/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.arquillian;

import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.page.Location;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Assert;
import org.junit.runner.RunWith;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.primefaces.extensions.arquillian.AbstractPrimePage;
import org.primefaces.extensions.arquillian.PrimeGraphene;

@RunWith(value=Arquillian.class)
@RunAsClient
public abstract class AbstractPrimePageTest {
    @Drone
    protected WebDriver webDriver;
    @ArquillianResource
    protected URL contextPath;

    protected void assertPresent(WebElement element) {
        if (!PrimeGraphene.isElementPresent(element)) {
            Assert.fail((String)"Element should be present!");
        }
    }

    protected void assertNotPresent(WebElement element) {
        if (PrimeGraphene.isElementPresent(element)) {
            Assert.fail((String)"Element should not be present!");
        }
    }

    protected void assertDisplayed(WebElement element) {
        if (!PrimeGraphene.isElementDisplayed(element)) {
            Assert.fail((String)"Element should be displayed!");
        }
    }

    protected void assertNotDisplayed(WebElement element) {
        if (PrimeGraphene.isElementDisplayed(element)) {
            Assert.fail((String)"Element should not be displayed!");
        }
    }

    protected void assertEnabled(WebElement element) {
        if (!PrimeGraphene.isElementEnabled(element)) {
            Assert.fail((String)"Element should be enabled!");
        }
    }

    protected void assertNotEnabled(WebElement element) {
        if (PrimeGraphene.isElementEnabled(element)) {
            Assert.fail((String)"Element should not be enabled!");
        }
    }

    protected void assertDisabled(WebElement element) {
        if (PrimeGraphene.isElementEnabled(element)) {
            Assert.fail((String)"Element should be disabled!");
        }
    }

    protected void assertNotDisabled(WebElement element) {
        if (!PrimeGraphene.isElementEnabled(element)) {
            Assert.fail((String)"Element should not be disabled!");
        }
    }

    protected void assertIsAt(AbstractPrimePage page) {
        this.assertIsAt(page.getLocation());
    }

    protected void assertIsAt(Class<?> pageClass) {
        Location location = pageClass.getAnnotation(Location.class);
        if (location == null) {
            Assert.fail((String)("Class doesn't have " + Location.class.getName() + " annotation"));
            return;
        }
        this.assertIsAt(location.value());
    }

    protected void assertIsAt(String relativePath) {
        String fullPath = this.contextPath.getPath() + relativePath;
        try {
            URL url = new URL(this.webDriver.getCurrentUrl());
            Assert.assertEquals((Object)fullPath, (Object)url.getPath());
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Malformed url: " + this.webDriver.getCurrentUrl(), e);
        }
    }
}

