/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.arquillian.component;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.arquillian.graphene.GrapheneElement;
import org.jboss.arquillian.graphene.findby.FindByJQuery;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.primefaces.extensions.arquillian.component.base.AbstractComponent;
import org.primefaces.extensions.arquillian.component.model.Msg;
import org.primefaces.extensions.arquillian.component.model.Severity;

public abstract class Messages
extends AbstractComponent {
    @FindByJQuery(value="> div")
    private List<GrapheneElement> messagesSeverties;

    public List<Msg> getAllMessages() {
        ArrayList<Msg> result = new ArrayList<Msg>();
        for (GrapheneElement messageSeverity : this.messagesSeverties) {
            Severity severity = Severity.toSeverity(messageSeverity.getAttribute("class"));
            for (GrapheneElement message : messageSeverity.findGrapheneElements(By.cssSelector((String)"li"))) {
                Msg msg = new Msg();
                msg.setSeverity(severity);
                msg.setSummary(message.findElement(By.className((String)("ui-messages-" + Severity.toName(severity) + "-summary"))).getText());
                try {
                    msg.setDetail(message.findElement(By.className((String)("ui-messages-" + Severity.toName(severity) + "-detail"))).getText());
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
                result.add(msg);
            }
        }
        return result;
    }

    public Msg getMessage(int index) {
        List<Msg> allMessages = this.getAllMessages();
        if (allMessages.size() > index) {
            return allMessages.get(index);
        }
        return null;
    }

    public List<Msg> getMessagesBySeverity(Severity severity) {
        return this.getAllMessages().stream().filter(message -> severity.equals((Object)message.getSeverity())).collect(Collectors.toList());
    }

    public List<String> getAllSummaries() {
        return this.getAllMessages().stream().map(Msg::getSummary).collect(Collectors.toList());
    }
}

