/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.arquillian.component;

import java.util.List;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.primefaces.extensions.arquillian.PrimeExpectedConditions;
import org.primefaces.extensions.arquillian.PrimeGraphene;
import org.primefaces.extensions.arquillian.component.base.AbstractInputComponent;
import org.primefaces.extensions.arquillian.extension.findby.FindByParentPartialId;

public abstract class SelectOneMenu
extends AbstractInputComponent {
    @FindByParentPartialId(value="_label")
    private WebElement label;
    @FindByParentPartialId(value="_items", searchFromRoot=true)
    private WebElement items;
    @FindByParentPartialId(value="_input")
    private WebElement input;
    @FindByParentPartialId(value="_panel", searchFromRoot=true)
    private WebElement panel;

    public void toggleDropdown() {
        if (this.panel.isDisplayed()) {
            this.label.click();
            PrimeGraphene.waitGui().until(PrimeExpectedConditions.invisibleAndAnimationComplete(this.panel));
        } else {
            this.label.click();
            PrimeGraphene.waitGui().until(PrimeExpectedConditions.visibileAndAnimationComplete(this.panel));
        }
    }

    public void deselect(String label) {
        if (!this.isSelected(label)) {
            return;
        }
        if (!this.panel.isDisplayed()) {
            this.toggleDropdown();
        }
        this.items.findElements(By.tagName((String)"li")).forEach(element -> {
            if (element.getText().equalsIgnoreCase(label)) {
                this.click((WebElement)element);
            }
        });
        if (this.panel.isDisplayed()) {
            this.toggleDropdown();
        }
    }

    public void select(String label) {
        if (this.isSelected(label)) {
            return;
        }
        if (!this.panel.isDisplayed()) {
            this.toggleDropdown();
        }
        this.items.findElements(By.tagName((String)"li")).forEach(element -> {
            if (element.getText().equalsIgnoreCase(label)) {
                this.click((WebElement)element);
            }
        });
        if (this.panel.isDisplayed()) {
            this.toggleDropdown();
        }
    }

    public String getSelectedLabel() {
        return this.label.getText();
    }

    public boolean isSelected(String label) {
        return this.getSelectedLabel().equalsIgnoreCase(label);
    }

    public List<String> getLabels() {
        return this.getInput().findElements(By.tagName((String)"option")).stream().map(WebElement::getText).collect(Collectors.toList());
    }

    public void select(int index) {
        this.select(this.getLabel(index));
    }

    public void deselect(int index) {
        this.deselect(this.getLabel(index));
    }

    public boolean isSelected(int index) {
        return this.getLabel(index).equals(this.getSelectedLabel());
    }

    public String getLabel(int index) {
        return this.getLabels().get(index);
    }

    @Override
    protected WebElement getInput() {
        return this.input;
    }

    protected void click(WebElement element) {
        if (PrimeGraphene.isAjaxScript(this.input.getAttribute("onchange"))) {
            PrimeGraphene.guardAjaxSilently(element).click();
        } else {
            element.click();
        }
    }
}

