
/*
 * Copyright (c) 2011-2021 PrimeFaces Extensions
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */

// ============================================================
// THIS FILE WAS GENERATED AUTOMATICALLY. DO NOT EDIT DIRECTLY.
// ============================================================

package org.primefaces.extensions.model.monacoeditor;

import org.primefaces.shaded.json.*;
import java.io.ObjectStreamException;
import java.io.Serializable;

@SuppressWarnings("serial")
/**
 * Configuration options for editor find widget
 */
public class EditorFindOptions extends JSONObject implements Serializable {
    private Object writeReplace() throws ObjectStreamException {
        return new SerializedEditorFindOptions(this);
    }

    private static class SerializedEditorFindOptions implements Serializable {
        private String json;

        public SerializedEditorFindOptions(EditorFindOptions editorFindOptions) {
            this.json = editorFindOptions.toString();
        }

        private Object readResolve() throws ObjectStreamException {
            final EditorFindOptions editorFindOptions = new EditorFindOptions();
            final JSONObject data = new JSONObject(json);
            for (final String key : data.keySet()) {
                final Object value = data.get(key);
                editorFindOptions.put(key, value);
            }
            return editorFindOptions;
        }
    }

    public Boolean isAddExtraSpaceOnTop() {
        return (Boolean) (has("addExtraSpaceOnTop") ? get("addExtraSpaceOnTop") : null);
    }

    public EditorFindOptions setAddExtraSpaceOnTop(final Boolean addExtraSpaceOnTop) {
        put("addExtraSpaceOnTop", addExtraSpaceOnTop);
        return this;
    }

    /**
     * @return Controls if Find in Selection flag is turned on in the editor.
     */
    public String getAutoFindInSelection() {
        return (String) (has("autoFindInSelection") ? get("autoFindInSelection") : null);
    }


    public EditorFindOptions setAutoFindInSelection(final EAutoFindInSelection autoFindInSelection) {
        put("autoFindInSelection", autoFindInSelection != null ? autoFindInSelection.toString() : null);
        return this;
    }

    public EditorFindOptions setAutoFindInSelection(final String autoFindInSelection) {
        put("autoFindInSelection", autoFindInSelection);
        return this;
    }

    /**
     * @return Controls whether the cursor should move to find matches while typing.
     */
    public Boolean isCursorMoveOnType() {
        return (Boolean) (has("cursorMoveOnType") ? get("cursorMoveOnType") : null);
    }


    public EditorFindOptions setCursorMoveOnType(final Boolean cursorMoveOnType) {
        put("cursorMoveOnType", cursorMoveOnType);
        return this;
    }

    /**
     * @return Controls whether the search automatically restarts from the beginning (or the end) when no further
     * matches can be found.
     */
    public Boolean isLoop() {
        return (Boolean) (has("loop") ? get("loop") : null);
    }


    public EditorFindOptions setLoop(final Boolean loop) {
        put("loop", loop);
        return this;
    }

    /**
     * @return Controls if we seed search string in the Find Widget with editor selection.
     */
    public String getSeedSearchStringFromSelection() {
        return (String) (has("seedSearchStringFromSelection") ? get("seedSearchStringFromSelection") : null);
    }


    public EditorFindOptions setSeedSearchStringFromSelection(final ESeedSearchStringFromSelection seedSearchStringFromSelection) {
        put("seedSearchStringFromSelection", seedSearchStringFromSelection != null ? seedSearchStringFromSelection.toString() : null);
        return this;
    }

    public EditorFindOptions setSeedSearchStringFromSelection(final String seedSearchStringFromSelection) {
        put("seedSearchStringFromSelection", seedSearchStringFromSelection);
        return this;
    }

    JSONObject getJSONObject() {
        return this;
    }
}