
/*
 * Copyright (c) 2011-2021 PrimeFaces Extensions
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */

// ============================================================
// THIS FILE WAS GENERATED AUTOMATICALLY. DO NOT EDIT DIRECTLY.
// ============================================================

package org.primefaces.extensions.model.monacoeditor;

import org.primefaces.shaded.json.*;
import java.io.ObjectStreamException;
import java.io.Serializable;

@SuppressWarnings("serial")
/**
 * Configuration options for editor hover
 */
public class EditorHoverOptions extends JSONObject implements Serializable {
    private Object writeReplace() throws ObjectStreamException {
        return new SerializedEditorHoverOptions(this);
    }

    private static class SerializedEditorHoverOptions implements Serializable {
        private String json;

        public SerializedEditorHoverOptions(EditorHoverOptions editorHoverOptions) {
            this.json = editorHoverOptions.toString();
        }

        private Object readResolve() throws ObjectStreamException {
            final EditorHoverOptions editorHoverOptions = new EditorHoverOptions();
            final JSONObject data = new JSONObject(json);
            for (final String key : data.keySet()) {
                final Object value = data.get(key);
                editorHoverOptions.put(key, value);
            }
            return editorHoverOptions;
        }
    }

    /**
     * @return Delay for showing the hover. Defaults to 300.
     */
    public Number getDelay() {
        return (Number) (has("delay") ? get("delay") : null);
    }


    public EditorHoverOptions setDelay(final Number delay) {
        put("delay", delay);
        return this;
    }

    /**
     * @return Enable the hover. Defaults to {@code true}.
     */
    public Boolean isEnabled() {
        return (Boolean) (has("enabled") ? get("enabled") : null);
    }


    public EditorHoverOptions setEnabled(final Boolean enabled) {
        put("enabled", enabled);
        return this;
    }

    /**
     * @return Is the hover sticky such that it can be clicked and its contents selected? Defaults to {@code true}.
     */
    public Boolean isSticky() {
        return (Boolean) (has("sticky") ? get("sticky") : null);
    }


    public EditorHoverOptions setSticky(final Boolean sticky) {
        put("sticky", sticky);
        return this;
    }

    JSONObject getJSONObject() {
        return this;
    }
}