
/*
 * Copyright (c) 2011-2021 PrimeFaces Extensions
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */

// ============================================================
// THIS FILE WAS GENERATED AUTOMATICALLY. DO NOT EDIT DIRECTLY.
// ============================================================

package org.primefaces.extensions.model.monacoeditor;

import org.primefaces.shaded.json.*;
import java.io.ObjectStreamException;
import java.io.Serializable;

@SuppressWarnings("serial")
/**
 * How to render vertical lines at the specified columns
 */
public class EditorRulerOption extends JSONObject implements Serializable {
    private Object writeReplace() throws ObjectStreamException {
        return new SerializedEditorRulerOption(this);
    }

    private static class SerializedEditorRulerOption implements Serializable {
        private String json;

        public SerializedEditorRulerOption(EditorRulerOption editorRulerOption) {
            this.json = editorRulerOption.toString();
        }

        private Object readResolve() throws ObjectStreamException {
            final EditorRulerOption editorRulerOption = new EditorRulerOption();
            final JSONObject data = new JSONObject(json);
            for (final String key : data.keySet()) {
                final Object value = data.get(key);
                editorRulerOption.put(key, value);
            }
            return editorRulerOption;
        }
    }

    /**
     * @return CSS color of the vertical ruler line.
     */
    public String getColor() {
        return (String) (has("color") ? get("color") : null);
    }


    public EditorRulerOption setColor(final String color) {
        put("color", color);
        return this;
    }

    /**
     * @return Position in characters from the left edge of the vertical ruler line.
     */
    public Number getColumn() {
        return (Number) (has("column") ? get("column") : null);
    }


    public EditorRulerOption setColumn(final Number column) {
        put("column", column);
        return this;
    }

    JSONObject getJSONObject() {
        return this;
    }
}