
/*
 * Copyright (c) 2011-2021 PrimeFaces Extensions
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */

// ============================================================
// THIS FILE WAS GENERATED AUTOMATICALLY. DO NOT EDIT DIRECTLY.
// ============================================================

package org.primefaces.extensions.model.monacoeditor;

import org.primefaces.shaded.json.*;
import java.io.ObjectStreamException;
import java.io.Serializable;

@SuppressWarnings("serial")
/**
 * Data that defines a custom theme for the Monaco code editor
 */
public class EditorStandaloneTheme extends JSONObject implements Serializable {
    private Object writeReplace() throws ObjectStreamException {
        return new SerializedEditorStandaloneTheme(this);
    }

    private static class SerializedEditorStandaloneTheme implements Serializable {
        private String json;

        public SerializedEditorStandaloneTheme(EditorStandaloneTheme editorStandaloneTheme) {
            this.json = editorStandaloneTheme.toString();
        }

        private Object readResolve() throws ObjectStreamException {
            final EditorStandaloneTheme editorStandaloneTheme = new EditorStandaloneTheme();
            final JSONObject data = new JSONObject(json);
            for (final String key : data.keySet()) {
                final Object value = data.get(key);
                editorStandaloneTheme.put(key, value);
            }
            return editorStandaloneTheme;
        }
    }

    /**
     * @return Base theme from which to extend when {@inherit} is set to {@code true}.
     */
    public String getBase() {
        return (String) (has("base") ? get("base") : null);
    }


    public EditorStandaloneTheme setBase(final ETheme base) {
        put("base", base != null ? base.toString() : null);
        return this;
    }

    public EditorStandaloneTheme setBase(final String base) {
        put("base", base);
        return this;
    }

    /**
     * @return Map between the color ID and the CSS color to use.
     */
    public JSONObject getColors() {
        return (JSONObject) (has("colors") ? get("colors") : null);
    }


    public EditorStandaloneTheme setColors(final JSONObject colors) {
        put("colors", colors);
        return this;
    }

    public EditorStandaloneTheme addColor(final String key, final String value) {
        JSONObject x = getColors();
        if (x == null) {
            x = new JSONObject();
            setColors(x);
        }
        x.put(key, value);
        return this;
    }

    public EditorStandaloneTheme setColors(java.util.Map<String, String> colors) {
        return setColors(new JSONObject(colors));
    }

    public JSONArray getEncodedTokensColors() {
        return (JSONArray) (has("encodedTokensColors") ? get("encodedTokensColors") : null);
    }

    public EditorStandaloneTheme setEncodedTokensColors(final JSONArray encodedTokensColors) {
        put("encodedTokensColors", encodedTokensColors);
        return this;
    }

    public EditorStandaloneTheme addEncodedTokensColor(final String ...items) {
        JSONArray x = getEncodedTokensColors();
        if (x == null) {
            x = new JSONArray();
            setEncodedTokensColors(x);
        }
        for (String item : items) x.put(item);
        return this;
    }

    public EditorStandaloneTheme setEncodedTokensColors(java.util.List<String> encodedTokensColors) {
        return setEncodedTokensColors(new JSONArray(encodedTokensColors));
    }

    /**
     * @return Whether this theme should inherit from the given base theme.
     */
    public Boolean isInherit() {
        return (Boolean) (has("inherit") ? get("inherit") : null);
    }


    public EditorStandaloneTheme setInherit(final Boolean inherit) {
        put("inherit", inherit);
        return this;
    }

    /**
     * @return Styling options for individual token types, such as how to style variables, certain keywords, and
     * parentheses.
     */
    public JSONArray getRules() {
        return (JSONArray) (has("rules") ? get("rules") : null);
    }


    public EditorStandaloneTheme setRules(final JSONArray rules) {
        put("rules", rules);
        return this;
    }

    public EditorStandaloneTheme addRule(final EditorTokenThemeRule ...items) {
        JSONArray x = getRules();
        if (x == null) {
            x = new JSONArray();
            setRules(x);
        }
        for (EditorTokenThemeRule item : items) x.put(item);
        return this;
    }

    public EditorStandaloneTheme setRules(java.util.List<EditorTokenThemeRule> rules) {
        return setRules(new JSONArray(rules));
    }

    JSONObject getJSONObject() {
        return this;
    }
}