
/*
 * Copyright (c) 2011-2022 PrimeFaces Extensions
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */

package org.primefaces.extensions.model.monacoeditor;

import org.primefaces.shaded.json.*;
import java.io.ObjectStreamException;
import java.io.Serializable;

// ============================================================
// THIS FILE WAS GENERATED AUTOMATICALLY. DO NOT EDIT DIRECTLY.
// ============================================================

/**
 * Configuration options for quick suggestions
 */
@SuppressWarnings("serial")
public class EditorQuickSuggestionsOptions extends JSONObject implements Serializable {
    private Object writeReplace() throws ObjectStreamException {
        return new SerializedEditorQuickSuggestionsOptions(this);
    }

    private static class SerializedEditorQuickSuggestionsOptions implements Serializable {
        private String json;

        public SerializedEditorQuickSuggestionsOptions(EditorQuickSuggestionsOptions editorQuickSuggestionsOptions) {
            this.json = editorQuickSuggestionsOptions.toString();
        }

        private Object readResolve() throws ObjectStreamException {
            final EditorQuickSuggestionsOptions editorQuickSuggestionsOptions = new EditorQuickSuggestionsOptions();
            final JSONObject data = new JSONObject(json);
            for (final String key : data.keySet()) {
                final Object value = data.get(key);
                editorQuickSuggestionsOptions.put(key, value);
            }
            return editorQuickSuggestionsOptions;
        }
    }

    /**
     * @return Whether to include comments in quick suggestions (shadow suggestions)
     */
    public Boolean isComments() {
        return (Boolean) (has("comments") ? get("comments") : null);
    }

    /**
     * @param comments Whether to include comments in quick suggestions (shadow suggestions)
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorQuickSuggestionsOptions setComments(final Boolean comments) {
        put("comments", comments);
        return this;
    }

    /**
     * @return Whether to include other types in quick suggestions (shadow suggestions)
     */
    public Boolean isOther() {
        return (Boolean) (has("other") ? get("other") : null);
    }

    /**
     * @param other Whether to include other types in quick suggestions (shadow suggestions)
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorQuickSuggestionsOptions setOther(final Boolean other) {
        put("other", other);
        return this;
    }

    /**
     * @return Whether to include strings in quick suggestions (shadow suggestions)
     */
    public Boolean isStrings() {
        return (Boolean) (has("strings") ? get("strings") : null);
    }

    /**
     * @param strings Whether to include strings in quick suggestions (shadow suggestions)
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorQuickSuggestionsOptions setStrings(final Boolean strings) {
        put("strings", strings);
        return this;
    }

    /**
     * @return This options object as a serializable JSON object
     */
    JSONObject getJSONObject() {
        return this;
    }
}