
/*
 * Copyright (c) 2011-2022 PrimeFaces Extensions
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */

package org.primefaces.extensions.model.monacoeditor;

import org.primefaces.shaded.json.*;
import java.io.ObjectStreamException;
import java.io.Serializable;

// ============================================================
// THIS FILE WAS GENERATED AUTOMATICALLY. DO NOT EDIT DIRECTLY.
// ============================================================

/**
 * Data that defines a custom theme for the Monaco code editor
 */
@SuppressWarnings("serial")
public class EditorStandaloneTheme extends JSONObject implements Serializable {
    private Object writeReplace() throws ObjectStreamException {
        return new SerializedEditorStandaloneTheme(this);
    }

    private static class SerializedEditorStandaloneTheme implements Serializable {
        private String json;

        public SerializedEditorStandaloneTheme(EditorStandaloneTheme editorStandaloneTheme) {
            this.json = editorStandaloneTheme.toString();
        }

        private Object readResolve() throws ObjectStreamException {
            final EditorStandaloneTheme editorStandaloneTheme = new EditorStandaloneTheme();
            final JSONObject data = new JSONObject(json);
            for (final String key : data.keySet()) {
                final Object value = data.get(key);
                editorStandaloneTheme.put(key, value);
            }
            return editorStandaloneTheme;
        }
    }

    /**
     * @return Base theme from which to extend when {@inherit} is set to {@code true}. This is required, when not set it
     * defaults to {@code vs}.
     */
    public String getBase() {
        return (String) (has("base") ? get("base") : null);
    }

    /**
     * @param base Base theme from which to extend when {@inherit} is set to {@code true}. This is required, when not
     * set it defaults to {@code vs}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorStandaloneTheme setBase(final ETheme base) {
        put("base", base != null ? base.toString() : null);
        return this;
    }

    /**
     * @param base Base theme from which to extend when {@inherit} is set to {@code true}. This is required, when not
     * set it defaults to {@code vs}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorStandaloneTheme setBase(final String base) {
        put("base", base);
        return this;
    }

    /**
     * @return Map between the color ID and the CSS color to use. This is required, when not set, it defaults to an
     * empty map.
     */
    public JSONObject getColors() {
        return (JSONObject) (has("colors") ? get("colors") : null);
    }

    /**
     * @param colors Map between the color ID and the CSS color to use. This is required, when not set, it defaults to
     * an empty map.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorStandaloneTheme setColors(final JSONObject colors) {
        put("colors", colors);
        return this;
    }

    /**
     * Map between the color ID and the CSS color to use. This is required, when not set, it defaults to an empty map.
     * @param key The key of the map entry to add.
     * @param value The value to associate with the key.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorStandaloneTheme addColor(final String key, final String value) {
        JSONObject x = getColors();
        if (x == null) {
            x = new JSONObject();
            setColors(x);
        }
        x.put(key, value);
        return this;
    }

    /**
     * @param colors Map between the color ID and the CSS color to use. This is required, when not set, it defaults to
     * an empty map.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorStandaloneTheme setColors(final java.util.Map<String, String> colors) {
        return setColors(new JSONObject(colors));
    }

    /**
     * @return Optional list of encoded token colors.
     */
    public JSONArray getEncodedTokensColors() {
        return (JSONArray) (has("encodedTokensColors") ? get("encodedTokensColors") : null);
    }

    /**
     * @param encodedTokensColors Optional list of encoded token colors.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorStandaloneTheme setEncodedTokensColors(final JSONArray encodedTokensColors) {
        put("encodedTokensColors", encodedTokensColors);
        return this;
    }

    /**
     * @return Optional list of encoded token colors.
     */
    public EditorStandaloneTheme addEncodedTokensColor(final String ...items) {
        JSONArray x = getEncodedTokensColors();
        if (x == null) {
            x = new JSONArray();
            setEncodedTokensColors(x);
        }
        for (String item : items) x.put(item);
        return this;
    }

    /**
     * @param encodedTokensColors Optional list of encoded token colors.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorStandaloneTheme setEncodedTokensColors(final java.util.List<String> encodedTokensColors) {
        return setEncodedTokensColors(new JSONArray(encodedTokensColors));
    }

    /**
     * @return Whether this theme should inherit from the given base theme. This is required, when not set it defaults
     * to {@code false}.
     */
    public Boolean isInherit() {
        return (Boolean) (has("inherit") ? get("inherit") : null);
    }

    /**
     * @param inherit Whether this theme should inherit from the given base theme. This is required, when not set it
     * defaults to {@code false}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorStandaloneTheme setInherit(final Boolean inherit) {
        put("inherit", inherit);
        return this;
    }

    /**
     * @return Styling options for individual token types, such as how to style variables, certain keywords, and
     * parentheses. This is required, when not set it defaults to an empty array.
     */
    public JSONArray getRules() {
        return (JSONArray) (has("rules") ? get("rules") : null);
    }

    /**
     * @param rules Styling options for individual token types, such as how to style variables, certain keywords, and
     * parentheses. This is required, when not set it defaults to an empty array.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorStandaloneTheme setRules(final JSONArray rules) {
        put("rules", rules);
        return this;
    }

    /**
     * @return Styling options for individual token types, such as how to style variables, certain keywords, and
     * parentheses. This is required, when not set it defaults to an empty array.
     */
    public EditorStandaloneTheme addRule(final EditorTokenThemeRule ...items) {
        JSONArray x = getRules();
        if (x == null) {
            x = new JSONArray();
            setRules(x);
        }
        for (EditorTokenThemeRule item : items) x.put(item);
        return this;
    }

    /**
     * @param rules Styling options for individual token types, such as how to style variables, certain keywords, and
     * parentheses. This is required, when not set it defaults to an empty array.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorStandaloneTheme setRules(final java.util.List<EditorTokenThemeRule> rules) {
        return setRules(new JSONArray(rules));
    }

    /**
     * @return This options object as a serializable JSON object
     */
    JSONObject getJSONObject() {
        return this;
    }
}