!function(){var e,t,i={97138:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-action-bar {\n\twhite-space: nowrap;\n\theight: 100%;\n}\n\n.monaco-action-bar .actions-container {\n\tdisplay: flex;\n\tmargin: 0 auto;\n\tpadding: 0;\n\theight: 100%;\n\twidth: 100%;\n\talign-items: center;\n}\n\n.monaco-action-bar.vertical .actions-container {\n\tdisplay: inline-block;\n}\n\n.monaco-action-bar .action-item {\n\tdisplay: block;\n\talign-items: center;\n\tjustify-content: center;\n\tcursor: pointer;\n\tposition: relative;  /* DO NOT REMOVE - this is the key to preventing the ghosting icon bug in Chrome 42 */\n}\n\n.monaco-action-bar .action-item.disabled {\n\tcursor: default;\n}\n\n.monaco-action-bar .action-item .icon,\n.monaco-action-bar .action-item .codicon {\n\tdisplay: block;\n}\n\n.monaco-action-bar .action-item .codicon {\n\tdisplay: flex;\n\talign-items: center;\n\twidth: 16px;\n\theight: 16px;\n}\n\n.monaco-action-bar .action-label {\n\tfont-size: 11px;\n\tpadding: 3px;\n\tborder-radius: 5px;\n}\n\n.monaco-action-bar .action-item.disabled .action-label,\n.monaco-action-bar .action-item.disabled .action-label::before,\n.monaco-action-bar .action-item.disabled .action-label:hover {\n\topacity: 0.6;\n}\n\n/* Vertical actions */\n\n.monaco-action-bar.vertical {\n\ttext-align: left;\n}\n\n.monaco-action-bar.vertical .action-item {\n\tdisplay: block;\n}\n\n.monaco-action-bar.vertical .action-label.separator {\n\tdisplay: block;\n\tborder-bottom: 1px solid #bbb;\n\tpadding-top: 1px;\n\tmargin-left: .8em;\n\tmargin-right: .8em;\n}\n\n.monaco-action-bar .action-item .action-label.separator {\n\twidth: 1px;\n\theight: 16px;\n\tmargin: 5px 4px !important;\n\tcursor: default;\n\tmin-width: 1px;\n\tpadding: 0;\n\tbackground-color: #bbb;\n}\n\n.secondary-actions .monaco-action-bar .action-label {\n\tmargin-left: 6px;\n}\n\n/* Action Items */\n.monaco-action-bar .action-item.select-container {\n\toverflow: hidden; /* somehow the dropdown overflows its container, we prevent it here to not push */\n\tflex: 1;\n\tmax-width: 170px;\n\tmin-width: 60px;\n\tdisplay: flex;\n\talign-items: center;\n\tjustify-content: center;\n\tmargin-right: 10px;\n}\n\n.monaco-action-bar .action-item.action-dropdown-item {\n\tdisplay: flex;\n}\n\n.monaco-action-bar .action-item.action-dropdown-item > .action-label {\n\tmargin-right: 1px;\n}\n",""]),t.Z=s},40371:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-aria-container {\n\tposition: absolute; /* try to hide from window but not from screen readers */\n\tleft:-999em;\n}",""]),t.Z=s},55796:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-text-button {\n\tbox-sizing: border-box;\n\tdisplay: flex;\n\twidth: 100%;\n\tpadding: 4px;\n\ttext-align: center;\n\tcursor: pointer;\n\tjustify-content: center;\n\talign-items: center;\n}\n\n.monaco-text-button:focus {\n\toutline-offset: 2px !important;\n}\n\n.monaco-text-button:hover {\n\ttext-decoration: none !important;\n}\n\n.monaco-button.disabled:focus,\n.monaco-button.disabled {\n\topacity: 0.4 !important;\n\tcursor: default;\n}\n\n.monaco-text-button > .codicon {\n\tmargin: 0 0.2em;\n\tcolor: inherit !important;\n}\n\n.monaco-button-dropdown {\n\tdisplay: flex;\n\tcursor: pointer;\n}\n\n.monaco-button-dropdown.disabled {\n\tcursor: default;\n}\n\n.monaco-button-dropdown > .monaco-button:focus {\n\toutline-offset: -1px !important;\n}\n\n.monaco-button-dropdown.disabled > .monaco-button.disabled,\n.monaco-button-dropdown.disabled > .monaco-button.disabled:focus,\n.monaco-button-dropdown.disabled > .monaco-button-dropdown-separator {\n\topacity: 0.4 !important;\n}\n\n.monaco-button-dropdown > .monaco-button.monaco-text-button {\n\tborder-right-width: 0 !important;\n}\n\n.monaco-button-dropdown .monaco-button-dropdown-separator {\n\tpadding: 4px 0;\n\tcursor: default;\n}\n\n.monaco-button-dropdown .monaco-button-dropdown-separator > div {\n\theight: 100%;\n\twidth: 1px;\n}\n\n.monaco-button-dropdown > .monaco-button.monaco-dropdown-button {\n\tborder-left-width: 0 !important;\n}\n\n.monaco-description-button {\n\tflex-direction: column;\n}\n\n.monaco-description-button .monaco-button-label {\n\tfont-weight: 500;\n}\n\n.monaco-description-button .monaco-button-description {\n\tfont-style: italic;\n}\n\n.monaco-description-button .monaco-button-label,\n.monaco-description-button .monaco-button-description\n{\n\tdisplay: flex;\n\tjustify-content: center;\n\talign-items: center;\n}\n\n.monaco-description-button .monaco-button-label > .codicon,\n.monaco-description-button .monaco-button-description > .codicon\n{\n\tmargin: 0 0.2em;\n\tcolor: inherit !important;\n}\n",""]),t.Z=s},99827:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.codicon-wrench-subaction {\n\topacity: 0.5;\n}\n\n@keyframes codicon-spin {\n\t100% {\n\t\ttransform:rotate(360deg);\n\t}\n}\n\n.codicon-sync.codicon-modifier-spin,\n.codicon-loading.codicon-modifier-spin,\n.codicon-gear.codicon-modifier-spin,\n.codicon-notebook-state-executing.codicon-modifier-spin {\n\t/* Use steps to throttle FPS to reduce CPU usage */\n\tanimation: codicon-spin 1.5s steps(30) infinite;\n}\n\n.codicon-modifier-disabled {\n\topacity: 0.4;\n}\n\n/* custom speed & easing for loading icon */\n.codicon-loading,\n.codicon-tree-item-loading::before {\n\tanimation-duration: 1s !important;\n\tanimation-timing-function: cubic-bezier(0.53, 0.21, 0.29, 0.67) !important;\n}\n",""]),t.Z=s},23222:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r),a=i(61667),l=i.n(a),c=new URL(i(48576),i.b),d=s()(o()),u=l()(c);d.push([e.id,'/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n@font-face {\n\tfont-family: "codicon";\n\tfont-display: block;\n\tsrc: url('+u+") format(\"truetype\");\n}\n\n.codicon[class*='codicon-'] {\n\tfont: normal normal normal 16px/1 codicon;\n\tdisplay: inline-block;\n\ttext-decoration: none;\n\ttext-rendering: auto;\n\ttext-align: center;\n\ttext-transform: none;\n\t-webkit-font-smoothing: antialiased;\n\t-moz-osx-font-smoothing: grayscale;\n\tuser-select: none;\n\t-webkit-user-select: none;\n\t-ms-user-select: none;\n}\n\n/* icon rules are dynamically created by the platform theme service (see iconsStyleSheet.ts) */\n",""]),t.Z=d},72555:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.context-view {\n\tposition: absolute;\n}\n\n.context-view.fixed {\n\tall: initial;\n\tfont-family: inherit;\n\tfont-size: 13px;\n\tposition: fixed;\n\tcolor: inherit;\n}\n",""]),t.Z=s},73688:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-count-badge {\n\tpadding: 3px 6px;\n\tborder-radius: 11px;\n\tfont-size: 11px;\n\tmin-width: 18px;\n\tmin-height: 18px;\n\tline-height: 11px;\n\tfont-weight: normal;\n\ttext-align: center;\n\tdisplay: inline-block;\n\tbox-sizing: border-box;\n}\n\n.monaco-count-badge.long {\n\tpadding: 2px 3px;\n\tborder-radius: 2px;\n\tmin-height: auto;\n\tline-height: normal;\n}\n",""]),t.Z=s},45340:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-dropdown {\n\theight: 100%;\n\tpadding: 0;\n}\n\n.monaco-dropdown > .dropdown-label {\n\tcursor: pointer;\n\theight: 100%;\n\tdisplay: flex;\n\talign-items: center;\n\tjustify-content: center;\n}\n\n.monaco-dropdown > .dropdown-label > .action-label.disabled {\n\tcursor: default;\n}\n\n.monaco-dropdown-with-primary {\n\tdisplay: flex !important;\n\tflex-direction: row;\n\tborder-radius: 5px;\n}\n\n.monaco-dropdown-with-primary > .action-container > .action-label {\n\tmargin-right: 0;\n}\n\n.monaco-dropdown-with-primary > .dropdown-action-container > .monaco-dropdown > .dropdown-label .codicon[class*='codicon-'] {\n\tfont-size: 12px;\n\tpadding-left: 0px;\n\tpadding-right: 0px;\n\tline-height: 16px;\n\tmargin-left: -3px;\n}\n\n.monaco-dropdown-with-primary > .dropdown-action-container > .monaco-dropdown > .dropdown-label > .action-label {\n\tdisplay: block;\n\tbackground-size: 16px;\n\tbackground-position: center center;\n\tbackground-repeat: no-repeat;\n}\n",""]),t.Z=s},27504:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n/* ---------- Find input ---------- */\n\n.monaco-findInput {\n\tposition: relative;\n}\n\n.monaco-findInput .monaco-inputbox {\n\tfont-size: 13px;\n\twidth: 100%;\n}\n\n.monaco-findInput > .controls {\n\tposition: absolute;\n\ttop: 3px;\n\tright: 2px;\n}\n\n.vs .monaco-findInput.disabled {\n\tbackground-color: #E1E1E1;\n}\n\n/* Theming */\n.vs-dark .monaco-findInput.disabled {\n\tbackground-color: #333;\n}\n\n/* Highlighting */\n.monaco-findInput.highlight-0 .controls,\n.hc-light .monaco-findInput.highlight-0 .controls {\n\tanimation: monaco-findInput-highlight-0 100ms linear 0s;\n}\n\n.monaco-findInput.highlight-1 .controls,\n.hc-light .monaco-findInput.highlight-1 .controls {\n\tanimation: monaco-findInput-highlight-1 100ms linear 0s;\n}\n\n.hc-black .monaco-findInput.highlight-0 .controls,\n.vs-dark  .monaco-findInput.highlight-0 .controls {\n\tanimation: monaco-findInput-highlight-dark-0 100ms linear 0s;\n}\n\n.hc-black .monaco-findInput.highlight-1 .controls,\n.vs-dark  .monaco-findInput.highlight-1 .controls {\n\tanimation: monaco-findInput-highlight-dark-1 100ms linear 0s;\n}\n\n@keyframes monaco-findInput-highlight-0 {\n\t0% { background: rgba(253, 255, 0, 0.8); }\n\t100% { background: transparent; }\n}\n@keyframes monaco-findInput-highlight-1 {\n\t0% { background: rgba(253, 255, 0, 0.8); }\n\t/* Made intentionally different such that the CSS minifier does not collapse the two animations into a single one*/\n\t99% { background: transparent; }\n}\n\n@keyframes monaco-findInput-highlight-dark-0 {\n\t0% { background: rgba(255, 255, 255, 0.44); }\n\t100% { background: transparent; }\n}\n@keyframes monaco-findInput-highlight-dark-1 {\n\t0% { background: rgba(255, 255, 255, 0.44); }\n\t/* Made intentionally different such that the CSS minifier does not collapse the two animations into a single one*/\n\t99% { background: transparent; }\n}\n",""]),t.Z=s},57780:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-hover {\n\tcursor: default;\n\tposition: absolute;\n\toverflow: hidden;\n\tz-index: 50;\n\tuser-select: text;\n\t-webkit-user-select: text;\n\t-ms-user-select: text;\n\tbox-sizing: initial;\n\tanimation: fadein 100ms linear;\n\tline-height: 1.5em;\n}\n\n.monaco-hover.hidden {\n\tdisplay: none;\n}\n\n.monaco-hover a:hover {\n\tcursor: pointer;\n}\n\n.monaco-hover .hover-contents:not(.html-hover-contents) {\n\tpadding: 4px 8px;\n}\n\n.monaco-hover .markdown-hover > .hover-contents:not(.code-hover-contents) {\n\tmax-width: 500px;\n\tword-wrap: break-word;\n}\n\n.monaco-hover .markdown-hover > .hover-contents:not(.code-hover-contents) hr {\n\tmin-width: 100%;\n}\n\n.monaco-hover p,\n.monaco-hover .code,\n.monaco-hover ul {\n\tmargin: 8px 0;\n}\n\n.monaco-hover code {\n\tfont-family: var(--monaco-monospace-font);\n}\n\n.monaco-hover hr {\n\tbox-sizing: border-box;\n\tborder-left: 0px;\n\tborder-right: 0px;\n\tmargin-top: 4px;\n\tmargin-bottom: -4px;\n\tmargin-left: -8px;\n\tmargin-right: -8px;\n\theight: 1px;\n}\n\n.monaco-hover p:first-child,\n.monaco-hover .code:first-child,\n.monaco-hover ul:first-child {\n\tmargin-top: 0;\n}\n\n.monaco-hover p:last-child,\n.monaco-hover .code:last-child,\n.monaco-hover ul:last-child {\n\tmargin-bottom: 0;\n}\n\n/* MarkupContent Layout */\n.monaco-hover ul {\n\tpadding-left: 20px;\n}\n.monaco-hover ol {\n\tpadding-left: 20px;\n}\n\n.monaco-hover li > p {\n\tmargin-bottom: 0;\n}\n\n.monaco-hover li > ul {\n\tmargin-top: 0;\n}\n\n.monaco-hover code {\n\tborder-radius: 3px;\n\tpadding: 0 0.4em;\n}\n\n.monaco-hover .monaco-tokenized-source {\n\twhite-space: pre-wrap;\n}\n\n.monaco-hover .hover-row.status-bar {\n\tfont-size: 12px;\n\tline-height: 22px;\n}\n\n.monaco-hover .hover-row.status-bar .actions {\n\tdisplay: flex;\n\tpadding: 0px 8px;\n}\n\n.monaco-hover .hover-row.status-bar .actions .action-container {\n\tmargin-right: 16px;\n\tcursor: pointer;\n}\n\n.monaco-hover .hover-row.status-bar .actions .action-container .action .icon {\n\tpadding-right: 4px;\n}\n\n.monaco-hover .markdown-hover .hover-contents .codicon {\n\tcolor: inherit;\n\tfont-size: inherit;\n\tvertical-align: middle;\n}\n\n.monaco-hover .hover-contents a.code-link:hover,\n.monaco-hover .hover-contents a.code-link {\n\tcolor: inherit;\n}\n\n.monaco-hover .hover-contents a.code-link:before {\n\tcontent: '(';\n}\n\n.monaco-hover .hover-contents a.code-link:after {\n\tcontent: ')';\n}\n\n.monaco-hover .hover-contents a.code-link > span {\n\ttext-decoration: underline;\n\t/** Hack to force underline to show **/\n\tborder-bottom: 1px solid transparent;\n\ttext-underline-position: under;\n}\n\n/** Spans in markdown hovers need a margin-bottom to avoid looking cramped: https://github.com/microsoft/vscode/issues/101496 **/\n.monaco-hover .markdown-hover .hover-contents:not(.code-hover-contents):not(.html-hover-contents) span {\n\tmargin-bottom: 4px;\n\tdisplay: inline-block;\n}\n\n.monaco-hover-content .action-container a {\n\t-webkit-user-select: none;\n\tuser-select: none;\n}\n\n.monaco-hover-content .action-container.disabled {\n\tpointer-events: none;\n\topacity: 0.4;\n\tcursor: default;\n}\n",""]),t.Z=s},3293:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n/* ---------- Icon label ---------- */\n\n.monaco-icon-label {\n\tdisplay: flex; /* required for icons support :before rule */\n\toverflow: hidden;\n\ttext-overflow: ellipsis;\n}\n\n.monaco-icon-label::before {\n\n\t/* svg icons rendered as background image */\n\tbackground-size: 16px;\n\tbackground-position: left center;\n\tbackground-repeat: no-repeat;\n\tpadding-right: 6px;\n\twidth: 16px;\n\theight: 22px;\n\tline-height: inherit !important;\n\tdisplay: inline-block;\n\n\t/* fonts icons */\n\t-webkit-font-smoothing: antialiased;\n\t-moz-osx-font-smoothing: grayscale;\n\tvertical-align: top;\n\n\tflex-shrink: 0; /* fix for https://github.com/microsoft/vscode/issues/13787 */\n}\n\n.monaco-icon-label > .monaco-icon-label-container {\n\tmin-width: 0;\n\toverflow: hidden;\n\ttext-overflow: ellipsis;\n\tflex: 1;\n}\n\n.monaco-icon-label > .monaco-icon-label-container > .monaco-icon-name-container > .label-name {\n\tcolor: inherit;\n\twhite-space: pre; /* enable to show labels that include multiple whitespaces */\n}\n\n.monaco-icon-label > .monaco-icon-label-container > .monaco-icon-name-container > .label-name > .label-separator {\n\tmargin: 0 2px;\n\topacity: 0.5;\n}\n\n.monaco-icon-label > .monaco-icon-label-container > .monaco-icon-description-container > .label-description {\n\topacity: .7;\n\tmargin-left: 0.5em;\n\tfont-size: 0.9em;\n\twhite-space: pre; /* enable to show labels that include multiple whitespaces */\n}\n\n.monaco-icon-label.nowrap > .monaco-icon-label-container > .monaco-icon-description-container > .label-description{\n\twhite-space: nowrap\n}\n\n.vs .monaco-icon-label > .monaco-icon-label-container > .monaco-icon-description-container > .label-description {\n\topacity: .95;\n}\n\n.monaco-icon-label.italic > .monaco-icon-label-container > .monaco-icon-name-container > .label-name,\n.monaco-icon-label.italic > .monaco-icon-label-container > .monaco-icon-description-container > .label-description {\n\tfont-style: italic;\n}\n\n.monaco-icon-label.deprecated {\n\ttext-decoration: line-through;\n\topacity: 0.66;\n}\n\n/* make sure apply italic font style to decorations as well */\n.monaco-icon-label.italic::after {\n\tfont-style: italic;\n}\n\n.monaco-icon-label.strikethrough > .monaco-icon-label-container > .monaco-icon-name-container > .label-name,\n.monaco-icon-label.strikethrough > .monaco-icon-label-container > .monaco-icon-description-container > .label-description {\n\ttext-decoration: line-through;\n}\n\n.monaco-icon-label::after {\n\topacity: 0.75;\n\tfont-size: 90%;\n\tfont-weight: 600;\n\tmargin: auto 16px 0 5px; /* https://github.com/microsoft/vscode/issues/113223 */\n\ttext-align: center;\n}\n\n/* make sure selection color wins when a label is being selected */\n.monaco-list:focus .selected .monaco-icon-label, /* list */\n.monaco-list:focus .selected .monaco-icon-label::after\n{\n\tcolor: inherit !important;\n}\n\n.monaco-list-row.focused.selected .label-description,\n.monaco-list-row.selected .label-description {\n\topacity: .8;\n}\n",""]),t.Z=s},24695:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-inputbox {\n\tposition: relative;\n\tdisplay: block;\n\tpadding: 0;\n\tbox-sizing:\tborder-box;\n\n\t/* Customizable */\n\tfont-size: inherit;\n}\n\n.monaco-inputbox.idle {\n\tborder: 1px solid transparent;\n}\n\n.monaco-inputbox > .ibwrapper > .input,\n.monaco-inputbox > .ibwrapper > .mirror {\n\n\t/* Customizable */\n\tpadding: 4px;\n}\n\n.monaco-inputbox > .ibwrapper {\n\tposition: relative;\n\twidth: 100%;\n\theight: 100%;\n}\n\n.monaco-inputbox > .ibwrapper > .input {\n\tdisplay: inline-block;\n\tbox-sizing:\tborder-box;\n\twidth: 100%;\n\theight: 100%;\n\tline-height: inherit;\n\tborder: none;\n\tfont-family: inherit;\n\tfont-size: inherit;\n\tresize: none;\n\tcolor: inherit;\n}\n\n.monaco-inputbox > .ibwrapper > input {\n\ttext-overflow: ellipsis;\n}\n\n.monaco-inputbox > .ibwrapper > textarea.input {\n\tdisplay: block;\n\t-ms-overflow-style: none; /* IE 10+: hide scrollbars */\n\tscrollbar-width: none; /* Firefox: hide scrollbars */\n\toutline: none;\n}\n\n.monaco-inputbox > .ibwrapper > textarea.input::-webkit-scrollbar {\n\tdisplay: none; /* Chrome + Safari: hide scrollbar */\n}\n\n.monaco-inputbox > .ibwrapper > textarea.input.empty {\n\twhite-space: nowrap;\n}\n\n.monaco-inputbox > .ibwrapper > .mirror {\n\tposition: absolute;\n\tdisplay: inline-block;\n\twidth: 100%;\n\ttop: 0;\n\tleft: 0;\n\tbox-sizing: border-box;\n\twhite-space: pre-wrap;\n\tvisibility: hidden;\n\tword-wrap: break-word;\n}\n\n/* Context view */\n\n.monaco-inputbox-container {\n\ttext-align: right;\n}\n\n.monaco-inputbox-container .monaco-inputbox-message {\n\tdisplay: inline-block;\n\toverflow: hidden;\n\ttext-align: left;\n\twidth: 100%;\n\tbox-sizing:\tborder-box;\n\tpadding: 0.4em;\n\tfont-size: 12px;\n\tline-height: 17px;\n\tmargin-top: -1px;\n\tword-wrap: break-word;\n}\n\n/* Action bar support */\n.monaco-inputbox .monaco-action-bar {\n\tposition: absolute;\n\tright: 2px;\n\ttop: 4px;\n}\n\n.monaco-inputbox .monaco-action-bar .action-item {\n\tmargin-left: 2px;\n}\n\n.monaco-inputbox .monaco-action-bar .action-item .codicon {\n\tbackground-repeat: no-repeat;\n\twidth: 16px;\n\theight: 16px;\n}\n",""]),t.Z=s},7896:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-keybinding {\n\tdisplay: flex;\n\talign-items: center;\n\tline-height: 10px;\n}\n\n.monaco-keybinding > .monaco-keybinding-key {\n\tdisplay: inline-block;\n\tborder-style: solid;\n\tborder-width: 1px;\n\tborder-radius: 3px;\n\tvertical-align: middle;\n\tfont-size: 11px;\n\tpadding: 3px 5px;\n\tmargin: 0 2px;\n}\n\n.monaco-keybinding > .monaco-keybinding-key:first-child {\n\tmargin-left: 0;\n}\n\n.monaco-keybinding > .monaco-keybinding-key:last-child {\n\tmargin-right: 0;\n}\n\n.monaco-keybinding > .monaco-keybinding-key-separator {\n\tdisplay: inline-block;\n}\n\n.monaco-keybinding > .monaco-keybinding-key-chord-separator {\n\twidth: 6px;\n}\n",""]),t.Z=s},85220:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-list {\n\tposition: relative;\n\theight: 100%;\n\twidth: 100%;\n\twhite-space: nowrap;\n}\n\n.monaco-list.mouse-support {\n\tuser-select: none;\n\t-webkit-user-select: none;\n\t-ms-user-select: none;\n}\n\n.monaco-list > .monaco-scrollable-element {\n\theight: 100%;\n}\n\n.monaco-list-rows {\n\tposition: relative;\n\twidth: 100%;\n\theight: 100%;\n}\n\n.monaco-list.horizontal-scrolling .monaco-list-rows {\n\twidth: auto;\n\tmin-width: 100%;\n}\n\n.monaco-list-row {\n\tposition: absolute;\n\tbox-sizing: border-box;\n\toverflow: hidden;\n\twidth: 100%;\n}\n\n.monaco-list.mouse-support .monaco-list-row {\n\tcursor: pointer;\n\ttouch-action: none;\n}\n\n/* for OS X ballistic scrolling */\n.monaco-list-row.scrolling {\n\tdisplay: none !important;\n}\n\n/* Focus */\n.monaco-list.element-focused,\n.monaco-list.selection-single,\n.monaco-list.selection-multiple {\n\toutline: 0 !important;\n}\n\n/* Dnd */\n.monaco-drag-image {\n\tdisplay: inline-block;\n\tpadding: 1px 7px;\n\tborder-radius: 10px;\n\tfont-size: 12px;\n\tposition: absolute;\n\tz-index: 1000;\n}\n\n/* Filter */\n\n.monaco-list-type-filter-message {\n\tposition: absolute;\n\tbox-sizing: border-box;\n\twidth: 100%;\n\theight: 100%;\n\ttop: 0;\n\tleft: 0;\n\tpadding: 40px 1em 1em 1em;\n\ttext-align: center;\n\twhite-space: normal;\n\topacity: 0.7;\n\tpointer-events: none;\n}\n\n.monaco-list-type-filter-message:empty {\n\tdisplay: none;\n}\n",""]),t.Z=s},58322:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-mouse-cursor-text {\n\tcursor: text;\n}\n",""]),t.Z=s},41227:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-progress-container {\n\twidth: 100%;\n\theight: 5px;\n\toverflow: hidden; /* keep progress bit in bounds */\n}\n\n.monaco-progress-container .progress-bit {\n\twidth: 2%;\n\theight: 5px;\n\tposition: absolute;\n\tleft: 0;\n\tdisplay: none;\n}\n\n.monaco-progress-container.active .progress-bit {\n\tdisplay: inherit;\n}\n\n.monaco-progress-container.discrete .progress-bit {\n\tleft: 0;\n\ttransition: width 100ms linear;\n}\n\n.monaco-progress-container.discrete.done .progress-bit {\n\twidth: 100%;\n}\n\n.monaco-progress-container.infinite .progress-bit {\n\tanimation-name: progress;\n\tanimation-duration: 4s;\n\tanimation-iteration-count: infinite;\n\ttransform: translate3d(0px, 0px, 0px);\n\tanimation-timing-function: linear;\n}\n\n.monaco-progress-container.infinite.infinite-long-running .progress-bit {\n\t/*\n\t\tThe more smooth `linear` timing function can cause\n\t\thigher GPU consumption as indicated in\n\t\thttps://github.com/microsoft/vscode/issues/97900 &\n\t\thttps://github.com/microsoft/vscode/issues/138396\n\t*/\n\tanimation-timing-function: steps(100);\n}\n\n/**\n * The progress bit has a width: 2% (1/50) of the parent container. The animation moves it from 0% to 100% of\n * that container. Since translateX is relative to the progress bit size, we have to multiple it with\n * its relative size to the parent container:\n * parent width: 5000%\n *    bit width: 100%\n * translateX should be as follow:\n *  50%: 5000% * 50% - 50% (set to center) = 2450%\n * 100%: 5000% * 100% - 100% (do not overflow) = 4900%\n */\n@keyframes progress { from { transform: translateX(0%) scaleX(1) } 50% { transform: translateX(2500%) scaleX(3) } to { transform: translateX(4900%) scaleX(1) } }\n",""]),t.Z=s},67054:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n:root {\n\t--sash-size: 4px;\n}\n\n.monaco-sash {\n\tposition: absolute;\n\tz-index: 35;\n\ttouch-action: none;\n}\n\n.monaco-sash.disabled {\n\tpointer-events: none;\n}\n\n.monaco-sash.mac.vertical {\n\tcursor: col-resize;\n}\n\n.monaco-sash.vertical.minimum {\n\tcursor: e-resize;\n}\n\n.monaco-sash.vertical.maximum {\n\tcursor: w-resize;\n}\n\n.monaco-sash.mac.horizontal {\n\tcursor: row-resize;\n}\n\n.monaco-sash.horizontal.minimum {\n\tcursor: s-resize;\n}\n\n.monaco-sash.horizontal.maximum {\n\tcursor: n-resize;\n}\n\n.monaco-sash.disabled {\n\tcursor: default !important;\n\tpointer-events: none !important;\n}\n\n.monaco-sash.vertical {\n\tcursor: ew-resize;\n\ttop: 0;\n\twidth: var(--sash-size);\n\theight: 100%;\n}\n\n.monaco-sash.horizontal {\n\tcursor: ns-resize;\n\tleft: 0;\n\twidth: 100%;\n\theight: var(--sash-size);\n}\n\n.monaco-sash:not(.disabled) > .orthogonal-drag-handle {\n\tcontent: \" \";\n\theight: calc(var(--sash-size) * 2);\n\twidth: calc(var(--sash-size) * 2);\n\tz-index: 100;\n\tdisplay: block;\n\tcursor: all-scroll;\n\tposition: absolute;\n}\n\n.monaco-sash.horizontal.orthogonal-edge-north:not(.disabled)\n\t> .orthogonal-drag-handle.start,\n.monaco-sash.horizontal.orthogonal-edge-south:not(.disabled)\n\t> .orthogonal-drag-handle.end {\n\tcursor: nwse-resize;\n}\n\n.monaco-sash.horizontal.orthogonal-edge-north:not(.disabled)\n\t> .orthogonal-drag-handle.end,\n.monaco-sash.horizontal.orthogonal-edge-south:not(.disabled)\n\t> .orthogonal-drag-handle.start {\n\tcursor: nesw-resize;\n}\n\n.monaco-sash.vertical > .orthogonal-drag-handle.start {\n\tleft: calc(var(--sash-size) * -0.5);\n\ttop: calc(var(--sash-size) * -1);\n}\n.monaco-sash.vertical > .orthogonal-drag-handle.end {\n\tleft: calc(var(--sash-size) * -0.5);\n\tbottom: calc(var(--sash-size) * -1);\n}\n.monaco-sash.horizontal > .orthogonal-drag-handle.start {\n\ttop: calc(var(--sash-size) * -0.5);\n\tleft: calc(var(--sash-size) * -1);\n}\n.monaco-sash.horizontal > .orthogonal-drag-handle.end {\n\ttop: calc(var(--sash-size) * -0.5);\n\tright: calc(var(--sash-size) * -1);\n}\n\n.monaco-sash:before {\n\tcontent: '';\n\tpointer-events: none;\n\tposition: absolute;\n\twidth: 100%;\n\theight: 100%;\n\ttransition: background-color 0.1s ease-out;\n\tbackground: transparent;\n}\n\n.monaco-sash.vertical:before {\n\twidth: var(--sash-hover-size);\n\tleft: calc(50% - (var(--sash-hover-size) / 2));\n}\n\n.monaco-sash.horizontal:before {\n\theight: var(--sash-hover-size);\n\ttop: calc(50% - (var(--sash-hover-size) / 2));\n}\n\n.pointer-events-disabled {\n\tpointer-events: none !important;\n}\n\n/** Debug **/\n\n.monaco-sash.debug {\n\tbackground: cyan;\n}\n\n.monaco-sash.debug.disabled {\n\tbackground: rgba(0, 255, 255, 0.2);\n}\n\n.monaco-sash.debug:not(.disabled) > .orthogonal-drag-handle {\n\tbackground: red;\n}\n",""]),t.Z=s},64836:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n/* Arrows */\n.monaco-scrollable-element > .scrollbar > .scra {\n\tcursor: pointer;\n\tfont-size: 11px !important;\n}\n\n.monaco-scrollable-element > .visible {\n\topacity: 1;\n\n\t/* Background rule added for IE9 - to allow clicks on dom node */\n\tbackground:rgba(0,0,0,0);\n\n\ttransition: opacity 100ms linear;\n}\n.monaco-scrollable-element > .invisible {\n\topacity: 0;\n\tpointer-events: none;\n}\n.monaco-scrollable-element > .invisible.fade {\n\ttransition: opacity 800ms linear;\n}\n\n/* Scrollable Content Inset Shadow */\n.monaco-scrollable-element > .shadow {\n\tposition: absolute;\n\tdisplay: none;\n}\n.monaco-scrollable-element > .shadow.top {\n\tdisplay: block;\n\ttop: 0;\n\tleft: 3px;\n\theight: 3px;\n\twidth: 100%;\n}\n.monaco-scrollable-element > .shadow.left {\n\tdisplay: block;\n\ttop: 3px;\n\tleft: 0;\n\theight: 100%;\n\twidth: 3px;\n}\n.monaco-scrollable-element > .shadow.top-left-corner {\n\tdisplay: block;\n\ttop: 0;\n\tleft: 0;\n\theight: 3px;\n\twidth: 3px;\n}\n",""]),t.Z=s},35201:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-split-view2 {\n\tposition: relative;\n\twidth: 100%;\n\theight: 100%;\n}\n\n.monaco-split-view2 > .sash-container {\n\tposition: absolute;\n\twidth: 100%;\n\theight: 100%;\n\tpointer-events: none;\n}\n\n.monaco-split-view2 > .sash-container > .monaco-sash {\n\tpointer-events: initial;\n}\n\n.monaco-split-view2 > .monaco-scrollable-element {\n\twidth: 100%;\n\theight: 100%;\n}\n\n.monaco-split-view2 > .monaco-scrollable-element > .split-view-container {\n\twidth: 100%;\n\theight: 100%;\n\twhite-space: nowrap;\n\tposition: relative;\n}\n\n.monaco-split-view2 > .monaco-scrollable-element > .split-view-container > .split-view-view {\n\twhite-space: initial;\n\tposition: absolute;\n}\n\n.monaco-split-view2 > .monaco-scrollable-element > .split-view-container > .split-view-view:not(.visible) {\n\tdisplay: none;\n}\n\n.monaco-split-view2.vertical > .monaco-scrollable-element > .split-view-container > .split-view-view {\n\twidth: 100%;\n}\n\n.monaco-split-view2.horizontal > .monaco-scrollable-element > .split-view-container > .split-view-view {\n\theight: 100%;\n}\n\n.monaco-split-view2.separator-border > .monaco-scrollable-element > .split-view-container > .split-view-view:not(:first-child)::before {\n\tcontent: ' ';\n\tposition: absolute;\n\ttop: 0;\n\tleft: 0;\n\tz-index: 5;\n\tpointer-events: none;\n\tbackground-color: var(--separator-border);\n}\n\n.monaco-split-view2.separator-border.horizontal > .monaco-scrollable-element > .split-view-container > .split-view-view:not(:first-child)::before {\n\theight: 100%;\n\twidth: 1px;\n}\n\n.monaco-split-view2.separator-border.vertical > .monaco-scrollable-element > .split-view-container > .split-view-view:not(:first-child)::before {\n\theight: 1px;\n\twidth: 100%;\n}\n",""]),t.Z=s},78590:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,'/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-table {\n\tdisplay: flex;\n\tflex-direction: column;\n\tposition: relative;\n\theight: 100%;\n\twidth: 100%;\n\twhite-space: nowrap;\n}\n\n.monaco-table > .monaco-split-view2 {\n\tborder-bottom: 1px solid transparent;\n}\n\n.monaco-table > .monaco-list {\n\tflex: 1;\n}\n\n.monaco-table-tr {\n\tdisplay: flex;\n\theight: 100%;\n}\n\n.monaco-table-th {\n\twidth: 100%;\n\theight: 100%;\n\tfont-weight: bold;\n\toverflow: hidden;\n\ttext-overflow: ellipsis;\n}\n\n.monaco-table-th,\n.monaco-table-td {\n\tbox-sizing: border-box;\n\tflex-shrink: 0;\n\toverflow: hidden;\n\twhite-space: nowrap;\n\ttext-overflow: ellipsis;\n}\n\n.monaco-table > .monaco-split-view2 .monaco-sash.vertical::before {\n\tcontent: "";\n\tposition: absolute;\n\tleft: calc(var(--sash-size) / 2);\n\twidth: 0;\n\tborder-left: 1px solid transparent;\n}\n\n.monaco-table > .monaco-split-view2,\n.monaco-table > .monaco-split-view2 .monaco-sash.vertical::before {\n\ttransition: border-color 0.2s ease-out;\n}\n/*\n.monaco-table:hover > .monaco-split-view2,\n.monaco-table:hover > .monaco-split-view2 .monaco-sash.vertical::before {\n\tborder-color: rgba(204, 204, 204, 0.2);\n} */\n',""]),t.Z=s},69811:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-custom-toggle {\n\tmargin-left: 2px;\n\tfloat: left;\n\tcursor: pointer;\n\toverflow: hidden;\n\twidth: 20px;\n\theight: 20px;\n\tborder-radius: 3px;\n\tborder: 1px solid transparent;\n\tpadding: 1px;\n\tbox-sizing:\tborder-box;\n\tuser-select: none;\n\t-webkit-user-select: none;\n\t-ms-user-select: none;\n}\n\n.monaco-custom-toggle:hover {\n\tbackground-color: var(--vscode-inputOption-hoverBackground);\n}\n\n.hc-black .monaco-custom-toggle:hover,\n.hc-light .monaco-custom-toggle:hover {\n\tborder: 1px dashed var(--vscode-focusBorder);\n}\n\n.hc-black .monaco-custom-toggle,\n.hc-light .monaco-custom-toggle {\n\tbackground: none;\n}\n\n.hc-black .monaco-custom-toggle:hover,\n.hc-light .monaco-custom-toggle:hover {\n\tbackground: none;\n}\n\n.monaco-custom-toggle.monaco-checkbox {\n\theight: 18px;\n\twidth: 18px;\n\tborder: 1px solid transparent;\n\tborder-radius: 3px;\n\tmargin-right: 9px;\n\tmargin-left: 0px;\n\tpadding: 0px;\n\topacity: 1;\n\tbackground-size: 16px !important;\n}\n\n/* hide check when unchecked */\n.monaco-custom-toggle.monaco-checkbox:not(.checked)::before {\n\tvisibility: hidden;\n}\n",""]),t.Z=s},42650:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-tl-row {\n\tdisplay: flex;\n\theight: 100%;\n\talign-items: center;\n\tposition: relative;\n}\n\n.monaco-tl-indent {\n\theight: 100%;\n\tposition: absolute;\n\ttop: 0;\n\tleft: 16px;\n\tpointer-events: none;\n}\n\n.hide-arrows .monaco-tl-indent {\n\tleft: 12px;\n}\n\n.monaco-tl-indent > .indent-guide {\n\tdisplay: inline-block;\n\tbox-sizing: border-box;\n\theight: 100%;\n\tborder-left: 1px solid transparent;\n}\n\n.monaco-tl-indent > .indent-guide {\n\ttransition: border-color 0.1s linear;\n}\n\n.monaco-tl-twistie,\n.monaco-tl-contents {\n\theight: 100%;\n}\n\n.monaco-tl-twistie {\n\tfont-size: 10px;\n\ttext-align: right;\n\tpadding-right: 6px;\n\tflex-shrink: 0;\n\twidth: 16px;\n\tdisplay: flex !important;\n\talign-items: center;\n\tjustify-content: center;\n\ttransform: translateX(3px);\n}\n\n.monaco-tl-contents {\n\tflex: 1;\n\toverflow: hidden;\n}\n\n.monaco-tl-twistie::before {\n\tborder-radius: 20px;\n}\n\n.monaco-tl-twistie.collapsed::before {\n\ttransform: rotate(-90deg);\n}\n\n.monaco-tl-twistie.codicon-tree-item-loading::before {\n\t/* Use steps to throttle FPS to reduce CPU usage */\n\tanimation: codicon-spin 1.25s steps(30) infinite;\n}\n\n.monaco-tree-type-filter {\n\tposition: absolute;\n\ttop: 0;\n\tdisplay: flex;\n\tpadding: 3px;\n\ttransition: top 0.3s;\n\tmax-width: 200px;\n\tz-index: 100;\n\tmargin: 0 6px;\n}\n\n.monaco-tree-type-filter.disabled {\n\ttop: -40px;\n}\n\n.monaco-tree-type-filter-grab {\n\tdisplay: flex !important;\n\talign-items: center;\n\tjustify-content: center;\n\tcursor: grab;\n\tmargin-right: 2px;\n}\n\n.monaco-tree-type-filter-grab.grabbing {\n\tcursor: grabbing;\n}\n\n.monaco-tree-type-filter-input {\n\tflex: 1;\n}\n\n.monaco-tree-type-filter-input .monaco-inputbox {\n\theight: 23px;\n}\n\n.monaco-tree-type-filter-input .monaco-inputbox > .ibwrapper > .input,\n.monaco-tree-type-filter-input .monaco-inputbox > .ibwrapper > .mirror {\n\tpadding: 2px 4px;\n}\n\n.monaco-tree-type-filter-input .monaco-findInput > .controls {\n\ttop: 2px;\n}\n\n.monaco-tree-type-filter-actionbar {\n\tmargin-left: 4px;\n}\n\n.monaco-tree-type-filter-actionbar .monaco-action-bar .action-label {\n\tpadding: 2px;\n}\n",""]),t.Z=s},94368:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.quick-input-widget {\n\tposition: absolute;\n\twidth: 600px;\n\tz-index: 2550;\n\tleft: 50%;\n\tmargin-left: -300px;\n\t-webkit-app-region: no-drag;\n}\n\n.quick-input-titlebar {\n\tdisplay: flex;\n\talign-items: center;\n}\n\n.quick-input-left-action-bar {\n\tdisplay: flex;\n\tmargin-left: 4px;\n\tflex: 1;\n}\n\n.quick-input-title {\n\tpadding: 3px 0px;\n\ttext-align: center;\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n}\n\n.quick-input-right-action-bar {\n\tdisplay: flex;\n\tmargin-right: 4px;\n\tflex: 1;\n}\n\n.quick-input-right-action-bar > .actions-container {\n\tjustify-content: flex-end;\n}\n\n.quick-input-titlebar .monaco-action-bar .action-label.codicon {\n\tbackground-position: center;\n\tbackground-repeat: no-repeat;\n\tpadding: 2px;\n}\n\n.quick-input-description {\n\tmargin: 6px;\n}\n\n.quick-input-header .quick-input-description {\n\tmargin: 4px 2px;\n}\n\n.quick-input-header {\n\tdisplay: flex;\n\tpadding: 6px 6px 0px 6px;\n\tmargin-bottom: -2px;\n}\n\n.quick-input-widget.hidden-input .quick-input-header {\n\t/* reduce margins and paddings when input box hidden */\n\tpadding: 0;\n\tmargin-bottom: 0;\n}\n\n.quick-input-and-message {\n\tdisplay: flex;\n\tflex-direction: column;\n\tflex-grow: 1;\n\tmin-width: 0;\n\tposition: relative;\n}\n\n.quick-input-check-all {\n\talign-self: center;\n\tmargin: 0;\n}\n\n.quick-input-filter {\n\tflex-grow: 1;\n\tdisplay: flex;\n\tposition: relative;\n}\n\n.quick-input-box {\n\tflex-grow: 1;\n}\n\n.quick-input-widget.show-checkboxes .quick-input-box,\n.quick-input-widget.show-checkboxes .quick-input-message {\n\tmargin-left: 5px;\n}\n\n.quick-input-visible-count {\n\tposition: absolute;\n\tleft: -10000px;\n}\n\n.quick-input-count {\n\talign-self: center;\n\tposition: absolute;\n\tright: 4px;\n\tdisplay: flex;\n\talign-items: center;\n}\n\n.quick-input-count .monaco-count-badge {\n\tvertical-align: middle;\n\tpadding: 2px 4px;\n\tborder-radius: 2px;\n\tmin-height: auto;\n\tline-height: normal;\n}\n\n.quick-input-action {\n\tmargin-left: 6px;\n}\n\n.quick-input-action .monaco-text-button {\n\tfont-size: 11px;\n\tpadding: 0 6px;\n\tdisplay: flex;\n\theight: 27.5px;\n\talign-items: center;\n}\n\n.quick-input-message {\n\tmargin-top: -1px;\n\tpadding: 5px;\n\toverflow-wrap: break-word;\n}\n\n.quick-input-message > .codicon {\n\tmargin: 0 0.2em;\n\tvertical-align: text-bottom;\n}\n\n.quick-input-progress.monaco-progress-container {\n\tposition: relative;\n}\n\n.quick-input-progress.monaco-progress-container,\n.quick-input-progress.monaco-progress-container .progress-bit {\n\theight: 2px;\n}\n\n.quick-input-list {\n\tline-height: 22px;\n\tmargin-top: 6px;\n\tpadding: 0px 1px 1px 1px;\n}\n\n.quick-input-widget.hidden-input .quick-input-list {\n\tmargin-top: 0; /* reduce margins when input box hidden */\n}\n\n.quick-input-list .monaco-list {\n\toverflow: hidden;\n\tmax-height: calc(20 * 22px);\n}\n\n.quick-input-list .quick-input-list-entry {\n\tbox-sizing: border-box;\n\toverflow: hidden;\n\tdisplay: flex;\n\theight: 100%;\n\tpadding: 0 6px;\n}\n\n.quick-input-list .quick-input-list-entry.quick-input-list-separator-border {\n\tborder-top-width: 1px;\n\tborder-top-style: solid;\n}\n\n.quick-input-list .monaco-list-row[data-index=\"0\"] .quick-input-list-entry.quick-input-list-separator-border {\n\tborder-top-style: none;\n}\n\n.quick-input-list .quick-input-list-label {\n\toverflow: hidden;\n\tdisplay: flex;\n\theight: 100%;\n\tflex: 1;\n}\n\n.quick-input-list .quick-input-list-checkbox {\n\talign-self: center;\n\tmargin: 0;\n}\n\n.quick-input-list .quick-input-list-rows {\n\toverflow: hidden;\n\ttext-overflow: ellipsis;\n\tdisplay: flex;\n\tflex-direction: column;\n\theight: 100%;\n\tflex: 1;\n\tmargin-left: 5px;\n}\n\n.quick-input-widget.show-checkboxes .quick-input-list .quick-input-list-rows {\n\tmargin-left: 10px;\n}\n\n.quick-input-widget .quick-input-list .quick-input-list-checkbox {\n\tdisplay: none;\n}\n.quick-input-widget.show-checkboxes .quick-input-list .quick-input-list-checkbox {\n\tdisplay: inline;\n}\n\n.quick-input-list .quick-input-list-rows > .quick-input-list-row {\n\tdisplay: flex;\n\talign-items: center;\n}\n\n.quick-input-list .quick-input-list-rows > .quick-input-list-row .monaco-icon-label,\n.quick-input-list .quick-input-list-rows > .quick-input-list-row .monaco-icon-label .monaco-icon-label-container > .monaco-icon-name-container {\n\tflex: 1; /* make sure the icon label grows within the row */\n}\n\n.quick-input-list .quick-input-list-rows > .quick-input-list-row .codicon[class*='codicon-'] {\n\tvertical-align: text-bottom;\n}\n\n.quick-input-list .quick-input-list-rows .monaco-highlighted-label span {\n\topacity: 1;\n}\n\n.quick-input-list .quick-input-list-entry .quick-input-list-entry-keybinding {\n\tmargin-right: 8px; /* separate from the separator label or scrollbar if any */\n}\n\n.quick-input-list .quick-input-list-label-meta {\n\topacity: 0.7;\n\tline-height: normal;\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n}\n\n.quick-input-list .monaco-highlighted-label .highlight {\n\tfont-weight: bold;\n}\n\n.quick-input-list .quick-input-list-entry .quick-input-list-separator {\n\tmargin-right: 8px; /* separate from keybindings or actions */\n}\n\n.quick-input-list .quick-input-list-entry-action-bar {\n\tdisplay: flex;\n\tflex: 0;\n\toverflow: visible;\n}\n\n.quick-input-list .quick-input-list-entry-action-bar .action-label {\n\t/*\n\t * By default, actions in the quick input action bar are hidden\n\t * until hovered over them or selected.\n\t */\n\tdisplay: none;\n}\n\n.quick-input-list .quick-input-list-entry-action-bar .action-label.codicon {\n\tmargin-right: 4px;\n\tpadding: 0px 2px 2px 2px;\n}\n\n.quick-input-list .quick-input-list-entry-action-bar {\n\tmargin-top: 1px;\n}\n\n.quick-input-list .quick-input-list-entry-action-bar {\n\tmargin-right: 4px; /* separate from scrollbar */\n}\n\n.quick-input-list .quick-input-list-entry .quick-input-list-entry-action-bar .action-label.always-visible,\n.quick-input-list .quick-input-list-entry:hover .quick-input-list-entry-action-bar .action-label,\n.quick-input-list .monaco-list-row.focused .quick-input-list-entry-action-bar .action-label {\n\tdisplay: flex;\n}\n\n/* focused items in quick pick */\n.quick-input-list .monaco-list-row.focused .monaco-keybinding-key,\n.quick-input-list .monaco-list-row.focused .quick-input-list-entry .quick-input-list-separator {\n\tcolor: inherit\n}\n.quick-input-list .monaco-list-row.focused .monaco-keybinding-key {\n\tbackground: none;\n}\n",""]),t.Z=s},92874:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .inputarea {\n\tmin-width: 0;\n\tmin-height: 0;\n\tmargin: 0;\n\tpadding: 0;\n\tposition: absolute;\n\toutline: none !important;\n\tresize: none;\n\tborder: none;\n\toverflow: hidden;\n\tcolor: transparent;\n\tbackground-color: transparent;\n}\n/*.monaco-editor .inputarea {\n\tposition: fixed !important;\n\twidth: 800px !important;\n\theight: 500px !important;\n\ttop: initial !important;\n\tleft: initial !important;\n\tbottom: 0 !important;\n\tright: 0 !important;\n\tcolor: black !important;\n\tbackground: white !important;\n\tline-height: 15px !important;\n\tfont-size: 14px !important;\n}*/\n.monaco-editor .inputarea.ime-input {\n\tz-index: 10;\n}\n",""]),t.Z=s},97926:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .blockDecorations-container {\n\tposition: absolute;\n\ttop: 0;\n}\n\n.monaco-editor .blockDecorations-block {\n\tposition: absolute;\n\tbox-sizing: border-box;\n}\n",""]),t.Z=s},82958:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .view-overlays .current-line {\n\tdisplay: block;\n\tposition: absolute;\n\tleft: 0;\n\ttop: 0;\n\tbox-sizing: border-box;\n}\n\n.monaco-editor .margin-view-overlays .current-line {\n\tdisplay: block;\n\tposition: absolute;\n\tleft: 0;\n\ttop: 0;\n\tbox-sizing: border-box;\n}\n\n.monaco-editor .margin-view-overlays .current-line.current-line-margin.current-line-margin-both {\n\tborder-right: 0;\n}\n",""]),t.Z=s},3381:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n/*\n\tKeeping name short for faster parsing.\n\tcdr = core decorations rendering (div)\n*/\n.monaco-editor .lines-content .cdr {\n\tposition: absolute;\n}",""]),t.Z=s},54734:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .glyph-margin {\n\tposition: absolute;\n\ttop: 0;\n}\n\n/*\n\tKeeping name short for faster parsing.\n\tcgmr = core glyph margin rendering (div)\n*/\n.monaco-editor .margin-view-overlays .cgmr {\n\tposition: absolute;\n\tdisplay: flex;\n\talign-items: center;\n\tjustify-content: center;\n}\n",""]),t.Z=s},68467:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .lines-content .core-guide {\n\tposition: absolute;\n\tbox-sizing: border-box;\n}\n",""]),t.Z=s},8787:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .margin-view-overlays .line-numbers {\n\tfont-variant-numeric: tabular-nums;\n\tposition: absolute;\n\ttext-align: right;\n\tdisplay: inline-block;\n\tvertical-align: middle;\n\tbox-sizing: border-box;\n\tcursor: default;\n\theight: 100%;\n}\n\n.monaco-editor .relative-current-line-number {\n\ttext-align: left;\n\tdisplay: inline-block;\n\twidth: 100%;\n}\n\n.monaco-editor .margin-view-overlays .line-numbers.lh-odd {\n\tmargin-top: 1px;\n}\n",""]),t.Z=s},17734:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n.monaco-editor .lines-decorations {\n\tposition: absolute;\n\ttop: 0;\n\tbackground: white;\n}\n\n/*\n\tKeeping name short for faster parsing.\n\tcldr = core lines decorations rendering (div)\n*/\n.monaco-editor .margin-view-overlays .cldr {\n\tposition: absolute;\n\theight: 100%;\n}",""]),t.Z=s},31192:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n/* Uncomment to see lines flashing when they're painted */\n/*.monaco-editor .view-lines > .view-line {\n\tbackground-color: none;\n\tanimation-name: flash-background;\n\tanimation-duration: 800ms;\n}\n@keyframes flash-background {\n\t0%   { background-color: lightgreen; }\n\t100% { background-color: none }\n}*/\n\n.mtkcontrol {\n\tcolor: rgb(255, 255, 255) !important;\n\tbackground: rgb(150, 0, 0) !important;\n}\n\n.monaco-editor.no-user-select .lines-content,\n.monaco-editor.no-user-select .view-line,\n.monaco-editor.no-user-select .view-lines {\n\tuser-select: none;\n\t-webkit-user-select: none;\n\t-ms-user-select: none;\n}\n\n.monaco-editor.enable-user-select {\n\tuser-select: initial;\n\t-webkit-user-select: initial;\n\t-ms-user-select: initial;\n}\n\n.monaco-editor .view-lines {\n\twhite-space: nowrap;\n}\n\n.monaco-editor .view-line {\n\tposition: absolute;\n\twidth: 100%;\n}\n\n.monaco-editor .mtkz {\n\tdisplay: inline-block;\n}\n\n/* TODO@tokenization bootstrap fix */\n/*.monaco-editor .view-line > span > span {\n\tfloat: none;\n\tmin-height: inherit;\n\tmargin-left: inherit;\n}*/\n",""]),t.Z=s},92762:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n/*\n\tKeeping name short for faster parsing.\n\tcmdr = core margin decorations rendering (div)\n*/\n.monaco-editor .margin-view-overlays .cmdr {\n\tposition: absolute;\n\tleft: 0;\n\twidth: 100%;\n\theight: 100%;\n}",""]),t.Z=s},75278:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n/* START cover the case that slider is visible on mouseover */\n.monaco-editor .minimap.slider-mouseover .minimap-slider {\n\topacity: 0;\n\ttransition: opacity 100ms linear;\n}\n.monaco-editor .minimap.slider-mouseover:hover .minimap-slider {\n\topacity: 1;\n}\n.monaco-editor .minimap.slider-mouseover .minimap-slider.active {\n\topacity: 1;\n}\n/* END cover the case that slider is visible on mouseover */\n\n.monaco-editor .minimap-shadow-hidden {\n\tposition: absolute;\n\twidth: 0;\n}\n.monaco-editor .minimap-shadow-visible {\n\tposition: absolute;\n\tleft: -6px;\n\twidth: 6px;\n}\n.monaco-editor.no-minimap-shadow .minimap-shadow-visible {\n\tposition: absolute;\n\tleft: -1px;\n\twidth: 1px;\n}\n\n/* 0.5s fade in/out for the minimap */\n.minimap.autohide {\n\topacity: 0.0;\n\ttransition: opacity 0.5s;\n}\n.minimap.autohide:hover {\n\topacity: 1.0;\n}\n",""]),t.Z=s},28096:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n.monaco-editor .overlayWidgets {\n\tposition: absolute;\n\ttop: 0;\n\tleft:0;\n}",""]),t.Z=s},10657:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .view-ruler {\n\tposition: absolute;\n\ttop: 0;\n}",""]),t.Z=s},71039:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .scroll-decoration {\n\tposition: absolute;\n\ttop: 0;\n\tleft: 0;\n\theight: 6px;\n}",""]),t.Z=s},58297:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n/*\n\tKeeping name short for faster parsing.\n\tcslr = core selections layer rendering (div)\n*/\n.monaco-editor .lines-content .cslr {\n\tposition: absolute;\n}\n\n.monaco-editor\t\t\t.top-left-radius\t\t{ border-top-left-radius: 3px; }\n.monaco-editor\t\t\t.bottom-left-radius\t\t{ border-bottom-left-radius: 3px; }\n.monaco-editor\t\t\t.top-right-radius\t\t{ border-top-right-radius: 3px; }\n.monaco-editor\t\t\t.bottom-right-radius\t{ border-bottom-right-radius: 3px; }\n\n.monaco-editor.hc-black .top-left-radius\t\t{ border-top-left-radius: 0; }\n.monaco-editor.hc-black .bottom-left-radius\t\t{ border-bottom-left-radius: 0; }\n.monaco-editor.hc-black .top-right-radius\t\t{ border-top-right-radius: 0; }\n.monaco-editor.hc-black .bottom-right-radius\t{ border-bottom-right-radius: 0; }\n\n.monaco-editor.hc-light .top-left-radius\t\t{ border-top-left-radius: 0; }\n.monaco-editor.hc-light .bottom-left-radius\t\t{ border-bottom-left-radius: 0; }\n.monaco-editor.hc-light .top-right-radius\t\t{ border-top-right-radius: 0; }\n.monaco-editor.hc-light .bottom-right-radius\t{ border-bottom-right-radius: 0; }\n",""]),t.Z=s},64115:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n.monaco-editor .cursors-layer {\n\tposition: absolute;\n\ttop: 0;\n}\n\n.monaco-editor .cursors-layer > .cursor {\n\tposition: absolute;\n\toverflow: hidden;\n}\n\n/* -- smooth-caret-animation -- */\n.monaco-editor .cursors-layer.cursor-smooth-caret-animation > .cursor {\n\ttransition: all 80ms;\n}\n\n/* -- block-outline-style -- */\n.monaco-editor .cursors-layer.cursor-block-outline-style > .cursor {\n\tbox-sizing: border-box;\n\tbackground: transparent !important;\n\tborder-style: solid;\n\tborder-width: 1px;\n}\n\n/* -- underline-style -- */\n.monaco-editor .cursors-layer.cursor-underline-style > .cursor {\n\tborder-bottom-width: 2px;\n\tborder-bottom-style: solid;\n\tbackground: transparent !important;\n\tbox-sizing: border-box;\n}\n\n/* -- underline-thin-style -- */\n.monaco-editor .cursors-layer.cursor-underline-thin-style > .cursor {\n\tborder-bottom-width: 1px;\n\tborder-bottom-style: solid;\n\tbackground: transparent !important;\n\tbox-sizing: border-box;\n}\n\n@keyframes monaco-cursor-smooth {\n\t0%,\n\t20% {\n\t\topacity: 1;\n\t}\n\t60%,\n\t100% {\n\t\topacity: 0;\n\t}\n}\n\n@keyframes monaco-cursor-phase {\n\t0%,\n\t20% {\n\t\topacity: 1;\n\t}\n\t90%,\n\t100% {\n\t\topacity: 0;\n\t}\n}\n\n@keyframes monaco-cursor-expand {\n\t0%,\n\t20% {\n\t\ttransform: scaleY(1);\n\t}\n\t80%,\n\t100% {\n\t\ttransform: scaleY(0);\n\t}\n}\n\n.cursor-smooth {\n\tanimation: monaco-cursor-smooth 0.5s ease-in-out 0s 20 alternate;\n}\n\n.cursor-phase {\n\tanimation: monaco-cursor-phase 0.5s ease-in-out 0s 20 alternate;\n}\n\n.cursor-expand > .cursor {\n\tanimation: monaco-cursor-expand 0.5s ease-in-out 0s 20 alternate;\n}\n",""]),t.Z=s},46663:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n/* ---------- DiffEditor ---------- */\n\n.monaco-diff-editor .diffOverview {\n\tz-index: 9;\n}\n\n.monaco-diff-editor .diffOverview .diffViewport {\n\tz-index: 10;\n}\n\n/* colors not externalized: using transparancy on background */\n.monaco-diff-editor.vs\t\t\t.diffOverview { background: rgba(0, 0, 0, 0.03); }\n.monaco-diff-editor.vs-dark\t\t.diffOverview { background: rgba(255, 255, 255, 0.01); }\n\n.monaco-scrollable-element.modified-in-monaco-diff-editor.vs\t\t.scrollbar { background: rgba(0,0,0,0); }\n.monaco-scrollable-element.modified-in-monaco-diff-editor.vs-dark\t.scrollbar { background: rgba(0,0,0,0); }\n.monaco-scrollable-element.modified-in-monaco-diff-editor.hc-black\t.scrollbar { background: none; }\n.monaco-scrollable-element.modified-in-monaco-diff-editor.hc-light\t.scrollbar { background: none; }\n\n.monaco-scrollable-element.modified-in-monaco-diff-editor .slider {\n\tz-index: 10;\n}\n.modified-in-monaco-diff-editor\t\t\t\t.slider.active { background: rgba(171, 171, 171, .4); }\n.modified-in-monaco-diff-editor.hc-black\t.slider.active { background: none; }\n.modified-in-monaco-diff-editor.hc-light\t.slider.active { background: none; }\n\n/* ---------- Diff ---------- */\n\n.monaco-editor .insert-sign,\n.monaco-diff-editor .insert-sign,\n.monaco-editor .delete-sign,\n.monaco-diff-editor .delete-sign {\n\tfont-size: 11px !important;\n\topacity: 0.7 !important;\n\tdisplay: flex !important;\n\talign-items: center;\n}\n.monaco-editor.hc-black .insert-sign,\n.monaco-diff-editor.hc-black .insert-sign,\n.monaco-editor.hc-black .delete-sign,\n.monaco-diff-editor.hc-black .delete-sign,\n.monaco-editor.hc-light .insert-sign,\n.monaco-diff-editor.hc-light .insert-sign,\n.monaco-editor.hc-light .delete-sign,\n.monaco-diff-editor.hc-light .delete-sign {\n\topacity: 1;\n}\n\n.monaco-editor .inline-deleted-margin-view-zone {\n\ttext-align: right;\n}\n.monaco-editor .inline-added-margin-view-zone {\n\ttext-align: right;\n}\n\n.monaco-editor .arrow-revert-change {\n\tz-index: 10;\n\tposition: absolute;\n}\n\n.monaco-editor .arrow-revert-change:hover {\n\tcursor: pointer;\n}\n\n/* ---------- Inline Diff ---------- */\n\n.monaco-editor .view-zones .view-lines .view-line span {\n\tdisplay: inline-block;\n}\n\n.monaco-editor .margin-view-zones .lightbulb-glyph:hover {\n\tcursor: pointer;\n}\n",""]),t.Z=s},65425:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-diff-editor .diff-review-line-number {\n\ttext-align: right;\n\tdisplay: inline-block;\n}\n\n.monaco-diff-editor .diff-review {\n\tposition: absolute;\n\tuser-select: none;\n\t-webkit-user-select: none;\n\t-ms-user-select: none;\n}\n\n.monaco-diff-editor .diff-review-summary {\n\tpadding-left: 10px;\n}\n\n.monaco-diff-editor .diff-review-shadow {\n\tposition: absolute;\n}\n\n.monaco-diff-editor .diff-review-row {\n\twhite-space: pre;\n}\n\n.monaco-diff-editor .diff-review-table {\n\tdisplay: table;\n\tmin-width: 100%;\n}\n\n.monaco-diff-editor .diff-review-row {\n\tdisplay: table-row;\n\twidth: 100%;\n}\n\n.monaco-diff-editor .diff-review-spacer {\n\tdisplay: inline-block;\n\twidth: 10px;\n\tvertical-align: middle;\n}\n\n.monaco-diff-editor .diff-review-spacer > .codicon {\n\tfont-size: 9px !important;\n}\n\n.monaco-diff-editor .diff-review-actions {\n\tdisplay: inline-block;\n\tposition: absolute;\n\tright: 10px;\n\ttop: 2px;\n}\n\n.monaco-diff-editor .diff-review-actions .action-label {\n\twidth: 16px;\n\theight: 16px;\n\tmargin: 2px 0;\n}\n",""]),t.Z=s},67691:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n/* -------------------- IE10 remove auto clear button -------------------- */\n\n::-ms-clear {\n\tdisplay: none;\n}\n\n/* All widgets */\n/* I am not a big fan of this rule */\n.monaco-editor .editor-widget input {\n\tcolor: inherit;\n}\n\n/* -------------------- Editor -------------------- */\n\n.monaco-editor {\n\tposition: relative;\n\toverflow: visible;\n\t-webkit-text-size-adjust: 100%;\n}\n\n/* -------------------- Misc -------------------- */\n\n.monaco-editor .overflow-guard {\n\tposition: relative;\n\toverflow: hidden;\n}\n\n.monaco-editor .view-overlays {\n\tposition: absolute;\n\ttop: 0;\n}\n\n/*\n.monaco-editor .auto-closed-character {\n\topacity: 0.3;\n}\n*/\n",""]),t.Z=s},84170:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .selection-anchor {\n\tbackground-color: #007ACC;\n\twidth: 2px !important;\n}\n",""]),t.Z=s},73809:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .bracket-match {\n\tbox-sizing: border-box;\n}\n",""]),t.Z=s},36501:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .contentWidgets .codicon-light-bulb,\n.monaco-editor .contentWidgets .codicon-lightbulb-autofix {\n\tdisplay: flex;\n\talign-items: center;\n\tjustify-content: center;\n}\n\n.monaco-editor .contentWidgets .codicon-light-bulb:hover,\n.monaco-editor .contentWidgets .codicon-lightbulb-autofix:hover {\n\tcursor: pointer;\n}\n",""]),t.Z=s},15622:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,'/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.codeActionMenuWidget {\n\tpadding: 8px 0px 8px 0px;\n\toverflow: auto;\n\tfont-size: 13px;\n\tborder-radius: 5px;\n\tmin-width: 160px;\n\tz-index: 40;\n\tdisplay: block;\n\t/* flex-direction: column;\n\tflex: 0 1 auto; */\n\twidth: 100%;\n\tborder-width: 0px;\n\tborder-color: none;\n\tbackground-color: var(--vscode-menu-background);\n\tcolor: var(--vscode-menu-foreground);\n\tbox-shadow: rgb(0,0,0, 16%) 0px 2px 8px;\n}\n\n.codeActionMenuWidget .monaco-list:not(.element-focused):focus:before {\n\tposition: absolute;\n\ttop: 0;\n\tleft: 0;\n\twidth: 100%;\n\theight: 100%;\n\tz-index: 5; /* make sure we are on top of the tree items */\n\tcontent: "";\n\tpointer-events: none; /* enable click through */\n\toutline: 0px solid !important; /* we still need to handle the empty tree or no focus item case */\n\toutline-width: 0px !important;\n\toutline-style: none !important;\n\toutline-offset: 0px !important;\n}\n\n.codeActionMenuWidget .monaco-list {\n\tuser-select: none;\n\t-webkit-user-select: none;\n\t-ms-user-select: none;\n\tborder: none !important;\n\tborder-width: 0px !important;\n}\n\n/* .codeActionMenuWidget .monaco-list:not(.element-focus) {\n\tborder: none !important;\n\tborder-width: 0px !important;\n} */\n\n.codeActionMenuWidget .monaco-list .monaco-scrollable-element .monaco-list-rows {\n\theight: 100% !important;\n}\n\n.codeActionMenuWidget .monaco-list .monaco-scrollable-element {\n\toverflow: visible;\n}\n/** Styles for each row in the list element **/\n\n.codeActionMenuWidget .monaco-list .monaco-list-row:not(.separator) {\n\tdisplay: flex;\n\t-mox-box-sizing: border-box;\n\tbox-sizing: border-box;\n\tpadding: 0px 26px 0px 26px;\n\tbackground-repeat: no-repeat;\n\tbackground-position: 2px 2px;\n\twhite-space: nowrap;\n\tcursor: pointer;\n\ttouch-action: none;\n\twidth: 100%;\n}\n\n\n.codeActionMenuWidget .monaco-list .monaco-list-row:hover:not(.option-disabled),\n.codeActionMenuWidget .monaco-list .moncao-list-row.focused:not(.option-disabled) {\n\tcolor: var(--vscode-menu-selectionForeground) !important;\n\tbackground-color: var(--vscode-menu-selectionBackground) !important;\n}\n\n.codeActionMenuWidget .monaco-list .option-disabled,\n.codeActionMenuWidget .monaco-list .option-disabled .focused {\n\tpointer-events: none;\n\t-webkit-touch-callout: none;\n\t-webkit-user-select: none;\n\t-khtml-user-select: none;\n\t-moz-user-select: none;\n\t-ms-user-select: none;\n\tuser-select: none;\n\tcolor: var(--vscode-disabledForeground) !important;\n}\n\n.codeActionMenuWidget .monaco-list .separator {\n\tborder-bottom: 1px solid var(--vscode-menu-separatorBackground);\n\tpadding-top: 0px !important;\n\t/* padding: 30px; */\n\twidth: 100%;\n\theight: 0px !important;\n\topacity: 1;\n\tfont-size: inherit;\n\tmargin: 5px 0 !important;\n\tborder-radius: 0;\n\tdisplay: flex;\n\t-mox-box-sizing: border-box;\n\tbox-sizing: border-box;\n\tbackground-repeat: no-repeat;\n\tbackground-position: 2px 2px;\n\twhite-space: nowrap;\n\tcursor: pointer;\n\ttouch-action: none;\n}\n',""]),t.Z=s},93820:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .codelens-decoration {\n\toverflow: hidden;\n\tdisplay: inline-block;\n\ttext-overflow: ellipsis;\n\twhite-space: nowrap;\n\tcolor: var(--vscode-editorCodeLens-foreground)\n}\n\n.monaco-editor .codelens-decoration>span,\n.monaco-editor .codelens-decoration>a {\n\tuser-select: none;\n\t-webkit-user-select: none;\n\t-ms-user-select: none;\n\twhite-space: nowrap;\n\tvertical-align: sub;\n}\n\n.monaco-editor .codelens-decoration>a {\n\ttext-decoration: none;\n}\n\n.monaco-editor .codelens-decoration>a:hover {\n\tcursor: pointer;\n\tcolor: var(--vscode-editorLink-activeForeground) !important;\n}\n\n.monaco-editor .codelens-decoration>a:hover .codicon {\n\tcolor: var(--vscode-editorLink-activeForeground) !important;\n}\n\n.monaco-editor .codelens-decoration .codicon {\n\tvertical-align: middle;\n\tcolor: currentColor !important;\n\tcolor: var(--vscode-editorCodeLens-foreground);\n}\n\n.monaco-editor .codelens-decoration>a:hover .codicon::before {\n\tcursor: pointer;\n}\n\n@keyframes fadein {\n\t0% {\n\t\topacity: 0;\n\t\tvisibility: visible;\n\t}\n\n\t100% {\n\t\topacity: 1;\n\t}\n}\n\n.monaco-editor .codelens-decoration.fadein {\n\tanimation: fadein 0.1s linear;\n}\n",""]),t.Z=s},64194:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r),a=i(61667),l=i.n(a),c=new URL(i(94748),i.b),d=s()(o()),u=l()(c);d.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.colorpicker-widget {\n\theight: 190px;\n\tuser-select: none;\n\t-webkit-user-select: none;\n\t-ms-user-select: none;\n}\n\n/* Decoration */\n\n.colorpicker-color-decoration,\n.hc-light .colorpicker-color-decoration {\n\tborder: solid 0.1em #000;\n\tbox-sizing: border-box;\n\tmargin: 0.1em 0.2em 0 0.2em;\n\twidth: 0.8em;\n\theight: 0.8em;\n\tline-height: 0.8em;\n\tdisplay: inline-block;\n\tcursor: pointer;\n}\n\n.hc-black .colorpicker-color-decoration,\n.vs-dark .colorpicker-color-decoration {\n\tborder: solid 0.1em #eee;\n}\n\n/* Header */\n\n.colorpicker-header {\n\tdisplay: flex;\n\theight: 24px;\n\tposition: relative;\n\tbackground: url("+u+");\n\tbackground-size: 9px 9px;\n\timage-rendering: pixelated;\n}\n\n.colorpicker-header .picked-color {\n\twidth: 216px;\n\tdisplay: flex;\n\talign-items: center;\n\tjustify-content: center;\n\tline-height: 24px;\n\tcursor: pointer;\n\tcolor: white;\n\tflex: 1;\n}\n\n.colorpicker-header .picked-color .codicon {\n\tcolor: inherit;\n\tfont-size: 14px;\n\tposition: absolute;\n\tleft: 8px;\n}\n\n.colorpicker-header .picked-color.light {\n\tcolor: black;\n}\n\n.colorpicker-header .original-color {\n\twidth: 74px;\n\tz-index: inherit;\n\tcursor: pointer;\n}\n\n\n/* Body */\n\n.colorpicker-body {\n\tdisplay: flex;\n\tpadding: 8px;\n\tposition: relative;\n}\n\n.colorpicker-body .saturation-wrap {\n\toverflow: hidden;\n\theight: 150px;\n\tposition: relative;\n\tmin-width: 220px;\n\tflex: 1;\n}\n\n.colorpicker-body .saturation-box {\n\theight: 150px;\n\tposition: absolute;\n}\n\n.colorpicker-body .saturation-selection {\n\twidth: 9px;\n\theight: 9px;\n\tmargin: -5px 0 0 -5px;\n\tborder: 1px solid rgb(255, 255, 255);\n\tborder-radius: 100%;\n\tbox-shadow: 0px 0px 2px rgba(0, 0, 0, 0.8);\n\tposition: absolute;\n}\n\n.colorpicker-body .strip {\n\twidth: 25px;\n\theight: 150px;\n}\n\n.colorpicker-body .hue-strip {\n\tposition: relative;\n\tmargin-left: 8px;\n\tcursor: grab;\n\tbackground: linear-gradient(to bottom, #ff0000 0%, #ffff00 17%, #00ff00 33%, #00ffff 50%, #0000ff 67%, #ff00ff 83%, #ff0000 100%);\n}\n\n.colorpicker-body .opacity-strip {\n\tposition: relative;\n\tmargin-left: 8px;\n\tcursor: grab;\n\tbackground: url("+u+");\n\tbackground-size: 9px 9px;\n\timage-rendering: pixelated;\n}\n\n.colorpicker-body .strip.grabbing {\n\tcursor: grabbing;\n}\n\n.colorpicker-body .slider {\n\tposition: absolute;\n\ttop: 0;\n\tleft: -2px;\n\twidth: calc(100% + 4px);\n\theight: 4px;\n\tbox-sizing: border-box;\n\tborder: 1px solid rgba(255, 255, 255, 0.71);\n\tbox-shadow: 0px 0px 1px rgba(0, 0, 0, 0.85);\n}\n\n.colorpicker-body .strip .overlay {\n\theight: 150px;\n\tpointer-events: none;\n}\n",""]),t.Z=d},81779:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor.vs .dnd-target,\n.monaco-editor.hc-light .dnd-target {\n\tborder-right: 2px dotted black;\n\tcolor: white; /* opposite of black */\n}\n.monaco-editor.vs-dark .dnd-target {\n\tborder-right: 2px dotted #AEAFAD;\n\tcolor: #51504f; /* opposite of #AEAFAD */\n}\n.monaco-editor.hc-black .dnd-target {\n\tborder-right: 2px dotted #fff;\n\tcolor: #000; /* opposite of #fff */\n}\n\n.monaco-editor.mouse-default .view-lines,\n.monaco-editor.vs-dark.mac.mouse-default .view-lines,\n.monaco-editor.hc-black.mac.mouse-default .view-lines,\n.monaco-editor.hc-light.mac.mouse-default .view-lines {\n\tcursor: default;\n}\n.monaco-editor.mouse-copy .view-lines,\n.monaco-editor.vs-dark.mac.mouse-copy .view-lines,\n.monaco-editor.hc-black.mac.mouse-copy .view-lines,\n.monaco-editor.hc-light.mac.mouse-copy .view-lines {\n\tcursor: copy;\n}\n",""]),t.Z=s},30156:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n/* Find widget */\n.monaco-editor .find-widget {\n\tposition: absolute;\n\tz-index: 35;\n\theight: 33px;\n\toverflow: hidden;\n\tline-height: 19px;\n\ttransition: transform 200ms linear;\n\tpadding: 0 4px;\n\tbox-sizing: border-box;\n\ttransform: translateY(calc(-100% - 10px)); /* shadow (10px) */\n}\n\n.monaco-workbench.reduce-motion .monaco-editor .find-widget {\n\ttransition: transform 0ms linear;\n}\n\n.monaco-editor .find-widget textarea {\n\tmargin: 0px;\n}\n\n.monaco-editor .find-widget.hiddenEditor {\n\tdisplay: none;\n}\n\n/* Find widget when replace is toggled on */\n.monaco-editor .find-widget.replaceToggled > .replace-part {\n\tdisplay: flex;\n}\n\n.monaco-editor .find-widget.visible  {\n\ttransform: translateY(0);\n}\n\n.monaco-editor .find-widget .monaco-inputbox.synthetic-focus {\n\toutline: 1px solid -webkit-focus-ring-color;\n\toutline-offset: -1px;\n}\n\n.monaco-editor .find-widget .monaco-inputbox .input {\n\tbackground-color: transparent;\n\tmin-height: 0;\n}\n\n.monaco-editor .find-widget .monaco-findInput .input {\n\tfont-size: 13px;\n}\n\n.monaco-editor .find-widget > .find-part,\n.monaco-editor .find-widget > .replace-part {\n\tmargin: 4px 0 0 17px;\n\tfont-size: 12px;\n\tdisplay: flex;\n}\n\n.monaco-editor .find-widget > .find-part .monaco-inputbox,\n.monaco-editor .find-widget > .replace-part .monaco-inputbox {\n\tmin-height: 25px;\n}\n\n\n.monaco-editor .find-widget > .replace-part .monaco-inputbox > .ibwrapper > .mirror {\n\tpadding-right: 22px;\n}\n\n.monaco-editor .find-widget > .find-part .monaco-inputbox > .ibwrapper > .input,\n.monaco-editor .find-widget > .find-part .monaco-inputbox > .ibwrapper > .mirror,\n.monaco-editor .find-widget > .replace-part .monaco-inputbox > .ibwrapper > .input,\n.monaco-editor .find-widget > .replace-part .monaco-inputbox > .ibwrapper > .mirror {\n\tpadding-top: 2px;\n\tpadding-bottom: 2px;\n}\n\n.monaco-editor .find-widget > .find-part .find-actions {\n\theight: 25px;\n\tdisplay: flex;\n\talign-items: center;\n}\n\n.monaco-editor .find-widget > .replace-part .replace-actions {\n\theight: 25px;\n\tdisplay: flex;\n\talign-items: center;\n}\n\n.monaco-editor .find-widget .monaco-findInput {\n\tvertical-align: middle;\n\tdisplay: flex;\n\tflex:1;\n}\n\n.monaco-editor .find-widget .monaco-findInput .monaco-scrollable-element {\n\t/* Make sure textarea inherits the width correctly */\n\twidth: 100%;\n}\n\n.monaco-editor .find-widget .monaco-findInput .monaco-scrollable-element .scrollbar.vertical {\n\t/* Hide vertical scrollbar */\n\topacity: 0;\n}\n\n.monaco-editor .find-widget .matchesCount {\n\tdisplay: flex;\n\tflex: initial;\n\tmargin: 0 0 0 3px;\n\tpadding: 2px 0 0 2px;\n\theight: 25px;\n\tvertical-align: middle;\n\tbox-sizing: border-box;\n\ttext-align: center;\n\tline-height: 23px;\n}\n\n.monaco-editor .find-widget .button {\n\twidth: 16px;\n\theight: 16px;\n\tpadding: 3px;\n\tborder-radius: 5px;\n\tdisplay: flex;\n\tflex: initial;\n\tmargin-left: 3px;\n\tbackground-position: center center;\n\tbackground-repeat: no-repeat;\n\tcursor: pointer;\n\tdisplay: flex;\n\talign-items: center;\n\tjustify-content: center;\n}\n\n/* find in selection button */\n.monaco-editor .find-widget .codicon-find-selection {\n\twidth: 22px;\n\theight: 22px;\n\tpadding: 3px;\n\tborder-radius: 5px;\n}\n\n.monaco-editor .find-widget .button.left {\n\tmargin-left: 0;\n\tmargin-right: 3px;\n}\n\n.monaco-editor .find-widget .button.wide {\n\twidth: auto;\n\tpadding: 1px 6px;\n\ttop: -1px;\n}\n\n.monaco-editor .find-widget .button.toggle {\n\tposition: absolute;\n\ttop: 0;\n\tleft: 3px;\n\twidth: 18px;\n\theight: 100%;\n\tborder-radius: 0;\n\tbox-sizing: border-box;\n}\n\n.monaco-editor .find-widget .button.toggle.disabled {\n\tdisplay: none;\n}\n\n.monaco-editor .find-widget .disabled {\n\tcolor: var(--vscode-disabledForeground);\n\tcursor: default;\n}\n\n.monaco-editor .find-widget > .replace-part {\n\tdisplay: none;\n}\n\n.monaco-editor .find-widget > .replace-part > .monaco-findInput {\n\tposition: relative;\n\tdisplay: flex;\n\tvertical-align: middle;\n\tflex: auto;\n\tflex-grow: 0;\n\tflex-shrink: 0;\n}\n\n.monaco-editor .find-widget > .replace-part > .monaco-findInput > .controls {\n\tposition: absolute;\n\ttop: 3px;\n\tright: 2px;\n}\n\n/* REDUCED */\n.monaco-editor .find-widget.reduced-find-widget .matchesCount {\n\tdisplay:none;\n}\n\n/* NARROW (SMALLER THAN REDUCED) */\n.monaco-editor .find-widget.narrow-find-widget {\n\tmax-width: 257px !important;\n}\n\n/* COLLAPSED (SMALLER THAN NARROW) */\n.monaco-editor .find-widget.collapsed-find-widget {\n\tmax-width: 170px !important;\n}\n\n.monaco-editor .find-widget.collapsed-find-widget .button.previous,\n.monaco-editor .find-widget.collapsed-find-widget .button.next,\n.monaco-editor .find-widget.collapsed-find-widget .button.replace,\n.monaco-editor .find-widget.collapsed-find-widget .button.replace-all,\n.monaco-editor .find-widget.collapsed-find-widget > .find-part .monaco-findInput .controls {\n\tdisplay:none;\n}\n\n.monaco-editor .findMatch {\n\tanimation-duration: 0;\n\tanimation-name: inherit !important;\n}\n\n.monaco-editor .find-widget .monaco-sash {\n\tleft: 0 !important;\n}\n\n.monaco-editor.hc-black .find-widget .button:before {\n\tposition: relative;\n\ttop: 1px;\n\tleft: 2px;\n}\n",""]),t.Z=s},54063:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,'/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n.monaco-editor .margin-view-overlays .codicon-folding-manual-collapsed,\n.monaco-editor .margin-view-overlays .codicon-folding-manual-expanded,\n.monaco-editor .margin-view-overlays .codicon-folding-expanded,\n.monaco-editor .margin-view-overlays .codicon-folding-collapsed {\n\tcursor: pointer;\n\topacity: 0;\n\ttransition: opacity 0.5s;\n\tdisplay: flex;\n\talign-items: center;\n\tjustify-content: center;\n\tfont-size: 140%;\n\tmargin-left: 2px;\n}\n\n.monaco-editor .margin-view-overlays:hover .codicon,\n.monaco-editor .margin-view-overlays .codicon.codicon-folding-collapsed,\n.monaco-editor .margin-view-overlays .codicon.codicon-folding-manual-collapsed,\n.monaco-editor .margin-view-overlays .codicon.alwaysShowFoldIcons {\n\topacity: 1;\n}\n\n.monaco-editor .inline-folded:after {\n\tcolor: grey;\n\tmargin: 0.1em 0.2em 0 0.2em;\n\tcontent: "⋯";\n\tdisplay: inline;\n\tline-height: 1em;\n\tcursor: pointer;\n}\n\n',""]),t.Z=s},20101:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n/* marker zone */\n\n.monaco-editor .peekview-widget .head .peekview-title .severity-icon {\n\tdisplay: inline-block;\n\tvertical-align: text-top;\n\tmargin-right: 4px;\n}\n\n.monaco-editor .marker-widget {\n\ttext-overflow: ellipsis;\n\twhite-space: nowrap;\n}\n\n.monaco-editor .marker-widget > .stale {\n\topacity: 0.6;\n\tfont-style: italic;\n}\n\n.monaco-editor .marker-widget .title {\n\tdisplay: inline-block;\n\tpadding-right: 5px;\n}\n\n.monaco-editor .marker-widget .descriptioncontainer {\n\tposition: absolute;\n\twhite-space: pre;\n\tuser-select: text;\n\t-webkit-user-select: text;\n\t-ms-user-select: text;\n\tpadding: 8px 12px 0 20px;\n}\n\n.monaco-editor .marker-widget .descriptioncontainer .message {\n\tdisplay: flex;\n\tflex-direction: column;\n}\n\n.monaco-editor .marker-widget .descriptioncontainer .message .details {\n\tpadding-left: 6px;\n}\n\n.monaco-editor .marker-widget .descriptioncontainer .message .source,\n.monaco-editor .marker-widget .descriptioncontainer .message span.code {\n\topacity: 0.6;\n}\n\n.monaco-editor .marker-widget .descriptioncontainer .message a.code-link {\n\topacity: 0.6;\n\tcolor: inherit;\n}\n\n.monaco-editor .marker-widget .descriptioncontainer .message a.code-link:before {\n\tcontent: '(';\n}\n\n.monaco-editor .marker-widget .descriptioncontainer .message a.code-link:after {\n\tcontent: ')';\n}\n\n.monaco-editor .marker-widget .descriptioncontainer .message a.code-link > span {\n\ttext-decoration: underline;\n\t/** Hack to force underline to show **/\n\tborder-bottom: 1px solid transparent;\n\ttext-underline-position: under;\n\tcolor: var(--vscode-textLink-foreground);\n}\n\n.monaco-editor .marker-widget .descriptioncontainer .message a.code-link > span {\n\tcolor: var(--vscode-textLink-activeForeground);\n}\n\n.monaco-editor .marker-widget .descriptioncontainer .filename {\n\tcursor: pointer;\n}\n",""]),t.Z=s},93380:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .goto-definition-link {\n\ttext-decoration: underline;\n\tcursor: pointer;\n}",""]),t.Z=s},83231:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n/* -- zone widget */\n.monaco-editor .zone-widget .zone-widget-container.reference-zone-widget {\n\tborder-top-width: 1px;\n\tborder-bottom-width: 1px;\n}\n\n.monaco-editor .reference-zone-widget .inline {\n\tdisplay: inline-block;\n\tvertical-align: top;\n}\n\n.monaco-editor .reference-zone-widget .messages {\n\theight: 100%;\n\twidth: 100%;\n\ttext-align: center;\n\tpadding: 3em 0;\n}\n\n.monaco-editor .reference-zone-widget .ref-tree {\n\tline-height: 23px;\n\tbackground-color: var(--vscode-peekViewResult-background);\n\tcolor: var(--vscode-peekViewResult-lineForeground);\n}\n\n.monaco-editor .reference-zone-widget .ref-tree .reference {\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n}\n\n.monaco-editor .reference-zone-widget .ref-tree .reference-file {\n\tdisplay: inline-flex;\n\twidth: 100%;\n\theight: 100%;\n\tcolor: var(--vscode-peekViewResult-fileForeground);\n}\n\n.monaco-editor .reference-zone-widget .ref-tree .monaco-list:focus .selected .reference-file {\n\tcolor: inherit !important;\n}\n\n.monaco-editor .reference-zone-widget .ref-tree .monaco-list:focus .monaco-list-rows > .monaco-list-row.selected:not(.highlighted) {\n\tbackground-color: var(--vscode-peekViewResult-selectionBackground);\n\tcolor: var(--vscode-peekViewResult-selectionForeground) !important;\n}\n\n.monaco-editor .reference-zone-widget .ref-tree .reference-file .count {\n\tmargin-right: 12px;\n\tmargin-left: auto;\n}\n\n.monaco-editor .reference-zone-widget .ref-tree .referenceMatch .highlight {\n\tbackground-color: var(--vscode-peekViewResult-matchHighlightBackground);\n}\n\n.monaco-editor .reference-zone-widget .preview .reference-decoration {\n\tbackground-color: var(--vscode-peekViewEditor-matchHighlightBackground);\n\tborder: 2px solid var(--vscode-peekViewEditor-matchHighlightBorder);\n\tbox-sizing: border-box;\n}\n\n.monaco-editor .reference-zone-widget .preview .monaco-editor .monaco-editor-background,\n.monaco-editor .reference-zone-widget .preview .monaco-editor .inputarea.ime-input {\n\tbackground-color: var(--vscode-peekViewEditor-background);\n}\n\n.monaco-editor .reference-zone-widget .preview .monaco-editor .margin {\n\tbackground-color: var(--vscode-peekViewEditorGutter-background);\n}\n\n/* High Contrast Theming */\n\n.monaco-editor.hc-black .reference-zone-widget .ref-tree .reference-file,\n.monaco-editor.hc-light .reference-zone-widget .ref-tree .reference-file {\n\tfont-weight: bold;\n}\n\n.monaco-editor.hc-black .reference-zone-widget .ref-tree .referenceMatch .highlight,\n.monaco-editor.hc-light .reference-zone-widget .ref-tree .referenceMatch .highlight {\n\tborder: 1px dotted var(--vscode-contrastActiveBorder, transparent);\n\tbox-sizing: border-box;\n}\n",""]),t.Z=s},61754:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .suggest-preview-additional-widget {\n\twhite-space: nowrap;\n}\n\n.monaco-editor .suggest-preview-additional-widget .content-spacer {\n\tcolor: transparent;\n\twhite-space: pre;\n}\n\n.monaco-editor .suggest-preview-additional-widget .button {\n\tdisplay: inline-block;\n\tcursor: pointer;\n\ttext-decoration: underline;\n\ttext-underline-position: under;\n}\n\n.monaco-editor .ghost-text-hidden {\n\topacity: 0;\n\tfont-size: 0;\n}\n\n.monaco-editor .ghost-text-decoration {\n\tfont-style: italic;\n}\n\n.monaco-editor .suggest-preview-text {\n\tfont-style: italic;\n}\n\n.monaco-editor .inline-completion-text-to-replace {\n\ttext-decoration: underline;\n\ttext-underline-position: under;\n}\n",""]),t.Z=s},76813:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n.monaco-editor .detected-link,\n.monaco-editor .detected-link-active {\n\ttext-decoration: underline;\n\ttext-underline-position: under;\n}\n\n.monaco-editor .detected-link-active {\n\tcursor: pointer;\n}\n",""]),t.Z=s},5036:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .monaco-editor-overlaymessage {\n\tpadding-bottom: 8px;\n\tz-index: 10000;\n}\n\n.monaco-editor .monaco-editor-overlaymessage.below {\n\tpadding-bottom: 0;\n\tpadding-top: 8px;\n\tz-index: 10000;\n}\n\n@keyframes fadeIn {\n\tfrom { opacity: 0; }\n\tto { opacity: 1; }\n}\n.monaco-editor .monaco-editor-overlaymessage.fadeIn {\n\tanimation: fadeIn 150ms ease-out;\n}\n\n@keyframes fadeOut {\n\tfrom { opacity: 1; }\n\tto { opacity: 0; }\n}\n.monaco-editor .monaco-editor-overlaymessage.fadeOut {\n\tanimation: fadeOut 100ms ease-out;\n}\n\n.monaco-editor .monaco-editor-overlaymessage .message {\n\tpadding: 1px 4px;\n\tcolor: var(--vscode-inputValidation-infoForeground);\n\tbackground-color: var(--vscode-inputValidation-infoBackground);\n\tborder: 1px solid var(--vscode-inputValidation-infoBorder);\n}\n\n.monaco-editor.hc-black .monaco-editor-overlaymessage .message,\n.monaco-editor.hc-light .monaco-editor-overlaymessage .message {\n\tborder-width: 2px;\n}\n\n.monaco-editor .monaco-editor-overlaymessage .anchor {\n\twidth: 0 !important;\n\theight: 0 !important;\n\tborder-color: transparent;\n\tborder-style: solid;\n\tz-index: 1000;\n\tborder-width: 8px;\n\tposition: absolute;\n}\n\n.monaco-editor .monaco-editor-overlaymessage .anchor.top {\n\tborder-bottom-color: var(--vscode-inputValidation-infoBorder);\n}\n\n.monaco-editor .monaco-editor-overlaymessage .anchor.below {\n\tborder-top-color: var(--vscode-inputValidation-infoBorder);\n}\n\n.monaco-editor .monaco-editor-overlaymessage:not(.below) .anchor.top,\n.monaco-editor .monaco-editor-overlaymessage.below .anchor.below {\n\tdisplay: none;\n}\n\n.monaco-editor .monaco-editor-overlaymessage.below .anchor.top {\n\tdisplay: inherit;\n\ttop: -8px;\n}\n",""]),t.Z=s},32951:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .parameter-hints-widget {\n\t/* Must be higher than the sash's z-index and terminal canvases but lower than the suggest widget */\n\tz-index: 39;\n\tdisplay: flex;\n\tflex-direction: column;\n\tline-height: 1.5em;\n\tcursor: default;\n}\n\n.monaco-editor .parameter-hints-widget > .phwrapper {\n\tmax-width: 440px;\n\tdisplay: flex;\n\tflex-direction: row;\n}\n\n.monaco-editor .parameter-hints-widget.multiple {\n\tmin-height: 3.3em;\n\tpadding: 0;\n}\n\n.monaco-editor .parameter-hints-widget.visible {\n\ttransition: left .05s ease-in-out;\n}\n\n.monaco-editor .parameter-hints-widget p,\n.monaco-editor .parameter-hints-widget ul {\n\tmargin: 8px 0;\n}\n\n.monaco-editor .parameter-hints-widget .monaco-scrollable-element,\n.monaco-editor .parameter-hints-widget .body {\n\tdisplay: flex;\n\tflex: 1;\n\tflex-direction: column;\n\tmin-height: 100%;\n}\n\n.monaco-editor .parameter-hints-widget .signature {\n\tpadding: 4px 5px;\n}\n\n.monaco-editor .parameter-hints-widget .docs {\n\tpadding: 0 10px 0 5px;\n\twhite-space: pre-wrap;\n}\n\n.monaco-editor .parameter-hints-widget .docs.empty {\n\tdisplay: none;\n}\n\n.monaco-editor .parameter-hints-widget .docs .markdown-docs {\n\twhite-space: initial;\n}\n\n.monaco-editor .parameter-hints-widget .docs .markdown-docs a:hover {\n\tcursor: pointer;\n}\n\n.monaco-editor .parameter-hints-widget .docs .markdown-docs code {\n\tfont-family: var(--monaco-monospace-font);\n}\n\n.monaco-editor .parameter-hints-widget .docs  .monaco-tokenized-source,\n.monaco-editor .parameter-hints-widget .docs .code {\n\twhite-space: pre-wrap;\n}\n\n.monaco-editor .parameter-hints-widget .docs code {\n\tborder-radius: 3px;\n\tpadding: 0 0.4em;\n}\n\n.monaco-editor .parameter-hints-widget .controls {\n\tdisplay: none;\n\tflex-direction: column;\n\talign-items: center;\n\tmin-width: 22px;\n\tjustify-content: flex-end;\n}\n\n.monaco-editor .parameter-hints-widget.multiple .controls {\n\tdisplay: flex;\n\tpadding: 0 2px;\n}\n\n.monaco-editor .parameter-hints-widget.multiple .button {\n\twidth: 16px;\n\theight: 16px;\n\tbackground-repeat: no-repeat;\n\tcursor: pointer;\n}\n\n.monaco-editor .parameter-hints-widget .button.previous {\n\tbottom: 24px;\n}\n\n.monaco-editor .parameter-hints-widget .overloads {\n\ttext-align: center;\n\theight: 12px;\n\tline-height: 12px;\n\tfont-family: var(--monaco-monospace-font);\n}\n\n.monaco-editor .parameter-hints-widget .signature .parameter.active {\n\tfont-weight: bold;\n}\n\n.monaco-editor .parameter-hints-widget .documentation-parameter > .parameter {\n\tfont-weight: bold;\n\tmargin-right: 0.5em;\n}\n",""]),t.Z=s},30126:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .peekview-widget .head {\n\tbox-sizing: border-box;\n\tdisplay: flex;\n\tjustify-content: space-between;\n\tflex-wrap: nowrap;\n}\n\n.monaco-editor .peekview-widget .head .peekview-title {\n\tdisplay: flex;\n\talign-items: center;\n\tfont-size: 13px;\n\tmargin-left: 20px;\n\tmin-width: 0;\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n}\n\n.monaco-editor .peekview-widget .head .peekview-title.clickable {\n\tcursor: pointer;\n}\n\n.monaco-editor .peekview-widget .head .peekview-title .dirname:not(:empty) {\n\tfont-size: 0.9em;\n\tmargin-left: 0.5em;\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n}\n\n.monaco-editor .peekview-widget .head .peekview-title .meta {\n\twhite-space: nowrap;\n\toverflow: hidden;\n\ttext-overflow: ellipsis;\n}\n\n.monaco-editor .peekview-widget .head .peekview-title .dirname {\n\twhite-space: nowrap;\n}\n\n.monaco-editor .peekview-widget .head .peekview-title .filename {\n\toverflow: hidden;\n\ttext-overflow: ellipsis;\n\twhite-space: nowrap;\n}\n\n.monaco-editor .peekview-widget .head .peekview-title .meta:not(:empty)::before {\n\tcontent: '-';\n\tpadding: 0 0.3em;\n}\n\n.monaco-editor .peekview-widget .head .peekview-actions {\n\tflex: 1;\n\ttext-align: right;\n\tpadding-right: 2px;\n}\n\n.monaco-editor .peekview-widget .head .peekview-actions > .monaco-action-bar {\n\tdisplay: inline-block;\n}\n\n.monaco-editor .peekview-widget .head .peekview-actions > .monaco-action-bar,\n.monaco-editor .peekview-widget .head .peekview-actions > .monaco-action-bar > .actions-container {\n\theight: 100%;\n}\n\n.monaco-editor .peekview-widget > .body {\n\tborder-top: 1px solid;\n\tposition: relative;\n}\n\n.monaco-editor .peekview-widget .head .peekview-title .codicon {\n\tmargin-right: 4px;\n}\n\n.monaco-editor .peekview-widget .monaco-list .monaco-list-row.focused .codicon {\n\tcolor: inherit !important;\n}\n",""]),t.Z=s},52475:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .rename-box {\n\tz-index: 100;\n\tcolor: inherit;\n}\n\n.monaco-editor .rename-box.preview {\n\tpadding: 3px 3px 0 3px;\n}\n\n.monaco-editor .rename-box .rename-input {\n\tpadding: 3px;\n\twidth: calc(100% - 6px);\n}\n\n.monaco-editor .rename-box .rename-label {\n\tdisplay: none;\n\topacity: .8;\n}\n\n.monaco-editor .rename-box.preview .rename-label {\n\tdisplay: inherit;\n}\n",""]),t.Z=s},16960:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .snippet-placeholder {\n\tmin-width: 2px;\n\toutline-style: solid;\n\toutline-width: 1px;\n\tbackground-color: var(--vscode-editor-snippetTabstopHighlightBackground, transparent);\n\toutline-color: var(--vscode-editor-snippetTabstopHighlightBorder, transparent);\n}\n\n.monaco-editor .finish-snippet-placeholder {\n\toutline-style: solid;\n\toutline-width: 1px;\n\tbackground-color: var(--vscode-editor-snippetFinalTabstopHighlightBackground, transparent);\n\toutline-color: var(--vscode-editor-snippetFinalTabstopHighlightBorder, transparent);\n}\n",""]),t.Z=s},34886:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n/* Suggest widget*/\n\n.monaco-editor .suggest-widget {\n\twidth: 430px;\n\tz-index: 40;\n\tdisplay: flex;\n\tflex-direction: column;\n}\n\n.monaco-editor .suggest-widget.message {\n\tflex-direction: row;\n\talign-items: center;\n}\n\n.monaco-editor .suggest-widget,\n.monaco-editor .suggest-details {\n\tflex: 0 1 auto;\n\twidth: 100%;\n\tborder-style: solid;\n\tborder-width: 1px;\n\tborder-color: var(--vscode-editorSuggestWidget-border);\n\tbackground-color: var(--vscode-editorSuggestWidget-background);\n}\n\n.monaco-editor.hc-black .suggest-widget,\n.monaco-editor.hc-black .suggest-details,\n.monaco-editor.hc-light .suggest-widget,\n.monaco-editor.hc-light .suggest-details {\n\tborder-width: 2px;\n}\n\n/* Styles for status bar part */\n\n\n.monaco-editor .suggest-widget .suggest-status-bar {\n\tbox-sizing: border-box;\n\tdisplay: none;\n\tflex-flow: row nowrap;\n\tjustify-content: space-between;\n\twidth: 100%;\n\tfont-size: 80%;\n\tpadding: 0 4px 0 4px;\n\tborder-top: 1px solid var(--vscode-editorSuggestWidget-border);\n\toverflow: hidden;\n}\n\n.monaco-editor .suggest-widget.with-status-bar .suggest-status-bar {\n\tdisplay: flex;\n}\n\n.monaco-editor .suggest-widget .suggest-status-bar .left {\n\tpadding-right: 8px;\n}\n\n.monaco-editor .suggest-widget.with-status-bar .suggest-status-bar .action-label {\n\tcolor: var(--vscode-editorSuggestWidgetStatus-foreground);\n}\n\n.monaco-editor .suggest-widget.with-status-bar .suggest-status-bar .action-item:not(:last-of-type) .action-label {\n\tmargin-right: 0;\n}\n\n.monaco-editor .suggest-widget.with-status-bar .suggest-status-bar .action-item:not(:last-of-type) .action-label::after {\n\tcontent: ', ';\n\tmargin-right: 0.3em;\n}\n\n.monaco-editor .suggest-widget.with-status-bar .monaco-list .monaco-list-row>.contents>.main>.right>.readMore,\n.monaco-editor .suggest-widget.with-status-bar .monaco-list .monaco-list-row.focused.string-label>.contents>.main>.right>.readMore {\n\tdisplay: none;\n}\n\n.monaco-editor .suggest-widget.with-status-bar:not(.docs-side) .monaco-list .monaco-list-row:hover>.contents>.main>.right.can-expand-details>.details-label {\n\twidth: 100%;\n}\n\n/* Styles for Message element for when widget is loading or is empty */\n\n.monaco-editor .suggest-widget>.message {\n\tpadding-left: 22px;\n}\n\n/** Styles for the list element **/\n\n.monaco-editor .suggest-widget>.tree {\n\theight: 100%;\n\twidth: 100%;\n}\n\n.monaco-editor .suggest-widget .monaco-list {\n\tuser-select: none;\n\t-webkit-user-select: none;\n\t-ms-user-select: none;\n}\n\n/** Styles for each row in the list element **/\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row {\n\tdisplay: flex;\n\t-mox-box-sizing: border-box;\n\tbox-sizing: border-box;\n\tpadding-right: 10px;\n\tbackground-repeat: no-repeat;\n\tbackground-position: 2px 2px;\n\twhite-space: nowrap;\n\tcursor: pointer;\n\ttouch-action: none;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row.focused {\n\tcolor: var(--vscode-editorSuggestWidget-selectedForeground);\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row.focused .codicon {\n\tcolor: var(--vscode-editorSuggestWidget-selectedIconForeground);\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents {\n\tflex: 1;\n\theight: 100%;\n\toverflow: hidden;\n\tpadding-left: 2px;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main {\n\tdisplay: flex;\n\toverflow: hidden;\n\ttext-overflow: ellipsis;\n\twhite-space: pre;\n\tjustify-content: space-between;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.left,\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.right {\n\tdisplay: flex;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row:not(.focused)>.contents>.main .monaco-icon-label {\n\tcolor: var(--vscode-editorSuggestWidget-foreground);\n}\n\n.monaco-editor .suggest-widget:not(.frozen) .monaco-highlighted-label .highlight {\n\tfont-weight: bold;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main .monaco-highlighted-label .highlight {\n\tcolor: var(--vscode-editorSuggestWidget-highlightForeground);\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row.focused>.contents>.main .monaco-highlighted-label .highlight {\n\tcolor: var(--vscode-editorSuggestWidget-focusHighlightForeground);\n}\n\n/** ReadMore Icon styles **/\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.header>.codicon-close,\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.right>.readMore::before {\n\tcolor: inherit;\n\topacity: 1;\n\tfont-size: 14px;\n\tcursor: pointer;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.header>.codicon-close {\n\tposition: absolute;\n\ttop: 6px;\n\tright: 2px;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.header>.codicon-close:hover,\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.right>.readMore:hover {\n\topacity: 1;\n}\n\n/** signature, qualifier, type/details opacity **/\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.right>.details-label {\n\topacity: 0.7;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.left>.signature-label {\n\toverflow: hidden;\n\ttext-overflow: ellipsis;\n\topacity: 0.6;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.left>.qualifier-label {\n\tmargin-left: 12px;\n\topacity: 0.4;\n\tfont-size: 85%;\n\tline-height: initial;\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n\talign-self: center;\n}\n\n/** Type Info and icon next to the label in the focused completion item **/\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.right>.details-label {\n\tfont-size: 85%;\n\tmargin-left: 1.1em;\n\toverflow: hidden;\n\ttext-overflow: ellipsis;\n\twhite-space: nowrap;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.right>.details-label>.monaco-tokenized-source {\n\tdisplay: inline;\n}\n\n/** Details: if using CompletionItem#details, show on focus **/\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.right>.details-label {\n\tdisplay: none;\n}\n\n.monaco-editor .suggest-widget:not(.shows-details) .monaco-list .monaco-list-row.focused>.contents>.main>.right>.details-label {\n\tdisplay: inline;\n}\n\n/** Details: if using CompletionItemLabel#details, always show **/\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row:not(.string-label)>.contents>.main>.right>.details-label,\n.monaco-editor .suggest-widget.docs-side .monaco-list .monaco-list-row.focused:not(.string-label)>.contents>.main>.right>.details-label {\n\tdisplay: inline;\n}\n\n/** Ellipsis on hover **/\n\n.monaco-editor .suggest-widget:not(.docs-side) .monaco-list .monaco-list-row.focused:hover>.contents>.main>.right.can-expand-details>.details-label {\n\twidth: calc(100% - 26px);\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.left {\n\tflex-shrink: 1;\n\tflex-grow: 1;\n\toverflow: hidden;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.left>.monaco-icon-label {\n\tflex-shrink: 0;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row:not(.string-label)>.contents>.main>.left>.monaco-icon-label {\n\tmax-width: 100%;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row.string-label>.contents>.main>.left>.monaco-icon-label {\n\tflex-shrink: 1;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.right {\n\toverflow: hidden;\n\tflex-shrink: 4;\n\tmax-width: 70%;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.right>.readMore {\n\tdisplay: inline-block;\n\tposition: absolute;\n\tright: 10px;\n\twidth: 18px;\n\theight: 18px;\n\tvisibility: hidden;\n}\n\n/** Do NOT display ReadMore when docs is side/below **/\n\n.monaco-editor .suggest-widget.docs-side .monaco-list .monaco-list-row>.contents>.main>.right>.readMore {\n\tdisplay: none !important;\n}\n\n/** Do NOT display ReadMore when using plain CompletionItemLabel (details/documentation might not be resolved) **/\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row.string-label>.contents>.main>.right>.readMore {\n\tdisplay: none;\n}\n\n/** Focused item can show ReadMore, but can't when docs is side/below **/\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row.focused.string-label>.contents>.main>.right>.readMore {\n\tdisplay: inline-block;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row.focused:hover>.contents>.main>.right>.readMore {\n\tvisibility: visible;\n}\n\n/** Styles for each row in the list **/\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row .monaco-icon-label.deprecated {\n\topacity: 0.66;\n\ttext-decoration: unset;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row .monaco-icon-label.deprecated>.monaco-icon-label-container>.monaco-icon-name-container {\n\ttext-decoration: line-through;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row .monaco-icon-label::before {\n\theight: 100%;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row .icon {\n\tdisplay: block;\n\theight: 16px;\n\twidth: 16px;\n\tmargin-left: 2px;\n\tbackground-repeat: no-repeat;\n\tbackground-size: 80%;\n\tbackground-position: center;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row .icon.hide {\n\tdisplay: none;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row .suggest-icon {\n\tdisplay: flex;\n\talign-items: center;\n\tmargin-right: 4px;\n}\n\n.monaco-editor .suggest-widget.no-icons .monaco-list .monaco-list-row .icon,\n.monaco-editor .suggest-widget.no-icons .monaco-list .monaco-list-row .suggest-icon::before {\n\tdisplay: none;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row .icon.customcolor .colorspan {\n\tmargin: 0 0 0 0.3em;\n\tborder: 0.1em solid #000;\n\twidth: 0.7em;\n\theight: 0.7em;\n\tdisplay: inline-block;\n}\n\n/** Styles for the docs of the completion item in focus **/\n\n.monaco-editor .suggest-details-container {\n\tz-index: 41;\n}\n\n.monaco-editor .suggest-details {\n\tdisplay: flex;\n\tflex-direction: column;\n\tcursor: default;\n\tcolor: var(--vscode-editorSuggestWidget-foreground);\n}\n\n.monaco-editor .suggest-details.focused {\n\tborder-color: var(--vscode-focusBorder);\n}\n\n.monaco-editor .suggest-details a {\n\tcolor: var(--vscode-textLink-foreground);\n}\n\n.monaco-editor .suggest-details a:hover {\n\tcolor: var(--vscode-textLink-activeForeground);\n}\n\n.monaco-editor .suggest-details code {\n\tbackground-color: var(--vscode-textCodeBlock-background);\n}\n\n.monaco-editor .suggest-details.no-docs {\n\tdisplay: none;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element {\n\tflex: 1;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body {\n\tbox-sizing: border-box;\n\theight: 100%;\n\twidth: 100%;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.header>.type {\n\tflex: 2;\n\toverflow: hidden;\n\ttext-overflow: ellipsis;\n\topacity: 0.7;\n\twhite-space: pre;\n\tmargin: 0 24px 0 0;\n\tpadding: 4px 0 12px 5px;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.header>.type.auto-wrap {\n\twhite-space: normal;\n\tword-break: break-all;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.docs {\n\tmargin: 0;\n\tpadding: 4px 5px;\n\twhite-space: pre-wrap;\n}\n\n.monaco-editor .suggest-details.no-type>.monaco-scrollable-element>.body>.docs {\n\tmargin-right: 24px;\n\toverflow: hidden;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.docs.markdown-docs {\n\tpadding: 0;\n\twhite-space: initial;\n\tmin-height: calc(1rem + 8px);\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.docs.markdown-docs>div,\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.docs.markdown-docs>span:not(:empty) {\n\tpadding: 4px 5px;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.docs.markdown-docs>div>p:first-child {\n\tmargin-top: 0;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.docs.markdown-docs>div>p:last-child {\n\tmargin-bottom: 0;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.docs.markdown-docs .monaco-tokenized-source {\n\twhite-space: pre;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.docs .code {\n\twhite-space: pre-wrap;\n\tword-wrap: break-word;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.docs.markdown-docs .codicon {\n\tvertical-align: sub;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>p:empty {\n\tdisplay: none;\n}\n\n.monaco-editor .suggest-details code {\n\tborder-radius: 3px;\n\tpadding: 0 0.4em;\n}\n\n.monaco-editor .suggest-details ul {\n\tpadding-left: 20px;\n}\n\n.monaco-editor .suggest-details ol {\n\tpadding-left: 20px;\n}\n\n.monaco-editor .suggest-details p code {\n\tfont-family: var(--monaco-monospace-font);\n}\n",""]),t.Z=s},57199:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.editor-banner {\n\tbox-sizing: border-box;\n\tcursor: default;\n\twidth: 100%;\n\tfont-size: 12px;\n\tdisplay: flex;\n\toverflow: visible;\n\n\theight: 26px;\n\n\tbackground: var(--vscode-banner-background);\n}\n\n\n.editor-banner .icon-container {\n\tdisplay: flex;\n\tflex-shrink: 0;\n\talign-items: center;\n\tpadding: 0 6px 0 10px;\n}\n\n.editor-banner .icon-container.custom-icon {\n\tbackground-repeat: no-repeat;\n\tbackground-position: center center;\n\tbackground-size: 16px;\n\twidth: 16px;\n\tpadding: 0;\n\tmargin: 0 6px 0 10px;\n}\n\n.editor-banner .message-container {\n\tdisplay: flex;\n\talign-items: center;\n\tline-height: 26px;\n\ttext-overflow: ellipsis;\n\twhite-space: nowrap;\n\toverflow: hidden;\n}\n\n.editor-banner .message-container p {\n\tmargin-block-start: 0;\n\tmargin-block-end: 0;\n}\n\n.editor-banner .message-actions-container {\n\tflex-grow: 1;\n\tflex-shrink: 0;\n\tline-height: 26px;\n\tmargin: 0 4px;\n}\n\n.editor-banner .message-actions-container a.monaco-button {\n\twidth: inherit;\n\tmargin: 2px 8px;\n\tpadding: 0px 12px;\n}\n\n.editor-banner .message-actions-container a {\n\tpadding: 3px;\n\tmargin-left: 12px;\n\ttext-decoration: underline;\n}\n\n.editor-banner .action-container {\n\tpadding: 0 10px 0 6px;\n}\n\n.editor-banner {\n\tbackground-color: var(--vscode-banner-background);\n}\n\n.editor-banner,\n.editor-banner .action-container .codicon,\n.editor-banner .message-actions-container .monaco-link {\n\tcolor: var(--vscode-banner-foreground);\n}\n\n.editor-banner .icon-container .codicon {\n\tcolor: var(--vscode-banner-iconForeground);\n}\n",""]),t.Z=s},39705:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .unicode-highlight {\n\tborder: 1px solid var(--vscode-editorUnicodeHighlight-border);\n\tbackground-color: var(--vscode-editorUnicodeHighlight-background);\n\tbox-sizing: border-box;\n}\n",""]),t.Z=s},43126:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n.monaco-editor .zone-widget {\n\tposition: absolute;\n\tz-index: 10;\n}\n\n\n.monaco-editor .zone-widget .zone-widget-container {\n\tborder-top-style: solid;\n\tborder-bottom-style: solid;\n\tborder-top-width: 0;\n\tborder-bottom-width: 0;\n\tposition: relative;\n}\n",""]),t.Z=s},21541:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .accessibilityHelpWidget {\n\tpadding: 10px;\n\tvertical-align: middle;\n\toverflow: scroll;\n}",""]),t.Z=s},45274:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r),a=i(61667),l=i.n(a),c=new URL(i(6161),i.b),d=new URL(i(51096),i.b),u=s()(o()),h=l()(c),g=l()(d);u.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .iPadShowKeyboard {\n\twidth: 58px;\n\tmin-width: 0;\n\theight: 36px;\n\tmin-height: 0;\n\tmargin: 0;\n\tpadding: 0;\n\tposition: absolute;\n\tresize: none;\n\toverflow: hidden;\n\tbackground: url("+h+") center center no-repeat;\n\tborder: 4px solid #F6F6F6;\n\tborder-radius: 4px;\n}\n\n.monaco-editor.vs-dark .iPadShowKeyboard {\n\tbackground: url("+g+") center center no-repeat;\n\tborder: 4px solid #252526;\n}",""]),t.Z=u},10223:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .tokens-inspect-widget {\n\tz-index: 50;\n\tuser-select: text;\n\t-webkit-user-select: text;\n\t-ms-user-select: text;\n\tpadding: 10px;\n}\n\n.tokens-inspect-separator {\n\theight: 1px;\n\tborder: 0;\n}\n\n.monaco-editor .tokens-inspect-widget .tm-token {\n\tfont-family: var(--monaco-monospace-font);\n}\n\n.monaco-editor .tokens-inspect-widget .tm-token-length {\n\tfont-weight: normal;\n\tfont-size: 60%;\n\tfloat: right;\n}\n\n.monaco-editor .tokens-inspect-widget .tm-metadata-table {\n\twidth: 100%;\n}\n\n.monaco-editor .tokens-inspect-widget .tm-metadata-value {\n\tfont-family: var(--monaco-monospace-font);\n\ttext-align: right;\n}\n\n.monaco-editor .tokens-inspect-widget .tm-token-type {\n\tfont-family: var(--monaco-monospace-font);\n}\n",""]),t.Z=s},77078:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.quick-input-widget {\n\tfont-size: 13px;\n}\n\n.quick-input-widget .monaco-highlighted-label .highlight,\n.quick-input-widget .monaco-highlighted-label .highlight {\n\tcolor: #0066BF;\n}\n\n.vs .quick-input-widget .monaco-list-row.focused .monaco-highlighted-label .highlight,\n.vs .quick-input-widget .monaco-list-row.focused .monaco-highlighted-label .highlight {\n\tcolor: #9DDDFF;\n}\n\n.vs-dark .quick-input-widget .monaco-highlighted-label .highlight,\n.vs-dark .quick-input-widget .monaco-highlighted-label .highlight {\n\tcolor: #0097fb;\n}\n\n.hc-black .quick-input-widget .monaco-highlighted-label .highlight,\n.hc-black .quick-input-widget .monaco-highlighted-label .highlight {\n\tcolor: #F38518;\n}\n\n.hc-light .quick-input-widget .monaco-highlighted-label .highlight,\n.hc-light .quick-input-widget .monaco-highlighted-label .highlight {\n\tcolor: #0F4A85;\n}\n\n.monaco-keybinding > .monaco-keybinding-key {\n\tbackground-color: rgba(221, 221, 221, 0.4);\n\tborder: solid 1px rgba(204, 204, 204, 0.4);\n\tborder-bottom-color: rgba(187, 187, 187, 0.4);\n\tbox-shadow: inset 0 -1px 0 rgba(187, 187, 187, 0.4);\n\tcolor: #555;\n}\n\n.hc-black .monaco-keybinding > .monaco-keybinding-key {\n\tbackground-color: transparent;\n\tborder: solid 1px rgb(111, 195, 223);\n\tbox-shadow: none;\n\tcolor: #fff;\n}\n\n.hc-light .monaco-keybinding > .monaco-keybinding-key {\n\tbackground-color: transparent;\n\tborder: solid 1px #0F4A85;\n\tbox-shadow: none;\n\tcolor: #292929;\n}\n\n.vs-dark .monaco-keybinding > .monaco-keybinding-key {\n\tbackground-color: rgba(128, 128, 128, 0.17);\n\tborder: solid 1px rgba(51, 51, 51, 0.6);\n\tborder-bottom-color: rgba(68, 68, 68, 0.6);\n\tbox-shadow: inset 0 -1px 0 rgba(68, 68, 68, 0.6);\n\tcolor: #ccc;\n}\n",""]),t.Z=s},72208:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,'/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n\n/* Default standalone editor fonts */\n.monaco-editor {\n\tfont-family: -apple-system, BlinkMacSystemFont, "Segoe WPC", "Segoe UI", "HelveticaNeue-Light", system-ui, "Ubuntu", "Droid Sans", sans-serif;\n\t--monaco-monospace-font: "SF Mono", Monaco, Menlo, Consolas, "Ubuntu Mono", "Liberation Mono", "DejaVu Sans Mono", "Courier New", monospace;\n}\n\n.monaco-menu .monaco-action-bar.vertical .action-item .action-menu-item:focus .action-label {\n\tstroke-width: 1.2px;\n}\n\n.monaco-editor.vs-dark .monaco-menu .monaco-action-bar.vertical .action-menu-item:focus .action-label,\n.monaco-editor.hc-black .monaco-menu .monaco-action-bar.vertical .action-menu-item:focus .action-label,\n.monaco-editor.hc-light .monaco-menu .monaco-action-bar.vertical .action-menu-item:focus .action-label {\n\tstroke-width: 1.2px;\n}\n\n.monaco-hover p {\n\tmargin: 0;\n}\n\n/* See https://github.com/microsoft/monaco-editor/issues/2168#issuecomment-780078600 */\n.monaco-aria-container {\n\tposition: absolute !important;\n\ttop: 0; /* avoid being placed underneath a sibling element */\n\theight: 1px;\n\twidth: 1px;\n\tmargin: -1px;\n\toverflow: hidden;\n\tpadding: 0;\n\tclip: rect(1px, 1px, 1px, 1px);\n\tclip-path: inset(50%);\n}\n\n/* The hc-black theme is already high contrast optimized */\n.monaco-editor.hc-black,\n.monaco-editor.hc-light {\n\t-ms-high-contrast-adjust: none;\n}\n/* In case the browser goes into high contrast mode and the editor is not configured with the hc-black theme */\n@media screen and (-ms-high-contrast:active) {\n\n\t/* current line highlight */\n\t.monaco-editor.vs .view-overlays .current-line,\n\t.monaco-editor.vs-dark .view-overlays .current-line {\n\t\tborder-color: windowtext !important;\n\t\tborder-left: 0;\n\t\tborder-right: 0;\n\t}\n\n\t/* view cursors */\n\t.monaco-editor.vs .cursor,\n\t.monaco-editor.vs-dark .cursor {\n\t\tbackground-color: windowtext !important;\n\t}\n\t/* dnd target */\n\t.monaco-editor.vs .dnd-target,\n\t.monaco-editor.vs-dark .dnd-target {\n\t\tborder-color: windowtext !important;\n\t}\n\n\t/* selected text background */\n\t.monaco-editor.vs .selected-text,\n\t.monaco-editor.vs-dark .selected-text {\n\t\tbackground-color: highlight !important;\n\t}\n\n\t/* allow the text to have a transparent background. */\n\t.monaco-editor.vs .view-line,\n\t.monaco-editor.vs-dark .view-line {\n\t\t-ms-high-contrast-adjust: none;\n\t}\n\n\t/* text color */\n\t.monaco-editor.vs .view-line span,\n\t.monaco-editor.vs-dark .view-line span {\n\t\tcolor: windowtext !important;\n\t}\n\t/* selected text color */\n\t.monaco-editor.vs .view-line span.inline-selected-text,\n\t.monaco-editor.vs-dark .view-line span.inline-selected-text {\n\t\tcolor: highlighttext !important;\n\t}\n\n\t/* allow decorations */\n\t.monaco-editor.vs .view-overlays,\n\t.monaco-editor.vs-dark .view-overlays {\n\t\t-ms-high-contrast-adjust: none;\n\t}\n\n\t/* various decorations */\n\t.monaco-editor.vs .selectionHighlight,\n\t.monaco-editor.vs-dark .selectionHighlight,\n\t.monaco-editor.vs .wordHighlight,\n\t.monaco-editor.vs-dark .wordHighlight,\n\t.monaco-editor.vs .wordHighlightStrong,\n\t.monaco-editor.vs-dark .wordHighlightStrong,\n\t.monaco-editor.vs .reference-decoration,\n\t.monaco-editor.vs-dark .reference-decoration {\n\t\tborder: 2px dotted highlight !important;\n\t\tbackground: transparent !important;\n\t\tbox-sizing: border-box;\n\t}\n\t.monaco-editor.vs .rangeHighlight,\n\t.monaco-editor.vs-dark .rangeHighlight {\n\t\tbackground: transparent !important;\n\t\tborder: 1px dotted activeborder !important;\n\t\tbox-sizing: border-box;\n\t}\n\t.monaco-editor.vs .bracket-match,\n\t.monaco-editor.vs-dark .bracket-match {\n\t\tborder-color: windowtext !important;\n\t\tbackground: transparent !important;\n\t}\n\n\t/* find widget */\n\t.monaco-editor.vs .findMatch,\n\t.monaco-editor.vs-dark .findMatch,\n\t.monaco-editor.vs .currentFindMatch,\n\t.monaco-editor.vs-dark .currentFindMatch {\n\t\tborder: 2px dotted activeborder !important;\n\t\tbackground: transparent !important;\n\t\tbox-sizing: border-box;\n\t}\n\t.monaco-editor.vs .find-widget,\n\t.monaco-editor.vs-dark .find-widget {\n\t\tborder: 1px solid windowtext;\n\t}\n\n\t/* list - used by suggest widget */\n\t.monaco-editor.vs .monaco-list .monaco-list-row,\n\t.monaco-editor.vs-dark .monaco-list .monaco-list-row {\n\t\t-ms-high-contrast-adjust: none;\n\t\tcolor: windowtext !important;\n\t}\n\t.monaco-editor.vs .monaco-list .monaco-list-row.focused,\n\t.monaco-editor.vs-dark .monaco-list .monaco-list-row.focused {\n\t\tcolor: highlighttext !important;\n\t\tbackground-color: highlight !important;\n\t}\n\t.monaco-editor.vs .monaco-list .monaco-list-row:hover,\n\t.monaco-editor.vs-dark .monaco-list .monaco-list-row:hover {\n\t\tbackground: transparent !important;\n\t\tborder: 1px solid highlight;\n\t\tbox-sizing: border-box;\n\t}\n\n\t/* scrollbars */\n\t.monaco-editor.vs .monaco-scrollable-element > .scrollbar,\n\t.monaco-editor.vs-dark .monaco-scrollable-element > .scrollbar {\n\t\t-ms-high-contrast-adjust: none;\n\t\tbackground: background !important;\n\t\tborder: 1px solid windowtext;\n\t\tbox-sizing: border-box;\n\t}\n\t.monaco-editor.vs .monaco-scrollable-element > .scrollbar > .slider,\n\t.monaco-editor.vs-dark .monaco-scrollable-element > .scrollbar > .slider {\n\t\tbackground: windowtext !important;\n\t}\n\t.monaco-editor.vs .monaco-scrollable-element > .scrollbar > .slider:hover,\n\t.monaco-editor.vs-dark .monaco-scrollable-element > .scrollbar > .slider:hover {\n\t\tbackground: highlight !important;\n\t}\n\t.monaco-editor.vs .monaco-scrollable-element > .scrollbar > .slider.active,\n\t.monaco-editor.vs-dark .monaco-scrollable-element > .scrollbar > .slider.active {\n\t\tbackground: highlight !important;\n\t}\n\n\t/* overview ruler */\n\t.monaco-editor.vs .decorationsOverviewRuler,\n\t.monaco-editor.vs-dark .decorationsOverviewRuler {\n\t\topacity: 0;\n\t}\n\n\t/* minimap */\n\t.monaco-editor.vs .minimap,\n\t.monaco-editor.vs-dark .minimap {\n\t\tdisplay: none;\n\t}\n\n\t/* squiggles */\n\t.monaco-editor.vs .squiggly-d-error,\n\t.monaco-editor.vs-dark .squiggly-d-error {\n\t\tbackground: transparent !important;\n\t\tborder-bottom: 4px double #E47777;\n\t}\n\t.monaco-editor.vs .squiggly-c-warning,\n\t.monaco-editor.vs-dark .squiggly-c-warning {\n\t\tborder-bottom: 4px double #71B771;\n\t}\n\t.monaco-editor.vs .squiggly-b-info,\n\t.monaco-editor.vs-dark .squiggly-b-info {\n\t\tborder-bottom: 4px double #71B771;\n\t}\n\t.monaco-editor.vs .squiggly-a-hint,\n\t.monaco-editor.vs-dark .squiggly-a-hint {\n\t\tborder-bottom: 4px double #6c6c6c;\n\t}\n\n\t/* contextmenu */\n\t.monaco-editor.vs .monaco-menu .monaco-action-bar.vertical .action-menu-item:focus .action-label,\n\t.monaco-editor.vs-dark .monaco-menu .monaco-action-bar.vertical .action-menu-item:focus .action-label {\n\t\t-ms-high-contrast-adjust: none;\n\t\tcolor: highlighttext !important;\n\t\tbackground-color: highlight !important;\n\t}\n\t.monaco-editor.vs .monaco-menu .monaco-action-bar.vertical .action-menu-item:hover .action-label,\n\t.monaco-editor.vs-dark .monaco-menu .monaco-action-bar.vertical .action-menu-item:hover .action-label {\n\t\t-ms-high-contrast-adjust: none;\n\t\tbackground: transparent !important;\n\t\tborder: 1px solid highlight;\n\t\tbox-sizing: border-box;\n\t}\n\n\t/* diff editor */\n\t.monaco-diff-editor.vs .diffOverviewRuler,\n\t.monaco-diff-editor.vs-dark .diffOverviewRuler {\n\t\tdisplay: none;\n\t}\n\t.monaco-editor.vs .line-insert,\n\t.monaco-editor.vs-dark .line-insert,\n\t.monaco-editor.vs .line-delete,\n\t.monaco-editor.vs-dark .line-delete {\n\t\tbackground: transparent !important;\n\t\tborder: 1px solid highlight !important;\n\t\tbox-sizing: border-box;\n\t}\n\t.monaco-editor.vs .char-insert,\n\t.monaco-editor.vs-dark .char-insert,\n\t.monaco-editor.vs .char-delete,\n\t.monaco-editor.vs-dark .char-delete {\n\t\tbackground: transparent !important;\n\t}\n}\n\n/*.monaco-editor.vs [tabindex="0"]:focus {\n\toutline: 1px solid rgba(0, 122, 204, 0.4);\n\toutline-offset: -1px;\n\topacity: 1 !important;\n}\n\n.monaco-editor.vs-dark [tabindex="0"]:focus {\n\toutline: 1px solid rgba(14, 99, 156, 0.6);\n\toutline-offset: -1px;\n\topacity: 1 !important;\n}*/\n',""]),t.Z=s},95861:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-action-bar .action-item.menu-entry .action-label.icon {\n\twidth: 16px;\n\theight: 16px;\n\tbackground-repeat: no-repeat;\n\tbackground-position: 50%;\n\tbackground-size: 16px;\n}\n\n\n.monaco-dropdown-with-default {\n\tdisplay: flex !important;\n\tflex-direction: row;\n\tborder-radius: 5px;\n}\n\n.monaco-dropdown-with-default > .action-container > .action-label {\n\tmargin-right: 0;\n}\n\n.monaco-dropdown-with-default > .action-container.menu-entry > .action-label.icon {\n\twidth: 16px;\n\theight: 16px;\n\tbackground-repeat: no-repeat;\n\tbackground-position: 50%;\n\tbackground-size: 16px;\n}\n\n.monaco-dropdown-with-default > .dropdown-action-container > .monaco-dropdown > .dropdown-label .codicon[class*='codicon-'] {\n\tfont-size: 12px;\n\tpadding-left: 0px;\n\tpadding-right: 0px;\n\tline-height: 16px;\n\tmargin-left: -3px;\n}\n\n.monaco-dropdown-with-default > .dropdown-action-container > .monaco-dropdown > .dropdown-label > .action-label {\n\tdisplay: block;\n\tbackground-size: 16px;\n\tbackground-position: center center;\n\tbackground-repeat: no-repeat;\n}\n",""]),t.Z=s},23645:function(e){"use strict";e.exports=function(e){var t=[];return t.toString=function(){return this.map((function(t){var i="",n=void 0!==t[5];return t[4]&&(i+="@supports (".concat(t[4],") {")),t[2]&&(i+="@media ".concat(t[2]," {")),n&&(i+="@layer".concat(t[5].length>0?" ".concat(t[5]):""," {")),i+=e(t),n&&(i+="}"),t[2]&&(i+="}"),t[4]&&(i+="}"),i})).join("")},t.i=function(e,i,n,o,r){"string"==typeof e&&(e=[[null,e,void 0]]);var s={};if(n)for(var a=0;a<this.length;a++){var l=this[a][0];null!=l&&(s[l]=!0)}for(var c=0;c<e.length;c++){var d=[].concat(e[c]);n&&s[d[0]]||(void 0!==r&&(void 0===d[5]||(d[1]="@layer".concat(d[5].length>0?" ".concat(d[5]):""," {").concat(d[1],"}")),d[5]=r),i&&(d[2]?(d[1]="@media ".concat(d[2]," {").concat(d[1],"}"),d[2]=i):d[2]=i),o&&(d[4]?(d[1]="@supports (".concat(d[4],") {").concat(d[1],"}"),d[4]=o):d[4]="".concat(o)),t.push(d))}},t}},61667:function(e){"use strict";e.exports=function(e,t){return t||(t={}),e?(e=String(e.__esModule?e.default:e),/^['"].*['"]$/.test(e)&&(e=e.slice(1,-1)),t.hash&&(e+=t.hash),/["'() \t\n]|(%20)/.test(e)||t.needQuotes?'"'.concat(e.replace(/"/g,'\\"').replace(/\n/g,"\\n"),'"'):e):e}},8081:function(e){"use strict";e.exports=function(e){return e[1]}},46147:function(e,t){t.features=[{label:"accessibilityHelp",entry:"vs/editor/standalone/browser/accessibilityHelp/accessibilityHelp"},{label:"anchorSelect",entry:"vs/editor/contrib/anchorSelect/browser/anchorSelect"},{label:"bracketMatching",entry:"vs/editor/contrib/bracketMatching/browser/bracketMatching"},{label:"browser",entry:"vs/editor/browser/coreCommands"},{label:"caretOperations",entry:["vs/editor/contrib/caretOperations/browser/caretOperations","vs/editor/contrib/caretOperations/browser/transpose"]},{label:"clipboard",entry:"vs/editor/contrib/clipboard/browser/clipboard"},{label:"codeAction",entry:"vs/editor/contrib/codeAction/browser/codeActionContributions"},{label:"codelens",entry:"vs/editor/contrib/codelens/browser/codelensController"},{label:"colorPicker",entry:"vs/editor/contrib/colorPicker/browser/colorContributions"},{label:"comment",entry:"vs/editor/contrib/comment/browser/comment"},{label:"contextmenu",entry:"vs/editor/contrib/contextmenu/browser/contextmenu"},{label:"copyPaste",entry:"vs/editor/contrib/copyPaste/browser/copyPasteContribution"},{label:"cursorUndo",entry:"vs/editor/contrib/cursorUndo/browser/cursorUndo"},{label:"dnd",entry:"vs/editor/contrib/dnd/browser/dnd"},{label:"documentSymbols",entry:"vs/editor/contrib/documentSymbols/browser/documentSymbols"},{label:"dropIntoEditor",entry:"vs/editor/contrib/dropIntoEditor/browser/dropIntoEditorContribution"},{label:"find",entry:"vs/editor/contrib/find/browser/findController"},{label:"folding",entry:"vs/editor/contrib/folding/browser/folding"},{label:"fontZoom",entry:"vs/editor/contrib/fontZoom/browser/fontZoom"},{label:"format",entry:"vs/editor/contrib/format/browser/formatActions"},{label:"gotoError",entry:"vs/editor/contrib/gotoError/browser/gotoError"},{label:"gotoLine",entry:"vs/editor/standalone/browser/quickAccess/standaloneGotoLineQuickAccess"},{label:"gotoSymbol",entry:["vs/editor/contrib/gotoSymbol/browser/goToCommands","vs/editor/contrib/gotoSymbol/browser/link/goToDefinitionAtPosition"]},{label:"hover",entry:"vs/editor/contrib/hover/browser/hover"},{label:"iPadShowKeyboard",entry:"vs/editor/standalone/browser/iPadShowKeyboard/iPadShowKeyboard"},{label:"inPlaceReplace",entry:"vs/editor/contrib/inPlaceReplace/browser/inPlaceReplace"},{label:"indentation",entry:"vs/editor/contrib/indentation/browser/indentation"},{label:"inlayHints",entry:"vs/editor/contrib/inlayHints/browser/inlayHintsContribution"},{label:"inlineCompletions",entry:"vs/editor/contrib/inlineCompletions/browser/ghostText.contribution"},{label:"inspectTokens",entry:"vs/editor/standalone/browser/inspectTokens/inspectTokens"},{label:"lineSelection",entry:"vs/editor/contrib/lineSelection/browser/lineSelection"},{label:"linesOperations",entry:"vs/editor/contrib/linesOperations/browser/linesOperations"},{label:"linkedEditing",entry:"vs/editor/contrib/linkedEditing/browser/linkedEditing"},{label:"links",entry:"vs/editor/contrib/links/browser/links"},{label:"multicursor",entry:"vs/editor/contrib/multicursor/browser/multicursor"},{label:"parameterHints",entry:"vs/editor/contrib/parameterHints/browser/parameterHints"},{label:"quickCommand",entry:"vs/editor/standalone/browser/quickAccess/standaloneCommandsQuickAccess"},{label:"quickHelp",entry:"vs/editor/standalone/browser/quickAccess/standaloneHelpQuickAccess"},{label:"quickOutline",entry:"vs/editor/standalone/browser/quickAccess/standaloneGotoSymbolQuickAccess"},{label:"readOnlyMessage",entry:"vs/editor/contrib/readOnlyMessage/browser/contribution"},{label:"referenceSearch",entry:"vs/editor/standalone/browser/referenceSearch/standaloneReferenceSearch"},{label:"rename",entry:"vs/editor/contrib/rename/browser/rename"},{label:"smartSelect",entry:"vs/editor/contrib/smartSelect/browser/smartSelect"},{label:"snippet",entry:"vs/editor/contrib/snippet/browser/snippetController2"},{label:"stickyScroll",entry:"vs/editor/contrib/stickyScroll/browser/stickyScroll"},{label:"suggest",entry:["vs/editor/contrib/suggest/browser/suggestController","vs/editor/contrib/suggest/browser/suggestInlineCompletions"]},{label:"toggleHighContrast",entry:"vs/editor/standalone/browser/toggleHighContrast/toggleHighContrast"},{label:"toggleTabFocusMode",entry:"vs/editor/contrib/toggleTabFocusMode/browser/toggleTabFocusMode"},{label:"tokenization",entry:"vs/editor/contrib/tokenization/browser/tokenization"},{label:"unicodeHighlighter",entry:"vs/editor/contrib/unicodeHighlighter/browser/unicodeHighlighter"},{label:"unusualLineTerminators",entry:"vs/editor/contrib/unusualLineTerminators/browser/unusualLineTerminators"},{label:"viewportSemanticTokens",entry:"vs/editor/contrib/viewportSemanticTokens/browser/viewportSemanticTokens"},{label:"wordHighlighter",entry:"vs/editor/contrib/wordHighlighter/browser/wordHighlighter"},{label:"wordOperations",entry:"vs/editor/contrib/wordOperations/browser/wordOperations"},{label:"wordPartOperations",entry:"vs/editor/contrib/wordPartOperations/browser/wordPartOperations"}],t.languages=[{label:"abap",entry:"vs/basic-languages/abap/abap.contribution"},{label:"apex",entry:"vs/basic-languages/apex/apex.contribution"},{label:"azcli",entry:"vs/basic-languages/azcli/azcli.contribution"},{label:"bat",entry:"vs/basic-languages/bat/bat.contribution"},{label:"bicep",entry:"vs/basic-languages/bicep/bicep.contribution"},{label:"cameligo",entry:"vs/basic-languages/cameligo/cameligo.contribution"},{label:"clojure",entry:"vs/basic-languages/clojure/clojure.contribution"},{label:"coffee",entry:"vs/basic-languages/coffee/coffee.contribution"},{label:"cpp",entry:"vs/basic-languages/cpp/cpp.contribution"},{label:"csharp",entry:"vs/basic-languages/csharp/csharp.contribution"},{label:"csp",entry:"vs/basic-languages/csp/csp.contribution"},{label:"css",entry:["vs/basic-languages/css/css.contribution","vs/language/css/monaco.contribution"],worker:{id:"vs/language/css/cssWorker",entry:"vs/language/css/css.worker"}},{label:"cypher",entry:"vs/basic-languages/cypher/cypher.contribution"},{label:"dart",entry:"vs/basic-languages/dart/dart.contribution"},{label:"dockerfile",entry:"vs/basic-languages/dockerfile/dockerfile.contribution"},{label:"ecl",entry:"vs/basic-languages/ecl/ecl.contribution"},{label:"elixir",entry:"vs/basic-languages/elixir/elixir.contribution"},{label:"flow9",entry:"vs/basic-languages/flow9/flow9.contribution"},{label:"freemarker2",entry:"vs/basic-languages/freemarker2/freemarker2.contribution"},{label:"fsharp",entry:"vs/basic-languages/fsharp/fsharp.contribution"},{label:"go",entry:"vs/basic-languages/go/go.contribution"},{label:"graphql",entry:"vs/basic-languages/graphql/graphql.contribution"},{label:"handlebars",entry:"vs/basic-languages/handlebars/handlebars.contribution"},{label:"hcl",entry:"vs/basic-languages/hcl/hcl.contribution"},{label:"html",entry:["vs/basic-languages/html/html.contribution","vs/language/html/monaco.contribution"],worker:{id:"vs/language/html/htmlWorker",entry:"vs/language/html/html.worker"}},{label:"ini",entry:"vs/basic-languages/ini/ini.contribution"},{label:"java",entry:"vs/basic-languages/java/java.contribution"},{label:"javascript",entry:"vs/basic-languages/javascript/javascript.contribution"},{label:"json",entry:"vs/language/json/monaco.contribution",worker:{id:"vs/language/json/jsonWorker",entry:"vs/language/json/json.worker"}},{label:"julia",entry:"vs/basic-languages/julia/julia.contribution"},{label:"kotlin",entry:"vs/basic-languages/kotlin/kotlin.contribution"},{label:"less",entry:"vs/basic-languages/less/less.contribution"},{label:"lexon",entry:"vs/basic-languages/lexon/lexon.contribution"},{label:"liquid",entry:"vs/basic-languages/liquid/liquid.contribution"},{label:"lua",entry:"vs/basic-languages/lua/lua.contribution"},{label:"m3",entry:"vs/basic-languages/m3/m3.contribution"},{label:"markdown",entry:"vs/basic-languages/markdown/markdown.contribution"},{label:"mips",entry:"vs/basic-languages/mips/mips.contribution"},{label:"msdax",entry:"vs/basic-languages/msdax/msdax.contribution"},{label:"mysql",entry:"vs/basic-languages/mysql/mysql.contribution"},{label:"objective-c",entry:"vs/basic-languages/objective-c/objective-c.contribution"},{label:"pascal",entry:"vs/basic-languages/pascal/pascal.contribution"},{label:"pascaligo",entry:"vs/basic-languages/pascaligo/pascaligo.contribution"},{label:"perl",entry:"vs/basic-languages/perl/perl.contribution"},{label:"pgsql",entry:"vs/basic-languages/pgsql/pgsql.contribution"},{label:"php",entry:"vs/basic-languages/php/php.contribution"},{label:"pla",entry:"vs/basic-languages/pla/pla.contribution"},{label:"postiats",entry:"vs/basic-languages/postiats/postiats.contribution"},{label:"powerquery",entry:"vs/basic-languages/powerquery/powerquery.contribution"},{label:"powershell",entry:"vs/basic-languages/powershell/powershell.contribution"},{label:"protobuf",entry:"vs/basic-languages/protobuf/protobuf.contribution"},{label:"pug",entry:"vs/basic-languages/pug/pug.contribution"},{label:"python",entry:"vs/basic-languages/python/python.contribution"},{label:"qsharp",entry:"vs/basic-languages/qsharp/qsharp.contribution"},{label:"r",entry:"vs/basic-languages/r/r.contribution"},{label:"razor",entry:"vs/basic-languages/razor/razor.contribution"},{label:"redis",entry:"vs/basic-languages/redis/redis.contribution"},{label:"redshift",entry:"vs/basic-languages/redshift/redshift.contribution"},{label:"restructuredtext",entry:"vs/basic-languages/restructuredtext/restructuredtext.contribution"},{label:"ruby",entry:"vs/basic-languages/ruby/ruby.contribution"},{label:"rust",entry:"vs/basic-languages/rust/rust.contribution"},{label:"sb",entry:"vs/basic-languages/sb/sb.contribution"},{label:"scala",entry:"vs/basic-languages/scala/scala.contribution"},{label:"scheme",entry:"vs/basic-languages/scheme/scheme.contribution"},{label:"scss",entry:"vs/basic-languages/scss/scss.contribution"},{label:"shell",entry:"vs/basic-languages/shell/shell.contribution"},{label:"solidity",entry:"vs/basic-languages/solidity/solidity.contribution"},{label:"sophia",entry:"vs/basic-languages/sophia/sophia.contribution"},{label:"sparql",entry:"vs/basic-languages/sparql/sparql.contribution"},{label:"sql",entry:"vs/basic-languages/sql/sql.contribution"},{label:"st",entry:"vs/basic-languages/st/st.contribution"},{label:"swift",entry:"vs/basic-languages/swift/swift.contribution"},{label:"systemverilog",entry:"vs/basic-languages/systemverilog/systemverilog.contribution"},{label:"tcl",entry:"vs/basic-languages/tcl/tcl.contribution"},{label:"twig",entry:"vs/basic-languages/twig/twig.contribution"},{label:"typescript",entry:["vs/basic-languages/typescript/typescript.contribution","vs/language/typescript/monaco.contribution"],worker:{id:"vs/language/typescript/tsWorker",entry:"vs/language/typescript/ts.worker"}},{label:"vb",entry:"vs/basic-languages/vb/vb.contribution"},{label:"xml",entry:"vs/basic-languages/xml/xml.contribution"},{label:"yaml",entry:"vs/basic-languages/yaml/yaml.contribution"}]},76736:function(e,t,i){"use strict";i.r(t),i.d(t,{PixelRatio:function(){return c},addMatchMediaChangeListener:function(){return l},getZoomFactor:function(){return d},isAndroid:function(){return _},isChrome:function(){return p},isElectron:function(){return b},isFirefox:function(){return h},isSafari:function(){return m},isStandalone:function(){return v},isWebKit:function(){return g},isWebkitWebView:function(){return f}});var n=i(63801),o=i(68921);class r{constructor(){this._zoomFactor=1}getZoomFactor(){return this._zoomFactor}}r.INSTANCE=new r;class s extends o.Disposable{constructor(){super(),this._onDidChange=this._register(new n.Emitter),this.onDidChange=this._onDidChange.event,this._listener=()=>this._handleChange(!0),this._mediaQueryList=null,this._handleChange(!1)}_handleChange(e){var t;null===(t=this._mediaQueryList)||void 0===t||t.removeEventListener("change",this._listener),this._mediaQueryList=matchMedia(`(resolution: ${window.devicePixelRatio}dppx)`),this._mediaQueryList.addEventListener("change",this._listener),e&&this._onDidChange.fire()}}class a extends o.Disposable{constructor(){super(),this._onDidChange=this._register(new n.Emitter),this.onDidChange=this._onDidChange.event,this._value=this._getPixelRatio();const e=this._register(new s);this._register(e.onDidChange((()=>{this._value=this._getPixelRatio(),this._onDidChange.fire(this._value)})))}get value(){return this._value}_getPixelRatio(){const e=document.createElement("canvas").getContext("2d");return(window.devicePixelRatio||1)/(e.webkitBackingStorePixelRatio||e.mozBackingStorePixelRatio||e.msBackingStorePixelRatio||e.oBackingStorePixelRatio||e.backingStorePixelRatio||1)}}function l(e,t){"string"==typeof e&&(e=window.matchMedia(e)),e.addEventListener("change",t)}const c=new class{constructor(){this._pixelRatioMonitor=null}_getOrCreatePixelRatioMonitor(){return this._pixelRatioMonitor||(this._pixelRatioMonitor=(0,o.markAsSingleton)(new a)),this._pixelRatioMonitor}get value(){return this._getOrCreatePixelRatioMonitor().value}get onDidChange(){return this._getOrCreatePixelRatioMonitor().onDidChange}};function d(){return r.INSTANCE.getZoomFactor()}const u=navigator.userAgent,h=u.indexOf("Firefox")>=0,g=u.indexOf("AppleWebKit")>=0,p=u.indexOf("Chrome")>=0,m=!p&&u.indexOf("Safari")>=0,f=!p&&!m&&g,b=u.indexOf("Electron/")>=0,_=u.indexOf("Android")>=0;let A=!1;if(window.matchMedia){const e=window.matchMedia("(display-mode: standalone)");A=e.matches,l(e,(({matches:e})=>{A=e}))}function v(){return A}},69098:function(e,t,i){"use strict";i.r(t),i.d(t,{BrowserFeatures:function(){return r}});var n=i(76736),o=i(66719);const r={clipboard:{writeText:o.isNative||document.queryCommandSupported&&document.queryCommandSupported("copy")||!!(navigator&&navigator.clipboard&&navigator.clipboard.writeText),readText:o.isNative||!!(navigator&&navigator.clipboard&&navigator.clipboard.readText)},keyboard:o.isNative||n.isStandalone()?0:navigator.keyboard||n.isSafari?1:2,touch:"ontouchstart"in window||navigator.maxTouchPoints>0,pointerEvents:window.PointerEvent&&("ontouchstart"in window||window.navigator.maxTouchPoints>0||navigator.maxTouchPoints>0)}},31160:function(e,t,i){"use strict";i.r(t),i.d(t,{DefaultWorkerFactory:function(){return l}});var n,o=i(66719),r=i(50302);const s=null===(n=window.trustedTypes)||void 0===n?void 0:n.createPolicy("defaultWorkerFactory",{createScriptURL:e=>e});class a{constructor(e,t,i,n,r){this.id=t;const a=function(e){if(o.globals.MonacoEnvironment){if("function"==typeof o.globals.MonacoEnvironment.getWorker)return o.globals.MonacoEnvironment.getWorker("workerMain.js",e);if("function"==typeof o.globals.MonacoEnvironment.getWorkerUrl){const t=o.globals.MonacoEnvironment.getWorkerUrl("workerMain.js",e);return new Worker(s?s.createScriptURL(t):t,{name:e})}}throw new Error("You must define a function MonacoEnvironment.getWorkerUrl or MonacoEnvironment.getWorker")}(i);"function"==typeof a.then?this.worker=a:this.worker=Promise.resolve(a),this.postMessage(e,[]),this.worker.then((e=>{e.onmessage=function(e){n(e.data)},e.onmessageerror=r,"function"==typeof e.addEventListener&&e.addEventListener("error",r)}))}getId(){return this.id}postMessage(e,t){var i;null===(i=this.worker)||void 0===i||i.then((i=>i.postMessage(e,t)))}dispose(){var e;null===(e=this.worker)||void 0===e||e.then((e=>e.terminate())),this.worker=null}}class l{constructor(e){this._label=e,this._webWorkerFailedBeforeError=!1}create(e,t,i){const n=++l.LAST_WORKER_ID;if(this._webWorkerFailedBeforeError)throw this._webWorkerFailedBeforeError;return new a(e,n,this._label||"anonymous"+n,t,(e=>{(0,r.logOnceWebWorkerWarning)(e),this._webWorkerFailedBeforeError=e,i(e)}))}}l.LAST_WORKER_ID=0},65174:function(e,t,i){"use strict";i.r(t),i.d(t,{DataTransfers:function(){return n},StaticDND:function(){return o}});const n={RESOURCES:"ResourceURLs",DOWNLOAD_URL:"DownloadURL",FILES:"Files",TEXT:i(5121).Mimes.text},o={CurrentDragAndDropData:void 0}},96747:function(e,t,i){"use strict";i.r(t),i.d(t,{$:function(){return he},Dimension:function(){return T},DragAndDropObserver:function(){return ye},EventHelper:function(){return te},EventType:function(){return ee},ModifierKeyEmitter:function(){return we},Namespace:function(){return de},StandardWindow:function(){return O},addDisposableGenericMouseDownListener:function(){return C},addDisposableGenericMouseUpListener:function(){return w},addDisposableListener:function(){return f},addStandardDisposableGenericMouseDownListener:function(){return A},addStandardDisposableGenericMouseUpListener:function(){return v},addStandardDisposableListener:function(){return _},animate:function(){return _e},append:function(){return se},asCSSPropertyValue:function(){return ve},asCSSUrl:function(){return Ae},clearNode:function(){return g},computeScreenAwareSize:function(){return fe},createCSSRule:function(){return J},createEventEmitter:function(){return y},createStyleSheet:function(){return $},findParentWithClass:function(){return V},getActiveElement:function(){return G},getClientArea:function(){return D},getComputedStyle:function(){return I},getContentHeight:function(){return z},getContentWidth:function(){return P},getDomNodePagePosition:function(){return R},getDomNodeZoomLevel:function(){return B},getElementsByTagName:function(){return me},getShadowRoot:function(){return j},getTopLeftOffset:function(){return M},getTotalHeight:function(){return H},getTotalWidth:function(){return F},h:function(){return xe},hasParentWithClass:function(){return U},hide:function(){return pe},hookDomPurifyHrefAndSrcSanitizer:function(){return Ce},isAncestor:function(){return W},isHTMLElement:function(){return X},isInDOM:function(){return p},isInShadowDOM:function(){return K},isShadowRoot:function(){return Q},prepend:function(){return ae},removeCSSRulesContainingSelector:function(){return Z},reset:function(){return le},restoreParentsScrollTop:function(){return ne},runAtThisOrScheduleAtNextAnimationFrame:function(){return S},saveParentsScrollTop:function(){return ie},scheduleAtNextAnimationFrame:function(){return x},show:function(){return ge},size:function(){return N},trackFocus:function(){return re},windowOpenNoOpener:function(){return be}});var n=i(76736),o=i(69098),r=i(8769),s=i(5642),a=i(12718),l=i(63801),c=i(9709),d=i(68921),u=i(27952),h=i(66719);function g(e){for(;e.firstChild;)e.firstChild.remove()}function p(e){var t;return null!==(t=null==e?void 0:e.isConnected)&&void 0!==t&&t}class m{constructor(e,t,i,n){this._node=e,this._type=t,this._handler=i,this._options=n||!1,this._node.addEventListener(this._type,this._handler,this._options)}dispose(){this._handler&&(this._node.removeEventListener(this._type,this._handler,this._options),this._node=null,this._handler=null)}}function f(e,t,i,n){return new m(e,t,i,n)}function b(e){return function(t){return e(new s.StandardMouseEvent(t))}}const _=function(e,t,i,n){let o=i;return"click"===t||"mousedown"===t?o=b(i):"keydown"!==t&&"keypress"!==t&&"keyup"!==t||(o=function(e){return function(t){return e(new r.StandardKeyboardEvent(t))}}(i)),f(e,t,o,n)},A=function(e,t,i){return C(e,b(t),i)},v=function(e,t,i){return w(e,b(t),i)};function C(e,t,i){return f(e,h.isIOS&&o.BrowserFeatures.pointerEvents?ee.POINTER_DOWN:ee.MOUSE_DOWN,t,i)}function w(e,t,i){return f(e,h.isIOS&&o.BrowserFeatures.pointerEvents?ee.POINTER_UP:ee.MOUSE_UP,t,i)}function y(e,t,i){let n=null;const o=e=>r.fire(e),r=new l.Emitter({onFirstListenerAdd:()=>{n||(n=new m(e,t,o,i))},onLastListenerRemove:()=>{n&&(n.dispose(),n=null)}});return r}let S,x,E=null;class k{constructor(e,t=0){this._runner=e,this.priority=t,this._canceled=!1}dispose(){this._canceled=!0}execute(){if(!this._canceled)try{this._runner()}catch(e){(0,a.onUnexpectedError)(e)}}static sort(e,t){return t.priority-e.priority}}function I(e){return document.defaultView.getComputedStyle(e,null)}function D(e){if(e!==document.body)return new T(e.clientWidth,e.clientHeight);if(h.isIOS&&window.visualViewport)return new T(window.visualViewport.width,window.visualViewport.height);if(window.innerWidth&&window.innerHeight)return new T(window.innerWidth,window.innerHeight);if(document.body&&document.body.clientWidth&&document.body.clientHeight)return new T(document.body.clientWidth,document.body.clientHeight);if(document.documentElement&&document.documentElement.clientWidth&&document.documentElement.clientHeight)return new T(document.documentElement.clientWidth,document.documentElement.clientHeight);throw new Error("Unable to figure out browser width and height")}!function(){let e=[],t=null,i=!1,n=!1;const o=()=>{for(i=!1,t=e,e=[],n=!0;t.length>0;){t.sort(k.sort);t.shift().execute()}n=!1};x=(t,n=0)=>{const r=new k(t,n);return e.push(r),i||(i=!0,function(e){if(!E){const e=e=>setTimeout((()=>e((new Date).getTime())),0);E=self.requestAnimationFrame||self.msRequestAnimationFrame||self.webkitRequestAnimationFrame||self.mozRequestAnimationFrame||self.oRequestAnimationFrame||e}E.call(self,e)}(o)),r},S=(e,i)=>{if(n){const n=new k(e,i);return t.push(n),n}return x(e,i)}}();class L{static convertToPixels(e,t){return parseFloat(t)||0}static getDimension(e,t,i){const n=I(e);let o="0";return n&&(o=n.getPropertyValue?n.getPropertyValue(t):n.getAttribute(i)),L.convertToPixels(e,o)}static getBorderLeftWidth(e){return L.getDimension(e,"border-left-width","borderLeftWidth")}static getBorderRightWidth(e){return L.getDimension(e,"border-right-width","borderRightWidth")}static getBorderTopWidth(e){return L.getDimension(e,"border-top-width","borderTopWidth")}static getBorderBottomWidth(e){return L.getDimension(e,"border-bottom-width","borderBottomWidth")}static getPaddingLeft(e){return L.getDimension(e,"padding-left","paddingLeft")}static getPaddingRight(e){return L.getDimension(e,"padding-right","paddingRight")}static getPaddingTop(e){return L.getDimension(e,"padding-top","paddingTop")}static getPaddingBottom(e){return L.getDimension(e,"padding-bottom","paddingBottom")}static getMarginLeft(e){return L.getDimension(e,"margin-left","marginLeft")}static getMarginTop(e){return L.getDimension(e,"margin-top","marginTop")}static getMarginRight(e){return L.getDimension(e,"margin-right","marginRight")}static getMarginBottom(e){return L.getDimension(e,"margin-bottom","marginBottom")}}class T{constructor(e,t){this.width=e,this.height=t}with(e=this.width,t=this.height){return e!==this.width||t!==this.height?new T(e,t):this}static is(e){return"object"==typeof e&&"number"==typeof e.height&&"number"==typeof e.width}static lift(e){return e instanceof T?e:new T(e.width,e.height)}static equals(e,t){return e===t||!(!e||!t)&&(e.width===t.width&&e.height===t.height)}}function M(e){let t=e.offsetParent,i=e.offsetTop,n=e.offsetLeft;for(;null!==(e=e.parentNode)&&e!==document.body&&e!==document.documentElement;){i-=e.scrollTop;const o=Q(e)?null:I(e);o&&(n-="rtl"!==o.direction?e.scrollLeft:-e.scrollLeft),e===t&&(n+=L.getBorderLeftWidth(e),i+=L.getBorderTopWidth(e),i+=e.offsetTop,n+=e.offsetLeft,t=e.offsetParent)}return{left:n,top:i}}function N(e,t,i){"number"==typeof t&&(e.style.width=`${t}px`),"number"==typeof i&&(e.style.height=`${i}px`)}function R(e){const t=e.getBoundingClientRect();return{left:t.left+O.scrollX,top:t.top+O.scrollY,width:t.width,height:t.height}}function B(e){let t=e,i=1;do{const e=I(t).zoom;null!=e&&"1"!==e&&(i*=e),t=t.parentElement}while(null!==t&&t!==document.documentElement);return i}T.None=new T(0,0);const O=new class{get scrollX(){return"number"==typeof window.scrollX?window.scrollX:document.body.scrollLeft+document.documentElement.scrollLeft}get scrollY(){return"number"==typeof window.scrollY?window.scrollY:document.body.scrollTop+document.documentElement.scrollTop}};function F(e){const t=L.getMarginLeft(e)+L.getMarginRight(e);return e.offsetWidth+t}function P(e){const t=L.getBorderLeftWidth(e)+L.getBorderRightWidth(e),i=L.getPaddingLeft(e)+L.getPaddingRight(e);return e.offsetWidth-t-i}function z(e){const t=L.getBorderTopWidth(e)+L.getBorderBottomWidth(e),i=L.getPaddingTop(e)+L.getPaddingBottom(e);return e.offsetHeight-t-i}function H(e){const t=L.getMarginTop(e)+L.getMarginBottom(e);return e.offsetHeight+t}function W(e,t){for(;e;){if(e===t)return!0;e=e.parentNode}return!1}function V(e,t,i){for(;e&&e.nodeType===e.ELEMENT_NODE;){if(e.classList.contains(t))return e;if(i)if("string"==typeof i){if(e.classList.contains(i))return null}else if(e===i)return null;e=e.parentNode}return null}function U(e,t,i){return!!V(e,t,i)}function Q(e){return e&&!!e.host&&!!e.mode}function K(e){return!!j(e)}function j(e){for(;e.parentNode;){if(e===document.body)return null;e=e.parentNode}return Q(e)?e:null}function G(){let e=document.activeElement;for(;null==e?void 0:e.shadowRoot;)e=e.shadowRoot.activeElement;return e}function $(e=document.getElementsByTagName("head")[0]){const t=document.createElement("style");return t.type="text/css",t.media="screen",e.appendChild(t),t}let Y=null;function q(){return Y||(Y=$()),Y}function J(e,t,i=q()){i&&t&&i.sheet.insertRule(e+"{"+t+"}",0)}function Z(e,t=q()){if(!t)return;const i=function(e){var t,i;return(null===(t=null==e?void 0:e.sheet)||void 0===t?void 0:t.rules)?e.sheet.rules:(null===(i=null==e?void 0:e.sheet)||void 0===i?void 0:i.cssRules)?e.sheet.cssRules:[]}(t),n=[];for(let t=0;t<i.length;t++){-1!==i[t].selectorText.indexOf(e)&&n.push(t)}for(let e=n.length-1;e>=0;e--)t.sheet.deleteRule(n[e])}function X(e){return"object"==typeof HTMLElement?e instanceof HTMLElement:e&&"object"==typeof e&&1===e.nodeType&&"string"==typeof e.nodeName}const ee={CLICK:"click",AUXCLICK:"auxclick",DBLCLICK:"dblclick",MOUSE_UP:"mouseup",MOUSE_DOWN:"mousedown",MOUSE_OVER:"mouseover",MOUSE_MOVE:"mousemove",MOUSE_OUT:"mouseout",MOUSE_ENTER:"mouseenter",MOUSE_LEAVE:"mouseleave",MOUSE_WHEEL:"wheel",POINTER_UP:"pointerup",POINTER_DOWN:"pointerdown",POINTER_MOVE:"pointermove",POINTER_LEAVE:"pointerleave",CONTEXT_MENU:"contextmenu",WHEEL:"wheel",KEY_DOWN:"keydown",KEY_PRESS:"keypress",KEY_UP:"keyup",LOAD:"load",BEFORE_UNLOAD:"beforeunload",UNLOAD:"unload",PAGE_SHOW:"pageshow",PAGE_HIDE:"pagehide",ABORT:"abort",ERROR:"error",RESIZE:"resize",SCROLL:"scroll",FULLSCREEN_CHANGE:"fullscreenchange",WK_FULLSCREEN_CHANGE:"webkitfullscreenchange",SELECT:"select",CHANGE:"change",SUBMIT:"submit",RESET:"reset",FOCUS:"focus",FOCUS_IN:"focusin",FOCUS_OUT:"focusout",BLUR:"blur",INPUT:"input",STORAGE:"storage",DRAG_START:"dragstart",DRAG:"drag",DRAG_ENTER:"dragenter",DRAG_LEAVE:"dragleave",DRAG_OVER:"dragover",DROP:"drop",DRAG_END:"dragend",ANIMATION_START:n.isWebKit?"webkitAnimationStart":"animationstart",ANIMATION_END:n.isWebKit?"webkitAnimationEnd":"animationend",ANIMATION_ITERATION:n.isWebKit?"webkitAnimationIteration":"animationiteration"},te={stop:function(e,t){e.preventDefault?e.preventDefault():e.returnValue=!1,t&&(e.stopPropagation?e.stopPropagation():e.cancelBubble=!0)}};function ie(e){const t=[];for(let i=0;e&&e.nodeType===e.ELEMENT_NODE;i++)t[i]=e.scrollTop,e=e.parentNode;return t}function ne(e,t){for(let i=0;e&&e.nodeType===e.ELEMENT_NODE;i++)e.scrollTop!==t[i]&&(e.scrollTop=t[i]),e=e.parentNode}class oe extends d.Disposable{constructor(e){super(),this._onDidFocus=this._register(new l.Emitter),this.onDidFocus=this._onDidFocus.event,this._onDidBlur=this._register(new l.Emitter),this.onDidBlur=this._onDidBlur.event;let t=oe.hasFocusWithin(e),i=!1;const n=()=>{i=!1,t||(t=!0,this._onDidFocus.fire())},o=()=>{t&&(i=!0,window.setTimeout((()=>{i&&(i=!1,t=!1,this._onDidBlur.fire())}),0))};this._refreshStateHandler=()=>{oe.hasFocusWithin(e)!==t&&(t?o():n())},this._register(f(e,ee.FOCUS,n,!0)),this._register(f(e,ee.BLUR,o,!0)),this._register(f(e,ee.FOCUS_IN,(()=>this._refreshStateHandler()))),this._register(f(e,ee.FOCUS_OUT,(()=>this._refreshStateHandler())))}static hasFocusWithin(e){const t=j(e);return W(t?t.activeElement:document.activeElement,e)}}function re(e){return new oe(e)}function se(e,...t){if(e.append(...t),1===t.length&&"string"!=typeof t[0])return t[0]}function ae(e,t){return e.insertBefore(t,e.firstChild),t}function le(e,...t){e.innerText="",se(e,...t)}const ce=/([\w\-]+)?(#([\w\-]+))?((\.([\w\-]+))*)/;var de;function ue(e,t,i,...n){const o=ce.exec(t);if(!o)throw new Error("Bad use of emmet");i=Object.assign({},i||{});const r=o[1]||"div";let s;return s=e!==de.HTML?document.createElementNS(e,r):document.createElement(r),o[3]&&(s.id=o[3]),o[4]&&(s.className=o[4].replace(/\./g," ").trim()),Object.keys(i).forEach((e=>{const t=i[e];void 0!==t&&(/^on\w+$/.test(e)?s[e]=t:"selected"===e?t&&s.setAttribute(e,"true"):s.setAttribute(e,t))})),s.append(...n),s}function he(e,t,...i){return ue(de.HTML,e,t,...i)}function ge(...e){for(const t of e)t.style.display="",t.removeAttribute("aria-hidden")}function pe(...e){for(const t of e)t.style.display="none",t.setAttribute("aria-hidden","true")}function me(e){return Array.prototype.slice.call(document.getElementsByTagName(e),0)}function fe(e){const t=window.devicePixelRatio*e;return Math.max(1,Math.floor(t))/window.devicePixelRatio}function be(e){window.open(e,"_blank","noopener")}function _e(e){const t=()=>{e(),i=x(t)};let i=x(t);return(0,d.toDisposable)((()=>i.dispose()))}function Ae(e){return e?`url('${u.FileAccess.asBrowserUri(e).toString(!0).replace(/'/g,"%27")}')`:"url('')"}function ve(e){return`'${e.replace(/'/g,"%27")}'`}function Ce(e,t=!1){const i=document.createElement("a");return c.addHook("afterSanitizeAttributes",(n=>{for(const o of["href","src"])if(n.hasAttribute(o)){const r=n.getAttribute(o);if("href"===o&&r.startsWith("#"))continue;if(i.href=r,!e.includes(i.protocol.replace(/:$/,""))){if(t&&"src"===o&&i.href.startsWith("data:"))continue;n.removeAttribute(o)}}})),(0,d.toDisposable)((()=>{c.removeHook("afterSanitizeAttributes")}))}!function(e){e.HTML="http://www.w3.org/1999/xhtml",e.SVG="http://www.w3.org/2000/svg"}(de||(de={})),he.SVG=function(e,t,...i){return ue(de.SVG,e,t,...i)},u.RemoteAuthorities.setPreferredWebSchema(/^https:/.test(window.location.href)?"https":"http");class we extends l.Emitter{constructor(){super(),this._subscriptions=new d.DisposableStore,this._keyStatus={altKey:!1,shiftKey:!1,ctrlKey:!1,metaKey:!1},this._subscriptions.add(f(window,"keydown",(e=>{if(e.defaultPrevented)return;const t=new r.StandardKeyboardEvent(e);if(6!==t.keyCode||!e.repeat){if(e.altKey&&!this._keyStatus.altKey)this._keyStatus.lastKeyPressed="alt";else if(e.ctrlKey&&!this._keyStatus.ctrlKey)this._keyStatus.lastKeyPressed="ctrl";else if(e.metaKey&&!this._keyStatus.metaKey)this._keyStatus.lastKeyPressed="meta";else if(e.shiftKey&&!this._keyStatus.shiftKey)this._keyStatus.lastKeyPressed="shift";else{if(6===t.keyCode)return;this._keyStatus.lastKeyPressed=void 0}this._keyStatus.altKey=e.altKey,this._keyStatus.ctrlKey=e.ctrlKey,this._keyStatus.metaKey=e.metaKey,this._keyStatus.shiftKey=e.shiftKey,this._keyStatus.lastKeyPressed&&(this._keyStatus.event=e,this.fire(this._keyStatus))}}),!0)),this._subscriptions.add(f(window,"keyup",(e=>{e.defaultPrevented||(!e.altKey&&this._keyStatus.altKey?this._keyStatus.lastKeyReleased="alt":!e.ctrlKey&&this._keyStatus.ctrlKey?this._keyStatus.lastKeyReleased="ctrl":!e.metaKey&&this._keyStatus.metaKey?this._keyStatus.lastKeyReleased="meta":!e.shiftKey&&this._keyStatus.shiftKey?this._keyStatus.lastKeyReleased="shift":this._keyStatus.lastKeyReleased=void 0,this._keyStatus.lastKeyPressed!==this._keyStatus.lastKeyReleased&&(this._keyStatus.lastKeyPressed=void 0),this._keyStatus.altKey=e.altKey,this._keyStatus.ctrlKey=e.ctrlKey,this._keyStatus.metaKey=e.metaKey,this._keyStatus.shiftKey=e.shiftKey,this._keyStatus.lastKeyReleased&&(this._keyStatus.event=e,this.fire(this._keyStatus)))}),!0)),this._subscriptions.add(f(document.body,"mousedown",(()=>{this._keyStatus.lastKeyPressed=void 0}),!0)),this._subscriptions.add(f(document.body,"mouseup",(()=>{this._keyStatus.lastKeyPressed=void 0}),!0)),this._subscriptions.add(f(document.body,"mousemove",(e=>{e.buttons&&(this._keyStatus.lastKeyPressed=void 0)}),!0)),this._subscriptions.add(f(window,"blur",(()=>{this.resetKeyStatus()})))}get keyStatus(){return this._keyStatus}resetKeyStatus(){this.doResetKeyStatus(),this.fire(this._keyStatus)}doResetKeyStatus(){this._keyStatus={altKey:!1,shiftKey:!1,ctrlKey:!1,metaKey:!1}}static getInstance(){return we.instance||(we.instance=new we),we.instance}dispose(){super.dispose(),this._subscriptions.dispose()}}class ye extends d.Disposable{constructor(e,t){super(),this.element=e,this.callbacks=t,this.counter=0,this.dragStartTime=0,this.registerListeners()}registerListeners(){this._register(f(this.element,ee.DRAG_ENTER,(e=>{this.counter++,this.dragStartTime=e.timeStamp,this.callbacks.onDragEnter(e)}))),this._register(f(this.element,ee.DRAG_OVER,(e=>{var t,i;e.preventDefault(),null===(i=(t=this.callbacks).onDragOver)||void 0===i||i.call(t,e,e.timeStamp-this.dragStartTime)}))),this._register(f(this.element,ee.DRAG_LEAVE,(e=>{this.counter--,0===this.counter&&(this.dragStartTime=0,this.callbacks.onDragLeave(e))}))),this._register(f(this.element,ee.DRAG_END,(e=>{this.counter=0,this.dragStartTime=0,this.callbacks.onDragEnd(e)}))),this._register(f(this.element,ee.DROP,(e=>{this.counter=0,this.dragStartTime=0,this.callbacks.onDrop(e)})))}}const Se=/(?<tag>[\w\-]+)?(?:#(?<id>[\w\-]+))?(?<class>(?:\.(?:[\w\-]+))*)(?:@(?<name>(?:[\w\_])+))?/;function xe(e,...t){let i,n;Array.isArray(t[0])?(i={},n=t[0]):(i=t[0]||{},n=t[1]);const o=Se.exec(e);if(!o||!o.groups)throw new Error("Bad use of h");const r=o.groups.tag||"div",s=document.createElement(r);o.groups.id&&(s.id=o.groups.id),o.groups.class&&(s.className=o.groups.class.replace(/\./g," ").trim());const a={};if(o.groups.name&&(a[o.groups.name]=s),n)for(const e of n)e instanceof HTMLElement?s.appendChild(e):"string"==typeof e?s.append(e):(Object.assign(a,e),s.appendChild(e.root));for(const[e,t]of Object.entries(i))if("style"===e)for(const[e,i]of Object.entries(t))s.style.setProperty(Ee(e),"number"==typeof i?i+"px":""+i);else"tabIndex"===e?s.tabIndex=t:s.setAttribute(Ee(e),t.toString());return a.root=s,a}function Ee(e){return e.replace(/([a-z])([A-Z])/g,"$1-$2").toLowerCase()}},9709:function(e,t,i){"use strict";i.r(t),i.d(t,{addHook:function(){return oe},clearConfig:function(){return ie},isSupported:function(){return X},isValidAttribute:function(){return ne},removeAllHooks:function(){return ae},removeHook:function(){return re},removeHooks:function(){return se},sanitize:function(){return ee},setConfig:function(){return te},version:function(){return Z}});var n=Object.hasOwnProperty,o=Object.setPrototypeOf,r=Object.isFrozen,s=Object.getPrototypeOf,a=Object.getOwnPropertyDescriptor,l=Object.freeze,c=Object.seal,d=Object.create,u="undefined"!=typeof Reflect&&Reflect,h=u.apply,g=u.construct;h||(h=function(e,t,i){return e.apply(t,i)}),l||(l=function(e){return e}),c||(c=function(e){return e}),g||(g=function(e,t){return new(Function.prototype.bind.apply(e,[null].concat(
/*! @license DOMPurify 2.3.1 | (c) Cure53 and other contributors | Released under the Apache license 2.0 and Mozilla Public License 2.0 | github.com/cure53/DOMPurify/blob/2.3.1/LICENSE */
function(e){if(Array.isArray(e)){for(var t=0,i=Array(e.length);t<e.length;t++)i[t]=e[t];return i}return Array.from(e)}(t))))});var p,m=x(Array.prototype.forEach),f=x(Array.prototype.pop),b=x(Array.prototype.push),_=x(String.prototype.toLowerCase),A=x(String.prototype.match),v=x(String.prototype.replace),C=x(String.prototype.indexOf),w=x(String.prototype.trim),y=x(RegExp.prototype.test),S=(p=TypeError,function(){for(var e=arguments.length,t=Array(e),i=0;i<e;i++)t[i]=arguments[i];return g(p,t)});function x(e){return function(t){for(var i=arguments.length,n=Array(i>1?i-1:0),o=1;o<i;o++)n[o-1]=arguments[o];return h(e,t,n)}}function E(e,t){o&&o(e,null);for(var i=t.length;i--;){var n=t[i];if("string"==typeof n){var s=_(n);s!==n&&(r(t)||(t[i]=s),n=s)}e[n]=!0}return e}function k(e){var t=d(null),i=void 0;for(i in e)h(n,e,[i])&&(t[i]=e[i]);return t}function I(e,t){for(;null!==e;){var i=a(e,t);if(i){if(i.get)return x(i.get);if("function"==typeof i.value)return x(i.value)}e=s(e)}return function(e){return console.warn("fallback value for",e),null}}var D=l(["a","abbr","acronym","address","area","article","aside","audio","b","bdi","bdo","big","blink","blockquote","body","br","button","canvas","caption","center","cite","code","col","colgroup","content","data","datalist","dd","decorator","del","details","dfn","dialog","dir","div","dl","dt","element","em","fieldset","figcaption","figure","font","footer","form","h1","h2","h3","h4","h5","h6","head","header","hgroup","hr","html","i","img","input","ins","kbd","label","legend","li","main","map","mark","marquee","menu","menuitem","meter","nav","nobr","ol","optgroup","option","output","p","picture","pre","progress","q","rp","rt","ruby","s","samp","section","select","shadow","small","source","spacer","span","strike","strong","style","sub","summary","sup","table","tbody","td","template","textarea","tfoot","th","thead","time","tr","track","tt","u","ul","var","video","wbr"]),L=l(["svg","a","altglyph","altglyphdef","altglyphitem","animatecolor","animatemotion","animatetransform","circle","clippath","defs","desc","ellipse","filter","font","g","glyph","glyphref","hkern","image","line","lineargradient","marker","mask","metadata","mpath","path","pattern","polygon","polyline","radialgradient","rect","stop","style","switch","symbol","text","textpath","title","tref","tspan","view","vkern"]),T=l(["feBlend","feColorMatrix","feComponentTransfer","feComposite","feConvolveMatrix","feDiffuseLighting","feDisplacementMap","feDistantLight","feFlood","feFuncA","feFuncB","feFuncG","feFuncR","feGaussianBlur","feMerge","feMergeNode","feMorphology","feOffset","fePointLight","feSpecularLighting","feSpotLight","feTile","feTurbulence"]),M=l(["animate","color-profile","cursor","discard","fedropshadow","feimage","font-face","font-face-format","font-face-name","font-face-src","font-face-uri","foreignobject","hatch","hatchpath","mesh","meshgradient","meshpatch","meshrow","missing-glyph","script","set","solidcolor","unknown","use"]),N=l(["math","menclose","merror","mfenced","mfrac","mglyph","mi","mlabeledtr","mmultiscripts","mn","mo","mover","mpadded","mphantom","mroot","mrow","ms","mspace","msqrt","mstyle","msub","msup","msubsup","mtable","mtd","mtext","mtr","munder","munderover"]),R=l(["maction","maligngroup","malignmark","mlongdiv","mscarries","mscarry","msgroup","mstack","msline","msrow","semantics","annotation","annotation-xml","mprescripts","none"]),B=l(["#text"]),O=l(["accept","action","align","alt","autocapitalize","autocomplete","autopictureinpicture","autoplay","background","bgcolor","border","capture","cellpadding","cellspacing","checked","cite","class","clear","color","cols","colspan","controls","controlslist","coords","crossorigin","datetime","decoding","default","dir","disabled","disablepictureinpicture","disableremoteplayback","download","draggable","enctype","enterkeyhint","face","for","headers","height","hidden","high","href","hreflang","id","inputmode","integrity","ismap","kind","label","lang","list","loading","loop","low","max","maxlength","media","method","min","minlength","multiple","muted","name","noshade","novalidate","nowrap","open","optimum","pattern","placeholder","playsinline","poster","preload","pubdate","radiogroup","readonly","rel","required","rev","reversed","role","rows","rowspan","spellcheck","scope","selected","shape","size","sizes","span","srclang","start","src","srcset","step","style","summary","tabindex","title","translate","type","usemap","valign","value","width","xmlns","slot"]),F=l(["accent-height","accumulate","additive","alignment-baseline","ascent","attributename","attributetype","azimuth","basefrequency","baseline-shift","begin","bias","by","class","clip","clippathunits","clip-path","clip-rule","color","color-interpolation","color-interpolation-filters","color-profile","color-rendering","cx","cy","d","dx","dy","diffuseconstant","direction","display","divisor","dur","edgemode","elevation","end","fill","fill-opacity","fill-rule","filter","filterunits","flood-color","flood-opacity","font-family","font-size","font-size-adjust","font-stretch","font-style","font-variant","font-weight","fx","fy","g1","g2","glyph-name","glyphref","gradientunits","gradienttransform","height","href","id","image-rendering","in","in2","k","k1","k2","k3","k4","kerning","keypoints","keysplines","keytimes","lang","lengthadjust","letter-spacing","kernelmatrix","kernelunitlength","lighting-color","local","marker-end","marker-mid","marker-start","markerheight","markerunits","markerwidth","maskcontentunits","maskunits","max","mask","media","method","mode","min","name","numoctaves","offset","operator","opacity","order","orient","orientation","origin","overflow","paint-order","path","pathlength","patterncontentunits","patterntransform","patternunits","points","preservealpha","preserveaspectratio","primitiveunits","r","rx","ry","radius","refx","refy","repeatcount","repeatdur","restart","result","rotate","scale","seed","shape-rendering","specularconstant","specularexponent","spreadmethod","startoffset","stddeviation","stitchtiles","stop-color","stop-opacity","stroke-dasharray","stroke-dashoffset","stroke-linecap","stroke-linejoin","stroke-miterlimit","stroke-opacity","stroke","stroke-width","style","surfacescale","systemlanguage","tabindex","targetx","targety","transform","text-anchor","text-decoration","text-rendering","textlength","type","u1","u2","unicode","values","viewbox","visibility","version","vert-adv-y","vert-origin-x","vert-origin-y","width","word-spacing","wrap","writing-mode","xchannelselector","ychannelselector","x","x1","x2","xmlns","y","y1","y2","z","zoomandpan"]),P=l(["accent","accentunder","align","bevelled","close","columnsalign","columnlines","columnspan","denomalign","depth","dir","display","displaystyle","encoding","fence","frame","height","href","id","largeop","length","linethickness","lspace","lquote","mathbackground","mathcolor","mathsize","mathvariant","maxsize","minsize","movablelimits","notation","numalign","open","rowalign","rowlines","rowspacing","rowspan","rspace","rquote","scriptlevel","scriptminsize","scriptsizemultiplier","selection","separator","separators","stretchy","subscriptshift","supscriptshift","symmetric","voffset","width","xmlns"]),z=l(["xlink:href","xml:id","xlink:title","xml:space","xmlns:xlink"]),H=c(/\{\{[\s\S]*|[\s\S]*\}\}/gm),W=c(/<%[\s\S]*|[\s\S]*%>/gm),V=c(/^data-[\-\w.\u00B7-\uFFFF]/),U=c(/^aria-[\-\w]+$/),Q=c(/^(?:(?:(?:f|ht)tps?|mailto|tel|callto|cid|xmpp):|[^a-z]|[a-z+.\-]+(?:[^a-z+.\-:]|$))/i),K=c(/^(?:\w+script|data):/i),j=c(/[\u0000-\u0020\u00A0\u1680\u180E\u2000-\u2029\u205F\u3000]/g),G="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e};function $(e){if(Array.isArray(e)){for(var t=0,i=Array(e.length);t<e.length;t++)i[t]=e[t];return i}return Array.from(e)}var Y=function(){return"undefined"==typeof window?null:window},q=function(e,t){if("object"!==(void 0===e?"undefined":G(e))||"function"!=typeof e.createPolicy)return null;var i=null,n="data-tt-policy-suffix";t.currentScript&&t.currentScript.hasAttribute(n)&&(i=t.currentScript.getAttribute(n));var o="dompurify"+(i?"#"+i:"");try{return e.createPolicy(o,{createHTML:function(e){return e}})}catch(e){return console.warn("TrustedTypes policy "+o+" could not be created."),null}};var J=function e(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:Y(),i=function(t){return e(t)};if(i.version="2.3.1",i.removed=[],!t||!t.document||9!==t.document.nodeType)return i.isSupported=!1,i;var n=t.document,o=t.document,r=t.DocumentFragment,s=t.HTMLTemplateElement,a=t.Node,c=t.Element,d=t.NodeFilter,u=t.NamedNodeMap,h=void 0===u?t.NamedNodeMap||t.MozNamedAttrMap:u,g=t.Text,p=t.Comment,x=t.DOMParser,J=t.trustedTypes,Z=c.prototype,X=I(Z,"cloneNode"),ee=I(Z,"nextSibling"),te=I(Z,"childNodes"),ie=I(Z,"parentNode");if("function"==typeof s){var ne=o.createElement("template");ne.content&&ne.content.ownerDocument&&(o=ne.content.ownerDocument)}var oe=q(J,n),re=oe&&Fe?oe.createHTML(""):"",se=o,ae=se.implementation,le=se.createNodeIterator,ce=se.createDocumentFragment,de=se.getElementsByTagName,ue=n.importNode,he={};try{he=k(o).documentMode?o.documentMode:{}}catch(e){}var ge={};i.isSupported="function"==typeof ie&&ae&&void 0!==ae.createHTMLDocument&&9!==he;var pe=H,me=W,fe=V,be=U,_e=K,Ae=j,ve=Q,Ce=null,we=E({},[].concat($(D),$(L),$(T),$(N),$(B))),ye=null,Se=E({},[].concat($(O),$(F),$(P),$(z))),xe=null,Ee=null,ke=!0,Ie=!0,De=!1,Le=!1,Te=!1,Me=!1,Ne=!1,Re=!1,Be=!1,Oe=!0,Fe=!1,Pe=!0,ze=!0,He=!1,We={},Ve=null,Ue=E({},["annotation-xml","audio","colgroup","desc","foreignobject","head","iframe","math","mi","mn","mo","ms","mtext","noembed","noframes","noscript","plaintext","script","style","svg","template","thead","title","video","xmp"]),Qe=null,Ke=E({},["audio","video","img","source","image","track"]),je=null,Ge=E({},["alt","class","for","id","label","name","pattern","placeholder","role","summary","title","value","style","xmlns"]),$e="http://www.w3.org/1998/Math/MathML",Ye="http://www.w3.org/2000/svg",qe="http://www.w3.org/1999/xhtml",Je=qe,Ze=!1,Xe=null,et=o.createElement("form"),tt=function(e){Xe&&Xe===e||(e&&"object"===(void 0===e?"undefined":G(e))||(e={}),e=k(e),Ce="ALLOWED_TAGS"in e?E({},e.ALLOWED_TAGS):we,ye="ALLOWED_ATTR"in e?E({},e.ALLOWED_ATTR):Se,je="ADD_URI_SAFE_ATTR"in e?E(k(Ge),e.ADD_URI_SAFE_ATTR):Ge,Qe="ADD_DATA_URI_TAGS"in e?E(k(Ke),e.ADD_DATA_URI_TAGS):Ke,Ve="FORBID_CONTENTS"in e?E({},e.FORBID_CONTENTS):Ue,xe="FORBID_TAGS"in e?E({},e.FORBID_TAGS):{},Ee="FORBID_ATTR"in e?E({},e.FORBID_ATTR):{},We="USE_PROFILES"in e&&e.USE_PROFILES,ke=!1!==e.ALLOW_ARIA_ATTR,Ie=!1!==e.ALLOW_DATA_ATTR,De=e.ALLOW_UNKNOWN_PROTOCOLS||!1,Le=e.SAFE_FOR_TEMPLATES||!1,Te=e.WHOLE_DOCUMENT||!1,Re=e.RETURN_DOM||!1,Be=e.RETURN_DOM_FRAGMENT||!1,Oe=!1!==e.RETURN_DOM_IMPORT,Fe=e.RETURN_TRUSTED_TYPE||!1,Ne=e.FORCE_BODY||!1,Pe=!1!==e.SANITIZE_DOM,ze=!1!==e.KEEP_CONTENT,He=e.IN_PLACE||!1,ve=e.ALLOWED_URI_REGEXP||ve,Je=e.NAMESPACE||qe,Le&&(Ie=!1),Be&&(Re=!0),We&&(Ce=E({},[].concat($(B))),ye=[],!0===We.html&&(E(Ce,D),E(ye,O)),!0===We.svg&&(E(Ce,L),E(ye,F),E(ye,z)),!0===We.svgFilters&&(E(Ce,T),E(ye,F),E(ye,z)),!0===We.mathMl&&(E(Ce,N),E(ye,P),E(ye,z))),e.ADD_TAGS&&(Ce===we&&(Ce=k(Ce)),E(Ce,e.ADD_TAGS)),e.ADD_ATTR&&(ye===Se&&(ye=k(ye)),E(ye,e.ADD_ATTR)),e.ADD_URI_SAFE_ATTR&&E(je,e.ADD_URI_SAFE_ATTR),e.FORBID_CONTENTS&&(Ve===Ue&&(Ve=k(Ve)),E(Ve,e.FORBID_CONTENTS)),ze&&(Ce["#text"]=!0),Te&&E(Ce,["html","head","body"]),Ce.table&&(E(Ce,["tbody"]),delete xe.tbody),l&&l(e),Xe=e)},it=E({},["mi","mo","mn","ms","mtext"]),nt=E({},["foreignobject","desc","title","annotation-xml"]),ot=E({},L);E(ot,T),E(ot,M);var rt=E({},N);E(rt,R);var st=function(e){var t=ie(e);t&&t.tagName||(t={namespaceURI:qe,tagName:"template"});var i=_(e.tagName),n=_(t.tagName);if(e.namespaceURI===Ye)return t.namespaceURI===qe?"svg"===i:t.namespaceURI===$e?"svg"===i&&("annotation-xml"===n||it[n]):Boolean(ot[i]);if(e.namespaceURI===$e)return t.namespaceURI===qe?"math"===i:t.namespaceURI===Ye?"math"===i&&nt[n]:Boolean(rt[i]);if(e.namespaceURI===qe){if(t.namespaceURI===Ye&&!nt[n])return!1;if(t.namespaceURI===$e&&!it[n])return!1;var o=E({},["title","style","font","a","script"]);return!rt[i]&&(o[i]||!ot[i])}return!1},at=function(e){b(i.removed,{element:e});try{e.parentNode.removeChild(e)}catch(t){try{e.outerHTML=re}catch(t){e.remove()}}},lt=function(e,t){try{b(i.removed,{attribute:t.getAttributeNode(e),from:t})}catch(e){b(i.removed,{attribute:null,from:t})}if(t.removeAttribute(e),"is"===e&&!ye[e])if(Re||Be)try{at(t)}catch(e){}else try{t.setAttribute(e,"")}catch(e){}},ct=function(e){var t=void 0,i=void 0;if(Ne)e="<remove></remove>"+e;else{var n=A(e,/^[\r\n\t ]+/);i=n&&n[0]}var r=oe?oe.createHTML(e):e;if(Je===qe)try{t=(new x).parseFromString(r,"text/html")}catch(e){}if(!t||!t.documentElement){t=ae.createDocument(Je,"template",null);try{t.documentElement.innerHTML=Ze?"":r}catch(e){}}var s=t.body||t.documentElement;return e&&i&&s.insertBefore(o.createTextNode(i),s.childNodes[0]||null),Je===qe?de.call(t,Te?"html":"body")[0]:Te?t.documentElement:s},dt=function(e){return le.call(e.ownerDocument||e,e,d.SHOW_ELEMENT|d.SHOW_COMMENT|d.SHOW_TEXT,null,!1)},ut=function(e){return!(e instanceof g||e instanceof p)&&!("string"==typeof e.nodeName&&"string"==typeof e.textContent&&"function"==typeof e.removeChild&&e.attributes instanceof h&&"function"==typeof e.removeAttribute&&"function"==typeof e.setAttribute&&"string"==typeof e.namespaceURI&&"function"==typeof e.insertBefore)},ht=function(e){return"object"===(void 0===a?"undefined":G(a))?e instanceof a:e&&"object"===(void 0===e?"undefined":G(e))&&"number"==typeof e.nodeType&&"string"==typeof e.nodeName},gt=function(e,t,n){ge[e]&&m(ge[e],(function(e){e.call(i,t,n,Xe)}))},pt=function(e){var t=void 0;if(gt("beforeSanitizeElements",e,null),ut(e))return at(e),!0;if(A(e.nodeName,/[\u0080-\uFFFF]/))return at(e),!0;var n=_(e.nodeName);if(gt("uponSanitizeElement",e,{tagName:n,allowedTags:Ce}),!ht(e.firstElementChild)&&(!ht(e.content)||!ht(e.content.firstElementChild))&&y(/<[/\w]/g,e.innerHTML)&&y(/<[/\w]/g,e.textContent))return at(e),!0;if("select"===n&&y(/<template/i,e.innerHTML))return at(e),!0;if(!Ce[n]||xe[n]){if(ze&&!Ve[n]){var o=ie(e)||e.parentNode,r=te(e)||e.childNodes;if(r&&o)for(var s=r.length-1;s>=0;--s)o.insertBefore(X(r[s],!0),ee(e))}return at(e),!0}return e instanceof c&&!st(e)?(at(e),!0):"noscript"!==n&&"noembed"!==n||!y(/<\/no(script|embed)/i,e.innerHTML)?(Le&&3===e.nodeType&&(t=e.textContent,t=v(t,pe," "),t=v(t,me," "),e.textContent!==t&&(b(i.removed,{element:e.cloneNode()}),e.textContent=t)),gt("afterSanitizeElements",e,null),!1):(at(e),!0)},mt=function(e,t,i){if(Pe&&("id"===t||"name"===t)&&(i in o||i in et))return!1;if(Ie&&!Ee[t]&&y(fe,t));else if(ke&&y(be,t));else{if(!ye[t]||Ee[t])return!1;if(je[t]);else if(y(ve,v(i,Ae,"")));else if("src"!==t&&"xlink:href"!==t&&"href"!==t||"script"===e||0!==C(i,"data:")||!Qe[e]){if(De&&!y(_e,v(i,Ae,"")));else if(i)return!1}else;}return!0},ft=function(e){var t=void 0,n=void 0,o=void 0,r=void 0;gt("beforeSanitizeAttributes",e,null);var s=e.attributes;if(s){var a={attrName:"",attrValue:"",keepAttr:!0,allowedAttributes:ye};for(r=s.length;r--;){var l=t=s[r],c=l.name,d=l.namespaceURI;if(n=w(t.value),o=_(c),a.attrName=o,a.attrValue=n,a.keepAttr=!0,a.forceKeepAttr=void 0,gt("uponSanitizeAttribute",e,a),n=a.attrValue,!a.forceKeepAttr&&(lt(c,e),a.keepAttr))if(y(/\/>/i,n))lt(c,e);else{Le&&(n=v(n,pe," "),n=v(n,me," "));var u=e.nodeName.toLowerCase();if(mt(u,o,n))try{d?e.setAttributeNS(d,c,n):e.setAttribute(c,n),f(i.removed)}catch(e){}}}gt("afterSanitizeAttributes",e,null)}},bt=function e(t){var i=void 0,n=dt(t);for(gt("beforeSanitizeShadowDOM",t,null);i=n.nextNode();)gt("uponSanitizeShadowNode",i,null),pt(i)||(i.content instanceof r&&e(i.content),ft(i));gt("afterSanitizeShadowDOM",t,null)};return i.sanitize=function(e,o){var s=void 0,l=void 0,c=void 0,d=void 0,u=void 0;if((Ze=!e)&&(e="\x3c!--\x3e"),"string"!=typeof e&&!ht(e)){if("function"!=typeof e.toString)throw S("toString is not a function");if("string"!=typeof(e=e.toString()))throw S("dirty is not a string, aborting")}if(!i.isSupported){if("object"===G(t.toStaticHTML)||"function"==typeof t.toStaticHTML){if("string"==typeof e)return t.toStaticHTML(e);if(ht(e))return t.toStaticHTML(e.outerHTML)}return e}if(Me||tt(o),i.removed=[],"string"==typeof e&&(He=!1),He);else if(e instanceof a)1===(l=(s=ct("\x3c!----\x3e")).ownerDocument.importNode(e,!0)).nodeType&&"BODY"===l.nodeName||"HTML"===l.nodeName?s=l:s.appendChild(l);else{if(!Re&&!Le&&!Te&&-1===e.indexOf("<"))return oe&&Fe?oe.createHTML(e):e;if(!(s=ct(e)))return Re?null:re}s&&Ne&&at(s.firstChild);for(var h=dt(He?e:s);c=h.nextNode();)3===c.nodeType&&c===d||pt(c)||(c.content instanceof r&&bt(c.content),ft(c),d=c);if(d=null,He)return e;if(Re){if(Be)for(u=ce.call(s.ownerDocument);s.firstChild;)u.appendChild(s.firstChild);else u=s;return Oe&&(u=ue.call(n,u,!0)),u}var g=Te?s.outerHTML:s.innerHTML;return Le&&(g=v(g,pe," "),g=v(g,me," ")),oe&&Fe?oe.createHTML(g):g},i.setConfig=function(e){tt(e),Me=!0},i.clearConfig=function(){Xe=null,Me=!1},i.isValidAttribute=function(e,t,i){Xe||tt({});var n=_(e),o=_(t);return mt(n,o,i)},i.addHook=function(e,t){"function"==typeof t&&(ge[e]=ge[e]||[],b(ge[e],t))},i.removeHook=function(e){ge[e]&&f(ge[e])},i.removeHooks=function(e){ge[e]&&(ge[e]=[])},i.removeAllHooks=function(){ge={}},i}();t.default=J;const Z=J.version,X=J.isSupported,ee=J.sanitize,te=J.setConfig,ie=J.clearConfig,ne=J.isValidAttribute,oe=J.addHook,re=J.removeHook,se=J.removeHooks,ae=J.removeAllHooks},50465:function(e,t,i){"use strict";i.r(t),i.d(t,{DomEmitter:function(){return o},stopEvent:function(){return r}});var n=i(63801);class o{constructor(e,t,i){const o=e=>this.emitter.fire(e);this.emitter=new n.Emitter({onFirstListenerAdd:()=>e.addEventListener(t,o,i),onLastListenerRemove:()=>e.removeEventListener(t,o,i)})}get event(){return this.emitter.event}dispose(){this.emitter.dispose()}}function r(e){return e.preventDefault(),e.stopPropagation(),e}},85297:function(e,t,i){"use strict";i.r(t),i.d(t,{FastDomNode:function(){return n},createFastDomNode:function(){return r}});class n{constructor(e){this.domNode=e,this._maxWidth="",this._width="",this._height="",this._top="",this._left="",this._bottom="",this._right="",this._fontFamily="",this._fontWeight="",this._fontSize="",this._fontStyle="",this._fontFeatureSettings="",this._textDecoration="",this._lineHeight="",this._letterSpacing="",this._className="",this._display="",this._position="",this._visibility="",this._color="",this._backgroundColor="",this._layerHint=!1,this._contain="none",this._boxShadow=""}setMaxWidth(e){const t=o(e);this._maxWidth!==t&&(this._maxWidth=t,this.domNode.style.maxWidth=this._maxWidth)}setWidth(e){const t=o(e);this._width!==t&&(this._width=t,this.domNode.style.width=this._width)}setHeight(e){const t=o(e);this._height!==t&&(this._height=t,this.domNode.style.height=this._height)}setTop(e){const t=o(e);this._top!==t&&(this._top=t,this.domNode.style.top=this._top)}setLeft(e){const t=o(e);this._left!==t&&(this._left=t,this.domNode.style.left=this._left)}setBottom(e){const t=o(e);this._bottom!==t&&(this._bottom=t,this.domNode.style.bottom=this._bottom)}setRight(e){const t=o(e);this._right!==t&&(this._right=t,this.domNode.style.right=this._right)}setFontFamily(e){this._fontFamily!==e&&(this._fontFamily=e,this.domNode.style.fontFamily=this._fontFamily)}setFontWeight(e){this._fontWeight!==e&&(this._fontWeight=e,this.domNode.style.fontWeight=this._fontWeight)}setFontSize(e){const t=o(e);this._fontSize!==t&&(this._fontSize=t,this.domNode.style.fontSize=this._fontSize)}setFontStyle(e){this._fontStyle!==e&&(this._fontStyle=e,this.domNode.style.fontStyle=this._fontStyle)}setFontFeatureSettings(e){this._fontFeatureSettings!==e&&(this._fontFeatureSettings=e,this.domNode.style.fontFeatureSettings=this._fontFeatureSettings)}setTextDecoration(e){this._textDecoration!==e&&(this._textDecoration=e,this.domNode.style.textDecoration=this._textDecoration)}setLineHeight(e){const t=o(e);this._lineHeight!==t&&(this._lineHeight=t,this.domNode.style.lineHeight=this._lineHeight)}setLetterSpacing(e){const t=o(e);this._letterSpacing!==t&&(this._letterSpacing=t,this.domNode.style.letterSpacing=this._letterSpacing)}setClassName(e){this._className!==e&&(this._className=e,this.domNode.className=this._className)}toggleClassName(e,t){this.domNode.classList.toggle(e,t),this._className=this.domNode.className}setDisplay(e){this._display!==e&&(this._display=e,this.domNode.style.display=this._display)}setPosition(e){this._position!==e&&(this._position=e,this.domNode.style.position=this._position)}setVisibility(e){this._visibility!==e&&(this._visibility=e,this.domNode.style.visibility=this._visibility)}setColor(e){this._color!==e&&(this._color=e,this.domNode.style.color=this._color)}setBackgroundColor(e){this._backgroundColor!==e&&(this._backgroundColor=e,this.domNode.style.backgroundColor=this._backgroundColor)}setLayerHinting(e){this._layerHint!==e&&(this._layerHint=e,this.domNode.style.transform=this._layerHint?"translate3d(0px, 0px, 0px)":"")}setBoxShadow(e){this._boxShadow!==e&&(this._boxShadow=e,this.domNode.style.boxShadow=e)}setContain(e){this._contain!==e&&(this._contain=e,this.domNode.style.contain=this._contain)}setAttribute(e,t){this.domNode.setAttribute(e,t)}removeAttribute(e){this.domNode.removeAttribute(e)}appendChild(e){this.domNode.appendChild(e.domNode)}removeChild(e){this.domNode.removeChild(e.domNode)}}function o(e){return"number"==typeof e?`${e}px`:e}function r(e){return new n(e)}},94264:function(e,t,i){"use strict";i.r(t),i.d(t,{createElement:function(){return s},renderFormattedText:function(){return r},renderText:function(){return o}});var n=i(96747);function o(e,t={}){const i=s(t);return i.textContent=e,i}function r(e,t={}){const i=s(t);return l(i,function(e,t){const i={type:1,children:[]};let n=0,o=i;const r=[],s=new a(e);for(;!s.eos();){let e=s.next();const i="\\"===e&&0!==d(s.peek(),t);if(i&&(e=s.next()),!i&&c(e,t)&&e===s.peek()){s.advance(),2===o.type&&(o=r.pop());const i=d(e,t);if(o.type===i||5===o.type&&6===i)o=r.pop();else{const e={type:i,children:[]};5===i&&(e.index=n,n++),o.children.push(e),r.push(o),o=e}}else if("\n"===e)2===o.type&&(o=r.pop()),o.children.push({type:8});else if(2!==o.type){const t={type:2,content:e};o.children.push(t),r.push(o),o=t}else o.content+=e}2===o.type&&(o=r.pop());r.length;return i}(e,!!t.renderCodeSegments),t.actionHandler,t.renderCodeSegments),i}function s(e){const t=e.inline?"span":"div",i=document.createElement(t);return e.className&&(i.className=e.className),i}class a{constructor(e){this.source=e,this.index=0}eos(){return this.index>=this.source.length}next(){const e=this.peek();return this.advance(),e}peek(){return this.source[this.index]}advance(){this.index++}}function l(e,t,i,o){let r;if(2===t.type)r=document.createTextNode(t.content||"");else if(3===t.type)r=document.createElement("b");else if(4===t.type)r=document.createElement("i");else if(7===t.type&&o)r=document.createElement("code");else if(5===t.type&&i){const e=document.createElement("a");i.disposables.add(n.addStandardDisposableListener(e,"click",(e=>{i.callback(String(t.index),e)}))),r=e}else 8===t.type?r=document.createElement("br"):1===t.type&&(r=e);r&&e!==r&&e.appendChild(r),r&&Array.isArray(t.children)&&t.children.forEach((e=>{l(r,e,i,o)}))}function c(e,t){return 0!==d(e,t)}function d(e,t){switch(e){case"*":return 3;case"_":return 4;case"[":return 5;case"]":return 6;case"`":return t?7:0;default:return 0}}},95689:function(e,t,i){"use strict";i.r(t),i.d(t,{GlobalPointerMoveMonitor:function(){return r}});var n=i(96747),o=i(68921);class r{constructor(){this._hooks=new o.DisposableStore,this._pointerMoveCallback=null,this._onStopCallback=null}dispose(){this.stopMonitoring(!1),this._hooks.dispose()}stopMonitoring(e,t){if(!this.isMonitoring())return;this._hooks.clear(),this._pointerMoveCallback=null;const i=this._onStopCallback;this._onStopCallback=null,e&&i&&i(t)}isMonitoring(){return!!this._pointerMoveCallback}startMonitoring(e,t,i,r,s){this.isMonitoring()&&this.stopMonitoring(!1),this._pointerMoveCallback=r,this._onStopCallback=s;let a=e;try{e.setPointerCapture(t),this._hooks.add((0,o.toDisposable)((()=>{e.releasePointerCapture(t)})))}catch(e){a=window}this._hooks.add(n.addDisposableListener(a,n.EventType.POINTER_MOVE,(e=>{e.buttons===i?(e.preventDefault(),this._pointerMoveCallback(e)):this.stopMonitoring(!0)}))),this._hooks.add(n.addDisposableListener(a,n.EventType.POINTER_UP,(e=>this.stopMonitoring(!0))))}}},28132:function(e,t,i){"use strict";i.r(t),i.d(t,{IframeUtils:function(){return s}});let n=!1,o=null;function r(e){if(!e.parent||e.parent===e)return null;try{const t=e.location,i=e.parent.location;if("null"!==t.origin&&"null"!==i.origin&&t.origin!==i.origin)return n=!0,null}catch(e){return n=!0,null}return e.parent}class s{static getSameOriginWindowChain(){if(!o){o=[];let e,t=window;do{e=r(t),e?o.push({window:t,iframeElement:t.frameElement||null}):o.push({window:t,iframeElement:null}),t=e}while(t)}return o.slice(0)}static getPositionOfChildWindowRelativeToAncestorWindow(e,t){if(!t||e===t)return{top:0,left:0};let i=0,n=0;const o=this.getSameOriginWindowChain();for(const e of o){if(i+=e.window.scrollY,n+=e.window.scrollX,e.window===t)break;if(!e.iframeElement)break;const o=e.iframeElement.getBoundingClientRect();i+=o.top,n+=o.left}return{top:i,left:n}}}},8769:function(e,t,i){"use strict";i.r(t),i.d(t,{StandardKeyboardEvent:function(){return c}});var n=i(76736),o=i(98070),r=i(37345),s=i(66719);const a=s.isMacintosh?256:2048,l=s.isMacintosh?2048:256;class c{constructor(e){this._standardKeyboardEventBrand=!0;const t=e;this.browserEvent=t,this.target=t.target,this.ctrlKey=t.ctrlKey,this.shiftKey=t.shiftKey,this.altKey=t.altKey,this.metaKey=t.metaKey,this.keyCode=function(e){if(e.charCode){const t=String.fromCharCode(e.charCode).toUpperCase();return o.KeyCodeUtils.fromString(t)}const t=e.keyCode;if(3===t)return 7;if(n.isFirefox){if(59===t)return 80;if(107===t)return 81;if(109===t)return 83;if(s.isMacintosh&&224===t)return 57}else if(n.isWebKit){if(91===t)return 57;if(s.isMacintosh&&93===t)return 57;if(!s.isMacintosh&&92===t)return 57}return o.EVENT_KEY_CODE_MAP[t]||0}(t),this.code=t.code,this.ctrlKey=this.ctrlKey||5===this.keyCode,this.altKey=this.altKey||6===this.keyCode,this.shiftKey=this.shiftKey||4===this.keyCode,this.metaKey=this.metaKey||57===this.keyCode,this._asKeybinding=this._computeKeybinding(),this._asRuntimeKeybinding=this._computeRuntimeKeybinding()}preventDefault(){this.browserEvent&&this.browserEvent.preventDefault&&this.browserEvent.preventDefault()}stopPropagation(){this.browserEvent&&this.browserEvent.stopPropagation&&this.browserEvent.stopPropagation()}toKeybinding(){return this._asRuntimeKeybinding}equals(e){return this._asKeybinding===e}_computeKeybinding(){let e=0;5!==this.keyCode&&4!==this.keyCode&&6!==this.keyCode&&57!==this.keyCode&&(e=this.keyCode);let t=0;return this.ctrlKey&&(t|=a),this.altKey&&(t|=512),this.shiftKey&&(t|=1024),this.metaKey&&(t|=l),t|=e,t}_computeRuntimeKeybinding(){let e=0;return 5!==this.keyCode&&4!==this.keyCode&&6!==this.keyCode&&57!==this.keyCode&&(e=this.keyCode),new r.SimpleKeybinding(this.ctrlKey,this.shiftKey,this.altKey,this.metaKey,e)}}},5642:function(e,t,i){"use strict";i.r(t),i.d(t,{StandardMouseEvent:function(){return s},StandardWheelEvent:function(){return a}});var n=i(76736),o=i(28132),r=i(66719);class s{constructor(e){this.timestamp=Date.now(),this.browserEvent=e,this.leftButton=0===e.button,this.middleButton=1===e.button,this.rightButton=2===e.button,this.buttons=e.buttons,this.target=e.target,this.detail=e.detail||1,"dblclick"===e.type&&(this.detail=2),this.ctrlKey=e.ctrlKey,this.shiftKey=e.shiftKey,this.altKey=e.altKey,this.metaKey=e.metaKey,"number"==typeof e.pageX?(this.posx=e.pageX,this.posy=e.pageY):(this.posx=e.clientX+document.body.scrollLeft+document.documentElement.scrollLeft,this.posy=e.clientY+document.body.scrollTop+document.documentElement.scrollTop);const t=o.IframeUtils.getPositionOfChildWindowRelativeToAncestorWindow(self,e.view);this.posx-=t.left,this.posy-=t.top}preventDefault(){this.browserEvent.preventDefault()}stopPropagation(){this.browserEvent.stopPropagation()}}class a{constructor(e,t=0,i=0){if(this.browserEvent=e||null,this.target=e?e.target||e.targetNode||e.srcElement:null,this.deltaY=i,this.deltaX=t,e){const t=e,i=e;if(void 0!==t.wheelDeltaY)this.deltaY=t.wheelDeltaY/120;else if(void 0!==i.VERTICAL_AXIS&&i.axis===i.VERTICAL_AXIS)this.deltaY=-i.detail/3;else if("wheel"===e.type){const t=e;t.deltaMode===t.DOM_DELTA_LINE?n.isFirefox&&!r.isMacintosh?this.deltaY=-e.deltaY/3:this.deltaY=-e.deltaY:this.deltaY=-e.deltaY/40}if(void 0!==t.wheelDeltaX)n.isSafari&&r.isWindows?this.deltaX=-t.wheelDeltaX/120:this.deltaX=t.wheelDeltaX/120;else if(void 0!==i.HORIZONTAL_AXIS&&i.axis===i.HORIZONTAL_AXIS)this.deltaX=-e.detail/3;else if("wheel"===e.type){const t=e;t.deltaMode===t.DOM_DELTA_LINE?n.isFirefox&&!r.isMacintosh?this.deltaX=-e.deltaX/3:this.deltaX=-e.deltaX:this.deltaX=-e.deltaX/40}0===this.deltaY&&0===this.deltaX&&e.wheelDelta&&(this.deltaY=e.wheelDelta/120)}}preventDefault(){this.browserEvent&&this.browserEvent.preventDefault()}stopPropagation(){this.browserEvent&&this.browserEvent.stopPropagation()}}},4043:function(e,t,i){"use strict";i.r(t),i.d(t,{EventType:function(){return n},Gesture:function(){return c}});var n,o=i(96747),r=i(64998),s=i(63966),a=i(68921),l=function(e,t,i,n){var o,r=arguments.length,s=r<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,i):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)s=Reflect.decorate(e,t,i,n);else for(var a=e.length-1;a>=0;a--)(o=e[a])&&(s=(r<3?o(s):r>3?o(t,i,s):o(t,i))||s);return r>3&&s&&Object.defineProperty(t,i,s),s};!function(e){e.Tap="-monaco-gesturetap",e.Change="-monaco-gesturechange",e.Start="-monaco-gesturestart",e.End="-monaco-gesturesend",e.Contextmenu="-monaco-gesturecontextmenu"}(n||(n={}));class c extends a.Disposable{constructor(){super(),this.dispatched=!1,this.activeTouches={},this.handle=null,this.targets=[],this.ignoreTargets=[],this._lastSetTapCountTime=0,this._register(o.addDisposableListener(document,"touchstart",(e=>this.onTouchStart(e)),{passive:!1})),this._register(o.addDisposableListener(document,"touchend",(e=>this.onTouchEnd(e)))),this._register(o.addDisposableListener(document,"touchmove",(e=>this.onTouchMove(e)),{passive:!1}))}static addTarget(e){return c.isTouchDevice()?(c.INSTANCE||(c.INSTANCE=new c),c.INSTANCE.targets.push(e),{dispose:()=>{c.INSTANCE.targets=c.INSTANCE.targets.filter((t=>t!==e))}}):a.Disposable.None}static ignoreTarget(e){return c.isTouchDevice()?(c.INSTANCE||(c.INSTANCE=new c),c.INSTANCE.ignoreTargets.push(e),{dispose:()=>{c.INSTANCE.ignoreTargets=c.INSTANCE.ignoreTargets.filter((t=>t!==e))}}):a.Disposable.None}static isTouchDevice(){return"ontouchstart"in window||navigator.maxTouchPoints>0}dispose(){this.handle&&(this.handle.dispose(),this.handle=null),super.dispose()}onTouchStart(e){const t=Date.now();this.handle&&(this.handle.dispose(),this.handle=null);for(let i=0,o=e.targetTouches.length;i<o;i++){const o=e.targetTouches.item(i);this.activeTouches[o.identifier]={id:o.identifier,initialTarget:o.target,initialTimeStamp:t,initialPageX:o.pageX,initialPageY:o.pageY,rollingTimestamps:[t],rollingPageX:[o.pageX],rollingPageY:[o.pageY]};const r=this.newGestureEvent(n.Start,o.target);r.pageX=o.pageX,r.pageY=o.pageY,this.dispatchEvent(r)}this.dispatched&&(e.preventDefault(),e.stopPropagation(),this.dispatched=!1)}onTouchEnd(e){const t=Date.now(),i=Object.keys(this.activeTouches).length;for(let o=0,s=e.changedTouches.length;o<s;o++){const s=e.changedTouches.item(o);if(!this.activeTouches.hasOwnProperty(String(s.identifier))){console.warn("move of an UNKNOWN touch",s);continue}const a=this.activeTouches[s.identifier],l=Date.now()-a.initialTimeStamp;if(l<c.HOLD_DELAY&&Math.abs(a.initialPageX-r.tail(a.rollingPageX))<30&&Math.abs(a.initialPageY-r.tail(a.rollingPageY))<30){const e=this.newGestureEvent(n.Tap,a.initialTarget);e.pageX=r.tail(a.rollingPageX),e.pageY=r.tail(a.rollingPageY),this.dispatchEvent(e)}else if(l>=c.HOLD_DELAY&&Math.abs(a.initialPageX-r.tail(a.rollingPageX))<30&&Math.abs(a.initialPageY-r.tail(a.rollingPageY))<30){const e=this.newGestureEvent(n.Contextmenu,a.initialTarget);e.pageX=r.tail(a.rollingPageX),e.pageY=r.tail(a.rollingPageY),this.dispatchEvent(e)}else if(1===i){const e=r.tail(a.rollingPageX),i=r.tail(a.rollingPageY),n=r.tail(a.rollingTimestamps)-a.rollingTimestamps[0],o=e-a.rollingPageX[0],s=i-a.rollingPageY[0],l=this.targets.filter((e=>a.initialTarget instanceof Node&&e.contains(a.initialTarget)));this.inertia(l,t,Math.abs(o)/n,o>0?1:-1,e,Math.abs(s)/n,s>0?1:-1,i)}this.dispatchEvent(this.newGestureEvent(n.End,a.initialTarget)),delete this.activeTouches[s.identifier]}this.dispatched&&(e.preventDefault(),e.stopPropagation(),this.dispatched=!1)}newGestureEvent(e,t){const i=document.createEvent("CustomEvent");return i.initEvent(e,!1,!0),i.initialTarget=t,i.tapCount=0,i}dispatchEvent(e){if(e.type===n.Tap){const t=(new Date).getTime();let i=0;i=t-this._lastSetTapCountTime>c.CLEAR_TAP_COUNT_TIME?1:2,this._lastSetTapCountTime=t,e.tapCount=i}else e.type!==n.Change&&e.type!==n.Contextmenu||(this._lastSetTapCountTime=0);for(let t=0;t<this.ignoreTargets.length;t++)if(e.initialTarget instanceof Node&&this.ignoreTargets[t].contains(e.initialTarget))return;this.targets.forEach((t=>{e.initialTarget instanceof Node&&t.contains(e.initialTarget)&&(t.dispatchEvent(e),this.dispatched=!0)}))}inertia(e,t,i,r,s,a,l,d){this.handle=o.scheduleAtNextAnimationFrame((()=>{const o=Date.now(),u=o-t;let h=0,g=0,p=!0;i+=c.SCROLL_FRICTION*u,a+=c.SCROLL_FRICTION*u,i>0&&(p=!1,h=r*i*u),a>0&&(p=!1,g=l*a*u);const m=this.newGestureEvent(n.Change);m.translationX=h,m.translationY=g,e.forEach((e=>e.dispatchEvent(m))),p||this.inertia(e,o,i,r,s+h,a,l,d+g)}))}onTouchMove(e){const t=Date.now();for(let i=0,o=e.changedTouches.length;i<o;i++){const o=e.changedTouches.item(i);if(!this.activeTouches.hasOwnProperty(String(o.identifier))){console.warn("end of an UNKNOWN touch",o);continue}const s=this.activeTouches[o.identifier],a=this.newGestureEvent(n.Change,s.initialTarget);a.translationX=o.pageX-r.tail(s.rollingPageX),a.translationY=o.pageY-r.tail(s.rollingPageY),a.pageX=o.pageX,a.pageY=o.pageY,this.dispatchEvent(a),s.rollingPageX.length>3&&(s.rollingPageX.shift(),s.rollingPageY.shift(),s.rollingTimestamps.shift()),s.rollingPageX.push(o.pageX),s.rollingPageY.push(o.pageY),s.rollingTimestamps.push(t)}this.dispatched&&(e.preventDefault(),e.stopPropagation(),this.dispatched=!1)}}c.SCROLL_FRICTION=-.005,c.HOLD_DELAY=700,c.CLEAR_TAP_COUNT_TIME=400,l([s.memoize],c,"isTouchDevice",null)},61009:function(e,t,i){"use strict";i.r(t),i.d(t,{ActionViewItem:function(){return p},BaseActionViewItem:function(){return g}});var n=i(76736),o=i(65174),r=i(96747),s=i(4043),a=i(2720),l=i(60969),c=i(68921),d=i(66719),u=i(18912),h=(i(59042),i(83787));class g extends c.Disposable{constructor(e,t,i={}){super(),this.options=i,this._context=e||this,this._action=t,t instanceof l.Action&&this._register(t.onDidChange((e=>{this.element&&this.handleActionChangeEvent(e)})))}get action(){return this._action}handleActionChangeEvent(e){void 0!==e.enabled&&this.updateEnabled(),void 0!==e.checked&&this.updateChecked(),void 0!==e.class&&this.updateClass(),void 0!==e.label&&(this.updateLabel(),this.updateTooltip()),void 0!==e.tooltip&&this.updateTooltip()}get actionRunner(){return this._actionRunner||(this._actionRunner=this._register(new l.ActionRunner)),this._actionRunner}set actionRunner(e){this._actionRunner=e}getAction(){return this._action}isEnabled(){return this._action.enabled}setActionContext(e){this._context=e}render(e){const t=this.element=e;this._register(s.Gesture.addTarget(e));const i=this.options&&this.options.draggable;i&&(e.draggable=!0,n.isFirefox&&this._register((0,r.addDisposableListener)(e,r.EventType.DRAG_START,(e=>{var t;return null===(t=e.dataTransfer)||void 0===t?void 0:t.setData(o.DataTransfers.TEXT,this._action.label)})))),this._register((0,r.addDisposableListener)(t,s.EventType.Tap,(e=>this.onClick(e,!0)))),this._register((0,r.addDisposableListener)(t,r.EventType.MOUSE_DOWN,(e=>{i||r.EventHelper.stop(e,!0),this._action.enabled&&0===e.button&&t.classList.add("active")}))),d.isMacintosh&&this._register((0,r.addDisposableListener)(t,r.EventType.CONTEXT_MENU,(e=>{0===e.button&&!0===e.ctrlKey&&this.onClick(e)}))),this._register((0,r.addDisposableListener)(t,r.EventType.CLICK,(e=>{r.EventHelper.stop(e,!0),this.options&&this.options.isMenu||this.onClick(e)}))),this._register((0,r.addDisposableListener)(t,r.EventType.DBLCLICK,(e=>{r.EventHelper.stop(e,!0)}))),[r.EventType.MOUSE_UP,r.EventType.MOUSE_OUT].forEach((e=>{this._register((0,r.addDisposableListener)(t,e,(e=>{r.EventHelper.stop(e),t.classList.remove("active")})))}))}onClick(e,t=!1){var i;r.EventHelper.stop(e,!0);const n=u.isUndefinedOrNull(this._context)?(null===(i=this.options)||void 0===i?void 0:i.useEventAsContext)?e:{preserveFocus:t}:this._context;this.actionRunner.run(this._action,n)}focus(){this.element&&(this.element.tabIndex=0,this.element.focus(),this.element.classList.add("focused"))}blur(){this.element&&(this.element.blur(),this.element.tabIndex=-1,this.element.classList.remove("focused"))}setFocusable(e){this.element&&(this.element.tabIndex=e?0:-1)}get trapsArrowNavigation(){return!1}updateEnabled(){}updateLabel(){}getTooltip(){return this.getAction().tooltip}updateTooltip(){var e;if(!this.element)return;const t=null!==(e=this.getTooltip())&&void 0!==e?e:"";this.element.setAttribute("aria-label",t),this.options.hoverDelegate?(this.element.title="",this.customHover?this.customHover.update(t):(this.customHover=(0,a.setupCustomHover)(this.options.hoverDelegate,this.element,t),this._store.add(this.customHover))):this.element.title=t}updateClass(){}updateChecked(){}dispose(){this.element&&(this.element.remove(),this.element=void 0),super.dispose()}}class p extends g{constructor(e,t,i={}){super(e,t,i),this.options=i,this.options.icon=void 0!==i.icon&&i.icon,this.options.label=void 0===i.label||i.label,this.cssClass=""}render(e){super.render(e),this.element&&(this.label=(0,r.append)(this.element,(0,r.$)("a.action-label"))),this.label&&(this._action.id===l.Separator.ID?this.label.setAttribute("role","presentation"):this.options.isMenu?this.label.setAttribute("role","menuitem"):this.label.setAttribute("role","button")),this.options.label&&this.options.keybinding&&this.element&&((0,r.append)(this.element,(0,r.$)("span.keybinding")).textContent=this.options.keybinding),this.updateClass(),this.updateLabel(),this.updateTooltip(),this.updateEnabled(),this.updateChecked()}focus(){this.label&&(this.label.tabIndex=0,this.label.focus())}blur(){this.label&&(this.label.tabIndex=-1)}setFocusable(e){this.label&&(this.label.tabIndex=e?0:-1)}updateLabel(){this.options.label&&this.label&&(this.label.textContent=this.getAction().label)}getTooltip(){let e=null;return this.getAction().tooltip?e=this.getAction().tooltip:!this.options.label&&this.getAction().label&&this.options.icon&&(e=this.getAction().label,this.options.keybinding&&(e=h.localize("vs/base/browser/ui/actionbar/actionViewItems",{key:"titleLabel",comment:["action title","action keybinding"]},"{0} ({1})",e,this.options.keybinding))),null!=e?e:void 0}updateClass(){var e;this.cssClass&&this.label&&this.label.classList.remove(...this.cssClass.split(" ")),this.options.icon?(this.cssClass=this.getAction().class,this.label&&(this.label.classList.add("codicon"),this.cssClass&&this.label.classList.add(...this.cssClass.split(" "))),this.updateEnabled()):null===(e=this.label)||void 0===e||e.classList.remove("codicon")}updateEnabled(){var e,t;this.getAction().enabled?(this.label&&(this.label.removeAttribute("aria-disabled"),this.label.classList.remove("disabled")),null===(e=this.element)||void 0===e||e.classList.remove("disabled")):(this.label&&(this.label.setAttribute("aria-disabled","true"),this.label.classList.add("disabled")),null===(t=this.element)||void 0===t||t.classList.add("disabled"))}updateChecked(){this.label&&(this.getAction().checked?this.label.classList.add("checked"):this.label.classList.remove("checked"))}}},31532:function(e,t,i){"use strict";i.r(t),i.d(t,{ActionBar:function(){return u}});var n=i(96747),o=i(8769),r=i(61009),s=i(60969),a=i(63801),l=i(68921),c=i(18912),d=(i(59042),function(e,t,i,n){return new(i||(i=Promise))((function(o,r){function s(e){try{l(n.next(e))}catch(e){r(e)}}function a(e){try{l(n.throw(e))}catch(e){r(e)}}function l(e){var t;e.done?o(e.value):(t=e.value,t instanceof i?t:new i((function(e){e(t)}))).then(s,a)}l((n=n.apply(e,t||[])).next())}))});class u extends l.Disposable{constructor(e,t={}){var i,l,c,d,u,h;let g,p;switch(super(),this.triggerKeyDown=!1,this.focusable=!0,this._onDidBlur=this._register(new a.Emitter),this.onDidBlur=this._onDidBlur.event,this._onDidCancel=this._register(new a.Emitter({onFirstListenerAdd:()=>this.cancelHasListener=!0})),this.onDidCancel=this._onDidCancel.event,this.cancelHasListener=!1,this._onDidRun=this._register(new a.Emitter),this.onDidRun=this._onDidRun.event,this._onBeforeRun=this._register(new a.Emitter),this.onBeforeRun=this._onBeforeRun.event,this.options=t,this._context=null!==(i=t.context)&&void 0!==i?i:null,this._orientation=null!==(l=this.options.orientation)&&void 0!==l?l:0,this._triggerKeys={keyDown:null!==(d=null===(c=this.options.triggerKeys)||void 0===c?void 0:c.keyDown)&&void 0!==d&&d,keys:null!==(h=null===(u=this.options.triggerKeys)||void 0===u?void 0:u.keys)&&void 0!==h?h:[3,10]},this.options.actionRunner?this._actionRunner=this.options.actionRunner:(this._actionRunner=new s.ActionRunner,this._register(this._actionRunner)),this._register(this._actionRunner.onDidRun((e=>this._onDidRun.fire(e)))),this._register(this._actionRunner.onBeforeRun((e=>this._onBeforeRun.fire(e)))),this._actionIds=[],this.viewItems=[],this.viewItemDisposables=new Map,this.focusedItem=void 0,this.domNode=document.createElement("div"),this.domNode.className="monaco-action-bar",!1!==t.animated&&this.domNode.classList.add("animated"),this._orientation){case 0:g=[15],p=[17];break;case 1:g=[16],p=[18],this.domNode.className+=" vertical"}this._register(n.addDisposableListener(this.domNode,n.EventType.KEY_DOWN,(e=>{const t=new o.StandardKeyboardEvent(e);let i=!0;const n="number"==typeof this.focusedItem?this.viewItems[this.focusedItem]:void 0;g&&(t.equals(g[0])||t.equals(g[1]))?i=this.focusPrevious():p&&(t.equals(p[0])||t.equals(p[1]))?i=this.focusNext():t.equals(9)&&this.cancelHasListener?this._onDidCancel.fire():t.equals(14)?i=this.focusFirst():t.equals(13)?i=this.focusLast():t.equals(2)&&n instanceof r.BaseActionViewItem&&n.trapsArrowNavigation?i=this.focusNext():this.isTriggerKeyEvent(t)?this._triggerKeys.keyDown?this.doTrigger(t):this.triggerKeyDown=!0:i=!1,i&&(t.preventDefault(),t.stopPropagation())}))),this._register(n.addDisposableListener(this.domNode,n.EventType.KEY_UP,(e=>{const t=new o.StandardKeyboardEvent(e);this.isTriggerKeyEvent(t)?(!this._triggerKeys.keyDown&&this.triggerKeyDown&&(this.triggerKeyDown=!1,this.doTrigger(t)),t.preventDefault(),t.stopPropagation()):(t.equals(2)||t.equals(1026))&&this.updateFocusedItem()}))),this.focusTracker=this._register(n.trackFocus(this.domNode)),this._register(this.focusTracker.onDidBlur((()=>{n.getActiveElement()!==this.domNode&&n.isAncestor(n.getActiveElement(),this.domNode)||(this._onDidBlur.fire(),this.focusedItem=void 0,this.previouslyFocusedItem=void 0,this.triggerKeyDown=!1)}))),this._register(this.focusTracker.onDidFocus((()=>this.updateFocusedItem()))),this.actionsList=document.createElement("ul"),this.actionsList.className="actions-container",this.actionsList.setAttribute("role",this.options.ariaRole||"toolbar"),this.options.ariaLabel&&this.actionsList.setAttribute("aria-label",this.options.ariaLabel),this.domNode.appendChild(this.actionsList),e.appendChild(this.domNode)}refreshRole(){this.length()>=2?this.actionsList.setAttribute("role",this.options.ariaRole||"toolbar"):this.actionsList.setAttribute("role","presentation")}setFocusable(e){if(this.focusable=e,this.focusable){const e=this.viewItems.find((e=>e instanceof r.BaseActionViewItem&&e.isEnabled()));e instanceof r.BaseActionViewItem&&e.setFocusable(!0)}else this.viewItems.forEach((e=>{e instanceof r.BaseActionViewItem&&e.setFocusable(!1)}))}isTriggerKeyEvent(e){let t=!1;return this._triggerKeys.keys.forEach((i=>{t=t||e.equals(i)})),t}updateFocusedItem(){for(let e=0;e<this.actionsList.children.length;e++){const t=this.actionsList.children[e];if(n.isAncestor(n.getActiveElement(),t)){this.focusedItem=e;break}}}get context(){return this._context}set context(e){this._context=e,this.viewItems.forEach((t=>t.setActionContext(e)))}get actionRunner(){return this._actionRunner}set actionRunner(e){e&&(this._actionRunner=e,this.viewItems.forEach((t=>t.actionRunner=e)))}getContainer(){return this.domNode}push(e,t={}){const i=Array.isArray(e)?e:[e];let o=c.isNumber(t.index)?t.index:null;i.forEach((e=>{const i=document.createElement("li");let s;i.className="action-item",i.setAttribute("role","presentation"),this.options.actionViewItemProvider&&(s=this.options.actionViewItemProvider(e)),s||(s=new r.ActionViewItem(this.context,e,Object.assign({hoverDelegate:this.options.hoverDelegate},t))),this.options.allowContextMenu||this.viewItemDisposables.set(s,n.addDisposableListener(i,n.EventType.CONTEXT_MENU,(e=>{n.EventHelper.stop(e,!0)}))),s.actionRunner=this._actionRunner,s.setActionContext(this.context),s.render(i),this.focusable&&s instanceof r.BaseActionViewItem&&0===this.viewItems.length&&s.setFocusable(!0),null===o||o<0||o>=this.actionsList.children.length?(this.actionsList.appendChild(i),this.viewItems.push(s),this._actionIds.push(e.id)):(this.actionsList.insertBefore(i,this.actionsList.children[o]),this.viewItems.splice(o,0,s),this._actionIds.splice(o,0,e.id),o++)})),"number"==typeof this.focusedItem&&this.focus(this.focusedItem),this.refreshRole()}clear(){(0,l.dispose)(this.viewItems),this.viewItemDisposables.forEach((e=>e.dispose())),this.viewItemDisposables.clear(),this.viewItems=[],this._actionIds=[],n.clearNode(this.actionsList),this.refreshRole()}length(){return this.viewItems.length}focus(e){let t,i=!1;if(void 0===e?i=!0:"number"==typeof e?t=e:"boolean"==typeof e&&(i=e),i&&void 0===this.focusedItem){const e=this.viewItems.findIndex((e=>e.isEnabled()));this.focusedItem=-1===e?void 0:e,this.updateFocus(void 0,void 0,!0)}else void 0!==t&&(this.focusedItem=t),this.updateFocus(void 0,void 0,!0)}focusFirst(){return this.focusedItem=this.length()-1,this.focusNext(!0)}focusLast(){return this.focusedItem=0,this.focusPrevious(!0)}focusNext(e){if(void 0===this.focusedItem)this.focusedItem=this.viewItems.length-1;else if(this.viewItems.length<=1)return!1;const t=this.focusedItem;let i;do{if(!e&&this.options.preventLoopNavigation&&this.focusedItem+1>=this.viewItems.length)return this.focusedItem=t,!1;this.focusedItem=(this.focusedItem+1)%this.viewItems.length,i=this.viewItems[this.focusedItem]}while(this.focusedItem!==t&&(this.options.focusOnlyEnabledItems&&!i.isEnabled()||i.action.id===s.Separator.ID));return this.updateFocus(),!0}focusPrevious(e){if(void 0===this.focusedItem)this.focusedItem=0;else if(this.viewItems.length<=1)return!1;const t=this.focusedItem;let i;do{if(this.focusedItem=this.focusedItem-1,this.focusedItem<0){if(!e&&this.options.preventLoopNavigation)return this.focusedItem=t,!1;this.focusedItem=this.viewItems.length-1}i=this.viewItems[this.focusedItem]}while(this.focusedItem!==t&&(this.options.focusOnlyEnabledItems&&!i.isEnabled()||i.action.id===s.Separator.ID));return this.updateFocus(!0),!0}updateFocus(e,t,i=!1){var n;void 0===this.focusedItem&&this.actionsList.focus({preventScroll:t}),void 0!==this.previouslyFocusedItem&&this.previouslyFocusedItem!==this.focusedItem&&(null===(n=this.viewItems[this.previouslyFocusedItem])||void 0===n||n.blur());const o=void 0!==this.focusedItem&&this.viewItems[this.focusedItem];if(o){let n=!0;c.isFunction(o.focus)||(n=!1),this.options.focusOnlyEnabledItems&&c.isFunction(o.isEnabled)&&!o.isEnabled()&&(n=!1),o.action.id===s.Separator.ID&&(n=!1),n?(i||this.previouslyFocusedItem!==this.focusedItem)&&(o.focus(e),this.previouslyFocusedItem=this.focusedItem):(this.actionsList.focus({preventScroll:t}),this.previouslyFocusedItem=void 0)}}doTrigger(e){if(void 0===this.focusedItem)return;const t=this.viewItems[this.focusedItem];if(t instanceof r.BaseActionViewItem){const i=null===t._context||void 0===t._context?e:t._context;this.run(t._action,i)}}run(e,t){return d(this,void 0,void 0,(function*(){yield this._actionRunner.run(e,t)}))}dispose(){(0,l.dispose)(this.viewItems),this.viewItems=[],this._actionIds=[],this.getContainer().remove(),super.dispose()}}},61950:function(e,t,i){"use strict";i.r(t),i.d(t,{alert:function(){return x},setARIAContainer:function(){return S},status:function(){return E}});var n=i(96747),o=i(66719),r=i(93379),s=i.n(r),a=i(7795),l=i.n(a),c=i(90569),d=i.n(c),u=i(3565),h=i.n(u),g=i(19216),p=i.n(g),m=i(44589),f=i.n(m),b=i(40371),_={};_.styleTagTransform=f(),_.setAttributes=h(),_.insert=d().bind(null,"head"),_.domAPI=l(),_.insertStyleElement=p();s()(b.Z,_),b.Z&&b.Z.locals&&b.Z.locals;let A,v,C,w,y;function S(e){A=document.createElement("div"),A.className="monaco-aria-container";const t=()=>{const e=document.createElement("div");return e.className="monaco-alert",e.setAttribute("role","alert"),e.setAttribute("aria-atomic","true"),A.appendChild(e),e};v=t(),C=t();const i=()=>{const e=document.createElement("div");return e.className="monaco-status",e.setAttribute("role","complementary"),e.setAttribute("aria-live","polite"),e.setAttribute("aria-atomic","true"),A.appendChild(e),e};w=i(),y=i(),e.appendChild(A)}function x(e){A&&(v.textContent!==e?(n.clearNode(C),k(v,e)):(n.clearNode(v),k(C,e)))}function E(e){A&&(o.isMacintosh?x(e):w.textContent!==e?(n.clearNode(y),k(w,e)):(n.clearNode(w),k(y,e)))}function k(e,t){n.clearNode(e),t.length>2e4&&(t=t.substr(0,2e4)),e.textContent=t,e.style.visibility="hidden",e.style.visibility="visible"}},54042:function(e,t,i){"use strict";i.r(t),i.d(t,{Button:function(){return E}});var n=i(96747),o=i(8769),r=i(4043),s=i(21348),a=i(17160),l=i(63801),c=i(68921),d=i(91057),u=i(93379),h=i.n(u),g=i(7795),p=i.n(g),m=i(90569),f=i.n(m),b=i(3565),_=i.n(b),A=i(19216),v=i.n(A),C=i(44589),w=i.n(C),y=i(55796),S={};S.styleTagTransform=w(),S.setAttributes=_(),S.insert=f().bind(null,"head"),S.domAPI=p(),S.insertStyleElement=v();h()(y.Z,S),y.Z&&y.Z.locals&&y.Z.locals;const x={buttonBackground:a.Color.fromHex("#0E639C"),buttonHoverBackground:a.Color.fromHex("#006BB3"),buttonSeparator:a.Color.white,buttonForeground:a.Color.white};class E extends c.Disposable{constructor(e,t){super(),this._onDidClick=this._register(new l.Emitter),this.options=t||Object.create(null),(0,d.mixin)(this.options,x,!1),this.buttonForeground=this.options.buttonForeground,this.buttonBackground=this.options.buttonBackground,this.buttonHoverBackground=this.options.buttonHoverBackground,this.buttonSecondaryForeground=this.options.buttonSecondaryForeground,this.buttonSecondaryBackground=this.options.buttonSecondaryBackground,this.buttonSecondaryHoverBackground=this.options.buttonSecondaryHoverBackground,this.buttonBorder=this.options.buttonBorder,this._element=document.createElement("a"),this._element.classList.add("monaco-button"),this._element.tabIndex=0,this._element.setAttribute("role","button"),e.appendChild(this._element),this._register(r.Gesture.addTarget(this._element)),[n.EventType.CLICK,r.EventType.Tap].forEach((e=>{this._register((0,n.addDisposableListener)(this._element,e,(e=>{this.enabled?this._onDidClick.fire(e):n.EventHelper.stop(e)})))})),this._register((0,n.addDisposableListener)(this._element,n.EventType.KEY_DOWN,(e=>{const t=new o.StandardKeyboardEvent(e);let i=!1;this.enabled&&(t.equals(3)||t.equals(10))?(this._onDidClick.fire(e),i=!0):t.equals(9)&&(this._element.blur(),i=!0),i&&n.EventHelper.stop(t,!0)}))),this._register((0,n.addDisposableListener)(this._element,n.EventType.MOUSE_OVER,(e=>{this._element.classList.contains("disabled")||this.setHoverBackground()}))),this._register((0,n.addDisposableListener)(this._element,n.EventType.MOUSE_OUT,(e=>{this.applyStyles()}))),this.focusTracker=this._register((0,n.trackFocus)(this._element)),this._register(this.focusTracker.onDidFocus((()=>{this.enabled&&this.setHoverBackground()}))),this._register(this.focusTracker.onDidBlur((()=>{this.enabled&&this.applyStyles()}))),this.applyStyles()}get onDidClick(){return this._onDidClick.event}setHoverBackground(){let e;e=this.options.secondary?this.buttonSecondaryHoverBackground?this.buttonSecondaryHoverBackground.toString():null:this.buttonHoverBackground?this.buttonHoverBackground.toString():null,e&&(this._element.style.backgroundColor=e)}style(e){this.buttonForeground=e.buttonForeground,this.buttonBackground=e.buttonBackground,this.buttonHoverBackground=e.buttonHoverBackground,this.buttonSecondaryForeground=e.buttonSecondaryForeground,this.buttonSecondaryBackground=e.buttonSecondaryBackground,this.buttonSecondaryHoverBackground=e.buttonSecondaryHoverBackground,this.buttonBorder=e.buttonBorder,this.applyStyles()}applyStyles(){if(this._element){let e,t;this.options.secondary?(t=this.buttonSecondaryForeground?this.buttonSecondaryForeground.toString():"",e=this.buttonSecondaryBackground?this.buttonSecondaryBackground.toString():""):(t=this.buttonForeground?this.buttonForeground.toString():"",e=this.buttonBackground?this.buttonBackground.toString():"");const i=this.buttonBorder?this.buttonBorder.toString():"";this._element.style.color=t,this._element.style.backgroundColor=e,this._element.style.borderWidth=i?"1px":"",this._element.style.borderStyle=i?"solid":"",this._element.style.borderColor=i}}get element(){return this._element}set label(e){this._element.classList.add("monaco-text-button"),this.options.supportIcons?(0,n.reset)(this._element,...(0,s.renderLabelWithIcons)(e)):this._element.textContent=e,"string"==typeof this.options.title?this._element.title=this.options.title:this.options.title&&(this._element.title=e)}set enabled(e){e?(this._element.classList.remove("disabled"),this._element.setAttribute("aria-disabled",String(!1)),this._element.tabIndex=0):(this._element.classList.add("disabled"),this._element.setAttribute("aria-disabled",String(!0)))}get enabled(){return!this._element.classList.contains("disabled")}}},22694:function(e,t,i){"use strict";i.r(t),i.d(t,{formatRule:function(){return v}});var n=i(56087),o=i(93379),r=i.n(o),s=i(7795),a=i.n(s),l=i(90569),c=i.n(l),d=i(3565),u=i.n(d),h=i(19216),g=i.n(h),p=i(44589),m=i.n(p),f=i(23222),b={};b.styleTagTransform=m(),b.setAttributes=u(),b.insert=c().bind(null,"head"),b.domAPI=a(),b.insertStyleElement=g();r()(f.Z,b),f.Z&&f.Z.locals&&f.Z.locals;var _=i(99827),A={};A.styleTagTransform=m(),A.setAttributes=u(),A.insert=c().bind(null,"head"),A.domAPI=a(),A.insertStyleElement=g();r()(_.Z,A),_.Z&&_.Z.locals&&_.Z.locals;function v(e){let t=e.definition;for(;t instanceof n.Codicon;)t=t.definition;return`.codicon-${e.id}:before { content: '${t.fontCharacter}'; }`}},96205:function(e,t,i){"use strict";i.r(t),i.d(t,{ContextView:function(){return S},LayoutAnchorMode:function(){return w},layout:function(){return y}});var n=i(69098),o=i(96747),r=i(68921),s=i(66719),a=i(83682),l=i(93379),c=i.n(l),d=i(7795),u=i.n(d),h=i(90569),g=i.n(h),p=i(3565),m=i.n(p),f=i(19216),b=i.n(f),_=i(44589),A=i.n(_),v=i(72555),C={};C.styleTagTransform=A(),C.setAttributes=m(),C.insert=g().bind(null,"head"),C.domAPI=u(),C.insertStyleElement=b();var w;c()(v.Z,C),v.Z&&v.Z.locals&&v.Z.locals;function y(e,t,i){const n=i.mode===w.ALIGN?i.offset:i.offset+i.size,o=i.mode===w.ALIGN?i.offset+i.size:i.offset;return 0===i.position?t<=e-n?n:t<=o?o-t:Math.max(e-t,0):t<=o?o-t:t<=e-n?n:0}!function(e){e[e.AVOID=0]="AVOID",e[e.ALIGN=1]="ALIGN"}(w||(w={}));class S extends r.Disposable{constructor(e,t){super(),this.container=null,this.delegate=null,this.toDisposeOnClean=r.Disposable.None,this.toDisposeOnSetContainer=r.Disposable.None,this.shadowRoot=null,this.shadowRootHostElement=null,this.view=o.$(".context-view"),this.useFixedPosition=!1,this.useShadowDOM=!1,o.hide(this.view),this.setContainer(e,t),this._register((0,r.toDisposable)((()=>this.setContainer(null,1))))}setContainer(e,t){var i;if(this.container&&(this.toDisposeOnSetContainer.dispose(),this.shadowRoot?(this.shadowRoot.removeChild(this.view),this.shadowRoot=null,null===(i=this.shadowRootHostElement)||void 0===i||i.remove(),this.shadowRootHostElement=null):this.container.removeChild(this.view),this.container=null),e){if(this.container=e,this.useFixedPosition=1!==t,this.useShadowDOM=3===t,this.useShadowDOM){this.shadowRootHostElement=o.$(".shadow-root-host"),this.container.appendChild(this.shadowRootHostElement),this.shadowRoot=this.shadowRootHostElement.attachShadow({mode:"open"});const e=document.createElement("style");e.textContent=x,this.shadowRoot.appendChild(e),this.shadowRoot.appendChild(this.view),this.shadowRoot.appendChild(o.$("slot"))}else this.container.appendChild(this.view);const i=new r.DisposableStore;S.BUBBLE_UP_EVENTS.forEach((e=>{i.add(o.addStandardDisposableListener(this.container,e,(e=>{this.onDOMEvent(e,!1)})))})),S.BUBBLE_DOWN_EVENTS.forEach((e=>{i.add(o.addStandardDisposableListener(this.container,e,(e=>{this.onDOMEvent(e,!0)}),!0))})),this.toDisposeOnSetContainer=i}}show(e){var t,i;this.isVisible()&&this.hide(),o.clearNode(this.view),this.view.className="context-view",this.view.style.top="0px",this.view.style.left="0px",this.view.style.zIndex="2575",this.view.style.position=this.useFixedPosition?"fixed":"absolute",o.show(this.view),this.toDisposeOnClean=e.render(this.view)||r.Disposable.None,this.delegate=e,this.doLayout(),null===(i=(t=this.delegate).focus)||void 0===i||i.call(t)}getViewElement(){return this.view}layout(){this.isVisible()&&(!1!==this.delegate.canRelayout||s.isIOS&&n.BrowserFeatures.pointerEvents?(this.delegate.layout&&this.delegate.layout(),this.doLayout()):this.hide())}doLayout(){if(!this.isVisible())return;const e=this.delegate.getAnchor();let t;if(o.isHTMLElement(e)){const i=o.getDomNodePagePosition(e),n=o.getDomNodeZoomLevel(e);t={top:i.top*n,left:i.left*n,width:i.width*n,height:i.height*n}}else t={top:e.y,left:e.x,width:e.width||1,height:e.height||2};const i=o.getTotalWidth(this.view),n=o.getTotalHeight(this.view),r=this.delegate.anchorPosition||0,s=this.delegate.anchorAlignment||0;let l,c;if(0===(this.delegate.anchorAxisAlignment||0)){const e={offset:t.top-window.pageYOffset,size:t.height,position:0===r?0:1},o={offset:t.left,size:t.width,position:0===s?0:1,mode:w.ALIGN};l=y(window.innerHeight,n,e)+window.pageYOffset,a.Range.intersects({start:l,end:l+n},{start:e.offset,end:e.offset+e.size})&&(o.mode=w.AVOID),c=y(window.innerWidth,i,o)}else{const e={offset:t.left,size:t.width,position:0===s?0:1},o={offset:t.top,size:t.height,position:0===r?0:1,mode:w.ALIGN};c=y(window.innerWidth,i,e),a.Range.intersects({start:c,end:c+i},{start:e.offset,end:e.offset+e.size})&&(o.mode=w.AVOID),l=y(window.innerHeight,n,o)+window.pageYOffset}this.view.classList.remove("top","bottom","left","right"),this.view.classList.add(0===r?"bottom":"top"),this.view.classList.add(0===s?"left":"right"),this.view.classList.toggle("fixed",this.useFixedPosition);const d=o.getDomNodePagePosition(this.container);this.view.style.top=l-(this.useFixedPosition?o.getDomNodePagePosition(this.view).top:d.top)+"px",this.view.style.left=c-(this.useFixedPosition?o.getDomNodePagePosition(this.view).left:d.left)+"px",this.view.style.width="initial"}hide(e){const t=this.delegate;this.delegate=null,(null==t?void 0:t.onHide)&&t.onHide(e),this.toDisposeOnClean.dispose(),o.hide(this.view)}isVisible(){return!!this.delegate}onDOMEvent(e,t){this.delegate&&(this.delegate.onDOMEvent?this.delegate.onDOMEvent(e,document.activeElement):t&&!o.isAncestor(e.target,this.container)&&this.hide())}dispose(){this.hide(),super.dispose()}}S.BUBBLE_UP_EVENTS=["click","keydown","focus","blur"],S.BUBBLE_DOWN_EVENTS=["click"];const x='\n\t:host {\n\t\tall: initial; /* 1st rule so subsequent properties are reset. */\n\t}\n\n\t@font-face {\n\t\tfont-family: "codicon";\n\t\tfont-display: block;\n\t\tsrc: url("./codicon.ttf?5d4d76ab2ce5108968ad644d591a16a6") format("truetype");\n\t}\n\n\t.codicon[class*=\'codicon-\'] {\n\t\tfont: normal normal normal 16px/1 codicon;\n\t\tdisplay: inline-block;\n\t\ttext-decoration: none;\n\t\ttext-rendering: auto;\n\t\ttext-align: center;\n\t\t-webkit-font-smoothing: antialiased;\n\t\t-moz-osx-font-smoothing: grayscale;\n\t\tuser-select: none;\n\t\t-webkit-user-select: none;\n\t\t-ms-user-select: none;\n\t}\n\n\t:host {\n\t\tfont-family: -apple-system, BlinkMacSystemFont, "Segoe WPC", "Segoe UI", "HelveticaNeue-Light", system-ui, "Ubuntu", "Droid Sans", sans-serif;\n\t}\n\n\t:host-context(.mac) { font-family: -apple-system, BlinkMacSystemFont, sans-serif; }\n\t:host-context(.mac:lang(zh-Hans)) { font-family: -apple-system, BlinkMacSystemFont, "PingFang SC", "Hiragino Sans GB", sans-serif; }\n\t:host-context(.mac:lang(zh-Hant)) { font-family: -apple-system, BlinkMacSystemFont, "PingFang TC", sans-serif; }\n\t:host-context(.mac:lang(ja)) { font-family: -apple-system, BlinkMacSystemFont, "Hiragino Kaku Gothic Pro", sans-serif; }\n\t:host-context(.mac:lang(ko)) { font-family: -apple-system, BlinkMacSystemFont, "Nanum Gothic", "Apple SD Gothic Neo", "AppleGothic", sans-serif; }\n\n\t:host-context(.windows) { font-family: "Segoe WPC", "Segoe UI", sans-serif; }\n\t:host-context(.windows:lang(zh-Hans)) { font-family: "Segoe WPC", "Segoe UI", "Microsoft YaHei", sans-serif; }\n\t:host-context(.windows:lang(zh-Hant)) { font-family: "Segoe WPC", "Segoe UI", "Microsoft Jhenghei", sans-serif; }\n\t:host-context(.windows:lang(ja)) { font-family: "Segoe WPC", "Segoe UI", "Yu Gothic UI", "Meiryo UI", sans-serif; }\n\t:host-context(.windows:lang(ko)) { font-family: "Segoe WPC", "Segoe UI", "Malgun Gothic", "Dotom", sans-serif; }\n\n\t:host-context(.linux) { font-family: system-ui, "Ubuntu", "Droid Sans", sans-serif; }\n\t:host-context(.linux:lang(zh-Hans)) { font-family: system-ui, "Ubuntu", "Droid Sans", "Source Han Sans SC", "Source Han Sans CN", "Source Han Sans", sans-serif; }\n\t:host-context(.linux:lang(zh-Hant)) { font-family: system-ui, "Ubuntu", "Droid Sans", "Source Han Sans TC", "Source Han Sans TW", "Source Han Sans", sans-serif; }\n\t:host-context(.linux:lang(ja)) { font-family: system-ui, "Ubuntu", "Droid Sans", "Source Han Sans J", "Source Han Sans JP", "Source Han Sans", sans-serif; }\n\t:host-context(.linux:lang(ko)) { font-family: system-ui, "Ubuntu", "Droid Sans", "Source Han Sans K", "Source Han Sans JR", "Source Han Sans", "UnDotum", "FBaekmuk Gulim", sans-serif; }\n'},66218:function(e,t,i){"use strict";i.r(t),i.d(t,{CountBadge:function(){return w}});var n=i(96747),o=i(17160),r=i(91057),s=i(91482),a=i(93379),l=i.n(a),c=i(7795),d=i.n(c),u=i(90569),h=i.n(u),g=i(3565),p=i.n(g),m=i(19216),f=i.n(m),b=i(44589),_=i.n(b),A=i(73688),v={};v.styleTagTransform=_(),v.setAttributes=p(),v.insert=h().bind(null,"head"),v.domAPI=d(),v.insertStyleElement=f();l()(A.Z,v),A.Z&&A.Z.locals&&A.Z.locals;const C={badgeBackground:o.Color.fromHex("#4D4D4D"),badgeForeground:o.Color.fromHex("#FFFFFF")};class w{constructor(e,t){this.count=0,this.options=t||Object.create(null),(0,r.mixin)(this.options,C,!1),this.badgeBackground=this.options.badgeBackground,this.badgeForeground=this.options.badgeForeground,this.badgeBorder=this.options.badgeBorder,this.element=(0,n.append)(e,(0,n.$)(".monaco-count-badge")),this.countFormat=this.options.countFormat||"{0}",this.titleFormat=this.options.titleFormat||"",this.setCount(this.options.count||0)}setCount(e){this.count=e,this.render()}setTitleFormat(e){this.titleFormat=e,this.render()}render(){this.element.textContent=(0,s.format)(this.countFormat,this.count),this.element.title=(0,s.format)(this.titleFormat,this.count),this.applyStyles()}style(e){this.badgeBackground=e.badgeBackground,this.badgeForeground=e.badgeForeground,this.badgeBorder=e.badgeBorder,this.applyStyles()}applyStyles(){if(this.element){const e=this.badgeBackground?this.badgeBackground.toString():"",t=this.badgeForeground?this.badgeForeground.toString():"",i=this.badgeBorder?this.badgeBorder.toString():"";this.element.style.backgroundColor=e,this.element.style.color=t,this.element.style.borderWidth=i?"1px":"",this.element.style.borderStyle=i?"solid":"",this.element.style.borderColor=i}}}},73493:function(e,t,i){"use strict";i.r(t),i.d(t,{FindInput:function(){return c}});var n=i(96747),o=i(30115),r=i(25802),s=i(47257),a=i(63801);i(90381);const l=i(83787).localize("vs/base/browser/ui/findinput/findInput","defaultLabel","input");class c extends s.Widget{constructor(e,t,i,s){var c;super(),this._showOptionButtons=i,this.fixFocusOnOptionClickEnabled=!0,this.imeSessionInProgress=!1,this.additionalToggles=[],this._onDidOptionChange=this._register(new a.Emitter),this.onDidOptionChange=this._onDidOptionChange.event,this._onKeyDown=this._register(new a.Emitter),this.onKeyDown=this._onKeyDown.event,this._onMouseDown=this._register(new a.Emitter),this.onMouseDown=this._onMouseDown.event,this._onInput=this._register(new a.Emitter),this._onKeyUp=this._register(new a.Emitter),this._onCaseSensitiveKeyDown=this._register(new a.Emitter),this.onCaseSensitiveKeyDown=this._onCaseSensitiveKeyDown.event,this._onRegexKeyDown=this._register(new a.Emitter),this.onRegexKeyDown=this._onRegexKeyDown.event,this._lastHighlightFindOptions=0,this.contextViewProvider=t,this.placeholder=s.placeholder||"",this.validation=s.validation,this.label=s.label||l,this.inputActiveOptionBorder=s.inputActiveOptionBorder,this.inputActiveOptionForeground=s.inputActiveOptionForeground,this.inputActiveOptionBackground=s.inputActiveOptionBackground,this.inputBackground=s.inputBackground,this.inputForeground=s.inputForeground,this.inputBorder=s.inputBorder,this.inputValidationInfoBorder=s.inputValidationInfoBorder,this.inputValidationInfoBackground=s.inputValidationInfoBackground,this.inputValidationInfoForeground=s.inputValidationInfoForeground,this.inputValidationWarningBorder=s.inputValidationWarningBorder,this.inputValidationWarningBackground=s.inputValidationWarningBackground,this.inputValidationWarningForeground=s.inputValidationWarningForeground,this.inputValidationErrorBorder=s.inputValidationErrorBorder,this.inputValidationErrorBackground=s.inputValidationErrorBackground,this.inputValidationErrorForeground=s.inputValidationErrorForeground;const d=s.appendCaseSensitiveLabel||"",u=s.appendWholeWordsLabel||"",h=s.appendRegexLabel||"",g=s.history||[],p=!!s.flexibleHeight,m=!!s.flexibleWidth,f=s.flexibleMaxHeight;this.domNode=document.createElement("div"),this.domNode.classList.add("monaco-findInput"),this.inputBox=this._register(new r.HistoryInputBox(this.domNode,this.contextViewProvider,{placeholder:this.placeholder||"",ariaLabel:this.label||"",validationOptions:{validation:this.validation},inputBackground:this.inputBackground,inputForeground:this.inputForeground,inputBorder:this.inputBorder,inputValidationInfoBackground:this.inputValidationInfoBackground,inputValidationInfoForeground:this.inputValidationInfoForeground,inputValidationInfoBorder:this.inputValidationInfoBorder,inputValidationWarningBackground:this.inputValidationWarningBackground,inputValidationWarningForeground:this.inputValidationWarningForeground,inputValidationWarningBorder:this.inputValidationWarningBorder,inputValidationErrorBackground:this.inputValidationErrorBackground,inputValidationErrorForeground:this.inputValidationErrorForeground,inputValidationErrorBorder:this.inputValidationErrorBorder,history:g,showHistoryHint:s.showHistoryHint,flexibleHeight:p,flexibleWidth:m,flexibleMaxHeight:f})),this.regex=this._register(new o.RegexToggle({appendTitle:h,isChecked:!1,inputActiveOptionBorder:this.inputActiveOptionBorder,inputActiveOptionForeground:this.inputActiveOptionForeground,inputActiveOptionBackground:this.inputActiveOptionBackground})),this._register(this.regex.onChange((e=>{this._onDidOptionChange.fire(e),!e&&this.fixFocusOnOptionClickEnabled&&this.inputBox.focus(),this.validate()}))),this._register(this.regex.onKeyDown((e=>{this._onRegexKeyDown.fire(e)}))),this.wholeWords=this._register(new o.WholeWordsToggle({appendTitle:u,isChecked:!1,inputActiveOptionBorder:this.inputActiveOptionBorder,inputActiveOptionForeground:this.inputActiveOptionForeground,inputActiveOptionBackground:this.inputActiveOptionBackground})),this._register(this.wholeWords.onChange((e=>{this._onDidOptionChange.fire(e),!e&&this.fixFocusOnOptionClickEnabled&&this.inputBox.focus(),this.validate()}))),this.caseSensitive=this._register(new o.CaseSensitiveToggle({appendTitle:d,isChecked:!1,inputActiveOptionBorder:this.inputActiveOptionBorder,inputActiveOptionForeground:this.inputActiveOptionForeground,inputActiveOptionBackground:this.inputActiveOptionBackground})),this._register(this.caseSensitive.onChange((e=>{this._onDidOptionChange.fire(e),!e&&this.fixFocusOnOptionClickEnabled&&this.inputBox.focus(),this.validate()}))),this._register(this.caseSensitive.onKeyDown((e=>{this._onCaseSensitiveKeyDown.fire(e)})));const b=[this.caseSensitive.domNode,this.wholeWords.domNode,this.regex.domNode];this.onkeydown(this.domNode,(e=>{if(e.equals(15)||e.equals(17)||e.equals(9)){const t=b.indexOf(document.activeElement);if(t>=0){let i=-1;e.equals(17)?i=(t+1)%b.length:e.equals(15)&&(i=0===t?b.length-1:t-1),e.equals(9)?(b[t].blur(),this.inputBox.focus()):i>=0&&b[i].focus(),n.EventHelper.stop(e,!0)}}})),this.controls=document.createElement("div"),this.controls.className="controls",this.controls.style.display=this._showOptionButtons?"block":"none",this.controls.appendChild(this.caseSensitive.domNode),this.controls.appendChild(this.wholeWords.domNode),this.controls.appendChild(this.regex.domNode),this._showOptionButtons||(this.caseSensitive.domNode.style.display="none",this.wholeWords.domNode.style.display="none",this.regex.domNode.style.display="none");for(const e of null!==(c=null==s?void 0:s.additionalToggles)&&void 0!==c?c:[])this._register(e),this.controls.appendChild(e.domNode),this._register(e.onChange((e=>{this._onDidOptionChange.fire(e),!e&&this.fixFocusOnOptionClickEnabled&&this.inputBox.focus()}))),this.additionalToggles.push(e);this.additionalToggles.length>0&&(this.controls.style.display="block"),this.inputBox.paddingRight=(this._showOptionButtons?this.caseSensitive.width()+this.wholeWords.width()+this.regex.width():0)+this.additionalToggles.reduce(((e,t)=>e+t.width()),0),this.domNode.appendChild(this.controls),null==e||e.appendChild(this.domNode),this._register(n.addDisposableListener(this.inputBox.inputElement,"compositionstart",(e=>{this.imeSessionInProgress=!0}))),this._register(n.addDisposableListener(this.inputBox.inputElement,"compositionend",(e=>{this.imeSessionInProgress=!1,this._onInput.fire()}))),this.onkeydown(this.inputBox.inputElement,(e=>this._onKeyDown.fire(e))),this.onkeyup(this.inputBox.inputElement,(e=>this._onKeyUp.fire(e))),this.oninput(this.inputBox.inputElement,(e=>this._onInput.fire())),this.onmousedown(this.inputBox.inputElement,(e=>this._onMouseDown.fire(e)))}get onDidChange(){return this.inputBox.onDidChange}enable(){this.domNode.classList.remove("disabled"),this.inputBox.enable(),this.regex.enable(),this.wholeWords.enable(),this.caseSensitive.enable();for(const e of this.additionalToggles)e.enable()}disable(){this.domNode.classList.add("disabled"),this.inputBox.disable(),this.regex.disable(),this.wholeWords.disable(),this.caseSensitive.disable();for(const e of this.additionalToggles)e.disable()}setFocusInputOnOptionClick(e){this.fixFocusOnOptionClickEnabled=e}setEnabled(e){e?this.enable():this.disable()}getValue(){return this.inputBox.value}setValue(e){this.inputBox.value!==e&&(this.inputBox.value=e)}style(e){this.inputActiveOptionBorder=e.inputActiveOptionBorder,this.inputActiveOptionForeground=e.inputActiveOptionForeground,this.inputActiveOptionBackground=e.inputActiveOptionBackground,this.inputBackground=e.inputBackground,this.inputForeground=e.inputForeground,this.inputBorder=e.inputBorder,this.inputValidationInfoBackground=e.inputValidationInfoBackground,this.inputValidationInfoForeground=e.inputValidationInfoForeground,this.inputValidationInfoBorder=e.inputValidationInfoBorder,this.inputValidationWarningBackground=e.inputValidationWarningBackground,this.inputValidationWarningForeground=e.inputValidationWarningForeground,this.inputValidationWarningBorder=e.inputValidationWarningBorder,this.inputValidationErrorBackground=e.inputValidationErrorBackground,this.inputValidationErrorForeground=e.inputValidationErrorForeground,this.inputValidationErrorBorder=e.inputValidationErrorBorder,this.applyStyles()}applyStyles(){if(this.domNode){const e={inputActiveOptionBorder:this.inputActiveOptionBorder,inputActiveOptionForeground:this.inputActiveOptionForeground,inputActiveOptionBackground:this.inputActiveOptionBackground};this.regex.style(e),this.wholeWords.style(e),this.caseSensitive.style(e);for(const t of this.additionalToggles)t.style(e);const t={inputBackground:this.inputBackground,inputForeground:this.inputForeground,inputBorder:this.inputBorder,inputValidationInfoBackground:this.inputValidationInfoBackground,inputValidationInfoForeground:this.inputValidationInfoForeground,inputValidationInfoBorder:this.inputValidationInfoBorder,inputValidationWarningBackground:this.inputValidationWarningBackground,inputValidationWarningForeground:this.inputValidationWarningForeground,inputValidationWarningBorder:this.inputValidationWarningBorder,inputValidationErrorBackground:this.inputValidationErrorBackground,inputValidationErrorForeground:this.inputValidationErrorForeground,inputValidationErrorBorder:this.inputValidationErrorBorder};this.inputBox.style(t)}}select(){this.inputBox.select()}focus(){this.inputBox.focus()}getCaseSensitive(){return this.caseSensitive.checked}setCaseSensitive(e){this.caseSensitive.checked=e}getWholeWords(){return this.wholeWords.checked}setWholeWords(e){this.wholeWords.checked=e}getRegex(){return this.regex.checked}setRegex(e){this.regex.checked=e,this.validate()}focusOnCaseSensitive(){this.caseSensitive.focus()}highlightFindOptions(){this.domNode.classList.remove("highlight-"+this._lastHighlightFindOptions),this._lastHighlightFindOptions=1-this._lastHighlightFindOptions,this.domNode.classList.add("highlight-"+this._lastHighlightFindOptions)}validate(){this.inputBox.validate()}showMessage(e){this.inputBox.showMessage(e)}clearMessage(){this.inputBox.hideMessage()}}},30115:function(e,t,i){"use strict";i.r(t),i.d(t,{CaseSensitiveToggle:function(){return c},RegexToggle:function(){return u},WholeWordsToggle:function(){return d}});var n=i(50797),o=i(56087),r=i(83787);const s=r.localize("vs/base/browser/ui/findinput/findInputToggles","caseDescription","Match Case"),a=r.localize("vs/base/browser/ui/findinput/findInputToggles","wordsDescription","Match Whole Word"),l=r.localize("vs/base/browser/ui/findinput/findInputToggles","regexDescription","Use Regular Expression");class c extends n.Toggle{constructor(e){super({icon:o.Codicon.caseSensitive,title:s+e.appendTitle,isChecked:e.isChecked,inputActiveOptionBorder:e.inputActiveOptionBorder,inputActiveOptionForeground:e.inputActiveOptionForeground,inputActiveOptionBackground:e.inputActiveOptionBackground})}}class d extends n.Toggle{constructor(e){super({icon:o.Codicon.wholeWord,title:a+e.appendTitle,isChecked:e.isChecked,inputActiveOptionBorder:e.inputActiveOptionBorder,inputActiveOptionForeground:e.inputActiveOptionForeground,inputActiveOptionBackground:e.inputActiveOptionBackground})}}class u extends n.Toggle{constructor(e){super({icon:o.Codicon.regex,title:l+e.appendTitle,isChecked:e.isChecked,inputActiveOptionBorder:e.inputActiveOptionBorder,inputActiveOptionForeground:e.inputActiveOptionForeground,inputActiveOptionBackground:e.inputActiveOptionBackground})}}},6360:function(e,t,i){"use strict";i.r(t),i.d(t,{HighlightedLabel:function(){return s}});var n=i(96747),o=i(21348),r=i(91057);class s{constructor(e,t){var i;this.text="",this.title="",this.highlights=[],this.didEverRender=!1,this.supportIcons=null!==(i=null==t?void 0:t.supportIcons)&&void 0!==i&&i,this.domNode=n.append(e,n.$("span.monaco-highlighted-label"))}get element(){return this.domNode}set(e,t=[],i="",n){e||(e=""),n&&(e=s.escapeNewLines(e,t)),this.didEverRender&&this.text===e&&this.title===i&&r.equals(this.highlights,t)||(this.text=e,this.title=i,this.highlights=t,this.render())}render(){const e=[];let t=0;for(const i of this.highlights){if(i.end===i.start)continue;if(t<i.start){const r=this.text.substring(t,i.start);e.push(n.$("span",void 0,...this.supportIcons?(0,o.renderLabelWithIcons)(r):[r])),t=i.end}const r=this.text.substring(i.start,i.end),s=n.$("span.highlight",void 0,...this.supportIcons?(0,o.renderLabelWithIcons)(r):[r]);i.extraClasses&&s.classList.add(...i.extraClasses),e.push(s),t=i.end}if(t<this.text.length){const i=this.text.substring(t);e.push(n.$("span",void 0,...this.supportIcons?(0,o.renderLabelWithIcons)(i):[i]))}n.reset(this.domNode,...e),this.title?this.domNode.title=this.title:this.domNode.removeAttribute("title"),this.didEverRender=!0}static escapeNewLines(e,t){let i=0,n=0;return e.replace(/\r\n|\r|\n/g,((e,o)=>{n="\r\n"===e?-1:0,o+=i;for(const e of t)e.end<=o||(e.start>=o&&(e.start+=n),e.end>=o&&(e.end+=n));return i+=n,"⏎"}))}}},74838:function(e,t,i){"use strict";i.r(t),i.d(t,{IconLabel:function(){return S}});var n=i(93379),o=i.n(n),r=i(7795),s=i.n(r),a=i(90569),l=i.n(a),c=i(3565),d=i.n(c),u=i(19216),h=i.n(u),g=i(44589),p=i.n(g),m=i(3293),f={};f.styleTagTransform=p(),f.setAttributes=d(),f.insert=l().bind(null,"head"),f.domAPI=s(),f.insertStyleElement=h();o()(m.Z,f),m.Z&&m.Z.locals&&m.Z.locals;var b=i(96747),_=i(6360),A=i(2720),v=i(68921),C=i(91057),w=i(83682);class y{constructor(e){this._element=e}get element(){return this._element}set textContent(e){this.disposed||e===this._textContent||(this._textContent=e,this._element.textContent=e)}set className(e){this.disposed||e===this._className||(this._className=e,this._element.className=e)}set empty(e){this.disposed||e===this._empty||(this._empty=e,this._element.style.marginLeft=e?"0":"")}dispose(){this.disposed=!0}}class S extends v.Disposable{constructor(e,t){super(),this.customHovers=new Map,this.domNode=this._register(new y(b.append(e,b.$(".monaco-icon-label")))),this.labelContainer=b.append(this.domNode.element,b.$(".monaco-icon-label-container"));const i=b.append(this.labelContainer,b.$("span.monaco-icon-name-container"));this.descriptionContainer=this._register(new y(b.append(this.labelContainer,b.$("span.monaco-icon-description-container")))),(null==t?void 0:t.supportHighlights)||(null==t?void 0:t.supportIcons)?this.nameNode=new E(i,!!t.supportIcons):this.nameNode=new x(i),(null==t?void 0:t.supportDescriptionHighlights)?this.descriptionNodeFactory=()=>new _.HighlightedLabel(b.append(this.descriptionContainer.element,b.$("span.label-description")),{supportIcons:!!t.supportIcons}):this.descriptionNodeFactory=()=>this._register(new y(b.append(this.descriptionContainer.element,b.$("span.label-description")))),this.hoverDelegate=null==t?void 0:t.hoverDelegate}get element(){return this.domNode.element}setLabel(e,t,i){const n=["monaco-icon-label"];i&&(i.extraClasses&&n.push(...i.extraClasses),i.italic&&n.push("italic"),i.strikethrough&&n.push("strikethrough")),this.domNode.className=n.join(" "),this.setupHover((null==i?void 0:i.descriptionTitle)?this.labelContainer:this.element,null==i?void 0:i.title),this.nameNode.setLabel(e,i),(t||this.descriptionNode)&&(this.descriptionNode||(this.descriptionNode=this.descriptionNodeFactory()),this.descriptionNode instanceof _.HighlightedLabel?(this.descriptionNode.set(t||"",i?i.descriptionMatches:void 0),this.setupHover(this.descriptionNode.element,null==i?void 0:i.descriptionTitle)):(this.descriptionNode.textContent=t||"",this.setupHover(this.descriptionNode.element,(null==i?void 0:i.descriptionTitle)||""),this.descriptionNode.empty=!t))}setupHover(e,t){const i=this.customHovers.get(e);if(i&&(i.dispose(),this.customHovers.delete(e)),t)if(this.hoverDelegate){const i=(0,A.setupCustomHover)(this.hoverDelegate,e,t);i&&this.customHovers.set(e,i)}else(0,A.setupNativeHover)(e,t);else e.removeAttribute("title")}dispose(){super.dispose();for(const e of this.customHovers.values())e.dispose();this.customHovers.clear()}}class x{constructor(e){this.container=e,this.label=void 0,this.singleLabel=void 0}setLabel(e,t){if(this.label!==e||!(0,C.equals)(this.options,t))if(this.label=e,this.options=t,"string"==typeof e)this.singleLabel||(this.container.innerText="",this.container.classList.remove("multiple"),this.singleLabel=b.append(this.container,b.$("a.label-name",{id:null==t?void 0:t.domId}))),this.singleLabel.textContent=e;else{this.container.innerText="",this.container.classList.add("multiple"),this.singleLabel=void 0;for(let i=0;i<e.length;i++){const n=e[i],o=(null==t?void 0:t.domId)&&`${null==t?void 0:t.domId}_${i}`;b.append(this.container,b.$("a.label-name",{id:o,"data-icon-label-count":e.length,"data-icon-label-index":i,role:"treeitem"},n)),i<e.length-1&&b.append(this.container,b.$("span.label-separator",void 0,(null==t?void 0:t.separator)||"/"))}}}}class E{constructor(e,t){this.container=e,this.supportIcons=t,this.label=void 0,this.singleLabel=void 0}setLabel(e,t){if(this.label!==e||!(0,C.equals)(this.options,t))if(this.label=e,this.options=t,"string"==typeof e)this.singleLabel||(this.container.innerText="",this.container.classList.remove("multiple"),this.singleLabel=new _.HighlightedLabel(b.append(this.container,b.$("a.label-name",{id:null==t?void 0:t.domId})),{supportIcons:this.supportIcons})),this.singleLabel.set(e,null==t?void 0:t.matches,void 0,null==t?void 0:t.labelEscapeNewLines);else{this.container.innerText="",this.container.classList.add("multiple"),this.singleLabel=void 0;const i=(null==t?void 0:t.separator)||"/",n=function(e,t,i){if(!i)return;let n=0;return e.map((e=>{const o={start:n,end:n+e.length},r=i.map((e=>w.Range.intersect(o,e))).filter((e=>!w.Range.isEmpty(e))).map((({start:e,end:t})=>({start:e-n,end:t-n})));return n=o.end+t.length,r}))}(e,i,null==t?void 0:t.matches);for(let o=0;o<e.length;o++){const r=e[o],s=n?n[o]:void 0,a=(null==t?void 0:t.domId)&&`${null==t?void 0:t.domId}_${o}`,l=b.$("a.label-name",{id:a,"data-icon-label-count":e.length,"data-icon-label-index":o,role:"treeitem"});new _.HighlightedLabel(b.append(this.container,l),{supportIcons:this.supportIcons}).set(r,s,void 0,null==t?void 0:t.labelEscapeNewLines),o<e.length-1&&b.append(l,b.$("span.label-separator",void 0,i))}}}}},2720:function(e,t,i){"use strict";i.r(t),i.d(t,{setupCustomHover:function(){return p},setupNativeHover:function(){return h}});var n=i(96747),o=i(66129),r=i(11256),s=i(25674),a=i(69373),l=i(68921),c=i(18912),d=i(83787),u=function(e,t,i,n){return new(i||(i=Promise))((function(o,r){function s(e){try{l(n.next(e))}catch(e){r(e)}}function a(e){try{l(n.throw(e))}catch(e){r(e)}}function l(e){var t;e.done?o(e.value):(t=e.value,t instanceof i?t:new i((function(e){e(t)}))).then(s,a)}l((n=n.apply(e,t||[])).next())}))};function h(e,t){(0,c.isString)(t)?e.title=(0,a.stripIcons)(t):(null==t?void 0:t.markdownNotSupportedFallback)?e.title=t.markdownNotSupportedFallback:e.removeAttribute("title")}class g{constructor(e,t,i){this.hoverDelegate=e,this.target=t,this.fadeInAnimation=i}update(e,t,i){var n;return u(this,void 0,void 0,(function*(){if(this._cancellationTokenSource&&(this._cancellationTokenSource.dispose(!0),this._cancellationTokenSource=void 0),this.isDisposed)return;let o;if(void 0===e||(0,c.isString)(e)||e instanceof HTMLElement)o=e;else if((0,c.isFunction)(e.markdown)){this._hoverWidget||this.show((0,d.localize)("vs/base/browser/ui/iconLabel/iconLabelHover","iconLabel.loading","Loading..."),t),this._cancellationTokenSource=new r.CancellationTokenSource;const i=this._cancellationTokenSource.token;if(o=yield e.markdown(i),void 0===o&&(o=e.markdownNotSupportedFallback),this.isDisposed||i.isCancellationRequested)return}else o=null!==(n=e.markdown)&&void 0!==n?n:e.markdownNotSupportedFallback;this.show(o,t,i)}))}show(e,t,i){const n=this._hoverWidget;if(this.hasContent(e)){const o=Object.assign({content:e,target:this.target,showPointer:"element"===this.hoverDelegate.placement,hoverPosition:2,skipFadeInAnimation:!this.fadeInAnimation||!!n},i);this._hoverWidget=this.hoverDelegate.showHover(o,t)}null==n||n.dispose()}hasContent(e){return!!e&&(!(0,s.isMarkdownString)(e)||!!e.value)}get isDisposed(){var e;return null===(e=this._hoverWidget)||void 0===e?void 0:e.isDisposed}dispose(){var e,t;null===(e=this._hoverWidget)||void 0===e||e.dispose(),null===(t=this._cancellationTokenSource)||void 0===t||t.dispose(!0),this._cancellationTokenSource=void 0}}function p(e,t,i,r){let s,a;const c=(t,i)=>{var n;t&&(null==a||a.dispose(),a=void 0),i&&(null==s||s.dispose(),s=void 0),null===(n=e.onDidHideHover)||void 0===n||n.call(e)},d=(n,s,l)=>new o.TimeoutTimer((()=>u(this,void 0,void 0,(function*(){a&&!a.isDisposed||(a=new g(e,l||t,n>0),yield a.update(i,s,r))}))),n),h=n.addDisposableListener(t,n.EventType.MOUSE_OVER,(()=>{if(s)return;const i=new l.DisposableStore;i.add(n.addDisposableListener(t,n.EventType.MOUSE_LEAVE,(e=>c(!1,e.fromElement===t)),!0));i.add(n.addDisposableListener(t,n.EventType.MOUSE_DOWN,(()=>c(!0,!0)),!0));const o={targetElements:[t],dispose:()=>{}};if(void 0===e.placement||"mouse"===e.placement){const e=e=>{o.x=e.x+10,e.target instanceof HTMLElement&&e.target.classList.contains("action-label")&&c(!0,!0)};i.add(n.addDisposableListener(t,n.EventType.MOUSE_MOVE,e,!0))}i.add(d(e.delay,!1,o)),s=i}),!0);return{show:e=>{c(!1,!0),d(0,e)},hide:()=>{c(!0,!0)},update:(e,t)=>u(this,void 0,void 0,(function*(){i=e,yield null==a?void 0:a.update(i,void 0,t)})),dispose:()=>{h.dispose(),c(!0,!0)}}}},21348:function(e,t,i){"use strict";i.r(t),i.d(t,{renderIcon:function(){return a},renderLabelWithIcons:function(){return s}});var n=i(96747),o=i(56087);const r=new RegExp(`(\\\\)?\\$\\((${o.CSSIcon.iconNameExpression}(?:${o.CSSIcon.iconModifierExpression})?)\\)`,"g");function s(e){const t=new Array;let i,n=0,o=0;for(;null!==(i=r.exec(e));){o=i.index||0,t.push(e.substring(n,o)),n=(i.index||0)+i[0].length;const[,r,s]=i;t.push(r?`$(${s})`:a({id:s}))}return n<e.length&&t.push(e.substring(n)),t}function a(e){const t=n.$("span");return t.classList.add(...o.CSSIcon.asClassNameArray(e)),t}},25802:function(e,t,i){"use strict";i.r(t),i.d(t,{HistoryInputBox:function(){return M},InputBox:function(){return T}});var n=i(96747),o=i(50465),r=i(94264),s=i(31532),a=i(61950),l=i(34309),c=i(47257),d=i(17160),u=i(63801),h=i(68538),g=i(91057),p=i(93379),m=i.n(p),f=i(7795),b=i.n(f),_=i(90569),A=i.n(_),v=i(3565),C=i.n(v),w=i(19216),y=i.n(w),S=i(44589),x=i.n(S),E=i(24695),k={};k.styleTagTransform=x(),k.setAttributes=C(),k.insert=A().bind(null,"head"),k.domAPI=b(),k.insertStyleElement=y();m()(E.Z,k),E.Z&&E.Z.locals&&E.Z.locals;var I=i(83787);const D=n.$,L={inputBackground:d.Color.fromHex("#3C3C3C"),inputForeground:d.Color.fromHex("#CCCCCC"),inputValidationInfoBorder:d.Color.fromHex("#55AAFF"),inputValidationInfoBackground:d.Color.fromHex("#063B49"),inputValidationWarningBorder:d.Color.fromHex("#B89500"),inputValidationWarningBackground:d.Color.fromHex("#352A05"),inputValidationErrorBorder:d.Color.fromHex("#BE1100"),inputValidationErrorBackground:d.Color.fromHex("#5A1D1D")};class T extends c.Widget{constructor(e,t,i){var r;super(),this.state="idle",this.maxHeight=Number.POSITIVE_INFINITY,this._onDidChange=this._register(new u.Emitter),this.onDidChange=this._onDidChange.event,this._onDidHeightChange=this._register(new u.Emitter),this.onDidHeightChange=this._onDidHeightChange.event,this.contextViewProvider=t,this.options=i||Object.create(null),(0,g.mixin)(this.options,L,!1),this.message=null,this.placeholder=this.options.placeholder||"",this.tooltip=null!==(r=this.options.tooltip)&&void 0!==r?r:this.placeholder||"",this.ariaLabel=this.options.ariaLabel||"",this.inputBackground=this.options.inputBackground,this.inputForeground=this.options.inputForeground,this.inputBorder=this.options.inputBorder,this.inputValidationInfoBorder=this.options.inputValidationInfoBorder,this.inputValidationInfoBackground=this.options.inputValidationInfoBackground,this.inputValidationInfoForeground=this.options.inputValidationInfoForeground,this.inputValidationWarningBorder=this.options.inputValidationWarningBorder,this.inputValidationWarningBackground=this.options.inputValidationWarningBackground,this.inputValidationWarningForeground=this.options.inputValidationWarningForeground,this.inputValidationErrorBorder=this.options.inputValidationErrorBorder,this.inputValidationErrorBackground=this.options.inputValidationErrorBackground,this.inputValidationErrorForeground=this.options.inputValidationErrorForeground,this.options.validationOptions&&(this.validation=this.options.validationOptions.validation),this.element=n.append(e,D(".monaco-inputbox.idle"));const a=this.options.flexibleHeight?"textarea":"input",c=n.append(this.element,D(".ibwrapper"));if(this.input=n.append(c,D(a+".input.empty")),this.input.setAttribute("autocorrect","off"),this.input.setAttribute("autocapitalize","off"),this.input.setAttribute("spellcheck","false"),this.onfocus(this.input,(()=>this.element.classList.add("synthetic-focus"))),this.onblur(this.input,(()=>this.element.classList.remove("synthetic-focus"))),this.options.flexibleHeight){this.maxHeight="number"==typeof this.options.flexibleMaxHeight?this.options.flexibleMaxHeight:Number.POSITIVE_INFINITY,this.mirror=n.append(c,D("div.mirror")),this.mirror.innerText=" ",this.scrollableElement=new l.ScrollableElement(this.element,{vertical:1}),this.options.flexibleWidth&&(this.input.setAttribute("wrap","off"),this.mirror.style.whiteSpace="pre",this.mirror.style.wordWrap="initial"),n.append(e,this.scrollableElement.getDomNode()),this._register(this.scrollableElement),this._register(this.scrollableElement.onScroll((e=>this.input.scrollTop=e.scrollTop)));const t=this._register(new o.DomEmitter(document,"selectionchange")),i=u.Event.filter(t.event,(()=>{const e=document.getSelection();return(null==e?void 0:e.anchorNode)===c}));this._register(i(this.updateScrollDimensions,this)),this._register(this.onDidHeightChange(this.updateScrollDimensions,this))}else this.input.type=this.options.type||"text",this.input.setAttribute("wrap","off");this.ariaLabel&&this.input.setAttribute("aria-label",this.ariaLabel),this.placeholder&&!this.options.showPlaceholderOnFocus&&this.setPlaceHolder(this.placeholder),this.tooltip&&this.setTooltip(this.tooltip),this.oninput(this.input,(()=>this.onValueChange())),this.onblur(this.input,(()=>this.onBlur())),this.onfocus(this.input,(()=>this.onFocus())),this.ignoreGesture(this.input),setTimeout((()=>this.updateMirror()),0),this.options.actions&&(this.actionbar=this._register(new s.ActionBar(this.element)),this.actionbar.push(this.options.actions,{icon:!0,label:!1})),this.applyStyles()}onBlur(){this._hideMessage(),this.options.showPlaceholderOnFocus&&this.input.setAttribute("placeholder","")}onFocus(){this._showMessage(),this.options.showPlaceholderOnFocus&&this.input.setAttribute("placeholder",this.placeholder||"")}setPlaceHolder(e){this.placeholder=e,this.input.setAttribute("placeholder",e)}setTooltip(e){this.tooltip=e,this.input.title=e}setAriaLabel(e){this.ariaLabel=e,e?this.input.setAttribute("aria-label",this.ariaLabel):this.input.removeAttribute("aria-label")}getAriaLabel(){return this.ariaLabel}get inputElement(){return this.input}get value(){return this.input.value}set value(e){this.input.value!==e&&(this.input.value=e,this.onValueChange())}get height(){return"number"==typeof this.cachedHeight?this.cachedHeight:n.getTotalHeight(this.element)}focus(){this.input.focus()}blur(){this.input.blur()}hasFocus(){return document.activeElement===this.input}select(e=null){this.input.select(),e&&(this.input.setSelectionRange(e.start,e.end),e.end===this.input.value.length&&(this.input.scrollLeft=this.input.scrollWidth))}isSelectionAtEnd(){return this.input.selectionEnd===this.input.value.length&&this.input.selectionStart===this.input.selectionEnd}enable(){this.input.removeAttribute("disabled")}disable(){this.blur(),this.input.disabled=!0,this._hideMessage()}get width(){return n.getTotalWidth(this.input)}set width(e){if(this.options.flexibleHeight&&this.options.flexibleWidth){let t=0;if(this.mirror){t=(parseFloat(this.mirror.style.paddingLeft||"")||0)+(parseFloat(this.mirror.style.paddingRight||"")||0)}this.input.style.width=e-t+"px"}else this.input.style.width=e+"px";this.mirror&&(this.mirror.style.width=e+"px")}set paddingRight(e){this.input.style.width=`calc(100% - ${e}px)`,this.mirror&&(this.mirror.style.paddingRight=e+"px")}updateScrollDimensions(){if("number"!=typeof this.cachedContentHeight||"number"!=typeof this.cachedHeight||!this.scrollableElement)return;const e=this.cachedContentHeight,t=this.cachedHeight,i=this.input.scrollTop;this.scrollableElement.setScrollDimensions({scrollHeight:e,height:t}),this.scrollableElement.setScrollPosition({scrollTop:i})}showMessage(e,t){this.message=e,this.element.classList.remove("idle"),this.element.classList.remove("info"),this.element.classList.remove("warning"),this.element.classList.remove("error"),this.element.classList.add(this.classForType(e.type));const i=this.stylesForType(this.message.type);this.element.style.border=i.border?`1px solid ${i.border}`:"",(this.hasFocus()||t)&&this._showMessage()}hideMessage(){this.message=null,this.element.classList.remove("info"),this.element.classList.remove("warning"),this.element.classList.remove("error"),this.element.classList.add("idle"),this._hideMessage(),this.applyStyles()}validate(){let e=null;return this.validation&&(e=this.validation(this.value),e?(this.inputElement.setAttribute("aria-invalid","true"),this.showMessage(e)):this.inputElement.hasAttribute("aria-invalid")&&(this.inputElement.removeAttribute("aria-invalid"),this.hideMessage())),null==e?void 0:e.type}stylesForType(e){switch(e){case 1:return{border:this.inputValidationInfoBorder,background:this.inputValidationInfoBackground,foreground:this.inputValidationInfoForeground};case 2:return{border:this.inputValidationWarningBorder,background:this.inputValidationWarningBackground,foreground:this.inputValidationWarningForeground};default:return{border:this.inputValidationErrorBorder,background:this.inputValidationErrorBackground,foreground:this.inputValidationErrorForeground}}}classForType(e){switch(e){case 1:return"info";case 2:return"warning";default:return"error"}}_showMessage(){if(!this.contextViewProvider||!this.message)return;let e;const t=()=>e.style.width=n.getTotalWidth(this.element)+"px";let i;this.contextViewProvider.showContextView({getAnchor:()=>this.element,anchorAlignment:1,render:i=>{if(!this.message)return null;e=n.append(i,D(".monaco-inputbox-container")),t();const o={inline:!0,className:"monaco-inputbox-message"},s=this.message.formatContent?(0,r.renderFormattedText)(this.message.content,o):(0,r.renderText)(this.message.content,o);s.classList.add(this.classForType(this.message.type));const a=this.stylesForType(this.message.type);return s.style.backgroundColor=a.background?a.background.toString():"",s.style.color=a.foreground?a.foreground.toString():"",s.style.border=a.border?`1px solid ${a.border}`:"",n.append(e,s),null},onHide:()=>{this.state="closed"},layout:t}),i=3===this.message.type?I.localize("vs/base/browser/ui/inputbox/inputBox","alertErrorMessage","Error: {0}",this.message.content):2===this.message.type?I.localize("vs/base/browser/ui/inputbox/inputBox","alertWarningMessage","Warning: {0}",this.message.content):I.localize("vs/base/browser/ui/inputbox/inputBox","alertInfoMessage","Info: {0}",this.message.content),a.alert(i),this.state="open"}_hideMessage(){this.contextViewProvider&&("open"===this.state&&this.contextViewProvider.hideContextView(),this.state="idle")}onValueChange(){this._onDidChange.fire(this.value),this.validate(),this.updateMirror(),this.input.classList.toggle("empty",!this.value),"open"===this.state&&this.contextViewProvider&&this.contextViewProvider.layout()}updateMirror(){if(!this.mirror)return;const e=this.value,t=10===e.charCodeAt(e.length-1)?" ":"";(e+t).replace(/\u000c/g,"")?this.mirror.textContent=e+t:this.mirror.innerText=" ",this.layout()}style(e){this.inputBackground=e.inputBackground,this.inputForeground=e.inputForeground,this.inputBorder=e.inputBorder,this.inputValidationInfoBackground=e.inputValidationInfoBackground,this.inputValidationInfoForeground=e.inputValidationInfoForeground,this.inputValidationInfoBorder=e.inputValidationInfoBorder,this.inputValidationWarningBackground=e.inputValidationWarningBackground,this.inputValidationWarningForeground=e.inputValidationWarningForeground,this.inputValidationWarningBorder=e.inputValidationWarningBorder,this.inputValidationErrorBackground=e.inputValidationErrorBackground,this.inputValidationErrorForeground=e.inputValidationErrorForeground,this.inputValidationErrorBorder=e.inputValidationErrorBorder,this.applyStyles()}applyStyles(){const e=this.inputBackground?this.inputBackground.toString():"",t=this.inputForeground?this.inputForeground.toString():"",i=this.inputBorder?this.inputBorder.toString():"";this.element.style.backgroundColor=e,this.element.style.color=t,this.input.style.backgroundColor="inherit",this.input.style.color=t,this.element.style.borderWidth=i?"1px":"",this.element.style.borderStyle=i?"solid":"",this.element.style.borderColor=i}layout(){if(!this.mirror)return;const e=this.cachedContentHeight;this.cachedContentHeight=n.getTotalHeight(this.mirror),e!==this.cachedContentHeight&&(this.cachedHeight=Math.min(this.cachedContentHeight,this.maxHeight),this.input.style.height=this.cachedHeight+"px",this._onDidHeightChange.fire(this.cachedContentHeight))}insertAtCursor(e){const t=this.inputElement,i=t.selectionStart,n=t.selectionEnd,o=t.value;null!==i&&null!==n&&(this.value=o.substr(0,i)+e+o.substr(n),t.setSelectionRange(i+1,i+1),this.layout())}dispose(){this._hideMessage(),this.message=null,this.actionbar&&this.actionbar.dispose(),super.dispose()}}class M extends T{constructor(e,t,i){const n=I.localize("vs/base/browser/ui/inputbox/inputBox",{key:"history.inputbox.hint",comment:["Text will be prefixed with ⇅ plus a single space, then used as a hint where input field keeps history"]},"for history"),o=` or ⇅ ${n}`,r=` (⇅ ${n})`;super(e,t,i),this._onDidFocus=this._register(new u.Emitter),this.onDidFocus=this._onDidFocus.event,this._onDidBlur=this._register(new u.Emitter),this.onDidBlur=this._onDidBlur.event,this.history=new h.HistoryNavigator(i.history,100);const s=()=>{if(i.showHistoryHint&&i.showHistoryHint()&&!this.placeholder.endsWith(o)&&!this.placeholder.endsWith(r)&&this.history.getHistory().length){const e=this.placeholder.endsWith(")")?o:r,t=this.placeholder+e;i.showPlaceholderOnFocus&&document.activeElement!==this.input?this.placeholder=t:this.setPlaceHolder(t)}};this.observer=new MutationObserver(((e,t)=>{e.forEach((e=>{e.target.textContent||s()}))})),this.observer.observe(this.input,{attributeFilter:["class"]}),this.onfocus(this.input,(()=>s())),this.onblur(this.input,(()=>{const e=e=>{if(this.placeholder.endsWith(e)){const t=this.placeholder.slice(0,this.placeholder.length-e.length);return i.showPlaceholderOnFocus?this.placeholder=t:this.setPlaceHolder(t),!0}return!1};e(r)||e(o)}))}dispose(){super.dispose(),this.observer&&(this.observer.disconnect(),this.observer=void 0)}addToHistory(){this.value&&this.value!==this.getCurrentValue()&&this.history.add(this.value)}showNextValue(){this.history.has(this.value)||this.addToHistory();let e=this.getNextValue();e&&(e=e===this.value?this.getNextValue():e),e&&(this.value=e,a.status(this.value))}showPreviousValue(){this.history.has(this.value)||this.addToHistory();let e=this.getPreviousValue();e&&(e=e===this.value?this.getPreviousValue():e),e&&(this.value=e,a.status(this.value))}onBlur(){super.onBlur(),this._onDidBlur.fire()}onFocus(){super.onFocus(),this._onDidFocus.fire()}getCurrentValue(){let e=this.history.current();return e||(e=this.history.last(),this.history.next()),e}getPreviousValue(){return this.history.previous()||this.history.first()}getNextValue(){return this.history.next()||this.history.last()}}},91120:function(e,t,i){"use strict";i.r(t),i.d(t,{KeybindingLabel:function(){return w}});var n=i(96747),o=i(20693),r=i(91057),s=i(93379),a=i.n(s),l=i(7795),c=i.n(l),d=i(90569),u=i.n(d),h=i(3565),g=i.n(h),p=i(19216),m=i.n(p),f=i(44589),b=i.n(f),_=i(7896),A={};A.styleTagTransform=b(),A.setAttributes=g(),A.insert=u().bind(null,"head"),A.domAPI=c(),A.insertStyleElement=m();a()(_.Z,A),_.Z&&_.Z.locals&&_.Z.locals;var v=i(83787);const C=n.$;class w{constructor(e,t,i){this.os=t,this.keyElements=new Set,this.options=i||Object.create(null),this.labelBackground=this.options.keybindingLabelBackground,this.labelForeground=this.options.keybindingLabelForeground,this.labelBorder=this.options.keybindingLabelBorder,this.labelBottomBorder=this.options.keybindingLabelBottomBorder,this.labelShadow=this.options.keybindingLabelShadow,this.domNode=n.append(e,C(".monaco-keybinding")),this.didEverRender=!1,e.appendChild(this.domNode)}get element(){return this.domNode}set(e,t){this.didEverRender&&this.keybinding===e&&w.areSame(this.matches,t)||(this.keybinding=e,this.matches=t,this.render())}render(){if(this.clear(),this.keybinding){const[e,t]=this.keybinding.getParts();e&&this.renderPart(this.domNode,e,this.matches?this.matches.firstPart:null),t&&(n.append(this.domNode,C("span.monaco-keybinding-key-chord-separator",void 0," ")),this.renderPart(this.domNode,t,this.matches?this.matches.chordPart:null)),this.domNode.title=this.keybinding.getAriaLabel()||""}else this.options&&this.options.renderUnboundKeybindings&&this.renderUnbound(this.domNode);this.applyStyles(),this.didEverRender=!0}clear(){n.clearNode(this.domNode),this.keyElements.clear()}renderPart(e,t,i){const n=o.UILabelProvider.modifierLabels[this.os];t.ctrlKey&&this.renderKey(e,n.ctrlKey,Boolean(null==i?void 0:i.ctrlKey),n.separator),t.shiftKey&&this.renderKey(e,n.shiftKey,Boolean(null==i?void 0:i.shiftKey),n.separator),t.altKey&&this.renderKey(e,n.altKey,Boolean(null==i?void 0:i.altKey),n.separator),t.metaKey&&this.renderKey(e,n.metaKey,Boolean(null==i?void 0:i.metaKey),n.separator);const r=t.keyLabel;r&&this.renderKey(e,r,Boolean(null==i?void 0:i.keyCode),"")}renderKey(e,t,i,o){n.append(e,this.createKeyElement(t,i?".highlight":"")),o&&n.append(e,C("span.monaco-keybinding-key-separator",void 0,o))}renderUnbound(e){n.append(e,this.createKeyElement((0,v.localize)("vs/base/browser/ui/keybindingLabel/keybindingLabel","unbound","Unbound")))}createKeyElement(e,t=""){const i=C("span.monaco-keybinding-key"+t,void 0,e);return this.keyElements.add(i),i}style(e){this.labelBackground=e.keybindingLabelBackground,this.labelForeground=e.keybindingLabelForeground,this.labelBorder=e.keybindingLabelBorder,this.labelBottomBorder=e.keybindingLabelBottomBorder,this.labelShadow=e.keybindingLabelShadow,this.applyStyles()}applyStyles(){var e;if(this.element){for(const t of this.keyElements)this.labelBackground&&(t.style.backgroundColor=null===(e=this.labelBackground)||void 0===e?void 0:e.toString()),this.labelBorder&&(t.style.borderColor=this.labelBorder.toString()),this.labelBottomBorder&&(t.style.borderBottomColor=this.labelBottomBorder.toString()),this.labelShadow&&(t.style.boxShadow=`inset 0 -1px 0 ${this.labelShadow}`);this.labelForeground&&(this.element.style.color=this.labelForeground.toString())}}static areSame(e,t){return e===t||!e&&!t||!!e&&!!t&&(0,r.equals)(e.firstPart,t.firstPart)&&(0,r.equals)(e.chordPart,t.chordPart)}}},40083:function(e,t,i){"use strict";i.r(t),i.d(t,{ListError:function(){return n}});class n extends Error{constructor(e,t){super(`ListError [${e}] ${t}`)}}},17659:function(e,t,i){"use strict";i.r(t),i.d(t,{PagedList:function(){return d}});var n=i(64998),o=i(11256),r=i(63801),s=i(68921),a=(i(82833),i(72406));class l{constructor(e,t){this.renderer=e,this.modelProvider=t}get templateId(){return this.renderer.templateId}renderTemplate(e){return{data:this.renderer.renderTemplate(e),disposable:s.Disposable.None}}renderElement(e,t,i,n){if(i.disposable&&i.disposable.dispose(),!i.data)return;const r=this.modelProvider();if(r.isResolved(e))return this.renderer.renderElement(r.get(e),e,i.data,n);const s=new o.CancellationTokenSource,a=r.resolve(e,s.token);i.disposable={dispose:()=>s.cancel()},this.renderer.renderPlaceholder(e,i.data),a.then((t=>this.renderer.renderElement(t,e,i.data,n)))}disposeTemplate(e){e.disposable&&(e.disposable.dispose(),e.disposable=void 0),e.data&&(this.renderer.disposeTemplate(e.data),e.data=void 0)}}class c{constructor(e,t){this.modelProvider=e,this.accessibilityProvider=t}getWidgetAriaLabel(){return this.accessibilityProvider.getWidgetAriaLabel()}getAriaLabel(e){const t=this.modelProvider();return t.isResolved(e)?this.accessibilityProvider.getAriaLabel(t.get(e)):null}}class d{constructor(e,t,i,n,o={}){const r=()=>this.model,s=n.map((e=>new l(e,r)));this.list=new a.List(e,t,i,s,function(e,t){return Object.assign(Object.assign({},t),{accessibilityProvider:t.accessibilityProvider&&new c(e,t.accessibilityProvider)})}(r,o))}updateOptions(e){this.list.updateOptions(e)}getHTMLElement(){return this.list.getHTMLElement()}get onDidFocus(){return this.list.onDidFocus}get onDidDispose(){return this.list.onDidDispose}get onMouseDblClick(){return r.Event.map(this.list.onMouseDblClick,(({element:e,index:t,browserEvent:i})=>({element:void 0===e?void 0:this._model.get(e),index:t,browserEvent:i})))}get onPointer(){return r.Event.map(this.list.onPointer,(({element:e,index:t,browserEvent:i})=>({element:void 0===e?void 0:this._model.get(e),index:t,browserEvent:i})))}get onDidChangeSelection(){return r.Event.map(this.list.onDidChangeSelection,(({elements:e,indexes:t,browserEvent:i})=>({elements:e.map((e=>this._model.get(e))),indexes:t,browserEvent:i})))}get model(){return this._model}set model(e){this._model=e,this.list.splice(0,this.list.length,(0,n.range)(e.length))}getFocus(){return this.list.getFocus()}getSelection(){return this.list.getSelection()}getSelectedElements(){return this.getSelection().map((e=>this.model.get(e)))}style(e){this.list.style(e)}dispose(){this.list.dispose()}}},75291:function(e,t,i){"use strict";i.r(t),i.d(t,{ElementsDragAndDropData:function(){return v},ExternalElementsDragAndDropData:function(){return C},ListView:function(){return S},NativeDragAndDropData:function(){return w}});var n=i(76736),o=i(65174),r=i(96747),s=i(50465),a=i(4043),l=i(34309),c=i(64998),d=i(66129),u=i(63966),h=i(63801),g=i(68921),p=i(83682),m=i(6097),f=i(37218),b=i(1056),_=function(e,t,i,n){var o,r=arguments.length,s=r<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,i):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)s=Reflect.decorate(e,t,i,n);else for(var a=e.length-1;a>=0;a--)(o=e[a])&&(s=(r<3?o(s):r>3?o(t,i,s):o(t,i))||s);return r>3&&s&&Object.defineProperty(t,i,s),s};const A={useShadows:!0,verticalScrollMode:1,setRowLineHeight:!0,setRowHeight:!0,supportDynamicHeights:!1,dnd:{getDragElements(e){return[e]},getDragURI(){return null},onDragStart(){},onDragOver(){return!1},drop(){}},horizontalScrolling:!1,transformOptimization:!0,alwaysConsumeMouseWheel:!0};class v{constructor(e){this.elements=e}update(){}getData(){return this.elements}}class C{constructor(e){this.elements=e}update(){}getData(){return this.elements}}class w{constructor(){this.types=[],this.files=[]}update(e){if(e.types&&this.types.splice(0,this.types.length,...e.types),e.files){this.files.splice(0,this.files.length);for(let t=0;t<e.files.length;t++){const i=e.files.item(t);i&&(i.size||i.type)&&this.files.push(i)}}}getData(){return{types:this.types,files:this.files}}}class y{constructor(e){(null==e?void 0:e.getSetSize)?this.getSetSize=e.getSetSize.bind(e):this.getSetSize=(e,t,i)=>i,(null==e?void 0:e.getPosInSet)?this.getPosInSet=e.getPosInSet.bind(e):this.getPosInSet=(e,t)=>t+1,(null==e?void 0:e.getRole)?this.getRole=e.getRole.bind(e):this.getRole=e=>"listitem",(null==e?void 0:e.isChecked)?this.isChecked=e.isChecked.bind(e):this.isChecked=e=>{}}}class S{constructor(e,t,i,n=A){var o,s,c,u,p,_,v,C,w,x;if(this.virtualDelegate=t,this.domId="list_id_"+ ++S.InstanceCount,this.renderers=new Map,this.renderWidth=0,this._scrollHeight=0,this.scrollableElementUpdateDisposable=null,this.scrollableElementWidthDelayer=new d.Delayer(50),this.splicing=!1,this.dragOverAnimationStopDisposable=g.Disposable.None,this.dragOverMouseY=0,this.canDrop=!1,this.currentDragFeedbackDisposable=g.Disposable.None,this.onDragLeaveTimeout=g.Disposable.None,this.disposables=new g.DisposableStore,this._onDidChangeContentHeight=new h.Emitter,this._horizontalScrolling=!1,n.horizontalScrolling&&n.supportDynamicHeights)throw new Error("Horizontal scrolling and dynamic heights not supported simultaneously");this.items=[],this.itemId=0,this.rangeMap=new f.RangeMap;for(const e of i)this.renderers.set(e.templateId,e);this.cache=this.disposables.add(new b.RowCache(this.renderers)),this.lastRenderTop=0,this.lastRenderHeight=0,this.domNode=document.createElement("div"),this.domNode.className="monaco-list",this.domNode.classList.add(this.domId),this.domNode.tabIndex=0,this.domNode.classList.toggle("mouse-support","boolean"!=typeof n.mouseSupport||n.mouseSupport),this._horizontalScrolling=null!==(o=n.horizontalScrolling)&&void 0!==o?o:A.horizontalScrolling,this.domNode.classList.toggle("horizontal-scrolling",this._horizontalScrolling),this.additionalScrollHeight=void 0===n.additionalScrollHeight?0:n.additionalScrollHeight,this.accessibilityProvider=new y(n.accessibilityProvider),this.rowsContainer=document.createElement("div"),this.rowsContainer.className="monaco-list-rows";(null!==(s=n.transformOptimization)&&void 0!==s?s:A.transformOptimization)&&(this.rowsContainer.style.transform="translate3d(0px, 0px, 0px)"),this.disposables.add(a.Gesture.addTarget(this.rowsContainer)),this.scrollable=new m.Scrollable({forceIntegerValues:!0,smoothScrollDuration:null!==(c=n.smoothScrolling)&&void 0!==c&&c?125:0,scheduleAtNextAnimationFrame:e=>(0,r.scheduleAtNextAnimationFrame)(e)}),this.scrollableElement=this.disposables.add(new l.SmoothScrollableElement(this.rowsContainer,{alwaysConsumeMouseWheel:null!==(u=n.alwaysConsumeMouseWheel)&&void 0!==u?u:A.alwaysConsumeMouseWheel,horizontal:1,vertical:null!==(p=n.verticalScrollMode)&&void 0!==p?p:A.verticalScrollMode,useShadows:null!==(_=n.useShadows)&&void 0!==_?_:A.useShadows,mouseWheelScrollSensitivity:n.mouseWheelScrollSensitivity,fastScrollSensitivity:n.fastScrollSensitivity},this.scrollable)),this.domNode.appendChild(this.scrollableElement.getDomNode()),e.appendChild(this.domNode),this.scrollableElement.onScroll(this.onScroll,this,this.disposables),this.disposables.add((0,r.addDisposableListener)(this.rowsContainer,a.EventType.Change,(e=>this.onTouchChange(e)))),this.disposables.add((0,r.addDisposableListener)(this.scrollableElement.getDomNode(),"scroll",(e=>e.target.scrollTop=0))),this.disposables.add((0,r.addDisposableListener)(this.domNode,"dragover",(e=>this.onDragOver(this.toDragEvent(e))))),this.disposables.add((0,r.addDisposableListener)(this.domNode,"drop",(e=>this.onDrop(this.toDragEvent(e))))),this.disposables.add((0,r.addDisposableListener)(this.domNode,"dragleave",(e=>this.onDragLeave(this.toDragEvent(e))))),this.disposables.add((0,r.addDisposableListener)(this.domNode,"dragend",(e=>this.onDragEnd(e)))),this.setRowLineHeight=null!==(v=n.setRowLineHeight)&&void 0!==v?v:A.setRowLineHeight,this.setRowHeight=null!==(C=n.setRowHeight)&&void 0!==C?C:A.setRowHeight,this.supportDynamicHeights=null!==(w=n.supportDynamicHeights)&&void 0!==w?w:A.supportDynamicHeights,this.dnd=null!==(x=n.dnd)&&void 0!==x?x:A.dnd,this.layout()}get contentHeight(){return this.rangeMap.size}get horizontalScrolling(){return this._horizontalScrolling}set horizontalScrolling(e){if(e!==this._horizontalScrolling){if(e&&this.supportDynamicHeights)throw new Error("Horizontal scrolling and dynamic heights not supported simultaneously");if(this._horizontalScrolling=e,this.domNode.classList.toggle("horizontal-scrolling",this._horizontalScrolling),this._horizontalScrolling){for(const e of this.items)this.measureItemWidth(e);this.updateScrollWidth(),this.scrollableElement.setScrollDimensions({width:(0,r.getContentWidth)(this.domNode)}),this.rowsContainer.style.width=`${Math.max(this.scrollWidth||0,this.renderWidth)}px`}else this.scrollableElementWidthDelayer.cancel(),this.scrollableElement.setScrollDimensions({width:this.renderWidth,scrollWidth:this.renderWidth}),this.rowsContainer.style.width=""}}updateOptions(e){void 0!==e.additionalScrollHeight&&(this.additionalScrollHeight=e.additionalScrollHeight,this.scrollableElement.setScrollDimensions({scrollHeight:this.scrollHeight})),void 0!==e.smoothScrolling&&this.scrollable.setSmoothScrollDuration(e.smoothScrolling?125:0),void 0!==e.horizontalScrolling&&(this.horizontalScrolling=e.horizontalScrolling),void 0!==e.mouseWheelScrollSensitivity&&this.scrollableElement.updateOptions({mouseWheelScrollSensitivity:e.mouseWheelScrollSensitivity}),void 0!==e.fastScrollSensitivity&&this.scrollableElement.updateOptions({fastScrollSensitivity:e.fastScrollSensitivity})}splice(e,t,i=[]){if(this.splicing)throw new Error("Can't run recursive splices.");this.splicing=!0;try{return this._splice(e,t,i)}finally{this.splicing=!1,this._onDidChangeContentHeight.fire(this.contentHeight)}}_splice(e,t,i=[]){const n=this.getRenderRange(this.lastRenderTop,this.lastRenderHeight),o={start:e,end:e+t},r=p.Range.intersect(n,o),s=new Map;for(let e=r.end-1;e>=r.start;e--){const t=this.items[e];if(t.dragStartDisposable.dispose(),t.checkedDisposable.dispose(),t.row){let i=s.get(t.templateId);i||(i=[],s.set(t.templateId,i));const n=this.renderers.get(t.templateId);n&&n.disposeElement&&n.disposeElement(t.element,e,t.row.templateData,t.size),i.push(t.row)}t.row=null}const a={start:e+t,end:this.items.length},l=p.Range.intersect(a,n),c=p.Range.relativeComplement(a,n),d=i.map((e=>({id:String(this.itemId++),element:e,templateId:this.virtualDelegate.getTemplateId(e),size:this.virtualDelegate.getHeight(e),width:void 0,hasDynamicHeight:!!this.virtualDelegate.hasDynamicHeight&&this.virtualDelegate.hasDynamicHeight(e),lastDynamicHeightWidth:void 0,row:null,uri:void 0,dropTarget:!1,dragStartDisposable:g.Disposable.None,checkedDisposable:g.Disposable.None})));let u;0===e&&t>=this.items.length?(this.rangeMap=new f.RangeMap,this.rangeMap.splice(0,0,d),u=this.items,this.items=d):(this.rangeMap.splice(e,t,d),u=this.items.splice(e,t,...d));const h=i.length-t,m=this.getRenderRange(this.lastRenderTop,this.lastRenderHeight),b=(0,f.shift)(l,h),_=p.Range.intersect(m,b);for(let e=_.start;e<_.end;e++)this.updateItemInDOM(this.items[e],e);const A=p.Range.relativeComplement(b,m);for(const e of A)for(let t=e.start;t<e.end;t++)this.removeItemFromDOM(t);const v=c.map((e=>(0,f.shift)(e,h))),C=[{start:e,end:e+i.length},...v].map((e=>p.Range.intersect(m,e))),w=this.getNextToLastElement(C);for(const e of C)for(let t=e.start;t<e.end;t++){const e=this.items[t],i=s.get(e.templateId),n=null==i?void 0:i.pop();this.insertItemInDOM(t,w,n)}for(const e of s.values())for(const t of e)this.cache.release(t);return this.eventuallyUpdateScrollDimensions(),this.supportDynamicHeights&&this._rerender(this.scrollTop,this.renderHeight),u.map((e=>e.element))}eventuallyUpdateScrollDimensions(){this._scrollHeight=this.contentHeight,this.rowsContainer.style.height=`${this._scrollHeight}px`,this.scrollableElementUpdateDisposable||(this.scrollableElementUpdateDisposable=(0,r.scheduleAtNextAnimationFrame)((()=>{this.scrollableElement.setScrollDimensions({scrollHeight:this.scrollHeight}),this.updateScrollWidth(),this.scrollableElementUpdateDisposable=null})))}eventuallyUpdateScrollWidth(){this.horizontalScrolling?this.scrollableElementWidthDelayer.trigger((()=>this.updateScrollWidth())):this.scrollableElementWidthDelayer.cancel()}updateScrollWidth(){if(!this.horizontalScrolling)return;let e=0;for(const t of this.items)void 0!==t.width&&(e=Math.max(e,t.width));this.scrollWidth=e,this.scrollableElement.setScrollDimensions({scrollWidth:0===e?0:e+10})}rerender(){if(this.supportDynamicHeights){for(const e of this.items)e.lastDynamicHeightWidth=void 0;this._rerender(this.lastRenderTop,this.lastRenderHeight)}}get length(){return this.items.length}get renderHeight(){return this.scrollableElement.getScrollDimensions().height}element(e){return this.items[e].element}domElement(e){const t=this.items[e].row;return t&&t.domNode}elementHeight(e){return this.items[e].size}elementTop(e){return this.rangeMap.positionAt(e)}indexAt(e){return this.rangeMap.indexAt(e)}indexAfter(e){return this.rangeMap.indexAfter(e)}layout(e,t){const i={height:"number"==typeof e?e:(0,r.getContentHeight)(this.domNode)};this.scrollableElementUpdateDisposable&&(this.scrollableElementUpdateDisposable.dispose(),this.scrollableElementUpdateDisposable=null,i.scrollHeight=this.scrollHeight),this.scrollableElement.setScrollDimensions(i),void 0!==t&&(this.renderWidth=t,this.supportDynamicHeights&&this._rerender(this.scrollTop,this.renderHeight)),this.horizontalScrolling&&this.scrollableElement.setScrollDimensions({width:"number"==typeof t?t:(0,r.getContentWidth)(this.domNode)})}render(e,t,i,n,o,r=!1){const s=this.getRenderRange(t,i),a=p.Range.relativeComplement(s,e),l=p.Range.relativeComplement(e,s),c=this.getNextToLastElement(a);if(r){const t=p.Range.intersect(e,s);for(let e=t.start;e<t.end;e++)this.updateItemInDOM(this.items[e],e)}for(const e of a)for(let t=e.start;t<e.end;t++)this.insertItemInDOM(t,c);for(const e of l)for(let t=e.start;t<e.end;t++)this.removeItemFromDOM(t);void 0!==n&&(this.rowsContainer.style.left=`-${n}px`),this.rowsContainer.style.top=`-${t}px`,this.horizontalScrolling&&void 0!==o&&(this.rowsContainer.style.width=`${Math.max(o,this.renderWidth)}px`),this.lastRenderTop=t,this.lastRenderHeight=i}insertItemInDOM(e,t,i){const n=this.items[e];n.row||(n.row=null!=i?i:this.cache.alloc(n.templateId));const o=this.accessibilityProvider.getRole(n.element)||"listitem";n.row.domNode.setAttribute("role",o);const s=this.accessibilityProvider.isChecked(n.element);if("boolean"==typeof s)n.row.domNode.setAttribute("aria-checked",String(!!s));else if(s){const e=e=>n.row.domNode.setAttribute("aria-checked",String(!!e));e(s.value),n.checkedDisposable=s.onDidChange(e)}n.row.domNode.parentElement||(t?this.rowsContainer.insertBefore(n.row.domNode,t):this.rowsContainer.appendChild(n.row.domNode)),this.updateItemInDOM(n,e);const a=this.renderers.get(n.templateId);if(!a)throw new Error(`No renderer found for template id ${n.templateId}`);null==a||a.renderElement(n.element,e,n.row.templateData,n.size);const l=this.dnd.getDragURI(n.element);n.dragStartDisposable.dispose(),n.row.domNode.draggable=!!l,l&&(n.dragStartDisposable=(0,r.addDisposableListener)(n.row.domNode,"dragstart",(e=>this.onDragStart(n.element,l,e)))),this.horizontalScrolling&&(this.measureItemWidth(n),this.eventuallyUpdateScrollWidth())}measureItemWidth(e){if(!e.row||!e.row.domNode)return;e.row.domNode.style.width=n.isFirefox?"-moz-fit-content":"fit-content",e.width=(0,r.getContentWidth)(e.row.domNode);const t=window.getComputedStyle(e.row.domNode);t.paddingLeft&&(e.width+=parseFloat(t.paddingLeft)),t.paddingRight&&(e.width+=parseFloat(t.paddingRight)),e.row.domNode.style.width=""}updateItemInDOM(e,t){e.row.domNode.style.top=`${this.elementTop(t)}px`,this.setRowHeight&&(e.row.domNode.style.height=`${e.size}px`),this.setRowLineHeight&&(e.row.domNode.style.lineHeight=`${e.size}px`),e.row.domNode.setAttribute("data-index",`${t}`),e.row.domNode.setAttribute("data-last-element",t===this.length-1?"true":"false"),e.row.domNode.setAttribute("data-parity",t%2==0?"even":"odd"),e.row.domNode.setAttribute("aria-setsize",String(this.accessibilityProvider.getSetSize(e.element,t,this.length))),e.row.domNode.setAttribute("aria-posinset",String(this.accessibilityProvider.getPosInSet(e.element,t))),e.row.domNode.setAttribute("id",this.getElementDomId(t)),e.row.domNode.classList.toggle("drop-target",e.dropTarget)}removeItemFromDOM(e){const t=this.items[e];if(t.dragStartDisposable.dispose(),t.checkedDisposable.dispose(),t.row){const i=this.renderers.get(t.templateId);i&&i.disposeElement&&i.disposeElement(t.element,e,t.row.templateData,t.size),this.cache.release(t.row),t.row=null}this.horizontalScrolling&&this.eventuallyUpdateScrollWidth()}getScrollTop(){return this.scrollableElement.getScrollPosition().scrollTop}setScrollTop(e,t){this.scrollableElementUpdateDisposable&&(this.scrollableElementUpdateDisposable.dispose(),this.scrollableElementUpdateDisposable=null,this.scrollableElement.setScrollDimensions({scrollHeight:this.scrollHeight})),this.scrollableElement.setScrollPosition({scrollTop:e,reuseAnimation:t})}get scrollTop(){return this.getScrollTop()}set scrollTop(e){this.setScrollTop(e)}get scrollHeight(){return this._scrollHeight+(this.horizontalScrolling?10:0)+this.additionalScrollHeight}get onMouseClick(){return h.Event.map(this.disposables.add(new s.DomEmitter(this.domNode,"click")).event,(e=>this.toMouseEvent(e)),this.disposables)}get onMouseDblClick(){return h.Event.map(this.disposables.add(new s.DomEmitter(this.domNode,"dblclick")).event,(e=>this.toMouseEvent(e)),this.disposables)}get onMouseMiddleClick(){return h.Event.filter(h.Event.map(this.disposables.add(new s.DomEmitter(this.domNode,"auxclick")).event,(e=>this.toMouseEvent(e)),this.disposables),(e=>1===e.browserEvent.button),this.disposables)}get onMouseDown(){return h.Event.map(this.disposables.add(new s.DomEmitter(this.domNode,"mousedown")).event,(e=>this.toMouseEvent(e)),this.disposables)}get onMouseOver(){return h.Event.map(this.disposables.add(new s.DomEmitter(this.domNode,"mouseover")).event,(e=>this.toMouseEvent(e)),this.disposables)}get onContextMenu(){return h.Event.any(h.Event.map(this.disposables.add(new s.DomEmitter(this.domNode,"contextmenu")).event,(e=>this.toMouseEvent(e)),this.disposables),h.Event.map(this.disposables.add(new s.DomEmitter(this.domNode,a.EventType.Contextmenu)).event,(e=>this.toGestureEvent(e)),this.disposables))}get onTouchStart(){return h.Event.map(this.disposables.add(new s.DomEmitter(this.domNode,"touchstart")).event,(e=>this.toTouchEvent(e)),this.disposables)}get onTap(){return h.Event.map(this.disposables.add(new s.DomEmitter(this.rowsContainer,a.EventType.Tap)).event,(e=>this.toGestureEvent(e)),this.disposables)}toMouseEvent(e){const t=this.getItemIndexFromEventTarget(e.target||null),i=void 0===t?void 0:this.items[t];return{browserEvent:e,index:t,element:i&&i.element}}toTouchEvent(e){const t=this.getItemIndexFromEventTarget(e.target||null),i=void 0===t?void 0:this.items[t];return{browserEvent:e,index:t,element:i&&i.element}}toGestureEvent(e){const t=this.getItemIndexFromEventTarget(e.initialTarget||null),i=void 0===t?void 0:this.items[t];return{browserEvent:e,index:t,element:i&&i.element}}toDragEvent(e){const t=this.getItemIndexFromEventTarget(e.target||null),i=void 0===t?void 0:this.items[t];return{browserEvent:e,index:t,element:i&&i.element}}onScroll(e){try{const t=this.getRenderRange(this.lastRenderTop,this.lastRenderHeight);this.render(t,e.scrollTop,e.height,e.scrollLeft,e.scrollWidth),this.supportDynamicHeights&&this._rerender(e.scrollTop,e.height,e.inSmoothScrolling)}catch(t){throw console.error("Got bad scroll event:",e),t}}onTouchChange(e){e.preventDefault(),e.stopPropagation(),this.scrollTop-=e.translationY}onDragStart(e,t,i){var n,s;if(!i.dataTransfer)return;const a=this.dnd.getDragElements(e);if(i.dataTransfer.effectAllowed="copyMove",i.dataTransfer.setData(o.DataTransfers.TEXT,t),i.dataTransfer.setDragImage){let e;this.dnd.getDragLabel&&(e=this.dnd.getDragLabel(a,i)),void 0===e&&(e=String(a.length));const t=(0,r.$)(".monaco-drag-image");t.textContent=e,document.body.appendChild(t),i.dataTransfer.setDragImage(t,-10,-10),setTimeout((()=>document.body.removeChild(t)),0)}this.currentDragData=new v(a),o.StaticDND.CurrentDragAndDropData=new C(a),null===(s=(n=this.dnd).onDragStart)||void 0===s||s.call(n,this.currentDragData,i)}onDragOver(e){var t;if(e.browserEvent.preventDefault(),this.onDragLeaveTimeout.dispose(),o.StaticDND.CurrentDragAndDropData&&"vscode-ui"===o.StaticDND.CurrentDragAndDropData.getData())return!1;if(this.setupDragAndDropScrollTopAnimation(e.browserEvent),!e.browserEvent.dataTransfer)return!1;if(!this.currentDragData)if(o.StaticDND.CurrentDragAndDropData)this.currentDragData=o.StaticDND.CurrentDragAndDropData;else{if(!e.browserEvent.dataTransfer.types)return!1;this.currentDragData=new w}const i=this.dnd.onDragOver(this.currentDragData,e.element,e.index,e.browserEvent);if(this.canDrop="boolean"==typeof i?i:i.accept,!this.canDrop)return this.currentDragFeedback=void 0,this.currentDragFeedbackDisposable.dispose(),!1;let n;if(e.browserEvent.dataTransfer.dropEffect="boolean"!=typeof i&&0===i.effect?"copy":"move",n="boolean"!=typeof i&&i.feedback?i.feedback:void 0===e.index?[-1]:[e.index],n=(0,c.distinct)(n).filter((e=>e>=-1&&e<this.length)).sort(((e,t)=>e-t)),n=-1===n[0]?[-1]:n,r=this.currentDragFeedback,s=n,Array.isArray(r)&&Array.isArray(s)?(0,c.equals)(r,s):r===s)return!0;var r,s;if(this.currentDragFeedback=n,this.currentDragFeedbackDisposable.dispose(),-1===n[0])this.domNode.classList.add("drop-target"),this.rowsContainer.classList.add("drop-target"),this.currentDragFeedbackDisposable=(0,g.toDisposable)((()=>{this.domNode.classList.remove("drop-target"),this.rowsContainer.classList.remove("drop-target")}));else{for(const e of n){const i=this.items[e];i.dropTarget=!0,null===(t=i.row)||void 0===t||t.domNode.classList.add("drop-target")}this.currentDragFeedbackDisposable=(0,g.toDisposable)((()=>{var e;for(const t of n){const i=this.items[t];i.dropTarget=!1,null===(e=i.row)||void 0===e||e.domNode.classList.remove("drop-target")}}))}return!0}onDragLeave(e){var t,i;this.onDragLeaveTimeout.dispose(),this.onDragLeaveTimeout=(0,d.disposableTimeout)((()=>this.clearDragOverFeedback()),100),this.currentDragData&&(null===(i=(t=this.dnd).onDragLeave)||void 0===i||i.call(t,this.currentDragData,e.element,e.index,e.browserEvent))}onDrop(e){if(!this.canDrop)return;const t=this.currentDragData;this.teardownDragAndDropScrollTopAnimation(),this.clearDragOverFeedback(),this.currentDragData=void 0,o.StaticDND.CurrentDragAndDropData=void 0,t&&e.browserEvent.dataTransfer&&(e.browserEvent.preventDefault(),t.update(e.browserEvent.dataTransfer),this.dnd.drop(t,e.element,e.index,e.browserEvent))}onDragEnd(e){var t,i;this.canDrop=!1,this.teardownDragAndDropScrollTopAnimation(),this.clearDragOverFeedback(),this.currentDragData=void 0,o.StaticDND.CurrentDragAndDropData=void 0,null===(i=(t=this.dnd).onDragEnd)||void 0===i||i.call(t,e)}clearDragOverFeedback(){this.currentDragFeedback=void 0,this.currentDragFeedbackDisposable.dispose(),this.currentDragFeedbackDisposable=g.Disposable.None}setupDragAndDropScrollTopAnimation(e){if(!this.dragOverAnimationDisposable){const e=(0,r.getTopLeftOffset)(this.domNode).top;this.dragOverAnimationDisposable=(0,r.animate)(this.animateDragAndDropScrollTop.bind(this,e))}this.dragOverAnimationStopDisposable.dispose(),this.dragOverAnimationStopDisposable=(0,d.disposableTimeout)((()=>{this.dragOverAnimationDisposable&&(this.dragOverAnimationDisposable.dispose(),this.dragOverAnimationDisposable=void 0)}),1e3),this.dragOverMouseY=e.pageY}animateDragAndDropScrollTop(e){if(void 0===this.dragOverMouseY)return;const t=this.dragOverMouseY-e,i=this.renderHeight-35;t<35?this.scrollTop+=Math.max(-14,Math.floor(.3*(t-35))):t>i&&(this.scrollTop+=Math.min(14,Math.floor(.3*(t-i))))}teardownDragAndDropScrollTopAnimation(){this.dragOverAnimationStopDisposable.dispose(),this.dragOverAnimationDisposable&&(this.dragOverAnimationDisposable.dispose(),this.dragOverAnimationDisposable=void 0)}getItemIndexFromEventTarget(e){const t=this.scrollableElement.getDomNode();let i=e;for(;i instanceof HTMLElement&&i!==this.rowsContainer&&t.contains(i);){const e=i.getAttribute("data-index");if(e){const t=Number(e);if(!isNaN(t))return t}i=i.parentElement}}getRenderRange(e,t){return{start:this.rangeMap.indexAt(e),end:this.rangeMap.indexAfter(e+t-1)}}_rerender(e,t,i){const n=this.getRenderRange(e,t);let o,r;e===this.elementTop(n.start)?(o=n.start,r=0):n.end-n.start>1&&(o=n.start+1,r=this.elementTop(o)-e);let s=0;for(;;){const a=this.getRenderRange(e,t);let l=!1;for(let e=a.start;e<a.end;e++){const t=this.probeDynamicHeight(e);0!==t&&this.rangeMap.splice(e,1,[this.items[e]]),s+=t,l=l||0!==t}if(!l){0!==s&&this.eventuallyUpdateScrollDimensions();const t=p.Range.relativeComplement(n,a);for(const e of t)for(let t=e.start;t<e.end;t++)this.items[t].row&&this.removeItemFromDOM(t);const l=p.Range.relativeComplement(a,n);for(const e of l)for(let t=e.start;t<e.end;t++){const e=t+1,i=e<this.items.length?this.items[e].row:null,n=i?i.domNode:null;this.insertItemInDOM(t,n)}for(let e=a.start;e<a.end;e++)this.items[e].row&&this.updateItemInDOM(this.items[e],e);if("number"==typeof o){const t=this.scrollable.getFutureScrollPosition().scrollTop-e,n=this.elementTop(o)-r+t;this.setScrollTop(n,i)}return void this._onDidChangeContentHeight.fire(this.contentHeight)}}}probeDynamicHeight(e){var t,i,n;const o=this.items[e];if(this.virtualDelegate.getDynamicHeight){const e=this.virtualDelegate.getDynamicHeight(o.element);if(null!==e){const t=o.size;return o.size=e,o.lastDynamicHeightWidth=this.renderWidth,e-t}}if(!o.hasDynamicHeight||o.lastDynamicHeightWidth===this.renderWidth)return 0;if(this.virtualDelegate.hasDynamicHeight&&!this.virtualDelegate.hasDynamicHeight(o.element))return 0;const r=o.size;if(!this.setRowHeight&&o.row){const e=o.row.domNode.offsetHeight;return o.size=e,o.lastDynamicHeightWidth=this.renderWidth,e-r}const s=this.cache.alloc(o.templateId);s.domNode.style.height="",this.rowsContainer.appendChild(s.domNode);const a=this.renderers.get(o.templateId);return a&&(a.renderElement(o.element,e,s.templateData,void 0),null===(t=a.disposeElement)||void 0===t||t.call(a,o.element,e,s.templateData,void 0)),o.size=s.domNode.offsetHeight,null===(n=(i=this.virtualDelegate).setDynamicHeight)||void 0===n||n.call(i,o.element,o.size),o.lastDynamicHeightWidth=this.renderWidth,this.rowsContainer.removeChild(s.domNode),this.cache.release(s),o.size-r}getNextToLastElement(e){const t=e[e.length-1];if(!t)return null;const i=this.items[t.end];return i&&i.row?i.row.domNode:null}getElementDomId(e){return`${this.domId}_${e}`}dispose(){var e;if(this.items){for(const t of this.items)if(t.row){const i=this.renderers.get(t.row.templateId);i&&(null===(e=i.disposeElement)||void 0===e||e.call(i,t.element,-1,t.row.templateData,void 0),i.disposeTemplate(t.row.templateData))}this.items=[]}this.domNode&&this.domNode.parentNode&&this.domNode.parentNode.removeChild(this.domNode),(0,g.dispose)(this.disposables)}}S.InstanceCount=0,_([u.memoize],S.prototype,"onMouseClick",null),_([u.memoize],S.prototype,"onMouseDblClick",null),_([u.memoize],S.prototype,"onMouseMiddleClick",null),_([u.memoize],S.prototype,"onMouseDown",null),_([u.memoize],S.prototype,"onMouseOver",null),_([u.memoize],S.prototype,"onContextMenu",null),_([u.memoize],S.prototype,"onTouchStart",null),_([u.memoize],S.prototype,"onTap",null)},72406:function(e,t,i){"use strict";i.r(t),i.d(t,{DefaultKeyboardNavigationDelegate:function(){return R},DefaultStyleController:function(){return W},List:function(){return Y},MouseController:function(){return H},TypeNavigationMode:function(){return n},isButton:function(){return M},isInputElement:function(){return L},isMonacoEditor:function(){return T},isSelectionRangeChangeEvent:function(){return P},isSelectionSingleChangeEvent:function(){return F}});var n,o,r=i(96747),s=i(50465),a=i(8769),l=i(4043),c=i(61950),d=i(25218),u=i(64998),h=i(66129),g=i(17160),p=i(63966),m=i(63801),f=i(27017),b=i(68921),_=i(53719),A=i(91057),v=i(66719),C=i(18912),w=(i(82833),i(40083)),y=i(75291),S=function(e,t,i,n){var o,r=arguments.length,s=r<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,i):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)s=Reflect.decorate(e,t,i,n);else for(var a=e.length-1;a>=0;a--)(o=e[a])&&(s=(r<3?o(s):r>3?o(t,i,s):o(t,i))||s);return r>3&&s&&Object.defineProperty(t,i,s),s},x=function(e,t,i,n){return new(i||(i=Promise))((function(o,r){function s(e){try{l(n.next(e))}catch(e){r(e)}}function a(e){try{l(n.throw(e))}catch(e){r(e)}}function l(e){var t;e.done?o(e.value):(t=e.value,t instanceof i?t:new i((function(e){e(t)}))).then(s,a)}l((n=n.apply(e,t||[])).next())}))};class E{constructor(e){this.trait=e,this.renderedElements=[]}get templateId(){return`template:${this.trait.name}`}renderTemplate(e){return e}renderElement(e,t,i){const n=this.renderedElements.findIndex((e=>e.templateData===i));if(n>=0){const e=this.renderedElements[n];this.trait.unrender(i),e.index=t}else{const e={index:t,templateData:i};this.renderedElements.push(e)}this.trait.renderIndex(t,i)}splice(e,t,i){const n=[];for(const o of this.renderedElements)o.index<e?n.push(o):o.index>=e+t&&n.push({index:o.index+i-t,templateData:o.templateData});this.renderedElements=n}renderIndexes(e){for(const{index:t,templateData:i}of this.renderedElements)e.indexOf(t)>-1&&this.trait.renderIndex(t,i)}disposeTemplate(e){const t=this.renderedElements.findIndex((t=>t.templateData===e));t<0||this.renderedElements.splice(t,1)}}class k{constructor(e){this._trait=e,this.length=0,this.indexes=[],this.sortedIndexes=[],this._onChange=new m.Emitter,this.onChange=this._onChange.event}get name(){return this._trait}get renderer(){return new E(this)}splice(e,t,i){var n;t=Math.max(0,Math.min(t,this.length-e));const o=i.length-t,r=e+t,s=[...this.sortedIndexes.filter((t=>t<e)),...i.map(((t,i)=>t?i+e:-1)).filter((e=>-1!==e)),...this.sortedIndexes.filter((e=>e>=r)).map((e=>e+o))],a=this.length+o;if(this.sortedIndexes.length>0&&0===s.length&&a>0){const t=null!==(n=this.sortedIndexes.find((t=>t>=e)))&&void 0!==n?n:a-1;s.push(Math.min(t,a-1))}this.renderer.splice(e,t,i.length),this._set(s,s),this.length=a}renderIndex(e,t){t.classList.toggle(this._trait,this.contains(e))}unrender(e){e.classList.remove(this._trait)}set(e,t){return this._set(e,[...e].sort(K),t)}_set(e,t,i){const n=this.indexes,o=this.sortedIndexes;this.indexes=e,this.sortedIndexes=t;const r=Q(o,e);return this.renderer.renderIndexes(r),this._onChange.fire({indexes:e,browserEvent:i}),n}get(){return this.indexes}contains(e){return(0,u.binarySearch)(this.sortedIndexes,e,K)>=0}dispose(){(0,b.dispose)(this._onChange)}}S([p.memoize],k.prototype,"renderer",null);class I extends k{constructor(e){super("selected"),this.setAriaSelected=e}renderIndex(e,t){super.renderIndex(e,t),this.setAriaSelected&&(this.contains(e)?t.setAttribute("aria-selected","true"):t.setAttribute("aria-selected","false"))}}class D{constructor(e,t,i){this.trait=e,this.view=t,this.identityProvider=i}splice(e,t,i){if(!this.identityProvider)return this.trait.splice(e,t,i.map((()=>!1)));const n=this.trait.get().map((e=>this.identityProvider.getId(this.view.element(e)).toString())),o=i.map((e=>n.indexOf(this.identityProvider.getId(e).toString())>-1));this.trait.splice(e,t,o)}}function L(e){return"INPUT"===e.tagName||"TEXTAREA"===e.tagName}function T(e){return!!e.classList.contains("monaco-editor")||!e.classList.contains("monaco-list")&&(!!e.parentElement&&T(e.parentElement))}function M(e){return!!("A"===e.tagName&&e.classList.contains("monaco-button")||"DIV"===e.tagName&&e.classList.contains("monaco-button-dropdown"))||!e.classList.contains("monaco-list")&&(!!e.parentElement&&M(e.parentElement))}class N{constructor(e,t,i){this.list=e,this.view=t,this.disposables=new b.DisposableStore,this.multipleSelectionDisposables=new b.DisposableStore,this.onKeyDown.filter((e=>3===e.keyCode)).on(this.onEnter,this,this.disposables),this.onKeyDown.filter((e=>16===e.keyCode)).on(this.onUpArrow,this,this.disposables),this.onKeyDown.filter((e=>18===e.keyCode)).on(this.onDownArrow,this,this.disposables),this.onKeyDown.filter((e=>11===e.keyCode)).on(this.onPageUpArrow,this,this.disposables),this.onKeyDown.filter((e=>12===e.keyCode)).on(this.onPageDownArrow,this,this.disposables),this.onKeyDown.filter((e=>9===e.keyCode)).on(this.onEscape,this,this.disposables),!1!==i.multipleSelectionSupport&&this.onKeyDown.filter((e=>(v.isMacintosh?e.metaKey:e.ctrlKey)&&31===e.keyCode)).on(this.onCtrlA,this,this.multipleSelectionDisposables)}get onKeyDown(){return this.disposables.add(m.Event.chain(this.disposables.add(new s.DomEmitter(this.view.domNode,"keydown")).event).filter((e=>!L(e.target))).map((e=>new a.StandardKeyboardEvent(e))))}updateOptions(e){void 0!==e.multipleSelectionSupport&&(this.multipleSelectionDisposables.clear(),e.multipleSelectionSupport&&this.onKeyDown.filter((e=>(v.isMacintosh?e.metaKey:e.ctrlKey)&&31===e.keyCode)).on(this.onCtrlA,this,this.multipleSelectionDisposables))}onEnter(e){e.preventDefault(),e.stopPropagation(),this.list.setSelection(this.list.getFocus(),e.browserEvent)}onUpArrow(e){e.preventDefault(),e.stopPropagation(),this.list.focusPrevious(1,!1,e.browserEvent);const t=this.list.getFocus()[0];this.list.setAnchor(t),this.list.reveal(t),this.view.domNode.focus()}onDownArrow(e){e.preventDefault(),e.stopPropagation(),this.list.focusNext(1,!1,e.browserEvent);const t=this.list.getFocus()[0];this.list.setAnchor(t),this.list.reveal(t),this.view.domNode.focus()}onPageUpArrow(e){e.preventDefault(),e.stopPropagation(),this.list.focusPreviousPage(e.browserEvent);const t=this.list.getFocus()[0];this.list.setAnchor(t),this.list.reveal(t),this.view.domNode.focus()}onPageDownArrow(e){e.preventDefault(),e.stopPropagation(),this.list.focusNextPage(e.browserEvent);const t=this.list.getFocus()[0];this.list.setAnchor(t),this.list.reveal(t),this.view.domNode.focus()}onCtrlA(e){e.preventDefault(),e.stopPropagation(),this.list.setSelection((0,u.range)(this.list.length),e.browserEvent),this.list.setAnchor(void 0),this.view.domNode.focus()}onEscape(e){this.list.getSelection().length&&(e.preventDefault(),e.stopPropagation(),this.list.setSelection([],e.browserEvent),this.list.setAnchor(void 0),this.view.domNode.focus())}dispose(){this.disposables.dispose(),this.multipleSelectionDisposables.dispose()}}S([p.memoize],N.prototype,"onKeyDown",null),function(e){e[e.Automatic=0]="Automatic",e[e.Trigger=1]="Trigger"}(n||(n={})),function(e){e[e.Idle=0]="Idle",e[e.Typing=1]="Typing"}(o||(o={}));const R=new class{mightProducePrintableCharacter(e){return!(e.ctrlKey||e.metaKey||e.altKey)&&(e.keyCode>=31&&e.keyCode<=56||e.keyCode>=21&&e.keyCode<=30||e.keyCode>=93&&e.keyCode<=102||e.keyCode>=80&&e.keyCode<=90)}};class B{constructor(e,t,i,r,s){this.list=e,this.view=t,this.keyboardNavigationLabelProvider=i,this.keyboardNavigationEventFilter=r,this.delegate=s,this.enabled=!1,this.state=o.Idle,this.mode=n.Automatic,this.triggered=!1,this.previouslyFocused=-1,this.enabledDisposables=new b.DisposableStore,this.disposables=new b.DisposableStore,this.updateOptions(e.options)}updateOptions(e){var t,i;null===(t=e.typeNavigationEnabled)||void 0===t||t?this.enable():this.disable(),this.mode=null!==(i=e.typeNavigationMode)&&void 0!==i?i:n.Automatic}enable(){if(this.enabled)return;let e=!1;const t=this.enabledDisposables.add(m.Event.chain(this.enabledDisposables.add(new s.DomEmitter(this.view.domNode,"keydown")).event)).filter((e=>!L(e.target))).filter((()=>this.mode===n.Automatic||this.triggered)).map((e=>new a.StandardKeyboardEvent(e))).filter((t=>e||this.keyboardNavigationEventFilter(t))).filter((e=>this.delegate.mightProducePrintableCharacter(e))).forEach(s.stopEvent).map((e=>e.browserEvent.key)).event,i=m.Event.debounce(t,(()=>null),800,void 0,void 0,this.enabledDisposables);m.Event.reduce(m.Event.any(t,i),((e,t)=>null===t?null:(e||"")+t),void 0,this.enabledDisposables)(this.onInput,this,this.enabledDisposables),i(this.onClear,this,this.enabledDisposables),t((()=>e=!0),void 0,this.enabledDisposables),i((()=>e=!1),void 0,this.enabledDisposables),this.enabled=!0,this.triggered=!1}disable(){this.enabled&&(this.enabledDisposables.clear(),this.enabled=!1,this.triggered=!1)}onClear(){var e;const t=this.list.getFocus();if(t.length>0&&t[0]===this.previouslyFocused){const i=null===(e=this.list.options.accessibilityProvider)||void 0===e?void 0:e.getAriaLabel(this.list.element(t[0]));i&&(0,c.alert)(i)}this.previouslyFocused=-1}onInput(e){if(!e)return this.state=o.Idle,void(this.triggered=!1);const t=this.list.getFocus(),i=t.length>0?t[0]:0,n=this.state===o.Idle?1:0;this.state=o.Typing;for(let t=0;t<this.list.length;t++){const o=(i+t+n)%this.list.length,r=this.keyboardNavigationLabelProvider.getKeyboardNavigationLabel(this.view.element(o)),s=r&&r.toString();if(void 0===s||(0,f.matchesPrefix)(e,s))return this.previouslyFocused=i,this.list.setFocus([o]),void this.list.reveal(o)}}dispose(){this.disable(),this.enabledDisposables.dispose(),this.disposables.dispose()}}class O{constructor(e,t){this.list=e,this.view=t,this.disposables=new b.DisposableStore;this.disposables.add(m.Event.chain(this.disposables.add(new s.DomEmitter(t.domNode,"keydown")).event)).filter((e=>!L(e.target))).map((e=>new a.StandardKeyboardEvent(e))).filter((e=>!(2!==e.keyCode||e.ctrlKey||e.metaKey||e.shiftKey||e.altKey))).on(this.onTab,this,this.disposables)}onTab(e){if(e.target!==this.view.domNode)return;const t=this.list.getFocus();if(0===t.length)return;const i=this.view.domElement(t[0]);if(!i)return;const n=i.querySelector("[tabIndex]");if(!(n&&n instanceof HTMLElement&&-1!==n.tabIndex))return;const o=window.getComputedStyle(n);"hidden"!==o.visibility&&"none"!==o.display&&(e.preventDefault(),e.stopPropagation(),n.focus())}dispose(){this.disposables.dispose()}}function F(e){return v.isMacintosh?e.browserEvent.metaKey:e.browserEvent.ctrlKey}function P(e){return e.browserEvent.shiftKey}const z={isSelectionSingleChangeEvent:F,isSelectionRangeChangeEvent:P};class H{constructor(e){this.list=e,this.disposables=new b.DisposableStore,this._onPointer=new m.Emitter,this.onPointer=this._onPointer.event,!1!==e.options.multipleSelectionSupport&&(this.multipleSelectionController=this.list.options.multipleSelectionController||z),this.mouseSupport=void 0===e.options.mouseSupport||!!e.options.mouseSupport,this.mouseSupport&&(e.onMouseDown(this.onMouseDown,this,this.disposables),e.onContextMenu(this.onContextMenu,this,this.disposables),e.onMouseDblClick(this.onDoubleClick,this,this.disposables),e.onTouchStart(this.onMouseDown,this,this.disposables),this.disposables.add(l.Gesture.addTarget(e.getHTMLElement()))),m.Event.any(e.onMouseClick,e.onMouseMiddleClick,e.onTap)(this.onViewPointer,this,this.disposables)}updateOptions(e){void 0!==e.multipleSelectionSupport&&(this.multipleSelectionController=void 0,e.multipleSelectionSupport&&(this.multipleSelectionController=this.list.options.multipleSelectionController||z))}isSelectionSingleChangeEvent(e){return!!this.multipleSelectionController&&this.multipleSelectionController.isSelectionSingleChangeEvent(e)}isSelectionRangeChangeEvent(e){return!!this.multipleSelectionController&&this.multipleSelectionController.isSelectionRangeChangeEvent(e)}isSelectionChangeEvent(e){return this.isSelectionSingleChangeEvent(e)||this.isSelectionRangeChangeEvent(e)}onMouseDown(e){T(e.browserEvent.target)||document.activeElement!==e.browserEvent.target&&this.list.domFocus()}onContextMenu(e){if(T(e.browserEvent.target))return;const t=void 0===e.index?[]:[e.index];this.list.setFocus(t,e.browserEvent)}onViewPointer(e){if(!this.mouseSupport)return;if(L(e.browserEvent.target)||T(e.browserEvent.target))return;const t=e.index;return void 0===t?(this.list.setFocus([],e.browserEvent),this.list.setSelection([],e.browserEvent),void this.list.setAnchor(void 0)):this.isSelectionRangeChangeEvent(e)||this.isSelectionChangeEvent(e)?this.changeSelection(e):(this.list.setFocus([t],e.browserEvent),this.list.setAnchor(t),(i=e.browserEvent)instanceof MouseEvent&&2===i.button||this.list.setSelection([t],e.browserEvent),void this._onPointer.fire(e));var i}onDoubleClick(e){if(L(e.browserEvent.target)||T(e.browserEvent.target))return;if(this.isSelectionChangeEvent(e))return;const t=this.list.getFocus();this.list.setSelection(t,e.browserEvent)}changeSelection(e){const t=e.index;let i=this.list.getAnchor();if(this.isSelectionRangeChangeEvent(e)){if(void 0===i){const e=this.list.getFocus()[0];i=null!=e?e:t,this.list.setAnchor(i)}const n=Math.min(i,t),o=Math.max(i,t),r=(0,u.range)(n,o+1),s=this.list.getSelection(),a=function(e,t){const i=e.indexOf(t);if(-1===i)return[];const n=[];let o=i-1;for(;o>=0&&e[o]===t-(i-o);)n.push(e[o--]);n.reverse(),o=i;for(;o<e.length&&e[o]===t+(o-i);)n.push(e[o++]);return n}(Q(s,[i]),i);if(0===a.length)return;const l=Q(r,function(e,t){const i=[];let n=0,o=0;for(;n<e.length||o<t.length;)if(n>=e.length)i.push(t[o++]);else if(o>=t.length)i.push(e[n++]);else{if(e[n]===t[o]){n++,o++;continue}e[n]<t[o]?i.push(e[n++]):o++}return i}(s,a));this.list.setSelection(l,e.browserEvent),this.list.setFocus([t],e.browserEvent)}else if(this.isSelectionSingleChangeEvent(e)){const i=this.list.getSelection(),n=i.filter((e=>e!==t));this.list.setFocus([t]),this.list.setAnchor(t),i.length===n.length?this.list.setSelection([...n,t],e.browserEvent):this.list.setSelection(n,e.browserEvent)}}dispose(){this.disposables.dispose()}}class W{constructor(e,t){this.styleElement=e,this.selectorSuffix=t}style(e){const t=this.selectorSuffix&&`.${this.selectorSuffix}`,i=[];e.listBackground&&(e.listBackground.isOpaque()?i.push(`.monaco-list${t} .monaco-list-rows { background: ${e.listBackground}; }`):v.isMacintosh||console.warn(`List with id '${this.selectorSuffix}' was styled with a non-opaque background color. This will break sub-pixel antialiasing.`)),e.listFocusBackground&&(i.push(`.monaco-list${t}:focus .monaco-list-row.focused { background-color: ${e.listFocusBackground}; }`),i.push(`.monaco-list${t}:focus .monaco-list-row.focused:hover { background-color: ${e.listFocusBackground}; }`)),e.listFocusForeground&&i.push(`.monaco-list${t}:focus .monaco-list-row.focused { color: ${e.listFocusForeground}; }`),e.listActiveSelectionBackground&&(i.push(`.monaco-list${t}:focus .monaco-list-row.selected { background-color: ${e.listActiveSelectionBackground}; }`),i.push(`.monaco-list${t}:focus .monaco-list-row.selected:hover { background-color: ${e.listActiveSelectionBackground}; }`)),e.listActiveSelectionForeground&&i.push(`.monaco-list${t}:focus .monaco-list-row.selected { color: ${e.listActiveSelectionForeground}; }`),e.listActiveSelectionIconForeground&&i.push(`.monaco-list${t}:focus .monaco-list-row.selected .codicon { color: ${e.listActiveSelectionIconForeground}; }`),e.listFocusAndSelectionOutline&&i.push(`.monaco-list${t}:focus .monaco-list-row.selected { outline-color: ${e.listFocusAndSelectionOutline} !important; }`),e.listFocusAndSelectionBackground&&i.push(`\n\t\t\t\t.monaco-drag-image,\n\t\t\t\t.monaco-list${t}:focus .monaco-list-row.selected.focused { background-color: ${e.listFocusAndSelectionBackground}; }\n\t\t\t`),e.listFocusAndSelectionForeground&&i.push(`\n\t\t\t\t.monaco-drag-image,\n\t\t\t\t.monaco-list${t}:focus .monaco-list-row.selected.focused { color: ${e.listFocusAndSelectionForeground}; }\n\t\t\t`),e.listInactiveFocusForeground&&(i.push(`.monaco-list${t} .monaco-list-row.focused { color:  ${e.listInactiveFocusForeground}; }`),i.push(`.monaco-list${t} .monaco-list-row.focused:hover { color:  ${e.listInactiveFocusForeground}; }`)),e.listInactiveSelectionIconForeground&&i.push(`.monaco-list${t} .monaco-list-row.focused .codicon { color:  ${e.listInactiveSelectionIconForeground}; }`),e.listInactiveFocusBackground&&(i.push(`.monaco-list${t} .monaco-list-row.focused { background-color:  ${e.listInactiveFocusBackground}; }`),i.push(`.monaco-list${t} .monaco-list-row.focused:hover { background-color:  ${e.listInactiveFocusBackground}; }`)),e.listInactiveSelectionBackground&&(i.push(`.monaco-list${t} .monaco-list-row.selected { background-color:  ${e.listInactiveSelectionBackground}; }`),i.push(`.monaco-list${t} .monaco-list-row.selected:hover { background-color:  ${e.listInactiveSelectionBackground}; }`)),e.listInactiveSelectionForeground&&i.push(`.monaco-list${t} .monaco-list-row.selected { color: ${e.listInactiveSelectionForeground}; }`),e.listHoverBackground&&i.push(`.monaco-list${t}:not(.drop-target) .monaco-list-row:hover:not(.selected):not(.focused) { background-color: ${e.listHoverBackground}; }`),e.listHoverForeground&&i.push(`.monaco-list${t} .monaco-list-row:hover:not(.selected):not(.focused) { color:  ${e.listHoverForeground}; }`),e.listSelectionOutline&&i.push(`.monaco-list${t} .monaco-list-row.selected { outline: 1px dotted ${e.listSelectionOutline}; outline-offset: -1px; }`),e.listFocusOutline&&i.push(`\n\t\t\t\t.monaco-drag-image,\n\t\t\t\t.monaco-list${t}:focus .monaco-list-row.focused { outline: 1px solid ${e.listFocusOutline}; outline-offset: -1px; }\n\t\t\t\t.monaco-workbench.context-menu-visible .monaco-list${t}.last-focused .monaco-list-row.focused { outline: 1px solid ${e.listFocusOutline}; outline-offset: -1px; }\n\t\t\t`),e.listInactiveFocusOutline&&i.push(`.monaco-list${t} .monaco-list-row.focused { outline: 1px dotted ${e.listInactiveFocusOutline}; outline-offset: -1px; }`),e.listHoverOutline&&i.push(`.monaco-list${t} .monaco-list-row:hover { outline: 1px dashed ${e.listHoverOutline}; outline-offset: -1px; }`),e.listDropBackground&&i.push(`\n\t\t\t\t.monaco-list${t}.drop-target,\n\t\t\t\t.monaco-list${t} .monaco-list-rows.drop-target,\n\t\t\t\t.monaco-list${t} .monaco-list-row.drop-target { background-color: ${e.listDropBackground} !important; color: inherit !important; }\n\t\t\t`),e.tableColumnsBorder&&i.push(`\n\t\t\t\t.monaco-table:hover > .monaco-split-view2,\n\t\t\t\t.monaco-table:hover > .monaco-split-view2 .monaco-sash.vertical::before {\n\t\t\t\t\tborder-color: ${e.tableColumnsBorder};\n\t\t\t}`),e.tableOddRowsBackgroundColor&&i.push(`\n\t\t\t\t.monaco-table .monaco-list-row[data-parity=odd]:not(.focused):not(.selected):not(:hover) .monaco-table-tr,\n\t\t\t\t.monaco-table .monaco-list:not(:focus) .monaco-list-row[data-parity=odd].focused:not(.selected):not(:hover) .monaco-table-tr,\n\t\t\t\t.monaco-table .monaco-list:not(.focused) .monaco-list-row[data-parity=odd].focused:not(.selected):not(:hover) .monaco-table-tr {\n\t\t\t\t\tbackground-color: ${e.tableOddRowsBackgroundColor};\n\t\t\t\t}\n\t\t\t`),this.styleElement.textContent=i.join("\n")}}const V={listFocusBackground:g.Color.fromHex("#7FB0D0"),listActiveSelectionBackground:g.Color.fromHex("#0E639C"),listActiveSelectionForeground:g.Color.fromHex("#FFFFFF"),listActiveSelectionIconForeground:g.Color.fromHex("#FFFFFF"),listFocusAndSelectionOutline:g.Color.fromHex("#90C2F9"),listFocusAndSelectionBackground:g.Color.fromHex("#094771"),listFocusAndSelectionForeground:g.Color.fromHex("#FFFFFF"),listInactiveSelectionBackground:g.Color.fromHex("#3F3F46"),listInactiveSelectionIconForeground:g.Color.fromHex("#FFFFFF"),listHoverBackground:g.Color.fromHex("#2A2D2E"),listDropBackground:g.Color.fromHex("#383B3D"),treeIndentGuidesStroke:g.Color.fromHex("#a9a9a9"),tableColumnsBorder:g.Color.fromHex("#cccccc").transparent(.2),tableOddRowsBackgroundColor:g.Color.fromHex("#cccccc").transparent(.04)},U={keyboardSupport:!0,mouseSupport:!0,multipleSelectionSupport:!0,dnd:{getDragURI(){return null},onDragStart(){},onDragOver(){return!1},drop(){}}};function Q(e,t){const i=[];let n=0,o=0;for(;n<e.length||o<t.length;)if(n>=e.length)i.push(t[o++]);else if(o>=t.length)i.push(e[n++]);else{if(e[n]===t[o]){i.push(e[n]),n++,o++;continue}e[n]<t[o]?i.push(e[n++]):i.push(t[o++])}return i}const K=(e,t)=>e-t;class j{constructor(e,t){this._templateId=e,this.renderers=t}get templateId(){return this._templateId}renderTemplate(e){return this.renderers.map((t=>t.renderTemplate(e)))}renderElement(e,t,i,n){let o=0;for(const r of this.renderers)r.renderElement(e,t,i[o++],n)}disposeElement(e,t,i,n){var o;let r=0;for(const s of this.renderers)null===(o=s.disposeElement)||void 0===o||o.call(s,e,t,i[r],n),r+=1}disposeTemplate(e){let t=0;for(const i of this.renderers)i.disposeTemplate(e[t++])}}class G{constructor(e){this.accessibilityProvider=e,this.templateId="a18n"}renderTemplate(e){return e}renderElement(e,t,i){const n=this.accessibilityProvider.getAriaLabel(e);n?i.setAttribute("aria-label",n):i.removeAttribute("aria-label");const o=this.accessibilityProvider.getAriaLevel&&this.accessibilityProvider.getAriaLevel(e);"number"==typeof o?i.setAttribute("aria-level",`${o}`):i.removeAttribute("aria-level")}disposeTemplate(e){}}class ${constructor(e,t){this.list=e,this.dnd=t}getDragElements(e){const t=this.list.getSelectedElements();return t.indexOf(e)>-1?t:[e]}getDragURI(e){return this.dnd.getDragURI(e)}getDragLabel(e,t){if(this.dnd.getDragLabel)return this.dnd.getDragLabel(e,t)}onDragStart(e,t){var i,n;null===(n=(i=this.dnd).onDragStart)||void 0===n||n.call(i,e,t)}onDragOver(e,t,i,n){return this.dnd.onDragOver(e,t,i,n)}onDragLeave(e,t,i,n){var o,r;null===(r=(o=this.dnd).onDragLeave)||void 0===r||r.call(o,e,t,i,n)}onDragEnd(e){var t,i;null===(i=(t=this.dnd).onDragEnd)||void 0===i||i.call(t,e)}drop(e,t,i,n){this.dnd.drop(e,t,i,n)}}class Y{constructor(e,t,i,n,o=U){var s,a,l,c;this.user=e,this._options=o,this.focus=new k("focused"),this.anchor=new k("anchor"),this.eventBufferer=new m.EventBufferer,this._ariaLabel="",this.disposables=new b.DisposableStore,this._onDidDispose=new m.Emitter,this.onDidDispose=this._onDidDispose.event;const u=this._options.accessibilityProvider&&this._options.accessibilityProvider.getWidgetRole?null===(s=this._options.accessibilityProvider)||void 0===s?void 0:s.getWidgetRole():"list";this.selection=new I("listbox"!==u),(0,A.mixin)(o,V,!1);const h=[this.focus.renderer,this.selection.renderer];this.accessibilityProvider=o.accessibilityProvider,this.accessibilityProvider&&(h.push(new G(this.accessibilityProvider)),null===(l=(a=this.accessibilityProvider).onDidChangeActiveDescendant)||void 0===l||l.call(a,this.onDidChangeActiveDescendant,this,this.disposables)),n=n.map((e=>new j(e.templateId,[...h,e])));const g=Object.assign(Object.assign({},o),{dnd:o.dnd&&new $(this,o.dnd)});if(this.view=new y.ListView(t,i,n,g),this.view.domNode.setAttribute("role",u),o.styleController)this.styleController=o.styleController(this.view.domId);else{const e=(0,r.createStyleSheet)(this.view.domNode);this.styleController=new W(e,this.view.domId)}if(this.spliceable=new d.CombinedSpliceable([new D(this.focus,this.view,o.identityProvider),new D(this.selection,this.view,o.identityProvider),new D(this.anchor,this.view,o.identityProvider),this.view]),this.disposables.add(this.focus),this.disposables.add(this.selection),this.disposables.add(this.anchor),this.disposables.add(this.view),this.disposables.add(this._onDidDispose),this.disposables.add(new O(this,this.view)),("boolean"!=typeof o.keyboardSupport||o.keyboardSupport)&&(this.keyboardController=new N(this,this.view,o),this.disposables.add(this.keyboardController)),o.keyboardNavigationLabelProvider){const e=o.keyboardNavigationDelegate||R;this.typeNavigationController=new B(this,this.view,o.keyboardNavigationLabelProvider,null!==(c=o.keyboardNavigationEventFilter)&&void 0!==c?c:()=>!0,e),this.disposables.add(this.typeNavigationController)}this.mouseController=this.createMouseController(o),this.disposables.add(this.mouseController),this.onDidChangeFocus(this._onFocusChange,this,this.disposables),this.onDidChangeSelection(this._onSelectionChange,this,this.disposables),this.accessibilityProvider&&(this.ariaLabel=this.accessibilityProvider.getWidgetAriaLabel()),!1!==this._options.multipleSelectionSupport&&this.view.domNode.setAttribute("aria-multiselectable","true")}get onDidChangeFocus(){return m.Event.map(this.eventBufferer.wrapEvent(this.focus.onChange),(e=>this.toListEvent(e)),this.disposables)}get onDidChangeSelection(){return m.Event.map(this.eventBufferer.wrapEvent(this.selection.onChange),(e=>this.toListEvent(e)),this.disposables)}get domId(){return this.view.domId}get onMouseClick(){return this.view.onMouseClick}get onMouseDblClick(){return this.view.onMouseDblClick}get onMouseMiddleClick(){return this.view.onMouseMiddleClick}get onPointer(){return this.mouseController.onPointer}get onMouseDown(){return this.view.onMouseDown}get onMouseOver(){return this.view.onMouseOver}get onTouchStart(){return this.view.onTouchStart}get onTap(){return this.view.onTap}get onContextMenu(){let e=!1;const t=this.disposables.add(m.Event.chain(this.disposables.add(new s.DomEmitter(this.view.domNode,"keydown")).event)).map((e=>new a.StandardKeyboardEvent(e))).filter((t=>e=58===t.keyCode||t.shiftKey&&68===t.keyCode)).map(s.stopEvent).filter((()=>!1)).event,i=this.disposables.add(m.Event.chain(this.disposables.add(new s.DomEmitter(this.view.domNode,"keyup")).event)).forEach((()=>e=!1)).map((e=>new a.StandardKeyboardEvent(e))).filter((e=>58===e.keyCode||e.shiftKey&&68===e.keyCode)).map(s.stopEvent).map((({browserEvent:e})=>{const t=this.getFocus(),i=t.length?t[0]:void 0;return{index:i,element:void 0!==i?this.view.element(i):void 0,anchor:void 0!==i?this.view.domElement(i):this.view.domNode,browserEvent:e}})).event,n=this.disposables.add(m.Event.chain(this.view.onContextMenu)).filter((t=>!e)).map((({element:e,index:t,browserEvent:i})=>({element:e,index:t,anchor:{x:i.pageX+1,y:i.pageY},browserEvent:i}))).event;return m.Event.any(t,i,n)}get onKeyDown(){return this.disposables.add(new s.DomEmitter(this.view.domNode,"keydown")).event}get onDidFocus(){return m.Event.signal(this.disposables.add(new s.DomEmitter(this.view.domNode,"focus",!0)).event)}createMouseController(e){return new H(this)}updateOptions(e={}){var t,i;this._options=Object.assign(Object.assign({},this._options),e),null===(t=this.typeNavigationController)||void 0===t||t.updateOptions(this._options),void 0!==this._options.multipleSelectionController&&(this._options.multipleSelectionSupport?this.view.domNode.setAttribute("aria-multiselectable","true"):this.view.domNode.removeAttribute("aria-multiselectable")),this.mouseController.updateOptions(e),null===(i=this.keyboardController)||void 0===i||i.updateOptions(e),this.view.updateOptions(e)}get options(){return this._options}splice(e,t,i=[]){if(e<0||e>this.view.length)throw new w.ListError(this.user,`Invalid start index: ${e}`);if(t<0)throw new w.ListError(this.user,`Invalid delete count: ${t}`);0===t&&0===i.length||this.eventBufferer.bufferEvents((()=>this.spliceable.splice(e,t,i)))}rerender(){this.view.rerender()}element(e){return this.view.element(e)}get length(){return this.view.length}get contentHeight(){return this.view.contentHeight}get scrollTop(){return this.view.getScrollTop()}set scrollTop(e){this.view.setScrollTop(e)}get ariaLabel(){return this._ariaLabel}set ariaLabel(e){this._ariaLabel=e,this.view.domNode.setAttribute("aria-label",e)}domFocus(){this.view.domNode.focus({preventScroll:!0})}layout(e,t){this.view.layout(e,t)}setSelection(e,t){for(const t of e)if(t<0||t>=this.length)throw new w.ListError(this.user,`Invalid index ${t}`);this.selection.set(e,t)}getSelection(){return this.selection.get()}getSelectedElements(){return this.getSelection().map((e=>this.view.element(e)))}setAnchor(e){if(void 0!==e){if(e<0||e>=this.length)throw new w.ListError(this.user,`Invalid index ${e}`);this.anchor.set([e])}else this.anchor.set([])}getAnchor(){return(0,u.firstOrDefault)(this.anchor.get(),void 0)}getAnchorElement(){const e=this.getAnchor();return void 0===e?void 0:this.element(e)}setFocus(e,t){for(const t of e)if(t<0||t>=this.length)throw new w.ListError(this.user,`Invalid index ${t}`);this.focus.set(e,t)}focusNext(e=1,t=!1,i,n){if(0===this.length)return;const o=this.focus.get(),r=this.findNextIndex(o.length>0?o[0]+e:0,t,n);r>-1&&this.setFocus([r],i)}focusPrevious(e=1,t=!1,i,n){if(0===this.length)return;const o=this.focus.get(),r=this.findPreviousIndex(o.length>0?o[0]-e:0,t,n);r>-1&&this.setFocus([r],i)}focusNextPage(e,t){return x(this,void 0,void 0,(function*(){let i=this.view.indexAt(this.view.getScrollTop()+this.view.renderHeight);i=0===i?0:i-1;const n=this.getFocus()[0];if(n!==i&&(void 0===n||i>n)){const o=this.findPreviousIndex(i,!1,t);o>-1&&n!==o?this.setFocus([o],e):this.setFocus([i],e)}else{const o=this.view.getScrollTop();let r=o+this.view.renderHeight;i>n&&(r-=this.view.elementHeight(i)),this.view.setScrollTop(r),this.view.getScrollTop()!==o&&(this.setFocus([]),yield(0,h.timeout)(0),yield this.focusNextPage(e,t))}}))}focusPreviousPage(e,t){return x(this,void 0,void 0,(function*(){let i;const n=this.view.getScrollTop();i=0===n?this.view.indexAt(n):this.view.indexAfter(n-1);const o=this.getFocus()[0];if(o!==i&&(void 0===o||o>=i)){const n=this.findNextIndex(i,!1,t);n>-1&&o!==n?this.setFocus([n],e):this.setFocus([i],e)}else{const i=n;this.view.setScrollTop(n-this.view.renderHeight),this.view.getScrollTop()!==i&&(this.setFocus([]),yield(0,h.timeout)(0),yield this.focusPreviousPage(e,t))}}))}focusLast(e,t){if(0===this.length)return;const i=this.findPreviousIndex(this.length-1,!1,t);i>-1&&this.setFocus([i],e)}focusFirst(e,t){this.focusNth(0,e,t)}focusNth(e,t,i){if(0===this.length)return;const n=this.findNextIndex(e,!1,i);n>-1&&this.setFocus([n],t)}findNextIndex(e,t=!1,i){for(let n=0;n<this.length;n++){if(e>=this.length&&!t)return-1;if(e%=this.length,!i||i(this.element(e)))return e;e++}return-1}findPreviousIndex(e,t=!1,i){for(let n=0;n<this.length;n++){if(e<0&&!t)return-1;if(e=(this.length+e%this.length)%this.length,!i||i(this.element(e)))return e;e--}return-1}getFocus(){return this.focus.get()}getFocusedElements(){return this.getFocus().map((e=>this.view.element(e)))}reveal(e,t){if(e<0||e>=this.length)throw new w.ListError(this.user,`Invalid index ${e}`);const i=this.view.getScrollTop(),n=this.view.elementTop(e),o=this.view.elementHeight(e);if((0,C.isNumber)(t)){const e=o-this.view.renderHeight;this.view.setScrollTop(e*(0,_.clamp)(t,0,1)+n)}else{const e=n+o,t=i+this.view.renderHeight;n<i&&e>=t||(n<i||e>=t&&o>=this.view.renderHeight?this.view.setScrollTop(n):e>=t&&this.view.setScrollTop(e-this.view.renderHeight))}}getHTMLElement(){return this.view.domNode}getElementID(e){return this.view.getElementDomId(e)}style(e){this.styleController.style(e)}toListEvent({indexes:e,browserEvent:t}){return{indexes:e,elements:e.map((e=>this.view.element(e))),browserEvent:t}}_onFocusChange(){const e=this.focus.get();this.view.domNode.classList.toggle("element-focused",e.length>0),this.onDidChangeActiveDescendant()}onDidChangeActiveDescendant(){var e;const t=this.focus.get();if(t.length>0){let i;(null===(e=this.accessibilityProvider)||void 0===e?void 0:e.getActiveDescendantId)&&(i=this.accessibilityProvider.getActiveDescendantId(this.view.element(t[0]))),this.view.domNode.setAttribute("aria-activedescendant",i||this.view.getElementDomId(t[0]))}else this.view.domNode.removeAttribute("aria-activedescendant")}_onSelectionChange(){const e=this.selection.get();this.view.domNode.classList.toggle("selection-none",0===e.length),this.view.domNode.classList.toggle("selection-single",1===e.length),this.view.domNode.classList.toggle("selection-multiple",e.length>1)}dispose(){this._onDidDispose.fire(),this.disposables.dispose(),this._onDidDispose.dispose()}}S([p.memoize],Y.prototype,"onDidChangeFocus",null),S([p.memoize],Y.prototype,"onDidChangeSelection",null),S([p.memoize],Y.prototype,"onContextMenu",null),S([p.memoize],Y.prototype,"onKeyDown",null),S([p.memoize],Y.prototype,"onDidFocus",null)},37218:function(e,t,i){"use strict";i.r(t),i.d(t,{RangeMap:function(){return a},consolidate:function(){return s},groupIntersect:function(){return o},shift:function(){return r}});var n=i(83682);function o(e,t){const i=[];for(const o of t){if(e.start>=o.range.end)continue;if(e.end<o.range.start)break;const t=n.Range.intersect(e,o.range);n.Range.isEmpty(t)||i.push({range:t,size:o.size})}return i}function r({start:e,end:t},i){return{start:e+i,end:t+i}}function s(e){const t=[];let i=null;for(const n of e){const e=n.range.start,o=n.range.end,r=n.size;i&&r===i.size?i.range.end=o:(i={range:{start:e,end:o},size:r},t.push(i))}return t}class a{constructor(){this.groups=[],this._size=0}splice(e,t,i=[]){const n=i.length-t,a=o({start:0,end:e},this.groups),l=o({start:e+t,end:Number.POSITIVE_INFINITY},this.groups).map((e=>({range:r(e.range,n),size:e.size}))),c=i.map(((t,i)=>({range:{start:e+i,end:e+i+1},size:t.size})));this.groups=function(...e){return s(e.reduce(((e,t)=>e.concat(t)),[]))}(a,c,l),this._size=this.groups.reduce(((e,t)=>e+t.size*(t.range.end-t.range.start)),0)}get count(){const e=this.groups.length;return e?this.groups[e-1].range.end:0}get size(){return this._size}indexAt(e){if(e<0)return-1;let t=0,i=0;for(const n of this.groups){const o=n.range.end-n.range.start,r=i+o*n.size;if(e<r)return t+Math.floor((e-i)/n.size);t+=o,i=r}return t}indexAfter(e){return Math.min(this.indexAt(e)+1,this.count)}positionAt(e){if(e<0)return-1;let t=0,i=0;for(const n of this.groups){const o=n.range.end-n.range.start,r=i+o;if(e<r)return t+(e-i)*n.size;t+=o*n.size,i=r}return-1}}},1056:function(e,t,i){"use strict";i.r(t),i.d(t,{RowCache:function(){return o}});var n=i(96747);class o{constructor(e){this.renderers=e,this.cache=new Map}alloc(e){let t=this.getTemplateCache(e).pop();if(!t){const i=(0,n.$)(".monaco-list-row");t={domNode:i,templateId:e,templateData:this.getRenderer(e).renderTemplate(i)}}return t}release(e){e&&this.releaseRow(e)}releaseRow(e){const{domNode:t,templateId:i}=e;t&&(t.classList.remove("scrolling"),function(e){var t;try{null===(t=e.parentElement)||void 0===t||t.removeChild(e)}catch(e){}}(t));this.getTemplateCache(i).push(e)}getTemplateCache(e){let t=this.cache.get(e);return t||(t=[],this.cache.set(e,t)),t}dispose(){this.cache.forEach(((e,t)=>{for(const i of e){this.getRenderer(t).disposeTemplate(i.templateData),i.templateData=null}})),this.cache.clear()}getRenderer(e){const t=this.renderers.get(e);if(!t)throw new Error(`No renderer found for ${e}`);return t}}},25218:function(e,t,i){"use strict";i.r(t),i.d(t,{CombinedSpliceable:function(){return n}});class n{constructor(e){this.spliceables=e}splice(e,t,i){this.spliceables.forEach((n=>n.splice(e,t,i)))}}},96959:function(e,t,i){"use strict";i.r(t),i.d(t,{Direction:function(){return w},MENU_ESCAPED_MNEMONIC_REGEX:function(){return C},MENU_MNEMONIC_REGEX:function(){return v},Menu:function(){return y},cleanMnemonic:function(){return k}});var n=i(76736),o=i(4043),r=i(96747),s=i(8769),a=i(5642),l=i(31532),c=i(61009),d=i(22694),u=i(96205),h=i(34309),g=i(60969),p=i(66129),m=i(56087),f=i(69373),b=i(68921),_=i(66719),A=i(91482);const v=/\(&([^\s&])\)|(^|[^&])&([^\s&])/,C=/(&amp;)?(&amp;)([^\s&])/g;var w;!function(e){e[e.Right=0]="Right",e[e.Left=1]="Left"}(w||(w={}));class y extends l.ActionBar{constructor(e,t,i={}){e.classList.add("monaco-menu-container"),e.setAttribute("role","presentation");const n=document.createElement("div");n.classList.add("monaco-menu"),n.setAttribute("role","presentation"),super(n,{orientation:1,actionViewItemProvider:e=>this.doGetActionViewItem(e,i,a),context:i.context,actionRunner:i.actionRunner,ariaLabel:i.ariaLabel,ariaRole:"menu",focusOnlyEnabledItems:!0,triggerKeys:{keys:[3,..._.isMacintosh||_.isLinux?[10]:[]],keyDown:!0}}),this.menuElement=n,this.actionsList.tabIndex=0,this.menuDisposables=this._register(new b.DisposableStore),this.initializeOrUpdateStyleSheet(e,{}),this._register(o.Gesture.addTarget(n)),(0,r.addDisposableListener)(n,r.EventType.KEY_DOWN,(e=>{new s.StandardKeyboardEvent(e).equals(2)&&e.preventDefault()})),i.enableMnemonics&&this.menuDisposables.add((0,r.addDisposableListener)(n,r.EventType.KEY_DOWN,(e=>{const t=e.key.toLocaleLowerCase();if(this.mnemonics.has(t)){r.EventHelper.stop(e,!0);const i=this.mnemonics.get(t);if(1===i.length&&(i[0]instanceof x&&i[0].container&&this.focusItemByElement(i[0].container),i[0].onClick(e)),i.length>1){const e=i.shift();e&&e.container&&(this.focusItemByElement(e.container),i.push(e)),this.mnemonics.set(t,i)}}}))),_.isLinux&&this._register((0,r.addDisposableListener)(n,r.EventType.KEY_DOWN,(e=>{const t=new s.StandardKeyboardEvent(e);t.equals(14)||t.equals(11)?(this.focusedItem=this.viewItems.length-1,this.focusNext(),r.EventHelper.stop(e,!0)):(t.equals(13)||t.equals(12))&&(this.focusedItem=0,this.focusPrevious(),r.EventHelper.stop(e,!0))}))),this._register((0,r.addDisposableListener)(this.domNode,r.EventType.MOUSE_OUT,(e=>{const t=e.relatedTarget;(0,r.isAncestor)(t,this.domNode)||(this.focusedItem=void 0,this.updateFocus(),e.stopPropagation())}))),this._register((0,r.addDisposableListener)(this.actionsList,r.EventType.MOUSE_OVER,(e=>{let t=e.target;if(t&&(0,r.isAncestor)(t,this.actionsList)&&t!==this.actionsList){for(;t.parentElement!==this.actionsList&&null!==t.parentElement;)t=t.parentElement;if(t.classList.contains("action-item")){const e=this.focusedItem;this.setFocusedItem(t),e!==this.focusedItem&&this.updateFocus()}}}))),this._register(o.Gesture.addTarget(this.actionsList)),this._register((0,r.addDisposableListener)(this.actionsList,o.EventType.Tap,(e=>{let t=e.initialTarget;if(t&&(0,r.isAncestor)(t,this.actionsList)&&t!==this.actionsList){for(;t.parentElement!==this.actionsList&&null!==t.parentElement;)t=t.parentElement;if(t.classList.contains("action-item")){const e=this.focusedItem;this.setFocusedItem(t),e!==this.focusedItem&&this.updateFocus()}}})));const a={parent:this};this.mnemonics=new Map,this.scrollableElement=this._register(new h.DomScrollableElement(n,{alwaysConsumeMouseWheel:!0,horizontal:2,vertical:3,verticalScrollbarSize:7,handleMouseWheel:!0,useShadows:!0}));const l=this.scrollableElement.getDomNode();l.style.position="",this._register((0,r.addDisposableListener)(n,o.EventType.Change,(e=>{r.EventHelper.stop(e,!0);const t=this.scrollableElement.getScrollPosition().scrollTop;this.scrollableElement.setScrollPosition({scrollTop:t-e.translationY})}))),this._register((0,r.addDisposableListener)(l,r.EventType.MOUSE_UP,(e=>{e.preventDefault()}))),n.style.maxHeight=`${Math.max(10,window.innerHeight-e.getBoundingClientRect().top-35)}px`,t=t.filter((e=>{var t;return!(null===(t=i.submenuIds)||void 0===t?void 0:t.has(e.id))||(console.warn(`Found submenu cycle: ${e.id}`),!1)})),this.push(t,{icon:!0,label:!0,isMenu:!0}),e.appendChild(this.scrollableElement.getDomNode()),this.scrollableElement.scanDomNode(),this.viewItems.filter((e=>!(e instanceof E))).forEach(((e,t,i)=>{e.updatePositionInSet(t+1,i.length)}))}initializeOrUpdateStyleSheet(e,t){this.styleSheet||((0,r.isInShadowDOM)(e)?this.styleSheet=(0,r.createStyleSheet)(e):(y.globalStyleSheet||(y.globalStyleSheet=(0,r.createStyleSheet)()),this.styleSheet=y.globalStyleSheet)),this.styleSheet.textContent=function(e,t){let i=`\n.monaco-menu {\n\tfont-size: 13px;\n\tborder-radius: 5px;\n\tmin-width: 160px;\n}\n\n${(0,d.formatRule)(m.Codicon.menuSelection)}\n${(0,d.formatRule)(m.Codicon.menuSubmenu)}\n\n.monaco-menu .monaco-action-bar {\n\ttext-align: right;\n\toverflow: hidden;\n\twhite-space: nowrap;\n}\n\n.monaco-menu .monaco-action-bar .actions-container {\n\tdisplay: flex;\n\tmargin: 0 auto;\n\tpadding: 0;\n\twidth: 100%;\n\tjustify-content: flex-end;\n}\n\n.monaco-menu .monaco-action-bar.vertical .actions-container {\n\tdisplay: inline-block;\n}\n\n.monaco-menu .monaco-action-bar.reverse .actions-container {\n\tflex-direction: row-reverse;\n}\n\n.monaco-menu .monaco-action-bar .action-item {\n\tcursor: pointer;\n\tdisplay: inline-block;\n\ttransition: transform 50ms ease;\n\tposition: relative;  /* DO NOT REMOVE - this is the key to preventing the ghosting icon bug in Chrome 42 */\n}\n\n.monaco-menu .monaco-action-bar .action-item.disabled {\n\tcursor: default;\n}\n\n.monaco-menu .monaco-action-bar.animated .action-item.active {\n\ttransform: scale(1.272019649, 1.272019649); /* 1.272019649 = √φ */\n}\n\n.monaco-menu .monaco-action-bar .action-item .icon,\n.monaco-menu .monaco-action-bar .action-item .codicon {\n\tdisplay: inline-block;\n}\n\n.monaco-menu .monaco-action-bar .action-item .codicon {\n\tdisplay: flex;\n\talign-items: center;\n}\n\n.monaco-menu .monaco-action-bar .action-label {\n\tfont-size: 11px;\n\tmargin-right: 4px;\n}\n\n.monaco-menu .monaco-action-bar .action-item.disabled .action-label,\n.monaco-menu .monaco-action-bar .action-item.disabled .action-label:hover {\n\tcolor: var(--vscode-disabledForeground);\n}\n\n/* Vertical actions */\n\n.monaco-menu .monaco-action-bar.vertical {\n\ttext-align: left;\n}\n\n.monaco-menu .monaco-action-bar.vertical .action-item {\n\tdisplay: block;\n}\n\n.monaco-menu .monaco-action-bar.vertical .action-label.separator {\n\tdisplay: block;\n\tborder-bottom: 1px solid var(--vscode-menu-separatorBackground);\n\tpadding-top: 1px;\n\tpadding: 30px;\n}\n\n.monaco-menu .secondary-actions .monaco-action-bar .action-label {\n\tmargin-left: 6px;\n}\n\n/* Action Items */\n.monaco-menu .monaco-action-bar .action-item.select-container {\n\toverflow: hidden; /* somehow the dropdown overflows its container, we prevent it here to not push */\n\tflex: 1;\n\tmax-width: 170px;\n\tmin-width: 60px;\n\tdisplay: flex;\n\talign-items: center;\n\tjustify-content: center;\n\tmargin-right: 10px;\n}\n\n.monaco-menu .monaco-action-bar.vertical {\n\tmargin-left: 0;\n\toverflow: visible;\n}\n\n.monaco-menu .monaco-action-bar.vertical .actions-container {\n\tdisplay: block;\n}\n\n.monaco-menu .monaco-action-bar.vertical .action-item {\n\tpadding: 0;\n\ttransform: none;\n\tdisplay: flex;\n}\n\n.monaco-menu .monaco-action-bar.vertical .action-item.active {\n\ttransform: none;\n}\n\n.monaco-menu .monaco-action-bar.vertical .action-menu-item {\n\tflex: 1 1 auto;\n\tdisplay: flex;\n\theight: 2em;\n\talign-items: center;\n\tposition: relative;\n}\n\n.monaco-menu .monaco-action-bar.vertical .action-menu-item:hover .keybinding,\n.monaco-menu .monaco-action-bar.vertical .action-menu-item:focus .keybinding {\n\topacity: unset;\n}\n\n.monaco-menu .monaco-action-bar.vertical .action-label {\n\tflex: 1 1 auto;\n\ttext-decoration: none;\n\tpadding: 0 1em;\n\tbackground: none;\n\tfont-size: 12px;\n\tline-height: 1;\n}\n\n.monaco-menu .monaco-action-bar.vertical .keybinding,\n.monaco-menu .monaco-action-bar.vertical .submenu-indicator {\n\tdisplay: inline-block;\n\tflex: 2 1 auto;\n\tpadding: 0 1em;\n\ttext-align: right;\n\tfont-size: 12px;\n\tline-height: 1;\n}\n\n.monaco-menu .monaco-action-bar.vertical .submenu-indicator {\n\theight: 100%;\n}\n\n.monaco-menu .monaco-action-bar.vertical .submenu-indicator.codicon {\n\tfont-size: 16px !important;\n\tdisplay: flex;\n\talign-items: center;\n}\n\n.monaco-menu .monaco-action-bar.vertical .submenu-indicator.codicon::before {\n\tmargin-left: auto;\n\tmargin-right: -20px;\n}\n\n.monaco-menu .monaco-action-bar.vertical .action-item.disabled .keybinding,\n.monaco-menu .monaco-action-bar.vertical .action-item.disabled .submenu-indicator {\n\topacity: 0.4;\n}\n\n.monaco-menu .monaco-action-bar.vertical .action-label:not(.separator) {\n\tdisplay: inline-block;\n\tbox-sizing: border-box;\n\tmargin: 0;\n}\n\n.monaco-menu .monaco-action-bar.vertical .action-item {\n\tposition: static;\n\toverflow: visible;\n}\n\n.monaco-menu .monaco-action-bar.vertical .action-item .monaco-submenu {\n\tposition: absolute;\n}\n\n.monaco-menu .monaco-action-bar.vertical .action-label.separator {\n\twidth: 100%;\n\theight: 0px !important;\n\topacity: 1;\n}\n\n.monaco-menu .monaco-action-bar.vertical .action-label.separator.text {\n\tpadding: 0.7em 1em 0.1em 1em;\n\tfont-weight: bold;\n\topacity: 1;\n}\n\n.monaco-menu .monaco-action-bar.vertical .action-label:hover {\n\tcolor: inherit;\n}\n\n.monaco-menu .monaco-action-bar.vertical .menu-item-check {\n\tposition: absolute;\n\tvisibility: hidden;\n\twidth: 1em;\n\theight: 100%;\n}\n\n.monaco-menu .monaco-action-bar.vertical .action-menu-item.checked .menu-item-check {\n\tvisibility: visible;\n\tdisplay: flex;\n\talign-items: center;\n\tjustify-content: center;\n}\n\n/* Context Menu */\n\n.context-view.monaco-menu-container {\n\toutline: 0;\n\tborder: none;\n\tanimation: fadeIn 0.083s linear;\n\t-webkit-app-region: no-drag;\n}\n\n.context-view.monaco-menu-container :focus,\n.context-view.monaco-menu-container .monaco-action-bar.vertical:focus,\n.context-view.monaco-menu-container .monaco-action-bar.vertical :focus {\n\toutline: 0;\n}\n\n.hc-black .context-view.monaco-menu-container,\n.hc-light .context-view.monaco-menu-container,\n:host-context(.hc-black) .context-view.monaco-menu-container,\n:host-context(.hc-light) .context-view.monaco-menu-container {\n\tbox-shadow: none;\n}\n\n.hc-black .monaco-menu .monaco-action-bar.vertical .action-item.focused,\n.hc-light .monaco-menu .monaco-action-bar.vertical .action-item.focused,\n:host-context(.hc-black) .monaco-menu .monaco-action-bar.vertical .action-item.focused,\n:host-context(.hc-light) .monaco-menu .monaco-action-bar.vertical .action-item.focused {\n\tbackground: none;\n}\n\n/* Vertical Action Bar Styles */\n\n.monaco-menu .monaco-action-bar.vertical {\n\tpadding: .6em 0;\n}\n\n.monaco-menu .monaco-action-bar.vertical .action-menu-item {\n\theight: 2em;\n}\n\n.monaco-menu .monaco-action-bar.vertical .action-label:not(.separator),\n.monaco-menu .monaco-action-bar.vertical .keybinding {\n\tfont-size: inherit;\n\tpadding: 0 2em;\n}\n\n.monaco-menu .monaco-action-bar.vertical .menu-item-check {\n\tfont-size: inherit;\n\twidth: 2em;\n}\n\n.monaco-menu .monaco-action-bar.vertical .action-label.separator {\n\tfont-size: inherit;\n\tmargin: 5px 0 !important;\n\tpadding: 0;\n\tborder-radius: 0;\n}\n\n.linux .monaco-menu .monaco-action-bar.vertical .action-label.separator,\n:host-context(.linux) .monaco-menu .monaco-action-bar.vertical .action-label.separator {\n\tmargin-left: 0;\n\tmargin-right: 0;\n}\n\n.monaco-menu .monaco-action-bar.vertical .submenu-indicator {\n\tfont-size: 60%;\n\tpadding: 0 1.8em;\n}\n\n.linux .monaco-menu .monaco-action-bar.vertical .submenu-indicator {\n:host-context(.linux) .monaco-menu .monaco-action-bar.vertical .submenu-indicator {\n\theight: 100%;\n\tmask-size: 10px 10px;\n\t-webkit-mask-size: 10px 10px;\n}\n\n.monaco-menu .action-item {\n\tcursor: default;\n}`;if(t){i+="\n\t\t\t/* Arrows */\n\t\t\t.monaco-scrollable-element > .scrollbar > .scra {\n\t\t\t\tcursor: pointer;\n\t\t\t\tfont-size: 11px !important;\n\t\t\t}\n\n\t\t\t.monaco-scrollable-element > .visible {\n\t\t\t\topacity: 1;\n\n\t\t\t\t/* Background rule added for IE9 - to allow clicks on dom node */\n\t\t\t\tbackground:rgba(0,0,0,0);\n\n\t\t\t\ttransition: opacity 100ms linear;\n\t\t\t}\n\t\t\t.monaco-scrollable-element > .invisible {\n\t\t\t\topacity: 0;\n\t\t\t\tpointer-events: none;\n\t\t\t}\n\t\t\t.monaco-scrollable-element > .invisible.fade {\n\t\t\t\ttransition: opacity 800ms linear;\n\t\t\t}\n\n\t\t\t/* Scrollable Content Inset Shadow */\n\t\t\t.monaco-scrollable-element > .shadow {\n\t\t\t\tposition: absolute;\n\t\t\t\tdisplay: none;\n\t\t\t}\n\t\t\t.monaco-scrollable-element > .shadow.top {\n\t\t\t\tdisplay: block;\n\t\t\t\ttop: 0;\n\t\t\t\tleft: 3px;\n\t\t\t\theight: 3px;\n\t\t\t\twidth: 100%;\n\t\t\t}\n\t\t\t.monaco-scrollable-element > .shadow.left {\n\t\t\t\tdisplay: block;\n\t\t\t\ttop: 3px;\n\t\t\t\tleft: 0;\n\t\t\t\theight: 100%;\n\t\t\t\twidth: 3px;\n\t\t\t}\n\t\t\t.monaco-scrollable-element > .shadow.top-left-corner {\n\t\t\t\tdisplay: block;\n\t\t\t\ttop: 0;\n\t\t\t\tleft: 0;\n\t\t\t\theight: 3px;\n\t\t\t\twidth: 3px;\n\t\t\t}\n\t\t";const t=e.scrollbarShadow;t&&(i+=`\n\t\t\t\t.monaco-scrollable-element > .shadow.top {\n\t\t\t\t\tbox-shadow: ${t} 0 6px 6px -6px inset;\n\t\t\t\t}\n\n\t\t\t\t.monaco-scrollable-element > .shadow.left {\n\t\t\t\t\tbox-shadow: ${t} 6px 0 6px -6px inset;\n\t\t\t\t}\n\n\t\t\t\t.monaco-scrollable-element > .shadow.top.left {\n\t\t\t\t\tbox-shadow: ${t} 6px 6px 6px -6px inset;\n\t\t\t\t}\n\t\t\t`);const n=e.scrollbarSliderBackground;n&&(i+=`\n\t\t\t\t.monaco-scrollable-element > .scrollbar > .slider {\n\t\t\t\t\tbackground: ${n};\n\t\t\t\t}\n\t\t\t`);const o=e.scrollbarSliderHoverBackground;o&&(i+=`\n\t\t\t\t.monaco-scrollable-element > .scrollbar > .slider:hover {\n\t\t\t\t\tbackground: ${o};\n\t\t\t\t}\n\t\t\t`);const r=e.scrollbarSliderActiveBackground;r&&(i+=`\n\t\t\t\t.monaco-scrollable-element > .scrollbar > .slider.active {\n\t\t\t\t\tbackground: ${r};\n\t\t\t\t}\n\t\t\t`)}return i}(t,(0,r.isInShadowDOM)(e))}style(e){const t=this.getContainer();this.initializeOrUpdateStyleSheet(t,e);const i=e.foregroundColor?`${e.foregroundColor}`:"",n=e.backgroundColor?`${e.backgroundColor}`:"",o=e.borderColor?`1px solid ${e.borderColor}`:"",r=e.shadowColor?`0 2px 8px ${e.shadowColor}`:"";t.style.outline=o,t.style.borderRadius="5px",t.style.color=i,t.style.backgroundColor=n,t.style.boxShadow=r,this.viewItems&&this.viewItems.forEach((t=>{(t instanceof S||t instanceof E)&&t.style(e)}))}getContainer(){return this.scrollableElement.getDomNode()}get onScroll(){return this.scrollableElement.onScroll}focusItemByElement(e){const t=this.focusedItem;this.setFocusedItem(e),t!==this.focusedItem&&this.updateFocus()}setFocusedItem(e){for(let t=0;t<this.actionsList.children.length;t++){if(e===this.actionsList.children[t]){this.focusedItem=t;break}}}updateFocus(e){super.updateFocus(e,!0,!0),void 0!==this.focusedItem&&this.scrollableElement.setScrollPosition({scrollTop:Math.round(this.menuElement.scrollTop)})}doGetActionViewItem(e,t,i){if(e instanceof g.Separator)return new E(t.context,e,{icon:!0});if(e instanceof g.SubmenuAction){const n=new x(e,e.actions,i,Object.assign(Object.assign({},t),{submenuIds:new Set([...t.submenuIds||[],e.id])}));if(t.enableMnemonics){const e=n.getMnemonic();if(e&&n.isEnabled()){let t=[];this.mnemonics.has(e)&&(t=this.mnemonics.get(e)),t.push(n),this.mnemonics.set(e,t)}}return n}{const i={enableMnemonics:t.enableMnemonics,useEventAsContext:t.useEventAsContext};if(t.getKeyBinding){const n=t.getKeyBinding(e);if(n){const e=n.getLabel();e&&(i.keybinding=e)}}const n=new S(t.context,e,i);if(t.enableMnemonics){const e=n.getMnemonic();if(e&&n.isEnabled()){let t=[];this.mnemonics.has(e)&&(t=this.mnemonics.get(e)),t.push(n),this.mnemonics.set(e,t)}}return n}}}class S extends c.BaseActionViewItem{constructor(e,t,i={}){if(i.isMenu=!0,super(t,t,i),this.options=i,this.options.icon=void 0!==i.icon&&i.icon,this.options.label=void 0===i.label||i.label,this.cssClass="",this.options.label&&i.enableMnemonics){const e=this.getAction().label;if(e){const t=v.exec(e);t&&(this.mnemonic=(t[1]?t[1]:t[3]).toLocaleLowerCase())}}this.runOnceToEnableMouseUp=new p.RunOnceScheduler((()=>{this.element&&(this._register((0,r.addDisposableListener)(this.element,r.EventType.MOUSE_UP,(e=>{if(r.EventHelper.stop(e,!0),n.isFirefox){if(new a.StandardMouseEvent(e).rightButton)return;this.onClick(e)}else setTimeout((()=>{this.onClick(e)}),0)}))),this._register((0,r.addDisposableListener)(this.element,r.EventType.CONTEXT_MENU,(e=>{r.EventHelper.stop(e,!0)}))))}),100),this._register(this.runOnceToEnableMouseUp)}render(e){super.render(e),this.element&&(this.container=e,this.item=(0,r.append)(this.element,(0,r.$)("a.action-menu-item")),this._action.id===g.Separator.ID?this.item.setAttribute("role","presentation"):(this.item.setAttribute("role","menuitem"),this.mnemonic&&this.item.setAttribute("aria-keyshortcuts",`${this.mnemonic}`)),this.check=(0,r.append)(this.item,(0,r.$)("span.menu-item-check"+m.Codicon.menuSelection.cssSelector)),this.check.setAttribute("role","none"),this.label=(0,r.append)(this.item,(0,r.$)("span.action-label")),this.options.label&&this.options.keybinding&&((0,r.append)(this.item,(0,r.$)("span.keybinding")).textContent=this.options.keybinding),this.runOnceToEnableMouseUp.schedule(),this.updateClass(),this.updateLabel(),this.updateTooltip(),this.updateEnabled(),this.updateChecked())}blur(){super.blur(),this.applyStyle()}focus(){super.focus(),this.item&&this.item.focus(),this.applyStyle()}updatePositionInSet(e,t){this.item&&(this.item.setAttribute("aria-posinset",`${e}`),this.item.setAttribute("aria-setsize",`${t}`))}updateLabel(){var e;if(this.label&&this.options.label){(0,r.clearNode)(this.label);let t=(0,f.stripIcons)(this.getAction().label);if(t){const i=k(t);this.options.enableMnemonics||(t=i),this.label.setAttribute("aria-label",i.replace(/&&/g,"&"));const n=v.exec(t);if(n){t=A.escape(t),C.lastIndex=0;let i=C.exec(t);for(;i&&i[1];)i=C.exec(t);const o=e=>e.replace(/&amp;&amp;/g,"&amp;");i?this.label.append(A.ltrim(o(t.substr(0,i.index))," "),(0,r.$)("u",{"aria-hidden":"true"},i[3]),A.rtrim(o(t.substr(i.index+i[0].length))," ")):this.label.innerText=o(t).trim(),null===(e=this.item)||void 0===e||e.setAttribute("aria-keyshortcuts",(n[1]?n[1]:n[3]).toLocaleLowerCase())}else this.label.innerText=t.replace(/&&/g,"&").trim()}}}updateTooltip(){}updateClass(){this.cssClass&&this.item&&this.item.classList.remove(...this.cssClass.split(" ")),this.options.icon&&this.label?(this.cssClass=this.getAction().class||"",this.label.classList.add("icon"),this.cssClass&&this.label.classList.add(...this.cssClass.split(" ")),this.updateEnabled()):this.label&&this.label.classList.remove("icon")}updateEnabled(){this.getAction().enabled?(this.element&&(this.element.classList.remove("disabled"),this.element.removeAttribute("aria-disabled")),this.item&&(this.item.classList.remove("disabled"),this.item.removeAttribute("aria-disabled"),this.item.tabIndex=0)):(this.element&&(this.element.classList.add("disabled"),this.element.setAttribute("aria-disabled","true")),this.item&&(this.item.classList.add("disabled"),this.item.setAttribute("aria-disabled","true")))}updateChecked(){if(!this.item)return;const e=this.getAction().checked;this.item.classList.toggle("checked",!!e),void 0!==e?(this.item.setAttribute("role","menuitemcheckbox"),this.item.setAttribute("aria-checked",e?"true":"false")):(this.item.setAttribute("role","menuitem"),this.item.setAttribute("aria-checked",""))}getMnemonic(){return this.mnemonic}applyStyle(){if(!this.menuStyle)return;const e=this.element&&this.element.classList.contains("focused"),t=e&&this.menuStyle.selectionForegroundColor?this.menuStyle.selectionForegroundColor:this.menuStyle.foregroundColor,i=e&&this.menuStyle.selectionBackgroundColor?this.menuStyle.selectionBackgroundColor:void 0,n=e&&this.menuStyle.selectionBorderColor?`1px solid ${this.menuStyle.selectionBorderColor}`:"",o=e&&this.menuStyle.selectionBorderColor?"-1px":"";this.item&&(this.item.style.color=t?t.toString():"",this.item.style.backgroundColor=i?i.toString():"",this.item.style.outline=n,this.item.style.outlineOffset=o),this.check&&(this.check.style.color=t?t.toString():"")}style(e){this.menuStyle=e,this.applyStyle()}}class x extends S{constructor(e,t,i,n){super(e,e,n),this.submenuActions=t,this.parentData=i,this.submenuOptions=n,this.mysubmenu=null,this.submenuDisposables=this._register(new b.DisposableStore),this.mouseOver=!1,this.expandDirection=n&&void 0!==n.expandDirection?n.expandDirection:w.Right,this.showScheduler=new p.RunOnceScheduler((()=>{this.mouseOver&&(this.cleanupExistingSubmenu(!1),this.createSubmenu(!1))}),250),this.hideScheduler=new p.RunOnceScheduler((()=>{this.element&&!(0,r.isAncestor)((0,r.getActiveElement)(),this.element)&&this.parentData.submenu===this.mysubmenu&&(this.parentData.parent.focus(!1),this.cleanupExistingSubmenu(!0))}),750)}render(e){super.render(e),this.element&&(this.item&&(this.item.classList.add("monaco-submenu-item"),this.item.tabIndex=0,this.item.setAttribute("aria-haspopup","true"),this.updateAriaExpanded("false"),this.submenuIndicator=(0,r.append)(this.item,(0,r.$)("span.submenu-indicator"+m.Codicon.menuSubmenu.cssSelector)),this.submenuIndicator.setAttribute("aria-hidden","true")),this._register((0,r.addDisposableListener)(this.element,r.EventType.KEY_UP,(e=>{const t=new s.StandardKeyboardEvent(e);(t.equals(17)||t.equals(3))&&(r.EventHelper.stop(e,!0),this.createSubmenu(!0))}))),this._register((0,r.addDisposableListener)(this.element,r.EventType.KEY_DOWN,(e=>{const t=new s.StandardKeyboardEvent(e);(0,r.getActiveElement)()===this.item&&(t.equals(17)||t.equals(3))&&r.EventHelper.stop(e,!0)}))),this._register((0,r.addDisposableListener)(this.element,r.EventType.MOUSE_OVER,(e=>{this.mouseOver||(this.mouseOver=!0,this.showScheduler.schedule())}))),this._register((0,r.addDisposableListener)(this.element,r.EventType.MOUSE_LEAVE,(e=>{this.mouseOver=!1}))),this._register((0,r.addDisposableListener)(this.element,r.EventType.FOCUS_OUT,(e=>{this.element&&!(0,r.isAncestor)((0,r.getActiveElement)(),this.element)&&this.hideScheduler.schedule()}))),this._register(this.parentData.parent.onScroll((()=>{this.parentData.submenu===this.mysubmenu&&(this.parentData.parent.focus(!1),this.cleanupExistingSubmenu(!0))}))))}updateEnabled(){}onClick(e){r.EventHelper.stop(e,!0),this.cleanupExistingSubmenu(!1),this.createSubmenu(!0)}cleanupExistingSubmenu(e){if(this.parentData.submenu&&(e||this.parentData.submenu!==this.mysubmenu)){try{this.parentData.submenu.dispose()}catch(e){}this.parentData.submenu=void 0,this.updateAriaExpanded("false"),this.submenuContainer&&(this.submenuDisposables.clear(),this.submenuContainer=void 0)}}calculateSubmenuMenuLayout(e,t,i,n){const o={top:0,left:0};return o.left=(0,u.layout)(e.width,t.width,{position:n===w.Right?0:1,offset:i.left,size:i.width}),o.left>=i.left&&o.left<i.left+i.width&&(i.left+10+t.width<=e.width&&(o.left=i.left+10),i.top+=10,i.height=0),o.top=(0,u.layout)(e.height,t.height,{position:0,offset:i.top,size:0}),o.top+t.height===i.top&&o.top+i.height+t.height<=e.height&&(o.top+=i.height),o}createSubmenu(e=!0){if(this.element)if(this.parentData.submenu)this.parentData.submenu.focus(!1);else{this.updateAriaExpanded("true"),this.submenuContainer=(0,r.append)(this.element,(0,r.$)("div.monaco-submenu")),this.submenuContainer.classList.add("menubar-menu-items-holder","context-view");const t=getComputedStyle(this.parentData.parent.domNode),i=parseFloat(t.paddingTop||"0")||0;this.submenuContainer.style.zIndex="1",this.submenuContainer.style.position="fixed",this.submenuContainer.style.top="0",this.submenuContainer.style.left="0",this.parentData.submenu=new y(this.submenuContainer,this.submenuActions.length?this.submenuActions:[new g.EmptySubmenuAction],this.submenuOptions),this.menuStyle&&this.parentData.submenu.style(this.menuStyle);const n=this.element.getBoundingClientRect(),o={top:n.top-i,left:n.left,height:n.height+2*i,width:n.width},a=this.submenuContainer.getBoundingClientRect(),{top:l,left:c}=this.calculateSubmenuMenuLayout(new r.Dimension(window.innerWidth,window.innerHeight),r.Dimension.lift(a),o,this.expandDirection);this.submenuContainer.style.left=c-a.left+"px",this.submenuContainer.style.top=l-a.top+"px",this.submenuDisposables.add((0,r.addDisposableListener)(this.submenuContainer,r.EventType.KEY_UP,(e=>{new s.StandardKeyboardEvent(e).equals(15)&&(r.EventHelper.stop(e,!0),this.parentData.parent.focus(),this.cleanupExistingSubmenu(!0))}))),this.submenuDisposables.add((0,r.addDisposableListener)(this.submenuContainer,r.EventType.KEY_DOWN,(e=>{new s.StandardKeyboardEvent(e).equals(15)&&r.EventHelper.stop(e,!0)}))),this.submenuDisposables.add(this.parentData.submenu.onDidCancel((()=>{this.parentData.parent.focus(),this.cleanupExistingSubmenu(!0)}))),this.parentData.submenu.focus(e),this.mysubmenu=this.parentData.submenu}}updateAriaExpanded(e){var t;this.item&&(null===(t=this.item)||void 0===t||t.setAttribute("aria-expanded",e))}applyStyle(){var e;if(super.applyStyle(),!this.menuStyle)return;const t=this.element&&this.element.classList.contains("focused")&&this.menuStyle.selectionForegroundColor?this.menuStyle.selectionForegroundColor:this.menuStyle.foregroundColor;this.submenuIndicator&&(this.submenuIndicator.style.color=t?`${t}`:""),null===(e=this.parentData.submenu)||void 0===e||e.style(this.menuStyle)}dispose(){super.dispose(),this.hideScheduler.dispose(),this.mysubmenu&&(this.mysubmenu.dispose(),this.mysubmenu=null),this.submenuContainer&&(this.submenuContainer=void 0)}}class E extends c.ActionViewItem{style(e){this.label&&(this.label.style.borderBottomColor=e.separatorColor?`${e.separatorColor}`:"")}}function k(e){const t=v,i=t.exec(e);if(!i)return e;const n=!i[1];return e.replace(t,n?"$2$3":"").trim()}},16011:function(e,t,i){"use strict";i.r(t),i.d(t,{MOUSE_CURSOR_TEXT_CSS_CLASS_NAME:function(){return b}});var n=i(93379),o=i.n(n),r=i(7795),s=i.n(r),a=i(90569),l=i.n(a),c=i(3565),d=i.n(c),u=i(19216),h=i.n(u),g=i(44589),p=i.n(g),m=i(58322),f={};f.styleTagTransform=p(),f.setAttributes=d(),f.insert=l().bind(null,"head"),f.domAPI=s(),f.insertStyleElement=h();o()(m.Z,f),m.Z&&m.Z.locals&&m.Z.locals;const b="monaco-mouse-cursor-text"},81449:function(e,t,i){"use strict";i.r(t),i.d(t,{ProgressBar:function(){return I}});var n=i(96747),o=i(66129),r=i(17160),s=i(68921),a=i(91057),l=i(93379),c=i.n(l),d=i(7795),u=i.n(d),h=i(90569),g=i.n(h),p=i(3565),m=i.n(p),f=i(19216),b=i.n(f),_=i(44589),A=i.n(_),v=i(41227),C={};C.styleTagTransform=A(),C.setAttributes=m(),C.insert=g().bind(null,"head"),C.domAPI=u(),C.insertStyleElement=b();c()(v.Z,C),v.Z&&v.Z.locals&&v.Z.locals;const w="done",y="active",S="infinite",x="infinite-long-running",E="discrete",k={progressBarBackground:r.Color.fromHex("#0E70C0")};class I extends s.Disposable{constructor(e,t){super(),this.options=t||Object.create(null),(0,a.mixin)(this.options,k,!1),this.workedVal=0,this.progressBarBackground=this.options.progressBarBackground,this.showDelayedScheduler=this._register(new o.RunOnceScheduler((()=>(0,n.show)(this.element)),0)),this.longRunningScheduler=this._register(new o.RunOnceScheduler((()=>this.infiniteLongRunning()),I.LONG_RUNNING_INFINITE_THRESHOLD)),this.create(e)}create(e){this.element=document.createElement("div"),this.element.classList.add("monaco-progress-container"),this.element.setAttribute("role","progressbar"),this.element.setAttribute("aria-valuemin","0"),e.appendChild(this.element),this.bit=document.createElement("div"),this.bit.classList.add("progress-bit"),this.element.appendChild(this.bit),this.applyStyles()}off(){this.bit.style.width="inherit",this.bit.style.opacity="1",this.element.classList.remove(y,S,x,E),this.workedVal=0,this.totalWork=void 0,this.longRunningScheduler.cancel()}stop(){return this.doDone(!1)}doDone(e){return this.element.classList.add(w),this.element.classList.contains(S)?(this.bit.style.opacity="0",e?setTimeout((()=>this.off()),200):this.off()):(this.bit.style.width="inherit",e?setTimeout((()=>this.off()),200):this.off()),this}infinite(){return this.bit.style.width="2%",this.bit.style.opacity="1",this.element.classList.remove(E,w,x),this.element.classList.add(y,S),this.longRunningScheduler.schedule(),this}infiniteLongRunning(){this.element.classList.add(x)}getContainer(){return this.element}style(e){this.progressBarBackground=e.progressBarBackground,this.applyStyles()}applyStyles(){if(this.bit){const e=this.progressBarBackground?this.progressBarBackground.toString():"";this.bit.style.backgroundColor=e}}}I.LONG_RUNNING_INFINITE_THRESHOLD=1e4},59625:function(e,t,i){"use strict";i.r(t),i.d(t,{OrthogonalEdge:function(){return E},Sash:function(){return N}});var n=i(96747),o=i(50465),r=i(4043),s=i(66129),a=i(63966),l=i(63801),c=i(68921),d=i(66719),u=i(93379),h=i.n(u),g=i(7795),p=i.n(g),m=i(90569),f=i.n(m),b=i(3565),_=i.n(b),A=i(19216),v=i.n(A),C=i(44589),w=i.n(C),y=i(67054),S={};S.styleTagTransform=w(),S.setAttributes=_(),S.insert=f().bind(null,"head"),S.domAPI=p(),S.insertStyleElement=v();h()(y.Z,S),y.Z&&y.Z.locals&&y.Z.locals;var x=function(e,t,i,n){var o,r=arguments.length,s=r<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,i):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)s=Reflect.decorate(e,t,i,n);else for(var a=e.length-1;a>=0;a--)(o=e[a])&&(s=(r<3?o(s):r>3?o(t,i,s):o(t,i))||s);return r>3&&s&&Object.defineProperty(t,i,s),s};var E;!function(e){e.North="north",e.South="south",e.East="east",e.West="west"}(E||(E={}));const k=new l.Emitter;const I=new l.Emitter;class D{constructor(){this.disposables=new c.DisposableStore}get onPointerMove(){return this.disposables.add(new o.DomEmitter(window,"mousemove")).event}get onPointerUp(){return this.disposables.add(new o.DomEmitter(window,"mouseup")).event}dispose(){this.disposables.dispose()}}x([a.memoize],D.prototype,"onPointerMove",null),x([a.memoize],D.prototype,"onPointerUp",null);class L{constructor(e){this.el=e,this.disposables=new c.DisposableStore}get onPointerMove(){return this.disposables.add(new o.DomEmitter(this.el,r.EventType.Change)).event}get onPointerUp(){return this.disposables.add(new o.DomEmitter(this.el,r.EventType.End)).event}dispose(){this.disposables.dispose()}}x([a.memoize],L.prototype,"onPointerMove",null),x([a.memoize],L.prototype,"onPointerUp",null);class T{constructor(e){this.factory=e}get onPointerMove(){return this.factory.onPointerMove}get onPointerUp(){return this.factory.onPointerUp}dispose(){}}x([a.memoize],T.prototype,"onPointerMove",null),x([a.memoize],T.prototype,"onPointerUp",null);const M="pointer-events-disabled";class N extends c.Disposable{constructor(e,t,i){super(),this.hoverDelay=300,this.hoverDelayer=this._register(new s.Delayer(this.hoverDelay)),this._state=3,this.onDidEnablementChange=this._register(new l.Emitter),this._onDidStart=this._register(new l.Emitter),this._onDidChange=this._register(new l.Emitter),this._onDidReset=this._register(new l.Emitter),this._onDidEnd=this._register(new l.Emitter),this.orthogonalStartSashDisposables=this._register(new c.DisposableStore),this.orthogonalStartDragHandleDisposables=this._register(new c.DisposableStore),this.orthogonalEndSashDisposables=this._register(new c.DisposableStore),this.orthogonalEndDragHandleDisposables=this._register(new c.DisposableStore),this.onDidStart=this._onDidStart.event,this.onDidChange=this._onDidChange.event,this.onDidReset=this._onDidReset.event,this.onDidEnd=this._onDidEnd.event,this.linkedSash=void 0,this.el=(0,n.append)(e,(0,n.$)(".monaco-sash")),i.orthogonalEdge&&this.el.classList.add(`orthogonal-edge-${i.orthogonalEdge}`),d.isMacintosh&&this.el.classList.add("mac");const a=this._register(new o.DomEmitter(this.el,"mousedown")).event;this._register(a((e=>this.onPointerStart(e,new D)),this));const u=this._register(new o.DomEmitter(this.el,"dblclick")).event;this._register(u(this.onPointerDoublePress,this));const h=this._register(new o.DomEmitter(this.el,"mouseenter")).event;this._register(h((()=>N.onMouseEnter(this))));const g=this._register(new o.DomEmitter(this.el,"mouseleave")).event;this._register(g((()=>N.onMouseLeave(this)))),this._register(r.Gesture.addTarget(this.el));const p=l.Event.map(this._register(new o.DomEmitter(this.el,r.EventType.Start)).event,(e=>{var t;return Object.assign(Object.assign({},e),{target:null!==(t=e.initialTarget)&&void 0!==t?t:null})}));this._register(p((e=>this.onPointerStart(e,new L(this.el))),this));const m=this._register(new o.DomEmitter(this.el,r.EventType.Tap)).event,f=l.Event.map(l.Event.filter(l.Event.debounce(m,((e,t)=>{var i;return{event:t,count:(null!==(i=null==e?void 0:e.count)&&void 0!==i?i:0)+1}}),250),(({count:e})=>2===e)),(({event:e})=>{var t;return Object.assign(Object.assign({},e),{target:null!==(t=e.initialTarget)&&void 0!==t?t:null})}));this._register(f(this.onPointerDoublePress,this)),"number"==typeof i.size?(this.size=i.size,0===i.orientation?this.el.style.width=`${this.size}px`:this.el.style.height=`${this.size}px`):(this.size=4,this._register(k.event((e=>{this.size=e,this.layout()})))),this._register(I.event((e=>this.hoverDelay=e))),this.layoutProvider=t,this.orthogonalStartSash=i.orthogonalStartSash,this.orthogonalEndSash=i.orthogonalEndSash,this.orientation=i.orientation||0,1===this.orientation?(this.el.classList.add("horizontal"),this.el.classList.remove("vertical")):(this.el.classList.remove("horizontal"),this.el.classList.add("vertical")),this.el.classList.toggle("debug",false),this.layout()}get state(){return this._state}get orthogonalStartSash(){return this._orthogonalStartSash}get orthogonalEndSash(){return this._orthogonalEndSash}set state(e){this._state!==e&&(this.el.classList.toggle("disabled",0===e),this.el.classList.toggle("minimum",1===e),this.el.classList.toggle("maximum",2===e),this._state=e,this.onDidEnablementChange.fire(e))}set orthogonalStartSash(e){if(this.orthogonalStartDragHandleDisposables.clear(),this.orthogonalStartSashDisposables.clear(),e){const t=t=>{this.orthogonalStartDragHandleDisposables.clear(),0!==t&&(this._orthogonalStartDragHandle=(0,n.append)(this.el,(0,n.$)(".orthogonal-drag-handle.start")),this.orthogonalStartDragHandleDisposables.add((0,c.toDisposable)((()=>this._orthogonalStartDragHandle.remove()))),this.orthogonalStartDragHandleDisposables.add(new o.DomEmitter(this._orthogonalStartDragHandle,"mouseenter")).event((()=>N.onMouseEnter(e)),void 0,this.orthogonalStartDragHandleDisposables),this.orthogonalStartDragHandleDisposables.add(new o.DomEmitter(this._orthogonalStartDragHandle,"mouseleave")).event((()=>N.onMouseLeave(e)),void 0,this.orthogonalStartDragHandleDisposables))};this.orthogonalStartSashDisposables.add(e.onDidEnablementChange.event(t,this)),t(e.state)}this._orthogonalStartSash=e}set orthogonalEndSash(e){if(this.orthogonalEndDragHandleDisposables.clear(),this.orthogonalEndSashDisposables.clear(),e){const t=t=>{this.orthogonalEndDragHandleDisposables.clear(),0!==t&&(this._orthogonalEndDragHandle=(0,n.append)(this.el,(0,n.$)(".orthogonal-drag-handle.end")),this.orthogonalEndDragHandleDisposables.add((0,c.toDisposable)((()=>this._orthogonalEndDragHandle.remove()))),this.orthogonalEndDragHandleDisposables.add(new o.DomEmitter(this._orthogonalEndDragHandle,"mouseenter")).event((()=>N.onMouseEnter(e)),void 0,this.orthogonalEndDragHandleDisposables),this.orthogonalEndDragHandleDisposables.add(new o.DomEmitter(this._orthogonalEndDragHandle,"mouseleave")).event((()=>N.onMouseLeave(e)),void 0,this.orthogonalEndDragHandleDisposables))};this.orthogonalEndSashDisposables.add(e.onDidEnablementChange.event(t,this)),t(e.state)}this._orthogonalEndSash=e}onPointerStart(e,t){n.EventHelper.stop(e);let i=!1;if(!e.__orthogonalSashEvent){const n=this.getOrthogonalSash(e);n&&(i=!0,e.__orthogonalSashEvent=!0,n.onPointerStart(e,new T(t)))}if(this.linkedSash&&!e.__linkedSashEvent&&(e.__linkedSashEvent=!0,this.linkedSash.onPointerStart(e,new T(t))),!this.state)return;const o=(0,n.getElementsByTagName)("iframe");for(const e of o)e.classList.add(M);const r=e.pageX,s=e.pageY,a=e.altKey,l={startX:r,currentX:r,startY:s,currentY:s,altKey:a};this.el.classList.add("active"),this._onDidStart.fire(l);const u=(0,n.createStyleSheet)(this.el),h=()=>{let e="";e=i?"all-scroll":1===this.orientation?1===this.state?"s-resize":2===this.state?"n-resize":d.isMacintosh?"row-resize":"ns-resize":1===this.state?"e-resize":2===this.state?"w-resize":d.isMacintosh?"col-resize":"ew-resize",u.textContent=`* { cursor: ${e} !important; }`},g=new c.DisposableStore;h(),i||this.onDidEnablementChange.event(h,null,g);t.onPointerMove((e=>{n.EventHelper.stop(e,!1);const t={startX:r,currentX:e.pageX,startY:s,currentY:e.pageY,altKey:a};this._onDidChange.fire(t)}),null,g),t.onPointerUp((e=>{n.EventHelper.stop(e,!1),this.el.removeChild(u),this.el.classList.remove("active"),this._onDidEnd.fire(),g.dispose();for(const e of o)e.classList.remove(M)}),null,g),g.add(t)}onPointerDoublePress(e){const t=this.getOrthogonalSash(e);t&&t._onDidReset.fire(),this.linkedSash&&this.linkedSash._onDidReset.fire(),this._onDidReset.fire()}static onMouseEnter(e,t=!1){e.el.classList.contains("active")?(e.hoverDelayer.cancel(),e.el.classList.add("hover")):e.hoverDelayer.trigger((()=>e.el.classList.add("hover")),e.hoverDelay).then(void 0,(()=>{})),!t&&e.linkedSash&&N.onMouseEnter(e.linkedSash,!0)}static onMouseLeave(e,t=!1){e.hoverDelayer.cancel(),e.el.classList.remove("hover"),!t&&e.linkedSash&&N.onMouseLeave(e.linkedSash,!0)}clearSashHoverState(){N.onMouseLeave(this)}layout(){if(0===this.orientation){const e=this.layoutProvider;this.el.style.left=e.getVerticalSashLeft(this)-this.size/2+"px",e.getVerticalSashTop&&(this.el.style.top=e.getVerticalSashTop(this)+"px"),e.getVerticalSashHeight&&(this.el.style.height=e.getVerticalSashHeight(this)+"px")}else{const e=this.layoutProvider;this.el.style.top=e.getHorizontalSashTop(this)-this.size/2+"px",e.getHorizontalSashLeft&&(this.el.style.left=e.getHorizontalSashLeft(this)+"px"),e.getHorizontalSashWidth&&(this.el.style.width=e.getHorizontalSashWidth(this)+"px")}}getOrthogonalSash(e){if(e.target&&e.target instanceof HTMLElement)return e.target.classList.contains("orthogonal-drag-handle")?e.target.classList.contains("start")?this.orthogonalStartSash:this.orthogonalEndSash:void 0}dispose(){super.dispose(),this.el.remove()}}},92117:function(e,t,i){"use strict";i.r(t),i.d(t,{AbstractScrollbar:function(){return d}});var n=i(96747),o=i(85297),r=i(95689),s=i(24990),a=i(23487),l=i(47257),c=i(66719);class d extends l.Widget{constructor(e){super(),this._lazyRender=e.lazyRender,this._host=e.host,this._scrollable=e.scrollable,this._scrollByPage=e.scrollByPage,this._scrollbarState=e.scrollbarState,this._visibilityController=this._register(new a.ScrollbarVisibilityController(e.visibility,"visible scrollbar "+e.extraScrollbarClassName,"invisible scrollbar "+e.extraScrollbarClassName)),this._visibilityController.setIsNeeded(this._scrollbarState.isNeeded()),this._pointerMoveMonitor=this._register(new r.GlobalPointerMoveMonitor),this._shouldRender=!0,this.domNode=(0,o.createFastDomNode)(document.createElement("div")),this.domNode.setAttribute("role","presentation"),this.domNode.setAttribute("aria-hidden","true"),this._visibilityController.setDomNode(this.domNode),this.domNode.setPosition("absolute"),this._register(n.addDisposableListener(this.domNode.domNode,n.EventType.POINTER_DOWN,(e=>this._domNodePointerDown(e))))}_createArrow(e){const t=this._register(new s.ScrollbarArrow(e));this.domNode.domNode.appendChild(t.bgDomNode),this.domNode.domNode.appendChild(t.domNode)}_createSlider(e,t,i,r){this.slider=(0,o.createFastDomNode)(document.createElement("div")),this.slider.setClassName("slider"),this.slider.setPosition("absolute"),this.slider.setTop(e),this.slider.setLeft(t),"number"==typeof i&&this.slider.setWidth(i),"number"==typeof r&&this.slider.setHeight(r),this.slider.setLayerHinting(!0),this.slider.setContain("strict"),this.domNode.domNode.appendChild(this.slider.domNode),this._register(n.addDisposableListener(this.slider.domNode,n.EventType.POINTER_DOWN,(e=>{0===e.button&&(e.preventDefault(),this._sliderPointerDown(e))}))),this.onclick(this.slider.domNode,(e=>{e.leftButton&&e.stopPropagation()}))}_onElementSize(e){return this._scrollbarState.setVisibleSize(e)&&(this._visibilityController.setIsNeeded(this._scrollbarState.isNeeded()),this._shouldRender=!0,this._lazyRender||this.render()),this._shouldRender}_onElementScrollSize(e){return this._scrollbarState.setScrollSize(e)&&(this._visibilityController.setIsNeeded(this._scrollbarState.isNeeded()),this._shouldRender=!0,this._lazyRender||this.render()),this._shouldRender}_onElementScrollPosition(e){return this._scrollbarState.setScrollPosition(e)&&(this._visibilityController.setIsNeeded(this._scrollbarState.isNeeded()),this._shouldRender=!0,this._lazyRender||this.render()),this._shouldRender}beginReveal(){this._visibilityController.setShouldBeVisible(!0)}beginHide(){this._visibilityController.setShouldBeVisible(!1)}render(){this._shouldRender&&(this._shouldRender=!1,this._renderDomNode(this._scrollbarState.getRectangleLargeSize(),this._scrollbarState.getRectangleSmallSize()),this._updateSlider(this._scrollbarState.getSliderSize(),this._scrollbarState.getArrowSize()+this._scrollbarState.getSliderPosition()))}_domNodePointerDown(e){e.target===this.domNode.domNode&&this._onPointerDown(e)}delegatePointerDown(e){const t=this.domNode.domNode.getClientRects()[0].top,i=t+this._scrollbarState.getSliderPosition(),n=t+this._scrollbarState.getSliderPosition()+this._scrollbarState.getSliderSize(),o=this._sliderPointerPosition(e);i<=o&&o<=n?0===e.button&&(e.preventDefault(),this._sliderPointerDown(e)):this._onPointerDown(e)}_onPointerDown(e){let t,i;if(e.target===this.domNode.domNode&&"number"==typeof e.offsetX&&"number"==typeof e.offsetY)t=e.offsetX,i=e.offsetY;else{const o=n.getDomNodePagePosition(this.domNode.domNode);t=e.pageX-o.left,i=e.pageY-o.top}const o=this._pointerDownRelativePosition(t,i);this._setDesiredScrollPositionNow(this._scrollByPage?this._scrollbarState.getDesiredScrollPositionFromOffsetPaged(o):this._scrollbarState.getDesiredScrollPositionFromOffset(o)),0===e.button&&(e.preventDefault(),this._sliderPointerDown(e))}_sliderPointerDown(e){if(!(e.target&&e.target instanceof Element))return;const t=this._sliderPointerPosition(e),i=this._sliderOrthogonalPointerPosition(e),n=this._scrollbarState.clone();this.slider.toggleClassName("active",!0),this._pointerMoveMonitor.startMonitoring(e.target,e.pointerId,e.buttons,(e=>{const o=this._sliderOrthogonalPointerPosition(e),r=Math.abs(o-i);if(c.isWindows&&r>140)return void this._setDesiredScrollPositionNow(n.getScrollPosition());const s=this._sliderPointerPosition(e)-t;this._setDesiredScrollPositionNow(n.getDesiredScrollPositionFromDelta(s))}),(()=>{this.slider.toggleClassName("active",!1),this._host.onDragEnd()})),this._host.onDragStart()}_setDesiredScrollPositionNow(e){const t={};this.writeScrollPosition(t,e),this._scrollable.setScrollPositionNow(t)}updateScrollbarSize(e){this._updateScrollbarSize(e),this._scrollbarState.setScrollbarSize(e),this._shouldRender=!0,this._lazyRender||this.render()}isNeeded(){return this._scrollbarState.isNeeded()}}},48321:function(e,t,i){"use strict";i.r(t),i.d(t,{HorizontalScrollbar:function(){return l}});var n=i(5642),o=i(92117),r=i(24990),s=i(76344),a=i(56087);class l extends o.AbstractScrollbar{constructor(e,t,i){const o=e.getScrollDimensions(),l=e.getCurrentScrollPosition();if(super({lazyRender:t.lazyRender,host:i,scrollbarState:new s.ScrollbarState(t.horizontalHasArrows?t.arrowSize:0,2===t.horizontal?0:t.horizontalScrollbarSize,2===t.vertical?0:t.verticalScrollbarSize,o.width,o.scrollWidth,l.scrollLeft),visibility:t.horizontal,extraScrollbarClassName:"horizontal",scrollable:e,scrollByPage:t.scrollByPage}),t.horizontalHasArrows){const e=(t.arrowSize-r.ARROW_IMG_SIZE)/2,i=(t.horizontalScrollbarSize-r.ARROW_IMG_SIZE)/2;this._createArrow({className:"scra",icon:a.Codicon.scrollbarButtonLeft,top:i,left:e,bottom:void 0,right:void 0,bgWidth:t.arrowSize,bgHeight:t.horizontalScrollbarSize,onActivate:()=>this._host.onMouseWheel(new n.StandardWheelEvent(null,1,0))}),this._createArrow({className:"scra",icon:a.Codicon.scrollbarButtonRight,top:i,left:void 0,bottom:void 0,right:e,bgWidth:t.arrowSize,bgHeight:t.horizontalScrollbarSize,onActivate:()=>this._host.onMouseWheel(new n.StandardWheelEvent(null,-1,0))})}this._createSlider(Math.floor((t.horizontalScrollbarSize-t.horizontalSliderSize)/2),0,void 0,t.horizontalSliderSize)}_updateSlider(e,t){this.slider.setWidth(e),this.slider.setLeft(t)}_renderDomNode(e,t){this.domNode.setWidth(e),this.domNode.setHeight(t),this.domNode.setLeft(0),this.domNode.setBottom(0)}onDidScroll(e){return this._shouldRender=this._onElementScrollSize(e.scrollWidth)||this._shouldRender,this._shouldRender=this._onElementScrollPosition(e.scrollLeft)||this._shouldRender,this._shouldRender=this._onElementSize(e.width)||this._shouldRender,this._shouldRender}_pointerDownRelativePosition(e,t){return e}_sliderPointerPosition(e){return e.pageX}_sliderOrthogonalPointerPosition(e){return e.pageY}_updateScrollbarSize(e){this.slider.setHeight(e)}writeScrollPosition(e,t){e.scrollLeft=t}updateOptions(e){this.updateScrollbarSize(2===e.horizontal?0:e.horizontalScrollbarSize),this._scrollbarState.setOppositeScrollbarSize(2===e.vertical?0:e.verticalScrollbarSize),this._visibilityController.setVisibility(e.horizontal),this._scrollByPage=e.scrollByPage}}},34309:function(e,t,i){"use strict";i.r(t),i.d(t,{AbstractScrollableElement:function(){return T},DomScrollableElement:function(){return R},MouseWheelClassifier:function(){return L},ScrollableElement:function(){return M},SmoothScrollableElement:function(){return N}});var n=i(76736),o=i(96747),r=i(85297),s=i(5642),a=i(48321),l=i(22876),c=i(47257),d=i(66129),u=i(63801),h=i(68921),g=i(66719),p=i(6097),m=i(93379),f=i.n(m),b=i(7795),_=i.n(b),A=i(90569),v=i.n(A),C=i(3565),w=i.n(C),y=i(19216),S=i.n(y),x=i(44589),E=i.n(x),k=i(64836),I={};I.styleTagTransform=E(),I.setAttributes=w(),I.insert=v().bind(null,"head"),I.domAPI=_(),I.insertStyleElement=S();f()(k.Z,I),k.Z&&k.Z.locals&&k.Z.locals;class D{constructor(e,t,i){this.timestamp=e,this.deltaX=t,this.deltaY=i,this.score=0}}class L{constructor(){this._capacity=5,this._memory=[],this._front=-1,this._rear=-1}isPhysicalMouseWheel(){if(-1===this._front&&-1===this._rear)return!1;let e=1,t=0,i=1,n=this._rear;for(;;){const o=n===this._front?e:Math.pow(2,-i);if(e-=o,t+=this._memory[n].score*o,n===this._front)break;n=(this._capacity+n-1)%this._capacity,i++}return t<=.5}accept(e,t,i){const n=new D(e,t,i);n.score=this._computeScore(n),-1===this._front&&-1===this._rear?(this._memory[0]=n,this._front=0,this._rear=0):(this._rear=(this._rear+1)%this._capacity,this._rear===this._front&&(this._front=(this._front+1)%this._capacity),this._memory[this._rear]=n)}_computeScore(e){if(Math.abs(e.deltaX)>0&&Math.abs(e.deltaY)>0)return 1;let t=.5;-1===this._front&&-1===this._rear||this._memory[this._rear];return this._isAlmostInt(e.deltaX)&&this._isAlmostInt(e.deltaY)||(t+=.25),Math.min(Math.max(t,0),1)}_isAlmostInt(e){return Math.abs(Math.round(e)-e)<.01}}L.INSTANCE=new L;class T extends c.Widget{constructor(e,t,i){super(),this._onScroll=this._register(new u.Emitter),this.onScroll=this._onScroll.event,this._onWillScroll=this._register(new u.Emitter),e.style.overflow="hidden",this._options=function(e){const t={lazyRender:void 0!==e.lazyRender&&e.lazyRender,className:void 0!==e.className?e.className:"",useShadows:void 0===e.useShadows||e.useShadows,handleMouseWheel:void 0===e.handleMouseWheel||e.handleMouseWheel,flipAxes:void 0!==e.flipAxes&&e.flipAxes,consumeMouseWheelIfScrollbarIsNeeded:void 0!==e.consumeMouseWheelIfScrollbarIsNeeded&&e.consumeMouseWheelIfScrollbarIsNeeded,alwaysConsumeMouseWheel:void 0!==e.alwaysConsumeMouseWheel&&e.alwaysConsumeMouseWheel,scrollYToX:void 0!==e.scrollYToX&&e.scrollYToX,mouseWheelScrollSensitivity:void 0!==e.mouseWheelScrollSensitivity?e.mouseWheelScrollSensitivity:1,fastScrollSensitivity:void 0!==e.fastScrollSensitivity?e.fastScrollSensitivity:5,scrollPredominantAxis:void 0===e.scrollPredominantAxis||e.scrollPredominantAxis,mouseWheelSmoothScroll:void 0===e.mouseWheelSmoothScroll||e.mouseWheelSmoothScroll,arrowSize:void 0!==e.arrowSize?e.arrowSize:11,listenOnDomNode:void 0!==e.listenOnDomNode?e.listenOnDomNode:null,horizontal:void 0!==e.horizontal?e.horizontal:1,horizontalScrollbarSize:void 0!==e.horizontalScrollbarSize?e.horizontalScrollbarSize:10,horizontalSliderSize:void 0!==e.horizontalSliderSize?e.horizontalSliderSize:0,horizontalHasArrows:void 0!==e.horizontalHasArrows&&e.horizontalHasArrows,vertical:void 0!==e.vertical?e.vertical:1,verticalScrollbarSize:void 0!==e.verticalScrollbarSize?e.verticalScrollbarSize:10,verticalHasArrows:void 0!==e.verticalHasArrows&&e.verticalHasArrows,verticalSliderSize:void 0!==e.verticalSliderSize?e.verticalSliderSize:0,scrollByPage:void 0!==e.scrollByPage&&e.scrollByPage};t.horizontalSliderSize=void 0!==e.horizontalSliderSize?e.horizontalSliderSize:t.horizontalScrollbarSize,t.verticalSliderSize=void 0!==e.verticalSliderSize?e.verticalSliderSize:t.verticalScrollbarSize,g.isMacintosh&&(t.className+=" mac");return t}(t),this._scrollable=i,this._register(this._scrollable.onScroll((e=>{this._onWillScroll.fire(e),this._onDidScroll(e),this._onScroll.fire(e)})));const n={onMouseWheel:e=>this._onMouseWheel(e),onDragStart:()=>this._onDragStart(),onDragEnd:()=>this._onDragEnd()};this._verticalScrollbar=this._register(new l.VerticalScrollbar(this._scrollable,this._options,n)),this._horizontalScrollbar=this._register(new a.HorizontalScrollbar(this._scrollable,this._options,n)),this._domNode=document.createElement("div"),this._domNode.className="monaco-scrollable-element "+this._options.className,this._domNode.setAttribute("role","presentation"),this._domNode.style.position="relative",this._domNode.style.overflow="hidden",this._domNode.appendChild(e),this._domNode.appendChild(this._horizontalScrollbar.domNode.domNode),this._domNode.appendChild(this._verticalScrollbar.domNode.domNode),this._options.useShadows?(this._leftShadowDomNode=(0,r.createFastDomNode)(document.createElement("div")),this._leftShadowDomNode.setClassName("shadow"),this._domNode.appendChild(this._leftShadowDomNode.domNode),this._topShadowDomNode=(0,r.createFastDomNode)(document.createElement("div")),this._topShadowDomNode.setClassName("shadow"),this._domNode.appendChild(this._topShadowDomNode.domNode),this._topLeftShadowDomNode=(0,r.createFastDomNode)(document.createElement("div")),this._topLeftShadowDomNode.setClassName("shadow"),this._domNode.appendChild(this._topLeftShadowDomNode.domNode)):(this._leftShadowDomNode=null,this._topShadowDomNode=null,this._topLeftShadowDomNode=null),this._listenOnDomNode=this._options.listenOnDomNode||this._domNode,this._mouseWheelToDispose=[],this._setListeningToMouseWheel(this._options.handleMouseWheel),this.onmouseover(this._listenOnDomNode,(e=>this._onMouseOver(e))),this.onmouseleave(this._listenOnDomNode,(e=>this._onMouseLeave(e))),this._hideTimeout=this._register(new d.TimeoutTimer),this._isDragging=!1,this._mouseIsOver=!1,this._shouldRender=!0,this._revealOnScroll=!0}get options(){return this._options}dispose(){this._mouseWheelToDispose=(0,h.dispose)(this._mouseWheelToDispose),super.dispose()}getDomNode(){return this._domNode}getOverviewRulerLayoutInfo(){return{parent:this._domNode,insertBefore:this._verticalScrollbar.domNode.domNode}}delegateVerticalScrollbarPointerDown(e){this._verticalScrollbar.delegatePointerDown(e)}getScrollDimensions(){return this._scrollable.getScrollDimensions()}setScrollDimensions(e){this._scrollable.setScrollDimensions(e,!1)}updateClassName(e){this._options.className=e,g.isMacintosh&&(this._options.className+=" mac"),this._domNode.className="monaco-scrollable-element "+this._options.className}updateOptions(e){void 0!==e.handleMouseWheel&&(this._options.handleMouseWheel=e.handleMouseWheel,this._setListeningToMouseWheel(this._options.handleMouseWheel)),void 0!==e.mouseWheelScrollSensitivity&&(this._options.mouseWheelScrollSensitivity=e.mouseWheelScrollSensitivity),void 0!==e.fastScrollSensitivity&&(this._options.fastScrollSensitivity=e.fastScrollSensitivity),void 0!==e.scrollPredominantAxis&&(this._options.scrollPredominantAxis=e.scrollPredominantAxis),void 0!==e.horizontal&&(this._options.horizontal=e.horizontal),void 0!==e.vertical&&(this._options.vertical=e.vertical),void 0!==e.horizontalScrollbarSize&&(this._options.horizontalScrollbarSize=e.horizontalScrollbarSize),void 0!==e.verticalScrollbarSize&&(this._options.verticalScrollbarSize=e.verticalScrollbarSize),void 0!==e.scrollByPage&&(this._options.scrollByPage=e.scrollByPage),this._horizontalScrollbar.updateOptions(this._options),this._verticalScrollbar.updateOptions(this._options),this._options.lazyRender||this._render()}_setListeningToMouseWheel(e){if(this._mouseWheelToDispose.length>0!==e&&(this._mouseWheelToDispose=(0,h.dispose)(this._mouseWheelToDispose),e)){const e=e=>{this._onMouseWheel(new s.StandardWheelEvent(e))};this._mouseWheelToDispose.push(o.addDisposableListener(this._listenOnDomNode,o.EventType.MOUSE_WHEEL,e,{passive:!1}))}}_onMouseWheel(e){const t=L.INSTANCE;{const i=window.devicePixelRatio/(0,n.getZoomFactor)();g.isWindows||g.isLinux?t.accept(Date.now(),e.deltaX/i,e.deltaY/i):t.accept(Date.now(),e.deltaX,e.deltaY)}let i=!1;if(e.deltaY||e.deltaX){let n=e.deltaY*this._options.mouseWheelScrollSensitivity,o=e.deltaX*this._options.mouseWheelScrollSensitivity;this._options.scrollPredominantAxis&&(Math.abs(n)>=Math.abs(o)?o=0:n=0),this._options.flipAxes&&([n,o]=[o,n]);const r=!g.isMacintosh&&e.browserEvent&&e.browserEvent.shiftKey;!this._options.scrollYToX&&!r||o||(o=n,n=0),e.browserEvent&&e.browserEvent.altKey&&(o*=this._options.fastScrollSensitivity,n*=this._options.fastScrollSensitivity);const s=this._scrollable.getFutureScrollPosition();let a={};if(n){const e=50*n,t=s.scrollTop-(e<0?Math.floor(e):Math.ceil(e));this._verticalScrollbar.writeScrollPosition(a,t)}if(o){const e=50*o,t=s.scrollLeft-(e<0?Math.floor(e):Math.ceil(e));this._horizontalScrollbar.writeScrollPosition(a,t)}if(a=this._scrollable.validateScrollPosition(a),s.scrollLeft!==a.scrollLeft||s.scrollTop!==a.scrollTop){this._options.mouseWheelSmoothScroll&&t.isPhysicalMouseWheel()?this._scrollable.setScrollPositionSmooth(a):this._scrollable.setScrollPositionNow(a),i=!0}}let o=i;!o&&this._options.alwaysConsumeMouseWheel&&(o=!0),!o&&this._options.consumeMouseWheelIfScrollbarIsNeeded&&(this._verticalScrollbar.isNeeded()||this._horizontalScrollbar.isNeeded())&&(o=!0),o&&(e.preventDefault(),e.stopPropagation())}_onDidScroll(e){this._shouldRender=this._horizontalScrollbar.onDidScroll(e)||this._shouldRender,this._shouldRender=this._verticalScrollbar.onDidScroll(e)||this._shouldRender,this._options.useShadows&&(this._shouldRender=!0),this._revealOnScroll&&this._reveal(),this._options.lazyRender||this._render()}renderNow(){if(!this._options.lazyRender)throw new Error("Please use `lazyRender` together with `renderNow`!");this._render()}_render(){if(this._shouldRender&&(this._shouldRender=!1,this._horizontalScrollbar.render(),this._verticalScrollbar.render(),this._options.useShadows)){const e=this._scrollable.getCurrentScrollPosition(),t=e.scrollTop>0,i=e.scrollLeft>0,n=i?" left":"",o=t?" top":"",r=i||t?" top-left-corner":"";this._leftShadowDomNode.setClassName(`shadow${n}`),this._topShadowDomNode.setClassName(`shadow${o}`),this._topLeftShadowDomNode.setClassName(`shadow${r}${o}${n}`)}}_onDragStart(){this._isDragging=!0,this._reveal()}_onDragEnd(){this._isDragging=!1,this._hide()}_onMouseLeave(e){this._mouseIsOver=!1,this._hide()}_onMouseOver(e){this._mouseIsOver=!0,this._reveal()}_reveal(){this._verticalScrollbar.beginReveal(),this._horizontalScrollbar.beginReveal(),this._scheduleHide()}_hide(){this._mouseIsOver||this._isDragging||(this._verticalScrollbar.beginHide(),this._horizontalScrollbar.beginHide())}_scheduleHide(){this._mouseIsOver||this._isDragging||this._hideTimeout.cancelAndSet((()=>this._hide()),500)}}class M extends T{constructor(e,t){(t=t||{}).mouseWheelSmoothScroll=!1;const i=new p.Scrollable({forceIntegerValues:!0,smoothScrollDuration:0,scheduleAtNextAnimationFrame:e=>o.scheduleAtNextAnimationFrame(e)});super(e,t,i),this._register(i)}setScrollPosition(e){this._scrollable.setScrollPositionNow(e)}}class N extends T{constructor(e,t,i){super(e,t,i)}setScrollPosition(e){e.reuseAnimation?this._scrollable.setScrollPositionSmooth(e,e.reuseAnimation):this._scrollable.setScrollPositionNow(e)}getScrollPosition(){return this._scrollable.getCurrentScrollPosition()}}class R extends T{constructor(e,t){(t=t||{}).mouseWheelSmoothScroll=!1;const i=new p.Scrollable({forceIntegerValues:!1,smoothScrollDuration:0,scheduleAtNextAnimationFrame:e=>o.scheduleAtNextAnimationFrame(e)});super(e,t,i),this._register(i),this._element=e,this.onScroll((e=>{e.scrollTopChanged&&(this._element.scrollTop=e.scrollTop),e.scrollLeftChanged&&(this._element.scrollLeft=e.scrollLeft)})),this.scanDomNode()}setScrollPosition(e){this._scrollable.setScrollPositionNow(e)}getScrollPosition(){return this._scrollable.getCurrentScrollPosition()}scanDomNode(){this.setScrollDimensions({width:this._element.clientWidth,scrollWidth:this._element.scrollWidth,height:this._element.clientHeight,scrollHeight:this._element.scrollHeight}),this.setScrollPosition({scrollLeft:this._element.scrollLeft,scrollTop:this._element.scrollTop})}}},24990:function(e,t,i){"use strict";i.r(t),i.d(t,{ARROW_IMG_SIZE:function(){return a},ScrollbarArrow:function(){return l}});var n=i(95689),o=i(47257),r=i(66129),s=i(96747);const a=11;class l extends o.Widget{constructor(e){super(),this._onActivate=e.onActivate,this.bgDomNode=document.createElement("div"),this.bgDomNode.className="arrow-background",this.bgDomNode.style.position="absolute",this.bgDomNode.style.width=e.bgWidth+"px",this.bgDomNode.style.height=e.bgHeight+"px",void 0!==e.top&&(this.bgDomNode.style.top="0px"),void 0!==e.left&&(this.bgDomNode.style.left="0px"),void 0!==e.bottom&&(this.bgDomNode.style.bottom="0px"),void 0!==e.right&&(this.bgDomNode.style.right="0px"),this.domNode=document.createElement("div"),this.domNode.className=e.className,this.domNode.classList.add(...e.icon.classNamesArray),this.domNode.style.position="absolute",this.domNode.style.width=a+"px",this.domNode.style.height=a+"px",void 0!==e.top&&(this.domNode.style.top=e.top+"px"),void 0!==e.left&&(this.domNode.style.left=e.left+"px"),void 0!==e.bottom&&(this.domNode.style.bottom=e.bottom+"px"),void 0!==e.right&&(this.domNode.style.right=e.right+"px"),this._pointerMoveMonitor=this._register(new n.GlobalPointerMoveMonitor),this._register(s.addStandardDisposableListener(this.bgDomNode,s.EventType.POINTER_DOWN,(e=>this._arrowPointerDown(e)))),this._register(s.addStandardDisposableListener(this.domNode,s.EventType.POINTER_DOWN,(e=>this._arrowPointerDown(e)))),this._pointerdownRepeatTimer=this._register(new r.IntervalTimer),this._pointerdownScheduleRepeatTimer=this._register(new r.TimeoutTimer)}_arrowPointerDown(e){if(!(e.target&&e.target instanceof Element))return;this._onActivate(),this._pointerdownRepeatTimer.cancel(),this._pointerdownScheduleRepeatTimer.cancelAndSet((()=>{this._pointerdownRepeatTimer.cancelAndSet((()=>this._onActivate()),1e3/24)}),200),this._pointerMoveMonitor.startMonitoring(e.target,e.pointerId,e.buttons,(e=>{}),(()=>{this._pointerdownRepeatTimer.cancel(),this._pointerdownScheduleRepeatTimer.cancel()})),e.preventDefault()}}},76344:function(e,t,i){"use strict";i.r(t),i.d(t,{ScrollbarState:function(){return n}});class n{constructor(e,t,i,n,o,r){this._scrollbarSize=Math.round(t),this._oppositeScrollbarSize=Math.round(i),this._arrowSize=Math.round(e),this._visibleSize=n,this._scrollSize=o,this._scrollPosition=r,this._computedAvailableSize=0,this._computedIsNeeded=!1,this._computedSliderSize=0,this._computedSliderRatio=0,this._computedSliderPosition=0,this._refreshComputedValues()}clone(){return new n(this._arrowSize,this._scrollbarSize,this._oppositeScrollbarSize,this._visibleSize,this._scrollSize,this._scrollPosition)}setVisibleSize(e){const t=Math.round(e);return this._visibleSize!==t&&(this._visibleSize=t,this._refreshComputedValues(),!0)}setScrollSize(e){const t=Math.round(e);return this._scrollSize!==t&&(this._scrollSize=t,this._refreshComputedValues(),!0)}setScrollPosition(e){const t=Math.round(e);return this._scrollPosition!==t&&(this._scrollPosition=t,this._refreshComputedValues(),!0)}setScrollbarSize(e){this._scrollbarSize=Math.round(e)}setOppositeScrollbarSize(e){this._oppositeScrollbarSize=Math.round(e)}static _computeValues(e,t,i,n,o){const r=Math.max(0,i-e),s=Math.max(0,r-2*t),a=n>0&&n>i;if(!a)return{computedAvailableSize:Math.round(r),computedIsNeeded:a,computedSliderSize:Math.round(s),computedSliderRatio:0,computedSliderPosition:0};const l=Math.round(Math.max(20,Math.floor(i*s/n))),c=(s-l)/(n-i),d=o*c;return{computedAvailableSize:Math.round(r),computedIsNeeded:a,computedSliderSize:Math.round(l),computedSliderRatio:c,computedSliderPosition:Math.round(d)}}_refreshComputedValues(){const e=n._computeValues(this._oppositeScrollbarSize,this._arrowSize,this._visibleSize,this._scrollSize,this._scrollPosition);this._computedAvailableSize=e.computedAvailableSize,this._computedIsNeeded=e.computedIsNeeded,this._computedSliderSize=e.computedSliderSize,this._computedSliderRatio=e.computedSliderRatio,this._computedSliderPosition=e.computedSliderPosition}getArrowSize(){return this._arrowSize}getScrollPosition(){return this._scrollPosition}getRectangleLargeSize(){return this._computedAvailableSize}getRectangleSmallSize(){return this._scrollbarSize}isNeeded(){return this._computedIsNeeded}getSliderSize(){return this._computedSliderSize}getSliderPosition(){return this._computedSliderPosition}getDesiredScrollPositionFromOffset(e){if(!this._computedIsNeeded)return 0;const t=e-this._arrowSize-this._computedSliderSize/2;return Math.round(t/this._computedSliderRatio)}getDesiredScrollPositionFromOffsetPaged(e){if(!this._computedIsNeeded)return 0;const t=e-this._arrowSize;let i=this._scrollPosition;return t<this._computedSliderPosition?i-=this._visibleSize:i+=this._visibleSize,i}getDesiredScrollPositionFromDelta(e){if(!this._computedIsNeeded)return 0;const t=this._computedSliderPosition+e;return Math.round(t/this._computedSliderRatio)}}},23487:function(e,t,i){"use strict";i.r(t),i.d(t,{ScrollbarVisibilityController:function(){return r}});var n=i(66129),o=i(68921);class r extends o.Disposable{constructor(e,t,i){super(),this._visibility=e,this._visibleClassName=t,this._invisibleClassName=i,this._domNode=null,this._isVisible=!1,this._isNeeded=!1,this._rawShouldBeVisible=!1,this._shouldBeVisible=!1,this._revealTimer=this._register(new n.TimeoutTimer)}setVisibility(e){this._visibility!==e&&(this._visibility=e,this._updateShouldBeVisible())}setShouldBeVisible(e){this._rawShouldBeVisible=e,this._updateShouldBeVisible()}_applyVisibilitySetting(){return 2!==this._visibility&&(3===this._visibility||this._rawShouldBeVisible)}_updateShouldBeVisible(){const e=this._applyVisibilitySetting();this._shouldBeVisible!==e&&(this._shouldBeVisible=e,this.ensureVisibility())}setIsNeeded(e){this._isNeeded!==e&&(this._isNeeded=e,this.ensureVisibility())}setDomNode(e){this._domNode=e,this._domNode.setClassName(this._invisibleClassName),this.setShouldBeVisible(!1)}ensureVisibility(){this._isNeeded?this._shouldBeVisible?this._reveal():this._hide(!0):this._hide(!1)}_reveal(){this._isVisible||(this._isVisible=!0,this._revealTimer.setIfNotSet((()=>{var e;null===(e=this._domNode)||void 0===e||e.setClassName(this._visibleClassName)}),0))}_hide(e){var t;this._revealTimer.cancel(),this._isVisible&&(this._isVisible=!1,null===(t=this._domNode)||void 0===t||t.setClassName(this._invisibleClassName+(e?" fade":"")))}}},22876:function(e,t,i){"use strict";i.r(t),i.d(t,{VerticalScrollbar:function(){return l}});var n=i(5642),o=i(92117),r=i(24990),s=i(76344),a=i(56087);class l extends o.AbstractScrollbar{constructor(e,t,i){const o=e.getScrollDimensions(),l=e.getCurrentScrollPosition();if(super({lazyRender:t.lazyRender,host:i,scrollbarState:new s.ScrollbarState(t.verticalHasArrows?t.arrowSize:0,2===t.vertical?0:t.verticalScrollbarSize,0,o.height,o.scrollHeight,l.scrollTop),visibility:t.vertical,extraScrollbarClassName:"vertical",scrollable:e,scrollByPage:t.scrollByPage}),t.verticalHasArrows){const e=(t.arrowSize-r.ARROW_IMG_SIZE)/2,i=(t.verticalScrollbarSize-r.ARROW_IMG_SIZE)/2;this._createArrow({className:"scra",icon:a.Codicon.scrollbarButtonUp,top:e,left:i,bottom:void 0,right:void 0,bgWidth:t.verticalScrollbarSize,bgHeight:t.arrowSize,onActivate:()=>this._host.onMouseWheel(new n.StandardWheelEvent(null,0,1))}),this._createArrow({className:"scra",icon:a.Codicon.scrollbarButtonDown,top:void 0,left:i,bottom:e,right:void 0,bgWidth:t.verticalScrollbarSize,bgHeight:t.arrowSize,onActivate:()=>this._host.onMouseWheel(new n.StandardWheelEvent(null,0,-1))})}this._createSlider(0,Math.floor((t.verticalScrollbarSize-t.verticalSliderSize)/2),t.verticalSliderSize,void 0)}_updateSlider(e,t){this.slider.setHeight(e),this.slider.setTop(t)}_renderDomNode(e,t){this.domNode.setWidth(t),this.domNode.setHeight(e),this.domNode.setRight(0),this.domNode.setTop(0)}onDidScroll(e){return this._shouldRender=this._onElementScrollSize(e.scrollHeight)||this._shouldRender,this._shouldRender=this._onElementScrollPosition(e.scrollTop)||this._shouldRender,this._shouldRender=this._onElementSize(e.height)||this._shouldRender,this._shouldRender}_pointerDownRelativePosition(e,t){return t}_sliderPointerPosition(e){return e.pageY}_sliderOrthogonalPointerPosition(e){return e.pageX}_updateScrollbarSize(e){this.slider.setWidth(e)}writeScrollPosition(e,t){e.scrollTop=t}updateOptions(e){this.updateScrollbarSize(2===e.vertical?0:e.verticalScrollbarSize),this._scrollbarState.setOppositeScrollbarSize(0),this._visibilityController.setVisibility(e.vertical),this._scrollByPage=e.scrollByPage}}},70626:function(e,t,i){"use strict";i.r(t),i.d(t,{Sizing:function(){return M},SplitView:function(){return N}});var n=i(96747),o=i(59625),r=i(34309),s=i(64998),a=i(17160),l=i(63801),c=i(68921),d=i(53719),u=i(6097),h=i(18912),g=i(93379),p=i.n(g),m=i(7795),f=i.n(m),b=i(90569),_=i.n(b),A=i(3565),v=i.n(A),C=i(19216),w=i.n(C),y=i(44589),S=i.n(y),x=i(35201),E={};E.styleTagTransform=S(),E.setAttributes=v(),E.insert=_().bind(null,"head"),E.domAPI=f(),E.insertStyleElement=w();p()(x.Z,E),x.Z&&x.Z.locals&&x.Z.locals;const k={separatorBorder:a.Color.transparent};class I{constructor(e,t,i,n){this.container=e,this.view=t,this.disposable=n,this._cachedVisibleSize=void 0,"number"==typeof i?(this._size=i,this._cachedVisibleSize=void 0,e.classList.add("visible")):(this._size=0,this._cachedVisibleSize=i.cachedVisibleSize)}set size(e){this._size=e}get size(){return this._size}get visible(){return void 0===this._cachedVisibleSize}setVisible(e,t){var i,n;e!==this.visible&&(e?(this.size=(0,d.clamp)(this._cachedVisibleSize,this.viewMinimumSize,this.viewMaximumSize),this._cachedVisibleSize=void 0):(this._cachedVisibleSize="number"==typeof t?t:this.size,this.size=0),this.container.classList.toggle("visible",e),null===(n=(i=this.view).setVisible)||void 0===n||n.call(i,e))}get minimumSize(){return this.visible?this.view.minimumSize:0}get viewMinimumSize(){return this.view.minimumSize}get maximumSize(){return this.visible?this.view.maximumSize:0}get viewMaximumSize(){return this.view.maximumSize}get priority(){return this.view.priority}get snap(){return!!this.view.snap}set enabled(e){this.container.style.pointerEvents=e?"":"none"}layout(e,t){this.layoutContainer(e),this.view.layout(this.size,e,t)}dispose(){return this.disposable.dispose(),this.view}}class D extends I{layoutContainer(e){this.container.style.top=`${e}px`,this.container.style.height=`${this.size}px`}}class L extends I{layoutContainer(e){this.container.style.left=`${e}px`,this.container.style.width=`${this.size}px`}}var T,M;!function(e){e[e.Idle=0]="Idle",e[e.Busy=1]="Busy"}(T||(T={})),function(e){e.Distribute={type:"distribute"},e.Split=function(e){return{type:"split",index:e}},e.Invisible=function(e){return{type:"invisible",cachedVisibleSize:e}}}(M||(M={}));class N extends c.Disposable{constructor(e,t={}){var i,o,s,a,c;super(),this.size=0,this.contentSize=0,this.proportions=void 0,this.viewItems=[],this.sashItems=[],this.state=T.Idle,this._onDidSashChange=this._register(new l.Emitter),this._onDidSashReset=this._register(new l.Emitter),this._startSnappingEnabled=!0,this._endSnappingEnabled=!0,this.onDidSashChange=this._onDidSashChange.event,this.onDidSashReset=this._onDidSashReset.event,this.orientation=null!==(i=t.orientation)&&void 0!==i?i:0,this.inverseAltBehavior=null!==(o=t.inverseAltBehavior)&&void 0!==o&&o,this.proportionalLayout=null===(s=t.proportionalLayout)||void 0===s||s,this.getSashOrthogonalSize=t.getSashOrthogonalSize,this.el=document.createElement("div"),this.el.classList.add("monaco-split-view2"),this.el.classList.add(0===this.orientation?"vertical":"horizontal"),e.appendChild(this.el),this.sashContainer=(0,n.append)(this.el,(0,n.$)(".sash-container")),this.viewContainer=(0,n.$)(".split-view-container"),this.scrollable=new u.Scrollable({forceIntegerValues:!0,smoothScrollDuration:125,scheduleAtNextAnimationFrame:n.scheduleAtNextAnimationFrame}),this.scrollableElement=this._register(new r.SmoothScrollableElement(this.viewContainer,{vertical:0===this.orientation?null!==(a=t.scrollbarVisibility)&&void 0!==a?a:1:2,horizontal:1===this.orientation?null!==(c=t.scrollbarVisibility)&&void 0!==c?c:1:2},this.scrollable)),this.onDidScroll=this.scrollableElement.onScroll,this._register(this.onDidScroll((e=>{this.viewContainer.scrollTop=e.scrollTop,this.viewContainer.scrollLeft=e.scrollLeft}))),(0,n.append)(this.el,this.scrollableElement.getDomNode()),this.style(t.styles||k),t.descriptor&&(this.size=t.descriptor.size,t.descriptor.views.forEach(((e,t)=>{const i=h.isUndefined(e.visible)||e.visible?e.size:{type:"invisible",cachedVisibleSize:e.size},n=e.view;this.doAddView(n,i,t,!0)})),this.contentSize=this.viewItems.reduce(((e,t)=>e+t.size),0),this.saveProportions())}get orthogonalStartSash(){return this._orthogonalStartSash}get orthogonalEndSash(){return this._orthogonalEndSash}get startSnappingEnabled(){return this._startSnappingEnabled}get endSnappingEnabled(){return this._endSnappingEnabled}set orthogonalStartSash(e){for(const t of this.sashItems)t.sash.orthogonalStartSash=e;this._orthogonalStartSash=e}set orthogonalEndSash(e){for(const t of this.sashItems)t.sash.orthogonalEndSash=e;this._orthogonalEndSash=e}set startSnappingEnabled(e){this._startSnappingEnabled!==e&&(this._startSnappingEnabled=e,this.updateSashEnablement())}set endSnappingEnabled(e){this._endSnappingEnabled!==e&&(this._endSnappingEnabled=e,this.updateSashEnablement())}style(e){e.separatorBorder.isTransparent()?(this.el.classList.remove("separator-border"),this.el.style.removeProperty("--separator-border")):(this.el.classList.add("separator-border"),this.el.style.setProperty("--separator-border",e.separatorBorder.toString()))}addView(e,t,i=this.viewItems.length,n){this.doAddView(e,t,i,n)}layout(e,t){const i=Math.max(this.size,this.contentSize);if(this.size=e,this.layoutContext=t,this.proportions)for(let t=0;t<this.viewItems.length;t++){const i=this.viewItems[t];i.size=(0,d.clamp)(Math.round(this.proportions[t]*e),i.minimumSize,i.maximumSize)}else{const t=(0,s.range)(this.viewItems.length),n=t.filter((e=>1===this.viewItems[e].priority)),o=t.filter((e=>2===this.viewItems[e].priority));this.resize(this.viewItems.length-1,e-i,void 0,n,o)}this.distributeEmptySpace(),this.layoutViews()}saveProportions(){this.proportionalLayout&&this.contentSize>0&&(this.proportions=this.viewItems.map((e=>e.size/this.contentSize)))}onSashStart({sash:e,start:t,alt:i}){for(const e of this.viewItems)e.enabled=!1;const o=this.sashItems.findIndex((t=>t.sash===e)),r=(0,c.combinedDisposable)((0,n.addDisposableListener)(document.body,"keydown",(e=>a(this.sashDragState.current,e.altKey))),(0,n.addDisposableListener)(document.body,"keyup",(()=>a(this.sashDragState.current,!1)))),a=(e,t)=>{const i=this.viewItems.map((e=>e.size));let n,a,l=Number.NEGATIVE_INFINITY,c=Number.POSITIVE_INFINITY;if(this.inverseAltBehavior&&(t=!t),t){if(o===this.sashItems.length-1){const e=this.viewItems[o];l=(e.minimumSize-e.size)/2,c=(e.maximumSize-e.size)/2}else{const e=this.viewItems[o+1];l=(e.size-e.maximumSize)/2,c=(e.size-e.minimumSize)/2}}if(!t){const e=(0,s.range)(o,-1),t=(0,s.range)(o+1,this.viewItems.length),r=e.reduce(((e,t)=>e+(this.viewItems[t].minimumSize-i[t])),0),l=e.reduce(((e,t)=>e+(this.viewItems[t].viewMaximumSize-i[t])),0),c=0===t.length?Number.POSITIVE_INFINITY:t.reduce(((e,t)=>e+(i[t]-this.viewItems[t].minimumSize)),0),d=0===t.length?Number.NEGATIVE_INFINITY:t.reduce(((e,t)=>e+(i[t]-this.viewItems[t].viewMaximumSize)),0),u=Math.max(r,d),h=Math.min(c,l),g=this.findFirstSnapIndex(e),p=this.findFirstSnapIndex(t);if("number"==typeof g){const e=this.viewItems[g],t=Math.floor(e.viewMinimumSize/2);n={index:g,limitDelta:e.visible?u-t:u+t,size:e.size}}if("number"==typeof p){const e=this.viewItems[p],t=Math.floor(e.viewMinimumSize/2);a={index:p,limitDelta:e.visible?h+t:h-t,size:e.size}}}this.sashDragState={start:e,current:e,index:o,sizes:i,minDelta:l,maxDelta:c,alt:t,snapBefore:n,snapAfter:a,disposable:r}};a(t,i)}onSashChange({current:e}){const{index:t,start:i,sizes:n,alt:o,minDelta:r,maxDelta:s,snapBefore:a,snapAfter:l}=this.sashDragState;this.sashDragState.current=e;const c=e-i,d=this.resize(t,c,n,void 0,void 0,r,s,a,l);if(o){const e=t===this.sashItems.length-1,i=this.viewItems.map((e=>e.size)),n=e?t:t+1,o=this.viewItems[n],r=o.size-o.maximumSize,s=o.size-o.minimumSize,a=e?t-1:t+1;this.resize(a,-d,i,void 0,void 0,r,s)}this.distributeEmptySpace(),this.layoutViews()}onSashEnd(e){this._onDidSashChange.fire(e),this.sashDragState.disposable.dispose(),this.saveProportions();for(const e of this.viewItems)e.enabled=!0}onViewChange(e,t){const i=this.viewItems.indexOf(e);i<0||i>=this.viewItems.length||(t="number"==typeof t?t:e.size,t=(0,d.clamp)(t,e.minimumSize,e.maximumSize),this.inverseAltBehavior&&i>0?(this.resize(i-1,Math.floor((e.size-t)/2)),this.distributeEmptySpace(),this.layoutViews()):(e.size=t,this.relayout([i],void 0)))}resizeView(e,t){if(this.state!==T.Idle)throw new Error("Cant modify splitview");if(this.state=T.Busy,e<0||e>=this.viewItems.length)return;const i=(0,s.range)(this.viewItems.length).filter((t=>t!==e)),n=[...i.filter((e=>1===this.viewItems[e].priority)),e],o=i.filter((e=>2===this.viewItems[e].priority)),r=this.viewItems[e];t=Math.round(t),t=(0,d.clamp)(t,r.minimumSize,Math.min(r.maximumSize,this.size)),r.size=t,this.relayout(n,o),this.state=T.Idle}distributeViewSizes(){const e=[];let t=0;for(const i of this.viewItems)i.maximumSize-i.minimumSize>0&&(e.push(i),t+=i.size);const i=Math.floor(t/e.length);for(const t of e)t.size=(0,d.clamp)(i,t.minimumSize,t.maximumSize);const n=(0,s.range)(this.viewItems.length),o=n.filter((e=>1===this.viewItems[e].priority)),r=n.filter((e=>2===this.viewItems[e].priority));this.relayout(o,r)}getViewSize(e){return e<0||e>=this.viewItems.length?-1:this.viewItems[e].size}doAddView(e,t,i=this.viewItems.length,r){if(this.state!==T.Idle)throw new Error("Cant modify splitview");this.state=T.Busy;const a=(0,n.$)(".split-view-view");i===this.viewItems.length?this.viewContainer.appendChild(a):this.viewContainer.insertBefore(a,this.viewContainer.children.item(i));const d=e.onDidChange((e=>this.onViewChange(p,e))),u=(0,c.toDisposable)((()=>this.viewContainer.removeChild(a))),h=(0,c.combinedDisposable)(d,u);let g;g="number"==typeof t?t:"split"===t.type?this.getViewSize(t.index)/2:"invisible"===t.type?{cachedVisibleSize:t.cachedVisibleSize}:e.minimumSize;const p=0===this.orientation?new D(a,e,g,h):new L(a,e,g,h);if(this.viewItems.splice(i,0,p),this.viewItems.length>1){const e={orthogonalStartSash:this.orthogonalStartSash,orthogonalEndSash:this.orthogonalEndSash},t=0===this.orientation?new o.Sash(this.sashContainer,{getHorizontalSashTop:e=>this.getSashPosition(e),getHorizontalSashWidth:this.getSashOrthogonalSize},Object.assign(Object.assign({},e),{orientation:1})):new o.Sash(this.sashContainer,{getVerticalSashLeft:e=>this.getSashPosition(e),getVerticalSashHeight:this.getSashOrthogonalSize},Object.assign(Object.assign({},e),{orientation:0})),n=0===this.orientation?e=>({sash:t,start:e.startY,current:e.currentY,alt:e.altKey}):e=>({sash:t,start:e.startX,current:e.currentX,alt:e.altKey}),r=l.Event.map(t.onDidStart,n)(this.onSashStart,this),a=l.Event.map(t.onDidChange,n)(this.onSashChange,this),d=l.Event.map(t.onDidEnd,(()=>this.sashItems.findIndex((e=>e.sash===t)))),u=d(this.onSashEnd,this),h=t.onDidReset((()=>{const e=this.sashItems.findIndex((e=>e.sash===t)),i=(0,s.range)(e,-1),n=(0,s.range)(e+1,this.viewItems.length),o=this.findFirstSnapIndex(i),r=this.findFirstSnapIndex(n);("number"!=typeof o||this.viewItems[o].visible)&&("number"!=typeof r||this.viewItems[r].visible)&&this._onDidSashReset.fire(e)})),g=(0,c.combinedDisposable)(r,a,u,h,t),p={sash:t,disposable:g};this.sashItems.splice(i-1,0,p)}let m;a.appendChild(e.element),"number"!=typeof t&&"split"===t.type&&(m=[t.index]),r||this.relayout([i],m),this.state=T.Idle,r||"number"==typeof t||"distribute"!==t.type||this.distributeViewSizes()}relayout(e,t){const i=this.viewItems.reduce(((e,t)=>e+t.size),0);this.resize(this.viewItems.length-1,this.size-i,void 0,e,t),this.distributeEmptySpace(),this.layoutViews(),this.saveProportions()}resize(e,t,i=this.viewItems.map((e=>e.size)),n,o,r=Number.NEGATIVE_INFINITY,a=Number.POSITIVE_INFINITY,l,c){if(e<0||e>=this.viewItems.length)return 0;const u=(0,s.range)(e,-1),h=(0,s.range)(e+1,this.viewItems.length);if(o)for(const e of o)(0,s.pushToStart)(u,e),(0,s.pushToStart)(h,e);if(n)for(const e of n)(0,s.pushToEnd)(u,e),(0,s.pushToEnd)(h,e);const g=u.map((e=>this.viewItems[e])),p=u.map((e=>i[e])),m=h.map((e=>this.viewItems[e])),f=h.map((e=>i[e])),b=u.reduce(((e,t)=>e+(this.viewItems[t].minimumSize-i[t])),0),_=u.reduce(((e,t)=>e+(this.viewItems[t].maximumSize-i[t])),0),A=0===h.length?Number.POSITIVE_INFINITY:h.reduce(((e,t)=>e+(i[t]-this.viewItems[t].minimumSize)),0),v=0===h.length?Number.NEGATIVE_INFINITY:h.reduce(((e,t)=>e+(i[t]-this.viewItems[t].maximumSize)),0),C=Math.max(b,v,r),w=Math.min(A,_,a);let y=!1;if(l){const e=this.viewItems[l.index],i=t>=l.limitDelta;y=i!==e.visible,e.setVisible(i,l.size)}if(!y&&c){const e=this.viewItems[c.index],i=t<c.limitDelta;y=i!==e.visible,e.setVisible(i,c.size)}if(y)return this.resize(e,t,i,n,o,r,a);for(let e=0,i=t=(0,d.clamp)(t,C,w);e<g.length;e++){const t=g[e],n=(0,d.clamp)(p[e]+i,t.minimumSize,t.maximumSize);i-=n-p[e],t.size=n}for(let e=0,i=t;e<m.length;e++){const t=m[e],n=(0,d.clamp)(f[e]-i,t.minimumSize,t.maximumSize);i+=n-f[e],t.size=n}return t}distributeEmptySpace(e){const t=this.viewItems.reduce(((e,t)=>e+t.size),0);let i=this.size-t;const n=(0,s.range)(this.viewItems.length-1,-1),o=n.filter((e=>1===this.viewItems[e].priority)),r=n.filter((e=>2===this.viewItems[e].priority));for(const e of r)(0,s.pushToStart)(n,e);for(const e of o)(0,s.pushToEnd)(n,e);"number"==typeof e&&(0,s.pushToEnd)(n,e);for(let e=0;0!==i&&e<n.length;e++){const t=this.viewItems[n[e]],o=(0,d.clamp)(t.size+i,t.minimumSize,t.maximumSize);i-=o-t.size,t.size=o}}layoutViews(){this.contentSize=this.viewItems.reduce(((e,t)=>e+t.size),0);let e=0;for(const t of this.viewItems)t.layout(e,this.layoutContext),e+=t.size;this.sashItems.forEach((e=>e.sash.layout())),this.updateSashEnablement(),this.updateScrollableElement()}updateScrollableElement(){0===this.orientation?this.scrollableElement.setScrollDimensions({height:this.size,scrollHeight:this.contentSize}):this.scrollableElement.setScrollDimensions({width:this.size,scrollWidth:this.contentSize})}updateSashEnablement(){let e=!1;const t=this.viewItems.map((t=>e=t.size-t.minimumSize>0||e));e=!1;const i=this.viewItems.map((t=>e=t.maximumSize-t.size>0||e)),n=[...this.viewItems].reverse();e=!1;const o=n.map((t=>e=t.size-t.minimumSize>0||e)).reverse();e=!1;const r=n.map((t=>e=t.maximumSize-t.size>0||e)).reverse();let a=0;for(let e=0;e<this.sashItems.length;e++){const{sash:n}=this.sashItems[e];a+=this.viewItems[e].size;const l=!(t[e]&&r[e+1]),c=!(i[e]&&o[e+1]);if(l&&c){const i=(0,s.range)(e,-1),r=(0,s.range)(e+1,this.viewItems.length),l=this.findFirstSnapIndex(i),c=this.findFirstSnapIndex(r),d="number"==typeof l&&!this.viewItems[l].visible,u="number"==typeof c&&!this.viewItems[c].visible;d&&o[e]&&(a>0||this.startSnappingEnabled)?n.state=1:u&&t[e]&&(a<this.contentSize||this.endSnappingEnabled)?n.state=2:n.state=0}else n.state=l&&!c?1:!l&&c?2:3}}getSashPosition(e){let t=0;for(let i=0;i<this.sashItems.length;i++)if(t+=this.viewItems[i].size,this.sashItems[i].sash===e)return t;return 0}findFirstSnapIndex(e){for(const t of e){const e=this.viewItems[t];if(e.visible&&e.snap)return t}for(const t of e){const e=this.viewItems[t];if(e.visible&&e.maximumSize-e.minimumSize>0)return;if(!e.visible&&e.snap)return t}}dispose(){super.dispose(),(0,c.dispose)(this.viewItems),this.viewItems=[],this.sashItems.forEach((e=>e.disposable.dispose())),this.sashItems=[]}}},6507:function(e,t,i){"use strict";i.r(t),i.d(t,{Table:function(){return S}});var n=i(96747),o=i(72406),r=i(70626),s=i(63801),a=i(68921),l=i(93379),c=i.n(l),d=i(7795),u=i.n(d),h=i(90569),g=i.n(h),p=i(3565),m=i.n(p),f=i(19216),b=i.n(f),_=i(44589),A=i.n(_),v=i(78590),C={};C.styleTagTransform=A(),C.setAttributes=m(),C.insert=g().bind(null,"head"),C.domAPI=u(),C.insertStyleElement=b();c()(v.Z,C),v.Z&&v.Z.locals&&v.Z.locals;class w{constructor(e,t,i){this.columns=e,this.getColumnSize=i,this.templateId=w.TemplateId,this.renderedTemplates=new Set;const n=new Map(t.map((e=>[e.templateId,e])));this.renderers=[];for(const t of e){const e=n.get(t.templateId);if(!e)throw new Error(`Table cell renderer for template id ${t.templateId} not found.`);this.renderers.push(e)}}renderTemplate(e){const t=(0,n.append)(e,(0,n.$)(".monaco-table-tr")),i=[],o=[];for(let e=0;e<this.columns.length;e++){const r=this.renderers[e],s=(0,n.append)(t,(0,n.$)(".monaco-table-td",{"data-col-index":e}));s.style.width=`${this.getColumnSize(e)}px`,i.push(s),o.push(r.renderTemplate(s))}const r={container:e,cellContainers:i,cellTemplateData:o};return this.renderedTemplates.add(r),r}renderElement(e,t,i,n){for(let o=0;o<this.columns.length;o++){const r=this.columns[o].project(e);this.renderers[o].renderElement(r,t,i.cellTemplateData[o],n)}}disposeElement(e,t,i,n){for(let o=0;o<this.columns.length;o++){const r=this.renderers[o];if(r.disposeElement){const s=this.columns[o].project(e);r.disposeElement(s,t,i.cellTemplateData[o],n)}}}disposeTemplate(e){for(let t=0;t<this.columns.length;t++){this.renderers[t].disposeTemplate(e.cellTemplateData[t])}(0,n.clearNode)(e.container),this.renderedTemplates.delete(e)}layoutColumn(e,t){for(const{cellContainers:i}of this.renderedTemplates)i[e].style.width=`${t}px`}}w.TemplateId="row";class y{constructor(e,t){this.column=e,this.index=t,this._onDidLayout=new s.Emitter,this.onDidLayout=this._onDidLayout.event,this.element=(0,n.$)(".monaco-table-th",{"data-col-index":t,title:e.tooltip},e.label)}get minimumSize(){var e;return null!==(e=this.column.minimumWidth)&&void 0!==e?e:120}get maximumSize(){var e;return null!==(e=this.column.maximumWidth)&&void 0!==e?e:Number.POSITIVE_INFINITY}get onDidChange(){var e;return null!==(e=this.column.onDidChangeWidthConstraints)&&void 0!==e?e:s.Event.None}layout(e){this._onDidLayout.fire([this.index,e])}}class S{constructor(e,t,i,l,c,d){this.virtualDelegate=i,this.domId="table_id_"+ ++S.InstanceCount,this.disposables=new a.DisposableStore,this.cachedWidth=0,this.cachedHeight=0,this.domNode=(0,n.append)(t,(0,n.$)(`.monaco-table.${this.domId}`));const u=l.map(((e,t)=>new y(e,t))),h={size:u.reduce(((e,t)=>e+t.column.weight),0),views:u.map((e=>({size:e.column.weight,view:e})))};this.splitview=this.disposables.add(new r.SplitView(this.domNode,{orientation:1,scrollbarVisibility:2,getSashOrthogonalSize:()=>this.cachedHeight,descriptor:h})),this.splitview.el.style.height=`${i.headerRowHeight}px`,this.splitview.el.style.lineHeight=`${i.headerRowHeight}px`;const g=new w(l,c,(e=>this.splitview.getViewSize(e)));var p;this.list=this.disposables.add(new o.List(e,this.domNode,(p=i,{getHeight(e){return p.getHeight(e)},getTemplateId(){return w.TemplateId}}),[g],d)),s.Event.any(...u.map((e=>e.onDidLayout)))((([e,t])=>g.layoutColumn(e,t)),null,this.disposables),this.splitview.onDidSashReset((e=>{const t=l.reduce(((e,t)=>e+t.weight),0),i=l[e].weight/t*this.cachedWidth;this.splitview.resizeView(e,i)}),null,this.disposables),this.styleElement=(0,n.createStyleSheet)(this.domNode),this.style({})}get onDidChangeFocus(){return this.list.onDidChangeFocus}get onDidChangeSelection(){return this.list.onDidChangeSelection}get onMouseDblClick(){return this.list.onMouseDblClick}get onPointer(){return this.list.onPointer}get onDidFocus(){return this.list.onDidFocus}get onDidDispose(){return this.list.onDidDispose}updateOptions(e){this.list.updateOptions(e)}splice(e,t,i=[]){this.list.splice(e,t,i)}getHTMLElement(){return this.domNode}style(e){const t=[];t.push(`.monaco-table.${this.domId} > .monaco-split-view2 .monaco-sash.vertical::before {\n\t\t\ttop: ${this.virtualDelegate.headerRowHeight+1}px;\n\t\t\theight: calc(100% - ${this.virtualDelegate.headerRowHeight}px);\n\t\t}`),this.styleElement.textContent=t.join("\n"),this.list.style(e)}getSelectedElements(){return this.list.getSelectedElements()}getSelection(){return this.list.getSelection()}getFocus(){return this.list.getFocus()}dispose(){this.disposables.dispose()}}S.InstanceCount=0},50797:function(e,t,i){"use strict";i.r(t),i.d(t,{Toggle:function(){return w}});var n=i(47257),o=i(56087),r=i(17160),s=i(63801),a=i(93379),l=i.n(a),c=i(7795),d=i.n(c),u=i(90569),h=i.n(u),g=i(3565),p=i.n(g),m=i(19216),f=i.n(m),b=i(44589),_=i.n(b),A=i(69811),v={};v.styleTagTransform=_(),v.setAttributes=p(),v.insert=h().bind(null,"head"),v.domAPI=d(),v.insertStyleElement=f();l()(A.Z,v),A.Z&&A.Z.locals&&A.Z.locals;const C={inputActiveOptionBorder:r.Color.fromHex("#007ACC00"),inputActiveOptionForeground:r.Color.fromHex("#FFFFFF"),inputActiveOptionBackground:r.Color.fromHex("#0E639C50")};class w extends n.Widget{constructor(e){super(),this._onChange=this._register(new s.Emitter),this.onChange=this._onChange.event,this._onKeyDown=this._register(new s.Emitter),this.onKeyDown=this._onKeyDown.event,this._opts=Object.assign(Object.assign({},C),e),this._checked=this._opts.isChecked;const t=["monaco-custom-toggle"];this._opts.icon&&(this._icon=this._opts.icon,t.push(...o.CSSIcon.asClassNameArray(this._icon))),this._opts.actionClassName&&t.push(...this._opts.actionClassName.split(" ")),this._checked&&t.push("checked"),this.domNode=document.createElement("div"),this.domNode.title=this._opts.title,this.domNode.classList.add(...t),this._opts.notFocusable||(this.domNode.tabIndex=0),this.domNode.setAttribute("role","checkbox"),this.domNode.setAttribute("aria-checked",String(this._checked)),this.domNode.setAttribute("aria-label",this._opts.title),this.applyStyles(),this.onclick(this.domNode,(e=>{this.enabled&&(this.checked=!this._checked,this._onChange.fire(!1),e.preventDefault())})),this.ignoreGesture(this.domNode),this.onkeydown(this.domNode,(e=>{if(10===e.keyCode||3===e.keyCode)return this.checked=!this._checked,this._onChange.fire(!0),e.preventDefault(),void e.stopPropagation();this._onKeyDown.fire(e)}))}get enabled(){return"true"!==this.domNode.getAttribute("aria-disabled")}focus(){this.domNode.focus()}get checked(){return this._checked}set checked(e){this._checked=e,this.domNode.setAttribute("aria-checked",String(this._checked)),this.domNode.classList.toggle("checked",this._checked),this.applyStyles()}width(){return 22}style(e){e.inputActiveOptionBorder&&(this._opts.inputActiveOptionBorder=e.inputActiveOptionBorder),e.inputActiveOptionForeground&&(this._opts.inputActiveOptionForeground=e.inputActiveOptionForeground),e.inputActiveOptionBackground&&(this._opts.inputActiveOptionBackground=e.inputActiveOptionBackground),this.applyStyles()}applyStyles(){this.domNode&&(this.domNode.style.borderColor=this._checked&&this._opts.inputActiveOptionBorder?this._opts.inputActiveOptionBorder.toString():"",this.domNode.style.color=this._checked&&this._opts.inputActiveOptionForeground?this._opts.inputActiveOptionForeground.toString():"inherit",this.domNode.style.backgroundColor=this._checked&&this._opts.inputActiveOptionBackground?this._opts.inputActiveOptionBackground.toString():"")}enable(){this.domNode.setAttribute("aria-disabled",String(!1))}disable(){this.domNode.setAttribute("aria-disabled",String(!0))}}},72665:function(e,t,i){"use strict";i.r(t),i.d(t,{AbstractTree:function(){return q},ComposedTreeDelegate:function(){return z},ModeToggle:function(){return U},RenderIndentGuides:function(){return N},TreeFindMode:function(){return R}});var n=i(96747),o=(i(50465),i(8769)),r=(i(31532),i(73493),i(75291)),s=i(72406),a=i(50797),l=i(49517),c=i(23877),d=(i(60969),i(64998)),u=i(66129),h=i(56087),g=i(64280),p=i(63801),m=i(27017),f=i(68921),b=i(53719),_=i(18912),A=i(93379),v=i.n(A),C=i(7795),w=i.n(C),y=i(90569),S=i.n(y),x=i(3565),E=i.n(x),k=i(19216),I=i.n(k),D=i(44589),L=i.n(D),T=i(42650),M={};M.styleTagTransform=L(),M.setAttributes=E(),M.insert=S().bind(null,"head"),M.domAPI=w(),M.insertStyleElement=I();v()(T.Z,M),T.Z&&T.Z.locals&&T.Z.locals;var N,R,B=i(83787);class O extends r.ElementsDragAndDropData{constructor(e){super(e.elements.map((e=>e.element))),this.data=e}}function F(e){return e instanceof r.ElementsDragAndDropData?new O(e):e}class P{constructor(e,t){this.modelProvider=e,this.dnd=t,this.autoExpandDisposable=f.Disposable.None}getDragURI(e){return this.dnd.getDragURI(e.element)}getDragLabel(e,t){if(this.dnd.getDragLabel)return this.dnd.getDragLabel(e.map((e=>e.element)),t)}onDragStart(e,t){var i,n;null===(n=(i=this.dnd).onDragStart)||void 0===n||n.call(i,F(e),t)}onDragOver(e,t,i,n,o=!0){const r=this.dnd.onDragOver(F(e),t&&t.element,i,n),s=this.autoExpandNode!==t;if(s&&(this.autoExpandDisposable.dispose(),this.autoExpandNode=t),void 0===t)return r;if(s&&"boolean"!=typeof r&&r.autoExpand&&(this.autoExpandDisposable=(0,u.disposableTimeout)((()=>{const e=this.modelProvider(),i=e.getNodeLocation(t);e.isCollapsed(i)&&e.setCollapsed(i,!1),this.autoExpandNode=void 0}),500)),"boolean"==typeof r||!r.accept||void 0===r.bubble||r.feedback){if(!o){return{accept:"boolean"==typeof r?r:r.accept,effect:"boolean"==typeof r?void 0:r.effect,feedback:[i]}}return r}if(1===r.bubble){const i=this.modelProvider(),o=i.getNodeLocation(t),r=i.getParentNodeLocation(o),s=i.getNode(r),a=r&&i.getListIndex(r);return this.onDragOver(e,s,a,n,!1)}const a=this.modelProvider(),l=a.getNodeLocation(t),c=a.getListIndex(l),h=a.getListRenderCount(l);return Object.assign(Object.assign({},r),{feedback:(0,d.range)(c,c+h)})}drop(e,t,i,n){this.autoExpandDisposable.dispose(),this.autoExpandNode=void 0,this.dnd.drop(F(e),t&&t.element,i,n)}onDragEnd(e){var t,i;null===(i=(t=this.dnd).onDragEnd)||void 0===i||i.call(t,e)}}class z{constructor(e){this.delegate=e}getHeight(e){return this.delegate.getHeight(e.element)}getTemplateId(e){return this.delegate.getTemplateId(e.element)}hasDynamicHeight(e){return!!this.delegate.hasDynamicHeight&&this.delegate.hasDynamicHeight(e.element)}setDynamicHeight(e,t){var i,n;null===(n=(i=this.delegate).setDynamicHeight)||void 0===n||n.call(i,e.element,t)}}!function(e){e.None="none",e.OnHover="onHover",e.Always="always"}(N||(N={}));class H{constructor(e,t=[]){this._elements=t,this.disposables=new f.DisposableStore,this.onDidChange=p.Event.forEach(e,(e=>this._elements=e),this.disposables)}get elements(){return this._elements}dispose(){this.disposables.dispose()}}class W{constructor(e,t,i,n,o={}){var r;this.renderer=e,this.modelProvider=t,this.activeNodes=n,this.renderedElements=new Map,this.renderedNodes=new Map,this.indent=W.DefaultIndent,this.hideTwistiesOfChildlessElements=!1,this.shouldRenderIndentGuides=!1,this.renderedIndentGuides=new g.SetMap,this.activeIndentNodes=new Set,this.indentGuidesDisposable=f.Disposable.None,this.disposables=new f.DisposableStore,this.templateId=e.templateId,this.updateOptions(o),p.Event.map(i,(e=>e.node))(this.onDidChangeNodeTwistieState,this,this.disposables),null===(r=e.onDidChangeTwistieState)||void 0===r||r.call(e,this.onDidChangeTwistieState,this,this.disposables)}updateOptions(e={}){if(void 0!==e.indent&&(this.indent=(0,b.clamp)(e.indent,0,40)),void 0!==e.renderIndentGuides){const t=e.renderIndentGuides!==N.None;if(t!==this.shouldRenderIndentGuides&&(this.shouldRenderIndentGuides=t,this.indentGuidesDisposable.dispose(),t)){const e=new f.DisposableStore;this.activeNodes.onDidChange(this._onDidChangeActiveNodes,this,e),this.indentGuidesDisposable=e,this._onDidChangeActiveNodes(this.activeNodes.elements)}}void 0!==e.hideTwistiesOfChildlessElements&&(this.hideTwistiesOfChildlessElements=e.hideTwistiesOfChildlessElements)}renderTemplate(e){const t=(0,n.append)(e,(0,n.$)(".monaco-tl-row")),i=(0,n.append)(t,(0,n.$)(".monaco-tl-indent")),o=(0,n.append)(t,(0,n.$)(".monaco-tl-twistie")),r=(0,n.append)(t,(0,n.$)(".monaco-tl-contents")),s=this.renderer.renderTemplate(r);return{container:e,indent:i,twistie:o,indentGuidesDisposable:f.Disposable.None,templateData:s}}renderElement(e,t,i,n){"number"==typeof n&&(this.renderedNodes.set(e,{templateData:i,height:n}),this.renderedElements.set(e.element,e));const o=W.DefaultIndent+(e.depth-1)*this.indent;i.twistie.style.paddingLeft=`${o}px`,i.indent.style.width=o+this.indent-16+"px",this.renderTwistie(e,i),"number"==typeof n&&this.renderIndentGuides(e,i),this.renderer.renderElement(e,t,i.templateData,n)}disposeElement(e,t,i,n){var o,r;i.indentGuidesDisposable.dispose(),null===(r=(o=this.renderer).disposeElement)||void 0===r||r.call(o,e,t,i.templateData,n),"number"==typeof n&&(this.renderedNodes.delete(e),this.renderedElements.delete(e.element))}disposeTemplate(e){this.renderer.disposeTemplate(e.templateData)}onDidChangeTwistieState(e){const t=this.renderedElements.get(e);t&&this.onDidChangeNodeTwistieState(t)}onDidChangeNodeTwistieState(e){const t=this.renderedNodes.get(e);t&&(this.renderTwistie(e,t.templateData),this._onDidChangeActiveNodes(this.activeNodes.elements),this.renderIndentGuides(e,t.templateData))}renderTwistie(e,t){t.twistie.classList.remove(...h.Codicon.treeItemExpanded.classNamesArray);let i=!1;this.renderer.renderTwistie&&(i=this.renderer.renderTwistie(e.element,t.twistie)),e.collapsible&&(!this.hideTwistiesOfChildlessElements||e.visibleChildrenCount>0)?(i||t.twistie.classList.add(...h.Codicon.treeItemExpanded.classNamesArray),t.twistie.classList.add("collapsible"),t.twistie.classList.toggle("collapsed",e.collapsed)):t.twistie.classList.remove("collapsible","collapsed"),e.collapsible?t.container.setAttribute("aria-expanded",String(!e.collapsed)):t.container.removeAttribute("aria-expanded")}renderIndentGuides(e,t){if((0,n.clearNode)(t.indent),t.indentGuidesDisposable.dispose(),!this.shouldRenderIndentGuides)return;const i=new f.DisposableStore,o=this.modelProvider();let r=e;for(;;){const e=o.getNodeLocation(r),s=o.getParentNodeLocation(e);if(!s)break;const a=o.getNode(s),l=(0,n.$)(".indent-guide",{style:`width: ${this.indent}px`});this.activeIndentNodes.has(a)&&l.classList.add("active"),0===t.indent.childElementCount?t.indent.appendChild(l):t.indent.insertBefore(l,t.indent.firstElementChild),this.renderedIndentGuides.add(a,l),i.add((0,f.toDisposable)((()=>this.renderedIndentGuides.delete(a,l)))),r=a}t.indentGuidesDisposable=i}_onDidChangeActiveNodes(e){if(!this.shouldRenderIndentGuides)return;const t=new Set,i=this.modelProvider();e.forEach((e=>{const n=i.getNodeLocation(e);try{const o=i.getParentNodeLocation(n);e.collapsible&&e.children.length>0&&!e.collapsed?t.add(e):o&&t.add(i.getNode(o))}catch(e){}})),this.activeIndentNodes.forEach((e=>{t.has(e)||this.renderedIndentGuides.forEach(e,(e=>e.classList.remove("active")))})),t.forEach((e=>{this.activeIndentNodes.has(e)||this.renderedIndentGuides.forEach(e,(e=>e.classList.add("active")))})),this.activeIndentNodes=t}dispose(){this.renderedNodes.clear(),this.renderedElements.clear(),this.indentGuidesDisposable.dispose(),(0,f.dispose)(this.disposables)}}W.DefaultIndent=8;class V{constructor(e,t,i){this.tree=e,this.keyboardNavigationLabelProvider=t,this._filter=i,this._totalCount=0,this._matchCount=0,this._pattern="",this._lowercasePattern="",this.disposables=new f.DisposableStore,e.onWillRefilter(this.reset,this,this.disposables)}get totalCount(){return this._totalCount}get matchCount(){return this._matchCount}filter(e,t){let i=1;if(this._filter){const n=this._filter.filter(e,t);if(i="boolean"==typeof n?n?1:0:(0,l.isFilterResult)(n)?(0,l.getVisibleState)(n.visibility):n,0===i)return!1}if(this._totalCount++,!this._pattern)return this._matchCount++,{data:m.FuzzyScore.Default,visibility:i};const n=this.keyboardNavigationLabelProvider.getKeyboardNavigationLabel(e),o=Array.isArray(n)?n:[n];for(const e of o){const t=e&&e.toString();if(void 0===t)return{data:m.FuzzyScore.Default,visibility:i};const n=(0,m.fuzzyScore)(this._pattern,this._lowercasePattern,0,t,t.toLowerCase(),0,{firstMatchCanBeWeak:!0,boostFullMatch:!0});if(n)return this._matchCount++,1===o.length?{data:n,visibility:i}:{data:{label:t,score:n},visibility:i}}return this.tree.findMode===R.Filter?2:{data:m.FuzzyScore.Default,visibility:i}}reset(){this._totalCount=0,this._matchCount=0}dispose(){(0,f.dispose)(this.disposables)}}class U extends a.Toggle{constructor(e){var t;super({icon:h.Codicon.filter,title:(0,B.localize)("vs/base/browser/ui/tree/abstractTree","filter","Filter"),isChecked:null!==(t=null==e?void 0:e.isChecked)&&void 0!==t&&t,inputActiveOptionBorder:null==e?void 0:e.inputActiveOptionBorder,inputActiveOptionForeground:null==e?void 0:e.inputActiveOptionForeground,inputActiveOptionBackground:null==e?void 0:e.inputActiveOptionBackground})}}!function(e){e[e.Highlight=0]="Highlight",e[e.Filter=1]="Filter"}(R||(R={}));class Q{constructor(e,t,i,n,o){var r;this.tree=e,this.view=i,this.filter=n,this.contextViewProvider=o,this._pattern="",this.width=0,this._onDidChangeMode=new p.Emitter,this.onDidChangeMode=this._onDidChangeMode.event,this._onDidChangePattern=new p.Emitter,this._onDidChangeOpenState=new p.Emitter,this.onDidChangeOpenState=this._onDidChangeOpenState.event,this.enabledDisposables=new f.DisposableStore,this.disposables=new f.DisposableStore,this._mode=null!==(r=e.options.defaultFindMode)&&void 0!==r?r:R.Highlight,t.onDidSplice(this.onDidSpliceModel,this,this.disposables)}get pattern(){return this._pattern}get mode(){return this._mode}set mode(e){e!==this._mode&&(this._mode=e,this.widget&&(this.widget.mode=this._mode),this.tree.refilter(),this.render(),this._onDidChangeMode.fire(e))}onDidSpliceModel(){this.widget&&0!==this.pattern.length&&(this.tree.refilter(),this.render())}render(){var e,t;const i=this.filter.totalCount>0&&0===this.filter.matchCount;this.pattern&&i?null===(e=this.widget)||void 0===e||e.showMessage({type:2,content:(0,B.localize)("vs/base/browser/ui/tree/abstractTree","not found","No elements found.")}):null===(t=this.widget)||void 0===t||t.clearMessage()}shouldAllowFocus(e){return!this.widget||!this.pattern||this._mode===R.Filter||(this.filter.totalCount>0&&this.filter.matchCount<=1||!m.FuzzyScore.isDefault(e.filterData))}style(e){var t;this.styles=e,null===(t=this.widget)||void 0===t||t.style(e)}layout(e){var t;this.width=e,null===(t=this.widget)||void 0===t||t.layout(e)}dispose(){this._onDidChangePattern.dispose(),this.enabledDisposables.dispose(),this.disposables.dispose()}}function K(e){let t=c.TreeMouseEventTarget.Unknown;return(0,n.hasParentWithClass)(e.browserEvent.target,"monaco-tl-twistie","monaco-tl-row")?t=c.TreeMouseEventTarget.Twistie:(0,n.hasParentWithClass)(e.browserEvent.target,"monaco-tl-contents","monaco-tl-row")?t=c.TreeMouseEventTarget.Element:(0,n.hasParentWithClass)(e.browserEvent.target,"monaco-tree-type-filter","monaco-list")&&(t=c.TreeMouseEventTarget.Filter),{browserEvent:e.browserEvent,element:e.element?e.element.element:null,target:t}}function j(e,t){t(e),e.children.forEach((e=>j(e,t)))}class G{constructor(e,t){this.getFirstViewElementWithTrait=e,this.identityProvider=t,this.nodes=[],this._onDidChange=new p.Emitter,this.onDidChange=this._onDidChange.event}get nodeSet(){return this._nodeSet||(this._nodeSet=this.createNodeSet()),this._nodeSet}set(e,t){!(null==t?void 0:t.__forceEvent)&&(0,d.equals)(this.nodes,e)||this._set(e,!1,t)}_set(e,t,i){if(this.nodes=[...e],this.elements=void 0,this._nodeSet=void 0,!t){const e=this;this._onDidChange.fire({get elements(){return e.get()},browserEvent:i})}}get(){return this.elements||(this.elements=this.nodes.map((e=>e.element))),[...this.elements]}getNodes(){return this.nodes}has(e){return this.nodeSet.has(e)}onDidModelSplice({insertedNodes:e,deletedNodes:t}){if(!this.identityProvider){const e=this.createNodeSet(),i=t=>e.delete(t);return t.forEach((e=>j(e,i))),void this.set([...e.values()])}const i=new Set,n=e=>i.add(this.identityProvider.getId(e.element).toString());t.forEach((e=>j(e,n)));const o=new Map,r=e=>o.set(this.identityProvider.getId(e.element).toString(),e);e.forEach((e=>j(e,r)));const s=[];for(const e of this.nodes){const t=this.identityProvider.getId(e.element).toString();if(i.has(t)){const e=o.get(t);e&&s.push(e)}else s.push(e)}if(this.nodes.length>0&&0===s.length){const e=this.getFirstViewElementWithTrait();e&&s.push(e)}this._set(s,!0)}createNodeSet(){const e=new Set;for(const t of this.nodes)e.add(t);return e}}class $ extends s.MouseController{constructor(e,t){super(e),this.tree=t}onViewPointer(e){if((0,s.isButton)(e.browserEvent.target)||(0,s.isInputElement)(e.browserEvent.target)||(0,s.isMonacoEditor)(e.browserEvent.target))return;const t=e.element;if(!t)return super.onViewPointer(e);if(this.isSelectionRangeChangeEvent(e)||this.isSelectionSingleChangeEvent(e))return super.onViewPointer(e);const i=e.browserEvent.target,n=i.classList.contains("monaco-tl-twistie")||i.classList.contains("monaco-icon-label")&&i.classList.contains("folder-icon")&&e.browserEvent.offsetX<16;let o=!1;if(o="function"==typeof this.tree.expandOnlyOnTwistieClick?this.tree.expandOnlyOnTwistieClick(t.element):!!this.tree.expandOnlyOnTwistieClick,o&&!n&&2!==e.browserEvent.detail)return super.onViewPointer(e);if(!this.tree.expandOnDoubleClick&&2===e.browserEvent.detail)return super.onViewPointer(e);if(t.collapsible){const i=this.tree.model,r=i.getNodeLocation(t),s=e.browserEvent.altKey;if(this.tree.setFocus([r]),i.setCollapsed(r,void 0,s),o&&n)return}super.onViewPointer(e)}onDoubleClick(e){!e.browserEvent.target.classList.contains("monaco-tl-twistie")&&this.tree.expandOnDoubleClick&&super.onDoubleClick(e)}}class Y extends s.List{constructor(e,t,i,n,o,r,s,a){super(e,t,i,n,a),this.focusTrait=o,this.selectionTrait=r,this.anchorTrait=s}createMouseController(e){return new $(this,e.tree)}splice(e,t,i=[]){if(super.splice(e,t,i),0===i.length)return;const n=[],o=[];let r;i.forEach(((t,i)=>{this.focusTrait.has(t)&&n.push(e+i),this.selectionTrait.has(t)&&o.push(e+i),this.anchorTrait.has(t)&&(r=e+i)})),n.length>0&&super.setFocus((0,d.distinct)([...super.getFocus(),...n])),o.length>0&&super.setSelection((0,d.distinct)([...super.getSelection(),...o])),"number"==typeof r&&super.setAnchor(r)}setFocus(e,t,i=!1){super.setFocus(e,t),i||this.focusTrait.set(e.map((e=>this.element(e))),t)}setSelection(e,t,i=!1){super.setSelection(e,t),i||this.selectionTrait.set(e.map((e=>this.element(e))),t)}setAnchor(e,t=!1){super.setAnchor(e),t||(void 0===e?this.anchorTrait.set([]):this.anchorTrait.set([this.element(e)]))}}class q{constructor(e,t,i,r,a={}){var l;this._user=e,this._options=a,this.eventBufferer=new p.EventBufferer,this.onDidChangeFindOpenState=p.Event.None,this.disposables=new f.DisposableStore,this._onWillRefilter=new p.Emitter,this.onWillRefilter=this._onWillRefilter.event,this._onDidUpdateOptions=new p.Emitter;const c=new z(i),d=new p.Relay,u=new p.Relay,h=this.disposables.add(new H(u.event));this.renderers=r.map((e=>new W(e,(()=>this.model),d.event,h,a)));for(const e of this.renderers)this.disposables.add(e);let g;a.keyboardNavigationLabelProvider&&(g=new V(this,a.keyboardNavigationLabelProvider,a.filter),a=Object.assign(Object.assign({},a),{filter:g}),this.disposables.add(g)),this.focus=new G((()=>this.view.getFocusedElements()[0]),a.identityProvider),this.selection=new G((()=>this.view.getSelectedElements()[0]),a.identityProvider),this.anchor=new G((()=>this.view.getAnchorElement()),a.identityProvider),this.view=new Y(e,t,c,this.renderers,this.focus,this.selection,this.anchor,Object.assign(Object.assign({},function(e,t){return t&&Object.assign(Object.assign({},t),{identityProvider:t.identityProvider&&{getId(e){return t.identityProvider.getId(e.element)}},dnd:t.dnd&&new P(e,t.dnd),multipleSelectionController:t.multipleSelectionController&&{isSelectionSingleChangeEvent(e){return t.multipleSelectionController.isSelectionSingleChangeEvent(Object.assign(Object.assign({},e),{element:e.element}))},isSelectionRangeChangeEvent(e){return t.multipleSelectionController.isSelectionRangeChangeEvent(Object.assign(Object.assign({},e),{element:e.element}))}},accessibilityProvider:t.accessibilityProvider&&Object.assign(Object.assign({},t.accessibilityProvider),{getSetSize(t){const i=e(),n=i.getNodeLocation(t),o=i.getParentNodeLocation(n);return i.getNode(o).visibleChildrenCount},getPosInSet(e){return e.visibleChildIndex+1},isChecked:t.accessibilityProvider&&t.accessibilityProvider.isChecked?e=>t.accessibilityProvider.isChecked(e.element):void 0,getRole:t.accessibilityProvider&&t.accessibilityProvider.getRole?e=>t.accessibilityProvider.getRole(e.element):()=>"treeitem",getAriaLabel(e){return t.accessibilityProvider.getAriaLabel(e.element)},getWidgetAriaLabel(){return t.accessibilityProvider.getWidgetAriaLabel()},getWidgetRole:t.accessibilityProvider&&t.accessibilityProvider.getWidgetRole?()=>t.accessibilityProvider.getWidgetRole():()=>"tree",getAriaLevel:t.accessibilityProvider&&t.accessibilityProvider.getAriaLevel?e=>t.accessibilityProvider.getAriaLevel(e.element):e=>e.depth,getActiveDescendantId:t.accessibilityProvider.getActiveDescendantId&&(e=>t.accessibilityProvider.getActiveDescendantId(e.element))}),keyboardNavigationLabelProvider:t.keyboardNavigationLabelProvider&&Object.assign(Object.assign({},t.keyboardNavigationLabelProvider),{getKeyboardNavigationLabel(e){return t.keyboardNavigationLabelProvider.getKeyboardNavigationLabel(e.element)}})})}((()=>this.model),a)),{tree:this})),this.model=this.createModel(e,this.view,a),d.input=this.model.onDidChangeCollapseState;const m=p.Event.forEach(this.model.onDidSplice,(e=>{this.eventBufferer.bufferEvents((()=>{this.focus.onDidModelSplice(e),this.selection.onDidModelSplice(e)}))}),this.disposables);if(m((()=>null),null,this.disposables),u.input=p.Event.chain(p.Event.any(m,this.focus.onDidChange,this.selection.onDidChange)).debounce((()=>null),0).map((()=>{const e=new Set;for(const t of this.focus.getNodes())e.add(t);for(const t of this.selection.getNodes())e.add(t);return[...e.values()]})).event,!1!==a.keyboardSupport){const e=p.Event.chain(this.view.onKeyDown).filter((e=>!(0,s.isInputElement)(e.target))).map((e=>new o.StandardKeyboardEvent(e)));e.filter((e=>15===e.keyCode)).on(this.onLeftArrow,this,this.disposables),e.filter((e=>17===e.keyCode)).on(this.onRightArrow,this,this.disposables),e.filter((e=>10===e.keyCode)).on(this.onSpace,this,this.disposables)}(null===(l=a.findWidgetEnabled)||void 0===l||l)&&a.keyboardNavigationLabelProvider&&a.contextViewProvider?(this.findController=new Q(this,this.model,this.view,g,a.contextViewProvider),this.focusNavigationFilter=e=>this.findController.shouldAllowFocus(e),this.onDidChangeFindOpenState=this.findController.onDidChangeOpenState,this.disposables.add(this.findController),this.onDidChangeFindMode=this.findController.onDidChangeMode):this.onDidChangeFindMode=p.Event.None,this.styleElement=(0,n.createStyleSheet)(this.view.getHTMLElement()),this.getHTMLElement().classList.toggle("always",this._options.renderIndentGuides===N.Always)}get onDidChangeFocus(){return this.eventBufferer.wrapEvent(this.focus.onDidChange)}get onDidChangeSelection(){return this.eventBufferer.wrapEvent(this.selection.onDidChange)}get onMouseDblClick(){return p.Event.filter(p.Event.map(this.view.onMouseDblClick,K),(e=>e.target!==c.TreeMouseEventTarget.Filter))}get onPointer(){return p.Event.map(this.view.onPointer,K)}get onDidFocus(){return this.view.onDidFocus}get onDidChangeModel(){return p.Event.signal(this.model.onDidSplice)}get onDidChangeCollapseState(){return this.model.onDidChangeCollapseState}get findMode(){var e,t;return null!==(t=null===(e=this.findController)||void 0===e?void 0:e.mode)&&void 0!==t?t:R.Highlight}set findMode(e){this.findController&&(this.findController.mode=e)}get expandOnDoubleClick(){return void 0===this._options.expandOnDoubleClick||this._options.expandOnDoubleClick}get expandOnlyOnTwistieClick(){return void 0===this._options.expandOnlyOnTwistieClick||this._options.expandOnlyOnTwistieClick}get onDidDispose(){return this.view.onDidDispose}updateOptions(e={}){this._options=Object.assign(Object.assign({},this._options),e);for(const t of this.renderers)t.updateOptions(e);this.view.updateOptions(this._options),this._onDidUpdateOptions.fire(this._options),this.getHTMLElement().classList.toggle("always",this._options.renderIndentGuides===N.Always)}get options(){return this._options}getHTMLElement(){return this.view.getHTMLElement()}get scrollTop(){return this.view.scrollTop}set scrollTop(e){this.view.scrollTop=e}domFocus(){this.view.domFocus()}layout(e,t){var i;this.view.layout(e,t),(0,_.isNumber)(t)&&(null===(i=this.findController)||void 0===i||i.layout(t))}style(e){var t;const i=`.${this.view.domId}`,n=[];e.treeIndentGuidesStroke&&(n.push(`.monaco-list${i}:hover .monaco-tl-indent > .indent-guide, .monaco-list${i}.always .monaco-tl-indent > .indent-guide  { border-color: ${e.treeIndentGuidesStroke.transparent(.4)}; }`),n.push(`.monaco-list${i} .monaco-tl-indent > .indent-guide.active { border-color: ${e.treeIndentGuidesStroke}; }`)),this.styleElement.textContent=n.join("\n"),null===(t=this.findController)||void 0===t||t.style(e),this.view.style(e)}getParentElement(e){const t=this.model.getParentNodeLocation(e);return this.model.getNode(t).element}getFirstElementChild(e){return this.model.getFirstElementChild(e)}getNode(e){return this.model.getNode(e)}collapse(e,t=!1){return this.model.setCollapsed(e,!0,t)}expand(e,t=!1){return this.model.setCollapsed(e,!1,t)}isCollapsible(e){return this.model.isCollapsible(e)}setCollapsible(e,t){return this.model.setCollapsible(e,t)}isCollapsed(e){return this.model.isCollapsed(e)}refilter(){this._onWillRefilter.fire(void 0),this.model.refilter()}setSelection(e,t){const i=e.map((e=>this.model.getNode(e)));this.selection.set(i,t);const n=e.map((e=>this.model.getListIndex(e))).filter((e=>e>-1));this.view.setSelection(n,t,!0)}getSelection(){return this.selection.get()}setFocus(e,t){const i=e.map((e=>this.model.getNode(e)));this.focus.set(i,t);const n=e.map((e=>this.model.getListIndex(e))).filter((e=>e>-1));this.view.setFocus(n,t,!0)}getFocus(){return this.focus.get()}reveal(e,t){this.model.expandTo(e);const i=this.model.getListIndex(e);-1!==i&&this.view.reveal(i,t)}onLeftArrow(e){e.preventDefault(),e.stopPropagation();const t=this.view.getFocusedElements();if(0===t.length)return;const i=t[0],n=this.model.getNodeLocation(i);if(!this.model.setCollapsed(n,!0)){const e=this.model.getParentNodeLocation(n);if(!e)return;const t=this.model.getListIndex(e);this.view.reveal(t),this.view.setFocus([t])}}onRightArrow(e){e.preventDefault(),e.stopPropagation();const t=this.view.getFocusedElements();if(0===t.length)return;const i=t[0],n=this.model.getNodeLocation(i);if(!this.model.setCollapsed(n,!1)){if(!i.children.some((e=>e.visible)))return;const[e]=this.view.getFocus(),t=e+1;this.view.reveal(t),this.view.setFocus([t])}}onSpace(e){e.preventDefault(),e.stopPropagation();const t=this.view.getFocusedElements();if(0===t.length)return;const i=t[0],n=this.model.getNodeLocation(i),o=e.browserEvent.altKey;this.model.setCollapsed(n,void 0,o)}dispose(){(0,f.dispose)(this.disposables),this.view.dispose()}}},74904:function(e,t,i){"use strict";i.r(t),i.d(t,{AsyncDataTree:function(){return k},CompressibleAsyncDataTree:function(){return L}});var n=i(75291),o=i(72665),r=i(49517),s=i(22481),a=i(23877),l=i(66129),c=i(56087),d=i(12718),u=i(63801),h=i(24417),g=i(68921),p=i(18912),m=function(e,t,i,n){return new(i||(i=Promise))((function(o,r){function s(e){try{l(n.next(e))}catch(e){r(e)}}function a(e){try{l(n.throw(e))}catch(e){r(e)}}function l(e){var t;e.done?o(e.value):(t=e.value,t instanceof i?t:new i((function(e){e(t)}))).then(s,a)}l((n=n.apply(e,t||[])).next())}))};function f(e){return Object.assign(Object.assign({},e),{children:[],refreshPromise:void 0,stale:!0,slow:!1,collapsedByDefault:void 0})}function b(e,t){return!!t.parent&&(t.parent===e||b(e,t.parent))}class _{constructor(e){this.node=e}get element(){return this.node.element.element}get children(){return this.node.children.map((e=>new _(e)))}get depth(){return this.node.depth}get visibleChildrenCount(){return this.node.visibleChildrenCount}get visibleChildIndex(){return this.node.visibleChildIndex}get collapsible(){return this.node.collapsible}get collapsed(){return this.node.collapsed}get visible(){return this.node.visible}get filterData(){return this.node.filterData}}class A{constructor(e,t,i){this.renderer=e,this.nodeMapper=t,this.onDidChangeTwistieState=i,this.renderedNodes=new Map,this.templateId=e.templateId}renderTemplate(e){return{templateData:this.renderer.renderTemplate(e)}}renderElement(e,t,i,n){this.renderer.renderElement(this.nodeMapper.map(e),t,i.templateData,n)}renderTwistie(e,t){return e.slow?(t.classList.add(...c.Codicon.treeItemLoading.classNamesArray),!0):(t.classList.remove(...c.Codicon.treeItemLoading.classNamesArray),!1)}disposeElement(e,t,i,n){var o,r;null===(r=(o=this.renderer).disposeElement)||void 0===r||r.call(o,this.nodeMapper.map(e),t,i.templateData,n)}disposeTemplate(e){this.renderer.disposeTemplate(e.templateData)}dispose(){this.renderedNodes.clear()}}function v(e){return{browserEvent:e.browserEvent,elements:e.elements.map((e=>e.element))}}function C(e){return{browserEvent:e.browserEvent,element:e.element&&e.element.element,target:e.target}}class w extends n.ElementsDragAndDropData{constructor(e){super(e.elements.map((e=>e.element))),this.data=e}}function y(e){return e instanceof n.ElementsDragAndDropData?new w(e):e}class S{constructor(e){this.dnd=e}getDragURI(e){return this.dnd.getDragURI(e.element)}getDragLabel(e,t){if(this.dnd.getDragLabel)return this.dnd.getDragLabel(e.map((e=>e.element)),t)}onDragStart(e,t){var i,n;null===(n=(i=this.dnd).onDragStart)||void 0===n||n.call(i,y(e),t)}onDragOver(e,t,i,n,o=!0){return this.dnd.onDragOver(y(e),t&&t.element,i,n)}drop(e,t,i,n){this.dnd.drop(y(e),t&&t.element,i,n)}onDragEnd(e){var t,i;null===(i=(t=this.dnd).onDragEnd)||void 0===i||i.call(t,e)}}function x(e){return e&&Object.assign(Object.assign({},e),{collapseByDefault:!0,identityProvider:e.identityProvider&&{getId(t){return e.identityProvider.getId(t.element)}},dnd:e.dnd&&new S(e.dnd),multipleSelectionController:e.multipleSelectionController&&{isSelectionSingleChangeEvent(t){return e.multipleSelectionController.isSelectionSingleChangeEvent(Object.assign(Object.assign({},t),{element:t.element}))},isSelectionRangeChangeEvent(t){return e.multipleSelectionController.isSelectionRangeChangeEvent(Object.assign(Object.assign({},t),{element:t.element}))}},accessibilityProvider:e.accessibilityProvider&&Object.assign(Object.assign({},e.accessibilityProvider),{getPosInSet:void 0,getSetSize:void 0,getRole:e.accessibilityProvider.getRole?t=>e.accessibilityProvider.getRole(t.element):()=>"treeitem",isChecked:e.accessibilityProvider.isChecked?t=>{var i;return!!(null===(i=e.accessibilityProvider)||void 0===i?void 0:i.isChecked(t.element))}:void 0,getAriaLabel(t){return e.accessibilityProvider.getAriaLabel(t.element)},getWidgetAriaLabel(){return e.accessibilityProvider.getWidgetAriaLabel()},getWidgetRole:e.accessibilityProvider.getWidgetRole?()=>e.accessibilityProvider.getWidgetRole():()=>"tree",getAriaLevel:e.accessibilityProvider.getAriaLevel&&(t=>e.accessibilityProvider.getAriaLevel(t.element)),getActiveDescendantId:e.accessibilityProvider.getActiveDescendantId&&(t=>e.accessibilityProvider.getActiveDescendantId(t.element))}),filter:e.filter&&{filter(t,i){return e.filter.filter(t.element,i)}},keyboardNavigationLabelProvider:e.keyboardNavigationLabelProvider&&Object.assign(Object.assign({},e.keyboardNavigationLabelProvider),{getKeyboardNavigationLabel(t){return e.keyboardNavigationLabelProvider.getKeyboardNavigationLabel(t.element)}}),sorter:void 0,expandOnlyOnTwistieClick:void 0===e.expandOnlyOnTwistieClick?void 0:"function"!=typeof e.expandOnlyOnTwistieClick?e.expandOnlyOnTwistieClick:t=>e.expandOnlyOnTwistieClick(t.element),additionalScrollHeight:e.additionalScrollHeight})}function E(e,t){t(e),e.children.forEach((e=>E(e,t)))}class k{constructor(e,t,i,n,o,r={}){this.user=e,this.dataSource=o,this.nodes=new Map,this.subTreeRefreshPromises=new Map,this.refreshPromises=new Map,this._onDidRender=new u.Emitter,this._onDidChangeNodeSlowState=new u.Emitter,this.nodeMapper=new a.WeakMapper((e=>new _(e))),this.disposables=new g.DisposableStore,this.identityProvider=r.identityProvider,this.autoExpandSingleChildren=void 0!==r.autoExpandSingleChildren&&r.autoExpandSingleChildren,this.sorter=r.sorter,this.collapseByDefault=r.collapseByDefault,this.tree=this.createTree(e,t,i,n,r),this.onDidChangeFindMode=this.tree.onDidChangeFindMode,this.root=f({element:void 0,parent:null,hasChildren:!0}),this.identityProvider&&(this.root=Object.assign(Object.assign({},this.root),{id:null})),this.nodes.set(null,this.root),this.tree.onDidChangeCollapseState(this._onDidChangeCollapseState,this,this.disposables)}get onDidChangeFocus(){return u.Event.map(this.tree.onDidChangeFocus,v)}get onDidChangeSelection(){return u.Event.map(this.tree.onDidChangeSelection,v)}get onMouseDblClick(){return u.Event.map(this.tree.onMouseDblClick,C)}get onPointer(){return u.Event.map(this.tree.onPointer,C)}get onDidFocus(){return this.tree.onDidFocus}get onDidChangeModel(){return this.tree.onDidChangeModel}get onDidChangeCollapseState(){return this.tree.onDidChangeCollapseState}get onDidChangeFindOpenState(){return this.tree.onDidChangeFindOpenState}get onDidDispose(){return this.tree.onDidDispose}createTree(e,t,i,n,r){const a=new o.ComposedTreeDelegate(i),l=n.map((e=>new A(e,this.nodeMapper,this._onDidChangeNodeSlowState.event))),c=x(r)||{};return new s.ObjectTree(e,t,a,l,c)}updateOptions(e={}){this.tree.updateOptions(e)}getHTMLElement(){return this.tree.getHTMLElement()}get scrollTop(){return this.tree.scrollTop}set scrollTop(e){this.tree.scrollTop=e}domFocus(){this.tree.domFocus()}layout(e,t){this.tree.layout(e,t)}style(e){this.tree.style(e)}getInput(){return this.root.element}setInput(e,t){return m(this,void 0,void 0,(function*(){this.refreshPromises.forEach((e=>e.cancel())),this.refreshPromises.clear(),this.root.element=e;const i=t&&{viewState:t,focus:[],selection:[]};yield this._updateChildren(e,!0,!1,i),i&&(this.tree.setFocus(i.focus),this.tree.setSelection(i.selection)),t&&"number"==typeof t.scrollTop&&(this.scrollTop=t.scrollTop)}))}_updateChildren(e=this.root.element,t=!0,i=!1,n,o){return m(this,void 0,void 0,(function*(){if(void 0===this.root.element)throw new a.TreeError(this.user,"Tree input not set");this.root.refreshPromise&&(yield this.root.refreshPromise,yield u.Event.toPromise(this._onDidRender.event));const r=this.getDataNode(e);if(yield this.refreshAndRenderNode(r,t,n,o),i)try{this.tree.rerender(r)}catch(e){}}))}rerender(e){if(void 0===e||e===this.root.element)return void this.tree.rerender();const t=this.getDataNode(e);this.tree.rerender(t)}getNode(e=this.root.element){const t=this.getDataNode(e),i=this.tree.getNode(t===this.root?null:t);return this.nodeMapper.map(i)}collapse(e,t=!1){const i=this.getDataNode(e);return this.tree.collapse(i===this.root?null:i,t)}expand(e,t=!1){return m(this,void 0,void 0,(function*(){if(void 0===this.root.element)throw new a.TreeError(this.user,"Tree input not set");this.root.refreshPromise&&(yield this.root.refreshPromise,yield u.Event.toPromise(this._onDidRender.event));const i=this.getDataNode(e);if(this.tree.hasElement(i)&&!this.tree.isCollapsible(i))return!1;if(i.refreshPromise&&(yield this.root.refreshPromise,yield u.Event.toPromise(this._onDidRender.event)),i!==this.root&&!i.refreshPromise&&!this.tree.isCollapsed(i))return!1;const n=this.tree.expand(i===this.root?null:i,t);return i.refreshPromise&&(yield this.root.refreshPromise,yield u.Event.toPromise(this._onDidRender.event)),n}))}setSelection(e,t){const i=e.map((e=>this.getDataNode(e)));this.tree.setSelection(i,t)}getSelection(){return this.tree.getSelection().map((e=>e.element))}setFocus(e,t){const i=e.map((e=>this.getDataNode(e)));this.tree.setFocus(i,t)}getFocus(){return this.tree.getFocus().map((e=>e.element))}reveal(e,t){this.tree.reveal(this.getDataNode(e),t)}getParentElement(e){const t=this.tree.getParentElement(this.getDataNode(e));return t&&t.element}getFirstElementChild(e=this.root.element){const t=this.getDataNode(e),i=this.tree.getFirstElementChild(t===this.root?null:t);return i&&i.element}getDataNode(e){const t=this.nodes.get(e===this.root.element?null:e);if(!t)throw new a.TreeError(this.user,`Data tree node not found: ${e}`);return t}refreshAndRenderNode(e,t,i,n){return m(this,void 0,void 0,(function*(){yield this.refreshNode(e,t,i),this.render(e,i,n)}))}refreshNode(e,t,i){return m(this,void 0,void 0,(function*(){let n;if(this.subTreeRefreshPromises.forEach(((o,r)=>{!n&&function(e,t){return e===t||b(e,t)||b(t,e)}(r,e)&&(n=o.then((()=>this.refreshNode(e,t,i))))})),n)return n;if(e!==this.root){if(this.tree.getNode(e).collapsed)return e.hasChildren=!!this.dataSource.hasChildren(e.element),void(e.stale=!0)}return this.doRefreshSubTree(e,t,i)}))}doRefreshSubTree(e,t,i){return m(this,void 0,void 0,(function*(){let n;e.refreshPromise=new Promise((e=>n=e)),this.subTreeRefreshPromises.set(e,e.refreshPromise),e.refreshPromise.finally((()=>{e.refreshPromise=void 0,this.subTreeRefreshPromises.delete(e)}));try{const o=yield this.doRefreshNode(e,t,i);e.stale=!1,yield l.Promises.settled(o.map((e=>this.doRefreshSubTree(e,t,i))))}finally{n()}}))}doRefreshNode(e,t,i){return m(this,void 0,void 0,(function*(){let n;if(e.hasChildren=!!this.dataSource.hasChildren(e.element),e.hasChildren){const t=this.doGetChildren(e);if((0,p.isIterable)(t))n=Promise.resolve(t);else{const i=(0,l.timeout)(800);i.then((()=>{e.slow=!0,this._onDidChangeNodeSlowState.fire(e)}),(e=>null)),n=t.finally((()=>i.cancel()))}}else n=Promise.resolve(h.Iterable.empty());try{const o=yield n;return this.setChildren(e,o,t,i)}catch(t){if(e!==this.root&&this.tree.hasElement(e)&&this.tree.collapse(e),(0,d.isCancellationError)(t))return[];throw t}finally{e.slow&&(e.slow=!1,this._onDidChangeNodeSlowState.fire(e))}}))}doGetChildren(e){let t=this.refreshPromises.get(e);if(t)return t;const i=this.dataSource.getChildren(e.element);return(0,p.isIterable)(i)?this.processChildren(i):(t=(0,l.createCancelablePromise)((()=>m(this,void 0,void 0,(function*(){return this.processChildren(yield i)})))),this.refreshPromises.set(e,t),t.finally((()=>{this.refreshPromises.delete(e)})))}_onDidChangeCollapseState({node:e,deep:t}){null!==e.element&&!e.collapsed&&e.element.stale&&(t?this.collapse(e.element.element):this.refreshAndRenderNode(e.element,!1).catch(d.onUnexpectedError))}setChildren(e,t,i,n){const o=[...t];if(0===e.children.length&&0===o.length)return[];const r=new Map,s=new Map;for(const t of e.children)if(r.set(t.element,t),this.identityProvider){const e=this.tree.isCollapsed(t);s.set(t.id,{node:t,collapsed:e})}const a=[],l=o.map((t=>{const o=!!this.dataSource.hasChildren(t);if(!this.identityProvider){const i=f({element:t,parent:e,hasChildren:o});return o&&this.collapseByDefault&&!this.collapseByDefault(t)&&(i.collapsedByDefault=!1,a.push(i)),i}const l=this.identityProvider.getId(t).toString(),c=s.get(l);if(c){const e=c.node;return r.delete(e.element),this.nodes.delete(e.element),this.nodes.set(t,e),e.element=t,e.hasChildren=o,i?c.collapsed?(e.children.forEach((e=>E(e,(e=>this.nodes.delete(e.element))))),e.children.splice(0,e.children.length),e.stale=!0):a.push(e):o&&this.collapseByDefault&&!this.collapseByDefault(t)&&(e.collapsedByDefault=!1,a.push(e)),e}const d=f({element:t,parent:e,id:l,hasChildren:o});return n&&n.viewState.focus&&n.viewState.focus.indexOf(l)>-1&&n.focus.push(d),n&&n.viewState.selection&&n.viewState.selection.indexOf(l)>-1&&n.selection.push(d),n&&n.viewState.expanded&&n.viewState.expanded.indexOf(l)>-1?a.push(d):o&&this.collapseByDefault&&!this.collapseByDefault(t)&&(d.collapsedByDefault=!1,a.push(d)),d}));for(const e of r.values())E(e,(e=>this.nodes.delete(e.element)));for(const e of l)this.nodes.set(e.element,e);return e.children.splice(0,e.children.length,...l),e!==this.root&&this.autoExpandSingleChildren&&1===l.length&&0===a.length&&(l[0].collapsedByDefault=!1,a.push(l[0])),a}render(e,t,i){const n=e.children.map((e=>this.asTreeElement(e,t))),o=i&&Object.assign(Object.assign({},i),{diffIdentityProvider:i.diffIdentityProvider&&{getId(e){return i.diffIdentityProvider.getId(e.element)}}});this.tree.setChildren(e===this.root?null:e,n,o),e!==this.root&&this.tree.setCollapsible(e,e.hasChildren),this._onDidRender.fire()}asTreeElement(e,t){if(e.stale)return{element:e,collapsible:e.hasChildren,collapsed:!0};let i;return i=!(t&&t.viewState.expanded&&e.id&&t.viewState.expanded.indexOf(e.id)>-1)&&e.collapsedByDefault,e.collapsedByDefault=void 0,{element:e,children:e.hasChildren?h.Iterable.map(e.children,(e=>this.asTreeElement(e,t))):[],collapsible:e.hasChildren,collapsed:i}}processChildren(e){return this.sorter&&(e=[...e].sort(this.sorter.compare.bind(this.sorter))),e}dispose(){this.disposables.dispose()}}class I{constructor(e){this.node=e}get element(){return{elements:this.node.element.elements.map((e=>e.element)),incompressible:this.node.element.incompressible}}get children(){return this.node.children.map((e=>new I(e)))}get depth(){return this.node.depth}get visibleChildrenCount(){return this.node.visibleChildrenCount}get visibleChildIndex(){return this.node.visibleChildIndex}get collapsible(){return this.node.collapsible}get collapsed(){return this.node.collapsed}get visible(){return this.node.visible}get filterData(){return this.node.filterData}}class D{constructor(e,t,i,n){this.renderer=e,this.nodeMapper=t,this.compressibleNodeMapperProvider=i,this.onDidChangeTwistieState=n,this.renderedNodes=new Map,this.disposables=[],this.templateId=e.templateId}renderTemplate(e){return{templateData:this.renderer.renderTemplate(e)}}renderElement(e,t,i,n){this.renderer.renderElement(this.nodeMapper.map(e),t,i.templateData,n)}renderCompressedElements(e,t,i,n){this.renderer.renderCompressedElements(this.compressibleNodeMapperProvider().map(e),t,i.templateData,n)}renderTwistie(e,t){return e.slow?(t.classList.add(...c.Codicon.treeItemLoading.classNamesArray),!0):(t.classList.remove(...c.Codicon.treeItemLoading.classNamesArray),!1)}disposeElement(e,t,i,n){var o,r;null===(r=(o=this.renderer).disposeElement)||void 0===r||r.call(o,this.nodeMapper.map(e),t,i.templateData,n)}disposeCompressedElements(e,t,i,n){var o,r;null===(r=(o=this.renderer).disposeCompressedElements)||void 0===r||r.call(o,this.compressibleNodeMapperProvider().map(e),t,i.templateData,n)}disposeTemplate(e){this.renderer.disposeTemplate(e.templateData)}dispose(){this.renderedNodes.clear(),this.disposables=(0,g.dispose)(this.disposables)}}class L extends k{constructor(e,t,i,n,o,r,s={}){super(e,t,i,o,r,s),this.compressionDelegate=n,this.compressibleNodeMapper=new a.WeakMapper((e=>new I(e))),this.filter=s.filter}createTree(e,t,i,n,r){const a=new o.ComposedTreeDelegate(i),l=n.map((e=>new D(e,this.nodeMapper,(()=>this.compressibleNodeMapper),this._onDidChangeNodeSlowState.event))),c=function(e){const t=e&&x(e);return t&&Object.assign(Object.assign({},t),{keyboardNavigationLabelProvider:t.keyboardNavigationLabelProvider&&Object.assign(Object.assign({},t.keyboardNavigationLabelProvider),{getCompressedNodeKeyboardNavigationLabel(t){return e.keyboardNavigationLabelProvider.getCompressedNodeKeyboardNavigationLabel(t.map((e=>e.element)))}})})}(r)||{};return new s.CompressibleObjectTree(e,t,a,l,c)}asTreeElement(e,t){return Object.assign({incompressible:this.compressionDelegate.isIncompressible(e.element)},super.asTreeElement(e,t))}updateOptions(e={}){this.tree.updateOptions(e)}render(e,t){if(!this.identityProvider)return super.render(e,t);const i=e=>this.identityProvider.getId(e).toString(),n=e=>{const t=new Set;for(const n of e){const e=this.tree.getCompressedTreeNode(n===this.root?null:n);if(e.element)for(const n of e.element.elements)t.add(i(n.element))}return t},o=n(this.tree.getSelection()),r=n(this.tree.getFocus());super.render(e,t);const s=this.getSelection();let a=!1;const l=this.getFocus();let c=!1;const d=e=>{const t=e.element;if(t)for(let e=0;e<t.elements.length;e++){const n=i(t.elements[e].element),d=t.elements[t.elements.length-1].element;o.has(n)&&-1===s.indexOf(d)&&(s.push(d),a=!0),r.has(n)&&-1===l.indexOf(d)&&(l.push(d),c=!0)}e.children.forEach(d)};d(this.tree.getCompressedTreeNode(e===this.root?null:e)),a&&this.setSelection(s),c&&this.setFocus(l)}processChildren(e){return this.filter&&(e=h.Iterable.filter(e,(e=>{const t=this.filter.filter(e,1),i="boolean"==typeof(n=t)?n?1:0:(0,r.isFilterResult)(n)?(0,r.getVisibleState)(n.visibility):(0,r.getVisibleState)(n);var n;if(2===i)throw new Error("Recursive tree visibility not supported in async data compressed trees");return 1===i}))),super.processChildren(e)}}},41605:function(e,t,i){"use strict";i.r(t),i.d(t,{CompressedObjectTreeModel:function(){return h},CompressibleObjectTreeModel:function(){return m},DefaultElementMapper:function(){return g},compress:function(){return l},decompress:function(){return d}});var n=i(63735),o=i(23877),r=i(63801),s=i(24417);function a(e){return{element:{elements:[e.element],incompressible:e.incompressible||!1},children:s.Iterable.map(s.Iterable.from(e.children),a),collapsible:e.collapsible,collapsed:e.collapsed}}function l(e){const t=[e.element],i=e.incompressible||!1;let n,o;for(;[o,n]=s.Iterable.consume(s.Iterable.from(e.children),2),1===o.length&&!o[0].incompressible;)e=o[0],t.push(e.element);return{element:{elements:t,incompressible:i},children:s.Iterable.map(s.Iterable.concat(o,n),l),collapsible:e.collapsible,collapsed:e.collapsed}}function c(e,t=0){let i;return i=t<e.element.elements.length-1?[c(e,t+1)]:s.Iterable.map(s.Iterable.from(e.children),(e=>c(e,0))),0===t&&e.element.incompressible?{element:e.element.elements[t],children:i,incompressible:!0,collapsible:e.collapsible,collapsed:e.collapsed}:{element:e.element.elements[t],children:i,collapsible:e.collapsible,collapsed:e.collapsed}}function d(e){return c(e,0)}function u(e,t,i){return e.element===t?Object.assign(Object.assign({},e),{children:i}):Object.assign(Object.assign({},e),{children:s.Iterable.map(s.Iterable.from(e.children),(e=>u(e,t,i)))})}class h{constructor(e,t,i={}){this.user=e,this.rootRef=null,this.nodes=new Map,this.model=new n.ObjectTreeModel(e,t,i),this.enabled=void 0===i.compressionEnabled||i.compressionEnabled,this.identityProvider=i.identityProvider}get onDidSplice(){return this.model.onDidSplice}get onDidChangeCollapseState(){return this.model.onDidChangeCollapseState}get onDidChangeRenderNodeCount(){return this.model.onDidChangeRenderNodeCount}setChildren(e,t=s.Iterable.empty(),i){const n=i.diffIdentityProvider&&(o=i.diffIdentityProvider,{getId(e){return e.elements.map((e=>o.getId(e).toString())).join("\0")}});var o;if(null===e){const e=s.Iterable.map(t,this.enabled?l:a);return void this._setChildren(null,e,{diffIdentityProvider:n,diffDepth:1/0})}const r=this.nodes.get(e);if(!r)throw new Error("Unknown compressed tree node");const c=this.model.getNode(r),h=this.model.getParentNodeLocation(r),g=this.model.getNode(h),p=u(d(c),e,t),m=(this.enabled?l:a)(p),f=g.children.map((e=>e===c?m:e));this._setChildren(g.element,f,{diffIdentityProvider:n,diffDepth:c.depth-g.depth})}setCompressionEnabled(e){if(e===this.enabled)return;this.enabled=e;const t=this.model.getNode().children,i=s.Iterable.map(t,d),n=s.Iterable.map(i,e?l:a);this._setChildren(null,n,{diffIdentityProvider:this.identityProvider,diffDepth:1/0})}_setChildren(e,t,i){const n=new Set;this.model.setChildren(e,t,Object.assign(Object.assign({},i),{onDidCreateNode:e=>{for(const t of e.element.elements)n.add(t),this.nodes.set(t,e.element)},onDidDeleteNode:e=>{for(const t of e.element.elements)n.has(t)||this.nodes.delete(t)}}))}has(e){return this.nodes.has(e)}getListIndex(e){const t=this.getCompressedNode(e);return this.model.getListIndex(t)}getListRenderCount(e){const t=this.getCompressedNode(e);return this.model.getListRenderCount(t)}getNode(e){if(void 0===e)return this.model.getNode();const t=this.getCompressedNode(e);return this.model.getNode(t)}getNodeLocation(e){const t=this.model.getNodeLocation(e);return null===t?null:t.elements[t.elements.length-1]}getParentNodeLocation(e){const t=this.getCompressedNode(e),i=this.model.getParentNodeLocation(t);return null===i?null:i.elements[i.elements.length-1]}getFirstElementChild(e){const t=this.getCompressedNode(e);return this.model.getFirstElementChild(t)}isCollapsible(e){const t=this.getCompressedNode(e);return this.model.isCollapsible(t)}setCollapsible(e,t){const i=this.getCompressedNode(e);return this.model.setCollapsible(i,t)}isCollapsed(e){const t=this.getCompressedNode(e);return this.model.isCollapsed(t)}setCollapsed(e,t,i){const n=this.getCompressedNode(e);return this.model.setCollapsed(n,t,i)}expandTo(e){const t=this.getCompressedNode(e);this.model.expandTo(t)}rerender(e){const t=this.getCompressedNode(e);this.model.rerender(t)}refilter(){this.model.refilter()}getCompressedNode(e){if(null===e)return null;const t=this.nodes.get(e);if(!t)throw new o.TreeError(this.user,`Tree element not found: ${e}`);return t}}const g=e=>e[e.length-1];class p{constructor(e,t){this.unwrapper=e,this.node=t}get element(){return null===this.node.element?null:this.unwrapper(this.node.element)}get children(){return this.node.children.map((e=>new p(this.unwrapper,e)))}get depth(){return this.node.depth}get visibleChildrenCount(){return this.node.visibleChildrenCount}get visibleChildIndex(){return this.node.visibleChildIndex}get collapsible(){return this.node.collapsible}get collapsed(){return this.node.collapsed}get visible(){return this.node.visible}get filterData(){return this.node.filterData}}class m{constructor(e,t,i={}){this.rootRef=null,this.elementMapper=i.elementMapper||g;const n=e=>this.elementMapper(e.elements);this.nodeMapper=new o.WeakMapper((e=>new p(n,e))),this.model=new h(e,function(e,t){return{splice(i,n,o){t.splice(i,n,o.map((t=>e.map(t))))},updateElementHeight(e,i){t.updateElementHeight(e,i)}}}(this.nodeMapper,t),function(e,t){return Object.assign(Object.assign({},t),{identityProvider:t.identityProvider&&{getId(i){return t.identityProvider.getId(e(i))}},sorter:t.sorter&&{compare(e,i){return t.sorter.compare(e.elements[0],i.elements[0])}},filter:t.filter&&{filter(i,n){return t.filter.filter(e(i),n)}}})}(n,i))}get onDidSplice(){return r.Event.map(this.model.onDidSplice,(({insertedNodes:e,deletedNodes:t})=>({insertedNodes:e.map((e=>this.nodeMapper.map(e))),deletedNodes:t.map((e=>this.nodeMapper.map(e)))})))}get onDidChangeCollapseState(){return r.Event.map(this.model.onDidChangeCollapseState,(({node:e,deep:t})=>({node:this.nodeMapper.map(e),deep:t})))}get onDidChangeRenderNodeCount(){return r.Event.map(this.model.onDidChangeRenderNodeCount,(e=>this.nodeMapper.map(e)))}setChildren(e,t=s.Iterable.empty(),i={}){this.model.setChildren(e,t,i)}setCompressionEnabled(e){this.model.setCompressionEnabled(e)}has(e){return this.model.has(e)}getListIndex(e){return this.model.getListIndex(e)}getListRenderCount(e){return this.model.getListRenderCount(e)}getNode(e){return this.nodeMapper.map(this.model.getNode(e))}getNodeLocation(e){return e.element}getParentNodeLocation(e){return this.model.getParentNodeLocation(e)}getFirstElementChild(e){const t=this.model.getFirstElementChild(e);return null==t?t:this.elementMapper(t.elements)}isCollapsible(e){return this.model.isCollapsible(e)}setCollapsible(e,t){return this.model.setCollapsible(e,t)}isCollapsed(e){return this.model.isCollapsed(e)}setCollapsed(e,t,i){return this.model.setCollapsed(e,t,i)}expandTo(e){return this.model.expandTo(e)}rerender(e){return this.model.rerender(e)}refilter(){return this.model.refilter()}getCompressedTreeNode(e=null){return this.model.getNode(e)}}},35313:function(e,t,i){"use strict";i.r(t),i.d(t,{DataTree:function(){return r}});var n=i(72665),o=i(63735);class r extends n.AbstractTree{constructor(e,t,i,n,o,r={}){super(e,t,i,n,r),this.user=e,this.dataSource=o,this.identityProvider=r.identityProvider}createModel(e,t,i){return new o.ObjectTreeModel(e,t,i)}}},49517:function(e,t,i){"use strict";i.r(t),i.d(t,{IndexTreeModel:function(){return h},getVisibleState:function(){return d},isFilterResult:function(){return c}});var n=i(23877),o=i(64998),r=i(66129),s=i(11914),a=i(63801),l=i(24417);function c(e){return"object"==typeof e&&"visibility"in e&&"data"in e}function d(e){switch(e){case!0:return 1;case!1:return 0;default:return e}}function u(e){return"boolean"==typeof e.collapsible}class h{constructor(e,t,i,n={}){this.user=e,this.list=t,this.rootRef=[],this.eventBufferer=new a.EventBufferer,this._onDidChangeCollapseState=new a.Emitter,this.onDidChangeCollapseState=this.eventBufferer.wrapEvent(this._onDidChangeCollapseState.event),this._onDidChangeRenderNodeCount=new a.Emitter,this.onDidChangeRenderNodeCount=this.eventBufferer.wrapEvent(this._onDidChangeRenderNodeCount.event),this._onDidSplice=new a.Emitter,this.onDidSplice=this._onDidSplice.event,this.refilterDelayer=new r.Delayer(r.MicrotaskDelay),this.collapseByDefault=void 0!==n.collapseByDefault&&n.collapseByDefault,this.filter=n.filter,this.autoExpandSingleChildren=void 0!==n.autoExpandSingleChildren&&n.autoExpandSingleChildren,this.root={parent:void 0,element:i,children:[],depth:0,visibleChildrenCount:0,visibleChildIndex:-1,collapsible:!1,collapsed:!1,renderNodeCount:0,visibility:1,visible:!0,filterData:void 0}}splice(e,t,i=l.Iterable.empty(),o={}){if(0===e.length)throw new n.TreeError(this.user,"Invalid tree location");o.diffIdentityProvider?this.spliceSmart(o.diffIdentityProvider,e,t,i,o):this.spliceSimple(e,t,i,o)}spliceSmart(e,t,i,n,o,r){var a;void 0===n&&(n=l.Iterable.empty()),void 0===r&&(r=null!==(a=o.diffDepth)&&void 0!==a?a:0);const{parentNode:c}=this.getParentNodeWithListIndex(t);if(!c.lastDiffIds)return this.spliceSimple(t,i,n,o);const d=[...n],u=t[t.length-1],h=new s.LcsDiff({getElements:()=>c.lastDiffIds},{getElements:()=>[...c.children.slice(0,u),...d,...c.children.slice(u+i)].map((t=>e.getId(t.element).toString()))}).ComputeDiff(!1);if(h.quitEarly)return c.lastDiffIds=void 0,this.spliceSimple(t,i,d,o);const g=t.slice(0,-1),p=(t,i,n)=>{if(r>0)for(let s=0;s<n;s++)t--,i--,this.spliceSmart(e,[...g,t,0],Number.MAX_SAFE_INTEGER,d[i].children,o,r-1)};let m=Math.min(c.children.length,u+i),f=d.length;for(const e of h.changes.sort(((e,t)=>t.originalStart-e.originalStart)))p(m,f,m-(e.originalStart+e.originalLength)),m=e.originalStart,f=e.modifiedStart-u,this.spliceSimple([...g,m],e.originalLength,l.Iterable.slice(d,f,f+e.modifiedLength),o);p(m,f,m)}spliceSimple(e,t,i=l.Iterable.empty(),{onDidCreateNode:n,onDidDeleteNode:r,diffIdentityProvider:s}){const{parentNode:a,listIndex:c,revealed:d,visible:u}=this.getParentNodeWithListIndex(e),h=[],g=l.Iterable.map(i,(e=>this.createTreeNode(e,a,a.visible?1:0,d,h,n))),p=e[e.length-1],m=a.children.length>0;let f=0;for(let e=p;e>=0&&e<a.children.length;e--){const t=a.children[e];if(t.visible){f=t.visibleChildIndex;break}}const b=[];let _=0,A=0;for(const e of g)b.push(e),A+=e.renderNodeCount,e.visible&&(e.visibleChildIndex=f+_++);const v=(0,o.splice)(a.children,p,t,b);s?a.lastDiffIds?(0,o.splice)(a.lastDiffIds,p,t,b.map((e=>s.getId(e.element).toString()))):a.lastDiffIds=a.children.map((e=>s.getId(e.element).toString())):a.lastDiffIds=void 0;let C=0;for(const e of v)e.visible&&C++;if(0!==C)for(let e=p+b.length;e<a.children.length;e++){const t=a.children[e];t.visible&&(t.visibleChildIndex-=C)}if(a.visibleChildrenCount+=_-C,d&&u){const e=v.reduce(((e,t)=>e+(t.visible?t.renderNodeCount:0)),0);this._updateAncestorsRenderNodeCount(a,A-e),this.list.splice(c,e,h)}if(v.length>0&&r){const e=t=>{r(t),t.children.forEach(e)};v.forEach(e)}this._onDidSplice.fire({insertedNodes:b,deletedNodes:v});const w=a.children.length>0;m!==w&&this.setCollapsible(e.slice(0,-1),w);let y=a;for(;y;){if(2===y.visibility){this.refilterDelayer.trigger((()=>this.refilter()));break}y=y.parent}}rerender(e){if(0===e.length)throw new n.TreeError(this.user,"Invalid tree location");const{node:t,listIndex:i,revealed:o}=this.getTreeNodeWithListIndex(e);t.visible&&o&&this.list.splice(i,1,[t])}has(e){return this.hasTreeNode(e)}getListIndex(e){const{listIndex:t,visible:i,revealed:n}=this.getTreeNodeWithListIndex(e);return i&&n?t:-1}getListRenderCount(e){return this.getTreeNode(e).renderNodeCount}isCollapsible(e){return this.getTreeNode(e).collapsible}setCollapsible(e,t){const i=this.getTreeNode(e);void 0===t&&(t=!i.collapsible);const n={collapsible:t};return this.eventBufferer.bufferEvents((()=>this._setCollapseState(e,n)))}isCollapsed(e){return this.getTreeNode(e).collapsed}setCollapsed(e,t,i){const n=this.getTreeNode(e);void 0===t&&(t=!n.collapsed);const o={collapsed:t,recursive:i||!1};return this.eventBufferer.bufferEvents((()=>this._setCollapseState(e,o)))}_setCollapseState(e,t){const{node:i,listIndex:n,revealed:o}=this.getTreeNodeWithListIndex(e),r=this._setListNodeCollapseState(i,n,o,t);if(i!==this.root&&this.autoExpandSingleChildren&&r&&!u(t)&&i.collapsible&&!i.collapsed&&!t.recursive){let n=-1;for(let e=0;e<i.children.length;e++){if(i.children[e].visible){if(n>-1){n=-1;break}n=e}}n>-1&&this._setCollapseState([...e,n],t)}return r}_setListNodeCollapseState(e,t,i,n){const o=this._setNodeCollapseState(e,n,!1);if(!i||!e.visible||!o)return o;const r=e.renderNodeCount,s=this.updateNodeAfterCollapseChange(e),a=r-(-1===t?0:1);return this.list.splice(t+1,a,s.slice(1)),o}_setNodeCollapseState(e,t,i){let n;if(e===this.root?n=!1:(u(t)?(n=e.collapsible!==t.collapsible,e.collapsible=t.collapsible):e.collapsible?(n=e.collapsed!==t.collapsed,e.collapsed=t.collapsed):n=!1,n&&this._onDidChangeCollapseState.fire({node:e,deep:i})),!u(t)&&t.recursive)for(const i of e.children)n=this._setNodeCollapseState(i,t,!0)||n;return n}expandTo(e){this.eventBufferer.bufferEvents((()=>{let t=this.getTreeNode(e);for(;t.parent;)t=t.parent,e=e.slice(0,e.length-1),t.collapsed&&this._setCollapseState(e,{collapsed:!1,recursive:!1})}))}refilter(){const e=this.root.renderNodeCount,t=this.updateNodeAfterFilterChange(this.root);this.list.splice(0,e,t),this.refilterDelayer.cancel()}createTreeNode(e,t,i,n,o,r){const s={parent:t,element:e.element,children:[],depth:t.depth+1,visibleChildrenCount:0,visibleChildIndex:-1,collapsible:"boolean"==typeof e.collapsible?e.collapsible:void 0!==e.collapsed,collapsed:void 0===e.collapsed?this.collapseByDefault:e.collapsed,renderNodeCount:1,visibility:1,visible:!0,filterData:void 0},a=this._filterNode(s,i);s.visibility=a,n&&o.push(s);const c=e.children||l.Iterable.empty(),d=n&&0!==a&&!s.collapsed,u=l.Iterable.map(c,(e=>this.createTreeNode(e,s,a,d,o,r)));let h=0,g=1;for(const e of u)s.children.push(e),g+=e.renderNodeCount,e.visible&&(e.visibleChildIndex=h++);return s.collapsible=s.collapsible||s.children.length>0,s.visibleChildrenCount=h,s.visible=2===a?h>0:1===a,s.visible?s.collapsed||(s.renderNodeCount=g):(s.renderNodeCount=0,n&&o.pop()),null==r||r(s),s}updateNodeAfterCollapseChange(e){const t=e.renderNodeCount,i=[];return this._updateNodeAfterCollapseChange(e,i),this._updateAncestorsRenderNodeCount(e.parent,i.length-t),i}_updateNodeAfterCollapseChange(e,t){if(!1===e.visible)return 0;if(t.push(e),e.renderNodeCount=1,!e.collapsed)for(const i of e.children)e.renderNodeCount+=this._updateNodeAfterCollapseChange(i,t);return this._onDidChangeRenderNodeCount.fire(e),e.renderNodeCount}updateNodeAfterFilterChange(e){const t=e.renderNodeCount,i=[];return this._updateNodeAfterFilterChange(e,e.visible?1:0,i),this._updateAncestorsRenderNodeCount(e.parent,i.length-t),i}_updateNodeAfterFilterChange(e,t,i,n=!0){let o;if(e!==this.root){if(o=this._filterNode(e,t),0===o)return e.visible=!1,e.renderNodeCount=0,!1;n&&i.push(e)}const r=i.length;e.renderNodeCount=e===this.root?0:1;let s=!1;if(e.collapsed&&0===o)e.visibleChildrenCount=0;else{let t=0;for(const r of e.children)s=this._updateNodeAfterFilterChange(r,o,i,n&&!e.collapsed)||s,r.visible&&(r.visibleChildIndex=t++);e.visibleChildrenCount=t}return e!==this.root&&(e.visible=2===o?s:1===o,e.visibility=o),e.visible?e.collapsed||(e.renderNodeCount+=i.length-r):(e.renderNodeCount=0,n&&i.pop()),this._onDidChangeRenderNodeCount.fire(e),e.visible}_updateAncestorsRenderNodeCount(e,t){if(0!==t)for(;e;)e.renderNodeCount+=t,this._onDidChangeRenderNodeCount.fire(e),e=e.parent}_filterNode(e,t){const i=this.filter?this.filter.filter(e.element,t):1;return"boolean"==typeof i?(e.filterData=void 0,i?1:0):c(i)?(e.filterData=i.data,d(i.visibility)):(e.filterData=void 0,d(i))}hasTreeNode(e,t=this.root){if(!e||0===e.length)return!0;const[i,...n]=e;return!(i<0||i>t.children.length)&&this.hasTreeNode(n,t.children[i])}getTreeNode(e,t=this.root){if(!e||0===e.length)return t;const[i,...o]=e;if(i<0||i>t.children.length)throw new n.TreeError(this.user,"Invalid tree location");return this.getTreeNode(o,t.children[i])}getTreeNodeWithListIndex(e){if(0===e.length)return{node:this.root,listIndex:-1,revealed:!0,visible:!1};const{parentNode:t,listIndex:i,revealed:o,visible:r}=this.getParentNodeWithListIndex(e),s=e[e.length-1];if(s<0||s>t.children.length)throw new n.TreeError(this.user,"Invalid tree location");const a=t.children[s];return{node:a,listIndex:i,revealed:o,visible:r&&a.visible}}getParentNodeWithListIndex(e,t=this.root,i=0,o=!0,r=!0){const[s,...a]=e;if(s<0||s>t.children.length)throw new n.TreeError(this.user,"Invalid tree location");for(let e=0;e<s;e++)i+=t.children[e].renderNodeCount;return o=o&&!t.collapsed,r=r&&t.visible,0===a.length?{parentNode:t,listIndex:i,revealed:o,visible:r}:this.getParentNodeWithListIndex(a,t.children[s],i+1,o,r)}getNode(e=[]){return this.getTreeNode(e)}getNodeLocation(e){const t=[];let i=e;for(;i.parent;)t.push(i.parent.children.indexOf(i)),i=i.parent;return t.reverse()}getParentNodeLocation(e){return 0===e.length?void 0:1===e.length?[]:(0,o.tail2)(e)[0]}getFirstElementChild(e){const t=this.getTreeNode(e);if(0!==t.children.length)return t.children[0].element}}},22481:function(e,t,i){"use strict";i.r(t),i.d(t,{CompressibleObjectTree:function(){return u},ObjectTree:function(){return c}});var n=i(72665),o=i(41605),r=i(63735),s=i(63966),a=i(24417),l=function(e,t,i,n){var o,r=arguments.length,s=r<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,i):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)s=Reflect.decorate(e,t,i,n);else for(var a=e.length-1;a>=0;a--)(o=e[a])&&(s=(r<3?o(s):r>3?o(t,i,s):o(t,i))||s);return r>3&&s&&Object.defineProperty(t,i,s),s};class c extends n.AbstractTree{constructor(e,t,i,n,o={}){super(e,t,i,n,o),this.user=e}get onDidChangeCollapseState(){return this.model.onDidChangeCollapseState}setChildren(e,t=a.Iterable.empty(),i){this.model.setChildren(e,t,i)}rerender(e){void 0!==e?this.model.rerender(e):this.view.rerender()}hasElement(e){return this.model.has(e)}createModel(e,t,i){return new r.ObjectTreeModel(e,t,i)}}class d{constructor(e,t){this._compressedTreeNodeProvider=e,this.renderer=t,this.templateId=t.templateId,t.onDidChangeTwistieState&&(this.onDidChangeTwistieState=t.onDidChangeTwistieState)}get compressedTreeNodeProvider(){return this._compressedTreeNodeProvider()}renderTemplate(e){return{compressedTreeNode:void 0,data:this.renderer.renderTemplate(e)}}renderElement(e,t,i,n){const o=this.compressedTreeNodeProvider.getCompressedTreeNode(e.element);1===o.element.elements.length?(i.compressedTreeNode=void 0,this.renderer.renderElement(e,t,i.data,n)):(i.compressedTreeNode=o,this.renderer.renderCompressedElements(o,t,i.data,n))}disposeElement(e,t,i,n){var o,r,s,a;i.compressedTreeNode?null===(r=(o=this.renderer).disposeCompressedElements)||void 0===r||r.call(o,i.compressedTreeNode,t,i.data,n):null===(a=(s=this.renderer).disposeElement)||void 0===a||a.call(s,e,t,i.data,n)}disposeTemplate(e){this.renderer.disposeTemplate(e.data)}renderTwistie(e,t){return!!this.renderer.renderTwistie&&this.renderer.renderTwistie(e,t)}}l([s.memoize],d.prototype,"compressedTreeNodeProvider",null);class u extends c{constructor(e,t,i,n,o={}){const r=()=>this;super(e,t,i,n.map((e=>new d(r,e))),function(e,t){return t&&Object.assign(Object.assign({},t),{keyboardNavigationLabelProvider:t.keyboardNavigationLabelProvider&&{getKeyboardNavigationLabel(i){let n;try{n=e().getCompressedTreeNode(i)}catch(e){return t.keyboardNavigationLabelProvider.getKeyboardNavigationLabel(i)}return 1===n.element.elements.length?t.keyboardNavigationLabelProvider.getKeyboardNavigationLabel(i):t.keyboardNavigationLabelProvider.getCompressedNodeKeyboardNavigationLabel(n.element.elements)}}})}(r,o))}setChildren(e,t=a.Iterable.empty(),i){this.model.setChildren(e,t,i)}createModel(e,t,i){return new o.CompressibleObjectTreeModel(e,t,i)}updateOptions(e={}){super.updateOptions(e),void 0!==e.compressionEnabled&&this.model.setCompressionEnabled(e.compressionEnabled)}getCompressedTreeNode(e=null){return this.model.getCompressedTreeNode(e)}}},63735:function(e,t,i){"use strict";i.r(t),i.d(t,{ObjectTreeModel:function(){return s}});var n=i(49517),o=i(23877),r=i(24417);class s{constructor(e,t,i={}){this.user=e,this.rootRef=null,this.nodes=new Map,this.nodesByIdentity=new Map,this.model=new n.IndexTreeModel(e,t,null,i),this.onDidSplice=this.model.onDidSplice,this.onDidChangeCollapseState=this.model.onDidChangeCollapseState,this.onDidChangeRenderNodeCount=this.model.onDidChangeRenderNodeCount,i.sorter&&(this.sorter={compare(e,t){return i.sorter.compare(e.element,t.element)}}),this.identityProvider=i.identityProvider}setChildren(e,t=r.Iterable.empty(),i={}){const n=this.getElementLocation(e);this._setChildren(n,this.preserveCollapseState(t),i)}_setChildren(e,t=r.Iterable.empty(),i){const n=new Set,o=new Set;this.model.splice([...e,0],Number.MAX_VALUE,t,Object.assign(Object.assign({},i),{onDidCreateNode:e=>{var t;if(null===e.element)return;const r=e;if(n.add(r.element),this.nodes.set(r.element,r),this.identityProvider){const e=this.identityProvider.getId(r.element).toString();o.add(e),this.nodesByIdentity.set(e,r)}null===(t=i.onDidCreateNode)||void 0===t||t.call(i,r)},onDidDeleteNode:e=>{var t;if(null===e.element)return;const r=e;if(n.has(r.element)||this.nodes.delete(r.element),this.identityProvider){const e=this.identityProvider.getId(r.element).toString();o.has(e)||this.nodesByIdentity.delete(e)}null===(t=i.onDidDeleteNode)||void 0===t||t.call(i,r)}}))}preserveCollapseState(e=r.Iterable.empty()){return this.sorter&&(e=[...e].sort(this.sorter.compare.bind(this.sorter))),r.Iterable.map(e,(e=>{let t=this.nodes.get(e.element);if(!t&&this.identityProvider){const i=this.identityProvider.getId(e.element).toString();t=this.nodesByIdentity.get(i)}if(!t)return Object.assign(Object.assign({},e),{children:this.preserveCollapseState(e.children)});const i="boolean"==typeof e.collapsible?e.collapsible:t.collapsible,n=void 0!==e.collapsed?e.collapsed:t.collapsed;return Object.assign(Object.assign({},e),{collapsible:i,collapsed:n,children:this.preserveCollapseState(e.children)})}))}rerender(e){const t=this.getElementLocation(e);this.model.rerender(t)}getFirstElementChild(e=null){const t=this.getElementLocation(e);return this.model.getFirstElementChild(t)}has(e){return this.nodes.has(e)}getListIndex(e){const t=this.getElementLocation(e);return this.model.getListIndex(t)}getListRenderCount(e){const t=this.getElementLocation(e);return this.model.getListRenderCount(t)}isCollapsible(e){const t=this.getElementLocation(e);return this.model.isCollapsible(t)}setCollapsible(e,t){const i=this.getElementLocation(e);return this.model.setCollapsible(i,t)}isCollapsed(e){const t=this.getElementLocation(e);return this.model.isCollapsed(t)}setCollapsed(e,t,i){const n=this.getElementLocation(e);return this.model.setCollapsed(n,t,i)}expandTo(e){const t=this.getElementLocation(e);this.model.expandTo(t)}refilter(){this.model.refilter()}getNode(e=null){if(null===e)return this.model.getNode(this.model.rootRef);const t=this.nodes.get(e);if(!t)throw new o.TreeError(this.user,`Tree element not found: ${e}`);return t}getNodeLocation(e){return e.element}getParentNodeLocation(e){if(null===e)throw new o.TreeError(this.user,"Invalid getParentNodeLocation call");const t=this.nodes.get(e);if(!t)throw new o.TreeError(this.user,`Tree element not found: ${e}`);const i=this.model.getNodeLocation(t),n=this.model.getParentNodeLocation(i);return this.model.getNode(n).element}getElementLocation(e){if(null===e)return[];const t=this.nodes.get(e);if(!t)throw new o.TreeError(this.user,`Tree element not found: ${e}`);return this.model.getNodeLocation(t)}}},23877:function(e,t,i){"use strict";var n;i.r(t),i.d(t,{TreeError:function(){return o},TreeMouseEventTarget:function(){return n},WeakMapper:function(){return r}}),function(e){e[e.Unknown=0]="Unknown",e[e.Twistie=1]="Twistie",e[e.Element=2]="Element",e[e.Filter=3]="Filter"}(n||(n={}));class o extends Error{constructor(e,t){super(`TreeError [${e}] ${t}`)}}class r{constructor(e){this.fn=e,this._map=new WeakMap}map(e){let t=this._map.get(e);return t||(t=this.fn(e),this._map.set(e,t)),t}}},47257:function(e,t,i){"use strict";i.r(t),i.d(t,{Widget:function(){return l}});var n=i(96747),o=i(8769),r=i(5642),s=i(4043),a=i(68921);class l extends a.Disposable{onclick(e,t){this._register(n.addDisposableListener(e,n.EventType.CLICK,(e=>t(new r.StandardMouseEvent(e)))))}onmousedown(e,t){this._register(n.addDisposableListener(e,n.EventType.MOUSE_DOWN,(e=>t(new r.StandardMouseEvent(e)))))}onmouseover(e,t){this._register(n.addDisposableListener(e,n.EventType.MOUSE_OVER,(e=>t(new r.StandardMouseEvent(e)))))}onmouseleave(e,t){this._register(n.addDisposableListener(e,n.EventType.MOUSE_LEAVE,(e=>t(new r.StandardMouseEvent(e)))))}onkeydown(e,t){this._register(n.addDisposableListener(e,n.EventType.KEY_DOWN,(e=>t(new o.StandardKeyboardEvent(e)))))}onkeyup(e,t){this._register(n.addDisposableListener(e,n.EventType.KEY_UP,(e=>t(new o.StandardKeyboardEvent(e)))))}oninput(e,t){this._register(n.addDisposableListener(e,n.EventType.INPUT,t))}onblur(e,t){this._register(n.addDisposableListener(e,n.EventType.BLUR,t))}onfocus(e,t){this._register(n.addDisposableListener(e,n.EventType.FOCUS,t))}ignoreGesture(e){s.Gesture.ignoreTarget(e)}}},60969:function(e,t,i){"use strict";i.r(t),i.d(t,{Action:function(){return a},ActionRunner:function(){return l},EmptySubmenuAction:function(){return u},Separator:function(){return c},SubmenuAction:function(){return d},toAction:function(){return h}});var n=i(63801),o=i(68921),r=i(83787),s=function(e,t,i,n){return new(i||(i=Promise))((function(o,r){function s(e){try{l(n.next(e))}catch(e){r(e)}}function a(e){try{l(n.throw(e))}catch(e){r(e)}}function l(e){var t;e.done?o(e.value):(t=e.value,t instanceof i?t:new i((function(e){e(t)}))).then(s,a)}l((n=n.apply(e,t||[])).next())}))};class a extends o.Disposable{constructor(e,t="",i="",o=!0,r){super(),this._onDidChange=this._register(new n.Emitter),this.onDidChange=this._onDidChange.event,this._enabled=!0,this._id=e,this._label=t,this._cssClass=i,this._enabled=o,this._actionCallback=r}get id(){return this._id}get label(){return this._label}set label(e){this._setLabel(e)}_setLabel(e){this._label!==e&&(this._label=e,this._onDidChange.fire({label:e}))}get tooltip(){return this._tooltip||""}set tooltip(e){this._setTooltip(e)}_setTooltip(e){this._tooltip!==e&&(this._tooltip=e,this._onDidChange.fire({tooltip:e}))}get class(){return this._cssClass}set class(e){this._setClass(e)}_setClass(e){this._cssClass!==e&&(this._cssClass=e,this._onDidChange.fire({class:e}))}get enabled(){return this._enabled}set enabled(e){this._setEnabled(e)}_setEnabled(e){this._enabled!==e&&(this._enabled=e,this._onDidChange.fire({enabled:e}))}get checked(){return this._checked}set checked(e){this._setChecked(e)}_setChecked(e){this._checked!==e&&(this._checked=e,this._onDidChange.fire({checked:e}))}run(e,t){return s(this,void 0,void 0,(function*(){this._actionCallback&&(yield this._actionCallback(e))}))}}class l extends o.Disposable{constructor(){super(...arguments),this._onBeforeRun=this._register(new n.Emitter),this.onBeforeRun=this._onBeforeRun.event,this._onDidRun=this._register(new n.Emitter),this.onDidRun=this._onDidRun.event}run(e,t){return s(this,void 0,void 0,(function*(){if(!e.enabled)return;let i;this._onBeforeRun.fire({action:e});try{yield this.runAction(e,t)}catch(e){i=e}this._onDidRun.fire({action:e,error:i})}))}runAction(e,t){return s(this,void 0,void 0,(function*(){yield e.run(t)}))}}class c extends a{constructor(e){super(c.ID,e,e?"separator text":"separator"),this.checked=!1,this.enabled=!1}}c.ID="vs.actions.separator";class d{constructor(e,t,i,n){this.tooltip="",this.enabled=!0,this.checked=void 0,this.id=e,this.label=t,this.class=n,this._actions=i}get actions(){return this._actions}dispose(){}run(){return s(this,void 0,void 0,(function*(){}))}}class u extends a{constructor(){super(u.ID,r.localize("vs/base/common/actions","submenu.empty","(empty)"),void 0,!1)}}function h(e){var t,i;return{id:e.id,label:e.label,class:void 0,enabled:null===(t=e.enabled)||void 0===t||t,checked:null!==(i=e.checked)&&void 0!==i&&i,run:()=>s(this,void 0,void 0,(function*(){return e.run()})),tooltip:e.label,dispose:()=>{}}}u.ID="vs.actions.empty"},64998:function(e,t,i){"use strict";function n(e,t=0){return e[e.length-(1+t)]}function o(e){if(0===e.length)throw new Error("Invalid tail call");return[e.slice(0,e.length-1),e[e.length-1]]}function r(e,t,i=((e,t)=>e===t)){if(e===t)return!0;if(!e||!t)return!1;if(e.length!==t.length)return!1;for(let n=0,o=e.length;n<o;n++)if(!i(e[n],t[n]))return!1;return!0}function s(e,t){const i=e.length-1;t<i&&(e[t]=e[i]),e.pop()}function a(e,t,i){return l(e.length,(n=>i(e[n],t)))}function l(e,t){let i=0,n=e-1;for(;i<=n;){const e=(i+n)/2|0,o=t(e);if(o<0)i=e+1;else{if(!(o>0))return e;n=e-1}}return-(i+1)}function c(e,t){let i=0,n=e.length;if(0===n)return 0;for(;i<n;){const o=Math.floor((i+n)/2);t(e[o])?n=o:i=o+1}return i}function d(e,t,i){if((e|=0)>=t.length)throw new TypeError("invalid index");const n=t[Math.floor(t.length*Math.random())],o=[],r=[],s=[];for(const e of t){const t=i(e,n);t<0?o.push(e):t>0?r.push(e):s.push(e)}return e<o.length?d(e,o,i):e<o.length+s.length?s[0]:d(e-(o.length+s.length),r,i)}function u(e,t){const i=[];let n;for(const o of e.slice(0).sort(t))n&&0===t(n[0],o)?n.push(o):(n=[o],i.push(n));return i}function h(e){return e.filter((e=>!!e))}function g(e){return!Array.isArray(e)||0===e.length}function p(e){return Array.isArray(e)&&e.length>0}function m(e,t=(e=>e)){const i=new Set;return e.filter((e=>{const n=t(e);return!i.has(n)&&(i.add(n),!0)}))}function f(e,t){const i=b(e,t);if(-1!==i)return e[i]}function b(e,t){for(let i=e.length-1;i>=0;i--){if(t(e[i]))return i}return-1}function _(e,t){return e.length>0?e[0]:t}function A(e,t){let i="number"==typeof t?e:0;"number"==typeof t?i=e:(i=0,t=e);const n=[];if(i<=t)for(let e=i;e<t;e++)n.push(e);else for(let e=i;e>t;e--)n.push(e);return n}function v(e,t,i){const n=e.slice(0,t),o=e.slice(t);return n.concat(i,o)}function C(e,t){const i=e.indexOf(t);i>-1&&(e.splice(i,1),e.unshift(t))}function w(e,t){const i=e.indexOf(t);i>-1&&(e.splice(i,1),e.push(t))}function y(e,t){for(const i of t)e.push(i)}function S(e){return Array.isArray(e)?e:[e]}function x(e,t,i){const n=k(e,t),o=e.length,r=i.length;e.length=o+r;for(let t=o-1;t>=n;t--)e[t+r]=e[t];for(let t=0;t<r;t++)e[t+n]=i[t]}function E(e,t,i,n){const o=k(e,t),r=e.splice(o,i);return x(e,o,n),r}function k(e,t){return t<0?Math.max(t+e.length,0):Math.min(t,e.length)}var I;function D(e,t){return(i,n)=>t(e(i),e(n))}i.r(t),i.d(t,{ArrayQueue:function(){return R},CompareResult:function(){return I},arrayInsert:function(){return v},asArray:function(){return S},binarySearch:function(){return a},binarySearch2:function(){return l},coalesce:function(){return h},compareBy:function(){return D},distinct:function(){return m},equals:function(){return r},findFirstInSorted:function(){return c},findLast:function(){return f},findLastMaxBy:function(){return M},findMaxBy:function(){return T},findMinBy:function(){return N},firstOrDefault:function(){return _},groupBy:function(){return u},insertInto:function(){return x},isFalsyOrEmpty:function(){return g},isNonEmptyArray:function(){return p},lastIndex:function(){return b},numberComparator:function(){return L},pushMany:function(){return y},pushToEnd:function(){return w},pushToStart:function(){return C},quickSelect:function(){return d},range:function(){return A},removeFastWithoutKeepingOrder:function(){return s},splice:function(){return E},tail:function(){return n},tail2:function(){return o}}),function(e){e.isLessThan=function(e){return e<0},e.isGreaterThan=function(e){return e>0},e.isNeitherLessOrGreaterThan=function(e){return 0===e},e.greaterThan=1,e.lessThan=-1,e.neitherLessOrGreaterThan=0}(I||(I={}));const L=(e,t)=>e-t;function T(e,t){if(0===e.length)return;let i=e[0];for(let n=1;n<e.length;n++){const o=e[n];t(o,i)>0&&(i=o)}return i}function M(e,t){if(0===e.length)return;let i=e[0];for(let n=1;n<e.length;n++){const o=e[n];t(o,i)>=0&&(i=o)}return i}function N(e,t){return T(e,((e,i)=>-t(e,i)))}class R{constructor(e){this.items=e,this.firstIdx=0,this.lastIdx=this.items.length-1}get length(){return this.lastIdx-this.firstIdx+1}takeWhile(e){let t=this.firstIdx;for(;t<this.items.length&&e(this.items[t]);)t++;const i=t===this.firstIdx?null:this.items.slice(this.firstIdx,t);return this.firstIdx=t,i}takeFromEndWhile(e){let t=this.lastIdx;for(;t>=0&&e(this.items[t]);)t--;const i=t===this.lastIdx?null:this.items.slice(t+1,this.lastIdx+1);return this.lastIdx=t,i}peek(){if(0!==this.length)return this.items[this.firstIdx]}dequeue(){const e=this.items[this.firstIdx];return this.firstIdx++,e}takeCount(e){const t=this.items.slice(this.firstIdx,this.firstIdx+e);return this.firstIdx+=e,t}}},86995:function(e,t,i){"use strict";function n(e,t){if(!e)throw new Error(t?`Assertion failed (${t})`:"Assertion Failed")}i.r(t),i.d(t,{ok:function(){return n}})},66129:function(e,t,i){"use strict";i.r(t),i.d(t,{AsyncIterableObject:function(){return k},CancelableAsyncIterableObject:function(){return I},DeferredPromise:function(){return x},Delayer:function(){return m},IdleValue:function(){return S},IntervalTimer:function(){return C},MicrotaskDelay:function(){return p},Promises:function(){return E},RunOnceScheduler:function(){return w},ThrottledDelayer:function(){return f},Throttler:function(){return g},TimeoutTimer:function(){return v},createCancelableAsyncIterable:function(){return D},createCancelablePromise:function(){return u},disposableTimeout:function(){return _},first:function(){return A},isThenable:function(){return d},raceCancellation:function(){return h},runWhenIdle:function(){return y},timeout:function(){return b}});var n=i(11256),o=i(12718),r=i(63801),s=i(68921),a=i(66719),l=function(e,t,i,n){return new(i||(i=Promise))((function(o,r){function s(e){try{l(n.next(e))}catch(e){r(e)}}function a(e){try{l(n.throw(e))}catch(e){r(e)}}function l(e){var t;e.done?o(e.value):(t=e.value,t instanceof i?t:new i((function(e){e(t)}))).then(s,a)}l((n=n.apply(e,t||[])).next())}))},c=function(e){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var t,i=e[Symbol.asyncIterator];return i?i.call(e):(e="function"==typeof __values?__values(e):e[Symbol.iterator](),t={},n("next"),n("throw"),n("return"),t[Symbol.asyncIterator]=function(){return this},t);function n(i){t[i]=e[i]&&function(t){return new Promise((function(n,o){(function(e,t,i,n){Promise.resolve(n).then((function(t){e({value:t,done:i})}),t)})(n,o,(t=e[i](t)).done,t.value)}))}}};function d(e){return!!e&&"function"==typeof e.then}function u(e){const t=new n.CancellationTokenSource,i=e(t.token),r=new Promise(((e,n)=>{const r=t.token.onCancellationRequested((()=>{r.dispose(),t.dispose(),n(new o.CancellationError)}));Promise.resolve(i).then((i=>{r.dispose(),t.dispose(),e(i)}),(e=>{r.dispose(),t.dispose(),n(e)}))}));return new class{cancel(){t.cancel()}then(e,t){return r.then(e,t)}catch(e){return this.then(void 0,e)}finally(e){return r.finally(e)}}}function h(e,t,i){return new Promise(((n,o)=>{const r=t.onCancellationRequested((()=>{r.dispose(),n(i)}));e.then(n,o).finally((()=>r.dispose()))}))}class g{constructor(){this.activePromise=null,this.queuedPromise=null,this.queuedPromiseFactory=null}queue(e){if(this.activePromise){if(this.queuedPromiseFactory=e,!this.queuedPromise){const e=()=>{this.queuedPromise=null;const e=this.queue(this.queuedPromiseFactory);return this.queuedPromiseFactory=null,e};this.queuedPromise=new Promise((t=>{this.activePromise.then(e,e).then(t)}))}return new Promise(((e,t)=>{this.queuedPromise.then(e,t)}))}return this.activePromise=e(),new Promise(((e,t)=>{this.activePromise.then((t=>{this.activePromise=null,e(t)}),(e=>{this.activePromise=null,t(e)}))}))}}const p=Symbol("MicrotaskDelay");class m{constructor(e){this.defaultDelay=e,this.deferred=null,this.completionPromise=null,this.doResolve=null,this.doReject=null,this.task=null}trigger(e,t=this.defaultDelay){this.task=e,this.cancelTimeout(),this.completionPromise||(this.completionPromise=new Promise(((e,t)=>{this.doResolve=e,this.doReject=t})).then((()=>{if(this.completionPromise=null,this.doResolve=null,this.task){const e=this.task;return this.task=null,e()}})));const i=()=>{var e;this.deferred=null,null===(e=this.doResolve)||void 0===e||e.call(this,null)};return this.deferred=t===p?(e=>{let t=!0;return queueMicrotask((()=>{t&&(t=!1,e())})),{isTriggered:()=>t,dispose:()=>{t=!1}}})(i):((e,t)=>{let i=!0;const n=setTimeout((()=>{i=!1,t()}),e);return{isTriggered:()=>i,dispose:()=>{clearTimeout(n),i=!1}}})(t,i),this.completionPromise}isTriggered(){var e;return!!(null===(e=this.deferred)||void 0===e?void 0:e.isTriggered())}cancel(){var e;this.cancelTimeout(),this.completionPromise&&(null===(e=this.doReject)||void 0===e||e.call(this,new o.CancellationError),this.completionPromise=null)}cancelTimeout(){var e;null===(e=this.deferred)||void 0===e||e.dispose(),this.deferred=null}dispose(){this.cancel()}}class f{constructor(e){this.delayer=new m(e),this.throttler=new g}trigger(e,t){return this.delayer.trigger((()=>this.throttler.queue(e)),t)}dispose(){this.delayer.dispose()}}function b(e,t){return t?new Promise(((i,n)=>{const r=setTimeout((()=>{s.dispose(),i()}),e),s=t.onCancellationRequested((()=>{clearTimeout(r),s.dispose(),n(new o.CancellationError)}))})):u((t=>b(e,t)))}function _(e,t=0){const i=setTimeout(e,t);return(0,s.toDisposable)((()=>clearTimeout(i)))}function A(e,t=(e=>!!e),i=null){let n=0;const o=e.length,r=()=>{if(n>=o)return Promise.resolve(i);const s=e[n++];return Promise.resolve(s()).then((e=>t(e)?Promise.resolve(e):r()))};return r()}class v{constructor(e,t){this._token=-1,"function"==typeof e&&"number"==typeof t&&this.setIfNotSet(e,t)}dispose(){this.cancel()}cancel(){-1!==this._token&&(clearTimeout(this._token),this._token=-1)}cancelAndSet(e,t){this.cancel(),this._token=setTimeout((()=>{this._token=-1,e()}),t)}setIfNotSet(e,t){-1===this._token&&(this._token=setTimeout((()=>{this._token=-1,e()}),t))}}class C{constructor(){this._token=-1}dispose(){this.cancel()}cancel(){-1!==this._token&&(clearInterval(this._token),this._token=-1)}cancelAndSet(e,t){this.cancel(),this._token=setInterval((()=>{e()}),t)}}class w{constructor(e,t){this.timeoutToken=-1,this.runner=e,this.timeout=t,this.timeoutHandler=this.onTimeout.bind(this)}dispose(){this.cancel(),this.runner=null}cancel(){this.isScheduled()&&(clearTimeout(this.timeoutToken),this.timeoutToken=-1)}schedule(e=this.timeout){this.cancel(),this.timeoutToken=setTimeout(this.timeoutHandler,e)}get delay(){return this.timeout}set delay(e){this.timeout=e}isScheduled(){return-1!==this.timeoutToken}onTimeout(){this.timeoutToken=-1,this.runner&&this.doRun()}doRun(){var e;null===(e=this.runner)||void 0===e||e.call(this)}}let y;y="function"!=typeof requestIdleCallback||"function"!=typeof cancelIdleCallback?e=>{(0,a.setTimeout0)((()=>{if(t)return;const i=Date.now()+15;e(Object.freeze({didTimeout:!0,timeRemaining(){return Math.max(0,i-Date.now())}}))}));let t=!1;return{dispose(){t||(t=!0)}}}:(e,t)=>{const i=requestIdleCallback(e,"number"==typeof t?{timeout:t}:void 0);let n=!1;return{dispose(){n||(n=!0,cancelIdleCallback(i))}}};class S{constructor(e){this._didRun=!1,this._executor=()=>{try{this._value=e()}catch(e){this._error=e}finally{this._didRun=!0}},this._handle=y((()=>this._executor()))}dispose(){this._handle.dispose()}get value(){if(this._didRun||(this._handle.dispose(),this._executor()),this._error)throw this._error;return this._value}get isInitialized(){return this._didRun}}class x{constructor(){this.rejected=!1,this.resolved=!1,this.p=new Promise(((e,t)=>{this.completeCallback=e,this.errorCallback=t}))}get isRejected(){return this.rejected}get isSettled(){return this.rejected||this.resolved}complete(e){return new Promise((t=>{this.completeCallback(e),this.resolved=!0,t()}))}cancel(){new Promise((e=>{this.errorCallback(new o.CancellationError),this.rejected=!0,e()}))}}var E;!function(e){e.settled=function(e){return l(this,void 0,void 0,(function*(){let t;const i=yield Promise.all(e.map((e=>e.then((e=>e),(e=>{t||(t=e)})))));if(void 0!==t)throw t;return i}))},e.withAsyncBody=function(e){return new Promise(((t,i)=>l(this,void 0,void 0,(function*(){try{yield e(t,i)}catch(e){i(e)}}))))}}(E||(E={}));class k{constructor(e){this._state=0,this._results=[],this._error=null,this._onStateChanged=new r.Emitter,queueMicrotask((()=>l(this,void 0,void 0,(function*(){const t={emitOne:e=>this.emitOne(e),emitMany:e=>this.emitMany(e),reject:e=>this.reject(e)};try{yield Promise.resolve(e(t)),this.resolve()}catch(e){this.reject(e)}finally{t.emitOne=void 0,t.emitMany=void 0,t.reject=void 0}}))))}static fromArray(e){return new k((t=>{t.emitMany(e)}))}static fromPromise(e){return new k((t=>l(this,void 0,void 0,(function*(){t.emitMany(yield e)}))))}static fromPromises(e){return new k((t=>l(this,void 0,void 0,(function*(){yield Promise.all(e.map((e=>l(this,void 0,void 0,(function*(){return t.emitOne(yield e)})))))}))))}static merge(e){return new k((t=>l(this,void 0,void 0,(function*(){yield Promise.all(e.map((e=>{var i,n;return l(this,void 0,void 0,(function*(){var o,r;try{for(i=c(e);!(n=yield i.next()).done;){const e=n.value;t.emitOne(e)}}catch(e){o={error:e}}finally{try{n&&!n.done&&(r=i.return)&&(yield r.call(i))}finally{if(o)throw o.error}}}))})))}))))}[Symbol.asyncIterator](){let e=0;return{next:()=>l(this,void 0,void 0,(function*(){for(;;){if(2===this._state)throw this._error;if(e<this._results.length)return{done:!1,value:this._results[e++]};if(1===this._state)return{done:!0,value:void 0};yield r.Event.toPromise(this._onStateChanged.event)}}))}}static map(e,t){return new k((i=>l(this,void 0,void 0,(function*(){var n,o;try{for(var r,s=c(e);!(r=yield s.next()).done;){const e=r.value;i.emitOne(t(e))}}catch(e){n={error:e}}finally{try{r&&!r.done&&(o=s.return)&&(yield o.call(s))}finally{if(n)throw n.error}}}))))}map(e){return k.map(this,e)}static filter(e,t){return new k((i=>l(this,void 0,void 0,(function*(){var n,o;try{for(var r,s=c(e);!(r=yield s.next()).done;){const e=r.value;t(e)&&i.emitOne(e)}}catch(e){n={error:e}}finally{try{r&&!r.done&&(o=s.return)&&(yield o.call(s))}finally{if(n)throw n.error}}}))))}filter(e){return k.filter(this,e)}static coalesce(e){return k.filter(e,(e=>!!e))}coalesce(){return k.coalesce(this)}static toPromise(e){var t,i,n,o;return l(this,void 0,void 0,(function*(){const r=[];try{for(t=c(e);!(i=yield t.next()).done;){const e=i.value;r.push(e)}}catch(e){n={error:e}}finally{try{i&&!i.done&&(o=t.return)&&(yield o.call(t))}finally{if(n)throw n.error}}return r}))}toPromise(){return k.toPromise(this)}emitOne(e){0===this._state&&(this._results.push(e),this._onStateChanged.fire())}emitMany(e){0===this._state&&(this._results=this._results.concat(e),this._onStateChanged.fire())}resolve(){0===this._state&&(this._state=1,this._onStateChanged.fire())}reject(e){0===this._state&&(this._state=2,this._error=e,this._onStateChanged.fire())}}k.EMPTY=k.fromArray([]);class I extends k{constructor(e,t){super(t),this._source=e}cancel(){this._source.cancel()}}function D(e){const t=new n.CancellationTokenSource,i=e(t.token);return new I(t,(e=>l(this,void 0,void 0,(function*(){var n,r;const s=t.token.onCancellationRequested((()=>{s.dispose(),t.dispose(),e.reject(new o.CancellationError)}));try{try{for(var a,l=c(i);!(a=yield l.next()).done;){const i=a.value;if(t.token.isCancellationRequested)return;e.emitOne(i)}}catch(e){n={error:e}}finally{try{a&&!a.done&&(r=l.return)&&(yield r.call(l))}finally{if(n)throw n.error}}s.dispose(),t.dispose()}catch(i){s.dispose(),t.dispose(),e.reject(i)}}))))}},44913:function(e,t,i){"use strict";i.r(t),i.d(t,{VSBuffer:function(){return r},readUInt16LE:function(){return s},readUInt32BE:function(){return l},readUInt8:function(){return d},writeUInt16LE:function(){return a},writeUInt32BE:function(){return c},writeUInt8:function(){return u}});const n="undefined"!=typeof Buffer;let o;class r{constructor(e){this.buffer=e,this.byteLength=this.buffer.byteLength}static wrap(e){return n&&!Buffer.isBuffer(e)&&(e=Buffer.from(e.buffer,e.byteOffset,e.byteLength)),new r(e)}toString(){return n?this.buffer.toString():(o||(o=new TextDecoder),o.decode(this.buffer))}}function s(e,t){return e[t+0]<<0>>>0|e[t+1]<<8>>>0}function a(e,t,i){e[i+0]=255&t,t>>>=8,e[i+1]=255&t}function l(e,t){return e[t]*Math.pow(2,24)+e[t+1]*Math.pow(2,16)+e[t+2]*Math.pow(2,8)+e[t+3]}function c(e,t,i){e[i+3]=t,t>>>=8,e[i+2]=t,t>>>=8,e[i+1]=t,t>>>=8,e[i]=t}function d(e,t){return e[t]}function u(e,t,i){e[i]=t}},12359:function(e,t,i){"use strict";i.r(t),i.d(t,{CachedFunction:function(){return o},LRUCachedFunction:function(){return n}});class n{constructor(e){this.fn=e,this.lastCache=void 0,this.lastArgKey=void 0}get(e){const t=JSON.stringify(e);return this.lastArgKey!==t&&(this.lastArgKey=t,this.lastCache=this.fn(e)),this.lastCache}}class o{constructor(e){this.fn=e,this._map=new Map}get cachedValues(){return this._map}get(e){if(this._map.has(e))return this._map.get(e);const t=this.fn(e);return this._map.set(e,t),t}}},11256:function(e,t,i){"use strict";i.r(t),i.d(t,{CancellationToken:function(){return r},CancellationTokenSource:function(){return a}});var n=i(63801);const o=Object.freeze((function(e,t){const i=setTimeout(e.bind(t),0);return{dispose(){clearTimeout(i)}}}));var r;!function(e){e.isCancellationToken=function(t){return t===e.None||t===e.Cancelled||(t instanceof s||!(!t||"object"!=typeof t)&&("boolean"==typeof t.isCancellationRequested&&"function"==typeof t.onCancellationRequested))},e.None=Object.freeze({isCancellationRequested:!1,onCancellationRequested:n.Event.None}),e.Cancelled=Object.freeze({isCancellationRequested:!0,onCancellationRequested:o})}(r||(r={}));class s{constructor(){this._isCancelled=!1,this._emitter=null}cancel(){this._isCancelled||(this._isCancelled=!0,this._emitter&&(this._emitter.fire(void 0),this.dispose()))}get isCancellationRequested(){return this._isCancelled}get onCancellationRequested(){return this._isCancelled?o:(this._emitter||(this._emitter=new n.Emitter),this._emitter.event)}dispose(){this._emitter&&(this._emitter.dispose(),this._emitter=null)}}class a{constructor(e){this._token=void 0,this._parentListener=void 0,this._parentListener=e&&e.onCancellationRequested(this.cancel,this)}get token(){return this._token||(this._token=new s),this._token}cancel(){this._token?this._token instanceof s&&this._token.cancel():this._token=r.Cancelled}dispose(e=!1){e&&this.cancel(),this._parentListener&&this._parentListener.dispose(),this._token?this._token instanceof s&&this._token.dispose():this._token=r.None}}},56087:function(e,t,i){"use strict";function n(e){return e?e.replace(/\$\((.*?)\)/g,((e,t)=>` ${t} `)).trim():""}i.r(t),i.d(t,{CSSIcon:function(){return r},Codicon:function(){return o},getCodiconAriaLabel:function(){return n}});class o{constructor(e,t,i){this.id=e,this.definition=t,this.description=i,o._allCodicons.push(this)}get classNames(){return"codicon codicon-"+this.id}get classNamesArray(){return["codicon","codicon-"+this.id]}get cssSelector(){return".codicon.codicon-"+this.id}static getAll(){return o._allCodicons}}var r;o._allCodicons=[],o.add=new o("add",{fontCharacter:"\\ea60"}),o.plus=new o("plus",o.add.definition),o.gistNew=new o("gist-new",o.add.definition),o.repoCreate=new o("repo-create",o.add.definition),o.lightbulb=new o("lightbulb",{fontCharacter:"\\ea61"}),o.lightBulb=new o("light-bulb",{fontCharacter:"\\ea61"}),o.repo=new o("repo",{fontCharacter:"\\ea62"}),o.repoDelete=new o("repo-delete",{fontCharacter:"\\ea62"}),o.gistFork=new o("gist-fork",{fontCharacter:"\\ea63"}),o.repoForked=new o("repo-forked",{fontCharacter:"\\ea63"}),o.gitPullRequest=new o("git-pull-request",{fontCharacter:"\\ea64"}),o.gitPullRequestAbandoned=new o("git-pull-request-abandoned",{fontCharacter:"\\ea64"}),o.recordKeys=new o("record-keys",{fontCharacter:"\\ea65"}),o.keyboard=new o("keyboard",{fontCharacter:"\\ea65"}),o.tag=new o("tag",{fontCharacter:"\\ea66"}),o.tagAdd=new o("tag-add",{fontCharacter:"\\ea66"}),o.tagRemove=new o("tag-remove",{fontCharacter:"\\ea66"}),o.person=new o("person",{fontCharacter:"\\ea67"}),o.personFollow=new o("person-follow",{fontCharacter:"\\ea67"}),o.personOutline=new o("person-outline",{fontCharacter:"\\ea67"}),o.personFilled=new o("person-filled",{fontCharacter:"\\ea67"}),o.gitBranch=new o("git-branch",{fontCharacter:"\\ea68"}),o.gitBranchCreate=new o("git-branch-create",{fontCharacter:"\\ea68"}),o.gitBranchDelete=new o("git-branch-delete",{fontCharacter:"\\ea68"}),o.sourceControl=new o("source-control",{fontCharacter:"\\ea68"}),o.mirror=new o("mirror",{fontCharacter:"\\ea69"}),o.mirrorPublic=new o("mirror-public",{fontCharacter:"\\ea69"}),o.star=new o("star",{fontCharacter:"\\ea6a"}),o.starAdd=new o("star-add",{fontCharacter:"\\ea6a"}),o.starDelete=new o("star-delete",{fontCharacter:"\\ea6a"}),o.starEmpty=new o("star-empty",{fontCharacter:"\\ea6a"}),o.comment=new o("comment",{fontCharacter:"\\ea6b"}),o.commentAdd=new o("comment-add",{fontCharacter:"\\ea6b"}),o.alert=new o("alert",{fontCharacter:"\\ea6c"}),o.warning=new o("warning",{fontCharacter:"\\ea6c"}),o.search=new o("search",{fontCharacter:"\\ea6d"}),o.searchSave=new o("search-save",{fontCharacter:"\\ea6d"}),o.logOut=new o("log-out",{fontCharacter:"\\ea6e"}),o.signOut=new o("sign-out",{fontCharacter:"\\ea6e"}),o.logIn=new o("log-in",{fontCharacter:"\\ea6f"}),o.signIn=new o("sign-in",{fontCharacter:"\\ea6f"}),o.eye=new o("eye",{fontCharacter:"\\ea70"}),o.eyeUnwatch=new o("eye-unwatch",{fontCharacter:"\\ea70"}),o.eyeWatch=new o("eye-watch",{fontCharacter:"\\ea70"}),o.circleFilled=new o("circle-filled",{fontCharacter:"\\ea71"}),o.primitiveDot=new o("primitive-dot",{fontCharacter:"\\ea71"}),o.closeDirty=new o("close-dirty",{fontCharacter:"\\ea71"}),o.debugBreakpoint=new o("debug-breakpoint",{fontCharacter:"\\ea71"}),o.debugBreakpointDisabled=new o("debug-breakpoint-disabled",{fontCharacter:"\\ea71"}),o.debugHint=new o("debug-hint",{fontCharacter:"\\ea71"}),o.primitiveSquare=new o("primitive-square",{fontCharacter:"\\ea72"}),o.edit=new o("edit",{fontCharacter:"\\ea73"}),o.pencil=new o("pencil",{fontCharacter:"\\ea73"}),o.info=new o("info",{fontCharacter:"\\ea74"}),o.issueOpened=new o("issue-opened",{fontCharacter:"\\ea74"}),o.gistPrivate=new o("gist-private",{fontCharacter:"\\ea75"}),o.gitForkPrivate=new o("git-fork-private",{fontCharacter:"\\ea75"}),o.lock=new o("lock",{fontCharacter:"\\ea75"}),o.mirrorPrivate=new o("mirror-private",{fontCharacter:"\\ea75"}),o.close=new o("close",{fontCharacter:"\\ea76"}),o.removeClose=new o("remove-close",{fontCharacter:"\\ea76"}),o.x=new o("x",{fontCharacter:"\\ea76"}),o.repoSync=new o("repo-sync",{fontCharacter:"\\ea77"}),o.sync=new o("sync",{fontCharacter:"\\ea77"}),o.clone=new o("clone",{fontCharacter:"\\ea78"}),o.desktopDownload=new o("desktop-download",{fontCharacter:"\\ea78"}),o.beaker=new o("beaker",{fontCharacter:"\\ea79"}),o.microscope=new o("microscope",{fontCharacter:"\\ea79"}),o.vm=new o("vm",{fontCharacter:"\\ea7a"}),o.deviceDesktop=new o("device-desktop",{fontCharacter:"\\ea7a"}),o.file=new o("file",{fontCharacter:"\\ea7b"}),o.fileText=new o("file-text",{fontCharacter:"\\ea7b"}),o.more=new o("more",{fontCharacter:"\\ea7c"}),o.ellipsis=new o("ellipsis",{fontCharacter:"\\ea7c"}),o.kebabHorizontal=new o("kebab-horizontal",{fontCharacter:"\\ea7c"}),o.mailReply=new o("mail-reply",{fontCharacter:"\\ea7d"}),o.reply=new o("reply",{fontCharacter:"\\ea7d"}),o.organization=new o("organization",{fontCharacter:"\\ea7e"}),o.organizationFilled=new o("organization-filled",{fontCharacter:"\\ea7e"}),o.organizationOutline=new o("organization-outline",{fontCharacter:"\\ea7e"}),o.newFile=new o("new-file",{fontCharacter:"\\ea7f"}),o.fileAdd=new o("file-add",{fontCharacter:"\\ea7f"}),o.newFolder=new o("new-folder",{fontCharacter:"\\ea80"}),o.fileDirectoryCreate=new o("file-directory-create",{fontCharacter:"\\ea80"}),o.trash=new o("trash",{fontCharacter:"\\ea81"}),o.trashcan=new o("trashcan",{fontCharacter:"\\ea81"}),o.history=new o("history",{fontCharacter:"\\ea82"}),o.clock=new o("clock",{fontCharacter:"\\ea82"}),o.folder=new o("folder",{fontCharacter:"\\ea83"}),o.fileDirectory=new o("file-directory",{fontCharacter:"\\ea83"}),o.symbolFolder=new o("symbol-folder",{fontCharacter:"\\ea83"}),o.logoGithub=new o("logo-github",{fontCharacter:"\\ea84"}),o.markGithub=new o("mark-github",{fontCharacter:"\\ea84"}),o.github=new o("github",{fontCharacter:"\\ea84"}),o.terminal=new o("terminal",{fontCharacter:"\\ea85"}),o.console=new o("console",{fontCharacter:"\\ea85"}),o.repl=new o("repl",{fontCharacter:"\\ea85"}),o.zap=new o("zap",{fontCharacter:"\\ea86"}),o.symbolEvent=new o("symbol-event",{fontCharacter:"\\ea86"}),o.error=new o("error",{fontCharacter:"\\ea87"}),o.stop=new o("stop",{fontCharacter:"\\ea87"}),o.variable=new o("variable",{fontCharacter:"\\ea88"}),o.symbolVariable=new o("symbol-variable",{fontCharacter:"\\ea88"}),o.array=new o("array",{fontCharacter:"\\ea8a"}),o.symbolArray=new o("symbol-array",{fontCharacter:"\\ea8a"}),o.symbolModule=new o("symbol-module",{fontCharacter:"\\ea8b"}),o.symbolPackage=new o("symbol-package",{fontCharacter:"\\ea8b"}),o.symbolNamespace=new o("symbol-namespace",{fontCharacter:"\\ea8b"}),o.symbolObject=new o("symbol-object",{fontCharacter:"\\ea8b"}),o.symbolMethod=new o("symbol-method",{fontCharacter:"\\ea8c"}),o.symbolFunction=new o("symbol-function",{fontCharacter:"\\ea8c"}),o.symbolConstructor=new o("symbol-constructor",{fontCharacter:"\\ea8c"}),o.symbolBoolean=new o("symbol-boolean",{fontCharacter:"\\ea8f"}),o.symbolNull=new o("symbol-null",{fontCharacter:"\\ea8f"}),o.symbolNumeric=new o("symbol-numeric",{fontCharacter:"\\ea90"}),o.symbolNumber=new o("symbol-number",{fontCharacter:"\\ea90"}),o.symbolStructure=new o("symbol-structure",{fontCharacter:"\\ea91"}),o.symbolStruct=new o("symbol-struct",{fontCharacter:"\\ea91"}),o.symbolParameter=new o("symbol-parameter",{fontCharacter:"\\ea92"}),o.symbolTypeParameter=new o("symbol-type-parameter",{fontCharacter:"\\ea92"}),o.symbolKey=new o("symbol-key",{fontCharacter:"\\ea93"}),o.symbolText=new o("symbol-text",{fontCharacter:"\\ea93"}),o.symbolReference=new o("symbol-reference",{fontCharacter:"\\ea94"}),o.goToFile=new o("go-to-file",{fontCharacter:"\\ea94"}),o.symbolEnum=new o("symbol-enum",{fontCharacter:"\\ea95"}),o.symbolValue=new o("symbol-value",{fontCharacter:"\\ea95"}),o.symbolRuler=new o("symbol-ruler",{fontCharacter:"\\ea96"}),o.symbolUnit=new o("symbol-unit",{fontCharacter:"\\ea96"}),o.activateBreakpoints=new o("activate-breakpoints",{fontCharacter:"\\ea97"}),o.archive=new o("archive",{fontCharacter:"\\ea98"}),o.arrowBoth=new o("arrow-both",{fontCharacter:"\\ea99"}),o.arrowDown=new o("arrow-down",{fontCharacter:"\\ea9a"}),o.arrowLeft=new o("arrow-left",{fontCharacter:"\\ea9b"}),o.arrowRight=new o("arrow-right",{fontCharacter:"\\ea9c"}),o.arrowSmallDown=new o("arrow-small-down",{fontCharacter:"\\ea9d"}),o.arrowSmallLeft=new o("arrow-small-left",{fontCharacter:"\\ea9e"}),o.arrowSmallRight=new o("arrow-small-right",{fontCharacter:"\\ea9f"}),o.arrowSmallUp=new o("arrow-small-up",{fontCharacter:"\\eaa0"}),o.arrowUp=new o("arrow-up",{fontCharacter:"\\eaa1"}),o.bell=new o("bell",{fontCharacter:"\\eaa2"}),o.bold=new o("bold",{fontCharacter:"\\eaa3"}),o.book=new o("book",{fontCharacter:"\\eaa4"}),o.bookmark=new o("bookmark",{fontCharacter:"\\eaa5"}),o.debugBreakpointConditionalUnverified=new o("debug-breakpoint-conditional-unverified",{fontCharacter:"\\eaa6"}),o.debugBreakpointConditional=new o("debug-breakpoint-conditional",{fontCharacter:"\\eaa7"}),o.debugBreakpointConditionalDisabled=new o("debug-breakpoint-conditional-disabled",{fontCharacter:"\\eaa7"}),o.debugBreakpointDataUnverified=new o("debug-breakpoint-data-unverified",{fontCharacter:"\\eaa8"}),o.debugBreakpointData=new o("debug-breakpoint-data",{fontCharacter:"\\eaa9"}),o.debugBreakpointDataDisabled=new o("debug-breakpoint-data-disabled",{fontCharacter:"\\eaa9"}),o.debugBreakpointLogUnverified=new o("debug-breakpoint-log-unverified",{fontCharacter:"\\eaaa"}),o.debugBreakpointLog=new o("debug-breakpoint-log",{fontCharacter:"\\eaab"}),o.debugBreakpointLogDisabled=new o("debug-breakpoint-log-disabled",{fontCharacter:"\\eaab"}),o.briefcase=new o("briefcase",{fontCharacter:"\\eaac"}),o.broadcast=new o("broadcast",{fontCharacter:"\\eaad"}),o.browser=new o("browser",{fontCharacter:"\\eaae"}),o.bug=new o("bug",{fontCharacter:"\\eaaf"}),o.calendar=new o("calendar",{fontCharacter:"\\eab0"}),o.caseSensitive=new o("case-sensitive",{fontCharacter:"\\eab1"}),o.check=new o("check",{fontCharacter:"\\eab2"}),o.checklist=new o("checklist",{fontCharacter:"\\eab3"}),o.chevronDown=new o("chevron-down",{fontCharacter:"\\eab4"}),o.dropDownButton=new o("drop-down-button",o.chevronDown.definition),o.chevronLeft=new o("chevron-left",{fontCharacter:"\\eab5"}),o.chevronRight=new o("chevron-right",{fontCharacter:"\\eab6"}),o.chevronUp=new o("chevron-up",{fontCharacter:"\\eab7"}),o.chromeClose=new o("chrome-close",{fontCharacter:"\\eab8"}),o.chromeMaximize=new o("chrome-maximize",{fontCharacter:"\\eab9"}),o.chromeMinimize=new o("chrome-minimize",{fontCharacter:"\\eaba"}),o.chromeRestore=new o("chrome-restore",{fontCharacter:"\\eabb"}),o.circleOutline=new o("circle-outline",{fontCharacter:"\\eabc"}),o.debugBreakpointUnverified=new o("debug-breakpoint-unverified",{fontCharacter:"\\eabc"}),o.circleSlash=new o("circle-slash",{fontCharacter:"\\eabd"}),o.circuitBoard=new o("circuit-board",{fontCharacter:"\\eabe"}),o.clearAll=new o("clear-all",{fontCharacter:"\\eabf"}),o.clippy=new o("clippy",{fontCharacter:"\\eac0"}),o.closeAll=new o("close-all",{fontCharacter:"\\eac1"}),o.cloudDownload=new o("cloud-download",{fontCharacter:"\\eac2"}),o.cloudUpload=new o("cloud-upload",{fontCharacter:"\\eac3"}),o.code=new o("code",{fontCharacter:"\\eac4"}),o.collapseAll=new o("collapse-all",{fontCharacter:"\\eac5"}),o.colorMode=new o("color-mode",{fontCharacter:"\\eac6"}),o.commentDiscussion=new o("comment-discussion",{fontCharacter:"\\eac7"}),o.compareChanges=new o("compare-changes",{fontCharacter:"\\eafd"}),o.creditCard=new o("credit-card",{fontCharacter:"\\eac9"}),o.dash=new o("dash",{fontCharacter:"\\eacc"}),o.dashboard=new o("dashboard",{fontCharacter:"\\eacd"}),o.database=new o("database",{fontCharacter:"\\eace"}),o.debugContinue=new o("debug-continue",{fontCharacter:"\\eacf"}),o.debugDisconnect=new o("debug-disconnect",{fontCharacter:"\\ead0"}),o.debugPause=new o("debug-pause",{fontCharacter:"\\ead1"}),o.debugRestart=new o("debug-restart",{fontCharacter:"\\ead2"}),o.debugStart=new o("debug-start",{fontCharacter:"\\ead3"}),o.debugStepInto=new o("debug-step-into",{fontCharacter:"\\ead4"}),o.debugStepOut=new o("debug-step-out",{fontCharacter:"\\ead5"}),o.debugStepOver=new o("debug-step-over",{fontCharacter:"\\ead6"}),o.debugStop=new o("debug-stop",{fontCharacter:"\\ead7"}),o.debug=new o("debug",{fontCharacter:"\\ead8"}),o.deviceCameraVideo=new o("device-camera-video",{fontCharacter:"\\ead9"}),o.deviceCamera=new o("device-camera",{fontCharacter:"\\eada"}),o.deviceMobile=new o("device-mobile",{fontCharacter:"\\eadb"}),o.diffAdded=new o("diff-added",{fontCharacter:"\\eadc"}),o.diffIgnored=new o("diff-ignored",{fontCharacter:"\\eadd"}),o.diffModified=new o("diff-modified",{fontCharacter:"\\eade"}),o.diffRemoved=new o("diff-removed",{fontCharacter:"\\eadf"}),o.diffRenamed=new o("diff-renamed",{fontCharacter:"\\eae0"}),o.diff=new o("diff",{fontCharacter:"\\eae1"}),o.discard=new o("discard",{fontCharacter:"\\eae2"}),o.editorLayout=new o("editor-layout",{fontCharacter:"\\eae3"}),o.emptyWindow=new o("empty-window",{fontCharacter:"\\eae4"}),o.exclude=new o("exclude",{fontCharacter:"\\eae5"}),o.extensions=new o("extensions",{fontCharacter:"\\eae6"}),o.eyeClosed=new o("eye-closed",{fontCharacter:"\\eae7"}),o.fileBinary=new o("file-binary",{fontCharacter:"\\eae8"}),o.fileCode=new o("file-code",{fontCharacter:"\\eae9"}),o.fileMedia=new o("file-media",{fontCharacter:"\\eaea"}),o.filePdf=new o("file-pdf",{fontCharacter:"\\eaeb"}),o.fileSubmodule=new o("file-submodule",{fontCharacter:"\\eaec"}),o.fileSymlinkDirectory=new o("file-symlink-directory",{fontCharacter:"\\eaed"}),o.fileSymlinkFile=new o("file-symlink-file",{fontCharacter:"\\eaee"}),o.fileZip=new o("file-zip",{fontCharacter:"\\eaef"}),o.files=new o("files",{fontCharacter:"\\eaf0"}),o.filter=new o("filter",{fontCharacter:"\\eaf1"}),o.flame=new o("flame",{fontCharacter:"\\eaf2"}),o.foldDown=new o("fold-down",{fontCharacter:"\\eaf3"}),o.foldUp=new o("fold-up",{fontCharacter:"\\eaf4"}),o.fold=new o("fold",{fontCharacter:"\\eaf5"}),o.folderActive=new o("folder-active",{fontCharacter:"\\eaf6"}),o.folderOpened=new o("folder-opened",{fontCharacter:"\\eaf7"}),o.gear=new o("gear",{fontCharacter:"\\eaf8"}),o.gift=new o("gift",{fontCharacter:"\\eaf9"}),o.gistSecret=new o("gist-secret",{fontCharacter:"\\eafa"}),o.gist=new o("gist",{fontCharacter:"\\eafb"}),o.gitCommit=new o("git-commit",{fontCharacter:"\\eafc"}),o.gitCompare=new o("git-compare",{fontCharacter:"\\eafd"}),o.gitMerge=new o("git-merge",{fontCharacter:"\\eafe"}),o.githubAction=new o("github-action",{fontCharacter:"\\eaff"}),o.githubAlt=new o("github-alt",{fontCharacter:"\\eb00"}),o.globe=new o("globe",{fontCharacter:"\\eb01"}),o.grabber=new o("grabber",{fontCharacter:"\\eb02"}),o.graph=new o("graph",{fontCharacter:"\\eb03"}),o.gripper=new o("gripper",{fontCharacter:"\\eb04"}),o.heart=new o("heart",{fontCharacter:"\\eb05"}),o.home=new o("home",{fontCharacter:"\\eb06"}),o.horizontalRule=new o("horizontal-rule",{fontCharacter:"\\eb07"}),o.hubot=new o("hubot",{fontCharacter:"\\eb08"}),o.inbox=new o("inbox",{fontCharacter:"\\eb09"}),o.issueClosed=new o("issue-closed",{fontCharacter:"\\eba4"}),o.issueReopened=new o("issue-reopened",{fontCharacter:"\\eb0b"}),o.issues=new o("issues",{fontCharacter:"\\eb0c"}),o.italic=new o("italic",{fontCharacter:"\\eb0d"}),o.jersey=new o("jersey",{fontCharacter:"\\eb0e"}),o.json=new o("json",{fontCharacter:"\\eb0f"}),o.kebabVertical=new o("kebab-vertical",{fontCharacter:"\\eb10"}),o.key=new o("key",{fontCharacter:"\\eb11"}),o.law=new o("law",{fontCharacter:"\\eb12"}),o.lightbulbAutofix=new o("lightbulb-autofix",{fontCharacter:"\\eb13"}),o.linkExternal=new o("link-external",{fontCharacter:"\\eb14"}),o.link=new o("link",{fontCharacter:"\\eb15"}),o.listOrdered=new o("list-ordered",{fontCharacter:"\\eb16"}),o.listUnordered=new o("list-unordered",{fontCharacter:"\\eb17"}),o.liveShare=new o("live-share",{fontCharacter:"\\eb18"}),o.loading=new o("loading",{fontCharacter:"\\eb19"}),o.location=new o("location",{fontCharacter:"\\eb1a"}),o.mailRead=new o("mail-read",{fontCharacter:"\\eb1b"}),o.mail=new o("mail",{fontCharacter:"\\eb1c"}),o.markdown=new o("markdown",{fontCharacter:"\\eb1d"}),o.megaphone=new o("megaphone",{fontCharacter:"\\eb1e"}),o.mention=new o("mention",{fontCharacter:"\\eb1f"}),o.milestone=new o("milestone",{fontCharacter:"\\eb20"}),o.mortarBoard=new o("mortar-board",{fontCharacter:"\\eb21"}),o.move=new o("move",{fontCharacter:"\\eb22"}),o.multipleWindows=new o("multiple-windows",{fontCharacter:"\\eb23"}),o.mute=new o("mute",{fontCharacter:"\\eb24"}),o.noNewline=new o("no-newline",{fontCharacter:"\\eb25"}),o.note=new o("note",{fontCharacter:"\\eb26"}),o.octoface=new o("octoface",{fontCharacter:"\\eb27"}),o.openPreview=new o("open-preview",{fontCharacter:"\\eb28"}),o.package_=new o("package",{fontCharacter:"\\eb29"}),o.paintcan=new o("paintcan",{fontCharacter:"\\eb2a"}),o.pin=new o("pin",{fontCharacter:"\\eb2b"}),o.play=new o("play",{fontCharacter:"\\eb2c"}),o.run=new o("run",{fontCharacter:"\\eb2c"}),o.plug=new o("plug",{fontCharacter:"\\eb2d"}),o.preserveCase=new o("preserve-case",{fontCharacter:"\\eb2e"}),o.preview=new o("preview",{fontCharacter:"\\eb2f"}),o.project=new o("project",{fontCharacter:"\\eb30"}),o.pulse=new o("pulse",{fontCharacter:"\\eb31"}),o.question=new o("question",{fontCharacter:"\\eb32"}),o.quote=new o("quote",{fontCharacter:"\\eb33"}),o.radioTower=new o("radio-tower",{fontCharacter:"\\eb34"}),o.reactions=new o("reactions",{fontCharacter:"\\eb35"}),o.references=new o("references",{fontCharacter:"\\eb36"}),o.refresh=new o("refresh",{fontCharacter:"\\eb37"}),o.regex=new o("regex",{fontCharacter:"\\eb38"}),o.remoteExplorer=new o("remote-explorer",{fontCharacter:"\\eb39"}),o.remote=new o("remote",{fontCharacter:"\\eb3a"}),o.remove=new o("remove",{fontCharacter:"\\eb3b"}),o.replaceAll=new o("replace-all",{fontCharacter:"\\eb3c"}),o.replace=new o("replace",{fontCharacter:"\\eb3d"}),o.repoClone=new o("repo-clone",{fontCharacter:"\\eb3e"}),o.repoForcePush=new o("repo-force-push",{fontCharacter:"\\eb3f"}),o.repoPull=new o("repo-pull",{fontCharacter:"\\eb40"}),o.repoPush=new o("repo-push",{fontCharacter:"\\eb41"}),o.report=new o("report",{fontCharacter:"\\eb42"}),o.requestChanges=new o("request-changes",{fontCharacter:"\\eb43"}),o.rocket=new o("rocket",{fontCharacter:"\\eb44"}),o.rootFolderOpened=new o("root-folder-opened",{fontCharacter:"\\eb45"}),o.rootFolder=new o("root-folder",{fontCharacter:"\\eb46"}),o.rss=new o("rss",{fontCharacter:"\\eb47"}),o.ruby=new o("ruby",{fontCharacter:"\\eb48"}),o.saveAll=new o("save-all",{fontCharacter:"\\eb49"}),o.saveAs=new o("save-as",{fontCharacter:"\\eb4a"}),o.save=new o("save",{fontCharacter:"\\eb4b"}),o.screenFull=new o("screen-full",{fontCharacter:"\\eb4c"}),o.screenNormal=new o("screen-normal",{fontCharacter:"\\eb4d"}),o.searchStop=new o("search-stop",{fontCharacter:"\\eb4e"}),o.server=new o("server",{fontCharacter:"\\eb50"}),o.settingsGear=new o("settings-gear",{fontCharacter:"\\eb51"}),o.settings=new o("settings",{fontCharacter:"\\eb52"}),o.shield=new o("shield",{fontCharacter:"\\eb53"}),o.smiley=new o("smiley",{fontCharacter:"\\eb54"}),o.sortPrecedence=new o("sort-precedence",{fontCharacter:"\\eb55"}),o.splitHorizontal=new o("split-horizontal",{fontCharacter:"\\eb56"}),o.splitVertical=new o("split-vertical",{fontCharacter:"\\eb57"}),o.squirrel=new o("squirrel",{fontCharacter:"\\eb58"}),o.starFull=new o("star-full",{fontCharacter:"\\eb59"}),o.starHalf=new o("star-half",{fontCharacter:"\\eb5a"}),o.symbolClass=new o("symbol-class",{fontCharacter:"\\eb5b"}),o.symbolColor=new o("symbol-color",{fontCharacter:"\\eb5c"}),o.symbolCustomColor=new o("symbol-customcolor",{fontCharacter:"\\eb5c"}),o.symbolConstant=new o("symbol-constant",{fontCharacter:"\\eb5d"}),o.symbolEnumMember=new o("symbol-enum-member",{fontCharacter:"\\eb5e"}),o.symbolField=new o("symbol-field",{fontCharacter:"\\eb5f"}),o.symbolFile=new o("symbol-file",{fontCharacter:"\\eb60"}),o.symbolInterface=new o("symbol-interface",{fontCharacter:"\\eb61"}),o.symbolKeyword=new o("symbol-keyword",{fontCharacter:"\\eb62"}),o.symbolMisc=new o("symbol-misc",{fontCharacter:"\\eb63"}),o.symbolOperator=new o("symbol-operator",{fontCharacter:"\\eb64"}),o.symbolProperty=new o("symbol-property",{fontCharacter:"\\eb65"}),o.wrench=new o("wrench",{fontCharacter:"\\eb65"}),o.wrenchSubaction=new o("wrench-subaction",{fontCharacter:"\\eb65"}),o.symbolSnippet=new o("symbol-snippet",{fontCharacter:"\\eb66"}),o.tasklist=new o("tasklist",{fontCharacter:"\\eb67"}),o.telescope=new o("telescope",{fontCharacter:"\\eb68"}),o.textSize=new o("text-size",{fontCharacter:"\\eb69"}),o.threeBars=new o("three-bars",{fontCharacter:"\\eb6a"}),o.thumbsdown=new o("thumbsdown",{fontCharacter:"\\eb6b"}),o.thumbsup=new o("thumbsup",{fontCharacter:"\\eb6c"}),o.tools=new o("tools",{fontCharacter:"\\eb6d"}),o.triangleDown=new o("triangle-down",{fontCharacter:"\\eb6e"}),o.triangleLeft=new o("triangle-left",{fontCharacter:"\\eb6f"}),o.triangleRight=new o("triangle-right",{fontCharacter:"\\eb70"}),o.triangleUp=new o("triangle-up",{fontCharacter:"\\eb71"}),o.twitter=new o("twitter",{fontCharacter:"\\eb72"}),o.unfold=new o("unfold",{fontCharacter:"\\eb73"}),o.unlock=new o("unlock",{fontCharacter:"\\eb74"}),o.unmute=new o("unmute",{fontCharacter:"\\eb75"}),o.unverified=new o("unverified",{fontCharacter:"\\eb76"}),o.verified=new o("verified",{fontCharacter:"\\eb77"}),o.versions=new o("versions",{fontCharacter:"\\eb78"}),o.vmActive=new o("vm-active",{fontCharacter:"\\eb79"}),o.vmOutline=new o("vm-outline",{fontCharacter:"\\eb7a"}),o.vmRunning=new o("vm-running",{fontCharacter:"\\eb7b"}),o.watch=new o("watch",{fontCharacter:"\\eb7c"}),o.whitespace=new o("whitespace",{fontCharacter:"\\eb7d"}),o.wholeWord=new o("whole-word",{fontCharacter:"\\eb7e"}),o.window=new o("window",{fontCharacter:"\\eb7f"}),o.wordWrap=new o("word-wrap",{fontCharacter:"\\eb80"}),o.zoomIn=new o("zoom-in",{fontCharacter:"\\eb81"}),o.zoomOut=new o("zoom-out",{fontCharacter:"\\eb82"}),o.listFilter=new o("list-filter",{fontCharacter:"\\eb83"}),o.listFlat=new o("list-flat",{fontCharacter:"\\eb84"}),o.listSelection=new o("list-selection",{fontCharacter:"\\eb85"}),o.selection=new o("selection",{fontCharacter:"\\eb85"}),o.listTree=new o("list-tree",{fontCharacter:"\\eb86"}),o.debugBreakpointFunctionUnverified=new o("debug-breakpoint-function-unverified",{fontCharacter:"\\eb87"}),o.debugBreakpointFunction=new o("debug-breakpoint-function",{fontCharacter:"\\eb88"}),o.debugBreakpointFunctionDisabled=new o("debug-breakpoint-function-disabled",{fontCharacter:"\\eb88"}),o.debugStackframeActive=new o("debug-stackframe-active",{fontCharacter:"\\eb89"}),o.circleSmallFilled=new o("circle-small-filled",{fontCharacter:"\\eb8a"}),o.debugStackframeDot=new o("debug-stackframe-dot",o.circleSmallFilled.definition),o.debugStackframe=new o("debug-stackframe",{fontCharacter:"\\eb8b"}),o.debugStackframeFocused=new o("debug-stackframe-focused",{fontCharacter:"\\eb8b"}),o.debugBreakpointUnsupported=new o("debug-breakpoint-unsupported",{fontCharacter:"\\eb8c"}),o.symbolString=new o("symbol-string",{fontCharacter:"\\eb8d"}),o.debugReverseContinue=new o("debug-reverse-continue",{fontCharacter:"\\eb8e"}),o.debugStepBack=new o("debug-step-back",{fontCharacter:"\\eb8f"}),o.debugRestartFrame=new o("debug-restart-frame",{fontCharacter:"\\eb90"}),o.callIncoming=new o("call-incoming",{fontCharacter:"\\eb92"}),o.callOutgoing=new o("call-outgoing",{fontCharacter:"\\eb93"}),o.menu=new o("menu",{fontCharacter:"\\eb94"}),o.expandAll=new o("expand-all",{fontCharacter:"\\eb95"}),o.feedback=new o("feedback",{fontCharacter:"\\eb96"}),o.groupByRefType=new o("group-by-ref-type",{fontCharacter:"\\eb97"}),o.ungroupByRefType=new o("ungroup-by-ref-type",{fontCharacter:"\\eb98"}),o.account=new o("account",{fontCharacter:"\\eb99"}),o.bellDot=new o("bell-dot",{fontCharacter:"\\eb9a"}),o.debugConsole=new o("debug-console",{fontCharacter:"\\eb9b"}),o.library=new o("library",{fontCharacter:"\\eb9c"}),o.output=new o("output",{fontCharacter:"\\eb9d"}),o.runAll=new o("run-all",{fontCharacter:"\\eb9e"}),o.syncIgnored=new o("sync-ignored",{fontCharacter:"\\eb9f"}),o.pinned=new o("pinned",{fontCharacter:"\\eba0"}),o.githubInverted=new o("github-inverted",{fontCharacter:"\\eba1"}),o.debugAlt=new o("debug-alt",{fontCharacter:"\\eb91"}),o.serverProcess=new o("server-process",{fontCharacter:"\\eba2"}),o.serverEnvironment=new o("server-environment",{fontCharacter:"\\eba3"}),o.pass=new o("pass",{fontCharacter:"\\eba4"}),o.stopCircle=new o("stop-circle",{fontCharacter:"\\eba5"}),o.playCircle=new o("play-circle",{fontCharacter:"\\eba6"}),o.record=new o("record",{fontCharacter:"\\eba7"}),o.debugAltSmall=new o("debug-alt-small",{fontCharacter:"\\eba8"}),o.vmConnect=new o("vm-connect",{fontCharacter:"\\eba9"}),o.cloud=new o("cloud",{fontCharacter:"\\ebaa"}),o.merge=new o("merge",{fontCharacter:"\\ebab"}),o.exportIcon=new o("export",{fontCharacter:"\\ebac"}),o.graphLeft=new o("graph-left",{fontCharacter:"\\ebad"}),o.magnet=new o("magnet",{fontCharacter:"\\ebae"}),o.notebook=new o("notebook",{fontCharacter:"\\ebaf"}),o.redo=new o("redo",{fontCharacter:"\\ebb0"}),o.checkAll=new o("check-all",{fontCharacter:"\\ebb1"}),o.pinnedDirty=new o("pinned-dirty",{fontCharacter:"\\ebb2"}),o.passFilled=new o("pass-filled",{fontCharacter:"\\ebb3"}),o.circleLargeFilled=new o("circle-large-filled",{fontCharacter:"\\ebb4"}),o.circleLargeOutline=new o("circle-large-outline",{fontCharacter:"\\ebb5"}),o.combine=new o("combine",{fontCharacter:"\\ebb6"}),o.gather=new o("gather",{fontCharacter:"\\ebb6"}),o.table=new o("table",{fontCharacter:"\\ebb7"}),o.variableGroup=new o("variable-group",{fontCharacter:"\\ebb8"}),o.typeHierarchy=new o("type-hierarchy",{fontCharacter:"\\ebb9"}),o.typeHierarchySub=new o("type-hierarchy-sub",{fontCharacter:"\\ebba"}),o.typeHierarchySuper=new o("type-hierarchy-super",{fontCharacter:"\\ebbb"}),o.gitPullRequestCreate=new o("git-pull-request-create",{fontCharacter:"\\ebbc"}),o.runAbove=new o("run-above",{fontCharacter:"\\ebbd"}),o.runBelow=new o("run-below",{fontCharacter:"\\ebbe"}),o.notebookTemplate=new o("notebook-template",{fontCharacter:"\\ebbf"}),o.debugRerun=new o("debug-rerun",{fontCharacter:"\\ebc0"}),o.workspaceTrusted=new o("workspace-trusted",{fontCharacter:"\\ebc1"}),o.workspaceUntrusted=new o("workspace-untrusted",{fontCharacter:"\\ebc2"}),o.workspaceUnspecified=new o("workspace-unspecified",{fontCharacter:"\\ebc3"}),o.terminalCmd=new o("terminal-cmd",{fontCharacter:"\\ebc4"}),o.terminalDebian=new o("terminal-debian",{fontCharacter:"\\ebc5"}),o.terminalLinux=new o("terminal-linux",{fontCharacter:"\\ebc6"}),o.terminalPowershell=new o("terminal-powershell",{fontCharacter:"\\ebc7"}),o.terminalTmux=new o("terminal-tmux",{fontCharacter:"\\ebc8"}),o.terminalUbuntu=new o("terminal-ubuntu",{fontCharacter:"\\ebc9"}),o.terminalBash=new o("terminal-bash",{fontCharacter:"\\ebca"}),o.arrowSwap=new o("arrow-swap",{fontCharacter:"\\ebcb"}),o.copy=new o("copy",{fontCharacter:"\\ebcc"}),o.personAdd=new o("person-add",{fontCharacter:"\\ebcd"}),o.filterFilled=new o("filter-filled",{fontCharacter:"\\ebce"}),o.wand=new o("wand",{fontCharacter:"\\ebcf"}),o.debugLineByLine=new o("debug-line-by-line",{fontCharacter:"\\ebd0"}),o.inspect=new o("inspect",{fontCharacter:"\\ebd1"}),o.layers=new o("layers",{fontCharacter:"\\ebd2"}),o.layersDot=new o("layers-dot",{fontCharacter:"\\ebd3"}),o.layersActive=new o("layers-active",{fontCharacter:"\\ebd4"}),o.compass=new o("compass",{fontCharacter:"\\ebd5"}),o.compassDot=new o("compass-dot",{fontCharacter:"\\ebd6"}),o.compassActive=new o("compass-active",{fontCharacter:"\\ebd7"}),o.azure=new o("azure",{fontCharacter:"\\ebd8"}),o.issueDraft=new o("issue-draft",{fontCharacter:"\\ebd9"}),o.gitPullRequestClosed=new o("git-pull-request-closed",{fontCharacter:"\\ebda"}),o.gitPullRequestDraft=new o("git-pull-request-draft",{fontCharacter:"\\ebdb"}),o.debugAll=new o("debug-all",{fontCharacter:"\\ebdc"}),o.debugCoverage=new o("debug-coverage",{fontCharacter:"\\ebdd"}),o.runErrors=new o("run-errors",{fontCharacter:"\\ebde"}),o.folderLibrary=new o("folder-library",{fontCharacter:"\\ebdf"}),o.debugContinueSmall=new o("debug-continue-small",{fontCharacter:"\\ebe0"}),o.beakerStop=new o("beaker-stop",{fontCharacter:"\\ebe1"}),o.graphLine=new o("graph-line",{fontCharacter:"\\ebe2"}),o.graphScatter=new o("graph-scatter",{fontCharacter:"\\ebe3"}),o.pieChart=new o("pie-chart",{fontCharacter:"\\ebe4"}),o.bracket=new o("bracket",o.json.definition),o.bracketDot=new o("bracket-dot",{fontCharacter:"\\ebe5"}),o.bracketError=new o("bracket-error",{fontCharacter:"\\ebe6"}),o.lockSmall=new o("lock-small",{fontCharacter:"\\ebe7"}),o.azureDevops=new o("azure-devops",{fontCharacter:"\\ebe8"}),o.verifiedFilled=new o("verified-filled",{fontCharacter:"\\ebe9"}),o.newLine=new o("newline",{fontCharacter:"\\ebea"}),o.layout=new o("layout",{fontCharacter:"\\ebeb"}),o.layoutActivitybarLeft=new o("layout-activitybar-left",{fontCharacter:"\\ebec"}),o.layoutActivitybarRight=new o("layout-activitybar-right",{fontCharacter:"\\ebed"}),o.layoutPanelLeft=new o("layout-panel-left",{fontCharacter:"\\ebee"}),o.layoutPanelCenter=new o("layout-panel-center",{fontCharacter:"\\ebef"}),o.layoutPanelJustify=new o("layout-panel-justify",{fontCharacter:"\\ebf0"}),o.layoutPanelRight=new o("layout-panel-right",{fontCharacter:"\\ebf1"}),o.layoutPanel=new o("layout-panel",{fontCharacter:"\\ebf2"}),o.layoutSidebarLeft=new o("layout-sidebar-left",{fontCharacter:"\\ebf3"}),o.layoutSidebarRight=new o("layout-sidebar-right",{fontCharacter:"\\ebf4"}),o.layoutStatusbar=new o("layout-statusbar",{fontCharacter:"\\ebf5"}),o.layoutMenubar=new o("layout-menubar",{fontCharacter:"\\ebf6"}),o.layoutCentered=new o("layout-centered",{fontCharacter:"\\ebf7"}),o.layoutSidebarRightOff=new o("layout-sidebar-right-off",{fontCharacter:"\\ec00"}),o.layoutPanelOff=new o("layout-panel-off",{fontCharacter:"\\ec01"}),o.layoutSidebarLeftOff=new o("layout-sidebar-left-off",{fontCharacter:"\\ec02"}),o.target=new o("target",{fontCharacter:"\\ebf8"}),o.indent=new o("indent",{fontCharacter:"\\ebf9"}),o.recordSmall=new o("record-small",{fontCharacter:"\\ebfa"}),o.errorSmall=new o("error-small",{fontCharacter:"\\ebfb"}),o.arrowCircleDown=new o("arrow-circle-down",{fontCharacter:"\\ebfc"}),o.arrowCircleLeft=new o("arrow-circle-left",{fontCharacter:"\\ebfd"}),o.arrowCircleRight=new o("arrow-circle-right",{fontCharacter:"\\ebfe"}),o.arrowCircleUp=new o("arrow-circle-up",{fontCharacter:"\\ebff"}),o.heartFilled=new o("heart-filled",{fontCharacter:"\\ec04"}),o.map=new o("map",{fontCharacter:"\\ec05"}),o.mapFilled=new o("map-filled",{fontCharacter:"\\ec06"}),o.circleSmall=new o("circle-small",{fontCharacter:"\\ec07"}),o.bellSlash=new o("bell-slash",{fontCharacter:"\\ec08"}),o.bellSlashDot=new o("bell-slash-dot",{fontCharacter:"\\ec09"}),o.commentUnresolved=new o("comment-unresolved",{fontCharacter:"\\ec0a"}),o.gitPullRequestGoToChanges=new o("git-pull-request-go-to-changes",{fontCharacter:"\\ec0b"}),o.gitPullRequestNewChanges=new o("git-pull-request-new-changes",{fontCharacter:"\\ec0c"}),o.dialogError=new o("dialog-error",o.error.definition),o.dialogWarning=new o("dialog-warning",o.warning.definition),o.dialogInfo=new o("dialog-info",o.info.definition),o.dialogClose=new o("dialog-close",o.close.definition),o.treeItemExpanded=new o("tree-item-expanded",o.chevronDown.definition),o.treeFilterOnTypeOn=new o("tree-filter-on-type-on",o.listFilter.definition),o.treeFilterOnTypeOff=new o("tree-filter-on-type-off",o.listSelection.definition),o.treeFilterClear=new o("tree-filter-clear",o.close.definition),o.treeItemLoading=new o("tree-item-loading",o.loading.definition),o.menuSelection=new o("menu-selection",o.check.definition),o.menuSubmenu=new o("menu-submenu",o.chevronRight.definition),o.menuBarMore=new o("menubar-more",o.more.definition),o.scrollbarButtonLeft=new o("scrollbar-button-left",o.triangleLeft.definition),o.scrollbarButtonRight=new o("scrollbar-button-right",o.triangleRight.definition),o.scrollbarButtonUp=new o("scrollbar-button-up",o.triangleUp.definition),o.scrollbarButtonDown=new o("scrollbar-button-down",o.triangleDown.definition),o.toolBarMore=new o("toolbar-more",o.more.definition),o.quickInputBack=new o("quick-input-back",o.arrowLeft.definition),function(e){e.iconNameSegment="[A-Za-z0-9]+",e.iconNameExpression="[A-Za-z0-9-]+",e.iconModifierExpression="~[A-Za-z]+",e.iconNameCharacter="[A-Za-z0-9~-]";const t=new RegExp(`^(${e.iconNameExpression})(${e.iconModifierExpression})?$`);function i(e){if(e instanceof o)return["codicon","codicon-"+e.id];const n=t.exec(e.id);if(!n)return i(o.error);const[,r,s]=n,a=["codicon","codicon-"+r];return s&&a.push("codicon-modifier-"+s.substr(1)),a}e.asClassNameArray=i,e.asClassName=function(e){return i(e).join(" ")},e.asCSSSelector=function(e){return"."+i(e).join(".")}}(r||(r={}))},64280:function(e,t,i){"use strict";i.r(t),i.d(t,{SetMap:function(){return n}});class n{constructor(){this.map=new Map}add(e,t){let i=this.map.get(e);i||(i=new Set,this.map.set(e,i)),i.add(t)}delete(e,t){const i=this.map.get(e);i&&(i.delete(t),0===i.size&&this.map.delete(e))}forEach(e,t){const i=this.map.get(e);i&&i.forEach(t)}}},17160:function(e,t,i){"use strict";function n(e,t){const i=Math.pow(10,t);return Math.round(e*i)/i}i.r(t),i.d(t,{Color:function(){return a},HSLA:function(){return r},HSVA:function(){return s},RGBA:function(){return o}});class o{constructor(e,t,i,o=1){this._rgbaBrand=void 0,this.r=0|Math.min(255,Math.max(0,e)),this.g=0|Math.min(255,Math.max(0,t)),this.b=0|Math.min(255,Math.max(0,i)),this.a=n(Math.max(Math.min(1,o),0),3)}static equals(e,t){return e.r===t.r&&e.g===t.g&&e.b===t.b&&e.a===t.a}}class r{constructor(e,t,i,o){this._hslaBrand=void 0,this.h=0|Math.max(Math.min(360,e),0),this.s=n(Math.max(Math.min(1,t),0),3),this.l=n(Math.max(Math.min(1,i),0),3),this.a=n(Math.max(Math.min(1,o),0),3)}static equals(e,t){return e.h===t.h&&e.s===t.s&&e.l===t.l&&e.a===t.a}static fromRGBA(e){const t=e.r/255,i=e.g/255,n=e.b/255,o=e.a,s=Math.max(t,i,n),a=Math.min(t,i,n);let l=0,c=0;const d=(a+s)/2,u=s-a;if(u>0){switch(c=Math.min(d<=.5?u/(2*d):u/(2-2*d),1),s){case t:l=(i-n)/u+(i<n?6:0);break;case i:l=(n-t)/u+2;break;case n:l=(t-i)/u+4}l*=60,l=Math.round(l)}return new r(l,c,d,o)}static _hue2rgb(e,t,i){return i<0&&(i+=1),i>1&&(i-=1),i<1/6?e+6*(t-e)*i:i<.5?t:i<2/3?e+(t-e)*(2/3-i)*6:e}static toRGBA(e){const t=e.h/360,{s:i,l:n,a:s}=e;let a,l,c;if(0===i)a=l=c=n;else{const e=n<.5?n*(1+i):n+i-n*i,o=2*n-e;a=r._hue2rgb(o,e,t+1/3),l=r._hue2rgb(o,e,t),c=r._hue2rgb(o,e,t-1/3)}return new o(Math.round(255*a),Math.round(255*l),Math.round(255*c),s)}}class s{constructor(e,t,i,o){this._hsvaBrand=void 0,this.h=0|Math.max(Math.min(360,e),0),this.s=n(Math.max(Math.min(1,t),0),3),this.v=n(Math.max(Math.min(1,i),0),3),this.a=n(Math.max(Math.min(1,o),0),3)}static equals(e,t){return e.h===t.h&&e.s===t.s&&e.v===t.v&&e.a===t.a}static fromRGBA(e){const t=e.r/255,i=e.g/255,n=e.b/255,o=Math.max(t,i,n),r=o-Math.min(t,i,n),a=0===o?0:r/o;let l;return l=0===r?0:o===t?((i-n)/r%6+6)%6:o===i?(n-t)/r+2:(t-i)/r+4,new s(Math.round(60*l),a,o,e.a)}static toRGBA(e){const{h:t,s:i,v:n,a:r}=e,s=n*i,a=s*(1-Math.abs(t/60%2-1)),l=n-s;let[c,d,u]=[0,0,0];return t<60?(c=s,d=a):t<120?(c=a,d=s):t<180?(d=s,u=a):t<240?(d=a,u=s):t<300?(c=a,u=s):t<=360&&(c=s,u=a),c=Math.round(255*(c+l)),d=Math.round(255*(d+l)),u=Math.round(255*(u+l)),new o(c,d,u,r)}}class a{constructor(e){if(!e)throw new Error("Color needs a value");if(e instanceof o)this.rgba=e;else if(e instanceof r)this._hsla=e,this.rgba=r.toRGBA(e);else{if(!(e instanceof s))throw new Error("Invalid color ctor argument");this._hsva=e,this.rgba=s.toRGBA(e)}}static fromHex(e){return a.Format.CSS.parseHex(e)||a.red}get hsla(){return this._hsla?this._hsla:r.fromRGBA(this.rgba)}get hsva(){return this._hsva?this._hsva:s.fromRGBA(this.rgba)}equals(e){return!!e&&o.equals(this.rgba,e.rgba)&&r.equals(this.hsla,e.hsla)&&s.equals(this.hsva,e.hsva)}getRelativeLuminance(){return n(.2126*a._relativeLuminanceForComponent(this.rgba.r)+.7152*a._relativeLuminanceForComponent(this.rgba.g)+.0722*a._relativeLuminanceForComponent(this.rgba.b),4)}static _relativeLuminanceForComponent(e){const t=e/255;return t<=.03928?t/12.92:Math.pow((t+.055)/1.055,2.4)}isLighter(){return(299*this.rgba.r+587*this.rgba.g+114*this.rgba.b)/1e3>=128}isLighterThan(e){return this.getRelativeLuminance()>e.getRelativeLuminance()}isDarkerThan(e){return this.getRelativeLuminance()<e.getRelativeLuminance()}lighten(e){return new a(new r(this.hsla.h,this.hsla.s,this.hsla.l+this.hsla.l*e,this.hsla.a))}darken(e){return new a(new r(this.hsla.h,this.hsla.s,this.hsla.l-this.hsla.l*e,this.hsla.a))}transparent(e){const{r:t,g:i,b:n,a:r}=this.rgba;return new a(new o(t,i,n,r*e))}isTransparent(){return 0===this.rgba.a}isOpaque(){return 1===this.rgba.a}opposite(){return new a(new o(255-this.rgba.r,255-this.rgba.g,255-this.rgba.b,this.rgba.a))}toString(){return this._toString||(this._toString=a.Format.CSS.format(this)),this._toString}static getLighterColor(e,t,i){if(e.isLighterThan(t))return e;i=i||.5;const n=e.getRelativeLuminance(),o=t.getRelativeLuminance();return i=i*(o-n)/o,e.lighten(i)}static getDarkerColor(e,t,i){if(e.isDarkerThan(t))return e;i=i||.5;const n=e.getRelativeLuminance();return i=i*(n-t.getRelativeLuminance())/n,e.darken(i)}}a.white=new a(new o(255,255,255,1)),a.black=new a(new o(0,0,0,1)),a.red=new a(new o(255,0,0,1)),a.blue=new a(new o(0,0,255,1)),a.green=new a(new o(0,255,0,1)),a.cyan=new a(new o(0,255,255,1)),a.lightgrey=new a(new o(211,211,211,1)),a.transparent=new a(new o(0,0,0,0)),function(e){let t;!function(t){let i;!function(t){function i(e){const t=e.toString(16);return 2!==t.length?"0"+t:t}function n(e){switch(e){case 48:return 0;case 49:return 1;case 50:return 2;case 51:return 3;case 52:return 4;case 53:return 5;case 54:return 6;case 55:return 7;case 56:return 8;case 57:return 9;case 97:case 65:return 10;case 98:case 66:return 11;case 99:case 67:return 12;case 100:case 68:return 13;case 101:case 69:return 14;case 102:case 70:return 15}return 0}t.formatRGB=function(t){return 1===t.rgba.a?`rgb(${t.rgba.r}, ${t.rgba.g}, ${t.rgba.b})`:e.Format.CSS.formatRGBA(t)},t.formatRGBA=function(e){return`rgba(${e.rgba.r}, ${e.rgba.g}, ${e.rgba.b}, ${+e.rgba.a.toFixed(2)})`},t.formatHSL=function(t){return 1===t.hsla.a?`hsl(${t.hsla.h}, ${(100*t.hsla.s).toFixed(2)}%, ${(100*t.hsla.l).toFixed(2)}%)`:e.Format.CSS.formatHSLA(t)},t.formatHSLA=function(e){return`hsla(${e.hsla.h}, ${(100*e.hsla.s).toFixed(2)}%, ${(100*e.hsla.l).toFixed(2)}%, ${e.hsla.a.toFixed(2)})`},t.formatHex=function(e){return`#${i(e.rgba.r)}${i(e.rgba.g)}${i(e.rgba.b)}`},t.formatHexA=function(t,n=!1){return n&&1===t.rgba.a?e.Format.CSS.formatHex(t):`#${i(t.rgba.r)}${i(t.rgba.g)}${i(t.rgba.b)}${i(Math.round(255*t.rgba.a))}`},t.format=function(t){return t.isOpaque()?e.Format.CSS.formatHex(t):e.Format.CSS.formatRGBA(t)},t.parseHex=function(t){const i=t.length;if(0===i)return null;if(35!==t.charCodeAt(0))return null;if(7===i){const i=16*n(t.charCodeAt(1))+n(t.charCodeAt(2)),r=16*n(t.charCodeAt(3))+n(t.charCodeAt(4)),s=16*n(t.charCodeAt(5))+n(t.charCodeAt(6));return new e(new o(i,r,s,1))}if(9===i){const i=16*n(t.charCodeAt(1))+n(t.charCodeAt(2)),r=16*n(t.charCodeAt(3))+n(t.charCodeAt(4)),s=16*n(t.charCodeAt(5))+n(t.charCodeAt(6)),a=16*n(t.charCodeAt(7))+n(t.charCodeAt(8));return new e(new o(i,r,s,a/255))}if(4===i){const i=n(t.charCodeAt(1)),r=n(t.charCodeAt(2)),s=n(t.charCodeAt(3));return new e(new o(16*i+i,16*r+r,16*s+s))}if(5===i){const i=n(t.charCodeAt(1)),r=n(t.charCodeAt(2)),s=n(t.charCodeAt(3)),a=n(t.charCodeAt(4));return new e(new o(16*i+i,16*r+r,16*s+s,(16*a+a)/255))}return null}}(i=t.CSS||(t.CSS={}))}(t=e.Format||(e.Format={}))}(a||(a={}))},99981:function(e,t,i){"use strict";i.r(t),i.d(t,{compareAnything:function(){return s},compareByPrefix:function(){return a},compareFileNames:function(){return r}});var n=i(66129);const o=new n.IdleValue((()=>{const e=new Intl.Collator(void 0,{numeric:!0,sensitivity:"base"});return{collator:e,collatorIsNumeric:e.resolvedOptions().numeric}}));new n.IdleValue((()=>({collator:new Intl.Collator(void 0,{numeric:!0})}))),new n.IdleValue((()=>({collator:new Intl.Collator(void 0,{numeric:!0,sensitivity:"accent"})})));function r(e,t,i=!1){const n=e||"",r=t||"",s=o.value.collator.compare(n,r);return o.value.collatorIsNumeric&&0===s&&n!==r?n<r?-1:1:s}function s(e,t,i){const n=e.toLowerCase(),o=t.toLowerCase(),s=a(e,t,i);if(s)return s;const l=n.endsWith(i);if(l!==o.endsWith(i))return l?-1:1;const c=r(n,o);return 0!==c?c:n.localeCompare(o)}function a(e,t,i){const n=e.toLowerCase(),o=t.toLowerCase(),r=n.startsWith(i),s=o.startsWith(i);if(r!==s)return r?-1:1;if(r&&s){if(n.length<o.length)return-1;if(n.length>o.length)return 1}return 0}},63966:function(e,t,i){"use strict";function n(e,t,i){let n=null,o=null;if("function"==typeof i.value?(n="value",o=i.value,0!==o.length&&console.warn("Memoize should only be used in functions with zero parameters")):"function"==typeof i.get&&(n="get",o=i.get),!o)throw new Error("not supported");const r=`$memoize$${t}`;i[n]=function(...e){return this.hasOwnProperty(r)||Object.defineProperty(this,r,{configurable:!1,enumerable:!1,writable:!1,value:o.apply(this,e)}),this[r]}}i.r(t),i.d(t,{memoize:function(){return n}})},11914:function(e,t,i){"use strict";i.r(t),i.d(t,{Debug:function(){return a},LcsDiff:function(){return d},MyArray:function(){return l},StringDiffSequence:function(){return r},stringDiff:function(){return s}});var n=i(97917),o=i(23829);class r{constructor(e){this.source=e}getElements(){const e=this.source,t=new Int32Array(e.length);for(let i=0,n=e.length;i<n;i++)t[i]=e.charCodeAt(i);return t}}function s(e,t,i){return new d(new r(e),new r(t)).ComputeDiff(i).changes}class a{static Assert(e,t){if(!e)throw new Error(t)}}class l{static Copy(e,t,i,n,o){for(let r=0;r<o;r++)i[n+r]=e[t+r]}static Copy2(e,t,i,n,o){for(let r=0;r<o;r++)i[n+r]=e[t+r]}}class c{constructor(){this.m_changes=[],this.m_originalStart=1073741824,this.m_modifiedStart=1073741824,this.m_originalCount=0,this.m_modifiedCount=0}MarkNextChange(){(this.m_originalCount>0||this.m_modifiedCount>0)&&this.m_changes.push(new n.DiffChange(this.m_originalStart,this.m_originalCount,this.m_modifiedStart,this.m_modifiedCount)),this.m_originalCount=0,this.m_modifiedCount=0,this.m_originalStart=1073741824,this.m_modifiedStart=1073741824}AddOriginalElement(e,t){this.m_originalStart=Math.min(this.m_originalStart,e),this.m_modifiedStart=Math.min(this.m_modifiedStart,t),this.m_originalCount++}AddModifiedElement(e,t){this.m_originalStart=Math.min(this.m_originalStart,e),this.m_modifiedStart=Math.min(this.m_modifiedStart,t),this.m_modifiedCount++}getChanges(){return(this.m_originalCount>0||this.m_modifiedCount>0)&&this.MarkNextChange(),this.m_changes}getReverseChanges(){return(this.m_originalCount>0||this.m_modifiedCount>0)&&this.MarkNextChange(),this.m_changes.reverse(),this.m_changes}}class d{constructor(e,t,i=null){this.ContinueProcessingPredicate=i,this._originalSequence=e,this._modifiedSequence=t;const[n,o,r]=d._getElements(e),[s,a,l]=d._getElements(t);this._hasStrings=r&&l,this._originalStringElements=n,this._originalElementsOrHash=o,this._modifiedStringElements=s,this._modifiedElementsOrHash=a,this.m_forwardHistory=[],this.m_reverseHistory=[]}static _isStringArray(e){return e.length>0&&"string"==typeof e[0]}static _getElements(e){const t=e.getElements();if(d._isStringArray(t)){const e=new Int32Array(t.length);for(let i=0,n=t.length;i<n;i++)e[i]=(0,o.stringHash)(t[i],0);return[t,e,!0]}return t instanceof Int32Array?[[],t,!1]:[[],new Int32Array(t),!1]}ElementsAreEqual(e,t){return this._originalElementsOrHash[e]===this._modifiedElementsOrHash[t]&&(!this._hasStrings||this._originalStringElements[e]===this._modifiedStringElements[t])}ElementsAreStrictEqual(e,t){if(!this.ElementsAreEqual(e,t))return!1;return d._getStrictElement(this._originalSequence,e)===d._getStrictElement(this._modifiedSequence,t)}static _getStrictElement(e,t){return"function"==typeof e.getStrictElement?e.getStrictElement(t):null}OriginalElementsAreEqual(e,t){return this._originalElementsOrHash[e]===this._originalElementsOrHash[t]&&(!this._hasStrings||this._originalStringElements[e]===this._originalStringElements[t])}ModifiedElementsAreEqual(e,t){return this._modifiedElementsOrHash[e]===this._modifiedElementsOrHash[t]&&(!this._hasStrings||this._modifiedStringElements[e]===this._modifiedStringElements[t])}ComputeDiff(e){return this._ComputeDiff(0,this._originalElementsOrHash.length-1,0,this._modifiedElementsOrHash.length-1,e)}_ComputeDiff(e,t,i,n,o){const r=[!1];let s=this.ComputeDiffRecursive(e,t,i,n,r);return o&&(s=this.PrettifyChanges(s)),{quitEarly:r[0],changes:s}}ComputeDiffRecursive(e,t,i,o,r){for(r[0]=!1;e<=t&&i<=o&&this.ElementsAreEqual(e,i);)e++,i++;for(;t>=e&&o>=i&&this.ElementsAreEqual(t,o);)t--,o--;if(e>t||i>o){let r;return i<=o?(a.Assert(e===t+1,"originalStart should only be one more than originalEnd"),r=[new n.DiffChange(e,0,i,o-i+1)]):e<=t?(a.Assert(i===o+1,"modifiedStart should only be one more than modifiedEnd"),r=[new n.DiffChange(e,t-e+1,i,0)]):(a.Assert(e===t+1,"originalStart should only be one more than originalEnd"),a.Assert(i===o+1,"modifiedStart should only be one more than modifiedEnd"),r=[]),r}const s=[0],l=[0],c=this.ComputeRecursionPoint(e,t,i,o,s,l,r),d=s[0],u=l[0];if(null!==c)return c;if(!r[0]){const s=this.ComputeDiffRecursive(e,d,i,u,r);let a=[];return a=r[0]?[new n.DiffChange(d+1,t-(d+1)+1,u+1,o-(u+1)+1)]:this.ComputeDiffRecursive(d+1,t,u+1,o,r),this.ConcatenateChanges(s,a)}return[new n.DiffChange(e,t-e+1,i,o-i+1)]}WALKTRACE(e,t,i,o,r,s,a,l,d,u,h,g,p,m,f,b,_,A){let v=null,C=null,w=new c,y=t,S=i,x=p[0]-b[0]-o,E=-1073741824,k=this.m_forwardHistory.length-1;do{const t=x+e;t===y||t<S&&d[t-1]<d[t+1]?(m=(h=d[t+1])-x-o,h<E&&w.MarkNextChange(),E=h,w.AddModifiedElement(h+1,m),x=t+1-e):(m=(h=d[t-1]+1)-x-o,h<E&&w.MarkNextChange(),E=h-1,w.AddOriginalElement(h,m+1),x=t-1-e),k>=0&&(e=(d=this.m_forwardHistory[k])[0],y=1,S=d.length-1)}while(--k>=-1);if(v=w.getReverseChanges(),A[0]){let e=p[0]+1,t=b[0]+1;if(null!==v&&v.length>0){const i=v[v.length-1];e=Math.max(e,i.getOriginalEnd()),t=Math.max(t,i.getModifiedEnd())}C=[new n.DiffChange(e,g-e+1,t,f-t+1)]}else{w=new c,y=s,S=a,x=p[0]-b[0]-l,E=1073741824,k=_?this.m_reverseHistory.length-1:this.m_reverseHistory.length-2;do{const e=x+r;e===y||e<S&&u[e-1]>=u[e+1]?(m=(h=u[e+1]-1)-x-l,h>E&&w.MarkNextChange(),E=h+1,w.AddOriginalElement(h+1,m+1),x=e+1-r):(m=(h=u[e-1])-x-l,h>E&&w.MarkNextChange(),E=h,w.AddModifiedElement(h+1,m+1),x=e-1-r),k>=0&&(r=(u=this.m_reverseHistory[k])[0],y=1,S=u.length-1)}while(--k>=-1);C=w.getChanges()}return this.ConcatenateChanges(v,C)}ComputeRecursionPoint(e,t,i,o,r,s,a){let c=0,d=0,u=0,h=0,g=0,p=0;e--,i--,r[0]=0,s[0]=0,this.m_forwardHistory=[],this.m_reverseHistory=[];const m=t-e+(o-i),f=m+1,b=new Int32Array(f),_=new Int32Array(f),A=o-i,v=t-e,C=e-i,w=t-o,y=(v-A)%2==0;b[A]=e,_[v]=t,a[0]=!1;for(let S=1;S<=m/2+1;S++){let m=0,x=0;u=this.ClipDiagonalBound(A-S,S,A,f),h=this.ClipDiagonalBound(A+S,S,A,f);for(let e=u;e<=h;e+=2){c=e===u||e<h&&b[e-1]<b[e+1]?b[e+1]:b[e-1]+1,d=c-(e-A)-C;const i=c;for(;c<t&&d<o&&this.ElementsAreEqual(c+1,d+1);)c++,d++;if(b[e]=c,c+d>m+x&&(m=c,x=d),!y&&Math.abs(e-v)<=S-1&&c>=_[e])return r[0]=c,s[0]=d,i<=_[e]&&S<=1448?this.WALKTRACE(A,u,h,C,v,g,p,w,b,_,c,t,r,d,o,s,y,a):null}const E=(m-e+(x-i)-S)/2;if(null!==this.ContinueProcessingPredicate&&!this.ContinueProcessingPredicate(m,E))return a[0]=!0,r[0]=m,s[0]=x,E>0&&S<=1448?this.WALKTRACE(A,u,h,C,v,g,p,w,b,_,c,t,r,d,o,s,y,a):(e++,i++,[new n.DiffChange(e,t-e+1,i,o-i+1)]);g=this.ClipDiagonalBound(v-S,S,v,f),p=this.ClipDiagonalBound(v+S,S,v,f);for(let n=g;n<=p;n+=2){c=n===g||n<p&&_[n-1]>=_[n+1]?_[n+1]-1:_[n-1],d=c-(n-v)-w;const l=c;for(;c>e&&d>i&&this.ElementsAreEqual(c,d);)c--,d--;if(_[n]=c,y&&Math.abs(n-A)<=S&&c<=b[n])return r[0]=c,s[0]=d,l>=b[n]&&S<=1448?this.WALKTRACE(A,u,h,C,v,g,p,w,b,_,c,t,r,d,o,s,y,a):null}if(S<=1447){let e=new Int32Array(h-u+2);e[0]=A-u+1,l.Copy2(b,u,e,1,h-u+1),this.m_forwardHistory.push(e),e=new Int32Array(p-g+2),e[0]=v-g+1,l.Copy2(_,g,e,1,p-g+1),this.m_reverseHistory.push(e)}}return this.WALKTRACE(A,u,h,C,v,g,p,w,b,_,c,t,r,d,o,s,y,a)}PrettifyChanges(e){for(let t=0;t<e.length;t++){const i=e[t],n=t<e.length-1?e[t+1].originalStart:this._originalElementsOrHash.length,o=t<e.length-1?e[t+1].modifiedStart:this._modifiedElementsOrHash.length,r=i.originalLength>0,s=i.modifiedLength>0;for(;i.originalStart+i.originalLength<n&&i.modifiedStart+i.modifiedLength<o&&(!r||this.OriginalElementsAreEqual(i.originalStart,i.originalStart+i.originalLength))&&(!s||this.ModifiedElementsAreEqual(i.modifiedStart,i.modifiedStart+i.modifiedLength));){const e=this.ElementsAreStrictEqual(i.originalStart,i.modifiedStart);if(this.ElementsAreStrictEqual(i.originalStart+i.originalLength,i.modifiedStart+i.modifiedLength)&&!e)break;i.originalStart++,i.modifiedStart++}const a=[null];t<e.length-1&&this.ChangesOverlap(e[t],e[t+1],a)&&(e[t]=a[0],e.splice(t+1,1),t--)}for(let t=e.length-1;t>=0;t--){const i=e[t];let n=0,o=0;if(t>0){const i=e[t-1];n=i.originalStart+i.originalLength,o=i.modifiedStart+i.modifiedLength}const r=i.originalLength>0,s=i.modifiedLength>0;let a=0,l=this._boundaryScore(i.originalStart,i.originalLength,i.modifiedStart,i.modifiedLength);for(let e=1;;e++){const t=i.originalStart-e,c=i.modifiedStart-e;if(t<n||c<o)break;if(r&&!this.OriginalElementsAreEqual(t,t+i.originalLength))break;if(s&&!this.ModifiedElementsAreEqual(c,c+i.modifiedLength))break;const d=(t===n&&c===o?5:0)+this._boundaryScore(t,i.originalLength,c,i.modifiedLength);d>l&&(l=d,a=e)}i.originalStart-=a,i.modifiedStart-=a;const c=[null];t>0&&this.ChangesOverlap(e[t-1],e[t],c)&&(e[t-1]=c[0],e.splice(t,1),t++)}if(this._hasStrings)for(let t=1,i=e.length;t<i;t++){const i=e[t-1],n=e[t],o=n.originalStart-i.originalStart-i.originalLength,r=i.originalStart,s=n.originalStart+n.originalLength,a=s-r,l=i.modifiedStart,c=n.modifiedStart+n.modifiedLength,d=c-l;if(o<5&&a<20&&d<20){const e=this._findBetterContiguousSequence(r,a,l,d,o);if(e){const[t,r]=e;t===i.originalStart+i.originalLength&&r===i.modifiedStart+i.modifiedLength||(i.originalLength=t-i.originalStart,i.modifiedLength=r-i.modifiedStart,n.originalStart=t+o,n.modifiedStart=r+o,n.originalLength=s-n.originalStart,n.modifiedLength=c-n.modifiedStart)}}}return e}_findBetterContiguousSequence(e,t,i,n,o){if(t<o||n<o)return null;const r=e+t-o+1,s=i+n-o+1;let a=0,l=0,c=0;for(let t=e;t<r;t++)for(let e=i;e<s;e++){const i=this._contiguousSequenceScore(t,e,o);i>0&&i>a&&(a=i,l=t,c=e)}return a>0?[l,c]:null}_contiguousSequenceScore(e,t,i){let n=0;for(let o=0;o<i;o++){if(!this.ElementsAreEqual(e+o,t+o))return 0;n+=this._originalStringElements[e+o].length}return n}_OriginalIsBoundary(e){return e<=0||e>=this._originalElementsOrHash.length-1||this._hasStrings&&/^\s*$/.test(this._originalStringElements[e])}_OriginalRegionIsBoundary(e,t){if(this._OriginalIsBoundary(e)||this._OriginalIsBoundary(e-1))return!0;if(t>0){const i=e+t;if(this._OriginalIsBoundary(i-1)||this._OriginalIsBoundary(i))return!0}return!1}_ModifiedIsBoundary(e){return e<=0||e>=this._modifiedElementsOrHash.length-1||this._hasStrings&&/^\s*$/.test(this._modifiedStringElements[e])}_ModifiedRegionIsBoundary(e,t){if(this._ModifiedIsBoundary(e)||this._ModifiedIsBoundary(e-1))return!0;if(t>0){const i=e+t;if(this._ModifiedIsBoundary(i-1)||this._ModifiedIsBoundary(i))return!0}return!1}_boundaryScore(e,t,i,n){return(this._OriginalRegionIsBoundary(e,t)?1:0)+(this._ModifiedRegionIsBoundary(i,n)?1:0)}ConcatenateChanges(e,t){const i=[];if(0===e.length||0===t.length)return t.length>0?t:e;if(this.ChangesOverlap(e[e.length-1],t[0],i)){const n=new Array(e.length+t.length-1);return l.Copy(e,0,n,0,e.length-1),n[e.length-1]=i[0],l.Copy(t,1,n,e.length,t.length-1),n}{const i=new Array(e.length+t.length);return l.Copy(e,0,i,0,e.length),l.Copy(t,0,i,e.length,t.length),i}}ChangesOverlap(e,t,i){if(a.Assert(e.originalStart<=t.originalStart,"Left change is not less than or equal to right change"),a.Assert(e.modifiedStart<=t.modifiedStart,"Left change is not less than or equal to right change"),e.originalStart+e.originalLength>=t.originalStart||e.modifiedStart+e.modifiedLength>=t.modifiedStart){const o=e.originalStart;let r=e.originalLength;const s=e.modifiedStart;let a=e.modifiedLength;return e.originalStart+e.originalLength>=t.originalStart&&(r=t.originalStart+t.originalLength-e.originalStart),e.modifiedStart+e.modifiedLength>=t.modifiedStart&&(a=t.modifiedStart+t.modifiedLength-e.modifiedStart),i[0]=new n.DiffChange(o,r,s,a),!0}return i[0]=null,!1}ClipDiagonalBound(e,t,i,n){if(e>=0&&e<n)return e;const o=t%2==0;if(e<0){return o===(i%2==0)?0:1}return o===((n-i-1)%2==0)?n-1:n-2}}},97917:function(e,t,i){"use strict";i.r(t),i.d(t,{DiffChange:function(){return n}});class n{constructor(e,t,i,n){this.originalStart=e,this.originalLength=t,this.modifiedStart=i,this.modifiedLength=n}getOriginalEnd(){return this.originalStart+this.originalLength}getModifiedEnd(){return this.modifiedStart+this.modifiedLength}}},12718:function(e,t,i){"use strict";i.r(t),i.d(t,{BugIndicatingError:function(){return f},CancellationError:function(){return d},ErrorHandler:function(){return n},ErrorNoTelemetry:function(){return m},NotSupportedError:function(){return p},canceled:function(){return u},errorHandler:function(){return o},illegalArgument:function(){return h},illegalState:function(){return g},isCancellationError:function(){return c},onUnexpectedError:function(){return r},onUnexpectedExternalError:function(){return s},transformErrorForSerialization:function(){return a}});class n{constructor(){this.listeners=[],this.unexpectedErrorHandler=function(e){setTimeout((()=>{if(e.stack){if(m.isErrorNoTelemetry(e))throw new m(e.message+"\n\n"+e.stack);throw new Error(e.message+"\n\n"+e.stack)}throw e}),0)}}emit(e){this.listeners.forEach((t=>{t(e)}))}onUnexpectedError(e){this.unexpectedErrorHandler(e),this.emit(e)}onUnexpectedExternalError(e){this.unexpectedErrorHandler(e)}}const o=new n;function r(e){c(e)||o.onUnexpectedError(e)}function s(e){c(e)||o.onUnexpectedExternalError(e)}function a(e){if(e instanceof Error){const{name:t,message:i}=e;return{$isError:!0,name:t,message:i,stack:e.stacktrace||e.stack,noTelemetry:m.isErrorNoTelemetry(e)}}return e}const l="Canceled";function c(e){return e instanceof d||e instanceof Error&&e.name===l&&e.message===l}class d extends Error{constructor(){super(l),this.name=this.message}}function u(){const e=new Error(l);return e.name=e.message,e}function h(e){return e?new Error(`Illegal argument: ${e}`):new Error("Illegal argument")}function g(e){return e?new Error(`Illegal state: ${e}`):new Error("Illegal state")}class p extends Error{constructor(e){super("NotSupported"),e&&(this.message=e)}}class m extends Error{constructor(e){super(e),this.name="ErrorNoTelemetry"}static fromError(e){if(e instanceof m)return e;const t=new m;return t.message=e.message,t.stack=e.stack,t}static isErrorNoTelemetry(e){return"ErrorNoTelemetry"===e.name}}class f extends Error{constructor(e){super(e||"An unexpected bug occurred."),Object.setPrototypeOf(this,f.prototype)}}},63801:function(e,t,i){"use strict";i.r(t),i.d(t,{DebounceEmitter:function(){return f},Emitter:function(){return u},Event:function(){return a},EventBufferer:function(){return b},EventDeliveryQueue:function(){return h},PauseableEmitter:function(){return m},Relay:function(){return _}});var n=i(12718),o=i(68921),r=i(22446),s=i(702);var a;!function(e){function t(e){false}function i(e){return(t,i=null,n)=>{let o,r=!1;return o=e((e=>{if(!r)return o?o.dispose():r=!0,t.call(i,e)}),null,n),r&&o.dispose(),o}}function n(e,t,i){return l(((i,n=null,o)=>e((e=>i.call(n,t(e))),null,o)),i)}function r(e,t,i){return l(((i,n=null,o)=>e((e=>{t(e),i.call(n,e)}),null,o)),i)}function s(e,t,i){return l(((i,n=null,o)=>e((e=>t(e)&&i.call(n,e)),null,o)),i)}function a(e,t,i,o){let r=i;return n(e,(e=>(r=t(r,e),r)),o)}function l(e,i){let n;const o={onFirstListenerAdd(){n=e(r.fire,r)},onLastListenerRemove(){null==n||n.dispose()}};i||t();const r=new u(o);return null==i||i.add(r),r.event}function c(e,i,n=100,o=!1,r,s){let a,l,c,d=0;const h={leakWarningThreshold:r,onFirstListenerAdd(){a=e((e=>{d++,l=i(l,e),o&&!c&&(g.fire(l),l=void 0),clearTimeout(c),c=setTimeout((()=>{const e=l;l=void 0,c=void 0,(!o||d>1)&&g.fire(e),d=0}),n)}))},onLastListenerRemove(){a.dispose()}};s||t();const g=new u(h);return null==s||s.add(g),g.event}function d(e,t=((e,t)=>e===t),i){let n,o=!0;return s(e,(e=>{const i=o||!t(e,n);return o=!1,n=e,i}),i)}e.None=()=>o.Disposable.None,e.once=i,e.map=n,e.forEach=r,e.filter=s,e.signal=function(e){return e},e.any=function(...e){return(t,i=null,n)=>(0,o.combinedDisposable)(...e.map((e=>e((e=>t.call(i,e)),null,n))))},e.reduce=a,e.debounce=c,e.latch=d,e.split=function(t,i,n){return[e.filter(t,i,n),e.filter(t,(e=>!i(e)),n)]},e.buffer=function(e,t=!1,i=[]){let n=i.slice(),o=e((e=>{n?n.push(e):s.fire(e)}));const r=()=>{null==n||n.forEach((e=>s.fire(e))),n=null},s=new u({onFirstListenerAdd(){o||(o=e((e=>s.fire(e))))},onFirstListenerDidAdd(){n&&(t?setTimeout(r):r())},onLastListenerRemove(){o&&o.dispose(),o=null}});return s.event};class h{constructor(e){this.event=e,this.disposables=new o.DisposableStore}map(e){return new h(n(this.event,e,this.disposables))}forEach(e){return new h(r(this.event,e,this.disposables))}filter(e){return new h(s(this.event,e,this.disposables))}reduce(e,t){return new h(a(this.event,e,t,this.disposables))}latch(){return new h(d(this.event,void 0,this.disposables))}debounce(e,t=100,i=!1,n){return new h(c(this.event,e,t,i,n,this.disposables))}on(e,t,i){return this.event(e,t,i)}once(e,t,n){return i(this.event)(e,t,n)}dispose(){this.disposables.dispose()}}e.chain=function(e){return new h(e)},e.fromNodeEventEmitter=function(e,t,i=(e=>e)){const n=(...e)=>o.fire(i(...e)),o=new u({onFirstListenerAdd:()=>e.on(t,n),onLastListenerRemove:()=>e.removeListener(t,n)});return o.event},e.fromDOMEventEmitter=function(e,t,i=(e=>e)){const n=(...e)=>o.fire(i(...e)),o=new u({onFirstListenerAdd:()=>e.addEventListener(t,n),onLastListenerRemove:()=>e.removeEventListener(t,n)});return o.event},e.toPromise=function(e){return new Promise((t=>i(e)(t)))},e.runAndSubscribe=function(e,t){return t(void 0),e((e=>t(e)))},e.runAndSubscribeWithStore=function(e,t){let i=null;function n(e){null==i||i.dispose(),i=new o.DisposableStore,t(e,i)}n(void 0);const r=e((e=>n(e)));return(0,o.toDisposable)((()=>{r.dispose(),null==i||i.dispose()}))};class g{constructor(e,i){this.obs=e,this._counter=0,this._hasChanged=!1;const n={onFirstListenerAdd:()=>{e.addObserver(this)},onLastListenerRemove:()=>{e.removeObserver(this)}};i||t(),this.emitter=new u(n),i&&i.add(this.emitter)}beginUpdate(e){this._counter++}handleChange(e,t){this._hasChanged=!0}endUpdate(e){0==--this._counter&&this._hasChanged&&(this._hasChanged=!1,this.emitter.fire(this.obs.get()))}}e.fromObservable=function(e,t){return new g(e,t).emitter.event}}(a||(a={}));class l{constructor(e){this._listenerCount=0,this._invocationCount=0,this._elapsedOverall=0,this._name=`${e}_${l._idPool++}`}start(e){this._stopWatch=new s.StopWatch(!0),this._listenerCount=e}stop(){if(this._stopWatch){const e=this._stopWatch.elapsed();this._elapsedOverall+=e,this._invocationCount+=1,console.info(`did FIRE ${this._name}: elapsed_ms: ${e.toFixed(5)}, listener: ${this._listenerCount} (elapsed_overall: ${this._elapsedOverall.toFixed(2)}, invocations: ${this._invocationCount})`),this._stopWatch=void 0}}}l._idPool=0;class c{constructor(e){this.value=e}static create(){var e;return new c(null!==(e=(new Error).stack)&&void 0!==e?e:"")}print(){console.warn(this.value.split("\n").slice(2).join("\n"))}}class d{constructor(e,t,i){this.callback=e,this.callbackThis=t,this.stack=i,this.subscription=new o.SafeDisposable}invoke(e){this.callback.call(this.callbackThis,e)}}class u{constructor(e){var t,i;this._disposed=!1,this._options=e,this._leakageMon=void 0,this._perfMon=(null===(t=this._options)||void 0===t?void 0:t._profName)?new l(this._options._profName):void 0,this._deliveryQueue=null===(i=this._options)||void 0===i?void 0:i.deliveryQueue}dispose(){var e,t,i,n;this._disposed||(this._disposed=!0,this._listeners&&this._listeners.clear(),null===(e=this._deliveryQueue)||void 0===e||e.clear(this),null===(i=null===(t=this._options)||void 0===t?void 0:t.onLastListenerRemove)||void 0===i||i.call(t),null===(n=this._leakageMon)||void 0===n||n.dispose())}get event(){return this._event||(this._event=(e,t,i)=>{var n,s,a;this._listeners||(this._listeners=new r.LinkedList);const l=this._listeners.isEmpty();let u,h;l&&(null===(n=this._options)||void 0===n?void 0:n.onFirstListenerAdd)&&this._options.onFirstListenerAdd(this),this._leakageMon&&this._listeners.size>=30&&(h=c.create(),u=this._leakageMon.check(h,this._listeners.size+1));const g=new d(e,t,h),p=this._listeners.push(g);l&&(null===(s=this._options)||void 0===s?void 0:s.onFirstListenerDidAdd)&&this._options.onFirstListenerDidAdd(this),(null===(a=this._options)||void 0===a?void 0:a.onListenerDidAdd)&&this._options.onListenerDidAdd(this,e,t);const m=g.subscription.set((()=>{if(null==u||u(),!this._disposed&&(p(),this._options&&this._options.onLastListenerRemove)){this._listeners&&!this._listeners.isEmpty()||this._options.onLastListenerRemove(this)}}));return i instanceof o.DisposableStore?i.add(m):Array.isArray(i)&&i.push(m),m}),this._event}fire(e){var t,i;if(this._listeners){this._deliveryQueue||(this._deliveryQueue=new g);for(const t of this._listeners)this._deliveryQueue.push(this,t,e);null===(t=this._perfMon)||void 0===t||t.start(this._deliveryQueue.size),this._deliveryQueue.deliver(),null===(i=this._perfMon)||void 0===i||i.stop()}}}class h{constructor(){this._queue=new r.LinkedList}get size(){return this._queue.size}push(e,t,i){this._queue.push(new p(e,t,i))}clear(e){const t=new r.LinkedList;for(const i of this._queue)i.emitter!==e&&t.push(i);this._queue=t}deliver(){for(;this._queue.size>0;){const e=this._queue.shift();try{e.listener.invoke(e.event)}catch(e){(0,n.onUnexpectedError)(e)}}}}class g extends h{clear(e){this._queue.clear()}}class p{constructor(e,t,i){this.emitter=e,this.listener=t,this.event=i}}class m extends u{constructor(e){super(e),this._isPaused=0,this._eventQueue=new r.LinkedList,this._mergeFn=null==e?void 0:e.merge}pause(){this._isPaused++}resume(){if(0!==this._isPaused&&0==--this._isPaused)if(this._mergeFn){const e=Array.from(this._eventQueue);this._eventQueue.clear(),super.fire(this._mergeFn(e))}else for(;!this._isPaused&&0!==this._eventQueue.size;)super.fire(this._eventQueue.shift())}fire(e){this._listeners&&(0!==this._isPaused?this._eventQueue.push(e):super.fire(e))}}class f extends m{constructor(e){var t;super(e),this._delay=null!==(t=e.delay)&&void 0!==t?t:100}fire(e){this._handle||(this.pause(),this._handle=setTimeout((()=>{this._handle=void 0,this.resume()}),this._delay)),super.fire(e)}}class b{constructor(){this.buffers=[]}wrapEvent(e){return(t,i,n)=>e((e=>{const n=this.buffers[this.buffers.length-1];n?n.push((()=>t.call(i,e))):t.call(i,e)}),void 0,n)}bufferEvents(e){const t=[];this.buffers.push(t);const i=e();return this.buffers.pop(),t.forEach((e=>e())),i}}class _{constructor(){this.listening=!1,this.inputEvent=a.None,this.inputEventListener=o.Disposable.None,this.emitter=new u({onFirstListenerDidAdd:()=>{this.listening=!0,this.inputEventListener=this.inputEvent(this.emitter.fire,this.emitter)},onLastListenerRemove:()=>{this.listening=!1,this.inputEventListener.dispose()}}),this.event=this.emitter.event}set input(e){this.inputEvent=e,this.listening&&(this.inputEventListener.dispose(),this.inputEventListener=e(this.emitter.fire,this.emitter))}dispose(){this.inputEventListener.dispose(),this.emitter.dispose()}}},98508:function(e,t,i){"use strict";i.r(t),i.d(t,{getRoot:function(){return c},hasDriveLetter:function(){return h},isEqualOrParent:function(){return d},isPathSeparator:function(){return s},isWindowsDriveLetter:function(){return u},toPosixPath:function(){return l},toSlashes:function(){return a}});var n=i(23674),o=i(66719),r=i(91482);function s(e){return 47===e||92===e}function a(e){return e.replace(/[\\/]/g,n.posix.sep)}function l(e){return-1===e.indexOf("/")&&(e=a(e)),/^[a-zA-Z]:(\/|$)/.test(e)&&(e="/"+e),e}function c(e,t=n.posix.sep){if(!e)return"";const i=e.length,o=e.charCodeAt(0);if(s(o)){if(s(e.charCodeAt(1))&&!s(e.charCodeAt(2))){let n=3;const o=n;for(;n<i&&!s(e.charCodeAt(n));n++);if(o!==n&&!s(e.charCodeAt(n+1)))for(n+=1;n<i;n++)if(s(e.charCodeAt(n)))return e.slice(0,n+1).replace(/[\\/]/g,t)}return t}if(u(o)&&58===e.charCodeAt(1))return s(e.charCodeAt(2))?e.slice(0,2)+t:e.slice(0,2);let r=e.indexOf("://");if(-1!==r)for(r+=3;r<i;r++)if(s(e.charCodeAt(r)))return e.slice(0,r+1);return""}function d(e,t,i,o=n.sep){if(e===t)return!0;if(!e||!t)return!1;if(t.length>e.length)return!1;if(i){if(!(0,r.startsWithIgnoreCase)(e,t))return!1;if(t.length===e.length)return!0;let i=t.length;return t.charAt(t.length-1)===o&&i--,e.charAt(i)===o}return t.charAt(t.length-1)!==o&&(t+=o),0===e.indexOf(t)}function u(e){return e>=65&&e<=90||e>=97&&e<=122}function h(e,t=o.isWindows){return!!t&&(u(e.charCodeAt(0))&&58===e.charCodeAt(1))}},27017:function(e,t,i){"use strict";i.r(t),i.d(t,{FuzzyScore:function(){return Q},FuzzyScoreOptions:function(){return K},anyScore:function(){return L},createMatches:function(){return T},fuzzyScore:function(){return j},fuzzyScoreGracefulAggressive:function(){return $},isPatternInWord:function(){return U},isUpper:function(){return g},matchesCamelCase:function(){return w},matchesContiguousSubString:function(){return c},matchesFuzzy:function(){return D},matchesPrefix:function(){return a},matchesStrictPrefix:function(){return s},matchesSubString:function(){return d},matchesWords:function(){return y},or:function(){return r}});var n=i(13833),o=i(91482);function r(...e){return function(t,i){for(let n=0,o=e.length;n<o;n++){const o=e[n](t,i);if(o)return o}return null}}const s=l.bind(void 0,!1),a=l.bind(void 0,!0);function l(e,t,i){if(!i||i.length<t.length)return null;let n;return n=e?o.startsWithIgnoreCase(i,t):0===i.indexOf(t),n?t.length>0?[{start:0,end:t.length}]:[]:null}function c(e,t){const i=t.toLowerCase().indexOf(e.toLowerCase());return-1===i?null:[{start:i,end:i+e.length}]}function d(e,t){return u(e.toLowerCase(),t.toLowerCase(),0,0)}function u(e,t,i,n){if(i===e.length)return[];if(n===t.length)return null;if(e[i]===t[n]){let o=null;return(o=u(e,t,i+1,n+1))?A({start:n,end:n+1},o):null}return u(e,t,i,n+1)}function h(e){return 97<=e&&e<=122}function g(e){return 65<=e&&e<=90}function p(e){return 48<=e&&e<=57}function m(e){return 32===e||9===e||10===e||13===e}const f=new Set;function b(e){return m(e)||f.has(e)}function _(e){return h(e)||g(e)||p(e)}function A(e,t){return 0===t.length?t=[e]:e.end===t[0].start?t[0].start=e.start:t.unshift(e),t}function v(e,t){for(let i=t;i<e.length;i++){const t=e.charCodeAt(i);if(g(t)||p(t)||i>0&&!_(e.charCodeAt(i-1)))return i}return e.length}function C(e,t,i,n){if(i===e.length)return[];if(n===t.length)return null;if(e[i]!==t[n].toLowerCase())return null;{let o=null,r=n+1;for(o=C(e,t,i+1,n+1);!o&&(r=v(t,r))<t.length;)o=C(e,t,i+1,r),r++;return null===o?null:A({start:n,end:n+1},o)}}function w(e,t){if(!t)return null;if(0===(t=t.trim()).length)return null;if(!function(e){let t=0,i=0,n=0,o=0;for(let r=0;r<e.length;r++)n=e.charCodeAt(r),g(n)&&t++,h(n)&&i++,m(n)&&o++;return 0!==t&&0!==i||0!==o?t<=5:e.length<=30}(e))return null;if(t.length>60)return null;const i=function(e){let t=0,i=0,n=0,o=0,r=0;for(let s=0;s<e.length;s++)r=e.charCodeAt(s),g(r)&&t++,h(r)&&i++,_(r)&&n++,p(r)&&o++;return{upperPercent:t/e.length,lowerPercent:i/e.length,alphaPercent:n/e.length,numericPercent:o/e.length}}(t);if(!function(e){const{upperPercent:t,lowerPercent:i,alphaPercent:n,numericPercent:o}=e;return i>.2&&t<.8&&n>.6&&o<.2}(i)){if(!function(e){const{upperPercent:t,lowerPercent:i}=e;return 0===i&&t>.6}(i))return null;t=t.toLowerCase()}let n=null,o=0;for(e=e.toLowerCase();o<t.length&&null===(n=C(e,t,0,o));)o=v(t,o+1);return n}function y(e,t,i=!1){if(!t||0===t.length)return null;let n=null,o=0;for(e=e.toLowerCase(),t=t.toLowerCase();o<t.length&&null===(n=S(e,t,0,o,i));)o=x(t,o+1);return n}function S(e,t,i,n,o){if(i===e.length)return[];if(n===t.length)return null;if(r=e.charCodeAt(i),s=t.charCodeAt(n),r===s||b(r)&&b(s)){let r=null,s=n+1;if(r=S(e,t,i+1,n+1,o),!o)for(;!r&&(s=x(t,s))<t.length;)r=S(e,t,i+1,s,o),s++;return null===r?null:A({start:n,end:n+1},r)}return null;var r,s}function x(e,t){for(let i=t;i<e.length;i++)if(b(e.charCodeAt(i))||i>0&&b(e.charCodeAt(i-1)))return i;return e.length}"()[]{}<>`'\"-/;:,.?!".split("").forEach((e=>f.add(e.charCodeAt(0))));const E=r(a,w,c),k=r(a,w,d),I=new n.LRUCache(1e4);function D(e,t,i=!1){if("string"!=typeof e||"string"!=typeof t)return null;let n=I.get(e);n||(n=new RegExp(o.convertSimple2RegExpPattern(e),"i"),I.set(e,n));const r=n.exec(t);return r?[{start:r.index,end:r.index+r[0].length}]:i?k(e,t):E(e,t)}function L(e,t,i,n,o,r){const s=Math.min(13,e.length);for(;i<s;i++){const s=j(e,t,i,n,o,r,{firstMatchCanBeWeak:!1,boostFullMatch:!0});if(s)return s}return[0,r]}function T(e){if(void 0===e)return[];const t=[],i=e[1];for(let n=e.length-1;n>1;n--){const o=e[n]+i,r=t[t.length-1];r&&r.end===o?r.end=o+1:t.push({start:o,end:o+1})}return t}const M=128;function N(){const e=[],t=[];for(let e=0;e<=M;e++)t[e]=0;for(let i=0;i<=M;i++)e.push(t.slice(0));return e}function R(e){const t=[];for(let i=0;i<=e;i++)t[i]=0;return t}const B=R(256),O=R(256),F=N(),P=N(),z=N();function H(e,t){if(t<0||t>=e.length)return!1;const i=e.codePointAt(t);switch(i){case 95:case 45:case 46:case 32:case 47:case 92:case 39:case 34:case 58:case 36:case 60:case 62:case 40:case 41:case 91:case 93:case 123:case 125:return!0;case void 0:return!1;default:return!!o.isEmojiImprecise(i)}}function W(e,t){if(t<0||t>=e.length)return!1;switch(e.charCodeAt(t)){case 32:case 9:return!0;default:return!1}}function V(e,t,i){return t[e]!==i[e]}function U(e,t,i,n,o,r,s=!1){for(;t<i&&o<r;)e[t]===n[o]&&(s&&(B[t]=o),t+=1),o+=1;return t===i}var Q;!function(e){e.Default=[-100,0],e.isDefault=function(e){return!e||2===e.length&&-100===e[0]&&0===e[1]}}(Q||(Q={}));class K{constructor(e,t){this.firstMatchCanBeWeak=e,this.boostFullMatch=t}}function j(e,t,i,n,o,r,s=K.default){const a=e.length>M?M:e.length,l=n.length>M?M:n.length;if(i>=a||r>=l||a-i>l-r)return;if(!U(t,i,a,o,r,l,!0))return;!function(e,t,i,n,o,r){let s=e-1,a=t-1;for(;s>=i&&a>=n;)o[s]===r[a]&&(O[s]=a,s--),a--}(a,l,i,r,t,o);let c=1,d=1,u=i,h=r;const g=[!1];for(c=1,u=i;u<a;c++,u++){const s=B[u],p=O[u],m=u+1<a?O[u+1]:l;for(d=s-r+1,h=s;h<m;d++,h++){let a=Number.MIN_SAFE_INTEGER,m=!1;h<=p&&(a=G(e,t,u,i,n,o,h,l,r,0===F[c-1][d-1],g));let f=0;a!==Number.MAX_SAFE_INTEGER&&(m=!0,f=a+P[c-1][d-1]);const b=h>s,_=b?P[c][d-1]+(F[c][d-1]>0?-5:0):0,A=h>s+1&&F[c][d-1]>0,v=A?P[c][d-2]+(F[c][d-2]>0?-5:0):0;if(A&&(!b||v>=_)&&(!m||v>=f))P[c][d]=v,z[c][d]=3,F[c][d]=0;else if(b&&(!m||_>=f))P[c][d]=_,z[c][d]=2,F[c][d]=0;else{if(!m)throw new Error("not possible");P[c][d]=f,z[c][d]=1,F[c][d]=F[c-1][d-1]+1}}}if(!g[0]&&!s.firstMatchCanBeWeak)return;c--,d--;const p=[P[c][d],r];let m=0,f=0;for(;c>=1;){let e=d;do{const t=z[c][e];if(3===t)e-=2;else{if(2!==t)break;e-=1}}while(e>=1);m>1&&t[i+c-1]===o[r+d-1]&&!V(e+r-1,n,o)&&m+1>F[c][e]&&(e=d),e===d?m++:m=1,f||(f=e),c--,d=e-1,p.push(d)}l===a&&s.boostFullMatch&&(p[0]+=2);const b=f-a;return p[0]-=b,p}function G(e,t,i,n,o,r,s,a,l,c,d){if(t[i]!==r[s])return Number.MIN_SAFE_INTEGER;let u=1,h=!1;return s===i-n?u=e[i]===o[s]?7:5:!V(s,o,r)||0!==s&&V(s-1,o,r)?!H(r,s)||0!==s&&H(r,s-1)?(H(r,s-1)||W(r,s-1))&&(u=5,h=!0):u=5:(u=e[i]===o[s]?7:5,h=!0),u>1&&i===n&&(d[0]=!0),h||(h=V(s,o,r)||H(r,s-1)||W(r,s-1)),i===n?s>l&&(u-=h?3:5):u+=c?h?2:0:h?0:1,s+1===a&&(u-=h?3:5),u}function $(e,t,i,n,o,r,s){return function(e,t,i,n,o,r,s,a){let l=j(e,t,i,n,o,r,a);if(l&&!s)return l;if(e.length>=3){const t=Math.min(7,e.length-1);for(let s=i+1;s<t;s++){const t=Y(e,s);if(t){const e=j(t,t.toLowerCase(),i,n,o,r,a);e&&(e[0]-=3,(!l||e[0]>l[0])&&(l=e))}}}return l}(e,t,i,n,o,r,!0,s)}function Y(e,t){if(t+1>=e.length)return;const i=e[t],n=e[t+1];return i!==n?e.slice(0,t)+n+i+e.slice(t+2):void 0}K.default={boostFullMatch:!0,firstMatchCanBeWeak:!1}},40548:function(e,t,i){"use strict";function n(e){const t=this;let i,n=!1;return function(){return n||(n=!0,i=e.apply(t,arguments)),i}}i.r(t),i.d(t,{once:function(){return n}})},30997:function(e,t,i){"use strict";i.r(t),i.d(t,{GLOBSTAR:function(){return d},GLOB_SPLIT:function(){return u},isRelativePattern:function(){return N},match:function(){return T},parse:function(){return M},splitGlobAware:function(){return f}});var n=i(66129),o=i(98508),r=i(13833),s=i(23674),a=i(66719),l=i(91482),c=function(e,t,i,n){return new(i||(i=Promise))((function(o,r){function s(e){try{l(n.next(e))}catch(e){r(e)}}function a(e){try{l(n.throw(e))}catch(e){r(e)}}function l(e){var t;e.done?o(e.value):(t=e.value,t instanceof i?t:new i((function(e){e(t)}))).then(s,a)}l((n=n.apply(e,t||[])).next())}))};const d="**",u="/",h="[/\\\\]",g="[^/\\\\]",p=/\//g;function m(e,t){switch(e){case 0:return"";case 1:return"[^/\\\\]*?";default:return`(?:[/\\\\]|[^/\\\\]+[/\\\\]${t?"|[/\\\\][^/\\\\]+":""})*?`}}function f(e,t){if(!e)return[];const i=[];let n=!1,o=!1,r="";for(const s of e){switch(s){case t:if(!n&&!o){i.push(r),r="";continue}break;case"{":n=!0;break;case"}":n=!1;break;case"[":o=!0;break;case"]":o=!1}r+=s}return r&&i.push(r),i}function b(e){if(!e)return"";let t="";const i=f(e,u);if(i.every((e=>e===d)))t=".*";else{let e=!1;i.forEach(((n,o)=>{if(n===d){if(e)return;t+=m(2,o===i.length-1)}else{let e=!1,r="",s=!1,a="";for(const i of n)if("}"!==i&&e)r+=i;else if(!s||"]"===i&&a)switch(i){case"{":e=!0;continue;case"[":s=!0;continue;case"}":{const i=`(?:${f(r,",").map((e=>b(e))).join("|")})`;t+=i,e=!1,r="";break}case"]":t+="["+a+"]",s=!1,a="";break;case"?":t+=g;continue;case"*":t+=m(1);continue;default:t+=(0,l.escapeRegExpCharacters)(i)}else{let e;e="-"===i?i:"^"!==i&&"!"!==i||a?i===u?"":(0,l.escapeRegExpCharacters)(i):"^",a+=e}o<i.length-1&&(i[o+1]!==d||o+2<i.length)&&(t+=h)}e=n===d}))}return t}const _=/^\*\*\/\*\.[\w\.-]+$/,A=/^\*\*\/([\w\.-]+)\/?$/,v=/^{\*\*\/\*?[\w\.-]+\/?(,\*\*\/\*?[\w\.-]+\/?)*}$/,C=/^{\*\*\/\*?[\w\.-]+(\/(\*\*)?)?(,\*\*\/\*?[\w\.-]+(\/(\*\*)?)?)*}$/,w=/^\*\*((\/[\w\.-]+)+)\/?$/,y=/^([\w\.-]+(\/[\w\.-]+)*)\/?$/,S=new r.LRUCache(1e4),x=function(){return!1},E=function(){return null};function k(e,t){if(!e)return E;let i;i="string"!=typeof e?e.pattern:e,i=i.trim();const n=`${i}_${!!t.trimForExclusions}`;let o,r=S.get(n);return r||(r=_.test(i)?function(e,t){return function(i,n){return"string"==typeof i&&i.endsWith(e)?t:null}}(i.substr(4),i):(o=A.exec(D(i,t)))?function(e,t){const i=`/${e}`,n=`\\${e}`,o=function(o,r){return"string"!=typeof o?null:r?r===e?t:null:o===e||o.endsWith(i)||o.endsWith(n)?t:null},r=[e];return o.basenames=r,o.patterns=[t],o.allBasenames=r,o}(o[1],i):(t.trimForExclusions?C:v).test(i)?function(e,t){const i=R(e.slice(1,-1).split(",").map((e=>k(e,t))).filter((e=>e!==E)),e),n=i.length;if(!n)return E;if(1===n)return i[0];const o=function(t,n){for(let o=0,r=i.length;o<r;o++)if(i[o](t,n))return e;return null},r=i.find((e=>!!e.allBasenames));r&&(o.allBasenames=r.allBasenames);const s=i.reduce(((e,t)=>t.allPaths?e.concat(t.allPaths):e),[]);s.length&&(o.allPaths=s);return o}(i,t):(o=w.exec(D(i,t)))?L(o[1].substr(1),i,!0):(o=y.exec(D(i,t)))?L(o[1],i,!1):function(e){try{const t=new RegExp(`^${b(e)}$`);return function(i){return t.lastIndex=0,"string"==typeof i&&t.test(i)?e:null}}catch(e){return E}}(i),S.set(n,r)),I(r,e)}function I(e,t){if("string"==typeof t)return e;const i=function(i,n){return(0,o.isEqualOrParent)(i,t.base,!a.isLinux)?e(i.substr(t.base.length+1),n):null};return i.allBasenames=e.allBasenames,i.allPaths=e.allPaths,i.basenames=e.basenames,i.patterns=e.patterns,i}function D(e,t){return t.trimForExclusions&&e.endsWith("/**")?e.substr(0,e.length-2):e}function L(e,t,i){const n=s.sep===s.posix.sep,o=n?e:e.replace(p,s.sep),r=s.sep+o,a=s.posix.sep+e;let l;return l=i?function(i,s){return"string"!=typeof i||i!==o&&!i.endsWith(r)&&(n||i!==e&&!i.endsWith(a))?null:t}:function(i,r){return"string"!=typeof i||i!==o&&(n||i!==e)?null:t},l.allPaths=[(i?"*/":"./")+e],l}function T(e,t,i){return!(!e||"string"!=typeof t)&&M(e)(t,void 0,i)}function M(e,t={}){if(!e)return x;if("string"==typeof e||N(e)){const i=k(e,t);if(i===E)return x;const n=function(e,t){return!!i(e,t)};return i.allBasenames&&(n.allBasenames=i.allBasenames),i.allPaths&&(n.allPaths=i.allPaths),n}return function(e,t){const i=R(Object.getOwnPropertyNames(e).map((i=>function(e,t,i){if(!1===t)return E;const o=k(e,i);if(o===E)return E;if("boolean"==typeof t)return o;if(t){const i=t.when;if("string"==typeof i){const t=(t,r,s,a)=>{if(!a||!o(t,r))return null;const l=a(i.replace("$(basename)",s));return(0,n.isThenable)(l)?l.then((t=>t?e:null)):l?e:null};return t.requiresSiblings=!0,t}}return o}(i,e[i],t))).filter((e=>e!==E))),o=i.length;if(!o)return E;if(!i.some((e=>!!e.requiresSiblings))){if(1===o)return i[0];const e=function(e,t){let o;for(let r=0,s=i.length;r<s;r++){const s=i[r](e,t);if("string"==typeof s)return s;(0,n.isThenable)(s)&&(o||(o=[]),o.push(s))}return o?(()=>c(this,void 0,void 0,(function*(){for(const e of o){const t=yield e;if("string"==typeof t)return t}return null})))():null},t=i.find((e=>!!e.allBasenames));t&&(e.allBasenames=t.allBasenames);const r=i.reduce(((e,t)=>t.allPaths?e.concat(t.allPaths):e),[]);return r.length&&(e.allPaths=r),e}const r=function(e,t,o){let r,a;for(let l=0,c=i.length;l<c;l++){const c=i[l];c.requiresSiblings&&o&&(t||(t=(0,s.basename)(e)),r||(r=t.substr(0,t.length-(0,s.extname)(e).length)));const d=c(e,t,r,o);if("string"==typeof d)return d;(0,n.isThenable)(d)&&(a||(a=[]),a.push(d))}return a?(()=>c(this,void 0,void 0,(function*(){for(const e of a){const t=yield e;if("string"==typeof t)return t}return null})))():null},a=i.find((e=>!!e.allBasenames));a&&(r.allBasenames=a.allBasenames);const l=i.reduce(((e,t)=>t.allPaths?e.concat(t.allPaths):e),[]);l.length&&(r.allPaths=l);return r}(e,t)}function N(e){const t=e;return!!t&&("string"==typeof t.base&&"string"==typeof t.pattern)}function R(e,t){const i=e.filter((e=>!!e.basenames));if(i.length<2)return e;const n=i.reduce(((e,t)=>{const i=t.basenames;return i?e.concat(i):e}),[]);let o;if(t){o=[];for(let e=0,i=n.length;e<i;e++)o.push(t)}else o=i.reduce(((e,t)=>{const i=t.patterns;return i?e.concat(i):e}),[]);const r=function(e,t){if("string"!=typeof e)return null;if(!t){let i;for(i=e.length;i>0;i--){const t=e.charCodeAt(i-1);if(47===t||92===t)break}t=e.substr(i)}const i=n.indexOf(t);return-1!==i?o[i]:null};r.basenames=n,r.patterns=o,r.allBasenames=n;const s=e.filter((e=>!e.basenames));return s.push(r),s}},23829:function(e,t,i){"use strict";i.r(t),i.d(t,{StringSHA1:function(){return u},doHash:function(){return r},hash:function(){return o},numberHash:function(){return s},stringHash:function(){return a},toHexString:function(){return d}});var n=i(91482);function o(e){return r(e,0)}function r(e,t){switch(typeof e){case"object":return null===e?s(349,t):Array.isArray(e)?(i=e,n=s(104579,n=t),i.reduce(((e,t)=>r(t,e)),n)):function(e,t){return t=s(181387,t),Object.keys(e).sort().reduce(((t,i)=>(t=a(i,t),r(e[i],t))),t)}(e,t);case"string":return a(e,t);case"boolean":return function(e,t){return s(e?433:863,t)}(e,t);case"number":return s(e,t);case"undefined":return s(937,t);default:return s(617,t)}var i,n}function s(e,t){return(t<<5)-t+e|0}function a(e,t){t=s(149417,t);for(let i=0,n=e.length;i<n;i++)t=s(e.charCodeAt(i),t);return t}function l(e,t,i=32){const n=i-t;return(e<<t|(~((1<<n)-1)&e)>>>n)>>>0}function c(e,t=0,i=e.byteLength,n=0){for(let o=0;o<i;o++)e[t+o]=n}function d(e,t=32){return e instanceof ArrayBuffer?Array.from(new Uint8Array(e)).map((e=>e.toString(16).padStart(2,"0"))).join(""):function(e,t,i="0"){for(;e.length<t;)e=i+e;return e}((e>>>0).toString(16),t/4)}class u{constructor(){this._h0=1732584193,this._h1=4023233417,this._h2=2562383102,this._h3=271733878,this._h4=3285377520,this._buff=new Uint8Array(67),this._buffDV=new DataView(this._buff.buffer),this._buffLen=0,this._totalLen=0,this._leftoverHighSurrogate=0,this._finished=!1}update(e){const t=e.length;if(0===t)return;const i=this._buff;let o,r,s=this._buffLen,a=this._leftoverHighSurrogate;for(0!==a?(o=a,r=-1,a=0):(o=e.charCodeAt(0),r=0);;){let l=o;if(n.isHighSurrogate(o)){if(!(r+1<t)){a=o;break}{const t=e.charCodeAt(r+1);n.isLowSurrogate(t)?(r++,l=n.computeCodePoint(o,t)):l=65533}}else n.isLowSurrogate(o)&&(l=65533);if(s=this._push(i,s,l),r++,!(r<t))break;o=e.charCodeAt(r)}this._buffLen=s,this._leftoverHighSurrogate=a}_push(e,t,i){return i<128?e[t++]=i:i<2048?(e[t++]=192|(1984&i)>>>6,e[t++]=128|(63&i)>>>0):i<65536?(e[t++]=224|(61440&i)>>>12,e[t++]=128|(4032&i)>>>6,e[t++]=128|(63&i)>>>0):(e[t++]=240|(1835008&i)>>>18,e[t++]=128|(258048&i)>>>12,e[t++]=128|(4032&i)>>>6,e[t++]=128|(63&i)>>>0),t>=64&&(this._step(),t-=64,this._totalLen+=64,e[0]=e[64],e[1]=e[65],e[2]=e[66]),t}digest(){return this._finished||(this._finished=!0,this._leftoverHighSurrogate&&(this._leftoverHighSurrogate=0,this._buffLen=this._push(this._buff,this._buffLen,65533)),this._totalLen+=this._buffLen,this._wrapUp()),d(this._h0)+d(this._h1)+d(this._h2)+d(this._h3)+d(this._h4)}_wrapUp(){this._buff[this._buffLen++]=128,c(this._buff,this._buffLen),this._buffLen>56&&(this._step(),c(this._buff));const e=8*this._totalLen;this._buffDV.setUint32(56,Math.floor(e/4294967296),!1),this._buffDV.setUint32(60,e%4294967296,!1),this._step()}_step(){const e=u._bigBlock32,t=this._buffDV;for(let i=0;i<64;i+=4)e.setUint32(i,t.getUint32(i,!1),!1);for(let t=64;t<320;t+=4)e.setUint32(t,l(e.getUint32(t-12,!1)^e.getUint32(t-32,!1)^e.getUint32(t-56,!1)^e.getUint32(t-64,!1),1),!1);let i,n,o,r=this._h0,s=this._h1,a=this._h2,c=this._h3,d=this._h4;for(let t=0;t<80;t++)t<20?(i=s&a|~s&c,n=1518500249):t<40?(i=s^a^c,n=1859775393):t<60?(i=s&a|s&c|a&c,n=2400959708):(i=s^a^c,n=3395469782),o=l(r,5)+i+d+n+e.getUint32(4*t,!1)&4294967295,d=c,c=a,a=l(s,30),s=r,r=o;this._h0=this._h0+r&4294967295,this._h1=this._h1+s&4294967295,this._h2=this._h2+a&4294967295,this._h3=this._h3+c&4294967295,this._h4=this._h4+d&4294967295}}u._bigBlock32=new DataView(new ArrayBuffer(320))},68538:function(e,t,i){"use strict";i.r(t),i.d(t,{HistoryNavigator:function(){return o}});var n=i(27582);class o{constructor(e=[],t=10){this._initialize(e),this._limit=t,this._onChange()}getHistory(){return this._elements}add(e){this._history.delete(e),this._history.add(e),this._onChange()}next(){return this._currentPosition()!==this._elements.length-1?this._navigator.next():null}previous(){return 0!==this._currentPosition()?this._navigator.previous():null}current(){return this._navigator.current()}first(){return this._navigator.first()}last(){return this._navigator.last()}has(e){return this._history.has(e)}_onChange(){this._reduceToLimit();const e=this._elements;this._navigator=new n.ArrayNavigator(e,0,e.length,e.length)}_reduceToLimit(){const e=this._elements;e.length>this._limit&&this._initialize(e.slice(e.length-this._limit))}_currentPosition(){const e=this._navigator.current();return e?this._elements.indexOf(e):-1}_initialize(e){this._history=new Set;for(const t of e)this._history.add(t)}get _elements(){const e=[];return this._history.forEach((t=>e.push(t))),e}}},25674:function(e,t,i){"use strict";i.r(t),i.d(t,{MarkdownString:function(){return s},escapeDoubleQuotes:function(){return d},escapeMarkdownSyntaxTokens:function(){return c},isEmptyMarkdownString:function(){return a},isMarkdownString:function(){return l},parseHrefAndDimensions:function(){return h},removeMarkdownEscapes:function(){return u}});var n=i(12718),o=i(69373),r=i(91482);class s{constructor(e="",t=!1){var i,o,r;if(this.value=e,"string"!=typeof this.value)throw(0,n.illegalArgument)("value");"boolean"==typeof t?(this.isTrusted=t,this.supportThemeIcons=!1,this.supportHtml=!1):(this.isTrusted=null!==(i=t.isTrusted)&&void 0!==i?i:void 0,this.supportThemeIcons=null!==(o=t.supportThemeIcons)&&void 0!==o&&o,this.supportHtml=null!==(r=t.supportHtml)&&void 0!==r&&r)}appendText(e,t=0){return this.value+=c(this.supportThemeIcons?(0,o.escapeIcons)(e):e).replace(/([ \t]+)/g,((e,t)=>"&nbsp;".repeat(t.length))).replace(/\>/gm,"\\>").replace(/\n/g,1===t?"\\\n":"\n\n"),this}appendMarkdown(e){return this.value+=e,this}appendCodeblock(e,t){return this.value+="\n```",this.value+=e,this.value+="\n",this.value+=t,this.value+="\n```\n",this}appendLink(e,t,i){return this.value+="[",this.value+=this._escape(t,"]"),this.value+="](",this.value+=this._escape(String(e),")"),i&&(this.value+=` "${this._escape(this._escape(i,'"'),")")}"`),this.value+=")",this}_escape(e,t){const i=new RegExp((0,r.escapeRegExpCharacters)(t),"g");return e.replace(i,((t,i)=>"\\"!==e.charAt(i-1)?`\\${t}`:t))}}function a(e){return l(e)?!e.value:!Array.isArray(e)||e.every(a)}function l(e){return e instanceof s||!(!e||"object"!=typeof e)&&!("string"!=typeof e.value||"boolean"!=typeof e.isTrusted&&void 0!==e.isTrusted||"boolean"!=typeof e.supportThemeIcons&&void 0!==e.supportThemeIcons)}function c(e){return e.replace(/[\\`*_{}[\]()#+\-!]/g,"\\$&")}function d(e){return e.replace(/"/g,"&quot;")}function u(e){return e?e.replace(/\\([\\`*_{}[\]()#+\-.!])/g,"$1"):e}function h(e){const t=[],i=e.split("|").map((e=>e.trim()));e=i[0];const n=i[1];if(n){const e=/height=(\d+)/.exec(n),i=/width=(\d+)/.exec(n),o=e?e[1]:"",r=i?i[1]:"",s=isFinite(parseInt(r)),a=isFinite(parseInt(o));s&&t.push(`width="${r}"`),a&&t.push(`height="${o}"`)}return{href:e,dimensions:t}}},69373:function(e,t,i){"use strict";i.r(t),i.d(t,{escapeIcons:function(){return d},iconStartMarker:function(){return s},markdownEscapeEscapedIcons:function(){return h},matchesFuzzyIconAware:function(){return f},parseLabelWithIcons:function(){return m},stripIcons:function(){return p}});var n=i(56087),o=i(27017),r=i(91482);const s="$(",a=new RegExp(`\\$\\(${n.CSSIcon.iconNameExpression}(?:${n.CSSIcon.iconModifierExpression})?\\)`,"g"),l=new RegExp(n.CSSIcon.iconNameCharacter),c=new RegExp(`(\\\\)?${a.source}`,"g");function d(e){return e.replace(c,((e,t)=>t?e:`\\${e}`))}const u=new RegExp(`\\\\${a.source}`,"g");function h(e){return e.replace(u,(e=>`\\${e}`))}const g=new RegExp(`(\\s)?(\\\\)?${a.source}(\\s)?`,"g");function p(e){return-1===e.indexOf(s)?e:e.replace(g,((e,t,i,n)=>i?e:t||n||""))}function m(e){const t=e.indexOf(s);return-1===t?{text:e}:function(e,t){const i=[];let n="";function o(e){if(e){n+=e;for(const t of e)i.push(u)}}let r,a,c=-1,d="",u=0,h=t;const g=e.length;o(e.substr(0,t));for(;h<g;){if(r=e[h],a=e[h+1],r===s[0]&&a===s[1])c=h,o(d),d=s,h++;else if(")"===r&&-1!==c){u+=h-c+1,c=-1,d=""}else-1!==c?l.test(r)?d+=r:(o(d),c=-1,d=""):o(r);h++}return o(d),{text:n,iconOffsets:i}}(e,t)}function f(e,t,i=!1){const{text:n,iconOffsets:s}=t;if(!s||0===s.length)return(0,o.matchesFuzzy)(e,n,i);const a=(0,r.ltrim)(n," "),l=n.length-a.length,c=(0,o.matchesFuzzy)(e,a,i);if(c)for(const e of c){const t=s[e.start+l]+l;e.start+=t,e.end+=t}return c}},60538:function(e,t,i){"use strict";i.r(t),i.d(t,{IdGenerator:function(){return n},defaultGenerator:function(){return o}});class n{constructor(e){this._prefix=e,this._lastId=0}nextId(){return this._prefix+ ++this._lastId}}const o=new n("id#")},24417:function(e,t,i){"use strict";var n;i.r(t),i.d(t,{Iterable:function(){return n}}),function(e){e.is=function(e){return e&&"object"==typeof e&&"function"==typeof e[Symbol.iterator]};const t=Object.freeze([]);function i(t,i=Number.POSITIVE_INFINITY){const n=[];if(0===i)return[n,t];const o=t[Symbol.iterator]();for(let t=0;t<i;t++){const t=o.next();if(t.done)return[n,e.empty()];n.push(t.value)}return[n,{[Symbol.iterator](){return o}}]}e.empty=function(){return t},e.single=function*(e){yield e},e.from=function(e){return e||t},e.isEmpty=function(e){return!e||!0===e[Symbol.iterator]().next().done},e.first=function(e){return e[Symbol.iterator]().next().value},e.some=function(e,t){for(const i of e)if(t(i))return!0;return!1},e.find=function(e,t){for(const i of e)if(t(i))return i},e.filter=function*(e,t){for(const i of e)t(i)&&(yield i)},e.map=function*(e,t){let i=0;for(const n of e)yield t(n,i++)},e.concat=function*(...e){for(const t of e)for(const e of t)yield e},e.concatNested=function*(e){for(const t of e)for(const e of t)yield e},e.reduce=function(e,t,i){let n=i;for(const i of e)n=t(n,i);return n},e.forEach=function(e,t){let i=0;for(const n of e)t(n,i++)},e.slice=function*(e,t,i=e.length){for(t<0&&(t+=e.length),i<0?i+=e.length:i>e.length&&(i=e.length);t<i;t++)yield e[t]},e.consume=i,e.collect=function(e){return i(e)[0]},e.equals=function(e,t,i=((e,t)=>e===t)){const n=e[Symbol.iterator](),o=t[Symbol.iterator]();for(;;){const e=n.next(),t=o.next();if(e.done!==t.done)return!1;if(e.done)return!0;if(!i(e.value,t.value))return!1}}}(n||(n={}))},98070:function(e,t,i){"use strict";i.r(t),i.d(t,{EVENT_KEY_CODE_MAP:function(){return a},IMMUTABLE_CODE_TO_KEY_CODE:function(){return h},IMMUTABLE_KEY_CODE_TO_CODE:function(){return g},KeyChord:function(){return m},KeyCodeUtils:function(){return p},NATIVE_WINDOWS_KEY_CODE_TO_KEY_CODE:function(){return l}});class n{constructor(){this._keyCodeToStr=[],this._strToKeyCode=Object.create(null)}define(e,t){this._keyCodeToStr[e]=t,this._strToKeyCode[t.toLowerCase()]=e}keyCodeToStr(e){return this._keyCodeToStr[e]}strToKeyCode(e){return this._strToKeyCode[e.toLowerCase()]||0}}const o=new n,r=new n,s=new n,a=new Array(230),l={},c=[],d=Object.create(null),u=Object.create(null),h=[],g=[];for(let e=0;e<=193;e++)h[e]=-1;for(let e=0;e<=127;e++)g[e]=-1;var p;function m(e,t){return(e|(65535&t)<<16>>>0)>>>0}!function(){const e="",t=[[0,1,0,"None",0,"unknown",0,"VK_UNKNOWN",e,e],[0,1,1,"Hyper",0,e,0,e,e,e],[0,1,2,"Super",0,e,0,e,e,e],[0,1,3,"Fn",0,e,0,e,e,e],[0,1,4,"FnLock",0,e,0,e,e,e],[0,1,5,"Suspend",0,e,0,e,e,e],[0,1,6,"Resume",0,e,0,e,e,e],[0,1,7,"Turbo",0,e,0,e,e,e],[0,1,8,"Sleep",0,e,0,"VK_SLEEP",e,e],[0,1,9,"WakeUp",0,e,0,e,e,e],[31,0,10,"KeyA",31,"A",65,"VK_A",e,e],[32,0,11,"KeyB",32,"B",66,"VK_B",e,e],[33,0,12,"KeyC",33,"C",67,"VK_C",e,e],[34,0,13,"KeyD",34,"D",68,"VK_D",e,e],[35,0,14,"KeyE",35,"E",69,"VK_E",e,e],[36,0,15,"KeyF",36,"F",70,"VK_F",e,e],[37,0,16,"KeyG",37,"G",71,"VK_G",e,e],[38,0,17,"KeyH",38,"H",72,"VK_H",e,e],[39,0,18,"KeyI",39,"I",73,"VK_I",e,e],[40,0,19,"KeyJ",40,"J",74,"VK_J",e,e],[41,0,20,"KeyK",41,"K",75,"VK_K",e,e],[42,0,21,"KeyL",42,"L",76,"VK_L",e,e],[43,0,22,"KeyM",43,"M",77,"VK_M",e,e],[44,0,23,"KeyN",44,"N",78,"VK_N",e,e],[45,0,24,"KeyO",45,"O",79,"VK_O",e,e],[46,0,25,"KeyP",46,"P",80,"VK_P",e,e],[47,0,26,"KeyQ",47,"Q",81,"VK_Q",e,e],[48,0,27,"KeyR",48,"R",82,"VK_R",e,e],[49,0,28,"KeyS",49,"S",83,"VK_S",e,e],[50,0,29,"KeyT",50,"T",84,"VK_T",e,e],[51,0,30,"KeyU",51,"U",85,"VK_U",e,e],[52,0,31,"KeyV",52,"V",86,"VK_V",e,e],[53,0,32,"KeyW",53,"W",87,"VK_W",e,e],[54,0,33,"KeyX",54,"X",88,"VK_X",e,e],[55,0,34,"KeyY",55,"Y",89,"VK_Y",e,e],[56,0,35,"KeyZ",56,"Z",90,"VK_Z",e,e],[22,0,36,"Digit1",22,"1",49,"VK_1",e,e],[23,0,37,"Digit2",23,"2",50,"VK_2",e,e],[24,0,38,"Digit3",24,"3",51,"VK_3",e,e],[25,0,39,"Digit4",25,"4",52,"VK_4",e,e],[26,0,40,"Digit5",26,"5",53,"VK_5",e,e],[27,0,41,"Digit6",27,"6",54,"VK_6",e,e],[28,0,42,"Digit7",28,"7",55,"VK_7",e,e],[29,0,43,"Digit8",29,"8",56,"VK_8",e,e],[30,0,44,"Digit9",30,"9",57,"VK_9",e,e],[21,0,45,"Digit0",21,"0",48,"VK_0",e,e],[3,1,46,"Enter",3,"Enter",13,"VK_RETURN",e,e],[9,1,47,"Escape",9,"Escape",27,"VK_ESCAPE",e,e],[1,1,48,"Backspace",1,"Backspace",8,"VK_BACK",e,e],[2,1,49,"Tab",2,"Tab",9,"VK_TAB",e,e],[10,1,50,"Space",10,"Space",32,"VK_SPACE",e,e],[83,0,51,"Minus",83,"-",189,"VK_OEM_MINUS","-","OEM_MINUS"],[81,0,52,"Equal",81,"=",187,"VK_OEM_PLUS","=","OEM_PLUS"],[87,0,53,"BracketLeft",87,"[",219,"VK_OEM_4","[","OEM_4"],[89,0,54,"BracketRight",89,"]",221,"VK_OEM_6","]","OEM_6"],[88,0,55,"Backslash",88,"\\",220,"VK_OEM_5","\\","OEM_5"],[0,0,56,"IntlHash",0,e,0,e,e,e],[80,0,57,"Semicolon",80,";",186,"VK_OEM_1",";","OEM_1"],[90,0,58,"Quote",90,"'",222,"VK_OEM_7","'","OEM_7"],[86,0,59,"Backquote",86,"`",192,"VK_OEM_3","`","OEM_3"],[82,0,60,"Comma",82,",",188,"VK_OEM_COMMA",",","OEM_COMMA"],[84,0,61,"Period",84,".",190,"VK_OEM_PERIOD",".","OEM_PERIOD"],[85,0,62,"Slash",85,"/",191,"VK_OEM_2","/","OEM_2"],[8,1,63,"CapsLock",8,"CapsLock",20,"VK_CAPITAL",e,e],[59,1,64,"F1",59,"F1",112,"VK_F1",e,e],[60,1,65,"F2",60,"F2",113,"VK_F2",e,e],[61,1,66,"F3",61,"F3",114,"VK_F3",e,e],[62,1,67,"F4",62,"F4",115,"VK_F4",e,e],[63,1,68,"F5",63,"F5",116,"VK_F5",e,e],[64,1,69,"F6",64,"F6",117,"VK_F6",e,e],[65,1,70,"F7",65,"F7",118,"VK_F7",e,e],[66,1,71,"F8",66,"F8",119,"VK_F8",e,e],[67,1,72,"F9",67,"F9",120,"VK_F9",e,e],[68,1,73,"F10",68,"F10",121,"VK_F10",e,e],[69,1,74,"F11",69,"F11",122,"VK_F11",e,e],[70,1,75,"F12",70,"F12",123,"VK_F12",e,e],[0,1,76,"PrintScreen",0,e,0,e,e,e],[79,1,77,"ScrollLock",79,"ScrollLock",145,"VK_SCROLL",e,e],[7,1,78,"Pause",7,"PauseBreak",19,"VK_PAUSE",e,e],[19,1,79,"Insert",19,"Insert",45,"VK_INSERT",e,e],[14,1,80,"Home",14,"Home",36,"VK_HOME",e,e],[11,1,81,"PageUp",11,"PageUp",33,"VK_PRIOR",e,e],[20,1,82,"Delete",20,"Delete",46,"VK_DELETE",e,e],[13,1,83,"End",13,"End",35,"VK_END",e,e],[12,1,84,"PageDown",12,"PageDown",34,"VK_NEXT",e,e],[17,1,85,"ArrowRight",17,"RightArrow",39,"VK_RIGHT","Right",e],[15,1,86,"ArrowLeft",15,"LeftArrow",37,"VK_LEFT","Left",e],[18,1,87,"ArrowDown",18,"DownArrow",40,"VK_DOWN","Down",e],[16,1,88,"ArrowUp",16,"UpArrow",38,"VK_UP","Up",e],[78,1,89,"NumLock",78,"NumLock",144,"VK_NUMLOCK",e,e],[108,1,90,"NumpadDivide",108,"NumPad_Divide",111,"VK_DIVIDE",e,e],[103,1,91,"NumpadMultiply",103,"NumPad_Multiply",106,"VK_MULTIPLY",e,e],[106,1,92,"NumpadSubtract",106,"NumPad_Subtract",109,"VK_SUBTRACT",e,e],[104,1,93,"NumpadAdd",104,"NumPad_Add",107,"VK_ADD",e,e],[3,1,94,"NumpadEnter",3,e,0,e,e,e],[94,1,95,"Numpad1",94,"NumPad1",97,"VK_NUMPAD1",e,e],[95,1,96,"Numpad2",95,"NumPad2",98,"VK_NUMPAD2",e,e],[96,1,97,"Numpad3",96,"NumPad3",99,"VK_NUMPAD3",e,e],[97,1,98,"Numpad4",97,"NumPad4",100,"VK_NUMPAD4",e,e],[98,1,99,"Numpad5",98,"NumPad5",101,"VK_NUMPAD5",e,e],[99,1,100,"Numpad6",99,"NumPad6",102,"VK_NUMPAD6",e,e],[100,1,101,"Numpad7",100,"NumPad7",103,"VK_NUMPAD7",e,e],[101,1,102,"Numpad8",101,"NumPad8",104,"VK_NUMPAD8",e,e],[102,1,103,"Numpad9",102,"NumPad9",105,"VK_NUMPAD9",e,e],[93,1,104,"Numpad0",93,"NumPad0",96,"VK_NUMPAD0",e,e],[107,1,105,"NumpadDecimal",107,"NumPad_Decimal",110,"VK_DECIMAL",e,e],[92,0,106,"IntlBackslash",92,"OEM_102",226,"VK_OEM_102",e,e],[58,1,107,"ContextMenu",58,"ContextMenu",93,e,e,e],[0,1,108,"Power",0,e,0,e,e,e],[0,1,109,"NumpadEqual",0,e,0,e,e,e],[71,1,110,"F13",71,"F13",124,"VK_F13",e,e],[72,1,111,"F14",72,"F14",125,"VK_F14",e,e],[73,1,112,"F15",73,"F15",126,"VK_F15",e,e],[74,1,113,"F16",74,"F16",127,"VK_F16",e,e],[75,1,114,"F17",75,"F17",128,"VK_F17",e,e],[76,1,115,"F18",76,"F18",129,"VK_F18",e,e],[77,1,116,"F19",77,"F19",130,"VK_F19",e,e],[0,1,117,"F20",0,e,0,"VK_F20",e,e],[0,1,118,"F21",0,e,0,"VK_F21",e,e],[0,1,119,"F22",0,e,0,"VK_F22",e,e],[0,1,120,"F23",0,e,0,"VK_F23",e,e],[0,1,121,"F24",0,e,0,"VK_F24",e,e],[0,1,122,"Open",0,e,0,e,e,e],[0,1,123,"Help",0,e,0,e,e,e],[0,1,124,"Select",0,e,0,e,e,e],[0,1,125,"Again",0,e,0,e,e,e],[0,1,126,"Undo",0,e,0,e,e,e],[0,1,127,"Cut",0,e,0,e,e,e],[0,1,128,"Copy",0,e,0,e,e,e],[0,1,129,"Paste",0,e,0,e,e,e],[0,1,130,"Find",0,e,0,e,e,e],[0,1,131,"AudioVolumeMute",112,"AudioVolumeMute",173,"VK_VOLUME_MUTE",e,e],[0,1,132,"AudioVolumeUp",113,"AudioVolumeUp",175,"VK_VOLUME_UP",e,e],[0,1,133,"AudioVolumeDown",114,"AudioVolumeDown",174,"VK_VOLUME_DOWN",e,e],[105,1,134,"NumpadComma",105,"NumPad_Separator",108,"VK_SEPARATOR",e,e],[110,0,135,"IntlRo",110,"ABNT_C1",193,"VK_ABNT_C1",e,e],[0,1,136,"KanaMode",0,e,0,e,e,e],[0,0,137,"IntlYen",0,e,0,e,e,e],[0,1,138,"Convert",0,e,0,e,e,e],[0,1,139,"NonConvert",0,e,0,e,e,e],[0,1,140,"Lang1",0,e,0,e,e,e],[0,1,141,"Lang2",0,e,0,e,e,e],[0,1,142,"Lang3",0,e,0,e,e,e],[0,1,143,"Lang4",0,e,0,e,e,e],[0,1,144,"Lang5",0,e,0,e,e,e],[0,1,145,"Abort",0,e,0,e,e,e],[0,1,146,"Props",0,e,0,e,e,e],[0,1,147,"NumpadParenLeft",0,e,0,e,e,e],[0,1,148,"NumpadParenRight",0,e,0,e,e,e],[0,1,149,"NumpadBackspace",0,e,0,e,e,e],[0,1,150,"NumpadMemoryStore",0,e,0,e,e,e],[0,1,151,"NumpadMemoryRecall",0,e,0,e,e,e],[0,1,152,"NumpadMemoryClear",0,e,0,e,e,e],[0,1,153,"NumpadMemoryAdd",0,e,0,e,e,e],[0,1,154,"NumpadMemorySubtract",0,e,0,e,e,e],[0,1,155,"NumpadClear",126,"Clear",12,"VK_CLEAR",e,e],[0,1,156,"NumpadClearEntry",0,e,0,e,e,e],[5,1,0,e,5,"Ctrl",17,"VK_CONTROL",e,e],[4,1,0,e,4,"Shift",16,"VK_SHIFT",e,e],[6,1,0,e,6,"Alt",18,"VK_MENU",e,e],[57,1,0,e,57,"Meta",0,"VK_COMMAND",e,e],[5,1,157,"ControlLeft",5,e,0,"VK_LCONTROL",e,e],[4,1,158,"ShiftLeft",4,e,0,"VK_LSHIFT",e,e],[6,1,159,"AltLeft",6,e,0,"VK_LMENU",e,e],[57,1,160,"MetaLeft",57,e,0,"VK_LWIN",e,e],[5,1,161,"ControlRight",5,e,0,"VK_RCONTROL",e,e],[4,1,162,"ShiftRight",4,e,0,"VK_RSHIFT",e,e],[6,1,163,"AltRight",6,e,0,"VK_RMENU",e,e],[57,1,164,"MetaRight",57,e,0,"VK_RWIN",e,e],[0,1,165,"BrightnessUp",0,e,0,e,e,e],[0,1,166,"BrightnessDown",0,e,0,e,e,e],[0,1,167,"MediaPlay",0,e,0,e,e,e],[0,1,168,"MediaRecord",0,e,0,e,e,e],[0,1,169,"MediaFastForward",0,e,0,e,e,e],[0,1,170,"MediaRewind",0,e,0,e,e,e],[114,1,171,"MediaTrackNext",119,"MediaTrackNext",176,"VK_MEDIA_NEXT_TRACK",e,e],[115,1,172,"MediaTrackPrevious",120,"MediaTrackPrevious",177,"VK_MEDIA_PREV_TRACK",e,e],[116,1,173,"MediaStop",121,"MediaStop",178,"VK_MEDIA_STOP",e,e],[0,1,174,"Eject",0,e,0,e,e,e],[117,1,175,"MediaPlayPause",122,"MediaPlayPause",179,"VK_MEDIA_PLAY_PAUSE",e,e],[0,1,176,"MediaSelect",123,"LaunchMediaPlayer",181,"VK_MEDIA_LAUNCH_MEDIA_SELECT",e,e],[0,1,177,"LaunchMail",124,"LaunchMail",180,"VK_MEDIA_LAUNCH_MAIL",e,e],[0,1,178,"LaunchApp2",125,"LaunchApp2",183,"VK_MEDIA_LAUNCH_APP2",e,e],[0,1,179,"LaunchApp1",0,e,0,"VK_MEDIA_LAUNCH_APP1",e,e],[0,1,180,"SelectTask",0,e,0,e,e,e],[0,1,181,"LaunchScreenSaver",0,e,0,e,e,e],[0,1,182,"BrowserSearch",115,"BrowserSearch",170,"VK_BROWSER_SEARCH",e,e],[0,1,183,"BrowserHome",116,"BrowserHome",172,"VK_BROWSER_HOME",e,e],[112,1,184,"BrowserBack",117,"BrowserBack",166,"VK_BROWSER_BACK",e,e],[113,1,185,"BrowserForward",118,"BrowserForward",167,"VK_BROWSER_FORWARD",e,e],[0,1,186,"BrowserStop",0,e,0,"VK_BROWSER_STOP",e,e],[0,1,187,"BrowserRefresh",0,e,0,"VK_BROWSER_REFRESH",e,e],[0,1,188,"BrowserFavorites",0,e,0,"VK_BROWSER_FAVORITES",e,e],[0,1,189,"ZoomToggle",0,e,0,e,e,e],[0,1,190,"MailReply",0,e,0,e,e,e],[0,1,191,"MailForward",0,e,0,e,e,e],[0,1,192,"MailSend",0,e,0,e,e,e],[109,1,0,e,109,"KeyInComposition",229,e,e,e],[111,1,0,e,111,"ABNT_C2",194,"VK_ABNT_C2",e,e],[91,1,0,e,91,"OEM_8",223,"VK_OEM_8",e,e],[0,1,0,e,0,e,0,"VK_KANA",e,e],[0,1,0,e,0,e,0,"VK_HANGUL",e,e],[0,1,0,e,0,e,0,"VK_JUNJA",e,e],[0,1,0,e,0,e,0,"VK_FINAL",e,e],[0,1,0,e,0,e,0,"VK_HANJA",e,e],[0,1,0,e,0,e,0,"VK_KANJI",e,e],[0,1,0,e,0,e,0,"VK_CONVERT",e,e],[0,1,0,e,0,e,0,"VK_NONCONVERT",e,e],[0,1,0,e,0,e,0,"VK_ACCEPT",e,e],[0,1,0,e,0,e,0,"VK_MODECHANGE",e,e],[0,1,0,e,0,e,0,"VK_SELECT",e,e],[0,1,0,e,0,e,0,"VK_PRINT",e,e],[0,1,0,e,0,e,0,"VK_EXECUTE",e,e],[0,1,0,e,0,e,0,"VK_SNAPSHOT",e,e],[0,1,0,e,0,e,0,"VK_HELP",e,e],[0,1,0,e,0,e,0,"VK_APPS",e,e],[0,1,0,e,0,e,0,"VK_PROCESSKEY",e,e],[0,1,0,e,0,e,0,"VK_PACKET",e,e],[0,1,0,e,0,e,0,"VK_DBE_SBCSCHAR",e,e],[0,1,0,e,0,e,0,"VK_DBE_DBCSCHAR",e,e],[0,1,0,e,0,e,0,"VK_ATTN",e,e],[0,1,0,e,0,e,0,"VK_CRSEL",e,e],[0,1,0,e,0,e,0,"VK_EXSEL",e,e],[0,1,0,e,0,e,0,"VK_EREOF",e,e],[0,1,0,e,0,e,0,"VK_PLAY",e,e],[0,1,0,e,0,e,0,"VK_ZOOM",e,e],[0,1,0,e,0,e,0,"VK_NONAME",e,e],[0,1,0,e,0,e,0,"VK_PA1",e,e],[0,1,0,e,0,e,0,"VK_OEM_CLEAR",e,e]],i=[],n=[];for(const e of t){const[t,p,m,f,b,_,A,v,C,w]=e;if(n[m]||(n[m]=!0,c[m]=f,d[f]=m,u[f.toLowerCase()]=m,p&&(h[m]=b,0!==b&&3!==b&&5!==b&&4!==b&&6!==b&&57!==b&&(g[b]=m))),!i[b]){if(i[b]=!0,!_)throw new Error(`String representation missing for key code ${b} around scan code ${f}`);o.define(b,_),r.define(b,C||_),s.define(b,w||C||_)}A&&(a[A]=b),v&&(l[v]=b)}g[3]=46}(),function(e){e.toString=function(e){return o.keyCodeToStr(e)},e.fromString=function(e){return o.strToKeyCode(e)},e.toUserSettingsUS=function(e){return r.keyCodeToStr(e)},e.toUserSettingsGeneral=function(e){return s.keyCodeToStr(e)},e.fromUserSettings=function(e){return r.strToKeyCode(e)||s.strToKeyCode(e)},e.toElectronAccelerator=function(e){if(e>=93&&e<=108)return null;switch(e){case 16:return"Up";case 18:return"Down";case 15:return"Left";case 17:return"Right"}return o.keyCodeToStr(e)}}(p||(p={}))},20693:function(e,t,i){"use strict";i.r(t),i.d(t,{AriaLabelProvider:function(){return s},ElectronAcceleratorLabelProvider:function(){return a},ModifierLabelProvider:function(){return o},UILabelProvider:function(){return r},UserSettingsLabelProvider:function(){return l}});var n=i(83787);class o{constructor(e,t,i=t){this.modifierLabels=[null],this.modifierLabels[2]=e,this.modifierLabels[1]=t,this.modifierLabels[3]=i}toLabel(e,t,i){if(0===t.length)return null;const n=[];for(let o=0,r=t.length;o<r;o++){const r=t[o],s=i(r);if(null===s)return null;n[o]=c(r,s,this.modifierLabels[e])}return n.join(" ")}}const r=new o({ctrlKey:"⌃",shiftKey:"⇧",altKey:"⌥",metaKey:"⌘",separator:""},{ctrlKey:n.localize("vs/base/common/keybindingLabels",{key:"ctrlKey",comment:["This is the short form for the Control key on the keyboard"]},"Ctrl"),shiftKey:n.localize("vs/base/common/keybindingLabels",{key:"shiftKey",comment:["This is the short form for the Shift key on the keyboard"]},"Shift"),altKey:n.localize("vs/base/common/keybindingLabels",{key:"altKey",comment:["This is the short form for the Alt key on the keyboard"]},"Alt"),metaKey:n.localize("vs/base/common/keybindingLabels",{key:"windowsKey",comment:["This is the short form for the Windows key on the keyboard"]},"Windows"),separator:"+"},{ctrlKey:n.localize("vs/base/common/keybindingLabels",{key:"ctrlKey",comment:["This is the short form for the Control key on the keyboard"]},"Ctrl"),shiftKey:n.localize("vs/base/common/keybindingLabels",{key:"shiftKey",comment:["This is the short form for the Shift key on the keyboard"]},"Shift"),altKey:n.localize("vs/base/common/keybindingLabels",{key:"altKey",comment:["This is the short form for the Alt key on the keyboard"]},"Alt"),metaKey:n.localize("vs/base/common/keybindingLabels",{key:"superKey",comment:["This is the short form for the Super key on the keyboard"]},"Super"),separator:"+"}),s=new o({ctrlKey:n.localize("vs/base/common/keybindingLabels",{key:"ctrlKey.long",comment:["This is the long form for the Control key on the keyboard"]},"Control"),shiftKey:n.localize("vs/base/common/keybindingLabels",{key:"shiftKey.long",comment:["This is the long form for the Shift key on the keyboard"]},"Shift"),altKey:n.localize("vs/base/common/keybindingLabels",{key:"optKey.long",comment:["This is the long form for the Alt/Option key on the keyboard"]},"Option"),metaKey:n.localize("vs/base/common/keybindingLabels",{key:"cmdKey.long",comment:["This is the long form for the Command key on the keyboard"]},"Command"),separator:"+"},{ctrlKey:n.localize("vs/base/common/keybindingLabels",{key:"ctrlKey.long",comment:["This is the long form for the Control key on the keyboard"]},"Control"),shiftKey:n.localize("vs/base/common/keybindingLabels",{key:"shiftKey.long",comment:["This is the long form for the Shift key on the keyboard"]},"Shift"),altKey:n.localize("vs/base/common/keybindingLabels",{key:"altKey.long",comment:["This is the long form for the Alt key on the keyboard"]},"Alt"),metaKey:n.localize("vs/base/common/keybindingLabels",{key:"windowsKey.long",comment:["This is the long form for the Windows key on the keyboard"]},"Windows"),separator:"+"},{ctrlKey:n.localize("vs/base/common/keybindingLabels",{key:"ctrlKey.long",comment:["This is the long form for the Control key on the keyboard"]},"Control"),shiftKey:n.localize("vs/base/common/keybindingLabels",{key:"shiftKey.long",comment:["This is the long form for the Shift key on the keyboard"]},"Shift"),altKey:n.localize("vs/base/common/keybindingLabels",{key:"altKey.long",comment:["This is the long form for the Alt key on the keyboard"]},"Alt"),metaKey:n.localize("vs/base/common/keybindingLabels",{key:"superKey.long",comment:["This is the long form for the Super key on the keyboard"]},"Super"),separator:"+"}),a=new o({ctrlKey:"Ctrl",shiftKey:"Shift",altKey:"Alt",metaKey:"Cmd",separator:"+"},{ctrlKey:"Ctrl",shiftKey:"Shift",altKey:"Alt",metaKey:"Super",separator:"+"}),l=new o({ctrlKey:"ctrl",shiftKey:"shift",altKey:"alt",metaKey:"cmd",separator:"+"},{ctrlKey:"ctrl",shiftKey:"shift",altKey:"alt",metaKey:"win",separator:"+"},{ctrlKey:"ctrl",shiftKey:"shift",altKey:"alt",metaKey:"meta",separator:"+"});function c(e,t,i){if(null===t)return"";const n=[];return e.ctrlKey&&n.push(i.ctrlKey),e.shiftKey&&n.push(i.shiftKey),e.altKey&&n.push(i.altKey),e.metaKey&&n.push(i.metaKey),""!==t&&n.push(t),n.join(i.separator)}},37345:function(e,t,i){"use strict";i.r(t),i.d(t,{ChordKeybinding:function(){return a},ResolvedKeybinding:function(){return d},ResolvedKeybindingPart:function(){return c},ScanCodeBinding:function(){return l},SimpleKeybinding:function(){return s},createKeybinding:function(){return o},createSimpleKeybinding:function(){return r}});var n=i(12718);function o(e,t){if(0===e)return null;const i=(65535&e)>>>0,n=(4294901760&e)>>>16;return new a(0!==n?[r(i,t),r(n,t)]:[r(i,t)])}function r(e,t){const i=!!(2048&e),n=!!(256&e);return new s(2===t?n:i,!!(1024&e),!!(512&e),2===t?i:n,255&e)}class s{constructor(e,t,i,n,o){this.ctrlKey=e,this.shiftKey=t,this.altKey=i,this.metaKey=n,this.keyCode=o}equals(e){return this.ctrlKey===e.ctrlKey&&this.shiftKey===e.shiftKey&&this.altKey===e.altKey&&this.metaKey===e.metaKey&&this.keyCode===e.keyCode}isModifierKey(){return 0===this.keyCode||5===this.keyCode||57===this.keyCode||6===this.keyCode||4===this.keyCode}toChord(){return new a([this])}isDuplicateModifierCase(){return this.ctrlKey&&5===this.keyCode||this.shiftKey&&4===this.keyCode||this.altKey&&6===this.keyCode||this.metaKey&&57===this.keyCode}}class a{constructor(e){if(0===e.length)throw(0,n.illegalArgument)("parts");this.parts=e}}class l{constructor(e,t,i,n,o){this.ctrlKey=e,this.shiftKey=t,this.altKey=i,this.metaKey=n,this.scanCode=o}isDuplicateModifierCase(){return this.ctrlKey&&(157===this.scanCode||161===this.scanCode)||this.shiftKey&&(158===this.scanCode||162===this.scanCode)||this.altKey&&(159===this.scanCode||163===this.scanCode)||this.metaKey&&(160===this.scanCode||164===this.scanCode)}}class c{constructor(e,t,i,n,o,r){this.ctrlKey=e,this.shiftKey=t,this.altKey=i,this.metaKey=n,this.keyLabel=o,this.keyAriaLabel=r}}class d{}},5560:function(e,t,i){"use strict";i.r(t),i.d(t,{Lazy:function(){return n}});class n{constructor(e){this.executor=e,this._didRun=!1}hasValue(){return this._didRun}getValue(){if(!this._didRun)try{this._value=this.executor()}catch(e){this._error=e}finally{this._didRun=!0}if(this._error)throw this._error;return this._value}get rawValue(){return this._value}}},68921:function(e,t,i){"use strict";i.r(t),i.d(t,{Disposable:function(){return b},DisposableStore:function(){return f},ImmortalReference:function(){return C},MultiDisposeError:function(){return u},MutableDisposable:function(){return _},RefCountedDisposable:function(){return A},SafeDisposable:function(){return v},combinedDisposable:function(){return p},dispose:function(){return g},isDisposable:function(){return h},markAsSingleton:function(){return d},setDisposableTracker:function(){return s},toDisposable:function(){return m}});var n=i(40548),o=i(24417);let r=null;function s(e){r=e}function a(e){return null==r||r.trackDisposable(e),e}function l(e){null==r||r.markAsDisposed(e)}function c(e,t){null==r||r.setParent(e,t)}function d(e){return null==r||r.markAsSingleton(e),e}class u extends Error{constructor(e){super(`Encountered errors while disposing of store. Errors: [${e.join(", ")}]`),this.errors=e}}function h(e){return"function"==typeof e.dispose&&0===e.dispose.length}function g(e){if(o.Iterable.is(e)){const t=[];for(const i of e)if(i)try{i.dispose()}catch(e){t.push(e)}if(1===t.length)throw t[0];if(t.length>1)throw new u(t);return Array.isArray(e)?[]:e}if(e)return e.dispose(),e}function p(...e){const t=m((()=>g(e)));return function(e,t){if(r)for(const i of e)r.setParent(i,t)}(e,t),t}function m(e){const t=a({dispose:(0,n.once)((()=>{l(t),e()}))});return t}class f{constructor(){this._toDispose=new Set,this._isDisposed=!1,a(this)}dispose(){this._isDisposed||(l(this),this._isDisposed=!0,this.clear())}get isDisposed(){return this._isDisposed}clear(){try{g(this._toDispose.values())}finally{this._toDispose.clear()}}add(e){if(!e)return e;if(e===this)throw new Error("Cannot register a disposable on itself!");return c(e,this),this._isDisposed?f.DISABLE_DISPOSED_WARNING||console.warn(new Error("Trying to add a disposable to a DisposableStore that has already been disposed of. The added object will be leaked!").stack):this._toDispose.add(e),e}}f.DISABLE_DISPOSED_WARNING=!1;class b{constructor(){this._store=new f,a(this),c(this._store,this)}dispose(){l(this),this._store.dispose()}_register(e){if(e===this)throw new Error("Cannot register a disposable on itself!");return this._store.add(e)}}b.None=Object.freeze({dispose(){}});class _{constructor(){this._isDisposed=!1,a(this)}get value(){return this._isDisposed?void 0:this._value}set value(e){var t;this._isDisposed||e===this._value||(null===(t=this._value)||void 0===t||t.dispose(),e&&c(e,this),this._value=e)}clear(){this.value=void 0}dispose(){var e;this._isDisposed=!0,l(this),null===(e=this._value)||void 0===e||e.dispose(),this._value=void 0}clearAndLeak(){const e=this._value;return this._value=void 0,e&&c(e,null),e}}class A{constructor(e){this._disposable=e,this._counter=1}acquire(){return this._counter++,this}release(){return 0==--this._counter&&this._disposable.dispose(),this}}class v{constructor(){this.dispose=()=>{},this.unset=()=>{},this.isset=()=>!1,a(this)}set(e){let t=e;return this.unset=()=>t=void 0,this.isset=()=>void 0!==t,this.dispose=()=>{t&&(t(),t=void 0,l(this))},this}}class C{constructor(e){this.object=e}dispose(){}}},22446:function(e,t,i){"use strict";i.r(t),i.d(t,{LinkedList:function(){return o}});class n{constructor(e){this.element=e,this.next=n.Undefined,this.prev=n.Undefined}}n.Undefined=new n(void 0);class o{constructor(){this._first=n.Undefined,this._last=n.Undefined,this._size=0}get size(){return this._size}isEmpty(){return this._first===n.Undefined}clear(){let e=this._first;for(;e!==n.Undefined;){const t=e.next;e.prev=n.Undefined,e.next=n.Undefined,e=t}this._first=n.Undefined,this._last=n.Undefined,this._size=0}unshift(e){return this._insert(e,!1)}push(e){return this._insert(e,!0)}_insert(e,t){const i=new n(e);if(this._first===n.Undefined)this._first=i,this._last=i;else if(t){const e=this._last;this._last=i,i.prev=e,e.next=i}else{const e=this._first;this._first=i,i.next=e,e.prev=i}this._size+=1;let o=!1;return()=>{o||(o=!0,this._remove(i))}}shift(){if(this._first!==n.Undefined){const e=this._first.element;return this._remove(this._first),e}}pop(){if(this._last!==n.Undefined){const e=this._last.element;return this._remove(this._last),e}}_remove(e){if(e.prev!==n.Undefined&&e.next!==n.Undefined){const t=e.prev;t.next=e.next,e.next.prev=t}else e.prev===n.Undefined&&e.next===n.Undefined?(this._first=n.Undefined,this._last=n.Undefined):e.next===n.Undefined?(this._last=this._last.prev,this._last.next=n.Undefined):e.prev===n.Undefined&&(this._first=this._first.next,this._first.prev=n.Undefined);this._size-=1}*[Symbol.iterator](){let e=this._first;for(;e!==n.Undefined;)yield e.element,e=e.next}}},13833:function(e,t,i){"use strict";i.r(t),i.d(t,{ConfigKeysIterator:function(){return a},LRUCache:function(){return m},LinkedMap:function(){return p},PathIterator:function(){return l},ResourceMap:function(){return g},StringIterator:function(){return s},TernarySearchTree:function(){return u},UriIterator:function(){return c}});var n,o,r=i(91482);class s{constructor(){this._value="",this._pos=0}reset(e){return this._value=e,this._pos=0,this}next(){return this._pos+=1,this}hasNext(){return this._pos<this._value.length-1}cmp(e){return e.charCodeAt(0)-this._value.charCodeAt(this._pos)}value(){return this._value[this._pos]}}class a{constructor(e=!0){this._caseSensitive=e}reset(e){return this._value=e,this._from=0,this._to=0,this.next()}hasNext(){return this._to<this._value.length}next(){this._from=this._to;let e=!0;for(;this._to<this._value.length;this._to++){if(46===this._value.charCodeAt(this._to)){if(!e)break;this._from++}else e=!1}return this}cmp(e){return this._caseSensitive?(0,r.compareSubstring)(e,this._value,0,e.length,this._from,this._to):(0,r.compareSubstringIgnoreCase)(e,this._value,0,e.length,this._from,this._to)}value(){return this._value.substring(this._from,this._to)}}class l{constructor(e=!0,t=!0){this._splitOnBackslash=e,this._caseSensitive=t}reset(e){this._from=0,this._to=0,this._value=e,this._valueLen=e.length;for(let t=e.length-1;t>=0;t--,this._valueLen--){const e=this._value.charCodeAt(t);if(!(47===e||this._splitOnBackslash&&92===e))break}return this.next()}hasNext(){return this._to<this._valueLen}next(){this._from=this._to;let e=!0;for(;this._to<this._valueLen;this._to++){const t=this._value.charCodeAt(this._to);if(47===t||this._splitOnBackslash&&92===t){if(!e)break;this._from++}else e=!1}return this}cmp(e){return this._caseSensitive?(0,r.compareSubstring)(e,this._value,0,e.length,this._from,this._to):(0,r.compareSubstringIgnoreCase)(e,this._value,0,e.length,this._from,this._to)}value(){return this._value.substring(this._from,this._to)}}class c{constructor(e,t){this._ignorePathCasing=e,this._ignoreQueryAndFragment=t,this._states=[],this._stateIdx=0}reset(e){return this._value=e,this._states=[],this._value.scheme&&this._states.push(1),this._value.authority&&this._states.push(2),this._value.path&&(this._pathIterator=new l(!1,!this._ignorePathCasing(e)),this._pathIterator.reset(e.path),this._pathIterator.value()&&this._states.push(3)),this._ignoreQueryAndFragment(e)||(this._value.query&&this._states.push(4),this._value.fragment&&this._states.push(5)),this._stateIdx=0,this}next(){return 3===this._states[this._stateIdx]&&this._pathIterator.hasNext()?this._pathIterator.next():this._stateIdx+=1,this}hasNext(){return 3===this._states[this._stateIdx]&&this._pathIterator.hasNext()||this._stateIdx<this._states.length-1}cmp(e){if(1===this._states[this._stateIdx])return(0,r.compareIgnoreCase)(e,this._value.scheme);if(2===this._states[this._stateIdx])return(0,r.compareIgnoreCase)(e,this._value.authority);if(3===this._states[this._stateIdx])return this._pathIterator.cmp(e);if(4===this._states[this._stateIdx])return(0,r.compare)(e,this._value.query);if(5===this._states[this._stateIdx])return(0,r.compare)(e,this._value.fragment);throw new Error}value(){if(1===this._states[this._stateIdx])return this._value.scheme;if(2===this._states[this._stateIdx])return this._value.authority;if(3===this._states[this._stateIdx])return this._pathIterator.value();if(4===this._states[this._stateIdx])return this._value.query;if(5===this._states[this._stateIdx])return this._value.fragment;throw new Error}}class d{constructor(){this.height=1}rotateLeft(){const e=this.right;return this.right=e.left,e.left=this,this.updateHeight(),e.updateHeight(),e}rotateRight(){const e=this.left;return this.left=e.right,e.right=this,this.updateHeight(),e.updateHeight(),e}updateHeight(){this.height=1+Math.max(this.heightLeft,this.heightRight)}balanceFactor(){return this.heightRight-this.heightLeft}get heightLeft(){var e,t;return null!==(t=null===(e=this.left)||void 0===e?void 0:e.height)&&void 0!==t?t:0}get heightRight(){var e,t;return null!==(t=null===(e=this.right)||void 0===e?void 0:e.height)&&void 0!==t?t:0}}class u{constructor(e){this._iter=e}static forUris(e=(()=>!1),t=(()=>!1)){return new u(new c(e,t))}static forStrings(){return new u(new s)}static forConfigKeys(){return new u(new a)}clear(){this._root=void 0}set(e,t){const i=this._iter.reset(e);let n;this._root||(this._root=new d,this._root.segment=i.value());const o=[];for(n=this._root;;){const e=i.cmp(n.segment);if(e>0)n.left||(n.left=new d,n.left.segment=i.value()),o.push([-1,n]),n=n.left;else if(e<0)n.right||(n.right=new d,n.right.segment=i.value()),o.push([1,n]),n=n.right;else{if(!i.hasNext())break;i.next(),n.mid||(n.mid=new d,n.mid.segment=i.value()),o.push([0,n]),n=n.mid}}const r=n.value;n.value=t,n.key=e;for(let e=o.length-1;e>=0;e--){const t=o[e][1];t.updateHeight();const i=t.balanceFactor();if(i<-1||i>1){const i=o[e][0],n=o[e+1][0];if(1===i&&1===n)o[e][1]=t.rotateLeft();else if(-1===i&&-1===n)o[e][1]=t.rotateRight();else if(1===i&&-1===n)t.right=o[e+1][1]=o[e+1][1].rotateRight(),o[e][1]=t.rotateLeft();else{if(-1!==i||1!==n)throw new Error;t.left=o[e+1][1]=o[e+1][1].rotateLeft(),o[e][1]=t.rotateRight()}if(e>0)switch(o[e-1][0]){case-1:o[e-1][1].left=o[e][1];break;case 1:o[e-1][1].right=o[e][1];break;case 0:o[e-1][1].mid=o[e][1]}else this._root=o[0][1]}}return r}get(e){var t;return null===(t=this._getNode(e))||void 0===t?void 0:t.value}_getNode(e){const t=this._iter.reset(e);let i=this._root;for(;i;){const e=t.cmp(i.segment);if(e>0)i=i.left;else if(e<0)i=i.right;else{if(!t.hasNext())break;t.next(),i=i.mid}}return i}has(e){const t=this._getNode(e);return!(void 0===(null==t?void 0:t.value)&&void 0===(null==t?void 0:t.mid))}delete(e){return this._delete(e,!1)}deleteSuperstr(e){return this._delete(e,!0)}_delete(e,t){var i;const n=this._iter.reset(e),o=[];let r=this._root;for(;r;){const e=n.cmp(r.segment);if(e>0)o.push([-1,r]),r=r.left;else if(e<0)o.push([1,r]),r=r.right;else{if(!n.hasNext())break;n.next(),o.push([0,r]),r=r.mid}}if(r){if(t?(r.left=void 0,r.mid=void 0,r.right=void 0,r.height=1):(r.key=void 0,r.value=void 0),!r.mid&&!r.value)if(r.left&&r.right){const e=this._min(r.right),{key:t,value:i,segment:n}=e;this._delete(e.key,!1),r.key=t,r.value=i,r.segment=n}else{const e=null!==(i=r.left)&&void 0!==i?i:r.right;if(o.length>0){const[t,i]=o[o.length-1];switch(t){case-1:i.left=e;break;case 0:i.mid=e;break;case 1:i.right=e}}else this._root=e}for(let e=o.length-1;e>=0;e--){const t=o[e][1];t.updateHeight();const i=t.balanceFactor();if(i>1?(t.right.balanceFactor()>=0||(t.right=t.right.rotateRight()),o[e][1]=t.rotateLeft()):i<-1&&(t.left.balanceFactor()<=0||(t.left=t.left.rotateLeft()),o[e][1]=t.rotateRight()),e>0)switch(o[e-1][0]){case-1:o[e-1][1].left=o[e][1];break;case 1:o[e-1][1].right=o[e][1];break;case 0:o[e-1][1].mid=o[e][1]}else this._root=o[0][1]}}}_min(e){for(;e.left;)e=e.left;return e}findSubstr(e){const t=this._iter.reset(e);let i,n=this._root;for(;n;){const e=t.cmp(n.segment);if(e>0)n=n.left;else if(e<0)n=n.right;else{if(!t.hasNext())break;t.next(),i=n.value||i,n=n.mid}}return n&&n.value||i}findSuperstr(e){const t=this._iter.reset(e);let i=this._root;for(;i;){const e=t.cmp(i.segment);if(e>0)i=i.left;else if(e<0)i=i.right;else{if(!t.hasNext())return i.mid?this._entries(i.mid):void 0;t.next(),i=i.mid}}}forEach(e){for(const[t,i]of this)e(i,t)}*[Symbol.iterator](){yield*this._entries(this._root)}_entries(e){const t=[];return this._dfsEntries(e,t),t[Symbol.iterator]()}_dfsEntries(e,t){e&&(e.left&&this._dfsEntries(e.left,t),e.value&&t.push([e.key,e.value]),e.mid&&this._dfsEntries(e.mid,t),e.right&&this._dfsEntries(e.right,t))}}class h{constructor(e,t){this.uri=e,this.value=t}}class g{constructor(e,t){this[n]="ResourceMap",e instanceof g?(this.map=new Map(e.map),this.toKey=null!=t?t:g.defaultToKey):(this.map=new Map,this.toKey=null!=e?e:g.defaultToKey)}set(e,t){return this.map.set(this.toKey(e),new h(e,t)),this}get(e){var t;return null===(t=this.map.get(this.toKey(e)))||void 0===t?void 0:t.value}has(e){return this.map.has(this.toKey(e))}get size(){return this.map.size}clear(){this.map.clear()}delete(e){return this.map.delete(this.toKey(e))}forEach(e,t){void 0!==t&&(e=e.bind(t));for(const[t,i]of this.map)e(i.value,i.uri,this)}*values(){for(const e of this.map.values())yield e.value}*keys(){for(const e of this.map.values())yield e.uri}*entries(){for(const e of this.map.values())yield[e.uri,e.value]}*[(n=Symbol.toStringTag,Symbol.iterator)](){for(const[,e]of this.map)yield[e.uri,e.value]}}g.defaultToKey=e=>e.toString();class p{constructor(){this[o]="LinkedMap",this._map=new Map,this._head=void 0,this._tail=void 0,this._size=0,this._state=0}clear(){this._map.clear(),this._head=void 0,this._tail=void 0,this._size=0,this._state++}isEmpty(){return!this._head&&!this._tail}get size(){return this._size}get first(){var e;return null===(e=this._head)||void 0===e?void 0:e.value}get last(){var e;return null===(e=this._tail)||void 0===e?void 0:e.value}has(e){return this._map.has(e)}get(e,t=0){const i=this._map.get(e);if(i)return 0!==t&&this.touch(i,t),i.value}set(e,t,i=0){let n=this._map.get(e);if(n)n.value=t,0!==i&&this.touch(n,i);else{switch(n={key:e,value:t,next:void 0,previous:void 0},i){case 0:case 2:default:this.addItemLast(n);break;case 1:this.addItemFirst(n)}this._map.set(e,n),this._size++}return this}delete(e){return!!this.remove(e)}remove(e){const t=this._map.get(e);if(t)return this._map.delete(e),this.removeItem(t),this._size--,t.value}shift(){if(!this._head&&!this._tail)return;if(!this._head||!this._tail)throw new Error("Invalid list");const e=this._head;return this._map.delete(e.key),this.removeItem(e),this._size--,e.value}forEach(e,t){const i=this._state;let n=this._head;for(;n;){if(t?e.bind(t)(n.value,n.key,this):e(n.value,n.key,this),this._state!==i)throw new Error("LinkedMap got modified during iteration.");n=n.next}}keys(){const e=this,t=this._state;let i=this._head;const n={[Symbol.iterator](){return n},next(){if(e._state!==t)throw new Error("LinkedMap got modified during iteration.");if(i){const e={value:i.key,done:!1};return i=i.next,e}return{value:void 0,done:!0}}};return n}values(){const e=this,t=this._state;let i=this._head;const n={[Symbol.iterator](){return n},next(){if(e._state!==t)throw new Error("LinkedMap got modified during iteration.");if(i){const e={value:i.value,done:!1};return i=i.next,e}return{value:void 0,done:!0}}};return n}entries(){const e=this,t=this._state;let i=this._head;const n={[Symbol.iterator](){return n},next(){if(e._state!==t)throw new Error("LinkedMap got modified during iteration.");if(i){const e={value:[i.key,i.value],done:!1};return i=i.next,e}return{value:void 0,done:!0}}};return n}[(o=Symbol.toStringTag,Symbol.iterator)](){return this.entries()}trimOld(e){if(e>=this.size)return;if(0===e)return void this.clear();let t=this._head,i=this.size;for(;t&&i>e;)this._map.delete(t.key),t=t.next,i--;this._head=t,this._size=i,t&&(t.previous=void 0),this._state++}addItemFirst(e){if(this._head||this._tail){if(!this._head)throw new Error("Invalid list");e.next=this._head,this._head.previous=e}else this._tail=e;this._head=e,this._state++}addItemLast(e){if(this._head||this._tail){if(!this._tail)throw new Error("Invalid list");e.previous=this._tail,this._tail.next=e}else this._head=e;this._tail=e,this._state++}removeItem(e){if(e===this._head&&e===this._tail)this._head=void 0,this._tail=void 0;else if(e===this._head){if(!e.next)throw new Error("Invalid list");e.next.previous=void 0,this._head=e.next}else if(e===this._tail){if(!e.previous)throw new Error("Invalid list");e.previous.next=void 0,this._tail=e.previous}else{const t=e.next,i=e.previous;if(!t||!i)throw new Error("Invalid list");t.previous=i,i.next=t}e.next=void 0,e.previous=void 0,this._state++}touch(e,t){if(!this._head||!this._tail)throw new Error("Invalid list");if(1===t||2===t)if(1===t){if(e===this._head)return;const t=e.next,i=e.previous;e===this._tail?(i.next=void 0,this._tail=i):(t.previous=i,i.next=t),e.previous=void 0,e.next=this._head,this._head.previous=e,this._head=e,this._state++}else if(2===t){if(e===this._tail)return;const t=e.next,i=e.previous;e===this._head?(t.previous=void 0,this._head=t):(t.previous=i,i.next=t),e.next=void 0,e.previous=this._tail,this._tail.next=e,this._tail=e,this._state++}}toJSON(){const e=[];return this.forEach(((t,i)=>{e.push([i,t])})),e}fromJSON(e){this.clear();for(const[t,i]of e)this.set(t,i)}}class m extends p{constructor(e,t=1){super(),this._limit=e,this._ratio=Math.min(Math.max(0,t),1)}get limit(){return this._limit}set limit(e){this._limit=e,this.checkTrim()}get(e,t=2){return super.get(e,t)}peek(e){return super.get(e,0)}set(e,t){return super.set(e,t,2),this.checkTrim(),this}checkTrim(){this.size>this._limit&&this.trimOld(Math.round(this._limit*this._ratio))}}},61098:function(e,t,i){"use strict";i.r(t),i.d(t,{parse:function(){return r},revive:function(){return s}});var n=i(44913),o=i(19300);function r(e){let t=JSON.parse(e);return t=s(t),t}function s(e,t=0){if(!e||t>200)return e;if("object"==typeof e){switch(e.$mid){case 1:return o.URI.revive(e);case 2:return new RegExp(e.source,e.flags);case 14:return new Date(e.source)}if(e instanceof n.VSBuffer||e instanceof Uint8Array)return e;if(Array.isArray(e))for(let i=0;i<e.length;++i)e[i]=s(e[i],t+1);else for(const i in e)Object.hasOwnProperty.call(e,i)&&(e[i]=s(e[i],t+1))}return e}},5121:function(e,t,i){"use strict";i.r(t),i.d(t,{Mimes:function(){return n}});const n=Object.freeze({text:"text/plain",binary:"application/octet-stream",unknown:"application/unknown",markdown:"text/markdown",latex:"text/latex",uriList:"text/uri-list"})},27582:function(e,t,i){"use strict";i.r(t),i.d(t,{ArrayNavigator:function(){return n}});class n{constructor(e,t=0,i=e.length,n=t-1){this.items=e,this.start=t,this.end=i,this.index=n}current(){return this.index===this.start-1||this.index===this.end?null:this.items[this.index]}next(){return this.index=Math.min(this.index+1,this.end),this.current()}previous(){return this.index=Math.max(this.index-1,this.start-1),this.current()}first(){return this.index=this.start,this.current()}last(){return this.index=this.end-1,this.current()}}},27952:function(e,t,i){"use strict";i.r(t),i.d(t,{FileAccess:function(){return c},RemoteAuthorities:function(){return a},Schemas:function(){return n},connectionTokenQueryName:function(){return s}});var n,o=i(66719),r=i(19300);!function(e){e.inMemory="inmemory",e.vscode="vscode",e.internal="private",e.walkThrough="walkThrough",e.walkThroughSnippet="walkThroughSnippet",e.http="http",e.https="https",e.file="file",e.mailto="mailto",e.untitled="untitled",e.data="data",e.command="command",e.vscodeRemote="vscode-remote",e.vscodeRemoteResource="vscode-remote-resource",e.vscodeUserData="vscode-userdata",e.vscodeCustomEditor="vscode-custom-editor",e.vscodeNotebook="vscode-notebook",e.vscodeNotebookCell="vscode-notebook-cell",e.vscodeNotebookCellMetadata="vscode-notebook-cell-metadata",e.vscodeNotebookCellOutput="vscode-notebook-cell-output",e.vscodeInteractive="vscode-interactive",e.vscodeInteractiveInput="vscode-interactive-input",e.vscodeSettings="vscode-settings",e.vscodeWorkspaceTrust="vscode-workspace-trust",e.vscodeTerminal="vscode-terminal",e.webviewPanel="webview-panel",e.vscodeWebview="vscode-webview",e.extension="extension",e.vscodeFileResource="vscode-file",e.tmp="tmp",e.vsls="vsls",e.vscodeSourceControl="vscode-scm"}(n||(n={}));const s="tkn";const a=new class{constructor(){this._hosts=Object.create(null),this._ports=Object.create(null),this._connectionTokens=Object.create(null),this._preferredWebSchema="http",this._delegate=null,this._remoteResourcesPath=`/${n.vscodeRemoteResource}`}setPreferredWebSchema(e){this._preferredWebSchema=e}rewrite(e){if(this._delegate)return this._delegate(e);const t=e.authority;let i=this._hosts[t];i&&-1!==i.indexOf(":")&&(i=`[${i}]`);const a=this._ports[t],l=this._connectionTokens[t];let c=`path=${encodeURIComponent(e.path)}`;return"string"==typeof l&&(c+=`&${s}=${encodeURIComponent(l)}`),r.URI.from({scheme:o.isWeb?this._preferredWebSchema:n.vscodeRemoteResource,authority:`${i}:${a}`,path:this._remoteResourcesPath,query:c})}};class l{asBrowserUri(e,t){const i=this.toUri(e,t);return i.scheme===n.vscodeRemote?a.rewrite(i):i.scheme===n.file&&(o.isNative||o.isWebWorker&&o.globals.origin===`${n.vscodeFileResource}://${l.FALLBACK_AUTHORITY}`)?i.with({scheme:n.vscodeFileResource,authority:i.authority||l.FALLBACK_AUTHORITY,query:null,fragment:null}):i}toUri(e,t){return r.URI.isUri(e)?e:r.URI.parse(t.toUrl(e))}}l.FALLBACK_AUTHORITY="vscode-app";const c=new l},53719:function(e,t,i){"use strict";function n(e,t,i){return Math.min(Math.max(e,t),i)}i.r(t),i.d(t,{MovingAverage:function(){return o},SlidingWindowAverage:function(){return r},clamp:function(){return n}});class o{constructor(){this._n=1,this._val=0}update(e){return this._val=this._val+(e-this._val)/this._n,this._n+=1,this._val}get value(){return this._val}}class r{constructor(e){this._n=0,this._val=0,this._values=[],this._index=0,this._sum=0,this._values=new Array(e),this._values.fill(0,0,e)}update(e){const t=this._values[this._index];return this._values[this._index]=e,this._index=(this._index+1)%this._values.length,this._sum-=t,this._sum+=e,this._n<this._values.length&&(this._n+=1),this._val=this._sum/this._n,this._val}get value(){return this._val}}},91057:function(e,t,i){"use strict";i.r(t),i.d(t,{cloneAndChange:function(){return a},deepClone:function(){return o},deepFreeze:function(){return r},equals:function(){return d},mixin:function(){return c}});var n=i(18912);function o(e){if(!e||"object"!=typeof e)return e;if(e instanceof RegExp)return e;const t=Array.isArray(e)?[]:{};return Object.keys(e).forEach((i=>{e[i]&&"object"==typeof e[i]?t[i]=o(e[i]):t[i]=e[i]})),t}function r(e){if(!e||"object"!=typeof e)return e;const t=[e];for(;t.length>0;){const e=t.shift();Object.freeze(e);for(const i in e)if(s.call(e,i)){const o=e[i];"object"!=typeof o||Object.isFrozen(o)||(0,n.isTypedArray)(o)||t.push(o)}}return e}const s=Object.prototype.hasOwnProperty;function a(e,t){return l(e,t,new Set)}function l(e,t,i){if((0,n.isUndefinedOrNull)(e))return e;const o=t(e);if(void 0!==o)return o;if((0,n.isArray)(e)){const n=[];for(const o of e)n.push(l(o,t,i));return n}if((0,n.isObject)(e)){if(i.has(e))throw new Error("Cannot clone recursive data-structure");i.add(e);const n={};for(const o in e)s.call(e,o)&&(n[o]=l(e[o],t,i));return i.delete(e),n}return e}function c(e,t,i=!0){return(0,n.isObject)(e)?((0,n.isObject)(t)&&Object.keys(t).forEach((o=>{o in e?i&&((0,n.isObject)(e[o])&&(0,n.isObject)(t[o])?c(e[o],t[o],i):e[o]=t[o]):e[o]=t[o]})),e):t}function d(e,t){if(e===t)return!0;if(null==e||null==t)return!1;if(typeof e!=typeof t)return!1;if("object"!=typeof e)return!1;if(Array.isArray(e)!==Array.isArray(t))return!1;let i,n;if(Array.isArray(e)){if(e.length!==t.length)return!1;for(i=0;i<e.length;i++)if(!d(e[i],t[i]))return!1}else{const o=[];for(n in e)o.push(n);o.sort();const r=[];for(n in t)r.push(n);if(r.sort(),!d(o,r))return!1;for(i=0;i<o.length;i++)if(!d(e[o[i]],t[o[i]]))return!1}return!0}},23674:function(e,t,i){"use strict";i.r(t),i.d(t,{basename:function(){return C},dirname:function(){return v},extname:function(){return w},normalize:function(){return b},posix:function(){return f},relative:function(){return A},resolve:function(){return _},sep:function(){return y},win32:function(){return m}});var n=i(63953);const o=46,r=47,s=92,a=58;class l extends Error{constructor(e,t,i){let n;"string"==typeof t&&0===t.indexOf("not ")?(n="must not be",t=t.replace(/^not /,"")):n="must be";const o=-1!==e.indexOf(".")?"property":"argument";let r=`The "${e}" ${o} ${n} of type ${t}`;r+=". Received type "+typeof i,super(r),this.code="ERR_INVALID_ARG_TYPE"}}function c(e,t){if("string"!=typeof e)throw new l(t,"string",e)}function d(e){return e===r||e===s}function u(e){return e===r}function h(e){return e>=65&&e<=90||e>=97&&e<=122}function g(e,t,i,n){let s="",a=0,l=-1,c=0,d=0;for(let u=0;u<=e.length;++u){if(u<e.length)d=e.charCodeAt(u);else{if(n(d))break;d=r}if(n(d)){if(l===u-1||1===c);else if(2===c){if(s.length<2||2!==a||s.charCodeAt(s.length-1)!==o||s.charCodeAt(s.length-2)!==o){if(s.length>2){const e=s.lastIndexOf(i);-1===e?(s="",a=0):(s=s.slice(0,e),a=s.length-1-s.lastIndexOf(i)),l=u,c=0;continue}if(0!==s.length){s="",a=0,l=u,c=0;continue}}t&&(s+=s.length>0?`${i}..`:"..",a=2)}else s.length>0?s+=`${i}${e.slice(l+1,u)}`:s=e.slice(l+1,u),a=u-l-1;l=u,c=0}else d===o&&-1!==c?++c:c=-1}return s}function p(e,t){if(null===t||"object"!=typeof t)throw new l("pathObject","Object",t);const i=t.dir||t.root,n=t.base||`${t.name||""}${t.ext||""}`;return i?i===t.root?`${i}${n}`:`${i}${e}${n}`:n}const m={resolve(...e){let t="",i="",o=!1;for(let r=e.length-1;r>=-1;r--){let l;if(r>=0){if(l=e[r],c(l,"path"),0===l.length)continue}else 0===t.length?l=n.cwd():(l=n.env[`=${t}`]||n.cwd(),(void 0===l||l.slice(0,2).toLowerCase()!==t.toLowerCase()&&l.charCodeAt(2)===s)&&(l=`${t}\\`));const u=l.length;let g=0,p="",m=!1;const f=l.charCodeAt(0);if(1===u)d(f)&&(g=1,m=!0);else if(d(f))if(m=!0,d(l.charCodeAt(1))){let e=2,t=e;for(;e<u&&!d(l.charCodeAt(e));)e++;if(e<u&&e!==t){const i=l.slice(t,e);for(t=e;e<u&&d(l.charCodeAt(e));)e++;if(e<u&&e!==t){for(t=e;e<u&&!d(l.charCodeAt(e));)e++;e!==u&&e===t||(p=`\\\\${i}\\${l.slice(t,e)}`,g=e)}}}else g=1;else h(f)&&l.charCodeAt(1)===a&&(p=l.slice(0,2),g=2,u>2&&d(l.charCodeAt(2))&&(m=!0,g=3));if(p.length>0)if(t.length>0){if(p.toLowerCase()!==t.toLowerCase())continue}else t=p;if(o){if(t.length>0)break}else if(i=`${l.slice(g)}\\${i}`,o=m,m&&t.length>0)break}return i=g(i,!o,"\\",d),o?`${t}\\${i}`:`${t}${i}`||"."},normalize(e){c(e,"path");const t=e.length;if(0===t)return".";let i,n=0,o=!1;const r=e.charCodeAt(0);if(1===t)return u(r)?"\\":e;if(d(r))if(o=!0,d(e.charCodeAt(1))){let o=2,r=o;for(;o<t&&!d(e.charCodeAt(o));)o++;if(o<t&&o!==r){const s=e.slice(r,o);for(r=o;o<t&&d(e.charCodeAt(o));)o++;if(o<t&&o!==r){for(r=o;o<t&&!d(e.charCodeAt(o));)o++;if(o===t)return`\\\\${s}\\${e.slice(r)}\\`;o!==r&&(i=`\\\\${s}\\${e.slice(r,o)}`,n=o)}}}else n=1;else h(r)&&e.charCodeAt(1)===a&&(i=e.slice(0,2),n=2,t>2&&d(e.charCodeAt(2))&&(o=!0,n=3));let s=n<t?g(e.slice(n),!o,"\\",d):"";return 0!==s.length||o||(s="."),s.length>0&&d(e.charCodeAt(t-1))&&(s+="\\"),void 0===i?o?`\\${s}`:s:o?`${i}\\${s}`:`${i}${s}`},isAbsolute(e){c(e,"path");const t=e.length;if(0===t)return!1;const i=e.charCodeAt(0);return d(i)||t>2&&h(i)&&e.charCodeAt(1)===a&&d(e.charCodeAt(2))},join(...e){if(0===e.length)return".";let t,i;for(let n=0;n<e.length;++n){const o=e[n];c(o,"path"),o.length>0&&(void 0===t?t=i=o:t+=`\\${o}`)}if(void 0===t)return".";let n=!0,o=0;if("string"==typeof i&&d(i.charCodeAt(0))){++o;const e=i.length;e>1&&d(i.charCodeAt(1))&&(++o,e>2&&(d(i.charCodeAt(2))?++o:n=!1))}if(n){for(;o<t.length&&d(t.charCodeAt(o));)o++;o>=2&&(t=`\\${t.slice(o)}`)}return m.normalize(t)},relative(e,t){if(c(e,"from"),c(t,"to"),e===t)return"";const i=m.resolve(e),n=m.resolve(t);if(i===n)return"";if((e=i.toLowerCase())===(t=n.toLowerCase()))return"";let o=0;for(;o<e.length&&e.charCodeAt(o)===s;)o++;let r=e.length;for(;r-1>o&&e.charCodeAt(r-1)===s;)r--;const a=r-o;let l=0;for(;l<t.length&&t.charCodeAt(l)===s;)l++;let d=t.length;for(;d-1>l&&t.charCodeAt(d-1)===s;)d--;const u=d-l,h=a<u?a:u;let g=-1,p=0;for(;p<h;p++){const i=e.charCodeAt(o+p);if(i!==t.charCodeAt(l+p))break;i===s&&(g=p)}if(p!==h){if(-1===g)return n}else{if(u>h){if(t.charCodeAt(l+p)===s)return n.slice(l+p+1);if(2===p)return n.slice(l+p)}a>h&&(e.charCodeAt(o+p)===s?g=p:2===p&&(g=3)),-1===g&&(g=0)}let f="";for(p=o+g+1;p<=r;++p)p!==r&&e.charCodeAt(p)!==s||(f+=0===f.length?"..":"\\..");return l+=g,f.length>0?`${f}${n.slice(l,d)}`:(n.charCodeAt(l)===s&&++l,n.slice(l,d))},toNamespacedPath(e){if("string"!=typeof e)return e;if(0===e.length)return"";const t=m.resolve(e);if(t.length<=2)return e;if(t.charCodeAt(0)===s){if(t.charCodeAt(1)===s){const e=t.charCodeAt(2);if(63!==e&&e!==o)return`\\\\?\\UNC\\${t.slice(2)}`}}else if(h(t.charCodeAt(0))&&t.charCodeAt(1)===a&&t.charCodeAt(2)===s)return`\\\\?\\${t}`;return e},dirname(e){c(e,"path");const t=e.length;if(0===t)return".";let i=-1,n=0;const o=e.charCodeAt(0);if(1===t)return d(o)?e:".";if(d(o)){if(i=n=1,d(e.charCodeAt(1))){let o=2,r=o;for(;o<t&&!d(e.charCodeAt(o));)o++;if(o<t&&o!==r){for(r=o;o<t&&d(e.charCodeAt(o));)o++;if(o<t&&o!==r){for(r=o;o<t&&!d(e.charCodeAt(o));)o++;if(o===t)return e;o!==r&&(i=n=o+1)}}}}else h(o)&&e.charCodeAt(1)===a&&(i=t>2&&d(e.charCodeAt(2))?3:2,n=i);let r=-1,s=!0;for(let i=t-1;i>=n;--i)if(d(e.charCodeAt(i))){if(!s){r=i;break}}else s=!1;if(-1===r){if(-1===i)return".";r=i}return e.slice(0,r)},basename(e,t){void 0!==t&&c(t,"ext"),c(e,"path");let i,n=0,o=-1,r=!0;if(e.length>=2&&h(e.charCodeAt(0))&&e.charCodeAt(1)===a&&(n=2),void 0!==t&&t.length>0&&t.length<=e.length){if(t===e)return"";let s=t.length-1,a=-1;for(i=e.length-1;i>=n;--i){const l=e.charCodeAt(i);if(d(l)){if(!r){n=i+1;break}}else-1===a&&(r=!1,a=i+1),s>=0&&(l===t.charCodeAt(s)?-1==--s&&(o=i):(s=-1,o=a))}return n===o?o=a:-1===o&&(o=e.length),e.slice(n,o)}for(i=e.length-1;i>=n;--i)if(d(e.charCodeAt(i))){if(!r){n=i+1;break}}else-1===o&&(r=!1,o=i+1);return-1===o?"":e.slice(n,o)},extname(e){c(e,"path");let t=0,i=-1,n=0,r=-1,s=!0,l=0;e.length>=2&&e.charCodeAt(1)===a&&h(e.charCodeAt(0))&&(t=n=2);for(let a=e.length-1;a>=t;--a){const t=e.charCodeAt(a);if(d(t)){if(!s){n=a+1;break}}else-1===r&&(s=!1,r=a+1),t===o?-1===i?i=a:1!==l&&(l=1):-1!==i&&(l=-1)}return-1===i||-1===r||0===l||1===l&&i===r-1&&i===n+1?"":e.slice(i,r)},format:p.bind(null,"\\"),parse(e){c(e,"path");const t={root:"",dir:"",base:"",ext:"",name:""};if(0===e.length)return t;const i=e.length;let n=0,r=e.charCodeAt(0);if(1===i)return d(r)?(t.root=t.dir=e,t):(t.base=t.name=e,t);if(d(r)){if(n=1,d(e.charCodeAt(1))){let t=2,o=t;for(;t<i&&!d(e.charCodeAt(t));)t++;if(t<i&&t!==o){for(o=t;t<i&&d(e.charCodeAt(t));)t++;if(t<i&&t!==o){for(o=t;t<i&&!d(e.charCodeAt(t));)t++;t===i?n=t:t!==o&&(n=t+1)}}}}else if(h(r)&&e.charCodeAt(1)===a){if(i<=2)return t.root=t.dir=e,t;if(n=2,d(e.charCodeAt(2))){if(3===i)return t.root=t.dir=e,t;n=3}}n>0&&(t.root=e.slice(0,n));let s=-1,l=n,u=-1,g=!0,p=e.length-1,m=0;for(;p>=n;--p)if(r=e.charCodeAt(p),d(r)){if(!g){l=p+1;break}}else-1===u&&(g=!1,u=p+1),r===o?-1===s?s=p:1!==m&&(m=1):-1!==s&&(m=-1);return-1!==u&&(-1===s||0===m||1===m&&s===u-1&&s===l+1?t.base=t.name=e.slice(l,u):(t.name=e.slice(l,s),t.base=e.slice(l,u),t.ext=e.slice(s,u))),t.dir=l>0&&l!==n?e.slice(0,l-1):t.root,t},sep:"\\",delimiter:";",win32:null,posix:null},f={resolve(...e){let t="",i=!1;for(let o=e.length-1;o>=-1&&!i;o--){const s=o>=0?e[o]:n.cwd();c(s,"path"),0!==s.length&&(t=`${s}/${t}`,i=s.charCodeAt(0)===r)}return t=g(t,!i,"/",u),i?`/${t}`:t.length>0?t:"."},normalize(e){if(c(e,"path"),0===e.length)return".";const t=e.charCodeAt(0)===r,i=e.charCodeAt(e.length-1)===r;return 0===(e=g(e,!t,"/",u)).length?t?"/":i?"./":".":(i&&(e+="/"),t?`/${e}`:e)},isAbsolute(e){return c(e,"path"),e.length>0&&e.charCodeAt(0)===r},join(...e){if(0===e.length)return".";let t;for(let i=0;i<e.length;++i){const n=e[i];c(n,"path"),n.length>0&&(void 0===t?t=n:t+=`/${n}`)}return void 0===t?".":f.normalize(t)},relative(e,t){if(c(e,"from"),c(t,"to"),e===t)return"";if((e=f.resolve(e))===(t=f.resolve(t)))return"";const i=e.length,n=i-1,o=t.length-1,s=n<o?n:o;let a=-1,l=0;for(;l<s;l++){const i=e.charCodeAt(1+l);if(i!==t.charCodeAt(1+l))break;i===r&&(a=l)}if(l===s)if(o>s){if(t.charCodeAt(1+l)===r)return t.slice(1+l+1);if(0===l)return t.slice(1+l)}else n>s&&(e.charCodeAt(1+l)===r?a=l:0===l&&(a=0));let d="";for(l=1+a+1;l<=i;++l)l!==i&&e.charCodeAt(l)!==r||(d+=0===d.length?"..":"/..");return`${d}${t.slice(1+a)}`},toNamespacedPath(e){return e},dirname(e){if(c(e,"path"),0===e.length)return".";const t=e.charCodeAt(0)===r;let i=-1,n=!0;for(let t=e.length-1;t>=1;--t)if(e.charCodeAt(t)===r){if(!n){i=t;break}}else n=!1;return-1===i?t?"/":".":t&&1===i?"//":e.slice(0,i)},basename(e,t){void 0!==t&&c(t,"ext"),c(e,"path");let i,n=0,o=-1,s=!0;if(void 0!==t&&t.length>0&&t.length<=e.length){if(t===e)return"";let a=t.length-1,l=-1;for(i=e.length-1;i>=0;--i){const c=e.charCodeAt(i);if(c===r){if(!s){n=i+1;break}}else-1===l&&(s=!1,l=i+1),a>=0&&(c===t.charCodeAt(a)?-1==--a&&(o=i):(a=-1,o=l))}return n===o?o=l:-1===o&&(o=e.length),e.slice(n,o)}for(i=e.length-1;i>=0;--i)if(e.charCodeAt(i)===r){if(!s){n=i+1;break}}else-1===o&&(s=!1,o=i+1);return-1===o?"":e.slice(n,o)},extname(e){c(e,"path");let t=-1,i=0,n=-1,s=!0,a=0;for(let l=e.length-1;l>=0;--l){const c=e.charCodeAt(l);if(c!==r)-1===n&&(s=!1,n=l+1),c===o?-1===t?t=l:1!==a&&(a=1):-1!==t&&(a=-1);else if(!s){i=l+1;break}}return-1===t||-1===n||0===a||1===a&&t===n-1&&t===i+1?"":e.slice(t,n)},format:p.bind(null,"/"),parse(e){c(e,"path");const t={root:"",dir:"",base:"",ext:"",name:""};if(0===e.length)return t;const i=e.charCodeAt(0)===r;let n;i?(t.root="/",n=1):n=0;let s=-1,a=0,l=-1,d=!0,u=e.length-1,h=0;for(;u>=n;--u){const t=e.charCodeAt(u);if(t!==r)-1===l&&(d=!1,l=u+1),t===o?-1===s?s=u:1!==h&&(h=1):-1!==s&&(h=-1);else if(!d){a=u+1;break}}if(-1!==l){const n=0===a&&i?1:a;-1===s||0===h||1===h&&s===l-1&&s===a+1?t.base=t.name=e.slice(n,l):(t.name=e.slice(n,s),t.base=e.slice(n,l),t.ext=e.slice(s,l))}return a>0?t.dir=e.slice(0,a-1):i&&(t.dir="/"),t},sep:"/",delimiter:":",win32:null,posix:null};f.win32=m.win32=m,f.posix=m.posix=f;const b="win32"===n.platform?m.normalize:f.normalize,_="win32"===n.platform?m.resolve:f.resolve,A="win32"===n.platform?m.relative:f.relative,v="win32"===n.platform?m.dirname:f.dirname,C="win32"===n.platform?m.basename:f.basename,w="win32"===n.platform?m.extname:f.extname,y="win32"===n.platform?m.sep:f.sep},66719:function(e,t,i){"use strict";i.r(t),i.d(t,{OS:function(){return B},globals:function(){return A},isAndroid:function(){return U},isChrome:function(){return z},isEdge:function(){return V},isFirefox:function(){return H},isIOS:function(){return L},isLinux:function(){return E},isLittleEndian:function(){return P},isMacintosh:function(){return x},isNative:function(){return k},isSafari:function(){return W},isWeb:function(){return I},isWebWorker:function(){return D},isWindows:function(){return S},language:function(){return M},setTimeout0:function(){return R},setTimeout0IsFaster:function(){return N},userAgent:function(){return T}});var n,o=i(83787);const r="en";let s,a,l=!1,c=!1,d=!1,u=!1,h=!1,g=!1,p=!1,m=!1,f=!1,b=r,_=null;const A="object"==typeof self?self:"object"==typeof i.g?i.g:{};let v;void 0!==A.vscode&&void 0!==A.vscode.process?v=A.vscode.process:"undefined"!=typeof process&&(v=process);const C="string"==typeof(null===(n=null==v?void 0:v.versions)||void 0===n?void 0:n.electron),w=C&&"renderer"===(null==v?void 0:v.type);if("object"!=typeof navigator||w)if("object"==typeof v){l="win32"===v.platform,c="darwin"===v.platform,d="linux"===v.platform,u=d&&!!v.env.SNAP&&!!v.env.SNAP_REVISION,p=C,f=!!v.env.CI||!!v.env.BUILD_ARTIFACTSTAGINGDIRECTORY,s=r,b=r;const e=v.env.VSCODE_NLS_CONFIG;if(e)try{const t=JSON.parse(e),i=t.availableLanguages["*"];s=t.locale,b=i||r,_=t._translationsConfigFile}catch(e){}h=!0}else console.error("Unable to resolve platform.");else{a=navigator.userAgent,l=a.indexOf("Windows")>=0,c=a.indexOf("Macintosh")>=0,m=(a.indexOf("Macintosh")>=0||a.indexOf("iPad")>=0||a.indexOf("iPhone")>=0)&&!!navigator.maxTouchPoints&&navigator.maxTouchPoints>0,d=a.indexOf("Linux")>=0,g=!0;s=o.getConfiguredDefaultLocale(o.localize("vs/base/common/platform",{key:"ensureLoaderPluginIsLoaded",comment:["{Locked}"]},"_"))||r,b=s}let y=0;c?y=1:l?y=3:d&&(y=2);const S=l,x=c,E=d,k=h,I=g,D=g&&"function"==typeof A.importScripts,L=m,T=a,M=b,N="function"==typeof A.postMessage&&!A.importScripts,R=(()=>{if(N){const e=[];A.addEventListener("message",(t=>{if(t.data&&t.data.vscodeScheduleAsyncWork)for(let i=0,n=e.length;i<n;i++){const n=e[i];if(n.id===t.data.vscodeScheduleAsyncWork)return e.splice(i,1),void n.callback()}}));let t=0;return i=>{const n=++t;e.push({id:n,callback:i}),A.postMessage({vscodeScheduleAsyncWork:n},"*")}}return e=>setTimeout(e)})(),B=c||m?2:l?1:3;let O=!0,F=!1;function P(){if(!F){F=!0;const e=new Uint8Array(2);e[0]=1,e[1]=2;const t=new Uint16Array(e.buffer);O=513===t[0]}return O}const z=!!(T&&T.indexOf("Chrome")>=0),H=!!(T&&T.indexOf("Firefox")>=0),W=!!(!z&&T&&T.indexOf("Safari")>=0),V=!!(T&&T.indexOf("Edg/")>=0),U=!!(T&&T.indexOf("Android")>=0)},63953:function(e,t,i){"use strict";i.r(t),i.d(t,{cwd:function(){return r},env:function(){return s},platform:function(){return a}});var n=i(66719);let o;if(void 0!==n.globals.vscode&&void 0!==n.globals.vscode.process){const e=n.globals.vscode.process;o={get platform(){return e.platform},get arch(){return e.arch},get env(){return e.env},cwd(){return e.cwd()}}}else o="undefined"!=typeof process?{get platform(){return process.platform},get arch(){return process.arch},get env(){return process.env},cwd(){return process.env.VSCODE_CWD||process.cwd()}}:{get platform(){return n.isWindows?"win32":n.isMacintosh?"darwin":"linux"},get arch(){},get env(){return{}},cwd(){return"/"}};const r=o.cwd,s=o.env,a=o.platform},83682:function(e,t,i){"use strict";var n;i.r(t),i.d(t,{Range:function(){return n}}),function(e){function t(e,t){if(e.start>=t.end||t.start>=e.end)return{start:0,end:0};const i=Math.max(e.start,t.start),n=Math.min(e.end,t.end);return n-i<=0?{start:0,end:0}:{start:i,end:n}}function i(e){return e.end-e.start<=0}e.intersect=t,e.isEmpty=i,e.intersects=function(e,n){return!i(t(e,n))},e.relativeComplement=function(e,t){const n=[],o={start:e.start,end:Math.min(t.start,e.end)},r={start:Math.max(t.end,e.start),end:e.end};return i(o)||n.push(o),i(r)||n.push(r),n}}(n||(n={}))},50552:function(e,t,i){"use strict";i.r(t),i.d(t,{DataUri:function(){return L},ExtUri:function(){return d},addTrailingPathSeparator:function(){return D},basename:function(){return _},basenameOrAuthority:function(){return b},dirname:function(){return v},extUri:function(){return u},extUriBiasedIgnorePathCase:function(){return h},extUriIgnorePathCase:function(){return g},extname:function(){return A},getComparisonKey:function(){return f},hasTrailingPathSeparator:function(){return k},isAbsolutePath:function(){return x},isEqual:function(){return p},isEqualAuthority:function(){return E},isEqualOrParent:function(){return m},joinPath:function(){return C},normalizePath:function(){return w},originalFSPath:function(){return c},relativePath:function(){return y},removeTrailingPathSeparator:function(){return I},resolvePath:function(){return S}});var n=i(98508),o=i(27952),r=i(23674),s=i(66719),a=i(91482),l=i(19300);function c(e){return(0,l.uriToFsPath)(e,!0)}class d{constructor(e){this._ignorePathCasing=e}compare(e,t,i=!1){return e===t?0:(0,a.compare)(this.getComparisonKey(e,i),this.getComparisonKey(t,i))}isEqual(e,t,i=!1){return e===t||!(!e||!t)&&this.getComparisonKey(e,i)===this.getComparisonKey(t,i)}getComparisonKey(e,t=!1){return e.with({path:this._ignorePathCasing(e)?e.path.toLowerCase():void 0,fragment:t?null:void 0}).toString()}isEqualOrParent(e,t,i=!1){if(e.scheme===t.scheme){if(e.scheme===o.Schemas.file)return n.isEqualOrParent(c(e),c(t),this._ignorePathCasing(e))&&e.query===t.query&&(i||e.fragment===t.fragment);if(E(e.authority,t.authority))return n.isEqualOrParent(e.path,t.path,this._ignorePathCasing(e),"/")&&e.query===t.query&&(i||e.fragment===t.fragment)}return!1}joinPath(e,...t){return l.URI.joinPath(e,...t)}basenameOrAuthority(e){return _(e)||e.authority}basename(e){return r.posix.basename(e.path)}extname(e){return r.posix.extname(e.path)}dirname(e){if(0===e.path.length)return e;let t;return e.scheme===o.Schemas.file?t=l.URI.file(r.dirname(c(e))).path:(t=r.posix.dirname(e.path),e.authority&&t.length&&47!==t.charCodeAt(0)&&(console.error(`dirname("${e.toString})) resulted in a relative path`),t="/")),e.with({path:t})}normalizePath(e){if(!e.path.length)return e;let t;return t=e.scheme===o.Schemas.file?l.URI.file(r.normalize(c(e))).path:r.posix.normalize(e.path),e.with({path:t})}relativePath(e,t){if(e.scheme!==t.scheme||!E(e.authority,t.authority))return;if(e.scheme===o.Schemas.file){const i=r.relative(c(e),c(t));return s.isWindows?n.toSlashes(i):i}let i=e.path||"/";const a=t.path||"/";if(this._ignorePathCasing(e)){let e=0;for(const t=Math.min(i.length,a.length);e<t&&(i.charCodeAt(e)===a.charCodeAt(e)||i.charAt(e).toLowerCase()===a.charAt(e).toLowerCase());e++);i=a.substr(0,e)+i.substr(e)}return r.posix.relative(i,a)}resolvePath(e,t){if(e.scheme===o.Schemas.file){const i=l.URI.file(r.resolve(c(e),t));return e.with({authority:i.authority,path:i.path})}return t=n.toPosixPath(t),e.with({path:r.posix.resolve(e.path,t)})}isAbsolutePath(e){return!!e.path&&"/"===e.path[0]}isEqualAuthority(e,t){return e===t||void 0!==e&&void 0!==t&&(0,a.equalsIgnoreCase)(e,t)}hasTrailingPathSeparator(e,t=r.sep){if(e.scheme===o.Schemas.file){const i=c(e);return i.length>n.getRoot(i).length&&i[i.length-1]===t}{const t=e.path;return t.length>1&&47===t.charCodeAt(t.length-1)&&!/^[a-zA-Z]:(\/$|\\$)/.test(e.fsPath)}}removeTrailingPathSeparator(e,t=r.sep){return k(e,t)?e.with({path:e.path.substr(0,e.path.length-1)}):e}addTrailingPathSeparator(e,t=r.sep){let i=!1;if(e.scheme===o.Schemas.file){const o=c(e);i=void 0!==o&&o.length===n.getRoot(o).length&&o[o.length-1]===t}else{t="/";const n=e.path;i=1===n.length&&47===n.charCodeAt(n.length-1)}return i||k(e,t)?e:e.with({path:e.path+"/"})}}const u=new d((()=>!1)),h=new d((e=>e.scheme!==o.Schemas.file||!s.isLinux)),g=new d((e=>!0)),p=u.isEqual.bind(u),m=u.isEqualOrParent.bind(u),f=u.getComparisonKey.bind(u),b=u.basenameOrAuthority.bind(u),_=u.basename.bind(u),A=u.extname.bind(u),v=u.dirname.bind(u),C=u.joinPath.bind(u),w=u.normalizePath.bind(u),y=u.relativePath.bind(u),S=u.resolvePath.bind(u),x=u.isAbsolutePath.bind(u),E=u.isEqualAuthority.bind(u),k=u.hasTrailingPathSeparator.bind(u),I=u.removeTrailingPathSeparator.bind(u),D=u.addTrailingPathSeparator.bind(u);var L;!function(e){e.META_DATA_LABEL="label",e.META_DATA_DESCRIPTION="description",e.META_DATA_SIZE="size",e.META_DATA_MIME="mime",e.parseMetaData=function(t){const i=new Map;t.path.substring(t.path.indexOf(";")+1,t.path.lastIndexOf(";")).split(";").forEach((e=>{const[t,n]=e.split(":");t&&n&&i.set(t,n)}));const n=t.path.substring(0,t.path.indexOf(";"));return n&&i.set(e.META_DATA_MIME,n),i}}(L||(L={}))},6097:function(e,t,i){"use strict";i.r(t),i.d(t,{ScrollState:function(){return r},Scrollable:function(){return s},SmoothScrollingOperation:function(){return c},SmoothScrollingUpdate:function(){return a}});var n=i(63801),o=i(68921);class r{constructor(e,t,i,n,o,r,s){this._forceIntegerValues=e,this._scrollStateBrand=void 0,this._forceIntegerValues&&(t|=0,i|=0,n|=0,o|=0,r|=0,s|=0),this.rawScrollLeft=n,this.rawScrollTop=s,t<0&&(t=0),n+t>i&&(n=i-t),n<0&&(n=0),o<0&&(o=0),s+o>r&&(s=r-o),s<0&&(s=0),this.width=t,this.scrollWidth=i,this.scrollLeft=n,this.height=o,this.scrollHeight=r,this.scrollTop=s}equals(e){return this.rawScrollLeft===e.rawScrollLeft&&this.rawScrollTop===e.rawScrollTop&&this.width===e.width&&this.scrollWidth===e.scrollWidth&&this.scrollLeft===e.scrollLeft&&this.height===e.height&&this.scrollHeight===e.scrollHeight&&this.scrollTop===e.scrollTop}withScrollDimensions(e,t){return new r(this._forceIntegerValues,void 0!==e.width?e.width:this.width,void 0!==e.scrollWidth?e.scrollWidth:this.scrollWidth,t?this.rawScrollLeft:this.scrollLeft,void 0!==e.height?e.height:this.height,void 0!==e.scrollHeight?e.scrollHeight:this.scrollHeight,t?this.rawScrollTop:this.scrollTop)}withScrollPosition(e){return new r(this._forceIntegerValues,this.width,this.scrollWidth,void 0!==e.scrollLeft?e.scrollLeft:this.rawScrollLeft,this.height,this.scrollHeight,void 0!==e.scrollTop?e.scrollTop:this.rawScrollTop)}createScrollEvent(e,t){const i=this.width!==e.width,n=this.scrollWidth!==e.scrollWidth,o=this.scrollLeft!==e.scrollLeft,r=this.height!==e.height,s=this.scrollHeight!==e.scrollHeight,a=this.scrollTop!==e.scrollTop;return{inSmoothScrolling:t,oldWidth:e.width,oldScrollWidth:e.scrollWidth,oldScrollLeft:e.scrollLeft,width:this.width,scrollWidth:this.scrollWidth,scrollLeft:this.scrollLeft,oldHeight:e.height,oldScrollHeight:e.scrollHeight,oldScrollTop:e.scrollTop,height:this.height,scrollHeight:this.scrollHeight,scrollTop:this.scrollTop,widthChanged:i,scrollWidthChanged:n,scrollLeftChanged:o,heightChanged:r,scrollHeightChanged:s,scrollTopChanged:a}}}class s extends o.Disposable{constructor(e){super(),this._scrollableBrand=void 0,this._onScroll=this._register(new n.Emitter),this.onScroll=this._onScroll.event,this._smoothScrollDuration=e.smoothScrollDuration,this._scheduleAtNextAnimationFrame=e.scheduleAtNextAnimationFrame,this._state=new r(e.forceIntegerValues,0,0,0,0,0,0),this._smoothScrolling=null}dispose(){this._smoothScrolling&&(this._smoothScrolling.dispose(),this._smoothScrolling=null),super.dispose()}setSmoothScrollDuration(e){this._smoothScrollDuration=e}validateScrollPosition(e){return this._state.withScrollPosition(e)}getScrollDimensions(){return this._state}setScrollDimensions(e,t){var i;const n=this._state.withScrollDimensions(e,t);this._setState(n,Boolean(this._smoothScrolling)),null===(i=this._smoothScrolling)||void 0===i||i.acceptScrollDimensions(this._state)}getFutureScrollPosition(){return this._smoothScrolling?this._smoothScrolling.to:this._state}getCurrentScrollPosition(){return this._state}setScrollPositionNow(e){const t=this._state.withScrollPosition(e);this._smoothScrolling&&(this._smoothScrolling.dispose(),this._smoothScrolling=null),this._setState(t,!1)}setScrollPositionSmooth(e,t){if(0===this._smoothScrollDuration)return this.setScrollPositionNow(e);if(this._smoothScrolling){e={scrollLeft:void 0===e.scrollLeft?this._smoothScrolling.to.scrollLeft:e.scrollLeft,scrollTop:void 0===e.scrollTop?this._smoothScrolling.to.scrollTop:e.scrollTop};const i=this._state.withScrollPosition(e);if(this._smoothScrolling.to.scrollLeft===i.scrollLeft&&this._smoothScrolling.to.scrollTop===i.scrollTop)return;let n;n=t?new c(this._smoothScrolling.from,i,this._smoothScrolling.startTime,this._smoothScrolling.duration):this._smoothScrolling.combine(this._state,i,this._smoothScrollDuration),this._smoothScrolling.dispose(),this._smoothScrolling=n}else{const t=this._state.withScrollPosition(e);this._smoothScrolling=c.start(this._state,t,this._smoothScrollDuration)}this._smoothScrolling.animationFrameDisposable=this._scheduleAtNextAnimationFrame((()=>{this._smoothScrolling&&(this._smoothScrolling.animationFrameDisposable=null,this._performSmoothScrolling())}))}_performSmoothScrolling(){if(!this._smoothScrolling)return;const e=this._smoothScrolling.tick(),t=this._state.withScrollPosition(e);return this._setState(t,!0),this._smoothScrolling?e.isDone?(this._smoothScrolling.dispose(),void(this._smoothScrolling=null)):void(this._smoothScrolling.animationFrameDisposable=this._scheduleAtNextAnimationFrame((()=>{this._smoothScrolling&&(this._smoothScrolling.animationFrameDisposable=null,this._performSmoothScrolling())}))):void 0}_setState(e,t){const i=this._state;i.equals(e)||(this._state=e,this._onScroll.fire(this._state.createScrollEvent(i,t)))}}class a{constructor(e,t,i){this.scrollLeft=e,this.scrollTop=t,this.isDone=i}}function l(e,t){const i=t-e;return function(t){return e+i*(1-function(e){return Math.pow(e,3)}(1-t))}}class c{constructor(e,t,i,n){this.from=e,this.to=t,this.duration=n,this.startTime=i,this.animationFrameDisposable=null,this._initAnimations()}_initAnimations(){this.scrollLeft=this._initAnimation(this.from.scrollLeft,this.to.scrollLeft,this.to.width),this.scrollTop=this._initAnimation(this.from.scrollTop,this.to.scrollTop,this.to.height)}_initAnimation(e,t,i){if(Math.abs(e-t)>2.5*i){let s,a;return e<t?(s=e+.75*i,a=t-.75*i):(s=e-.75*i,a=t+.75*i),n=l(e,s),o=l(a,t),r=.33,function(e){return e<r?n(e/r):o((e-r)/(1-r))}}var n,o,r;return l(e,t)}dispose(){null!==this.animationFrameDisposable&&(this.animationFrameDisposable.dispose(),this.animationFrameDisposable=null)}acceptScrollDimensions(e){this.to=e.withScrollPosition(this.to),this._initAnimations()}tick(){return this._tick(Date.now())}_tick(e){const t=(e-this.startTime)/this.duration;if(t<1){const e=this.scrollLeft(t),i=this.scrollTop(t);return new a(e,i,!1)}return new a(this.to.scrollLeft,this.to.scrollTop,!0)}combine(e,t,i){return c.start(e,t,i)}static start(e,t,i){i+=10;const n=Date.now()-10;return new c(e,t,n,i)}}},15051:function(e,t,i){"use strict";i.r(t);var n,o=i(91482);!function(e){e[e.Ignore=0]="Ignore",e[e.Info=1]="Info",e[e.Warning=2]="Warning",e[e.Error=3]="Error"}(n||(n={})),function(e){const t="error",i="warning",n="info";e.fromValue=function(r){return r?o.equalsIgnoreCase(t,r)?e.Error:o.equalsIgnoreCase(i,r)||o.equalsIgnoreCase("warn",r)?e.Warning:o.equalsIgnoreCase(n,r)?e.Info:e.Ignore:e.Ignore},e.toString=function(o){switch(o){case e.Error:return t;case e.Warning:return i;case e.Info:return n;default:return"ignore"}}}(n||(n={})),t.default=n},702:function(e,t,i){"use strict";i.r(t),i.d(t,{StopWatch:function(){return r}});var n=i(66719);const o=n.globals.performance&&"function"==typeof n.globals.performance.now;class r{constructor(e){this._highResolution=o&&e,this._startTime=this._now(),this._stopTime=-1}static create(e=!0){return new r(e)}stop(){this._stopTime=this._now()}elapsed(){return-1!==this._stopTime?this._stopTime-this._startTime:this._now()-this._startTime}_now(){return this._highResolution?n.globals.performance.now():Date.now()}}},91482:function(e,t,i){"use strict";i.r(t),i.d(t,{AmbiguousCharacters:function(){return se},CodePointIterator:function(){return P},GraphemeIterator:function(){return z},InvisibleCharacters:function(){return ae},UNUSUAL_LINE_TERMINATORS:function(){return G},UTF8_BOM_CHARACTER:function(){return J},commonPrefixLength:function(){return M},commonSuffixLength:function(){return N},compare:function(){return y},compareIgnoreCase:function(){return x},compareSubstring:function(){return S},compareSubstringIgnoreCase:function(){return E},computeCodePoint:function(){return O},containsRTL:function(){return Q},containsUnusualLineTerminators:function(){return $},containsUppercaseCharacter:function(){return X},convertSimple2RegExpPattern:function(){return p},createRegExp:function(){return f},equalsIgnoreCase:function(){return L},escape:function(){return c},escapeRegExpCharacters:function(){return d},firstNonWhitespaceIndex:function(){return v},format:function(){return l},getCharContainingOffset:function(){return V},getLeadingWhitespace:function(){return C},getLeftDeleteOffset:function(){return ne},getNextCodePoint:function(){return F},isAsciiDigit:function(){return k},isBasicASCII:function(){return j},isEmojiImprecise:function(){return q},isFalsyOrWhitespace:function(){return s},isFullWidthCharacter:function(){return Y},isHighSurrogate:function(){return R},isLowSurrogate:function(){return B},isLowerAsciiLetter:function(){return I},isUpperAsciiLetter:function(){return D},lastNonWhitespaceIndex:function(){return w},ltrim:function(){return h},nextCharLength:function(){return H},noBreakWhitespace:function(){return re},prevCharLength:function(){return W},regExpFlags:function(){return _},regExpLeadsToEndlessLoop:function(){return b},rtrim:function(){return g},singleLetterHash:function(){return ee},splitLines:function(){return A},startsWithIgnoreCase:function(){return T},startsWithUTF8BOM:function(){return Z},stripWildcards:function(){return m},trim:function(){return u}});var n,o=i(12359),r=i(5560);function s(e){return!e||"string"!=typeof e||0===e.trim().length}const a=/{(\d+)}/g;function l(e,...t){return 0===t.length?e:e.replace(a,(function(e,i){const n=parseInt(i,10);return isNaN(n)||n<0||n>=t.length?e:t[n]}))}function c(e){return e.replace(/[<>&]/g,(function(e){switch(e){case"<":return"&lt;";case">":return"&gt;";case"&":return"&amp;";default:return e}}))}function d(e){return e.replace(/[\\\{\}\*\+\?\|\^\$\.\[\]\(\)]/g,"\\$&")}function u(e,t=" "){return g(h(e,t),t)}function h(e,t){if(!e||!t)return e;const i=t.length;if(0===i||0===e.length)return e;let n=0;for(;e.indexOf(t,n)===n;)n+=i;return e.substring(n)}function g(e,t){if(!e||!t)return e;const i=t.length,n=e.length;if(0===i||0===n)return e;let o=n,r=-1;for(;r=e.lastIndexOf(t,o-1),-1!==r&&r+i===o;){if(0===r)return"";o=r}return e.substring(0,o)}function p(e){return e.replace(/[\-\\\{\}\+\?\|\^\$\.\,\[\]\(\)\#\s]/g,"\\$&").replace(/[\*]/g,".*")}function m(e){return e.replace(/\*/g,"")}function f(e,t,i={}){if(!e)throw new Error("Cannot create regex from empty string");t||(e=d(e)),i.wholeWord&&(/\B/.test(e.charAt(0))||(e="\\b"+e),/\B/.test(e.charAt(e.length-1))||(e+="\\b"));let n="";return i.global&&(n+="g"),i.matchCase||(n+="i"),i.multiline&&(n+="m"),i.unicode&&(n+="u"),new RegExp(e,n)}function b(e){if("^"===e.source||"^$"===e.source||"$"===e.source||"^\\s*$"===e.source)return!1;return!(!e.exec("")||0!==e.lastIndex)}function _(e){return(e.global?"g":"")+(e.ignoreCase?"i":"")+(e.multiline?"m":"")+(e.unicode?"u":"")}function A(e){return e.split(/\r\n|\r|\n/)}function v(e){for(let t=0,i=e.length;t<i;t++){const i=e.charCodeAt(t);if(32!==i&&9!==i)return t}return-1}function C(e,t=0,i=e.length){for(let n=t;n<i;n++){const i=e.charCodeAt(n);if(32!==i&&9!==i)return e.substring(t,n)}return e.substring(t,i)}function w(e,t=e.length-1){for(let i=t;i>=0;i--){const t=e.charCodeAt(i);if(32!==t&&9!==t)return i}return-1}function y(e,t){return e<t?-1:e>t?1:0}function S(e,t,i=0,n=e.length,o=0,r=t.length){for(;i<n&&o<r;i++,o++){const n=e.charCodeAt(i),r=t.charCodeAt(o);if(n<r)return-1;if(n>r)return 1}const s=n-i,a=r-o;return s<a?-1:s>a?1:0}function x(e,t){return E(e,t,0,e.length,0,t.length)}function E(e,t,i=0,n=e.length,o=0,r=t.length){for(;i<n&&o<r;i++,o++){let s=e.charCodeAt(i),a=t.charCodeAt(o);if(s===a)continue;if(s>=128||a>=128)return S(e.toLowerCase(),t.toLowerCase(),i,n,o,r);I(s)&&(s-=32),I(a)&&(a-=32);const l=s-a;if(0!==l)return l}const s=n-i,a=r-o;return s<a?-1:s>a?1:0}function k(e){return e>=48&&e<=57}function I(e){return e>=97&&e<=122}function D(e){return e>=65&&e<=90}function L(e,t){return e.length===t.length&&0===E(e,t)}function T(e,t){const i=t.length;return!(t.length>e.length)&&0===E(e,t,0,i)}function M(e,t){const i=Math.min(e.length,t.length);let n;for(n=0;n<i;n++)if(e.charCodeAt(n)!==t.charCodeAt(n))return n;return i}function N(e,t){const i=Math.min(e.length,t.length);let n;const o=e.length-1,r=t.length-1;for(n=0;n<i;n++)if(e.charCodeAt(o-n)!==t.charCodeAt(r-n))return n;return i}function R(e){return 55296<=e&&e<=56319}function B(e){return 56320<=e&&e<=57343}function O(e,t){return t-56320+(e-55296<<10)+65536}function F(e,t,i){const n=e.charCodeAt(i);if(R(n)&&i+1<t){const t=e.charCodeAt(i+1);if(B(t))return O(n,t)}return n}class P{constructor(e,t=0){this._str=e,this._len=e.length,this._offset=t}get offset(){return this._offset}setOffset(e){this._offset=e}prevCodePoint(){const e=function(e,t){const i=e.charCodeAt(t-1);if(B(i)&&t>1){const n=e.charCodeAt(t-2);if(R(n))return O(n,i)}return i}(this._str,this._offset);return this._offset-=e>=65536?2:1,e}nextCodePoint(){const e=F(this._str,this._len,this._offset);return this._offset+=e>=65536?2:1,e}eol(){return this._offset>=this._len}}class z{constructor(e,t=0){this._iterator=new P(e,t)}get offset(){return this._iterator.offset}nextGraphemeLength(){const e=ie.getInstance(),t=this._iterator,i=t.offset;let n=e.getGraphemeBreakType(t.nextCodePoint());for(;!t.eol();){const i=t.offset,o=e.getGraphemeBreakType(t.nextCodePoint());if(te(n,o)){t.setOffset(i);break}n=o}return t.offset-i}prevGraphemeLength(){const e=ie.getInstance(),t=this._iterator,i=t.offset;let n=e.getGraphemeBreakType(t.prevCodePoint());for(;t.offset>0;){const i=t.offset,o=e.getGraphemeBreakType(t.prevCodePoint());if(te(o,n)){t.setOffset(i);break}n=o}return i-t.offset}eol(){return this._iterator.eol()}}function H(e,t){return new z(e,t).nextGraphemeLength()}function W(e,t){return new z(e,t).prevGraphemeLength()}function V(e,t){t>0&&B(e.charCodeAt(t))&&t--;const i=t+H(e,t);return[i-W(e,i),i]}const U=/(?:[\u05BE\u05C0\u05C3\u05C6\u05D0-\u05F4\u0608\u060B\u060D\u061B-\u064A\u066D-\u066F\u0671-\u06D5\u06E5\u06E6\u06EE\u06EF\u06FA-\u0710\u0712-\u072F\u074D-\u07A5\u07B1-\u07EA\u07F4\u07F5\u07FA\u07FE-\u0815\u081A\u0824\u0828\u0830-\u0858\u085E-\u088E\u08A0-\u08C9\u200F\uFB1D\uFB1F-\uFB28\uFB2A-\uFD3D\uFD50-\uFDC7\uFDF0-\uFDFC\uFE70-\uFEFC]|\uD802[\uDC00-\uDD1B\uDD20-\uDE00\uDE10-\uDE35\uDE40-\uDEE4\uDEEB-\uDF35\uDF40-\uDFFF]|\uD803[\uDC00-\uDD23\uDE80-\uDEA9\uDEAD-\uDF45\uDF51-\uDF81\uDF86-\uDFF6]|\uD83A[\uDC00-\uDCCF\uDD00-\uDD43\uDD4B-\uDFFF]|\uD83B[\uDC00-\uDEBB])/;function Q(e){return U.test(e)}const K=/^[\t\n\r\x20-\x7E]*$/;function j(e){return K.test(e)}const G=/[\u2028\u2029]/;function $(e){return G.test(e)}function Y(e){return e>=11904&&e<=55215||e>=63744&&e<=64255||e>=65281&&e<=65374}function q(e){return e>=127462&&e<=127487||8986===e||8987===e||9200===e||9203===e||e>=9728&&e<=10175||11088===e||11093===e||e>=127744&&e<=128591||e>=128640&&e<=128764||e>=128992&&e<=129008||e>=129280&&e<=129535||e>=129648&&e<=129782}const J=String.fromCharCode(65279);function Z(e){return!!(e&&e.length>0&&65279===e.charCodeAt(0))}function X(e,t=!1){return!!e&&(t&&(e=e.replace(/\\./g,"")),e.toLowerCase()!==e)}function ee(e){return(e%=52)<26?String.fromCharCode(97+e):String.fromCharCode(65+e-26)}function te(e,t){return 0===e?5!==t&&7!==t:(2!==e||3!==t)&&(4===e||2===e||3===e||(4===t||2===t||3===t||(8!==e||8!==t&&9!==t&&11!==t&&12!==t)&&((11!==e&&9!==e||9!==t&&10!==t)&&((12!==e&&10!==e||10!==t)&&(5!==t&&13!==t&&(7!==t&&(1!==e&&((13!==e||14!==t)&&(6!==e||6!==t)))))))))}class ie{constructor(){this._data=JSON.parse("[0,0,0,51229,51255,12,44061,44087,12,127462,127487,6,7083,7085,5,47645,47671,12,54813,54839,12,128678,128678,14,3270,3270,5,9919,9923,14,45853,45879,12,49437,49463,12,53021,53047,12,71216,71218,7,128398,128399,14,129360,129374,14,2519,2519,5,4448,4519,9,9742,9742,14,12336,12336,14,44957,44983,12,46749,46775,12,48541,48567,12,50333,50359,12,52125,52151,12,53917,53943,12,69888,69890,5,73018,73018,5,127990,127990,14,128558,128559,14,128759,128760,14,129653,129655,14,2027,2035,5,2891,2892,7,3761,3761,5,6683,6683,5,8293,8293,4,9825,9826,14,9999,9999,14,43452,43453,5,44509,44535,12,45405,45431,12,46301,46327,12,47197,47223,12,48093,48119,12,48989,49015,12,49885,49911,12,50781,50807,12,51677,51703,12,52573,52599,12,53469,53495,12,54365,54391,12,65279,65279,4,70471,70472,7,72145,72147,7,119173,119179,5,127799,127818,14,128240,128244,14,128512,128512,14,128652,128652,14,128721,128722,14,129292,129292,14,129445,129450,14,129734,129743,14,1476,1477,5,2366,2368,7,2750,2752,7,3076,3076,5,3415,3415,5,4141,4144,5,6109,6109,5,6964,6964,5,7394,7400,5,9197,9198,14,9770,9770,14,9877,9877,14,9968,9969,14,10084,10084,14,43052,43052,5,43713,43713,5,44285,44311,12,44733,44759,12,45181,45207,12,45629,45655,12,46077,46103,12,46525,46551,12,46973,46999,12,47421,47447,12,47869,47895,12,48317,48343,12,48765,48791,12,49213,49239,12,49661,49687,12,50109,50135,12,50557,50583,12,51005,51031,12,51453,51479,12,51901,51927,12,52349,52375,12,52797,52823,12,53245,53271,12,53693,53719,12,54141,54167,12,54589,54615,12,55037,55063,12,69506,69509,5,70191,70193,5,70841,70841,7,71463,71467,5,72330,72342,5,94031,94031,5,123628,123631,5,127763,127765,14,127941,127941,14,128043,128062,14,128302,128317,14,128465,128467,14,128539,128539,14,128640,128640,14,128662,128662,14,128703,128703,14,128745,128745,14,129004,129007,14,129329,129330,14,129402,129402,14,129483,129483,14,129686,129704,14,130048,131069,14,173,173,4,1757,1757,1,2200,2207,5,2434,2435,7,2631,2632,5,2817,2817,5,3008,3008,5,3201,3201,5,3387,3388,5,3542,3542,5,3902,3903,7,4190,4192,5,6002,6003,5,6439,6440,5,6765,6770,7,7019,7027,5,7154,7155,7,8205,8205,13,8505,8505,14,9654,9654,14,9757,9757,14,9792,9792,14,9852,9853,14,9890,9894,14,9937,9937,14,9981,9981,14,10035,10036,14,11035,11036,14,42654,42655,5,43346,43347,7,43587,43587,5,44006,44007,7,44173,44199,12,44397,44423,12,44621,44647,12,44845,44871,12,45069,45095,12,45293,45319,12,45517,45543,12,45741,45767,12,45965,45991,12,46189,46215,12,46413,46439,12,46637,46663,12,46861,46887,12,47085,47111,12,47309,47335,12,47533,47559,12,47757,47783,12,47981,48007,12,48205,48231,12,48429,48455,12,48653,48679,12,48877,48903,12,49101,49127,12,49325,49351,12,49549,49575,12,49773,49799,12,49997,50023,12,50221,50247,12,50445,50471,12,50669,50695,12,50893,50919,12,51117,51143,12,51341,51367,12,51565,51591,12,51789,51815,12,52013,52039,12,52237,52263,12,52461,52487,12,52685,52711,12,52909,52935,12,53133,53159,12,53357,53383,12,53581,53607,12,53805,53831,12,54029,54055,12,54253,54279,12,54477,54503,12,54701,54727,12,54925,54951,12,55149,55175,12,68101,68102,5,69762,69762,7,70067,70069,7,70371,70378,5,70720,70721,7,71087,71087,5,71341,71341,5,71995,71996,5,72249,72249,7,72850,72871,5,73109,73109,5,118576,118598,5,121505,121519,5,127245,127247,14,127568,127569,14,127777,127777,14,127872,127891,14,127956,127967,14,128015,128016,14,128110,128172,14,128259,128259,14,128367,128368,14,128424,128424,14,128488,128488,14,128530,128532,14,128550,128551,14,128566,128566,14,128647,128647,14,128656,128656,14,128667,128673,14,128691,128693,14,128715,128715,14,128728,128732,14,128752,128752,14,128765,128767,14,129096,129103,14,129311,129311,14,129344,129349,14,129394,129394,14,129413,129425,14,129466,129471,14,129511,129535,14,129664,129666,14,129719,129722,14,129760,129767,14,917536,917631,5,13,13,2,1160,1161,5,1564,1564,4,1807,1807,1,2085,2087,5,2307,2307,7,2382,2383,7,2497,2500,5,2563,2563,7,2677,2677,5,2763,2764,7,2879,2879,5,2914,2915,5,3021,3021,5,3142,3144,5,3263,3263,5,3285,3286,5,3398,3400,7,3530,3530,5,3633,3633,5,3864,3865,5,3974,3975,5,4155,4156,7,4229,4230,5,5909,5909,7,6078,6085,7,6277,6278,5,6451,6456,7,6744,6750,5,6846,6846,5,6972,6972,5,7074,7077,5,7146,7148,7,7222,7223,5,7416,7417,5,8234,8238,4,8417,8417,5,9000,9000,14,9203,9203,14,9730,9731,14,9748,9749,14,9762,9763,14,9776,9783,14,9800,9811,14,9831,9831,14,9872,9873,14,9882,9882,14,9900,9903,14,9929,9933,14,9941,9960,14,9974,9974,14,9989,9989,14,10006,10006,14,10062,10062,14,10160,10160,14,11647,11647,5,12953,12953,14,43019,43019,5,43232,43249,5,43443,43443,5,43567,43568,7,43696,43696,5,43765,43765,7,44013,44013,5,44117,44143,12,44229,44255,12,44341,44367,12,44453,44479,12,44565,44591,12,44677,44703,12,44789,44815,12,44901,44927,12,45013,45039,12,45125,45151,12,45237,45263,12,45349,45375,12,45461,45487,12,45573,45599,12,45685,45711,12,45797,45823,12,45909,45935,12,46021,46047,12,46133,46159,12,46245,46271,12,46357,46383,12,46469,46495,12,46581,46607,12,46693,46719,12,46805,46831,12,46917,46943,12,47029,47055,12,47141,47167,12,47253,47279,12,47365,47391,12,47477,47503,12,47589,47615,12,47701,47727,12,47813,47839,12,47925,47951,12,48037,48063,12,48149,48175,12,48261,48287,12,48373,48399,12,48485,48511,12,48597,48623,12,48709,48735,12,48821,48847,12,48933,48959,12,49045,49071,12,49157,49183,12,49269,49295,12,49381,49407,12,49493,49519,12,49605,49631,12,49717,49743,12,49829,49855,12,49941,49967,12,50053,50079,12,50165,50191,12,50277,50303,12,50389,50415,12,50501,50527,12,50613,50639,12,50725,50751,12,50837,50863,12,50949,50975,12,51061,51087,12,51173,51199,12,51285,51311,12,51397,51423,12,51509,51535,12,51621,51647,12,51733,51759,12,51845,51871,12,51957,51983,12,52069,52095,12,52181,52207,12,52293,52319,12,52405,52431,12,52517,52543,12,52629,52655,12,52741,52767,12,52853,52879,12,52965,52991,12,53077,53103,12,53189,53215,12,53301,53327,12,53413,53439,12,53525,53551,12,53637,53663,12,53749,53775,12,53861,53887,12,53973,53999,12,54085,54111,12,54197,54223,12,54309,54335,12,54421,54447,12,54533,54559,12,54645,54671,12,54757,54783,12,54869,54895,12,54981,55007,12,55093,55119,12,55243,55291,10,66045,66045,5,68325,68326,5,69688,69702,5,69817,69818,5,69957,69958,7,70089,70092,5,70198,70199,5,70462,70462,5,70502,70508,5,70750,70750,5,70846,70846,7,71100,71101,5,71230,71230,7,71351,71351,5,71737,71738,5,72000,72000,7,72160,72160,5,72273,72278,5,72752,72758,5,72882,72883,5,73031,73031,5,73461,73462,7,94192,94193,7,119149,119149,7,121403,121452,5,122915,122916,5,126980,126980,14,127358,127359,14,127535,127535,14,127759,127759,14,127771,127771,14,127792,127793,14,127825,127867,14,127897,127899,14,127945,127945,14,127985,127986,14,128000,128007,14,128021,128021,14,128066,128100,14,128184,128235,14,128249,128252,14,128266,128276,14,128335,128335,14,128379,128390,14,128407,128419,14,128444,128444,14,128481,128481,14,128499,128499,14,128526,128526,14,128536,128536,14,128543,128543,14,128556,128556,14,128564,128564,14,128577,128580,14,128643,128645,14,128649,128649,14,128654,128654,14,128660,128660,14,128664,128664,14,128675,128675,14,128686,128689,14,128695,128696,14,128705,128709,14,128717,128719,14,128725,128725,14,128736,128741,14,128747,128748,14,128755,128755,14,128762,128762,14,128981,128991,14,129009,129023,14,129160,129167,14,129296,129304,14,129320,129327,14,129340,129342,14,129356,129356,14,129388,129392,14,129399,129400,14,129404,129407,14,129432,129442,14,129454,129455,14,129473,129474,14,129485,129487,14,129648,129651,14,129659,129660,14,129671,129679,14,129709,129711,14,129728,129730,14,129751,129753,14,129776,129782,14,917505,917505,4,917760,917999,5,10,10,3,127,159,4,768,879,5,1471,1471,5,1536,1541,1,1648,1648,5,1767,1768,5,1840,1866,5,2070,2073,5,2137,2139,5,2274,2274,1,2363,2363,7,2377,2380,7,2402,2403,5,2494,2494,5,2507,2508,7,2558,2558,5,2622,2624,7,2641,2641,5,2691,2691,7,2759,2760,5,2786,2787,5,2876,2876,5,2881,2884,5,2901,2902,5,3006,3006,5,3014,3016,7,3072,3072,5,3134,3136,5,3157,3158,5,3260,3260,5,3266,3266,5,3274,3275,7,3328,3329,5,3391,3392,7,3405,3405,5,3457,3457,5,3536,3537,7,3551,3551,5,3636,3642,5,3764,3772,5,3895,3895,5,3967,3967,7,3993,4028,5,4146,4151,5,4182,4183,7,4226,4226,5,4253,4253,5,4957,4959,5,5940,5940,7,6070,6070,7,6087,6088,7,6158,6158,4,6432,6434,5,6448,6449,7,6679,6680,5,6742,6742,5,6754,6754,5,6783,6783,5,6912,6915,5,6966,6970,5,6978,6978,5,7042,7042,7,7080,7081,5,7143,7143,7,7150,7150,7,7212,7219,5,7380,7392,5,7412,7412,5,8203,8203,4,8232,8232,4,8265,8265,14,8400,8412,5,8421,8432,5,8617,8618,14,9167,9167,14,9200,9200,14,9410,9410,14,9723,9726,14,9733,9733,14,9745,9745,14,9752,9752,14,9760,9760,14,9766,9766,14,9774,9774,14,9786,9786,14,9794,9794,14,9823,9823,14,9828,9828,14,9833,9850,14,9855,9855,14,9875,9875,14,9880,9880,14,9885,9887,14,9896,9897,14,9906,9916,14,9926,9927,14,9935,9935,14,9939,9939,14,9962,9962,14,9972,9972,14,9978,9978,14,9986,9986,14,9997,9997,14,10002,10002,14,10017,10017,14,10055,10055,14,10071,10071,14,10133,10135,14,10548,10549,14,11093,11093,14,12330,12333,5,12441,12442,5,42608,42610,5,43010,43010,5,43045,43046,5,43188,43203,7,43302,43309,5,43392,43394,5,43446,43449,5,43493,43493,5,43571,43572,7,43597,43597,7,43703,43704,5,43756,43757,5,44003,44004,7,44009,44010,7,44033,44059,12,44089,44115,12,44145,44171,12,44201,44227,12,44257,44283,12,44313,44339,12,44369,44395,12,44425,44451,12,44481,44507,12,44537,44563,12,44593,44619,12,44649,44675,12,44705,44731,12,44761,44787,12,44817,44843,12,44873,44899,12,44929,44955,12,44985,45011,12,45041,45067,12,45097,45123,12,45153,45179,12,45209,45235,12,45265,45291,12,45321,45347,12,45377,45403,12,45433,45459,12,45489,45515,12,45545,45571,12,45601,45627,12,45657,45683,12,45713,45739,12,45769,45795,12,45825,45851,12,45881,45907,12,45937,45963,12,45993,46019,12,46049,46075,12,46105,46131,12,46161,46187,12,46217,46243,12,46273,46299,12,46329,46355,12,46385,46411,12,46441,46467,12,46497,46523,12,46553,46579,12,46609,46635,12,46665,46691,12,46721,46747,12,46777,46803,12,46833,46859,12,46889,46915,12,46945,46971,12,47001,47027,12,47057,47083,12,47113,47139,12,47169,47195,12,47225,47251,12,47281,47307,12,47337,47363,12,47393,47419,12,47449,47475,12,47505,47531,12,47561,47587,12,47617,47643,12,47673,47699,12,47729,47755,12,47785,47811,12,47841,47867,12,47897,47923,12,47953,47979,12,48009,48035,12,48065,48091,12,48121,48147,12,48177,48203,12,48233,48259,12,48289,48315,12,48345,48371,12,48401,48427,12,48457,48483,12,48513,48539,12,48569,48595,12,48625,48651,12,48681,48707,12,48737,48763,12,48793,48819,12,48849,48875,12,48905,48931,12,48961,48987,12,49017,49043,12,49073,49099,12,49129,49155,12,49185,49211,12,49241,49267,12,49297,49323,12,49353,49379,12,49409,49435,12,49465,49491,12,49521,49547,12,49577,49603,12,49633,49659,12,49689,49715,12,49745,49771,12,49801,49827,12,49857,49883,12,49913,49939,12,49969,49995,12,50025,50051,12,50081,50107,12,50137,50163,12,50193,50219,12,50249,50275,12,50305,50331,12,50361,50387,12,50417,50443,12,50473,50499,12,50529,50555,12,50585,50611,12,50641,50667,12,50697,50723,12,50753,50779,12,50809,50835,12,50865,50891,12,50921,50947,12,50977,51003,12,51033,51059,12,51089,51115,12,51145,51171,12,51201,51227,12,51257,51283,12,51313,51339,12,51369,51395,12,51425,51451,12,51481,51507,12,51537,51563,12,51593,51619,12,51649,51675,12,51705,51731,12,51761,51787,12,51817,51843,12,51873,51899,12,51929,51955,12,51985,52011,12,52041,52067,12,52097,52123,12,52153,52179,12,52209,52235,12,52265,52291,12,52321,52347,12,52377,52403,12,52433,52459,12,52489,52515,12,52545,52571,12,52601,52627,12,52657,52683,12,52713,52739,12,52769,52795,12,52825,52851,12,52881,52907,12,52937,52963,12,52993,53019,12,53049,53075,12,53105,53131,12,53161,53187,12,53217,53243,12,53273,53299,12,53329,53355,12,53385,53411,12,53441,53467,12,53497,53523,12,53553,53579,12,53609,53635,12,53665,53691,12,53721,53747,12,53777,53803,12,53833,53859,12,53889,53915,12,53945,53971,12,54001,54027,12,54057,54083,12,54113,54139,12,54169,54195,12,54225,54251,12,54281,54307,12,54337,54363,12,54393,54419,12,54449,54475,12,54505,54531,12,54561,54587,12,54617,54643,12,54673,54699,12,54729,54755,12,54785,54811,12,54841,54867,12,54897,54923,12,54953,54979,12,55009,55035,12,55065,55091,12,55121,55147,12,55177,55203,12,65024,65039,5,65520,65528,4,66422,66426,5,68152,68154,5,69291,69292,5,69633,69633,5,69747,69748,5,69811,69814,5,69826,69826,5,69932,69932,7,70016,70017,5,70079,70080,7,70095,70095,5,70196,70196,5,70367,70367,5,70402,70403,7,70464,70464,5,70487,70487,5,70709,70711,7,70725,70725,7,70833,70834,7,70843,70844,7,70849,70849,7,71090,71093,5,71103,71104,5,71227,71228,7,71339,71339,5,71344,71349,5,71458,71461,5,71727,71735,5,71985,71989,7,71998,71998,5,72002,72002,7,72154,72155,5,72193,72202,5,72251,72254,5,72281,72283,5,72344,72345,5,72766,72766,7,72874,72880,5,72885,72886,5,73023,73029,5,73104,73105,5,73111,73111,5,92912,92916,5,94095,94098,5,113824,113827,4,119142,119142,7,119155,119162,4,119362,119364,5,121476,121476,5,122888,122904,5,123184,123190,5,125252,125258,5,127183,127183,14,127340,127343,14,127377,127386,14,127491,127503,14,127548,127551,14,127744,127756,14,127761,127761,14,127769,127769,14,127773,127774,14,127780,127788,14,127796,127797,14,127820,127823,14,127869,127869,14,127894,127895,14,127902,127903,14,127943,127943,14,127947,127950,14,127972,127972,14,127988,127988,14,127992,127994,14,128009,128011,14,128019,128019,14,128023,128041,14,128064,128064,14,128102,128107,14,128174,128181,14,128238,128238,14,128246,128247,14,128254,128254,14,128264,128264,14,128278,128299,14,128329,128330,14,128348,128359,14,128371,128377,14,128392,128393,14,128401,128404,14,128421,128421,14,128433,128434,14,128450,128452,14,128476,128478,14,128483,128483,14,128495,128495,14,128506,128506,14,128519,128520,14,128528,128528,14,128534,128534,14,128538,128538,14,128540,128542,14,128544,128549,14,128552,128555,14,128557,128557,14,128560,128563,14,128565,128565,14,128567,128576,14,128581,128591,14,128641,128642,14,128646,128646,14,128648,128648,14,128650,128651,14,128653,128653,14,128655,128655,14,128657,128659,14,128661,128661,14,128663,128663,14,128665,128666,14,128674,128674,14,128676,128677,14,128679,128685,14,128690,128690,14,128694,128694,14,128697,128702,14,128704,128704,14,128710,128714,14,128716,128716,14,128720,128720,14,128723,128724,14,128726,128727,14,128733,128735,14,128742,128744,14,128746,128746,14,128749,128751,14,128753,128754,14,128756,128758,14,128761,128761,14,128763,128764,14,128884,128895,14,128992,129003,14,129008,129008,14,129036,129039,14,129114,129119,14,129198,129279,14,129293,129295,14,129305,129310,14,129312,129319,14,129328,129328,14,129331,129338,14,129343,129343,14,129351,129355,14,129357,129359,14,129375,129387,14,129393,129393,14,129395,129398,14,129401,129401,14,129403,129403,14,129408,129412,14,129426,129431,14,129443,129444,14,129451,129453,14,129456,129465,14,129472,129472,14,129475,129482,14,129484,129484,14,129488,129510,14,129536,129647,14,129652,129652,14,129656,129658,14,129661,129663,14,129667,129670,14,129680,129685,14,129705,129708,14,129712,129718,14,129723,129727,14,129731,129733,14,129744,129750,14,129754,129759,14,129768,129775,14,129783,129791,14,917504,917504,4,917506,917535,4,917632,917759,4,918000,921599,4,0,9,4,11,12,4,14,31,4,169,169,14,174,174,14,1155,1159,5,1425,1469,5,1473,1474,5,1479,1479,5,1552,1562,5,1611,1631,5,1750,1756,5,1759,1764,5,1770,1773,5,1809,1809,5,1958,1968,5,2045,2045,5,2075,2083,5,2089,2093,5,2192,2193,1,2250,2273,5,2275,2306,5,2362,2362,5,2364,2364,5,2369,2376,5,2381,2381,5,2385,2391,5,2433,2433,5,2492,2492,5,2495,2496,7,2503,2504,7,2509,2509,5,2530,2531,5,2561,2562,5,2620,2620,5,2625,2626,5,2635,2637,5,2672,2673,5,2689,2690,5,2748,2748,5,2753,2757,5,2761,2761,7,2765,2765,5,2810,2815,5,2818,2819,7,2878,2878,5,2880,2880,7,2887,2888,7,2893,2893,5,2903,2903,5,2946,2946,5,3007,3007,7,3009,3010,7,3018,3020,7,3031,3031,5,3073,3075,7,3132,3132,5,3137,3140,7,3146,3149,5,3170,3171,5,3202,3203,7,3262,3262,7,3264,3265,7,3267,3268,7,3271,3272,7,3276,3277,5,3298,3299,5,3330,3331,7,3390,3390,5,3393,3396,5,3402,3404,7,3406,3406,1,3426,3427,5,3458,3459,7,3535,3535,5,3538,3540,5,3544,3550,7,3570,3571,7,3635,3635,7,3655,3662,5,3763,3763,7,3784,3789,5,3893,3893,5,3897,3897,5,3953,3966,5,3968,3972,5,3981,3991,5,4038,4038,5,4145,4145,7,4153,4154,5,4157,4158,5,4184,4185,5,4209,4212,5,4228,4228,7,4237,4237,5,4352,4447,8,4520,4607,10,5906,5908,5,5938,5939,5,5970,5971,5,6068,6069,5,6071,6077,5,6086,6086,5,6089,6099,5,6155,6157,5,6159,6159,5,6313,6313,5,6435,6438,7,6441,6443,7,6450,6450,5,6457,6459,5,6681,6682,7,6741,6741,7,6743,6743,7,6752,6752,5,6757,6764,5,6771,6780,5,6832,6845,5,6847,6862,5,6916,6916,7,6965,6965,5,6971,6971,7,6973,6977,7,6979,6980,7,7040,7041,5,7073,7073,7,7078,7079,7,7082,7082,7,7142,7142,5,7144,7145,5,7149,7149,5,7151,7153,5,7204,7211,7,7220,7221,7,7376,7378,5,7393,7393,7,7405,7405,5,7415,7415,7,7616,7679,5,8204,8204,5,8206,8207,4,8233,8233,4,8252,8252,14,8288,8292,4,8294,8303,4,8413,8416,5,8418,8420,5,8482,8482,14,8596,8601,14,8986,8987,14,9096,9096,14,9193,9196,14,9199,9199,14,9201,9202,14,9208,9210,14,9642,9643,14,9664,9664,14,9728,9729,14,9732,9732,14,9735,9741,14,9743,9744,14,9746,9746,14,9750,9751,14,9753,9756,14,9758,9759,14,9761,9761,14,9764,9765,14,9767,9769,14,9771,9773,14,9775,9775,14,9784,9785,14,9787,9791,14,9793,9793,14,9795,9799,14,9812,9822,14,9824,9824,14,9827,9827,14,9829,9830,14,9832,9832,14,9851,9851,14,9854,9854,14,9856,9861,14,9874,9874,14,9876,9876,14,9878,9879,14,9881,9881,14,9883,9884,14,9888,9889,14,9895,9895,14,9898,9899,14,9904,9905,14,9917,9918,14,9924,9925,14,9928,9928,14,9934,9934,14,9936,9936,14,9938,9938,14,9940,9940,14,9961,9961,14,9963,9967,14,9970,9971,14,9973,9973,14,9975,9977,14,9979,9980,14,9982,9985,14,9987,9988,14,9992,9996,14,9998,9998,14,10000,10001,14,10004,10004,14,10013,10013,14,10024,10024,14,10052,10052,14,10060,10060,14,10067,10069,14,10083,10083,14,10085,10087,14,10145,10145,14,10175,10175,14,11013,11015,14,11088,11088,14,11503,11505,5,11744,11775,5,12334,12335,5,12349,12349,14,12951,12951,14,42607,42607,5,42612,42621,5,42736,42737,5,43014,43014,5,43043,43044,7,43047,43047,7,43136,43137,7,43204,43205,5,43263,43263,5,43335,43345,5,43360,43388,8,43395,43395,7,43444,43445,7,43450,43451,7,43454,43456,7,43561,43566,5,43569,43570,5,43573,43574,5,43596,43596,5,43644,43644,5,43698,43700,5,43710,43711,5,43755,43755,7,43758,43759,7,43766,43766,5,44005,44005,5,44008,44008,5,44012,44012,7,44032,44032,11,44060,44060,11,44088,44088,11,44116,44116,11,44144,44144,11,44172,44172,11,44200,44200,11,44228,44228,11,44256,44256,11,44284,44284,11,44312,44312,11,44340,44340,11,44368,44368,11,44396,44396,11,44424,44424,11,44452,44452,11,44480,44480,11,44508,44508,11,44536,44536,11,44564,44564,11,44592,44592,11,44620,44620,11,44648,44648,11,44676,44676,11,44704,44704,11,44732,44732,11,44760,44760,11,44788,44788,11,44816,44816,11,44844,44844,11,44872,44872,11,44900,44900,11,44928,44928,11,44956,44956,11,44984,44984,11,45012,45012,11,45040,45040,11,45068,45068,11,45096,45096,11,45124,45124,11,45152,45152,11,45180,45180,11,45208,45208,11,45236,45236,11,45264,45264,11,45292,45292,11,45320,45320,11,45348,45348,11,45376,45376,11,45404,45404,11,45432,45432,11,45460,45460,11,45488,45488,11,45516,45516,11,45544,45544,11,45572,45572,11,45600,45600,11,45628,45628,11,45656,45656,11,45684,45684,11,45712,45712,11,45740,45740,11,45768,45768,11,45796,45796,11,45824,45824,11,45852,45852,11,45880,45880,11,45908,45908,11,45936,45936,11,45964,45964,11,45992,45992,11,46020,46020,11,46048,46048,11,46076,46076,11,46104,46104,11,46132,46132,11,46160,46160,11,46188,46188,11,46216,46216,11,46244,46244,11,46272,46272,11,46300,46300,11,46328,46328,11,46356,46356,11,46384,46384,11,46412,46412,11,46440,46440,11,46468,46468,11,46496,46496,11,46524,46524,11,46552,46552,11,46580,46580,11,46608,46608,11,46636,46636,11,46664,46664,11,46692,46692,11,46720,46720,11,46748,46748,11,46776,46776,11,46804,46804,11,46832,46832,11,46860,46860,11,46888,46888,11,46916,46916,11,46944,46944,11,46972,46972,11,47000,47000,11,47028,47028,11,47056,47056,11,47084,47084,11,47112,47112,11,47140,47140,11,47168,47168,11,47196,47196,11,47224,47224,11,47252,47252,11,47280,47280,11,47308,47308,11,47336,47336,11,47364,47364,11,47392,47392,11,47420,47420,11,47448,47448,11,47476,47476,11,47504,47504,11,47532,47532,11,47560,47560,11,47588,47588,11,47616,47616,11,47644,47644,11,47672,47672,11,47700,47700,11,47728,47728,11,47756,47756,11,47784,47784,11,47812,47812,11,47840,47840,11,47868,47868,11,47896,47896,11,47924,47924,11,47952,47952,11,47980,47980,11,48008,48008,11,48036,48036,11,48064,48064,11,48092,48092,11,48120,48120,11,48148,48148,11,48176,48176,11,48204,48204,11,48232,48232,11,48260,48260,11,48288,48288,11,48316,48316,11,48344,48344,11,48372,48372,11,48400,48400,11,48428,48428,11,48456,48456,11,48484,48484,11,48512,48512,11,48540,48540,11,48568,48568,11,48596,48596,11,48624,48624,11,48652,48652,11,48680,48680,11,48708,48708,11,48736,48736,11,48764,48764,11,48792,48792,11,48820,48820,11,48848,48848,11,48876,48876,11,48904,48904,11,48932,48932,11,48960,48960,11,48988,48988,11,49016,49016,11,49044,49044,11,49072,49072,11,49100,49100,11,49128,49128,11,49156,49156,11,49184,49184,11,49212,49212,11,49240,49240,11,49268,49268,11,49296,49296,11,49324,49324,11,49352,49352,11,49380,49380,11,49408,49408,11,49436,49436,11,49464,49464,11,49492,49492,11,49520,49520,11,49548,49548,11,49576,49576,11,49604,49604,11,49632,49632,11,49660,49660,11,49688,49688,11,49716,49716,11,49744,49744,11,49772,49772,11,49800,49800,11,49828,49828,11,49856,49856,11,49884,49884,11,49912,49912,11,49940,49940,11,49968,49968,11,49996,49996,11,50024,50024,11,50052,50052,11,50080,50080,11,50108,50108,11,50136,50136,11,50164,50164,11,50192,50192,11,50220,50220,11,50248,50248,11,50276,50276,11,50304,50304,11,50332,50332,11,50360,50360,11,50388,50388,11,50416,50416,11,50444,50444,11,50472,50472,11,50500,50500,11,50528,50528,11,50556,50556,11,50584,50584,11,50612,50612,11,50640,50640,11,50668,50668,11,50696,50696,11,50724,50724,11,50752,50752,11,50780,50780,11,50808,50808,11,50836,50836,11,50864,50864,11,50892,50892,11,50920,50920,11,50948,50948,11,50976,50976,11,51004,51004,11,51032,51032,11,51060,51060,11,51088,51088,11,51116,51116,11,51144,51144,11,51172,51172,11,51200,51200,11,51228,51228,11,51256,51256,11,51284,51284,11,51312,51312,11,51340,51340,11,51368,51368,11,51396,51396,11,51424,51424,11,51452,51452,11,51480,51480,11,51508,51508,11,51536,51536,11,51564,51564,11,51592,51592,11,51620,51620,11,51648,51648,11,51676,51676,11,51704,51704,11,51732,51732,11,51760,51760,11,51788,51788,11,51816,51816,11,51844,51844,11,51872,51872,11,51900,51900,11,51928,51928,11,51956,51956,11,51984,51984,11,52012,52012,11,52040,52040,11,52068,52068,11,52096,52096,11,52124,52124,11,52152,52152,11,52180,52180,11,52208,52208,11,52236,52236,11,52264,52264,11,52292,52292,11,52320,52320,11,52348,52348,11,52376,52376,11,52404,52404,11,52432,52432,11,52460,52460,11,52488,52488,11,52516,52516,11,52544,52544,11,52572,52572,11,52600,52600,11,52628,52628,11,52656,52656,11,52684,52684,11,52712,52712,11,52740,52740,11,52768,52768,11,52796,52796,11,52824,52824,11,52852,52852,11,52880,52880,11,52908,52908,11,52936,52936,11,52964,52964,11,52992,52992,11,53020,53020,11,53048,53048,11,53076,53076,11,53104,53104,11,53132,53132,11,53160,53160,11,53188,53188,11,53216,53216,11,53244,53244,11,53272,53272,11,53300,53300,11,53328,53328,11,53356,53356,11,53384,53384,11,53412,53412,11,53440,53440,11,53468,53468,11,53496,53496,11,53524,53524,11,53552,53552,11,53580,53580,11,53608,53608,11,53636,53636,11,53664,53664,11,53692,53692,11,53720,53720,11,53748,53748,11,53776,53776,11,53804,53804,11,53832,53832,11,53860,53860,11,53888,53888,11,53916,53916,11,53944,53944,11,53972,53972,11,54000,54000,11,54028,54028,11,54056,54056,11,54084,54084,11,54112,54112,11,54140,54140,11,54168,54168,11,54196,54196,11,54224,54224,11,54252,54252,11,54280,54280,11,54308,54308,11,54336,54336,11,54364,54364,11,54392,54392,11,54420,54420,11,54448,54448,11,54476,54476,11,54504,54504,11,54532,54532,11,54560,54560,11,54588,54588,11,54616,54616,11,54644,54644,11,54672,54672,11,54700,54700,11,54728,54728,11,54756,54756,11,54784,54784,11,54812,54812,11,54840,54840,11,54868,54868,11,54896,54896,11,54924,54924,11,54952,54952,11,54980,54980,11,55008,55008,11,55036,55036,11,55064,55064,11,55092,55092,11,55120,55120,11,55148,55148,11,55176,55176,11,55216,55238,9,64286,64286,5,65056,65071,5,65438,65439,5,65529,65531,4,66272,66272,5,68097,68099,5,68108,68111,5,68159,68159,5,68900,68903,5,69446,69456,5,69632,69632,7,69634,69634,7,69744,69744,5,69759,69761,5,69808,69810,7,69815,69816,7,69821,69821,1,69837,69837,1,69927,69931,5,69933,69940,5,70003,70003,5,70018,70018,7,70070,70078,5,70082,70083,1,70094,70094,7,70188,70190,7,70194,70195,7,70197,70197,7,70206,70206,5,70368,70370,7,70400,70401,5,70459,70460,5,70463,70463,7,70465,70468,7,70475,70477,7,70498,70499,7,70512,70516,5,70712,70719,5,70722,70724,5,70726,70726,5,70832,70832,5,70835,70840,5,70842,70842,5,70845,70845,5,70847,70848,5,70850,70851,5,71088,71089,7,71096,71099,7,71102,71102,7,71132,71133,5,71219,71226,5,71229,71229,5,71231,71232,5,71340,71340,7,71342,71343,7,71350,71350,7,71453,71455,5,71462,71462,7,71724,71726,7,71736,71736,7,71984,71984,5,71991,71992,7,71997,71997,7,71999,71999,1,72001,72001,1,72003,72003,5,72148,72151,5,72156,72159,7,72164,72164,7,72243,72248,5,72250,72250,1,72263,72263,5,72279,72280,7,72324,72329,1,72343,72343,7,72751,72751,7,72760,72765,5,72767,72767,5,72873,72873,7,72881,72881,7,72884,72884,7,73009,73014,5,73020,73021,5,73030,73030,1,73098,73102,7,73107,73108,7,73110,73110,7,73459,73460,5,78896,78904,4,92976,92982,5,94033,94087,7,94180,94180,5,113821,113822,5,118528,118573,5,119141,119141,5,119143,119145,5,119150,119154,5,119163,119170,5,119210,119213,5,121344,121398,5,121461,121461,5,121499,121503,5,122880,122886,5,122907,122913,5,122918,122922,5,123566,123566,5,125136,125142,5,126976,126979,14,126981,127182,14,127184,127231,14,127279,127279,14,127344,127345,14,127374,127374,14,127405,127461,14,127489,127490,14,127514,127514,14,127538,127546,14,127561,127567,14,127570,127743,14,127757,127758,14,127760,127760,14,127762,127762,14,127766,127768,14,127770,127770,14,127772,127772,14,127775,127776,14,127778,127779,14,127789,127791,14,127794,127795,14,127798,127798,14,127819,127819,14,127824,127824,14,127868,127868,14,127870,127871,14,127892,127893,14,127896,127896,14,127900,127901,14,127904,127940,14,127942,127942,14,127944,127944,14,127946,127946,14,127951,127955,14,127968,127971,14,127973,127984,14,127987,127987,14,127989,127989,14,127991,127991,14,127995,127999,5,128008,128008,14,128012,128014,14,128017,128018,14,128020,128020,14,128022,128022,14,128042,128042,14,128063,128063,14,128065,128065,14,128101,128101,14,128108,128109,14,128173,128173,14,128182,128183,14,128236,128237,14,128239,128239,14,128245,128245,14,128248,128248,14,128253,128253,14,128255,128258,14,128260,128263,14,128265,128265,14,128277,128277,14,128300,128301,14,128326,128328,14,128331,128334,14,128336,128347,14,128360,128366,14,128369,128370,14,128378,128378,14,128391,128391,14,128394,128397,14,128400,128400,14,128405,128406,14,128420,128420,14,128422,128423,14,128425,128432,14,128435,128443,14,128445,128449,14,128453,128464,14,128468,128475,14,128479,128480,14,128482,128482,14,128484,128487,14,128489,128494,14,128496,128498,14,128500,128505,14,128507,128511,14,128513,128518,14,128521,128525,14,128527,128527,14,128529,128529,14,128533,128533,14,128535,128535,14,128537,128537,14]")}static getInstance(){return ie._INSTANCE||(ie._INSTANCE=new ie),ie._INSTANCE}getGraphemeBreakType(e){if(e<32)return 10===e?3:13===e?2:4;if(e<127)return 0;const t=this._data,i=t.length/3;let n=1;for(;n<=i;)if(e<t[3*n])n*=2;else{if(!(e>t[3*n+1]))return t[3*n+2];n=2*n+1}return 0}}function ne(e,t){if(0===e)return 0;const i=function(e,t){const i=new P(t,e);let n=i.prevCodePoint();for(;oe(n)||65039===n||8419===n;){if(0===i.offset)return;n=i.prevCodePoint()}if(!q(n))return;let o=i.offset;if(o>0){8205===i.prevCodePoint()&&(o=i.offset)}return o}(e,t);if(void 0!==i)return i;const n=new P(t,e);return n.prevCodePoint(),n.offset}function oe(e){return 127995<=e&&e<=127999}ie._INSTANCE=null;const re=" ";class se{constructor(e){this.confusableDictionary=e}static getInstance(e){return se.cache.get(Array.from(e))}static getLocales(){return se._locales.getValue()}isAmbiguous(e){return this.confusableDictionary.has(e)}getPrimaryConfusable(e){return this.confusableDictionary.get(e)}getConfusableCodePoints(){return new Set(this.confusableDictionary.keys())}}n=se,se.ambiguousCharacterData=new r.Lazy((()=>JSON.parse('{"_common":[8232,32,8233,32,5760,32,8192,32,8193,32,8194,32,8195,32,8196,32,8197,32,8198,32,8200,32,8201,32,8202,32,8287,32,8199,32,8239,32,2042,95,65101,95,65102,95,65103,95,8208,45,8209,45,8210,45,65112,45,1748,45,8259,45,727,45,8722,45,10134,45,11450,45,1549,44,1643,44,8218,44,184,44,42233,44,894,59,2307,58,2691,58,1417,58,1795,58,1796,58,5868,58,65072,58,6147,58,6153,58,8282,58,1475,58,760,58,42889,58,8758,58,720,58,42237,58,451,33,11601,33,660,63,577,63,2429,63,5038,63,42731,63,119149,46,8228,46,1793,46,1794,46,42510,46,68176,46,1632,46,1776,46,42232,46,1373,96,65287,96,8219,96,8242,96,1370,96,1523,96,8175,96,65344,96,900,96,8189,96,8125,96,8127,96,8190,96,697,96,884,96,712,96,714,96,715,96,756,96,699,96,701,96,700,96,702,96,42892,96,1497,96,2036,96,2037,96,5194,96,5836,96,94033,96,94034,96,65339,91,10088,40,10098,40,12308,40,64830,40,65341,93,10089,41,10099,41,12309,41,64831,41,10100,123,119060,123,10101,125,65342,94,8270,42,1645,42,8727,42,66335,42,5941,47,8257,47,8725,47,8260,47,9585,47,10187,47,10744,47,119354,47,12755,47,12339,47,11462,47,20031,47,12035,47,65340,92,65128,92,8726,92,10189,92,10741,92,10745,92,119311,92,119355,92,12756,92,20022,92,12034,92,42872,38,708,94,710,94,5869,43,10133,43,66203,43,8249,60,10094,60,706,60,119350,60,5176,60,5810,60,5120,61,11840,61,12448,61,42239,61,8250,62,10095,62,707,62,119351,62,5171,62,94015,62,8275,126,732,126,8128,126,8764,126,65372,124,65293,45,120784,50,120794,50,120804,50,120814,50,120824,50,130034,50,42842,50,423,50,1000,50,42564,50,5311,50,42735,50,119302,51,120785,51,120795,51,120805,51,120815,51,120825,51,130035,51,42923,51,540,51,439,51,42858,51,11468,51,1248,51,94011,51,71882,51,120786,52,120796,52,120806,52,120816,52,120826,52,130036,52,5070,52,71855,52,120787,53,120797,53,120807,53,120817,53,120827,53,130037,53,444,53,71867,53,120788,54,120798,54,120808,54,120818,54,120828,54,130038,54,11474,54,5102,54,71893,54,119314,55,120789,55,120799,55,120809,55,120819,55,120829,55,130039,55,66770,55,71878,55,2819,56,2538,56,2666,56,125131,56,120790,56,120800,56,120810,56,120820,56,120830,56,130040,56,547,56,546,56,66330,56,2663,57,2920,57,2541,57,3437,57,120791,57,120801,57,120811,57,120821,57,120831,57,130041,57,42862,57,11466,57,71884,57,71852,57,71894,57,9082,97,65345,97,119834,97,119886,97,119938,97,119990,97,120042,97,120094,97,120146,97,120198,97,120250,97,120302,97,120354,97,120406,97,120458,97,593,97,945,97,120514,97,120572,97,120630,97,120688,97,120746,97,65313,65,119808,65,119860,65,119912,65,119964,65,120016,65,120068,65,120120,65,120172,65,120224,65,120276,65,120328,65,120380,65,120432,65,913,65,120488,65,120546,65,120604,65,120662,65,120720,65,5034,65,5573,65,42222,65,94016,65,66208,65,119835,98,119887,98,119939,98,119991,98,120043,98,120095,98,120147,98,120199,98,120251,98,120303,98,120355,98,120407,98,120459,98,388,98,5071,98,5234,98,5551,98,65314,66,8492,66,119809,66,119861,66,119913,66,120017,66,120069,66,120121,66,120173,66,120225,66,120277,66,120329,66,120381,66,120433,66,42932,66,914,66,120489,66,120547,66,120605,66,120663,66,120721,66,5108,66,5623,66,42192,66,66178,66,66209,66,66305,66,65347,99,8573,99,119836,99,119888,99,119940,99,119992,99,120044,99,120096,99,120148,99,120200,99,120252,99,120304,99,120356,99,120408,99,120460,99,7428,99,1010,99,11429,99,43951,99,66621,99,128844,67,71922,67,71913,67,65315,67,8557,67,8450,67,8493,67,119810,67,119862,67,119914,67,119966,67,120018,67,120174,67,120226,67,120278,67,120330,67,120382,67,120434,67,1017,67,11428,67,5087,67,42202,67,66210,67,66306,67,66581,67,66844,67,8574,100,8518,100,119837,100,119889,100,119941,100,119993,100,120045,100,120097,100,120149,100,120201,100,120253,100,120305,100,120357,100,120409,100,120461,100,1281,100,5095,100,5231,100,42194,100,8558,68,8517,68,119811,68,119863,68,119915,68,119967,68,120019,68,120071,68,120123,68,120175,68,120227,68,120279,68,120331,68,120383,68,120435,68,5024,68,5598,68,5610,68,42195,68,8494,101,65349,101,8495,101,8519,101,119838,101,119890,101,119942,101,120046,101,120098,101,120150,101,120202,101,120254,101,120306,101,120358,101,120410,101,120462,101,43826,101,1213,101,8959,69,65317,69,8496,69,119812,69,119864,69,119916,69,120020,69,120072,69,120124,69,120176,69,120228,69,120280,69,120332,69,120384,69,120436,69,917,69,120492,69,120550,69,120608,69,120666,69,120724,69,11577,69,5036,69,42224,69,71846,69,71854,69,66182,69,119839,102,119891,102,119943,102,119995,102,120047,102,120099,102,120151,102,120203,102,120255,102,120307,102,120359,102,120411,102,120463,102,43829,102,42905,102,383,102,7837,102,1412,102,119315,70,8497,70,119813,70,119865,70,119917,70,120021,70,120073,70,120125,70,120177,70,120229,70,120281,70,120333,70,120385,70,120437,70,42904,70,988,70,120778,70,5556,70,42205,70,71874,70,71842,70,66183,70,66213,70,66853,70,65351,103,8458,103,119840,103,119892,103,119944,103,120048,103,120100,103,120152,103,120204,103,120256,103,120308,103,120360,103,120412,103,120464,103,609,103,7555,103,397,103,1409,103,119814,71,119866,71,119918,71,119970,71,120022,71,120074,71,120126,71,120178,71,120230,71,120282,71,120334,71,120386,71,120438,71,1292,71,5056,71,5107,71,42198,71,65352,104,8462,104,119841,104,119945,104,119997,104,120049,104,120101,104,120153,104,120205,104,120257,104,120309,104,120361,104,120413,104,120465,104,1211,104,1392,104,5058,104,65320,72,8459,72,8460,72,8461,72,119815,72,119867,72,119919,72,120023,72,120179,72,120231,72,120283,72,120335,72,120387,72,120439,72,919,72,120494,72,120552,72,120610,72,120668,72,120726,72,11406,72,5051,72,5500,72,42215,72,66255,72,731,105,9075,105,65353,105,8560,105,8505,105,8520,105,119842,105,119894,105,119946,105,119998,105,120050,105,120102,105,120154,105,120206,105,120258,105,120310,105,120362,105,120414,105,120466,105,120484,105,618,105,617,105,953,105,8126,105,890,105,120522,105,120580,105,120638,105,120696,105,120754,105,1110,105,42567,105,1231,105,43893,105,5029,105,71875,105,65354,106,8521,106,119843,106,119895,106,119947,106,119999,106,120051,106,120103,106,120155,106,120207,106,120259,106,120311,106,120363,106,120415,106,120467,106,1011,106,1112,106,65322,74,119817,74,119869,74,119921,74,119973,74,120025,74,120077,74,120129,74,120181,74,120233,74,120285,74,120337,74,120389,74,120441,74,42930,74,895,74,1032,74,5035,74,5261,74,42201,74,119844,107,119896,107,119948,107,120000,107,120052,107,120104,107,120156,107,120208,107,120260,107,120312,107,120364,107,120416,107,120468,107,8490,75,65323,75,119818,75,119870,75,119922,75,119974,75,120026,75,120078,75,120130,75,120182,75,120234,75,120286,75,120338,75,120390,75,120442,75,922,75,120497,75,120555,75,120613,75,120671,75,120729,75,11412,75,5094,75,5845,75,42199,75,66840,75,1472,108,8739,73,9213,73,65512,73,1633,108,1777,73,66336,108,125127,108,120783,73,120793,73,120803,73,120813,73,120823,73,130033,73,65321,73,8544,73,8464,73,8465,73,119816,73,119868,73,119920,73,120024,73,120128,73,120180,73,120232,73,120284,73,120336,73,120388,73,120440,73,65356,108,8572,73,8467,108,119845,108,119897,108,119949,108,120001,108,120053,108,120105,73,120157,73,120209,73,120261,73,120313,73,120365,73,120417,73,120469,73,448,73,120496,73,120554,73,120612,73,120670,73,120728,73,11410,73,1030,73,1216,73,1493,108,1503,108,1575,108,126464,108,126592,108,65166,108,65165,108,1994,108,11599,73,5825,73,42226,73,93992,73,66186,124,66313,124,119338,76,8556,76,8466,76,119819,76,119871,76,119923,76,120027,76,120079,76,120131,76,120183,76,120235,76,120287,76,120339,76,120391,76,120443,76,11472,76,5086,76,5290,76,42209,76,93974,76,71843,76,71858,76,66587,76,66854,76,65325,77,8559,77,8499,77,119820,77,119872,77,119924,77,120028,77,120080,77,120132,77,120184,77,120236,77,120288,77,120340,77,120392,77,120444,77,924,77,120499,77,120557,77,120615,77,120673,77,120731,77,1018,77,11416,77,5047,77,5616,77,5846,77,42207,77,66224,77,66321,77,119847,110,119899,110,119951,110,120003,110,120055,110,120107,110,120159,110,120211,110,120263,110,120315,110,120367,110,120419,110,120471,110,1400,110,1404,110,65326,78,8469,78,119821,78,119873,78,119925,78,119977,78,120029,78,120081,78,120185,78,120237,78,120289,78,120341,78,120393,78,120445,78,925,78,120500,78,120558,78,120616,78,120674,78,120732,78,11418,78,42208,78,66835,78,3074,111,3202,111,3330,111,3458,111,2406,111,2662,111,2790,111,3046,111,3174,111,3302,111,3430,111,3664,111,3792,111,4160,111,1637,111,1781,111,65359,111,8500,111,119848,111,119900,111,119952,111,120056,111,120108,111,120160,111,120212,111,120264,111,120316,111,120368,111,120420,111,120472,111,7439,111,7441,111,43837,111,959,111,120528,111,120586,111,120644,111,120702,111,120760,111,963,111,120532,111,120590,111,120648,111,120706,111,120764,111,11423,111,4351,111,1413,111,1505,111,1607,111,126500,111,126564,111,126596,111,65259,111,65260,111,65258,111,65257,111,1726,111,64428,111,64429,111,64427,111,64426,111,1729,111,64424,111,64425,111,64423,111,64422,111,1749,111,3360,111,4125,111,66794,111,71880,111,71895,111,66604,111,1984,79,2534,79,2918,79,12295,79,70864,79,71904,79,120782,79,120792,79,120802,79,120812,79,120822,79,130032,79,65327,79,119822,79,119874,79,119926,79,119978,79,120030,79,120082,79,120134,79,120186,79,120238,79,120290,79,120342,79,120394,79,120446,79,927,79,120502,79,120560,79,120618,79,120676,79,120734,79,11422,79,1365,79,11604,79,4816,79,2848,79,66754,79,42227,79,71861,79,66194,79,66219,79,66564,79,66838,79,9076,112,65360,112,119849,112,119901,112,119953,112,120005,112,120057,112,120109,112,120161,112,120213,112,120265,112,120317,112,120369,112,120421,112,120473,112,961,112,120530,112,120544,112,120588,112,120602,112,120646,112,120660,112,120704,112,120718,112,120762,112,120776,112,11427,112,65328,80,8473,80,119823,80,119875,80,119927,80,119979,80,120031,80,120083,80,120187,80,120239,80,120291,80,120343,80,120395,80,120447,80,929,80,120504,80,120562,80,120620,80,120678,80,120736,80,11426,80,5090,80,5229,80,42193,80,66197,80,119850,113,119902,113,119954,113,120006,113,120058,113,120110,113,120162,113,120214,113,120266,113,120318,113,120370,113,120422,113,120474,113,1307,113,1379,113,1382,113,8474,81,119824,81,119876,81,119928,81,119980,81,120032,81,120084,81,120188,81,120240,81,120292,81,120344,81,120396,81,120448,81,11605,81,119851,114,119903,114,119955,114,120007,114,120059,114,120111,114,120163,114,120215,114,120267,114,120319,114,120371,114,120423,114,120475,114,43847,114,43848,114,7462,114,11397,114,43905,114,119318,82,8475,82,8476,82,8477,82,119825,82,119877,82,119929,82,120033,82,120189,82,120241,82,120293,82,120345,82,120397,82,120449,82,422,82,5025,82,5074,82,66740,82,5511,82,42211,82,94005,82,65363,115,119852,115,119904,115,119956,115,120008,115,120060,115,120112,115,120164,115,120216,115,120268,115,120320,115,120372,115,120424,115,120476,115,42801,115,445,115,1109,115,43946,115,71873,115,66632,115,65331,83,119826,83,119878,83,119930,83,119982,83,120034,83,120086,83,120138,83,120190,83,120242,83,120294,83,120346,83,120398,83,120450,83,1029,83,1359,83,5077,83,5082,83,42210,83,94010,83,66198,83,66592,83,119853,116,119905,116,119957,116,120009,116,120061,116,120113,116,120165,116,120217,116,120269,116,120321,116,120373,116,120425,116,120477,116,8868,84,10201,84,128872,84,65332,84,119827,84,119879,84,119931,84,119983,84,120035,84,120087,84,120139,84,120191,84,120243,84,120295,84,120347,84,120399,84,120451,84,932,84,120507,84,120565,84,120623,84,120681,84,120739,84,11430,84,5026,84,42196,84,93962,84,71868,84,66199,84,66225,84,66325,84,119854,117,119906,117,119958,117,120010,117,120062,117,120114,117,120166,117,120218,117,120270,117,120322,117,120374,117,120426,117,120478,117,42911,117,7452,117,43854,117,43858,117,651,117,965,117,120534,117,120592,117,120650,117,120708,117,120766,117,1405,117,66806,117,71896,117,8746,85,8899,85,119828,85,119880,85,119932,85,119984,85,120036,85,120088,85,120140,85,120192,85,120244,85,120296,85,120348,85,120400,85,120452,85,1357,85,4608,85,66766,85,5196,85,42228,85,94018,85,71864,85,8744,118,8897,118,65366,118,8564,118,119855,118,119907,118,119959,118,120011,118,120063,118,120115,118,120167,118,120219,118,120271,118,120323,118,120375,118,120427,118,120479,118,7456,118,957,118,120526,118,120584,118,120642,118,120700,118,120758,118,1141,118,1496,118,71430,118,43945,118,71872,118,119309,86,1639,86,1783,86,8548,86,119829,86,119881,86,119933,86,119985,86,120037,86,120089,86,120141,86,120193,86,120245,86,120297,86,120349,86,120401,86,120453,86,1140,86,11576,86,5081,86,5167,86,42719,86,42214,86,93960,86,71840,86,66845,86,623,119,119856,119,119908,119,119960,119,120012,119,120064,119,120116,119,120168,119,120220,119,120272,119,120324,119,120376,119,120428,119,120480,119,7457,119,1121,119,1309,119,1377,119,71434,119,71438,119,71439,119,43907,119,71919,87,71910,87,119830,87,119882,87,119934,87,119986,87,120038,87,120090,87,120142,87,120194,87,120246,87,120298,87,120350,87,120402,87,120454,87,1308,87,5043,87,5076,87,42218,87,5742,120,10539,120,10540,120,10799,120,65368,120,8569,120,119857,120,119909,120,119961,120,120013,120,120065,120,120117,120,120169,120,120221,120,120273,120,120325,120,120377,120,120429,120,120481,120,5441,120,5501,120,5741,88,9587,88,66338,88,71916,88,65336,88,8553,88,119831,88,119883,88,119935,88,119987,88,120039,88,120091,88,120143,88,120195,88,120247,88,120299,88,120351,88,120403,88,120455,88,42931,88,935,88,120510,88,120568,88,120626,88,120684,88,120742,88,11436,88,11613,88,5815,88,42219,88,66192,88,66228,88,66327,88,66855,88,611,121,7564,121,65369,121,119858,121,119910,121,119962,121,120014,121,120066,121,120118,121,120170,121,120222,121,120274,121,120326,121,120378,121,120430,121,120482,121,655,121,7935,121,43866,121,947,121,8509,121,120516,121,120574,121,120632,121,120690,121,120748,121,1199,121,4327,121,71900,121,65337,89,119832,89,119884,89,119936,89,119988,89,120040,89,120092,89,120144,89,120196,89,120248,89,120300,89,120352,89,120404,89,120456,89,933,89,978,89,120508,89,120566,89,120624,89,120682,89,120740,89,11432,89,1198,89,5033,89,5053,89,42220,89,94019,89,71844,89,66226,89,119859,122,119911,122,119963,122,120015,122,120067,122,120119,122,120171,122,120223,122,120275,122,120327,122,120379,122,120431,122,120483,122,7458,122,43923,122,71876,122,66293,90,71909,90,65338,90,8484,90,8488,90,119833,90,119885,90,119937,90,119989,90,120041,90,120197,90,120249,90,120301,90,120353,90,120405,90,120457,90,918,90,120493,90,120551,90,120609,90,120667,90,120725,90,5059,90,42204,90,71849,90,65282,34,65284,36,65285,37,65286,38,65290,42,65291,43,65294,46,65295,47,65296,48,65297,49,65298,50,65299,51,65300,52,65301,53,65302,54,65303,55,65304,56,65305,57,65308,60,65309,61,65310,62,65312,64,65316,68,65318,70,65319,71,65324,76,65329,81,65330,82,65333,85,65334,86,65335,87,65343,95,65346,98,65348,100,65350,102,65355,107,65357,109,65358,110,65361,113,65362,114,65364,116,65365,117,65367,119,65370,122,65371,123,65373,125],"_default":[160,32,8211,45,65374,126,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"cs":[65374,126,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"de":[65374,126,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"es":[8211,45,65374,126,65306,58,65281,33,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"fr":[65374,126,65306,58,65281,33,8216,96,8245,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"it":[160,32,8211,45,65374,126,65306,58,65281,33,8216,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"ja":[8211,45,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65292,44,65307,59],"ko":[8211,45,65374,126,65306,58,65281,33,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"pl":[65374,126,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"pt-BR":[65374,126,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"qps-ploc":[160,32,8211,45,65374,126,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"ru":[65374,126,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,12494,47,305,105,921,73,1009,112,215,120,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"tr":[160,32,8211,45,65374,126,65306,58,65281,33,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"zh-hans":[65374,126,65306,58,65281,33,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41],"zh-hant":[8211,45,65374,126,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65307,59]}'))),se.cache=new o.LRUCachedFunction((e=>{function t(e){const t=new Map;for(let i=0;i<e.length;i+=2)t.set(e[i],e[i+1]);return t}function i(e,t){if(!e)return t;const i=new Map;for(const[n,o]of e)t.has(n)&&i.set(n,o);return i}const o=n.ambiguousCharacterData.getValue();let r,s=e.filter((e=>!e.startsWith("_")&&e in o));0===s.length&&(s=["_default"]);for(const e of s){r=i(r,t(o[e]))}const a=function(e,t){const i=new Map(e);for(const[e,n]of t)i.set(e,n);return i}(t(o._common),r);return new se(a)})),se._locales=new r.Lazy((()=>Object.keys(se.ambiguousCharacterData.getValue()).filter((e=>!e.startsWith("_")))));class ae{static getRawData(){return JSON.parse("[9,10,11,12,13,32,127,160,173,847,1564,4447,4448,6068,6069,6155,6156,6157,6158,7355,7356,8192,8193,8194,8195,8196,8197,8198,8199,8200,8201,8202,8203,8204,8205,8206,8207,8234,8235,8236,8237,8238,8239,8287,8288,8289,8290,8291,8292,8293,8294,8295,8296,8297,8298,8299,8300,8301,8302,8303,10240,12288,12644,65024,65025,65026,65027,65028,65029,65030,65031,65032,65033,65034,65035,65036,65037,65038,65039,65279,65440,65520,65521,65522,65523,65524,65525,65526,65527,65528,65532,78844,119155,119156,119157,119158,119159,119160,119161,119162,917504,917505,917506,917507,917508,917509,917510,917511,917512,917513,917514,917515,917516,917517,917518,917519,917520,917521,917522,917523,917524,917525,917526,917527,917528,917529,917530,917531,917532,917533,917534,917535,917536,917537,917538,917539,917540,917541,917542,917543,917544,917545,917546,917547,917548,917549,917550,917551,917552,917553,917554,917555,917556,917557,917558,917559,917560,917561,917562,917563,917564,917565,917566,917567,917568,917569,917570,917571,917572,917573,917574,917575,917576,917577,917578,917579,917580,917581,917582,917583,917584,917585,917586,917587,917588,917589,917590,917591,917592,917593,917594,917595,917596,917597,917598,917599,917600,917601,917602,917603,917604,917605,917606,917607,917608,917609,917610,917611,917612,917613,917614,917615,917616,917617,917618,917619,917620,917621,917622,917623,917624,917625,917626,917627,917628,917629,917630,917631,917760,917761,917762,917763,917764,917765,917766,917767,917768,917769,917770,917771,917772,917773,917774,917775,917776,917777,917778,917779,917780,917781,917782,917783,917784,917785,917786,917787,917788,917789,917790,917791,917792,917793,917794,917795,917796,917797,917798,917799,917800,917801,917802,917803,917804,917805,917806,917807,917808,917809,917810,917811,917812,917813,917814,917815,917816,917817,917818,917819,917820,917821,917822,917823,917824,917825,917826,917827,917828,917829,917830,917831,917832,917833,917834,917835,917836,917837,917838,917839,917840,917841,917842,917843,917844,917845,917846,917847,917848,917849,917850,917851,917852,917853,917854,917855,917856,917857,917858,917859,917860,917861,917862,917863,917864,917865,917866,917867,917868,917869,917870,917871,917872,917873,917874,917875,917876,917877,917878,917879,917880,917881,917882,917883,917884,917885,917886,917887,917888,917889,917890,917891,917892,917893,917894,917895,917896,917897,917898,917899,917900,917901,917902,917903,917904,917905,917906,917907,917908,917909,917910,917911,917912,917913,917914,917915,917916,917917,917918,917919,917920,917921,917922,917923,917924,917925,917926,917927,917928,917929,917930,917931,917932,917933,917934,917935,917936,917937,917938,917939,917940,917941,917942,917943,917944,917945,917946,917947,917948,917949,917950,917951,917952,917953,917954,917955,917956,917957,917958,917959,917960,917961,917962,917963,917964,917965,917966,917967,917968,917969,917970,917971,917972,917973,917974,917975,917976,917977,917978,917979,917980,917981,917982,917983,917984,917985,917986,917987,917988,917989,917990,917991,917992,917993,917994,917995,917996,917997,917998,917999]")}static getData(){return this._data||(this._data=new Set(ae.getRawData())),this._data}static isInvisibleCharacter(e){return ae.getData().has(e)}static get codePoints(){return ae.getData()}}ae._data=void 0},18912:function(e,t,i){"use strict";function n(e){return Array.isArray(e)}function o(e){return"string"==typeof e}function r(e){return!("object"!=typeof e||null===e||Array.isArray(e)||e instanceof RegExp||e instanceof Date)}function s(e){const t=Object.getPrototypeOf(Uint8Array);return"object"==typeof e&&e instanceof t}function a(e){return"number"==typeof e&&!isNaN(e)}function l(e){return!!e&&"function"==typeof e[Symbol.iterator]}function c(e){return!0===e||!1===e}function d(e){return void 0===e}function u(e){return!h(e)}function h(e){return d(e)||null===e}function g(e,t){if(!e)throw new Error(t?`Unexpected type, expected '${t}'`:"Unexpected type")}function p(e){if(h(e))throw new Error("Assertion Failed: argument is undefined or null");return e}function m(e){return"function"==typeof e}function f(e,t){const i=Math.min(e.length,t.length);for(let n=0;n<i;n++)b(e[n],t[n])}function b(e,t){if(o(t)){if(typeof e!==t)throw new Error(`argument does not match constraint: typeof ${t}`)}else if(m(t)){try{if(e instanceof t)return}catch(e){}if(!h(e)&&e.constructor===t)return;if(1===t.length&&!0===t.call(void 0,e))return;throw new Error("argument does not match one of these constraints: arg instanceof constraint, arg.constructor === constraint, nor constraint(arg) === true")}}function _(e){let t=[],i=Object.getPrototypeOf(e);for(;Object.prototype!==i;)t=t.concat(Object.getOwnPropertyNames(i)),i=Object.getPrototypeOf(i);return t}function A(e){const t=[];for(const i of _(e))"function"==typeof e[i]&&t.push(i);return t}function v(e,t){const i=e=>function(){const i=Array.prototype.slice.call(arguments,0);return t(e,i)},n={};for(const t of e)n[t]=i(t);return n}function C(e){return null===e?void 0:e}function w(e,t="Unreachable"){throw new Error(t)}i.r(t),i.d(t,{assertIsDefined:function(){return p},assertNever:function(){return w},assertType:function(){return g},createProxyObject:function(){return v},getAllMethodNames:function(){return A},getAllPropertyNames:function(){return _},isArray:function(){return n},isBoolean:function(){return c},isDefined:function(){return u},isFunction:function(){return m},isIterable:function(){return l},isNumber:function(){return a},isObject:function(){return r},isString:function(){return o},isTypedArray:function(){return s},isUndefined:function(){return d},isUndefinedOrNull:function(){return h},validateConstraint:function(){return b},validateConstraints:function(){return f},withNullAsUndefined:function(){return C}})},90662:function(e,t,i){"use strict";function n(e){return e<0?0:e>255?255:0|e}function o(e){return e<0?0:e>4294967295?4294967295:0|e}i.r(t),i.d(t,{toUint32:function(){return o},toUint8:function(){return n}})},19300:function(e,t,i){"use strict";i.r(t),i.d(t,{URI:function(){return h},uriToFsPath:function(){return _}});var n=i(23674),o=i(66719);const r=/^\w[\w\d+.-]*$/,s=/^\//,a=/^\/\//;function l(e,t){if(!e.scheme&&t)throw new Error(`[UriError]: Scheme is missing: {scheme: "", authority: "${e.authority}", path: "${e.path}", query: "${e.query}", fragment: "${e.fragment}"}`);if(e.scheme&&!r.test(e.scheme))throw new Error("[UriError]: Scheme contains illegal characters.");if(e.path)if(e.authority){if(!s.test(e.path))throw new Error('[UriError]: If a URI contains an authority component, then the path component must either be empty or begin with a slash ("/") character')}else if(a.test(e.path))throw new Error('[UriError]: If a URI does not contain an authority component, then the path cannot begin with two slash characters ("//")')}const c="",d="/",u=/^(([^:/?#]+?):)?(\/\/([^/?#]*))?([^?#]*)(\?([^#]*))?(#(.*))?/;class h{constructor(e,t,i,n,o,r=!1){"object"==typeof e?(this.scheme=e.scheme||c,this.authority=e.authority||c,this.path=e.path||c,this.query=e.query||c,this.fragment=e.fragment||c):(this.scheme=function(e,t){return e||t?e:"file"}(e,r),this.authority=t||c,this.path=function(e,t){switch(e){case"https":case"http":case"file":t?t[0]!==d&&(t=d+t):t=d}return t}(this.scheme,i||c),this.query=n||c,this.fragment=o||c,l(this,r))}static isUri(e){return e instanceof h||!!e&&("string"==typeof e.authority&&"string"==typeof e.fragment&&"string"==typeof e.path&&"string"==typeof e.query&&"string"==typeof e.scheme&&"string"==typeof e.fsPath&&"function"==typeof e.with&&"function"==typeof e.toString)}get fsPath(){return _(this,!1)}with(e){if(!e)return this;let{scheme:t,authority:i,path:n,query:o,fragment:r}=e;return void 0===t?t=this.scheme:null===t&&(t=c),void 0===i?i=this.authority:null===i&&(i=c),void 0===n?n=this.path:null===n&&(n=c),void 0===o?o=this.query:null===o&&(o=c),void 0===r?r=this.fragment:null===r&&(r=c),t===this.scheme&&i===this.authority&&n===this.path&&o===this.query&&r===this.fragment?this:new p(t,i,n,o,r)}static parse(e,t=!1){const i=u.exec(e);return i?new p(i[2]||c,w(i[4]||c),w(i[5]||c),w(i[7]||c),w(i[9]||c),t):new p(c,c,c,c,c)}static file(e){let t=c;if(o.isWindows&&(e=e.replace(/\\/g,d)),e[0]===d&&e[1]===d){const i=e.indexOf(d,2);-1===i?(t=e.substring(2),e=d):(t=e.substring(2,i),e=e.substring(i)||d)}return new p("file",t,e,c,c)}static from(e){const t=new p(e.scheme,e.authority,e.path,e.query,e.fragment);return l(t,!0),t}static joinPath(e,...t){if(!e.path)throw new Error("[UriError]: cannot call joinPath on URI without path");let i;return i=o.isWindows&&"file"===e.scheme?h.file(n.win32.join(_(e,!0),...t)).path:n.posix.join(e.path,...t),e.with({path:i})}toString(e=!1){return A(this,e)}toJSON(){return this}static revive(e){if(e){if(e instanceof h)return e;{const t=new p(e);return t._formatted=e.external,t._fsPath=e._sep===g?e.fsPath:null,t}}return e}}const g=o.isWindows?1:void 0;class p extends h{constructor(){super(...arguments),this._formatted=null,this._fsPath=null}get fsPath(){return this._fsPath||(this._fsPath=_(this,!1)),this._fsPath}toString(e=!1){return e?A(this,!0):(this._formatted||(this._formatted=A(this,!1)),this._formatted)}toJSON(){const e={$mid:1};return this._fsPath&&(e.fsPath=this._fsPath,e._sep=g),this._formatted&&(e.external=this._formatted),this.path&&(e.path=this.path),this.scheme&&(e.scheme=this.scheme),this.authority&&(e.authority=this.authority),this.query&&(e.query=this.query),this.fragment&&(e.fragment=this.fragment),e}}const m={58:"%3A",47:"%2F",63:"%3F",35:"%23",91:"%5B",93:"%5D",64:"%40",33:"%21",36:"%24",38:"%26",39:"%27",40:"%28",41:"%29",42:"%2A",43:"%2B",44:"%2C",59:"%3B",61:"%3D",32:"%20"};function f(e,t){let i,n=-1;for(let o=0;o<e.length;o++){const r=e.charCodeAt(o);if(r>=97&&r<=122||r>=65&&r<=90||r>=48&&r<=57||45===r||46===r||95===r||126===r||t&&47===r)-1!==n&&(i+=encodeURIComponent(e.substring(n,o)),n=-1),void 0!==i&&(i+=e.charAt(o));else{void 0===i&&(i=e.substr(0,o));const t=m[r];void 0!==t?(-1!==n&&(i+=encodeURIComponent(e.substring(n,o)),n=-1),i+=t):-1===n&&(n=o)}}return-1!==n&&(i+=encodeURIComponent(e.substring(n))),void 0!==i?i:e}function b(e){let t;for(let i=0;i<e.length;i++){const n=e.charCodeAt(i);35===n||63===n?(void 0===t&&(t=e.substr(0,i)),t+=m[n]):void 0!==t&&(t+=e[i])}return void 0!==t?t:e}function _(e,t){let i;return i=e.authority&&e.path.length>1&&"file"===e.scheme?`//${e.authority}${e.path}`:47===e.path.charCodeAt(0)&&(e.path.charCodeAt(1)>=65&&e.path.charCodeAt(1)<=90||e.path.charCodeAt(1)>=97&&e.path.charCodeAt(1)<=122)&&58===e.path.charCodeAt(2)?t?e.path.substr(1):e.path[1].toLowerCase()+e.path.substr(2):e.path,o.isWindows&&(i=i.replace(/\//g,"\\")),i}function A(e,t){const i=t?b:f;let n="",{scheme:o,authority:r,path:s,query:a,fragment:l}=e;if(o&&(n+=o,n+=":"),(r||"file"===o)&&(n+=d,n+=d),r){let e=r.indexOf("@");if(-1!==e){const t=r.substr(0,e);r=r.substr(e+1),e=t.indexOf(":"),-1===e?n+=i(t,!1):(n+=i(t.substr(0,e),!1),n+=":",n+=i(t.substr(e+1),!1)),n+="@"}r=r.toLowerCase(),e=r.indexOf(":"),-1===e?n+=i(r,!1):(n+=i(r.substr(0,e),!1),n+=r.substr(e))}if(s){if(s.length>=3&&47===s.charCodeAt(0)&&58===s.charCodeAt(2)){const e=s.charCodeAt(1);e>=65&&e<=90&&(s=`/${String.fromCharCode(e+32)}:${s.substr(3)}`)}else if(s.length>=2&&58===s.charCodeAt(1)){const e=s.charCodeAt(0);e>=65&&e<=90&&(s=`${String.fromCharCode(e+32)}:${s.substr(2)}`)}n+=i(s,!0)}return a&&(n+="?",n+=i(a,!1)),l&&(n+="#",n+=t?l:f(l,!1)),n}function v(e){try{return decodeURIComponent(e)}catch(t){return e.length>3?e.substr(0,3)+v(e.substr(3)):e}}const C=/(%[0-9A-Za-z][0-9A-Za-z])+/g;function w(e){return e.match(C)?e.replace(C,(e=>v(e))):e}},50302:function(e,t,i){"use strict";i.r(t),i.d(t,{SimpleWorkerClient:function(){return _},SimpleWorkerServer:function(){return w},create:function(){return y},logOnceWebWorkerWarning:function(){return u}});var n=i(12718),o=i(63801),r=i(68921),s=i(66719),a=i(18912),l=i(91482);const c="$initialize";let d=!1;function u(e){s.isWeb&&(d||(d=!0,console.warn("Could not create web worker(s). Falling back to loading web worker code in main thread, which might cause UI freezes. Please see https://github.com/microsoft/monaco-editor#faq")),console.warn(e.message))}class h{constructor(e,t,i,n){this.vsWorker=e,this.req=t,this.method=i,this.args=n,this.type=0}}class g{constructor(e,t,i,n){this.vsWorker=e,this.seq=t,this.res=i,this.err=n,this.type=1}}class p{constructor(e,t,i,n){this.vsWorker=e,this.req=t,this.eventName=i,this.arg=n,this.type=2}}class m{constructor(e,t,i){this.vsWorker=e,this.req=t,this.event=i,this.type=3}}class f{constructor(e,t){this.vsWorker=e,this.req=t,this.type=4}}class b{constructor(e){this._workerId=-1,this._handler=e,this._lastSentReq=0,this._pendingReplies=Object.create(null),this._pendingEmitters=new Map,this._pendingEvents=new Map}setWorkerId(e){this._workerId=e}sendMessage(e,t){const i=String(++this._lastSentReq);return new Promise(((n,o)=>{this._pendingReplies[i]={resolve:n,reject:o},this._send(new h(this._workerId,i,e,t))}))}listen(e,t){let i=null;const n=new o.Emitter({onFirstListenerAdd:()=>{i=String(++this._lastSentReq),this._pendingEmitters.set(i,n),this._send(new p(this._workerId,i,e,t))},onLastListenerRemove:()=>{this._pendingEmitters.delete(i),this._send(new f(this._workerId,i)),i=null}});return n.event}handleMessage(e){e&&e.vsWorker&&(-1!==this._workerId&&e.vsWorker!==this._workerId||this._handleMessage(e))}_handleMessage(e){switch(e.type){case 1:return this._handleReplyMessage(e);case 0:return this._handleRequestMessage(e);case 2:return this._handleSubscribeEventMessage(e);case 3:return this._handleEventMessage(e);case 4:return this._handleUnsubscribeEventMessage(e)}}_handleReplyMessage(e){if(!this._pendingReplies[e.seq])return void console.warn("Got reply to unknown seq");const t=this._pendingReplies[e.seq];if(delete this._pendingReplies[e.seq],e.err){let i=e.err;return e.err.$isError&&(i=new Error,i.name=e.err.name,i.message=e.err.message,i.stack=e.err.stack),void t.reject(i)}t.resolve(e.res)}_handleRequestMessage(e){const t=e.req;this._handler.handleMessage(e.method,e.args).then((e=>{this._send(new g(this._workerId,t,e,void 0))}),(e=>{e.detail instanceof Error&&(e.detail=(0,n.transformErrorForSerialization)(e.detail)),this._send(new g(this._workerId,t,void 0,(0,n.transformErrorForSerialization)(e)))}))}_handleSubscribeEventMessage(e){const t=e.req,i=this._handler.handleEvent(e.eventName,e.arg)((e=>{this._send(new m(this._workerId,t,e))}));this._pendingEvents.set(t,i)}_handleEventMessage(e){this._pendingEmitters.has(e.req)?this._pendingEmitters.get(e.req).fire(e.event):console.warn("Got event for unknown req")}_handleUnsubscribeEventMessage(e){this._pendingEvents.has(e.req)?(this._pendingEvents.get(e.req).dispose(),this._pendingEvents.delete(e.req)):console.warn("Got unsubscribe for unknown req")}_send(e){const t=[];if(0===e.type)for(let i=0;i<e.args.length;i++)e.args[i]instanceof ArrayBuffer&&t.push(e.args[i]);else 1===e.type&&e.res instanceof ArrayBuffer&&t.push(e.res);this._handler.sendMessage(e,t)}}class _ extends r.Disposable{constructor(e,t,i){super();let n=null;this._worker=this._register(e.create("vs/base/common/worker/simpleWorker",(e=>{this._protocol.handleMessage(e)}),(e=>{null==n||n(e)}))),this._protocol=new b({sendMessage:(e,t)=>{this._worker.postMessage(e,t)},handleMessage:(e,t)=>{if("function"!=typeof i[e])return Promise.reject(new Error("Missing method "+e+" on main thread host."));try{return Promise.resolve(i[e].apply(i,t))}catch(e){return Promise.reject(e)}},handleEvent:(e,t)=>{if(v(e)){const n=i[e].call(i,t);if("function"!=typeof n)throw new Error(`Missing dynamic event ${e} on main thread host.`);return n}if(A(e)){const t=i[e];if("function"!=typeof t)throw new Error(`Missing event ${e} on main thread host.`);return t}throw new Error(`Malformed event name ${e}`)}}),this._protocol.setWorkerId(this._worker.getId());let o=null;void 0!==s.globals.require&&"function"==typeof s.globals.require.getConfig?o=s.globals.require.getConfig():void 0!==s.globals.requirejs&&(o=s.globals.requirejs.s.contexts._.config);const r=a.getAllMethodNames(i);this._onModuleLoaded=this._protocol.sendMessage(c,[this._worker.getId(),JSON.parse(JSON.stringify(o)),t,r]);const l=(e,t)=>this._request(e,t),d=(e,t)=>this._protocol.listen(e,t);this._lazyProxy=new Promise(((e,i)=>{n=i,this._onModuleLoaded.then((t=>{e(C(t,l,d))}),(e=>{i(e),this._onError("Worker failed to load "+t,e)}))}))}getProxyObject(){return this._lazyProxy}_request(e,t){return new Promise(((i,n)=>{this._onModuleLoaded.then((()=>{this._protocol.sendMessage(e,t).then(i,n)}),n)}))}_onError(e,t){console.error(e),console.info(t)}}function A(e){return"o"===e[0]&&"n"===e[1]&&l.isUpperAsciiLetter(e.charCodeAt(2))}function v(e){return/^onDynamic/.test(e)&&l.isUpperAsciiLetter(e.charCodeAt(9))}function C(e,t,i){const n=e=>function(){const i=Array.prototype.slice.call(arguments,0);return t(e,i)},o=e=>function(t){return i(e,t)},r={};for(const t of e)v(t)?r[t]=o(t):A(t)?r[t]=i(t,void 0):r[t]=n(t);return r}class w{constructor(e,t){this._requestHandlerFactory=t,this._requestHandler=null,this._protocol=new b({sendMessage:(t,i)=>{e(t,i)},handleMessage:(e,t)=>this._handleMessage(e,t),handleEvent:(e,t)=>this._handleEvent(e,t)})}onmessage(e){this._protocol.handleMessage(e)}_handleMessage(e,t){if(e===c)return this.initialize(t[0],t[1],t[2],t[3]);if(!this._requestHandler||"function"!=typeof this._requestHandler[e])return Promise.reject(new Error("Missing requestHandler or method: "+e));try{return Promise.resolve(this._requestHandler[e].apply(this._requestHandler,t))}catch(e){return Promise.reject(e)}}_handleEvent(e,t){if(!this._requestHandler)throw new Error("Missing requestHandler");if(v(e)){const i=this._requestHandler[e].call(this._requestHandler,t);if("function"!=typeof i)throw new Error(`Missing dynamic event ${e} on request handler.`);return i}if(A(e)){const t=this._requestHandler[e];if("function"!=typeof t)throw new Error(`Missing event ${e} on request handler.`);return t}throw new Error(`Malformed event name ${e}`)}initialize(e,t,i,n){this._protocol.setWorkerId(e);const o=C(n,((e,t)=>this._protocol.sendMessage(e,t)),((e,t)=>this._protocol.listen(e,t)));return this._requestHandlerFactory?(this._requestHandler=this._requestHandlerFactory(o),Promise.resolve(a.getAllMethodNames(this._requestHandler))):(t&&(void 0!==t.baseUrl&&delete t.baseUrl,void 0!==t.paths&&void 0!==t.paths.vs&&delete t.paths.vs,void 0!==typeof t.trustedTypesPolicy&&delete t.trustedTypesPolicy,t.catchError=!0,s.globals.require.config(t)),new Promise(((e,t)=>{(0,s.globals.require)([i],(i=>{this._requestHandler=i.create(o),this._requestHandler?e(a.getAllMethodNames(this._requestHandler)):t(new Error("No RequestHandler!"))}),t)})))}}function y(e){return new w(e,null)}},72067:function(e,t,i){"use strict";i.r(t),i.d(t,{QuickInputController:function(){return L}});var n=i(96747),o=i(8769),r=i(31532),s=i(54042),a=i(66218),l=i(21348),c=i(81449),d=i(60969),u=i(64998),h=i(66129),g=i(11256),p=i(56087),m=i(63801),f=i(68921),b=i(66719),_=i(15051),A=i(18912),v=i(2926),C=i(11476),w=(i(67027),i(83787)),y=i(19376),S=i(59765),x=function(e,t,i,n){return new(i||(i=Promise))((function(o,r){function s(e){try{l(n.next(e))}catch(e){r(e)}}function a(e){try{l(n.throw(e))}catch(e){r(e)}}function l(e){var t;e.done?o(e.value):(t=e.value,t instanceof i?t:new i((function(e){e(t)}))).then(s,a)}l((n=n.apply(e,t||[])).next())}))};const E=n.$,k={iconClass:p.Codicon.quickInputBack.classNames,tooltip:(0,w.localize)("vs/base/parts/quickinput/browser/quickInput","quickInput.back","Back"),handle:-1};class I extends f.Disposable{constructor(e){super(),this.ui=e,this.visible=!1,this._enabled=!0,this._busy=!1,this._ignoreFocusOut=!1,this._buttons=[],this.noValidationMessage=I.noPromptMessage,this._severity=_.default.Ignore,this.buttonsUpdated=!1,this.onDidTriggerButtonEmitter=this._register(new m.Emitter),this.onDidHideEmitter=this._register(new m.Emitter),this.onDisposeEmitter=this._register(new m.Emitter),this.visibleDisposables=this._register(new f.DisposableStore),this.onDidHide=this.onDidHideEmitter.event}get title(){return this._title}set title(e){this._title=e,this.update()}get description(){return this._description}set description(e){this._description=e,this.update()}get step(){return this._steps}set step(e){this._steps=e,this.update()}get totalSteps(){return this._totalSteps}set totalSteps(e){this._totalSteps=e,this.update()}get enabled(){return this._enabled}set enabled(e){this._enabled=e,this.update()}get contextKey(){return this._contextKey}set contextKey(e){this._contextKey=e,this.update()}get busy(){return this._busy}set busy(e){this._busy=e,this.update()}get ignoreFocusOut(){return this._ignoreFocusOut}set ignoreFocusOut(e){const t=this._ignoreFocusOut!==e&&!b.isIOS;this._ignoreFocusOut=e&&!b.isIOS,t&&this.update()}get buttons(){return this._buttons}set buttons(e){this._buttons=e,this.buttonsUpdated=!0,this.update()}get validationMessage(){return this._validationMessage}set validationMessage(e){this._validationMessage=e,this.update()}get severity(){return this._severity}set severity(e){this._severity=e,this.update()}show(){this.visible||(this.visibleDisposables.add(this.ui.onDidTriggerButton((e=>{-1!==this.buttons.indexOf(e)&&this.onDidTriggerButtonEmitter.fire(e)}))),this.ui.show(this),this.visible=!0,this._lastValidationMessage=void 0,this._lastSeverity=void 0,this.buttons.length&&(this.buttonsUpdated=!0),this.update())}hide(){this.visible&&this.ui.hide()}didHide(e=C.QuickInputHideReason.Other){this.visible=!1,this.visibleDisposables.clear(),this.onDidHideEmitter.fire({reason:e})}update(){if(!this.visible)return;const e=this.getTitle();e&&this.ui.title.textContent!==e?this.ui.title.textContent=e:e||"&nbsp;"===this.ui.title.innerHTML||(this.ui.title.innerText=" ");const t=this.getDescription();if(this.ui.description1.textContent!==t&&(this.ui.description1.textContent=t),this.ui.description2.textContent!==t&&(this.ui.description2.textContent=t),this.busy&&!this.busyDelay&&(this.busyDelay=new h.TimeoutTimer,this.busyDelay.setIfNotSet((()=>{this.visible&&this.ui.progressBar.infinite()}),800)),!this.busy&&this.busyDelay&&(this.ui.progressBar.stop(),this.busyDelay.cancel(),this.busyDelay=void 0),this.buttonsUpdated){this.buttonsUpdated=!1,this.ui.leftActionBar.clear();const e=this.buttons.filter((e=>e===k));this.ui.leftActionBar.push(e.map(((e,t)=>{const i=new d.Action(`id-${t}`,"",e.iconClass||(0,v.getIconClass)(e.iconPath),!0,(()=>x(this,void 0,void 0,(function*(){this.onDidTriggerButtonEmitter.fire(e)}))));return i.tooltip=e.tooltip||"",i})),{icon:!0,label:!1}),this.ui.rightActionBar.clear();const t=this.buttons.filter((e=>e!==k));this.ui.rightActionBar.push(t.map(((e,t)=>{const i=new d.Action(`id-${t}`,"",e.iconClass||(0,v.getIconClass)(e.iconPath),!0,(()=>x(this,void 0,void 0,(function*(){this.onDidTriggerButtonEmitter.fire(e)}))));return i.tooltip=e.tooltip||"",i})),{icon:!0,label:!1})}this.ui.ignoreFocusOut=this.ignoreFocusOut,this.ui.setEnabled(this.enabled),this.ui.setContextKey(this.contextKey);const i=this.validationMessage||this.noValidationMessage;this._lastValidationMessage!==i&&(this._lastValidationMessage=i,n.reset(this.ui.message,...(0,l.renderLabelWithIcons)(i))),this._lastSeverity!==this.severity&&(this._lastSeverity=this.severity,this.showMessageDecoration(this.severity))}getTitle(){return this.title&&this.step?`${this.title} (${this.getSteps()})`:this.title?this.title:this.step?this.getSteps():""}getDescription(){return this.description||""}getSteps(){return this.step&&this.totalSteps?(0,w.localize)("vs/base/parts/quickinput/browser/quickInput","quickInput.steps","{0}/{1}",this.step,this.totalSteps):this.step?String(this.step):""}showMessageDecoration(e){if(this.ui.inputBox.showDecoration(e),e!==_.default.Ignore){const t=this.ui.inputBox.stylesForType(e);this.ui.message.style.color=t.foreground?`${t.foreground}`:"",this.ui.message.style.backgroundColor=t.background?`${t.background}`:"",this.ui.message.style.border=t.border?`1px solid ${t.border}`:"",this.ui.message.style.marginBottom="-2px"}else this.ui.message.style.color="",this.ui.message.style.backgroundColor="",this.ui.message.style.border="",this.ui.message.style.marginBottom=""}dispose(){this.hide(),this.onDisposeEmitter.fire(),super.dispose()}}I.noPromptMessage=(0,w.localize)("vs/base/parts/quickinput/browser/quickInput","inputModeEntry","Press 'Enter' to confirm your input or 'Escape' to cancel");class D extends I{constructor(){super(...arguments),this._value="",this.onDidChangeValueEmitter=this._register(new m.Emitter),this.onWillAcceptEmitter=this._register(new m.Emitter),this.onDidAcceptEmitter=this._register(new m.Emitter),this.onDidCustomEmitter=this._register(new m.Emitter),this._items=[],this.itemsUpdated=!1,this._canSelectMany=!1,this._canAcceptInBackground=!1,this._matchOnDescription=!1,this._matchOnDetail=!1,this._matchOnLabel=!0,this._matchOnLabelMode="fuzzy",this._sortByLabel=!0,this._autoFocusOnList=!0,this._keepScrollPosition=!1,this._itemActivation=this.ui.isScreenReaderOptimized()?C.ItemActivation.NONE:C.ItemActivation.FIRST,this._activeItems=[],this.activeItemsUpdated=!1,this.activeItemsToConfirm=[],this.onDidChangeActiveEmitter=this._register(new m.Emitter),this._selectedItems=[],this.selectedItemsUpdated=!1,this.selectedItemsToConfirm=[],this.onDidChangeSelectionEmitter=this._register(new m.Emitter),this.onDidTriggerItemButtonEmitter=this._register(new m.Emitter),this.valueSelectionUpdated=!0,this._ok="default",this._customButton=!1,this.filterValue=e=>e,this.onDidChangeValue=this.onDidChangeValueEmitter.event,this.onWillAccept=this.onWillAcceptEmitter.event,this.onDidAccept=this.onDidAcceptEmitter.event,this.onDidChangeActive=this.onDidChangeActiveEmitter.event,this.onDidChangeSelection=this.onDidChangeSelectionEmitter.event,this.onDidTriggerItemButton=this.onDidTriggerItemButtonEmitter.event}get quickNavigate(){return this._quickNavigate}set quickNavigate(e){this._quickNavigate=e,this.update()}get value(){return this._value}set value(e){this.doSetValue(e)}doSetValue(e,t){if(this._value!==e){if(this._value=e,t||this.update(),this.visible){this.ui.list.filter(this.filterValue(this._value))&&this.trySelectFirst()}this.onDidChangeValueEmitter.fire(this._value)}}set ariaLabel(e){this._ariaLabel=e,this.update()}get ariaLabel(){return this._ariaLabel}get placeholder(){return this._placeholder}set placeholder(e){this._placeholder=e,this.update()}get items(){return this._items}get scrollTop(){return this.ui.list.scrollTop}set scrollTop(e){this.ui.list.scrollTop=e}set items(e){this._items=e,this.itemsUpdated=!0,this.update()}get canSelectMany(){return this._canSelectMany}set canSelectMany(e){this._canSelectMany=e,this.update()}get canAcceptInBackground(){return this._canAcceptInBackground}set canAcceptInBackground(e){this._canAcceptInBackground=e}get matchOnDescription(){return this._matchOnDescription}set matchOnDescription(e){this._matchOnDescription=e,this.update()}get matchOnDetail(){return this._matchOnDetail}set matchOnDetail(e){this._matchOnDetail=e,this.update()}get matchOnLabel(){return this._matchOnLabel}set matchOnLabel(e){this._matchOnLabel=e,this.update()}get matchOnLabelMode(){return this._matchOnLabelMode}set matchOnLabelMode(e){this._matchOnLabelMode=e,this.update()}get sortByLabel(){return this._sortByLabel}set sortByLabel(e){this._sortByLabel=e,this.update()}get autoFocusOnList(){return this._autoFocusOnList}set autoFocusOnList(e){this._autoFocusOnList=e,this.update()}get keepScrollPosition(){return this._keepScrollPosition}set keepScrollPosition(e){this._keepScrollPosition=e}get itemActivation(){return this._itemActivation}set itemActivation(e){this._itemActivation=e}get activeItems(){return this._activeItems}set activeItems(e){this._activeItems=e,this.activeItemsUpdated=!0,this.update()}get selectedItems(){return this._selectedItems}set selectedItems(e){this._selectedItems=e,this.selectedItemsUpdated=!0,this.update()}get keyMods(){return this._quickNavigate?C.NO_KEY_MODS:this.ui.keyMods}set valueSelection(e){this._valueSelection=e,this.valueSelectionUpdated=!0,this.update()}get customButton(){return this._customButton}set customButton(e){this._customButton=e,this.update()}get customLabel(){return this._customButtonLabel}set customLabel(e){this._customButtonLabel=e,this.update()}get customHover(){return this._customButtonHover}set customHover(e){this._customButtonHover=e,this.update()}get ok(){return this._ok}set ok(e){this._ok=e,this.update()}get hideInput(){return!!this._hideInput}set hideInput(e){this._hideInput=e,this.update()}trySelectFirst(){this.autoFocusOnList&&(this.canSelectMany||this.ui.list.focus(S.QuickInputListFocus.First))}show(){this.visible||(this.visibleDisposables.add(this.ui.inputBox.onDidChange((e=>{this.doSetValue(e,!0)}))),this.visibleDisposables.add(this.ui.inputBox.onMouseDown((e=>{this.autoFocusOnList||this.ui.list.clearFocus()}))),this.visibleDisposables.add((this._hideInput?this.ui.list:this.ui.inputBox).onKeyDown((e=>{switch(e.keyCode){case 18:this.ui.list.focus(S.QuickInputListFocus.Next),this.canSelectMany&&this.ui.list.domFocus(),n.EventHelper.stop(e,!0);break;case 16:this.ui.list.getFocusedElements().length?this.ui.list.focus(S.QuickInputListFocus.Previous):this.ui.list.focus(S.QuickInputListFocus.Last),this.canSelectMany&&this.ui.list.domFocus(),n.EventHelper.stop(e,!0);break;case 12:this.ui.list.focus(S.QuickInputListFocus.NextPage),this.canSelectMany&&this.ui.list.domFocus(),n.EventHelper.stop(e,!0);break;case 11:this.ui.list.focus(S.QuickInputListFocus.PreviousPage),this.canSelectMany&&this.ui.list.domFocus(),n.EventHelper.stop(e,!0);break;case 17:if(!this._canAcceptInBackground)return;if(!this.ui.inputBox.isSelectionAtEnd())return;this.activeItems[0]&&(this._selectedItems=[this.activeItems[0]],this.onDidChangeSelectionEmitter.fire(this.selectedItems),this.handleAccept(!0));break;case 14:!e.ctrlKey&&!e.metaKey||e.shiftKey||e.altKey||(this.ui.list.focus(S.QuickInputListFocus.First),n.EventHelper.stop(e,!0));break;case 13:!e.ctrlKey&&!e.metaKey||e.shiftKey||e.altKey||(this.ui.list.focus(S.QuickInputListFocus.Last),n.EventHelper.stop(e,!0))}}))),this.visibleDisposables.add(this.ui.onDidAccept((()=>{this.canSelectMany?this.ui.list.getCheckedElements().length||(this._selectedItems=[],this.onDidChangeSelectionEmitter.fire(this.selectedItems)):this.activeItems[0]&&(this._selectedItems=[this.activeItems[0]],this.onDidChangeSelectionEmitter.fire(this.selectedItems)),this.handleAccept(!1)}))),this.visibleDisposables.add(this.ui.onDidCustom((()=>{this.onDidCustomEmitter.fire()}))),this.visibleDisposables.add(this.ui.list.onDidChangeFocus((e=>{this.activeItemsUpdated||this.activeItemsToConfirm!==this._activeItems&&(0,u.equals)(e,this._activeItems,((e,t)=>e===t))||(this._activeItems=e,this.onDidChangeActiveEmitter.fire(e))}))),this.visibleDisposables.add(this.ui.list.onDidChangeSelection((({items:e,event:t})=>{this.canSelectMany?e.length&&this.ui.list.setSelectedElements([]):this.selectedItemsToConfirm!==this._selectedItems&&(0,u.equals)(e,this._selectedItems,((e,t)=>e===t))||(this._selectedItems=e,this.onDidChangeSelectionEmitter.fire(e),e.length&&this.handleAccept(t instanceof MouseEvent&&1===t.button))}))),this.visibleDisposables.add(this.ui.list.onChangedCheckedElements((e=>{this.canSelectMany&&(this.selectedItemsToConfirm!==this._selectedItems&&(0,u.equals)(e,this._selectedItems,((e,t)=>e===t))||(this._selectedItems=e,this.onDidChangeSelectionEmitter.fire(e)))}))),this.visibleDisposables.add(this.ui.list.onButtonTriggered((e=>this.onDidTriggerItemButtonEmitter.fire(e)))),this.visibleDisposables.add(this.registerQuickNavigation()),this.valueSelectionUpdated=!0),super.show()}handleAccept(e){let t=!1;this.onWillAcceptEmitter.fire({veto:()=>t=!0}),t||this.onDidAcceptEmitter.fire({inBackground:e})}registerQuickNavigation(){return n.addDisposableListener(this.ui.container,n.EventType.KEY_UP,(e=>{if(this.canSelectMany||!this._quickNavigate)return;const t=new o.StandardKeyboardEvent(e),i=t.keyCode;this._quickNavigate.keybindings.some((e=>{const[n,o]=e.getParts();return!o&&(n.shiftKey&&4===i?!(t.ctrlKey||t.altKey||t.metaKey):!(!n.altKey||6!==i)||(!(!n.ctrlKey||5!==i)||!(!n.metaKey||57!==i)))}))&&(this.activeItems[0]&&(this._selectedItems=[this.activeItems[0]],this.onDidChangeSelectionEmitter.fire(this.selectedItems),this.handleAccept(!1)),this._quickNavigate=void 0)}))}update(){if(!this.visible)return;const e=this.keepScrollPosition?this.scrollTop:0,t=!!this._hideInput&&this._items.length>0;this.ui.container.classList.toggle("hidden-input",t&&!this.description);const i={title:!!this.title||!!this.step||!!this.buttons.length,description:!!this.description,checkAll:this.canSelectMany&&!this._hideCheckAll,checkBox:this.canSelectMany,inputBox:!t,progressBar:!t,visibleCount:!0,count:this.canSelectMany,ok:"default"===this.ok?this.canSelectMany:this.ok,list:!0,message:!!this.validationMessage,customButton:this.customButton};this.ui.setVisibilities(i),super.update(),this.ui.inputBox.value!==this.value&&(this.ui.inputBox.value=this.value),this.valueSelectionUpdated&&(this.valueSelectionUpdated=!1,this.ui.inputBox.select(this._valueSelection&&{start:this._valueSelection[0],end:this._valueSelection[1]})),this.ui.inputBox.placeholder!==(this.placeholder||"")&&(this.ui.inputBox.placeholder=this.placeholder||"");let n=this.ariaLabel;if(n||(n=this.placeholder||D.DEFAULT_ARIA_LABEL,this.title&&(n+=` - ${this.title}`)),this.ui.inputBox.ariaLabel!==n&&(this.ui.inputBox.ariaLabel=n),this.ui.list.matchOnDescription=this.matchOnDescription,this.ui.list.matchOnDetail=this.matchOnDetail,this.ui.list.matchOnLabel=this.matchOnLabel,this.ui.list.matchOnLabelMode=this.matchOnLabelMode,this.ui.list.sortByLabel=this.sortByLabel,this.itemsUpdated)switch(this.itemsUpdated=!1,this.ui.list.setElements(this.items),this.ui.list.filter(this.filterValue(this.ui.inputBox.value)),this.ui.checkAll.checked=this.ui.list.getAllVisibleChecked(),this.ui.visibleCount.setCount(this.ui.list.getVisibleCount()),this.ui.count.setCount(this.ui.list.getCheckedCount()),this._itemActivation){case C.ItemActivation.NONE:this._itemActivation=C.ItemActivation.FIRST;break;case C.ItemActivation.SECOND:this.ui.list.focus(S.QuickInputListFocus.Second),this._itemActivation=C.ItemActivation.FIRST;break;case C.ItemActivation.LAST:this.ui.list.focus(S.QuickInputListFocus.Last),this._itemActivation=C.ItemActivation.FIRST;break;default:this.trySelectFirst()}this.ui.container.classList.contains("show-checkboxes")!==!!this.canSelectMany&&(this.canSelectMany?this.ui.list.clearFocus():this.trySelectFirst()),this.activeItemsUpdated&&(this.activeItemsUpdated=!1,this.activeItemsToConfirm=this._activeItems,this.ui.list.setFocusedElements(this.activeItems),this.activeItemsToConfirm===this._activeItems&&(this.activeItemsToConfirm=null)),this.selectedItemsUpdated&&(this.selectedItemsUpdated=!1,this.selectedItemsToConfirm=this._selectedItems,this.canSelectMany?this.ui.list.setCheckedElements(this.selectedItems):this.ui.list.setSelectedElements(this.selectedItems),this.selectedItemsToConfirm===this._selectedItems&&(this.selectedItemsToConfirm=null)),this.ui.customButton.label=this.customLabel||"",this.ui.customButton.element.title=this.customHover||"",this.ui.setComboboxAccessibility(!0),i.inputBox||(this.ui.list.domFocus(),this.canSelectMany&&this.ui.list.focus(S.QuickInputListFocus.First)),this.keepScrollPosition&&(this.scrollTop=e)}}D.DEFAULT_ARIA_LABEL=(0,w.localize)("vs/base/parts/quickinput/browser/quickInput","quickInputBox.ariaLabel","Type to narrow down results.");class L extends f.Disposable{constructor(e){super(),this.options=e,this.comboboxAccessibility=!1,this.enabled=!0,this.onDidAcceptEmitter=this._register(new m.Emitter),this.onDidCustomEmitter=this._register(new m.Emitter),this.onDidTriggerButtonEmitter=this._register(new m.Emitter),this.keyMods={ctrlCmd:!1,alt:!1},this.controller=null,this.onShowEmitter=this._register(new m.Emitter),this.onShow=this.onShowEmitter.event,this.onHideEmitter=this._register(new m.Emitter),this.onHide=this.onHideEmitter.event,this.idPrefix=e.idPrefix,this.parentElement=e.container,this.styles=e.styles,this.registerKeyModsListeners()}registerKeyModsListeners(){const e=e=>{this.keyMods.ctrlCmd=e.ctrlKey||e.metaKey,this.keyMods.alt=e.altKey};this._register(n.addDisposableListener(window,n.EventType.KEY_DOWN,e,!0)),this._register(n.addDisposableListener(window,n.EventType.KEY_UP,e,!0)),this._register(n.addDisposableListener(window,n.EventType.MOUSE_DOWN,e,!0))}getUI(){if(this.ui)return this.ui;const e=n.append(this.parentElement,E(".quick-input-widget.show-file-icons"));e.tabIndex=-1,e.style.display="none";const t=n.createStyleSheet(e),i=n.append(e,E(".quick-input-titlebar")),l=this._register(new r.ActionBar(i));l.domNode.classList.add("quick-input-left-action-bar");const d=n.append(i,E(".quick-input-title")),u=this._register(new r.ActionBar(i));u.domNode.classList.add("quick-input-right-action-bar");const h=n.append(e,E(".quick-input-description")),g=n.append(e,E(".quick-input-header")),p=n.append(g,E("input.quick-input-check-all"));p.type="checkbox",p.setAttribute("aria-label",(0,w.localize)("vs/base/parts/quickinput/browser/quickInput","quickInput.checkAll","Toggle all checkboxes")),this._register(n.addStandardDisposableListener(p,n.EventType.CHANGE,(e=>{const t=p.checked;R.setAllVisibleChecked(t)}))),this._register(n.addDisposableListener(p,n.EventType.CLICK,(e=>{(e.x||e.y)&&_.setFocus()})));const m=n.append(g,E(".quick-input-description")),f=n.append(g,E(".quick-input-and-message")),b=n.append(f,E(".quick-input-filter")),_=this._register(new y.QuickInputBox(b));_.setAttribute("aria-describedby",`${this.idPrefix}message`);const A=n.append(b,E(".quick-input-visible-count"));A.setAttribute("aria-live","polite"),A.setAttribute("aria-atomic","true");const v=new a.CountBadge(A,{countFormat:(0,w.localize)("vs/base/parts/quickinput/browser/quickInput",{key:"quickInput.visibleCount",comment:["This tells the user how many items are shown in a list of items to select from. The items can be anything. Currently not visible, but read by screen readers."]},"{0} Results")}),x=n.append(b,E(".quick-input-count"));x.setAttribute("aria-live","polite");const k=new a.CountBadge(x,{countFormat:(0,w.localize)("vs/base/parts/quickinput/browser/quickInput",{key:"quickInput.countSelected",comment:["This tells the user how many items are selected in a list of items to select from. The items can be anything."]},"{0} Selected")}),I=n.append(g,E(".quick-input-action")),L=new s.Button(I);L.label=(0,w.localize)("vs/base/parts/quickinput/browser/quickInput","ok","OK"),this._register(L.onDidClick((e=>{this.onDidAcceptEmitter.fire()})));const T=n.append(g,E(".quick-input-action")),M=new s.Button(T);M.label=(0,w.localize)("vs/base/parts/quickinput/browser/quickInput","custom","Custom"),this._register(M.onDidClick((e=>{this.onDidCustomEmitter.fire()})));const N=n.append(f,E(`#${this.idPrefix}message.quick-input-message`)),R=this._register(new S.QuickInputList(e,this.idPrefix+"list",this.options));this._register(R.onChangedAllVisibleChecked((e=>{p.checked=e}))),this._register(R.onChangedVisibleCount((e=>{v.setCount(e)}))),this._register(R.onChangedCheckedCount((e=>{k.setCount(e)}))),this._register(R.onLeave((()=>{setTimeout((()=>{_.setFocus(),this.controller instanceof D&&this.controller.canSelectMany&&R.clearFocus()}),0)}))),this._register(R.onDidChangeFocus((()=>{this.comboboxAccessibility&&this.getUI().inputBox.setAttribute("aria-activedescendant",this.getUI().list.getActiveDescendant()||"")})));const B=new c.ProgressBar(e);B.getContainer().classList.add("quick-input-progress");const O=n.trackFocus(e);return this._register(O),this._register(n.addDisposableListener(e,n.EventType.FOCUS,(e=>{this.previousFocusElement=e.relatedTarget instanceof HTMLElement?e.relatedTarget:void 0}),!0)),this._register(O.onDidBlur((()=>{this.getUI().ignoreFocusOut||this.options.ignoreFocusOut()||this.hide(C.QuickInputHideReason.Blur),this.previousFocusElement=void 0}))),this._register(n.addDisposableListener(e,n.EventType.FOCUS,(e=>{_.setFocus()}))),this._register(n.addDisposableListener(e,n.EventType.KEY_DOWN,(t=>{const i=new o.StandardKeyboardEvent(t);switch(i.keyCode){case 3:n.EventHelper.stop(t,!0),this.onDidAcceptEmitter.fire();break;case 9:n.EventHelper.stop(t,!0),this.hide(C.QuickInputHideReason.Gesture);break;case 2:if(!i.altKey&&!i.ctrlKey&&!i.metaKey){const o=[".action-label.codicon"];e.classList.contains("show-checkboxes")?o.push("input"):o.push("input[type=text]"),this.getUI().list.isDisplayed()&&o.push(".monaco-list");const r=e.querySelectorAll(o.join(", "));i.shiftKey&&i.target===r[0]?(n.EventHelper.stop(t,!0),r[r.length-1].focus()):i.shiftKey||i.target!==r[r.length-1]||(n.EventHelper.stop(t,!0),r[0].focus())}}}))),this.ui={container:e,styleSheet:t,leftActionBar:l,titleBar:i,title:d,description1:h,description2:m,rightActionBar:u,checkAll:p,filterContainer:b,inputBox:_,visibleCountContainer:A,visibleCount:v,countContainer:x,count:k,okContainer:I,ok:L,message:N,customButtonContainer:T,customButton:M,list:R,progressBar:B,onDidAccept:this.onDidAcceptEmitter.event,onDidCustom:this.onDidCustomEmitter.event,onDidTriggerButton:this.onDidTriggerButtonEmitter.event,ignoreFocusOut:!1,keyMods:this.keyMods,isScreenReaderOptimized:()=>this.options.isScreenReaderOptimized(),show:e=>this.show(e),hide:()=>this.hide(),setVisibilities:e=>this.setVisibilities(e),setComboboxAccessibility:e=>this.setComboboxAccessibility(e),setEnabled:e=>this.setEnabled(e),setContextKey:e=>this.options.setContextKey(e)},this.updateStyles(),this.ui}pick(e,t={},i=g.CancellationToken.None){return new Promise(((n,o)=>{let r=e=>{var i;r=n,null===(i=t.onKeyMods)||void 0===i||i.call(t,s.keyMods),n(e)};if(i.isCancellationRequested)return void r(void 0);const s=this.createQuickPick();let a;const l=[s,s.onDidAccept((()=>{if(s.canSelectMany)r(s.selectedItems.slice()),s.hide();else{const e=s.activeItems[0];e&&(r(e),s.hide())}})),s.onDidChangeActive((e=>{const i=e[0];i&&t.onDidFocus&&t.onDidFocus(i)})),s.onDidChangeSelection((e=>{if(!s.canSelectMany){const t=e[0];t&&(r(t),s.hide())}})),s.onDidTriggerItemButton((e=>t.onDidTriggerItemButton&&t.onDidTriggerItemButton(Object.assign(Object.assign({},e),{removeItem:()=>{const t=s.items.indexOf(e.item);if(-1!==t){const e=s.items.slice(),i=e.splice(t,1),n=s.activeItems.filter((e=>e!==i[0])),o=s.keepScrollPosition;s.keepScrollPosition=!0,s.items=e,n&&(s.activeItems=n),s.keepScrollPosition=o}}})))),s.onDidChangeValue((e=>{!a||e||1===s.activeItems.length&&s.activeItems[0]===a||(s.activeItems=[a])})),i.onCancellationRequested((()=>{s.hide()})),s.onDidHide((()=>{(0,f.dispose)(l),r(void 0)}))];s.title=t.title,s.canSelectMany=!!t.canPickMany,s.placeholder=t.placeHolder,s.ignoreFocusOut=!!t.ignoreFocusLost,s.matchOnDescription=!!t.matchOnDescription,s.matchOnDetail=!!t.matchOnDetail,s.matchOnLabel=void 0===t.matchOnLabel||t.matchOnLabel,s.autoFocusOnList=void 0===t.autoFocusOnList||t.autoFocusOnList,s.quickNavigate=t.quickNavigate,s.hideInput=!!t.hideInput,s.contextKey=t.contextKey,s.busy=!0,Promise.all([e,t.activeItem]).then((([e,t])=>{a=t,s.busy=!1,s.items=e,s.canSelectMany&&(s.selectedItems=e.filter((e=>"separator"!==e.type&&e.picked))),a&&(s.activeItems=[a])})),s.show(),Promise.resolve(e).then(void 0,(e=>{o(e),s.hide()}))}))}createQuickPick(){const e=this.getUI();return new D(e)}show(e){const t=this.getUI();this.onShowEmitter.fire();const i=this.controller;this.controller=e,i&&i.didHide(),this.setEnabled(!0),t.leftActionBar.clear(),t.title.textContent="",t.description1.textContent="",t.description2.textContent="",t.rightActionBar.clear(),t.checkAll.checked=!1,t.inputBox.placeholder="",t.inputBox.password=!1,t.inputBox.showDecoration(_.default.Ignore),t.visibleCount.setCount(0),t.count.setCount(0),n.reset(t.message),t.progressBar.stop(),t.list.setElements([]),t.list.matchOnDescription=!1,t.list.matchOnDetail=!1,t.list.matchOnLabel=!0,t.list.sortByLabel=!0,t.ignoreFocusOut=!1,this.setComboboxAccessibility(!1),t.inputBox.ariaLabel="";const o=this.options.backKeybindingLabel();k.tooltip=o?(0,w.localize)("vs/base/parts/quickinput/browser/quickInput","quickInput.backWithKeybinding","Back ({0})",o):(0,w.localize)("vs/base/parts/quickinput/browser/quickInput","quickInput.back","Back"),t.container.style.display="",this.updateLayout(),t.inputBox.setFocus()}setVisibilities(e){const t=this.getUI();t.title.style.display=e.title?"":"none",t.description1.style.display=e.description&&(e.inputBox||e.checkAll)?"":"none",t.description2.style.display=!e.description||e.inputBox||e.checkAll?"none":"",t.checkAll.style.display=e.checkAll?"":"none",t.filterContainer.style.display=e.inputBox?"":"none",t.visibleCountContainer.style.display=e.visibleCount?"":"none",t.countContainer.style.display=e.count?"":"none",t.okContainer.style.display=e.ok?"":"none",t.customButtonContainer.style.display=e.customButton?"":"none",t.message.style.display=e.message?"":"none",t.progressBar.getContainer().style.display=e.progressBar?"":"none",t.list.display(!!e.list),t.container.classList[e.checkBox?"add":"remove"]("show-checkboxes"),this.updateLayout()}setComboboxAccessibility(e){if(e!==this.comboboxAccessibility){const t=this.getUI();this.comboboxAccessibility=e,this.comboboxAccessibility?(t.inputBox.setAttribute("role","combobox"),t.inputBox.setAttribute("aria-haspopup","true"),t.inputBox.setAttribute("aria-autocomplete","list"),t.inputBox.setAttribute("aria-activedescendant",t.list.getActiveDescendant()||"")):(t.inputBox.removeAttribute("role"),t.inputBox.removeAttribute("aria-haspopup"),t.inputBox.removeAttribute("aria-autocomplete"),t.inputBox.removeAttribute("aria-activedescendant"))}}setEnabled(e){if(e!==this.enabled){this.enabled=e;for(const t of this.getUI().leftActionBar.viewItems)t.getAction().enabled=e;for(const t of this.getUI().rightActionBar.viewItems)t.getAction().enabled=e;this.getUI().checkAll.disabled=!e,this.getUI().ok.enabled=e,this.getUI().list.enabled=e}}hide(e){var t;const i=this.controller;if(i){const n=!(null===(t=this.ui)||void 0===t?void 0:t.container.contains(document.activeElement));if(this.controller=null,this.onHideEmitter.fire(),this.getUI().container.style.display="none",!n){let e=this.previousFocusElement;for(;e&&!e.offsetParent;)e=(0,A.withNullAsUndefined)(e.parentElement);(null==e?void 0:e.offsetParent)?(e.focus(),this.previousFocusElement=void 0):this.options.returnFocus()}i.didHide(e)}}layout(e,t){this.dimension=e,this.titleBarOffset=t,this.updateLayout()}updateLayout(){if(this.ui){this.ui.container.style.top=`${this.titleBarOffset}px`;const e=this.ui.container.style,t=Math.min(.62*this.dimension.width,L.MAX_WIDTH);e.width=t+"px",e.marginLeft="-"+t/2+"px",this.ui.inputBox.layout(),this.ui.list.layout(this.dimension&&.4*this.dimension.height)}}applyStyles(e){this.styles=e,this.updateStyles()}updateStyles(){if(this.ui){const{quickInputTitleBackground:e,quickInputBackground:t,quickInputForeground:i,contrastBorder:n,widgetShadow:o}=this.styles.widget;this.ui.titleBar.style.backgroundColor=e?e.toString():"",this.ui.container.style.backgroundColor=t?t.toString():"",this.ui.container.style.color=i?i.toString():"",this.ui.container.style.border=n?`1px solid ${n}`:"",this.ui.container.style.boxShadow=o?`0 0 8px 2px ${o}`:"",this.ui.inputBox.style(this.styles.inputBox),this.ui.count.style(this.styles.countBadge),this.ui.ok.style(this.styles.button),this.ui.customButton.style(this.styles.button),this.ui.progressBar.style(this.styles.progressBar),this.ui.list.style(this.styles.list);const r=[];this.styles.list.pickerGroupBorder&&r.push(`.quick-input-list .quick-input-list-entry { border-top-color:  ${this.styles.list.pickerGroupBorder}; }`),this.styles.list.pickerGroupForeground&&r.push(`.quick-input-list .quick-input-list-separator { color:  ${this.styles.list.pickerGroupForeground}; }`),(this.styles.keybindingLabel.keybindingLabelBackground||this.styles.keybindingLabel.keybindingLabelBorder||this.styles.keybindingLabel.keybindingLabelBottomBorder||this.styles.keybindingLabel.keybindingLabelShadow||this.styles.keybindingLabel.keybindingLabelForeground)&&(r.push(".quick-input-list .monaco-keybinding > .monaco-keybinding-key {"),this.styles.keybindingLabel.keybindingLabelBackground&&r.push(`background-color: ${this.styles.keybindingLabel.keybindingLabelBackground};`),this.styles.keybindingLabel.keybindingLabelBorder&&r.push(`border-color: ${this.styles.keybindingLabel.keybindingLabelBorder};`),this.styles.keybindingLabel.keybindingLabelBottomBorder&&r.push(`border-bottom-color: ${this.styles.keybindingLabel.keybindingLabelBottomBorder};`),this.styles.keybindingLabel.keybindingLabelShadow&&r.push(`box-shadow: inset 0 -1px 0 ${this.styles.keybindingLabel.keybindingLabelShadow};`),this.styles.keybindingLabel.keybindingLabelForeground&&r.push(`color: ${this.styles.keybindingLabel.keybindingLabelForeground};`),r.push("}"));const s=r.join("\n");s!==this.ui.styleSheet.textContent&&(this.ui.styleSheet.textContent=s)}}}L.MAX_WIDTH=600},19376:function(e,t,i){"use strict";i.r(t),i.d(t,{QuickInputBox:function(){return d}});var n=i(96747),o=i(8769),r=i(5642),s=i(25802),a=i(68921),l=i(15051);i(67027);const c=n.$;class d extends a.Disposable{constructor(e){super(),this.parent=e,this.onKeyDown=e=>n.addDisposableListener(this.inputBox.inputElement,n.EventType.KEY_DOWN,(t=>{e(new o.StandardKeyboardEvent(t))})),this.onMouseDown=e=>n.addDisposableListener(this.inputBox.inputElement,n.EventType.MOUSE_DOWN,(t=>{e(new r.StandardMouseEvent(t))})),this.onDidChange=e=>this.inputBox.onDidChange(e),this.container=n.append(this.parent,c(".quick-input-box")),this.inputBox=this._register(new s.InputBox(this.container,void 0))}get value(){return this.inputBox.value}set value(e){this.inputBox.value=e}select(e=null){this.inputBox.select(e)}isSelectionAtEnd(){return this.inputBox.isSelectionAtEnd()}get placeholder(){return this.inputBox.inputElement.getAttribute("placeholder")||""}set placeholder(e){this.inputBox.setPlaceHolder(e)}get ariaLabel(){return this.inputBox.getAriaLabel()}set ariaLabel(e){this.inputBox.setAriaLabel(e)}get password(){return"password"===this.inputBox.inputElement.type}set password(e){this.inputBox.inputElement.type=e?"password":"text"}setAttribute(e,t){this.inputBox.inputElement.setAttribute(e,t)}removeAttribute(e){this.inputBox.inputElement.removeAttribute(e)}showDecoration(e){e===l.default.Ignore?this.inputBox.hideMessage():this.inputBox.showMessage({type:e===l.default.Info?1:e===l.default.Warning?2:3,content:""})}stylesForType(e){return this.inputBox.stylesForType(e===l.default.Info?1:e===l.default.Warning?2:3)}setFocus(){this.inputBox.focus()}layout(){this.inputBox.layout()}style(e){this.inputBox.style(e)}}},59765:function(e,t,i){"use strict";i.r(t),i.d(t,{QuickInputList:function(){return I},QuickInputListFocus:function(){return k},matchesContiguousIconAware:function(){return D}});var n=i(96747),o=i(8769),r=i(31532),s=i(74838),a=i(91120),l=i(60969),c=i(64998),d=i(56087),u=i(99981),h=i(63966),g=i(63801),p=i(69373),m=i(68921),f=i(66719),b=i(91482),_=i(18912),A=i(2926),v=(i(67027),i(83787)),C=function(e,t,i,n){var o,r=arguments.length,s=r<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,i):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)s=Reflect.decorate(e,t,i,n);else for(var a=e.length-1;a>=0;a--)(o=e[a])&&(s=(r<3?o(s):r>3?o(t,i,s):o(t,i))||s);return r>3&&s&&Object.defineProperty(t,i,s),s},w=function(e,t,i,n){return new(i||(i=Promise))((function(o,r){function s(e){try{l(n.next(e))}catch(e){r(e)}}function a(e){try{l(n.throw(e))}catch(e){r(e)}}function l(e){var t;e.done?o(e.value):(t=e.value,t instanceof i?t:new i((function(e){e(t)}))).then(s,a)}l((n=n.apply(e,t||[])).next())}))};const y=n.$;class S{constructor(e){this.hidden=!1,this._onChecked=new g.Emitter,this.onChecked=this._onChecked.event,Object.assign(this,e)}get checked(){return!!this._checked}set checked(e){e!==this._checked&&(this._checked=e,this._onChecked.fire(e))}dispose(){this._onChecked.dispose()}}class x{get templateId(){return x.ID}renderTemplate(e){const t=Object.create(null);t.toDisposeElement=[],t.toDisposeTemplate=[],t.entry=n.append(e,y(".quick-input-list-entry"));const i=n.append(t.entry,y("label.quick-input-list-label"));t.toDisposeTemplate.push(n.addStandardDisposableListener(i,n.EventType.CLICK,(e=>{t.checkbox.offsetParent||e.preventDefault()}))),t.checkbox=n.append(i,y("input.quick-input-list-checkbox")),t.checkbox.type="checkbox",t.toDisposeTemplate.push(n.addStandardDisposableListener(t.checkbox,n.EventType.CHANGE,(e=>{t.element.checked=t.checkbox.checked})));const o=n.append(i,y(".quick-input-list-rows")),l=n.append(o,y(".quick-input-list-row")),c=n.append(o,y(".quick-input-list-row"));t.label=new s.IconLabel(l,{supportHighlights:!0,supportDescriptionHighlights:!0,supportIcons:!0});const d=n.append(l,y(".quick-input-list-entry-keybinding"));t.keybinding=new a.KeybindingLabel(d,f.OS);const u=n.append(c,y(".quick-input-list-label-meta"));return t.detail=new s.IconLabel(u,{supportHighlights:!0,supportIcons:!0}),t.separator=n.append(t.entry,y(".quick-input-list-separator")),t.actionBar=new r.ActionBar(t.entry),t.actionBar.domNode.classList.add("quick-input-list-entry-action-bar"),t.toDisposeTemplate.push(t.actionBar),t}renderElement(e,t,i){i.toDisposeElement=(0,m.dispose)(i.toDisposeElement),i.element=e,i.checkbox.checked=e.checked,i.toDisposeElement.push(e.onChecked((e=>i.checkbox.checked=e)));const{labelHighlights:n,descriptionHighlights:o,detailHighlights:r}=e,s=Object.create(null);s.matches=n||[],s.descriptionTitle=e.saneDescription,s.descriptionMatches=o||[],s.extraClasses=e.item.iconClasses,s.italic=e.item.italic,s.strikethrough=e.item.strikethrough,i.label.setLabel(e.saneLabel,e.saneDescription,s),i.keybinding.set(e.item.keybinding),e.saneDetail&&i.detail.setLabel(e.saneDetail,void 0,{matches:r,title:e.saneDetail}),e.separator&&e.separator.label?(i.separator.textContent=e.separator.label,i.separator.style.display=""):i.separator.style.display="none",i.entry.classList.toggle("quick-input-list-separator-border",!!e.separator),i.actionBar.clear();const a=e.item.buttons;a&&a.length?(i.actionBar.push(a.map(((t,i)=>{let n=t.iconClass||(t.iconPath?(0,A.getIconClass)(t.iconPath):void 0);t.alwaysVisible&&(n=n?`${n} always-visible`:"always-visible");const o=new l.Action(`id-${i}`,"",n,!0,(()=>w(this,void 0,void 0,(function*(){e.fireButtonTriggered({button:t,item:e.item})}))));return o.tooltip=t.tooltip||"",o})),{icon:!0,label:!1}),i.entry.classList.add("has-actions")):i.entry.classList.remove("has-actions")}disposeElement(e,t,i){i.toDisposeElement=(0,m.dispose)(i.toDisposeElement)}disposeTemplate(e){e.toDisposeElement=(0,m.dispose)(e.toDisposeElement),e.toDisposeTemplate=(0,m.dispose)(e.toDisposeTemplate)}}x.ID="listelement";class E{getHeight(e){return e.saneDetail?44:22}getTemplateId(e){return x.ID}}var k;!function(e){e[e.First=1]="First",e[e.Second=2]="Second",e[e.Last=3]="Last",e[e.Next=4]="Next",e[e.Previous=5]="Previous",e[e.NextPage=6]="NextPage",e[e.PreviousPage=7]="PreviousPage"}(k||(k={}));class I{constructor(e,t,i){this.parent=e,this.inputElements=[],this.elements=[],this.elementsToIndexes=new Map,this.matchOnDescription=!1,this.matchOnDetail=!1,this.matchOnLabel=!0,this.matchOnLabelMode="fuzzy",this.matchOnMeta=!0,this.sortByLabel=!0,this._onChangedAllVisibleChecked=new g.Emitter,this.onChangedAllVisibleChecked=this._onChangedAllVisibleChecked.event,this._onChangedCheckedCount=new g.Emitter,this.onChangedCheckedCount=this._onChangedCheckedCount.event,this._onChangedVisibleCount=new g.Emitter,this.onChangedVisibleCount=this._onChangedVisibleCount.event,this._onChangedCheckedElements=new g.Emitter,this.onChangedCheckedElements=this._onChangedCheckedElements.event,this._onButtonTriggered=new g.Emitter,this.onButtonTriggered=this._onButtonTriggered.event,this._onKeyDown=new g.Emitter,this.onKeyDown=this._onKeyDown.event,this._onLeave=new g.Emitter,this.onLeave=this._onLeave.event,this._fireCheckedEvents=!0,this.elementDisposables=[],this.disposables=[],this.id=t,this.container=n.append(this.parent,y(".quick-input-list"));const r=new E,s=new T;this.list=i.createList("QuickInput",this.container,r,[new x],{identityProvider:{getId:e=>e.saneLabel},setRowLineHeight:!1,multipleSelectionSupport:!1,horizontalScrolling:!1,accessibilityProvider:s}),this.list.getHTMLElement().id=t,this.disposables.push(this.list),this.disposables.push(this.list.onKeyDown((e=>{const t=new o.StandardKeyboardEvent(e);switch(t.keyCode){case 10:this.toggleCheckbox();break;case 31:(f.isMacintosh?e.metaKey:e.ctrlKey)&&this.list.setFocus((0,c.range)(this.list.length));break;case 16:{const e=this.list.getFocus();1===e.length&&0===e[0]&&this._onLeave.fire();break}case 18:{const e=this.list.getFocus();1===e.length&&e[0]===this.list.length-1&&this._onLeave.fire();break}}this._onKeyDown.fire(t)}))),this.disposables.push(this.list.onMouseDown((e=>{2!==e.browserEvent.button&&e.browserEvent.preventDefault()}))),this.disposables.push(n.addDisposableListener(this.container,n.EventType.CLICK,(e=>{(e.x||e.y)&&this._onLeave.fire()}))),this.disposables.push(this.list.onMouseMiddleClick((e=>{this._onLeave.fire()}))),this.disposables.push(this.list.onContextMenu((e=>{"number"==typeof e.index&&(e.browserEvent.preventDefault(),this.list.setSelection([e.index]))}))),this.disposables.push(this._onChangedAllVisibleChecked,this._onChangedCheckedCount,this._onChangedVisibleCount,this._onChangedCheckedElements,this._onButtonTriggered,this._onLeave,this._onKeyDown)}get onDidChangeFocus(){return g.Event.map(this.list.onDidChangeFocus,(e=>e.elements.map((e=>e.item))))}get onDidChangeSelection(){return g.Event.map(this.list.onDidChangeSelection,(e=>({items:e.elements.map((e=>e.item)),event:e.browserEvent})))}get scrollTop(){return this.list.scrollTop}set scrollTop(e){this.list.scrollTop=e}getAllVisibleChecked(){return this.allVisibleChecked(this.elements,!1)}allVisibleChecked(e,t=!0){for(let i=0,n=e.length;i<n;i++){const n=e[i];if(!n.hidden){if(!n.checked)return!1;t=!0}}return t}getCheckedCount(){let e=0;const t=this.elements;for(let i=0,n=t.length;i<n;i++)t[i].checked&&e++;return e}getVisibleCount(){let e=0;const t=this.elements;for(let i=0,n=t.length;i<n;i++)t[i].hidden||e++;return e}setAllVisibleChecked(e){try{this._fireCheckedEvents=!1,this.elements.forEach((t=>{t.hidden||(t.checked=e)}))}finally{this._fireCheckedEvents=!0,this.fireCheckedEvents()}}setElements(e){this.elementDisposables=(0,m.dispose)(this.elementDisposables);const t=e=>this.fireButtonTriggered(e);this.inputElements=e,this.elements=e.reduce(((i,n,o)=>{var r,s,a;if("separator"!==n.type){const l=o&&e[o-1],c=n.label&&n.label.replace(/\r?\n/g," "),u=(0,p.parseLabelWithIcons)(c).text.trim(),h=n.meta&&n.meta.replace(/\r?\n/g," "),g=n.description&&n.description.replace(/\r?\n/g," "),m=n.detail&&n.detail.replace(/\r?\n/g," "),f=n.ariaLabel||[c,g,m].map((e=>(0,d.getCodiconAriaLabel)(e))).filter((e=>!!e)).join(", "),b=this.parent.classList.contains("show-checkboxes");i.push(new S({hasCheckbox:b,index:o,item:n,saneLabel:c,saneSortLabel:u,saneMeta:h,saneAriaLabel:f,saneDescription:g,saneDetail:m,labelHighlights:null===(r=n.highlights)||void 0===r?void 0:r.label,descriptionHighlights:null===(s=n.highlights)||void 0===s?void 0:s.description,detailHighlights:null===(a=n.highlights)||void 0===a?void 0:a.detail,checked:!1,separator:l&&"separator"===l.type?l:void 0,fireButtonTriggered:t}))}return i}),[]),this.elementDisposables.push(...this.elements),this.elementDisposables.push(...this.elements.map((e=>e.onChecked((()=>this.fireCheckedEvents()))))),this.elementsToIndexes=this.elements.reduce(((e,t,i)=>(e.set(t.item,i),e)),new Map),this.list.splice(0,this.list.length),this.list.splice(0,this.list.length,this.elements),this._onChangedVisibleCount.fire(this.elements.length)}getFocusedElements(){return this.list.getFocusedElements().map((e=>e.item))}setFocusedElements(e){if(this.list.setFocus(e.filter((e=>this.elementsToIndexes.has(e))).map((e=>this.elementsToIndexes.get(e)))),e.length>0){const e=this.list.getFocus()[0];"number"==typeof e&&this.list.reveal(e)}}getActiveDescendant(){return this.list.getHTMLElement().getAttribute("aria-activedescendant")}setSelectedElements(e){this.list.setSelection(e.filter((e=>this.elementsToIndexes.has(e))).map((e=>this.elementsToIndexes.get(e))))}getCheckedElements(){return this.elements.filter((e=>e.checked)).map((e=>e.item))}setCheckedElements(e){try{this._fireCheckedEvents=!1;const t=new Set;for(const i of e)t.add(i);for(const e of this.elements)e.checked=t.has(e.item)}finally{this._fireCheckedEvents=!0,this.fireCheckedEvents()}}set enabled(e){this.list.getHTMLElement().style.pointerEvents=e?"":"none"}focus(e){if(!this.list.length)return;switch(e===k.Next&&this.list.getFocus()[0]===this.list.length-1&&(e=k.First),e===k.Previous&&0===this.list.getFocus()[0]&&(e=k.Last),e===k.Second&&this.list.length<2&&(e=k.First),e){case k.First:this.list.focusFirst();break;case k.Second:this.list.focusNth(1);break;case k.Last:this.list.focusLast();break;case k.Next:this.list.focusNext();break;case k.Previous:this.list.focusPrevious();break;case k.NextPage:this.list.focusNextPage();break;case k.PreviousPage:this.list.focusPreviousPage()}const t=this.list.getFocus()[0];"number"==typeof t&&this.list.reveal(t)}clearFocus(){this.list.setFocus([])}domFocus(){this.list.domFocus()}layout(e){this.list.getHTMLElement().style.maxHeight=e?`calc(${44*Math.floor(e/44)}px)`:"",this.list.layout()}filter(e){if(!(this.sortByLabel||this.matchOnLabel||this.matchOnDescription||this.matchOnDetail))return this.list.layout(),!1;const t=e;if((e=e.trim())&&(this.matchOnLabel||this.matchOnDescription||this.matchOnDetail)){let i;this.elements.forEach((n=>{let o;o="fuzzy"===this.matchOnLabelMode?this.matchOnLabel?(0,_.withNullAsUndefined)((0,p.matchesFuzzyIconAware)(e,(0,p.parseLabelWithIcons)(n.saneLabel))):void 0:this.matchOnLabel?(0,_.withNullAsUndefined)(D(t,(0,p.parseLabelWithIcons)(n.saneLabel))):void 0;const r=this.matchOnDescription?(0,_.withNullAsUndefined)((0,p.matchesFuzzyIconAware)(e,(0,p.parseLabelWithIcons)(n.saneDescription||""))):void 0,s=this.matchOnDetail?(0,_.withNullAsUndefined)((0,p.matchesFuzzyIconAware)(e,(0,p.parseLabelWithIcons)(n.saneDetail||""))):void 0,a=this.matchOnMeta?(0,_.withNullAsUndefined)((0,p.matchesFuzzyIconAware)(e,(0,p.parseLabelWithIcons)(n.saneMeta||""))):void 0;if(o||r||s||a?(n.labelHighlights=o,n.descriptionHighlights=r,n.detailHighlights=s,n.hidden=!1):(n.labelHighlights=void 0,n.descriptionHighlights=void 0,n.detailHighlights=void 0,n.hidden=!n.item.alwaysShow),n.separator=void 0,!this.sortByLabel){const e=n.index&&this.inputElements[n.index-1];i=e&&"separator"===e.type?e:i,i&&!n.hidden&&(n.separator=i,i=void 0)}}))}else this.elements.forEach((e=>{e.labelHighlights=void 0,e.descriptionHighlights=void 0,e.detailHighlights=void 0,e.hidden=!1;const t=e.index&&this.inputElements[e.index-1];e.separator=t&&"separator"===t.type?t:void 0}));const i=this.elements.filter((e=>!e.hidden));if(this.sortByLabel&&e){const t=e.toLowerCase();i.sort(((e,i)=>function(e,t,i){const n=e.labelHighlights||[],o=t.labelHighlights||[];if(n.length&&!o.length)return-1;if(!n.length&&o.length)return 1;if(0===n.length&&0===o.length)return 0;return(0,u.compareAnything)(e.saneSortLabel,t.saneSortLabel,i)}(e,i,t)))}return this.elementsToIndexes=i.reduce(((e,t,i)=>(e.set(t.item,i),e)),new Map),this.list.splice(0,this.list.length,i),this.list.setFocus([]),this.list.layout(),this._onChangedAllVisibleChecked.fire(this.getAllVisibleChecked()),this._onChangedVisibleCount.fire(i.length),!0}toggleCheckbox(){try{this._fireCheckedEvents=!1;const e=this.list.getFocusedElements(),t=this.allVisibleChecked(e);for(const i of e)i.checked=!t}finally{this._fireCheckedEvents=!0,this.fireCheckedEvents()}}display(e){this.container.style.display=e?"":"none"}isDisplayed(){return"none"!==this.container.style.display}dispose(){this.elementDisposables=(0,m.dispose)(this.elementDisposables),this.disposables=(0,m.dispose)(this.disposables)}fireCheckedEvents(){this._fireCheckedEvents&&(this._onChangedAllVisibleChecked.fire(this.getAllVisibleChecked()),this._onChangedCheckedCount.fire(this.getCheckedCount()),this._onChangedCheckedElements.fire(this.getCheckedElements()))}fireButtonTriggered(e){this._onButtonTriggered.fire(e)}style(e){this.list.style(e)}}function D(e,t){const{text:i,iconOffsets:n}=t;if(!n||0===n.length)return L(e,i);const o=(0,b.ltrim)(i," "),r=i.length-o.length,s=L(e,o);if(s)for(const e of s){const t=n[e.start+r]+r;e.start+=t,e.end+=t}return s}function L(e,t){const i=t.toLowerCase().indexOf(e.toLowerCase());return-1!==i?[{start:i,end:i+e.length}]:null}C([h.memoize],I.prototype,"onDidChangeFocus",null),C([h.memoize],I.prototype,"onDidChangeSelection",null);class T{getWidgetAriaLabel(){return(0,v.localize)("vs/base/parts/quickinput/browser/quickInputList","quickInput","Quick Input")}getAriaLabel(e){var t;return(null===(t=e.separator)||void 0===t?void 0:t.label)?`${e.saneAriaLabel}, ${e.separator.label}`:e.saneAriaLabel}getWidgetRole(){return"listbox"}getRole(e){return e.hasCheckbox?"checkbox":"option"}isChecked(e){if(e.hasCheckbox)return{value:e.checked,onDidChange:e.onChecked}}}},2926:function(e,t,i){"use strict";i.r(t),i.d(t,{getIconClass:function(){return a}});var n=i(96747),o=i(60538);i(67027);const r={},s=new o.IdGenerator("quick-input-button-icon-");function a(e){if(!e)return;let t;const i=e.dark.toString();return r[i]?t=r[i]:(t=s.nextId(),n.createCSSRule(`.${t}, .hc-light .${t}`,`background-image: ${n.asCSSUrl(e.light||e.dark)}`),n.createCSSRule(`.vs-dark .${t}, .hc-black .${t}`,`background-image: ${n.asCSSUrl(e.dark)}`),r[i]=t),t}},11476:function(e,t,i){"use strict";i.r(t),i.d(t,{ItemActivation:function(){return r},NO_KEY_MODS:function(){return n},QuickInputHideReason:function(){return o},QuickPickItemScorerAccessor:function(){return s},quickPickItemScorerAccessor:function(){return a}});const n={ctrlCmd:!1,alt:!1};var o,r;!function(e){e[e.Blur=1]="Blur",e[e.Gesture=2]="Gesture",e[e.Other=3]="Other"}(o||(o={})),function(e){e[e.NONE=0]="NONE",e[e.FIRST=1]="FIRST",e[e.SECOND=2]="SECOND",e[e.LAST=3]="LAST"}(r||(r={}));class s{constructor(e){this.options=e}}const a=new s},14778:function(e,t,i){"use strict";i.r(t),i.d(t,{InMemoryStorageDatabase:function(){return d},Storage:function(){return c},StorageState:function(){return n}});var n,o=i(66129),r=i(63801),s=i(68921),a=i(18912),l=function(e,t,i,n){return new(i||(i=Promise))((function(o,r){function s(e){try{l(n.next(e))}catch(e){r(e)}}function a(e){try{l(n.throw(e))}catch(e){r(e)}}function l(e){var t;e.done?o(e.value):(t=e.value,t instanceof i?t:new i((function(e){e(t)}))).then(s,a)}l((n=n.apply(e,t||[])).next())}))};!function(e){e[e.None=0]="None",e[e.Initialized=1]="Initialized",e[e.Closed=2]="Closed"}(n||(n={}));class c extends s.Disposable{constructor(e,t=Object.create(null)){super(),this.database=e,this.options=t,this._onDidChangeStorage=this._register(new r.Emitter),this.onDidChangeStorage=this._onDidChangeStorage.event,this.state=n.None,this.cache=new Map,this.flushDelayer=new o.ThrottledDelayer(c.DEFAULT_FLUSH_DELAY),this.pendingDeletes=new Set,this.pendingInserts=new Map,this.whenFlushedCallbacks=[],this.registerListeners()}registerListeners(){this._register(this.database.onDidChangeItemsExternal((e=>this.onDidChangeItemsExternal(e))))}onDidChangeItemsExternal(e){var t,i;null===(t=e.changed)||void 0===t||t.forEach(((e,t)=>this.accept(t,e))),null===(i=e.deleted)||void 0===i||i.forEach((e=>this.accept(e,void 0)))}accept(e,t){if(this.state===n.Closed)return;let i=!1;if((0,a.isUndefinedOrNull)(t))i=this.cache.delete(e);else{this.cache.get(e)!==t&&(this.cache.set(e,t),i=!0)}i&&this._onDidChangeStorage.fire(e)}get(e,t){const i=this.cache.get(e);return(0,a.isUndefinedOrNull)(i)?t:i}getBoolean(e,t){const i=this.get(e);return(0,a.isUndefinedOrNull)(i)?t:"true"===i}getNumber(e,t){const i=this.get(e);return(0,a.isUndefinedOrNull)(i)?t:parseInt(i,10)}set(e,t){return l(this,void 0,void 0,(function*(){if(this.state===n.Closed)return;if((0,a.isUndefinedOrNull)(t))return this.delete(e);const i=String(t);return this.cache.get(e)!==i?(this.cache.set(e,i),this.pendingInserts.set(e,i),this.pendingDeletes.delete(e),this._onDidChangeStorage.fire(e),this.doFlush()):void 0}))}delete(e){return l(this,void 0,void 0,(function*(){if(this.state===n.Closed)return;return this.cache.delete(e)?(this.pendingDeletes.has(e)||this.pendingDeletes.add(e),this.pendingInserts.delete(e),this._onDidChangeStorage.fire(e),this.doFlush()):void 0}))}get hasPending(){return this.pendingInserts.size>0||this.pendingDeletes.size>0}flushPending(){return l(this,void 0,void 0,(function*(){if(!this.hasPending)return;const e={insert:this.pendingInserts,delete:this.pendingDeletes};return this.pendingDeletes=new Set,this.pendingInserts=new Map,this.database.updateItems(e).finally((()=>{var e;if(!this.hasPending)for(;this.whenFlushedCallbacks.length;)null===(e=this.whenFlushedCallbacks.pop())||void 0===e||e()}))}))}doFlush(e){return l(this,void 0,void 0,(function*(){return this.flushDelayer.trigger((()=>this.flushPending()),e)}))}dispose(){this.flushDelayer.dispose(),super.dispose()}}c.DEFAULT_FLUSH_DELAY=100;class d{constructor(){this.onDidChangeItemsExternal=r.Event.None,this.items=new Map}updateItems(e){var t,i;return l(this,void 0,void 0,(function*(){null===(t=e.insert)||void 0===t||t.forEach(((e,t)=>this.items.set(t,e))),null===(i=e.delete)||void 0===i||i.forEach((e=>this.items.delete(e)))}))}}},97365:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return n},language:function(){return o}});
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
var n={comments:{lineComment:"*"},brackets:[["[","]"],["(",")"]]},o={defaultToken:"invalid",ignoreCase:!0,tokenPostfix:".abap",keywords:["abap-source","abbreviated","abstract","accept","accepting","according","activation","actual","add","add-corresponding","adjacent","after","alias","aliases","align","all","allocate","alpha","analysis","analyzer","and","append","appendage","appending","application","archive","area","arithmetic","as","ascending","aspect","assert","assign","assigned","assigning","association","asynchronous","at","attributes","authority","authority-check","avg","back","background","backup","backward","badi","base","before","begin","between","big","binary","bintohex","bit","black","blank","blanks","blob","block","blocks","blue","bound","boundaries","bounds","boxed","break-point","buffer","by","bypassing","byte","byte-order","call","calling","case","cast","casting","catch","center","centered","chain","chain-input","chain-request","change","changing","channels","character","char-to-hex","check","checkbox","ci_","circular","class","class-coding","class-data","class-events","class-methods","class-pool","cleanup","clear","client","clob","clock","close","coalesce","code","coding","col_background","col_group","col_heading","col_key","col_negative","col_normal","col_positive","col_total","collect","color","column","columns","comment","comments","commit","common","communication","comparing","component","components","compression","compute","concat","concat_with_space","concatenate","cond","condense","condition","connect","connection","constants","context","contexts","continue","control","controls","conv","conversion","convert","copies","copy","corresponding","country","cover","cpi","create","creating","critical","currency","currency_conversion","current","cursor","cursor-selection","customer","customer-function","dangerous","data","database","datainfo","dataset","date","dats_add_days","dats_add_months","dats_days_between","dats_is_valid","daylight","dd/mm/yy","dd/mm/yyyy","ddmmyy","deallocate","decimal_shift","decimals","declarations","deep","default","deferred","define","defining","definition","delete","deleting","demand","department","descending","describe","destination","detail","dialog","directory","disconnect","display","display-mode","distinct","divide","divide-corresponding","division","do","dummy","duplicate","duplicates","duration","during","dynamic","dynpro","edit","editor-call","else","elseif","empty","enabled","enabling","encoding","end","endat","endcase","endcatch","endchain","endclass","enddo","endenhancement","end-enhancement-section","endexec","endform","endfunction","endian","endif","ending","endinterface","end-lines","endloop","endmethod","endmodule","end-of-definition","end-of-editing","end-of-file","end-of-page","end-of-selection","endon","endprovide","endselect","end-test-injection","end-test-seam","endtry","endwhile","endwith","engineering","enhancement","enhancement-point","enhancements","enhancement-section","entries","entry","enum","environment","equiv","errormessage","errors","escaping","event","events","exact","except","exception","exceptions","exception-table","exclude","excluding","exec","execute","exists","exit","exit-command","expand","expanding","expiration","explicit","exponent","export","exporting","extend","extended","extension","extract","fail","fetch","field","field-groups","fields","field-symbol","field-symbols","file","filter","filters","filter-table","final","find","first","first-line","fixed-point","fkeq","fkge","flush","font","for","form","format","forward","found","frame","frames","free","friends","from","function","functionality","function-pool","further","gaps","generate","get","giving","gkeq","gkge","global","grant","green","group","groups","handle","handler","harmless","hashed","having","hdb","header","headers","heading","head-lines","help-id","help-request","hextobin","hide","high","hint","hold","hotspot","icon","id","identification","identifier","ids","if","ignore","ignoring","immediately","implementation","implementations","implemented","implicit","import","importing","in","inactive","incl","include","includes","including","increment","index","index-line","infotypes","inheriting","init","initial","initialization","inner","inout","input","insert","instance","instances","instr","intensified","interface","interface-pool","interfaces","internal","intervals","into","inverse","inverted-date","is","iso","job","join","keep","keeping","kernel","key","keys","keywords","kind","language","last","late","layout","leading","leave","left","left-justified","leftplus","leftspace","legacy","length","let","level","levels","like","line","lines","line-count","linefeed","line-selection","line-size","list","listbox","list-processing","little","llang","load","load-of-program","lob","local","locale","locator","logfile","logical","log-point","long","loop","low","lower","lpad","lpi","ltrim","mail","main","major-id","mapping","margin","mark","mask","match","matchcode","max","maximum","medium","members","memory","mesh","message","message-id","messages","messaging","method","methods","min","minimum","minor-id","mm/dd/yy","mm/dd/yyyy","mmddyy","mode","modif","modifier","modify","module","move","move-corresponding","multiply","multiply-corresponding","name","nametab","native","nested","nesting","new","new-line","new-page","new-section","next","no","no-display","no-extension","no-gap","no-gaps","no-grouping","no-heading","no-scrolling","no-sign","no-title","no-topofpage","no-zero","node","nodes","non-unicode","non-unique","not","null","number","object","objects","obligatory","occurrence","occurrences","occurs","of","off","offset","ole","on","only","open","option","optional","options","or","order","other","others","out","outer","output","output-length","overflow","overlay","pack","package","pad","padding","page","pages","parameter","parameters","parameter-table","part","partially","pattern","percentage","perform","performing","person","pf1","pf10","pf11","pf12","pf13","pf14","pf15","pf2","pf3","pf4","pf5","pf6","pf7","pf8","pf9","pf-status","pink","places","pool","pos_high","pos_low","position","pragmas","precompiled","preferred","preserving","primary","print","print-control","priority","private","procedure","process","program","property","protected","provide","public","push","pushbutton","put","queue-only","quickinfo","radiobutton","raise","raising","range","ranges","read","reader","read-only","receive","received","receiver","receiving","red","redefinition","reduce","reduced","ref","reference","refresh","regex","reject","remote","renaming","replace","replacement","replacing","report","request","requested","reserve","reset","resolution","respecting","responsible","result","results","resumable","resume","retry","return","returncode","returning","returns","right","right-justified","rightplus","rightspace","risk","rmc_communication_failure","rmc_invalid_status","rmc_system_failure","role","rollback","rows","rpad","rtrim","run","sap","sap-spool","saving","scale_preserving","scale_preserving_scientific","scan","scientific","scientific_with_leading_zero","scroll","scroll-boundary","scrolling","search","secondary","seconds","section","select","selection","selections","selection-screen","selection-set","selection-sets","selection-table","select-options","send","separate","separated","set","shared","shift","short","shortdump-id","sign_as_postfix","single","size","skip","skipping","smart","some","sort","sortable","sorted","source","specified","split","spool","spots","sql","sqlscript","stable","stamp","standard","starting","start-of-editing","start-of-selection","state","statement","statements","static","statics","statusinfo","step-loop","stop","structure","structures","style","subkey","submatches","submit","subroutine","subscreen","subtract","subtract-corresponding","suffix","sum","summary","summing","supplied","supply","suppress","switch","switchstates","symbol","syncpoints","syntax","syntax-check","syntax-trace","system-call","system-exceptions","system-exit","tab","tabbed","table","tables","tableview","tabstrip","target","task","tasks","test","testing","test-injection","test-seam","text","textpool","then","throw","time","times","timestamp","timezone","tims_is_valid","title","titlebar","title-lines","to","tokenization","tokens","top-lines","top-of-page","trace-file","trace-table","trailing","transaction","transfer","transformation","translate","transporting","trmac","truncate","truncation","try","tstmp_add_seconds","tstmp_current_utctimestamp","tstmp_is_valid","tstmp_seconds_between","type","type-pool","type-pools","types","uline","unassign","under","unicode","union","unique","unit_conversion","unix","unpack","until","unwind","up","update","upper","user","user-command","using","utf-8","valid","value","value-request","values","vary","varying","verification-message","version","via","view","visible","wait","warning","when","whenever","where","while","width","window","windows","with","with-heading","without","with-title","word","work","write","writer","xml","xsd","yellow","yes","yymmdd","zero","zone","abap_system_timezone","abap_user_timezone","access","action","adabas","adjust_numbers","allow_precision_loss","allowed","amdp","applicationuser","as_geo_json","as400","associations","balance","behavior","breakup","bulk","cds","cds_client","check_before_save","child","clients","corr","corr_spearman","cross","cycles","datn_add_days","datn_add_months","datn_days_between","dats_from_datn","dats_tims_to_tstmp","dats_to_datn","db2","db6","ddl","dense_rank","depth","deterministic","discarding","entities","entity","error","failed","finalize","first_value","fltp_to_dec","following","fractional","full","graph","grouping","hierarchy","hierarchy_ancestors","hierarchy_ancestors_aggregate","hierarchy_descendants","hierarchy_descendants_aggregate","hierarchy_siblings","incremental","indicators","lag","last_value","lead","leaves","like_regexpr","link","locale_sap","lock","locks","many","mapped","matched","measures","median","mssqlnt","multiple","nodetype","ntile","nulls","occurrences_regexpr","one","operations","oracle","orphans","over","parent","parents","partition","pcre","period","pfcg_mapping","preceding","privileged","product","projection","rank","redirected","replace_regexpr","reported","response","responses","root","row","row_number","sap_system_date","save","schema","session","sets","shortdump","siblings","spantree","start","stddev","string_agg","subtotal","sybase","tims_from_timn","tims_to_timn","to_blob","to_clob","total","trace-entry","tstmp_to_dats","tstmp_to_dst","tstmp_to_tims","tstmpl_from_utcl","tstmpl_to_utcl","unbounded","utcl_add_seconds","utcl_current","utcl_seconds_between","uuid","var","verbatim"],builtinFunctions:["abs","acos","asin","atan","bit-set","boolc","boolx","ceil","char_off","charlen","cmax","cmin","concat_lines_of","contains","contains_any_not_of","contains_any_of","cos","cosh","count","count_any_not_of","count_any_of","dbmaxlen","distance","escape","exp","find_any_not_of","find_any_of","find_end","floor","frac","from_mixed","ipow","line_exists","line_index","log","log10","matches","nmax","nmin","numofchar","repeat","rescale","reverse","round","segment","shift_left","shift_right","sign","sin","sinh","sqrt","strlen","substring","substring_after","substring_before","substring_from","substring_to","tan","tanh","to_lower","to_mixed","to_upper","trunc","utclong_add","utclong_current","utclong_diff","xsdbool","xstrlen"],typeKeywords:["b","c","d","decfloat16","decfloat34","f","i","int8","n","p","s","string","t","utclong","x","xstring","any","clike","csequence","decfloat","numeric","simple","xsequence","accp","char","clnt","cuky","curr","datn","dats","d16d","d16n","d16r","d34d","d34n","d34r","dec","df16_dec","df16_raw","df34_dec","df34_raw","fltp","geom_ewkb","int1","int2","int4","lang","lchr","lraw","numc","quan","raw","rawstring","sstring","timn","tims","unit","utcl","df16_scl","df34_scl","prec","varc","abap_bool","abap_false","abap_true","abap_undefined","me","screen","space","super","sy","syst","table_line","*sys*"],builtinMethods:["class_constructor","constructor"],derivedTypes:["%CID","%CID_REF","%CONTROL","%DATA","%ELEMENT","%FAIL","%KEY","%MSG","%PARAM","%PID","%PID_ASSOC","%PID_PARENT","%_HINTS"],cdsLanguage:["@AbapAnnotation","@AbapCatalog","@AccessControl","@API","@ClientDependent","@ClientHandling","@CompatibilityContract","@DataAging","@EndUserText","@Environment","@LanguageDependency","@MappingRole","@Metadata","@MetadataExtension","@ObjectModel","@Scope","@Semantics","$EXTENSION","$SELF"],selectors:["->","->*","=>","~","~*"],operators:[" +"," -","/","*","**","div","mod","=","#","@","+=","-=","*=","/=","**=","&&=","?=","&","&&","bit-and","bit-not","bit-or","bit-xor","m","o","z","<"," >","<=",">=","<>","><","=<","=>","bt","byte-ca","byte-cn","byte-co","byte-cs","byte-na","byte-ns","ca","cn","co","cp","cs","eq","ge","gt","le","lt","na","nb","ne","np","ns","*/","*:","--","/*","//"],symbols:/[=><!~?&+\-*\/\^%#@]+/,tokenizer:{root:[[/[a-z_\/$%@]([\w\/$%]|-(?!>))*/,{cases:{"@typeKeywords":"type","@keywords":"keyword","@cdsLanguage":"annotation","@derivedTypes":"type","@builtinFunctions":"type","@builtinMethods":"type","@operators":"key","@default":"identifier"}}],[/<[\w]+>/,"identifier"],[/##[\w|_]+/,"comment"],{include:"@whitespace"},[/[:,.]/,"delimiter"],[/[{}()\[\]]/,"@brackets"],[/@symbols/,{cases:{"@selectors":"tag","@operators":"key","@default":""}}],[/'/,{token:"string",bracket:"@open",next:"@stringquote"}],[/`/,{token:"string",bracket:"@open",next:"@stringping"}],[/\|/,{token:"string",bracket:"@open",next:"@stringtemplate"}],[/\d+/,"number"]],stringtemplate:[[/[^\\\|]+/,"string"],[/\\\|/,"string"],[/\|/,{token:"string",bracket:"@close",next:"@pop"}]],stringping:[[/[^\\`]+/,"string"],[/`/,{token:"string",bracket:"@close",next:"@pop"}]],stringquote:[[/[^\\']+/,"string"],[/'/,{token:"string",bracket:"@close",next:"@pop"}]],whitespace:[[/[ \t\r\n]+/,""],[/^\*.*$/,"comment"],[/\".*$/,"comment"]]}}},81294:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return n},language:function(){return r}});
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
var n={wordPattern:/(-?\d*\.\d\w*)|([^\`\~\!\#\%\^\&\*\(\)\-\=\+\[\{\]\}\\\|\;\:\'\"\,\.\<\>\/\?\s]+)/g,comments:{lineComment:"//",blockComment:["/*","*/"]},brackets:[["{","}"],["[","]"],["(",")"]],autoClosingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"'},{open:"'",close:"'"}],surroundingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"'},{open:"'",close:"'"},{open:"<",close:">"}],folding:{markers:{start:new RegExp("^\\s*//\\s*(?:(?:#?region\\b)|(?:<editor-fold\\b))"),end:new RegExp("^\\s*//\\s*(?:(?:#?endregion\\b)|(?:</editor-fold>))")}}},o=[];["abstract","activate","and","any","array","as","asc","assert","autonomous","begin","bigdecimal","blob","boolean","break","bulk","by","case","cast","catch","char","class","collect","commit","const","continue","convertcurrency","decimal","default","delete","desc","do","double","else","end","enum","exception","exit","export","extends","false","final","finally","float","for","from","future","get","global","goto","group","having","hint","if","implements","import","in","inner","insert","instanceof","int","interface","into","join","last_90_days","last_month","last_n_days","last_week","like","limit","list","long","loop","map","merge","native","new","next_90_days","next_month","next_n_days","next_week","not","null","nulls","number","object","of","on","or","outer","override","package","parallel","pragma","private","protected","public","retrieve","return","returning","rollback","savepoint","search","select","set","short","sort","stat","static","strictfp","super","switch","synchronized","system","testmethod","then","this","this_month","this_week","throw","throws","today","tolabel","tomorrow","transaction","transient","trigger","true","try","type","undelete","update","upsert","using","virtual","void","volatile","webservice","when","where","while","yesterday"].forEach((e=>{o.push(e),o.push(e.toUpperCase()),o.push((e=>e.charAt(0).toUpperCase()+e.substr(1))(e))}));var r={defaultToken:"",tokenPostfix:".apex",keywords:o,operators:["=",">","<","!","~","?",":","==","<=",">=","!=","&&","||","++","--","+","-","*","/","&","|","^","%","<<",">>",">>>","+=","-=","*=","/=","&=","|=","^=","%=","<<=",">>=",">>>="],symbols:/[=><!~?:&|+\-*\/\^%]+/,escapes:/\\(?:[abfnrtv\\"']|x[0-9A-Fa-f]{1,4}|u[0-9A-Fa-f]{4}|U[0-9A-Fa-f]{8})/,digits:/\d+(_+\d+)*/,octaldigits:/[0-7]+(_+[0-7]+)*/,binarydigits:/[0-1]+(_+[0-1]+)*/,hexdigits:/[[0-9a-fA-F]+(_+[0-9a-fA-F]+)*/,tokenizer:{root:[[/[a-z_$][\w$]*/,{cases:{"@keywords":{token:"keyword.$0"},"@default":"identifier"}}],[/[A-Z][\w\$]*/,{cases:{"@keywords":{token:"keyword.$0"},"@default":"type.identifier"}}],{include:"@whitespace"},[/[{}()\[\]]/,"@brackets"],[/[<>](?!@symbols)/,"@brackets"],[/@symbols/,{cases:{"@operators":"delimiter","@default":""}}],[/@\s*[a-zA-Z_\$][\w\$]*/,"annotation"],[/(@digits)[eE]([\-+]?(@digits))?[fFdD]?/,"number.float"],[/(@digits)\.(@digits)([eE][\-+]?(@digits))?[fFdD]?/,"number.float"],[/(@digits)[fFdD]/,"number.float"],[/(@digits)[lL]?/,"number"],[/[;,.]/,"delimiter"],[/"([^"\\]|\\.)*$/,"string.invalid"],[/'([^'\\]|\\.)*$/,"string.invalid"],[/"/,"string",'@string."'],[/'/,"string","@string.'"],[/'[^\\']'/,"string"],[/(')(@escapes)(')/,["string","string.escape","string"]],[/'/,"string.invalid"]],whitespace:[[/[ \t\r\n]+/,""],[/\/\*\*(?!\/)/,"comment.doc","@apexdoc"],[/\/\*/,"comment","@comment"],[/\/\/.*$/,"comment"]],comment:[[/[^\/*]+/,"comment"],[/\*\//,"comment","@pop"],[/[\/*]/,"comment"]],apexdoc:[[/[^\/*]+/,"comment.doc"],[/\*\//,"comment.doc","@pop"],[/[\/*]/,"comment.doc"]],string:[[/[^\\"']+/,"string"],[/@escapes/,"string.escape"],[/\\./,"string.escape.invalid"],[/["']/,{cases:{"$#==$S2":{token:"string",next:"@pop"},"@default":"string"}}]]}}},64343:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return n},language:function(){return o}});
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
var n={comments:{lineComment:"#"}},o={defaultToken:"keyword",ignoreCase:!0,tokenPostfix:".azcli",str:/[^#\s]/,tokenizer:{root:[{include:"@comment"},[/\s-+@str*\s*/,{cases:{"@eos":{token:"key.identifier",next:"@popall"},"@default":{token:"key.identifier",next:"@type"}}}],[/^-+@str*\s*/,{cases:{"@eos":{token:"key.identifier",next:"@popall"},"@default":{token:"key.identifier",next:"@type"}}}]],type:[{include:"@comment"},[/-+@str*\s*/,{cases:{"@eos":{token:"key.identifier",next:"@popall"},"@default":"key.identifier"}}],[/@str+\s*/,{cases:{"@eos":{token:"string",next:"@popall"},"@default":"string"}}]],comment:[[/#.*$/,{cases:{"@eos":{token:"comment",next:"@popall"}}}]]}}},42479:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return n},language:function(){return o}});
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
var n={comments:{lineComment:"REM"},brackets:[["{","}"],["[","]"],["(",")"]],autoClosingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"'}],surroundingPairs:[{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"'}],folding:{markers:{start:new RegExp("^\\s*(::\\s*|REM\\s+)#region"),end:new RegExp("^\\s*(::\\s*|REM\\s+)#endregion")}}},o={defaultToken:"",ignoreCase:!0,tokenPostfix:".bat",brackets:[{token:"delimiter.bracket",open:"{",close:"}"},{token:"delimiter.parenthesis",open:"(",close:")"},{token:"delimiter.square",open:"[",close:"]"}],keywords:/call|defined|echo|errorlevel|exist|for|goto|if|pause|set|shift|start|title|not|pushd|popd/,symbols:/[=><!~?&|+\-*\/\^;\.,]+/,escapes:/\\(?:[abfnrtv\\"']|x[0-9A-Fa-f]{1,4}|u[0-9A-Fa-f]{4}|U[0-9A-Fa-f]{8})/,tokenizer:{root:[[/^(\s*)(rem(?:\s.*|))$/,["","comment"]],[/(\@?)(@keywords)(?!\w)/,[{token:"keyword"},{token:"keyword.$2"}]],[/[ \t\r\n]+/,""],[/setlocal(?!\w)/,"keyword.tag-setlocal"],[/endlocal(?!\w)/,"keyword.tag-setlocal"],[/[a-zA-Z_]\w*/,""],[/:\w*/,"metatag"],[/%[^%]+%/,"variable"],[/%%[\w]+(?!\w)/,"variable"],[/[{}()\[\]]/,"@brackets"],[/@symbols/,"delimiter"],[/\d*\.\d+([eE][\-+]?\d+)?/,"number.float"],[/0[xX][0-9a-fA-F_]*[0-9a-fA-F]/,"number.hex"],[/\d+/,"number"],[/[;,.]/,"delimiter"],[/"/,"string",'@string."'],[/'/,"string","@string.'"]],string:[[/[^\\"'%]+/,{cases:{"@eos":{token:"string",next:"@popall"},"@default":"string"}}],[/@escapes/,"string.escape"],[/\\./,"string.escape.invalid"],[/%[\w ]+%/,"variable"],[/%%[\w]+(?!\w)/,"variable"],[/["']/,{cases:{"$#==$S2":{token:"string",next:"@pop"},"@default":"string"}}],[/$/,"string","@popall"]]}}},80767:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return o},language:function(){return r}});
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
var n=`\\b${"[_a-zA-Z][_a-zA-Z0-9]*"}\\b`,o={comments:{lineComment:"//",blockComment:["/*","*/"]},brackets:[["{","}"],["[","]"],["(",")"]],surroundingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:"'",close:"'"},{open:"'''",close:"'''"}],autoClosingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:"'",close:"'",notIn:["string","comment"]},{open:"'''",close:"'''",notIn:["string","comment"]}],autoCloseBefore:":.,=}])' \n\t",indentationRules:{increaseIndentPattern:new RegExp("^((?!\\/\\/).)*(\\{[^}\"'`]*|\\([^)\"'`]*|\\[[^\\]\"'`]*)$"),decreaseIndentPattern:new RegExp("^((?!.*?\\/\\*).*\\*/)?\\s*[\\}\\]].*$")}},r={defaultToken:"",tokenPostfix:".bicep",brackets:[{open:"{",close:"}",token:"delimiter.curly"},{open:"[",close:"]",token:"delimiter.square"},{open:"(",close:")",token:"delimiter.parenthesis"}],symbols:/[=><!~?:&|+\-*/^%]+/,keywords:["targetScope","resource","module","param","var","output","for","in","if","existing"],namedLiterals:["true","false","null"],escapes:"\\\\(u{[0-9A-Fa-f]+}|n|r|t|\\\\|'|\\${)",tokenizer:{root:[{include:"@expression"},{include:"@whitespace"}],stringVerbatim:[{regex:"(|'|'')[^']",action:{token:"string"}},{regex:"'''",action:{token:"string.quote",next:"@pop"}}],stringLiteral:[{regex:"\\${",action:{token:"delimiter.bracket",next:"@bracketCounting"}},{regex:"[^\\\\'$]+",action:{token:"string"}},{regex:"@escapes",action:{token:"string.escape"}},{regex:"\\\\.",action:{token:"string.escape.invalid"}},{regex:"'",action:{token:"string",next:"@pop"}}],bracketCounting:[{regex:"{",action:{token:"delimiter.bracket",next:"@bracketCounting"}},{regex:"}",action:{token:"delimiter.bracket",next:"@pop"}},{include:"expression"}],comment:[{regex:"[^\\*]+",action:{token:"comment"}},{regex:"\\*\\/",action:{token:"comment",next:"@pop"}},{regex:"[\\/*]",action:{token:"comment"}}],whitespace:[{regex:"[ \\t\\r\\n]"},{regex:"\\/\\*",action:{token:"comment",next:"@comment"}},{regex:"\\/\\/.*$",action:{token:"comment"}}],expression:[{regex:"'''",action:{token:"string.quote",next:"@stringVerbatim"}},{regex:"'",action:{token:"string.quote",next:"@stringLiteral"}},{regex:"[0-9]+",action:{token:"number"}},{regex:n,action:{cases:{"@keywords":{token:"keyword"},"@namedLiterals":{token:"keyword"},"@default":{token:"identifier"}}}}]}}},39395:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return n},language:function(){return o}});
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
var n={comments:{lineComment:"//",blockComment:["(*","*)"]},brackets:[["{","}"],["[","]"],["(",")"],["<",">"]],autoClosingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:"<",close:">"},{open:"'",close:"'"},{open:'"',close:'"'},{open:"(*",close:"*)"}],surroundingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:"<",close:">"},{open:"'",close:"'"},{open:'"',close:'"'},{open:"(*",close:"*)"}]},o={defaultToken:"",tokenPostfix:".cameligo",ignoreCase:!0,brackets:[{open:"{",close:"}",token:"delimiter.curly"},{open:"[",close:"]",token:"delimiter.square"},{open:"(",close:")",token:"delimiter.parenthesis"},{open:"<",close:">",token:"delimiter.angle"}],keywords:["abs","assert","block","Bytes","case","Crypto","Current","else","failwith","false","for","fun","if","in","let","let%entry","let%init","List","list","Map","map","match","match%nat","mod","not","operation","Operation","of","record","Set","set","sender","skip","source","String","then","to","true","type","with"],typeKeywords:["int","unit","string","tz","nat","bool"],operators:["=",">","<","<=",">=","<>",":",":=","and","mod","or","+","-","*","/","@","&","^","%","->","<-","&&","||"],symbols:/[=><:@\^&|+\-*\/\^%]+/,tokenizer:{root:[[/[a-zA-Z_][\w]*/,{cases:{"@keywords":{token:"keyword.$0"},"@default":"identifier"}}],{include:"@whitespace"},[/[{}()\[\]]/,"@brackets"],[/[<>](?!@symbols)/,"@brackets"],[/@symbols/,{cases:{"@operators":"delimiter","@default":""}}],[/\d*\.\d+([eE][\-+]?\d+)?/,"number.float"],[/\$[0-9a-fA-F]{1,16}/,"number.hex"],[/\d+/,"number"],[/[;,.]/,"delimiter"],[/'([^'\\]|\\.)*$/,"string.invalid"],[/'/,"string","@string"],[/'[^\\']'/,"string"],[/'/,"string.invalid"],[/\#\d+/,"string"]],comment:[[/[^\(\*]+/,"comment"],[/\*\)/,"comment","@pop"],[/\(\*/,"comment"]],string:[[/[^\\']+/,"string"],[/\\./,"string.escape.invalid"],[/'/,{token:"string.quote",bracket:"@close",next:"@pop"}]],whitespace:[[/[ \t\r\n]+/,"white"],[/\(\*/,"comment","@comment"],[/\/\/.*$/,"comment"]]}}},36525:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return n},language:function(){return o}});
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
var n={comments:{lineComment:";;"},brackets:[["[","]"],["(",")"],["{","}"]],autoClosingPairs:[{open:"[",close:"]"},{open:'"',close:'"'},{open:"(",close:")"},{open:"{",close:"}"}],surroundingPairs:[{open:"[",close:"]"},{open:'"',close:'"'},{open:"(",close:")"},{open:"{",close:"}"}]},o={defaultToken:"",ignoreCase:!0,tokenPostfix:".clj",brackets:[{open:"[",close:"]",token:"delimiter.square"},{open:"(",close:")",token:"delimiter.parenthesis"},{open:"{",close:"}",token:"delimiter.curly"}],constants:["true","false","nil"],numbers:/^(?:[+\-]?\d+(?:(?:N|(?:[eE][+\-]?\d+))|(?:\.?\d*(?:M|(?:[eE][+\-]?\d+))?)|\/\d+|[xX][0-9a-fA-F]+|r[0-9a-zA-Z]+)?(?=[\\\[\]\s"#'(),;@^`{}~]|$))/,characters:/^(?:\\(?:backspace|formfeed|newline|return|space|tab|o[0-7]{3}|u[0-9A-Fa-f]{4}|x[0-9A-Fa-f]{4}|.)?(?=[\\\[\]\s"(),;@^`{}~]|$))/,escapes:/^\\(?:["'\\bfnrt]|x[0-9A-Fa-f]{1,4}|u[0-9A-Fa-f]{4}|U[0-9A-Fa-f]{8})/,qualifiedSymbols:/^(?:(?:[^\\\/\[\]\d\s"#'(),;@^`{}~][^\\\[\]\s"(),;@^`{}~]*(?:\.[^\\\/\[\]\d\s"#'(),;@^`{}~][^\\\[\]\s"(),;@^`{}~]*)*\/)?(?:\/|[^\\\/\[\]\d\s"#'(),;@^`{}~][^\\\[\]\s"(),;@^`{}~]*)*(?=[\\\[\]\s"(),;@^`{}~]|$))/,specialForms:[".","catch","def","do","if","monitor-enter","monitor-exit","new","quote","recur","set!","throw","try","var"],coreSymbols:["*","*'","*1","*2","*3","*agent*","*allow-unresolved-vars*","*assert*","*clojure-version*","*command-line-args*","*compile-files*","*compile-path*","*compiler-options*","*data-readers*","*default-data-reader-fn*","*e","*err*","*file*","*flush-on-newline*","*fn-loader*","*in*","*math-context*","*ns*","*out*","*print-dup*","*print-length*","*print-level*","*print-meta*","*print-namespace-maps*","*print-readably*","*read-eval*","*reader-resolver*","*source-path*","*suppress-read*","*unchecked-math*","*use-context-classloader*","*verbose-defrecords*","*warn-on-reflection*","+","+'","-","-'","->","->>","->ArrayChunk","->Eduction","->Vec","->VecNode","->VecSeq","-cache-protocol-fn","-reset-methods","..","/","<","<=","=","==",">",">=","EMPTY-NODE","Inst","StackTraceElement->vec","Throwable->map","accessor","aclone","add-classpath","add-watch","agent","agent-error","agent-errors","aget","alength","alias","all-ns","alter","alter-meta!","alter-var-root","amap","ancestors","and","any?","apply","areduce","array-map","as->","aset","aset-boolean","aset-byte","aset-char","aset-double","aset-float","aset-int","aset-long","aset-short","assert","assoc","assoc!","assoc-in","associative?","atom","await","await-for","await1","bases","bean","bigdec","bigint","biginteger","binding","bit-and","bit-and-not","bit-clear","bit-flip","bit-not","bit-or","bit-set","bit-shift-left","bit-shift-right","bit-test","bit-xor","boolean","boolean-array","boolean?","booleans","bound-fn","bound-fn*","bound?","bounded-count","butlast","byte","byte-array","bytes","bytes?","case","cast","cat","char","char-array","char-escape-string","char-name-string","char?","chars","chunk","chunk-append","chunk-buffer","chunk-cons","chunk-first","chunk-next","chunk-rest","chunked-seq?","class","class?","clear-agent-errors","clojure-version","coll?","comment","commute","comp","comparator","compare","compare-and-set!","compile","complement","completing","concat","cond","cond->","cond->>","condp","conj","conj!","cons","constantly","construct-proxy","contains?","count","counted?","create-ns","create-struct","cycle","dec","dec'","decimal?","declare","dedupe","default-data-readers","definline","definterface","defmacro","defmethod","defmulti","defn","defn-","defonce","defprotocol","defrecord","defstruct","deftype","delay","delay?","deliver","denominator","deref","derive","descendants","destructure","disj","disj!","dissoc","dissoc!","distinct","distinct?","doall","dorun","doseq","dosync","dotimes","doto","double","double-array","double?","doubles","drop","drop-last","drop-while","eduction","empty","empty?","ensure","ensure-reduced","enumeration-seq","error-handler","error-mode","eval","even?","every-pred","every?","ex-data","ex-info","extend","extend-protocol","extend-type","extenders","extends?","false?","ffirst","file-seq","filter","filterv","find","find-keyword","find-ns","find-protocol-impl","find-protocol-method","find-var","first","flatten","float","float-array","float?","floats","flush","fn","fn?","fnext","fnil","for","force","format","frequencies","future","future-call","future-cancel","future-cancelled?","future-done?","future?","gen-class","gen-interface","gensym","get","get-in","get-method","get-proxy-class","get-thread-bindings","get-validator","group-by","halt-when","hash","hash-combine","hash-map","hash-ordered-coll","hash-set","hash-unordered-coll","ident?","identical?","identity","if-let","if-not","if-some","ifn?","import","in-ns","inc","inc'","indexed?","init-proxy","inst-ms","inst-ms*","inst?","instance?","int","int-array","int?","integer?","interleave","intern","interpose","into","into-array","ints","io!","isa?","iterate","iterator-seq","juxt","keep","keep-indexed","key","keys","keyword","keyword?","last","lazy-cat","lazy-seq","let","letfn","line-seq","list","list*","list?","load","load-file","load-reader","load-string","loaded-libs","locking","long","long-array","longs","loop","macroexpand","macroexpand-1","make-array","make-hierarchy","map","map-entry?","map-indexed","map?","mapcat","mapv","max","max-key","memfn","memoize","merge","merge-with","meta","method-sig","methods","min","min-key","mix-collection-hash","mod","munge","name","namespace","namespace-munge","nat-int?","neg-int?","neg?","newline","next","nfirst","nil?","nnext","not","not-any?","not-empty","not-every?","not=","ns","ns-aliases","ns-imports","ns-interns","ns-map","ns-name","ns-publics","ns-refers","ns-resolve","ns-unalias","ns-unmap","nth","nthnext","nthrest","num","number?","numerator","object-array","odd?","or","parents","partial","partition","partition-all","partition-by","pcalls","peek","persistent!","pmap","pop","pop!","pop-thread-bindings","pos-int?","pos?","pr","pr-str","prefer-method","prefers","primitives-classnames","print","print-ctor","print-dup","print-method","print-simple","print-str","printf","println","println-str","prn","prn-str","promise","proxy","proxy-call-with-super","proxy-mappings","proxy-name","proxy-super","push-thread-bindings","pvalues","qualified-ident?","qualified-keyword?","qualified-symbol?","quot","rand","rand-int","rand-nth","random-sample","range","ratio?","rational?","rationalize","re-find","re-groups","re-matcher","re-matches","re-pattern","re-seq","read","read-line","read-string","reader-conditional","reader-conditional?","realized?","record?","reduce","reduce-kv","reduced","reduced?","reductions","ref","ref-history-count","ref-max-history","ref-min-history","ref-set","refer","refer-clojure","reify","release-pending-sends","rem","remove","remove-all-methods","remove-method","remove-ns","remove-watch","repeat","repeatedly","replace","replicate","require","reset!","reset-meta!","reset-vals!","resolve","rest","restart-agent","resultset-seq","reverse","reversible?","rseq","rsubseq","run!","satisfies?","second","select-keys","send","send-off","send-via","seq","seq?","seqable?","seque","sequence","sequential?","set","set-agent-send-executor!","set-agent-send-off-executor!","set-error-handler!","set-error-mode!","set-validator!","set?","short","short-array","shorts","shuffle","shutdown-agents","simple-ident?","simple-keyword?","simple-symbol?","slurp","some","some->","some->>","some-fn","some?","sort","sort-by","sorted-map","sorted-map-by","sorted-set","sorted-set-by","sorted?","special-symbol?","spit","split-at","split-with","str","string?","struct","struct-map","subs","subseq","subvec","supers","swap!","swap-vals!","symbol","symbol?","sync","tagged-literal","tagged-literal?","take","take-last","take-nth","take-while","test","the-ns","thread-bound?","time","to-array","to-array-2d","trampoline","transduce","transient","tree-seq","true?","type","unchecked-add","unchecked-add-int","unchecked-byte","unchecked-char","unchecked-dec","unchecked-dec-int","unchecked-divide-int","unchecked-double","unchecked-float","unchecked-inc","unchecked-inc-int","unchecked-int","unchecked-long","unchecked-multiply","unchecked-multiply-int","unchecked-negate","unchecked-negate-int","unchecked-remainder-int","unchecked-short","unchecked-subtract","unchecked-subtract-int","underive","unquote","unquote-splicing","unreduced","unsigned-bit-shift-right","update","update-in","update-proxy","uri?","use","uuid?","val","vals","var-get","var-set","var?","vary-meta","vec","vector","vector-of","vector?","volatile!","volatile?","vreset!","vswap!","when","when-first","when-let","when-not","when-some","while","with-bindings","with-bindings*","with-in-str","with-loading-context","with-local-vars","with-meta","with-open","with-out-str","with-precision","with-redefs","with-redefs-fn","xml-seq","zero?","zipmap"],tokenizer:{root:[{include:"@whitespace"},[/@numbers/,"number"],[/@characters/,"string"],{include:"@string"},[/[()\[\]{}]/,"@brackets"],[/\/#"(?:\.|(?:")|[^"\n])*"\/g/,"regexp"],[/[#'@^`~]/,"meta"],[/@qualifiedSymbols/,{cases:{"^:.+$":"constant","@specialForms":"keyword","@coreSymbols":"keyword","@constants":"constant","@default":"identifier"}}]],whitespace:[[/[\s,]+/,"white"],[/;.*$/,"comment"],[/\(comment\b/,"comment","@comment"]],comment:[[/\(/,"comment","@push"],[/\)/,"comment","@pop"],[/[^()]/,"comment"]],string:[[/"/,"string","@multiLineString"]],multiLineString:[[/"/,"string","@popall"],[/@escapes/,"string.escape"],[/./,"string"]]}}},78444:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return n},language:function(){return o}});
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
var n={wordPattern:/(-?\d*\.\d\w*)|([^\`\~\!\@\#%\^\&\*\(\)\=\$\-\+\[\{\]\}\\\|\;\:\'\"\,\.\<\>\/\?\s]+)/g,comments:{blockComment:["###","###"],lineComment:"#"},brackets:[["{","}"],["[","]"],["(",")"]],autoClosingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"'},{open:"'",close:"'"}],surroundingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"'},{open:"'",close:"'"}],folding:{markers:{start:new RegExp("^\\s*#region\\b"),end:new RegExp("^\\s*#endregion\\b")}}},o={defaultToken:"",ignoreCase:!0,tokenPostfix:".coffee",brackets:[{open:"{",close:"}",token:"delimiter.curly"},{open:"[",close:"]",token:"delimiter.square"},{open:"(",close:")",token:"delimiter.parenthesis"}],regEx:/\/(?!\/\/)(?:[^\/\\]|\\.)*\/[igm]*/,keywords:["and","or","is","isnt","not","on","yes","@","no","off","true","false","null","this","new","delete","typeof","in","instanceof","return","throw","break","continue","debugger","if","else","switch","for","while","do","try","catch","finally","class","extends","super","undefined","then","unless","until","loop","of","by","when"],symbols:/[=><!~?&%|+\-*\/\^\.,\:]+/,escapes:/\\(?:[abfnrtv\\"'$]|x[0-9A-Fa-f]{1,4}|u[0-9A-Fa-f]{4}|U[0-9A-Fa-f]{8})/,tokenizer:{root:[[/\@[a-zA-Z_]\w*/,"variable.predefined"],[/[a-zA-Z_]\w*/,{cases:{this:"variable.predefined","@keywords":{token:"keyword.$0"},"@default":""}}],[/[ \t\r\n]+/,""],[/###/,"comment","@comment"],[/#.*$/,"comment"],["///",{token:"regexp",next:"@hereregexp"}],[/^(\s*)(@regEx)/,["","regexp"]],[/(\()(\s*)(@regEx)/,["@brackets","","regexp"]],[/(\,)(\s*)(@regEx)/,["delimiter","","regexp"]],[/(\=)(\s*)(@regEx)/,["delimiter","","regexp"]],[/(\:)(\s*)(@regEx)/,["delimiter","","regexp"]],[/(\[)(\s*)(@regEx)/,["@brackets","","regexp"]],[/(\!)(\s*)(@regEx)/,["delimiter","","regexp"]],[/(\&)(\s*)(@regEx)/,["delimiter","","regexp"]],[/(\|)(\s*)(@regEx)/,["delimiter","","regexp"]],[/(\?)(\s*)(@regEx)/,["delimiter","","regexp"]],[/(\{)(\s*)(@regEx)/,["@brackets","","regexp"]],[/(\;)(\s*)(@regEx)/,["","","regexp"]],[/}/,{cases:{"$S2==interpolatedstring":{token:"string",next:"@pop"},"@default":"@brackets"}}],[/[{}()\[\]]/,"@brackets"],[/@symbols/,"delimiter"],[/\d+[eE]([\-+]?\d+)?/,"number.float"],[/\d+\.\d+([eE][\-+]?\d+)?/,"number.float"],[/0[xX][0-9a-fA-F]+/,"number.hex"],[/0[0-7]+(?!\d)/,"number.octal"],[/\d+/,"number"],[/[,.]/,"delimiter"],[/"""/,"string",'@herestring."""'],[/'''/,"string","@herestring.'''"],[/"/,{cases:{"@eos":"string","@default":{token:"string",next:'@string."'}}}],[/'/,{cases:{"@eos":"string","@default":{token:"string",next:"@string.'"}}}]],string:[[/[^"'\#\\]+/,"string"],[/@escapes/,"string.escape"],[/\./,"string.escape.invalid"],[/\./,"string.escape.invalid"],[/#{/,{cases:{'$S2=="':{token:"string",next:"root.interpolatedstring"},"@default":"string"}}],[/["']/,{cases:{"$#==$S2":{token:"string",next:"@pop"},"@default":"string"}}],[/#/,"string"]],herestring:[[/("""|''')/,{cases:{"$1==$S2":{token:"string",next:"@pop"},"@default":"string"}}],[/[^#\\'"]+/,"string"],[/['"]+/,"string"],[/@escapes/,"string.escape"],[/\./,"string.escape.invalid"],[/#{/,{token:"string.quote",next:"root.interpolatedstring"}],[/#/,"string"]],comment:[[/[^#]+/,"comment"],[/###/,"comment","@pop"],[/#/,"comment"]],hereregexp:[[/[^\\\/#]+/,"regexp"],[/\\./,"regexp"],[/#.*$/,"comment"],["///[igm]*",{token:"regexp",next:"@pop"}],[/\//,"regexp"]]}}},63584:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return n},language:function(){return o}});
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
var n={comments:{lineComment:"//",blockComment:["/*","*/"]},brackets:[["{","}"],["[","]"],["(",")"]],autoClosingPairs:[{open:"[",close:"]"},{open:"{",close:"}"},{open:"(",close:")"},{open:"'",close:"'",notIn:["string","comment"]},{open:'"',close:'"',notIn:["string"]}],surroundingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"'},{open:"'",close:"'"}],folding:{markers:{start:new RegExp("^\\s*#pragma\\s+region\\b"),end:new RegExp("^\\s*#pragma\\s+endregion\\b")}}},o={defaultToken:"",tokenPostfix:".cpp",brackets:[{token:"delimiter.curly",open:"{",close:"}"},{token:"delimiter.parenthesis",open:"(",close:")"},{token:"delimiter.square",open:"[",close:"]"},{token:"delimiter.angle",open:"<",close:">"}],keywords:["abstract","amp","array","auto","bool","break","case","catch","char","class","const","constexpr","const_cast","continue","cpu","decltype","default","delegate","delete","do","double","dynamic_cast","each","else","enum","event","explicit","export","extern","false","final","finally","float","for","friend","gcnew","generic","goto","if","in","initonly","inline","int","interface","interior_ptr","internal","literal","long","mutable","namespace","new","noexcept","nullptr","__nullptr","operator","override","partial","pascal","pin_ptr","private","property","protected","public","ref","register","reinterpret_cast","restrict","return","safe_cast","sealed","short","signed","sizeof","static","static_assert","static_cast","struct","switch","template","this","thread_local","throw","tile_static","true","try","typedef","typeid","typename","union","unsigned","using","virtual","void","volatile","wchar_t","where","while","_asm","_based","_cdecl","_declspec","_fastcall","_if_exists","_if_not_exists","_inline","_multiple_inheritance","_pascal","_single_inheritance","_stdcall","_virtual_inheritance","_w64","__abstract","__alignof","__asm","__assume","__based","__box","__builtin_alignof","__cdecl","__clrcall","__declspec","__delegate","__event","__except","__fastcall","__finally","__forceinline","__gc","__hook","__identifier","__if_exists","__if_not_exists","__inline","__int128","__int16","__int32","__int64","__int8","__interface","__leave","__m128","__m128d","__m128i","__m256","__m256d","__m256i","__m64","__multiple_inheritance","__newslot","__nogc","__noop","__nounwind","__novtordisp","__pascal","__pin","__pragma","__property","__ptr32","__ptr64","__raise","__restrict","__resume","__sealed","__single_inheritance","__stdcall","__super","__thiscall","__try","__try_cast","__typeof","__unaligned","__unhook","__uuidof","__value","__virtual_inheritance","__w64","__wchar_t"],operators:["=",">","<","!","~","?",":","==","<=",">=","!=","&&","||","++","--","+","-","*","/","&","|","^","%","<<",">>",">>>","+=","-=","*=","/=","&=","|=","^=","%=","<<=",">>=",">>>="],symbols:/[=><!~?:&|+\-*\/\^%]+/,escapes:/\\(?:[abfnrtv\\"']|x[0-9A-Fa-f]{1,4}|u[0-9A-Fa-f]{4}|U[0-9A-Fa-f]{8})/,integersuffix:/([uU](ll|LL|l|L)|(ll|LL|l|L)?[uU]?)/,floatsuffix:/[fFlL]?/,encoding:/u|u8|U|L/,tokenizer:{root:[[/@encoding?R\"(?:([^ ()\\\t]*))\(/,{token:"string.raw.begin",next:"@raw.$1"}],[/[a-zA-Z_]\w*/,{cases:{"@keywords":{token:"keyword.$0"},"@default":"identifier"}}],[/^\s*#\s*include/,{token:"keyword.directive.include",next:"@include"}],[/^\s*#\s*\w+/,"keyword.directive"],{include:"@whitespace"},[/\[\s*\[/,{token:"annotation",next:"@annotation"}],[/[{}()\[\]]/,"@brackets"],[/[<>](?!@symbols)/,"@brackets"],[/@symbols/,{cases:{"@operators":"delimiter","@default":""}}],[/\d*\d+[eE]([\-+]?\d+)?(@floatsuffix)/,"number.float"],[/\d*\.\d+([eE][\-+]?\d+)?(@floatsuffix)/,"number.float"],[/0[xX][0-9a-fA-F']*[0-9a-fA-F](@integersuffix)/,"number.hex"],[/0[0-7']*[0-7](@integersuffix)/,"number.octal"],[/0[bB][0-1']*[0-1](@integersuffix)/,"number.binary"],[/\d[\d']*\d(@integersuffix)/,"number"],[/\d(@integersuffix)/,"number"],[/[;,.]/,"delimiter"],[/"([^"\\]|\\.)*$/,"string.invalid"],[/"/,"string","@string"],[/'[^\\']'/,"string"],[/(')(@escapes)(')/,["string","string.escape","string"]],[/'/,"string.invalid"]],whitespace:[[/[ \t\r\n]+/,""],[/\/\*\*(?!\/)/,"comment.doc","@doccomment"],[/\/\*/,"comment","@comment"],[/\/\/.*\\$/,"comment","@linecomment"],[/\/\/.*$/,"comment"]],comment:[[/[^\/*]+/,"comment"],[/\*\//,"comment","@pop"],[/[\/*]/,"comment"]],linecomment:[[/.*[^\\]$/,"comment","@pop"],[/[^]+/,"comment"]],doccomment:[[/[^\/*]+/,"comment.doc"],[/\*\//,"comment.doc","@pop"],[/[\/*]/,"comment.doc"]],string:[[/[^\\"]+/,"string"],[/@escapes/,"string.escape"],[/\\./,"string.escape.invalid"],[/"/,"string","@pop"]],raw:[[/(.*)(\))(?:([^ ()\\\t"]*))(\")/,{cases:{"$3==$S2":["string.raw","string.raw.end","string.raw.end",{token:"string.raw.end",next:"@pop"}],"@default":["string.raw","string.raw","string.raw","string.raw"]}}],[/.*/,"string.raw"]],annotation:[{include:"@whitespace"},[/using|alignas/,"keyword"],[/[a-zA-Z0-9_]+/,"annotation"],[/[,:]/,"delimiter"],[/[()]/,"@brackets"],[/\]\s*\]/,{token:"annotation",next:"@pop"}]],include:[[/(\s*)(<)([^<>]*)(>)/,["","keyword.directive.include.begin","string.include.identifier",{token:"keyword.directive.include.end",next:"@pop"}]],[/(\s*)(")([^"]*)(")/,["","keyword.directive.include.begin","string.include.identifier",{token:"keyword.directive.include.end",next:"@pop"}]]]}}},12910:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return n},language:function(){return o}});
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
var n={wordPattern:/(-?\d*\.\d\w*)|([^\`\~\!\#\$\%\^\&\*\(\)\-\=\+\[\{\]\}\\\|\;\:\'\"\,\.\<\>\/\?\s]+)/g,comments:{lineComment:"//",blockComment:["/*","*/"]},brackets:[["{","}"],["[","]"],["(",")"]],autoClosingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:"'",close:"'",notIn:["string","comment"]},{open:'"',close:'"',notIn:["string","comment"]}],surroundingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:"<",close:">"},{open:"'",close:"'"},{open:'"',close:'"'}],folding:{markers:{start:new RegExp("^\\s*#region\\b"),end:new RegExp("^\\s*#endregion\\b")}}},o={defaultToken:"",tokenPostfix:".cs",brackets:[{open:"{",close:"}",token:"delimiter.curly"},{open:"[",close:"]",token:"delimiter.square"},{open:"(",close:")",token:"delimiter.parenthesis"},{open:"<",close:">",token:"delimiter.angle"}],keywords:["extern","alias","using","bool","decimal","sbyte","byte","short","ushort","int","uint","long","ulong","char","float","double","object","dynamic","string","assembly","is","as","ref","out","this","base","new","typeof","void","checked","unchecked","default","delegate","var","const","if","else","switch","case","while","do","for","foreach","in","break","continue","goto","return","throw","try","catch","finally","lock","yield","from","let","where","join","on","equals","into","orderby","ascending","descending","select","group","by","namespace","partial","class","field","event","method","param","public","protected","internal","private","abstract","sealed","static","struct","readonly","volatile","virtual","override","params","get","set","add","remove","operator","true","false","implicit","explicit","interface","enum","null","async","await","fixed","sizeof","stackalloc","unsafe","nameof","when"],namespaceFollows:["namespace","using"],parenFollows:["if","for","while","switch","foreach","using","catch","when"],operators:["=","??","||","&&","|","^","&","==","!=","<=",">=","<<","+","-","*","/","%","!","~","++","--","+=","-=","*=","/=","%=","&=","|=","^=","<<=",">>=",">>","=>"],symbols:/[=><!~?:&|+\-*\/\^%]+/,escapes:/\\(?:[abfnrtv\\"']|x[0-9A-Fa-f]{1,4}|u[0-9A-Fa-f]{4}|U[0-9A-Fa-f]{8})/,tokenizer:{root:[[/\@?[a-zA-Z_]\w*/,{cases:{"@namespaceFollows":{token:"keyword.$0",next:"@namespace"},"@keywords":{token:"keyword.$0",next:"@qualified"},"@default":{token:"identifier",next:"@qualified"}}}],{include:"@whitespace"},[/}/,{cases:{"$S2==interpolatedstring":{token:"string.quote",next:"@pop"},"$S2==litinterpstring":{token:"string.quote",next:"@pop"},"@default":"@brackets"}}],[/[{}()\[\]]/,"@brackets"],[/[<>](?!@symbols)/,"@brackets"],[/@symbols/,{cases:{"@operators":"delimiter","@default":""}}],[/[0-9_]*\.[0-9_]+([eE][\-+]?\d+)?[fFdD]?/,"number.float"],[/0[xX][0-9a-fA-F_]+/,"number.hex"],[/0[bB][01_]+/,"number.hex"],[/[0-9_]+/,"number"],[/[;,.]/,"delimiter"],[/"([^"\\]|\\.)*$/,"string.invalid"],[/"/,{token:"string.quote",next:"@string"}],[/\$\@"/,{token:"string.quote",next:"@litinterpstring"}],[/\@"/,{token:"string.quote",next:"@litstring"}],[/\$"/,{token:"string.quote",next:"@interpolatedstring"}],[/'[^\\']'/,"string"],[/(')(@escapes)(')/,["string","string.escape","string"]],[/'/,"string.invalid"]],qualified:[[/[a-zA-Z_][\w]*/,{cases:{"@keywords":{token:"keyword.$0"},"@default":"identifier"}}],[/\./,"delimiter"],["","","@pop"]],namespace:[{include:"@whitespace"},[/[A-Z]\w*/,"namespace"],[/[\.=]/,"delimiter"],["","","@pop"]],comment:[[/[^\/*]+/,"comment"],["\\*/","comment","@pop"],[/[\/*]/,"comment"]],string:[[/[^\\"]+/,"string"],[/@escapes/,"string.escape"],[/\\./,"string.escape.invalid"],[/"/,{token:"string.quote",next:"@pop"}]],litstring:[[/[^"]+/,"string"],[/""/,"string.escape"],[/"/,{token:"string.quote",next:"@pop"}]],litinterpstring:[[/[^"{]+/,"string"],[/""/,"string.escape"],[/{{/,"string.escape"],[/}}/,"string.escape"],[/{/,{token:"string.quote",next:"root.litinterpstring"}],[/"/,{token:"string.quote",next:"@pop"}]],interpolatedstring:[[/[^\\"{]+/,"string"],[/@escapes/,"string.escape"],[/\\./,"string.escape.invalid"],[/{{/,"string.escape"],[/}}/,"string.escape"],[/{/,{token:"string.quote",next:"root.interpolatedstring"}],[/"/,{token:"string.quote",next:"@pop"}]],whitespace:[[/^[ \t\v\f]*#((r)|(load))(?=\s)/,"directive.csx"],[/^[ \t\v\f]*#\w.*$/,"namespace.cpp"],[/[ \t\v\f\r\n]+/,""],[/\/\*/,"comment","@comment"],[/\/\/.*$/,"comment"]]}}},53691:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return n},language:function(){return o}});
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
var n={brackets:[],autoClosingPairs:[],surroundingPairs:[]},o={keywords:[],typeKeywords:[],tokenPostfix:".csp",operators:[],symbols:/[=><!~?:&|+\-*\/\^%]+/,escapes:/\\(?:[abfnrtv\\"']|x[0-9A-Fa-f]{1,4}|u[0-9A-Fa-f]{4}|U[0-9A-Fa-f]{8})/,tokenizer:{root:[[/child-src/,"string.quote"],[/connect-src/,"string.quote"],[/default-src/,"string.quote"],[/font-src/,"string.quote"],[/frame-src/,"string.quote"],[/img-src/,"string.quote"],[/manifest-src/,"string.quote"],[/media-src/,"string.quote"],[/object-src/,"string.quote"],[/script-src/,"string.quote"],[/style-src/,"string.quote"],[/worker-src/,"string.quote"],[/base-uri/,"string.quote"],[/plugin-types/,"string.quote"],[/sandbox/,"string.quote"],[/disown-opener/,"string.quote"],[/form-action/,"string.quote"],[/frame-ancestors/,"string.quote"],[/report-uri/,"string.quote"],[/report-to/,"string.quote"],[/upgrade-insecure-requests/,"string.quote"],[/block-all-mixed-content/,"string.quote"],[/require-sri-for/,"string.quote"],[/reflected-xss/,"string.quote"],[/referrer/,"string.quote"],[/policy-uri/,"string.quote"],[/'self'/,"string.quote"],[/'unsafe-inline'/,"string.quote"],[/'unsafe-eval'/,"string.quote"],[/'strict-dynamic'/,"string.quote"],[/'unsafe-hashed-attributes'/,"string.quote"]]}}},94095:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return n},language:function(){return o}});
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
var n={wordPattern:/(#?-?\d*\.\d\w*%?)|((::|[@#.!:])?[\w-?]+%?)|::|[@#.!:]/g,comments:{blockComment:["/*","*/"]},brackets:[["{","}"],["[","]"],["(",")"]],autoClosingPairs:[{open:"{",close:"}",notIn:["string","comment"]},{open:"[",close:"]",notIn:["string","comment"]},{open:"(",close:")",notIn:["string","comment"]},{open:'"',close:'"',notIn:["string","comment"]},{open:"'",close:"'",notIn:["string","comment"]}],surroundingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"'},{open:"'",close:"'"}],folding:{markers:{start:new RegExp("^\\s*\\/\\*\\s*#region\\b\\s*(.*?)\\s*\\*\\/"),end:new RegExp("^\\s*\\/\\*\\s*#endregion\\b.*\\*\\/")}}},o={defaultToken:"",tokenPostfix:".css",ws:"[ \t\n\r\f]*",identifier:"-?-?([a-zA-Z]|(\\\\(([0-9a-fA-F]{1,6}\\s?)|[^[0-9a-fA-F])))([\\w\\-]|(\\\\(([0-9a-fA-F]{1,6}\\s?)|[^[0-9a-fA-F])))*",brackets:[{open:"{",close:"}",token:"delimiter.bracket"},{open:"[",close:"]",token:"delimiter.bracket"},{open:"(",close:")",token:"delimiter.parenthesis"},{open:"<",close:">",token:"delimiter.angle"}],tokenizer:{root:[{include:"@selector"}],selector:[{include:"@comments"},{include:"@import"},{include:"@strings"},["[@](keyframes|-webkit-keyframes|-moz-keyframes|-o-keyframes)",{token:"keyword",next:"@keyframedeclaration"}],["[@](page|content|font-face|-moz-document)",{token:"keyword"}],["[@](charset|namespace)",{token:"keyword",next:"@declarationbody"}],["(url-prefix)(\\()",["attribute.value",{token:"delimiter.parenthesis",next:"@urldeclaration"}]],["(url)(\\()",["attribute.value",{token:"delimiter.parenthesis",next:"@urldeclaration"}]],{include:"@selectorname"},["[\\*]","tag"],["[>\\+,]","delimiter"],["\\[",{token:"delimiter.bracket",next:"@selectorattribute"}],["{",{token:"delimiter.bracket",next:"@selectorbody"}]],selectorbody:[{include:"@comments"},["[*_]?@identifier@ws:(?=(\\s|\\d|[^{;}]*[;}]))","attribute.name","@rulevalue"],["}",{token:"delimiter.bracket",next:"@pop"}]],selectorname:[["(\\.|#(?=[^{])|%|(@identifier)|:)+","tag"]],selectorattribute:[{include:"@term"},["]",{token:"delimiter.bracket",next:"@pop"}]],term:[{include:"@comments"},["(url-prefix)(\\()",["attribute.value",{token:"delimiter.parenthesis",next:"@urldeclaration"}]],["(url)(\\()",["attribute.value",{token:"delimiter.parenthesis",next:"@urldeclaration"}]],{include:"@functioninvocation"},{include:"@numbers"},{include:"@name"},{include:"@strings"},["([<>=\\+\\-\\*\\/\\^\\|\\~,])","delimiter"],[",","delimiter"]],rulevalue:[{include:"@comments"},{include:"@strings"},{include:"@term"},["!important","keyword"],[";","delimiter","@pop"],["(?=})",{token:"",next:"@pop"}]],warndebug:[["[@](warn|debug)",{token:"keyword",next:"@declarationbody"}]],import:[["[@](import)",{token:"keyword",next:"@declarationbody"}]],urldeclaration:[{include:"@strings"},["[^)\r\n]+","string"],["\\)",{token:"delimiter.parenthesis",next:"@pop"}]],parenthizedterm:[{include:"@term"},["\\)",{token:"delimiter.parenthesis",next:"@pop"}]],declarationbody:[{include:"@term"},[";","delimiter","@pop"],["(?=})",{token:"",next:"@pop"}]],comments:[["\\/\\*","comment","@comment"],["\\/\\/+.*","comment"]],comment:[["\\*\\/","comment","@pop"],[/[^*/]+/,"comment"],[/./,"comment"]],name:[["@identifier","attribute.value"]],numbers:[["-?(\\d*\\.)?\\d+([eE][\\-+]?\\d+)?",{token:"attribute.value.number",next:"@units"}],["#[0-9a-fA-F_]+(?!\\w)","attribute.value.hex"]],units:[["(em|ex|ch|rem|fr|vmin|vmax|vw|vh|vm|cm|mm|in|px|pt|pc|deg|grad|rad|turn|s|ms|Hz|kHz|%)?","attribute.value.unit","@pop"]],keyframedeclaration:[["@identifier","attribute.value"],["{",{token:"delimiter.bracket",switchTo:"@keyframebody"}]],keyframebody:[{include:"@term"},["{",{token:"delimiter.bracket",next:"@selectorbody"}],["}",{token:"delimiter.bracket",next:"@pop"}]],functioninvocation:[["@identifier\\(",{token:"attribute.value",next:"@functionarguments"}]],functionarguments:[["\\$@identifier@ws:","attribute.name"],["[,]","delimiter"],{include:"@term"},["\\)",{token:"attribute.value",next:"@pop"}]],strings:[['~?"',{token:"string",next:"@stringenddoublequote"}],["~?'",{token:"string",next:"@stringendquote"}]],stringenddoublequote:[["\\\\.","string"],['"',{token:"string",next:"@pop"}],[/[^\\"]+/,"string"],[".","string"]],stringendquote:[["\\\\.","string"],["'",{token:"string",next:"@pop"}],[/[^\\']+/,"string"],[".","string"]]}}},91440:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return n},language:function(){return o}});
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
var n={comments:{lineComment:"//",blockComment:["/*","*/"]},brackets:[["{","}"],["[","]"],["(",")"]],autoClosingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"'},{open:"'",close:"'"},{open:"`",close:"`"}],surroundingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"'},{open:"'",close:"'"},{open:"`",close:"`"}]},o={defaultToken:"",tokenPostfix:".cypher",ignoreCase:!0,brackets:[{open:"{",close:"}",token:"delimiter.curly"},{open:"[",close:"]",token:"delimiter.bracket"},{open:"(",close:")",token:"delimiter.parenthesis"}],keywords:["ALL","AND","AS","ASC","ASCENDING","BY","CALL","CASE","CONTAINS","CREATE","DELETE","DESC","DESCENDING","DETACH","DISTINCT","ELSE","END","ENDS","EXISTS","IN","IS","LIMIT","MANDATORY","MATCH","MERGE","NOT","ON","ON","OPTIONAL","OR","ORDER","REMOVE","RETURN","SET","SKIP","STARTS","THEN","UNION","UNWIND","WHEN","WHERE","WITH","XOR","YIELD"],builtinLiterals:["true","TRUE","false","FALSE","null","NULL"],builtinFunctions:["abs","acos","asin","atan","atan2","avg","ceil","coalesce","collect","cos","cot","count","degrees","e","endNode","exists","exp","floor","head","id","keys","labels","last","left","length","log","log10","lTrim","max","min","nodes","percentileCont","percentileDisc","pi","properties","radians","rand","range","relationships","replace","reverse","right","round","rTrim","sign","sin","size","split","sqrt","startNode","stDev","stDevP","substring","sum","tail","tan","timestamp","toBoolean","toFloat","toInteger","toLower","toString","toUpper","trim","type"],operators:["+","-","*","/","%","^","=","<>","<",">","<=",">=","->","<-","--\x3e","<--"],escapes:/\\(?:[tbnrf\\"'`]|u[0-9A-Fa-f]{4}|U[0-9A-Fa-f]{8})/,digits:/\d+/,octaldigits:/[0-7]+/,hexdigits:/[0-9a-fA-F]+/,tokenizer:{root:[[/[{}[\]()]/,"@brackets"],{include:"common"}],common:[{include:"@whitespace"},{include:"@numbers"},{include:"@strings"},[/:[a-zA-Z_][\w]*/,"type.identifier"],[/[a-zA-Z_][\w]*(?=\()/,{cases:{"@builtinFunctions":"predefined.function"}}],[/[a-zA-Z_$][\w$]*/,{cases:{"@keywords":"keyword","@builtinLiterals":"predefined.literal","@default":"identifier"}}],[/`/,"identifier.escape","@identifierBacktick"],[/[;,.:|]/,"delimiter"],[/[<>=%+\-*/^]+/,{cases:{"@operators":"delimiter","@default":""}}]],numbers:[[/-?(@digits)[eE](-?(@digits))?/,"number.float"],[/-?(@digits)?\.(@digits)([eE]-?(@digits))?/,"number.float"],[/-?0x(@hexdigits)/,"number.hex"],[/-?0(@octaldigits)/,"number.octal"],[/-?(@digits)/,"number"]],strings:[[/"([^"\\]|\\.)*$/,"string.invalid"],[/'([^'\\]|\\.)*$/,"string.invalid"],[/"/,"string","@stringDouble"],[/'/,"string","@stringSingle"]],whitespace:[[/[ \t\r\n]+/,"white"],[/\/\*/,"comment","@comment"],[/\/\/.*$/,"comment"]],comment:[[/\/\/.*/,"comment"],[/[^/*]+/,"comment"],[/\*\//,"comment","@pop"],[/[/*]/,"comment"]],stringDouble:[[/[^\\"]+/,"string"],[/@escapes/,"string"],[/\\./,"string.invalid"],[/"/,"string","@pop"]],stringSingle:[[/[^\\']+/,"string"],[/@escapes/,"string"],[/\\./,"string.invalid"],[/'/,"string","@pop"]],identifierBacktick:[[/[^\\`]+/,"identifier.escape"],[/@escapes/,"identifier.escape"],[/\\./,"identifier.escape.invalid"],[/`/,"identifier.escape","@pop"]]}}},7001:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return n},language:function(){return o}});
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
var n={comments:{lineComment:"//",blockComment:["/*","*/"]},brackets:[["{","}"],["[","]"],["(",")"]],autoClosingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:"'",close:"'",notIn:["string","comment"]},{open:'"',close:'"',notIn:["string"]},{open:"`",close:"`",notIn:["string","comment"]},{open:"/**",close:" */",notIn:["string"]}],surroundingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:"<",close:">"},{open:"'",close:"'"},{open:"(",close:")"},{open:'"',close:'"'},{open:"`",close:"`"}],folding:{markers:{start:/^\s*\s*#?region\b/,end:/^\s*\s*#?endregion\b/}}},o={defaultToken:"invalid",tokenPostfix:".dart",keywords:["abstract","dynamic","implements","show","as","else","import","static","assert","enum","in","super","async","export","interface","switch","await","extends","is","sync","break","external","library","this","case","factory","mixin","throw","catch","false","new","true","class","final","null","try","const","finally","on","typedef","continue","for","operator","var","covariant","Function","part","void","default","get","rethrow","while","deferred","hide","return","with","do","if","set","yield"],typeKeywords:["int","double","String","bool"],operators:["+","-","*","/","~/","%","++","--","==","!=",">","<",">=","<=","=","-=","/=","%=",">>=","^=","+=","*=","~/=","<<=","&=","!=","||","&&","&","|","^","~","<<",">>","!",">>>","??","?",":","|="],symbols:/[=><!~?:&|+\-*\/\^%]+/,escapes:/\\(?:[abfnrtv\\"']|x[0-9A-Fa-f]{1,4}|u[0-9A-Fa-f]{4}|U[0-9A-Fa-f]{8})/,digits:/\d+(_+\d+)*/,octaldigits:/[0-7]+(_+[0-7]+)*/,binarydigits:/[0-1]+(_+[0-1]+)*/,hexdigits:/[[0-9a-fA-F]+(_+[0-9a-fA-F]+)*/,regexpctl:/[(){}\[\]\$\^|\-*+?\.]/,regexpesc:/\\(?:[bBdDfnrstvwWn0\\\/]|@regexpctl|c[A-Z]|x[0-9a-fA-F]{2}|u[0-9a-fA-F]{4})/,tokenizer:{root:[[/[{}]/,"delimiter.bracket"],{include:"common"}],common:[[/[a-z_$][\w$]*/,{cases:{"@typeKeywords":"type.identifier","@keywords":"keyword","@default":"identifier"}}],[/[A-Z_$][\w\$]*/,"type.identifier"],{include:"@whitespace"},[/\/(?=([^\\\/]|\\.)+\/([gimsuy]*)(\s*)(\.|;|,|\)|\]|\}|$))/,{token:"regexp",bracket:"@open",next:"@regexp"}],[/@[a-zA-Z]+/,"annotation"],[/[()\[\]]/,"@brackets"],[/[<>](?!@symbols)/,"@brackets"],[/!(?=([^=]|$))/,"delimiter"],[/@symbols/,{cases:{"@operators":"delimiter","@default":""}}],[/(@digits)[eE]([\-+]?(@digits))?/,"number.float"],[/(@digits)\.(@digits)([eE][\-+]?(@digits))?/,"number.float"],[/0[xX](@hexdigits)n?/,"number.hex"],[/0[oO]?(@octaldigits)n?/,"number.octal"],[/0[bB](@binarydigits)n?/,"number.binary"],[/(@digits)n?/,"number"],[/[;,.]/,"delimiter"],[/"([^"\\]|\\.)*$/,"string.invalid"],[/'([^'\\]|\\.)*$/,"string.invalid"],[/"/,"string","@string_double"],[/'/,"string","@string_single"]],whitespace:[[/[ \t\r\n]+/,""],[/\/\*\*(?!\/)/,"comment.doc","@jsdoc"],[/\/\*/,"comment","@comment"],[/\/\/\/.*$/,"comment.doc"],[/\/\/.*$/,"comment"]],comment:[[/[^\/*]+/,"comment"],[/\*\//,"comment","@pop"],[/[\/*]/,"comment"]],jsdoc:[[/[^\/*]+/,"comment.doc"],[/\*\//,"comment.doc","@pop"],[/[\/*]/,"comment.doc"]],regexp:[[/(\{)(\d+(?:,\d*)?)(\})/,["regexp.escape.control","regexp.escape.control","regexp.escape.control"]],[/(\[)(\^?)(?=(?:[^\]\\\/]|\\.)+)/,["regexp.escape.control",{token:"regexp.escape.control",next:"@regexrange"}]],[/(\()(\?:|\?=|\?!)/,["regexp.escape.control","regexp.escape.control"]],[/[()]/,"regexp.escape.control"],[/@regexpctl/,"regexp.escape.control"],[/[^\\\/]/,"regexp"],[/@regexpesc/,"regexp.escape"],[/\\\./,"regexp.invalid"],[/(\/)([gimsuy]*)/,[{token:"regexp",bracket:"@close",next:"@pop"},"keyword.other"]]],regexrange:[[/-/,"regexp.escape.control"],[/\^/,"regexp.invalid"],[/@regexpesc/,"regexp.escape"],[/[^\]]/,"regexp"],[/\]/,{token:"regexp.escape.control",next:"@pop",bracket:"@close"}]],string_double:[[/[^\\"\$]+/,"string"],[/[^\\"]+/,"string"],[/@escapes/,"string.escape"],[/\\./,"string.escape.invalid"],[/"/,"string","@pop"],[/\$\w+/,"identifier"]],string_single:[[/[^\\'\$]+/,"string"],[/@escapes/,"string.escape"],[/\\./,"string.escape.invalid"],[/'/,"string","@pop"],[/\$\w+/,"identifier"]]}}},25922:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return n},language:function(){return o}});
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
var n={brackets:[["{","}"],["[","]"],["(",")"]],autoClosingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"'},{open:"'",close:"'"}],surroundingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"'},{open:"'",close:"'"}]},o={defaultToken:"",tokenPostfix:".dockerfile",variable:/\${?[\w]+}?/,tokenizer:{root:[{include:"@whitespace"},{include:"@comment"},[/(ONBUILD)(\s+)/,["keyword",""]],[/(ENV)(\s+)([\w]+)/,["keyword","",{token:"variable",next:"@arguments"}]],[/(FROM|MAINTAINER|RUN|EXPOSE|ENV|ADD|ARG|VOLUME|LABEL|USER|WORKDIR|COPY|CMD|STOPSIGNAL|SHELL|HEALTHCHECK|ENTRYPOINT)/,{token:"keyword",next:"@arguments"}]],arguments:[{include:"@whitespace"},{include:"@strings"},[/(@variable)/,{cases:{"@eos":{token:"variable",next:"@popall"},"@default":"variable"}}],[/\\/,{cases:{"@eos":"","@default":""}}],[/./,{cases:{"@eos":{token:"",next:"@popall"},"@default":""}}]],whitespace:[[/\s+/,{cases:{"@eos":{token:"",next:"@popall"},"@default":""}}]],comment:[[/(^#.*$)/,"comment","@popall"]],strings:[[/\\'$/,"","@popall"],[/\\'/,""],[/'$/,"string","@popall"],[/'/,"string","@stringBody"],[/"$/,"string","@popall"],[/"/,"string","@dblStringBody"]],stringBody:[[/[^\\\$']/,{cases:{"@eos":{token:"string",next:"@popall"},"@default":"string"}}],[/\\./,"string.escape"],[/'$/,"string","@popall"],[/'/,"string","@pop"],[/(@variable)/,"variable"],[/\\$/,"string"],[/$/,"string","@popall"]],dblStringBody:[[/[^\\\$"]/,{cases:{"@eos":{token:"string",next:"@popall"},"@default":"string"}}],[/\\./,"string.escape"],[/"$/,"string","@popall"],[/"/,"string","@pop"],[/(@variable)/,"variable"],[/\\$/,"string"],[/$/,"string","@popall"]]}}},71040:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return n},language:function(){return o}});
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
var n={comments:{lineComment:"//",blockComment:["/*","*/"]},brackets:[["{","}"],["[","]"],["(",")"]],autoClosingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:"'",close:"'",notIn:["string","comment"]},{open:'"',close:'"',notIn:["string","comment"]}],surroundingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:"<",close:">"},{open:"'",close:"'"},{open:'"',close:'"'}]},o={defaultToken:"",tokenPostfix:".ecl",ignoreCase:!0,brackets:[{open:"{",close:"}",token:"delimiter.curly"},{open:"[",close:"]",token:"delimiter.square"},{open:"(",close:")",token:"delimiter.parenthesis"},{open:"<",close:">",token:"delimiter.angle"}],pounds:["append","break","declare","demangle","end","for","getdatatype","if","inmodule","loop","mangle","onwarning","option","set","stored","uniquename"].join("|"),keywords:["__compressed__","after","all","and","any","as","atmost","before","beginc","best","between","case","cluster","compressed","compression","const","counter","csv","default","descend","embed","encoding","encrypt","end","endc","endembed","endmacro","enum","escape","except","exclusive","expire","export","extend","fail","few","fileposition","first","flat","forward","from","full","function","functionmacro","group","grouped","heading","hole","ifblock","import","in","inner","interface","internal","joined","keep","keyed","last","left","limit","linkcounted","literal","little_endian","load","local","locale","lookup","lzw","macro","many","maxcount","maxlength","min skew","module","mofn","multiple","named","namespace","nocase","noroot","noscan","nosort","not","noxpath","of","onfail","only","opt","or","outer","overwrite","packed","partition","penalty","physicallength","pipe","prefetch","quote","record","repeat","retry","return","right","right1","right2","rows","rowset","scan","scope","self","separator","service","shared","skew","skip","smart","soapaction","sql","stable","store","terminator","thor","threshold","timelimit","timeout","token","transform","trim","type","unicodeorder","unordered","unsorted","unstable","update","use","validate","virtual","whole","width","wild","within","wnotrim","xml","xpath"],functions:["abs","acos","aggregate","allnodes","apply","ascii","asin","assert","asstring","atan","atan2","ave","build","buildindex","case","catch","choose","choosen","choosesets","clustersize","combine","correlation","cos","cosh","count","covariance","cron","dataset","dedup","define","denormalize","dictionary","distribute","distributed","distribution","ebcdic","enth","error","evaluate","event","eventextra","eventname","exists","exp","fail","failcode","failmessage","fetch","fromunicode","fromxml","getenv","getisvalid","global","graph","group","hash","hash32","hash64","hashcrc","hashmd5","having","httpcall","httpheader","if","iff","index","intformat","isvalid","iterate","join","keydiff","keypatch","keyunicode","length","library","limit","ln","loadxml","local","log","loop","map","matched","matchlength","matchposition","matchtext","matchunicode","max","merge","mergejoin","min","nofold","nolocal","nonempty","normalize","nothor","notify","output","parallel","parse","pipe","power","preload","process","project","pull","random","range","rank","ranked","realformat","recordof","regexfind","regexreplace","regroup","rejected","rollup","round","roundup","row","rowdiff","sample","sequential","set","sin","sinh","sizeof","soapcall","sort","sorted","sqrt","stepped","stored","sum","table","tan","tanh","thisnode","topn","tounicode","toxml","transfer","transform","trim","truncate","typeof","ungroup","unicodeorder","variance","wait","which","workunit","xmldecode","xmlencode","xmltext","xmlunicode"],typesint:["integer","unsigned"].join("|"),typesnum:["data","qstring","string","unicode","utf8","varstring","varunicode"],typesone:["ascii","big_endian","boolean","data","decimal","ebcdic","grouped","integer","linkcounted","pattern","qstring","real","record","rule","set of","streamed","string","token","udecimal","unicode","unsigned","utf8","varstring","varunicode"].join("|"),operators:["+","-","/",":=","<","<>","=",">","\\","and","in","not","or"],symbols:/[=><!~?:&|+\-*\/\^%]+/,escapes:/\\(?:[abfnrtv\\"']|x[0-9A-Fa-f]{1,4}|u[0-9A-Fa-f]{4}|U[0-9A-Fa-f]{8})/,tokenizer:{root:[[/@typesint[4|8]/,"type"],[/#(@pounds)/,"type"],[/@typesone/,"type"],[/[a-zA-Z_$][\w-$]*/,{cases:{"@functions":"keyword.function","@keywords":"keyword","@operators":"operator"}}],{include:"@whitespace"},[/[{}()\[\]]/,"@brackets"],[/[<>](?!@symbols)/,"@brackets"],[/@symbols/,{cases:{"@operators":"delimiter","@default":""}}],[/[0-9_]*\.[0-9_]+([eE][\-+]?\d+)?/,"number.float"],[/0[xX][0-9a-fA-F_]+/,"number.hex"],[/0[bB][01]+/,"number.hex"],[/[0-9_]+/,"number"],[/[;,.]/,"delimiter"],[/"([^"\\]|\\.)*$/,"string.invalid"],[/"/,"string","@string"],[/'[^\\']'/,"string"],[/(')(@escapes)(')/,["string","string.escape","string"]],[/'/,"string.invalid"]],whitespace:[[/[ \t\v\f\r\n]+/,""],[/\/\*/,"comment","@comment"],[/\/\/.*$/,"comment"]],comment:[[/[^\/*]+/,"comment"],[/\*\//,"comment","@pop"],[/[\/*]/,"comment"]],string:[[/[^\\']+/,"string"],[/@escapes/,"string.escape"],[/\\./,"string.escape.invalid"],[/'/,"string","@pop"]]}}},35993:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return n},language:function(){return o}});
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
var n={comments:{lineComment:"#"},brackets:[["{","}"],["[","]"],["(",")"]],surroundingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:"'",close:"'"},{open:'"',close:'"'}],autoClosingPairs:[{open:"'",close:"'",notIn:["string","comment"]},{open:'"',close:'"',notIn:["comment"]},{open:'"""',close:'"""'},{open:"`",close:"`",notIn:["string","comment"]},{open:"(",close:")"},{open:"{",close:"}"},{open:"[",close:"]"},{open:"<<",close:">>"}],indentationRules:{increaseIndentPattern:/^\s*(after|else|catch|rescue|fn|[^#]*(do|<\-|\->|\{|\[|\=))\s*$/,decreaseIndentPattern:/^\s*((\}|\])\s*$|(after|else|catch|rescue|end)\b)/}},o={defaultToken:"source",tokenPostfix:".elixir",brackets:[{open:"[",close:"]",token:"delimiter.square"},{open:"(",close:")",token:"delimiter.parenthesis"},{open:"{",close:"}",token:"delimiter.curly"},{open:"<<",close:">>",token:"delimiter.angle.special"}],declarationKeywords:["def","defp","defn","defnp","defguard","defguardp","defmacro","defmacrop","defdelegate","defcallback","defmacrocallback","defmodule","defprotocol","defexception","defimpl","defstruct"],operatorKeywords:["and","in","not","or","when"],namespaceKeywords:["alias","import","require","use"],otherKeywords:["after","case","catch","cond","do","else","end","fn","for","if","quote","raise","receive","rescue","super","throw","try","unless","unquote_splicing","unquote","with"],constants:["true","false","nil"],nameBuiltin:["__MODULE__","__DIR__","__ENV__","__CALLER__","__STACKTRACE__"],operator:/-[->]?|!={0,2}|\*{1,2}|\/|\\\\|&{1,3}|\.\.?|\^(?:\^\^)?|\+\+?|<(?:-|<<|=|>|\|>|~>?)?|=~|={1,3}|>(?:=|>>)?|\|~>|\|>|\|{1,3}|~>>?|~~~|::/,variableName:/[a-z_][a-zA-Z0-9_]*[?!]?/,atomName:/[a-zA-Z_][a-zA-Z0-9_@]*[?!]?|@specialAtomName|@operator/,specialAtomName:/\.\.\.|<<>>|%\{\}|%|\{\}/,aliasPart:/[A-Z][a-zA-Z0-9_]*/,moduleName:/@aliasPart(?:\.@aliasPart)*/,sigilSymmetricDelimiter:/"""|'''|"|'|\/|\|/,sigilStartDelimiter:/@sigilSymmetricDelimiter|<|\{|\[|\(/,sigilEndDelimiter:/@sigilSymmetricDelimiter|>|\}|\]|\)/,sigilModifiers:/[a-zA-Z0-9]*/,decimal:/\d(?:_?\d)*/,hex:/[0-9a-fA-F](_?[0-9a-fA-F])*/,octal:/[0-7](_?[0-7])*/,binary:/[01](_?[01])*/,escape:/\\u[0-9a-fA-F]{4}|\\x[0-9a-fA-F]{2}|\\./,tokenizer:{root:[{include:"@whitespace"},{include:"@comments"},{include:"@keywordsShorthand"},{include:"@numbers"},{include:"@identifiers"},{include:"@strings"},{include:"@atoms"},{include:"@sigils"},{include:"@attributes"},{include:"@symbols"}],whitespace:[[/\s+/,"white"]],comments:[[/(#)(.*)/,["comment.punctuation","comment"]]],keywordsShorthand:[[/(@atomName)(:)/,["constant","constant.punctuation"]],[/"(?=([^"]|#\{.*?\}|\\")*":)/,{token:"constant.delimiter",next:"@doubleQuotedStringKeyword"}],[/'(?=([^']|#\{.*?\}|\\')*':)/,{token:"constant.delimiter",next:"@singleQuotedStringKeyword"}]],doubleQuotedStringKeyword:[[/":/,{token:"constant.delimiter",next:"@pop"}],{include:"@stringConstantContentInterpol"}],singleQuotedStringKeyword:[[/':/,{token:"constant.delimiter",next:"@pop"}],{include:"@stringConstantContentInterpol"}],numbers:[[/0b@binary/,"number.binary"],[/0o@octal/,"number.octal"],[/0x@hex/,"number.hex"],[/@decimal\.@decimal([eE]-?@decimal)?/,"number.float"],[/@decimal/,"number"]],identifiers:[[/\b(defp?|defnp?|defmacrop?|defguardp?|defdelegate)(\s+)(@variableName)(?!\s+@operator)/,["keyword.declaration","white",{cases:{unquote:"keyword","@default":"function"}}]],[/(@variableName)(?=\s*\.?\s*\()/,{cases:{"@declarationKeywords":"keyword.declaration","@namespaceKeywords":"keyword","@otherKeywords":"keyword","@default":"function.call"}}],[/(@moduleName)(\s*)(\.)(\s*)(@variableName)/,["type.identifier","white","operator","white","function.call"]],[/(:)(@atomName)(\s*)(\.)(\s*)(@variableName)/,["constant.punctuation","constant","white","operator","white","function.call"]],[/(\|>)(\s*)(@variableName)/,["operator","white",{cases:{"@otherKeywords":"keyword","@default":"function.call"}}]],[/(&)(\s*)(@variableName)/,["operator","white","function.call"]],[/@variableName/,{cases:{"@declarationKeywords":"keyword.declaration","@operatorKeywords":"keyword.operator","@namespaceKeywords":"keyword","@otherKeywords":"keyword","@constants":"constant.language","@nameBuiltin":"variable.language","_.*":"comment.unused","@default":"identifier"}}],[/@moduleName/,"type.identifier"]],strings:[[/"""/,{token:"string.delimiter",next:"@doubleQuotedHeredoc"}],[/'''/,{token:"string.delimiter",next:"@singleQuotedHeredoc"}],[/"/,{token:"string.delimiter",next:"@doubleQuotedString"}],[/'/,{token:"string.delimiter",next:"@singleQuotedString"}]],doubleQuotedHeredoc:[[/"""/,{token:"string.delimiter",next:"@pop"}],{include:"@stringContentInterpol"}],singleQuotedHeredoc:[[/'''/,{token:"string.delimiter",next:"@pop"}],{include:"@stringContentInterpol"}],doubleQuotedString:[[/"/,{token:"string.delimiter",next:"@pop"}],{include:"@stringContentInterpol"}],singleQuotedString:[[/'/,{token:"string.delimiter",next:"@pop"}],{include:"@stringContentInterpol"}],atoms:[[/(:)(@atomName)/,["constant.punctuation","constant"]],[/:"/,{token:"constant.delimiter",next:"@doubleQuotedStringAtom"}],[/:'/,{token:"constant.delimiter",next:"@singleQuotedStringAtom"}]],doubleQuotedStringAtom:[[/"/,{token:"constant.delimiter",next:"@pop"}],{include:"@stringConstantContentInterpol"}],singleQuotedStringAtom:[[/'/,{token:"constant.delimiter",next:"@pop"}],{include:"@stringConstantContentInterpol"}],sigils:[[/~[a-z]@sigilStartDelimiter/,{token:"@rematch",next:"@sigil.interpol"}],[/~[A-Z]@sigilStartDelimiter/,{token:"@rematch",next:"@sigil.noInterpol"}]],sigil:[[/~([a-zA-Z])\{/,{token:"@rematch",switchTo:"@sigilStart.$S2.$1.{.}"}],[/~([a-zA-Z])\[/,{token:"@rematch",switchTo:"@sigilStart.$S2.$1.[.]"}],[/~([a-zA-Z])\(/,{token:"@rematch",switchTo:"@sigilStart.$S2.$1.(.)"}],[/~([a-zA-Z])\</,{token:"@rematch",switchTo:"@sigilStart.$S2.$1.<.>"}],[/~([a-zA-Z])(@sigilSymmetricDelimiter)/,{token:"@rematch",switchTo:"@sigilStart.$S2.$1.$2.$2"}]],"sigilStart.interpol.s":[[/~s@sigilStartDelimiter/,{token:"string.delimiter",switchTo:"@sigilContinue.$S2.$S3.$S4.$S5"}]],"sigilContinue.interpol.s":[[/(@sigilEndDelimiter)@sigilModifiers/,{cases:{"$1==$S5":{token:"string.delimiter",next:"@pop"},"@default":"string"}}],{include:"@stringContentInterpol"}],"sigilStart.noInterpol.S":[[/~S@sigilStartDelimiter/,{token:"string.delimiter",switchTo:"@sigilContinue.$S2.$S3.$S4.$S5"}]],"sigilContinue.noInterpol.S":[[/(^|[^\\])\\@sigilEndDelimiter/,"string"],[/(@sigilEndDelimiter)@sigilModifiers/,{cases:{"$1==$S5":{token:"string.delimiter",next:"@pop"},"@default":"string"}}],{include:"@stringContent"}],"sigilStart.interpol.r":[[/~r@sigilStartDelimiter/,{token:"regexp.delimiter",switchTo:"@sigilContinue.$S2.$S3.$S4.$S5"}]],"sigilContinue.interpol.r":[[/(@sigilEndDelimiter)@sigilModifiers/,{cases:{"$1==$S5":{token:"regexp.delimiter",next:"@pop"},"@default":"regexp"}}],{include:"@regexpContentInterpol"}],"sigilStart.noInterpol.R":[[/~R@sigilStartDelimiter/,{token:"regexp.delimiter",switchTo:"@sigilContinue.$S2.$S3.$S4.$S5"}]],"sigilContinue.noInterpol.R":[[/(^|[^\\])\\@sigilEndDelimiter/,"regexp"],[/(@sigilEndDelimiter)@sigilModifiers/,{cases:{"$1==$S5":{token:"regexp.delimiter",next:"@pop"},"@default":"regexp"}}],{include:"@regexpContent"}],"sigilStart.interpol":[[/~([a-zA-Z])@sigilStartDelimiter/,{token:"sigil.delimiter",switchTo:"@sigilContinue.$S2.$S3.$S4.$S5"}]],"sigilContinue.interpol":[[/(@sigilEndDelimiter)@sigilModifiers/,{cases:{"$1==$S5":{token:"sigil.delimiter",next:"@pop"},"@default":"sigil"}}],{include:"@sigilContentInterpol"}],"sigilStart.noInterpol":[[/~([a-zA-Z])@sigilStartDelimiter/,{token:"sigil.delimiter",switchTo:"@sigilContinue.$S2.$S3.$S4.$S5"}]],"sigilContinue.noInterpol":[[/(^|[^\\])\\@sigilEndDelimiter/,"sigil"],[/(@sigilEndDelimiter)@sigilModifiers/,{cases:{"$1==$S5":{token:"sigil.delimiter",next:"@pop"},"@default":"sigil"}}],{include:"@sigilContent"}],attributes:[[/\@(module|type)?doc (~[sS])?"""/,{token:"comment.block.documentation",next:"@doubleQuotedHeredocDocstring"}],[/\@(module|type)?doc (~[sS])?"/,{token:"comment.block.documentation",next:"@doubleQuotedStringDocstring"}],[/\@(module|type)?doc false/,"comment.block.documentation"],[/\@(@variableName)/,"variable"]],doubleQuotedHeredocDocstring:[[/"""/,{token:"comment.block.documentation",next:"@pop"}],{include:"@docstringContent"}],doubleQuotedStringDocstring:[[/"/,{token:"comment.block.documentation",next:"@pop"}],{include:"@docstringContent"}],symbols:[[/\?(\\.|[^\\\s])/,"number.constant"],[/&\d+/,"operator"],[/<<<|>>>/,"operator"],[/[()\[\]\{\}]|<<|>>/,"@brackets"],[/\.\.\./,"identifier"],[/=>/,"punctuation"],[/@operator/,"operator"],[/[:;,.%]/,"punctuation"]],stringContentInterpol:[{include:"@interpolation"},{include:"@escapeChar"},{include:"@stringContent"}],stringContent:[[/./,"string"]],stringConstantContentInterpol:[{include:"@interpolation"},{include:"@escapeChar"},{include:"@stringConstantContent"}],stringConstantContent:[[/./,"constant"]],regexpContentInterpol:[{include:"@interpolation"},{include:"@escapeChar"},{include:"@regexpContent"}],regexpContent:[[/(\s)(#)(\s.*)$/,["white","comment.punctuation","comment"]],[/./,"regexp"]],sigilContentInterpol:[{include:"@interpolation"},{include:"@escapeChar"},{include:"@sigilContent"}],sigilContent:[[/./,"sigil"]],docstringContent:[[/./,"comment.block.documentation"]],escapeChar:[[/@escape/,"constant.character.escape"]],interpolation:[[/#{/,{token:"delimiter.bracket.embed",next:"@interpolationContinue"}]],interpolationContinue:[[/}/,{token:"delimiter.bracket.embed",next:"@pop"}],{include:"@root"}]}}},10127:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return n},language:function(){return o}});
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
var n={comments:{blockComment:["/*","*/"],lineComment:"//"},brackets:[["{","}"],["[","]"],["(",")"]],autoClosingPairs:[{open:"{",close:"}",notIn:["string"]},{open:"[",close:"]",notIn:["string"]},{open:"(",close:")",notIn:["string"]},{open:'"',close:'"',notIn:["string"]},{open:"'",close:"'",notIn:["string"]}],surroundingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"'},{open:"'",close:"'"},{open:"<",close:">"}]},o={defaultToken:"",tokenPostfix:".flow",keywords:["import","require","export","forbid","native","if","else","cast","unsafe","switch","default"],types:["io","mutable","bool","int","double","string","flow","void","ref","true","false","with"],operators:["=",">","<","<=",">=","==","!","!=",":=","::=","&&","||","+","-","*","/","@","&","%",":","->","\\","$","??","^"],symbols:/[@$=><!~?:&|+\-*\\\/\^%]+/,escapes:/\\(?:[abfnrtv\\"']|x[0-9A-Fa-f]{1,4}|u[0-9A-Fa-f]{4}|U[0-9A-Fa-f]{8})/,tokenizer:{root:[[/[a-zA-Z_]\w*/,{cases:{"@keywords":"keyword","@types":"type","@default":"identifier"}}],{include:"@whitespace"},[/[{}()\[\]]/,"delimiter"],[/[<>](?!@symbols)/,"delimiter"],[/@symbols/,{cases:{"@operators":"delimiter","@default":""}}],[/((0(x|X)[0-9a-fA-F]*)|(([0-9]+\.?[0-9]*)|(\.[0-9]+))((e|E)(\+|-)?[0-9]+)?)/,"number"],[/[;,.]/,"delimiter"],[/"([^"\\]|\\.)*$/,"string.invalid"],[/"/,"string","@string"]],whitespace:[[/[ \t\r\n]+/,""],[/\/\*/,"comment","@comment"],[/\/\/.*$/,"comment"]],comment:[[/[^\/*]+/,"comment"],[/\*\//,"comment","@pop"],[/[\/*]/,"comment"]],string:[[/[^\\"]+/,"string"],[/@escapes/,"string.escape"],[/\\./,"string.escape.invalid"],[/"/,"string","@pop"]]}}},94255:function(e,t,i){"use strict";i.r(t),i.d(t,{TagAngleInterpolationBracket:function(){return x},TagAngleInterpolationDollar:function(){return y},TagAutoInterpolationBracket:function(){return I},TagAutoInterpolationDollar:function(){return k},TagBracketInterpolationBracket:function(){return E},TagBracketInterpolationDollar:function(){return S}});var n,o,r=i(57768),s=Object.defineProperty,a=Object.getOwnPropertyDescriptor,l=Object.getOwnPropertyNames,c=Object.prototype.hasOwnProperty,d=(e,t,i,n)=>{if(t&&"object"==typeof t||"function"==typeof t)for(let o of l(t))c.call(e,o)||o===i||s(e,o,{get:()=>t[o],enumerable:!(n=a(t,o))||n.enumerable});return e},u={};
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/d(u,n=r,"default"),o&&d(o,n,"default");var h=["assign","flush","ftl","return","global","import","include","break","continue","local","nested","nt","setting","stop","t","lt","rt","fallback"],g=["attempt","autoesc","autoEsc","compress","comment","escape","noescape","function","if","list","items","sep","macro","noparse","noParse","noautoesc","noAutoEsc","outputformat","switch","visit","recurse"],p={close:">",id:"angle",open:"<"},m={close:"\\]",id:"bracket",open:"\\["},f={close:"[>\\]]",id:"auto",open:"[<\\[]"},b={close:"\\}",id:"dollar",open1:"\\$",open2:"\\{"},_={close:"\\]",id:"bracket",open1:"\\[",open2:"="};function A(e){return{brackets:[["<",">"],["[","]"],["(",")"],["{","}"]],comments:{blockComment:[`${e.open}--`,`--${e.close}`]},autoCloseBefore:"\n\r\t }]),.:;=",autoClosingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"',notIn:["string"]},{open:"'",close:"'",notIn:["string"]}],surroundingPairs:[{open:'"',close:'"'},{open:"'",close:"'"},{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:"<",close:">"}],folding:{markers:{start:new RegExp(`${e.open}#(?:${g.join("|")})([^/${e.close}]*(?!/)${e.close})[^${e.open}]*$`),end:new RegExp(`${e.open}/#(?:${g.join("|")})[\\r\\n\\t ]*>`)}},onEnterRules:[{beforeText:new RegExp(`${e.open}#(?!(?:${h.join("|")}))([a-zA-Z_]+)([^/${e.close}]*(?!/)${e.close})[^${e.open}]*$`),afterText:new RegExp(`^${e.open}/#([a-zA-Z_]+)[\\r\\n\\t ]*${e.close}$`),action:{indentAction:u.languages.IndentAction.IndentOutdent}},{beforeText:new RegExp(`${e.open}#(?!(?:${h.join("|")}))([a-zA-Z_]+)([^/${e.close}]*(?!/)${e.close})[^${e.open}]*$`),action:{indentAction:u.languages.IndentAction.Indent}}]}}function v(){return{brackets:[["<",">"],["[","]"],["(",")"],["{","}"]],autoCloseBefore:"\n\r\t }]),.:;=",autoClosingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"',notIn:["string"]},{open:"'",close:"'",notIn:["string"]}],surroundingPairs:[{open:'"',close:'"'},{open:"'",close:"'"},{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:"<",close:">"}],folding:{markers:{start:new RegExp(`[<\\[]#(?:${g.join("|")})([^/>\\]]*(?!/)[>\\]])[^<\\[]*$`),end:new RegExp(`[<\\[]/#(?:${g.join("|")})[\\r\\n\\t ]*>`)}},onEnterRules:[{beforeText:new RegExp(`[<\\[]#(?!(?:${h.join("|")}))([a-zA-Z_]+)([^/>\\]]*(?!/)[>\\]])[^[<\\[]]*$`),afterText:new RegExp("^[<\\[]/#([a-zA-Z_]+)[\\r\\n\\t ]*[>\\]]$"),action:{indentAction:u.languages.IndentAction.IndentOutdent}},{beforeText:new RegExp(`[<\\[]#(?!(?:${h.join("|")}))([a-zA-Z_]+)([^/>\\]]*(?!/)[>\\]])[^[<\\[]]*$`),action:{indentAction:u.languages.IndentAction.Indent}}]}}function C(e,t){const i=`_${e.id}_${t.id}`,n=e=>e.replace(/__id__/g,i),o=e=>{const t=e.source.replace(/__id__/g,i);return new RegExp(t,e.flags)};return{unicode:!0,includeLF:!1,start:n("default__id__"),ignoreCase:!1,defaultToken:"invalid",tokenPostfix:".freemarker2",brackets:[{open:"{",close:"}",token:"delimiter.curly"},{open:"[",close:"]",token:"delimiter.square"},{open:"(",close:")",token:"delimiter.parenthesis"},{open:"<",close:">",token:"delimiter.angle"}],[n("open__id__")]:new RegExp(e.open),[n("close__id__")]:new RegExp(e.close),[n("iOpen1__id__")]:new RegExp(t.open1),[n("iOpen2__id__")]:new RegExp(t.open2),[n("iClose__id__")]:new RegExp(t.close),[n("startTag__id__")]:o(/(@open__id__)(#)/),[n("endTag__id__")]:o(/(@open__id__)(\/#)/),[n("startOrEndTag__id__")]:o(/(@open__id__)(\/?#)/),[n("closeTag1__id__")]:o(/((?:@blank)*)(@close__id__)/),[n("closeTag2__id__")]:o(/((?:@blank)*\/?)(@close__id__)/),blank:/[ \t\n\r]/,keywords:["false","true","in","as","using"],directiveStartCloseTag1:/attempt|recover|sep|auto[eE]sc|no(?:autoe|AutoE)sc|compress|default|no[eE]scape|comment|no[pP]arse/,directiveStartCloseTag2:/else|break|continue|return|stop|flush|t|lt|rt|nt|nested|recurse|fallback|ftl/,directiveStartBlank:/if|else[iI]f|list|for[eE]ach|switch|case|assign|global|local|include|import|function|macro|transform|visit|stop|return|call|setting|output[fF]ormat|nested|recurse|escape|ftl|items/,directiveEndCloseTag1:/if|list|items|sep|recover|attempt|for[eE]ach|local|global|assign|function|macro|output[fF]ormat|auto[eE]sc|no(?:autoe|AutoE)sc|compress|transform|switch|escape|no[eE]scape/,escapedChar:/\\(?:[ntrfbgla\\'"\{=]|(?:x[0-9A-Fa-f]{1,4}))/,asciiDigit:/[0-9]/,integer:/[0-9]+/,nonEscapedIdStartChar:/[\$@-Z_a-z\u00AA\u00B5\u00BA\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u1FFF\u2071\u207F\u2090-\u209C\u2102\u2107\u210A-\u2113\u2115\u2119-\u211D\u2124\u2126\u2128\u212A-\u212D\u212F-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2183-\u2184\u2C00-\u2C2E\u2C30-\u2C5E\u2C60-\u2CE4\u2CEB-\u2CEE\u2CF2-\u2CF3\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D80-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u2E2F\u3005-\u3006\u3031-\u3035\u303B-\u303C\u3040-\u318F\u31A0-\u31BA\u31F0-\u31FF\u3300-\u337F\u3400-\u4DB5\u4E00-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA62B\uA640-\uA66E\uA67F-\uA697\uA6A0-\uA6E5\uA717-\uA71F\uA722-\uA788\uA78B-\uA78E\uA790-\uA793\uA7A0-\uA7AA\uA7F8-\uA801\uA803-\uA805\uA807-\uA80A\uA80C-\uA822\uA840-\uA873\uA882-\uA8B3\uA8D0-\uA8D9\uA8F2-\uA8F7\uA8FB\uA900-\uA925\uA930-\uA946\uA960-\uA97C\uA984-\uA9B2\uA9CF-\uA9D9\uAA00-\uAA28\uAA40-\uAA42\uAA44-\uAA4B\uAA50-\uAA59\uAA60-\uAA76\uAA7A\uAA80-\uAAAF\uAAB1\uAAB5-\uAAB6\uAAB9-\uAABD\uAAC0\uAAC2\uAADB-\uAADD\uAAE0-\uAAEA\uAAF2-\uAAF4\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uABC0-\uABE2\uABF0-\uABF9\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFB06\uFB13-\uFB17\uFB1D\uFB1F-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40-\uFB41\uFB43-\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE70-\uFE74\uFE76-\uFEFC\uFF10-\uFF19\uFF21-\uFF3A\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC]/,escapedIdChar:/\\[\-\.:#]/,idStartChar:/(?:@nonEscapedIdStartChar)|(?:@escapedIdChar)/,id:/(?:@idStartChar)(?:(?:@idStartChar)|(?:@asciiDigit))*/,specialHashKeys:/\*\*|\*|false|true|in|as|using/,namedSymbols:/&lt;=|&gt;=|\\lte|\\lt|&lt;|\\gte|\\gt|&gt;|&amp;&amp;|\\and|-&gt;|->|==|!=|\+=|-=|\*=|\/=|%=|\+\+|--|<=|&&|\|\||:|\.\.\.|\.\.\*|\.\.<|\.\.!|\?\?|=|<|\+|-|\*|\/|%|\||\.\.|\?|!|&|\.|,|;/,arrows:["->","-&gt;"],delimiters:[";",":",",","."],stringOperators:["lte","lt","gte","gt"],noParseTags:["noparse","noParse","comment"],tokenizer:{[n("default__id__")]:[{include:n("@directive_token__id__")},{include:n("@interpolation_and_text_token__id__")}],[n("fmExpression__id__.directive")]:[{include:n("@blank_and_expression_comment_token__id__")},{include:n("@directive_end_token__id__")},{include:n("@expression_token__id__")}],[n("fmExpression__id__.interpolation")]:[{include:n("@blank_and_expression_comment_token__id__")},{include:n("@expression_token__id__")},{include:n("@greater_operators_token__id__")}],[n("inParen__id__.plain")]:[{include:n("@blank_and_expression_comment_token__id__")},{include:n("@directive_end_token__id__")},{include:n("@expression_token__id__")}],[n("inParen__id__.gt")]:[{include:n("@blank_and_expression_comment_token__id__")},{include:n("@expression_token__id__")},{include:n("@greater_operators_token__id__")}],[n("noSpaceExpression__id__")]:[{include:n("@no_space_expression_end_token__id__")},{include:n("@directive_end_token__id__")},{include:n("@expression_token__id__")}],[n("unifiedCall__id__")]:[{include:n("@unified_call_token__id__")}],[n("singleString__id__")]:[{include:n("@string_single_token__id__")}],[n("doubleString__id__")]:[{include:n("@string_double_token__id__")}],[n("rawSingleString__id__")]:[{include:n("@string_single_raw_token__id__")}],[n("rawDoubleString__id__")]:[{include:n("@string_double_raw_token__id__")}],[n("expressionComment__id__")]:[{include:n("@expression_comment_token__id__")}],[n("noParse__id__")]:[{include:n("@no_parse_token__id__")}],[n("terseComment__id__")]:[{include:n("@terse_comment_token__id__")}],[n("directive_token__id__")]:[[o(/(?:@startTag__id__)(@directiveStartCloseTag1)(?:@closeTag1__id__)/),"auto"===e.id?{cases:{"$1==<":{token:"@rematch",switchTo:`@default_angle_${t.id}`},"$1==[":{token:"@rematch",switchTo:`@default_bracket_${t.id}`}}}:[{token:"@brackets.directive"},{token:"delimiter.directive"},{cases:{"@noParseTags":{token:"tag",next:n("@noParse__id__.$3")},"@default":{token:"tag"}}},{token:"delimiter.directive"},{token:"@brackets.directive"}]],[o(/(?:@startTag__id__)(@directiveStartCloseTag2)(?:@closeTag2__id__)/),"auto"===e.id?{cases:{"$1==<":{token:"@rematch",switchTo:`@default_angle_${t.id}`},"$1==[":{token:"@rematch",switchTo:`@default_bracket_${t.id}`}}}:[{token:"@brackets.directive"},{token:"delimiter.directive"},{token:"tag"},{token:"delimiter.directive"},{token:"@brackets.directive"}]],[o(/(?:@startTag__id__)(@directiveStartBlank)(@blank)/),"auto"===e.id?{cases:{"$1==<":{token:"@rematch",switchTo:`@default_angle_${t.id}`},"$1==[":{token:"@rematch",switchTo:`@default_bracket_${t.id}`}}}:[{token:"@brackets.directive"},{token:"delimiter.directive"},{token:"tag"},{token:"",next:n("@fmExpression__id__.directive")}]],[o(/(?:@endTag__id__)(@directiveEndCloseTag1)(?:@closeTag1__id__)/),"auto"===e.id?{cases:{"$1==<":{token:"@rematch",switchTo:`@default_angle_${t.id}`},"$1==[":{token:"@rematch",switchTo:`@default_bracket_${t.id}`}}}:[{token:"@brackets.directive"},{token:"delimiter.directive"},{token:"tag"},{token:"delimiter.directive"},{token:"@brackets.directive"}]],[o(/(@open__id__)(@)/),"auto"===e.id?{cases:{"$1==<":{token:"@rematch",switchTo:`@default_angle_${t.id}`},"$1==[":{token:"@rematch",switchTo:`@default_bracket_${t.id}`}}}:[{token:"@brackets.directive"},{token:"delimiter.directive",next:n("@unifiedCall__id__")}]],[o(/(@open__id__)(\/@)((?:(?:@id)(?:\.(?:@id))*)?)(?:@closeTag1__id__)/),[{token:"@brackets.directive"},{token:"delimiter.directive"},{token:"tag"},{token:"delimiter.directive"},{token:"@brackets.directive"}]],[o(/(@open__id__)#--/),"auto"===e.id?{cases:{"$1==<":{token:"@rematch",switchTo:`@default_angle_${t.id}`},"$1==[":{token:"@rematch",switchTo:`@default_bracket_${t.id}`}}}:{token:"comment",next:n("@terseComment__id__")}],[o(/(?:@startOrEndTag__id__)([a-zA-Z_]+)/),"auto"===e.id?{cases:{"$1==<":{token:"@rematch",switchTo:`@default_angle_${t.id}`},"$1==[":{token:"@rematch",switchTo:`@default_bracket_${t.id}`}}}:[{token:"@brackets.directive"},{token:"delimiter.directive"},{token:"tag.invalid",next:n("@fmExpression__id__.directive")}]]],[n("interpolation_and_text_token__id__")]:[[o(/(@iOpen1__id__)(@iOpen2__id__)/),[{token:"bracket"===t.id?"@brackets.interpolation":"delimiter.interpolation"},{token:"bracket"===t.id?"delimiter.interpolation":"@brackets.interpolation",next:n("@fmExpression__id__.interpolation")}]],[/[\$#<\[\{]|(?:@blank)+|[^\$<#\[\{\n\r\t ]+/,{token:"source"}]],[n("string_single_token__id__")]:[[/[^'\\]/,{token:"string"}],[/@escapedChar/,{token:"string.escape"}],[/'/,{token:"string",next:"@pop"}]],[n("string_double_token__id__")]:[[/[^"\\]/,{token:"string"}],[/@escapedChar/,{token:"string.escape"}],[/"/,{token:"string",next:"@pop"}]],[n("string_single_raw_token__id__")]:[[/[^']+/,{token:"string.raw"}],[/'/,{token:"string.raw",next:"@pop"}]],[n("string_double_raw_token__id__")]:[[/[^"]+/,{token:"string.raw"}],[/"/,{token:"string.raw",next:"@pop"}]],[n("expression_token__id__")]:[[/(r?)(['"])/,{cases:{"r'":[{token:"keyword"},{token:"string.raw",next:n("@rawSingleString__id__")}],'r"':[{token:"keyword"},{token:"string.raw",next:n("@rawDoubleString__id__")}],"'":[{token:"source"},{token:"string",next:n("@singleString__id__")}],'"':[{token:"source"},{token:"string",next:n("@doubleString__id__")}]}}],[/(?:@integer)(?:\.(?:@integer))?/,{cases:{"(?:@integer)":{token:"number"},"@default":{token:"number.float"}}}],[/(\.)(@blank*)(@specialHashKeys)/,[{token:"delimiter"},{token:""},{token:"identifier"}]],[/(?:@namedSymbols)/,{cases:{"@arrows":{token:"meta.arrow"},"@delimiters":{token:"delimiter"},"@default":{token:"operators"}}}],[/@id/,{cases:{"@keywords":{token:"keyword.$0"},"@stringOperators":{token:"operators"},"@default":{token:"identifier"}}}],[/[\[\]\(\)\{\}]/,{cases:{"\\[":{cases:{"$S2==gt":{token:"@brackets",next:n("@inParen__id__.gt")},"@default":{token:"@brackets",next:n("@inParen__id__.plain")}}},"\\]":{cases:{..."bracket"===t.id?{"$S2==interpolation":{token:"@brackets.interpolation",next:"@popall"}}:{},..."bracket"===e.id?{"$S2==directive":{token:"@brackets.directive",next:"@popall"}}:{},[n("$S1==inParen__id__")]:{token:"@brackets",next:"@pop"},"@default":{token:"@brackets"}}},"\\(":{token:"@brackets",next:n("@inParen__id__.gt")},"\\)":{cases:{[n("$S1==inParen__id__")]:{token:"@brackets",next:"@pop"},"@default":{token:"@brackets"}}},"\\{":{cases:{"$S2==gt":{token:"@brackets",next:n("@inParen__id__.gt")},"@default":{token:"@brackets",next:n("@inParen__id__.plain")}}},"\\}":{cases:{..."bracket"===t.id?{}:{"$S2==interpolation":{token:"@brackets.interpolation",next:"@popall"}},[n("$S1==inParen__id__")]:{token:"@brackets",next:"@pop"},"@default":{token:"@brackets"}}}}}],[/\$\{/,{token:"delimiter.invalid"}]],[n("blank_and_expression_comment_token__id__")]:[[/(?:@blank)+/,{token:""}],[/[<\[][#!]--/,{token:"comment",next:n("@expressionComment__id__")}]],[n("directive_end_token__id__")]:[[/>/,"bracket"===e.id?{token:"operators"}:{token:"@brackets.directive",next:"@popall"}],[o(/(\/)(@close__id__)/),[{token:"delimiter.directive"},{token:"@brackets.directive",next:"@popall"}]]],[n("greater_operators_token__id__")]:[[/>/,{token:"operators"}],[/>=/,{token:"operators"}]],[n("no_space_expression_end_token__id__")]:[[/(?:@blank)+/,{token:"",switchTo:n("@fmExpression__id__.directive")}]],[n("unified_call_token__id__")]:[[/(@id)((?:@blank)+)/,[{token:"tag"},{token:"",next:n("@fmExpression__id__.directive")}]],[o(/(@id)(\/?)(@close__id__)/),[{token:"tag"},{token:"delimiter.directive"},{token:"@brackets.directive",next:"@popall"}]],[/./,{token:"@rematch",next:n("@noSpaceExpression__id__")}]],[n("no_parse_token__id__")]:[[o(/(@open__id__)(\/#?)([a-zA-Z]+)((?:@blank)*)(@close__id__)/),{cases:{"$S2==$3":[{token:"@brackets.directive"},{token:"delimiter.directive"},{token:"tag"},{token:""},{token:"@brackets.directive",next:"@popall"}],"$S2==comment":[{token:"comment"},{token:"comment"},{token:"comment"},{token:"comment"},{token:"comment"}],"@default":[{token:"source"},{token:"source"},{token:"source"},{token:"source"},{token:"source"}]}}],[/[^<\[\-]+|[<\[\-]/,{cases:{"$S2==comment":{token:"comment"},"@default":{token:"source"}}}]],[n("expression_comment_token__id__")]:[[/--[>\]]/,{token:"comment",next:"@pop"}],[/[^\->\]]+|[>\]\-]/,{token:"comment"}]],[n("terse_comment_token__id__")]:[[o(/--(?:@close__id__)/),{token:"comment",next:"@popall"}],[/[^<\[\-]+|[<\[\-]/,{token:"comment"}]]}}}function w(e){const t=C(p,e),i=C(m,e),n=C(f,e);return{...t,...i,...n,unicode:!0,includeLF:!1,start:`default_auto_${e.id}`,ignoreCase:!1,defaultToken:"invalid",tokenPostfix:".freemarker2",brackets:[{open:"{",close:"}",token:"delimiter.curly"},{open:"[",close:"]",token:"delimiter.square"},{open:"(",close:")",token:"delimiter.parenthesis"},{open:"<",close:">",token:"delimiter.angle"}],tokenizer:{...t.tokenizer,...i.tokenizer,...n.tokenizer}}}var y={conf:A(p),language:C(p,b)},S={conf:A(m),language:C(m,b)},x={conf:A(p),language:C(p,_)},E={conf:A(m),language:C(m,_)},k={conf:v(),language:w(b)},I={conf:v(),language:w(_)}},73567:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return n},language:function(){return o}});
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
var n={comments:{lineComment:"//",blockComment:["(*","*)"]},brackets:[["{","}"],["[","]"],["(",")"]],autoClosingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"'}],surroundingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"'},{open:"'",close:"'"}],folding:{markers:{start:new RegExp("^\\s*//\\s*#region\\b|^\\s*\\(\\*\\s*#region(.*)\\*\\)"),end:new RegExp("^\\s*//\\s*#endregion\\b|^\\s*\\(\\*\\s*#endregion\\s*\\*\\)")}}},o={defaultToken:"",tokenPostfix:".fs",keywords:["abstract","and","atomic","as","assert","asr","base","begin","break","checked","component","const","constraint","constructor","continue","class","default","delegate","do","done","downcast","downto","elif","else","end","exception","eager","event","external","extern","false","finally","for","fun","function","fixed","functor","global","if","in","include","inherit","inline","interface","internal","land","lor","lsl","lsr","lxor","lazy","let","match","member","mod","module","mutable","namespace","method","mixin","new","not","null","of","open","or","object","override","private","parallel","process","protected","pure","public","rec","return","static","sealed","struct","sig","then","to","true","tailcall","trait","try","type","upcast","use","val","void","virtual","volatile","when","while","with","yield"],symbols:/[=><!~?:&|+\-*\^%;\.,\/]+/,escapes:/\\(?:[abfnrtv\\"']|x[0-9A-Fa-f]{1,4}|u[0-9A-Fa-f]{4}|U[0-9A-Fa-f]{8})/,integersuffix:/[uU]?[yslnLI]?/,floatsuffix:/[fFmM]?/,tokenizer:{root:[[/[a-zA-Z_]\w*/,{cases:{"@keywords":{token:"keyword.$0"},"@default":"identifier"}}],{include:"@whitespace"},[/\[<.*>\]/,"annotation"],[/^#(if|else|endif)/,"keyword"],[/[{}()\[\]]/,"@brackets"],[/[<>](?!@symbols)/,"@brackets"],[/@symbols/,"delimiter"],[/\d*\d+[eE]([\-+]?\d+)?(@floatsuffix)/,"number.float"],[/\d*\.\d+([eE][\-+]?\d+)?(@floatsuffix)/,"number.float"],[/0x[0-9a-fA-F]+LF/,"number.float"],[/0x[0-9a-fA-F]+(@integersuffix)/,"number.hex"],[/0b[0-1]+(@integersuffix)/,"number.bin"],[/\d+(@integersuffix)/,"number"],[/[;,.]/,"delimiter"],[/"([^"\\]|\\.)*$/,"string.invalid"],[/"""/,"string",'@string."""'],[/"/,"string",'@string."'],[/\@"/,{token:"string.quote",next:"@litstring"}],[/'[^\\']'B?/,"string"],[/(')(@escapes)(')/,["string","string.escape","string"]],[/'/,"string.invalid"]],whitespace:[[/[ \t\r\n]+/,""],[/\(\*(?!\))/,"comment","@comment"],[/\/\/.*$/,"comment"]],comment:[[/[^*(]+/,"comment"],[/\*\)/,"comment","@pop"],[/\*/,"comment"],[/\(\*\)/,"comment"],[/\(/,"comment"]],string:[[/[^\\"]+/,"string"],[/@escapes/,"string.escape"],[/\\./,"string.escape.invalid"],[/("""|"B?)/,{cases:{"$#==$S2":{token:"string",next:"@pop"},"@default":"string"}}]],litstring:[[/[^"]+/,"string"],[/""/,"string.escape"],[/"/,{token:"string.quote",next:"@pop"}]]}}},62823:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return n},language:function(){return o}});
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
var n={comments:{lineComment:"//",blockComment:["/*","*/"]},brackets:[["{","}"],["[","]"],["(",")"]],autoClosingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:"`",close:"`",notIn:["string"]},{open:'"',close:'"',notIn:["string"]},{open:"'",close:"'",notIn:["string","comment"]}],surroundingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:"`",close:"`"},{open:'"',close:'"'},{open:"'",close:"'"}]},o={defaultToken:"",tokenPostfix:".go",keywords:["break","case","chan","const","continue","default","defer","else","fallthrough","for","func","go","goto","if","import","interface","map","package","range","return","select","struct","switch","type","var","bool","true","false","uint8","uint16","uint32","uint64","int8","int16","int32","int64","float32","float64","complex64","complex128","byte","rune","uint","int","uintptr","string","nil"],operators:["+","-","*","/","%","&","|","^","<<",">>","&^","+=","-=","*=","/=","%=","&=","|=","^=","<<=",">>=","&^=","&&","||","<-","++","--","==","<",">","=","!","!=","<=",">=",":=","...","(",")","","]","{","}",",",";",".",":"],symbols:/[=><!~?:&|+\-*\/\^%]+/,escapes:/\\(?:[abfnrtv\\"']|x[0-9A-Fa-f]{1,4}|u[0-9A-Fa-f]{4}|U[0-9A-Fa-f]{8})/,tokenizer:{root:[[/[a-zA-Z_]\w*/,{cases:{"@keywords":{token:"keyword.$0"},"@default":"identifier"}}],{include:"@whitespace"},[/\[\[.*\]\]/,"annotation"],[/^\s*#\w+/,"keyword"],[/[{}()\[\]]/,"@brackets"],[/[<>](?!@symbols)/,"@brackets"],[/@symbols/,{cases:{"@operators":"delimiter","@default":""}}],[/\d*\d+[eE]([\-+]?\d+)?/,"number.float"],[/\d*\.\d+([eE][\-+]?\d+)?/,"number.float"],[/0[xX][0-9a-fA-F']*[0-9a-fA-F]/,"number.hex"],[/0[0-7']*[0-7]/,"number.octal"],[/0[bB][0-1']*[0-1]/,"number.binary"],[/\d[\d']*/,"number"],[/\d/,"number"],[/[;,.]/,"delimiter"],[/"([^"\\]|\\.)*$/,"string.invalid"],[/"/,"string","@string"],[/`/,"string","@rawstring"],[/'[^\\']'/,"string"],[/(')(@escapes)(')/,["string","string.escape","string"]],[/'/,"string.invalid"]],whitespace:[[/[ \t\r\n]+/,""],[/\/\*\*(?!\/)/,"comment.doc","@doccomment"],[/\/\*/,"comment","@comment"],[/\/\/.*$/,"comment"]],comment:[[/[^\/*]+/,"comment"],[/\*\//,"comment","@pop"],[/[\/*]/,"comment"]],doccomment:[[/[^\/*]+/,"comment.doc"],[/\/\*/,"comment.doc.invalid"],[/\*\//,"comment.doc","@pop"],[/[\/*]/,"comment.doc"]],string:[[/[^\\"]+/,"string"],[/@escapes/,"string.escape"],[/\\./,"string.escape.invalid"],[/"/,"string","@pop"]],rawstring:[[/[^\`]/,"string"],[/`/,"string","@pop"]]}}},35857:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return n},language:function(){return o}});
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
var n={comments:{lineComment:"#"},brackets:[["{","}"],["[","]"],["(",")"]],autoClosingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"""',close:'"""',notIn:["string","comment"]},{open:'"',close:'"',notIn:["string","comment"]}],surroundingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"""',close:'"""'},{open:'"',close:'"'}],folding:{offSide:!0}},o={defaultToken:"invalid",tokenPostfix:".gql",keywords:["null","true","false","query","mutation","subscription","extend","schema","directive","scalar","type","interface","union","enum","input","implements","fragment","on"],typeKeywords:["Int","Float","String","Boolean","ID"],directiveLocations:["SCHEMA","SCALAR","OBJECT","FIELD_DEFINITION","ARGUMENT_DEFINITION","INTERFACE","UNION","ENUM","ENUM_VALUE","INPUT_OBJECT","INPUT_FIELD_DEFINITION","QUERY","MUTATION","SUBSCRIPTION","FIELD","FRAGMENT_DEFINITION","FRAGMENT_SPREAD","INLINE_FRAGMENT","VARIABLE_DEFINITION"],operators:["=","!","?",":","&","|"],symbols:/[=!?:&|]+/,escapes:/\\(?:["\\\/bfnrt]|u[0-9A-Fa-f]{4})/,tokenizer:{root:[[/[a-z_][\w$]*/,{cases:{"@keywords":"keyword","@default":"key.identifier"}}],[/[$][\w$]*/,{cases:{"@keywords":"keyword","@default":"argument.identifier"}}],[/[A-Z][\w\$]*/,{cases:{"@typeKeywords":"keyword","@default":"type.identifier"}}],{include:"@whitespace"},[/[{}()\[\]]/,"@brackets"],[/@symbols/,{cases:{"@operators":"operator","@default":""}}],[/@\s*[a-zA-Z_\$][\w\$]*/,{token:"annotation",log:"annotation token: $0"}],[/\d*\.\d+([eE][\-+]?\d+)?/,"number.float"],[/0[xX][0-9a-fA-F]+/,"number.hex"],[/\d+/,"number"],[/[;,.]/,"delimiter"],[/"""/,{token:"string",next:"@mlstring",nextEmbedded:"markdown"}],[/"([^"\\]|\\.)*$/,"string.invalid"],[/"/,{token:"string.quote",bracket:"@open",next:"@string"}]],mlstring:[[/[^"]+/,"string"],['"""',{token:"string",next:"@pop",nextEmbedded:"@pop"}]],string:[[/[^\\"]+/,"string"],[/@escapes/,"string.escape"],[/\\./,"string.escape.invalid"],[/"/,{token:"string.quote",bracket:"@close",next:"@pop"}]],whitespace:[[/[ \t\r\n]+/,""],[/#.*$/,"comment"]]}}},55055:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return g},language:function(){return p}});var n,o,r=i(57768),s=Object.defineProperty,a=Object.getOwnPropertyDescriptor,l=Object.getOwnPropertyNames,c=Object.prototype.hasOwnProperty,d=(e,t,i,n)=>{if(t&&"object"==typeof t||"function"==typeof t)for(let o of l(t))c.call(e,o)||o===i||s(e,o,{get:()=>t[o],enumerable:!(n=a(t,o))||n.enumerable});return e},u={};
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/d(u,n=r,"default"),o&&d(o,n,"default");var h=["area","base","br","col","embed","hr","img","input","keygen","link","menuitem","meta","param","source","track","wbr"],g={wordPattern:/(-?\d*\.\d\w*)|([^\`\~\!\@\$\^\&\*\(\)\=\+\[\{\]\}\\\|\;\:\'\"\,\.\<\>\/\s]+)/g,comments:{blockComment:["{{!--","--}}"]},brackets:[["\x3c!--","--\x3e"],["<",">"],["{{","}}"],["{","}"],["(",")"]],autoClosingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"'},{open:"'",close:"'"}],surroundingPairs:[{open:"<",close:">"},{open:'"',close:'"'},{open:"'",close:"'"}],onEnterRules:[{beforeText:new RegExp(`<(?!(?:${h.join("|")}))(\\w[\\w\\d]*)([^/>]*(?!/)>)[^<]*$`,"i"),afterText:/^<\/(\w[\w\d]*)\s*>$/i,action:{indentAction:u.languages.IndentAction.IndentOutdent}},{beforeText:new RegExp(`<(?!(?:${h.join("|")}))(\\w[\\w\\d]*)([^/>]*(?!/)>)[^<]*$`,"i"),action:{indentAction:u.languages.IndentAction.Indent}}]},p={defaultToken:"",tokenPostfix:"",tokenizer:{root:[[/\{\{!--/,"comment.block.start.handlebars","@commentBlock"],[/\{\{!/,"comment.start.handlebars","@comment"],[/\{\{/,{token:"@rematch",switchTo:"@handlebarsInSimpleState.root"}],[/<!DOCTYPE/,"metatag.html","@doctype"],[/<!--/,"comment.html","@commentHtml"],[/(<)(\w+)(\/>)/,["delimiter.html","tag.html","delimiter.html"]],[/(<)(script)/,["delimiter.html",{token:"tag.html",next:"@script"}]],[/(<)(style)/,["delimiter.html",{token:"tag.html",next:"@style"}]],[/(<)([:\w]+)/,["delimiter.html",{token:"tag.html",next:"@otherTag"}]],[/(<\/)(\w+)/,["delimiter.html",{token:"tag.html",next:"@otherTag"}]],[/</,"delimiter.html"],[/\{/,"delimiter.html"],[/[^<{]+/]],doctype:[[/\{\{/,{token:"@rematch",switchTo:"@handlebarsInSimpleState.comment"}],[/[^>]+/,"metatag.content.html"],[/>/,"metatag.html","@pop"]],comment:[[/\}\}/,"comment.end.handlebars","@pop"],[/./,"comment.content.handlebars"]],commentBlock:[[/--\}\}/,"comment.block.end.handlebars","@pop"],[/./,"comment.content.handlebars"]],commentHtml:[[/\{\{/,{token:"@rematch",switchTo:"@handlebarsInSimpleState.comment"}],[/-->/,"comment.html","@pop"],[/[^-]+/,"comment.content.html"],[/./,"comment.content.html"]],otherTag:[[/\{\{/,{token:"@rematch",switchTo:"@handlebarsInSimpleState.otherTag"}],[/\/?>/,"delimiter.html","@pop"],[/"([^"]*)"/,"attribute.value"],[/'([^']*)'/,"attribute.value"],[/[\w\-]+/,"attribute.name"],[/=/,"delimiter"],[/[ \t\r\n]+/]],script:[[/\{\{/,{token:"@rematch",switchTo:"@handlebarsInSimpleState.script"}],[/type/,"attribute.name","@scriptAfterType"],[/"([^"]*)"/,"attribute.value"],[/'([^']*)'/,"attribute.value"],[/[\w\-]+/,"attribute.name"],[/=/,"delimiter"],[/>/,{token:"delimiter.html",next:"@scriptEmbedded.text/javascript",nextEmbedded:"text/javascript"}],[/[ \t\r\n]+/],[/(<\/)(script\s*)(>)/,["delimiter.html","tag.html",{token:"delimiter.html",next:"@pop"}]]],scriptAfterType:[[/\{\{/,{token:"@rematch",switchTo:"@handlebarsInSimpleState.scriptAfterType"}],[/=/,"delimiter","@scriptAfterTypeEquals"],[/>/,{token:"delimiter.html",next:"@scriptEmbedded.text/javascript",nextEmbedded:"text/javascript"}],[/[ \t\r\n]+/],[/<\/script\s*>/,{token:"@rematch",next:"@pop"}]],scriptAfterTypeEquals:[[/\{\{/,{token:"@rematch",switchTo:"@handlebarsInSimpleState.scriptAfterTypeEquals"}],[/"([^"]*)"/,{token:"attribute.value",switchTo:"@scriptWithCustomType.$1"}],[/'([^']*)'/,{token:"attribute.value",switchTo:"@scriptWithCustomType.$1"}],[/>/,{token:"delimiter.html",next:"@scriptEmbedded.text/javascript",nextEmbedded:"text/javascript"}],[/[ \t\r\n]+/],[/<\/script\s*>/,{token:"@rematch",next:"@pop"}]],scriptWithCustomType:[[/\{\{/,{token:"@rematch",switchTo:"@handlebarsInSimpleState.scriptWithCustomType.$S2"}],[/>/,{token:"delimiter.html",next:"@scriptEmbedded.$S2",nextEmbedded:"$S2"}],[/"([^"]*)"/,"attribute.value"],[/'([^']*)'/,"attribute.value"],[/[\w\-]+/,"attribute.name"],[/=/,"delimiter"],[/[ \t\r\n]+/],[/<\/script\s*>/,{token:"@rematch",next:"@pop"}]],scriptEmbedded:[[/\{\{/,{token:"@rematch",switchTo:"@handlebarsInEmbeddedState.scriptEmbedded.$S2",nextEmbedded:"@pop"}],[/<\/script/,{token:"@rematch",next:"@pop",nextEmbedded:"@pop"}]],style:[[/\{\{/,{token:"@rematch",switchTo:"@handlebarsInSimpleState.style"}],[/type/,"attribute.name","@styleAfterType"],[/"([^"]*)"/,"attribute.value"],[/'([^']*)'/,"attribute.value"],[/[\w\-]+/,"attribute.name"],[/=/,"delimiter"],[/>/,{token:"delimiter.html",next:"@styleEmbedded.text/css",nextEmbedded:"text/css"}],[/[ \t\r\n]+/],[/(<\/)(style\s*)(>)/,["delimiter.html","tag.html",{token:"delimiter.html",next:"@pop"}]]],styleAfterType:[[/\{\{/,{token:"@rematch",switchTo:"@handlebarsInSimpleState.styleAfterType"}],[/=/,"delimiter","@styleAfterTypeEquals"],[/>/,{token:"delimiter.html",next:"@styleEmbedded.text/css",nextEmbedded:"text/css"}],[/[ \t\r\n]+/],[/<\/style\s*>/,{token:"@rematch",next:"@pop"}]],styleAfterTypeEquals:[[/\{\{/,{token:"@rematch",switchTo:"@handlebarsInSimpleState.styleAfterTypeEquals"}],[/"([^"]*)"/,{token:"attribute.value",switchTo:"@styleWithCustomType.$1"}],[/'([^']*)'/,{token:"attribute.value",switchTo:"@styleWithCustomType.$1"}],[/>/,{token:"delimiter.html",next:"@styleEmbedded.text/css",nextEmbedded:"text/css"}],[/[ \t\r\n]+/],[/<\/style\s*>/,{token:"@rematch",next:"@pop"}]],styleWithCustomType:[[/\{\{/,{token:"@rematch",switchTo:"@handlebarsInSimpleState.styleWithCustomType.$S2"}],[/>/,{token:"delimiter.html",next:"@styleEmbedded.$S2",nextEmbedded:"$S2"}],[/"([^"]*)"/,"attribute.value"],[/'([^']*)'/,"attribute.value"],[/[\w\-]+/,"attribute.name"],[/=/,"delimiter"],[/[ \t\r\n]+/],[/<\/style\s*>/,{token:"@rematch",next:"@pop"}]],styleEmbedded:[[/\{\{/,{token:"@rematch",switchTo:"@handlebarsInEmbeddedState.styleEmbedded.$S2",nextEmbedded:"@pop"}],[/<\/style/,{token:"@rematch",next:"@pop",nextEmbedded:"@pop"}]],handlebarsInSimpleState:[[/\{\{\{?/,"delimiter.handlebars"],[/\}\}\}?/,{token:"delimiter.handlebars",switchTo:"@$S2.$S3"}],{include:"handlebarsRoot"}],handlebarsInEmbeddedState:[[/\{\{\{?/,"delimiter.handlebars"],[/\}\}\}?/,{token:"delimiter.handlebars",switchTo:"@$S2.$S3",nextEmbedded:"$S3"}],{include:"handlebarsRoot"}],handlebarsRoot:[[/"[^"]*"/,"string.handlebars"],[/[#/][^\s}]+/,"keyword.helper.handlebars"],[/else\b/,"keyword.helper.handlebars"],[/[\s]+/],[/[^}]/,"variable.parameter.handlebars"]]}}},12053:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return n},language:function(){return o}});
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
var n={comments:{lineComment:"#",blockComment:["/*","*/"]},brackets:[["{","}"],["[","]"],["(",")"]],autoClosingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"',notIn:["string"]}],surroundingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"'}]},o={defaultToken:"",tokenPostfix:".hcl",keywords:["var","local","path","for_each","any","string","number","bool","true","false","null","if ","else ","endif ","for ","in","endfor"],operators:["=",">=","<=","==","!=","+","-","*","/","%","&&","||","!","<",">","?","...",":"],symbols:/[=><!~?:&|+\-*\/\^%]+/,escapes:/\\(?:[abfnrtv\\"']|x[0-9A-Fa-f]{1,4}|u[0-9A-Fa-f]{4}|U[0-9A-Fa-f]{8})/,terraformFunctions:/(abs|ceil|floor|log|max|min|pow|signum|chomp|format|formatlist|indent|join|lower|regex|regexall|replace|split|strrev|substr|title|trimspace|upper|chunklist|coalesce|coalescelist|compact|concat|contains|distinct|element|flatten|index|keys|length|list|lookup|map|matchkeys|merge|range|reverse|setintersection|setproduct|setunion|slice|sort|transpose|values|zipmap|base64decode|base64encode|base64gzip|csvdecode|jsondecode|jsonencode|urlencode|yamldecode|yamlencode|abspath|dirname|pathexpand|basename|file|fileexists|fileset|filebase64|templatefile|formatdate|timeadd|timestamp|base64sha256|base64sha512|bcrypt|filebase64sha256|filebase64sha512|filemd5|filemd1|filesha256|filesha512|md5|rsadecrypt|sha1|sha256|sha512|uuid|uuidv5|cidrhost|cidrnetmask|cidrsubnet|tobool|tolist|tomap|tonumber|toset|tostring)/,terraformMainBlocks:/(module|data|terraform|resource|provider|variable|output|locals)/,tokenizer:{root:[[/^@terraformMainBlocks([ \t]*)([\w-]+|"[\w-]+"|)([ \t]*)([\w-]+|"[\w-]+"|)([ \t]*)(\{)/,["type","","string","","string","","@brackets"]],[/(\w+[ \t]+)([ \t]*)([\w-]+|"[\w-]+"|)([ \t]*)([\w-]+|"[\w-]+"|)([ \t]*)(\{)/,["identifier","","string","","string","","@brackets"]],[/(\w+[ \t]+)([ \t]*)([\w-]+|"[\w-]+"|)([ \t]*)([\w-]+|"[\w-]+"|)(=)(\{)/,["identifier","","string","","operator","","@brackets"]],{include:"@terraform"}],terraform:[[/@terraformFunctions(\()/,["type","@brackets"]],[/[a-zA-Z_]\w*-*/,{cases:{"@keywords":{token:"keyword.$0"},"@default":"variable"}}],{include:"@whitespace"},{include:"@heredoc"},[/[{}()\[\]]/,"@brackets"],[/[<>](?!@symbols)/,"@brackets"],[/@symbols/,{cases:{"@operators":"operator","@default":""}}],[/\d*\d+[eE]([\-+]?\d+)?/,"number.float"],[/\d*\.\d+([eE][\-+]?\d+)?/,"number.float"],[/\d[\d']*/,"number"],[/\d/,"number"],[/[;,.]/,"delimiter"],[/"/,"string","@string"],[/'/,"invalid"]],heredoc:[[/<<[-]*\s*["]?([\w\-]+)["]?/,{token:"string.heredoc.delimiter",next:"@heredocBody.$1"}]],heredocBody:[[/([\w\-]+)$/,{cases:{"$1==$S2":[{token:"string.heredoc.delimiter",next:"@popall"}],"@default":"string.heredoc"}}],[/./,"string.heredoc"]],whitespace:[[/[ \t\r\n]+/,""],[/\/\*/,"comment","@comment"],[/\/\/.*$/,"comment"],[/#.*$/,"comment"]],comment:[[/[^\/*]+/,"comment"],[/\*\//,"comment","@pop"],[/[\/*]/,"comment"]],string:[[/\$\{/,{token:"delimiter",next:"@stringExpression"}],[/[^\\"\$]+/,"string"],[/@escapes/,"string.escape"],[/\\./,"string.escape.invalid"],[/"/,"string","@popall"]],stringInsideExpression:[[/[^\\"]+/,"string"],[/@escapes/,"string.escape"],[/\\./,"string.escape.invalid"],[/"/,"string","@pop"]],stringExpression:[[/\}/,{token:"delimiter",next:"@pop"}],[/"/,"string","@stringInsideExpression"],{include:"@terraform"}]}}},62642:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return g},language:function(){return p}});var n,o,r=i(57768),s=Object.defineProperty,a=Object.getOwnPropertyDescriptor,l=Object.getOwnPropertyNames,c=Object.prototype.hasOwnProperty,d=(e,t,i,n)=>{if(t&&"object"==typeof t||"function"==typeof t)for(let o of l(t))c.call(e,o)||o===i||s(e,o,{get:()=>t[o],enumerable:!(n=a(t,o))||n.enumerable});return e},u={};
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/d(u,n=r,"default"),o&&d(o,n,"default");var h=["area","base","br","col","embed","hr","img","input","keygen","link","menuitem","meta","param","source","track","wbr"],g={wordPattern:/(-?\d*\.\d\w*)|([^\`\~\!\@\$\^\&\*\(\)\=\+\[\{\]\}\\\|\;\:\'\"\,\.\<\>\/\s]+)/g,comments:{blockComment:["\x3c!--","--\x3e"]},brackets:[["\x3c!--","--\x3e"],["<",">"],["{","}"],["(",")"]],autoClosingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"'},{open:"'",close:"'"}],surroundingPairs:[{open:'"',close:'"'},{open:"'",close:"'"},{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:"<",close:">"}],onEnterRules:[{beforeText:new RegExp(`<(?!(?:${h.join("|")}))([_:\\w][_:\\w-.\\d]*)([^/>]*(?!/)>)[^<]*$`,"i"),afterText:/^<\/([_:\w][_:\w-.\d]*)\s*>$/i,action:{indentAction:u.languages.IndentAction.IndentOutdent}},{beforeText:new RegExp(`<(?!(?:${h.join("|")}))(\\w[\\w\\d]*)([^/>]*(?!/)>)[^<]*$`,"i"),action:{indentAction:u.languages.IndentAction.Indent}}],folding:{markers:{start:new RegExp("^\\s*\x3c!--\\s*#region\\b.*--\x3e"),end:new RegExp("^\\s*\x3c!--\\s*#endregion\\b.*--\x3e")}}},p={defaultToken:"",tokenPostfix:".html",ignoreCase:!0,tokenizer:{root:[[/<!DOCTYPE/,"metatag","@doctype"],[/<!--/,"comment","@comment"],[/(<)((?:[\w\-]+:)?[\w\-]+)(\s*)(\/>)/,["delimiter","tag","","delimiter"]],[/(<)(script)/,["delimiter",{token:"tag",next:"@script"}]],[/(<)(style)/,["delimiter",{token:"tag",next:"@style"}]],[/(<)((?:[\w\-]+:)?[\w\-]+)/,["delimiter",{token:"tag",next:"@otherTag"}]],[/(<\/)((?:[\w\-]+:)?[\w\-]+)/,["delimiter",{token:"tag",next:"@otherTag"}]],[/</,"delimiter"],[/[^<]+/]],doctype:[[/[^>]+/,"metatag.content"],[/>/,"metatag","@pop"]],comment:[[/-->/,"comment","@pop"],[/[^-]+/,"comment.content"],[/./,"comment.content"]],otherTag:[[/\/?>/,"delimiter","@pop"],[/"([^"]*)"/,"attribute.value"],[/'([^']*)'/,"attribute.value"],[/[\w\-]+/,"attribute.name"],[/=/,"delimiter"],[/[ \t\r\n]+/]],script:[[/type/,"attribute.name","@scriptAfterType"],[/"([^"]*)"/,"attribute.value"],[/'([^']*)'/,"attribute.value"],[/[\w\-]+/,"attribute.name"],[/=/,"delimiter"],[/>/,{token:"delimiter",next:"@scriptEmbedded",nextEmbedded:"text/javascript"}],[/[ \t\r\n]+/],[/(<\/)(script\s*)(>)/,["delimiter","tag",{token:"delimiter",next:"@pop"}]]],scriptAfterType:[[/=/,"delimiter","@scriptAfterTypeEquals"],[/>/,{token:"delimiter",next:"@scriptEmbedded",nextEmbedded:"text/javascript"}],[/[ \t\r\n]+/],[/<\/script\s*>/,{token:"@rematch",next:"@pop"}]],scriptAfterTypeEquals:[[/"module"/,{token:"attribute.value",switchTo:"@scriptWithCustomType.text/javascript"}],[/'module'/,{token:"attribute.value",switchTo:"@scriptWithCustomType.text/javascript"}],[/"([^"]*)"/,{token:"attribute.value",switchTo:"@scriptWithCustomType.$1"}],[/'([^']*)'/,{token:"attribute.value",switchTo:"@scriptWithCustomType.$1"}],[/>/,{token:"delimiter",next:"@scriptEmbedded",nextEmbedded:"text/javascript"}],[/[ \t\r\n]+/],[/<\/script\s*>/,{token:"@rematch",next:"@pop"}]],scriptWithCustomType:[[/>/,{token:"delimiter",next:"@scriptEmbedded.$S2",nextEmbedded:"$S2"}],[/"([^"]*)"/,"attribute.value"],[/'([^']*)'/,"attribute.value"],[/[\w\-]+/,"attribute.name"],[/=/,"delimiter"],[/[ \t\r\n]+/],[/<\/script\s*>/,{token:"@rematch",next:"@pop"}]],scriptEmbedded:[[/<\/script/,{token:"@rematch",next:"@pop",nextEmbedded:"@pop"}],[/[^<]+/,""]],style:[[/type/,"attribute.name","@styleAfterType"],[/"([^"]*)"/,"attribute.value"],[/'([^']*)'/,"attribute.value"],[/[\w\-]+/,"attribute.name"],[/=/,"delimiter"],[/>/,{token:"delimiter",next:"@styleEmbedded",nextEmbedded:"text/css"}],[/[ \t\r\n]+/],[/(<\/)(style\s*)(>)/,["delimiter","tag",{token:"delimiter",next:"@pop"}]]],styleAfterType:[[/=/,"delimiter","@styleAfterTypeEquals"],[/>/,{token:"delimiter",next:"@styleEmbedded",nextEmbedded:"text/css"}],[/[ \t\r\n]+/],[/<\/style\s*>/,{token:"@rematch",next:"@pop"}]],styleAfterTypeEquals:[[/"([^"]*)"/,{token:"attribute.value",switchTo:"@styleWithCustomType.$1"}],[/'([^']*)'/,{token:"attribute.value",switchTo:"@styleWithCustomType.$1"}],[/>/,{token:"delimiter",next:"@styleEmbedded",nextEmbedded:"text/css"}],[/[ \t\r\n]+/],[/<\/style\s*>/,{token:"@rematch",next:"@pop"}]],styleWithCustomType:[[/>/,{token:"delimiter",next:"@styleEmbedded.$S2",nextEmbedded:"$S2"}],[/"([^"]*)"/,"attribute.value"],[/'([^']*)'/,"attribute.value"],[/[\w\-]+/,"attribute.name"],[/=/,"delimiter"],[/[ \t\r\n]+/],[/<\/style\s*>/,{token:"@rematch",next:"@pop"}]],styleEmbedded:[[/<\/style/,{token:"@rematch",next:"@pop",nextEmbedded:"@pop"}],[/[^<]+/,""]]}}},16830:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return n},language:function(){return o}});
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
var n={comments:{lineComment:"#"},brackets:[["{","}"],["[","]"],["(",")"]],autoClosingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"'},{open:"'",close:"'"}],surroundingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"'},{open:"'",close:"'"}]},o={defaultToken:"",tokenPostfix:".ini",escapes:/\\(?:[abfnrtv\\"']|x[0-9A-Fa-f]{1,4}|u[0-9A-Fa-f]{4}|U[0-9A-Fa-f]{8})/,tokenizer:{root:[[/^\[[^\]]*\]/,"metatag"],[/(^\w+)(\s*)(\=)/,["key","","delimiter"]],{include:"@whitespace"},[/\d+/,"number"],[/"([^"\\]|\\.)*$/,"string.invalid"],[/'([^'\\]|\\.)*$/,"string.invalid"],[/"/,"string",'@string."'],[/'/,"string","@string.'"]],whitespace:[[/[ \t\r\n]+/,""],[/^\s*[#;].*$/,"comment"]],string:[[/[^\\"']+/,"string"],[/@escapes/,"string.escape"],[/\\./,"string.escape.invalid"],[/["']/,{cases:{"$#==$S2":{token:"string",next:"@pop"},"@default":"string"}}]]}}},16853:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return n},language:function(){return o}});
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
var n={wordPattern:/(-?\d*\.\d\w*)|([^\`\~\!\#\%\^\&\*\(\)\-\=\+\[\{\]\}\\\|\;\:\'\"\,\.\<\>\/\?\s]+)/g,comments:{lineComment:"//",blockComment:["/*","*/"]},brackets:[["{","}"],["[","]"],["(",")"]],autoClosingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"'},{open:"'",close:"'"}],surroundingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"'},{open:"'",close:"'"},{open:"<",close:">"}],folding:{markers:{start:new RegExp("^\\s*//\\s*(?:(?:#?region\\b)|(?:<editor-fold\\b))"),end:new RegExp("^\\s*//\\s*(?:(?:#?endregion\\b)|(?:</editor-fold>))")}}},o={defaultToken:"",tokenPostfix:".java",keywords:["abstract","continue","for","new","switch","assert","default","goto","package","synchronized","boolean","do","if","private","this","break","double","implements","protected","throw","byte","else","import","public","throws","case","enum","instanceof","return","transient","catch","extends","int","short","try","char","final","interface","static","void","class","finally","long","strictfp","volatile","const","float","native","super","while","true","false","yield","record","sealed","non-sealed","permits"],operators:["=",">","<","!","~","?",":","==","<=",">=","!=","&&","||","++","--","+","-","*","/","&","|","^","%","<<",">>",">>>","+=","-=","*=","/=","&=","|=","^=","%=","<<=",">>=",">>>="],symbols:/[=><!~?:&|+\-*\/\^%]+/,escapes:/\\(?:[abfnrtv\\"']|x[0-9A-Fa-f]{1,4}|u[0-9A-Fa-f]{4}|U[0-9A-Fa-f]{8})/,digits:/\d+(_+\d+)*/,octaldigits:/[0-7]+(_+[0-7]+)*/,binarydigits:/[0-1]+(_+[0-1]+)*/,hexdigits:/[[0-9a-fA-F]+(_+[0-9a-fA-F]+)*/,tokenizer:{root:[["non-sealed","keyword.non-sealed"],[/[a-zA-Z_$][\w$]*/,{cases:{"@keywords":{token:"keyword.$0"},"@default":"identifier"}}],{include:"@whitespace"},[/[{}()\[\]]/,"@brackets"],[/[<>](?!@symbols)/,"@brackets"],[/@symbols/,{cases:{"@operators":"delimiter","@default":""}}],[/@\s*[a-zA-Z_\$][\w\$]*/,"annotation"],[/(@digits)[eE]([\-+]?(@digits))?[fFdD]?/,"number.float"],[/(@digits)\.(@digits)([eE][\-+]?(@digits))?[fFdD]?/,"number.float"],[/0[xX](@hexdigits)[Ll]?/,"number.hex"],[/0(@octaldigits)[Ll]?/,"number.octal"],[/0[bB](@binarydigits)[Ll]?/,"number.binary"],[/(@digits)[fFdD]/,"number.float"],[/(@digits)[lL]?/,"number"],[/[;,.]/,"delimiter"],[/"([^"\\]|\\.)*$/,"string.invalid"],[/"""/,"string","@multistring"],[/"/,"string","@string"],[/'[^\\']'/,"string"],[/(')(@escapes)(')/,["string","string.escape","string"]],[/'/,"string.invalid"]],whitespace:[[/[ \t\r\n]+/,""],[/\/\*\*(?!\/)/,"comment.doc","@javadoc"],[/\/\*/,"comment","@comment"],[/\/\/.*$/,"comment"]],comment:[[/[^\/*]+/,"comment"],[/\*\//,"comment","@pop"],[/[\/*]/,"comment"]],javadoc:[[/[^\/*]+/,"comment.doc"],[/\/\*/,"comment.doc.invalid"],[/\*\//,"comment.doc","@pop"],[/[\/*]/,"comment.doc"]],string:[[/[^\\"]+/,"string"],[/@escapes/,"string.escape"],[/\\./,"string.escape.invalid"],[/"/,"string","@pop"]],multistring:[[/[^\\"]+/,"string"],[/@escapes/,"string.escape"],[/\\./,"string.escape.invalid"],[/"""/,"string","@pop"],[/./,"string"]]}}},22237:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return o},language:function(){return r}});var n=i(22633),o=n.conf,r={defaultToken:"invalid",tokenPostfix:".js",keywords:["break","case","catch","class","continue","const","constructor","debugger","default","delete","do","else","export","extends","false","finally","for","from","function","get","if","import","in","instanceof","let","new","null","return","set","super","switch","symbol","this","throw","true","try","typeof","undefined","var","void","while","with","yield","async","await","of"],typeKeywords:[],operators:n.language.operators,symbols:n.language.symbols,escapes:n.language.escapes,digits:n.language.digits,octaldigits:n.language.octaldigits,binarydigits:n.language.binarydigits,hexdigits:n.language.hexdigits,regexpctl:n.language.regexpctl,regexpesc:n.language.regexpesc,tokenizer:n.language.tokenizer};
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/},19308:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return n},language:function(){return o}});
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
var n={brackets:[["{","}"],["[","]"],["(",")"]],autoClosingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"'},{open:"'",close:"'"}],surroundingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"'},{open:"'",close:"'"}]},o={tokenPostfix:".julia",keywords:["begin","while","if","for","try","return","break","continue","function","macro","quote","let","local","global","const","do","struct","module","baremodule","using","import","export","end","else","elseif","catch","finally","mutable","primitive","abstract","type","in","isa","where","new"],types:["LinRange","LineNumberNode","LinearIndices","LoadError","MIME","Matrix","Method","MethodError","Missing","MissingException","Module","NTuple","NamedTuple","Nothing","Number","OrdinalRange","OutOfMemoryError","OverflowError","Pair","PartialQuickSort","PermutedDimsArray","Pipe","Ptr","QuoteNode","Rational","RawFD","ReadOnlyMemoryError","Real","ReentrantLock","Ref","Regex","RegexMatch","RoundingMode","SegmentationFault","Set","Signed","Some","StackOverflowError","StepRange","StepRangeLen","StridedArray","StridedMatrix","StridedVecOrMat","StridedVector","String","StringIndexError","SubArray","SubString","SubstitutionString","Symbol","SystemError","Task","Text","TextDisplay","Timer","Tuple","Type","TypeError","TypeVar","UInt","UInt128","UInt16","UInt32","UInt64","UInt8","UndefInitializer","AbstractArray","UndefKeywordError","AbstractChannel","UndefRefError","AbstractChar","UndefVarError","AbstractDict","Union","AbstractDisplay","UnionAll","AbstractFloat","UnitRange","AbstractIrrational","Unsigned","AbstractMatrix","AbstractRange","Val","AbstractSet","Vararg","AbstractString","VecElement","AbstractUnitRange","VecOrMat","AbstractVecOrMat","Vector","AbstractVector","VersionNumber","Any","WeakKeyDict","ArgumentError","WeakRef","Array","AssertionError","BigFloat","BigInt","BitArray","BitMatrix","BitSet","BitVector","Bool","BoundsError","CapturedException","CartesianIndex","CartesianIndices","Cchar","Cdouble","Cfloat","Channel","Char","Cint","Cintmax_t","Clong","Clonglong","Cmd","Colon","Complex","ComplexF16","ComplexF32","ComplexF64","CompositeException","Condition","Cptrdiff_t","Cshort","Csize_t","Cssize_t","Cstring","Cuchar","Cuint","Cuintmax_t","Culong","Culonglong","Cushort","Cvoid","Cwchar_t","Cwstring","DataType","DenseArray","DenseMatrix","DenseVecOrMat","DenseVector","Dict","DimensionMismatch","Dims","DivideError","DomainError","EOFError","Enum","ErrorException","Exception","ExponentialBackOff","Expr","Float16","Float32","Float64","Function","GlobalRef","HTML","IO","IOBuffer","IOContext","IOStream","IdDict","IndexCartesian","IndexLinear","IndexStyle","InexactError","InitError","Int","Int128","Int16","Int32","Int64","Int8","Integer","InterruptException","InvalidStateException","Irrational","KeyError"],keywordops:["<:",">:",":","=>","...",".","->","?"],allops:/[^\w\d\s()\[\]{}"'#]+/,constants:["true","false","nothing","missing","undef","Inf","pi","NaN","π","ℯ","ans","PROGRAM_FILE","ARGS","C_NULL","VERSION","DEPOT_PATH","LOAD_PATH"],operators:["!","!=","!==","%","&","*","+","-","/","//","<","<<","<=","==","===","=>",">",">=",">>",">>>","\\","^","|","|>","~","÷","∈","∉","∋","∌","∘","√","∛","∩","∪","≈","≉","≠","≡","≢","≤","≥","⊆","⊇","⊈","⊉","⊊","⊋","⊻"],brackets:[{open:"(",close:")",token:"delimiter.parenthesis"},{open:"{",close:"}",token:"delimiter.curly"},{open:"[",close:"]",token:"delimiter.square"}],ident:/π|ℯ|\b(?!\d)\w+\b/,escape:/(?:[abefnrstv\\"'\n\r]|[0-7]{1,3}|x[0-9A-Fa-f]{1,2}|u[0-9A-Fa-f]{4})/,escapes:/\\(?:C\-(@escape|.)|c(@escape|.)|@escape)/,tokenizer:{root:[[/(::)\s*|\b(isa)\s+/,"keyword","@typeanno"],[/\b(isa)(\s*\(@ident\s*,\s*)/,["keyword",{token:"",next:"@typeanno"}]],[/\b(type|struct)[ \t]+/,"keyword","@typeanno"],[/^\s*:@ident[!?]?/,"metatag"],[/(return)(\s*:@ident[!?]?)/,["keyword","metatag"]],[/(\(|\[|\{|@allops)(\s*:@ident[!?]?)/,["","metatag"]],[/:\(/,"metatag","@quote"],[/r"""/,"regexp.delim","@tregexp"],[/r"/,"regexp.delim","@sregexp"],[/raw"""/,"string.delim","@rtstring"],[/[bv]?"""/,"string.delim","@dtstring"],[/raw"/,"string.delim","@rsstring"],[/[bv]?"/,"string.delim","@dsstring"],[/(@ident)\{/,{cases:{"$1@types":{token:"type",next:"@gen"},"@default":{token:"type",next:"@gen"}}}],[/@ident[!?'']?(?=\.?\()/,{cases:{"@types":"type","@keywords":"keyword","@constants":"variable","@default":"keyword.flow"}}],[/@ident[!?']?/,{cases:{"@types":"type","@keywords":"keyword","@constants":"variable","@default":"identifier"}}],[/\$\w+/,"key"],[/\$\(/,"key","@paste"],[/@@@ident/,"annotation"],{include:"@whitespace"},[/'(?:@escapes|.)'/,"string.character"],[/[()\[\]{}]/,"@brackets"],[/@allops/,{cases:{"@keywordops":"keyword","@operators":"operator"}}],[/[;,]/,"delimiter"],[/0[xX][0-9a-fA-F](_?[0-9a-fA-F])*/,"number.hex"],[/0[_oO][0-7](_?[0-7])*/,"number.octal"],[/0[bB][01](_?[01])*/,"number.binary"],[/[+\-]?\d+(\.\d+)?(im?|[eE][+\-]?\d+(\.\d+)?)?/,"number"]],typeanno:[[/[a-zA-Z_]\w*(?:\.[a-zA-Z_]\w*)*\{/,"type","@gen"],[/([a-zA-Z_]\w*(?:\.[a-zA-Z_]\w*)*)(\s*<:\s*)/,["type","keyword"]],[/[a-zA-Z_]\w*(?:\.[a-zA-Z_]\w*)*/,"type","@pop"],["","","@pop"]],gen:[[/[a-zA-Z_]\w*(?:\.[a-zA-Z_]\w*)*\{/,"type","@push"],[/[a-zA-Z_]\w*(?:\.[a-zA-Z_]\w*)*/,"type"],[/<:/,"keyword"],[/(\})(\s*<:\s*)/,["type",{token:"keyword",next:"@pop"}]],[/\}/,"type","@pop"],{include:"@root"}],quote:[[/\$\(/,"key","@paste"],[/\(/,"@brackets","@paren"],[/\)/,"metatag","@pop"],{include:"@root"}],paste:[[/:\(/,"metatag","@quote"],[/\(/,"@brackets","@paren"],[/\)/,"key","@pop"],{include:"@root"}],paren:[[/\$\(/,"key","@paste"],[/:\(/,"metatag","@quote"],[/\(/,"@brackets","@push"],[/\)/,"@brackets","@pop"],{include:"@root"}],sregexp:[[/^.*/,"invalid"],[/[^\\"()\[\]{}]/,"regexp"],[/[()\[\]{}]/,"@brackets"],[/\\./,"operator.scss"],[/"[imsx]*/,"regexp.delim","@pop"]],tregexp:[[/[^\\"()\[\]{}]/,"regexp"],[/[()\[\]{}]/,"@brackets"],[/\\./,"operator.scss"],[/"(?!"")/,"string"],[/"""[imsx]*/,"regexp.delim","@pop"]],rsstring:[[/^.*/,"invalid"],[/[^\\"]/,"string"],[/\\./,"string.escape"],[/"/,"string.delim","@pop"]],rtstring:[[/[^\\"]/,"string"],[/\\./,"string.escape"],[/"(?!"")/,"string"],[/"""/,"string.delim","@pop"]],dsstring:[[/^.*/,"invalid"],[/[^\\"\$]/,"string"],[/\$/,"","@interpolated"],[/@escapes/,"string.escape"],[/\\./,"string.escape.invalid"],[/"/,"string.delim","@pop"]],dtstring:[[/[^\\"\$]/,"string"],[/\$/,"","@interpolated"],[/@escapes/,"string.escape"],[/\\./,"string.escape.invalid"],[/"(?!"")/,"string"],[/"""/,"string.delim","@pop"]],interpolated:[[/\(/,{token:"",switchTo:"@interpolated_compound"}],[/[a-zA-Z_]\w*/,"identifier"],["","","@pop"]],interpolated_compound:[[/\)/,"","@pop"],{include:"@root"}],whitespace:[[/[ \t\r\n]+/,""],[/#=/,"comment","@multi_comment"],[/#.*$/,"comment"]],multi_comment:[[/#=/,"comment","@push"],[/=#/,"comment","@pop"],[/=(?!#)|#(?!=)/,"comment"],[/[^#=]+/,"comment"]]}}},45556:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return n},language:function(){return o}});
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
var n={wordPattern:/(-?\d*\.\d\w*)|([^\`\~\!\#\%\^\&\*\(\)\-\=\+\[\{\]\}\\\|\;\:\'\"\,\.\<\>\/\?\s]+)/g,comments:{lineComment:"//",blockComment:["/*","*/"]},brackets:[["{","}"],["[","]"],["(",")"]],autoClosingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"'},{open:"'",close:"'"}],surroundingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"'},{open:"'",close:"'"},{open:"<",close:">"}],folding:{markers:{start:new RegExp("^\\s*//\\s*(?:(?:#?region\\b)|(?:<editor-fold\\b))"),end:new RegExp("^\\s*//\\s*(?:(?:#?endregion\\b)|(?:</editor-fold>))")}}},o={defaultToken:"",tokenPostfix:".kt",keywords:["as","as?","break","class","continue","do","else","false","for","fun","if","in","!in","interface","is","!is","null","object","package","return","super","this","throw","true","try","typealias","val","var","when","while","by","catch","constructor","delegate","dynamic","field","file","finally","get","import","init","param","property","receiver","set","setparam","where","actual","abstract","annotation","companion","const","crossinline","data","enum","expect","external","final","infix","inline","inner","internal","lateinit","noinline","open","operator","out","override","private","protected","public","reified","sealed","suspend","tailrec","vararg","field","it"],operators:["+","-","*","/","%","=","+=","-=","*=","/=","%=","++","--","&&","||","!","==","!=","===","!==",">","<","<=",">=","[","]","!!","?.","?:","::","..",":","?","->","@",";","$","_"],symbols:/[=><!~?:&|+\-*\/\^%]+/,escapes:/\\(?:[abfnrtv\\"']|x[0-9A-Fa-f]{1,4}|u[0-9A-Fa-f]{4}|U[0-9A-Fa-f]{8})/,digits:/\d+(_+\d+)*/,octaldigits:/[0-7]+(_+[0-7]+)*/,binarydigits:/[0-1]+(_+[0-1]+)*/,hexdigits:/[[0-9a-fA-F]+(_+[0-9a-fA-F]+)*/,tokenizer:{root:[[/[A-Z][\w\$]*/,"type.identifier"],[/[a-zA-Z_$][\w$]*/,{cases:{"@keywords":{token:"keyword.$0"},"@default":"identifier"}}],{include:"@whitespace"},[/[{}()\[\]]/,"@brackets"],[/[<>](?!@symbols)/,"@brackets"],[/@symbols/,{cases:{"@operators":"delimiter","@default":""}}],[/@\s*[a-zA-Z_\$][\w\$]*/,"annotation"],[/(@digits)[eE]([\-+]?(@digits))?[fFdD]?/,"number.float"],[/(@digits)\.(@digits)([eE][\-+]?(@digits))?[fFdD]?/,"number.float"],[/0[xX](@hexdigits)[Ll]?/,"number.hex"],[/0(@octaldigits)[Ll]?/,"number.octal"],[/0[bB](@binarydigits)[Ll]?/,"number.binary"],[/(@digits)[fFdD]/,"number.float"],[/(@digits)[lL]?/,"number"],[/[;,.]/,"delimiter"],[/"([^"\\]|\\.)*$/,"string.invalid"],[/"""/,"string","@multistring"],[/"/,"string","@string"],[/'[^\\']'/,"string"],[/(')(@escapes)(')/,["string","string.escape","string"]],[/'/,"string.invalid"]],whitespace:[[/[ \t\r\n]+/,""],[/\/\*\*(?!\/)/,"comment.doc","@javadoc"],[/\/\*/,"comment","@comment"],[/\/\/.*$/,"comment"]],comment:[[/[^\/*]+/,"comment"],[/\/\*/,"comment","@comment"],[/\*\//,"comment","@pop"],[/[\/*]/,"comment"]],javadoc:[[/[^\/*]+/,"comment.doc"],[/\/\*/,"comment.doc","@push"],[/\/\*/,"comment.doc.invalid"],[/\*\//,"comment.doc","@pop"],[/[\/*]/,"comment.doc"]],string:[[/[^\\"]+/,"string"],[/@escapes/,"string.escape"],[/\\./,"string.escape.invalid"],[/"/,"string","@pop"]],multistring:[[/[^\\"]+/,"string"],[/@escapes/,"string.escape"],[/\\./,"string.escape.invalid"],[/"""/,"string","@pop"],[/./,"string"]]}}},39689:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return n},language:function(){return o}});
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
var n={wordPattern:/(#?-?\d*\.\d\w*%?)|([@#!.:]?[\w-?]+%?)|[@#!.]/g,comments:{blockComment:["/*","*/"],lineComment:"//"},brackets:[["{","}"],["[","]"],["(",")"]],autoClosingPairs:[{open:"{",close:"}",notIn:["string","comment"]},{open:"[",close:"]",notIn:["string","comment"]},{open:"(",close:")",notIn:["string","comment"]},{open:'"',close:'"',notIn:["string","comment"]},{open:"'",close:"'",notIn:["string","comment"]}],surroundingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"'},{open:"'",close:"'"}],folding:{markers:{start:new RegExp("^\\s*\\/\\*\\s*#region\\b\\s*(.*?)\\s*\\*\\/"),end:new RegExp("^\\s*\\/\\*\\s*#endregion\\b.*\\*\\/")}}},o={defaultToken:"",tokenPostfix:".less",identifier:"-?-?([a-zA-Z]|(\\\\(([0-9a-fA-F]{1,6}\\s?)|[^[0-9a-fA-F])))([\\w\\-]|(\\\\(([0-9a-fA-F]{1,6}\\s?)|[^[0-9a-fA-F])))*",identifierPlus:"-?-?([a-zA-Z:.]|(\\\\(([0-9a-fA-F]{1,6}\\s?)|[^[0-9a-fA-F])))([\\w\\-:.]|(\\\\(([0-9a-fA-F]{1,6}\\s?)|[^[0-9a-fA-F])))*",brackets:[{open:"{",close:"}",token:"delimiter.curly"},{open:"[",close:"]",token:"delimiter.bracket"},{open:"(",close:")",token:"delimiter.parenthesis"},{open:"<",close:">",token:"delimiter.angle"}],tokenizer:{root:[{include:"@nestedJSBegin"},["[ \\t\\r\\n]+",""],{include:"@comments"},{include:"@keyword"},{include:"@strings"},{include:"@numbers"},["[*_]?[a-zA-Z\\-\\s]+(?=:.*(;|(\\\\$)))","attribute.name","@attribute"],["url(\\-prefix)?\\(",{token:"tag",next:"@urldeclaration"}],["[{}()\\[\\]]","@brackets"],["[,:;]","delimiter"],["#@identifierPlus","tag.id"],["&","tag"],["\\.@identifierPlus(?=\\()","tag.class","@attribute"],["\\.@identifierPlus","tag.class"],["@identifierPlus","tag"],{include:"@operators"},["@(@identifier(?=[:,\\)]))","variable","@attribute"],["@(@identifier)","variable"],["@","key","@atRules"]],nestedJSBegin:[["``","delimiter.backtick"],["`",{token:"delimiter.backtick",next:"@nestedJSEnd",nextEmbedded:"text/javascript"}]],nestedJSEnd:[["`",{token:"delimiter.backtick",next:"@pop",nextEmbedded:"@pop"}]],operators:[["[<>=\\+\\-\\*\\/\\^\\|\\~]","operator"]],keyword:[["(@[\\s]*import|![\\s]*important|true|false|when|iscolor|isnumber|isstring|iskeyword|isurl|ispixel|ispercentage|isem|hue|saturation|lightness|alpha|lighten|darken|saturate|desaturate|fadein|fadeout|fade|spin|mix|round|ceil|floor|percentage)\\b","keyword"]],urldeclaration:[{include:"@strings"},["[^)\r\n]+","string"],["\\)",{token:"tag",next:"@pop"}]],attribute:[{include:"@nestedJSBegin"},{include:"@comments"},{include:"@strings"},{include:"@numbers"},{include:"@keyword"},["[a-zA-Z\\-]+(?=\\()","attribute.value","@attribute"],[">","operator","@pop"],["@identifier","attribute.value"],{include:"@operators"},["@(@identifier)","variable"],["[)\\}]","@brackets","@pop"],["[{}()\\[\\]>]","@brackets"],["[;]","delimiter","@pop"],["[,=:]","delimiter"],["\\s",""],[".","attribute.value"]],comments:[["\\/\\*","comment","@comment"],["\\/\\/+.*","comment"]],comment:[["\\*\\/","comment","@pop"],[".","comment"]],numbers:[["(\\d*\\.)?\\d+([eE][\\-+]?\\d+)?",{token:"attribute.value.number",next:"@units"}],["#[0-9a-fA-F_]+(?!\\w)","attribute.value.hex"]],units:[["(em|ex|ch|rem|fr|vmin|vmax|vw|vh|vm|cm|mm|in|px|pt|pc|deg|grad|rad|turn|s|ms|Hz|kHz|%)?","attribute.value.unit","@pop"]],strings:[['~?"',{token:"string.delimiter",next:"@stringsEndDoubleQuote"}],["~?'",{token:"string.delimiter",next:"@stringsEndQuote"}]],stringsEndDoubleQuote:[['\\\\"',"string"],['"',{token:"string.delimiter",next:"@popall"}],[".","string"]],stringsEndQuote:[["\\\\'","string"],["'",{token:"string.delimiter",next:"@popall"}],[".","string"]],atRules:[{include:"@comments"},{include:"@strings"},["[()]","delimiter"],["[\\{;]","delimiter","@pop"],[".","key"]]}}},65843:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return n},language:function(){return o}});
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
var n={comments:{lineComment:"COMMENT"},brackets:[["(",")"]],autoClosingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"'},{open:":",close:"."}],surroundingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:"`",close:"`"},{open:'"',close:'"'},{open:"'",close:"'"},{open:":",close:"."}],folding:{markers:{start:new RegExp("^\\s*(::\\s*|COMMENT\\s+)#region"),end:new RegExp("^\\s*(::\\s*|COMMENT\\s+)#endregion")}}},o={tokenPostfix:".lexon",ignoreCase:!0,keywords:["lexon","lex","clause","terms","contracts","may","pay","pays","appoints","into","to"],typeKeywords:["amount","person","key","time","date","asset","text"],operators:["less","greater","equal","le","gt","or","and","add","added","subtract","subtracted","multiply","multiplied","times","divide","divided","is","be","certified"],symbols:/[=><!~?:&|+\-*\/\^%]+/,tokenizer:{root:[[/^(\s*)(comment:?(?:\s.*|))$/,["","comment"]],[/"/,{token:"identifier.quote",bracket:"@open",next:"@quoted_identifier"}],["LEX$",{token:"keyword",bracket:"@open",next:"@identifier_until_period"}],["LEXON",{token:"keyword",bracket:"@open",next:"@semver"}],[":",{token:"delimiter",bracket:"@open",next:"@identifier_until_period"}],[/[a-z_$][\w$]*/,{cases:{"@operators":"operator","@typeKeywords":"keyword.type","@keywords":"keyword","@default":"identifier"}}],{include:"@whitespace"},[/[{}()\[\]]/,"@brackets"],[/[<>](?!@symbols)/,"@brackets"],[/@symbols/,"delimiter"],[/\d*\.\d*\.\d*/,"number.semver"],[/\d*\.\d+([eE][\-+]?\d+)?/,"number.float"],[/0[xX][0-9a-fA-F]+/,"number.hex"],[/\d+/,"number"],[/[;,.]/,"delimiter"]],quoted_identifier:[[/[^\\"]+/,"identifier"],[/"/,{token:"identifier.quote",bracket:"@close",next:"@pop"}]],space_identifier_until_period:[[":","delimiter"],[" ",{token:"white",next:"@identifier_rest"}]],identifier_until_period:[{include:"@whitespace"},[":",{token:"delimiter",next:"@identifier_rest"}],[/[^\\.]+/,"identifier"],[/\./,{token:"delimiter",bracket:"@close",next:"@pop"}]],identifier_rest:[[/[^\\.]+/,"identifier"],[/\./,{token:"delimiter",bracket:"@close",next:"@pop"}]],semver:[{include:"@whitespace"},[":","delimiter"],[/\d*\.\d*\.\d*/,{token:"number.semver",bracket:"@close",next:"@pop"}]],whitespace:[[/[ \t\r\n]+/,"white"]]}}},67019:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return g},language:function(){return p}});var n,o,r=i(57768),s=Object.defineProperty,a=Object.getOwnPropertyDescriptor,l=Object.getOwnPropertyNames,c=Object.prototype.hasOwnProperty,d=(e,t,i,n)=>{if(t&&"object"==typeof t||"function"==typeof t)for(let o of l(t))c.call(e,o)||o===i||s(e,o,{get:()=>t[o],enumerable:!(n=a(t,o))||n.enumerable});return e},u={};
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/d(u,n=r,"default"),o&&d(o,n,"default");var h=["area","base","br","col","embed","hr","img","input","keygen","link","menuitem","meta","param","source","track","wbr"],g={wordPattern:/(-?\d*\.\d\w*)|([^\`\~\!\@\$\^\&\*\(\)\=\+\[\{\]\}\\\|\;\:\'\"\,\.\<\>\/\s]+)/g,brackets:[["\x3c!--","--\x3e"],["<",">"],["{{","}}"],["{%","%}"],["{","}"],["(",")"]],autoClosingPairs:[{open:"{",close:"}"},{open:"%",close:"%"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"'},{open:"'",close:"'"}],surroundingPairs:[{open:"<",close:">"},{open:'"',close:'"'},{open:"'",close:"'"}],onEnterRules:[{beforeText:new RegExp(`<(?!(?:${h.join("|")}))(\\w[\\w\\d]*)([^/>]*(?!/)>)[^<]*$`,"i"),afterText:/^<\/(\w[\w\d]*)\s*>$/i,action:{indentAction:u.languages.IndentAction.IndentOutdent}},{beforeText:new RegExp(`<(?!(?:${h.join("|")}))(\\w[\\w\\d]*)([^/>]*(?!/)>)[^<]*$`,"i"),action:{indentAction:u.languages.IndentAction.Indent}}]},p={defaultToken:"",tokenPostfix:"",builtinTags:["if","else","elseif","endif","render","assign","capture","endcapture","case","endcase","comment","endcomment","cycle","decrement","for","endfor","include","increment","layout","raw","endraw","render","tablerow","endtablerow","unless","endunless"],builtinFilters:["abs","append","at_least","at_most","capitalize","ceil","compact","date","default","divided_by","downcase","escape","escape_once","first","floor","join","json","last","lstrip","map","minus","modulo","newline_to_br","plus","prepend","remove","remove_first","replace","replace_first","reverse","round","rstrip","size","slice","sort","sort_natural","split","strip","strip_html","strip_newlines","times","truncate","truncatewords","uniq","upcase","url_decode","url_encode","where"],constants:["true","false"],operators:["==","!=",">","<",">=","<="],symbol:/[=><!]+/,identifier:/[a-zA-Z_][\w]*/,tokenizer:{root:[[/\{\%\s*comment\s*\%\}/,"comment.start.liquid","@comment"],[/\{\{/,{token:"@rematch",switchTo:"@liquidState.root"}],[/\{\%/,{token:"@rematch",switchTo:"@liquidState.root"}],[/(<)([\w\-]+)(\/>)/,["delimiter.html","tag.html","delimiter.html"]],[/(<)([:\w]+)/,["delimiter.html",{token:"tag.html",next:"@otherTag"}]],[/(<\/)([\w\-]+)/,["delimiter.html",{token:"tag.html",next:"@otherTag"}]],[/</,"delimiter.html"],[/\{/,"delimiter.html"],[/[^<{]+/]],comment:[[/\{\%\s*endcomment\s*\%\}/,"comment.end.liquid","@pop"],[/./,"comment.content.liquid"]],otherTag:[[/\{\{/,{token:"@rematch",switchTo:"@liquidState.otherTag"}],[/\{\%/,{token:"@rematch",switchTo:"@liquidState.otherTag"}],[/\/?>/,"delimiter.html","@pop"],[/"([^"]*)"/,"attribute.value"],[/'([^']*)'/,"attribute.value"],[/[\w\-]+/,"attribute.name"],[/=/,"delimiter"],[/[ \t\r\n]+/]],liquidState:[[/\{\{/,"delimiter.output.liquid"],[/\}\}/,{token:"delimiter.output.liquid",switchTo:"@$S2.$S3"}],[/\{\%/,"delimiter.tag.liquid"],[/raw\s*\%\}/,"delimiter.tag.liquid","@liquidRaw"],[/\%\}/,{token:"delimiter.tag.liquid",switchTo:"@$S2.$S3"}],{include:"liquidRoot"}],liquidRaw:[[/^(?!\{\%\s*endraw\s*\%\}).+/],[/\{\%/,"delimiter.tag.liquid"],[/@identifier/],[/\%\}/,{token:"delimiter.tag.liquid",next:"@root"}]],liquidRoot:[[/\d+(\.\d+)?/,"number.liquid"],[/"[^"]*"/,"string.liquid"],[/'[^']*'/,"string.liquid"],[/\s+/],[/@symbol/,{cases:{"@operators":"operator.liquid","@default":""}}],[/\./],[/@identifier/,{cases:{"@constants":"keyword.liquid","@builtinFilters":"predefined.liquid","@builtinTags":"predefined.liquid","@default":"variable.liquid"}}],[/[^}|%]/,"variable.liquid"]]}}},29931:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return n},language:function(){return o}});
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
var n={comments:{lineComment:"--",blockComment:["--[[","]]"]},brackets:[["{","}"],["[","]"],["(",")"]],autoClosingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"'},{open:"'",close:"'"}],surroundingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"'},{open:"'",close:"'"}]},o={defaultToken:"",tokenPostfix:".lua",keywords:["and","break","do","else","elseif","end","false","for","function","goto","if","in","local","nil","not","or","repeat","return","then","true","until","while"],brackets:[{token:"delimiter.bracket",open:"{",close:"}"},{token:"delimiter.array",open:"[",close:"]"},{token:"delimiter.parenthesis",open:"(",close:")"}],operators:["+","-","*","/","%","^","#","==","~=","<=",">=","<",">","=",";",":",",",".","..","..."],symbols:/[=><!~?:&|+\-*\/\^%]+/,escapes:/\\(?:[abfnrtv\\"']|x[0-9A-Fa-f]{1,4}|u[0-9A-Fa-f]{4}|U[0-9A-Fa-f]{8})/,tokenizer:{root:[[/[a-zA-Z_]\w*/,{cases:{"@keywords":{token:"keyword.$0"},"@default":"identifier"}}],{include:"@whitespace"},[/(,)(\s*)([a-zA-Z_]\w*)(\s*)(:)(?!:)/,["delimiter","","key","","delimiter"]],[/({)(\s*)([a-zA-Z_]\w*)(\s*)(:)(?!:)/,["@brackets","","key","","delimiter"]],[/[{}()\[\]]/,"@brackets"],[/@symbols/,{cases:{"@operators":"delimiter","@default":""}}],[/\d*\.\d+([eE][\-+]?\d+)?/,"number.float"],[/0[xX][0-9a-fA-F_]*[0-9a-fA-F]/,"number.hex"],[/\d+?/,"number"],[/[;,.]/,"delimiter"],[/"([^"\\]|\\.)*$/,"string.invalid"],[/'([^'\\]|\\.)*$/,"string.invalid"],[/"/,"string",'@string."'],[/'/,"string","@string.'"]],whitespace:[[/[ \t\r\n]+/,""],[/--\[([=]*)\[/,"comment","@comment.$1"],[/--.*$/,"comment"]],comment:[[/[^\]]+/,"comment"],[/\]([=]*)\]/,{cases:{"$1==$S2":{token:"comment",next:"@pop"},"@default":"comment"}}],[/./,"comment"]],string:[[/[^\\"']+/,"string"],[/@escapes/,"string.escape"],[/\\./,"string.escape.invalid"],[/["']/,{cases:{"$#==$S2":{token:"string",next:"@pop"},"@default":"string"}}]]}}},34906:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return n},language:function(){return o}});
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
var n={comments:{blockComment:["(*","*)"]},brackets:[["{","}"],["[","]"],["(",")"]],autoClosingPairs:[{open:"[",close:"]"},{open:"{",close:"}"},{open:"(",close:")"},{open:"(*",close:"*)"},{open:"<*",close:"*>"},{open:"'",close:"'",notIn:["string","comment"]},{open:'"',close:'"',notIn:["string","comment"]}]},o={defaultToken:"",tokenPostfix:".m3",brackets:[{token:"delimiter.curly",open:"{",close:"}"},{token:"delimiter.parenthesis",open:"(",close:")"},{token:"delimiter.square",open:"[",close:"]"}],keywords:["AND","ANY","ARRAY","AS","BEGIN","BITS","BRANDED","BY","CASE","CONST","DIV","DO","ELSE","ELSIF","END","EVAL","EXCEPT","EXCEPTION","EXIT","EXPORTS","FINALLY","FOR","FROM","GENERIC","IF","IMPORT","IN","INTERFACE","LOCK","LOOP","METHODS","MOD","MODULE","NOT","OBJECT","OF","OR","OVERRIDES","PROCEDURE","RAISE","RAISES","READONLY","RECORD","REF","REPEAT","RETURN","REVEAL","SET","THEN","TO","TRY","TYPE","TYPECASE","UNSAFE","UNTIL","UNTRACED","VALUE","VAR","WHILE","WITH"],reservedConstNames:["ABS","ADR","ADRSIZE","BITSIZE","BYTESIZE","CEILING","DEC","DISPOSE","FALSE","FIRST","FLOAT","FLOOR","INC","ISTYPE","LAST","LOOPHOLE","MAX","MIN","NARROW","NEW","NIL","NUMBER","ORD","ROUND","SUBARRAY","TRUE","TRUNC","TYPECODE","VAL"],reservedTypeNames:["ADDRESS","ANY","BOOLEAN","CARDINAL","CHAR","EXTENDED","INTEGER","LONGCARD","LONGINT","LONGREAL","MUTEX","NULL","REAL","REFANY","ROOT","TEXT"],operators:["+","-","*","/","&","^","."],relations:["=","#","<","<=",">",">=","<:",":"],delimiters:["|","..","=>",",",";",":="],symbols:/[>=<#.,:;+\-*/&^]+/,escapes:/\\(?:[\\fnrt"']|[0-7]{3})/,tokenizer:{root:[[/_\w*/,"invalid"],[/[a-zA-Z][a-zA-Z0-9_]*/,{cases:{"@keywords":{token:"keyword.$0"},"@reservedConstNames":{token:"constant.reserved.$0"},"@reservedTypeNames":{token:"type.reserved.$0"},"@default":"identifier"}}],{include:"@whitespace"},[/[{}()\[\]]/,"@brackets"],[/[0-9]+\.[0-9]+(?:[DdEeXx][\+\-]?[0-9]+)?/,"number.float"],[/[0-9]+(?:\_[0-9a-fA-F]+)?L?/,"number"],[/@symbols/,{cases:{"@operators":"operators","@relations":"operators","@delimiters":"delimiter","@default":"invalid"}}],[/'[^\\']'/,"string.char"],[/(')(@escapes)(')/,["string.char","string.escape","string.char"]],[/'/,"invalid"],[/"([^"\\]|\\.)*$/,"invalid"],[/"/,"string.text","@text"]],text:[[/[^\\"]+/,"string.text"],[/@escapes/,"string.escape"],[/\\./,"invalid"],[/"/,"string.text","@pop"]],comment:[[/\(\*/,"comment","@push"],[/\*\)/,"comment","@pop"],[/./,"comment"]],pragma:[[/<\*/,"keyword.pragma","@push"],[/\*>/,"keyword.pragma","@pop"],[/./,"keyword.pragma"]],whitespace:[[/[ \t\r\n]+/,"white"],[/\(\*/,"comment","@comment"],[/<\*/,"keyword.pragma","@pragma"]]}}},508:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return n},language:function(){return o}});
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
var n={comments:{blockComment:["\x3c!--","--\x3e"]},brackets:[["{","}"],["[","]"],["(",")"]],autoClosingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:"<",close:">",notIn:["string"]}],surroundingPairs:[{open:"(",close:")"},{open:"[",close:"]"},{open:"`",close:"`"}],folding:{markers:{start:new RegExp("^\\s*\x3c!--\\s*#?region\\b.*--\x3e"),end:new RegExp("^\\s*\x3c!--\\s*#?endregion\\b.*--\x3e")}}},o={defaultToken:"",tokenPostfix:".md",control:/[\\`*_\[\]{}()#+\-\.!]/,noncontrol:/[^\\`*_\[\]{}()#+\-\.!]/,escapes:/\\(?:@control)/,jsescapes:/\\(?:[btnfr\\"']|[0-7][0-7]?|[0-3][0-7]{2})/,empty:["area","base","basefont","br","col","frame","hr","img","input","isindex","link","meta","param"],tokenizer:{root:[[/^\s*\|/,"@rematch","@table_header"],[/^(\s{0,3})(#+)((?:[^\\#]|@escapes)+)((?:#+)?)/,["white","keyword","keyword","keyword"]],[/^\s*(=+|\-+)\s*$/,"keyword"],[/^\s*((\*[ ]?)+)\s*$/,"meta.separator"],[/^\s*>+/,"comment"],[/^\s*([\*\-+:]|\d+\.)\s/,"keyword"],[/^(\t|[ ]{4})[^ ].*$/,"string"],[/^\s*~~~\s*((?:\w|[\/\-#])+)?\s*$/,{token:"string",next:"@codeblock"}],[/^\s*```\s*((?:\w|[\/\-#])+).*$/,{token:"string",next:"@codeblockgh",nextEmbedded:"$1"}],[/^\s*```\s*$/,{token:"string",next:"@codeblock"}],{include:"@linecontent"}],table_header:[{include:"@table_common"},[/[^\|]+/,"keyword.table.header"]],table_body:[{include:"@table_common"},{include:"@linecontent"}],table_common:[[/\s*[\-:]+\s*/,{token:"keyword",switchTo:"table_body"}],[/^\s*\|/,"keyword.table.left"],[/^\s*[^\|]/,"@rematch","@pop"],[/^\s*$/,"@rematch","@pop"],[/\|/,{cases:{"@eos":"keyword.table.right","@default":"keyword.table.middle"}}]],codeblock:[[/^\s*~~~\s*$/,{token:"string",next:"@pop"}],[/^\s*```\s*$/,{token:"string",next:"@pop"}],[/.*$/,"variable.source"]],codeblockgh:[[/```\s*$/,{token:"string",next:"@pop",nextEmbedded:"@pop"}],[/[^`]+/,"variable.source"]],linecontent:[[/&\w+;/,"string.escape"],[/@escapes/,"escape"],[/\b__([^\\_]|@escapes|_(?!_))+__\b/,"strong"],[/\*\*([^\\*]|@escapes|\*(?!\*))+\*\*/,"strong"],[/\b_[^_]+_\b/,"emphasis"],[/\*([^\\*]|@escapes)+\*/,"emphasis"],[/`([^\\`]|@escapes)+`/,"variable"],[/\{+[^}]+\}+/,"string.target"],[/(!?\[)((?:[^\]\\]|@escapes)*)(\]\([^\)]+\))/,["string.link","","string.link"]],[/(!?\[)((?:[^\]\\]|@escapes)*)(\])/,"string.link"],{include:"html"}],html:[[/<(\w+)\/>/,"tag"],[/<(\w+)(\-|\w)*/,{cases:{"@empty":{token:"tag",next:"@tag.$1"},"@default":{token:"tag",next:"@tag.$1"}}}],[/<\/(\w+)(\-|\w)*\s*>/,{token:"tag"}],[/<!--/,"comment","@comment"]],comment:[[/[^<\-]+/,"comment.content"],[/-->/,"comment","@pop"],[/<!--/,"comment.content.invalid"],[/[<\-]/,"comment.content"]],tag:[[/[ \t\r\n]+/,"white"],[/(type)(\s*=\s*)(")([^"]+)(")/,["attribute.name.html","delimiter.html","string.html",{token:"string.html",switchTo:"@tag.$S2.$4"},"string.html"]],[/(type)(\s*=\s*)(')([^']+)(')/,["attribute.name.html","delimiter.html","string.html",{token:"string.html",switchTo:"@tag.$S2.$4"},"string.html"]],[/(\w+)(\s*=\s*)("[^"]*"|'[^']*')/,["attribute.name.html","delimiter.html","string.html"]],[/\w+/,"attribute.name.html"],[/\/>/,"tag","@pop"],[/>/,{cases:{"$S2==style":{token:"tag",switchTo:"embeddedStyle",nextEmbedded:"text/css"},"$S2==script":{cases:{$S3:{token:"tag",switchTo:"embeddedScript",nextEmbedded:"$S3"},"@default":{token:"tag",switchTo:"embeddedScript",nextEmbedded:"text/javascript"}}},"@default":{token:"tag",next:"@pop"}}}]],embeddedStyle:[[/[^<]+/,""],[/<\/style\s*>/,{token:"@rematch",next:"@pop",nextEmbedded:"@pop"}],[/</,""]],embeddedScript:[[/[^<]+/,""],[/<\/script\s*>/,{token:"@rematch",next:"@pop",nextEmbedded:"@pop"}],[/</,""]]}}},29266:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return n},language:function(){return o}});
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
var n={wordPattern:/(-?\d*\.\d\w*)|([^\`\~\!\@\#%\^\&\*\(\)\=\$\-\+\[\{\]\}\\\|\;\:\'\"\,\.\<\>\/\?\s]+)/g,comments:{blockComment:["###","###"],lineComment:"#"},folding:{markers:{start:new RegExp("^\\s*#region\\b"),end:new RegExp("^\\s*#endregion\\b")}}},o={defaultToken:"",ignoreCase:!1,tokenPostfix:".mips",regEx:/\/(?!\/\/)(?:[^\/\\]|\\.)*\/[igm]*/,keywords:[".data",".text","syscall","trap","add","addu","addi","addiu","and","andi","div","divu","mult","multu","nor","or","ori","sll","slv","sra","srav","srl","srlv","sub","subu","xor","xori","lhi","lho","lhi","llo","slt","slti","sltu","sltiu","beq","bgtz","blez","bne","j","jal","jalr","jr","lb","lbu","lh","lhu","lw","li","la","sb","sh","sw","mfhi","mflo","mthi","mtlo","move"],symbols:/[\.,\:]+/,escapes:/\\(?:[abfnrtv\\"'$]|x[0-9A-Fa-f]{1,4}|u[0-9A-Fa-f]{4}|U[0-9A-Fa-f]{8})/,tokenizer:{root:[[/\$[a-zA-Z_]\w*/,"variable.predefined"],[/[.a-zA-Z_]\w*/,{cases:{this:"variable.predefined","@keywords":{token:"keyword.$0"},"@default":""}}],[/[ \t\r\n]+/,""],[/#.*$/,"comment"],["///",{token:"regexp",next:"@hereregexp"}],[/^(\s*)(@regEx)/,["","regexp"]],[/(\,)(\s*)(@regEx)/,["delimiter","","regexp"]],[/(\:)(\s*)(@regEx)/,["delimiter","","regexp"]],[/@symbols/,"delimiter"],[/\d+[eE]([\-+]?\d+)?/,"number.float"],[/\d+\.\d+([eE][\-+]?\d+)?/,"number.float"],[/0[xX][0-9a-fA-F]+/,"number.hex"],[/0[0-7]+(?!\d)/,"number.octal"],[/\d+/,"number"],[/[,.]/,"delimiter"],[/"""/,"string",'@herestring."""'],[/'''/,"string","@herestring.'''"],[/"/,{cases:{"@eos":"string","@default":{token:"string",next:'@string."'}}}],[/'/,{cases:{"@eos":"string","@default":{token:"string",next:"@string.'"}}}]],string:[[/[^"'\#\\]+/,"string"],[/@escapes/,"string.escape"],[/\./,"string.escape.invalid"],[/\./,"string.escape.invalid"],[/#{/,{cases:{'$S2=="':{token:"string",next:"root.interpolatedstring"},"@default":"string"}}],[/["']/,{cases:{"$#==$S2":{token:"string",next:"@pop"},"@default":"string"}}],[/#/,"string"]],herestring:[[/("""|''')/,{cases:{"$1==$S2":{token:"string",next:"@pop"},"@default":"string"}}],[/[^#\\'"]+/,"string"],[/['"]+/,"string"],[/@escapes/,"string.escape"],[/\./,"string.escape.invalid"],[/#{/,{token:"string.quote",next:"root.interpolatedstring"}],[/#/,"string"]],comment:[[/[^#]+/,"comment"],[/#/,"comment"]],hereregexp:[[/[^\\\/#]+/,"regexp"],[/\\./,"regexp"],[/#.*$/,"comment"],["///[igm]*",{token:"regexp",next:"@pop"}],[/\//,"regexp"]]}}},34245:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return n},language:function(){return o}});
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
var n={comments:{lineComment:"//",blockComment:["/*","*/"]},brackets:[["[","]"],["(",")"],["{","}"]],autoClosingPairs:[{open:'"',close:'"',notIn:["string","comment"]},{open:"'",close:"'",notIn:["string","comment"]},{open:"[",close:"]",notIn:["string","comment"]},{open:"(",close:")",notIn:["string","comment"]},{open:"{",close:"}",notIn:["string","comment"]}]},o={defaultToken:"",tokenPostfix:".msdax",ignoreCase:!0,brackets:[{open:"[",close:"]",token:"delimiter.square"},{open:"{",close:"}",token:"delimiter.brackets"},{open:"(",close:")",token:"delimiter.parenthesis"}],keywords:["VAR","RETURN","NOT","EVALUATE","DATATABLE","ORDER","BY","START","AT","DEFINE","MEASURE","ASC","DESC","IN","BOOLEAN","DOUBLE","INTEGER","DATETIME","CURRENCY","STRING"],functions:["CLOSINGBALANCEMONTH","CLOSINGBALANCEQUARTER","CLOSINGBALANCEYEAR","DATEADD","DATESBETWEEN","DATESINPERIOD","DATESMTD","DATESQTD","DATESYTD","ENDOFMONTH","ENDOFQUARTER","ENDOFYEAR","FIRSTDATE","FIRSTNONBLANK","LASTDATE","LASTNONBLANK","NEXTDAY","NEXTMONTH","NEXTQUARTER","NEXTYEAR","OPENINGBALANCEMONTH","OPENINGBALANCEQUARTER","OPENINGBALANCEYEAR","PARALLELPERIOD","PREVIOUSDAY","PREVIOUSMONTH","PREVIOUSQUARTER","PREVIOUSYEAR","SAMEPERIODLASTYEAR","STARTOFMONTH","STARTOFQUARTER","STARTOFYEAR","TOTALMTD","TOTALQTD","TOTALYTD","ADDCOLUMNS","ADDMISSINGITEMS","ALL","ALLEXCEPT","ALLNOBLANKROW","ALLSELECTED","CALCULATE","CALCULATETABLE","CALENDAR","CALENDARAUTO","CROSSFILTER","CROSSJOIN","CURRENTGROUP","DATATABLE","DETAILROWS","DISTINCT","EARLIER","EARLIEST","EXCEPT","FILTER","FILTERS","GENERATE","GENERATEALL","GROUPBY","IGNORE","INTERSECT","ISONORAFTER","KEEPFILTERS","LOOKUPVALUE","NATURALINNERJOIN","NATURALLEFTOUTERJOIN","RELATED","RELATEDTABLE","ROLLUP","ROLLUPADDISSUBTOTAL","ROLLUPGROUP","ROLLUPISSUBTOTAL","ROW","SAMPLE","SELECTCOLUMNS","SUBSTITUTEWITHINDEX","SUMMARIZE","SUMMARIZECOLUMNS","TOPN","TREATAS","UNION","USERELATIONSHIP","VALUES","SUM","SUMX","PATH","PATHCONTAINS","PATHITEM","PATHITEMREVERSE","PATHLENGTH","AVERAGE","AVERAGEA","AVERAGEX","COUNT","COUNTA","COUNTAX","COUNTBLANK","COUNTROWS","COUNTX","DISTINCTCOUNT","DIVIDE","GEOMEAN","GEOMEANX","MAX","MAXA","MAXX","MEDIAN","MEDIANX","MIN","MINA","MINX","PERCENTILE.EXC","PERCENTILE.INC","PERCENTILEX.EXC","PERCENTILEX.INC","PRODUCT","PRODUCTX","RANK.EQ","RANKX","STDEV.P","STDEV.S","STDEVX.P","STDEVX.S","VAR.P","VAR.S","VARX.P","VARX.S","XIRR","XNPV","DATE","DATEDIFF","DATEVALUE","DAY","EDATE","EOMONTH","HOUR","MINUTE","MONTH","NOW","SECOND","TIME","TIMEVALUE","TODAY","WEEKDAY","WEEKNUM","YEAR","YEARFRAC","CONTAINS","CONTAINSROW","CUSTOMDATA","ERROR","HASONEFILTER","HASONEVALUE","ISBLANK","ISCROSSFILTERED","ISEMPTY","ISERROR","ISEVEN","ISFILTERED","ISLOGICAL","ISNONTEXT","ISNUMBER","ISODD","ISSUBTOTAL","ISTEXT","USERNAME","USERPRINCIPALNAME","AND","FALSE","IF","IFERROR","NOT","OR","SWITCH","TRUE","ABS","ACOS","ACOSH","ACOT","ACOTH","ASIN","ASINH","ATAN","ATANH","BETA.DIST","BETA.INV","CEILING","CHISQ.DIST","CHISQ.DIST.RT","CHISQ.INV","CHISQ.INV.RT","COMBIN","COMBINA","CONFIDENCE.NORM","CONFIDENCE.T","COS","COSH","COT","COTH","CURRENCY","DEGREES","EVEN","EXP","EXPON.DIST","FACT","FLOOR","GCD","INT","ISO.CEILING","LCM","LN","LOG","LOG10","MOD","MROUND","ODD","PERMUT","PI","POISSON.DIST","POWER","QUOTIENT","RADIANS","RAND","RANDBETWEEN","ROUND","ROUNDDOWN","ROUNDUP","SIGN","SIN","SINH","SQRT","SQRTPI","TAN","TANH","TRUNC","BLANK","CONCATENATE","CONCATENATEX","EXACT","FIND","FIXED","FORMAT","LEFT","LEN","LOWER","MID","REPLACE","REPT","RIGHT","SEARCH","SUBSTITUTE","TRIM","UNICHAR","UNICODE","UPPER","VALUE"],tokenizer:{root:[{include:"@comments"},{include:"@whitespace"},{include:"@numbers"},{include:"@strings"},{include:"@complexIdentifiers"},[/[;,.]/,"delimiter"],[/[({})]/,"@brackets"],[/[a-z_][a-zA-Z0-9_]*/,{cases:{"@keywords":"keyword","@functions":"keyword","@default":"identifier"}}],[/[<>=!%&+\-*/|~^]/,"operator"]],whitespace:[[/\s+/,"white"]],comments:[[/\/\/+.*/,"comment"],[/\/\*/,{token:"comment.quote",next:"@comment"}]],comment:[[/[^*/]+/,"comment"],[/\*\//,{token:"comment.quote",next:"@pop"}],[/./,"comment"]],numbers:[[/0[xX][0-9a-fA-F]*/,"number"],[/[$][+-]*\d*(\.\d*)?/,"number"],[/((\d+(\.\d*)?)|(\.\d+))([eE][\-+]?\d+)?/,"number"]],strings:[[/N"/,{token:"string",next:"@string"}],[/"/,{token:"string",next:"@string"}]],string:[[/[^"]+/,"string"],[/""/,"string"],[/"/,{token:"string",next:"@pop"}]],complexIdentifiers:[[/\[/,{token:"identifier.quote",next:"@bracketedIdentifier"}],[/'/,{token:"identifier.quote",next:"@quotedIdentifier"}]],bracketedIdentifier:[[/[^\]]+/,"identifier"],[/]]/,"identifier"],[/]/,{token:"identifier.quote",next:"@pop"}]],quotedIdentifier:[[/[^']+/,"identifier"],[/''/,"identifier"],[/'/,{token:"identifier.quote",next:"@pop"}]]}}},39889:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return n},language:function(){return o}});
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
var n={comments:{lineComment:"--",blockComment:["/*","*/"]},brackets:[["{","}"],["[","]"],["(",")"]],autoClosingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"'},{open:"'",close:"'"}],surroundingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"'},{open:"'",close:"'"}]},o={defaultToken:"",tokenPostfix:".sql",ignoreCase:!0,brackets:[{open:"[",close:"]",token:"delimiter.square"},{open:"(",close:")",token:"delimiter.parenthesis"}],keywords:["ACCESSIBLE","ADD","ALL","ALTER","ANALYZE","AND","AS","ASC","ASENSITIVE","BEFORE","BETWEEN","BIGINT","BINARY","BLOB","BOTH","BY","CALL","CASCADE","CASE","CHANGE","CHAR","CHARACTER","CHECK","COLLATE","COLUMN","CONDITION","CONSTRAINT","CONTINUE","CONVERT","CREATE","CROSS","CUBE","CUME_DIST","CURRENT_DATE","CURRENT_TIME","CURRENT_TIMESTAMP","CURRENT_USER","CURSOR","DATABASE","DATABASES","DAY_HOUR","DAY_MICROSECOND","DAY_MINUTE","DAY_SECOND","DEC","DECIMAL","DECLARE","DEFAULT","DELAYED","DELETE","DENSE_RANK","DESC","DESCRIBE","DETERMINISTIC","DISTINCT","DISTINCTROW","DIV","DOUBLE","DROP","DUAL","EACH","ELSE","ELSEIF","EMPTY","ENCLOSED","ESCAPED","EXCEPT","EXISTS","EXIT","EXPLAIN","FALSE","FETCH","FIRST_VALUE","FLOAT","FLOAT4","FLOAT8","FOR","FORCE","FOREIGN","FROM","FULLTEXT","FUNCTION","GENERATED","GET","GRANT","GROUP","GROUPING","GROUPS","HAVING","HIGH_PRIORITY","HOUR_MICROSECOND","HOUR_MINUTE","HOUR_SECOND","IF","IGNORE","IN","INDEX","INFILE","INNER","INOUT","INSENSITIVE","INSERT","INT","INT1","INT2","INT3","INT4","INT8","INTEGER","INTERVAL","INTO","IO_AFTER_GTIDS","IO_BEFORE_GTIDS","IS","ITERATE","JOIN","JSON_TABLE","KEY","KEYS","KILL","LAG","LAST_VALUE","LATERAL","LEAD","LEADING","LEAVE","LEFT","LIKE","LIMIT","LINEAR","LINES","LOAD","LOCALTIME","LOCALTIMESTAMP","LOCK","LONG","LONGBLOB","LONGTEXT","LOOP","LOW_PRIORITY","MASTER_BIND","MASTER_SSL_VERIFY_SERVER_CERT","MATCH","MAXVALUE","MEDIUMBLOB","MEDIUMINT","MEDIUMTEXT","MIDDLEINT","MINUTE_MICROSECOND","MINUTE_SECOND","MOD","MODIFIES","NATURAL","NOT","NO_WRITE_TO_BINLOG","NTH_VALUE","NTILE","NULL","NUMERIC","OF","ON","OPTIMIZE","OPTIMIZER_COSTS","OPTION","OPTIONALLY","OR","ORDER","OUT","OUTER","OUTFILE","OVER","PARTITION","PERCENT_RANK","PRECISION","PRIMARY","PROCEDURE","PURGE","RANGE","RANK","READ","READS","READ_WRITE","REAL","RECURSIVE","REFERENCES","REGEXP","RELEASE","RENAME","REPEAT","REPLACE","REQUIRE","RESIGNAL","RESTRICT","RETURN","REVOKE","RIGHT","RLIKE","ROW","ROWS","ROW_NUMBER","SCHEMA","SCHEMAS","SECOND_MICROSECOND","SELECT","SENSITIVE","SEPARATOR","SET","SHOW","SIGNAL","SMALLINT","SPATIAL","SPECIFIC","SQL","SQLEXCEPTION","SQLSTATE","SQLWARNING","SQL_BIG_RESULT","SQL_CALC_FOUND_ROWS","SQL_SMALL_RESULT","SSL","STARTING","STORED","STRAIGHT_JOIN","SYSTEM","TABLE","TERMINATED","THEN","TINYBLOB","TINYINT","TINYTEXT","TO","TRAILING","TRIGGER","TRUE","UNDO","UNION","UNIQUE","UNLOCK","UNSIGNED","UPDATE","USAGE","USE","USING","UTC_DATE","UTC_TIME","UTC_TIMESTAMP","VALUES","VARBINARY","VARCHAR","VARCHARACTER","VARYING","VIRTUAL","WHEN","WHERE","WHILE","WINDOW","WITH","WRITE","XOR","YEAR_MONTH","ZEROFILL"],operators:["AND","BETWEEN","IN","LIKE","NOT","OR","IS","NULL","INTERSECT","UNION","INNER","JOIN","LEFT","OUTER","RIGHT"],builtinFunctions:["ABS","ACOS","ADDDATE","ADDTIME","AES_DECRYPT","AES_ENCRYPT","ANY_VALUE","Area","AsBinary","AsWKB","ASCII","ASIN","AsText","AsWKT","ASYMMETRIC_DECRYPT","ASYMMETRIC_DERIVE","ASYMMETRIC_ENCRYPT","ASYMMETRIC_SIGN","ASYMMETRIC_VERIFY","ATAN","ATAN2","ATAN","AVG","BENCHMARK","BIN","BIT_AND","BIT_COUNT","BIT_LENGTH","BIT_OR","BIT_XOR","Buffer","CAST","CEIL","CEILING","Centroid","CHAR","CHAR_LENGTH","CHARACTER_LENGTH","CHARSET","COALESCE","COERCIBILITY","COLLATION","COMPRESS","CONCAT","CONCAT_WS","CONNECTION_ID","Contains","CONV","CONVERT","CONVERT_TZ","ConvexHull","COS","COT","COUNT","CRC32","CREATE_ASYMMETRIC_PRIV_KEY","CREATE_ASYMMETRIC_PUB_KEY","CREATE_DH_PARAMETERS","CREATE_DIGEST","Crosses","CUME_DIST","CURDATE","CURRENT_DATE","CURRENT_ROLE","CURRENT_TIME","CURRENT_TIMESTAMP","CURRENT_USER","CURTIME","DATABASE","DATE","DATE_ADD","DATE_FORMAT","DATE_SUB","DATEDIFF","DAY","DAYNAME","DAYOFMONTH","DAYOFWEEK","DAYOFYEAR","DECODE","DEFAULT","DEGREES","DES_DECRYPT","DES_ENCRYPT","DENSE_RANK","Dimension","Disjoint","Distance","ELT","ENCODE","ENCRYPT","EndPoint","Envelope","Equals","EXP","EXPORT_SET","ExteriorRing","EXTRACT","ExtractValue","FIELD","FIND_IN_SET","FIRST_VALUE","FLOOR","FORMAT","FORMAT_BYTES","FORMAT_PICO_TIME","FOUND_ROWS","FROM_BASE64","FROM_DAYS","FROM_UNIXTIME","GEN_RANGE","GEN_RND_EMAIL","GEN_RND_PAN","GEN_RND_SSN","GEN_RND_US_PHONE","GeomCollection","GeomCollFromText","GeometryCollectionFromText","GeomCollFromWKB","GeometryCollectionFromWKB","GeometryCollection","GeometryN","GeometryType","GeomFromText","GeometryFromText","GeomFromWKB","GeometryFromWKB","GET_FORMAT","GET_LOCK","GLength","GREATEST","GROUP_CONCAT","GROUPING","GTID_SUBSET","GTID_SUBTRACT","HEX","HOUR","ICU_VERSION","IF","IFNULL","INET_ATON","INET_NTOA","INET6_ATON","INET6_NTOA","INSERT","INSTR","InteriorRingN","Intersects","INTERVAL","IS_FREE_LOCK","IS_IPV4","IS_IPV4_COMPAT","IS_IPV4_MAPPED","IS_IPV6","IS_USED_LOCK","IS_UUID","IsClosed","IsEmpty","ISNULL","IsSimple","JSON_APPEND","JSON_ARRAY","JSON_ARRAY_APPEND","JSON_ARRAY_INSERT","JSON_ARRAYAGG","JSON_CONTAINS","JSON_CONTAINS_PATH","JSON_DEPTH","JSON_EXTRACT","JSON_INSERT","JSON_KEYS","JSON_LENGTH","JSON_MERGE","JSON_MERGE_PATCH","JSON_MERGE_PRESERVE","JSON_OBJECT","JSON_OBJECTAGG","JSON_OVERLAPS","JSON_PRETTY","JSON_QUOTE","JSON_REMOVE","JSON_REPLACE","JSON_SCHEMA_VALID","JSON_SCHEMA_VALIDATION_REPORT","JSON_SEARCH","JSON_SET","JSON_STORAGE_FREE","JSON_STORAGE_SIZE","JSON_TABLE","JSON_TYPE","JSON_UNQUOTE","JSON_VALID","LAG","LAST_DAY","LAST_INSERT_ID","LAST_VALUE","LCASE","LEAD","LEAST","LEFT","LENGTH","LineFromText","LineStringFromText","LineFromWKB","LineStringFromWKB","LineString","LN","LOAD_FILE","LOCALTIME","LOCALTIMESTAMP","LOCATE","LOG","LOG10","LOG2","LOWER","LPAD","LTRIM","MAKE_SET","MAKEDATE","MAKETIME","MASK_INNER","MASK_OUTER","MASK_PAN","MASK_PAN_RELAXED","MASK_SSN","MASTER_POS_WAIT","MAX","MBRContains","MBRCoveredBy","MBRCovers","MBRDisjoint","MBREqual","MBREquals","MBRIntersects","MBROverlaps","MBRTouches","MBRWithin","MD5","MEMBER OF","MICROSECOND","MID","MIN","MINUTE","MLineFromText","MultiLineStringFromText","MLineFromWKB","MultiLineStringFromWKB","MOD","MONTH","MONTHNAME","MPointFromText","MultiPointFromText","MPointFromWKB","MultiPointFromWKB","MPolyFromText","MultiPolygonFromText","MPolyFromWKB","MultiPolygonFromWKB","MultiLineString","MultiPoint","MultiPolygon","NAME_CONST","NOT IN","NOW","NTH_VALUE","NTILE","NULLIF","NumGeometries","NumInteriorRings","NumPoints","OCT","OCTET_LENGTH","OLD_PASSWORD","ORD","Overlaps","PASSWORD","PERCENT_RANK","PERIOD_ADD","PERIOD_DIFF","PI","Point","PointFromText","PointFromWKB","PointN","PolyFromText","PolygonFromText","PolyFromWKB","PolygonFromWKB","Polygon","POSITION","POW","POWER","PS_CURRENT_THREAD_ID","PS_THREAD_ID","PROCEDURE ANALYSE","QUARTER","QUOTE","RADIANS","RAND","RANDOM_BYTES","RANK","REGEXP_INSTR","REGEXP_LIKE","REGEXP_REPLACE","REGEXP_REPLACE","RELEASE_ALL_LOCKS","RELEASE_LOCK","REPEAT","REPLACE","REVERSE","RIGHT","ROLES_GRAPHML","ROUND","ROW_COUNT","ROW_NUMBER","RPAD","RTRIM","SCHEMA","SEC_TO_TIME","SECOND","SESSION_USER","SHA1","SHA","SHA2","SIGN","SIN","SLEEP","SOUNDEX","SOURCE_POS_WAIT","SPACE","SQRT","SRID","ST_Area","ST_AsBinary","ST_AsWKB","ST_AsGeoJSON","ST_AsText","ST_AsWKT","ST_Buffer","ST_Buffer_Strategy","ST_Centroid","ST_Collect","ST_Contains","ST_ConvexHull","ST_Crosses","ST_Difference","ST_Dimension","ST_Disjoint","ST_Distance","ST_Distance_Sphere","ST_EndPoint","ST_Envelope","ST_Equals","ST_ExteriorRing","ST_FrechetDistance","ST_GeoHash","ST_GeomCollFromText","ST_GeometryCollectionFromText","ST_GeomCollFromTxt","ST_GeomCollFromWKB","ST_GeometryCollectionFromWKB","ST_GeometryN","ST_GeometryType","ST_GeomFromGeoJSON","ST_GeomFromText","ST_GeometryFromText","ST_GeomFromWKB","ST_GeometryFromWKB","ST_HausdorffDistance","ST_InteriorRingN","ST_Intersection","ST_Intersects","ST_IsClosed","ST_IsEmpty","ST_IsSimple","ST_IsValid","ST_LatFromGeoHash","ST_Length","ST_LineFromText","ST_LineStringFromText","ST_LineFromWKB","ST_LineStringFromWKB","ST_LineInterpolatePoint","ST_LineInterpolatePoints","ST_LongFromGeoHash","ST_Longitude","ST_MakeEnvelope","ST_MLineFromText","ST_MultiLineStringFromText","ST_MLineFromWKB","ST_MultiLineStringFromWKB","ST_MPointFromText","ST_MultiPointFromText","ST_MPointFromWKB","ST_MultiPointFromWKB","ST_MPolyFromText","ST_MultiPolygonFromText","ST_MPolyFromWKB","ST_MultiPolygonFromWKB","ST_NumGeometries","ST_NumInteriorRing","ST_NumInteriorRings","ST_NumPoints","ST_Overlaps","ST_PointAtDistance","ST_PointFromGeoHash","ST_PointFromText","ST_PointFromWKB","ST_PointN","ST_PolyFromText","ST_PolygonFromText","ST_PolyFromWKB","ST_PolygonFromWKB","ST_Simplify","ST_SRID","ST_StartPoint","ST_SwapXY","ST_SymDifference","ST_Touches","ST_Transform","ST_Union","ST_Validate","ST_Within","ST_X","ST_Y","StartPoint","STATEMENT_DIGEST","STATEMENT_DIGEST_TEXT","STD","STDDEV","STDDEV_POP","STDDEV_SAMP","STR_TO_DATE","STRCMP","SUBDATE","SUBSTR","SUBSTRING","SUBSTRING_INDEX","SUBTIME","SUM","SYSDATE","SYSTEM_USER","TAN","TIME","TIME_FORMAT","TIME_TO_SEC","TIMEDIFF","TIMESTAMP","TIMESTAMPADD","TIMESTAMPDIFF","TO_BASE64","TO_DAYS","TO_SECONDS","Touches","TRIM","TRUNCATE","UCASE","UNCOMPRESS","UNCOMPRESSED_LENGTH","UNHEX","UNIX_TIMESTAMP","UpdateXML","UPPER","USER","UTC_DATE","UTC_TIME","UTC_TIMESTAMP","UUID","UUID_SHORT","UUID_TO_BIN","VALIDATE_PASSWORD_STRENGTH","VALUES","VAR_POP","VAR_SAMP","VARIANCE","VERSION","WAIT_FOR_EXECUTED_GTID_SET","WAIT_UNTIL_SQL_THREAD_AFTER_GTIDS","WEEK","WEEKDAY","WEEKOFYEAR","WEIGHT_STRING","Within","X","Y","YEAR","YEARWEEK"],builtinVariables:[],tokenizer:{root:[{include:"@comments"},{include:"@whitespace"},{include:"@numbers"},{include:"@strings"},{include:"@complexIdentifiers"},{include:"@scopes"},[/[;,.]/,"delimiter"],[/[()]/,"@brackets"],[/[\w@]+/,{cases:{"@operators":"operator","@builtinVariables":"predefined","@builtinFunctions":"predefined","@keywords":"keyword","@default":"identifier"}}],[/[<>=!%&+\-*/|~^]/,"operator"]],whitespace:[[/\s+/,"white"]],comments:[[/--+.*/,"comment"],[/#+.*/,"comment"],[/\/\*/,{token:"comment.quote",next:"@comment"}]],comment:[[/[^*/]+/,"comment"],[/\*\//,{token:"comment.quote",next:"@pop"}],[/./,"comment"]],numbers:[[/0[xX][0-9a-fA-F]*/,"number"],[/[$][+-]*\d*(\.\d*)?/,"number"],[/((\d+(\.\d*)?)|(\.\d+))([eE][\-+]?\d+)?/,"number"]],strings:[[/'/,{token:"string",next:"@string"}],[/"/,{token:"string.double",next:"@stringDouble"}]],string:[[/[^']+/,"string"],[/''/,"string"],[/'/,{token:"string",next:"@pop"}]],stringDouble:[[/[^"]+/,"string.double"],[/""/,"string.double"],[/"/,{token:"string.double",next:"@pop"}]],complexIdentifiers:[[/`/,{token:"identifier.quote",next:"@quotedIdentifier"}]],quotedIdentifier:[[/[^`]+/,"identifier"],[/``/,"identifier"],[/`/,{token:"identifier.quote",next:"@pop"}]],scopes:[]}}},83015:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return n},language:function(){return o}});
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
var n={comments:{lineComment:"//",blockComment:["/*","*/"]},brackets:[["{","}"],["[","]"],["(",")"]],autoClosingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"'},{open:"'",close:"'"}],surroundingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"'},{open:"'",close:"'"}]},o={defaultToken:"",tokenPostfix:".objective-c",keywords:["#import","#include","#define","#else","#endif","#if","#ifdef","#ifndef","#ident","#undef","@class","@defs","@dynamic","@encode","@end","@implementation","@interface","@package","@private","@protected","@property","@protocol","@public","@selector","@synthesize","__declspec","assign","auto","BOOL","break","bycopy","byref","case","char","Class","const","copy","continue","default","do","double","else","enum","extern","FALSE","false","float","for","goto","if","in","int","id","inout","IMP","long","nil","nonatomic","NULL","oneway","out","private","public","protected","readwrite","readonly","register","return","SEL","self","short","signed","sizeof","static","struct","super","switch","typedef","TRUE","true","union","unsigned","volatile","void","while"],decpart:/\d(_?\d)*/,decimal:/0|@decpart/,tokenizer:{root:[{include:"@comments"},{include:"@whitespace"},{include:"@numbers"},{include:"@strings"},[/[,:;]/,"delimiter"],[/[{}\[\]()<>]/,"@brackets"],[/[a-zA-Z@#]\w*/,{cases:{"@keywords":"keyword","@default":"identifier"}}],[/[<>=\\+\\-\\*\\/\\^\\|\\~,]|and\\b|or\\b|not\\b]/,"operator"]],whitespace:[[/\s+/,"white"]],comments:[["\\/\\*","comment","@comment"],["\\/\\/+.*","comment"]],comment:[["\\*\\/","comment","@pop"],[".","comment"]],numbers:[[/0[xX][0-9a-fA-F]*(_?[0-9a-fA-F])*/,"number.hex"],[/@decimal((\.@decpart)?([eE][\-+]?@decpart)?)[fF]*/,{cases:{"(\\d)*":"number",$0:"number.float"}}]],strings:[[/'$/,"string.escape","@popall"],[/'/,"string.escape","@stringBody"],[/"$/,"string.escape","@popall"],[/"/,"string.escape","@dblStringBody"]],stringBody:[[/[^\\']+$/,"string","@popall"],[/[^\\']+/,"string"],[/\\./,"string"],[/'/,"string.escape","@popall"],[/\\$/,"string"]],dblStringBody:[[/[^\\"]+$/,"string","@popall"],[/[^\\"]+/,"string"],[/\\./,"string"],[/"/,"string.escape","@popall"],[/\\$/,"string"]]}}},21599:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return n},language:function(){return o}});
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
var n={wordPattern:/(-?\d*\.\d\w*)|([^\`\~\!\#\%\^\&\*\(\)\-\=\+\[\{\]\}\\\|\;\:\'\"\,\.\<\>\/\?\s]+)/g,comments:{lineComment:"//",blockComment:["{","}"]},brackets:[["{","}"],["[","]"],["(",")"],["<",">"]],autoClosingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:"<",close:">"},{open:"'",close:"'"}],surroundingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:"<",close:">"},{open:"'",close:"'"}],folding:{markers:{start:new RegExp("^\\s*\\{\\$REGION(\\s\\'.*\\')?\\}"),end:new RegExp("^\\s*\\{\\$ENDREGION\\}")}}},o={defaultToken:"",tokenPostfix:".pascal",ignoreCase:!0,brackets:[{open:"{",close:"}",token:"delimiter.curly"},{open:"[",close:"]",token:"delimiter.square"},{open:"(",close:")",token:"delimiter.parenthesis"},{open:"<",close:">",token:"delimiter.angle"}],keywords:["absolute","abstract","all","and_then","array","as","asm","attribute","begin","bindable","case","class","const","contains","default","div","else","end","except","exports","external","far","file","finalization","finally","forward","generic","goto","if","implements","import","in","index","inherited","initialization","interrupt","is","label","library","mod","module","name","near","not","object","of","on","only","operator","or_else","otherwise","override","package","packed","pow","private","program","protected","public","published","interface","implementation","qualified","read","record","resident","requires","resourcestring","restricted","segment","set","shl","shr","specialize","stored","strict","then","threadvar","to","try","type","unit","uses","var","view","virtual","dynamic","overload","reintroduce","with","write","xor","true","false","procedure","function","constructor","destructor","property","break","continue","exit","abort","while","do","for","raise","repeat","until"],typeKeywords:["boolean","double","byte","integer","shortint","char","longint","float","string"],operators:["=",">","<","<=",">=","<>",":",":=","and","or","+","-","*","/","@","&","^","%"],symbols:/[=><:@\^&|+\-*\/\^%]+/,tokenizer:{root:[[/[a-zA-Z_][\w]*/,{cases:{"@keywords":{token:"keyword.$0"},"@default":"identifier"}}],{include:"@whitespace"},[/[{}()\[\]]/,"@brackets"],[/[<>](?!@symbols)/,"@brackets"],[/@symbols/,{cases:{"@operators":"delimiter","@default":""}}],[/\d*\.\d+([eE][\-+]?\d+)?/,"number.float"],[/\$[0-9a-fA-F]{1,16}/,"number.hex"],[/\d+/,"number"],[/[;,.]/,"delimiter"],[/'([^'\\]|\\.)*$/,"string.invalid"],[/'/,"string","@string"],[/'[^\\']'/,"string"],[/'/,"string.invalid"],[/\#\d+/,"string"]],comment:[[/[^\*\}]+/,"comment"],[/\}/,"comment","@pop"],[/[\{]/,"comment"]],string:[[/[^\\']+/,"string"],[/\\./,"string.escape.invalid"],[/'/,{token:"string.quote",bracket:"@close",next:"@pop"}]],whitespace:[[/[ \t\r\n]+/,"white"],[/\{/,"comment","@comment"],[/\/\/.*$/,"comment"]]}}},95104:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return n},language:function(){return o}});
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
var n={comments:{lineComment:"//",blockComment:["(*","*)"]},brackets:[["{","}"],["[","]"],["(",")"],["<",">"]],autoClosingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:"<",close:">"},{open:"'",close:"'"}],surroundingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:"<",close:">"},{open:"'",close:"'"}]},o={defaultToken:"",tokenPostfix:".pascaligo",ignoreCase:!0,brackets:[{open:"{",close:"}",token:"delimiter.curly"},{open:"[",close:"]",token:"delimiter.square"},{open:"(",close:")",token:"delimiter.parenthesis"},{open:"<",close:">",token:"delimiter.angle"}],keywords:["begin","block","case","const","else","end","fail","for","from","function","if","is","nil","of","remove","return","skip","then","type","var","while","with","option","None","transaction"],typeKeywords:["bool","int","list","map","nat","record","string","unit","address","map","mtz","xtz"],operators:["=",">","<","<=",">=","<>",":",":=","and","mod","or","+","-","*","/","@","&","^","%"],symbols:/[=><:@\^&|+\-*\/\^%]+/,tokenizer:{root:[[/[a-zA-Z_][\w]*/,{cases:{"@keywords":{token:"keyword.$0"},"@default":"identifier"}}],{include:"@whitespace"},[/[{}()\[\]]/,"@brackets"],[/[<>](?!@symbols)/,"@brackets"],[/@symbols/,{cases:{"@operators":"delimiter","@default":""}}],[/\d*\.\d+([eE][\-+]?\d+)?/,"number.float"],[/\$[0-9a-fA-F]{1,16}/,"number.hex"],[/\d+/,"number"],[/[;,.]/,"delimiter"],[/'([^'\\]|\\.)*$/,"string.invalid"],[/'/,"string","@string"],[/'[^\\']'/,"string"],[/'/,"string.invalid"],[/\#\d+/,"string"]],comment:[[/[^\(\*]+/,"comment"],[/\*\)/,"comment","@pop"],[/\(\*/,"comment"]],string:[[/[^\\']+/,"string"],[/\\./,"string.escape.invalid"],[/'/,{token:"string.quote",bracket:"@close",next:"@pop"}]],whitespace:[[/[ \t\r\n]+/,"white"],[/\(\*/,"comment","@comment"],[/\/\/.*$/,"comment"]]}}},59184:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return n},language:function(){return o}});
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
var n={comments:{lineComment:"#"},brackets:[["{","}"],["[","]"],["(",")"]],autoClosingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"'},{open:"'",close:"'"},{open:"`",close:"`"}],surroundingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"'},{open:"'",close:"'"},{open:"`",close:"`"}]},o={defaultToken:"",tokenPostfix:".perl",brackets:[{token:"delimiter.bracket",open:"{",close:"}"},{token:"delimiter.parenthesis",open:"(",close:")"},{token:"delimiter.square",open:"[",close:"]"}],keywords:["__DATA__","else","lock","__END__","elsif","lt","__FILE__","eq","__LINE__","exp","ne","sub","__PACKAGE__","for","no","and","foreach","or","unless","cmp","ge","package","until","continue","gt","while","CORE","if","xor","do","le","__DIE__","__WARN__"],builtinFunctions:["-A","END","length","setpgrp","-B","endgrent","link","setpriority","-b","endhostent","listen","setprotoent","-C","endnetent","local","setpwent","-c","endprotoent","localtime","setservent","-d","endpwent","log","setsockopt","-e","endservent","lstat","shift","-f","eof","map","shmctl","-g","eval","mkdir","shmget","-k","exec","msgctl","shmread","-l","exists","msgget","shmwrite","-M","exit","msgrcv","shutdown","-O","fcntl","msgsnd","sin","-o","fileno","my","sleep","-p","flock","next","socket","-r","fork","not","socketpair","-R","format","oct","sort","-S","formline","open","splice","-s","getc","opendir","split","-T","getgrent","ord","sprintf","-t","getgrgid","our","sqrt","-u","getgrnam","pack","srand","-w","gethostbyaddr","pipe","stat","-W","gethostbyname","pop","state","-X","gethostent","pos","study","-x","getlogin","print","substr","-z","getnetbyaddr","printf","symlink","abs","getnetbyname","prototype","syscall","accept","getnetent","push","sysopen","alarm","getpeername","quotemeta","sysread","atan2","getpgrp","rand","sysseek","AUTOLOAD","getppid","read","system","BEGIN","getpriority","readdir","syswrite","bind","getprotobyname","readline","tell","binmode","getprotobynumber","readlink","telldir","bless","getprotoent","readpipe","tie","break","getpwent","recv","tied","caller","getpwnam","redo","time","chdir","getpwuid","ref","times","CHECK","getservbyname","rename","truncate","chmod","getservbyport","require","uc","chomp","getservent","reset","ucfirst","chop","getsockname","return","umask","chown","getsockopt","reverse","undef","chr","glob","rewinddir","UNITCHECK","chroot","gmtime","rindex","unlink","close","goto","rmdir","unpack","closedir","grep","say","unshift","connect","hex","scalar","untie","cos","index","seek","use","c