/*
 * Copyright (c) 2011-2022 PrimeFaces Extensions
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */

package org.primefaces.extensions.model.monacoeditor;

// ============================================================
// THIS FILE WAS GENERATED AUTOMATICALLY. DO NOT EDIT DIRECTLY.
// ============================================================

/**
 * initial language of the auto created model in the editor.
 */
public enum ELanguage {
    ABAP("abap"),

    AES("aes"),

    APEX("apex"),

    AZCLI("azcli"),

    BAT("bat"),

    BICEP("bicep"),

    C("c"),

    CAMELIGO("cameligo"),

    CLOJURE("clojure"),

    COFFEESCRIPT("coffeescript"),

    CPP("cpp"),

    CSHARP("csharp"),

    CSP("csp"),

    CSS("css"),

    CYPHER("cypher"),

    DART("dart"),

    DOCKERFILE("dockerfile"),

    ECL("ecl"),

    ELIXIR("elixir"),

    FLOW9("flow9"),

    FREEMARKER2("freemarker2"),

    FREEMARKER2_TAG_ANGLE_INTERPOLATION_BRACKET("freemarker2.tag-angle.interpolation-bracket"),

    FREEMARKER2_TAG_ANGLE_INTERPOLATION_DOLLAR("freemarker2.tag-angle.interpolation-dollar"),

    FREEMARKER2_TAG_AUTO_INTERPOLATION_BRACKET("freemarker2.tag-auto.interpolation-bracket"),

    FREEMARKER2_TAG_AUTO_INTERPOLATION_DOLLAR("freemarker2.tag-auto.interpolation-dollar"),

    FREEMARKER2_TAG_BRACKET_INTERPOLATION_BRACKET("freemarker2.tag-bracket.interpolation-bracket"),

    FREEMARKER2_TAG_BRACKET_INTERPOLATION_DOLLAR("freemarker2.tag-bracket.interpolation-dollar"),

    FSHARP("fsharp"),

    GO("go"),

    GRAPHQL("graphql"),

    HANDLEBARS("handlebars"),

    HCL("hcl"),

    HTML("html"),

    INI("ini"),

    JAVA("java"),

    JAVASCRIPT("javascript"),

    JSON("json"),

    JULIA("julia"),

    KOTLIN("kotlin"),

    LESS("less"),

    LEXON("lexon"),

    LIQUID("liquid"),

    LUA("lua"),

    M3("m3"),

    MARKDOWN("markdown"),

    MIPS("mips"),

    MSDAX("msdax"),

    MYSQL("mysql"),

    OBJECTIVE_C("objective-c"),

    PASCAL("pascal"),

    PASCALIGO("pascaligo"),

    PERL("perl"),

    PGSQL("pgsql"),

    PHP("php"),

    PLA("pla"),

    PLAINTEXT("plaintext"),

    POSTIATS("postiats"),

    POWERQUERY("powerquery"),

    POWERSHELL("powershell"),

    PROTO("proto"),

    PUG("pug"),

    PYTHON("python"),

    QSHARP("qsharp"),

    R("r"),

    RAZOR("razor"),

    REDIS("redis"),

    REDSHIFT("redshift"),

    RESTRUCTUREDTEXT("restructuredtext"),

    RUBY("ruby"),

    RUST("rust"),

    SB("sb"),

    SCALA("scala"),

    SCHEME("scheme"),

    SCSS("scss"),

    SHELL("shell"),

    SOL("sol"),

    SPARQL("sparql"),

    SQL("sql"),

    ST("st"),

    SWIFT("swift"),

    SYSTEMVERILOG("systemverilog"),

    TCL("tcl"),

    TWIG("twig"),

    TYPESCRIPT("typescript"),

    VB("vb"),

    VERILOG("verilog"),

    XML("xml"),

    YAML("yaml"),
    ;

    private final String toString;

    ELanguage(final String toString) {
        this.toString = toString;
    }

    @Override
    public String toString() {
        return toString;
    }

    public static ELanguage parseString(String name) {
        for (final ELanguage enumConst : values()) {
            if (enumConst.toString.equals(name)) {
                return enumConst;
            }
        }
        throw new IllegalArgumentException("No such enum constant with name '" + name + "'");
    }
}