
/*
 * Copyright (c) 2011-2022 PrimeFaces Extensions
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */

package org.primefaces.extensions.model.monacoeditor;

import org.primefaces.shaded.json.*;
import java.io.ObjectStreamException;
import java.io.Serializable;

// ============================================================
// THIS FILE WAS GENERATED AUTOMATICALLY. DO NOT EDIT DIRECTLY.
// ============================================================

/**
 * The options to create a Monaco Code editor instance.
 */
@SuppressWarnings("serial")
public class EditorOptions extends JSONObject implements Serializable {
    private Object writeReplace() throws ObjectStreamException {
        return new SerializedEditorOptions(this);
    }

    private static class SerializedEditorOptions implements Serializable {
        private String json;

        public SerializedEditorOptions(EditorOptions editorOptions) {
            this.json = editorOptions.toString();
        }

        private Object readResolve() throws ObjectStreamException {
            final EditorOptions editorOptions = new EditorOptions();
            final JSONObject data = new JSONObject(json);
            for (final String key : data.keySet()) {
                final Object value = data.get(key);
                editorOptions.put(key, value);
            }
            return editorOptions;
        }
    }

    /**
     * @return Configures bracket pair colorization (disabled by default).
     */
    public EditorBracketPairColorizationOptions getBracketPairColorization() {
        return (EditorBracketPairColorizationOptions) (has("bracketPairColorization") ? get("bracketPairColorization") : null);
    }

    /**
     * @param bracketPairColorization Configures bracket pair colorization (disabled by default).
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setBracketPairColorization(final EditorBracketPairColorizationOptions bracketPairColorization) {
        put("bracketPairColorization", bracketPairColorization);
        return this;
    }

    /**
     * @return Control the behavior of comments in the editor.
     */
    public EditorCommentsOptions getComments() {
        return (EditorCommentsOptions) (has("comments") ? get("comments") : null);
    }

    /**
     * @param comments Control the behavior of comments in the editor.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setComments(final EditorCommentsOptions comments) {
        put("comments", comments);
        return this;
    }

    /**
     * @return Controls dropping into the editor from an external source. When enabled, this shows a preview of the drop
     * location and triggers an onDropIntoEditor event.
     */
    public EditorDropIntoEditorOptions getDropIntoEditor() {
        return (EditorDropIntoEditorOptions) (has("dropIntoEditor") ? get("dropIntoEditor") : null);
    }

    /**
     * @param dropIntoEditor Controls dropping into the editor from an external source. When enabled, this shows a
     * preview of the drop location and triggers an onDropIntoEditor event.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setDropIntoEditor(final EditorDropIntoEditorOptions dropIntoEditor) {
        put("dropIntoEditor", dropIntoEditor);
        return this;
    }

    /**
     * @return Control the behavior of the find widget.
     */
    public EditorFindOptions getFind() {
        return (EditorFindOptions) (has("find") ? get("find") : null);
    }

    /**
     * @param find Control the behavior of the find widget.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setFind(final EditorFindOptions find) {
        put("find", find);
        return this;
    }

    /**
     * @return Controls the behavior of editor guides.
     */
    public EditorGuidesOptions getGuides() {
        return (EditorGuidesOptions) (has("guides") ? get("guides") : null);
    }

    /**
     * @param guides Controls the behavior of editor guides.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setGuides(final EditorGuidesOptions guides) {
        put("guides", guides);
        return this;
    }

    public EditorGotoLocationOptions getGotoLocation() {
        return (EditorGotoLocationOptions) (has("gotoLocation") ? get("gotoLocation") : null);
    }

    public EditorOptions setGotoLocation(final EditorGotoLocationOptions gotoLocation) {
        put("gotoLocation", gotoLocation);
        return this;
    }

    /**
     * @return Configure the editor&#039;s hover.
     */
    public EditorHoverOptions getHover() {
        return (EditorHoverOptions) (has("hover") ? get("hover") : null);
    }

    /**
     * @param hover Configure the editor&#039;s hover.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setHover(final EditorHoverOptions hover) {
        put("hover", hover);
        return this;
    }

    /**
     * @return Control the behavior and rendering of the inline hints.
     */
    public EditorInlayHintOptions getInlayHints() {
        return (EditorInlayHintOptions) (has("inlayHints") ? get("inlayHints") : null);
    }

    /**
     * @param inlayHints Control the behavior and rendering of the inline hints.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setInlayHints(final EditorInlayHintOptions inlayHints) {
        put("inlayHints", inlayHints);
        return this;
    }

    /**
     * @return Control the behavior and rendering of the inline completions.
     */
    public EditorInlineSuggestOptions getInlineSuggest() {
        return (EditorInlineSuggestOptions) (has("inlineSuggest") ? get("inlineSuggest") : null);
    }

    /**
     * @param inlineSuggest Control the behavior and rendering of the inline completions.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setInlineSuggest(final EditorInlineSuggestOptions inlineSuggest) {
        put("inlineSuggest", inlineSuggest);
        return this;
    }

    /**
     * @return Control the behavior and rendering of the code action lightbulb.
     */
    public EditorLightbulbOptions getLightbulb() {
        return (EditorLightbulbOptions) (has("lightbulb") ? get("lightbulb") : null);
    }

    /**
     * @param lightbulb Control the behavior and rendering of the code action lightbulb.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setLightbulb(final EditorLightbulbOptions lightbulb) {
        put("lightbulb", lightbulb);
        return this;
    }

    /**
     * @return Control the behavior and rendering of the minimap.
     */
    public EditorMinimapOptions getMinimap() {
        return (EditorMinimapOptions) (has("minimap") ? get("minimap") : null);
    }

    /**
     * @param minimap Control the behavior and rendering of the minimap.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setMinimap(final EditorMinimapOptions minimap) {
        put("minimap", minimap);
        return this;
    }

    /**
     * @return Controls the spacing around the editor.
     */
    public EditorPaddingOptions getPadding() {
        return (EditorPaddingOptions) (has("padding") ? get("padding") : null);
    }

    /**
     * @param padding Controls the spacing around the editor.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setPadding(final EditorPaddingOptions padding) {
        put("padding", padding);
        return this;
    }

    /**
     * @return Parameter hint options.
     */
    public EditorParameterHints getParameterHints() {
        return (EditorParameterHints) (has("parameterHints") ? get("parameterHints") : null);
    }

    /**
     * @param parameterHints Parameter hint options.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setParameterHints(final EditorParameterHints parameterHints) {
        put("parameterHints", parameterHints);
        return this;
    }

    /**
     * @return Enable quick suggestions (shadow suggestions) Defaults to {@code true}.
     */
    public EditorQuickSuggestionsOptions getQuickSuggestions() {
        return (EditorQuickSuggestionsOptions) (has("quickSuggestions") ? get("quickSuggestions") : null);
    }

    /**
     * @param quickSuggestions Enable quick suggestions (shadow suggestions) Defaults to {@code true}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setQuickSuggestions(final EditorQuickSuggestionsOptions quickSuggestions) {
        put("quickSuggestions", quickSuggestions);
        return this;
    }

    /**
     * @return Control the behavior and rendering of the scrollbars.
     */
    public EditorScrollbarOptions getScrollbar() {
        return (EditorScrollbarOptions) (has("scrollbar") ? get("scrollbar") : null);
    }

    /**
     * @param scrollbar Control the behavior and rendering of the scrollbars.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setScrollbar(final EditorScrollbarOptions scrollbar) {
        put("scrollbar", scrollbar);
        return this;
    }

    /**
     * @return Smart select options.
     */
    public EditorSmartSelectOptions getSmartSelect() {
        return (EditorSmartSelectOptions) (has("smartSelect") ? get("smartSelect") : null);
    }

    /**
     * @param smartSelect Smart select options.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setSmartSelect(final EditorSmartSelectOptions smartSelect) {
        put("smartSelect", smartSelect);
        return this;
    }

    /**
     * @return Control the behavior of sticky scroll options
     */
    public EditorStickyScrollOptions getStickyScroll() {
        return (EditorStickyScrollOptions) (has("stickyScroll") ? get("stickyScroll") : null);
    }

    /**
     * @param stickyScroll Control the behavior of sticky scroll options
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setStickyScroll(final EditorStickyScrollOptions stickyScroll) {
        put("stickyScroll", stickyScroll);
        return this;
    }

    /**
     * @return Suggest options.
     */
    public EditorSuggestOptions getSuggest() {
        return (EditorSuggestOptions) (has("suggest") ? get("suggest") : null);
    }

    /**
     * @param suggest Suggest options.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setSuggest(final EditorSuggestOptions suggest) {
        put("suggest", suggest);
        return this;
    }

    /**
     * @return Defines how Unicode characters should be highlighted.
     */
    public EditorUnicodeHighlightOptions getUnicodeHighlight() {
        return (EditorUnicodeHighlightOptions) (has("unicodeHighlight") ? get("unicodeHighlight") : null);
    }

    /**
     * @param unicodeHighlight Defines how Unicode characters should be highlighted.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setUnicodeHighlight(final EditorUnicodeHighlightOptions unicodeHighlight) {
        put("unicodeHighlight", unicodeHighlight);
        return this;
    }

    /**
     * @return Options for typing over closing quotes or brackets.
     */
    public String getAutoClosingOvertype() {
        return (String) (has("autoClosingOvertype") ? get("autoClosingOvertype") : null);
    }

    /**
     * @param autoClosingOvertype Options for typing over closing quotes or brackets.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setAutoClosingOvertype(final EAutoClosingOvertype autoClosingOvertype) {
        put("autoClosingOvertype", autoClosingOvertype != null ? autoClosingOvertype.toString() : null);
        return this;
    }

    /**
     * @param autoClosingOvertype Options for typing over closing quotes or brackets.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setAutoClosingOvertype(final String autoClosingOvertype) {
        put("autoClosingOvertype", autoClosingOvertype);
        return this;
    }

    /**
     * @return Controls whether the editor should automatically adjust the indentation when users type, paste, move or
     * indent lines. Defaults to {@code advanced}.
     */
    public String getAutoIndent() {
        return (String) (has("autoIndent") ? get("autoIndent") : null);
    }

    /**
     * @param autoIndent Controls whether the editor should automatically adjust the indentation when users type, paste,
     * move or indent lines. Defaults to {@code advanced}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setAutoIndent(final EAutoIndent autoIndent) {
        put("autoIndent", autoIndent != null ? autoIndent.toString() : null);
        return this;
    }

    /**
     * @param autoIndent Controls whether the editor should automatically adjust the indentation when users type, paste,
     * move or indent lines. Defaults to {@code advanced}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setAutoIndent(final String autoIndent) {
        put("autoIndent", autoIndent);
        return this;
    }

    /**
     * @return Accept suggestions on ENTER. Defaults to {@code on}.
     */
    public String getAcceptSuggestionOnEnter() {
        return (String) (has("acceptSuggestionOnEnter") ? get("acceptSuggestionOnEnter") : null);
    }

    /**
     * @param acceptSuggestionOnEnter Accept suggestions on ENTER. Defaults to {@code on}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setAcceptSuggestionOnEnter(final EAcceptSuggestionOnEnter acceptSuggestionOnEnter) {
        put("acceptSuggestionOnEnter", acceptSuggestionOnEnter != null ? acceptSuggestionOnEnter.toString() : null);
        return this;
    }

    /**
     * @param acceptSuggestionOnEnter Accept suggestions on ENTER. Defaults to {@code on}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setAcceptSuggestionOnEnter(final String acceptSuggestionOnEnter) {
        put("acceptSuggestionOnEnter", acceptSuggestionOnEnter);
        return this;
    }

    /**
     * @return Configure the editor&#039;s accessibility support. Defaults to {@code auto}. It is best to leave this to
     * {@code auto}.
     */
    public String getAccessibilitySupport() {
        return (String) (has("accessibilitySupport") ? get("accessibilitySupport") : null);
    }

    /**
     * @param accessibilitySupport Configure the editor&#039;s accessibility support. Defaults to {@code auto}. It is best to
     * leave this to {@code auto}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setAccessibilitySupport(final EAccessibilitySupport accessibilitySupport) {
        put("accessibilitySupport", accessibilitySupport != null ? accessibilitySupport.toString() : null);
        return this;
    }

    /**
     * @param accessibilitySupport Configure the editor&#039;s accessibility support. Defaults to {@code auto}. It is best to
     * leave this to {@code auto}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setAccessibilitySupport(final String accessibilitySupport) {
        put("accessibilitySupport", accessibilitySupport);
        return this;
    }

    /**
     * @return Options for auto closing brackets. Defaults to language defined behavior.
     */
    public String getAutoClosingBrackets() {
        return (String) (has("autoClosingBrackets") ? get("autoClosingBrackets") : null);
    }

    /**
     * @param autoClosingBrackets Options for auto closing brackets. Defaults to language defined behavior.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setAutoClosingBrackets(final EAutoClosingBrackets autoClosingBrackets) {
        put("autoClosingBrackets", autoClosingBrackets != null ? autoClosingBrackets.toString() : null);
        return this;
    }

    /**
     * @param autoClosingBrackets Options for auto closing brackets. Defaults to language defined behavior.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setAutoClosingBrackets(final String autoClosingBrackets) {
        put("autoClosingBrackets", autoClosingBrackets);
        return this;
    }

    /**
     * @return Options for pressing backspace near quotes or bracket pairs.
     */
    public String getAutoClosingDelete() {
        return (String) (has("autoClosingDelete") ? get("autoClosingDelete") : null);
    }

    /**
     * @param autoClosingDelete Options for pressing backspace near quotes or bracket pairs.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setAutoClosingDelete(final EAutoClosingEditStrategy autoClosingDelete) {
        put("autoClosingDelete", autoClosingDelete != null ? autoClosingDelete.toString() : null);
        return this;
    }

    /**
     * @param autoClosingDelete Options for pressing backspace near quotes or bracket pairs.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setAutoClosingDelete(final String autoClosingDelete) {
        put("autoClosingDelete", autoClosingDelete);
        return this;
    }

    /**
     * @return Options for auto closing quotes. Defaults to language defined behavior.
     */
    public String getAutoClosingQuotes() {
        return (String) (has("autoClosingQuotes") ? get("autoClosingQuotes") : null);
    }

    /**
     * @param autoClosingQuotes Options for auto closing quotes. Defaults to language defined behavior.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setAutoClosingQuotes(final EAutoClosingQuotes autoClosingQuotes) {
        put("autoClosingQuotes", autoClosingQuotes != null ? autoClosingQuotes.toString() : null);
        return this;
    }

    /**
     * @param autoClosingQuotes Options for auto closing quotes. Defaults to language defined behavior.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setAutoClosingQuotes(final String autoClosingQuotes) {
        put("autoClosingQuotes", autoClosingQuotes);
        return this;
    }

    /**
     * @return Options for auto surrounding. Defaults to always allowing auto surrounding.
     */
    public String getAutoSurround() {
        return (String) (has("autoSurround") ? get("autoSurround") : null);
    }

    /**
     * @param autoSurround Options for auto surrounding. Defaults to always allowing auto surrounding.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setAutoSurround(final EAutoSurround autoSurround) {
        put("autoSurround", autoSurround != null ? autoSurround.toString() : null);
        return this;
    }

    /**
     * @param autoSurround Options for auto surrounding. Defaults to always allowing auto surrounding.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setAutoSurround(final String autoSurround) {
        put("autoSurround", autoSurround);
        return this;
    }

    /**
     * @return Control the cursor animation style, possible values are {@code blink}, {@code smooth}, {@code phase},
     * {@code expand} and {@code solid}. Defaults to {@code blink}.
     */
    public String getCursorBlinking() {
        return (String) (has("cursorBlinking") ? get("cursorBlinking") : null);
    }

    /**
     * @param cursorBlinking Control the cursor animation style, possible values are {@code blink}, {@code smooth},
     * {@code phase}, {@code expand} and {@code solid}. Defaults to {@code blink}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setCursorBlinking(final ECursorBlinking cursorBlinking) {
        put("cursorBlinking", cursorBlinking != null ? cursorBlinking.toString() : null);
        return this;
    }

    /**
     * @param cursorBlinking Control the cursor animation style, possible values are {@code blink}, {@code smooth},
     * {@code phase}, {@code expand} and {@code solid}. Defaults to {@code blink}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setCursorBlinking(final String cursorBlinking) {
        put("cursorBlinking", cursorBlinking);
        return this;
    }

    /**
     * @return Enable smooth caret animation. Defaults to {@code off}.
     */
    public String getCursorSmoothCaretAnimation() {
        return (String) (has("cursorSmoothCaretAnimation") ? get("cursorSmoothCaretAnimation") : null);
    }

    /**
     * @param cursorSmoothCaretAnimation Enable smooth caret animation. Defaults to {@code off}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setCursorSmoothCaretAnimation(final ECursorSmoothCaretAnimation cursorSmoothCaretAnimation) {
        put("cursorSmoothCaretAnimation", cursorSmoothCaretAnimation != null ? cursorSmoothCaretAnimation.toString() : null);
        return this;
    }

    /**
     * @param cursorSmoothCaretAnimation Enable smooth caret animation. Defaults to {@code off}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setCursorSmoothCaretAnimation(final String cursorSmoothCaretAnimation) {
        put("cursorSmoothCaretAnimation", cursorSmoothCaretAnimation);
        return this;
    }

    /**
     * @return Control the cursor style, either {@code block} or {@code line}. Defaults to {@code line}.
     */
    public String getCursorStyle() {
        return (String) (has("cursorStyle") ? get("cursorStyle") : null);
    }

    /**
     * @param cursorStyle Control the cursor style, either {@code block} or {@code line}. Defaults to {@code line}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setCursorStyle(final ECursorStyle cursorStyle) {
        put("cursorStyle", cursorStyle != null ? cursorStyle.toString() : null);
        return this;
    }

    /**
     * @param cursorStyle Control the cursor style, either {@code block} or {@code line}. Defaults to {@code line}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setCursorStyle(final String cursorStyle) {
        put("cursorStyle", cursorStyle);
        return this;
    }

    /**
     * @return Controls when {@code cursorSurroundingLines} should be enforced Defaults to {@code default}, {@code
     * cursorSurroundingLines} is not enforced when cursor position is changed by mouse.
     */
    public String getCursorSurroundingLinesStyle() {
        return (String) (has("cursorSurroundingLinesStyle") ? get("cursorSurroundingLinesStyle") : null);
    }

    /**
     * @param cursorSurroundingLinesStyle Controls when {@code cursorSurroundingLines} should be enforced Defaults to
     * {@code default}, {@code cursorSurroundingLines} is not enforced when cursor position is changed by mouse.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setCursorSurroundingLinesStyle(final ECursorSurroundingLinesStyle cursorSurroundingLinesStyle) {
        put("cursorSurroundingLinesStyle", cursorSurroundingLinesStyle != null ? cursorSurroundingLinesStyle.toString() : null);
        return this;
    }

    /**
     * @param cursorSurroundingLinesStyle Controls when {@code cursorSurroundingLines} should be enforced Defaults to
     * {@code default}, {@code cursorSurroundingLines} is not enforced when cursor position is changed by mouse.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setCursorSurroundingLinesStyle(final String cursorSurroundingLinesStyle) {
        put("cursorSurroundingLinesStyle", cursorSurroundingLinesStyle);
        return this;
    }

    /**
     * @return Enable experimental whitespace rendering. Defaults to {@code svg}.
     */
    public String getExperimentalWhitespaceRendering() {
        return (String) (has("experimentalWhitespaceRendering") ? get("experimentalWhitespaceRendering") : null);
    }

    /**
     * @param experimentalWhitespaceRendering Enable experimental whitespace rendering. Defaults to {@code svg}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setExperimentalWhitespaceRendering(final EFoldingStrategy experimentalWhitespaceRendering) {
        put("experimentalWhitespaceRendering", experimentalWhitespaceRendering != null ? experimentalWhitespaceRendering.toString() : null);
        return this;
    }

    /**
     * @param experimentalWhitespaceRendering Enable experimental whitespace rendering. Defaults to {@code svg}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setExperimentalWhitespaceRendering(final String experimentalWhitespaceRendering) {
        put("experimentalWhitespaceRendering", experimentalWhitespaceRendering);
        return this;
    }

    /**
     * @return Selects the folding strategy. &#039;auto&#039; uses the strategies contributed for the current document,
     * &#039;indentation&#039; uses the indentation based folding strategy. Defaults to &#039;auto&#039;.
     */
    public String getFoldingStrategy() {
        return (String) (has("foldingStrategy") ? get("foldingStrategy") : null);
    }

    /**
     * @param foldingStrategy Selects the folding strategy. &#039;auto&#039; uses the strategies contributed for the current
     * document, &#039;indentation&#039; uses the indentation based folding strategy. Defaults to &#039;auto&#039;.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setFoldingStrategy(final EFoldingStrategy foldingStrategy) {
        put("foldingStrategy", foldingStrategy != null ? foldingStrategy.toString() : null);
        return this;
    }

    /**
     * @param foldingStrategy Selects the folding strategy. &#039;auto&#039; uses the strategies contributed for the current
     * document, &#039;indentation&#039; uses the indentation based folding strategy. Defaults to &#039;auto&#039;.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setFoldingStrategy(final String foldingStrategy) {
        put("foldingStrategy", foldingStrategy);
        return this;
    }

    /**
     * @return The font weight
     */
    public String getFontWeight() {
        return (String) (has("fontWeight") ? get("fontWeight") : null);
    }

    /**
     * @param fontWeight The font weight
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setFontWeight(final EFontWeight fontWeight) {
        put("fontWeight", fontWeight != null ? fontWeight.toString() : null);
        return this;
    }

    /**
     * @param fontWeight The font weight
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setFontWeight(final String fontWeight) {
        put("fontWeight", fontWeight);
        return this;
    }

    /**
     * @return Control the rendering of line numbers. If it is a function, it will be invoked when rendering a line
     * number and the return value will be rendered. Otherwise, if it is a truey, line numbers will be rendered normally
     * (equivalent of using an identity function). Otherwise, line numbers will not be rendered. Defaults to {@code on}.
     */
    public String getLineNumbers() {
        return (String) (has("lineNumbers") ? get("lineNumbers") : null);
    }

    /**
     * @param lineNumbers Control the rendering of line numbers. If it is a function, it will be invoked when rendering
     * a line number and the return value will be rendered. Otherwise, if it is a truey, line numbers will be rendered
     * normally (equivalent of using an identity function). Otherwise, line numbers will not be rendered. Defaults to
     * {@code on}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setLineNumbers(final ELineNumbers lineNumbers) {
        put("lineNumbers", lineNumbers != null ? lineNumbers.toString() : null);
        return this;
    }

    /**
     * @param lineNumbers Control the rendering of line numbers. If it is a function, it will be invoked when rendering
     * a line number and the return value will be rendered. Otherwise, if it is a truey, line numbers will be rendered
     * normally (equivalent of using an identity function). Otherwise, line numbers will not be rendered. Defaults to
     * {@code on}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setLineNumbers(final String lineNumbers) {
        put("lineNumbers", lineNumbers);
        return this;
    }

    /**
     * @return Enable highlighting of matching brackets. Defaults to {@code always}.
     */
    public String getMatchBrackets() {
        return (String) (has("matchBrackets") ? get("matchBrackets") : null);
    }

    /**
     * @param matchBrackets Enable highlighting of matching brackets. Defaults to {@code always}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setMatchBrackets(final EMatchBrackets matchBrackets) {
        put("matchBrackets", matchBrackets != null ? matchBrackets.toString() : null);
        return this;
    }

    /**
     * @param matchBrackets Enable highlighting of matching brackets. Defaults to {@code always}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setMatchBrackets(final String matchBrackets) {
        put("matchBrackets", matchBrackets);
        return this;
    }

    /**
     * @return Control the mouse pointer style, either &#039;text&#039; or &#039;default&#039; or &#039;copy&#039; Defaults to {@code text}
     */
    public String getMouseStyle() {
        return (String) (has("mouseStyle") ? get("mouseStyle") : null);
    }

    /**
     * @param mouseStyle Control the mouse pointer style, either &#039;text&#039; or &#039;default&#039; or &#039;copy&#039; Defaults to {@code text}
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setMouseStyle(final EMouseStyle mouseStyle) {
        put("mouseStyle", mouseStyle != null ? mouseStyle.toString() : null);
        return this;
    }

    /**
     * @param mouseStyle Control the mouse pointer style, either &#039;text&#039; or &#039;default&#039; or &#039;copy&#039; Defaults to {@code text}
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setMouseStyle(final String mouseStyle) {
        put("mouseStyle", mouseStyle);
        return this;
    }

    /**
     * @return The modifier to be used to add multiple cursors with the mouse. Defaults to {@code alt}
     */
    public String getMultiCursorModifier() {
        return (String) (has("multiCursorModifier") ? get("multiCursorModifier") : null);
    }

    /**
     * @param multiCursorModifier The modifier to be used to add multiple cursors with the mouse. Defaults to {@code
     * alt}
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setMultiCursorModifier(final EMultiCursorModifier multiCursorModifier) {
        put("multiCursorModifier", multiCursorModifier != null ? multiCursorModifier.toString() : null);
        return this;
    }

    /**
     * @param multiCursorModifier The modifier to be used to add multiple cursors with the mouse. Defaults to {@code
     * alt}
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setMultiCursorModifier(final String multiCursorModifier) {
        put("multiCursorModifier", multiCursorModifier);
        return this;
    }

    /**
     * @return Configure the behaviour when pasting a text with the line count equal to the cursor count. Defaults to
     * {@code spread}.
     */
    public String getMultiCursorPaste() {
        return (String) (has("multiCursorPaste") ? get("multiCursorPaste") : null);
    }

    /**
     * @param multiCursorPaste Configure the behaviour when pasting a text with the line count equal to the cursor
     * count. Defaults to {@code spread}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setMultiCursorPaste(final EMultiCursorPaste multiCursorPaste) {
        put("multiCursorPaste", multiCursorPaste != null ? multiCursorPaste.toString() : null);
        return this;
    }

    /**
     * @param multiCursorPaste Configure the behaviour when pasting a text with the line count equal to the cursor
     * count. Defaults to {@code spread}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setMultiCursorPaste(final String multiCursorPaste) {
        put("multiCursorPaste", multiCursorPaste);
        return this;
    }

    /**
     * @return Controls whether to focus the inline editor in the peek widget by default. Defaults to {@code false}.
     */
    public String getPeekWidgetDefaultFocus() {
        return (String) (has("peekWidgetDefaultFocus") ? get("peekWidgetDefaultFocus") : null);
    }

    /**
     * @param peekWidgetDefaultFocus Controls whether to focus the inline editor in the peek widget by default. Defaults
     * to {@code false}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setPeekWidgetDefaultFocus(final EPeekWidgetDefaultFocus peekWidgetDefaultFocus) {
        put("peekWidgetDefaultFocus", peekWidgetDefaultFocus != null ? peekWidgetDefaultFocus.toString() : null);
        return this;
    }

    /**
     * @param peekWidgetDefaultFocus Controls whether to focus the inline editor in the peek widget by default. Defaults
     * to {@code false}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setPeekWidgetDefaultFocus(final String peekWidgetDefaultFocus) {
        put("peekWidgetDefaultFocus", peekWidgetDefaultFocus);
        return this;
    }

    /**
     * @return Render last line number when the file ends with a newline. Defaults to {@code on} for Windows and macOS
     * and {@code dimmed} for Linux.
     */
    public String getRenderFinalNewline() {
        return (String) (has("renderFinalNewline") ? get("renderFinalNewline") : null);
    }

    /**
     * @param renderFinalNewline Render last line number when the file ends with a newline. Defaults to {@code on} for
     * Windows and macOS and {@code dimmed} for Linux.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setRenderFinalNewline(final ERenderFinalNewline renderFinalNewline) {
        put("renderFinalNewline", renderFinalNewline != null ? renderFinalNewline.toString() : null);
        return this;
    }

    /**
     * @param renderFinalNewline Render last line number when the file ends with a newline. Defaults to {@code on} for
     * Windows and macOS and {@code dimmed} for Linux.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setRenderFinalNewline(final String renderFinalNewline) {
        put("renderFinalNewline", renderFinalNewline);
        return this;
    }

    /**
     * @return Enable rendering of current line highlight. Defaults to {@code all}.
     */
    public String getRenderLineHighlight() {
        return (String) (has("renderLineHighlight") ? get("renderLineHighlight") : null);
    }

    /**
     * @param renderLineHighlight Enable rendering of current line highlight. Defaults to {@code all}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setRenderLineHighlight(final ERenderLineHighlight renderLineHighlight) {
        put("renderLineHighlight", renderLineHighlight != null ? renderLineHighlight.toString() : null);
        return this;
    }

    /**
     * @param renderLineHighlight Enable rendering of current line highlight. Defaults to {@code all}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setRenderLineHighlight(final String renderLineHighlight) {
        put("renderLineHighlight", renderLineHighlight);
        return this;
    }

    /**
     * @return Should the editor render validation decorations. Defaults to {@code editable}.
     */
    public String getRenderValidationDecorations() {
        return (String) (has("renderValidationDecorations") ? get("renderValidationDecorations") : null);
    }

    /**
     * @param renderValidationDecorations Should the editor render validation decorations. Defaults to {@code editable}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setRenderValidationDecorations(final ERenderValidationDecorations renderValidationDecorations) {
        put("renderValidationDecorations", renderValidationDecorations != null ? renderValidationDecorations.toString() : null);
        return this;
    }

    /**
     * @param renderValidationDecorations Should the editor render validation decorations. Defaults to {@code editable}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setRenderValidationDecorations(final String renderValidationDecorations) {
        put("renderValidationDecorations", renderValidationDecorations);
        return this;
    }

    /**
     * @return Enable rendering of whitespace. Defaults to {@code none}.
     */
    public String getRenderWhitespace() {
        return (String) (has("renderWhitespace") ? get("renderWhitespace") : null);
    }

    /**
     * @param renderWhitespace Enable rendering of whitespace. Defaults to {@code none}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setRenderWhitespace(final ERenderWhitespace renderWhitespace) {
        put("renderWhitespace", renderWhitespace != null ? renderWhitespace.toString() : null);
        return this;
    }

    /**
     * @param renderWhitespace Enable rendering of whitespace. Defaults to {@code none}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setRenderWhitespace(final String renderWhitespace) {
        put("renderWhitespace", renderWhitespace);
        return this;
    }

    /**
     * @return Controls whether the fold actions in the gutter stay always visible or hide unless the mouse is over the
     * gutter. Defaults to {@code mouseover}.
     */
    public String getShowFoldingControls() {
        return (String) (has("showFoldingControls") ? get("showFoldingControls") : null);
    }

    /**
     * @param showFoldingControls Controls whether the fold actions in the gutter stay always visible or hide unless the
     * mouse is over the gutter. Defaults to {@code mouseover}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setShowFoldingControls(final EShowFoldingControls showFoldingControls) {
        put("showFoldingControls", showFoldingControls != null ? showFoldingControls.toString() : null);
        return this;
    }

    /**
     * @param showFoldingControls Controls whether the fold actions in the gutter stay always visible or hide unless the
     * mouse is over the gutter. Defaults to {@code mouseover}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setShowFoldingControls(final String showFoldingControls) {
        put("showFoldingControls", showFoldingControls);
        return this;
    }

    /**
     * @return Enable snippet suggestions. Defaults to &#039;inline&#039;.
     */
    public String getSnippetSuggestions() {
        return (String) (has("snippetSuggestions") ? get("snippetSuggestions") : null);
    }

    /**
     * @param snippetSuggestions Enable snippet suggestions. Defaults to &#039;inline&#039;.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setSnippetSuggestions(final ESnippetSuggestions snippetSuggestions) {
        put("snippetSuggestions", snippetSuggestions != null ? snippetSuggestions.toString() : null);
        return this;
    }

    /**
     * @param snippetSuggestions Enable snippet suggestions. Defaults to &#039;inline&#039;.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setSnippetSuggestions(final String snippetSuggestions) {
        put("snippetSuggestions", snippetSuggestions);
        return this;
    }

    /**
     * @return Keep peek editors open even when double clicking their content or when hitting Escape. Defaults to {@code
     * false}.
     */
    public String getSuggestSelection() {
        return (String) (has("suggestSelection") ? get("suggestSelection") : null);
    }

    /**
     * @param suggestSelection Keep peek editors open even when double clicking their content or when hitting Escape.
     * Defaults to {@code false}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setSuggestSelection(final ESuggestSelection suggestSelection) {
        put("suggestSelection", suggestSelection != null ? suggestSelection.toString() : null);
        return this;
    }

    /**
     * @param suggestSelection Keep peek editors open even when double clicking their content or when hitting Escape.
     * Defaults to {@code false}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setSuggestSelection(final String suggestSelection) {
        put("suggestSelection", suggestSelection);
        return this;
    }

    /**
     * @return Enable tab completion.
     */
    public String getTabCompletion() {
        return (String) (has("tabCompletion") ? get("tabCompletion") : null);
    }

    /**
     * @param tabCompletion Enable tab completion.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setTabCompletion(final ETabCompletion tabCompletion) {
        put("tabCompletion", tabCompletion != null ? tabCompletion.toString() : null);
        return this;
    }

    /**
     * @param tabCompletion Enable tab completion.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setTabCompletion(final String tabCompletion) {
        put("tabCompletion", tabCompletion);
        return this;
    }

    /**
     * @return Remove unusual line terminators like LINE SEPARATOR (LS), PARAGRAPH SEPARATOR (PS). Defaults to {@code
     * prompt}.
     */
    public String getUnusualLineTerminators() {
        return (String) (has("unusualLineTerminators") ? get("unusualLineTerminators") : null);
    }

    /**
     * @param unusualLineTerminators Remove unusual line terminators like LINE SEPARATOR (LS), PARAGRAPH SEPARATOR (PS).
     * Defaults to {@code prompt}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setUnusualLineTerminators(final EUnusualLineTerminators unusualLineTerminators) {
        put("unusualLineTerminators", unusualLineTerminators != null ? unusualLineTerminators.toString() : null);
        return this;
    }

    /**
     * @param unusualLineTerminators Remove unusual line terminators like LINE SEPARATOR (LS), PARAGRAPH SEPARATOR (PS).
     * Defaults to {@code prompt}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setUnusualLineTerminators(final String unusualLineTerminators) {
        put("unusualLineTerminators", unusualLineTerminators);
        return this;
    }

    /**
     * @return Sets whether line breaks appear wherever the text would otherwise overflow its content box. When
     * wordBreak = {@code normal}, Use the default line break rule. When wordBreak = {@code keepAll}, word breaks should
     * not be used for Chinese/Japanese/Korean (CJK) text. Non-CJK text behavior is the same as for normal.
     */
    public String getWordBreak() {
        return (String) (has("wordBreak") ? get("wordBreak") : null);
    }

    /**
     * @param wordBreak Sets whether line breaks appear wherever the text would otherwise overflow its content box. When
     * wordBreak = {@code normal}, Use the default line break rule. When wordBreak = {@code keepAll}, word breaks should
     * not be used for Chinese/Japanese/Korean (CJK) text. Non-CJK text behavior is the same as for normal.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setWordBreak(final EWordBreak wordBreak) {
        put("wordBreak", wordBreak != null ? wordBreak.toString() : null);
        return this;
    }

    /**
     * @param wordBreak Sets whether line breaks appear wherever the text would otherwise overflow its content box. When
     * wordBreak = {@code normal}, Use the default line break rule. When wordBreak = {@code keepAll}, word breaks should
     * not be used for Chinese/Japanese/Korean (CJK) text. Non-CJK text behavior is the same as for normal.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setWordBreak(final String wordBreak) {
        put("wordBreak", wordBreak);
        return this;
    }

    /**
     * @return Control the wrapping of the editor. When {@code wordWrap} = {@code off}, the lines will never wrap. When
     * {@code wordWrap} = {@code on}, the lines will wrap at the viewport width. When {@code wordWrap} = {@code
     * wordWrapColumn}, the lines will wrap at {@code wordWrapColumn}. When {@code wordWrap} = {@code bounded}, the
     * lines will wrap at {@code min(viewport width, wordWrapColumn)}. Defaults to {@code off}.
     */
    public String getWordWrap() {
        return (String) (has("wordWrap") ? get("wordWrap") : null);
    }

    /**
     * @param wordWrap Control the wrapping of the editor. When {@code wordWrap} = {@code off}, the lines will never
     * wrap. When {@code wordWrap} = {@code on}, the lines will wrap at the viewport width. When {@code wordWrap} =
     * {@code wordWrapColumn}, the lines will wrap at {@code wordWrapColumn}. When {@code wordWrap} = {@code bounded},
     * the lines will wrap at {@code min(viewport width, wordWrapColumn)}. Defaults to {@code off}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setWordWrap(final EWordWrap wordWrap) {
        put("wordWrap", wordWrap != null ? wordWrap.toString() : null);
        return this;
    }

    /**
     * @param wordWrap Control the wrapping of the editor. When {@code wordWrap} = {@code off}, the lines will never
     * wrap. When {@code wordWrap} = {@code on}, the lines will wrap at the viewport width. When {@code wordWrap} =
     * {@code wordWrapColumn}, the lines will wrap at {@code wordWrapColumn}. When {@code wordWrap} = {@code bounded},
     * the lines will wrap at {@code min(viewport width, wordWrapColumn)}. Defaults to {@code off}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setWordWrap(final String wordWrap) {
        put("wordWrap", wordWrap);
        return this;
    }

    /**
     * @return Override the {@code wordWrap} setting.
     */
    public String getWordWrapOverride1() {
        return (String) (has("wordWrapOverride1") ? get("wordWrapOverride1") : null);
    }

    /**
     * @param wordWrapOverride1 Override the {@code wordWrap} setting.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setWordWrapOverride1(final EWordWrapOverride1 wordWrapOverride1) {
        put("wordWrapOverride1", wordWrapOverride1 != null ? wordWrapOverride1.toString() : null);
        return this;
    }

    /**
     * @param wordWrapOverride1 Override the {@code wordWrap} setting.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setWordWrapOverride1(final String wordWrapOverride1) {
        put("wordWrapOverride1", wordWrapOverride1);
        return this;
    }

    /**
     * @return Override the {@code wordWrapOverride1} setting.
     */
    public String getWordWrapOverride2() {
        return (String) (has("wordWrapOverride2") ? get("wordWrapOverride2") : null);
    }

    /**
     * @param wordWrapOverride2 Override the {@code wordWrapOverride1} setting.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setWordWrapOverride2(final EWordWrapOverride2 wordWrapOverride2) {
        put("wordWrapOverride2", wordWrapOverride2 != null ? wordWrapOverride2.toString() : null);
        return this;
    }

    /**
     * @param wordWrapOverride2 Override the {@code wordWrapOverride1} setting.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setWordWrapOverride2(final String wordWrapOverride2) {
        put("wordWrapOverride2", wordWrapOverride2);
        return this;
    }

    /**
     * @return Control indentation of wrapped lines. Can be: {@code none}, {@code same}, {@code indent} or {@code
     * deepIndent}. Defaults to {@code same} in vscode and to {@code none} in monaco-editor.
     */
    public String getWrappingIndent() {
        return (String) (has("wrappingIndent") ? get("wrappingIndent") : null);
    }

    /**
     * @param wrappingIndent Control indentation of wrapped lines. Can be: {@code none}, {@code same}, {@code indent} or
     * {@code deepIndent}. Defaults to {@code same} in vscode and to {@code none} in monaco-editor.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setWrappingIndent(final EWrappingIndent wrappingIndent) {
        put("wrappingIndent", wrappingIndent != null ? wrappingIndent.toString() : null);
        return this;
    }

    /**
     * @param wrappingIndent Control indentation of wrapped lines. Can be: {@code none}, {@code same}, {@code indent} or
     * {@code deepIndent}. Defaults to {@code same} in vscode and to {@code none} in monaco-editor.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setWrappingIndent(final String wrappingIndent) {
        put("wrappingIndent", wrappingIndent);
        return this;
    }

    /**
     * @return Controls the wrapping strategy to use. Defaults to {@code simple}.
     */
    public String getWrappingStrategy() {
        return (String) (has("wrappingStrategy") ? get("wrappingStrategy") : null);
    }

    /**
     * @param wrappingStrategy Controls the wrapping strategy to use. Defaults to {@code simple}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setWrappingStrategy(final EWrappingStrategy wrappingStrategy) {
        put("wrappingStrategy", wrappingStrategy != null ? wrappingStrategy.toString() : null);
        return this;
    }

    /**
     * @param wrappingStrategy Controls the wrapping strategy to use. Defaults to {@code simple}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setWrappingStrategy(final String wrappingStrategy) {
        put("wrappingStrategy", wrappingStrategy);
        return this;
    }

    /**
     * @return Render vertical lines at the specified columns. Defaults to empty array.
     */
    public JSONArray getRulers() {
        return (JSONArray) (has("rulers") ? get("rulers") : null);
    }

    /**
     * @param rulers Render vertical lines at the specified columns. Defaults to empty array.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setRulers(final JSONArray rulers) {
        put("rulers", rulers);
        return this;
    }

    /**
     * @return Render vertical lines at the specified columns. Defaults to empty array.
     */
    public EditorOptions addRuler(final EditorRulerOption ... items) {
        JSONArray x = getRulers();
        if (x == null) {
            x = new JSONArray();
            setRulers(x);
        }
        for (EditorRulerOption item : items) x.put(item);
        return this;
    }

    /**
     * @param rulers Render vertical lines at the specified columns. Defaults to empty array.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setRulers(final java.util.List<EditorRulerOption> rulers) {
        return setRulers(new JSONArray(rulers));
    }

    /**
     * @return Accept suggestions on provider defined characters. Defaults to {@code true}.
     */
    public Boolean isAcceptSuggestionOnCommitCharacter() {
        return (Boolean) (has("acceptSuggestionOnCommitCharacter") ? get("acceptSuggestionOnCommitCharacter") : null);
    }

    /**
     * @param acceptSuggestionOnCommitCharacter Accept suggestions on provider defined characters. Defaults to {@code
     * true}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setAcceptSuggestionOnCommitCharacter(final Boolean acceptSuggestionOnCommitCharacter) {
        put("acceptSuggestionOnCommitCharacter", acceptSuggestionOnCommitCharacter);
        return this;
    }

    /**
     * @return If enabled, will automatically change to high contrast theme if the OS is using a high contrast theme.
     * Defaults to {@code true}.
     */
    public Boolean isAutoDetectHighContrast() {
        return (Boolean) (has("autoDetectHighContrast") ? get("autoDetectHighContrast") : null);
    }

    /**
     * @param autoDetectHighContrast If enabled, will automatically change to high contrast theme if the OS is using a
     * high contrast theme. Defaults to {@code true}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setAutoDetectHighContrast(final Boolean autoDetectHighContrast) {
        put("autoDetectHighContrast", autoDetectHighContrast);
        return this;
    }

    /**
     * @return Enable that the editor will install an interval to check if its container dom node size has changed.
     * Enabling this might have a severe performance impact. Defaults to {@code false}.
     */
    public Boolean isAutomaticLayout() {
        return (Boolean) (has("automaticLayout") ? get("automaticLayout") : null);
    }

    /**
     * @param automaticLayout Enable that the editor will install an interval to check if its container dom node size
     * has changed. Enabling this might have a severe performance impact. Defaults to {@code false}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setAutomaticLayout(final Boolean automaticLayout) {
        put("automaticLayout", automaticLayout);
        return this;
    }

    /**
     * @return Show code lens Defaults to {@code true}.
     */
    public Boolean isCodeLens() {
        return (Boolean) (has("codeLens") ? get("codeLens") : null);
    }

    /**
     * @param codeLens Show code lens Defaults to {@code true}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setCodeLens(final Boolean codeLens) {
        put("codeLens", codeLens);
        return this;
    }

    /**
     * @return Enable inline color decorators and color picker rendering.
     */
    public Boolean isColorDecorators() {
        return (Boolean) (has("colorDecorators") ? get("colorDecorators") : null);
    }

    /**
     * @param colorDecorators Enable inline color decorators and color picker rendering.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setColorDecorators(final Boolean colorDecorators) {
        put("colorDecorators", colorDecorators);
        return this;
    }

    /**
     * @return Controls the max number of color decorators that can be rendered in an editor at once.
     */
    public Boolean isColorDecoratorsLimit() {
        return (Boolean) (has("colorDecoratorsLimit") ? get("colorDecoratorsLimit") : null);
    }

    /**
     * @param colorDecoratorsLimit Controls the max number of color decorators that can be rendered in an editor at
     * once.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setColorDecoratorsLimit(final Boolean colorDecoratorsLimit) {
        put("colorDecoratorsLimit", colorDecoratorsLimit);
        return this;
    }

    /**
     * @return Enable that the selection with the mouse and keys is doing column selection. Defaults to {@code false}.
     */
    public Boolean isColumnSelection() {
        return (Boolean) (has("columnSelection") ? get("columnSelection") : null);
    }

    /**
     * @param columnSelection Enable that the selection with the mouse and keys is doing column selection. Defaults to
     * {@code false}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setColumnSelection(final Boolean columnSelection) {
        put("columnSelection", columnSelection);
        return this;
    }

    /**
     * @return Enable custom contextmenu. Defaults to {@code true}.
     */
    public Boolean isContextmenu() {
        return (Boolean) (has("contextmenu") ? get("contextmenu") : null);
    }

    /**
     * @param contextmenu Enable custom contextmenu. Defaults to {@code true}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setContextmenu(final Boolean contextmenu) {
        put("contextmenu", contextmenu);
        return this;
    }

    /**
     * @return Syntax highlighting is copied.
     */
    public Boolean isCopyWithSyntaxHighlighting() {
        return (Boolean) (has("copyWithSyntaxHighlighting") ? get("copyWithSyntaxHighlighting") : null);
    }

    /**
     * @param copyWithSyntaxHighlighting Syntax highlighting is copied.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setCopyWithSyntaxHighlighting(final Boolean copyWithSyntaxHighlighting) {
        put("copyWithSyntaxHighlighting", copyWithSyntaxHighlighting);
        return this;
    }

    /**
     * @return Controls whether the definition link opens element in the peek widget. Defaults to {@code false}.
     */
    public Boolean isDefinitionLinkOpensInPeek() {
        return (Boolean) (has("definitionLinkOpensInPeek") ? get("definitionLinkOpensInPeek") : null);
    }

    /**
     * @param definitionLinkOpensInPeek Controls whether the definition link opens element in the peek widget. Defaults
     * to {@code false}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setDefinitionLinkOpensInPeek(final Boolean definitionLinkOpensInPeek) {
        put("definitionLinkOpensInPeek", definitionLinkOpensInPeek);
        return this;
    }

    /**
     * @return Disable the use of transform: translate3d(0px, 0px, 0px) for the editor margin and lines layers. The
     * usage of transform: translate3d(0px, 0px, 0px) acts as a hint for browsers to create an extra layer. Defaults to
     * {@code false}.
     */
    public Boolean isDisableLayerHinting() {
        return (Boolean) (has("disableLayerHinting") ? get("disableLayerHinting") : null);
    }

    /**
     * @param disableLayerHinting Disable the use of transform: translate3d(0px, 0px, 0px) for the editor margin and
     * lines layers. The usage of transform: translate3d(0px, 0px, 0px) acts as a hint for browsers to create an extra
     * layer. Defaults to {@code false}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setDisableLayerHinting(final Boolean disableLayerHinting) {
        put("disableLayerHinting", disableLayerHinting);
        return this;
    }

    /**
     * @return Disable the optimizations for monospace fonts. Defaults to {@code false}.
     */
    public Boolean isDisableMonospaceOptimizations() {
        return (Boolean) (has("disableMonospaceOptimizations") ? get("disableMonospaceOptimizations") : null);
    }

    /**
     * @param disableMonospaceOptimizations Disable the optimizations for monospace fonts. Defaults to {@code false}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setDisableMonospaceOptimizations(final Boolean disableMonospaceOptimizations) {
        put("disableMonospaceOptimizations", disableMonospaceOptimizations);
        return this;
    }

    /**
     * @return Controls if the editor should allow to move selections via drag and drop. Defaults to {@code false}.
     */
    public Boolean isDragAndDrop() {
        return (Boolean) (has("dragAndDrop") ? get("dragAndDrop") : null);
    }

    /**
     * @param dragAndDrop Controls if the editor should allow to move selections via drag and drop. Defaults to {@code
     * false}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setDragAndDrop(final Boolean dragAndDrop) {
        put("dragAndDrop", dragAndDrop);
        return this;
    }

    /**
     * @return Copying without a selection copies the current line
     */
    public Boolean isEmptySelectionClipboard() {
        return (Boolean) (has("emptySelectionClipboard") ? get("emptySelectionClipboard") : null);
    }

    /**
     * @param emptySelectionClipboard Copying without a selection copies the current line
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setEmptySelectionClipboard(final Boolean emptySelectionClipboard) {
        put("emptySelectionClipboard", emptySelectionClipboard);
        return this;
    }

    /**
     * @return Display overflow widgets as {@code fixed}. Defaults to {@code false}
     */
    public Boolean isFixedOverflowWidgets() {
        return (Boolean) (has("fixedOverflowWidgets") ? get("fixedOverflowWidgets") : null);
    }

    /**
     * @param fixedOverflowWidgets Display overflow widgets as {@code fixed}. Defaults to {@code false}
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setFixedOverflowWidgets(final Boolean fixedOverflowWidgets) {
        put("fixedOverflowWidgets", fixedOverflowWidgets);
        return this;
    }

    /**
     * @return Enable code folding. Defaults to {@code true}.
     */
    public Boolean isFolding() {
        return (Boolean) (has("folding") ? get("folding") : null);
    }

    /**
     * @param folding Enable code folding. Defaults to {@code true}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setFolding(final Boolean folding) {
        put("folding", folding);
        return this;
    }

    /**
     * @return Enable highlight for folded regions. Defaults to {@code true}.
     */
    public Boolean isFoldingHighlight() {
        return (Boolean) (has("foldingHighlight") ? get("foldingHighlight") : null);
    }

    /**
     * @param foldingHighlight Enable highlight for folded regions. Defaults to {@code true}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setFoldingHighlight(final Boolean foldingHighlight) {
        put("foldingHighlight", foldingHighlight);
        return this;
    }

    /**
     * @return Auto fold imports folding regions. Defaults to {@code true}.
     */
    public Boolean isFoldingImportsByDefault() {
        return (Boolean) (has("foldingImportsByDefault") ? get("foldingImportsByDefault") : null);
    }

    /**
     * @param foldingImportsByDefault Auto fold imports folding regions. Defaults to {@code true}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setFoldingImportsByDefault(final Boolean foldingImportsByDefault) {
        put("foldingImportsByDefault", foldingImportsByDefault);
        return this;
    }

    public Boolean isFontLigatures() {
        final Object tmp = (has("fontLigatures") ? get("fontLigatures") : null);
        return (Boolean) (tmp instanceof Boolean ? tmp : null);
    }

    public String getFontLigatures() {
        final Object tmp = (has("fontLigatures") ? get("fontLigatures") : null);
        return (String) (tmp instanceof String ? tmp : null);
    }

    public EditorOptions setFontLigatures(final Boolean fontLigatures) {
        put("fontLigatures", fontLigatures);
        return this;
    }

    public EditorOptions setFontLigatures(final String fontLigatures) {
        put("fontLigatures", fontLigatures);
        return this;
    }

    public Boolean isFontVariations() {
        final Object tmp = (has("fontVariations") ? get("fontVariations") : null);
        return (Boolean) (tmp instanceof Boolean ? tmp : null);
    }

    public String getFontVariations() {
        final Object tmp = (has("fontVariations") ? get("fontVariations") : null);
        return (String) (tmp instanceof String ? tmp : null);
    }

    public EditorOptions setFontVariations(final Boolean fontVariations) {
        put("fontVariations", fontVariations);
        return this;
    }

    public EditorOptions setFontVariations(final String fontVariations) {
        put("fontVariations", fontVariations);
        return this;
    }

    /**
     * @return Enable format on paste. Defaults to {@code false}
     */
    public Boolean isFormatOnPaste() {
        return (Boolean) (has("formatOnPaste") ? get("formatOnPaste") : null);
    }

    /**
     * @param formatOnPaste Enable format on paste. Defaults to {@code false}
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setFormatOnPaste(final Boolean formatOnPaste) {
        put("formatOnPaste", formatOnPaste);
        return this;
    }

    /**
     * @return Enable format on type. Defaults to {@code false}
     */
    public Boolean isFormatOnType() {
        return (Boolean) (has("formatOnType") ? get("formatOnType") : null);
    }

    /**
     * @param formatOnType Enable format on type. Defaults to {@code false}
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setFormatOnType(final Boolean formatOnType) {
        put("formatOnType", formatOnType);
        return this;
    }

    /**
     * @return Enable the rendering of the glyph margin. Defaults to {@code true}. in vscode and to {@code false} in
     * monaco-editor
     */
    public Boolean isGlyphMargin() {
        return (Boolean) (has("glyphMargin") ? get("glyphMargin") : null);
    }

    /**
     * @param glyphMargin Enable the rendering of the glyph margin. Defaults to {@code true}. in vscode and to {@code
     * false} in monaco-editor
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setGlyphMargin(final Boolean glyphMargin) {
        put("glyphMargin", glyphMargin);
        return this;
    }

    /**
     * @return Should the cursor be hidden in the overview ruler. Defaults to {@code false}
     */
    public Boolean isHideCursorInOverviewRuler() {
        return (Boolean) (has("hideCursorInOverviewRuler") ? get("hideCursorInOverviewRuler") : null);
    }

    /**
     * @param hideCursorInOverviewRuler Should the cursor be hidden in the overview ruler. Defaults to {@code false}
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setHideCursorInOverviewRuler(final Boolean hideCursorInOverviewRuler) {
        put("hideCursorInOverviewRuler", hideCursorInOverviewRuler);
        return this;
    }

    /**
     * @return Special handling for large files to disable certain memory intensive features. Defaults to {@code true}.
     */
    public Boolean isLargeFileOptimizations() {
        return (Boolean) (has("largeFileOptimizations") ? get("largeFileOptimizations") : null);
    }

    /**
     * @param largeFileOptimizations Special handling for large files to disable certain memory intensive features.
     * Defaults to {@code true}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setLargeFileOptimizations(final Boolean largeFileOptimizations) {
        put("largeFileOptimizations", largeFileOptimizations);
        return this;
    }

    /**
     * @return Enables linked editing. Defaults to {@code false}.
     */
    public Boolean isLinkedEditing() {
        return (Boolean) (has("linkedEditing") ? get("linkedEditing") : null);
    }

    /**
     * @param linkedEditing Enables linked editing. Defaults to {@code false}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setLinkedEditing(final Boolean linkedEditing) {
        put("linkedEditing", linkedEditing);
        return this;
    }

    /**
     * @return Enable detecting links and making them clickable. Defaults to {@code true}.
     */
    public Boolean isLinks() {
        return (Boolean) (has("links") ? get("links") : null);
    }

    /**
     * @param links Enable detecting links and making them clickable. Defaults to {@code true}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setLinks(final Boolean links) {
        put("links", links);
        return this;
    }

    /**
     * @return Controls whether suggestions allow matches in the middle of the word instead of only at the beginning
     */
    public Boolean isMatchOnWordStartOnly() {
        return (Boolean) (has("matchOnWordStartOnly") ? get("matchOnWordStartOnly") : null);
    }

    /**
     * @param matchOnWordStartOnly Controls whether suggestions allow matches in the middle of the word instead of only
     * at the beginning
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setMatchOnWordStartOnly(final Boolean matchOnWordStartOnly) {
        put("matchOnWordStartOnly", matchOnWordStartOnly);
        return this;
    }

    /**
     * @return Zoom the font in the editor when using the mouse wheel in combination with holding Ctrl. Defaults to
     * {@code false}
     */
    public Boolean isMouseWheelZoom() {
        return (Boolean) (has("mouseWheelZoom") ? get("mouseWheelZoom") : null);
    }

    /**
     * @param mouseWheelZoom Zoom the font in the editor when using the mouse wheel in combination with holding Ctrl.
     * Defaults to {@code false}
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setMouseWheelZoom(final Boolean mouseWheelZoom) {
        put("mouseWheelZoom", mouseWheelZoom);
        return this;
    }

    /**
     * @return Merge overlapping selections. Defaults to {@code true}.
     */
    public Boolean isMultiCursorMergeOverlapping() {
        return (Boolean) (has("multiCursorMergeOverlapping") ? get("multiCursorMergeOverlapping") : null);
    }

    /**
     * @param multiCursorMergeOverlapping Merge overlapping selections. Defaults to {@code true}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setMultiCursorMergeOverlapping(final Boolean multiCursorMergeOverlapping) {
        put("multiCursorMergeOverlapping", multiCursorMergeOverlapping);
        return this;
    }

    /**
     * @return Enable semantic occurrences highlight. Defaults to {@code true}.
     */
    public Boolean isOccurrencesHighlight() {
        return (Boolean) (has("occurrencesHighlight") ? get("occurrencesHighlight") : null);
    }

    /**
     * @param occurrencesHighlight Enable semantic occurrences highlight. Defaults to {@code true}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setOccurrencesHighlight(final Boolean occurrencesHighlight) {
        put("occurrencesHighlight", occurrencesHighlight);
        return this;
    }

    /**
     * @return Controls if a border should be drawn around the overview ruler. Defaults to {@code true}.
     */
    public Boolean isOverviewRulerBorder() {
        return (Boolean) (has("overviewRulerBorder") ? get("overviewRulerBorder") : null);
    }

    /**
     * @param overviewRulerBorder Controls if a border should be drawn around the overview ruler. Defaults to {@code
     * true}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setOverviewRulerBorder(final Boolean overviewRulerBorder) {
        put("overviewRulerBorder", overviewRulerBorder);
        return this;
    }

    /**
     * @return Should the editor be read only. Defaults to {@code false}
     */
    public Boolean isReadOnly() {
        return (Boolean) (has("readOnly") ? get("readOnly") : null);
    }

    /**
     * @param readOnly Should the editor be read only. Defaults to {@code false}
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setReadOnly(final Boolean readOnly) {
        put("readOnly", readOnly);
        return this;
    }

    /**
     * @deprecated 
     * @return Deprecated, use {@link linkedEditing} instead.
     */
    @Deprecated
    public Boolean isRenameOnType() {
        return (Boolean) (has("renameOnType") ? get("renameOnType") : null);
    }

    /**
     * @deprecated 
     * @param renameOnType Deprecated, use {@link linkedEditing} instead.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    @Deprecated
    public EditorOptions setRenameOnType(final Boolean renameOnType) {
        put("renameOnType", renameOnType);
        return this;
    }

    /**
     * @return Enable rendering of control characters. Defaults to {@code true}.
     */
    public Boolean isRenderControlCharacters() {
        return (Boolean) (has("renderControlCharacters") ? get("renderControlCharacters") : null);
    }

    /**
     * @param renderControlCharacters Enable rendering of control characters. Defaults to {@code true}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setRenderControlCharacters(final Boolean renderControlCharacters) {
        put("renderControlCharacters", renderControlCharacters);
        return this;
    }

    /**
     * @return Control if the current line highlight should be rendered only the editor is focused. Defaults to {@code
     * false}.
     */
    public Boolean isRenderLineHighlightOnlyWhenFocus() {
        return (Boolean) (has("renderLineHighlightOnlyWhenFocus") ? get("renderLineHighlightOnlyWhenFocus") : null);
    }

    /**
     * @param renderLineHighlightOnlyWhenFocus Control if the current line highlight should be rendered only the editor
     * is focused. Defaults to {@code false}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setRenderLineHighlightOnlyWhenFocus(final Boolean renderLineHighlightOnlyWhenFocus) {
        put("renderLineHighlightOnlyWhenFocus", renderLineHighlightOnlyWhenFocus);
        return this;
    }

    /**
     * @return Render the editor selection with rounded borders. Defaults to {@code true}.
     */
    public Boolean isRoundedSelection() {
        return (Boolean) (has("roundedSelection") ? get("roundedSelection") : null);
    }

    /**
     * @param roundedSelection Render the editor selection with rounded borders. Defaults to {@code true}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setRoundedSelection(final Boolean roundedSelection) {
        put("roundedSelection", roundedSelection);
        return this;
    }

    /**
     * @return Enable that scrolling can go one screen size after the last line. Defaults to {@code true}.
     */
    public Boolean isScrollBeyondLastLine() {
        return (Boolean) (has("scrollBeyondLastLine") ? get("scrollBeyondLastLine") : null);
    }

    /**
     * @param scrollBeyondLastLine Enable that scrolling can go one screen size after the last line. Defaults to {@code
     * true}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setScrollBeyondLastLine(final Boolean scrollBeyondLastLine) {
        put("scrollBeyondLastLine", scrollBeyondLastLine);
        return this;
    }

    /**
     * @return Enable that the editor scrolls only the predominant axis. Prevents horizontal drift when scrolling
     * vertically on a trackpad. Defaults to {@code true}.}
     */
    public Boolean isScrollPredominantAxis() {
        return (Boolean) (has("scrollPredominantAxis") ? get("scrollPredominantAxis") : null);
    }

    /**
     * @param scrollPredominantAxis Enable that the editor scrolls only the predominant axis. Prevents horizontal drift
     * when scrolling vertically on a trackpad. Defaults to {@code true}.}
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setScrollPredominantAxis(final Boolean scrollPredominantAxis) {
        put("scrollPredominantAxis", scrollPredominantAxis);
        return this;
    }

    /**
     * @return Should the corresponding line be selected when clicking on the line number? Defaults to {@code true}.
     */
    public Boolean isSelectOnLineNumbers() {
        return (Boolean) (has("selectOnLineNumbers") ? get("selectOnLineNumbers") : null);
    }

    /**
     * @param selectOnLineNumbers Should the corresponding line be selected when clicking on the line number? Defaults
     * to {@code true}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setSelectOnLineNumbers(final Boolean selectOnLineNumbers) {
        put("selectOnLineNumbers", selectOnLineNumbers);
        return this;
    }

    /**
     * @return Enable Linux primary clipboard. Defaults to {@code true}.
     */
    public Boolean isSelectionClipboard() {
        return (Boolean) (has("selectionClipboard") ? get("selectionClipboard") : null);
    }

    /**
     * @param selectionClipboard Enable Linux primary clipboard. Defaults to {@code true}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setSelectionClipboard(final Boolean selectionClipboard) {
        put("selectionClipboard", selectionClipboard);
        return this;
    }

    /**
     * @return Enable selection highlight. Defaults to {@code true}.
     */
    public Boolean isSelectionHighlight() {
        return (Boolean) (has("selectionHighlight") ? get("selectionHighlight") : null);
    }

    /**
     * @param selectionHighlight Enable selection highlight. Defaults to {@code true}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setSelectionHighlight(final Boolean selectionHighlight) {
        put("selectionHighlight", selectionHighlight);
        return this;
    }

    /**
     * @return Controls strikethrough deprecated variables.
     */
    public Boolean isShowDeprecated() {
        return (Boolean) (has("showDeprecated") ? get("showDeprecated") : null);
    }

    /**
     * @param showDeprecated Controls strikethrough deprecated variables.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setShowDeprecated(final Boolean showDeprecated) {
        put("showDeprecated", showDeprecated);
        return this;
    }

    /**
     * @return Controls fading out of unused variables
     */
    public Boolean isShowUnused() {
        return (Boolean) (has("showUnused") ? get("showUnused") : null);
    }

    /**
     * @param showUnused Controls fading out of unused variables
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setShowUnused(final Boolean showUnused) {
        put("showUnused", showUnused);
        return this;
    }

    /**
     * @return Enable that the editor animates scrolling to a position. Defaults to {@code false}
     */
    public Boolean isSmoothScrolling() {
        return (Boolean) (has("smoothScrolling") ? get("smoothScrolling") : null);
    }

    /**
     * @param smoothScrolling Enable that the editor animates scrolling to a position. Defaults to {@code false}
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setSmoothScrolling(final Boolean smoothScrolling) {
        put("smoothScrolling", smoothScrolling);
        return this;
    }

    /**
     * @return Keep peek editors open even when double clicking their content or when hitting Escape. Defaults to {@code
     * false}
     */
    public Boolean isStablePeek() {
        return (Boolean) (has("stablePeek") ? get("stablePeek") : null);
    }

    /**
     * @param stablePeek Keep peek editors open even when double clicking their content or when hitting Escape. Defaults
     * to {@code false}
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setStablePeek(final Boolean stablePeek) {
        put("stablePeek", stablePeek);
        return this;
    }

    /**
     * @return Enable the suggestion box to pop-up on trigger characters. Defaults to {@code true}.
     */
    public Boolean isSuggestOnTriggerCharacters() {
        return (Boolean) (has("suggestOnTriggerCharacters") ? get("suggestOnTriggerCharacters") : null);
    }

    /**
     * @param suggestOnTriggerCharacters Enable the suggestion box to pop-up on trigger characters. Defaults to {@code
     * true}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setSuggestOnTriggerCharacters(final Boolean suggestOnTriggerCharacters) {
        put("suggestOnTriggerCharacters", suggestOnTriggerCharacters);
        return this;
    }

    /**
     * @return Controls whether clicking on the empty content after a folded line will unfold the line. Defaults to
     * {@code false}.
     */
    public Boolean isUnfoldOnClickAfterEndOfLine() {
        return (Boolean) (has("unfoldOnClickAfterEndOfLine") ? get("unfoldOnClickAfterEndOfLine") : null);
    }

    /**
     * @param unfoldOnClickAfterEndOfLine Controls whether clicking on the empty content after a folded line will unfold
     * the line. Defaults to {@code false}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setUnfoldOnClickAfterEndOfLine(final Boolean unfoldOnClickAfterEndOfLine) {
        put("unfoldOnClickAfterEndOfLine", unfoldOnClickAfterEndOfLine);
        return this;
    }

    /**
     * @return Control if the editor should use shadow DOM.
     */
    public Boolean isUseShadowDOM() {
        return (Boolean) (has("useShadowDOM") ? get("useShadowDOM") : null);
    }

    /**
     * @param useShadowDOM Control if the editor should use shadow DOM.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setUseShadowDOM(final Boolean useShadowDOM) {
        put("useShadowDOM", useShadowDOM);
        return this;
    }

    /**
     * @return Inserting and deleting whitespace follows tab stops.
     */
    public Boolean isUseTabStops() {
        return (Boolean) (has("useTabStops") ? get("useTabStops") : null);
    }

    /**
     * @param useTabStops Inserting and deleting whitespace follows tab stops.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setUseTabStops(final Boolean useTabStops) {
        put("useTabStops", useTabStops);
        return this;
    }

    /**
     * @return Force word wrapping when the text appears to be of a minified/generated file. Defaults to {@code true}.
     */
    public Boolean isWordWrapMinified() {
        return (Boolean) (has("wordWrapMinified") ? get("wordWrapMinified") : null);
    }

    /**
     * @param wordWrapMinified Force word wrapping when the text appears to be of a minified/generated file. Defaults to
     * {@code true}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setWordWrapMinified(final Boolean wordWrapMinified) {
        put("wordWrapMinified", wordWrapMinified);
        return this;
    }

    /**
     * @return Controls the number of lines in the editor that can be read out by a screen reader.
     */
    public Number getAccessibilityPageSize() {
        return (Number) (has("accessibilityPageSize") ? get("accessibilityPageSize") : null);
    }

    /**
     * @param accessibilityPageSize Controls the number of lines in the editor that can be read out by a screen reader.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setAccessibilityPageSize(final Number accessibilityPageSize) {
        put("accessibilityPageSize", accessibilityPageSize);
        return this;
    }

    /**
     * @return Timeout for running code actions on save.
     */
    public Number getCodeActionsOnSaveTimeout() {
        return (Number) (has("codeActionsOnSaveTimeout") ? get("codeActionsOnSaveTimeout") : null);
    }

    /**
     * @param codeActionsOnSaveTimeout Timeout for running code actions on save.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setCodeActionsOnSaveTimeout(final Number codeActionsOnSaveTimeout) {
        put("codeActionsOnSaveTimeout", codeActionsOnSaveTimeout);
        return this;
    }

    /**
     * @return Code lens font size. Default to 90% of the editor font size.
     */
    public Number getCodeLensFontSize() {
        return (Number) (has("codeLensFontSize") ? get("codeLensFontSize") : null);
    }

    /**
     * @param codeLensFontSize Code lens font size. Default to 90% of the editor font size.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setCodeLensFontSize(final Number codeLensFontSize) {
        put("codeLensFontSize", codeLensFontSize);
        return this;
    }

    /**
     * @return Controls the minimal number of visible leading and trailing lines surrounding the cursor. Defaults to
     * {@code 0}.
     */
    public Number getCursorSurroundingLines() {
        return (Number) (has("cursorSurroundingLines") ? get("cursorSurroundingLines") : null);
    }

    /**
     * @param cursorSurroundingLines Controls the minimal number of visible leading and trailing lines surrounding the
     * cursor. Defaults to {@code 0}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setCursorSurroundingLines(final Number cursorSurroundingLines) {
        put("cursorSurroundingLines", cursorSurroundingLines);
        return this;
    }

    /**
     * @return Control the width of the cursor when cursorStyle is set to {@code line}
     */
    public Number getCursorWidth() {
        return (Number) (has("cursorWidth") ? get("cursorWidth") : null);
    }

    /**
     * @param cursorWidth Control the width of the cursor when cursorStyle is set to {@code line}
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setCursorWidth(final Number cursorWidth) {
        put("cursorWidth", cursorWidth);
        return this;
    }

    /**
     * @return Fast scrolling multiplier speed when pressing {@code Alt} Defaults to {@code 5}.
     */
    public Number getFastScrollSensitivity() {
        return (Number) (has("fastScrollSensitivity") ? get("fastScrollSensitivity") : null);
    }

    /**
     * @param fastScrollSensitivity Fast scrolling multiplier speed when pressing {@code Alt} Defaults to {@code 5}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setFastScrollSensitivity(final Number fastScrollSensitivity) {
        put("fastScrollSensitivity", fastScrollSensitivity);
        return this;
    }

    /**
     * @return Maximum number of foldable regions. Defaults to {@code 5000}.
     */
    public Number getFoldingMaximumRegions() {
        return (Number) (has("foldingMaximumRegions") ? get("foldingMaximumRegions") : null);
    }

    /**
     * @param foldingMaximumRegions Maximum number of foldable regions. Defaults to {@code 5000}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setFoldingMaximumRegions(final Number foldingMaximumRegions) {
        put("foldingMaximumRegions", foldingMaximumRegions);
        return this;
    }

    /**
     * @return The font size
     */
    public Number getFontSize() {
        return (Number) (has("fontSize") ? get("fontSize") : null);
    }

    /**
     * @param fontSize The font size
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setFontSize(final Number fontSize) {
        put("fontSize", fontSize);
        return this;
    }

    /**
     * @return This editor is used inside a diff editor.
     */
    public Boolean isInDiffEditor() {
        return (Boolean) (has("inDiffEditor") ? get("inDiffEditor") : null);
    }

    /**
     * @param inDiffEditor This editor is used inside a diff editor.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setInDiffEditor(final Boolean inDiffEditor) {
        put("inDiffEditor", inDiffEditor);
        return this;
    }

    /**
     * @return Emulate selection behaviour of tab characters when using spaces for indentation. This means selection
     * will stick to tab stops.
     */
    public Boolean isStickyTabStops() {
        return (Boolean) (has("stickyTabStops") ? get("stickyTabStops") : null);
    }

    /**
     * @param stickyTabStops Emulate selection behaviour of tab characters when using spaces for indentation. This means
     * selection will stick to tab stops.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setStickyTabStops(final Boolean stickyTabStops) {
        put("stickyTabStops", stickyTabStops);
        return this;
    }

    /**
     * @return The letter spacing
     */
    public Number getLetterSpacing() {
        return (Number) (has("letterSpacing") ? get("letterSpacing") : null);
    }

    /**
     * @param letterSpacing The letter spacing
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setLetterSpacing(final Number letterSpacing) {
        put("letterSpacing", letterSpacing);
        return this;
    }

    /**
     * @return The line height
     */
    public Number getLineHeight() {
        return (Number) (has("lineHeight") ? get("lineHeight") : null);
    }

    /**
     * @param lineHeight The line height
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setLineHeight(final Number lineHeight) {
        put("lineHeight", lineHeight);
        return this;
    }

    /**
     * @return Control the rendering of line numbers. If it is a function, it will be invoked when rendering a line
     * number and the return value will be rendered. Otherwise, if it is a truey, line numbers will be rendered normally
     * (equivalent of using an identity function). Otherwise, line numbers will not be rendered. Defaults to {@code on}.
     */
    public Number getLineNumbersMinChars() {
        return (Number) (has("lineNumbersMinChars") ? get("lineNumbersMinChars") : null);
    }

    /**
     * @param lineNumbersMinChars Control the rendering of line numbers. If it is a function, it will be invoked when
     * rendering a line number and the return value will be rendered. Otherwise, if it is a truey, line numbers will be
     * rendered normally (equivalent of using an identity function). Otherwise, line numbers will not be rendered.
     * Defaults to {@code on}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setLineNumbersMinChars(final Number lineNumbersMinChars) {
        put("lineNumbersMinChars", lineNumbersMinChars);
        return this;
    }

    /**
     * @return A multiplier to be used on the {@code deltaX} and {@code deltaY} of mouse wheel scroll events. Defaults
     * to {@code 1}.
     */
    public Number getMouseWheelScrollSensitivity() {
        return (Number) (has("mouseWheelScrollSensitivity") ? get("mouseWheelScrollSensitivity") : null);
    }

    /**
     * @param mouseWheelScrollSensitivity A multiplier to be used on the {@code deltaX} and {@code deltaY} of mouse
     * wheel scroll events. Defaults to {@code 1}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setMouseWheelScrollSensitivity(final Number mouseWheelScrollSensitivity) {
        put("mouseWheelScrollSensitivity", mouseWheelScrollSensitivity);
        return this;
    }

    /**
     * @return Controls the max number of text cursors that can be in an active editor at once.
     */
    public Number getMultiCursorLimit() {
        return (Number) (has("multiCursorLimit") ? get("multiCursorLimit") : null);
    }

    /**
     * @param multiCursorLimit Controls the max number of text cursors that can be in an active editor at once.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setMultiCursorLimit(final Number multiCursorLimit) {
        put("multiCursorLimit", multiCursorLimit);
        return this;
    }

    /**
     * @return The number of vertical lanes the overview ruler should render. Defaults to {@code 3}.
     */
    public Number getOverviewRulerLanes() {
        return (Number) (has("overviewRulerLanes") ? get("overviewRulerLanes") : null);
    }

    /**
     * @param overviewRulerLanes The number of vertical lanes the overview ruler should render. Defaults to {@code 3}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setOverviewRulerLanes(final Number overviewRulerLanes) {
        put("overviewRulerLanes", overviewRulerLanes);
        return this;
    }

    /**
     * @return Quick suggestions show delay (in ms) Defaults to {@code 10} (ms)
     */
    public Number getQuickSuggestionsDelay() {
        return (Number) (has("quickSuggestionsDelay") ? get("quickSuggestionsDelay") : null);
    }

    /**
     * @param quickSuggestionsDelay Quick suggestions show delay (in ms) Defaults to {@code 10} (ms)
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setQuickSuggestionsDelay(final Number quickSuggestionsDelay) {
        put("quickSuggestionsDelay", quickSuggestionsDelay);
        return this;
    }

    /**
     * @return When revealing the cursor, a virtual padding (px) is added to the cursor, turning it into a rectangle.
     * This virtual padding ensures that the cursor gets revealed before hitting the edge of the viewport. Defaults to
     * {@code 30} (px).
     */
    public Number getRevealHorizontalRightPadding() {
        return (Number) (has("revealHorizontalRightPadding") ? get("revealHorizontalRightPadding") : null);
    }

    /**
     * @param revealHorizontalRightPadding When revealing the cursor, a virtual padding (px) is added to the cursor,
     * turning it into a rectangle. This virtual padding ensures that the cursor gets revealed before hitting the edge
     * of the viewport. Defaults to {@code 30} (px).
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setRevealHorizontalRightPadding(final Number revealHorizontalRightPadding) {
        put("revealHorizontalRightPadding", revealHorizontalRightPadding);
        return this;
    }

    /**
     * @return Enable that scrolling can go beyond the last column by a number of columns. Defaults to {@code 5}.
     */
    public Number getScrollBeyondLastColumn() {
        return (Number) (has("scrollBeyondLastColumn") ? get("scrollBeyondLastColumn") : null);
    }

    /**
     * @param scrollBeyondLastColumn Enable that scrolling can go beyond the last column by a number of columns.
     * Defaults to {@code 5}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setScrollBeyondLastColumn(final Number scrollBeyondLastColumn) {
        put("scrollBeyondLastColumn", scrollBeyondLastColumn);
        return this;
    }

    /**
     * @return Performance guard: Stop rendering a line after x characters. Defaults to {@code 10000}. Use {@code -1} to
     * never stop rendering
     */
    public Number getStopRenderingLineAfter() {
        return (Number) (has("stopRenderingLineAfter") ? get("stopRenderingLineAfter") : null);
    }

    /**
     * @param stopRenderingLineAfter Performance guard: Stop rendering a line after x characters. Defaults to {@code
     * 10000}. Use {@code -1} to never stop rendering
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setStopRenderingLineAfter(final Number stopRenderingLineAfter) {
        put("stopRenderingLineAfter", stopRenderingLineAfter);
        return this;
    }

    /**
     * @return The font size for the suggest widget. Defaults to the editor font size.
     */
    public Number getSuggestFontSize() {
        return (Number) (has("suggestFontSize") ? get("suggestFontSize") : null);
    }

    /**
     * @param suggestFontSize The font size for the suggest widget. Defaults to the editor font size.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setSuggestFontSize(final Number suggestFontSize) {
        put("suggestFontSize", suggestFontSize);
        return this;
    }

    /**
     * @return The line height for the suggest widget. Defaults to the editor line height.
     */
    public Number getSuggestLineHeight() {
        return (Number) (has("suggestLineHeight") ? get("suggestLineHeight") : null);
    }

    /**
     * @param suggestLineHeight The line height for the suggest widget. Defaults to the editor line height.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setSuggestLineHeight(final Number suggestLineHeight) {
        put("suggestLineHeight", suggestLineHeight);
        return this;
    }

    /**
     * @return The {@code tabindex} property of the editor&#039;s textarea.
     */
    public Number getTabIndex() {
        return (Number) (has("tabIndex") ? get("tabIndex") : null);
    }

    /**
     * @param tabIndex The {@code tabindex} property of the editor&#039;s textarea.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setTabIndex(final Number tabIndex) {
        put("tabIndex", tabIndex);
        return this;
    }

    /**
     * @return Control the wrapping of the editor. When {@code wordWrap} = {@code off}, the lines will never wrap. When
     * {@code wordWrap} = {@code on}, the lines will wrap at the viewport width. When {@code wordWrap} = {@code
     * wordWrapColumn}, the lines will wrap at wordWrapColumn. When {@code wordWrap} = {@code bounded}, the lines will
     * wrap at min(viewport width, wordWrapColumn). Defaults to {@code 80}.
     */
    public Number getWordWrapColumn() {
        return (Number) (has("wordWrapColumn") ? get("wordWrapColumn") : null);
    }

    /**
     * @param wordWrapColumn Control the wrapping of the editor. When {@code wordWrap} = {@code off}, the lines will
     * never wrap. When {@code wordWrap} = {@code on}, the lines will wrap at the viewport width. When {@code wordWrap}
     * = {@code wordWrapColumn}, the lines will wrap at wordWrapColumn. When {@code wordWrap} = {@code bounded}, the
     * lines will wrap at min(viewport width, wordWrapColumn). Defaults to {@code 80}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setWordWrapColumn(final Number wordWrapColumn) {
        put("wordWrapColumn", wordWrapColumn);
        return this;
    }

    public String getLineDecorationsWidth() {
        return (String) (has("lineDecorationsWidth") ? get("lineDecorationsWidth") : null);
    }

    public EditorOptions setLineDecorationsWidth(final Number lineDecorationsWidth) {
        put("lineDecorationsWidth", lineDecorationsWidth != null ? lineDecorationsWidth.toString() + "px" : null);
        return this;
    }

    public EditorOptions setLineDecorationsWidth(final String lineDecorationsWidth) {
        put("lineDecorationsWidth", lineDecorationsWidth);
        return this;
    }

    /**
     * @return The aria label for the editor&#039;s textarea (when it is focused).
     */
    public String getAriaLabel() {
        return (String) (has("ariaLabel") ? get("ariaLabel") : null);
    }

    /**
     * @param ariaLabel The aria label for the editor&#039;s textarea (when it is focused).
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setAriaLabel(final String ariaLabel) {
        put("ariaLabel", ariaLabel);
        return this;
    }

    /**
     * @return Code lens font family. Defaults to editor font family.
     */
    public String getCodeLensFontFamily() {
        return (String) (has("codeLensFontFamily") ? get("codeLensFontFamily") : null);
    }

    /**
     * @param codeLensFontFamily Code lens font family. Defaults to editor font family.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setCodeLensFontFamily(final String codeLensFontFamily) {
        put("codeLensFontFamily", codeLensFontFamily);
        return this;
    }

    /**
     * @return Class name to be added to the editor.
     */
    public String getExtraEditorClassName() {
        return (String) (has("extraEditorClassName") ? get("extraEditorClassName") : null);
    }

    /**
     * @param extraEditorClassName Class name to be added to the editor.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setExtraEditorClassName(final String extraEditorClassName) {
        put("extraEditorClassName", extraEditorClassName);
        return this;
    }

    /**
     * @return The font family
     */
    public String getFontFamily() {
        return (String) (has("fontFamily") ? get("fontFamily") : null);
    }

    /**
     * @param fontFamily The font family
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setFontFamily(final String fontFamily) {
        put("fontFamily", fontFamily);
        return this;
    }

    /**
     * @return A string containing the word separators used when doing word navigation. Defaults to
     * `~!@#$%^&amp;*()-=+[{]}|;:&#039;&quot;,.&lt;&gt;/?
     */
    public String getWordSeparators() {
        return (String) (has("wordSeparators") ? get("wordSeparators") : null);
    }

    /**
     * @param wordSeparators A string containing the word separators used when doing word navigation. Defaults to
     * `~!@#$%^&amp;*()-=+[{]}|;:&#039;&quot;,.&lt;&gt;/?
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setWordSeparators(final String wordSeparators) {
        put("wordSeparators", wordSeparators);
        return this;
    }

    /**
     * @return Configure word wrapping characters. A break will be introduced after these characters. Defaults to tab
     * stops, closing brackets and parentheses, and several other Unicode punctuation marks.
     */
    public String getWordWrapBreakAfterCharacters() {
        return (String) (has("wordWrapBreakAfterCharacters") ? get("wordWrapBreakAfterCharacters") : null);
    }

    /**
     * @param wordWrapBreakAfterCharacters Configure word wrapping characters. A break will be introduced after these
     * characters. Defaults to tab stops, closing brackets and parentheses, and several other Unicode punctuation marks.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setWordWrapBreakAfterCharacters(final String wordWrapBreakAfterCharacters) {
        put("wordWrapBreakAfterCharacters", wordWrapBreakAfterCharacters);
        return this;
    }

    /**
     * @return Configure word wrapping characters. A break will be introduced before these characters. Defaults to
     * opening brackets and parentheses, and several other Unicode punctuation marks.
     */
    public String getWordWrapBreakBeforeCharacters() {
        return (String) (has("wordWrapBreakBeforeCharacters") ? get("wordWrapBreakBeforeCharacters") : null);
    }

    /**
     * @param wordWrapBreakBeforeCharacters Configure word wrapping characters. A break will be introduced before these
     * characters. Defaults to opening brackets and parentheses, and several other Unicode punctuation marks.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setWordWrapBreakBeforeCharacters(final String wordWrapBreakBeforeCharacters) {
        put("wordWrapBreakBeforeCharacters", wordWrapBreakBeforeCharacters);
        return this;
    }

    /**
     * @return The initial editor dimension (to avoid measuring the container).
     */
    public EditorDimension getDimension() {
        return (EditorDimension) (has("dimension") ? get("dimension") : null);
    }

    /**
     * @param dimension The initial editor dimension (to avoid measuring the container).
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setDimension(final EditorDimension dimension) {
        put("dimension", dimension);
        return this;
    }

    private String language;

    /**
     * @return The initial language of the auto created model in the editor. To not create automatically a model, use
     * {@code model: null}.
     */
    public String getLanguage() {
        return language;
    }

    /**
     * @param language The initial language of the auto created model in the editor. To not create automatically a
     * model, use {@code model: null}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setLanguage(final ELanguage language) {
        this.language = language != null ? language.toString() : null;
        return this;
    }

    /**
     * @param language The initial language of the auto created model in the editor. To not create automatically a
     * model, use {@code model: null}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setLanguage(final String language) {
        this.language = language;
        return this;
    }

    /**
     * @return Initial theme to be used for rendering. The current out-of-the-box available themes are: {@code vs}
     * (default), {@code vs-dark}, {@code hc-black}. You can create custom themes via {@code monaco.editor.defineTheme}.
     * To switch a theme, use {@code monaco.editor.setTheme}
     */
    public String getTheme() {
        return (String) (has("theme") ? get("theme") : null);
    }

    /**
     * @param theme Initial theme to be used for rendering. The current out-of-the-box available themes are: {@code vs}
     * (default), {@code vs-dark}, {@code hc-black}. You can create custom themes via {@code monaco.editor.defineTheme}.
     * To switch a theme, use {@code monaco.editor.setTheme}
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setTheme(final ETheme theme) {
        put("theme", theme != null ? theme.toString() : null);
        return this;
    }

    /**
     * @param theme Initial theme to be used for rendering. The current out-of-the-box available themes are: {@code vs}
     * (default), {@code vs-dark}, {@code hc-black}. You can create custom themes via {@code monaco.editor.defineTheme}.
     * To switch a theme, use {@code monaco.editor.setTheme}
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setTheme(final String theme) {
        put("theme", theme);
        return this;
    }

    /**
     * @return Controls whether the semanticHighlighting is shown for the languages that support it. {@code true}:
     * Semantic highlighting is enabled for all themes {@code false}: Semantic highlighting is disabled for all themes.
     * {@code configuredByTheme}: Semantic highlighting is controlled by the current color theme&#039;s {@code
     * semanticHighlighting} setting. Defaults to {@code configuredByTheme}.
     */
    public String getSemanticHighlightingEnabled() {
        return (String) (has("semanticHighlighting.enabled") ? get("semanticHighlighting.enabled") : null);
    }

    /**
     * @param semanticHighlightingEnabled Controls whether the semanticHighlighting is shown for the languages that
     * support it. {@code true}: Semantic highlighting is enabled for all themes {@code false}: Semantic highlighting is
     * disabled for all themes. {@code configuredByTheme}: Semantic highlighting is controlled by the current color
     * theme&#039;s {@code semanticHighlighting} setting. Defaults to {@code configuredByTheme}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setSemanticHighlightingEnabled(final ESemanticHighlightingEnabled semanticHighlightingEnabled) {
        put("semanticHighlighting.enabled", semanticHighlightingEnabled != null ? semanticHighlightingEnabled.toString() : null);
        return this;
    }

    /**
     * @param semanticHighlightingEnabled Controls whether the semanticHighlighting is shown for the languages that
     * support it. {@code true}: Semantic highlighting is enabled for all themes {@code false}: Semantic highlighting is
     * disabled for all themes. {@code configuredByTheme}: Semantic highlighting is controlled by the current color
     * theme&#039;s {@code semanticHighlighting} setting. Defaults to {@code configuredByTheme}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setSemanticHighlightingEnabled(final String semanticHighlightingEnabled) {
        put("semanticHighlighting.enabled", semanticHighlightingEnabled);
        return this;
    }

    /**
     * @return Controls whether {@code tabSize} and {@code insertSpaces} will be automatically detected when a file is
     * opened based on the file contents. Defaults to {@code true}.
     */
    public Boolean isDetectIndentation() {
        return (Boolean) (has("detectIndentation") ? get("detectIndentation") : null);
    }

    /**
     * @param detectIndentation Controls whether {@code tabSize} and {@code insertSpaces} will be automatically detected
     * when a file is opened based on the file contents. Defaults to {@code true}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setDetectIndentation(final Boolean detectIndentation) {
        put("detectIndentation", detectIndentation);
        return this;
    }

    /**
     * @return Insert spaces when pressing {@code Tab}. This setting is overridden based on the file contents when
     * {@code detectIndentation} is on. Defaults to {@code true}.
     */
    public Boolean isInsertSpaces() {
        return (Boolean) (has("insertSpaces") ? get("insertSpaces") : null);
    }

    /**
     * @param insertSpaces Insert spaces when pressing {@code Tab}. This setting is overridden based on the file
     * contents when {@code detectIndentation} is on. Defaults to {@code true}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setInsertSpaces(final Boolean insertSpaces) {
        put("insertSpaces", insertSpaces);
        return this;
    }

    /**
     * @return Remove trailing auto inserted whitespace. Defaults to {@code true}.
     */
    public Boolean isTrimAutoWhitespace() {
        return (Boolean) (has("trimAutoWhitespace") ? get("trimAutoWhitespace") : null);
    }

    /**
     * @param trimAutoWhitespace Remove trailing auto inserted whitespace. Defaults to {@code true}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setTrimAutoWhitespace(final Boolean trimAutoWhitespace) {
        put("trimAutoWhitespace", trimAutoWhitespace);
        return this;
    }

    /**
     * @return Controls whether completions should be computed based on words in the document. Defaults to {@code true}.
     */
    public Boolean isWordBasedSuggestions() {
        return (Boolean) (has("wordBasedSuggestions") ? get("wordBasedSuggestions") : null);
    }

    /**
     * @param wordBasedSuggestions Controls whether completions should be computed based on words in the document.
     * Defaults to {@code true}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setWordBasedSuggestions(final Boolean wordBasedSuggestions) {
        put("wordBasedSuggestions", wordBasedSuggestions);
        return this;
    }

    /**
     * @return Controls whether word based completions should be included from opened documents of the same language or
     * any language.
     */
    public Boolean isWordBasedSuggestionsOnlySameLanguage() {
        return (Boolean) (has("wordBasedSuggestionsOnlySameLanguage") ? get("wordBasedSuggestionsOnlySameLanguage") : null);
    }

    /**
     * @param wordBasedSuggestionsOnlySameLanguage Controls whether word based completions should be included from
     * opened documents of the same language or any language.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setWordBasedSuggestionsOnlySameLanguage(final Boolean wordBasedSuggestionsOnlySameLanguage) {
        put("wordBasedSuggestionsOnlySameLanguage", wordBasedSuggestionsOnlySameLanguage);
        return this;
    }

    /**
     * @return Lines above this length will not be tokenized for performance reasons. Defaults to {@code 20000}.
     */
    public Number getMaxTokenizationLineLength() {
        return (Number) (has("maxTokenizationLineLength") ? get("maxTokenizationLineLength") : null);
    }

    /**
     * @param maxTokenizationLineLength Lines above this length will not be tokenized for performance reasons. Defaults
     * to {@code 20000}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setMaxTokenizationLineLength(final Number maxTokenizationLineLength) {
        put("maxTokenizationLineLength", maxTokenizationLineLength);
        return this;
    }

    /**
     * @return The number of spaces a tab is equal to. This setting is overridden based on the file contents when {@code
     * detectIndentation} is on. Defaults to {@code 4}.
     */
    public Number getTabSize() {
        return (Number) (has("tabSize") ? get("tabSize") : null);
    }

    /**
     * @param tabSize The number of spaces a tab is equal to. This setting is overridden based on the file contents when
     * {@code detectIndentation} is on. Defaults to {@code 4}.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setTabSize(final Number tabSize) {
        put("tabSize", tabSize);
        return this;
    }

    /**
     * @return An URL to open when Ctrl+H (Windows and Linux) or Cmd+H (OSX) is pressed in the accessibility help dialog
     * in the editor.
     */
    public String getAccessibilityHelpUrl() {
        return (String) (has("accessibilityHelpUrl") ? get("accessibilityHelpUrl") : null);
    }

    /**
     * @param accessibilityHelpUrl An URL to open when Ctrl+H (Windows and Linux) or Cmd+H (OSX) is pressed in the
     * accessibility help dialog in the editor.
     * @return This same instance, useful for chaining multiple setter methods in one call.
     */
    public EditorOptions setAccessibilityHelpUrl(final String accessibilityHelpUrl) {
        put("accessibilityHelpUrl", accessibilityHelpUrl);
        return this;
    }

    /**
     * @return This options object as a serializable JSON object
     */
    JSONObject getJSONObject() {
        return this;
    }
}