!function(){var e,t,i={97138:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-action-bar {\n\twhite-space: nowrap;\n\theight: 100%;\n}\n\n.monaco-action-bar .actions-container {\n\tdisplay: flex;\n\tmargin: 0 auto;\n\tpadding: 0;\n\theight: 100%;\n\twidth: 100%;\n\talign-items: center;\n}\n\n.monaco-action-bar.vertical .actions-container {\n\tdisplay: inline-block;\n}\n\n.monaco-action-bar .action-item {\n\tdisplay: block;\n\talign-items: center;\n\tjustify-content: center;\n\tcursor: pointer;\n\tposition: relative;  /* DO NOT REMOVE - this is the key to preventing the ghosting icon bug in Chrome 42 */\n}\n\n.monaco-action-bar .action-item.disabled {\n\tcursor: default;\n}\n\n.monaco-action-bar .action-item .icon,\n.monaco-action-bar .action-item .codicon {\n\tdisplay: block;\n}\n\n.monaco-action-bar .action-item .codicon {\n\tdisplay: flex;\n\talign-items: center;\n\twidth: 16px;\n\theight: 16px;\n}\n\n.monaco-action-bar .action-label {\n\tdisplay: flex;\n\tfont-size: 11px;\n\tpadding: 3px;\n\tborder-radius: 5px;\n}\n\n.monaco-action-bar .action-item.disabled .action-label,\n.monaco-action-bar .action-item.disabled .action-label::before,\n.monaco-action-bar .action-item.disabled .action-label:hover {\n\topacity: 0.6;\n}\n\n/* Vertical actions */\n\n.monaco-action-bar.vertical {\n\ttext-align: left;\n}\n\n.monaco-action-bar.vertical .action-item {\n\tdisplay: block;\n}\n\n.monaco-action-bar.vertical .action-label.separator {\n\tdisplay: block;\n\tborder-bottom: 1px solid #bbb;\n\tpadding-top: 1px;\n\tmargin-left: .8em;\n\tmargin-right: .8em;\n}\n\n.monaco-action-bar .action-item .action-label.separator {\n\twidth: 1px;\n\theight: 16px;\n\tmargin: 5px 4px !important;\n\tcursor: default;\n\tmin-width: 1px;\n\tpadding: 0;\n\tbackground-color: #bbb;\n}\n\n.secondary-actions .monaco-action-bar .action-label {\n\tmargin-left: 6px;\n}\n\n/* Action Items */\n.monaco-action-bar .action-item.select-container {\n\toverflow: hidden; /* somehow the dropdown overflows its container, we prevent it here to not push */\n\tflex: 1;\n\tmax-width: 170px;\n\tmin-width: 60px;\n\tdisplay: flex;\n\talign-items: center;\n\tjustify-content: center;\n\tmargin-right: 10px;\n}\n\n.monaco-action-bar .action-item.action-dropdown-item {\n\tdisplay: flex;\n}\n\n.monaco-action-bar .action-item.action-dropdown-item > .action-dropdown-item-separator {\n\tdisplay: flex;\n\talign-items: center;\n\tcursor: default;\n}\n\n.monaco-action-bar .action-item.action-dropdown-item > .action-dropdown-item-separator > div {\n\twidth: 1px;\n}\n",""]),t.Z=s},40371:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-aria-container {\n\tposition: absolute; /* try to hide from window but not from screen readers */\n\tleft:-999em;\n}",""]),t.Z=s},93770:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-breadcrumbs {\n\tuser-select: none;\n\t-webkit-user-select: none;\n\tdisplay: flex;\n\tflex-direction: row;\n\tflex-wrap: nowrap;\n\tjustify-content: flex-start;\n\toutline-style: none;\n}\n\n.monaco-breadcrumbs .monaco-breadcrumb-item {\n\tdisplay: flex;\n\talign-items: center;\n\tflex: 0 1 auto;\n\twhite-space: nowrap;\n\tcursor: pointer;\n\talign-self: center;\n\theight: 100%;\n\toutline: none;\n}\n.monaco-breadcrumbs.disabled .monaco-breadcrumb-item {\n\tcursor: default;\n}\n\n.monaco-breadcrumbs .monaco-breadcrumb-item .codicon-breadcrumb-separator {\n\tcolor: inherit;\n}\n\n.monaco-breadcrumbs .monaco-breadcrumb-item:first-of-type::before {\n\tcontent: ' ';\n}\n",""]),t.Z=s},55796:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-text-button {\n\tbox-sizing: border-box;\n\tdisplay: flex;\n\twidth: 100%;\n\tpadding: 4px;\n\tborder-radius: 2px;\n\ttext-align: center;\n\tcursor: pointer;\n\tjustify-content: center;\n\talign-items: center;\n\tborder: 1px solid var(--vscode-button-border, transparent);\n\tline-height: 18px;\n}\n\n.monaco-text-button:focus {\n\toutline-offset: 2px !important;\n}\n\n.monaco-text-button:hover {\n\ttext-decoration: none !important;\n}\n\n.monaco-button.disabled:focus,\n.monaco-button.disabled {\n\topacity: 0.4 !important;\n\tcursor: default;\n}\n\n.monaco-text-button .codicon {\n\tmargin: 0 0.2em;\n\tcolor: inherit !important;\n}\n\n.monaco-text-button.monaco-text-button-with-short-label {\n\tflex-direction: row;\n\tflex-wrap: wrap;\n\tpadding: 0 4px;\n\toverflow: hidden;\n\theight: 28px;\n}\n\n.monaco-text-button.monaco-text-button-with-short-label > .monaco-button-label {\n\tflex-basis: 100%;\n}\n\n.monaco-text-button.monaco-text-button-with-short-label > .monaco-button-label-short {\n\tflex-grow: 1;\n\twidth: 0;\n\toverflow: hidden;\n}\n\n.monaco-text-button.monaco-text-button-with-short-label > .monaco-button-label,\n.monaco-text-button.monaco-text-button-with-short-label > .monaco-button-label-short {\n\tdisplay: flex;\n\tjustify-content: center;\n\talign-items: center;\n\tfont-weight: normal;\n\tfont-style: inherit;\n\tpadding: 4px 0;\n}\n\n.monaco-button-dropdown {\n\tdisplay: flex;\n\tcursor: pointer;\n}\n\n.monaco-button-dropdown.disabled {\n\tcursor: default;\n}\n\n.monaco-button-dropdown > .monaco-button:focus {\n\toutline-offset: -1px !important;\n}\n\n.monaco-button-dropdown.disabled > .monaco-button.disabled,\n.monaco-button-dropdown.disabled > .monaco-button.disabled:focus,\n.monaco-button-dropdown.disabled > .monaco-button-dropdown-separator {\n\topacity: 0.4 !important;\n}\n\n.monaco-button-dropdown > .monaco-button.monaco-text-button {\n\tborder-right-width: 0 !important;\n}\n\n.monaco-button-dropdown .monaco-button-dropdown-separator {\n\tpadding: 4px 0;\n\tcursor: default;\n}\n\n.monaco-button-dropdown .monaco-button-dropdown-separator > div {\n\theight: 100%;\n\twidth: 1px;\n}\n\n.monaco-button-dropdown > .monaco-button.monaco-dropdown-button {\n\tborder: 1px solid var(--vscode-button-border, transparent);\n\tborder-left-width: 0 !important;\n\tborder-radius: 0 2px 2px 0;\n\tdisplay: flex;\n\talign-items: center;\n}\n\n.monaco-button-dropdown > .monaco-button.monaco-text-button {\n\tborder-radius: 2px 0 0 2px;\n}\n\n.monaco-description-button {\n\tdisplay: flex;\n\tflex-direction: column;\n\talign-items: center;\n\tmargin: 4px 5px; /* allows button focus outline to be visible */\n}\n\n.monaco-description-button .monaco-button-description {\n\tfont-style: italic;\n\tfont-size: 11px;\n\tpadding: 4px 20px;\n}\n\n.monaco-description-button .monaco-button-label,\n.monaco-description-button .monaco-button-description {\n\tdisplay: flex;\n\tjustify-content: center;\n\talign-items: center;\n}\n\n.monaco-description-button .monaco-button-label > .codicon,\n.monaco-description-button .monaco-button-description > .codicon {\n\tmargin: 0 0.2em;\n\tcolor: inherit !important;\n}\n\n/* default color styles - based on CSS variables */\n\n.monaco-button.default-colors,\n.monaco-button-dropdown.default-colors > .monaco-button{\n\tcolor: var(--vscode-button-foreground);\n\tbackground-color: var(--vscode-button-background);\n}\n\n.monaco-button.default-colors:hover,\n.monaco-button-dropdown.default-colors > .monaco-button:hover {\n\tbackground-color: var(--vscode-button-hoverBackground);\n}\n\n.monaco-button.default-colors.secondary,\n.monaco-button-dropdown.default-colors > .monaco-button.secondary {\n\tcolor: var(--vscode-button-secondaryForeground);\n\tbackground-color: var(--vscode-button-secondaryBackground);\n}\n\n.monaco-button.default-colors.secondary:hover,\n.monaco-button-dropdown.default-colors > .monaco-button.secondary:hover {\n\tbackground-color: var(--vscode-button-secondaryHoverBackground);\n}\n\n.monaco-button-dropdown.default-colors .monaco-button-dropdown-separator {\n\tbackground-color: var(--vscode-button-background);\n\tborder-top: 1px solid var(--vscode-button-border);\n\tborder-bottom: 1px solid var(--vscode-button-border);\n}\n\n.monaco-button-dropdown.default-colors .monaco-button.secondary + .monaco-button-dropdown-separator {\n\tbackground-color: var(--vscode-button-secondaryBackground);\n}\n\n.monaco-button-dropdown.default-colors .monaco-button-dropdown-separator > div {\n\tbackground-color: var(--vscode-button-separator);\n}\n",""]),t.Z=s},99827:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.codicon-wrench-subaction {\n\topacity: 0.5;\n}\n\n@keyframes codicon-spin {\n\t100% {\n\t\ttransform:rotate(360deg);\n\t}\n}\n\n.codicon-sync.codicon-modifier-spin,\n.codicon-loading.codicon-modifier-spin,\n.codicon-gear.codicon-modifier-spin,\n.codicon-notebook-state-executing.codicon-modifier-spin {\n\t/* Use steps to throttle FPS to reduce CPU usage */\n\tanimation: codicon-spin 1.5s steps(30) infinite;\n}\n\n.codicon-modifier-disabled {\n\topacity: 0.4;\n}\n\n/* custom speed & easing for loading icon */\n.codicon-loading,\n.codicon-tree-item-loading::before {\n\tanimation-duration: 1s !important;\n\tanimation-timing-function: cubic-bezier(0.53, 0.21, 0.29, 0.67) !important;\n}\n",""]),t.Z=s},23222:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r),a=i(61667),l=i.n(a),c=new URL(i(48576),i.b),d=s()(o()),u=l()(c);d.push([e.id,'/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n@font-face {\n\tfont-family: "codicon";\n\tfont-display: block;\n\tsrc: url('+u+") format(\"truetype\");\n}\n\n.codicon[class*='codicon-'] {\n\tfont: normal normal normal 16px/1 codicon;\n\tdisplay: inline-block;\n\ttext-decoration: none;\n\ttext-rendering: auto;\n\ttext-align: center;\n\ttext-transform: none;\n\t-webkit-font-smoothing: antialiased;\n\t-moz-osx-font-smoothing: grayscale;\n\tuser-select: none;\n\t-webkit-user-select: none;\n}\n\n/* icon rules are dynamically created by the platform theme service (see iconsStyleSheet.ts) */\n",""]),t.Z=d},72555:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.context-view {\n\tposition: absolute;\n}\n\n.context-view.fixed {\n\tall: initial;\n\tfont-family: inherit;\n\tfont-size: 13px;\n\tposition: fixed;\n\tcolor: inherit;\n}\n",""]),t.Z=s},73688:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-count-badge {\n\tpadding: 3px 6px;\n\tborder-radius: 11px;\n\tfont-size: 11px;\n\tmin-width: 18px;\n\tmin-height: 18px;\n\tline-height: 11px;\n\tfont-weight: normal;\n\ttext-align: center;\n\tdisplay: inline-block;\n\tbox-sizing: border-box;\n}\n\n.monaco-count-badge.long {\n\tpadding: 2px 3px;\n\tborder-radius: 2px;\n\tmin-height: auto;\n\tline-height: normal;\n}\n",""]),t.Z=s},51911:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n/** Dialog: Modal Block */\n.monaco-dialog-modal-block {\n\tposition: fixed;\n\theight: 100%;\n\twidth: 100%;\n\tleft:0;\n\ttop:0;\n\tz-index: 2600;\n\tdisplay: flex;\n\tjustify-content: center;\n\talign-items: center;\n}\n\n.monaco-dialog-modal-block.dimmed {\n\tbackground: rgba(0, 0, 0, 0.3);\n}\n\n/** Dialog: Container */\n.monaco-dialog-box {\n\tdisplay: flex;\n\tflex-direction: column-reverse;\n\twidth: min-content;\n\tmin-width: 500px;\n\tmax-width: 90vw;\n\tmin-height: 75px;\n\tpadding: 10px;\n\ttransform: translate3d(0px, 0px, 0px);\n}\n\n/** Dialog: Title Actions Row */\n.monaco-dialog-box .dialog-toolbar-row {\n\theight: 22px;\n\tpadding-bottom: 4px;\n}\n\n.monaco-dialog-box .dialog-toolbar-row .actions-container {\n\tjustify-content: flex-end;\n}\n\n/** Dialog: Message Row */\n.monaco-dialog-box .dialog-message-row {\n\tdisplay: flex;\n\tflex-grow: 1;\n\talign-items: center;\n\tpadding: 0 10px;\n}\n\n.monaco-dialog-box .dialog-message-row > .dialog-icon.codicon {\n\tflex: 0 0 48px;\n\theight: 48px;\n\talign-self: baseline;\n\tfont-size: 48px;\n}\n\n/** Dialog: Message Container */\n.monaco-dialog-box .dialog-message-row .dialog-message-container {\n\tdisplay: flex;\n\tflex-direction: column;\n\toverflow: hidden;\n\ttext-overflow: ellipsis;\n\tpadding-left: 24px;\n\tuser-select: text;\n\t-webkit-user-select: text;\n\tword-wrap: break-word; /* never overflow long words, but break to next line */\n\twhite-space: normal;\n}\n\n/** Dialog: Message */\n.monaco-dialog-box .dialog-message-row .dialog-message-container .dialog-message {\n\tline-height: 22px;\n\tfont-size: 18px;\n\tflex: 1; /* let the message always grow */\n\twhite-space: normal;\n\tword-wrap: break-word; /* never overflow long words, but break to next line */\n\tmin-height: 48px; /* matches icon height */\n\tmargin-bottom: 8px;\n\tdisplay: flex;\n\talign-items: center;\n}\n\n/** Dialog: Details */\n.monaco-dialog-box .dialog-message-row .dialog-message-container .dialog-message-detail {\n\tline-height: 22px;\n\tflex: 1; /* let the message always grow */\n}\n\n.monaco-dialog-box .dialog-message-row .dialog-message-container .dialog-message a:focus {\n\toutline-width: 1px;\n\toutline-style: solid;\n}\n\n/** Dialog: Checkbox */\n.monaco-dialog-box .dialog-message-row .dialog-message-container .dialog-checkbox-row {\n\tpadding: 15px 0px 0px;\n\tdisplay: flex;\n}\n\n.monaco-dialog-box .dialog-message-row .dialog-message-container .dialog-checkbox-row .dialog-checkbox-message {\n\tcursor: pointer;\n\tuser-select: none;\n\t-webkit-user-select: none;\n}\n\n/** Dialog: Input */\n.monaco-dialog-box .dialog-message-row .dialog-message-container .dialog-message-input {\n\tpadding: 15px 0px 0px;\n\tdisplay: flex;\n}\n\n.monaco-dialog-box .dialog-message-row .dialog-message-container .dialog-message-input .monaco-inputbox {\n\tflex: 1;\n}\n\n/** Dialog: File Path */\n.monaco-dialog-box code {\n\tfont-family: var(--monaco-monospace-font);\n}\n\n/** Dialog: Buttons Row */\n.monaco-dialog-box > .dialog-buttons-row {\n\tdisplay: flex;\n\talign-items: center;\n\tpadding-right: 1px;\n\toverflow: hidden; /* buttons row should never overflow */\n}\n\n.monaco-dialog-box > .dialog-buttons-row {\n\tdisplay: flex;\n\twhite-space: nowrap;\n\tpadding: 20px 10px 10px;\n}\n\n/** Dialog: Buttons */\n.monaco-dialog-box > .dialog-buttons-row > .dialog-buttons {\n\tdisplay: flex;\n\twidth: 100%;\n\tjustify-content: flex-end;\n\toverflow: hidden;\n\tmargin-left: 67px; /* for long buttons, force align with text */\n}\n\n.monaco-dialog-box > .dialog-buttons-row > .dialog-buttons > .monaco-button {\n\twidth: fit-content;\n\tpadding: 5px 10px;\n\toverflow: hidden;\n\ttext-overflow: ellipsis;\n\tmargin: 4px 5px; /* allows button focus outline to be visible */\n\toutline-offset: 2px !important;\n}\n",""]),t.Z=s},45340:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-dropdown {\n\theight: 100%;\n\tpadding: 0;\n}\n\n.monaco-dropdown > .dropdown-label {\n\tcursor: pointer;\n\theight: 100%;\n\tdisplay: flex;\n\talign-items: center;\n\tjustify-content: center;\n}\n\n.monaco-dropdown > .dropdown-label > .action-label.disabled {\n\tcursor: default;\n}\n\n.monaco-dropdown-with-primary {\n\tdisplay: flex !important;\n\tflex-direction: row;\n\tborder-radius: 5px;\n}\n\n.monaco-dropdown-with-primary > .action-container > .action-label {\n\tmargin-right: 0;\n}\n\n.monaco-dropdown-with-primary > .dropdown-action-container > .monaco-dropdown > .dropdown-label .codicon[class*='codicon-'] {\n\tfont-size: 12px;\n\tpadding-left: 0px;\n\tpadding-right: 0px;\n\tline-height: 16px;\n\tmargin-left: -3px;\n}\n\n.monaco-dropdown-with-primary > .dropdown-action-container > .monaco-dropdown > .dropdown-label > .action-label {\n\tdisplay: block;\n\tbackground-size: 16px;\n\tbackground-position: center center;\n\tbackground-repeat: no-repeat;\n}\n",""]),t.Z=s},27504:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n/* ---------- Find input ---------- */\n\n.monaco-findInput {\n\tposition: relative;\n}\n\n.monaco-findInput .monaco-inputbox {\n\tfont-size: 13px;\n\twidth: 100%;\n}\n\n.monaco-findInput > .controls {\n\tposition: absolute;\n\ttop: 3px;\n\tright: 2px;\n}\n\n.vs .monaco-findInput.disabled {\n\tbackground-color: #E1E1E1;\n}\n\n/* Theming */\n.vs-dark .monaco-findInput.disabled {\n\tbackground-color: #333;\n}\n\n/* Highlighting */\n.monaco-findInput.highlight-0 .controls,\n.hc-light .monaco-findInput.highlight-0 .controls {\n\tanimation: monaco-findInput-highlight-0 100ms linear 0s;\n}\n\n.monaco-findInput.highlight-1 .controls,\n.hc-light .monaco-findInput.highlight-1 .controls {\n\tanimation: monaco-findInput-highlight-1 100ms linear 0s;\n}\n\n.hc-black .monaco-findInput.highlight-0 .controls,\n.vs-dark  .monaco-findInput.highlight-0 .controls {\n\tanimation: monaco-findInput-highlight-dark-0 100ms linear 0s;\n}\n\n.hc-black .monaco-findInput.highlight-1 .controls,\n.vs-dark  .monaco-findInput.highlight-1 .controls {\n\tanimation: monaco-findInput-highlight-dark-1 100ms linear 0s;\n}\n\n@keyframes monaco-findInput-highlight-0 {\n\t0% { background: rgba(253, 255, 0, 0.8); }\n\t100% { background: transparent; }\n}\n@keyframes monaco-findInput-highlight-1 {\n\t0% { background: rgba(253, 255, 0, 0.8); }\n\t/* Made intentionally different such that the CSS minifier does not collapse the two animations into a single one*/\n\t99% { background: transparent; }\n}\n\n@keyframes monaco-findInput-highlight-dark-0 {\n\t0% { background: rgba(255, 255, 255, 0.44); }\n\t100% { background: transparent; }\n}\n@keyframes monaco-findInput-highlight-dark-1 {\n\t0% { background: rgba(255, 255, 255, 0.44); }\n\t/* Made intentionally different such that the CSS minifier does not collapse the two animations into a single one*/\n\t99% { background: transparent; }\n}\n",""]),t.Z=s},57780:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-hover {\n\tcursor: default;\n\tposition: absolute;\n\toverflow: hidden;\n\tuser-select: text;\n\t-webkit-user-select: text;\n\tbox-sizing: border-box;\n\tanimation: fadein 100ms linear;\n\tline-height: 1.5em;\n\twhite-space: var(--vscode-hover-whiteSpace, normal);\n}\n\n.monaco-hover.hidden {\n\tdisplay: none;\n}\n\n.monaco-hover a:hover:not(.disabled) {\n\tcursor: pointer;\n}\n\n.monaco-hover .hover-contents:not(.html-hover-contents) {\n\tpadding: 4px 8px;\n}\n\n.monaco-hover .markdown-hover > .hover-contents:not(.code-hover-contents) {\n\tmax-width: var(--vscode-hover-maxWidth, 500px);\n\tword-wrap: break-word;\n}\n\n.monaco-hover .markdown-hover > .hover-contents:not(.code-hover-contents) hr {\n\tmin-width: 100%;\n}\n\n.monaco-hover p,\n.monaco-hover .code,\n.monaco-hover ul,\n.monaco-hover h1,\n.monaco-hover h2,\n.monaco-hover h3,\n.monaco-hover h4,\n.monaco-hover h5,\n.monaco-hover h6 {\n\tmargin: 8px 0;\n}\n\n.monaco-hover h1,\n.monaco-hover h2,\n.monaco-hover h3,\n.monaco-hover h4,\n.monaco-hover h5,\n.monaco-hover h6 {\n\tline-height: 1.1;\n}\n\n.monaco-hover code {\n\tfont-family: var(--monaco-monospace-font);\n}\n\n.monaco-hover hr {\n\tbox-sizing: border-box;\n\tborder-left: 0px;\n\tborder-right: 0px;\n\tmargin-top: 4px;\n\tmargin-bottom: -4px;\n\tmargin-left: -8px;\n\tmargin-right: -8px;\n\theight: 1px;\n}\n\n.monaco-hover p:first-child,\n.monaco-hover .code:first-child,\n.monaco-hover ul:first-child {\n\tmargin-top: 0;\n}\n\n.monaco-hover p:last-child,\n.monaco-hover .code:last-child,\n.monaco-hover ul:last-child {\n\tmargin-bottom: 0;\n}\n\n/* MarkupContent Layout */\n.monaco-hover ul {\n\tpadding-left: 20px;\n}\n.monaco-hover ol {\n\tpadding-left: 20px;\n}\n\n.monaco-hover li > p {\n\tmargin-bottom: 0;\n}\n\n.monaco-hover li > ul {\n\tmargin-top: 0;\n}\n\n.monaco-hover code {\n\tborder-radius: 3px;\n\tpadding: 0 0.4em;\n}\n\n.monaco-hover .monaco-tokenized-source {\n\twhite-space: var(--vscode-hover-sourceWhiteSpace, pre-wrap);\n}\n\n.monaco-hover .hover-row.status-bar {\n\tfont-size: 12px;\n\tline-height: 22px;\n}\n\n.monaco-hover .hover-row.status-bar .info {\n\tfont-style: italic;\n\tpadding: 0px 8px;\n}\n\n.monaco-hover .hover-row.status-bar .actions {\n\tdisplay: flex;\n\tpadding: 0px 8px;\n}\n\n.monaco-hover .hover-row.status-bar .actions .action-container {\n\tmargin-right: 16px;\n\tcursor: pointer;\n}\n\n.monaco-hover .hover-row.status-bar .actions .action-container .action .icon {\n\tpadding-right: 4px;\n}\n\n.monaco-hover .markdown-hover .hover-contents .codicon {\n\tcolor: inherit;\n\tfont-size: inherit;\n\tvertical-align: middle;\n}\n\n.monaco-hover .hover-contents a.code-link:hover,\n.monaco-hover .hover-contents a.code-link {\n\tcolor: inherit;\n}\n\n.monaco-hover .hover-contents a.code-link:before {\n\tcontent: '(';\n}\n\n.monaco-hover .hover-contents a.code-link:after {\n\tcontent: ')';\n}\n\n.monaco-hover .hover-contents a.code-link > span {\n\ttext-decoration: underline;\n\t/** Hack to force underline to show **/\n\tborder-bottom: 1px solid transparent;\n\ttext-underline-position: under;\n\tcolor: var(--vscode-textLink-foreground);\n}\n\n.monaco-hover .hover-contents a.code-link > span:hover {\n\tcolor: var(--vscode-textLink-activeForeground);\n}\n\n/** Spans in markdown hovers need a margin-bottom to avoid looking cramped: https://github.com/microsoft/vscode/issues/101496 **/\n.monaco-hover .markdown-hover .hover-contents:not(.code-hover-contents):not(.html-hover-contents) span {\n\tmargin-bottom: 4px;\n\tdisplay: inline-block;\n}\n\n.monaco-hover-content .action-container a {\n\t-webkit-user-select: none;\n\tuser-select: none;\n}\n\n.monaco-hover-content .action-container.disabled {\n\tpointer-events: none;\n\topacity: 0.4;\n\tcursor: default;\n}\n",""]),t.Z=s},3293:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n/* ---------- Icon label ---------- */\n\n.monaco-icon-label {\n\tdisplay: flex; /* required for icons support :before rule */\n\toverflow: hidden;\n\ttext-overflow: ellipsis;\n}\n\n.monaco-icon-label::before {\n\n\t/* svg icons rendered as background image */\n\tbackground-size: 16px;\n\tbackground-position: left center;\n\tbackground-repeat: no-repeat;\n\tpadding-right: 6px;\n\twidth: 16px;\n\theight: 22px;\n\tline-height: inherit !important;\n\tdisplay: inline-block;\n\n\t/* fonts icons */\n\t-webkit-font-smoothing: antialiased;\n\t-moz-osx-font-smoothing: grayscale;\n\tvertical-align: top;\n\n\tflex-shrink: 0; /* fix for https://github.com/microsoft/vscode/issues/13787 */\n}\n\n.monaco-icon-label-container.disabled {\n\tcolor: var(--vscode-disabledForeground);\n}\n.monaco-icon-label > .monaco-icon-label-container {\n\tmin-width: 0;\n\toverflow: hidden;\n\ttext-overflow: ellipsis;\n\tflex: 1;\n}\n\n.monaco-icon-label > .monaco-icon-label-container > .monaco-icon-name-container > .label-name {\n\tcolor: inherit;\n\twhite-space: pre; /* enable to show labels that include multiple whitespaces */\n}\n\n.monaco-icon-label > .monaco-icon-label-container > .monaco-icon-name-container > .label-name > .label-separator {\n\tmargin: 0 2px;\n\topacity: 0.5;\n}\n\n.monaco-icon-label>.monaco-icon-label-container>.monaco-icon-suffix-container>.label-suffix {\n\topacity: .7;\n\twhite-space: pre;\n}\n\n.monaco-icon-label > .monaco-icon-label-container > .monaco-icon-description-container > .label-description {\n\topacity: .7;\n\tmargin-left: 0.5em;\n\tfont-size: 0.9em;\n\twhite-space: pre; /* enable to show labels that include multiple whitespaces */\n}\n\n.monaco-icon-label.nowrap > .monaco-icon-label-container > .monaco-icon-description-container > .label-description{\n\twhite-space: nowrap\n}\n\n.vs .monaco-icon-label > .monaco-icon-label-container > .monaco-icon-description-container > .label-description {\n\topacity: .95;\n}\n\n.monaco-icon-label.italic > .monaco-icon-label-container > .monaco-icon-name-container > .label-name,\n.monaco-icon-label.italic > .monaco-icon-label-container > .monaco-icon-description-container > .label-description {\n\tfont-style: italic;\n}\n\n.monaco-icon-label.deprecated {\n\ttext-decoration: line-through;\n\topacity: 0.66;\n}\n\n/* make sure apply italic font style to decorations as well */\n.monaco-icon-label.italic::after {\n\tfont-style: italic;\n}\n\n.monaco-icon-label.strikethrough > .monaco-icon-label-container > .monaco-icon-name-container > .label-name,\n.monaco-icon-label.strikethrough > .monaco-icon-label-container > .monaco-icon-description-container > .label-description {\n\ttext-decoration: line-through;\n}\n\n.monaco-icon-label::after {\n\topacity: 0.75;\n\tfont-size: 90%;\n\tfont-weight: 600;\n\tmargin: auto 16px 0 5px; /* https://github.com/microsoft/vscode/issues/113223 */\n\ttext-align: center;\n}\n\n/* make sure selection color wins when a label is being selected */\n.monaco-list:focus .selected .monaco-icon-label, /* list */\n.monaco-list:focus .selected .monaco-icon-label::after\n{\n\tcolor: inherit !important;\n}\n\n.monaco-list-row.focused.selected .label-description,\n.monaco-list-row.selected .label-description {\n\topacity: .8;\n}\n",""]),t.Z=s},24695:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-inputbox {\n\tposition: relative;\n\tdisplay: block;\n\tpadding: 0;\n\tbox-sizing:\tborder-box;\n\tborder-radius: 2px;\n\n\t/* Customizable */\n\tfont-size: inherit;\n}\n\n.monaco-inputbox > .ibwrapper > .input,\n.monaco-inputbox > .ibwrapper > .mirror {\n\n\t/* Customizable */\n\tpadding: 4px 6px;\n}\n\n.monaco-inputbox > .ibwrapper {\n\tposition: relative;\n\twidth: 100%;\n\theight: 100%;\n}\n\n.monaco-inputbox > .ibwrapper > .input {\n\tdisplay: inline-block;\n\tbox-sizing:\tborder-box;\n\twidth: 100%;\n\theight: 100%;\n\tline-height: inherit;\n\tborder: none;\n\tfont-family: inherit;\n\tfont-size: inherit;\n\tresize: none;\n\tcolor: inherit;\n}\n\n.monaco-inputbox > .ibwrapper > input {\n\ttext-overflow: ellipsis;\n}\n\n.monaco-inputbox > .ibwrapper > textarea.input {\n\tdisplay: block;\n\tscrollbar-width: none; /* Firefox: hide scrollbars */\n\toutline: none;\n}\n\n.monaco-inputbox > .ibwrapper > textarea.input::-webkit-scrollbar {\n\tdisplay: none; /* Chrome + Safari: hide scrollbar */\n}\n\n.monaco-inputbox > .ibwrapper > textarea.input.empty {\n\twhite-space: nowrap;\n}\n\n.monaco-inputbox > .ibwrapper > .mirror {\n\tposition: absolute;\n\tdisplay: inline-block;\n\twidth: 100%;\n\ttop: 0;\n\tleft: 0;\n\tbox-sizing: border-box;\n\twhite-space: pre-wrap;\n\tvisibility: hidden;\n\tword-wrap: break-word;\n}\n\n/* Context view */\n\n.monaco-inputbox-container {\n\ttext-align: right;\n}\n\n.monaco-inputbox-container .monaco-inputbox-message {\n\tdisplay: inline-block;\n\toverflow: hidden;\n\ttext-align: left;\n\twidth: 100%;\n\tbox-sizing:\tborder-box;\n\tpadding: 0.4em;\n\tfont-size: 12px;\n\tline-height: 17px;\n\tmargin-top: -1px;\n\tword-wrap: break-word;\n}\n\n/* Action bar support */\n.monaco-inputbox .monaco-action-bar {\n\tposition: absolute;\n\tright: 2px;\n\ttop: 4px;\n}\n\n.monaco-inputbox .monaco-action-bar .action-item {\n\tmargin-left: 2px;\n}\n\n.monaco-inputbox .monaco-action-bar .action-item .codicon {\n\tbackground-repeat: no-repeat;\n\twidth: 16px;\n\theight: 16px;\n}\n",""]),t.Z=s},7896:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-keybinding {\n\tdisplay: flex;\n\talign-items: center;\n\tline-height: 10px;\n}\n\n.monaco-keybinding > .monaco-keybinding-key {\n\tdisplay: inline-block;\n\tborder-style: solid;\n\tborder-width: 1px;\n\tborder-radius: 3px;\n\tvertical-align: middle;\n\tfont-size: 11px;\n\tpadding: 3px 5px;\n\tmargin: 0 2px;\n}\n\n.monaco-keybinding > .monaco-keybinding-key:first-child {\n\tmargin-left: 0;\n}\n\n.monaco-keybinding > .monaco-keybinding-key:last-child {\n\tmargin-right: 0;\n}\n\n.monaco-keybinding > .monaco-keybinding-key-separator {\n\tdisplay: inline-block;\n}\n\n.monaco-keybinding > .monaco-keybinding-key-chord-separator {\n\twidth: 6px;\n}\n",""]),t.Z=s},85220:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-list {\n\tposition: relative;\n\theight: 100%;\n\twidth: 100%;\n\twhite-space: nowrap;\n}\n\n.monaco-list.mouse-support {\n\tuser-select: none;\n\t-webkit-user-select: none;\n}\n\n.monaco-list > .monaco-scrollable-element {\n\theight: 100%;\n}\n\n.monaco-list-rows {\n\tposition: relative;\n\twidth: 100%;\n\theight: 100%;\n}\n\n.monaco-list.horizontal-scrolling .monaco-list-rows {\n\twidth: auto;\n\tmin-width: 100%;\n}\n\n.monaco-list-row {\n\tposition: absolute;\n\tbox-sizing: border-box;\n\toverflow: hidden;\n\twidth: 100%;\n}\n\n.monaco-list.mouse-support .monaco-list-row {\n\tcursor: pointer;\n\ttouch-action: none;\n}\n\n/* Make sure the scrollbar renders above overlays (sticky scroll) */\n.monaco-list .monaco-scrollable-element > .scrollbar.vertical,\n.monaco-pane-view > .monaco-split-view2.vertical > .monaco-scrollable-element > .scrollbar.vertical {\n\tz-index: 14;\n}\n\n/* for OS X ballistic scrolling */\n.monaco-list-row.scrolling {\n\tdisplay: none !important;\n}\n\n/* Focus */\n.monaco-list.element-focused,\n.monaco-list.selection-single,\n.monaco-list.selection-multiple {\n\toutline: 0 !important;\n}\n\n/* Dnd */\n.monaco-drag-image {\n\tdisplay: inline-block;\n\tpadding: 1px 7px;\n\tborder-radius: 10px;\n\tfont-size: 12px;\n\tposition: absolute;\n\tz-index: 1000;\n}\n\n/* Filter */\n\n.monaco-list-type-filter-message {\n\tposition: absolute;\n\tbox-sizing: border-box;\n\twidth: 100%;\n\theight: 100%;\n\ttop: 0;\n\tleft: 0;\n\tpadding: 40px 1em 1em 1em;\n\ttext-align: center;\n\twhite-space: normal;\n\topacity: 0.7;\n\tpointer-events: none;\n}\n\n.monaco-list-type-filter-message:empty {\n\tdisplay: none;\n}\n",""]),t.Z=s},58322:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-mouse-cursor-text {\n\tcursor: text;\n}\n",""]),t.Z=s},41227:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-progress-container {\n\twidth: 100%;\n\theight: 2px;\n\toverflow: hidden; /* keep progress bit in bounds */\n}\n\n.monaco-progress-container .progress-bit {\n\twidth: 2%;\n\theight: 2px;\n\tposition: absolute;\n\tleft: 0;\n\tdisplay: none;\n}\n\n.monaco-progress-container.active .progress-bit {\n\tdisplay: inherit;\n}\n\n.monaco-progress-container.discrete .progress-bit {\n\tleft: 0;\n\ttransition: width 100ms linear;\n}\n\n.monaco-progress-container.discrete.done .progress-bit {\n\twidth: 100%;\n}\n\n.monaco-progress-container.infinite .progress-bit {\n\tanimation-name: progress;\n\tanimation-duration: 4s;\n\tanimation-iteration-count: infinite;\n\ttransform: translate3d(0px, 0px, 0px);\n\tanimation-timing-function: linear;\n}\n\n.monaco-progress-container.infinite.infinite-long-running .progress-bit {\n\t/*\n\t\tThe more smooth `linear` timing function can cause\n\t\thigher GPU consumption as indicated in\n\t\thttps://github.com/microsoft/vscode/issues/97900 &\n\t\thttps://github.com/microsoft/vscode/issues/138396\n\t*/\n\tanimation-timing-function: steps(100);\n}\n\n/**\n * The progress bit has a width: 2% (1/50) of the parent container. The animation moves it from 0% to 100% of\n * that container. Since translateX is relative to the progress bit size, we have to multiple it with\n * its relative size to the parent container:\n * parent width: 5000%\n *    bit width: 100%\n * translateX should be as follow:\n *  50%: 5000% * 50% - 50% (set to center) = 2450%\n * 100%: 5000% * 100% - 100% (do not overflow) = 4900%\n */\n@keyframes progress { from { transform: translateX(0%) scaleX(1) } 50% { transform: translateX(2500%) scaleX(3) } to { transform: translateX(4900%) scaleX(1) } }\n",""]),t.Z=s},67054:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n:root {\n\t--vscode-sash-size: 4px;\n\t--vscode-sash-hover-size: 4px;\n}\n\n.monaco-sash {\n\tposition: absolute;\n\tz-index: 35;\n\ttouch-action: none;\n}\n\n.monaco-sash.disabled {\n\tpointer-events: none;\n}\n\n.monaco-sash.mac.vertical {\n\tcursor: col-resize;\n}\n\n.monaco-sash.vertical.minimum {\n\tcursor: e-resize;\n}\n\n.monaco-sash.vertical.maximum {\n\tcursor: w-resize;\n}\n\n.monaco-sash.mac.horizontal {\n\tcursor: row-resize;\n}\n\n.monaco-sash.horizontal.minimum {\n\tcursor: s-resize;\n}\n\n.monaco-sash.horizontal.maximum {\n\tcursor: n-resize;\n}\n\n.monaco-sash.disabled {\n\tcursor: default !important;\n\tpointer-events: none !important;\n}\n\n.monaco-sash.vertical {\n\tcursor: ew-resize;\n\ttop: 0;\n\twidth: var(--vscode-sash-size);\n\theight: 100%;\n}\n\n.monaco-sash.horizontal {\n\tcursor: ns-resize;\n\tleft: 0;\n\twidth: 100%;\n\theight: var(--vscode-sash-size);\n}\n\n.monaco-sash:not(.disabled) > .orthogonal-drag-handle {\n\tcontent: \" \";\n\theight: calc(var(--vscode-sash-size) * 2);\n\twidth: calc(var(--vscode-sash-size) * 2);\n\tz-index: 100;\n\tdisplay: block;\n\tcursor: all-scroll;\n\tposition: absolute;\n}\n\n.monaco-sash.horizontal.orthogonal-edge-north:not(.disabled)\n\t> .orthogonal-drag-handle.start,\n.monaco-sash.horizontal.orthogonal-edge-south:not(.disabled)\n\t> .orthogonal-drag-handle.end {\n\tcursor: nwse-resize;\n}\n\n.monaco-sash.horizontal.orthogonal-edge-north:not(.disabled)\n\t> .orthogonal-drag-handle.end,\n.monaco-sash.horizontal.orthogonal-edge-south:not(.disabled)\n\t> .orthogonal-drag-handle.start {\n\tcursor: nesw-resize;\n}\n\n.monaco-sash.vertical > .orthogonal-drag-handle.start {\n\tleft: calc(var(--vscode-sash-size) * -0.5);\n\ttop: calc(var(--vscode-sash-size) * -1);\n}\n.monaco-sash.vertical > .orthogonal-drag-handle.end {\n\tleft: calc(var(--vscode-sash-size) * -0.5);\n\tbottom: calc(var(--vscode-sash-size) * -1);\n}\n.monaco-sash.horizontal > .orthogonal-drag-handle.start {\n\ttop: calc(var(--vscode-sash-size) * -0.5);\n\tleft: calc(var(--vscode-sash-size) * -1);\n}\n.monaco-sash.horizontal > .orthogonal-drag-handle.end {\n\ttop: calc(var(--vscode-sash-size) * -0.5);\n\tright: calc(var(--vscode-sash-size) * -1);\n}\n\n.monaco-sash:before {\n\tcontent: '';\n\tpointer-events: none;\n\tposition: absolute;\n\twidth: 100%;\n\theight: 100%;\n\tbackground: transparent;\n}\n\n.monaco-workbench:not(.reduce-motion) .monaco-sash:before {\n\ttransition: background-color 0.1s ease-out;\n}\n\n.monaco-sash.hover:before,\n.monaco-sash.active:before {\n\tbackground: var(--vscode-sash-hoverBorder);\n}\n\n.monaco-sash.vertical:before {\n\twidth: var(--vscode-sash-hover-size);\n\tleft: calc(50% - (var(--vscode-sash-hover-size) / 2));\n}\n\n.monaco-sash.horizontal:before {\n\theight: var(--vscode-sash-hover-size);\n\ttop: calc(50% - (var(--vscode-sash-hover-size) / 2));\n}\n\n.pointer-events-disabled {\n\tpointer-events: none !important;\n}\n\n/** Debug **/\n\n.monaco-sash.debug {\n\tbackground: cyan;\n}\n\n.monaco-sash.debug.disabled {\n\tbackground: rgba(0, 255, 255, 0.2);\n}\n\n.monaco-sash.debug:not(.disabled) > .orthogonal-drag-handle {\n\tbackground: red;\n}\n",""]),t.Z=s},64836:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n/* Arrows */\n.monaco-scrollable-element > .scrollbar > .scra {\n\tcursor: pointer;\n\tfont-size: 11px !important;\n}\n\n.monaco-scrollable-element > .visible {\n\topacity: 1;\n\n\t/* Background rule added for IE9 - to allow clicks on dom node */\n\tbackground:rgba(0,0,0,0);\n\n\ttransition: opacity 100ms linear;\n\t/* In front of peek view */\n\tz-index: 11;\n}\n.monaco-scrollable-element > .invisible {\n\topacity: 0;\n\tpointer-events: none;\n}\n.monaco-scrollable-element > .invisible.fade {\n\ttransition: opacity 800ms linear;\n}\n\n/* Scrollable Content Inset Shadow */\n.monaco-scrollable-element > .shadow {\n\tposition: absolute;\n\tdisplay: none;\n}\n.monaco-scrollable-element > .shadow.top {\n\tdisplay: block;\n\ttop: 0;\n\tleft: 3px;\n\theight: 3px;\n\twidth: 100%;\n\tbox-shadow: var(--vscode-scrollbar-shadow) 0 6px 6px -6px inset;\n}\n.monaco-scrollable-element > .shadow.left {\n\tdisplay: block;\n\ttop: 3px;\n\tleft: 0;\n\theight: 100%;\n\twidth: 3px;\n\tbox-shadow: var(--vscode-scrollbar-shadow) 6px 0 6px -6px inset;\n}\n.monaco-scrollable-element > .shadow.top-left-corner {\n\tdisplay: block;\n\ttop: 0;\n\tleft: 0;\n\theight: 3px;\n\twidth: 3px;\n}\n.monaco-scrollable-element > .shadow.top.left {\n\tbox-shadow: var(--vscode-scrollbar-shadow) 6px 0 6px -6px inset;\n}\n\n.monaco-scrollable-element > .scrollbar > .slider {\n\tbackground: var(--vscode-scrollbarSlider-background);\n}\n\n.monaco-scrollable-element > .scrollbar > .slider:hover {\n\tbackground: var(--vscode-scrollbarSlider-hoverBackground);\n}\n\n.monaco-scrollable-element > .scrollbar > .slider.active {\n\tbackground: var(--vscode-scrollbarSlider-activeBackground);\n}\n",""]),t.Z=s},98657:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-select-box {\n\twidth: 100%;\n\tcursor: pointer;\n\tborder-radius: 2px;\n}\n\n.monaco-select-box-dropdown-container {\n\tfont-size: 13px;\n\tfont-weight: normal;\n\ttext-transform: none;\n}\n\n/** Actions */\n\n.monaco-action-bar .action-item.select-container {\n\tcursor: default;\n}\n\n.monaco-action-bar .action-item .monaco-select-box {\n\tcursor: pointer;\n\tmin-width: 100px;\n\tmin-height: 18px;\n\tpadding: 2px 23px 2px 8px;\n}\n\n.mac .monaco-action-bar .action-item .monaco-select-box {\n\tfont-size: 11px;\n\tborder-radius: 5px;\n}\n",""]),t.Z=s},40053:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n/* Use custom CSS vars to expose padding into parent select for padding calculation */\n.monaco-select-box-dropdown-padding {\n\t--dropdown-padding-top: 1px;\n\t--dropdown-padding-bottom: 1px;\n}\n\n.hc-black .monaco-select-box-dropdown-padding,\n.hc-light .monaco-select-box-dropdown-padding {\n\t--dropdown-padding-top: 3px;\n\t--dropdown-padding-bottom: 4px;\n}\n\n.monaco-select-box-dropdown-container {\n\tdisplay: none;\n\tbox-sizing:\tborder-box;\n}\n\n.monaco-select-box-dropdown-container > .select-box-details-pane > .select-box-description-markdown * {\n\tmargin: 0;\n}\n\n.monaco-select-box-dropdown-container > .select-box-details-pane > .select-box-description-markdown a:focus {\n\toutline: 1px solid -webkit-focus-ring-color;\n\toutline-offset: -1px;\n}\n\n.monaco-select-box-dropdown-container > .select-box-details-pane > .select-box-description-markdown code {\n\tline-height: 15px; /** For some reason, this is needed, otherwise <code> will take up 20px height */\n\tfont-family: var(--monaco-monospace-font);\n}\n\n\n.monaco-select-box-dropdown-container.visible {\n\tdisplay: flex;\n\tflex-direction: column;\n\ttext-align: left;\n\twidth: 1px;\n\toverflow: hidden;\n\tborder-bottom-left-radius: 3px;\n\tborder-bottom-right-radius: 3px;\n}\n\n.monaco-select-box-dropdown-container > .select-box-dropdown-list-container {\n\tflex: 0 0 auto;\n\talign-self: flex-start;\n\tpadding-top: var(--dropdown-padding-top);\n\tpadding-bottom: var(--dropdown-padding-bottom);\n\tpadding-left: 1px;\n\tpadding-right: 1px;\n\twidth: 100%;\n\toverflow: hidden;\n\tbox-sizing:\tborder-box;\n}\n\n.monaco-select-box-dropdown-container > .select-box-details-pane {\n\tpadding: 5px;\n}\n\n.hc-black .monaco-select-box-dropdown-container > .select-box-dropdown-list-container {\n\tpadding-top: var(--dropdown-padding-top);\n\tpadding-bottom: var(--dropdown-padding-bottom);\n}\n\n.monaco-select-box-dropdown-container > .select-box-dropdown-list-container .monaco-list .monaco-list-row {\n\tcursor: pointer;\n}\n\n.monaco-select-box-dropdown-container > .select-box-dropdown-list-container .monaco-list .monaco-list-row > .option-text {\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n\tpadding-left: 3.5px;\n\twhite-space: nowrap;\n\tfloat: left;\n}\n\n.monaco-select-box-dropdown-container > .select-box-dropdown-list-container .monaco-list .monaco-list-row > .option-detail {\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n\tpadding-left: 3.5px;\n\twhite-space: nowrap;\n\tfloat: left;\n\topacity: 0.7;\n}\n\n.monaco-select-box-dropdown-container > .select-box-dropdown-list-container .monaco-list .monaco-list-row > .option-decorator-right {\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n\tpadding-right: 10px;\n\twhite-space: nowrap;\n\tfloat: right;\n}\n\n\n/* Accepted CSS hiding technique for accessibility reader text  */\n/* https://webaim.org/techniques/css/invisiblecontent/ */\n\n.monaco-select-box-dropdown-container > .select-box-dropdown-list-container .monaco-list .monaco-list-row > .visually-hidden {\n\t\tposition: absolute;\n\t\tleft: -10000px;\n\t\ttop: auto;\n\t\twidth: 1px;\n\t\theight: 1px;\n\t\toverflow: hidden;\n}\n\n.monaco-select-box-dropdown-container > .select-box-dropdown-container-width-control {\n\tflex: 1 1 auto;\n\talign-self: flex-start;\n\topacity: 0;\n}\n\n.monaco-select-box-dropdown-container > .select-box-dropdown-container-width-control > .width-control-div {\n\toverflow: hidden;\n\tmax-height: 0px;\n}\n\n.monaco-select-box-dropdown-container > .select-box-dropdown-container-width-control > .width-control-div > .option-text-width-control {\n\tpadding-left: 4px;\n\tpadding-right: 8px;\n\twhite-space: nowrap;\n}\n",""]),t.Z=s},35201:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-split-view2 {\n\tposition: relative;\n\twidth: 100%;\n\theight: 100%;\n}\n\n.monaco-split-view2 > .sash-container {\n\tposition: absolute;\n\twidth: 100%;\n\theight: 100%;\n\tpointer-events: none;\n}\n\n.monaco-split-view2 > .sash-container > .monaco-sash {\n\tpointer-events: initial;\n}\n\n.monaco-split-view2 > .monaco-scrollable-element {\n\twidth: 100%;\n\theight: 100%;\n}\n\n.monaco-split-view2 > .monaco-scrollable-element > .split-view-container {\n\twidth: 100%;\n\theight: 100%;\n\twhite-space: nowrap;\n\tposition: relative;\n}\n\n.monaco-split-view2 > .monaco-scrollable-element > .split-view-container > .split-view-view {\n\twhite-space: initial;\n\tposition: absolute;\n}\n\n.monaco-split-view2 > .monaco-scrollable-element > .split-view-container > .split-view-view:not(.visible) {\n\tdisplay: none;\n}\n\n.monaco-split-view2.vertical > .monaco-scrollable-element > .split-view-container > .split-view-view {\n\twidth: 100%;\n}\n\n.monaco-split-view2.horizontal > .monaco-scrollable-element > .split-view-container > .split-view-view {\n\theight: 100%;\n}\n\n.monaco-split-view2.separator-border > .monaco-scrollable-element > .split-view-container > .split-view-view:not(:first-child)::before {\n\tcontent: ' ';\n\tposition: absolute;\n\ttop: 0;\n\tleft: 0;\n\tz-index: 5;\n\tpointer-events: none;\n\tbackground-color: var(--separator-border);\n}\n\n.monaco-split-view2.separator-border.horizontal > .monaco-scrollable-element > .split-view-container > .split-view-view:not(:first-child)::before {\n\theight: 100%;\n\twidth: 1px;\n}\n\n.monaco-split-view2.separator-border.vertical > .monaco-scrollable-element > .split-view-container > .split-view-view:not(:first-child)::before {\n\theight: 1px;\n\twidth: 100%;\n}\n",""]),t.Z=s},78590:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,'/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-table {\n\tdisplay: flex;\n\tflex-direction: column;\n\tposition: relative;\n\theight: 100%;\n\twidth: 100%;\n\twhite-space: nowrap;\n\toverflow: hidden;\n}\n\n.monaco-table > .monaco-split-view2 {\n\tborder-bottom: 1px solid transparent;\n}\n\n.monaco-table > .monaco-list {\n\tflex: 1;\n}\n\n.monaco-table-tr {\n\tdisplay: flex;\n\theight: 100%;\n}\n\n.monaco-table-th {\n\twidth: 100%;\n\theight: 100%;\n\tfont-weight: bold;\n\toverflow: hidden;\n\ttext-overflow: ellipsis;\n}\n\n.monaco-table-th,\n.monaco-table-td {\n\tbox-sizing: border-box;\n\tflex-shrink: 0;\n\toverflow: hidden;\n\twhite-space: nowrap;\n\ttext-overflow: ellipsis;\n}\n\n.monaco-table > .monaco-split-view2 .monaco-sash.vertical::before {\n\tcontent: "";\n\tposition: absolute;\n\tleft: calc(var(--vscode-sash-size) / 2);\n\twidth: 0;\n\tborder-left: 1px solid transparent;\n}\n\n.monaco-workbench:not(.reduce-motion) .monaco-table > .monaco-split-view2,\n.monaco-workbench:not(.reduce-motion) .monaco-table > .monaco-split-view2 .monaco-sash.vertical::before {\n\ttransition: border-color 0.2s ease-out;\n}\n',""]),t.Z=s},69811:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-custom-toggle {\n\tmargin-left: 2px;\n\tfloat: left;\n\tcursor: pointer;\n\toverflow: hidden;\n\twidth: 20px;\n\theight: 20px;\n\tborder-radius: 3px;\n\tborder: 1px solid transparent;\n\tpadding: 1px;\n\tbox-sizing:\tborder-box;\n\tuser-select: none;\n\t-webkit-user-select: none;\n}\n\n.monaco-custom-toggle:hover {\n\tbackground-color: var(--vscode-inputOption-hoverBackground);\n}\n\n.hc-black .monaco-custom-toggle:hover,\n.hc-light .monaco-custom-toggle:hover {\n\tborder: 1px dashed var(--vscode-focusBorder);\n}\n\n.hc-black .monaco-custom-toggle,\n.hc-light .monaco-custom-toggle {\n\tbackground: none;\n}\n\n.hc-black .monaco-custom-toggle:hover,\n.hc-light .monaco-custom-toggle:hover {\n\tbackground: none;\n}\n\n.monaco-custom-toggle.monaco-checkbox {\n\theight: 18px;\n\twidth: 18px;\n\tborder: 1px solid transparent;\n\tborder-radius: 3px;\n\tmargin-right: 9px;\n\tmargin-left: 0px;\n\tpadding: 0px;\n\topacity: 1;\n\tbackground-size: 16px !important;\n}\n\n.monaco-action-bar .checkbox-action-item {\n\tdisplay: flex;\n\talign-items: center;\n}\n\n.monaco-action-bar .checkbox-action-item > .monaco-custom-toggle.monaco-checkbox {\n\tmargin-right: 4px;\n}\n\n.monaco-action-bar .checkbox-action-item > .checkbox-label {\n\tfont-size: 12px;\n}\n\n/* hide check when unchecked */\n.monaco-custom-toggle.monaco-checkbox:not(.checked)::before {\n\tvisibility: hidden;\n}\n",""]),t.Z=s},86228:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-toolbar {\n\theight: 100%;\n}\n\n.monaco-toolbar .toolbar-toggle-more {\n\tdisplay: inline-block;\n\tpadding: 0;\n}\n",""]),t.Z=s},42650:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-tl-row {\n\tdisplay: flex;\n\theight: 100%;\n\talign-items: center;\n\tposition: relative;\n}\n\n.monaco-tl-row.disabled {\n\tcursor: default;\n}\n.monaco-tl-indent {\n\theight: 100%;\n\tposition: absolute;\n\ttop: 0;\n\tleft: 16px;\n\tpointer-events: none;\n}\n\n.hide-arrows .monaco-tl-indent {\n\tleft: 12px;\n}\n\n.monaco-tl-indent > .indent-guide {\n\tdisplay: inline-block;\n\tbox-sizing: border-box;\n\theight: 100%;\n\tborder-left: 1px solid transparent;\n}\n\n.monaco-workbench:not(.reduce-motion) .monaco-tl-indent > .indent-guide {\n\ttransition: border-color 0.1s linear;\n}\n\n.monaco-tl-twistie,\n.monaco-tl-contents {\n\theight: 100%;\n}\n\n.monaco-tl-twistie {\n\tfont-size: 10px;\n\ttext-align: right;\n\tpadding-right: 6px;\n\tflex-shrink: 0;\n\twidth: 16px;\n\tdisplay: flex !important;\n\talign-items: center;\n\tjustify-content: center;\n\ttransform: translateX(3px);\n}\n\n.monaco-tl-contents {\n\tflex: 1;\n\toverflow: hidden;\n}\n\n.monaco-tl-twistie::before {\n\tborder-radius: 20px;\n}\n\n.monaco-tl-twistie.collapsed::before {\n\ttransform: rotate(-90deg);\n}\n\n.monaco-tl-twistie.codicon-tree-item-loading::before {\n\t/* Use steps to throttle FPS to reduce CPU usage */\n\tanimation: codicon-spin 1.25s steps(30) infinite;\n}\n\n.monaco-tree-type-filter {\n\tposition: absolute;\n\ttop: 0;\n\tdisplay: flex;\n\tpadding: 3px;\n\tmax-width: 200px;\n\tz-index: 100;\n\tmargin: 0 6px;\n\tborder: 1px solid var(--vscode-widget-border);\n\tborder-bottom-left-radius: 4px;\n\tborder-bottom-right-radius: 4px;\n}\n\n.monaco-workbench:not(.reduce-motion) .monaco-tree-type-filter {\n\ttransition: top 0.3s;\n}\n\n.monaco-tree-type-filter.disabled {\n\ttop: -40px !important;\n}\n\n.monaco-tree-type-filter-grab {\n\tdisplay: flex !important;\n\talign-items: center;\n\tjustify-content: center;\n\tcursor: grab;\n\tmargin-right: 2px;\n}\n\n.monaco-tree-type-filter-grab.grabbing {\n\tcursor: grabbing;\n}\n\n.monaco-tree-type-filter-input {\n\tflex: 1;\n}\n\n.monaco-tree-type-filter-input .monaco-inputbox {\n\theight: 23px;\n}\n\n.monaco-tree-type-filter-input .monaco-inputbox > .ibwrapper > .input,\n.monaco-tree-type-filter-input .monaco-inputbox > .ibwrapper > .mirror {\n\tpadding: 2px 4px;\n}\n\n.monaco-tree-type-filter-input .monaco-findInput > .controls {\n\ttop: 2px;\n}\n\n.monaco-tree-type-filter-actionbar {\n\tmargin-left: 4px;\n}\n\n.monaco-tree-type-filter-actionbar .monaco-action-bar .action-label {\n\tpadding: 2px;\n}\n\n.monaco-list .monaco-scrollable-element .monaco-tree-sticky-container{\n\tposition: absolute;\n\ttop: 0;\n\tleft: 0;\n\twidth: 100%;\n\theight: 0;\n\tz-index: 13; /* Settings editor uses z-index: 12 */\n\n\t/* TODO@benibenj temporary solution, all lists should provide their background */\n\tbackground-color: var(--vscode-sideBar-background);\n}\n\n.monaco-list .monaco-scrollable-element .monaco-tree-sticky-container .monaco-tree-sticky-row.monaco-list-row{\n\tposition: absolute;\n\twidth: 100%;\n\topacity: 1 !important; /* Settings editor uses opacity < 1 */\n\toverflow: hidden;\n\n\t/* TODO@benibenj temporary solution, all lists should provide their background */\n\tbackground-color: var(--vscode-sideBar-background);\n}\n\n.monaco-list .monaco-scrollable-element .monaco-tree-sticky-container .monaco-tree-sticky-row:hover{\n\tbackground-color: var(--vscode-list-hoverBackground) !important;\n\tcursor: pointer;\n}\n\n.monaco-list .monaco-scrollable-element .monaco-tree-sticky-container .monaco-tree-sticky-container-shadow{\n\tposition: absolute;\n\tbottom: -3px;\n\tleft: 0px;\n\theight: 3px;\n\twidth: 100%;\n\tbox-shadow: var(--vscode-scrollbar-shadow) 0 6px 6px -6px inset;\n}\n",""]),t.Z=s},92874:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .inputarea {\n\tmin-width: 0;\n\tmin-height: 0;\n\tmargin: 0;\n\tpadding: 0;\n\tposition: absolute;\n\toutline: none !important;\n\tresize: none;\n\tborder: none;\n\toverflow: hidden;\n\tcolor: transparent;\n\tbackground-color: transparent;\n\tz-index: -10;\n}\n/*.monaco-editor .inputarea {\n\tposition: fixed !important;\n\twidth: 800px !important;\n\theight: 500px !important;\n\ttop: initial !important;\n\tleft: initial !important;\n\tbottom: 0 !important;\n\tright: 0 !important;\n\tcolor: black !important;\n\tbackground: white !important;\n\tline-height: 15px !important;\n\tfont-size: 14px !important;\n\tz-index: 10 !important;\n}*/\n.monaco-editor .inputarea.ime-input {\n\tz-index: 10;\n\tcaret-color: var(--vscode-editorCursor-foreground);\n\tcolor: var(--vscode-editor-foreground);\n}\n",""]),t.Z=s},97926:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .blockDecorations-container {\n\tposition: absolute;\n\ttop: 0;\n\tpointer-events: none;\n}\n\n.monaco-editor .blockDecorations-block {\n\tposition: absolute;\n\tbox-sizing: border-box;\n}\n",""]),t.Z=s},82958:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .view-overlays .current-line {\n\tdisplay: block;\n\tposition: absolute;\n\tleft: 0;\n\ttop: 0;\n\tbox-sizing: border-box;\n}\n\n.monaco-editor .margin-view-overlays .current-line {\n\tdisplay: block;\n\tposition: absolute;\n\tleft: 0;\n\ttop: 0;\n\tbox-sizing: border-box;\n}\n\n.monaco-editor .margin-view-overlays .current-line.current-line-margin.current-line-margin-both {\n\tborder-right: 0;\n}\n",""]),t.Z=s},3381:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n/*\n\tKeeping name short for faster parsing.\n\tcdr = core decorations rendering (div)\n*/\n.monaco-editor .lines-content .cdr {\n\tposition: absolute;\n}",""]),t.Z=s},54734:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .glyph-margin {\n\tposition: absolute;\n\ttop: 0;\n}\n\n/*\n\tKeeping name short for faster parsing.\n\tcgmr = core glyph margin rendering (div)\n*/\n.monaco-editor .glyph-margin-widgets .cgmr {\n\tposition: absolute;\n\tdisplay: flex;\n\talign-items: center;\n\tjustify-content: center;\n}\n\n/*\n\tEnsure spinning icons are pixel-perfectly centered and avoid wobble.\n\tThis is only applied to icons that spin to avoid unnecessary\n\tGPU layers and blurry subpixel AA.\n*/\n.monaco-editor .glyph-margin-widgets .cgmr.codicon-modifier-spin::before  {\n\tposition: absolute;\n\ttop: 50%;\n\tleft: 50%;\n\ttransform: translate(-50%, -50%);\n}\n",""]),t.Z=s},68467:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .lines-content .core-guide {\n\tposition: absolute;\n\tbox-sizing: border-box;\n}\n",""]),t.Z=s},8787:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .margin-view-overlays .line-numbers {\n\tfont-variant-numeric: tabular-nums;\n\tposition: absolute;\n\ttext-align: right;\n\tdisplay: inline-block;\n\tvertical-align: middle;\n\tbox-sizing: border-box;\n\tcursor: default;\n\theight: 100%;\n}\n\n.monaco-editor .relative-current-line-number {\n\ttext-align: left;\n\tdisplay: inline-block;\n\twidth: 100%;\n}\n\n.monaco-editor .margin-view-overlays .line-numbers.lh-odd {\n\tmargin-top: 1px;\n}\n\n.monaco-editor .line-numbers {\n\tcolor: var(--vscode-editorLineNumber-foreground);\n}\n\n.monaco-editor .line-numbers.active-line-number {\n\tcolor: var(--vscode-editorLineNumber-activeForeground);\n}\n",""]),t.Z=s},17734:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n.monaco-editor .lines-decorations {\n\tposition: absolute;\n\ttop: 0;\n\tbackground: white;\n}\n\n/*\n\tKeeping name short for faster parsing.\n\tcldr = core lines decorations rendering (div)\n*/\n.monaco-editor .margin-view-overlays .cldr {\n\tposition: absolute;\n\theight: 100%;\n}",""]),t.Z=s},31192:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n/* Uncomment to see lines flashing when they're painted */\n/*.monaco-editor .view-lines > .view-line {\n\tbackground-color: none;\n\tanimation-name: flash-background;\n\tanimation-duration: 800ms;\n}\n@keyframes flash-background {\n\t0%   { background-color: lightgreen; }\n\t100% { background-color: none }\n}*/\n\n.mtkcontrol {\n\tcolor: rgb(255, 255, 255) !important;\n\tbackground: rgb(150, 0, 0) !important;\n}\n\n.mtkoverflow {\n\tbackground-color: var(--vscode-button-background, var(--vscode-editor-background));\n\tcolor: var(--vscode-button-foreground, var(--vscode-editor-foreground));\n\tborder-width: 1px;\n\tborder-style: solid;\n\tborder-color: var(--vscode-contrastBorder);\n\tborder-radius: 2px;\n\tpadding: 4px;\n\tcursor: pointer;\n}\n.mtkoverflow:hover {\n\tbackground-color: var(--vscode-button-hoverBackground);\n}\n\n.monaco-editor.no-user-select .lines-content,\n.monaco-editor.no-user-select .view-line,\n.monaco-editor.no-user-select .view-lines {\n\tuser-select: none;\n\t-webkit-user-select: none;\n}\n/* Use user-select: text for lookup feature on macOS */\n/* https://github.com/microsoft/vscode/issues/85632 */\n.monaco-editor.mac .lines-content:hover,\n.monaco-editor.mac .view-line:hover,\n.monaco-editor.mac .view-lines:hover {\n\tuser-select: text;\n\t-webkit-user-select: text;\n\t-ms-user-select: text;\n}\n\n.monaco-editor.enable-user-select {\n\tuser-select: initial;\n\t-webkit-user-select: initial;\n}\n\n.monaco-editor .view-lines {\n\twhite-space: nowrap;\n}\n\n.monaco-editor .view-line {\n\tposition: absolute;\n\twidth: 100%;\n}\n\n.monaco-editor .mtkw {\n\tcolor: var(--vscode-editorWhitespace-foreground) !important;\n}\n\n.monaco-editor .mtkz {\n\tdisplay: inline-block;\n\tcolor: var(--vscode-editorWhitespace-foreground) !important;\n}\n\n/* TODO@tokenization bootstrap fix */\n/*.monaco-editor .view-line > span > span {\n\tfloat: none;\n\tmin-height: inherit;\n\tmargin-left: inherit;\n}*/\n",""]),t.Z=s},92762:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n/*\n\tKeeping name short for faster parsing.\n\tcmdr = core margin decorations rendering (div)\n*/\n.monaco-editor .margin-view-overlays .cmdr {\n\tposition: absolute;\n\tleft: 0;\n\twidth: 100%;\n\theight: 100%;\n}",""]),t.Z=s},42754:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .margin {\n\tbackground-color: var(--vscode-editorGutter-background);\n}\n",""]),t.Z=s},75278:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n/* START cover the case that slider is visible on mouseover */\n.monaco-editor .minimap.slider-mouseover .minimap-slider {\n\topacity: 0;\n\ttransition: opacity 100ms linear;\n}\n.monaco-editor .minimap.slider-mouseover:hover .minimap-slider {\n\topacity: 1;\n}\n.monaco-editor .minimap.slider-mouseover .minimap-slider.active {\n\topacity: 1;\n}\n/* END cover the case that slider is visible on mouseover */\n.monaco-editor .minimap-slider .minimap-slider-horizontal {\n\tbackground: var(--vscode-minimapSlider-background);\n}\n.monaco-editor .minimap-slider:hover .minimap-slider-horizontal {\n\tbackground: var(--vscode-minimapSlider-hoverBackground);\n}\n.monaco-editor .minimap-slider.active .minimap-slider-horizontal {\n\tbackground: var(--vscode-minimapSlider-activeBackground);\n}\n.monaco-editor .minimap-shadow-visible {\n\tbox-shadow: var(--vscode-scrollbar-shadow) -6px 0 6px -6px inset;\n}\n.monaco-editor .minimap-shadow-hidden {\n\tposition: absolute;\n\twidth: 0;\n}\n.monaco-editor .minimap-shadow-visible {\n\tposition: absolute;\n\tleft: -6px;\n\twidth: 6px;\n}\n.monaco-editor.no-minimap-shadow .minimap-shadow-visible {\n\tposition: absolute;\n\tleft: -1px;\n\twidth: 1px;\n}\n\n/* 0.5s fade in/out for the minimap */\n.minimap.autohide {\n\topacity: 0;\n\ttransition: opacity 0.5s;\n}\n.minimap.autohide:hover {\n\topacity: 1;\n}\n\n.monaco-editor .minimap {\n\tz-index: 5;\n}\n",""]),t.Z=s},28096:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n.monaco-editor .overlayWidgets {\n\tposition: absolute;\n\ttop: 0;\n\tleft:0;\n}",""]),t.Z=s},10657:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .view-ruler {\n\tposition: absolute;\n\ttop: 0;\n\tbox-shadow: 1px 0 0 0 var(--vscode-editorRuler-foreground) inset;\n}\n",""]),t.Z=s},71039:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .scroll-decoration {\n\tposition: absolute;\n\ttop: 0;\n\tleft: 0;\n\theight: 6px;\n\tbox-shadow: var(--vscode-scrollbar-shadow) 0 6px 6px -6px inset;\n}\n",""]),t.Z=s},58297:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n/*\n\tKeeping name short for faster parsing.\n\tcslr = core selections layer rendering (div)\n*/\n.monaco-editor .lines-content .cslr {\n\tposition: absolute;\n}\n\n.monaco-editor .focused .selected-text {\n\tbackground-color: var(--vscode-editor-selectionBackground);\n}\n\n.monaco-editor .selected-text {\n\tbackground-color: var(--vscode-editor-inactiveSelectionBackground);\n}\n\n.monaco-editor\t\t\t.top-left-radius\t\t{ border-top-left-radius: 3px; }\n.monaco-editor\t\t\t.bottom-left-radius\t\t{ border-bottom-left-radius: 3px; }\n.monaco-editor\t\t\t.top-right-radius\t\t{ border-top-right-radius: 3px; }\n.monaco-editor\t\t\t.bottom-right-radius\t{ border-bottom-right-radius: 3px; }\n\n.monaco-editor.hc-black .top-left-radius\t\t{ border-top-left-radius: 0; }\n.monaco-editor.hc-black .bottom-left-radius\t\t{ border-bottom-left-radius: 0; }\n.monaco-editor.hc-black .top-right-radius\t\t{ border-top-right-radius: 0; }\n.monaco-editor.hc-black .bottom-right-radius\t{ border-bottom-right-radius: 0; }\n\n.monaco-editor.hc-light .top-left-radius\t\t{ border-top-left-radius: 0; }\n.monaco-editor.hc-light .bottom-left-radius\t\t{ border-bottom-left-radius: 0; }\n.monaco-editor.hc-light .top-right-radius\t\t{ border-top-right-radius: 0; }\n.monaco-editor.hc-light .bottom-right-radius\t{ border-bottom-right-radius: 0; }\n",""]),t.Z=s},64115:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n.monaco-editor .cursors-layer {\n\tposition: absolute;\n\ttop: 0;\n}\n\n.monaco-editor .cursors-layer > .cursor {\n\tposition: absolute;\n\toverflow: hidden;\n\tbox-sizing: border-box;\n}\n\n/* -- smooth-caret-animation -- */\n.monaco-editor .cursors-layer.cursor-smooth-caret-animation > .cursor {\n\ttransition: all 80ms;\n}\n\n/* -- block-outline-style -- */\n.monaco-editor .cursors-layer.cursor-block-outline-style > .cursor {\n\tbackground: transparent !important;\n\tborder-style: solid;\n\tborder-width: 1px;\n}\n\n/* -- underline-style -- */\n.monaco-editor .cursors-layer.cursor-underline-style > .cursor {\n\tborder-bottom-width: 2px;\n\tborder-bottom-style: solid;\n\tbackground: transparent !important;\n}\n\n/* -- underline-thin-style -- */\n.monaco-editor .cursors-layer.cursor-underline-thin-style > .cursor {\n\tborder-bottom-width: 1px;\n\tborder-bottom-style: solid;\n\tbackground: transparent !important;\n}\n\n@keyframes monaco-cursor-smooth {\n\t0%,\n\t20% {\n\t\topacity: 1;\n\t}\n\t60%,\n\t100% {\n\t\topacity: 0;\n\t}\n}\n\n@keyframes monaco-cursor-phase {\n\t0%,\n\t20% {\n\t\topacity: 1;\n\t}\n\t90%,\n\t100% {\n\t\topacity: 0;\n\t}\n}\n\n@keyframes monaco-cursor-expand {\n\t0%,\n\t20% {\n\t\ttransform: scaleY(1);\n\t}\n\t80%,\n\t100% {\n\t\ttransform: scaleY(0);\n\t}\n}\n\n.cursor-smooth {\n\tanimation: monaco-cursor-smooth 0.5s ease-in-out 0s 20 alternate;\n}\n\n.cursor-phase {\n\tanimation: monaco-cursor-phase 0.5s ease-in-out 0s 20 alternate;\n}\n\n.cursor-expand > .cursor {\n\tanimation: monaco-cursor-expand 0.5s ease-in-out 0s 20 alternate;\n}\n",""]),t.Z=s},91448:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .mwh {\n\tposition: absolute;\n\tcolor: var(--vscode-editorWhitespace-foreground) !important;\n}\n",""]),t.Z=s},2089:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-diff-editor .diff-review-line-number {\n\ttext-align: right;\n\tdisplay: inline-block;\n\tcolor: var(--vscode-editorLineNumber-foreground);\n}\n\n.monaco-diff-editor .diff-review {\n\tposition: absolute;\n\tuser-select: none;\n\t-webkit-user-select: none;\n\tz-index: 99;\n}\n\n.monaco-diff-editor .diff-review-summary {\n\tpadding-left: 10px;\n}\n\n.monaco-diff-editor .diff-review-shadow {\n\tposition: absolute;\n\tbox-shadow: var(--vscode-scrollbar-shadow) 0 -6px 6px -6px inset;\n}\n\n.monaco-diff-editor .diff-review-row {\n\twhite-space: pre;\n}\n\n.monaco-diff-editor .diff-review-table {\n\tdisplay: table;\n\tmin-width: 100%;\n}\n\n.monaco-diff-editor .diff-review-row {\n\tdisplay: table-row;\n\twidth: 100%;\n}\n\n.monaco-diff-editor .diff-review-spacer {\n\tdisplay: inline-block;\n\twidth: 10px;\n\tvertical-align: middle;\n}\n\n.monaco-diff-editor .diff-review-spacer > .codicon {\n\tfont-size: 9px !important;\n}\n\n.monaco-diff-editor .diff-review-actions {\n\tdisplay: inline-block;\n\tposition: absolute;\n\tright: 10px;\n\ttop: 2px;\n\tz-index: 100;\n}\n\n.monaco-diff-editor .diff-review-actions .action-label {\n\twidth: 16px;\n\theight: 16px;\n\tmargin: 2px 0;\n}\n\n.monaco-diff-editor .revertButton {\n\tcursor: pointer;\n}\n",""]),t.Z=s},46906:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .diff-hidden-lines-widget {\n\twidth: 100%;\n}\n\n.monaco-editor .diff-hidden-lines {\n\theight: 0px; /* The children each have a fixed height, the transform confuses the browser */\n\ttransform: translate(0px, -10px);\n\tfont-size: 13px;\n\tline-height: 14px;\n}\n\n.monaco-editor .diff-hidden-lines:not(.dragging) .top:hover,\n.monaco-editor .diff-hidden-lines:not(.dragging) .bottom:hover,\n.monaco-editor .diff-hidden-lines .top.dragging,\n.monaco-editor .diff-hidden-lines .bottom.dragging {\n\tbackground-color: var(--vscode-focusBorder);\n}\n\n.monaco-editor .diff-hidden-lines .top,\n.monaco-editor .diff-hidden-lines .bottom {\n\ttransition: background-color 0.1s ease-out;\n\theight: 4px;\n\tbackground-color: transparent;\n\tbackground-clip: padding-box;\n\tborder-bottom: 2px solid transparent;\n\tborder-top: 4px solid transparent;\n\t/*cursor: n-resize;*/\n}\n\n.monaco-editor.draggingUnchangedRegion.canMoveTop:not(.canMoveBottom) *,\n.monaco-editor .diff-hidden-lines .top.canMoveTop:not(.canMoveBottom),\n.monaco-editor .diff-hidden-lines .bottom.canMoveTop:not(.canMoveBottom) {\n\tcursor: n-resize !important;\n}\n\n.monaco-editor.draggingUnchangedRegion:not(.canMoveTop).canMoveBottom *,\n.monaco-editor .diff-hidden-lines .top:not(.canMoveTop).canMoveBottom,\n.monaco-editor .diff-hidden-lines .bottom:not(.canMoveTop).canMoveBottom {\n\tcursor: s-resize !important;\n}\n\n.monaco-editor.draggingUnchangedRegion.canMoveTop.canMoveBottom *,\n.monaco-editor .diff-hidden-lines .top.canMoveTop.canMoveBottom,\n.monaco-editor .diff-hidden-lines .bottom.canMoveTop.canMoveBottom {\n\tcursor: ns-resize !important;\n}\n\n.monaco-editor .diff-hidden-lines .top {\n\ttransform: translate(0px, 4px);\n}\n\n.monaco-editor .diff-hidden-lines .bottom {\n\ttransform: translate(0px, -6px);\n}\n\n.monaco-editor .diff-unchanged-lines {\n\tbackground: var(--vscode-diffEditor-unchangedCodeBackground);\n}\n\n.monaco-editor .noModificationsOverlay {\n\tz-index: 1;\n\tbackground: var(--vscode-editor-background);\n\n\tdisplay: flex;\n\tjustify-content: center;\n\talign-items: center;\n}\n\n\n.monaco-editor .diff-hidden-lines .center {\n\tbackground: var(--vscode-diffEditor-unchangedRegionBackground);\n\tcolor: var(--vscode-diffEditor-unchangedRegionForeground);\n\toverflow: hidden;\n\tdisplay: block;\n\ttext-overflow: ellipsis;\n\twhite-space: nowrap;\n\n\theight: 24px;\n\tbox-shadow: inset 0 -5px 5px -7px var(--vscode-diffEditor-unchangedRegionShadow), inset 0 5px 5px -7px var(--vscode-diffEditor-unchangedRegionShadow);\n}\n\n.monaco-editor .diff-hidden-lines .center span.codicon {\n\tvertical-align: middle;\n}\n\n.monaco-editor .diff-hidden-lines .center a:hover .codicon {\n\tcursor: pointer;\n\tcolor: var(--vscode-editorLink-activeForeground) !important;\n}\n\n.monaco-editor .diff-hidden-lines div.breadcrumb-item {\n\tcursor: pointer;\n}\n\n.monaco-editor .diff-hidden-lines div.breadcrumb-item:hover {\n\tcolor: var(--vscode-editorLink-activeForeground);\n}\n\n.monaco-editor .movedOriginal {\n\tborder: 2px solid var(--vscode-diffEditor-move-border);\n}\n\n.monaco-editor .movedModified {\n\tborder: 2px solid var(--vscode-diffEditor-move-border);\n}\n\n.monaco-editor .movedOriginal.currentMove, .monaco-editor .movedModified.currentMove {\n\tborder: 2px solid var(--vscode-diffEditor-moveActive-border);\n}\n\n.monaco-diff-editor .moved-blocks-lines path.currentMove {\n\tstroke: var(--vscode-diffEditor-moveActive-border);\n}\n\n.monaco-diff-editor .moved-blocks-lines path {\n\tpointer-events: visiblestroke;\n}\n\n.monaco-diff-editor .moved-blocks-lines .arrow {\n\tfill: var(--vscode-diffEditor-move-border);\n}\n\n.monaco-diff-editor .moved-blocks-lines .arrow.currentMove {\n\tfill: var(--vscode-diffEditor-moveActive-border);\n}\n\n.monaco-diff-editor .moved-blocks-lines .arrow-rectangle {\n\tfill: var(--vscode-editor-background);\n}\n\n.monaco-diff-editor .moved-blocks-lines {\n\tposition: absolute;\n\tpointer-events: none;\n}\n\n.monaco-diff-editor .moved-blocks-lines path {\n\tfill: none;\n\tstroke: var(--vscode-diffEditor-move-border);\n\tstroke-width: 2;\n}\n\n.monaco-editor .char-delete.diff-range-empty {\n\tmargin-left: -1px;\n\tborder-left: solid var(--vscode-diffEditor-removedTextBackground) 3px;\n}\n\n.monaco-editor .char-insert.diff-range-empty {\n\tborder-left: solid var(--vscode-diffEditor-insertedTextBackground) 3px;\n}\n\n.monaco-editor .fold-unchanged {\n\tcursor: pointer;\n}\n\n.monaco-diff-editor .diff-moved-code-block {\n\tdisplay: flex;\n\tjustify-content: flex-end;\n\tmargin-top: -4px;\n}\n\n.monaco-diff-editor .diff-moved-code-block .action-bar .action-label.codicon {\n\twidth: 12px;\n\theight: 12px;\n\tfont-size: 12px;\n}\n\n/* ---------- DiffEditor ---------- */\n\n.monaco-diff-editor .diffOverview {\n\tz-index: 9;\n}\n\n.monaco-diff-editor .diffOverview .diffViewport {\n\tz-index: 10;\n}\n\n/* colors not externalized: using transparancy on background */\n.monaco-diff-editor.vs\t\t\t.diffOverview { background: rgba(0, 0, 0, 0.03); }\n.monaco-diff-editor.vs-dark\t\t.diffOverview { background: rgba(255, 255, 255, 0.01); }\n\n.monaco-scrollable-element.modified-in-monaco-diff-editor.vs\t\t.scrollbar { background: rgba(0,0,0,0); }\n.monaco-scrollable-element.modified-in-monaco-diff-editor.vs-dark\t.scrollbar { background: rgba(0,0,0,0); }\n.monaco-scrollable-element.modified-in-monaco-diff-editor.hc-black\t.scrollbar { background: none; }\n.monaco-scrollable-element.modified-in-monaco-diff-editor.hc-light\t.scrollbar { background: none; }\n\n.monaco-scrollable-element.modified-in-monaco-diff-editor .slider {\n\tz-index: 10;\n}\n.modified-in-monaco-diff-editor\t\t\t\t.slider.active { background: rgba(171, 171, 171, .4); }\n.modified-in-monaco-diff-editor.hc-black\t.slider.active { background: none; }\n.modified-in-monaco-diff-editor.hc-light\t.slider.active { background: none; }\n\n/* ---------- Diff ---------- */\n\n.monaco-editor .insert-sign,\n.monaco-diff-editor .insert-sign,\n.monaco-editor .delete-sign,\n.monaco-diff-editor .delete-sign {\n\tfont-size: 11px !important;\n\topacity: 0.7 !important;\n\tdisplay: flex !important;\n\talign-items: center;\n}\n.monaco-editor.hc-black .insert-sign,\n.monaco-diff-editor.hc-black .insert-sign,\n.monaco-editor.hc-black .delete-sign,\n.monaco-diff-editor.hc-black .delete-sign,\n.monaco-editor.hc-light .insert-sign,\n.monaco-diff-editor.hc-light .insert-sign,\n.monaco-editor.hc-light .delete-sign,\n.monaco-diff-editor.hc-light .delete-sign {\n\topacity: 1;\n}\n\n.monaco-editor .inline-deleted-margin-view-zone {\n\ttext-align: right;\n}\n.monaco-editor .inline-added-margin-view-zone {\n\ttext-align: right;\n}\n\n.monaco-editor .arrow-revert-change {\n\tz-index: 10;\n\tposition: absolute;\n}\n\n.monaco-editor .arrow-revert-change:hover {\n\tcursor: pointer;\n}\n\n/* ---------- Inline Diff ---------- */\n\n.monaco-editor .view-zones .view-lines .view-line span {\n\tdisplay: inline-block;\n}\n\n.monaco-editor .margin-view-zones .lightbulb-glyph:hover {\n\tcursor: pointer;\n}\n\n.monaco-editor .char-insert, .monaco-diff-editor .char-insert {\n\tbackground-color: var(--vscode-diffEditor-insertedTextBackground);\n}\n\n.monaco-editor .line-insert, .monaco-diff-editor .line-insert {\n\tbackground-color: var(--vscode-diffEditor-insertedLineBackground, var(--vscode-diffEditor-insertedTextBackground));\n}\n\n.monaco-editor .line-insert,\n.monaco-editor .char-insert {\n\tbox-sizing: border-box;\n\tborder: 1px solid var(--vscode-diffEditor-insertedTextBorder);\n}\n.monaco-editor.hc-black .line-insert, .monaco-editor.hc-light .line-insert,\n.monaco-editor.hc-black .char-insert, .monaco-editor.hc-light .char-insert {\n\tborder-style: dashed;\n}\n\n.monaco-editor .line-delete,\n.monaco-editor .char-delete {\n\tbox-sizing: border-box;\n\tborder: 1px solid var(--vscode-diffEditor-removedTextBorder);\n}\n.monaco-editor.hc-black .line-delete, .monaco-editor.hc-light .line-delete,\n.monaco-editor.hc-black .char-delete, .monaco-editor.hc-light .char-delete {\n\tborder-style: dashed;\n}\n\n.monaco-editor .inline-added-margin-view-zone,\n.monaco-editor .gutter-insert, .monaco-diff-editor .gutter-insert {\n\tbackground-color: var(--vscode-diffEditorGutter-insertedLineBackground, var(--vscode-diffEditor-insertedLineBackground), var(--vscode-diffEditor-insertedTextBackground));\n}\n\n.monaco-editor .char-delete, .monaco-diff-editor .char-delete {\n\tbackground-color: var(--vscode-diffEditor-removedTextBackground);\n}\n\n.monaco-editor .line-delete, .monaco-diff-editor .line-delete {\n\tbackground-color: var(--vscode-diffEditor-removedLineBackground, var(--vscode-diffEditor-removedTextBackground));\n}\n\n.monaco-editor .inline-deleted-margin-view-zone,\n.monaco-editor .gutter-delete, .monaco-diff-editor .gutter-delete {\n\tbackground-color: var(--vscode-diffEditorGutter-removedLineBackground, var(--vscode-diffEditor-removedLineBackground), var(--vscode-diffEditor-removedTextBackground));\n}\n\n.monaco-diff-editor.side-by-side .editor.modified {\n\tbox-shadow: -6px 0 5px -5px var(--vscode-scrollbar-shadow);\n\tborder-left: 1px solid var(--vscode-diffEditor-border);\n}\n\n.monaco-diff-editor .diffViewport {\n\tbackground: var(--vscode-scrollbarSlider-background);\n}\n\n.monaco-diff-editor .diffViewport:hover {\n\tbackground: var(--vscode-scrollbarSlider-hoverBackground);\n}\n\n.monaco-diff-editor .diffViewport:active {\n\tbackground: var(--vscode-scrollbarSlider-activeBackground);\n}\n\n.monaco-editor .diagonal-fill {\n\tbackground-image: linear-gradient(\n\t\t-45deg,\n\t\tvar(--vscode-diffEditor-diagonalFill) 12.5%,\n\t\t#0000 12.5%, #0000 50%,\n\t\tvar(--vscode-diffEditor-diagonalFill) 50%, var(--vscode-diffEditor-diagonalFill) 62.5%,\n\t\t#0000 62.5%, #0000 100%\n\t);\n\tbackground-size: 8px 8px;\n}\n",""]),t.Z=s},67691:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n/* -------------------- IE10 remove auto clear button -------------------- */\n\n::-ms-clear {\n\tdisplay: none;\n}\n\n/* All widgets */\n/* I am not a big fan of this rule */\n.monaco-editor .editor-widget input {\n\tcolor: inherit;\n}\n\n/* -------------------- Editor -------------------- */\n\n.monaco-editor {\n\tposition: relative;\n\toverflow: visible;\n\t-webkit-text-size-adjust: 100%;\n\tcolor: var(--vscode-editor-foreground);\n\tbackground-color: var(--vscode-editor-background);\n}\n.monaco-editor-background {\n\tbackground-color: var(--vscode-editor-background);\n}\n.monaco-editor .rangeHighlight {\n\tbackground-color: var(--vscode-editor-rangeHighlightBackground);\n\tbox-sizing: border-box;\n\tborder: 1px solid var(--vscode-editor-rangeHighlightBorder);\n}\n.monaco-editor.hc-black .rangeHighlight, .monaco-editor.hc-light .rangeHighlight {\n\tborder-style: dotted;\n}\n.monaco-editor .symbolHighlight {\n\tbackground-color: var(--vscode-editor-symbolHighlightBackground);\n\tbox-sizing: border-box;\n\tborder: 1px solid var(--vscode-editor-symbolHighlightBorder);\n}\n.monaco-editor.hc-black .symbolHighlight, .monaco-editor.hc-light .symbolHighlight {\n\tborder-style: dotted;\n}\n\n/* -------------------- Misc -------------------- */\n\n.monaco-editor .overflow-guard {\n\tposition: relative;\n\toverflow: hidden;\n}\n\n.monaco-editor .view-overlays {\n\tposition: absolute;\n\ttop: 0;\n}\n\n/*\n.monaco-editor .auto-closed-character {\n\topacity: 0.3;\n}\n*/\n\n\n.monaco-editor .squiggly-error {\n\tborder-bottom: 4px double var(--vscode-editorError-border);\n}\n.monaco-editor .squiggly-error::before {\n\tdisplay: block;\n\tcontent: '';\n\twidth: 100%;\n\theight: 100%;\n\tbackground: var(--vscode-editorError-background);\n}\n.monaco-editor .squiggly-warning {\n\tborder-bottom: 4px double var(--vscode-editorWarning-border);\n}\n.monaco-editor .squiggly-warning::before {\n\tdisplay: block;\n\tcontent: '';\n\twidth: 100%;\n\theight: 100%;\n\tbackground: var(--vscode-editorWarning-background);\n}\n.monaco-editor .squiggly-info {\n\tborder-bottom: 4px double var(--vscode-editorInfo-border);\n}\n.monaco-editor .squiggly-info::before {\n\tdisplay: block;\n\tcontent: '';\n\twidth: 100%;\n\theight: 100%;\n\tbackground: var(--vscode-editorInfo-background);\n}\n.monaco-editor .squiggly-hint {\n\tborder-bottom: 2px dotted var(--vscode-editorHint-border);\n}\n.monaco-editor.showUnused .squiggly-unnecessary {\n\tborder-bottom: 2px dashed var(--vscode-editorUnnecessaryCode-border);\n}\n.monaco-editor.showDeprecated .squiggly-inline-deprecated {\n\ttext-decoration: line-through;\n\ttext-decoration-color: var(--vscode-editor-foreground, inherit);\n}\n",""]),t.Z=s},51333:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-component .multiDiffEntry {\n\tdisplay: flex;\n\tflex-direction: column;\n}\n\n.monaco-component .multiDiffEntry .editorParent {\n\tborder-left: 2px var(--vscode-tab-inactiveBackground) solid;\n}\n\n.monaco-component .multiDiffEntry.focused .editorParent {\n\tborder-left: 2px var(--vscode-notebook-focusedCellBorder) solid;\n}\n\n.monaco-component .multiDiffEntry .editorParent .editorContainer {\n\tborder-left: 17px var(--vscode-tab-inactiveBackground) solid;\n}\n\n.monaco-component .multiDiffEntry .collapse-button {\n\tmargin: 0 5px;\n\tcursor: pointer;\n}\n\n.monaco-component .multiDiffEntry .collapse-button a {\n\tdisplay: block;\n}\n\n.monaco-component .multiDiffEntry .header {\n\tdisplay: flex;\n\talign-items: center;\n\tpadding: 8px 5px;\n\tcolor: var(--vscode-foreground);\n\tbackground: var(--vscode-editor-background);\n\tz-index: 1000;\n\n\tborder-bottom: 1px  var(--vscode-sideBarSectionHeader-border) solid;\n\tborder-top: 1px  var(--vscode-sideBarSectionHeader-border) solid;\n\n\tborder-left: 2px var(--vscode-editor-background) solid;\n}\n.monaco-component .multiDiffEntry.focused .header {\n\tborder-left: 2px var(--vscode-notebook-focusedCellBorder) solid;\n}\n\n.monaco-component .multiDiffEntry .header.shadow {\n\tbox-shadow: var(--vscode-scrollbar-shadow) 0px 6px 6px -6px;\n}\n\n.monaco-component .multiDiffEntry .header .title {\n\tflex: 1;\n\tfont-size: 14px;\n\tline-height: 22px;\n}\n\n.monaco-component .multiDiffEntry .header .actions {\n\tpadding: 0 8px;\n}\n",""]),t.Z=s},84170:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .selection-anchor {\n\tbackground-color: #007ACC;\n\twidth: 2px !important;\n}\n",""]),t.Z=s},73809:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .bracket-match {\n\tbox-sizing: border-box;\n\tbackground-color: var(--vscode-editorBracketMatch-background);\n\tborder: 1px solid var(--vscode-editorBracketMatch-border);\n}\n",""]),t.Z=s},36501:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .lightBulbWidget {\n\tdisplay: flex;\n\talign-items: center;\n\tjustify-content: center;\n}\n\n.monaco-editor .lightBulbWidget:hover{\n\tcursor: pointer;\n}\n\n.monaco-editor .lightBulbWidget.codicon-light-bulb,\n.monaco-editor .lightBulbWidget.codicon-lightbulb-sparkle {\n\tcolor: var(--vscode-editorLightBulb-foreground);\n}\n\n.monaco-editor .lightBulbWidget.codicon-lightbulb-autofix,\n.monaco-editor .lightBulbWidget.codicon-lightbulb-sparkle-autofix {\n\tcolor: var(--vscode-editorLightBulbAutoFix-foreground, var(--vscode-editorLightBulb-foreground));\n}\n\n.monaco-editor .lightBulbWidget.codicon-sparkle-filled {\n\tcolor: var(--vscode-editorLightBulbAi-foreground, var(--vscode-icon-foreground));\n}\n\n.monaco-editor .lightBulbWidget:before {\n\tposition: relative;\n\tz-index: 2;\n}\n\n.monaco-editor .lightBulbWidget:after {\n\tposition: absolute;\n\ttop: 0;\n\tleft: 0;\n\tcontent: '';\n\tdisplay: block;\n\twidth: 100%;\n\theight: 100%;\n\topacity: 0.3;\n\tbackground-color: var(--vscode-editor-background);\n\tz-index: 1;\n}\n",""]),t.Z=s},93820:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .codelens-decoration {\n\toverflow: hidden;\n\tdisplay: inline-block;\n\ttext-overflow: ellipsis;\n\twhite-space: nowrap;\n\tcolor: var(--vscode-editorCodeLens-foreground);\n\tline-height: var(--vscode-editorCodeLens-lineHeight);\n\tfont-size: var(--vscode-editorCodeLens-fontSize);\n\tpadding-right: calc(var(--vscode-editorCodeLens-fontSize)*0.5);\n\tfont-feature-settings: var(--vscode-editorCodeLens-fontFeatureSettings);\n\tfont-family: var(--vscode-editorCodeLens-fontFamily), var(--vscode-editorCodeLens-fontFamilyDefault);\n}\n\n.monaco-editor .codelens-decoration>span,\n.monaco-editor .codelens-decoration>a {\n\tuser-select: none;\n\t-webkit-user-select: none;\n\twhite-space: nowrap;\n\tvertical-align: sub;\n}\n\n.monaco-editor .codelens-decoration>a {\n\ttext-decoration: none;\n}\n\n.monaco-editor .codelens-decoration>a:hover {\n\tcursor: pointer;\n\tcolor: var(--vscode-editorLink-activeForeground) !important;\n}\n\n.monaco-editor .codelens-decoration>a:hover .codicon {\n\tcolor: var(--vscode-editorLink-activeForeground) !important;\n}\n\n.monaco-editor .codelens-decoration .codicon {\n\tvertical-align: middle;\n\tcolor: currentColor !important;\n\tcolor: var(--vscode-editorCodeLens-foreground);\n\tline-height: var(--vscode-editorCodeLens-lineHeight);\n\tfont-size: var(--vscode-editorCodeLens-fontSize);\n}\n\n.monaco-editor .codelens-decoration>a:hover .codicon::before {\n\tcursor: pointer;\n}\n\n@keyframes fadein {\n\t0% {\n\t\topacity: 0;\n\t\tvisibility: visible;\n\t}\n\n\t100% {\n\t\topacity: 1;\n\t}\n}\n\n.monaco-editor .codelens-decoration.fadein {\n\tanimation: fadein 0.1s linear;\n}\n",""]),t.Z=s},64194:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r),a=i(61667),l=i.n(a),c=new URL(i(94748),i.b),d=s()(o()),u=l()(c);d.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.colorpicker-widget {\n\theight: 190px;\n\tuser-select: none;\n\t-webkit-user-select: none;\n}\n\n/* Decoration */\n\n.colorpicker-color-decoration,\n.hc-light .colorpicker-color-decoration {\n\tborder: solid 0.1em #000;\n\tbox-sizing: border-box;\n\tmargin: 0.1em 0.2em 0 0.2em;\n\twidth: 0.8em;\n\theight: 0.8em;\n\tline-height: 0.8em;\n\tdisplay: inline-block;\n\tcursor: pointer;\n}\n\n.hc-black .colorpicker-color-decoration,\n.vs-dark .colorpicker-color-decoration {\n\tborder: solid 0.1em #eee;\n}\n\n/* Header */\n\n.colorpicker-header {\n\tdisplay: flex;\n\theight: 24px;\n\tposition: relative;\n\tbackground: url("+u+");\n\tbackground-size: 9px 9px;\n\timage-rendering: pixelated;\n}\n\n.colorpicker-header .picked-color {\n\twidth: 240px;\n\tdisplay: flex;\n\talign-items: center;\n\tjustify-content: center;\n\tline-height: 24px;\n\tcursor: pointer;\n\tcolor: white;\n\tflex: 1;\n\twhite-space: nowrap;\n\toverflow: hidden;\n}\n\n.colorpicker-header .picked-color .picked-color-presentation {\n\twhite-space: nowrap;\n\tmargin-left: 5px;\n\tmargin-right: 5px;\n}\n\n.colorpicker-header .picked-color .codicon {\n\tcolor: inherit;\n\tfont-size: 14px;\n}\n\n.colorpicker-header .picked-color.light {\n\tcolor: black;\n}\n\n.colorpicker-header .original-color {\n\twidth: 74px;\n\tz-index: inherit;\n\tcursor: pointer;\n}\n\n.standalone-colorpicker {\n\tcolor: var(--vscode-editorHoverWidget-foreground);\n\tbackground-color: var(--vscode-editorHoverWidget-background);\n\tborder: 1px solid var(--vscode-editorHoverWidget-border);\n}\n\n.colorpicker-header.standalone-colorpicker {\n\tborder-bottom: none;\n}\n\n.colorpicker-header .close-button {\n\tcursor: pointer;\n\tbackground-color: var(--vscode-editorHoverWidget-background);\n\tborder-left: 1px solid var(--vscode-editorHoverWidget-border);\n}\n\n.colorpicker-header .close-button-inner-div {\n\twidth: 100%;\n\theight: 100%;\n\ttext-align: center;\n}\n\n.colorpicker-header .close-button-inner-div:hover {\n\tbackground-color: var(--vscode-toolbar-hoverBackground);\n}\n\n.colorpicker-header .close-icon {\n\tpadding: 3px;\n}\n\n/* Body */\n\n.colorpicker-body {\n\tdisplay: flex;\n\tpadding: 8px;\n\tposition: relative;\n}\n\n.colorpicker-body .saturation-wrap {\n\toverflow: hidden;\n\theight: 150px;\n\tposition: relative;\n\tmin-width: 220px;\n\tflex: 1;\n}\n\n.colorpicker-body .saturation-box {\n\theight: 150px;\n\tposition: absolute;\n}\n\n.colorpicker-body .saturation-selection {\n\twidth: 9px;\n\theight: 9px;\n\tmargin: -5px 0 0 -5px;\n\tborder: 1px solid rgb(255, 255, 255);\n\tborder-radius: 100%;\n\tbox-shadow: 0px 0px 2px rgba(0, 0, 0, 0.8);\n\tposition: absolute;\n}\n\n.colorpicker-body .strip {\n\twidth: 25px;\n\theight: 150px;\n}\n\n.colorpicker-body .standalone-strip {\n\twidth: 25px;\n\theight: 122px;\n}\n\n.colorpicker-body .hue-strip {\n\tposition: relative;\n\tmargin-left: 8px;\n\tcursor: grab;\n\tbackground: linear-gradient(to bottom, #ff0000 0%, #ffff00 17%, #00ff00 33%, #00ffff 50%, #0000ff 67%, #ff00ff 83%, #ff0000 100%);\n}\n\n.colorpicker-body .opacity-strip {\n\tposition: relative;\n\tmargin-left: 8px;\n\tcursor: grab;\n\tbackground: url("+u+");\n\tbackground-size: 9px 9px;\n\timage-rendering: pixelated;\n}\n\n.colorpicker-body .strip.grabbing {\n\tcursor: grabbing;\n}\n\n.colorpicker-body .slider {\n\tposition: absolute;\n\ttop: 0;\n\tleft: -2px;\n\twidth: calc(100% + 4px);\n\theight: 4px;\n\tbox-sizing: border-box;\n\tborder: 1px solid rgba(255, 255, 255, 0.71);\n\tbox-shadow: 0px 0px 1px rgba(0, 0, 0, 0.85);\n}\n\n.colorpicker-body .strip .overlay {\n\theight: 150px;\n\tpointer-events: none;\n}\n\n.colorpicker-body .standalone-strip .standalone-overlay {\n\theight: 122px;\n\tpointer-events: none;\n}\n\n.standalone-colorpicker-body {\n\tdisplay: block;\n\tborder: 1px solid transparent;\n\tborder-bottom: 1px solid var(--vscode-editorHoverWidget-border);\n\toverflow: hidden;\n}\n\n.colorpicker-body .insert-button {\n\tposition: absolute;\n\theight: 20px;\n\twidth: 58px;\n\tpadding: 0px;\n\tright: 8px;\n\tbottom: 8px;\n\tbackground: var(--vscode-button-background);\n\tcolor: var(--vscode-button-foreground);\n\tborder-radius: 2px;\n\tborder: none;\n\tcursor: pointer;\n}\n\n.colorpicker-body .insert-button:hover{\n\tbackground: var(--vscode-button-hoverBackground);\n}\n",""]),t.Z=d},81779:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor.vs .dnd-target,\n.monaco-editor.hc-light .dnd-target {\n\tborder-right: 2px dotted black;\n\tcolor: white; /* opposite of black */\n}\n.monaco-editor.vs-dark .dnd-target {\n\tborder-right: 2px dotted #AEAFAD;\n\tcolor: #51504f; /* opposite of #AEAFAD */\n}\n.monaco-editor.hc-black .dnd-target {\n\tborder-right: 2px dotted #fff;\n\tcolor: #000; /* opposite of #fff */\n}\n\n.monaco-editor.mouse-default .view-lines,\n.monaco-editor.vs-dark.mac.mouse-default .view-lines,\n.monaco-editor.hc-black.mac.mouse-default .view-lines,\n.monaco-editor.hc-light.mac.mouse-default .view-lines {\n\tcursor: default;\n}\n.monaco-editor.mouse-copy .view-lines,\n.monaco-editor.vs-dark.mac.mouse-copy .view-lines,\n.monaco-editor.hc-black.mac.mouse-copy .view-lines,\n.monaco-editor.hc-light.mac.mouse-copy .view-lines {\n\tcursor: copy;\n}\n",""]),t.Z=s},10666:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.post-edit-widget {\n\tbox-shadow: 0 0 8px 2px var(--vscode-widget-shadow);\n\tborder: 1px solid var(--vscode-widget-border, transparent);\n\tborder-radius: 4px;\n\tbackground-color: var(--vscode-editorWidget-background);\n\toverflow: hidden;\n}\n\n.post-edit-widget .monaco-button {\n\tpadding: 2px;\n\tborder: none;\n\tborder-radius: 0;\n}\n\n.post-edit-widget .monaco-button:hover {\n\tbackground-color: var(--vscode-button-secondaryHoverBackground) !important;\n}\n\n.post-edit-widget .monaco-button .codicon {\n\tmargin: 0;\n}\n",""]),t.Z=s},47125:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .findOptionsWidget {\n\tbackground-color: var(--vscode-editorWidget-background);\n\tcolor: var(--vscode-editorWidget-foreground);\n\tbox-shadow: 0 0 8px 2px var(--vscode-widget-shadow);\n\tborder: 2px solid var(--vscode-contrastBorder);\n}\n",""]),t.Z=s},30156:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n/* Find widget */\n.monaco-editor .find-widget {\n\tposition: absolute;\n\tz-index: 35;\n\theight: 33px;\n\toverflow: hidden;\n\tline-height: 19px;\n\ttransition: transform 200ms linear;\n\tpadding: 0 4px;\n\tbox-sizing: border-box;\n\ttransform: translateY(calc(-100% - 10px)); /* shadow (10px) */\n\tborder-bottom-left-radius: 4px;\n\tborder-bottom-right-radius: 4px;\n}\n\n.monaco-workbench.reduce-motion .monaco-editor .find-widget {\n\ttransition: transform 0ms linear;\n}\n\n.monaco-editor .find-widget textarea {\n\tmargin: 0px;\n}\n\n.monaco-editor .find-widget.hiddenEditor {\n\tdisplay: none;\n}\n\n/* Find widget when replace is toggled on */\n.monaco-editor .find-widget.replaceToggled > .replace-part {\n\tdisplay: flex;\n}\n\n.monaco-editor .find-widget.visible  {\n\ttransform: translateY(0);\n}\n\n.monaco-editor .find-widget .monaco-inputbox.synthetic-focus {\n\toutline: 1px solid -webkit-focus-ring-color;\n\toutline-offset: -1px;\n}\n\n.monaco-editor .find-widget .monaco-inputbox .input {\n\tbackground-color: transparent;\n\tmin-height: 0;\n}\n\n.monaco-editor .find-widget .monaco-findInput .input {\n\tfont-size: 13px;\n}\n\n.monaco-editor .find-widget > .find-part,\n.monaco-editor .find-widget > .replace-part {\n\tmargin: 3px 25px 0 17px;\n\tfont-size: 12px;\n\tdisplay: flex;\n}\n\n.monaco-editor .find-widget > .find-part .monaco-inputbox,\n.monaco-editor .find-widget > .replace-part .monaco-inputbox {\n\tmin-height: 25px;\n}\n\n\n.monaco-editor .find-widget > .replace-part .monaco-inputbox > .ibwrapper > .mirror {\n\tpadding-right: 22px;\n}\n\n.monaco-editor .find-widget > .find-part .monaco-inputbox > .ibwrapper > .input,\n.monaco-editor .find-widget > .find-part .monaco-inputbox > .ibwrapper > .mirror,\n.monaco-editor .find-widget > .replace-part .monaco-inputbox > .ibwrapper > .input,\n.monaco-editor .find-widget > .replace-part .monaco-inputbox > .ibwrapper > .mirror {\n\tpadding-top: 2px;\n\tpadding-bottom: 2px;\n}\n\n.monaco-editor .find-widget > .find-part .find-actions {\n\theight: 25px;\n\tdisplay: flex;\n\talign-items: center;\n}\n\n.monaco-editor .find-widget > .replace-part .replace-actions {\n\theight: 25px;\n\tdisplay: flex;\n\talign-items: center;\n}\n\n.monaco-editor .find-widget .monaco-findInput {\n\tvertical-align: middle;\n\tdisplay: flex;\n\tflex:1;\n}\n\n.monaco-editor .find-widget .monaco-findInput .monaco-scrollable-element {\n\t/* Make sure textarea inherits the width correctly */\n\twidth: 100%;\n}\n\n.monaco-editor .find-widget .monaco-findInput .monaco-scrollable-element .scrollbar.vertical {\n\t/* Hide vertical scrollbar */\n\topacity: 0;\n}\n\n.monaco-editor .find-widget .matchesCount {\n\tdisplay: flex;\n\tflex: initial;\n\tmargin: 0 0 0 3px;\n\tpadding: 2px 0 0 2px;\n\theight: 25px;\n\tvertical-align: middle;\n\tbox-sizing: border-box;\n\ttext-align: center;\n\tline-height: 23px;\n}\n\n.monaco-editor .find-widget .button {\n\twidth: 16px;\n\theight: 16px;\n\tpadding: 3px;\n\tborder-radius: 5px;\n\tdisplay: flex;\n\tflex: initial;\n\tmargin-left: 3px;\n\tbackground-position: center center;\n\tbackground-repeat: no-repeat;\n\tcursor: pointer;\n\tdisplay: flex;\n\talign-items: center;\n\tjustify-content: center;\n}\n\n/* find in selection button */\n.monaco-editor .find-widget .codicon-find-selection {\n\twidth: 22px;\n\theight: 22px;\n\tpadding: 3px;\n\tborder-radius: 5px;\n}\n\n.monaco-editor .find-widget .button.left {\n\tmargin-left: 0;\n\tmargin-right: 3px;\n}\n\n.monaco-editor .find-widget .button.wide {\n\twidth: auto;\n\tpadding: 1px 6px;\n\ttop: -1px;\n}\n\n.monaco-editor .find-widget .button.toggle {\n\tposition: absolute;\n\ttop: 0;\n\tleft: 3px;\n\twidth: 18px;\n\theight: 100%;\n\tborder-radius: 0;\n\tbox-sizing: border-box;\n}\n\n.monaco-editor .find-widget .button.toggle.disabled {\n\tdisplay: none;\n}\n\n.monaco-editor .find-widget .disabled {\n\tcolor: var(--vscode-disabledForeground);\n\tcursor: default;\n}\n\n.monaco-editor .find-widget > .replace-part {\n\tdisplay: none;\n}\n\n.monaco-editor .find-widget > .replace-part > .monaco-findInput {\n\tposition: relative;\n\tdisplay: flex;\n\tvertical-align: middle;\n\tflex: auto;\n\tflex-grow: 0;\n\tflex-shrink: 0;\n}\n\n.monaco-editor .find-widget > .replace-part > .monaco-findInput > .controls {\n\tposition: absolute;\n\ttop: 3px;\n\tright: 2px;\n}\n\n/* REDUCED */\n.monaco-editor .find-widget.reduced-find-widget .matchesCount {\n\tdisplay:none;\n}\n\n/* NARROW (SMALLER THAN REDUCED) */\n.monaco-editor .find-widget.narrow-find-widget {\n\tmax-width: 257px !important;\n}\n\n/* COLLAPSED (SMALLER THAN NARROW) */\n.monaco-editor .find-widget.collapsed-find-widget {\n\tmax-width: 170px !important;\n}\n\n.monaco-editor .find-widget.collapsed-find-widget .button.previous,\n.monaco-editor .find-widget.collapsed-find-widget .button.next,\n.monaco-editor .find-widget.collapsed-find-widget .button.replace,\n.monaco-editor .find-widget.collapsed-find-widget .button.replace-all,\n.monaco-editor .find-widget.collapsed-find-widget > .find-part .monaco-findInput .controls {\n\tdisplay:none;\n}\n\n.monaco-editor .findMatch {\n\tanimation-duration: 0;\n\tanimation-name: inherit !important;\n}\n\n.monaco-editor .find-widget .monaco-sash {\n\tleft: 0 !important;\n}\n\n.monaco-editor.hc-black .find-widget .button:before {\n\tposition: relative;\n\ttop: 1px;\n\tleft: 2px;\n}\n\n/* Close button position. */\n.monaco-editor .find-widget > .button.codicon-widget-close {\n\tposition: absolute;\n\ttop: 5px;\n\tright: 4px;\n}\n",""]),t.Z=s},54063:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,'/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n.monaco-editor .margin-view-overlays .codicon-folding-manual-collapsed,\n.monaco-editor .margin-view-overlays .codicon-folding-manual-expanded,\n.monaco-editor .margin-view-overlays .codicon-folding-expanded,\n.monaco-editor .margin-view-overlays .codicon-folding-collapsed {\n\tcursor: pointer;\n\topacity: 0;\n\ttransition: opacity 0.5s;\n\tdisplay: flex;\n\talign-items: center;\n\tjustify-content: center;\n\tfont-size: 140%;\n\tmargin-left: 2px;\n}\n\n.monaco-workbench.reduce-motion .monaco-editor .margin-view-overlays .codicon-folding-manual-collapsed,\n.monaco-workbench.reduce-motion .monaco-editor .margin-view-overlays .codicon-folding-manual-expanded,\n.monaco-workbench.reduce-motion .monaco-editor .margin-view-overlays .codicon-folding-expanded,\n.monaco-workbench.reduce-motion .monaco-editor .margin-view-overlays .codicon-folding-collapsed {\n\ttransition: initial;\n}\n\n.monaco-editor .margin-view-overlays:hover .codicon,\n.monaco-editor .margin-view-overlays .codicon.codicon-folding-collapsed,\n.monaco-editor .margin-view-overlays .codicon.codicon-folding-manual-collapsed,\n.monaco-editor .margin-view-overlays .codicon.alwaysShowFoldIcons {\n\topacity: 1;\n}\n\n.monaco-editor .inline-folded:after {\n\tcolor: grey;\n\tmargin: 0.1em 0.2em 0 0.2em;\n\tcontent: "\\22EF"; /* ellipses unicode character */\n\tdisplay: inline;\n\tline-height: 1em;\n\tcursor: pointer;\n}\n\n.monaco-editor .folded-background {\n\tbackground-color: var(--vscode-editor-foldBackground);\n}\n\n.monaco-editor .cldr.codicon.codicon-folding-expanded,\n.monaco-editor .cldr.codicon.codicon-folding-collapsed,\n.monaco-editor .cldr.codicon.codicon-folding-manual-expanded,\n.monaco-editor .cldr.codicon.codicon-folding-manual-collapsed {\n\tcolor: var(--vscode-editorGutter-foldingControlForeground) !important;\n}\n\n',""]),t.Z=s},20101:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n/* marker zone */\n\n.monaco-editor .peekview-widget .head .peekview-title .severity-icon {\n\tdisplay: inline-block;\n\tvertical-align: text-top;\n\tmargin-right: 4px;\n}\n\n.monaco-editor .marker-widget {\n\ttext-overflow: ellipsis;\n\twhite-space: nowrap;\n}\n\n.monaco-editor .marker-widget > .stale {\n\topacity: 0.6;\n\tfont-style: italic;\n}\n\n.monaco-editor .marker-widget .title {\n\tdisplay: inline-block;\n\tpadding-right: 5px;\n}\n\n.monaco-editor .marker-widget .descriptioncontainer {\n\tposition: absolute;\n\twhite-space: pre;\n\tuser-select: text;\n\t-webkit-user-select: text;\n\tpadding: 8px 12px 0 20px;\n}\n\n.monaco-editor .marker-widget .descriptioncontainer .message {\n\tdisplay: flex;\n\tflex-direction: column;\n}\n\n.monaco-editor .marker-widget .descriptioncontainer .message .details {\n\tpadding-left: 6px;\n}\n\n.monaco-editor .marker-widget .descriptioncontainer .message .source,\n.monaco-editor .marker-widget .descriptioncontainer .message span.code {\n\topacity: 0.6;\n}\n\n.monaco-editor .marker-widget .descriptioncontainer .message a.code-link {\n\topacity: 0.6;\n\tcolor: inherit;\n}\n\n.monaco-editor .marker-widget .descriptioncontainer .message a.code-link:before {\n\tcontent: '(';\n}\n\n.monaco-editor .marker-widget .descriptioncontainer .message a.code-link:after {\n\tcontent: ')';\n}\n\n.monaco-editor .marker-widget .descriptioncontainer .message a.code-link > span {\n\ttext-decoration: underline;\n\t/** Hack to force underline to show **/\n\tborder-bottom: 1px solid transparent;\n\ttext-underline-position: under;\n\tcolor: var(--vscode-textLink-foreground);\n}\n\n.monaco-editor .marker-widget .descriptioncontainer .message a.code-link > span {\n\tcolor: var(--vscode-textLink-activeForeground);\n}\n\n.monaco-editor .marker-widget .descriptioncontainer .filename {\n\tcursor: pointer;\n}\n",""]),t.Z=s},93380:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .goto-definition-link {\n\ttext-decoration: underline;\n\tcursor: pointer;\n\tcolor: var(--vscode-editorLink-activeForeground) !important;\n}\n",""]),t.Z=s},83231:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n/* -- zone widget */\n.monaco-editor .zone-widget .zone-widget-container.reference-zone-widget {\n\tborder-top-width: 1px;\n\tborder-bottom-width: 1px;\n}\n\n.monaco-editor .reference-zone-widget .inline {\n\tdisplay: inline-block;\n\tvertical-align: top;\n}\n\n.monaco-editor .reference-zone-widget .messages {\n\theight: 100%;\n\twidth: 100%;\n\ttext-align: center;\n\tpadding: 3em 0;\n}\n\n.monaco-editor .reference-zone-widget .ref-tree {\n\tline-height: 23px;\n\tbackground-color: var(--vscode-peekViewResult-background);\n\tcolor: var(--vscode-peekViewResult-lineForeground);\n}\n\n.monaco-editor .reference-zone-widget .ref-tree .reference {\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n}\n\n.monaco-editor .reference-zone-widget .ref-tree .reference-file {\n\tdisplay: inline-flex;\n\twidth: 100%;\n\theight: 100%;\n\tcolor: var(--vscode-peekViewResult-fileForeground);\n}\n\n.monaco-editor .reference-zone-widget .ref-tree .monaco-list:focus .selected .reference-file {\n\tcolor: inherit !important;\n}\n\n.monaco-editor .reference-zone-widget .ref-tree .monaco-list:focus .monaco-list-rows > .monaco-list-row.selected:not(.highlighted) {\n\tbackground-color: var(--vscode-peekViewResult-selectionBackground);\n\tcolor: var(--vscode-peekViewResult-selectionForeground) !important;\n}\n\n.monaco-editor .reference-zone-widget .ref-tree .reference-file .count {\n\tmargin-right: 12px;\n\tmargin-left: auto;\n}\n\n.monaco-editor .reference-zone-widget .ref-tree .referenceMatch .highlight {\n\tbackground-color: var(--vscode-peekViewResult-matchHighlightBackground);\n}\n\n.monaco-editor .reference-zone-widget .preview .reference-decoration {\n\tbackground-color: var(--vscode-peekViewEditor-matchHighlightBackground);\n\tborder: 2px solid var(--vscode-peekViewEditor-matchHighlightBorder);\n\tbox-sizing: border-box;\n}\n\n.monaco-editor .reference-zone-widget .preview .monaco-editor .monaco-editor-background,\n.monaco-editor .reference-zone-widget .preview .monaco-editor .inputarea.ime-input {\n\tbackground-color: var(--vscode-peekViewEditor-background);\n}\n\n.monaco-editor .reference-zone-widget .preview .monaco-editor .margin {\n\tbackground-color: var(--vscode-peekViewEditorGutter-background);\n}\n\n/* High Contrast Theming */\n\n.monaco-editor.hc-black .reference-zone-widget .ref-tree .reference-file,\n.monaco-editor.hc-light .reference-zone-widget .ref-tree .reference-file {\n\tfont-weight: bold;\n}\n\n.monaco-editor.hc-black .reference-zone-widget .ref-tree .referenceMatch .highlight,\n.monaco-editor.hc-light .reference-zone-widget .ref-tree .referenceMatch .highlight {\n\tborder: 1px dotted var(--vscode-contrastActiveBorder, transparent);\n\tbox-sizing: border-box;\n}\n",""]),t.Z=s},35285:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .hoverHighlight {\n\tbackground-color: var(--vscode-editor-hoverHighlightBackground);\n}\n\n.monaco-editor .monaco-hover {\n\tcolor: var(--vscode-editorHoverWidget-foreground);\n\tbackground-color: var(--vscode-editorHoverWidget-background);\n\tborder: 1px solid var(--vscode-editorHoverWidget-border);\n\tborder-radius: 3px;\n}\n\n.monaco-editor .monaco-hover a {\n\tcolor: var(--vscode-textLink-foreground);\n}\n\n.monaco-editor .monaco-hover a:hover {\n\tcolor: var(--vscode-textLink-activeForeground);\n}\n\n.monaco-editor .monaco-hover .hover-row .actions {\n\tbackground-color: var(--vscode-editorHoverWidget-statusBarBackground);\n}\n\n.monaco-editor .monaco-hover code {\n\tbackground-color: var(--vscode-textCodeBlock-background);\n}\n\n\n",""]),t.Z=s},3612:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n\n.monaco-editor.vs .valueSetReplacement {\n\toutline: solid 2px var(--vscode-editorBracketMatch-border);\n}\n",""]),t.Z=s},61754:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .suggest-preview-additional-widget {\n\twhite-space: nowrap;\n}\n\n.monaco-editor .suggest-preview-additional-widget .content-spacer {\n\tcolor: transparent;\n\twhite-space: pre;\n}\n\n.monaco-editor .suggest-preview-additional-widget .button {\n\tdisplay: inline-block;\n\tcursor: pointer;\n\ttext-decoration: underline;\n\ttext-underline-position: under;\n}\n\n.monaco-editor .ghost-text-hidden {\n\topacity: 0;\n\tfont-size: 0;\n}\n\n.monaco-editor .ghost-text-decoration, .monaco-editor .suggest-preview-text .ghost-text {\n\tfont-style: italic;\n}\n\n.monaco-editor .inline-completion-text-to-replace {\n\ttext-decoration: underline;\n\ttext-underline-position: under;\n}\n\n.monaco-editor .ghost-text-decoration,\n.monaco-editor .ghost-text-decoration-preview,\n.monaco-editor .suggest-preview-text .ghost-text {\n\tcolor: var(--vscode-editorGhostText-foreground) !important;\n\tbackground-color: var(--vscode-editorGhostText-background);\n\tborder: 1px solid var(--vscode-editorGhostText-border);\n}\n",""]),t.Z=s},32866:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .inlineSuggestionsHints.withBorder {\n\tz-index: 39;\n\tcolor: var(--vscode-editorHoverWidget-foreground);\n\tbackground-color: var(--vscode-editorHoverWidget-background);\n\tborder: 1px solid var(--vscode-editorHoverWidget-border);\n}\n\n.monaco-editor .inlineSuggestionsHints a {\n\tcolor: var(--vscode-foreground);\n}\n\n.monaco-editor .inlineSuggestionsHints a:hover {\n\tcolor: var(--vscode-foreground);\n}\n\n.monaco-editor .inlineSuggestionsHints .keybinding {\n\tdisplay: flex;\n\tmargin-left: 4px;\n\topacity: 0.6;\n}\n\n.monaco-editor .inlineSuggestionsHints .keybinding .monaco-keybinding-key {\n\tfont-size: 8px;\n\tpadding: 2px 3px;\n}\n\n.monaco-editor .inlineSuggestionsHints .availableSuggestionCount a {\n\tdisplay: flex;\n\tmin-width: 19px;\n\tjustify-content: center;\n}\n\n.monaco-editor .inlineSuggestionStatusBarItemLabel {\n\tmargin-right: 2px;\n}\n",""]),t.Z=s},67927:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,'/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.inline-editor-progress-decoration {\n\tdisplay: inline-block;\n\twidth: 1em;\n\theight: 1em;\n}\n\n.inline-progress-widget  {\n\tdisplay: flex !important;\n\tjustify-content: center;\n\talign-items: center;\n}\n\n.inline-progress-widget .icon {\n\tfont-size: 80% !important;\n}\n\n.inline-progress-widget:hover .icon {\n\tfont-size: 90% !important;\n\tanimation: none;\n}\n\n.inline-progress-widget:hover .icon::before {\n\tcontent: "\\ea76"; /* codicon-x */\n}\n',""]),t.Z=s},79316:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .linked-editing-decoration {\n\tbackground-color: var(--vscode-editor-linkedEditingBackground);\n\n\t/* Ensure decoration is visible even if range is empty */\n\tmin-width: 1px;\n}\n",""]),t.Z=s},76813:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n.monaco-editor .detected-link,\n.monaco-editor .detected-link-active {\n\ttext-decoration: underline;\n\ttext-underline-position: under;\n}\n\n.monaco-editor .detected-link-active {\n\tcursor: pointer;\n\tcolor: var(--vscode-editorLink-activeForeground) !important;\n}\n",""]),t.Z=s},84484:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .rendered-markdown kbd {\n\tbackground-color: var(--vscode-keybindingLabel-background);\n\tcolor: var(--vscode-keybindingLabel-foreground);\n\tborder-style: solid;\n\tborder-width: 1px;\n\tborder-radius: 3px;\n\tborder-color: var(--vscode-keybindingLabel-border);\n\tborder-bottom-color: var(--vscode-keybindingLabel-bottomBorder);\n\tbox-shadow: inset 0 -1px 0 var(--vscode-widget-shadow);\n\tvertical-align: middle;\n\tpadding: 1px 3px;\n}\n",""]),t.Z=s},5036:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .monaco-editor-overlaymessage {\n\tpadding-bottom: 8px;\n\tz-index: 10000;\n}\n\n.monaco-editor .monaco-editor-overlaymessage.below {\n\tpadding-bottom: 0;\n\tpadding-top: 8px;\n\tz-index: 10000;\n}\n\n@keyframes fadeIn {\n\tfrom { opacity: 0; }\n\tto { opacity: 1; }\n}\n.monaco-editor .monaco-editor-overlaymessage.fadeIn {\n\tanimation: fadeIn 150ms ease-out;\n}\n\n@keyframes fadeOut {\n\tfrom { opacity: 1; }\n\tto { opacity: 0; }\n}\n.monaco-editor .monaco-editor-overlaymessage.fadeOut {\n\tanimation: fadeOut 100ms ease-out;\n}\n\n.monaco-editor .monaco-editor-overlaymessage .message {\n\tpadding: 2px 4px;\n\tcolor: var(--vscode-editorHoverWidget-foreground);\n\tbackground-color: var(--vscode-editorHoverWidget-background);\n\tborder: 1px solid var(--vscode-inputValidation-infoBorder);\n\tborder-radius: 3px;\n}\n\n.monaco-editor .monaco-editor-overlaymessage .message p {\n\tmargin-block: 0px;\n}\n\n.monaco-editor .monaco-editor-overlaymessage .message a {\n\tcolor: var(--vscode-textLink-foreground);\n}\n\n.monaco-editor .monaco-editor-overlaymessage .message a:hover {\n\tcolor: var(--vscode-textLink-activeForeground);\n}\n\n.monaco-editor.hc-black .monaco-editor-overlaymessage .message,\n.monaco-editor.hc-light .monaco-editor-overlaymessage .message {\n\tborder-width: 2px;\n}\n\n.monaco-editor .monaco-editor-overlaymessage .anchor {\n\twidth: 0 !important;\n\theight: 0 !important;\n\tborder-color: transparent;\n\tborder-style: solid;\n\tz-index: 1000;\n\tborder-width: 8px;\n\tposition: absolute;\n\tleft: 2px;\n}\n\n.monaco-editor .monaco-editor-overlaymessage .anchor.top {\n\tborder-bottom-color: var(--vscode-inputValidation-infoBorder);\n}\n\n.monaco-editor .monaco-editor-overlaymessage .anchor.below {\n\tborder-top-color: var(--vscode-inputValidation-infoBorder);\n}\n\n.monaco-editor .monaco-editor-overlaymessage:not(.below) .anchor.top,\n.monaco-editor .monaco-editor-overlaymessage.below .anchor.below {\n\tdisplay: none;\n}\n\n.monaco-editor .monaco-editor-overlaymessage.below .anchor.top {\n\tdisplay: inherit;\n\ttop: -8px;\n}\n",""]),t.Z=s},32951:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,'/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .parameter-hints-widget {\n\t/* Must be higher than the sash\'s z-index and terminal canvases but lower than the suggest widget */\n\tz-index: 39;\n\tdisplay: flex;\n\tflex-direction: column;\n\tline-height: 1.5em;\n\tcursor: default;\n\tcolor: var(--vscode-editorHoverWidget-foreground);\n\tbackground-color: var(--vscode-editorHoverWidget-background);\n\tborder: 1px solid var(--vscode-editorHoverWidget-border);\n}\n\n.hc-black .monaco-editor .parameter-hints-widget,\n.hc-light .monaco-editor .parameter-hints-widget {\n\tborder-width: 2px;\n}\n\n.monaco-editor .parameter-hints-widget > .phwrapper {\n\tmax-width: 440px;\n\tdisplay: flex;\n\tflex-direction: row;\n}\n\n.monaco-editor .parameter-hints-widget.multiple {\n\tmin-height: 3.3em;\n\tpadding: 0;\n}\n\n.monaco-editor .parameter-hints-widget.multiple .body::before {\n\tcontent: "";\n\tdisplay: block;\n\theight: 100%;\n\tposition: absolute;\n\topacity: 0.5;\n\tborder-left: 1px solid var(--vscode-editorHoverWidget-border);\n}\n\n.monaco-editor .parameter-hints-widget p,\n.monaco-editor .parameter-hints-widget ul {\n\tmargin: 8px 0;\n}\n\n.monaco-editor .parameter-hints-widget .monaco-scrollable-element,\n.monaco-editor .parameter-hints-widget .body {\n\tdisplay: flex;\n\tflex: 1;\n\tflex-direction: column;\n\tmin-height: 100%;\n}\n\n.monaco-editor .parameter-hints-widget .signature {\n\tpadding: 4px 5px;\n\tposition: relative;\n}\n\n.monaco-editor .parameter-hints-widget .signature.has-docs::after {\n\tcontent: "";\n\tdisplay: block;\n\tposition: absolute;\n\tleft: 0;\n\twidth: 100%;\n\tpadding-top: 4px;\n\topacity: 0.5;\n\tborder-bottom: 1px solid var(--vscode-editorHoverWidget-border);\n}\n\n.monaco-editor .parameter-hints-widget .docs {\n\tpadding: 0 10px 0 5px;\n\twhite-space: pre-wrap;\n}\n\n.monaco-editor .parameter-hints-widget .docs.empty {\n\tdisplay: none;\n}\n\n.monaco-editor .parameter-hints-widget .docs a {\n\tcolor: var(--vscode-textLink-foreground);\n}\n\n.monaco-editor .parameter-hints-widget .docs a:hover {\n\tcolor: var(--vscode-textLink-activeForeground);\n\tcursor: pointer;\n}\n\n.monaco-editor .parameter-hints-widget .docs .markdown-docs {\n\twhite-space: initial;\n}\n\n.monaco-editor .parameter-hints-widget .docs code {\n\tfont-family: var(--monaco-monospace-font);\n\tborder-radius: 3px;\n\tpadding: 0 0.4em;\n\tbackground-color: var(--vscode-textCodeBlock-background);\n}\n\n.monaco-editor .parameter-hints-widget .docs .monaco-tokenized-source,\n.monaco-editor .parameter-hints-widget .docs .code {\n\twhite-space: pre-wrap;\n}\n\n.monaco-editor .parameter-hints-widget .controls {\n\tdisplay: none;\n\tflex-direction: column;\n\talign-items: center;\n\tmin-width: 22px;\n\tjustify-content: flex-end;\n}\n\n.monaco-editor .parameter-hints-widget.multiple .controls {\n\tdisplay: flex;\n\tpadding: 0 2px;\n}\n\n.monaco-editor .parameter-hints-widget.multiple .button {\n\twidth: 16px;\n\theight: 16px;\n\tbackground-repeat: no-repeat;\n\tcursor: pointer;\n}\n\n.monaco-editor .parameter-hints-widget .button.previous {\n\tbottom: 24px;\n}\n\n.monaco-editor .parameter-hints-widget .overloads {\n\ttext-align: center;\n\theight: 12px;\n\tline-height: 12px;\n\tfont-family: var(--monaco-monospace-font);\n}\n\n.monaco-editor .parameter-hints-widget .signature .parameter.active {\n\tcolor: var(--vscode-editorHoverWidget-highlightForeground);\n\tfont-weight: bold;\n}\n\n.monaco-editor .parameter-hints-widget .documentation-parameter > .parameter {\n\tfont-weight: bold;\n\tmargin-right: 0.5em;\n}\n',""]),t.Z=s},30126:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .peekview-widget .head {\n\tbox-sizing: border-box;\n\tdisplay: flex;\n\tjustify-content: space-between;\n\tflex-wrap: nowrap;\n}\n\n.monaco-editor .peekview-widget .head .peekview-title {\n\tdisplay: flex;\n\talign-items: baseline;\n\tfont-size: 13px;\n\tmargin-left: 20px;\n\tmin-width: 0;\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n}\n\n.monaco-editor .peekview-widget .head .peekview-title.clickable {\n\tcursor: pointer;\n}\n\n.monaco-editor .peekview-widget .head .peekview-title .dirname:not(:empty) {\n\tfont-size: 0.9em;\n\tmargin-left: 0.5em;\n}\n\n.monaco-editor .peekview-widget .head .peekview-title .meta {\n\twhite-space: nowrap;\n\toverflow: hidden;\n\ttext-overflow: ellipsis;\n}\n\n.monaco-editor .peekview-widget .head .peekview-title .dirname {\n\toverflow: hidden;\n\ttext-overflow: ellipsis;\n\twhite-space: nowrap;\n}\n\n.monaco-editor .peekview-widget .head .peekview-title .filename {\n\toverflow: hidden;\n\ttext-overflow: ellipsis;\n\twhite-space: nowrap;\n}\n\n.monaco-editor .peekview-widget .head .peekview-title .meta:not(:empty)::before {\n\tcontent: '-';\n\tpadding: 0 0.3em;\n}\n\n.monaco-editor .peekview-widget .head .peekview-actions {\n\tflex: 1;\n\ttext-align: right;\n\tpadding-right: 2px;\n}\n\n.monaco-editor .peekview-widget .head .peekview-actions > .monaco-action-bar {\n\tdisplay: inline-block;\n}\n\n.monaco-editor .peekview-widget .head .peekview-actions > .monaco-action-bar,\n.monaco-editor .peekview-widget .head .peekview-actions > .monaco-action-bar > .actions-container {\n\theight: 100%;\n}\n\n.monaco-editor .peekview-widget > .body {\n\tborder-top: 1px solid;\n\tposition: relative;\n}\n\n.monaco-editor .peekview-widget .head .peekview-title .codicon {\n\tmargin-right: 4px;\n\talign-self: center;\n}\n\n.monaco-editor .peekview-widget .monaco-list .monaco-list-row.focused .codicon {\n\tcolor: inherit !important;\n}\n",""]),t.Z=s},52475:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .rename-box {\n\tz-index: 100;\n\tcolor: inherit;\n\tborder-radius: 4px;\n}\n\n.monaco-editor .rename-box.preview {\n\tpadding: 4px 4px 0 4px;\n}\n\n.monaco-editor .rename-box .rename-input {\n\tpadding: 3px;\n\tborder-radius: 2px;\n}\n\n.monaco-editor .rename-box .rename-label {\n\tdisplay: none;\n\topacity: .8;\n}\n\n.monaco-editor .rename-box.preview .rename-label {\n\tdisplay: inherit;\n}\n",""]),t.Z=s},16960:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .snippet-placeholder {\n\tmin-width: 2px;\n\toutline-style: solid;\n\toutline-width: 1px;\n\tbackground-color: var(--vscode-editor-snippetTabstopHighlightBackground, transparent);\n\toutline-color: var(--vscode-editor-snippetTabstopHighlightBorder, transparent);\n}\n\n.monaco-editor .finish-snippet-placeholder {\n\toutline-style: solid;\n\toutline-width: 1px;\n\tbackground-color: var(--vscode-editor-snippetFinalTabstopHighlightBackground, transparent);\n\toutline-color: var(--vscode-editor-snippetFinalTabstopHighlightBorder, transparent);\n}\n",""]),t.Z=s},33302:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .sticky-widget {\n\toverflow: hidden;\n}\n\n.monaco-editor .sticky-widget-line-numbers {\n\tfloat: left;\n\tbackground-color: inherit;\n}\n\n.monaco-editor .sticky-widget-lines-scrollable {\n\tdisplay: inline-block;\n\tposition: absolute;\n\toverflow: hidden;\n\twidth: var(--vscode-editorStickyScroll-scrollableWidth);\n\tbackground-color: inherit;\n}\n\n.monaco-editor .sticky-widget-lines {\n\tposition: absolute;\n\tbackground-color: inherit;\n}\n\n.monaco-editor .sticky-line-number, .monaco-editor .sticky-line-content {\n\tcolor: var(--vscode-editorLineNumber-foreground);\n\twhite-space: nowrap;\n\tdisplay: inline-block;\n\tposition: absolute;\n\tbackground-color: inherit;\n}\n\n.monaco-editor .sticky-line-number .codicon-folding-expanded,\n.monaco-editor .sticky-line-number .codicon-folding-collapsed {\n\tfloat: right;\n\ttransition: var(--vscode-editorStickyScroll-foldingOpacityTransition);\n}\n\n.monaco-editor .sticky-line-content {\n\twidth: var(--vscode-editorStickyScroll-scrollableWidth);\n\tbackground-color: inherit;\n\twhite-space: nowrap;\n}\n\n.monaco-editor .sticky-line-number-inner {\n\tdisplay: inline-block;\n\ttext-align: right;\n}\n\n.monaco-editor.hc-black .sticky-widget,\n.monaco-editor.hc-light .sticky-widget {\n\tborder-bottom: 1px solid var(--vscode-contrastBorder);\n}\n\n.monaco-editor .sticky-line-content:hover {\n\tbackground-color: var(--vscode-editorStickyScrollHover-background);\n\tcursor: pointer;\n}\n\n.monaco-editor .sticky-widget {\n\twidth: 100%;\n\tbox-shadow: var(--vscode-scrollbar-shadow) 0 3px 2px -2px;\n\tz-index: 4;\n\tbackground-color: var(--vscode-editorStickyScroll-background);\n}\n\n.monaco-editor .sticky-widget.peek {\n\tbackground-color: var(--vscode-peekViewEditorStickyScroll-background);\n}\n",""]),t.Z=s},34886:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n/* Suggest widget*/\n\n.monaco-editor .suggest-widget {\n\twidth: 430px;\n\tz-index: 40;\n\tdisplay: flex;\n\tflex-direction: column;\n\tborder-radius: 3px;\n}\n\n.monaco-editor .suggest-widget.message {\n\tflex-direction: row;\n\talign-items: center;\n}\n\n.monaco-editor .suggest-widget,\n.monaco-editor .suggest-details {\n\tflex: 0 1 auto;\n\twidth: 100%;\n\tborder-style: solid;\n\tborder-width: 1px;\n\tborder-color: var(--vscode-editorSuggestWidget-border);\n\tbackground-color: var(--vscode-editorSuggestWidget-background);\n}\n\n.monaco-editor.hc-black .suggest-widget,\n.monaco-editor.hc-black .suggest-details,\n.monaco-editor.hc-light .suggest-widget,\n.monaco-editor.hc-light .suggest-details {\n\tborder-width: 2px;\n}\n\n/* Styles for status bar part */\n\n\n.monaco-editor .suggest-widget .suggest-status-bar {\n\tbox-sizing: border-box;\n\tdisplay: none;\n\tflex-flow: row nowrap;\n\tjustify-content: space-between;\n\twidth: 100%;\n\tfont-size: 80%;\n\tpadding: 0 4px 0 4px;\n\tborder-top: 1px solid var(--vscode-editorSuggestWidget-border);\n\toverflow: hidden;\n}\n\n.monaco-editor .suggest-widget.with-status-bar .suggest-status-bar {\n\tdisplay: flex;\n}\n\n.monaco-editor .suggest-widget .suggest-status-bar .left {\n\tpadding-right: 8px;\n}\n\n.monaco-editor .suggest-widget.with-status-bar .suggest-status-bar .action-label {\n\tcolor: var(--vscode-editorSuggestWidgetStatus-foreground);\n}\n\n.monaco-editor .suggest-widget.with-status-bar .suggest-status-bar .action-item:not(:last-of-type) .action-label {\n\tmargin-right: 0;\n}\n\n.monaco-editor .suggest-widget.with-status-bar .suggest-status-bar .action-item:not(:last-of-type) .action-label::after {\n\tcontent: ', ';\n\tmargin-right: 0.3em;\n}\n\n.monaco-editor .suggest-widget.with-status-bar .monaco-list .monaco-list-row>.contents>.main>.right>.readMore,\n.monaco-editor .suggest-widget.with-status-bar .monaco-list .monaco-list-row.focused.string-label>.contents>.main>.right>.readMore {\n\tdisplay: none;\n}\n\n.monaco-editor .suggest-widget.with-status-bar:not(.docs-side) .monaco-list .monaco-list-row:hover>.contents>.main>.right.can-expand-details>.details-label {\n\twidth: 100%;\n}\n\n/* Styles for Message element for when widget is loading or is empty */\n\n.monaco-editor .suggest-widget>.message {\n\tpadding-left: 22px;\n}\n\n/** Styles for the list element **/\n\n.monaco-editor .suggest-widget>.tree {\n\theight: 100%;\n\twidth: 100%;\n}\n\n.monaco-editor .suggest-widget .monaco-list {\n\tuser-select: none;\n\t-webkit-user-select: none;\n}\n\n/** Styles for each row in the list element **/\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row {\n\tdisplay: flex;\n\t-mox-box-sizing: border-box;\n\tbox-sizing: border-box;\n\tpadding-right: 10px;\n\tbackground-repeat: no-repeat;\n\tbackground-position: 2px 2px;\n\twhite-space: nowrap;\n\tcursor: pointer;\n\ttouch-action: none;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row.focused {\n\tcolor: var(--vscode-editorSuggestWidget-selectedForeground);\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row.focused .codicon {\n\tcolor: var(--vscode-editorSuggestWidget-selectedIconForeground);\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents {\n\tflex: 1;\n\theight: 100%;\n\toverflow: hidden;\n\tpadding-left: 2px;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main {\n\tdisplay: flex;\n\toverflow: hidden;\n\ttext-overflow: ellipsis;\n\twhite-space: pre;\n\tjustify-content: space-between;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.left,\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.right {\n\tdisplay: flex;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row:not(.focused)>.contents>.main .monaco-icon-label {\n\tcolor: var(--vscode-editorSuggestWidget-foreground);\n}\n\n.monaco-editor .suggest-widget:not(.frozen) .monaco-highlighted-label .highlight {\n\tfont-weight: bold;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main .monaco-highlighted-label .highlight {\n\tcolor: var(--vscode-editorSuggestWidget-highlightForeground);\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row.focused>.contents>.main .monaco-highlighted-label .highlight {\n\tcolor: var(--vscode-editorSuggestWidget-focusHighlightForeground);\n}\n\n/** ReadMore Icon styles **/\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.header>.codicon-close,\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.right>.readMore::before {\n\tcolor: inherit;\n\topacity: 1;\n\tfont-size: 14px;\n\tcursor: pointer;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.header>.codicon-close {\n\tposition: absolute;\n\ttop: 6px;\n\tright: 2px;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.header>.codicon-close:hover,\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.right>.readMore:hover {\n\topacity: 1;\n}\n\n/** signature, qualifier, type/details opacity **/\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.right>.details-label {\n\topacity: 0.7;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.left>.signature-label {\n\toverflow: hidden;\n\ttext-overflow: ellipsis;\n\topacity: 0.6;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.left>.qualifier-label {\n\tmargin-left: 12px;\n\topacity: 0.4;\n\tfont-size: 85%;\n\tline-height: initial;\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n\talign-self: center;\n}\n\n/** Type Info and icon next to the label in the focused completion item **/\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.right>.details-label {\n\tfont-size: 85%;\n\tmargin-left: 1.1em;\n\toverflow: hidden;\n\ttext-overflow: ellipsis;\n\twhite-space: nowrap;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.right>.details-label>.monaco-tokenized-source {\n\tdisplay: inline;\n}\n\n/** Details: if using CompletionItem#details, show on focus **/\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.right>.details-label {\n\tdisplay: none;\n}\n\n.monaco-editor .suggest-widget:not(.shows-details) .monaco-list .monaco-list-row.focused>.contents>.main>.right>.details-label {\n\tdisplay: inline;\n}\n\n/** Details: if using CompletionItemLabel#details, always show **/\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row:not(.string-label)>.contents>.main>.right>.details-label,\n.monaco-editor .suggest-widget.docs-side .monaco-list .monaco-list-row.focused:not(.string-label)>.contents>.main>.right>.details-label {\n\tdisplay: inline;\n}\n\n/** Ellipsis on hover **/\n\n.monaco-editor .suggest-widget:not(.docs-side) .monaco-list .monaco-list-row.focused:hover>.contents>.main>.right.can-expand-details>.details-label {\n\twidth: calc(100% - 26px);\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.left {\n\tflex-shrink: 1;\n\tflex-grow: 1;\n\toverflow: hidden;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.left>.monaco-icon-label {\n\tflex-shrink: 0;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row:not(.string-label)>.contents>.main>.left>.monaco-icon-label {\n\tmax-width: 100%;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row.string-label>.contents>.main>.left>.monaco-icon-label {\n\tflex-shrink: 1;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.right {\n\toverflow: hidden;\n\tflex-shrink: 4;\n\tmax-width: 70%;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row>.contents>.main>.right>.readMore {\n\tdisplay: inline-block;\n\tposition: absolute;\n\tright: 10px;\n\twidth: 18px;\n\theight: 18px;\n\tvisibility: hidden;\n}\n\n/** Do NOT display ReadMore when docs is side/below **/\n\n.monaco-editor .suggest-widget.docs-side .monaco-list .monaco-list-row>.contents>.main>.right>.readMore {\n\tdisplay: none !important;\n}\n\n/** Do NOT display ReadMore when using plain CompletionItemLabel (details/documentation might not be resolved) **/\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row.string-label>.contents>.main>.right>.readMore {\n\tdisplay: none;\n}\n\n/** Focused item can show ReadMore, but can't when docs is side/below **/\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row.focused.string-label>.contents>.main>.right>.readMore {\n\tdisplay: inline-block;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row.focused:hover>.contents>.main>.right>.readMore {\n\tvisibility: visible;\n}\n\n/** Styles for each row in the list **/\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row .monaco-icon-label.deprecated {\n\topacity: 0.66;\n\ttext-decoration: unset;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row .monaco-icon-label.deprecated>.monaco-icon-label-container>.monaco-icon-name-container {\n\ttext-decoration: line-through;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row .monaco-icon-label::before {\n\theight: 100%;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row .icon {\n\tdisplay: block;\n\theight: 16px;\n\twidth: 16px;\n\tmargin-left: 2px;\n\tbackground-repeat: no-repeat;\n\tbackground-size: 80%;\n\tbackground-position: center;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row .icon.hide {\n\tdisplay: none;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row .suggest-icon {\n\tdisplay: flex;\n\talign-items: center;\n\tmargin-right: 4px;\n}\n\n.monaco-editor .suggest-widget.no-icons .monaco-list .monaco-list-row .icon,\n.monaco-editor .suggest-widget.no-icons .monaco-list .monaco-list-row .suggest-icon::before {\n\tdisplay: none;\n}\n\n.monaco-editor .suggest-widget .monaco-list .monaco-list-row .icon.customcolor .colorspan {\n\tmargin: 0 0 0 0.3em;\n\tborder: 0.1em solid #000;\n\twidth: 0.7em;\n\theight: 0.7em;\n\tdisplay: inline-block;\n}\n\n/** Styles for the docs of the completion item in focus **/\n\n.monaco-editor .suggest-details-container {\n\tz-index: 41;\n}\n\n.monaco-editor .suggest-details {\n\tdisplay: flex;\n\tflex-direction: column;\n\tcursor: default;\n\tcolor: var(--vscode-editorSuggestWidget-foreground);\n}\n\n.monaco-editor .suggest-details.focused {\n\tborder-color: var(--vscode-focusBorder);\n}\n\n.monaco-editor .suggest-details a {\n\tcolor: var(--vscode-textLink-foreground);\n}\n\n.monaco-editor .suggest-details a:hover {\n\tcolor: var(--vscode-textLink-activeForeground);\n}\n\n.monaco-editor .suggest-details code {\n\tbackground-color: var(--vscode-textCodeBlock-background);\n}\n\n.monaco-editor .suggest-details.no-docs {\n\tdisplay: none;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element {\n\tflex: 1;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body {\n\tbox-sizing: border-box;\n\theight: 100%;\n\twidth: 100%;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.header>.type {\n\tflex: 2;\n\toverflow: hidden;\n\ttext-overflow: ellipsis;\n\topacity: 0.7;\n\twhite-space: pre;\n\tmargin: 0 24px 0 0;\n\tpadding: 4px 0 12px 5px;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.header>.type.auto-wrap {\n\twhite-space: normal;\n\tword-break: break-all;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.docs {\n\tmargin: 0;\n\tpadding: 4px 5px;\n\twhite-space: pre-wrap;\n}\n\n.monaco-editor .suggest-details.no-type>.monaco-scrollable-element>.body>.docs {\n\tmargin-right: 24px;\n\toverflow: hidden;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.docs.markdown-docs {\n\tpadding: 0;\n\twhite-space: initial;\n\tmin-height: calc(1rem + 8px);\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.docs.markdown-docs>div,\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.docs.markdown-docs>span:not(:empty) {\n\tpadding: 4px 5px;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.docs.markdown-docs>div>p:first-child {\n\tmargin-top: 0;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.docs.markdown-docs>div>p:last-child {\n\tmargin-bottom: 0;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.docs.markdown-docs .monaco-tokenized-source {\n\twhite-space: pre;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.docs .code {\n\twhite-space: pre-wrap;\n\tword-wrap: break-word;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>.docs.markdown-docs .codicon {\n\tvertical-align: sub;\n}\n\n.monaco-editor .suggest-details>.monaco-scrollable-element>.body>p:empty {\n\tdisplay: none;\n}\n\n.monaco-editor .suggest-details code {\n\tborder-radius: 3px;\n\tpadding: 0 0.4em;\n}\n\n.monaco-editor .suggest-details ul {\n\tpadding-left: 20px;\n}\n\n.monaco-editor .suggest-details ol {\n\tpadding-left: 20px;\n}\n\n.monaco-editor .suggest-details p code {\n\tfont-family: var(--monaco-monospace-font);\n}\n",""]),t.Z=s},78095:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .codicon.codicon-symbol-array,\n.monaco-workbench .codicon.codicon-symbol-array { color: var(--vscode-symbolIcon-arrayForeground); }\n.monaco-editor .codicon.codicon-symbol-boolean,\n.monaco-workbench .codicon.codicon-symbol-boolean { color: var(--vscode-symbolIcon-booleanForeground); }\n.monaco-editor .codicon.codicon-symbol-class,\n.monaco-workbench .codicon.codicon-symbol-class { color: var(--vscode-symbolIcon-classForeground); }\n.monaco-editor .codicon.codicon-symbol-method,\n.monaco-workbench .codicon.codicon-symbol-method { color: var(--vscode-symbolIcon-methodForeground); }\n.monaco-editor .codicon.codicon-symbol-color,\n.monaco-workbench .codicon.codicon-symbol-color { color: var(--vscode-symbolIcon-colorForeground); }\n.monaco-editor .codicon.codicon-symbol-constant,\n.monaco-workbench .codicon.codicon-symbol-constant { color: var(--vscode-symbolIcon-constantForeground); }\n.monaco-editor .codicon.codicon-symbol-constructor,\n.monaco-workbench .codicon.codicon-symbol-constructor { color: var(--vscode-symbolIcon-constructorForeground); }\n.monaco-editor .codicon.codicon-symbol-value,\n.monaco-workbench .codicon.codicon-symbol-value,\n.monaco-editor .codicon.codicon-symbol-enum,\n.monaco-workbench .codicon.codicon-symbol-enum { color: var(--vscode-symbolIcon-enumeratorForeground); }\n.monaco-editor .codicon.codicon-symbol-enum-member,\n.monaco-workbench .codicon.codicon-symbol-enum-member { color: var(--vscode-symbolIcon-enumeratorMemberForeground); }\n.monaco-editor .codicon.codicon-symbol-event,\n.monaco-workbench .codicon.codicon-symbol-event { color: var(--vscode-symbolIcon-eventForeground); }\n.monaco-editor .codicon.codicon-symbol-field,\n.monaco-workbench .codicon.codicon-symbol-field { color: var(--vscode-symbolIcon-fieldForeground); }\n.monaco-editor .codicon.codicon-symbol-file,\n.monaco-workbench .codicon.codicon-symbol-file { color: var(--vscode-symbolIcon-fileForeground); }\n.monaco-editor .codicon.codicon-symbol-folder,\n.monaco-workbench .codicon.codicon-symbol-folder { color: var(--vscode-symbolIcon-folderForeground); }\n.monaco-editor .codicon.codicon-symbol-function,\n.monaco-workbench .codicon.codicon-symbol-function { color: var(--vscode-symbolIcon-functionForeground); }\n.monaco-editor .codicon.codicon-symbol-interface,\n.monaco-workbench .codicon.codicon-symbol-interface { color: var(--vscode-symbolIcon-interfaceForeground); }\n.monaco-editor .codicon.codicon-symbol-key,\n.monaco-workbench .codicon.codicon-symbol-key { color: var(--vscode-symbolIcon-keyForeground); }\n.monaco-editor .codicon.codicon-symbol-keyword,\n.monaco-workbench .codicon.codicon-symbol-keyword { color: var(--vscode-symbolIcon-keywordForeground); }\n.monaco-editor .codicon.codicon-symbol-module,\n.monaco-workbench .codicon.codicon-symbol-module { color: var(--vscode-symbolIcon-moduleForeground); }\n.monaco-editor .codicon.codicon-symbol-namespace,\n.monaco-workbench .codicon.codicon-symbol-namespace { color: var(--vscode-symbolIcon-namespaceForeground); }\n.monaco-editor .codicon.codicon-symbol-null,\n.monaco-workbench .codicon.codicon-symbol-null { color: var(--vscode-symbolIcon-nullForeground); }\n.monaco-editor .codicon.codicon-symbol-number,\n.monaco-workbench .codicon.codicon-symbol-number { color: var(--vscode-symbolIcon-numberForeground); }\n.monaco-editor .codicon.codicon-symbol-object,\n.monaco-workbench .codicon.codicon-symbol-object { color: var(--vscode-symbolIcon-objectForeground); }\n.monaco-editor .codicon.codicon-symbol-operator,\n.monaco-workbench .codicon.codicon-symbol-operator { color: var(--vscode-symbolIcon-operatorForeground); }\n.monaco-editor .codicon.codicon-symbol-package,\n.monaco-workbench .codicon.codicon-symbol-package { color: var(--vscode-symbolIcon-packageForeground); }\n.monaco-editor .codicon.codicon-symbol-property,\n.monaco-workbench .codicon.codicon-symbol-property { color: var(--vscode-symbolIcon-propertyForeground); }\n.monaco-editor .codicon.codicon-symbol-reference,\n.monaco-workbench .codicon.codicon-symbol-reference { color: var(--vscode-symbolIcon-referenceForeground); }\n.monaco-editor .codicon.codicon-symbol-snippet,\n.monaco-workbench .codicon.codicon-symbol-snippet { color: var(--vscode-symbolIcon-snippetForeground); }\n.monaco-editor .codicon.codicon-symbol-string,\n.monaco-workbench .codicon.codicon-symbol-string { color: var(--vscode-symbolIcon-stringForeground); }\n.monaco-editor .codicon.codicon-symbol-struct,\n.monaco-workbench .codicon.codicon-symbol-struct { color: var(--vscode-symbolIcon-structForeground); }\n.monaco-editor .codicon.codicon-symbol-text,\n.monaco-workbench .codicon.codicon-symbol-text { color: var(--vscode-symbolIcon-textForeground); }\n.monaco-editor .codicon.codicon-symbol-type-parameter,\n.monaco-workbench .codicon.codicon-symbol-type-parameter { color: var(--vscode-symbolIcon-typeParameterForeground); }\n.monaco-editor .codicon.codicon-symbol-unit,\n.monaco-workbench .codicon.codicon-symbol-unit { color: var(--vscode-symbolIcon-unitForeground); }\n.monaco-editor .codicon.codicon-symbol-variable,\n.monaco-workbench .codicon.codicon-symbol-variable { color: var(--vscode-symbolIcon-variableForeground); }\n",""]),t.Z=s},57199:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.editor-banner {\n\tbox-sizing: border-box;\n\tcursor: default;\n\twidth: 100%;\n\tfont-size: 12px;\n\tdisplay: flex;\n\toverflow: visible;\n\n\theight: 26px;\n\n\tbackground: var(--vscode-banner-background);\n}\n\n\n.editor-banner .icon-container {\n\tdisplay: flex;\n\tflex-shrink: 0;\n\talign-items: center;\n\tpadding: 0 6px 0 10px;\n}\n\n.editor-banner .icon-container.custom-icon {\n\tbackground-repeat: no-repeat;\n\tbackground-position: center center;\n\tbackground-size: 16px;\n\twidth: 16px;\n\tpadding: 0;\n\tmargin: 0 6px 0 10px;\n}\n\n.editor-banner .message-container {\n\tdisplay: flex;\n\talign-items: center;\n\tline-height: 26px;\n\ttext-overflow: ellipsis;\n\twhite-space: nowrap;\n\toverflow: hidden;\n}\n\n.editor-banner .message-container p {\n\tmargin-block-start: 0;\n\tmargin-block-end: 0;\n}\n\n.editor-banner .message-actions-container {\n\tflex-grow: 1;\n\tflex-shrink: 0;\n\tline-height: 26px;\n\tmargin: 0 4px;\n}\n\n.editor-banner .message-actions-container a.monaco-button {\n\twidth: inherit;\n\tmargin: 2px 8px;\n\tpadding: 0px 12px;\n}\n\n.editor-banner .message-actions-container a {\n\tpadding: 3px;\n\tmargin-left: 12px;\n\ttext-decoration: underline;\n}\n\n.editor-banner .action-container {\n\tpadding: 0 10px 0 6px;\n}\n\n.editor-banner {\n\tbackground-color: var(--vscode-banner-background);\n}\n\n.editor-banner,\n.editor-banner .action-container .codicon,\n.editor-banner .message-actions-container .monaco-link {\n\tcolor: var(--vscode-banner-foreground);\n}\n\n.editor-banner .icon-container .codicon {\n\tcolor: var(--vscode-banner-iconForeground);\n}\n",""]),t.Z=s},39705:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .unicode-highlight {\n\tborder: 1px solid var(--vscode-editorUnicodeHighlight-border);\n\tbackground-color: var(--vscode-editorUnicodeHighlight-background);\n\tbox-sizing: border-box;\n}\n",""]),t.Z=s},65998:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .focused .selectionHighlight {\n\tbackground-color: var(--vscode-editor-selectionHighlightBackground);\n\tbox-sizing: border-box;\n\tborder: 1px solid var(--vscode-editor-selectionHighlightBorder);\n}\n.monaco-editor.hc-black .focused .selectionHighlight, .monaco-editor.hc-light .focused .selectionHighlight {\n\tborder-style: dotted;\n}\n\n.monaco-editor .wordHighlight {\n\tbackground-color: var(--vscode-editor-wordHighlightBackground);\n\tbox-sizing: border-box;\n\tborder: 1px solid var(--vscode-editor-wordHighlightBorder);\n}\n.monaco-editor.hc-black .wordHighlight, .monaco-editor.hc-light .wordHighlight {\n\tborder-style: dotted;\n}\n\n.monaco-editor .wordHighlightStrong {\n\tbackground-color: var(--vscode-editor-wordHighlightStrongBackground);\n\tbox-sizing: border-box;\n\tborder: 1px solid var(--vscode-editor-wordHighlightStrongBorder);\n}\n.monaco-editor.hc-black .wordHighlightStrong, .monaco-editor.hc-light .wordHighlightStrong {\n\tborder-style: dotted;\n}\n\n.monaco-editor .wordHighlightText {\n\tbackground-color: var(--vscode-editor-wordHighlightTextBackground);\n\tbox-sizing: border-box;\n\tborder: 1px solid var(--vscode-editor-wordHighlightTextBorder);\n}\n.monaco-editor.hc-black .wordHighlightText, .monaco-editor.hc-light .wordHighlightText {\n\tborder-style: dotted;\n}\n",""]),t.Z=s},43126:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n.monaco-editor .zone-widget {\n\tposition: absolute;\n\tz-index: 10;\n}\n\n\n.monaco-editor .zone-widget .zone-widget-container {\n\tborder-top-style: solid;\n\tborder-bottom-style: solid;\n\tborder-top-width: 0;\n\tborder-bottom-width: 0;\n\tposition: relative;\n}\n",""]),t.Z=s},45274:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r),a=i(61667),l=i.n(a),c=new URL(i(6161),i.b),d=new URL(i(51096),i.b),u=s()(o()),h=l()(c),g=l()(d);u.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .iPadShowKeyboard {\n\twidth: 58px;\n\tmin-width: 0;\n\theight: 36px;\n\tmin-height: 0;\n\tmargin: 0;\n\tpadding: 0;\n\tposition: absolute;\n\tresize: none;\n\toverflow: hidden;\n\tbackground: url("+h+") center center no-repeat;\n\tborder: 4px solid #F6F6F6;\n\tborder-radius: 4px;\n}\n\n.monaco-editor.vs-dark .iPadShowKeyboard {\n\tbackground: url("+g+") center center no-repeat;\n\tborder: 4px solid #252526;\n}",""]),t.Z=u},10223:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .tokens-inspect-widget {\n\tz-index: 50;\n\tuser-select: text;\n\t-webkit-user-select: text;\n\tpadding: 10px;\n\tcolor: var(--vscode-editorHoverWidget-foreground);\n\tbackground-color: var(--vscode-editorHoverWidget-background);\n\tborder: 1px solid var(--vscode-editorHoverWidget-border);\n}\n.monaco-editor.hc-black .tokens-inspect-widget, .monaco-editor.hc-light .tokens-inspect-widget {\n\tborder-width: 2px;\n}\n\n.monaco-editor .tokens-inspect-widget .tokens-inspect-separator {\n\theight: 1px;\n\tborder: 0;\n\tbackground-color: var(--vscode-editorHoverWidget-border);\n}\n\n.monaco-editor .tokens-inspect-widget .tm-token {\n\tfont-family: var(--monaco-monospace-font);\n}\n\n.monaco-editor .tokens-inspect-widget .tm-token-length {\n\tfont-weight: normal;\n\tfont-size: 60%;\n\tfloat: right;\n}\n\n.monaco-editor .tokens-inspect-widget .tm-metadata-table {\n\twidth: 100%;\n}\n\n.monaco-editor .tokens-inspect-widget .tm-metadata-value {\n\tfont-family: var(--monaco-monospace-font);\n\ttext-align: right;\n}\n\n.monaco-editor .tokens-inspect-widget .tm-token-type {\n\tfont-family: var(--monaco-monospace-font);\n}\n",""]),t.Z=s},77078:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.quick-input-widget {\n\tfont-size: 13px;\n}\n\n.quick-input-widget .monaco-highlighted-label .highlight,\n.quick-input-widget .monaco-highlighted-label .highlight {\n\tcolor: #0066BF;\n}\n\n.vs .quick-input-widget .monaco-list-row.focused .monaco-highlighted-label .highlight,\n.vs .quick-input-widget .monaco-list-row.focused .monaco-highlighted-label .highlight {\n\tcolor: #9DDDFF;\n}\n\n.vs-dark .quick-input-widget .monaco-highlighted-label .highlight,\n.vs-dark .quick-input-widget .monaco-highlighted-label .highlight {\n\tcolor: #0097fb;\n}\n\n.hc-black .quick-input-widget .monaco-highlighted-label .highlight,\n.hc-black .quick-input-widget .monaco-highlighted-label .highlight {\n\tcolor: #F38518;\n}\n\n.hc-light .quick-input-widget .monaco-highlighted-label .highlight,\n.hc-light .quick-input-widget .monaco-highlighted-label .highlight {\n\tcolor: #0F4A85;\n}\n\n.monaco-keybinding > .monaco-keybinding-key {\n\tbackground-color: rgba(221, 221, 221, 0.4);\n\tborder: solid 1px rgba(204, 204, 204, 0.4);\n\tborder-bottom-color: rgba(187, 187, 187, 0.4);\n\tbox-shadow: inset 0 -1px 0 rgba(187, 187, 187, 0.4);\n\tcolor: #555;\n}\n\n.hc-black .monaco-keybinding > .monaco-keybinding-key {\n\tbackground-color: transparent;\n\tborder: solid 1px rgb(111, 195, 223);\n\tbox-shadow: none;\n\tcolor: #fff;\n}\n\n.hc-light .monaco-keybinding > .monaco-keybinding-key {\n\tbackground-color: transparent;\n\tborder: solid 1px #0F4A85;\n\tbox-shadow: none;\n\tcolor: #292929;\n}\n\n.vs-dark .monaco-keybinding > .monaco-keybinding-key {\n\tbackground-color: rgba(128, 128, 128, 0.17);\n\tborder: solid 1px rgba(51, 51, 51, 0.6);\n\tborder-bottom-color: rgba(68, 68, 68, 0.6);\n\tbox-shadow: inset 0 -1px 0 rgba(68, 68, 68, 0.6);\n\tcolor: #ccc;\n}\n",""]),t.Z=s},72208:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,'/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n\n/* Default standalone editor fonts */\n.monaco-editor {\n\tfont-family: -apple-system, BlinkMacSystemFont, "Segoe WPC", "Segoe UI", "HelveticaNeue-Light", system-ui, "Ubuntu", "Droid Sans", sans-serif;\n\t--monaco-monospace-font: "SF Mono", Monaco, Menlo, Consolas, "Ubuntu Mono", "Liberation Mono", "DejaVu Sans Mono", "Courier New", monospace;\n}\n\n.monaco-menu .monaco-action-bar.vertical .action-item .action-menu-item:focus .action-label {\n\tstroke-width: 1.2px;\n}\n\n.monaco-editor.vs-dark .monaco-menu .monaco-action-bar.vertical .action-menu-item:focus .action-label,\n.monaco-editor.hc-black .monaco-menu .monaco-action-bar.vertical .action-menu-item:focus .action-label,\n.monaco-editor.hc-light .monaco-menu .monaco-action-bar.vertical .action-menu-item:focus .action-label {\n\tstroke-width: 1.2px;\n}\n\n.monaco-hover p {\n\tmargin: 0;\n}\n\n/* See https://github.com/microsoft/monaco-editor/issues/2168#issuecomment-780078600 */\n.monaco-aria-container {\n\tposition: absolute !important;\n\ttop: 0; /* avoid being placed underneath a sibling element */\n\theight: 1px;\n\twidth: 1px;\n\tmargin: -1px;\n\toverflow: hidden;\n\tpadding: 0;\n\tclip: rect(1px, 1px, 1px, 1px);\n\tclip-path: inset(50%);\n}\n\n/*.monaco-editor.vs [tabindex="0"]:focus {\n\toutline: 1px solid rgba(0, 122, 204, 0.4);\n\toutline-offset: -1px;\n\topacity: 1 !important;\n}\n\n.monaco-editor.vs-dark [tabindex="0"]:focus {\n\toutline: 1px solid rgba(14, 99, 156, 0.6);\n\toutline-offset: -1px;\n\topacity: 1 !important;\n}*/\n',""]),t.Z=s},58316:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,'/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.action-widget {\n\tfont-size: 13px;\n\tborder-radius: 0;\n\tmin-width: 160px;\n\tmax-width: 80vw;\n\tz-index: 40;\n\tdisplay: block;\n\twidth: 100%;\n\tborder: 1px solid var(--vscode-editorWidget-border) !important;\n\tborder-radius: 2px;\n\tbackground-color: var(--vscode-editorWidget-background);\n\tcolor: var(--vscode-editorWidget-foreground);\n}\n\n.context-view-block {\n\tposition: fixed;\n\tcursor: initial;\n\tleft: 0;\n\ttop: 0;\n\twidth: 100%;\n\theight: 100%;\n\tz-index: -1;\n}\n\n.context-view-pointerBlock {\n\tposition: fixed;\n\tcursor: initial;\n\tleft: 0;\n\ttop: 0;\n\twidth: 100%;\n\theight: 100%;\n\tz-index: 2;\n}\n\n.action-widget .monaco-list {\n\tuser-select: none;\n\t-webkit-user-select: none;\n\tborder: none !important;\n\tborder-width: 0 !important;\n}\n\n.action-widget .monaco-list:focus:before {\n\toutline: 0 !important;\n}\n\n.action-widget .monaco-list .monaco-scrollable-element {\n\toverflow: visible;\n}\n\n/** Styles for each row in the list element **/\n.action-widget .monaco-list .monaco-list-row {\n\tpadding: 0 10px;\n\twhite-space: nowrap;\n\tcursor: pointer;\n\ttouch-action: none;\n\twidth: 100%;\n}\n\n.action-widget .monaco-list .monaco-list-row.action.focused:not(.option-disabled) {\n\tbackground-color: var(--vscode-quickInputList-focusBackground) !important;\n\tcolor: var(--vscode-quickInputList-focusForeground);\n\toutline: 1px solid var(--vscode-menu-selectionBorder, transparent);\n\toutline-offset: -1px;\n}\n\n.action-widget .monaco-list-row.group-header {\n\tcolor: var(--vscode-descriptionForeground) !important;\n\tfont-weight: 600;\n}\n\n.action-widget .monaco-list .group-header,\n.action-widget .monaco-list .option-disabled,\n.action-widget .monaco-list .option-disabled:before,\n.action-widget .monaco-list .option-disabled .focused,\n.action-widget .monaco-list .option-disabled .focused:before {\n\tcursor: default !important;\n\t-webkit-touch-callout: none;\n\t-webkit-user-select: none;\n\tuser-select: none;\n\tbackground-color: transparent !important;\n\toutline: 0 solid !important;\n}\n\n.action-widget .monaco-list-row.action {\n\tdisplay: flex;\n\tgap: 6px;\n\talign-items: center;\n}\n\n.action-widget .monaco-list-row.action.option-disabled,\n.action-widget .monaco-list:focus .monaco-list-row.focused.action.option-disabled,\n.action-widget .monaco-list-row.action.option-disabled .codicon,\n.action-widget .monaco-list:not(.drop-target):not(.dragging) .monaco-list-row:hover:not(.selected):not(.focused).option-disabled {\n\tcolor: var(--vscode-disabledForeground);\n}\n\n\n.action-widget .monaco-list-row.action:not(.option-disabled) .codicon {\n\tcolor: inherit;\n}\n\n.action-widget .monaco-list-row.action .title {\n\tflex: 1;\n\toverflow: hidden;\n\ttext-overflow: ellipsis;\n}\n\n/* Action bar */\n\n.action-widget .action-widget-action-bar {\n\tbackground-color: var(--vscode-editorHoverWidget-statusBarBackground);\n\tborder-top: 1px solid var(--vscode-editorHoverWidget-border);\n}\n\n.action-widget .action-widget-action-bar::before {\n\tdisplay: block;\n\tcontent: "";\n\twidth: 100%;\n}\n\n.action-widget .action-widget-action-bar .actions-container {\n\tpadding: 0 8px;\n}\n\n.action-widget-action-bar .action-label {\n\tcolor: var(--vscode-textLink-activeForeground);\n\tfont-size: 12px;\n\tline-height: 22px;\n\tpadding: 0;\n\tpointer-events: all;\n}\n\n.action-widget-action-bar .action-item {\n\tmargin-right: 16px;\n\tpointer-events: none;\n}\n\n.action-widget-action-bar .action-label:hover {\n\tbackground-color: transparent !important;\n}\n\n.monaco-action-bar .actions-container.highlight-toggled .action-label.checked {\n\t/* The important gives this rule precedence over the hover rule. */\n\tbackground: var(--vscode-actionBar-toggledBackground) !important;\n}\n',""]),t.Z=s},95861:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-action-bar .action-item.menu-entry .action-label.icon {\n\twidth: 16px;\n\theight: 16px;\n\tbackground-repeat: no-repeat;\n\tbackground-position: 50%;\n\tbackground-size: 16px;\n}\n\n.monaco-dropdown-with-default {\n\tdisplay: flex !important;\n\tflex-direction: row;\n\tborder-radius: 5px;\n}\n\n.monaco-dropdown-with-default > .action-container > .action-label {\n\tmargin-right: 0;\n}\n\n.monaco-dropdown-with-default > .action-container.menu-entry > .action-label.icon {\n\twidth: 16px;\n\theight: 16px;\n\tbackground-repeat: no-repeat;\n\tbackground-position: 50%;\n\tbackground-size: 16px;\n}\n\n.monaco-dropdown-with-default > .dropdown-action-container > .monaco-dropdown > .dropdown-label .codicon[class*='codicon-'] {\n\tfont-size: 12px;\n\tpadding-left: 0px;\n\tpadding-right: 0px;\n\tline-height: 16px;\n\tmargin-left: -3px;\n}\n\n.monaco-dropdown-with-default > .dropdown-action-container > .monaco-dropdown > .dropdown-label > .action-label {\n\tdisplay: block;\n\tbackground-size: 16px;\n\tbackground-position: center center;\n\tbackground-repeat: no-repeat;\n}\n",""]),t.Z=s},48366:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-link {\n\tcolor: var(--vscode-textLink-foreground);\n}\n\n.monaco-link:hover {\n\tcolor: var(--vscode-textLink-activeForeground);\n}\n\n",""]),t.Z=s},11933:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.quick-input-widget {\n\tposition: absolute;\n\twidth: 600px;\n\tz-index: 2550;\n\tleft: 50%;\n\tmargin-left: -300px;\n\t-webkit-app-region: no-drag;\n\tborder-radius: 6px;\n}\n\n.quick-input-titlebar {\n\tdisplay: flex;\n\talign-items: center;\n\tborder-top-left-radius: 5px; /* match border radius of quick input widget */\n\tborder-top-right-radius: 5px;\n}\n\n.quick-input-left-action-bar {\n\tdisplay: flex;\n\tmargin-left: 4px;\n\tflex: 1;\n}\n\n.quick-input-title {\n\tpadding: 3px 0px;\n\ttext-align: center;\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n}\n\n.quick-input-right-action-bar {\n\tdisplay: flex;\n\tmargin-right: 4px;\n\tflex: 1;\n}\n\n.quick-input-right-action-bar > .actions-container {\n\tjustify-content: flex-end;\n}\n\n.quick-input-titlebar .monaco-action-bar .action-label.codicon {\n\tbackground-position: center;\n\tbackground-repeat: no-repeat;\n\tpadding: 2px;\n}\n\n.quick-input-description {\n\tmargin: 6px 6px 6px 11px;\n}\n\n.quick-input-header .quick-input-description {\n\tmargin: 4px 2px;\n\tflex: 1;\n}\n\n.quick-input-header {\n\tdisplay: flex;\n\tpadding: 8px 6px 6px 6px;\n}\n\n.quick-input-widget.hidden-input .quick-input-header {\n\t/* reduce margins and paddings when input box hidden */\n\tpadding: 0;\n\tmargin-bottom: 0;\n}\n\n.quick-input-and-message {\n\tdisplay: flex;\n\tflex-direction: column;\n\tflex-grow: 1;\n\tmin-width: 0;\n\tposition: relative;\n}\n\n.quick-input-check-all {\n\talign-self: center;\n\tmargin: 0;\n}\n\n.quick-input-filter {\n\tflex-grow: 1;\n\tdisplay: flex;\n\tposition: relative;\n}\n\n.quick-input-box {\n\tflex-grow: 1;\n}\n\n.quick-input-widget.show-checkboxes .quick-input-box,\n.quick-input-widget.show-checkboxes .quick-input-message {\n\tmargin-left: 5px;\n}\n\n.quick-input-visible-count {\n\tposition: absolute;\n\tleft: -10000px;\n}\n\n.quick-input-count {\n\talign-self: center;\n\tposition: absolute;\n\tright: 4px;\n\tdisplay: flex;\n\talign-items: center;\n}\n\n.quick-input-count .monaco-count-badge {\n\tvertical-align: middle;\n\tpadding: 2px 4px;\n\tborder-radius: 2px;\n\tmin-height: auto;\n\tline-height: normal;\n}\n\n.quick-input-action {\n\tmargin-left: 6px;\n}\n\n.quick-input-action .monaco-text-button {\n\tfont-size: 11px;\n\tpadding: 0 6px;\n\tdisplay: flex;\n\theight: 25px;\n\talign-items: center;\n}\n\n.quick-input-message {\n\tmargin-top: -1px;\n\tpadding: 5px;\n\toverflow-wrap: break-word;\n}\n\n.quick-input-message > .codicon {\n\tmargin: 0 0.2em;\n\tvertical-align: text-bottom;\n}\n\n/* Links in descriptions & validations */\n.quick-input-message a {\n\tcolor: inherit;\n}\n\n.quick-input-progress.monaco-progress-container {\n\tposition: relative;\n}\n\n.quick-input-list {\n\tline-height: 22px;\n}\n\n.quick-input-widget.hidden-input .quick-input-list {\n\tmargin-top: 4px; /* reduce margins when input box hidden */\n\tpadding-bottom: 4px;\n}\n\n.quick-input-list .monaco-list {\n\toverflow: hidden;\n\tmax-height: calc(20 * 22px);\n\tpadding-bottom: 5px;\n}\n\n.quick-input-list .monaco-scrollable-element {\n\tpadding: 0px 5px;\n}\n\n.quick-input-list .quick-input-list-entry {\n\tbox-sizing: border-box;\n\toverflow: hidden;\n\tdisplay: flex;\n\theight: 100%;\n\tpadding: 0 6px;\n}\n\n.quick-input-list .quick-input-list-entry.quick-input-list-separator-border {\n\tborder-top-width: 1px;\n\tborder-top-style: solid;\n}\n\n.quick-input-list .monaco-list-row {\n\tborder-radius: 3px;\n}\n\n.quick-input-list .monaco-list-row[data-index=\"0\"] .quick-input-list-entry.quick-input-list-separator-border {\n\tborder-top-style: none;\n}\n\n.quick-input-list .quick-input-list-label {\n\toverflow: hidden;\n\tdisplay: flex;\n\theight: 100%;\n\tflex: 1;\n}\n\n.quick-input-list .quick-input-list-checkbox {\n\talign-self: center;\n\tmargin: 0;\n}\n\n.quick-input-list .quick-input-list-icon {\n\tbackground-size: 16px;\n\tbackground-position: left center;\n\tbackground-repeat: no-repeat;\n\tpadding-right: 6px;\n\twidth: 16px;\n\theight: 22px;\n\tdisplay: flex;\n\talign-items: center;\n\tjustify-content: center;\n}\n\n.quick-input-list .quick-input-list-rows {\n\toverflow: hidden;\n\ttext-overflow: ellipsis;\n\tdisplay: flex;\n\tflex-direction: column;\n\theight: 100%;\n\tflex: 1;\n\tmargin-left: 5px;\n}\n\n.quick-input-widget.show-checkboxes .quick-input-list .quick-input-list-rows {\n\tmargin-left: 10px;\n}\n\n.quick-input-widget .quick-input-list .quick-input-list-checkbox {\n\tdisplay: none;\n}\n.quick-input-widget.show-checkboxes .quick-input-list .quick-input-list-checkbox {\n\tdisplay: inline;\n}\n\n.quick-input-list .quick-input-list-rows > .quick-input-list-row {\n\tdisplay: flex;\n\talign-items: center;\n}\n\n.quick-input-list .quick-input-list-rows > .quick-input-list-row .monaco-icon-label,\n.quick-input-list .quick-input-list-rows > .quick-input-list-row .monaco-icon-label .monaco-icon-label-container > .monaco-icon-name-container {\n\tflex: 1; /* make sure the icon label grows within the row */\n}\n\n.quick-input-list .quick-input-list-rows > .quick-input-list-row .codicon[class*='codicon-'] {\n\tvertical-align: text-bottom;\n}\n\n.quick-input-list .quick-input-list-rows .monaco-highlighted-label > span {\n\topacity: 1;\n}\n\n.quick-input-list .quick-input-list-entry .quick-input-list-entry-keybinding {\n\tmargin-right: 8px; /* separate from the separator label or scrollbar if any */\n}\n\n.quick-input-list .quick-input-list-label-meta {\n\topacity: 0.7;\n\tline-height: normal;\n\ttext-overflow: ellipsis;\n\toverflow: hidden;\n}\n\n.quick-input-list .monaco-highlighted-label .highlight {\n\tfont-weight: bold;\n}\n\n.quick-input-list .quick-input-list-entry .quick-input-list-separator {\n\tmargin-right: 4px; /* separate from keybindings or actions */\n}\n\n.quick-input-list .quick-input-list-entry-action-bar {\n\tdisplay: flex;\n\tflex: 0;\n\toverflow: visible;\n}\n\n.quick-input-list .quick-input-list-entry-action-bar .action-label {\n\t/*\n\t * By default, actions in the quick input action bar are hidden\n\t * until hovered over them or selected.\n\t */\n\tdisplay: none;\n}\n\n.quick-input-list .quick-input-list-entry-action-bar .action-label.codicon {\n\tmargin-right: 4px;\n\tpadding: 0px 2px 2px 2px;\n}\n\n.quick-input-list .quick-input-list-entry-action-bar {\n\tmargin-top: 1px;\n}\n\n.quick-input-list .quick-input-list-entry-action-bar {\n\tmargin-right: 4px; /* separate from scrollbar */\n}\n\n.quick-input-list .quick-input-list-entry .quick-input-list-entry-action-bar .action-label.always-visible,\n.quick-input-list .quick-input-list-entry:hover .quick-input-list-entry-action-bar .action-label,\n.quick-input-list .monaco-list-row.focused .quick-input-list-entry-action-bar .action-label {\n\tdisplay: flex;\n}\n\n/* focused items in quick pick */\n.quick-input-list .monaco-list-row.focused .monaco-keybinding-key,\n.quick-input-list .monaco-list-row.focused .quick-input-list-entry .quick-input-list-separator {\n\tcolor: inherit\n}\n.quick-input-list .monaco-list-row.focused .monaco-keybinding-key {\n\tbackground: none;\n}\n\n/* Quick input separators as full-row item */\n.quick-input-list .quick-input-list-separator-as-item {\n\tfont-weight: 600;\n\tfont-size: 12px;\n}\n",""]),t.Z=s},86350:function(e,t,i){"use strict";var n=i(8081),o=i.n(n),r=i(23645),s=i.n(r)()(o());s.push([e.id,"/*---------------------------------------------------------------------------------------------\n *  Copyright (c) Microsoft Corporation. All rights reserved.\n *  Licensed under the MIT License. See License.txt in the project root for license information.\n *--------------------------------------------------------------------------------------------*/\n\n.monaco-editor .zone-widget .codicon.codicon-error,\n.markers-panel .marker-icon.error, .markers-panel .marker-icon .codicon.codicon-error,\n.text-search-provider-messages .providerMessage .codicon.codicon-error,\n.extensions-viewlet > .extensions .codicon.codicon-error,\n.extension-editor .codicon.codicon-error,\n.preferences-editor .codicon.codicon-error {\n\tcolor: var(--vscode-problemsErrorIcon-foreground);\n}\n\n.monaco-editor .zone-widget .codicon.codicon-warning,\n.markers-panel .marker-icon.warning, .markers-panel .marker-icon .codicon.codicon-warning,\n.text-search-provider-messages .providerMessage .codicon.codicon-warning,\n.extensions-viewlet > .extensions .codicon.codicon-warning,\n.extension-editor .codicon.codicon-warning,\n.preferences-editor .codicon.codicon-warning {\n\tcolor: var(--vscode-problemsWarningIcon-foreground);\n}\n\n.monaco-editor .zone-widget .codicon.codicon-info,\n.markers-panel .marker-icon.info, .markers-panel .marker-icon .codicon.codicon-info,\n.text-search-provider-messages .providerMessage .codicon.codicon-info,\n.extensions-viewlet > .extensions .codicon.codicon-info,\n.extension-editor .codicon.codicon-info,\n.preferences-editor .codicon.codicon-info {\n\tcolor: var(--vscode-problemsInfoIcon-foreground);\n}\n",""]),t.Z=s},23645:function(e){"use strict";e.exports=function(e){var t=[];return t.toString=function(){return this.map((function(t){var i="",n=void 0!==t[5];return t[4]&&(i+="@supports (".concat(t[4],") {")),t[2]&&(i+="@media ".concat(t[2]," {")),n&&(i+="@layer".concat(t[5].length>0?" ".concat(t[5]):""," {")),i+=e(t),n&&(i+="}"),t[2]&&(i+="}"),t[4]&&(i+="}"),i})).join("")},t.i=function(e,i,n,o,r){"string"==typeof e&&(e=[[null,e,void 0]]);var s={};if(n)for(var a=0;a<this.length;a++){var l=this[a][0];null!=l&&(s[l]=!0)}for(var c=0;c<e.length;c++){var d=[].concat(e[c]);n&&s[d[0]]||(void 0!==r&&(void 0===d[5]||(d[1]="@layer".concat(d[5].length>0?" ".concat(d[5]):""," {").concat(d[1],"}")),d[5]=r),i&&(d[2]?(d[1]="@media ".concat(d[2]," {").concat(d[1],"}"),d[2]=i):d[2]=i),o&&(d[4]?(d[1]="@supports (".concat(d[4],") {").concat(d[1],"}"),d[4]=o):d[4]="".concat(o)),t.push(d))}},t}},61667:function(e){"use strict";e.exports=function(e,t){return t||(t={}),e?(e=String(e.__esModule?e.default:e),/^['"].*['"]$/.test(e)&&(e=e.slice(1,-1)),t.hash&&(e+=t.hash),/["'() \t\n]|(%20)/.test(e)||t.needQuotes?'"'.concat(e.replace(/"/g,'\\"').replace(/\n/g,"\\n"),'"'):e):e}},8081:function(e){"use strict";e.exports=function(e){return e[1]}},46147:function(e,t){t.features=[{label:"anchorSelect",entry:"vs/editor/contrib/anchorSelect/browser/anchorSelect"},{label:"bracketMatching",entry:"vs/editor/contrib/bracketMatching/browser/bracketMatching"},{label:"browser",entry:"vs/editor/browser/coreCommands"},{label:"caretOperations",entry:["vs/editor/contrib/caretOperations/browser/caretOperations","vs/editor/contrib/caretOperations/browser/transpose"]},{label:"clipboard",entry:"vs/editor/contrib/clipboard/browser/clipboard"},{label:"codeAction",entry:"vs/editor/contrib/codeAction/browser/codeActionContributions"},{label:"codelens",entry:"vs/editor/contrib/codelens/browser/codelensController"},{label:"colorPicker",entry:["vs/editor/contrib/colorPicker/browser/colorContributions","vs/editor/contrib/colorPicker/browser/standaloneColorPickerActions"]},{label:"comment",entry:"vs/editor/contrib/comment/browser/comment"},{label:"contextmenu",entry:"vs/editor/contrib/contextmenu/browser/contextmenu"},{label:"cursorUndo",entry:"vs/editor/contrib/cursorUndo/browser/cursorUndo"},{label:"diffEditor",entry:"vs/editor/browser/widget/diffEditor/diffEditor.contribution"},{label:"dnd",entry:"vs/editor/contrib/dnd/browser/dnd"},{label:"documentSymbols",entry:"vs/editor/contrib/documentSymbols/browser/documentSymbols"},{label:"dropOrPasteInto",entry:["vs/editor/contrib/dropOrPasteInto/browser/copyPasteContribution","vs/editor/contrib/dropOrPasteInto/browser/dropIntoEditorContribution"]},{label:"find",entry:"vs/editor/contrib/find/browser/findController"},{label:"folding",entry:"vs/editor/contrib/folding/browser/folding"},{label:"fontZoom",entry:"vs/editor/contrib/fontZoom/browser/fontZoom"},{label:"format",entry:"vs/editor/contrib/format/browser/formatActions"},{label:"gotoError",entry:"vs/editor/contrib/gotoError/browser/gotoError"},{label:"gotoLine",entry:"vs/editor/standalone/browser/quickAccess/standaloneGotoLineQuickAccess"},{label:"gotoSymbol",entry:["vs/editor/contrib/gotoSymbol/browser/goToCommands","vs/editor/contrib/gotoSymbol/browser/link/goToDefinitionAtPosition"]},{label:"hover",entry:"vs/editor/contrib/hover/browser/hover"},{label:"iPadShowKeyboard",entry:"vs/editor/standalone/browser/iPadShowKeyboard/iPadShowKeyboard"},{label:"inPlaceReplace",entry:"vs/editor/contrib/inPlaceReplace/browser/inPlaceReplace"},{label:"indentation",entry:"vs/editor/contrib/indentation/browser/indentation"},{label:"inlayHints",entry:"vs/editor/contrib/inlayHints/browser/inlayHintsContribution"},{label:"inlineCompletions",entry:"vs/editor/contrib/inlineCompletions/browser/inlineCompletions.contribution"},{label:"inlineProgress",entry:"vs/editor/contrib/inlineProgress/browser/inlineProgress"},{label:"inspectTokens",entry:"vs/editor/standalone/browser/inspectTokens/inspectTokens"},{label:"lineSelection",entry:"vs/editor/contrib/lineSelection/browser/lineSelection"},{label:"linesOperations",entry:"vs/editor/contrib/linesOperations/browser/linesOperations"},{label:"linkedEditing",entry:"vs/editor/contrib/linkedEditing/browser/linkedEditing"},{label:"links",entry:"vs/editor/contrib/links/browser/links"},{label:"longLinesHelper",entry:"vs/editor/contrib/longLinesHelper/browser/longLinesHelper"},{label:"multicursor",entry:"vs/editor/contrib/multicursor/browser/multicursor"},{label:"parameterHints",entry:"vs/editor/contrib/parameterHints/browser/parameterHints"},{label:"quickCommand",entry:"vs/editor/standalone/browser/quickAccess/standaloneCommandsQuickAccess"},{label:"quickHelp",entry:"vs/editor/standalone/browser/quickAccess/standaloneHelpQuickAccess"},{label:"quickOutline",entry:"vs/editor/standalone/browser/quickAccess/standaloneGotoSymbolQuickAccess"},{label:"readOnlyMessage",entry:"vs/editor/contrib/readOnlyMessage/browser/contribution"},{label:"referenceSearch",entry:"vs/editor/standalone/browser/referenceSearch/standaloneReferenceSearch"},{label:"rename",entry:"vs/editor/contrib/rename/browser/rename"},{label:"semanticTokens",entry:["vs/editor/contrib/semanticTokens/browser/documentSemanticTokens","vs/editor/contrib/semanticTokens/browser/viewportSemanticTokens"]},{label:"smartSelect",entry:"vs/editor/contrib/smartSelect/browser/smartSelect"},{label:"snippet",entry:"vs/editor/contrib/snippet/browser/snippetController2"},{label:"stickyScroll",entry:"vs/editor/contrib/stickyScroll/browser/stickyScrollContribution"},{label:"suggest",entry:["vs/editor/contrib/suggest/browser/suggestController","vs/editor/contrib/suggest/browser/suggestInlineCompletions"]},{label:"toggleHighContrast",entry:"vs/editor/standalone/browser/toggleHighContrast/toggleHighContrast"},{label:"toggleTabFocusMode",entry:"vs/editor/contrib/toggleTabFocusMode/browser/toggleTabFocusMode"},{label:"tokenization",entry:"vs/editor/contrib/tokenization/browser/tokenization"},{label:"unicodeHighlighter",entry:"vs/editor/contrib/unicodeHighlighter/browser/unicodeHighlighter"},{label:"unusualLineTerminators",entry:"vs/editor/contrib/unusualLineTerminators/browser/unusualLineTerminators"},{label:"wordHighlighter",entry:"vs/editor/contrib/wordHighlighter/browser/wordHighlighter"},{label:"wordOperations",entry:"vs/editor/contrib/wordOperations/browser/wordOperations"},{label:"wordPartOperations",entry:"vs/editor/contrib/wordPartOperations/browser/wordPartOperations"}],t.languages=[{label:"abap",entry:"vs/basic-languages/abap/abap.contribution"},{label:"apex",entry:"vs/basic-languages/apex/apex.contribution"},{label:"azcli",entry:"vs/basic-languages/azcli/azcli.contribution"},{label:"bat",entry:"vs/basic-languages/bat/bat.contribution"},{label:"bicep",entry:"vs/basic-languages/bicep/bicep.contribution"},{label:"cameligo",entry:"vs/basic-languages/cameligo/cameligo.contribution"},{label:"clojure",entry:"vs/basic-languages/clojure/clojure.contribution"},{label:"coffee",entry:"vs/basic-languages/coffee/coffee.contribution"},{label:"cpp",entry:"vs/basic-languages/cpp/cpp.contribution"},{label:"csharp",entry:"vs/basic-languages/csharp/csharp.contribution"},{label:"csp",entry:"vs/basic-languages/csp/csp.contribution"},{label:"css",entry:["vs/basic-languages/css/css.contribution","vs/language/css/monaco.contribution"],worker:{id:"vs/language/css/cssWorker",entry:"vs/language/css/css.worker"}},{label:"cypher",entry:"vs/basic-languages/cypher/cypher.contribution"},{label:"dart",entry:"vs/basic-languages/dart/dart.contribution"},{label:"dockerfile",entry:"vs/basic-languages/dockerfile/dockerfile.contribution"},{label:"ecl",entry:"vs/basic-languages/ecl/ecl.contribution"},{label:"elixir",entry:"vs/basic-languages/elixir/elixir.contribution"},{label:"flow9",entry:"vs/basic-languages/flow9/flow9.contribution"},{label:"freemarker2",entry:"vs/basic-languages/freemarker2/freemarker2.contribution"},{label:"fsharp",entry:"vs/basic-languages/fsharp/fsharp.contribution"},{label:"go",entry:"vs/basic-languages/go/go.contribution"},{label:"graphql",entry:"vs/basic-languages/graphql/graphql.contribution"},{label:"handlebars",entry:"vs/basic-languages/handlebars/handlebars.contribution"},{label:"hcl",entry:"vs/basic-languages/hcl/hcl.contribution"},{label:"html",entry:["vs/basic-languages/html/html.contribution","vs/language/html/monaco.contribution"],worker:{id:"vs/language/html/htmlWorker",entry:"vs/language/html/html.worker"}},{label:"ini",entry:"vs/basic-languages/ini/ini.contribution"},{label:"java",entry:"vs/basic-languages/java/java.contribution"},{label:"javascript",entry:"vs/basic-languages/javascript/javascript.contribution"},{label:"json",entry:"vs/language/json/monaco.contribution",worker:{id:"vs/language/json/jsonWorker",entry:"vs/language/json/json.worker"}},{label:"julia",entry:"vs/basic-languages/julia/julia.contribution"},{label:"kotlin",entry:"vs/basic-languages/kotlin/kotlin.contribution"},{label:"less",entry:"vs/basic-languages/less/less.contribution"},{label:"lexon",entry:"vs/basic-languages/lexon/lexon.contribution"},{label:"liquid",entry:"vs/basic-languages/liquid/liquid.contribution"},{label:"lua",entry:"vs/basic-languages/lua/lua.contribution"},{label:"m3",entry:"vs/basic-languages/m3/m3.contribution"},{label:"markdown",entry:"vs/basic-languages/markdown/markdown.contribution"},{label:"mdx",entry:"vs/basic-languages/mdx/mdx.contribution"},{label:"mips",entry:"vs/basic-languages/mips/mips.contribution"},{label:"msdax",entry:"vs/basic-languages/msdax/msdax.contribution"},{label:"mysql",entry:"vs/basic-languages/mysql/mysql.contribution"},{label:"objective-c",entry:"vs/basic-languages/objective-c/objective-c.contribution"},{label:"pascal",entry:"vs/basic-languages/pascal/pascal.contribution"},{label:"pascaligo",entry:"vs/basic-languages/pascaligo/pascaligo.contribution"},{label:"perl",entry:"vs/basic-languages/perl/perl.contribution"},{label:"pgsql",entry:"vs/basic-languages/pgsql/pgsql.contribution"},{label:"php",entry:"vs/basic-languages/php/php.contribution"},{label:"pla",entry:"vs/basic-languages/pla/pla.contribution"},{label:"postiats",entry:"vs/basic-languages/postiats/postiats.contribution"},{label:"powerquery",entry:"vs/basic-languages/powerquery/powerquery.contribution"},{label:"powershell",entry:"vs/basic-languages/powershell/powershell.contribution"},{label:"protobuf",entry:"vs/basic-languages/protobuf/protobuf.contribution"},{label:"pug",entry:"vs/basic-languages/pug/pug.contribution"},{label:"python",entry:"vs/basic-languages/python/python.contribution"},{label:"qsharp",entry:"vs/basic-languages/qsharp/qsharp.contribution"},{label:"r",entry:"vs/basic-languages/r/r.contribution"},{label:"razor",entry:"vs/basic-languages/razor/razor.contribution"},{label:"redis",entry:"vs/basic-languages/redis/redis.contribution"},{label:"redshift",entry:"vs/basic-languages/redshift/redshift.contribution"},{label:"restructuredtext",entry:"vs/basic-languages/restructuredtext/restructuredtext.contribution"},{label:"ruby",entry:"vs/basic-languages/ruby/ruby.contribution"},{label:"rust",entry:"vs/basic-languages/rust/rust.contribution"},{label:"sb",entry:"vs/basic-languages/sb/sb.contribution"},{label:"scala",entry:"vs/basic-languages/scala/scala.contribution"},{label:"scheme",entry:"vs/basic-languages/scheme/scheme.contribution"},{label:"scss",entry:"vs/basic-languages/scss/scss.contribution"},{label:"shell",entry:"vs/basic-languages/shell/shell.contribution"},{label:"solidity",entry:"vs/basic-languages/solidity/solidity.contribution"},{label:"sophia",entry:"vs/basic-languages/sophia/sophia.contribution"},{label:"sparql",entry:"vs/basic-languages/sparql/sparql.contribution"},{label:"sql",entry:"vs/basic-languages/sql/sql.contribution"},{label:"st",entry:"vs/basic-languages/st/st.contribution"},{label:"swift",entry:"vs/basic-languages/swift/swift.contribution"},{label:"systemverilog",entry:"vs/basic-languages/systemverilog/systemverilog.contribution"},{label:"tcl",entry:"vs/basic-languages/tcl/tcl.contribution"},{label:"twig",entry:"vs/basic-languages/twig/twig.contribution"},{label:"typescript",entry:["vs/basic-languages/typescript/typescript.contribution","vs/language/typescript/monaco.contribution"],worker:{id:"vs/language/typescript/tsWorker",entry:"vs/language/typescript/ts.worker"}},{label:"vb",entry:"vs/basic-languages/vb/vb.contribution"},{label:"wgsl",entry:"vs/basic-languages/wgsl/wgsl.contribution"},{label:"xml",entry:"vs/basic-languages/xml/xml.contribution"},{label:"yaml",entry:"vs/basic-languages/yaml/yaml.contribution"}]},76736:function(e,t,i){"use strict";i.r(t),i.d(t,{PixelRatio:function(){return d},addMatchMediaChangeListener:function(){return c},getZoomFactor:function(){return u},isAndroid:function(){return _},isChrome:function(){return m},isElectron:function(){return v},isFirefox:function(){return g},isSafari:function(){return f},isStandalone:function(){return C},isWebKit:function(){return p},isWebkitWebView:function(){return b}});var n=i(99817),o=i(63801),r=i(68921);class s{constructor(){this._zoomFactor=1}getZoomFactor(){return this._zoomFactor}}s.INSTANCE=new s;class a extends r.Disposable{constructor(){super(),this._onDidChange=this._register(new o.Emitter),this.onDidChange=this._onDidChange.event,this._listener=()=>this._handleChange(!0),this._mediaQueryList=null,this._handleChange(!1)}_handleChange(e){var t;null===(t=this._mediaQueryList)||void 0===t||t.removeEventListener("change",this._listener),this._mediaQueryList=n.$window.matchMedia(`(resolution: ${n.$window.devicePixelRatio}dppx)`),this._mediaQueryList.addEventListener("change",this._listener),e&&this._onDidChange.fire()}}class l extends r.Disposable{get value(){return this._value}constructor(){super(),this._onDidChange=this._register(new o.Emitter),this.onDidChange=this._onDidChange.event,this._value=this._getPixelRatio();const e=this._register(new a);this._register(e.onDidChange((()=>{this._value=this._getPixelRatio(),this._onDidChange.fire(this._value)})))}_getPixelRatio(){const e=document.createElement("canvas").getContext("2d");return(n.$window.devicePixelRatio||1)/(e.webkitBackingStorePixelRatio||e.mozBackingStorePixelRatio||e.msBackingStorePixelRatio||e.oBackingStorePixelRatio||e.backingStorePixelRatio||1)}}function c(e,t){"string"==typeof e&&(e=n.$window.matchMedia(e)),e.addEventListener("change",t)}const d=new class{constructor(){this._pixelRatioMonitor=null}_getOrCreatePixelRatioMonitor(){return this._pixelRatioMonitor||(this._pixelRatioMonitor=(0,r.markAsSingleton)(new l)),this._pixelRatioMonitor}get value(){return this._getOrCreatePixelRatioMonitor().value}get onDidChange(){return this._getOrCreatePixelRatioMonitor().onDidChange}};function u(){return s.INSTANCE.getZoomFactor()}const h=navigator.userAgent,g=h.indexOf("Firefox")>=0,p=h.indexOf("AppleWebKit")>=0,m=h.indexOf("Chrome")>=0,f=!m&&h.indexOf("Safari")>=0,b=!m&&!f&&p,v=h.indexOf("Electron/")>=0,_=h.indexOf("Android")>=0;let A=!1;if(n.$window.matchMedia){const e=n.$window.matchMedia("(display-mode: standalone) or (display-mode: window-controls-overlay)"),t=n.$window.matchMedia("(display-mode: fullscreen)");A=e.matches,c(e,(({matches:e})=>{A&&t.matches||(A=e)}))}function C(){return A}},69098:function(e,t,i){"use strict";i.r(t),i.d(t,{BrowserFeatures:function(){return s}});var n=i(76736),o=i(99817),r=i(66719);const s={clipboard:{writeText:r.isNative||document.queryCommandSupported&&document.queryCommandSupported("copy")||!!(navigator&&navigator.clipboard&&navigator.clipboard.writeText),readText:r.isNative||!!(navigator&&navigator.clipboard&&navigator.clipboard.readText)},keyboard:r.isNative||n.isStandalone()?0:navigator.keyboard||n.isSafari?1:2,touch:"ontouchstart"in o.mainWindow||navigator.maxTouchPoints>0,pointerEvents:o.mainWindow.PointerEvent&&("ontouchstart"in o.mainWindow||navigator.maxTouchPoints>0||navigator.maxTouchPoints>0)}},31160:function(e,t,i){"use strict";i.r(t),i.d(t,{DefaultWorkerFactory:function(){return l}});var n=i(1639),o=i(12718),r=i(50302);const s=(0,n.createTrustedTypesPolicy)("defaultWorkerFactory",{createScriptURL:e=>e});class a{constructor(e,t,i,n,o){this.id=t,this.label=i;const r=function(e){const t=globalThis.MonacoEnvironment;if(t){if("function"==typeof t.getWorker)return t.getWorker("workerMain.js",e);if("function"==typeof t.getWorkerUrl){const i=t.getWorkerUrl("workerMain.js",e);return new Worker(s?s.createScriptURL(i):i,{name:e})}}throw new Error("You must define a function MonacoEnvironment.getWorkerUrl or MonacoEnvironment.getWorker")}(i);"function"==typeof r.then?this.worker=r:this.worker=Promise.resolve(r),this.postMessage(e,[]),this.worker.then((e=>{e.onmessage=function(e){n(e.data)},e.onmessageerror=o,"function"==typeof e.addEventListener&&e.addEventListener("error",o)}))}getId(){return this.id}postMessage(e,t){var i;null===(i=this.worker)||void 0===i||i.then((i=>{try{i.postMessage(e,t)}catch(e){(0,o.onUnexpectedError)(e),(0,o.onUnexpectedError)(new Error(`FAILED to post message to '${this.label}'-worker`,{cause:e}))}}))}dispose(){var e;null===(e=this.worker)||void 0===e||e.then((e=>e.terminate())),this.worker=null}}class l{constructor(e){this._label=e,this._webWorkerFailedBeforeError=!1}create(e,t,i){const n=++l.LAST_WORKER_ID;if(this._webWorkerFailedBeforeError)throw this._webWorkerFailedBeforeError;return new a(e,n,this._label||"anonymous"+n,t,(e=>{(0,r.logOnceWebWorkerWarning)(e),this._webWorkerFailedBeforeError=e,i(e)}))}}l.LAST_WORKER_ID=0},65174:function(e,t,i){"use strict";i.r(t),i.d(t,{DataTransfers:function(){return n}});const n={RESOURCES:"ResourceURLs",DOWNLOAD_URL:"DownloadURL",FILES:"Files",TEXT:i(5121).Mimes.text,INTERNAL_URI_LIST:"application/vnd.code.uri-list"}},96747:function(e,t,i){"use strict";i.r(t),i.d(t,{$:function(){return Fe},Dimension:function(){return K},DragAndDropObserver:function(){return $e},EventHelper:function(){return xe},EventType:function(){return ye},ModifierKeyEmitter:function(){return Ye},Namespace:function(){return Be},WindowIdleValue:function(){return F},WindowIntervalTimer:function(){return W},addDisposableGenericMouseDownListener:function(){return R},addDisposableGenericMouseUpListener:function(){return B},addDisposableListener:function(){return I},addStandardDisposableGenericMouseDownListener:function(){return M},addStandardDisposableGenericMouseUpListener:function(){return N},addStandardDisposableListener:function(){return T},after:function(){return Le},animate:function(){return Ue},append:function(){return Te},asCSSPropertyValue:function(){return Ke},asCSSUrl:function(){return Qe},asCssValueWithDefault:function(){return je},basicMarkupHtmlTags:function(){return qe},clearNode:function(){return k},computeScreenAwareSize:function(){return He},createCSSRule:function(){return ve},createStyleSheet:function(){return he},findParentWithClass:function(){return te},getActiveDocument:function(){return ce},getActiveElement:function(){return se},getActiveWindow:function(){return de},getClientArea:function(){return U},getComputedStyle:function(){return V},getContentHeight:function(){return Z},getContentWidth:function(){return J},getDocument:function(){return v},getDomNodePagePosition:function(){return q},getDomNodeZoomLevel:function(){return Y},getShadowRoot:function(){return re},getTopLeftOffset:function(){return j},getTotalHeight:function(){return X},getTotalWidth:function(){return $},getWindow:function(){return b},getWindowById:function(){return w},getWindowId:function(){return C},getWindows:function(){return _},getWindowsCount:function(){return A},h:function(){return Ze},hasParentWithClass:function(){return ie},hasWindow:function(){return y},hide:function(){return We},hookDomPurifyHrefAndSrcSanitizer:function(){return Ge},isActiveElement:function(){return ae},isAncestor:function(){return ee},isAncestorOfActiveElement:function(){return le},isEventLike:function(){return Se},isInShadowDOM:function(){return oe},isKeyboardEvent:function(){return we},isMouseEvent:function(){return Ce},isShadowRoot:function(){return ne},onDidRegisterWindow:function(){return S},onDidUnregisterWindow:function(){return E},onWillUnregisterWindow:function(){return x},prepend:function(){return Me},registerWindow:function(){return f},removeCSSRulesContainingSelector:function(){return _e},reset:function(){return Ne},restoreParentsScrollTop:function(){return ke},runAtThisOrScheduleAtNextAnimationFrame:function(){return P},runWhenWindowIdle:function(){return O},saveParentsScrollTop:function(){return Ee},scheduleAtNextAnimationFrame:function(){return z},setVisibility:function(){return Pe},sharedMutationObserver:function(){return pe},show:function(){return ze},size:function(){return G},trackFocus:function(){return Ie},windowOpenNoOpener:function(){return Ve}});var n=i(76736),o=i(69098),r=i(8769),s=i(5642),a=i(66129),l=i(12718),c=i(63801),d=i(9709),u=i(68921),h=i(27952),g=i(66719),p=i(23829),m=i(99817);const{registerWindow:f,getWindow:b,getDocument:v,getWindows:_,getWindowsCount:A,getWindowId:C,getWindowById:w,hasWindow:y,onDidRegisterWindow:S,onWillUnregisterWindow:x,onDidUnregisterWindow:E}=function(){const e=new Map;(0,m.ensureCodeWindow)(m.mainWindow,1),e.set(m.mainWindow.vscodeWindowId,{window:m.mainWindow,disposables:new u.DisposableStore});const t=new c.Emitter,i=new c.Emitter,n=new c.Emitter;return{onDidRegisterWindow:t.event,onWillUnregisterWindow:n.event,onDidUnregisterWindow:i.event,registerWindow(o){if(e.has(o.vscodeWindowId))return u.Disposable.None;const r=new u.DisposableStore,s={window:o,disposables:r.add(new u.DisposableStore)};return e.set(o.vscodeWindowId,s),r.add((0,u.toDisposable)((()=>{e.delete(o.vscodeWindowId),i.fire(o)}))),r.add(I(o,ye.BEFORE_UNLOAD,(()=>{n.fire(o)}))),t.fire(s),r},getWindows(){return e.values()},getWindowsCount(){return e.size},getWindowId(e){return e.vscodeWindowId},hasWindow(t){return e.has(t)},getWindowById(t){return e.get(t)},getWindow(e){var t;const i=e;if(null===(t=null==i?void 0:i.ownerDocument)||void 0===t?void 0:t.defaultView)return i.ownerDocument.defaultView.window;const n=e;return(null==n?void 0:n.view)?n.view.window:m.mainWindow},getDocument(e){return b(e).document}}}();function k(e){for(;e.firstChild;)e.firstChild.remove()}class D{constructor(e,t,i,n){this._node=e,this._type=t,this._handler=i,this._options=n||!1,this._node.addEventListener(this._type,this._handler,this._options)}dispose(){this._handler&&(this._node.removeEventListener(this._type,this._handler,this._options),this._node=null,this._handler=null)}}function I(e,t,i,n){return new D(e,t,i,n)}function L(e,t){return function(i){return t(new s.StandardMouseEvent(e,i))}}const T=function(e,t,i,n){let o=i;return"click"===t||"mousedown"===t?o=L(b(e),i):"keydown"!==t&&"keypress"!==t&&"keyup"!==t||(o=function(e){return function(t){return e(new r.StandardKeyboardEvent(t))}}(i)),I(e,t,o,n)},M=function(e,t,i){return R(e,L(b(e),t),i)},N=function(e,t,i){return B(e,L(b(e),t),i)};function R(e,t,i){return I(e,g.isIOS&&o.BrowserFeatures.pointerEvents?ye.POINTER_DOWN:ye.MOUSE_DOWN,t,i)}function B(e,t,i){return I(e,g.isIOS&&o.BrowserFeatures.pointerEvents?ye.POINTER_UP:ye.MOUSE_UP,t,i)}function O(e,t,i){return(0,a._runWhenIdle)(e,t,i)}class F extends a.AbstractIdleValue{constructor(e,t){super(e,t)}}let P,z;class W extends a.IntervalTimer{cancelAndSet(e,t,i){return super.cancelAndSet(e,t,i)}}class H{constructor(e,t=0){this._runner=e,this.priority=t,this._canceled=!1}dispose(){this._canceled=!0}execute(){if(!this._canceled)try{this._runner()}catch(e){(0,l.onUnexpectedError)(e)}}static sort(e,t){return t.priority-e.priority}}function V(e){return b(e).getComputedStyle(e,null)}function U(e,t){const i=b(e),n=i.document;if(e!==n.body)return new K(e.clientWidth,e.clientHeight);if(g.isIOS&&(null==i?void 0:i.visualViewport))return new K(i.visualViewport.width,i.visualViewport.height);if((null==i?void 0:i.innerWidth)&&i.innerHeight)return new K(i.innerWidth,i.innerHeight);if(n.body&&n.body.clientWidth&&n.body.clientHeight)return new K(n.body.clientWidth,n.body.clientHeight);if(n.documentElement&&n.documentElement.clientWidth&&n.documentElement.clientHeight)return new K(n.documentElement.clientWidth,n.documentElement.clientHeight);if(t)return U(t);throw new Error("Unable to figure out browser width and height")}!function(){const e=new Map,t=new Map,i=new Map,n=new Map;z=(o,r,s=0)=>{const a=C(o),l=new H(r,s);let c=e.get(a);return c||(c=[],e.set(a,c)),c.push(l),i.get(a)||(i.set(a,!0),o.requestAnimationFrame((()=>(o=>{var r;i.set(o,!1);const s=null!==(r=e.get(o))&&void 0!==r?r:[];for(t.set(o,s),e.set(o,[]),n.set(o,!0);s.length>0;)s.sort(H.sort),s.shift().execute();n.set(o,!1)})(a)))),l},P=(e,i,o)=>{const r=C(e);if(n.get(r)){const e=new H(i,o);let n=t.get(r);return n||(n=[],t.set(r,n)),n.push(e),e}return z(e,i,o)}}();class Q{static convertToPixels(e,t){return parseFloat(t)||0}static getDimension(e,t,i){const n=V(e),o=n?n.getPropertyValue(t):"0";return Q.convertToPixels(e,o)}static getBorderLeftWidth(e){return Q.getDimension(e,"border-left-width","borderLeftWidth")}static getBorderRightWidth(e){return Q.getDimension(e,"border-right-width","borderRightWidth")}static getBorderTopWidth(e){return Q.getDimension(e,"border-top-width","borderTopWidth")}static getBorderBottomWidth(e){return Q.getDimension(e,"border-bottom-width","borderBottomWidth")}static getPaddingLeft(e){return Q.getDimension(e,"padding-left","paddingLeft")}static getPaddingRight(e){return Q.getDimension(e,"padding-right","paddingRight")}static getPaddingTop(e){return Q.getDimension(e,"padding-top","paddingTop")}static getPaddingBottom(e){return Q.getDimension(e,"padding-bottom","paddingBottom")}static getMarginLeft(e){return Q.getDimension(e,"margin-left","marginLeft")}static getMarginTop(e){return Q.getDimension(e,"margin-top","marginTop")}static getMarginRight(e){return Q.getDimension(e,"margin-right","marginRight")}static getMarginBottom(e){return Q.getDimension(e,"margin-bottom","marginBottom")}}class K{constructor(e,t){this.width=e,this.height=t}with(e=this.width,t=this.height){return e!==this.width||t!==this.height?new K(e,t):this}static is(e){return"object"==typeof e&&"number"==typeof e.height&&"number"==typeof e.width}static lift(e){return e instanceof K?e:new K(e.width,e.height)}static equals(e,t){return e===t||!(!e||!t)&&(e.width===t.width&&e.height===t.height)}}function j(e){let t=e.offsetParent,i=e.offsetTop,n=e.offsetLeft;for(;null!==(e=e.parentNode)&&e!==e.ownerDocument.body&&e!==e.ownerDocument.documentElement;){i-=e.scrollTop;const o=ne(e)?null:V(e);o&&(n-="rtl"!==o.direction?e.scrollLeft:-e.scrollLeft),e===t&&(n+=Q.getBorderLeftWidth(e),i+=Q.getBorderTopWidth(e),i+=e.offsetTop,n+=e.offsetLeft,t=e.offsetParent)}return{left:n,top:i}}function G(e,t,i){"number"==typeof t&&(e.style.width=`${t}px`),"number"==typeof i&&(e.style.height=`${i}px`)}function q(e){const t=e.getBoundingClientRect(),i=b(e);return{left:t.left+i.scrollX,top:t.top+i.scrollY,width:t.width,height:t.height}}function Y(e){let t=e,i=1;do{const e=V(t).zoom;null!=e&&"1"!==e&&(i*=e),t=t.parentElement}while(null!==t&&t!==t.ownerDocument.documentElement);return i}function $(e){const t=Q.getMarginLeft(e)+Q.getMarginRight(e);return e.offsetWidth+t}function J(e){const t=Q.getBorderLeftWidth(e)+Q.getBorderRightWidth(e),i=Q.getPaddingLeft(e)+Q.getPaddingRight(e);return e.offsetWidth-t-i}function Z(e){const t=Q.getBorderTopWidth(e)+Q.getBorderBottomWidth(e),i=Q.getPaddingTop(e)+Q.getPaddingBottom(e);return e.offsetHeight-t-i}function X(e){const t=Q.getMarginTop(e)+Q.getMarginBottom(e);return e.offsetHeight+t}function ee(e,t){return Boolean(null==t?void 0:t.contains(e))}function te(e,t,i){for(;e&&e.nodeType===e.ELEMENT_NODE;){if(e.classList.contains(t))return e;if(i)if("string"==typeof i){if(e.classList.contains(i))return null}else if(e===i)return null;e=e.parentNode}return null}function ie(e,t,i){return!!te(e,t,i)}function ne(e){return e&&!!e.host&&!!e.mode}function oe(e){return!!re(e)}function re(e){for(var t;e.parentNode;){if(e===(null===(t=e.ownerDocument)||void 0===t?void 0:t.body))return null;e=e.parentNode}return ne(e)?e:null}function se(){let e=ce().activeElement;for(;null==e?void 0:e.shadowRoot;)e=e.shadowRoot.activeElement;return e}function ae(e){return e.ownerDocument.activeElement===e}function le(e){return ee(e.ownerDocument.activeElement,e)}function ce(){var e;if(A()<=1)return document;return null!==(e=Array.from(_()).map((({window:e})=>e.document)).find((e=>e.hasFocus())))&&void 0!==e?e:document}function de(){var e,t;return null!==(t=null===(e=ce().defaultView)||void 0===e?void 0:e.window)&&void 0!==t?t:m.mainWindow}K.None=new K(0,0);const ue=new Map;function he(e=m.mainWindow.document.head,t,i){const n=document.createElement("style");if(n.type="text/css",n.media="screen",null==t||t(n),e.appendChild(n),i&&i.add((0,u.toDisposable)((()=>e.removeChild(n)))),e===m.mainWindow.document.head){const e=new Set;ue.set(n,e);for(const{window:t,disposables:o}of _()){if(t===m.mainWindow)continue;const r=o.add(ge(n,e,t));null==i||i.add(r)}}return n}function ge(e,t,i){var n,o;const r=new u.DisposableStore,s=e.cloneNode(!0);i.document.head.appendChild(s),r.add((0,u.toDisposable)((()=>i.document.head.removeChild(s))));for(const t of be(e))null===(n=s.sheet)||void 0===n||n.insertRule(t.cssText,null===(o=s.sheet)||void 0===o?void 0:o.cssRules.length);return r.add(pe.observe(e,r,{childList:!0})((()=>{s.textContent=e.textContent}))),t.add(s),r.add((0,u.toDisposable)((()=>t.delete(s)))),r}const pe=new class{constructor(){this.mutationObservers=new Map}observe(e,t,i){let n=this.mutationObservers.get(e);n||(n=new Map,this.mutationObservers.set(e,n));const o=(0,p.hash)(i);let r=n.get(o);if(r)r.users+=1;else{const s=new c.Emitter,a=new MutationObserver((e=>s.fire(e)));a.observe(e,i);const l=r={users:1,observer:a,onDidMutate:s.event};t.add((0,u.toDisposable)((()=>{l.users-=1,0===l.users&&(s.dispose(),a.disconnect(),null==n||n.delete(o),0===(null==n?void 0:n.size)&&this.mutationObservers.delete(e))}))),n.set(o,r)}return r.onDidMutate}};let me=null;function fe(){return me||(me=he()),me}function be(e){var t,i;return(null===(t=null==e?void 0:e.sheet)||void 0===t?void 0:t.rules)?e.sheet.rules:(null===(i=null==e?void 0:e.sheet)||void 0===i?void 0:i.cssRules)?e.sheet.cssRules:[]}function ve(e,t,i=fe()){var n,o;if(i&&t){null===(n=i.sheet)||void 0===n||n.insertRule(`${e} {${t}}`,0);for(const n of null!==(o=ue.get(i))&&void 0!==o?o:[])ve(e,t,n)}}function _e(e,t=fe()){var i,n;if(!t)return;const o=be(t),r=[];for(let t=0;t<o.length;t++){const i=o[t];Ae(i)&&-1!==i.selectorText.indexOf(e)&&r.push(t)}for(let e=r.length-1;e>=0;e--)null===(i=t.sheet)||void 0===i||i.deleteRule(r[e]);for(const i of null!==(n=ue.get(t))&&void 0!==n?n:[])_e(e,i)}function Ae(e){return"string"==typeof e.selectorText}function Ce(e){return e instanceof MouseEvent||e instanceof b(e).MouseEvent}function we(e){return e instanceof KeyboardEvent||e instanceof b(e).KeyboardEvent}const ye={CLICK:"click",AUXCLICK:"auxclick",DBLCLICK:"dblclick",MOUSE_UP:"mouseup",MOUSE_DOWN:"mousedown",MOUSE_OVER:"mouseover",MOUSE_MOVE:"mousemove",MOUSE_OUT:"mouseout",MOUSE_ENTER:"mouseenter",MOUSE_LEAVE:"mouseleave",MOUSE_WHEEL:"wheel",POINTER_UP:"pointerup",POINTER_DOWN:"pointerdown",POINTER_MOVE:"pointermove",POINTER_LEAVE:"pointerleave",CONTEXT_MENU:"contextmenu",WHEEL:"wheel",KEY_DOWN:"keydown",KEY_PRESS:"keypress",KEY_UP:"keyup",LOAD:"load",BEFORE_UNLOAD:"beforeunload",UNLOAD:"unload",PAGE_SHOW:"pageshow",PAGE_HIDE:"pagehide",PASTE:"paste",ABORT:"abort",ERROR:"error",RESIZE:"resize",SCROLL:"scroll",FULLSCREEN_CHANGE:"fullscreenchange",WK_FULLSCREEN_CHANGE:"webkitfullscreenchange",SELECT:"select",CHANGE:"change",SUBMIT:"submit",RESET:"reset",FOCUS:"focus",FOCUS_IN:"focusin",FOCUS_OUT:"focusout",BLUR:"blur",INPUT:"input",STORAGE:"storage",DRAG_START:"dragstart",DRAG:"drag",DRAG_ENTER:"dragenter",DRAG_LEAVE:"dragleave",DRAG_OVER:"dragover",DROP:"drop",DRAG_END:"dragend",ANIMATION_START:n.isWebKit?"webkitAnimationStart":"animationstart",ANIMATION_END:n.isWebKit?"webkitAnimationEnd":"animationend",ANIMATION_ITERATION:n.isWebKit?"webkitAnimationIteration":"animationiteration"};function Se(e){const t=e;return!(!t||"function"!=typeof t.preventDefault||"function"!=typeof t.stopPropagation)}const xe={stop:(e,t)=>(e.preventDefault(),t&&e.stopPropagation(),e)};function Ee(e){const t=[];for(let i=0;e&&e.nodeType===e.ELEMENT_NODE;i++)t[i]=e.scrollTop,e=e.parentNode;return t}function ke(e,t){for(let i=0;e&&e.nodeType===e.ELEMENT_NODE;i++)e.scrollTop!==t[i]&&(e.scrollTop=t[i]),e=e.parentNode}class De extends u.Disposable{static hasFocusWithin(e){if(e instanceof HTMLElement){const t=re(e);return ee(t?t.activeElement:e.ownerDocument.activeElement,e)}{const t=e;return ee(t.document.activeElement,t.document)}}constructor(e){super(),this._onDidFocus=this._register(new c.Emitter),this.onDidFocus=this._onDidFocus.event,this._onDidBlur=this._register(new c.Emitter),this.onDidBlur=this._onDidBlur.event;let t=De.hasFocusWithin(e),i=!1;const n=()=>{i=!1,t||(t=!0,this._onDidFocus.fire())},o=()=>{t&&(i=!0,(e instanceof HTMLElement?b(e):e).setTimeout((()=>{i&&(i=!1,t=!1,this._onDidBlur.fire())}),0))};this._refreshStateHandler=()=>{De.hasFocusWithin(e)!==t&&(t?o():n())},this._register(I(e,ye.FOCUS,n,!0)),this._register(I(e,ye.BLUR,o,!0)),e instanceof HTMLElement&&(this._register(I(e,ye.FOCUS_IN,(()=>this._refreshStateHandler()))),this._register(I(e,ye.FOCUS_OUT,(()=>this._refreshStateHandler()))))}}function Ie(e){return new De(e)}function Le(e,t){return e.after(t),t}function Te(e,...t){if(e.append(...t),1===t.length&&"string"!=typeof t[0])return t[0]}function Me(e,t){return e.insertBefore(t,e.firstChild),t}function Ne(e,...t){e.innerText="",Te(e,...t)}const Re=/([\w\-]+)?(#([\w\-]+))?((\.([\w\-]+))*)/;var Be;function Oe(e,t,i,...n){const o=Re.exec(t);if(!o)throw new Error("Bad use of emmet");const r=o[1]||"div";let s;return s=e!==Be.HTML?document.createElementNS(e,r):document.createElement(r),o[3]&&(s.id=o[3]),o[4]&&(s.className=o[4].replace(/\./g," ").trim()),i&&Object.entries(i).forEach((([e,t])=>{void 0!==t&&(/^on\w+$/.test(e)?s[e]=t:"selected"===e?t&&s.setAttribute(e,"true"):s.setAttribute(e,t))})),s.append(...n),s}function Fe(e,t,...i){return Oe(Be.HTML,e,t,...i)}function Pe(e,...t){e?ze(...t):We(...t)}function ze(...e){for(const t of e)t.style.display="",t.removeAttribute("aria-hidden")}function We(...e){for(const t of e)t.style.display="none",t.setAttribute("aria-hidden","true")}function He(e,t){const i=e.devicePixelRatio*t;return Math.max(1,Math.floor(i))/e.devicePixelRatio}function Ve(e){m.mainWindow.open(e,"_blank","noopener")}function Ue(e,t){const i=()=>{t(),n=z(e,i)};let n=z(e,i);return(0,u.toDisposable)((()=>n.dispose()))}function Qe(e){return e?`url('${h.FileAccess.uriToBrowserUri(e).toString(!0).replace(/'/g,"%27")}')`:"url('')"}function Ke(e){return`'${e.replace(/'/g,"%27")}'`}function je(e,t){if(void 0!==e){const i=e.match(/^\s*var\((.+)\)$/);if(i){const e=i[1].split(",",2);return 2===e.length&&(t=je(e[1].trim(),t)),`var(${e[0]}, ${t})`}return e}return t}function Ge(e,t=!1){const i=document.createElement("a");return d.addHook("afterSanitizeAttributes",(n=>{for(const o of["href","src"])if(n.hasAttribute(o)){const r=n.getAttribute(o);if("href"===o&&r.startsWith("#"))continue;if(i.href=r,!e.includes(i.protocol.replace(/:$/,""))){if(t&&"src"===o&&i.href.startsWith("data:"))continue;n.removeAttribute(o)}}})),(0,u.toDisposable)((()=>{d.removeHook("afterSanitizeAttributes")}))}!function(e){e.HTML="http://www.w3.org/1999/xhtml",e.SVG="http://www.w3.org/2000/svg"}(Be||(Be={})),Fe.SVG=function(e,t,...i){return Oe(Be.SVG,e,t,...i)},h.RemoteAuthorities.setPreferredWebSchema(/^https:/.test(m.mainWindow.location.href)?"https":"http");const qe=Object.freeze(["a","abbr","b","bdo","blockquote","br","caption","cite","code","col","colgroup","dd","del","details","dfn","div","dl","dt","em","figcaption","figure","h1","h2","h3","h4","h5","h6","hr","i","img","ins","kbd","label","li","mark","ol","p","pre","q","rp","rt","ruby","samp","small","small","source","span","strike","strong","sub","summary","sup","table","tbody","td","tfoot","th","thead","time","tr","tt","u","ul","var","video","wbr"]);Object.freeze({ALLOWED_TAGS:["a","button","blockquote","code","div","h1","h2","h3","h4","h5","h6","hr","input","label","li","p","pre","select","small","span","strong","textarea","ul","ol"],ALLOWED_ATTR:["href","data-href","data-command","target","title","name","src","alt","class","id","role","tabindex","style","data-code","width","height","align","x-dispatch","required","checked","placeholder","type","start"],RETURN_DOM:!1,RETURN_DOM_FRAGMENT:!1,RETURN_TRUSTED_TYPE:!0});class Ye extends c.Emitter{constructor(){super(),this._subscriptions=new u.DisposableStore,this._keyStatus={altKey:!1,shiftKey:!1,ctrlKey:!1,metaKey:!1},this._subscriptions.add(c.Event.runAndSubscribe(S,(({window:e,disposables:t})=>this.registerListeners(e,t)),{window:m.mainWindow,disposables:this._subscriptions}))}registerListeners(e,t){t.add(I(e,"keydown",(e=>{if(e.defaultPrevented)return;const t=new r.StandardKeyboardEvent(e);if(6!==t.keyCode||!e.repeat){if(e.altKey&&!this._keyStatus.altKey)this._keyStatus.lastKeyPressed="alt";else if(e.ctrlKey&&!this._keyStatus.ctrlKey)this._keyStatus.lastKeyPressed="ctrl";else if(e.metaKey&&!this._keyStatus.metaKey)this._keyStatus.lastKeyPressed="meta";else if(e.shiftKey&&!this._keyStatus.shiftKey)this._keyStatus.lastKeyPressed="shift";else{if(6===t.keyCode)return;this._keyStatus.lastKeyPressed=void 0}this._keyStatus.altKey=e.altKey,this._keyStatus.ctrlKey=e.ctrlKey,this._keyStatus.metaKey=e.metaKey,this._keyStatus.shiftKey=e.shiftKey,this._keyStatus.lastKeyPressed&&(this._keyStatus.event=e,this.fire(this._keyStatus))}}),!0)),t.add(I(e,"keyup",(e=>{e.defaultPrevented||(!e.altKey&&this._keyStatus.altKey?this._keyStatus.lastKeyReleased="alt":!e.ctrlKey&&this._keyStatus.ctrlKey?this._keyStatus.lastKeyReleased="ctrl":!e.metaKey&&this._keyStatus.metaKey?this._keyStatus.lastKeyReleased="meta":!e.shiftKey&&this._keyStatus.shiftKey?this._keyStatus.lastKeyReleased="shift":this._keyStatus.lastKeyReleased=void 0,this._keyStatus.lastKeyPressed!==this._keyStatus.lastKeyReleased&&(this._keyStatus.lastKeyPressed=void 0),this._keyStatus.altKey=e.altKey,this._keyStatus.ctrlKey=e.ctrlKey,this._keyStatus.metaKey=e.metaKey,this._keyStatus.shiftKey=e.shiftKey,this._keyStatus.lastKeyReleased&&(this._keyStatus.event=e,this.fire(this._keyStatus)))}),!0)),t.add(I(e.document.body,"mousedown",(()=>{this._keyStatus.lastKeyPressed=void 0}),!0)),t.add(I(e.document.body,"mouseup",(()=>{this._keyStatus.lastKeyPressed=void 0}),!0)),t.add(I(e.document.body,"mousemove",(e=>{e.buttons&&(this._keyStatus.lastKeyPressed=void 0)}),!0)),t.add(I(e,"blur",(()=>{this.resetKeyStatus()})))}get keyStatus(){return this._keyStatus}resetKeyStatus(){this.doResetKeyStatus(),this.fire(this._keyStatus)}doResetKeyStatus(){this._keyStatus={altKey:!1,shiftKey:!1,ctrlKey:!1,metaKey:!1}}static getInstance(){return Ye.instance||(Ye.instance=new Ye),Ye.instance}dispose(){super.dispose(),this._subscriptions.dispose()}}class $e extends u.Disposable{constructor(e,t){super(),this.element=e,this.callbacks=t,this.counter=0,this.dragStartTime=0,this.registerListeners()}registerListeners(){this.callbacks.onDragStart&&this._register(I(this.element,ye.DRAG_START,(e=>{var t,i;null===(i=(t=this.callbacks).onDragStart)||void 0===i||i.call(t,e)}))),this.callbacks.onDrag&&this._register(I(this.element,ye.DRAG,(e=>{var t,i;null===(i=(t=this.callbacks).onDrag)||void 0===i||i.call(t,e)}))),this._register(I(this.element,ye.DRAG_ENTER,(e=>{var t,i;this.counter++,this.dragStartTime=e.timeStamp,null===(i=(t=this.callbacks).onDragEnter)||void 0===i||i.call(t,e)}))),this._register(I(this.element,ye.DRAG_OVER,(e=>{var t,i;e.preventDefault(),null===(i=(t=this.callbacks).onDragOver)||void 0===i||i.call(t,e,e.timeStamp-this.dragStartTime)}))),this._register(I(this.element,ye.DRAG_LEAVE,(e=>{var t,i;this.counter--,0===this.counter&&(this.dragStartTime=0,null===(i=(t=this.callbacks).onDragLeave)||void 0===i||i.call(t,e))}))),this._register(I(this.element,ye.DRAG_END,(e=>{var t,i;this.counter=0,this.dragStartTime=0,null===(i=(t=this.callbacks).onDragEnd)||void 0===i||i.call(t,e)}))),this._register(I(this.element,ye.DROP,(e=>{var t,i;this.counter=0,this.dragStartTime=0,null===(i=(t=this.callbacks).onDrop)||void 0===i||i.call(t,e)})))}}const Je=/(?<tag>[\w\-]+)?(?:#(?<id>[\w\-]+))?(?<class>(?:\.(?:[\w\-]+))*)(?:@(?<name>(?:[\w\_])+))?/;function Ze(e,...t){let i,n;Array.isArray(t[0])?(i={},n=t[0]):(i=t[0]||{},n=t[1]);const o=Je.exec(e);if(!o||!o.groups)throw new Error("Bad use of h");const r=o.groups.tag||"div",s=document.createElement(r);o.groups.id&&(s.id=o.groups.id);const a=[];if(o.groups.class)for(const e of o.groups.class.split("."))""!==e&&a.push(e);if(void 0!==i.className)for(const e of i.className.split("."))""!==e&&a.push(e);a.length>0&&(s.className=a.join(" "));const l={};if(o.groups.name&&(l[o.groups.name]=s),n)for(const e of n)e instanceof HTMLElement?s.appendChild(e):"string"==typeof e?s.append(e):"root"in e&&(Object.assign(l,e),s.appendChild(e.root));for(const[e,t]of Object.entries(i))if("className"!==e)if("style"===e)for(const[e,i]of Object.entries(t))s.style.setProperty(Xe(e),"number"==typeof i?i+"px":""+i);else"tabIndex"===e?s.tabIndex=t:s.setAttribute(Xe(e),t.toString());return l.root=s,l}function Xe(e){return e.replace(/([a-z])([A-Z])/g,"$1-$2").toLowerCase()}},9709:function(e,t,i){"use strict";i.r(t),i.d(t,{addHook:function(){return oe},clearConfig:function(){return ie},isSupported:function(){return X},isValidAttribute:function(){return ne},removeAllHooks:function(){return ae},removeHook:function(){return re},removeHooks:function(){return se},sanitize:function(){return ee},setConfig:function(){return te},version:function(){return Z}});
/*! @license DOMPurify 3.0.5 | (c) Cure53 and other contributors | Released under the Apache license 2.0 and Mozilla Public License 2.0 | github.com/cure53/DOMPurify/blob/3.0.5/LICENSE */
const{entries:n,setPrototypeOf:o,isFrozen:r,getPrototypeOf:s,getOwnPropertyDescriptor:a}=Object;let{freeze:l,seal:c,create:d}=Object,{apply:u,construct:h}="undefined"!=typeof Reflect&&Reflect;u||(u=function(e,t,i){return e.apply(t,i)}),l||(l=function(e){return e}),c||(c=function(e){return e}),h||(h=function(e,t){return new e(...t)});const g=x(Array.prototype.forEach),p=x(Array.prototype.pop),m=x(Array.prototype.push),f=x(String.prototype.toLowerCase),b=x(String.prototype.toString),v=x(String.prototype.match),_=x(String.prototype.replace),A=x(String.prototype.indexOf),C=x(String.prototype.trim),w=x(RegExp.prototype.test),y=(S=TypeError,function(){for(var e=arguments.length,t=new Array(e),i=0;i<e;i++)t[i]=arguments[i];return h(S,t)});var S;function x(e){return function(t){for(var i=arguments.length,n=new Array(i>1?i-1:0),o=1;o<i;o++)n[o-1]=arguments[o];return u(e,t,n)}}function E(e,t,i){var n;i=null!==(n=i)&&void 0!==n?n:f,o&&o(e,null);let s=t.length;for(;s--;){let n=t[s];if("string"==typeof n){const e=i(n);e!==n&&(r(t)||(t[s]=e),n=e)}e[n]=!0}return e}function k(e){const t=d(null);for(const[i,o]of n(e))t[i]=o;return t}function D(e,t){for(;null!==e;){const i=a(e,t);if(i){if(i.get)return x(i.get);if("function"==typeof i.value)return x(i.value)}e=s(e)}return function(e){return console.warn("fallback value for",e),null}}const I=l(["a","abbr","acronym","address","area","article","aside","audio","b","bdi","bdo","big","blink","blockquote","body","br","button","canvas","caption","center","cite","code","col","colgroup","content","data","datalist","dd","decorator","del","details","dfn","dialog","dir","div","dl","dt","element","em","fieldset","figcaption","figure","font","footer","form","h1","h2","h3","h4","h5","h6","head","header","hgroup","hr","html","i","img","input","ins","kbd","label","legend","li","main","map","mark","marquee","menu","menuitem","meter","nav","nobr","ol","optgroup","option","output","p","picture","pre","progress","q","rp","rt","ruby","s","samp","section","select","shadow","small","source","spacer","span","strike","strong","style","sub","summary","sup","table","tbody","td","template","textarea","tfoot","th","thead","time","tr","track","tt","u","ul","var","video","wbr"]),L=l(["svg","a","altglyph","altglyphdef","altglyphitem","animatecolor","animatemotion","animatetransform","circle","clippath","defs","desc","ellipse","filter","font","g","glyph","glyphref","hkern","image","line","lineargradient","marker","mask","metadata","mpath","path","pattern","polygon","polyline","radialgradient","rect","stop","style","switch","symbol","text","textpath","title","tref","tspan","view","vkern"]),T=l(["feBlend","feColorMatrix","feComponentTransfer","feComposite","feConvolveMatrix","feDiffuseLighting","feDisplacementMap","feDistantLight","feDropShadow","feFlood","feFuncA","feFuncB","feFuncG","feFuncR","feGaussianBlur","feImage","feMerge","feMergeNode","feMorphology","feOffset","fePointLight","feSpecularLighting","feSpotLight","feTile","feTurbulence"]),M=l(["animate","color-profile","cursor","discard","font-face","font-face-format","font-face-name","font-face-src","font-face-uri","foreignobject","hatch","hatchpath","mesh","meshgradient","meshpatch","meshrow","missing-glyph","script","set","solidcolor","unknown","use"]),N=l(["math","menclose","merror","mfenced","mfrac","mglyph","mi","mlabeledtr","mmultiscripts","mn","mo","mover","mpadded","mphantom","mroot","mrow","ms","mspace","msqrt","mstyle","msub","msup","msubsup","mtable","mtd","mtext","mtr","munder","munderover","mprescripts"]),R=l(["maction","maligngroup","malignmark","mlongdiv","mscarries","mscarry","msgroup","mstack","msline","msrow","semantics","annotation","annotation-xml","mprescripts","none"]),B=l(["#text"]),O=l(["accept","action","align","alt","autocapitalize","autocomplete","autopictureinpicture","autoplay","background","bgcolor","border","capture","cellpadding","cellspacing","checked","cite","class","clear","color","cols","colspan","controls","controlslist","coords","crossorigin","datetime","decoding","default","dir","disabled","disablepictureinpicture","disableremoteplayback","download","draggable","enctype","enterkeyhint","face","for","headers","height","hidden","high","href","hreflang","id","inputmode","integrity","ismap","kind","label","lang","list","loading","loop","low","max","maxlength","media","method","min","minlength","multiple","muted","name","nonce","noshade","novalidate","nowrap","open","optimum","pattern","placeholder","playsinline","poster","preload","pubdate","radiogroup","readonly","rel","required","rev","reversed","role","rows","rowspan","spellcheck","scope","selected","shape","size","sizes","span","srclang","start","src","srcset","step","style","summary","tabindex","title","translate","type","usemap","valign","value","width","xmlns","slot"]),F=l(["accent-height","accumulate","additive","alignment-baseline","ascent","attributename","attributetype","azimuth","basefrequency","baseline-shift","begin","bias","by","class","clip","clippathunits","clip-path","clip-rule","color","color-interpolation","color-interpolation-filters","color-profile","color-rendering","cx","cy","d","dx","dy","diffuseconstant","direction","display","divisor","dur","edgemode","elevation","end","fill","fill-opacity","fill-rule","filter","filterunits","flood-color","flood-opacity","font-family","font-size","font-size-adjust","font-stretch","font-style","font-variant","font-weight","fx","fy","g1","g2","glyph-name","glyphref","gradientunits","gradienttransform","height","href","id","image-rendering","in","in2","k","k1","k2","k3","k4","kerning","keypoints","keysplines","keytimes","lang","lengthadjust","letter-spacing","kernelmatrix","kernelunitlength","lighting-color","local","marker-end","marker-mid","marker-start","markerheight","markerunits","markerwidth","maskcontentunits","maskunits","max","mask","media","method","mode","min","name","numoctaves","offset","operator","opacity","order","orient","orientation","origin","overflow","paint-order","path","pathlength","patterncontentunits","patterntransform","patternunits","points","preservealpha","preserveaspectratio","primitiveunits","r","rx","ry","radius","refx","refy","repeatcount","repeatdur","restart","result","rotate","scale","seed","shape-rendering","specularconstant","specularexponent","spreadmethod","startoffset","stddeviation","stitchtiles","stop-color","stop-opacity","stroke-dasharray","stroke-dashoffset","stroke-linecap","stroke-linejoin","stroke-miterlimit","stroke-opacity","stroke","stroke-width","style","surfacescale","systemlanguage","tabindex","targetx","targety","transform","transform-origin","text-anchor","text-decoration","text-rendering","textlength","type","u1","u2","unicode","values","viewbox","visibility","version","vert-adv-y","vert-origin-x","vert-origin-y","width","word-spacing","wrap","writing-mode","xchannelselector","ychannelselector","x","x1","x2","xmlns","y","y1","y2","z","zoomandpan"]),P=l(["accent","accentunder","align","bevelled","close","columnsalign","columnlines","columnspan","denomalign","depth","dir","display","displaystyle","encoding","fence","frame","height","href","id","largeop","length","linethickness","lspace","lquote","mathbackground","mathcolor","mathsize","mathvariant","maxsize","minsize","movablelimits","notation","numalign","open","rowalign","rowlines","rowspacing","rowspan","rspace","rquote","scriptlevel","scriptminsize","scriptsizemultiplier","selection","separator","separators","stretchy","subscriptshift","supscriptshift","symmetric","voffset","width","xmlns"]),z=l(["xlink:href","xml:id","xlink:title","xml:space","xmlns:xlink"]),W=c(/\{\{[\w\W]*|[\w\W]*\}\}/gm),H=c(/<%[\w\W]*|[\w\W]*%>/gm),V=c(/\${[\w\W]*}/gm),U=c(/^data-[\-\w.\u00B7-\uFFFF]/),Q=c(/^aria-[\-\w]+$/),K=c(/^(?:(?:(?:f|ht)tps?|mailto|tel|callto|sms|cid|xmpp):|[^a-z]|[a-z+.\-]+(?:[^a-z+.\-:]|$))/i),j=c(/^(?:\w+script|data):/i),G=c(/[\u0000-\u0020\u00A0\u1680\u180E\u2000-\u2029\u205F\u3000]/g),q=c(/^html$/i);var Y=Object.freeze({__proto__:null,MUSTACHE_EXPR:W,ERB_EXPR:H,TMPLIT_EXPR:V,DATA_ATTR:U,ARIA_ATTR:Q,IS_ALLOWED_URI:K,IS_SCRIPT_OR_DATA:j,ATTR_WHITESPACE:G,DOCTYPE_NAME:q});const $=()=>"undefined"==typeof window?null:window;var J=function e(){let t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:$();const i=t=>e(t);if(i.version="3.0.5",i.removed=[],!t||!t.document||9!==t.document.nodeType)return i.isSupported=!1,i;const o=t.document,r=o.currentScript;let{document:s}=t;const{DocumentFragment:a,HTMLTemplateElement:c,Node:d,Element:u,NodeFilter:h,NamedNodeMap:S=t.NamedNodeMap||t.MozNamedAttrMap,HTMLFormElement:x,DOMParser:W,trustedTypes:H}=t,V=u.prototype,U=D(V,"cloneNode"),Q=D(V,"nextSibling"),j=D(V,"childNodes"),G=D(V,"parentNode");if("function"==typeof c){const e=s.createElement("template");e.content&&e.content.ownerDocument&&(s=e.content.ownerDocument)}let J,Z="";const{implementation:X,createNodeIterator:ee,createDocumentFragment:te,getElementsByTagName:ie}=s,{importNode:ne}=o;let oe={};i.isSupported="function"==typeof n&&"function"==typeof G&&X&&void 0!==X.createHTMLDocument;const{MUSTACHE_EXPR:re,ERB_EXPR:se,TMPLIT_EXPR:ae,DATA_ATTR:le,ARIA_ATTR:ce,IS_SCRIPT_OR_DATA:de,ATTR_WHITESPACE:ue}=Y;let{IS_ALLOWED_URI:he}=Y,ge=null;const pe=E({},[...I,...L,...T,...N,...B]);let me=null;const fe=E({},[...O,...F,...P,...z]);let be=Object.seal(Object.create(null,{tagNameCheck:{writable:!0,configurable:!1,enumerable:!0,value:null},attributeNameCheck:{writable:!0,configurable:!1,enumerable:!0,value:null},allowCustomizedBuiltInElements:{writable:!0,configurable:!1,enumerable:!0,value:!1}})),ve=null,_e=null,Ae=!0,Ce=!0,we=!1,ye=!0,Se=!1,xe=!1,Ee=!1,ke=!1,De=!1,Ie=!1,Le=!1,Te=!0,Me=!1,Ne=!0,Re=!1,Be={},Oe=null;const Fe=E({},["annotation-xml","audio","colgroup","desc","foreignobject","head","iframe","math","mi","mn","mo","ms","mtext","noembed","noframes","noscript","plaintext","script","style","svg","template","thead","title","video","xmp"]);let Pe=null;const ze=E({},["audio","video","img","source","image","track"]);let We=null;const He=E({},["alt","class","for","id","label","name","pattern","placeholder","role","summary","title","value","style","xmlns"]),Ve="http://www.w3.org/1998/Math/MathML",Ue="http://www.w3.org/2000/svg",Qe="http://www.w3.org/1999/xhtml";let Ke=Qe,je=!1,Ge=null;const qe=E({},[Ve,Ue,Qe],b);let Ye;const $e=["application/xhtml+xml","text/html"];let Je,Ze=null;const Xe=s.createElement("form"),et=function(e){return e instanceof RegExp||e instanceof Function},tt=function(e){if(!Ze||Ze!==e){if(e&&"object"==typeof e||(e={}),e=k(e),Ye=Ye=-1===$e.indexOf(e.PARSER_MEDIA_TYPE)?"text/html":e.PARSER_MEDIA_TYPE,Je="application/xhtml+xml"===Ye?b:f,ge="ALLOWED_TAGS"in e?E({},e.ALLOWED_TAGS,Je):pe,me="ALLOWED_ATTR"in e?E({},e.ALLOWED_ATTR,Je):fe,Ge="ALLOWED_NAMESPACES"in e?E({},e.ALLOWED_NAMESPACES,b):qe,We="ADD_URI_SAFE_ATTR"in e?E(k(He),e.ADD_URI_SAFE_ATTR,Je):He,Pe="ADD_DATA_URI_TAGS"in e?E(k(ze),e.ADD_DATA_URI_TAGS,Je):ze,Oe="FORBID_CONTENTS"in e?E({},e.FORBID_CONTENTS,Je):Fe,ve="FORBID_TAGS"in e?E({},e.FORBID_TAGS,Je):{},_e="FORBID_ATTR"in e?E({},e.FORBID_ATTR,Je):{},Be="USE_PROFILES"in e&&e.USE_PROFILES,Ae=!1!==e.ALLOW_ARIA_ATTR,Ce=!1!==e.ALLOW_DATA_ATTR,we=e.ALLOW_UNKNOWN_PROTOCOLS||!1,ye=!1!==e.ALLOW_SELF_CLOSE_IN_ATTR,Se=e.SAFE_FOR_TEMPLATES||!1,xe=e.WHOLE_DOCUMENT||!1,De=e.RETURN_DOM||!1,Ie=e.RETURN_DOM_FRAGMENT||!1,Le=e.RETURN_TRUSTED_TYPE||!1,ke=e.FORCE_BODY||!1,Te=!1!==e.SANITIZE_DOM,Me=e.SANITIZE_NAMED_PROPS||!1,Ne=!1!==e.KEEP_CONTENT,Re=e.IN_PLACE||!1,he=e.ALLOWED_URI_REGEXP||K,Ke=e.NAMESPACE||Qe,be=e.CUSTOM_ELEMENT_HANDLING||{},e.CUSTOM_ELEMENT_HANDLING&&et(e.CUSTOM_ELEMENT_HANDLING.tagNameCheck)&&(be.tagNameCheck=e.CUSTOM_ELEMENT_HANDLING.tagNameCheck),e.CUSTOM_ELEMENT_HANDLING&&et(e.CUSTOM_ELEMENT_HANDLING.attributeNameCheck)&&(be.attributeNameCheck=e.CUSTOM_ELEMENT_HANDLING.attributeNameCheck),e.CUSTOM_ELEMENT_HANDLING&&"boolean"==typeof e.CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements&&(be.allowCustomizedBuiltInElements=e.CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements),Se&&(Ce=!1),Ie&&(De=!0),Be&&(ge=E({},[...B]),me=[],!0===Be.html&&(E(ge,I),E(me,O)),!0===Be.svg&&(E(ge,L),E(me,F),E(me,z)),!0===Be.svgFilters&&(E(ge,T),E(me,F),E(me,z)),!0===Be.mathMl&&(E(ge,N),E(me,P),E(me,z))),e.ADD_TAGS&&(ge===pe&&(ge=k(ge)),E(ge,e.ADD_TAGS,Je)),e.ADD_ATTR&&(me===fe&&(me=k(me)),E(me,e.ADD_ATTR,Je)),e.ADD_URI_SAFE_ATTR&&E(We,e.ADD_URI_SAFE_ATTR,Je),e.FORBID_CONTENTS&&(Oe===Fe&&(Oe=k(Oe)),E(Oe,e.FORBID_CONTENTS,Je)),Ne&&(ge["#text"]=!0),xe&&E(ge,["html","head","body"]),ge.table&&(E(ge,["tbody"]),delete ve.tbody),e.TRUSTED_TYPES_POLICY){if("function"!=typeof e.TRUSTED_TYPES_POLICY.createHTML)throw y('TRUSTED_TYPES_POLICY configuration option must provide a "createHTML" hook.');if("function"!=typeof e.TRUSTED_TYPES_POLICY.createScriptURL)throw y('TRUSTED_TYPES_POLICY configuration option must provide a "createScriptURL" hook.');J=e.TRUSTED_TYPES_POLICY,Z=J.createHTML("")}else void 0===J&&(J=function(e,t){if("object"!=typeof e||"function"!=typeof e.createPolicy)return null;let i=null;const n="data-tt-policy-suffix";t&&t.hasAttribute(n)&&(i=t.getAttribute(n));const o="dompurify"+(i?"#"+i:"");try{return e.createPolicy(o,{createHTML(e){return e},createScriptURL(e){return e}})}catch(e){return console.warn("TrustedTypes policy "+o+" could not be created."),null}}(H,r)),null!==J&&"string"==typeof Z&&(Z=J.createHTML(""));l&&l(e),Ze=e}},it=E({},["mi","mo","mn","ms","mtext"]),nt=E({},["foreignobject","desc","title","annotation-xml"]),ot=E({},["title","style","font","a","script"]),rt=E({},L);E(rt,T),E(rt,M);const st=E({},N);E(st,R);const at=function(e){m(i.removed,{element:e});try{e.parentNode.removeChild(e)}catch(t){e.remove()}},lt=function(e,t){try{m(i.removed,{attribute:t.getAttributeNode(e),from:t})}catch(e){m(i.removed,{attribute:null,from:t})}if(t.removeAttribute(e),"is"===e&&!me[e])if(De||Ie)try{at(t)}catch(e){}else try{t.setAttribute(e,"")}catch(e){}},ct=function(e){let t,i;if(ke)e="<remove></remove>"+e;else{const t=v(e,/^[\r\n\t ]+/);i=t&&t[0]}"application/xhtml+xml"===Ye&&Ke===Qe&&(e='<html xmlns="http://www.w3.org/1999/xhtml"><head></head><body>'+e+"</body></html>");const n=J?J.createHTML(e):e;if(Ke===Qe)try{t=(new W).parseFromString(n,Ye)}catch(e){}if(!t||!t.documentElement){t=X.createDocument(Ke,"template",null);try{t.documentElement.innerHTML=je?Z:n}catch(e){}}const o=t.body||t.documentElement;return e&&i&&o.insertBefore(s.createTextNode(i),o.childNodes[0]||null),Ke===Qe?ie.call(t,xe?"html":"body")[0]:xe?t.documentElement:o},dt=function(e){return ee.call(e.ownerDocument||e,e,h.SHOW_ELEMENT|h.SHOW_COMMENT|h.SHOW_TEXT,null,!1)},ut=function(e){return"object"==typeof d?e instanceof d:e&&"object"==typeof e&&"number"==typeof e.nodeType&&"string"==typeof e.nodeName},ht=function(e,t,n){oe[e]&&g(oe[e],(e=>{e.call(i,t,n,Ze)}))},gt=function(e){let t;if(ht("beforeSanitizeElements",e,null),(n=e)instanceof x&&("string"!=typeof n.nodeName||"string"!=typeof n.textContent||"function"!=typeof n.removeChild||!(n.attributes instanceof S)||"function"!=typeof n.removeAttribute||"function"!=typeof n.setAttribute||"string"!=typeof n.namespaceURI||"function"!=typeof n.insertBefore||"function"!=typeof n.hasChildNodes))return at(e),!0;var n;const o=Je(e.nodeName);if(ht("uponSanitizeElement",e,{tagName:o,allowedTags:ge}),e.hasChildNodes()&&!ut(e.firstElementChild)&&(!ut(e.content)||!ut(e.content.firstElementChild))&&w(/<[/\w]/g,e.innerHTML)&&w(/<[/\w]/g,e.textContent))return at(e),!0;if(!ge[o]||ve[o]){if(!ve[o]&&mt(o)){if(be.tagNameCheck instanceof RegExp&&w(be.tagNameCheck,o))return!1;if(be.tagNameCheck instanceof Function&&be.tagNameCheck(o))return!1}if(Ne&&!Oe[o]){const t=G(e)||e.parentNode,i=j(e)||e.childNodes;if(i&&t){for(let n=i.length-1;n>=0;--n)t.insertBefore(U(i[n],!0),Q(e))}}return at(e),!0}return e instanceof u&&!function(e){let t=G(e);t&&t.tagName||(t={namespaceURI:Ke,tagName:"template"});const i=f(e.tagName),n=f(t.tagName);return!!Ge[e.namespaceURI]&&(e.namespaceURI===Ue?t.namespaceURI===Qe?"svg"===i:t.namespaceURI===Ve?"svg"===i&&("annotation-xml"===n||it[n]):Boolean(rt[i]):e.namespaceURI===Ve?t.namespaceURI===Qe?"math"===i:t.namespaceURI===Ue?"math"===i&&nt[n]:Boolean(st[i]):e.namespaceURI===Qe?!(t.namespaceURI===Ue&&!nt[n])&&!(t.namespaceURI===Ve&&!it[n])&&!st[i]&&(ot[i]||!rt[i]):!("application/xhtml+xml"!==Ye||!Ge[e.namespaceURI]))}(e)?(at(e),!0):"noscript"!==o&&"noembed"!==o&&"noframes"!==o||!w(/<\/no(script|embed|frames)/i,e.innerHTML)?(Se&&3===e.nodeType&&(t=e.textContent,t=_(t,re," "),t=_(t,se," "),t=_(t,ae," "),e.textContent!==t&&(m(i.removed,{element:e.cloneNode()}),e.textContent=t)),ht("afterSanitizeElements",e,null),!1):(at(e),!0)},pt=function(e,t,i){if(Te&&("id"===t||"name"===t)&&(i in s||i in Xe))return!1;if(Ce&&!_e[t]&&w(le,t));else if(Ae&&w(ce,t));else if(!me[t]||_e[t]){if(!(mt(e)&&(be.tagNameCheck instanceof RegExp&&w(be.tagNameCheck,e)||be.tagNameCheck instanceof Function&&be.tagNameCheck(e))&&(be.attributeNameCheck instanceof RegExp&&w(be.attributeNameCheck,t)||be.attributeNameCheck instanceof Function&&be.attributeNameCheck(t))||"is"===t&&be.allowCustomizedBuiltInElements&&(be.tagNameCheck instanceof RegExp&&w(be.tagNameCheck,i)||be.tagNameCheck instanceof Function&&be.tagNameCheck(i))))return!1}else if(We[t]);else if(w(he,_(i,ue,"")));else if("src"!==t&&"xlink:href"!==t&&"href"!==t||"script"===e||0!==A(i,"data:")||!Pe[e]){if(we&&!w(de,_(i,ue,"")));else if(i)return!1}else;return!0},mt=function(e){return e.indexOf("-")>0},ft=function(e){let t,n,o,r;ht("beforeSanitizeAttributes",e,null);const{attributes:s}=e;if(!s)return;const a={attrName:"",attrValue:"",keepAttr:!0,allowedAttributes:me};for(r=s.length;r--;){t=s[r];const{name:l,namespaceURI:c}=t;if(n="value"===l?t.value:C(t.value),o=Je(l),a.attrName=o,a.attrValue=n,a.keepAttr=!0,a.forceKeepAttr=void 0,ht("uponSanitizeAttribute",e,a),n=a.attrValue,a.forceKeepAttr)continue;if(lt(l,e),!a.keepAttr)continue;if(!ye&&w(/\/>/i,n)){lt(l,e);continue}Se&&(n=_(n,re," "),n=_(n,se," "),n=_(n,ae," "));const d=Je(e.nodeName);if(pt(d,o,n)){if(!Me||"id"!==o&&"name"!==o||(lt(l,e),n="user-content-"+n),J&&"object"==typeof H&&"function"==typeof H.getAttributeType)if(c);else switch(H.getAttributeType(d,o)){case"TrustedHTML":n=J.createHTML(n);break;case"TrustedScriptURL":n=J.createScriptURL(n)}try{c?e.setAttributeNS(c,l,n):e.setAttribute(l,n),p(i.removed)}catch(e){}}}ht("afterSanitizeAttributes",e,null)},bt=function e(t){let i;const n=dt(t);for(ht("beforeSanitizeShadowDOM",t,null);i=n.nextNode();)ht("uponSanitizeShadowNode",i,null),gt(i)||(i.content instanceof a&&e(i.content),ft(i));ht("afterSanitizeShadowDOM",t,null)};return i.sanitize=function(e){let t,n,r,s,l=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};if(je=!e,je&&(e="\x3c!--\x3e"),"string"!=typeof e&&!ut(e)){if("function"!=typeof e.toString)throw y("toString is not a function");if("string"!=typeof(e=e.toString()))throw y("dirty is not a string, aborting")}if(!i.isSupported)return e;if(Ee||tt(l),i.removed=[],"string"==typeof e&&(Re=!1),Re){if(e.nodeName){const t=Je(e.nodeName);if(!ge[t]||ve[t])throw y("root node is forbidden and cannot be sanitized in-place")}}else if(e instanceof d)t=ct("\x3c!----\x3e"),n=t.ownerDocument.importNode(e,!0),1===n.nodeType&&"BODY"===n.nodeName||"HTML"===n.nodeName?t=n:t.appendChild(n);else{if(!De&&!Se&&!xe&&-1===e.indexOf("<"))return J&&Le?J.createHTML(e):e;if(t=ct(e),!t)return De?null:Le?Z:""}t&&ke&&at(t.firstChild);const c=dt(Re?e:t);for(;r=c.nextNode();)gt(r)||(r.content instanceof a&&bt(r.content),ft(r));if(Re)return e;if(De){if(Ie)for(s=te.call(t.ownerDocument);t.firstChild;)s.appendChild(t.firstChild);else s=t;return(me.shadowroot||me.shadowrootmode)&&(s=ne.call(o,s,!0)),s}let u=xe?t.outerHTML:t.innerHTML;return xe&&ge["!doctype"]&&t.ownerDocument&&t.ownerDocument.doctype&&t.ownerDocument.doctype.name&&w(q,t.ownerDocument.doctype.name)&&(u="<!DOCTYPE "+t.ownerDocument.doctype.name+">\n"+u),Se&&(u=_(u,re," "),u=_(u,se," "),u=_(u,ae," ")),J&&Le?J.createHTML(u):u},i.setConfig=function(e){tt(e),Ee=!0},i.clearConfig=function(){Ze=null,Ee=!1},i.isValidAttribute=function(e,t,i){Ze||tt({});const n=Je(e),o=Je(t);return pt(n,o,i)},i.addHook=function(e,t){"function"==typeof t&&(oe[e]=oe[e]||[],m(oe[e],t))},i.removeHook=function(e){if(oe[e])return p(oe[e])},i.removeHooks=function(e){oe[e]&&(oe[e]=[])},i.removeAllHooks=function(){oe={}},i}();t.default=J;const Z=J.version,X=J.isSupported,ee=J.sanitize,te=J.setConfig,ie=J.clearConfig,ne=J.isValidAttribute,oe=J.addHook,re=J.removeHook,se=J.removeHooks,ae=J.removeAllHooks},50465:function(e,t,i){"use strict";i.r(t),i.d(t,{DomEmitter:function(){return o}});var n=i(63801);class o{get event(){return this.emitter.event}constructor(e,t,i){const o=e=>this.emitter.fire(e);this.emitter=new n.Emitter({onWillAddFirstListener:()=>e.addEventListener(t,o,i),onDidRemoveLastListener:()=>e.removeEventListener(t,o,i)})}dispose(){this.emitter.dispose()}}},85297:function(e,t,i){"use strict";i.r(t),i.d(t,{FastDomNode:function(){return n},createFastDomNode:function(){return r}});class n{constructor(e){this.domNode=e,this._maxWidth="",this._width="",this._height="",this._top="",this._left="",this._bottom="",this._right="",this._paddingLeft="",this._fontFamily="",this._fontWeight="",this._fontSize="",this._fontStyle="",this._fontFeatureSettings="",this._fontVariationSettings="",this._textDecoration="",this._lineHeight="",this._letterSpacing="",this._className="",this._display="",this._position="",this._visibility="",this._color="",this._backgroundColor="",this._layerHint=!1,this._contain="none",this._boxShadow=""}setMaxWidth(e){const t=o(e);this._maxWidth!==t&&(this._maxWidth=t,this.domNode.style.maxWidth=this._maxWidth)}setWidth(e){const t=o(e);this._width!==t&&(this._width=t,this.domNode.style.width=this._width)}setHeight(e){const t=o(e);this._height!==t&&(this._height=t,this.domNode.style.height=this._height)}setTop(e){const t=o(e);this._top!==t&&(this._top=t,this.domNode.style.top=this._top)}setLeft(e){const t=o(e);this._left!==t&&(this._left=t,this.domNode.style.left=this._left)}setBottom(e){const t=o(e);this._bottom!==t&&(this._bottom=t,this.domNode.style.bottom=this._bottom)}setRight(e){const t=o(e);this._right!==t&&(this._right=t,this.domNode.style.right=this._right)}setPaddingLeft(e){const t=o(e);this._paddingLeft!==t&&(this._paddingLeft=t,this.domNode.style.paddingLeft=this._paddingLeft)}setFontFamily(e){this._fontFamily!==e&&(this._fontFamily=e,this.domNode.style.fontFamily=this._fontFamily)}setFontWeight(e){this._fontWeight!==e&&(this._fontWeight=e,this.domNode.style.fontWeight=this._fontWeight)}setFontSize(e){const t=o(e);this._fontSize!==t&&(this._fontSize=t,this.domNode.style.fontSize=this._fontSize)}setFontStyle(e){this._fontStyle!==e&&(this._fontStyle=e,this.domNode.style.fontStyle=this._fontStyle)}setFontFeatureSettings(e){this._fontFeatureSettings!==e&&(this._fontFeatureSettings=e,this.domNode.style.fontFeatureSettings=this._fontFeatureSettings)}setFontVariationSettings(e){this._fontVariationSettings!==e&&(this._fontVariationSettings=e,this.domNode.style.fontVariationSettings=this._fontVariationSettings)}setTextDecoration(e){this._textDecoration!==e&&(this._textDecoration=e,this.domNode.style.textDecoration=this._textDecoration)}setLineHeight(e){const t=o(e);this._lineHeight!==t&&(this._lineHeight=t,this.domNode.style.lineHeight=this._lineHeight)}setLetterSpacing(e){const t=o(e);this._letterSpacing!==t&&(this._letterSpacing=t,this.domNode.style.letterSpacing=this._letterSpacing)}setClassName(e){this._className!==e&&(this._className=e,this.domNode.className=this._className)}toggleClassName(e,t){this.domNode.classList.toggle(e,t),this._className=this.domNode.className}setDisplay(e){this._display!==e&&(this._display=e,this.domNode.style.display=this._display)}setPosition(e){this._position!==e&&(this._position=e,this.domNode.style.position=this._position)}setVisibility(e){this._visibility!==e&&(this._visibility=e,this.domNode.style.visibility=this._visibility)}setColor(e){this._color!==e&&(this._color=e,this.domNode.style.color=this._color)}setBackgroundColor(e){this._backgroundColor!==e&&(this._backgroundColor=e,this.domNode.style.backgroundColor=this._backgroundColor)}setLayerHinting(e){this._layerHint!==e&&(this._layerHint=e,this.domNode.style.transform=this._layerHint?"translate3d(0px, 0px, 0px)":"")}setBoxShadow(e){this._boxShadow!==e&&(this._boxShadow=e,this.domNode.style.boxShadow=e)}setContain(e){this._contain!==e&&(this._contain=e,this.domNode.style.contain=this._contain)}setAttribute(e,t){this.domNode.setAttribute(e,t)}removeAttribute(e){this.domNode.removeAttribute(e)}appendChild(e){this.domNode.appendChild(e.domNode)}removeChild(e){this.domNode.removeChild(e.domNode)}}function o(e){return"number"==typeof e?`${e}px`:e}function r(e){return new n(e)}},94264:function(e,t,i){"use strict";i.r(t),i.d(t,{createElement:function(){return s},renderFormattedText:function(){return r},renderText:function(){return o}});var n=i(96747);function o(e,t={}){const i=s(t);return i.textContent=e,i}function r(e,t={}){const i=s(t);return l(i,function(e,t){const i={type:1,children:[]};let n=0,o=i;const r=[],s=new a(e);for(;!s.eos();){let e=s.next();const i="\\"===e&&0!==d(s.peek(),t);if(i&&(e=s.next()),!i&&c(e,t)&&e===s.peek()){s.advance(),2===o.type&&(o=r.pop());const i=d(e,t);if(o.type===i||5===o.type&&6===i)o=r.pop();else{const e={type:i,children:[]};5===i&&(e.index=n,n++),o.children.push(e),r.push(o),o=e}}else if("\n"===e)2===o.type&&(o=r.pop()),o.children.push({type:8});else if(2!==o.type){const t={type:2,content:e};o.children.push(t),r.push(o),o=t}else o.content+=e}2===o.type&&(o=r.pop());r.length;return i}(e,!!t.renderCodeSegments),t.actionHandler,t.renderCodeSegments),i}function s(e){const t=e.inline?"span":"div",i=document.createElement(t);return e.className&&(i.className=e.className),i}class a{constructor(e){this.source=e,this.index=0}eos(){return this.index>=this.source.length}next(){const e=this.peek();return this.advance(),e}peek(){return this.source[this.index]}advance(){this.index++}}function l(e,t,i,o){let r;if(2===t.type)r=document.createTextNode(t.content||"");else if(3===t.type)r=document.createElement("b");else if(4===t.type)r=document.createElement("i");else if(7===t.type&&o)r=document.createElement("code");else if(5===t.type&&i){const e=document.createElement("a");i.disposables.add(n.addStandardDisposableListener(e,"click",(e=>{i.callback(String(t.index),e)}))),r=e}else 8===t.type?r=document.createElement("br"):1===t.type&&(r=e);r&&e!==r&&e.appendChild(r),r&&Array.isArray(t.children)&&t.children.forEach((e=>{l(r,e,i,o)}))}function c(e,t){return 0!==d(e,t)}function d(e,t){switch(e){case"*":return 3;case"_":return 4;case"[":return 5;case"]":return 6;case"`":return t?7:0;default:return 0}}},95689:function(e,t,i){"use strict";i.r(t),i.d(t,{GlobalPointerMoveMonitor:function(){return r}});var n=i(96747),o=i(68921);class r{constructor(){this._hooks=new o.DisposableStore,this._pointerMoveCallback=null,this._onStopCallback=null}dispose(){this.stopMonitoring(!1),this._hooks.dispose()}stopMonitoring(e,t){if(!this.isMonitoring())return;this._hooks.clear(),this._pointerMoveCallback=null;const i=this._onStopCallback;this._onStopCallback=null,e&&i&&i(t)}isMonitoring(){return!!this._pointerMoveCallback}startMonitoring(e,t,i,r,s){this.isMonitoring()&&this.stopMonitoring(!1),this._pointerMoveCallback=r,this._onStopCallback=s;let a=e;try{e.setPointerCapture(t),this._hooks.add((0,o.toDisposable)((()=>{try{e.releasePointerCapture(t)}catch(e){}})))}catch(t){a=n.getWindow(e)}this._hooks.add(n.addDisposableListener(a,n.EventType.POINTER_MOVE,(e=>{e.buttons===i?(e.preventDefault(),this._pointerMoveCallback(e)):this.stopMonitoring(!0)}))),this._hooks.add(n.addDisposableListener(a,n.EventType.POINTER_UP,(e=>this.stopMonitoring(!0))))}}},28132:function(e,t,i){"use strict";i.r(t),i.d(t,{IframeUtils:function(){return r}});const n=new WeakMap;function o(e){if(!e.parent||e.parent===e)return null;try{const t=e.location,i=e.parent.location;if("null"!==t.origin&&"null"!==i.origin&&t.origin!==i.origin)return null}catch(e){return null}return e.parent}class r{static getSameOriginWindowChain(e){let t=n.get(e);if(!t){t=[],n.set(e,t);let i,r=e;do{i=o(r),i?t.push({window:new WeakRef(r),iframeElement:r.frameElement||null}):t.push({window:new WeakRef(r),iframeElement:null}),r=i}while(r)}return t.slice(0)}static getPositionOfChildWindowRelativeToAncestorWindow(e,t){var i,n;if(!t||e===t)return{top:0,left:0};let o=0,r=0;const s=this.getSameOriginWindowChain(e);for(const e of s){const s=e.window.deref();if(o+=null!==(i=null==s?void 0:s.scrollY)&&void 0!==i?i:0,r+=null!==(n=null==s?void 0:s.scrollX)&&void 0!==n?n:0,s===t)break;if(!e.iframeElement)break;const a=e.iframeElement.getBoundingClientRect();o+=a.top,r+=a.left}return{top:o,left:r}}}},8769:function(e,t,i){"use strict";i.r(t),i.d(t,{StandardKeyboardEvent:function(){return c}});var n=i(76736),o=i(98070),r=i(37345),s=i(66719);const a=s.isMacintosh?256:2048,l=s.isMacintosh?2048:256;class c{constructor(e){this._standardKeyboardEventBrand=!0;const t=e;this.browserEvent=t,this.target=t.target,this.ctrlKey=t.ctrlKey,this.shiftKey=t.shiftKey,this.altKey=t.altKey,this.metaKey=t.metaKey,this.altGraphKey=t.getModifierState("AltGraph"),this.keyCode=function(e){if(e.charCode){const t=String.fromCharCode(e.charCode).toUpperCase();return o.KeyCodeUtils.fromString(t)}const t=e.keyCode;if(3===t)return 7;if(n.isFirefox)switch(t){case 59:return 85;case 60:if(s.isLinux)return 97;break;case 61:return 86;case 107:return 109;case 109:return 111;case 173:return 88;case 224:if(s.isMacintosh)return 57}else if(n.isWebKit){if(s.isMacintosh&&93===t)return 57;if(!s.isMacintosh&&92===t)return 57}return o.EVENT_KEY_CODE_MAP[t]||0}(t),this.code=t.code,this.ctrlKey=this.ctrlKey||5===this.keyCode,this.altKey=this.altKey||6===this.keyCode,this.shiftKey=this.shiftKey||4===this.keyCode,this.metaKey=this.metaKey||57===this.keyCode,this._asKeybinding=this._computeKeybinding(),this._asKeyCodeChord=this._computeKeyCodeChord()}preventDefault(){this.browserEvent&&this.browserEvent.preventDefault&&this.browserEvent.preventDefault()}stopPropagation(){this.browserEvent&&this.browserEvent.stopPropagation&&this.browserEvent.stopPropagation()}toKeyCodeChord(){return this._asKeyCodeChord}equals(e){return this._asKeybinding===e}_computeKeybinding(){let e=0;5!==this.keyCode&&4!==this.keyCode&&6!==this.keyCode&&57!==this.keyCode&&(e=this.keyCode);let t=0;return this.ctrlKey&&(t|=a),this.altKey&&(t|=512),this.shiftKey&&(t|=1024),this.metaKey&&(t|=l),t|=e,t}_computeKeyCodeChord(){let e=0;return 5!==this.keyCode&&4!==this.keyCode&&6!==this.keyCode&&57!==this.keyCode&&(e=this.keyCode),new r.KeyCodeChord(this.ctrlKey,this.shiftKey,this.altKey,this.metaKey,e)}}},32703:function(e,t,i){"use strict";i.r(t),i.d(t,{allowedMarkdownAttr:function(){return I},fillInIncompleteTokens:function(){return O},renderMarkdown:function(){return x},renderMarkdownAsPlaintext:function(){return T},renderStringAsPlaintext:function(){return L}});var n=i(96747),o=i(9709),r=i(50465),s=i(94264),a=i(8769),l=i(5642),c=i(21348),d=i(12718),u=i(63801),h=i(25674),g=i(69373),p=i(60538),m=i(5560),f=i(68921),b=i(55202),v=i(61098),_=i(27952),A=i(91057),C=i(50552),w=i(91482),y=i(19300);const S=Object.freeze({image:(e,t,i)=>{let n=[],o=[];return e&&(({href:e,dimensions:n}=(0,h.parseHrefAndDimensions)(e)),o.push(`src="${(0,h.escapeDoubleQuotes)(e)}"`)),i&&o.push(`alt="${(0,h.escapeDoubleQuotes)(i)}"`),t&&o.push(`title="${(0,h.escapeDoubleQuotes)(t)}"`),n.length&&(o=o.concat(n)),"<img "+o.join(" ")+">"},paragraph:e=>`<p>${e}</p>`,link:(e,t,i)=>"string"!=typeof e?"":(e===i&&(i=(0,h.removeMarkdownEscapes)(i)),t="string"==typeof t?(0,h.escapeDoubleQuotes)((0,h.removeMarkdownEscapes)(t)):"",`<a href="${e=(e=(0,h.removeMarkdownEscapes)(e)).replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&#39;")}" title="${t||e}" draggable="false">${i}</a>`)});function x(e,t={},i={}){var o,h;const m=new f.DisposableStore;let C=!1;const x=(0,s.createElement)(t),I=function(t){let i;try{i=(0,v.parse)(decodeURIComponent(t))}catch(e){}return i?(i=(0,A.cloneAndChange)(i,(t=>e.uris&&e.uris[t]?y.URI.revive(e.uris[t]):void 0)),encodeURIComponent(JSON.stringify(i))):t},L=function(t,i){const n=e.uris&&e.uris[t];let o=y.URI.revive(n);return i?t.startsWith(_.Schemas.data+":")?t:(o||(o=y.URI.parse(t)),_.FileAccess.uriToBrowserUri(o).toString(!0)):o?y.URI.parse(t).toString()===o.toString()?t:(o.query&&(o=o.with({query:I(o.query)})),o.toString()):t},T=new b.marked.Renderer;T.image=S.image,T.link=S.link,T.paragraph=S.paragraph;const M=[],N=[];if(t.codeBlockRendererSync?T.code=(e,i)=>{const n=p.defaultGenerator.nextId(),o=t.codeBlockRendererSync(E(i),e);return N.push([n,o]),`<div class="code" data-code="${n}">${(0,w.escape)(e)}</div>`}:t.codeBlockRenderer&&(T.code=(e,i)=>{const n=p.defaultGenerator.nextId(),o=t.codeBlockRenderer(E(i),e);return M.push(o.then((e=>[n,e]))),`<div class="code" data-code="${n}">${(0,w.escape)(e)}</div>`}),t.actionHandler){const i=function(i){let n=i.target;if("A"===n.tagName||(n=n.parentElement,n&&"A"===n.tagName))try{let o=n.dataset.href;o&&(e.baseUri&&(o=k(y.URI.from(e.baseUri),o)),t.actionHandler.callback(o,i))}catch(e){(0,d.onUnexpectedError)(e)}finally{i.preventDefault()}},o=t.actionHandler.disposables.add(new r.DomEmitter(x,"click")),s=t.actionHandler.disposables.add(new r.DomEmitter(x,"auxclick"));t.actionHandler.disposables.add(u.Event.any(o.event,s.event)((e=>{const t=new l.StandardMouseEvent(n.getWindow(x),e);(t.leftButton||t.middleButton)&&i(t)}))),t.actionHandler.disposables.add(n.addDisposableListener(x,"keydown",(e=>{const t=new a.StandardKeyboardEvent(e);(t.equals(10)||t.equals(3))&&i(t)})))}e.supportHtml||(i.sanitizer=t=>(e.isTrusted?t.match(/^(<span[^>]+>)|(<\/\s*span>)$/):void 0)?t:"",i.sanitize=!0,i.silent=!0),i.renderer=T;let R,B=null!==(o=e.value)&&void 0!==o?o:"";if(B.length>1e5&&(B=`${B.substr(0,1e5)}…`),e.supportThemeIcons&&(B=(0,g.markdownEscapeEscapedIcons)(B)),t.fillInIncompleteTokens){const e={...b.marked.defaults,...i},t=O(b.marked.lexer(B,e));R=b.marked.parser(t,e)}else R=b.marked.parse(B,i);if(e.supportThemeIcons){R=(0,c.renderLabelWithIcons)(R).map((e=>"string"==typeof e?e:e.outerHTML)).join("")}const F=(new DOMParser).parseFromString(D(e,R),"text/html");if(F.body.querySelectorAll("img").forEach((t=>{const i=t.getAttribute("src");if(i){let n=i;try{e.baseUri&&(n=k(y.URI.from(e.baseUri),n))}catch(e){}t.src=L(n,!0)}})),F.body.querySelectorAll("a").forEach((t=>{const i=t.getAttribute("href");if(t.setAttribute("href",""),!i||/^data:|javascript:/i.test(i)||/^command:/i.test(i)&&!e.isTrusted||/^command:(\/\/\/)?_workbench\.downloadResource/i.test(i))t.replaceWith(...t.childNodes);else{let n=L(i,!1);e.baseUri&&(n=k(y.URI.from(e.baseUri),i)),t.dataset.href=n}})),x.innerHTML=D(e,F.body.innerHTML),M.length>0)Promise.all(M).then((e=>{var i,o;if(C)return;const r=new Map(e),s=x.querySelectorAll("div[data-code]");for(const e of s){const t=r.get(null!==(i=e.dataset.code)&&void 0!==i?i:"");t&&n.reset(e,t)}null===(o=t.asyncRenderCallback)||void 0===o||o.call(t)}));else if(N.length>0){const e=new Map(N),t=x.querySelectorAll("div[data-code]");for(const i of t){const t=e.get(null!==(h=i.dataset.code)&&void 0!==h?h:"");t&&n.reset(i,t)}}if(t.asyncRenderCallback)for(const e of x.getElementsByTagName("img")){const i=m.add(n.addDisposableListener(e,"load",(()=>{i.dispose(),t.asyncRenderCallback()})))}return{element:x,dispose:()=>{C=!0,m.dispose()}}}function E(e){if(!e)return"";const t=e.split(/[\s+|:|,|\{|\?]/,1);return t.length?t[0]:e}function k(e,t){return/^\w[\w\d+.-]*:/.test(t)?t:e.path.endsWith("/")?(0,C.resolvePath)(e,t).toString():(0,C.resolvePath)((0,C.dirname)(e),t).toString()}function D(e,t){const{config:i,allowedSchemes:r}=function(e){const t=[_.Schemas.http,_.Schemas.https,_.Schemas.mailto,_.Schemas.data,_.Schemas.file,_.Schemas.vscodeFileResource,_.Schemas.vscodeRemote,_.Schemas.vscodeRemoteResource];e.isTrusted&&t.push(_.Schemas.command);return{config:{ALLOWED_TAGS:[...n.basicMarkupHtmlTags],ALLOWED_ATTR:I,ALLOW_UNKNOWN_PROTOCOLS:!0},allowedSchemes:t}}(e);o.addHook("uponSanitizeAttribute",((e,t)=>{if("style"!==t.attrName&&"class"!==t.attrName);else{if("SPAN"===e.tagName){if("style"===t.attrName)return void(t.keepAttr=/^(color\:(#[0-9a-fA-F]+|var\(--vscode(-[a-zA-Z]+)+\));)?(background-color\:(#[0-9a-fA-F]+|var\(--vscode(-[a-zA-Z]+)+\));)?$/.test(t.attrValue));if("class"===t.attrName)return void(t.keepAttr=/^codicon codicon-[a-z\-]+( codicon-modifier-[a-z\-]+)?$/.test(t.attrValue))}t.keepAttr=!1}}));const s=n.hookDomPurifyHrefAndSrcSanitizer(r);try{return o.sanitize(t,{...i,RETURN_TRUSTED_TYPE:!0})}finally{o.removeHook("uponSanitizeAttribute"),s.dispose()}}const I=["align","autoplay","alt","class","controls","data-code","data-href","draggable","height","href","loop","muted","playsinline","poster","src","style","target","title","width","start"];function L(e){return"string"==typeof e?e:T(e)}function T(e){var t;let i=null!==(t=e.value)&&void 0!==t?t:"";i.length>1e5&&(i=`${i.substr(0,1e5)}…`);const n=b.marked.parse(i,{renderer:N.value}).replace(/&(#\d+|[a-zA-Z]+);/g,(e=>{var t;return null!==(t=M.get(e))&&void 0!==t?t:e}));return D({isTrusted:!1},n).toString()}const M=new Map([["&quot;",'"'],["&nbsp;"," "],["&amp;","&"],["&#39;","'"],["&lt;","<"],["&gt;",">"]]),N=new m.Lazy((()=>{const e=new b.marked.Renderer;return e.code=e=>e,e.blockquote=e=>e,e.html=e=>"",e.heading=(e,t,i)=>e+"\n",e.hr=()=>"",e.list=(e,t)=>e,e.listitem=e=>e+"\n",e.paragraph=e=>e+"\n",e.table=(e,t)=>e+t+"\n",e.tablerow=e=>e,e.tablecell=(e,t)=>e+" ",e.strong=e=>e,e.em=e=>e,e.codespan=e=>e,e.br=()=>"\n",e.del=e=>e,e.image=(e,t,i)=>"",e.text=e=>e,e.link=(e,t,i)=>i,e}));function R(e){let t="";return e.forEach((e=>{t+=e.raw})),t}function B(e){for(const t of e.tokens)if("text"===t.type){const i=t.raw.split("\n"),n=i[i.length-1];if(n.includes("`"))return P(e);if(n.includes("**"))return Q(e,"**");if(n.match(/\*\w/))return z(e);if(n.match(/(^|\s)__\w/))return U(e);if(n.match(/(^|\s)_\w/))return W(e);if(n.match(/(^|\s)\[.*\]\(\w*/))return H(e);if(n.match(/(^|\s)\[\w/))return V(e)}}function O(e){let t,i;for(t=0;t<e.length;t++){const n=e[t];if("paragraph"===n.type&&n.raw.match(/(\n|^)```/)){i=F(e.slice(t));break}if("paragraph"===n.type&&n.raw.match(/(\n|^)\|/)){i=K(e.slice(t));break}if(t===e.length-1&&"paragraph"===n.type){const e=B(n);if(e){i=[e];break}}}if(i){const n=[...e.slice(0,t),...i];return n.links=e.links,n}return e}function F(e){const t=R(e);return b.marked.lexer(t+"\n```")}function P(e){return Q(e,"`")}function z(e){return Q(e,"*")}function W(e){return Q(e,"_")}function H(e){return Q(e,")")}function V(e){return Q(e,"](about:blank)")}function U(e){return Q(e,"__")}function Q(e,t){const i=R(Array.isArray(e)?e:[e]);return b.marked.lexer(i+t)[0]}function K(e){const t=R(e),i=t.split("\n");let n,o=!1;for(let e=0;e<i.length;e++){const t=i[e].trim();if(void 0===n&&t.match(/^\s*\|/)){const e=t.match(/(\|[^\|]+)(?=\||$)/g);e&&(n=e.length)}else if("number"==typeof n){if(!t.match(/^\s*\|/))return;if(e!==i.length-1)return;o=!0}}if("number"==typeof n&&n>0){const e=o?i.slice(0,-1).join("\n"):t,r=!!e.match(/\|\s*$/),s=e+(r?"":"|")+`\n|${" --- |".repeat(n)}`;return b.marked.lexer(s)}}},5642:function(e,t,i){"use strict";i.r(t),i.d(t,{StandardMouseEvent:function(){return s},StandardWheelEvent:function(){return a}});var n=i(76736),o=i(28132),r=i(66719);class s{constructor(e,t){this.timestamp=Date.now(),this.browserEvent=t,this.leftButton=0===t.button,this.middleButton=1===t.button,this.rightButton=2===t.button,this.buttons=t.buttons,this.target=t.target,this.detail=t.detail||1,"dblclick"===t.type&&(this.detail=2),this.ctrlKey=t.ctrlKey,this.shiftKey=t.shiftKey,this.altKey=t.altKey,this.metaKey=t.metaKey,"number"==typeof t.pageX?(this.posx=t.pageX,this.posy=t.pageY):(this.posx=t.clientX+this.target.ownerDocument.body.scrollLeft+this.target.ownerDocument.documentElement.scrollLeft,this.posy=t.clientY+this.target.ownerDocument.body.scrollTop+this.target.ownerDocument.documentElement.scrollTop);const i=o.IframeUtils.getPositionOfChildWindowRelativeToAncestorWindow(e,t.view);this.posx-=i.left,this.posy-=i.top}preventDefault(){this.browserEvent.preventDefault()}stopPropagation(){this.browserEvent.stopPropagation()}}class a{constructor(e,t=0,i=0){if(this.browserEvent=e||null,this.target=e?e.target||e.targetNode||e.srcElement:null,this.deltaY=i,this.deltaX=t,e){const t=e,i=e;if(void 0!==t.wheelDeltaY)this.deltaY=t.wheelDeltaY/120;else if(void 0!==i.VERTICAL_AXIS&&i.axis===i.VERTICAL_AXIS)this.deltaY=-i.detail/3;else if("wheel"===e.type){const t=e;t.deltaMode===t.DOM_DELTA_LINE?n.isFirefox&&!r.isMacintosh?this.deltaY=-e.deltaY/3:this.deltaY=-e.deltaY:this.deltaY=-e.deltaY/40}if(void 0!==t.wheelDeltaX)n.isSafari&&r.isWindows?this.deltaX=-t.wheelDeltaX/120:this.deltaX=t.wheelDeltaX/120;else if(void 0!==i.HORIZONTAL_AXIS&&i.axis===i.HORIZONTAL_AXIS)this.deltaX=-e.detail/3;else if("wheel"===e.type){const t=e;t.deltaMode===t.DOM_DELTA_LINE?n.isFirefox&&!r.isMacintosh?this.deltaX=-e.deltaX/3:this.deltaX=-e.deltaX:this.deltaX=-e.deltaX/40}0===this.deltaY&&0===this.deltaX&&e.wheelDelta&&(this.deltaY=e.wheelDelta/120)}}preventDefault(){var e;null===(e=this.browserEvent)||void 0===e||e.preventDefault()}stopPropagation(){var e;null===(e=this.browserEvent)||void 0===e||e.stopPropagation()}}},6119:function(e,t,i){"use strict";var n;i.r(t),i.d(t,{inputLatency:function(){return n}}),function(e){const t={total:0,min:Number.MAX_VALUE,max:0},i={...t},n={...t},o={...t};let r=0;const s={keydown:0,input:0,render:0};function a(){1===s.keydown&&(performance.mark("keydown/end"),s.keydown=2)}function l(){performance.mark("input/start"),s.input=1,u()}function c(){1===s.input&&(performance.mark("input/end"),s.input=2)}function d(){1===s.render&&(performance.mark("render/end"),s.render=2)}function u(){setTimeout(h)}function h(){2===s.keydown&&2===s.input&&2===s.render&&(performance.mark("inputlatency/end"),performance.measure("keydown","keydown/start","keydown/end"),performance.measure("input","input/start","input/end"),performance.measure("render","render/start","render/end"),performance.measure("inputlatency","inputlatency/start","inputlatency/end"),g("keydown",t),g("input",i),g("render",n),g("inputlatency",o),r++,performance.clearMarks("keydown/start"),performance.clearMarks("keydown/end"),performance.clearMarks("input/start"),performance.clearMarks("input/end"),performance.clearMarks("render/start"),performance.clearMarks("render/end"),performance.clearMarks("inputlatency/start"),performance.clearMarks("inputlatency/end"),performance.clearMeasures("keydown"),performance.clearMeasures("input"),performance.clearMeasures("render"),performance.clearMeasures("inputlatency"),s.keydown=0,s.input=0,s.render=0)}function g(e,t){const i=performance.getEntriesByName(e)[0].duration;t.total+=i,t.min=Math.min(t.min,i),t.max=Math.max(t.max,i)}function p(e){return{average:e.total/r,max:e.max,min:e.min}}function m(e){e.total=0,e.min=Number.MAX_VALUE,e.max=0}e.onKeyDown=function(){h(),performance.mark("inputlatency/start"),performance.mark("keydown/start"),s.keydown=1,queueMicrotask(a)},e.onBeforeInput=l,e.onInput=function(){0===s.input&&l(),queueMicrotask(c)},e.onKeyUp=function(){h()},e.onSelectionChange=function(){h()},e.onRenderStart=function(){2===s.keydown&&2===s.input&&0===s.render&&(performance.mark("render/start"),s.render=1,queueMicrotask(d),u())},e.getAndClearMeasurements=function(){if(0===r)return;const e={keydown:p(t),input:p(i),render:p(n),total:p(o),sampleCount:r};return m(t),m(i),m(n),m(o),r=0,e}}(n||(n={}))},4043:function(e,t,i){"use strict";i.r(t),i.d(t,{EventType:function(){return n},Gesture:function(){return h}});var n,o=i(96747),r=i(99817),s=i(64998),a=i(63966),l=i(63801),c=i(68921),d=i(22446),u=function(e,t,i,n){var o,r=arguments.length,s=r<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,i):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)s=Reflect.decorate(e,t,i,n);else for(var a=e.length-1;a>=0;a--)(o=e[a])&&(s=(r<3?o(s):r>3?o(t,i,s):o(t,i))||s);return r>3&&s&&Object.defineProperty(t,i,s),s};!function(e){e.Tap="-monaco-gesturetap",e.Change="-monaco-gesturechange",e.Start="-monaco-gesturestart",e.End="-monaco-gesturesend",e.Contextmenu="-monaco-gesturecontextmenu"}(n||(n={}));class h extends c.Disposable{constructor(){super(),this.dispatched=!1,this.targets=new d.LinkedList,this.ignoreTargets=new d.LinkedList,this.activeTouches={},this.handle=null,this._lastSetTapCountTime=0,this._register(l.Event.runAndSubscribe(o.onDidRegisterWindow,(({window:e,disposables:t})=>{t.add(o.addDisposableListener(e.document,"touchstart",(e=>this.onTouchStart(e)),{passive:!1})),t.add(o.addDisposableListener(e.document,"touchend",(t=>this.onTouchEnd(e,t)))),t.add(o.addDisposableListener(e.document,"touchmove",(e=>this.onTouchMove(e)),{passive:!1}))}),{window:r.mainWindow,disposables:this._store}))}static addTarget(e){if(!h.isTouchDevice())return c.Disposable.None;h.INSTANCE||(h.INSTANCE=(0,c.markAsSingleton)(new h));const t=h.INSTANCE.targets.push(e);return(0,c.toDisposable)(t)}static ignoreTarget(e){if(!h.isTouchDevice())return c.Disposable.None;h.INSTANCE||(h.INSTANCE=(0,c.markAsSingleton)(new h));const t=h.INSTANCE.ignoreTargets.push(e);return(0,c.toDisposable)(t)}static isTouchDevice(){return"ontouchstart"in r.mainWindow||navigator.maxTouchPoints>0}dispose(){this.handle&&(this.handle.dispose(),this.handle=null),super.dispose()}onTouchStart(e){const t=Date.now();this.handle&&(this.handle.dispose(),this.handle=null);for(let i=0,o=e.targetTouches.length;i<o;i++){const o=e.targetTouches.item(i);this.activeTouches[o.identifier]={id:o.identifier,initialTarget:o.target,initialTimeStamp:t,initialPageX:o.pageX,initialPageY:o.pageY,rollingTimestamps:[t],rollingPageX:[o.pageX],rollingPageY:[o.pageY]};const r=this.newGestureEvent(n.Start,o.target);r.pageX=o.pageX,r.pageY=o.pageY,this.dispatchEvent(r)}this.dispatched&&(e.preventDefault(),e.stopPropagation(),this.dispatched=!1)}onTouchEnd(e,t){const i=Date.now(),o=Object.keys(this.activeTouches).length;for(let r=0,a=t.changedTouches.length;r<a;r++){const a=t.changedTouches.item(r);if(!this.activeTouches.hasOwnProperty(String(a.identifier))){console.warn("move of an UNKNOWN touch",a);continue}const l=this.activeTouches[a.identifier],c=Date.now()-l.initialTimeStamp;if(c<h.HOLD_DELAY&&Math.abs(l.initialPageX-s.tail(l.rollingPageX))<30&&Math.abs(l.initialPageY-s.tail(l.rollingPageY))<30){const e=this.newGestureEvent(n.Tap,l.initialTarget);e.pageX=s.tail(l.rollingPageX),e.pageY=s.tail(l.rollingPageY),this.dispatchEvent(e)}else if(c>=h.HOLD_DELAY&&Math.abs(l.initialPageX-s.tail(l.rollingPageX))<30&&Math.abs(l.initialPageY-s.tail(l.rollingPageY))<30){const e=this.newGestureEvent(n.Contextmenu,l.initialTarget);e.pageX=s.tail(l.rollingPageX),e.pageY=s.tail(l.rollingPageY),this.dispatchEvent(e)}else if(1===o){const t=s.tail(l.rollingPageX),n=s.tail(l.rollingPageY),o=s.tail(l.rollingTimestamps)-l.rollingTimestamps[0],r=t-l.rollingPageX[0],a=n-l.rollingPageY[0],c=[...this.targets].filter((e=>l.initialTarget instanceof Node&&e.contains(l.initialTarget)));this.inertia(e,c,i,Math.abs(r)/o,r>0?1:-1,t,Math.abs(a)/o,a>0?1:-1,n)}this.dispatchEvent(this.newGestureEvent(n.End,l.initialTarget)),delete this.activeTouches[a.identifier]}this.dispatched&&(t.preventDefault(),t.stopPropagation(),this.dispatched=!1)}newGestureEvent(e,t){const i=document.createEvent("CustomEvent");return i.initEvent(e,!1,!0),i.initialTarget=t,i.tapCount=0,i}dispatchEvent(e){if(e.type===n.Tap){const t=(new Date).getTime();let i=0;i=t-this._lastSetTapCountTime>h.CLEAR_TAP_COUNT_TIME?1:2,this._lastSetTapCountTime=t,e.tapCount=i}else e.type!==n.Change&&e.type!==n.Contextmenu||(this._lastSetTapCountTime=0);if(e.initialTarget instanceof Node){for(const t of this.ignoreTargets)if(t.contains(e.initialTarget))return;for(const t of this.targets)t.contains(e.initialTarget)&&(t.dispatchEvent(e),this.dispatched=!0)}}inertia(e,t,i,r,s,a,l,c,d){this.handle=o.scheduleAtNextAnimationFrame(e,(()=>{const o=Date.now(),u=o-i;let g=0,p=0,m=!0;r+=h.SCROLL_FRICTION*u,l+=h.SCROLL_FRICTION*u,r>0&&(m=!1,g=s*r*u),l>0&&(m=!1,p=c*l*u);const f=this.newGestureEvent(n.Change);f.translationX=g,f.translationY=p,t.forEach((e=>e.dispatchEvent(f))),m||this.inertia(e,t,o,r,s,a+g,l,c,d+p)}))}onTouchMove(e){const t=Date.now();for(let i=0,o=e.changedTouches.length;i<o;i++){const o=e.changedTouches.item(i);if(!this.activeTouches.hasOwnProperty(String(o.identifier))){console.warn("end of an UNKNOWN touch",o);continue}const r=this.activeTouches[o.identifier],a=this.newGestureEvent(n.Change,r.initialTarget);a.translationX=o.pageX-s.tail(r.rollingPageX),a.translationY=o.pageY-s.tail(r.rollingPageY),a.pageX=o.pageX,a.pageY=o.pageY,this.dispatchEvent(a),r.rollingPageX.length>3&&(r.rollingPageX.shift(),r.rollingPageY.shift(),r.rollingTimestamps.shift()),r.rollingPageX.push(o.pageX),r.rollingPageY.push(o.pageY),r.rollingTimestamps.push(t)}this.dispatched&&(e.preventDefault(),e.stopPropagation(),this.dispatched=!1)}}h.SCROLL_FRICTION=-.005,h.HOLD_DELAY=700,h.CLEAR_TAP_COUNT_TIME=400,u([a.memoize],h,"isTouchDevice",null)},1639:function(e,t,i){"use strict";i.r(t),i.d(t,{createTrustedTypesPolicy:function(){return r}});var n=i(99817),o=i(12718);function r(e,t){var i;const r=globalThis.MonacoEnvironment;if(null==r?void 0:r.createTrustedTypesPolicy)try{return r.createTrustedTypesPolicy(e,t)}catch(e){return void(0,o.onUnexpectedError)(e)}try{return null===(i=n.mainWindow.trustedTypes)||void 0===i?void 0:i.createPolicy(e,t)}catch(e){return void(0,o.onUnexpectedError)(e)}}},61009:function(e,t,i){"use strict";i.r(t),i.d(t,{ActionViewItem:function(){return m},BaseActionViewItem:function(){return p},SelectActionViewItem:function(){return f}});var n=i(76736),o=i(65174),r=i(96747),s=i(4043),a=i(2720),l=i(66418),c=i(60969),d=i(68921),u=i(66719),h=i(18912),g=(i(59042),i(83787));class p extends d.Disposable{get action(){return this._action}constructor(e,t,i={}){super(),this.options=i,this._context=e||this,this._action=t,t instanceof c.Action&&this._register(t.onDidChange((e=>{this.element&&this.handleActionChangeEvent(e)})))}handleActionChangeEvent(e){void 0!==e.enabled&&this.updateEnabled(),void 0!==e.checked&&this.updateChecked(),void 0!==e.class&&this.updateClass(),void 0!==e.label&&(this.updateLabel(),this.updateTooltip()),void 0!==e.tooltip&&this.updateTooltip()}get actionRunner(){return this._actionRunner||(this._actionRunner=this._register(new c.ActionRunner)),this._actionRunner}set actionRunner(e){this._actionRunner=e}isEnabled(){return this._action.enabled}setActionContext(e){this._context=e}render(e){const t=this.element=e;this._register(s.Gesture.addTarget(e));const i=this.options&&this.options.draggable;i&&(e.draggable=!0,n.isFirefox&&this._register((0,r.addDisposableListener)(e,r.EventType.DRAG_START,(e=>{var t;return null===(t=e.dataTransfer)||void 0===t?void 0:t.setData(o.DataTransfers.TEXT,this._action.label)})))),this._register((0,r.addDisposableListener)(t,s.EventType.Tap,(e=>this.onClick(e,!0)))),this._register((0,r.addDisposableListener)(t,r.EventType.MOUSE_DOWN,(e=>{i||r.EventHelper.stop(e,!0),this._action.enabled&&0===e.button&&t.classList.add("active")}))),u.isMacintosh&&this._register((0,r.addDisposableListener)(t,r.EventType.CONTEXT_MENU,(e=>{0===e.button&&!0===e.ctrlKey&&this.onClick(e)}))),this._register((0,r.addDisposableListener)(t,r.EventType.CLICK,(e=>{r.EventHelper.stop(e,!0),this.options&&this.options.isMenu||this.onClick(e)}))),this._register((0,r.addDisposableListener)(t,r.EventType.DBLCLICK,(e=>{r.EventHelper.stop(e,!0)}))),[r.EventType.MOUSE_UP,r.EventType.MOUSE_OUT].forEach((e=>{this._register((0,r.addDisposableListener)(t,e,(e=>{r.EventHelper.stop(e),t.classList.remove("active")})))}))}onClick(e,t=!1){var i;r.EventHelper.stop(e,!0);const n=h.isUndefinedOrNull(this._context)?(null===(i=this.options)||void 0===i?void 0:i.useEventAsContext)?e:{preserveFocus:t}:this._context;this.actionRunner.run(this._action,n)}focus(){this.element&&(this.element.tabIndex=0,this.element.focus(),this.element.classList.add("focused"))}blur(){this.element&&(this.element.blur(),this.element.tabIndex=-1,this.element.classList.remove("focused"))}setFocusable(e){this.element&&(this.element.tabIndex=e?0:-1)}get trapsArrowNavigation(){return!1}updateEnabled(){}updateLabel(){}getClass(){return this.action.class}getTooltip(){return this.action.tooltip}updateTooltip(){var e;if(!this.element)return;const t=null!==(e=this.getTooltip())&&void 0!==e?e:"";this.updateAriaLabel(),this.options.hoverDelegate?(this.element.title="",this.customHover?this.customHover.update(t):(this.customHover=(0,a.setupCustomHover)(this.options.hoverDelegate,this.element,t),this._store.add(this.customHover))):this.element.title=t}updateAriaLabel(){var e;if(this.element){const t=null!==(e=this.getTooltip())&&void 0!==e?e:"";this.element.setAttribute("aria-label",t)}}updateClass(){}updateChecked(){}dispose(){this.element&&(this.element.remove(),this.element=void 0),this._context=void 0,super.dispose()}}class m extends p{constructor(e,t,i){super(e,t,i),this.options=i,this.options.icon=void 0!==i.icon&&i.icon,this.options.label=void 0===i.label||i.label,this.cssClass=""}render(e){super.render(e),h.assertType(this.element);const t=document.createElement("a");if(t.classList.add("action-label"),t.setAttribute("role",this.getDefaultAriaRole()),this.label=t,this.element.appendChild(t),this.options.label&&this.options.keybinding){const e=document.createElement("span");e.classList.add("keybinding"),e.textContent=this.options.keybinding,this.element.appendChild(e)}this.updateClass(),this.updateLabel(),this.updateTooltip(),this.updateEnabled(),this.updateChecked()}getDefaultAriaRole(){return this._action.id===c.Separator.ID?"presentation":this.options.isMenu?"menuitem":"button"}focus(){this.label&&(this.label.tabIndex=0,this.label.focus())}blur(){this.label&&(this.label.tabIndex=-1)}setFocusable(e){this.label&&(this.label.tabIndex=e?0:-1)}updateLabel(){this.options.label&&this.label&&(this.label.textContent=this.action.label)}getTooltip(){let e=null;return this.action.tooltip?e=this.action.tooltip:!this.options.label&&this.action.label&&this.options.icon&&(e=this.action.label,this.options.keybinding&&(e=g.localize("vs/base/browser/ui/actionbar/actionViewItems",{key:"titleLabel",comment:["action title","action keybinding"]},"{0} ({1})",e,this.options.keybinding))),null!=e?e:void 0}updateClass(){var e;this.cssClass&&this.label&&this.label.classList.remove(...this.cssClass.split(" ")),this.options.icon?(this.cssClass=this.getClass(),this.label&&(this.label.classList.add("codicon"),this.cssClass&&this.label.classList.add(...this.cssClass.split(" "))),this.updateEnabled()):null===(e=this.label)||void 0===e||e.classList.remove("codicon")}updateEnabled(){var e,t;this.action.enabled?(this.label&&(this.label.removeAttribute("aria-disabled"),this.label.classList.remove("disabled")),null===(e=this.element)||void 0===e||e.classList.remove("disabled")):(this.label&&(this.label.setAttribute("aria-disabled","true"),this.label.classList.add("disabled")),null===(t=this.element)||void 0===t||t.classList.add("disabled"))}updateAriaLabel(){var e;if(this.label){const t=null!==(e=this.getTooltip())&&void 0!==e?e:"";this.label.setAttribute("aria-label",t)}}updateChecked(){this.label&&(void 0!==this.action.checked?(this.label.classList.toggle("checked",this.action.checked),this.label.setAttribute("aria-checked",this.action.checked?"true":"false"),this.label.setAttribute("role","checkbox")):(this.label.classList.remove("checked"),this.label.removeAttribute("aria-checked"),this.label.setAttribute("role",this.getDefaultAriaRole())))}}class f extends p{constructor(e,t,i,n,o,r,s){super(e,t),this.selectBox=new l.SelectBox(i,n,o,r,s),this.selectBox.setFocusable(!1),this._register(this.selectBox),this.registerListeners()}select(e){this.selectBox.select(e)}registerListeners(){this._register(this.selectBox.onDidSelect((e=>this.runAction(e.selected,e.index))))}runAction(e,t){this.actionRunner.run(this._action,this.getActionContext(e,t))}getActionContext(e,t){return e}setFocusable(e){this.selectBox.setFocusable(e)}focus(){var e;null===(e=this.selectBox)||void 0===e||e.focus()}blur(){var e;null===(e=this.selectBox)||void 0===e||e.blur()}render(e){this.selectBox.render(e)}}},31532:function(e,t,i){"use strict";i.r(t),i.d(t,{ActionBar:function(){return d}});var n=i(96747),o=i(8769),r=i(61009),s=i(60969),a=i(63801),l=i(68921),c=i(18912);i(59042);class d extends l.Disposable{constructor(e,t={}){var i,c,d,u,h,g;let p,m;switch(super(),this._actionRunnerDisposables=this._register(new l.DisposableStore),this.viewItemDisposables=this._register(new l.DisposableMap),this.triggerKeyDown=!1,this.focusable=!0,this._onDidBlur=this._register(new a.Emitter),this.onDidBlur=this._onDidBlur.event,this._onDidCancel=this._register(new a.Emitter({onWillAddFirstListener:()=>this.cancelHasListener=!0})),this.onDidCancel=this._onDidCancel.event,this.cancelHasListener=!1,this._onDidRun=this._register(new a.Emitter),this.onDidRun=this._onDidRun.event,this._onWillRun=this._register(new a.Emitter),this.onWillRun=this._onWillRun.event,this.options=t,this._context=null!==(i=t.context)&&void 0!==i?i:null,this._orientation=null!==(c=this.options.orientation)&&void 0!==c?c:0,this._triggerKeys={keyDown:null!==(u=null===(d=this.options.triggerKeys)||void 0===d?void 0:d.keyDown)&&void 0!==u&&u,keys:null!==(g=null===(h=this.options.triggerKeys)||void 0===h?void 0:h.keys)&&void 0!==g?g:[3,10]},this.options.actionRunner?this._actionRunner=this.options.actionRunner:(this._actionRunner=new s.ActionRunner,this._actionRunnerDisposables.add(this._actionRunner)),this._actionRunnerDisposables.add(this._actionRunner.onDidRun((e=>this._onDidRun.fire(e)))),this._actionRunnerDisposables.add(this._actionRunner.onWillRun((e=>this._onWillRun.fire(e)))),this.viewItems=[],this.focusedItem=void 0,this.domNode=document.createElement("div"),this.domNode.className="monaco-action-bar",!1!==t.animated&&this.domNode.classList.add("animated"),this._orientation){case 0:p=[15],m=[17];break;case 1:p=[16],m=[18],this.domNode.className+=" vertical"}this._register(n.addDisposableListener(this.domNode,n.EventType.KEY_DOWN,(e=>{const t=new o.StandardKeyboardEvent(e);let i=!0;const n="number"==typeof this.focusedItem?this.viewItems[this.focusedItem]:void 0;p&&(t.equals(p[0])||t.equals(p[1]))?i=this.focusPrevious():m&&(t.equals(m[0])||t.equals(m[1]))?i=this.focusNext():t.equals(9)&&this.cancelHasListener?this._onDidCancel.fire():t.equals(14)?i=this.focusFirst():t.equals(13)?i=this.focusLast():t.equals(2)&&n instanceof r.BaseActionViewItem&&n.trapsArrowNavigation?i=this.focusNext():this.isTriggerKeyEvent(t)?this._triggerKeys.keyDown?this.doTrigger(t):this.triggerKeyDown=!0:i=!1,i&&(t.preventDefault(),t.stopPropagation())}))),this._register(n.addDisposableListener(this.domNode,n.EventType.KEY_UP,(e=>{const t=new o.StandardKeyboardEvent(e);this.isTriggerKeyEvent(t)?(!this._triggerKeys.keyDown&&this.triggerKeyDown&&(this.triggerKeyDown=!1,this.doTrigger(t)),t.preventDefault(),t.stopPropagation()):(t.equals(2)||t.equals(1026)||t.equals(16)||t.equals(18)||t.equals(15)||t.equals(17))&&this.updateFocusedItem()}))),this.focusTracker=this._register(n.trackFocus(this.domNode)),this._register(this.focusTracker.onDidBlur((()=>{n.getActiveElement()!==this.domNode&&n.isAncestor(n.getActiveElement(),this.domNode)||(this._onDidBlur.fire(),this.previouslyFocusedItem=this.focusedItem,this.focusedItem=void 0,this.triggerKeyDown=!1)}))),this._register(this.focusTracker.onDidFocus((()=>this.updateFocusedItem()))),this.actionsList=document.createElement("ul"),this.actionsList.className="actions-container",this.options.highlightToggledItems&&this.actionsList.classList.add("highlight-toggled"),this.actionsList.setAttribute("role",this.options.ariaRole||"toolbar"),this.options.ariaLabel&&this.actionsList.setAttribute("aria-label",this.options.ariaLabel),this.domNode.appendChild(this.actionsList),e.appendChild(this.domNode)}refreshRole(){this.length()>=1?this.actionsList.setAttribute("role",this.options.ariaRole||"toolbar"):this.actionsList.setAttribute("role","presentation")}setFocusable(e){if(this.focusable=e,this.focusable){const e=this.viewItems.find((e=>e instanceof r.BaseActionViewItem&&e.isEnabled()));e instanceof r.BaseActionViewItem&&e.setFocusable(!0)}else this.viewItems.forEach((e=>{e instanceof r.BaseActionViewItem&&e.setFocusable(!1)}))}isTriggerKeyEvent(e){let t=!1;return this._triggerKeys.keys.forEach((i=>{t=t||e.equals(i)})),t}updateFocusedItem(){var e,t;for(let i=0;i<this.actionsList.children.length;i++){const o=this.actionsList.children[i];if(n.isAncestor(n.getActiveElement(),o)){this.focusedItem=i,null===(t=null===(e=this.viewItems[this.focusedItem])||void 0===e?void 0:e.showHover)||void 0===t||t.call(e);break}}}get context(){return this._context}set context(e){this._context=e,this.viewItems.forEach((t=>t.setActionContext(e)))}get actionRunner(){return this._actionRunner}set actionRunner(e){this._actionRunner=e,this._actionRunnerDisposables.clear(),this._actionRunnerDisposables.add(this._actionRunner.onDidRun((e=>this._onDidRun.fire(e)))),this._actionRunnerDisposables.add(this._actionRunner.onWillRun((e=>this._onWillRun.fire(e)))),this.viewItems.forEach((t=>t.actionRunner=e))}getContainer(){return this.domNode}getAction(e){var t;if("number"==typeof e)return null===(t=this.viewItems[e])||void 0===t?void 0:t.action;if(e instanceof HTMLElement){for(;e.parentElement!==this.actionsList;){if(!e.parentElement)return;e=e.parentElement}for(let t=0;t<this.actionsList.childNodes.length;t++)if(this.actionsList.childNodes[t]===e)return this.viewItems[t].action}}push(e,t={}){const i=Array.isArray(e)?e:[e];let o=c.isNumber(t.index)?t.index:null;i.forEach((e=>{const i=document.createElement("li");let s;i.className="action-item",i.setAttribute("role","presentation");const a={hoverDelegate:this.options.hoverDelegate,...t};this.options.actionViewItemProvider&&(s=this.options.actionViewItemProvider(e,a)),s||(s=new r.ActionViewItem(this.context,e,a)),this.options.allowContextMenu||this.viewItemDisposables.set(s,n.addDisposableListener(i,n.EventType.CONTEXT_MENU,(e=>{n.EventHelper.stop(e,!0)}))),s.actionRunner=this._actionRunner,s.setActionContext(this.context),s.render(i),this.focusable&&s instanceof r.BaseActionViewItem&&0===this.viewItems.length&&s.setFocusable(!0),null===o||o<0||o>=this.actionsList.children.length?(this.actionsList.appendChild(i),this.viewItems.push(s)):(this.actionsList.insertBefore(i,this.actionsList.children[o]),this.viewItems.splice(o,0,s),o++)})),"number"==typeof this.focusedItem&&this.focus(this.focusedItem),this.refreshRole()}clear(){this.isEmpty()||(this.viewItems=(0,l.dispose)(this.viewItems),this.viewItemDisposables.clearAndDisposeAll(),n.clearNode(this.actionsList),this.refreshRole())}length(){return this.viewItems.length}isEmpty(){return 0===this.viewItems.length}focus(e){let t,i=!1;if(void 0===e?i=!0:"number"==typeof e?t=e:"boolean"==typeof e&&(i=e),i&&void 0===this.focusedItem){const e=this.viewItems.findIndex((e=>e.isEnabled()));this.focusedItem=-1===e?void 0:e,this.updateFocus(void 0,void 0,!0)}else void 0!==t&&(this.focusedItem=t),this.updateFocus(void 0,void 0,!0)}focusFirst(){return this.focusedItem=this.length()-1,this.focusNext(!0)}focusLast(){return this.focusedItem=0,this.focusPrevious(!0)}focusNext(e){if(void 0===this.focusedItem)this.focusedItem=this.viewItems.length-1;else if(this.viewItems.length<=1)return!1;const t=this.focusedItem;let i;do{if(!e&&this.options.preventLoopNavigation&&this.focusedItem+1>=this.viewItems.length)return this.focusedItem=t,!1;this.focusedItem=(this.focusedItem+1)%this.viewItems.length,i=this.viewItems[this.focusedItem]}while(this.focusedItem!==t&&(this.options.focusOnlyEnabledItems&&!i.isEnabled()||i.action.id===s.Separator.ID));return this.updateFocus(),!0}focusPrevious(e){if(void 0===this.focusedItem)this.focusedItem=0;else if(this.viewItems.length<=1)return!1;const t=this.focusedItem;let i;do{if(this.focusedItem=this.focusedItem-1,this.focusedItem<0){if(!e&&this.options.preventLoopNavigation)return this.focusedItem=t,!1;this.focusedItem=this.viewItems.length-1}i=this.viewItems[this.focusedItem]}while(this.focusedItem!==t&&(this.options.focusOnlyEnabledItems&&!i.isEnabled()||i.action.id===s.Separator.ID));return this.updateFocus(!0),!0}updateFocus(e,t,i=!1){var n,o;void 0===this.focusedItem&&this.actionsList.focus({preventScroll:t}),void 0!==this.previouslyFocusedItem&&this.previouslyFocusedItem!==this.focusedItem&&(null===(n=this.viewItems[this.previouslyFocusedItem])||void 0===n||n.blur());const r=void 0!==this.focusedItem?this.viewItems[this.focusedItem]:void 0;if(r){let n=!0;c.isFunction(r.focus)||(n=!1),this.options.focusOnlyEnabledItems&&c.isFunction(r.isEnabled)&&!r.isEnabled()&&(n=!1),r.action.id===s.Separator.ID&&(n=!1),n&&(null===(o=r.showHover)||void 0===o||o.call(r)),n?(i||this.previouslyFocusedItem!==this.focusedItem)&&(r.focus(e),this.previouslyFocusedItem=this.focusedItem):(this.actionsList.focus({preventScroll:t}),this.previouslyFocusedItem=void 0)}}doTrigger(e){if(void 0===this.focusedItem)return;const t=this.viewItems[this.focusedItem];if(t instanceof r.BaseActionViewItem){const i=null===t._context||void 0===t._context?e:t._context;this.run(t._action,i)}}async run(e,t){await this._actionRunner.run(e,t)}dispose(){this._context=void 0,this.viewItems=(0,l.dispose)(this.viewItems),this.getContainer().remove(),super.dispose()}}},61950:function(e,t,i){"use strict";i.r(t),i.d(t,{alert:function(){return x},setARIAContainer:function(){return S},status:function(){return E}});var n=i(96747),o=i(93379),r=i.n(o),s=i(7795),a=i.n(s),l=i(90569),c=i.n(l),d=i(3565),u=i.n(d),h=i(19216),g=i.n(h),p=i(44589),m=i.n(p),f=i(40371),b={};b.styleTagTransform=m(),b.setAttributes=u(),b.insert=c().bind(null,"head"),b.domAPI=a(),b.insertStyleElement=g();r()(f.Z,b),f.Z&&f.Z.locals&&f.Z.locals;const v=2e4;let _,A,C,w,y;function S(e){_=document.createElement("div"),_.className="monaco-aria-container";const t=()=>{const e=document.createElement("div");return e.className="monaco-alert",e.setAttribute("role","alert"),e.setAttribute("aria-atomic","true"),_.appendChild(e),e};A=t(),C=t();const i=()=>{const e=document.createElement("div");return e.className="monaco-status",e.setAttribute("aria-live","polite"),e.setAttribute("aria-atomic","true"),_.appendChild(e),e};w=i(),y=i(),e.appendChild(_)}function x(e){_&&(A.textContent!==e?(n.clearNode(C),k(A,e)):(n.clearNode(A),k(C,e)))}function E(e){_&&(w.textContent!==e?(n.clearNode(y),k(w,e)):(n.clearNode(w),k(y,e)))}function k(e,t){n.clearNode(e),t.length>v&&(t=t.substr(0,v)),e.textContent=t,e.style.visibility="hidden",e.style.visibility="visible"}},54042:function(e,t,i){"use strict";i.r(t),i.d(t,{Button:function(){return I},unthemedButtonStyles:function(){return D}});var n=i(96747),o=i(9709),r=i(8769),s=i(32703),a=i(4043),l=i(21348),c=i(17160),d=i(63801),u=i(25674),h=i(68921),g=i(27269),p=i(93379),m=i.n(p),f=i(7795),b=i.n(f),v=i(90569),_=i.n(v),A=i(3565),C=i.n(A),w=i(19216),y=i.n(w),S=i(44589),x=i.n(S),E=i(55796),k={};k.styleTagTransform=x(),k.setAttributes=C(),k.insert=_().bind(null,"head"),k.domAPI=b(),k.insertStyleElement=y();m()(E.Z,k),E.Z&&E.Z.locals&&E.Z.locals;const D={buttonBackground:"#0E639C",buttonHoverBackground:"#006BB3",buttonSeparator:c.Color.white.toString(),buttonForeground:c.Color.white.toString(),buttonBorder:void 0,buttonSecondaryBackground:void 0,buttonSecondaryForeground:void 0,buttonSecondaryHoverBackground:void 0};class I extends h.Disposable{get onDidClick(){return this._onDidClick.event}constructor(e,t){super(),this._label="",this._onDidClick=this._register(new d.Emitter),this.options=t,this._element=document.createElement("a"),this._element.classList.add("monaco-button"),this._element.tabIndex=0,this._element.setAttribute("role","button"),this._element.classList.toggle("secondary",!!t.secondary);const i=t.secondary?t.buttonSecondaryBackground:t.buttonBackground,o=t.secondary?t.buttonSecondaryForeground:t.buttonForeground;this._element.style.color=o||"",this._element.style.backgroundColor=i||"",t.supportShortLabel&&(this._labelShortElement=document.createElement("div"),this._labelShortElement.classList.add("monaco-button-label-short"),this._element.appendChild(this._labelShortElement),this._labelElement=document.createElement("div"),this._labelElement.classList.add("monaco-button-label"),this._element.appendChild(this._labelElement),this._element.classList.add("monaco-text-button-with-short-label")),e.appendChild(this._element),this._register(a.Gesture.addTarget(this._element)),[n.EventType.CLICK,a.EventType.Tap].forEach((e=>{this._register((0,n.addDisposableListener)(this._element,e,(e=>{this.enabled?this._onDidClick.fire(e):n.EventHelper.stop(e)})))})),this._register((0,n.addDisposableListener)(this._element,n.EventType.KEY_DOWN,(e=>{const t=new r.StandardKeyboardEvent(e);let i=!1;this.enabled&&(t.equals(3)||t.equals(10))?(this._onDidClick.fire(e),i=!0):t.equals(9)&&(this._element.blur(),i=!0),i&&n.EventHelper.stop(t,!0)}))),this._register((0,n.addDisposableListener)(this._element,n.EventType.MOUSE_OVER,(e=>{this._element.classList.contains("disabled")||this.updateBackground(!0)}))),this._register((0,n.addDisposableListener)(this._element,n.EventType.MOUSE_OUT,(e=>{this.updateBackground(!1)}))),this.focusTracker=this._register((0,n.trackFocus)(this._element)),this._register(this.focusTracker.onDidFocus((()=>{this.enabled&&this.updateBackground(!0)}))),this._register(this.focusTracker.onDidBlur((()=>{this.enabled&&this.updateBackground(!1)})))}dispose(){super.dispose(),this._element.remove()}getContentElements(e){const t=[];for(let i of(0,l.renderLabelWithIcons)(e))if("string"==typeof i){if(i=i.trim(),""===i)continue;const e=document.createElement("span");e.textContent=i,t.push(e)}else t.push(i);return t}updateBackground(e){let t;t=this.options.secondary?e?this.options.buttonSecondaryHoverBackground:this.options.buttonSecondaryBackground:e?this.options.buttonHoverBackground:this.options.buttonBackground,t&&(this._element.style.backgroundColor=t)}get element(){return this._element}set label(e){var t;if(this._label===e)return;if((0,u.isMarkdownString)(this._label)&&(0,u.isMarkdownString)(e)&&(0,u.markdownStringEqual)(this._label,e))return;this._element.classList.add("monaco-text-button");const i=this.options.supportShortLabel?this._labelElement:this._element;if((0,u.isMarkdownString)(e)){const r=(0,s.renderMarkdown)(e,{inline:!0});r.dispose();const a=null===(t=r.element.querySelector("p"))||void 0===t?void 0:t.innerHTML;if(a){const e=(0,o.sanitize)(a,{ADD_TAGS:["b","i","u","code","span"],ALLOWED_ATTR:["class"],RETURN_TRUSTED_TYPE:!0});i.innerHTML=e}else(0,n.reset)(i)}else this.options.supportIcons?(0,n.reset)(i,...this.getContentElements(e)):i.textContent=e;"string"==typeof this.options.title?this._element.title=this.options.title:this.options.title&&(this._element.title=(0,s.renderStringAsPlaintext)(e)),this._label=e}get label(){return this._label}set icon(e){this._element.classList.add(...g.ThemeIcon.asClassNameArray(e))}set enabled(e){e?(this._element.classList.remove("disabled"),this._element.setAttribute("aria-disabled",String(!1)),this._element.tabIndex=0):(this._element.classList.add("disabled"),this._element.setAttribute("aria-disabled",String(!0)))}get enabled(){return!this._element.classList.contains("disabled")}}},96205:function(e,t,i){"use strict";i.r(t),i.d(t,{ContextView:function(){return x},LayoutAnchorMode:function(){return w},isAnchor:function(){return y},layout:function(){return S}});var n=i(69098),o=i(96747),r=i(68921),s=i(66719),a=i(83682),l=i(93379),c=i.n(l),d=i(7795),u=i.n(d),h=i(90569),g=i.n(h),p=i(3565),m=i.n(p),f=i(19216),b=i.n(f),v=i(44589),_=i.n(v),A=i(72555),C={};C.styleTagTransform=_(),C.setAttributes=m(),C.insert=g().bind(null,"head"),C.domAPI=u(),C.insertStyleElement=b();var w;c()(A.Z,C),A.Z&&A.Z.locals&&A.Z.locals;function y(e){const t=e;return!!t&&"number"==typeof t.x&&"number"==typeof t.y}function S(e,t,i){const n=i.mode===w.ALIGN?i.offset:i.offset+i.size,o=i.mode===w.ALIGN?i.offset+i.size:i.offset;return 0===i.position?t<=e-n?n:t<=o?o-t:Math.max(e-t,0):t<=o?o-t:t<=e-n?n:0}!function(e){e[e.AVOID=0]="AVOID",e[e.ALIGN=1]="ALIGN"}(w||(w={}));class x extends r.Disposable{constructor(e,t){super(),this.container=null,this.useFixedPosition=!1,this.useShadowDOM=!1,this.delegate=null,this.toDisposeOnClean=r.Disposable.None,this.toDisposeOnSetContainer=r.Disposable.None,this.shadowRoot=null,this.shadowRootHostElement=null,this.view=o.$(".context-view"),o.hide(this.view),this.setContainer(e,t),this._register((0,r.toDisposable)((()=>this.setContainer(null,1))))}setContainer(e,t){var i;this.useFixedPosition=1!==t;const n=this.useShadowDOM;if(this.useShadowDOM=3===t,(e!==this.container||n===this.useShadowDOM)&&(this.container&&(this.toDisposeOnSetContainer.dispose(),this.shadowRoot?(this.shadowRoot.removeChild(this.view),this.shadowRoot=null,null===(i=this.shadowRootHostElement)||void 0===i||i.remove(),this.shadowRootHostElement=null):this.container.removeChild(this.view),this.container=null),e)){if(this.container=e,this.useShadowDOM){this.shadowRootHostElement=o.$(".shadow-root-host"),this.container.appendChild(this.shadowRootHostElement),this.shadowRoot=this.shadowRootHostElement.attachShadow({mode:"open"});const e=document.createElement("style");e.textContent=E,this.shadowRoot.appendChild(e),this.shadowRoot.appendChild(this.view),this.shadowRoot.appendChild(o.$("slot"))}else this.container.appendChild(this.view);const t=new r.DisposableStore;x.BUBBLE_UP_EVENTS.forEach((e=>{t.add(o.addStandardDisposableListener(this.container,e,(e=>{this.onDOMEvent(e,!1)})))})),x.BUBBLE_DOWN_EVENTS.forEach((e=>{t.add(o.addStandardDisposableListener(this.container,e,(e=>{this.onDOMEvent(e,!0)}),!0))})),this.toDisposeOnSetContainer=t}}show(e){var t,i;this.isVisible()&&this.hide(),o.clearNode(this.view),this.view.className="context-view",this.view.style.top="0px",this.view.style.left="0px",this.view.style.zIndex="2575",this.view.style.position=this.useFixedPosition?"fixed":"absolute",o.show(this.view),this.toDisposeOnClean=e.render(this.view)||r.Disposable.None,this.delegate=e,this.doLayout(),null===(i=(t=this.delegate).focus)||void 0===i||i.call(t)}getViewElement(){return this.view}layout(){this.isVisible()&&(!1!==this.delegate.canRelayout||s.isIOS&&n.BrowserFeatures.pointerEvents?(this.delegate.layout&&this.delegate.layout(),this.doLayout()):this.hide())}doLayout(){if(!this.isVisible())return;const e=this.delegate.getAnchor();let t;if(e instanceof HTMLElement){const i=o.getDomNodePagePosition(e),n=o.getDomNodeZoomLevel(e);t={top:i.top*n,left:i.left*n,width:i.width*n,height:i.height*n}}else t=y(e)?{top:e.y,left:e.x,width:e.width||1,height:e.height||2}:{top:e.posy,left:e.posx,width:2,height:2};const i=o.getTotalWidth(this.view),n=o.getTotalHeight(this.view),r=this.delegate.anchorPosition||0,s=this.delegate.anchorAlignment||0,l=this.delegate.anchorAxisAlignment||0;let c,d;const u=o.getActiveWindow();if(0===l){const e={offset:t.top-u.pageYOffset,size:t.height,position:0===r?0:1},o={offset:t.left,size:t.width,position:0===s?0:1,mode:w.ALIGN};c=S(u.innerHeight,n,e)+u.pageYOffset,a.Range.intersects({start:c,end:c+n},{start:e.offset,end:e.offset+e.size})&&(o.mode=w.AVOID),d=S(u.innerWidth,i,o)}else{const e={offset:t.left,size:t.width,position:0===s?0:1},o={offset:t.top,size:t.height,position:0===r?0:1,mode:w.ALIGN};d=S(u.innerWidth,i,e),a.Range.intersects({start:d,end:d+i},{start:e.offset,end:e.offset+e.size})&&(o.mode=w.AVOID),c=S(u.innerHeight,n,o)+u.pageYOffset}this.view.classList.remove("top","bottom","left","right"),this.view.classList.add(0===r?"bottom":"top"),this.view.classList.add(0===s?"left":"right"),this.view.classList.toggle("fixed",this.useFixedPosition);const h=o.getDomNodePagePosition(this.container);this.view.style.top=c-(this.useFixedPosition?o.getDomNodePagePosition(this.view).top:h.top)+"px",this.view.style.left=d-(this.useFixedPosition?o.getDomNodePagePosition(this.view).left:h.left)+"px",this.view.style.width="initial"}hide(e){const t=this.delegate;this.delegate=null,(null==t?void 0:t.onHide)&&t.onHide(e),this.toDisposeOnClean.dispose(),o.hide(this.view)}isVisible(){return!!this.delegate}onDOMEvent(e,t){this.delegate&&(this.delegate.onDOMEvent?this.delegate.onDOMEvent(e,o.getWindow(e).document.activeElement):t&&!o.isAncestor(e.target,this.container)&&this.hide())}dispose(){this.hide(),super.dispose()}}x.BUBBLE_UP_EVENTS=["click","keydown","focus","blur"],x.BUBBLE_DOWN_EVENTS=["click"];const E='\n\t:host {\n\t\tall: initial; /* 1st rule so subsequent properties are reset. */\n\t}\n\n\t.codicon[class*=\'codicon-\'] {\n\t\tfont: normal normal normal 16px/1 codicon;\n\t\tdisplay: inline-block;\n\t\ttext-decoration: none;\n\t\ttext-rendering: auto;\n\t\ttext-align: center;\n\t\t-webkit-font-smoothing: antialiased;\n\t\t-moz-osx-font-smoothing: grayscale;\n\t\tuser-select: none;\n\t\t-webkit-user-select: none;\n\t\t-ms-user-select: none;\n\t}\n\n\t:host {\n\t\tfont-family: -apple-system, BlinkMacSystemFont, "Segoe WPC", "Segoe UI", "HelveticaNeue-Light", system-ui, "Ubuntu", "Droid Sans", sans-serif;\n\t}\n\n\t:host-context(.mac) { font-family: -apple-system, BlinkMacSystemFont, sans-serif; }\n\t:host-context(.mac:lang(zh-Hans)) { font-family: -apple-system, BlinkMacSystemFont, "PingFang SC", "Hiragino Sans GB", sans-serif; }\n\t:host-context(.mac:lang(zh-Hant)) { font-family: -apple-system, BlinkMacSystemFont, "PingFang TC", sans-serif; }\n\t:host-context(.mac:lang(ja)) { font-family: -apple-system, BlinkMacSystemFont, "Hiragino Kaku Gothic Pro", sans-serif; }\n\t:host-context(.mac:lang(ko)) { font-family: -apple-system, BlinkMacSystemFont, "Nanum Gothic", "Apple SD Gothic Neo", "AppleGothic", sans-serif; }\n\n\t:host-context(.windows) { font-family: "Segoe WPC", "Segoe UI", sans-serif; }\n\t:host-context(.windows:lang(zh-Hans)) { font-family: "Segoe WPC", "Segoe UI", "Microsoft YaHei", sans-serif; }\n\t:host-context(.windows:lang(zh-Hant)) { font-family: "Segoe WPC", "Segoe UI", "Microsoft Jhenghei", sans-serif; }\n\t:host-context(.windows:lang(ja)) { font-family: "Segoe WPC", "Segoe UI", "Yu Gothic UI", "Meiryo UI", sans-serif; }\n\t:host-context(.windows:lang(ko)) { font-family: "Segoe WPC", "Segoe UI", "Malgun Gothic", "Dotom", sans-serif; }\n\n\t:host-context(.linux) { font-family: system-ui, "Ubuntu", "Droid Sans", sans-serif; }\n\t:host-context(.linux:lang(zh-Hans)) { font-family: system-ui, "Ubuntu", "Droid Sans", "Source Han Sans SC", "Source Han Sans CN", "Source Han Sans", sans-serif; }\n\t:host-context(.linux:lang(zh-Hant)) { font-family: system-ui, "Ubuntu", "Droid Sans", "Source Han Sans TC", "Source Han Sans TW", "Source Han Sans", sans-serif; }\n\t:host-context(.linux:lang(ja)) { font-family: system-ui, "Ubuntu", "Droid Sans", "Source Han Sans J", "Source Han Sans JP", "Source Han Sans", sans-serif; }\n\t:host-context(.linux:lang(ko)) { font-family: system-ui, "Ubuntu", "Droid Sans", "Source Han Sans K", "Source Han Sans JR", "Source Han Sans", "UnDotum", "FBaekmuk Gulim", sans-serif; }\n'},66218:function(e,t,i){"use strict";i.r(t),i.d(t,{CountBadge:function(){return _}});var n=i(96747),o=i(91482),r=i(93379),s=i.n(r),a=i(7795),l=i.n(a),c=i(90569),d=i.n(c),u=i(3565),h=i.n(u),g=i(19216),p=i.n(g),m=i(44589),f=i.n(m),b=i(73688),v={};v.styleTagTransform=f(),v.setAttributes=h(),v.insert=d().bind(null,"head"),v.domAPI=l(),v.insertStyleElement=p();s()(b.Z,v),b.Z&&b.Z.locals&&b.Z.locals;class _{constructor(e,t,i){this.options=t,this.styles=i,this.count=0,this.element=(0,n.append)(e,(0,n.$)(".monaco-count-badge")),this.countFormat=this.options.countFormat||"{0}",this.titleFormat=this.options.titleFormat||"",this.setCount(this.options.count||0)}setCount(e){this.count=e,this.render()}setTitleFormat(e){this.titleFormat=e,this.render()}render(){var e,t;this.element.textContent=(0,o.format)(this.countFormat,this.count),this.element.title=(0,o.format)(this.titleFormat,this.count),this.element.style.backgroundColor=null!==(e=this.styles.badgeBackground)&&void 0!==e?e:"",this.element.style.color=null!==(t=this.styles.badgeForeground)&&void 0!==t?t:"",this.styles.badgeBorder&&(this.element.style.border=`1px solid ${this.styles.badgeBorder}`)}}},96319:function(e,t,i){"use strict";i.r(t),i.d(t,{DropdownMenu:function(){return c}});var n=i(96747),o=i(8769),r=i(4043),s=i(60969),a=i(63801);i(45549);class l extends s.ActionRunner{constructor(e,t){super(),this._onDidChangeVisibility=this._register(new a.Emitter),this.onDidChangeVisibility=this._onDidChangeVisibility.event,this._element=(0,n.append)(e,(0,n.$)(".monaco-dropdown")),this._label=(0,n.append)(this._element,(0,n.$)(".dropdown-label"));let i=t.labelRenderer;i||(i=e=>(e.textContent=t.label||"",null));for(const e of[n.EventType.CLICK,n.EventType.MOUSE_DOWN,r.EventType.Tap])this._register((0,n.addDisposableListener)(this.element,e,(e=>n.EventHelper.stop(e,!0))));for(const e of[n.EventType.MOUSE_DOWN,r.EventType.Tap])this._register((0,n.addDisposableListener)(this._label,e,(e=>{(0,n.isMouseEvent)(e)&&(e.detail>1||0!==e.button)||(this.visible?this.hide():this.show())})));this._register((0,n.addDisposableListener)(this._label,n.EventType.KEY_UP,(e=>{const t=new o.StandardKeyboardEvent(e);(t.equals(3)||t.equals(10))&&(n.EventHelper.stop(e,!0),this.visible?this.hide():this.show())})));const s=i(this._label);s&&this._register(s),this._register(r.Gesture.addTarget(this._label))}get element(){return this._element}show(){this.visible||(this.visible=!0,this._onDidChangeVisibility.fire(!0))}hide(){this.visible&&(this.visible=!1,this._onDidChangeVisibility.fire(!1))}dispose(){super.dispose(),this.hide(),this.boxContainer&&(this.boxContainer.remove(),this.boxContainer=void 0),this.contents&&(this.contents.remove(),this.contents=void 0),this._label&&(this._label.remove(),this._label=void 0)}}class c extends l{constructor(e,t){super(e,t),this._options=t,this._actions=[],this.actions=t.actions||[]}set menuOptions(e){this._menuOptions=e}get menuOptions(){return this._menuOptions}get actions(){return this._options.actionProvider?this._options.actionProvider.getActions():this._actions}set actions(e){this._actions=e}show(){super.show(),this.element.classList.add("active"),this._options.contextMenuProvider.showContextMenu({getAnchor:()=>this.element,getActions:()=>this.actions,getActionsContext:()=>this.menuOptions?this.menuOptions.context:null,getActionViewItem:(e,t)=>this.menuOptions&&this.menuOptions.actionViewItemProvider?this.menuOptions.actionViewItemProvider(e,t):void 0,getKeyBinding:e=>this.menuOptions&&this.menuOptions.getKeyBinding?this.menuOptions.getKeyBinding(e):void 0,getMenuClassName:()=>this._options.menuClassName||"",onHide:()=>this.onHide(),actionRunner:this.menuOptions?this.menuOptions.actionRunner:void 0,anchorAlignment:this.menuOptions?this.menuOptions.anchorAlignment:0,domForShadowRoot:this._options.menuAsChild?this.element:void 0,skipTelemetry:this._options.skipTelemetry})}hide(){super.hide()}onHide(){this.hide(),this.element.classList.remove("active")}}},36720:function(e,t,i){"use strict";i.r(t),i.d(t,{DropdownMenuActionViewItem:function(){return a}});var n=i(96747),o=i(61009),r=i(96319),s=i(63801);i(45549);class a extends o.BaseActionViewItem{constructor(e,t,i,n=Object.create(null)){super(null,e,n),this.actionItem=null,this._onDidChangeVisibility=this._register(new s.Emitter),this.onDidChangeVisibility=this._onDidChangeVisibility.event,this.menuActionsOrProvider=t,this.contextMenuProvider=i,this.options=n,this.options.actionRunner&&(this.actionRunner=this.options.actionRunner)}render(e){this.actionItem=e;const t=Array.isArray(this.menuActionsOrProvider),i={contextMenuProvider:this.contextMenuProvider,labelRenderer:e=>{this.element=(0,n.append)(e,(0,n.$)("a.action-label"));let t=[];return"string"==typeof this.options.classNames?t=this.options.classNames.split(/\s+/g).filter((e=>!!e)):this.options.classNames&&(t=this.options.classNames),t.find((e=>"icon"===e))||t.push("codicon"),this.element.classList.add(...t),this.element.setAttribute("role","button"),this.element.setAttribute("aria-haspopup","true"),this.element.setAttribute("aria-expanded","false"),this.element.title=this._action.label||"",this.element.ariaLabel=this._action.label||"",null},menuAsChild:this.options.menuAsChild,actions:t?this.menuActionsOrProvider:void 0,actionProvider:t?void 0:this.menuActionsOrProvider,skipTelemetry:this.options.skipTelemetry};if(this.dropdownMenu=this._register(new r.DropdownMenu(e,i)),this._register(this.dropdownMenu.onDidChangeVisibility((e=>{var t;null===(t=this.element)||void 0===t||t.setAttribute("aria-expanded",`${e}`),this._onDidChangeVisibility.fire(e)}))),this.dropdownMenu.menuOptions={actionViewItemProvider:this.options.actionViewItemProvider,actionRunner:this.actionRunner,getKeyBinding:this.options.keybindingProvider,context:this._context},this.options.anchorAlignmentProvider){const e=this;this.dropdownMenu.menuOptions={...this.dropdownMenu.menuOptions,get anchorAlignment(){return e.options.anchorAlignmentProvider()}}}this.updateTooltip(),this.updateEnabled()}getTooltip(){let e=null;return this.action.tooltip?e=this.action.tooltip:this.action.label&&(e=this.action.label),null!=e?e:void 0}setActionContext(e){super.setActionContext(e),this.dropdownMenu&&(this.dropdownMenu.menuOptions?this.dropdownMenu.menuOptions.context=e:this.dropdownMenu.menuOptions={context:e})}show(){var e;null===(e=this.dropdownMenu)||void 0===e||e.show()}updateEnabled(){var e,t;const i=!this.action.enabled;null===(e=this.actionItem)||void 0===e||e.classList.toggle("disabled",i),null===(t=this.element)||void 0===t||t.classList.toggle("disabled",i)}}},73493:function(e,t,i){"use strict";i.r(t),i.d(t,{FindInput:function(){return u}});var n=i(96747),o=i(30115),r=i(25802),s=i(47257),a=i(63801),l=(i(90381),i(83787)),c=i(68921);const d=l.localize("vs/base/browser/ui/findinput/findInput","defaultLabel","input");class u extends s.Widget{constructor(e,t,i){super(),this.fixFocusOnOptionClickEnabled=!0,this.imeSessionInProgress=!1,this.additionalTogglesDisposables=this._register(new c.MutableDisposable),this.additionalToggles=[],this._onDidOptionChange=this._register(new a.Emitter),this.onDidOptionChange=this._onDidOptionChange.event,this._onKeyDown=this._register(new a.Emitter),this.onKeyDown=this._onKeyDown.event,this._onMouseDown=this._register(new a.Emitter),this.onMouseDown=this._onMouseDown.event,this._onInput=this._register(new a.Emitter),this._onKeyUp=this._register(new a.Emitter),this._onCaseSensitiveKeyDown=this._register(new a.Emitter),this.onCaseSensitiveKeyDown=this._onCaseSensitiveKeyDown.event,this._onRegexKeyDown=this._register(new a.Emitter),this.onRegexKeyDown=this._onRegexKeyDown.event,this._lastHighlightFindOptions=0,this.placeholder=i.placeholder||"",this.validation=i.validation,this.label=i.label||d,this.showCommonFindToggles=!!i.showCommonFindToggles;const s=i.appendCaseSensitiveLabel||"",l=i.appendWholeWordsLabel||"",u=i.appendRegexLabel||"",h=i.history||[],g=!!i.flexibleHeight,p=!!i.flexibleWidth,m=i.flexibleMaxHeight;if(this.domNode=document.createElement("div"),this.domNode.classList.add("monaco-findInput"),this.inputBox=this._register(new r.HistoryInputBox(this.domNode,t,{placeholder:this.placeholder||"",ariaLabel:this.label||"",validationOptions:{validation:this.validation},history:h,showHistoryHint:i.showHistoryHint,flexibleHeight:g,flexibleWidth:p,flexibleMaxHeight:m,inputBoxStyles:i.inputBoxStyles})),this.showCommonFindToggles){this.regex=this._register(new o.RegexToggle({appendTitle:u,isChecked:!1,...i.toggleStyles})),this._register(this.regex.onChange((e=>{this._onDidOptionChange.fire(e),!e&&this.fixFocusOnOptionClickEnabled&&this.inputBox.focus(),this.validate()}))),this._register(this.regex.onKeyDown((e=>{this._onRegexKeyDown.fire(e)}))),this.wholeWords=this._register(new o.WholeWordsToggle({appendTitle:l,isChecked:!1,...i.toggleStyles})),this._register(this.wholeWords.onChange((e=>{this._onDidOptionChange.fire(e),!e&&this.fixFocusOnOptionClickEnabled&&this.inputBox.focus(),this.validate()}))),this.caseSensitive=this._register(new o.CaseSensitiveToggle({appendTitle:s,isChecked:!1,...i.toggleStyles})),this._register(this.caseSensitive.onChange((e=>{this._onDidOptionChange.fire(e),!e&&this.fixFocusOnOptionClickEnabled&&this.inputBox.focus(),this.validate()}))),this._register(this.caseSensitive.onKeyDown((e=>{this._onCaseSensitiveKeyDown.fire(e)})));const e=[this.caseSensitive.domNode,this.wholeWords.domNode,this.regex.domNode];this.onkeydown(this.domNode,(t=>{if(t.equals(15)||t.equals(17)||t.equals(9)){const i=e.indexOf(this.domNode.ownerDocument.activeElement);if(i>=0){let o=-1;t.equals(17)?o=(i+1)%e.length:t.equals(15)&&(o=0===i?e.length-1:i-1),t.equals(9)?(e[i].blur(),this.inputBox.focus()):o>=0&&e[o].focus(),n.EventHelper.stop(t,!0)}}}))}this.controls=document.createElement("div"),this.controls.className="controls",this.controls.style.display=this.showCommonFindToggles?"":"none",this.caseSensitive&&this.controls.append(this.caseSensitive.domNode),this.wholeWords&&this.controls.appendChild(this.wholeWords.domNode),this.regex&&this.controls.appendChild(this.regex.domNode),this.setAdditionalToggles(null==i?void 0:i.additionalToggles),this.controls&&this.domNode.appendChild(this.controls),null==e||e.appendChild(this.domNode),this._register(n.addDisposableListener(this.inputBox.inputElement,"compositionstart",(e=>{this.imeSessionInProgress=!0}))),this._register(n.addDisposableListener(this.inputBox.inputElement,"compositionend",(e=>{this.imeSessionInProgress=!1,this._onInput.fire()}))),this.onkeydown(this.inputBox.inputElement,(e=>this._onKeyDown.fire(e))),this.onkeyup(this.inputBox.inputElement,(e=>this._onKeyUp.fire(e))),this.oninput(this.inputBox.inputElement,(e=>this._onInput.fire())),this.onmousedown(this.inputBox.inputElement,(e=>this._onMouseDown.fire(e)))}get onDidChange(){return this.inputBox.onDidChange}layout(e){this.inputBox.layout(),this.updateInputBoxPadding(e.collapsedFindWidget)}enable(){var e,t,i;this.domNode.classList.remove("disabled"),this.inputBox.enable(),null===(e=this.regex)||void 0===e||e.enable(),null===(t=this.wholeWords)||void 0===t||t.enable(),null===(i=this.caseSensitive)||void 0===i||i.enable();for(const e of this.additionalToggles)e.enable()}disable(){var e,t,i;this.domNode.classList.add("disabled"),this.inputBox.disable(),null===(e=this.regex)||void 0===e||e.disable(),null===(t=this.wholeWords)||void 0===t||t.disable(),null===(i=this.caseSensitive)||void 0===i||i.disable();for(const e of this.additionalToggles)e.disable()}setFocusInputOnOptionClick(e){this.fixFocusOnOptionClickEnabled=e}setEnabled(e){e?this.enable():this.disable()}setAdditionalToggles(e){for(const e of this.additionalToggles)e.domNode.remove();this.additionalToggles=[],this.additionalTogglesDisposables.value=new c.DisposableStore;for(const t of null!=e?e:[])this.additionalTogglesDisposables.value.add(t),this.controls.appendChild(t.domNode),this.additionalTogglesDisposables.value.add(t.onChange((e=>{this._onDidOptionChange.fire(e),!e&&this.fixFocusOnOptionClickEnabled&&this.inputBox.focus()}))),this.additionalToggles.push(t);this.additionalToggles.length>0&&(this.controls.style.display=""),this.updateInputBoxPadding()}updateInputBoxPadding(e=!1){var t,i,n,o,r,s;this.inputBox.paddingRight=e?0:(null!==(i=null===(t=this.caseSensitive)||void 0===t?void 0:t.width())&&void 0!==i?i:0)+(null!==(o=null===(n=this.wholeWords)||void 0===n?void 0:n.width())&&void 0!==o?o:0)+(null!==(s=null===(r=this.regex)||void 0===r?void 0:r.width())&&void 0!==s?s:0)+this.additionalToggles.reduce(((e,t)=>e+t.width()),0)}getValue(){return this.inputBox.value}setValue(e){this.inputBox.value!==e&&(this.inputBox.value=e)}select(){this.inputBox.select()}focus(){this.inputBox.focus()}getCaseSensitive(){var e,t;return null!==(t=null===(e=this.caseSensitive)||void 0===e?void 0:e.checked)&&void 0!==t&&t}setCaseSensitive(e){this.caseSensitive&&(this.caseSensitive.checked=e)}getWholeWords(){var e,t;return null!==(t=null===(e=this.wholeWords)||void 0===e?void 0:e.checked)&&void 0!==t&&t}setWholeWords(e){this.wholeWords&&(this.wholeWords.checked=e)}getRegex(){var e,t;return null!==(t=null===(e=this.regex)||void 0===e?void 0:e.checked)&&void 0!==t&&t}setRegex(e){this.regex&&(this.regex.checked=e,this.validate())}focusOnCaseSensitive(){var e;null===(e=this.caseSensitive)||void 0===e||e.focus()}highlightFindOptions(){this.domNode.classList.remove("highlight-"+this._lastHighlightFindOptions),this._lastHighlightFindOptions=1-this._lastHighlightFindOptions,this.domNode.classList.add("highlight-"+this._lastHighlightFindOptions)}validate(){this.inputBox.validate()}showMessage(e){this.inputBox.showMessage(e)}clearMessage(){this.inputBox.hideMessage()}}},30115:function(e,t,i){"use strict";i.r(t),i.d(t,{CaseSensitiveToggle:function(){return c},RegexToggle:function(){return u},WholeWordsToggle:function(){return d}});var n=i(50797),o=i(56087),r=i(83787);const s=r.localize("vs/base/browser/ui/findinput/findInputToggles","caseDescription","Match Case"),a=r.localize("vs/base/browser/ui/findinput/findInputToggles","wordsDescription","Match Whole Word"),l=r.localize("vs/base/browser/ui/findinput/findInputToggles","regexDescription","Use Regular Expression");class c extends n.Toggle{constructor(e){super({icon:o.Codicon.caseSensitive,title:s+e.appendTitle,isChecked:e.isChecked,inputActiveOptionBorder:e.inputActiveOptionBorder,inputActiveOptionForeground:e.inputActiveOptionForeground,inputActiveOptionBackground:e.inputActiveOptionBackground})}}class d extends n.Toggle{constructor(e){super({icon:o.Codicon.wholeWord,title:a+e.appendTitle,isChecked:e.isChecked,inputActiveOptionBorder:e.inputActiveOptionBorder,inputActiveOptionForeground:e.inputActiveOptionForeground,inputActiveOptionBackground:e.inputActiveOptionBackground})}}class u extends n.Toggle{constructor(e){super({icon:o.Codicon.regex,title:l+e.appendTitle,isChecked:e.isChecked,inputActiveOptionBorder:e.inputActiveOptionBorder,inputActiveOptionForeground:e.inputActiveOptionForeground,inputActiveOptionBackground:e.inputActiveOptionBackground})}}},6360:function(e,t,i){"use strict";i.r(t),i.d(t,{HighlightedLabel:function(){return s}});var n=i(96747),o=i(21348),r=i(91057);class s{constructor(e,t){var i;this.text="",this.title="",this.highlights=[],this.didEverRender=!1,this.supportIcons=null!==(i=null==t?void 0:t.supportIcons)&&void 0!==i&&i,this.domNode=n.append(e,n.$("span.monaco-highlighted-label"))}get element(){return this.domNode}set(e,t=[],i="",n){e||(e=""),n&&(e=s.escapeNewLines(e,t)),this.didEverRender&&this.text===e&&this.title===i&&r.equals(this.highlights,t)||(this.text=e,this.title=i,this.highlights=t,this.render())}render(){const e=[];let t=0;for(const i of this.highlights){if(i.end===i.start)continue;if(t<i.start){const n=this.text.substring(t,i.start);this.supportIcons?e.push(...(0,o.renderLabelWithIcons)(n)):e.push(n),t=i.start}const r=this.text.substring(t,i.end),s=n.$("span.highlight",void 0,...this.supportIcons?(0,o.renderLabelWithIcons)(r):[r]);i.extraClasses&&s.classList.add(...i.extraClasses),e.push(s),t=i.end}if(t<this.text.length){const i=this.text.substring(t);this.supportIcons?e.push(...(0,o.renderLabelWithIcons)(i)):e.push(i)}n.reset(this.domNode,...e),this.title?this.domNode.title=this.title:this.domNode.removeAttribute("title"),this.didEverRender=!0}static escapeNewLines(e,t){let i=0,n=0;return e.replace(/\r\n|\r|\n/g,((e,o)=>{n="\r\n"===e?-1:0,o+=i;for(const e of t)e.end<=o||(e.start>=o&&(e.start+=n),e.end>=o&&(e.end+=n));return i+=n,"⏎"}))}}},74838:function(e,t,i){"use strict";i.r(t),i.d(t,{IconLabel:function(){return S}});var n=i(93379),o=i.n(n),r=i(7795),s=i.n(r),a=i(90569),l=i.n(a),c=i(3565),d=i.n(c),u=i(19216),h=i.n(u),g=i(44589),p=i.n(g),m=i(3293),f={};f.styleTagTransform=p(),f.setAttributes=d(),f.insert=l().bind(null,"head"),f.domAPI=s(),f.insertStyleElement=h();o()(m.Z,f),m.Z&&m.Z.locals&&m.Z.locals;var b=i(96747),v=i(6360),_=i(2720),A=i(68921),C=i(91057),w=i(83682);class y{constructor(e){this._element=e}get element(){return this._element}set textContent(e){this.disposed||e===this._textContent||(this._textContent=e,this._element.textContent=e)}set className(e){this.disposed||e===this._className||(this._className=e,this._element.className=e)}set empty(e){this.disposed||e===this._empty||(this._empty=e,this._element.style.marginLeft=e?"0":"")}dispose(){this.disposed=!0}}class S extends A.Disposable{constructor(e,t){super(),this.customHovers=new Map,this.creationOptions=t,this.domNode=this._register(new y(b.append(e,b.$(".monaco-icon-label")))),this.labelContainer=b.append(this.domNode.element,b.$(".monaco-icon-label-container")),this.nameContainer=b.append(this.labelContainer,b.$("span.monaco-icon-name-container")),(null==t?void 0:t.supportHighlights)||(null==t?void 0:t.supportIcons)?this.nameNode=new E(this.nameContainer,!!t.supportIcons):this.nameNode=new x(this.nameContainer),this.hoverDelegate=null==t?void 0:t.hoverDelegate}get element(){return this.domNode.element}setLabel(e,t,i){var n;const o=["monaco-icon-label"],r=["monaco-icon-label-container"];let s="";if(i&&(i.extraClasses&&o.push(...i.extraClasses),i.italic&&o.push("italic"),i.strikethrough&&o.push("strikethrough"),i.disabledCommand&&r.push("disabled"),i.title&&("string"==typeof i.title?s+=i.title:s+=e)),this.domNode.className=o.join(" "),this.domNode.element.setAttribute("aria-label",s),this.labelContainer.className=r.join(" "),this.setupHover((null==i?void 0:i.descriptionTitle)?this.labelContainer:this.element,null==i?void 0:i.title),this.nameNode.setLabel(e,i),t||this.descriptionNode){const e=this.getOrCreateDescriptionNode();e instanceof v.HighlightedLabel?(e.set(t||"",i?i.descriptionMatches:void 0,void 0,null==i?void 0:i.labelEscapeNewLines),this.setupHover(e.element,null==i?void 0:i.descriptionTitle)):(e.textContent=t&&(null==i?void 0:i.labelEscapeNewLines)?v.HighlightedLabel.escapeNewLines(t,[]):t||"",this.setupHover(e.element,(null==i?void 0:i.descriptionTitle)||""),e.empty=!t)}if((null==i?void 0:i.suffix)||this.suffixNode){this.getOrCreateSuffixNode().textContent=null!==(n=null==i?void 0:i.suffix)&&void 0!==n?n:""}}setupHover(e,t){const i=this.customHovers.get(e);if(i&&(i.dispose(),this.customHovers.delete(e)),t)if(this.hoverDelegate){const i=(0,_.setupCustomHover)(this.hoverDelegate,e,t);i&&this.customHovers.set(e,i)}else(0,_.setupNativeHover)(e,t);else e.removeAttribute("title")}dispose(){super.dispose();for(const e of this.customHovers.values())e.dispose();this.customHovers.clear()}getOrCreateSuffixNode(){if(!this.suffixNode){const e=this._register(new y(b.after(this.nameContainer,b.$("span.monaco-icon-suffix-container"))));this.suffixNode=this._register(new y(b.append(e.element,b.$("span.label-suffix"))))}return this.suffixNode}getOrCreateDescriptionNode(){var e;if(!this.descriptionNode){const t=this._register(new y(b.append(this.labelContainer,b.$("span.monaco-icon-description-container"))));(null===(e=this.creationOptions)||void 0===e?void 0:e.supportDescriptionHighlights)?this.descriptionNode=new v.HighlightedLabel(b.append(t.element,b.$("span.label-description")),{supportIcons:!!this.creationOptions.supportIcons}):this.descriptionNode=this._register(new y(b.append(t.element,b.$("span.label-description"))))}return this.descriptionNode}}class x{constructor(e){this.container=e,this.label=void 0,this.singleLabel=void 0}setLabel(e,t){if(this.label!==e||!(0,C.equals)(this.options,t))if(this.label=e,this.options=t,"string"==typeof e)this.singleLabel||(this.container.innerText="",this.container.classList.remove("multiple"),this.singleLabel=b.append(this.container,b.$("a.label-name",{id:null==t?void 0:t.domId}))),this.singleLabel.textContent=e;else{this.container.innerText="",this.container.classList.add("multiple"),this.singleLabel=void 0;for(let i=0;i<e.length;i++){const n=e[i],o=(null==t?void 0:t.domId)&&`${null==t?void 0:t.domId}_${i}`;b.append(this.container,b.$("a.label-name",{id:o,"data-icon-label-count":e.length,"data-icon-label-index":i,role:"treeitem"},n)),i<e.length-1&&b.append(this.container,b.$("span.label-separator",void 0,(null==t?void 0:t.separator)||"/"))}}}}class E{constructor(e,t){this.container=e,this.supportIcons=t,this.label=void 0,this.singleLabel=void 0}setLabel(e,t){if(this.label!==e||!(0,C.equals)(this.options,t))if(this.label=e,this.options=t,"string"==typeof e)this.singleLabel||(this.container.innerText="",this.container.classList.remove("multiple"),this.singleLabel=new v.HighlightedLabel(b.append(this.container,b.$("a.label-name",{id:null==t?void 0:t.domId})),{supportIcons:this.supportIcons})),this.singleLabel.set(e,null==t?void 0:t.matches,void 0,null==t?void 0:t.labelEscapeNewLines);else{this.container.innerText="",this.container.classList.add("multiple"),this.singleLabel=void 0;const i=(null==t?void 0:t.separator)||"/",n=function(e,t,i){if(!i)return;let n=0;return e.map((e=>{const o={start:n,end:n+e.length},r=i.map((e=>w.Range.intersect(o,e))).filter((e=>!w.Range.isEmpty(e))).map((({start:e,end:t})=>({start:e-n,end:t-n})));return n=o.end+t.length,r}))}(e,i,null==t?void 0:t.matches);for(let o=0;o<e.length;o++){const r=e[o],s=n?n[o]:void 0,a=(null==t?void 0:t.domId)&&`${null==t?void 0:t.domId}_${o}`,l=b.$("a.label-name",{id:a,"data-icon-label-count":e.length,"data-icon-label-index":o,role:"treeitem"});new v.HighlightedLabel(b.append(this.container,l),{supportIcons:this.supportIcons}).set(r,s,void 0,null==t?void 0:t.labelEscapeNewLines),o<e.length-1&&b.append(l,b.$("span.label-separator",void 0,i))}}}}},2720:function(e,t,i){"use strict";i.r(t),i.d(t,{setupCustomHover:function(){return g},setupNativeHover:function(){return u}});var n=i(96747),o=i(66129),r=i(11256),s=i(25674),a=i(69373),l=i(68921),c=i(18912),d=i(83787);function u(e,t){(0,c.isString)(t)?e.title=(0,a.stripIcons)(t):(null==t?void 0:t.markdownNotSupportedFallback)?e.title=t.markdownNotSupportedFallback:e.removeAttribute("title")}class h{constructor(e,t,i){this.hoverDelegate=e,this.target=t,this.fadeInAnimation=i}async update(e,t,i){var n;if(this._cancellationTokenSource&&(this._cancellationTokenSource.dispose(!0),this._cancellationTokenSource=void 0),this.isDisposed)return;let o;if(void 0===e||(0,c.isString)(e)||e instanceof HTMLElement)o=e;else if((0,c.isFunction)(e.markdown)){this._hoverWidget||this.show((0,d.localize)("vs/base/browser/ui/iconLabel/iconLabelHover","iconLabel.loading","Loading..."),t),this._cancellationTokenSource=new r.CancellationTokenSource;const i=this._cancellationTokenSource.token;if(o=await e.markdown(i),void 0===o&&(o=e.markdownNotSupportedFallback),this.isDisposed||i.isCancellationRequested)return}else o=null!==(n=e.markdown)&&void 0!==n?n:e.markdownNotSupportedFallback;this.show(o,t,i)}show(e,t,i){const n=this._hoverWidget;if(this.hasContent(e)){const o={content:e,target:this.target,appearance:{showPointer:"element"===this.hoverDelegate.placement,skipFadeInAnimation:!this.fadeInAnimation||!!n},position:{hoverPosition:2},...i};this._hoverWidget=this.hoverDelegate.showHover(o,t)}null==n||n.dispose()}hasContent(e){return!!e&&(!(0,s.isMarkdownString)(e)||!!e.value)}get isDisposed(){var e;return null===(e=this._hoverWidget)||void 0===e?void 0:e.isDisposed}dispose(){var e,t;null===(e=this._hoverWidget)||void 0===e||e.dispose(),null===(t=this._cancellationTokenSource)||void 0===t||t.dispose(!0),this._cancellationTokenSource=void 0}}function g(e,t,i,r){let s,a;const c=(t,i)=>{var n;const o=void 0!==a;t&&(null==a||a.dispose(),a=void 0),i&&(null==s||s.dispose(),s=void 0),o&&(null===(n=e.onDidHideHover)||void 0===n||n.call(e))},d=(n,s,l)=>new o.TimeoutTimer((async()=>{a&&!a.isDisposed||(a=new h(e,l||t,n>0),await a.update(i,s,r))}),n),u=n.addDisposableListener(t,n.EventType.MOUSE_OVER,(()=>{if(s)return;const i=new l.DisposableStore;i.add(n.addDisposableListener(t,n.EventType.MOUSE_LEAVE,(e=>c(!1,e.fromElement===t)),!0));i.add(n.addDisposableListener(t,n.EventType.MOUSE_DOWN,(()=>c(!0,!0)),!0));const o={targetElements:[t],dispose:()=>{}};if(void 0===e.placement||"mouse"===e.placement){const e=e=>{o.x=e.x+10,e.target instanceof HTMLElement&&e.target.classList.contains("action-label")&&c(!0,!0)};i.add(n.addDisposableListener(t,n.EventType.MOUSE_MOVE,e,!0))}i.add(d(e.delay,!1,o)),s=i}),!0),g=n.addDisposableListener(t,n.EventType.FOCUS,(()=>{if(s)return;const i={targetElements:[t],dispose:()=>{}},o=new l.DisposableStore;o.add(n.addDisposableListener(t,n.EventType.BLUR,(()=>c(!0,!0)),!0)),o.add(d(e.delay,!1,i)),s=o}),!0);return{show:e=>{c(!1,!0),d(0,e)},hide:()=>{c(!0,!0)},update:async(e,t)=>{i=e,await(null==a?void 0:a.update(i,void 0,t))},dispose:()=>{u.dispose(),g.dispose(),c(!0,!0)}}}},21348:function(e,t,i){"use strict";i.r(t),i.d(t,{renderIcon:function(){return a},renderLabelWithIcons:function(){return s}});var n=i(96747),o=i(27269);const r=new RegExp(`(\\\\)?\\$\\((${o.ThemeIcon.iconNameExpression}(?:${o.ThemeIcon.iconModifierExpression})?)\\)`,"g");function s(e){const t=new Array;let i,n=0,o=0;for(;null!==(i=r.exec(e));){o=i.index||0,n<o&&t.push(e.substring(n,o)),n=(i.index||0)+i[0].length;const[,r,s]=i;t.push(r?`$(${s})`:a({id:s}))}return n<e.length&&t.push(e.substring(n)),t}function a(e){const t=n.$("span");return t.classList.add(...o.ThemeIcon.asClassNameArray(e)),t}},25802:function(e,t,i){"use strict";i.r(t),i.d(t,{HistoryInputBox:function(){return T},InputBox:function(){return L},unthemedInboxStyles:function(){return I}});var n=i(96747),o=i(50465),r=i(94264),s=i(31532),a=i(61950),l=i(34309),c=i(47257),d=i(63801),u=i(68538),h=i(91057),g=i(93379),p=i.n(g),m=i(7795),f=i.n(m),b=i(90569),v=i.n(b),_=i(3565),A=i.n(_),C=i(19216),w=i.n(C),y=i(44589),S=i.n(y),x=i(24695),E={};E.styleTagTransform=S(),E.setAttributes=A(),E.insert=v().bind(null,"head"),E.domAPI=f(),E.insertStyleElement=w();p()(x.Z,E),x.Z&&x.Z.locals&&x.Z.locals;var k=i(83787);const D=n.$,I={inputBackground:"#3C3C3C",inputForeground:"#CCCCCC",inputValidationInfoBorder:"#55AAFF",inputValidationInfoBackground:"#063B49",inputValidationWarningBorder:"#B89500",inputValidationWarningBackground:"#352A05",inputValidationErrorBorder:"#BE1100",inputValidationErrorBackground:"#5A1D1D",inputBorder:void 0,inputValidationErrorForeground:void 0,inputValidationInfoForeground:void 0,inputValidationWarningForeground:void 0};class L extends c.Widget{constructor(e,t,i){var r;super(),this.state="idle",this.maxHeight=Number.POSITIVE_INFINITY,this._onDidChange=this._register(new d.Emitter),this.onDidChange=this._onDidChange.event,this._onDidHeightChange=this._register(new d.Emitter),this.onDidHeightChange=this._onDidHeightChange.event,this.contextViewProvider=t,this.options=i,this.message=null,this.placeholder=this.options.placeholder||"",this.tooltip=null!==(r=this.options.tooltip)&&void 0!==r?r:this.placeholder||"",this.ariaLabel=this.options.ariaLabel||"",this.options.validationOptions&&(this.validation=this.options.validationOptions.validation),this.element=n.append(e,D(".monaco-inputbox.idle"));const a=this.options.flexibleHeight?"textarea":"input",c=n.append(this.element,D(".ibwrapper"));if(this.input=n.append(c,D(a+".input.empty")),this.input.setAttribute("autocorrect","off"),this.input.setAttribute("autocapitalize","off"),this.input.setAttribute("spellcheck","false"),this.onfocus(this.input,(()=>this.element.classList.add("synthetic-focus"))),this.onblur(this.input,(()=>this.element.classList.remove("synthetic-focus"))),this.options.flexibleHeight){this.maxHeight="number"==typeof this.options.flexibleMaxHeight?this.options.flexibleMaxHeight:Number.POSITIVE_INFINITY,this.mirror=n.append(c,D("div.mirror")),this.mirror.innerText=" ",this.scrollableElement=new l.ScrollableElement(this.element,{vertical:1}),this.options.flexibleWidth&&(this.input.setAttribute("wrap","off"),this.mirror.style.whiteSpace="pre",this.mirror.style.wordWrap="initial"),n.append(e,this.scrollableElement.getDomNode()),this._register(this.scrollableElement),this._register(this.scrollableElement.onScroll((e=>this.input.scrollTop=e.scrollTop)));const t=this._register(new o.DomEmitter(e.ownerDocument,"selectionchange")),i=d.Event.filter(t.event,(()=>{const t=e.ownerDocument.getSelection();return(null==t?void 0:t.anchorNode)===c}));this._register(i(this.updateScrollDimensions,this)),this._register(this.onDidHeightChange(this.updateScrollDimensions,this))}else this.input.type=this.options.type||"text",this.input.setAttribute("wrap","off");this.ariaLabel&&this.input.setAttribute("aria-label",this.ariaLabel),this.placeholder&&!this.options.showPlaceholderOnFocus&&this.setPlaceHolder(this.placeholder),this.tooltip&&this.setTooltip(this.tooltip),this.oninput(this.input,(()=>this.onValueChange())),this.onblur(this.input,(()=>this.onBlur())),this.onfocus(this.input,(()=>this.onFocus())),this._register(this.ignoreGesture(this.input)),setTimeout((()=>this.updateMirror()),0),this.options.actions&&(this.actionbar=this._register(new s.ActionBar(this.element)),this.actionbar.push(this.options.actions,{icon:!0,label:!1})),this.applyStyles()}onBlur(){this._hideMessage(),this.options.showPlaceholderOnFocus&&this.input.setAttribute("placeholder","")}onFocus(){this._showMessage(),this.options.showPlaceholderOnFocus&&this.input.setAttribute("placeholder",this.placeholder||"")}setPlaceHolder(e){this.placeholder=e,this.input.setAttribute("placeholder",e)}setTooltip(e){this.tooltip=e,this.input.title=e}get inputElement(){return this.input}get value(){return this.input.value}set value(e){this.input.value!==e&&(this.input.value=e,this.onValueChange())}get height(){return"number"==typeof this.cachedHeight?this.cachedHeight:n.getTotalHeight(this.element)}focus(){this.input.focus()}blur(){this.input.blur()}hasFocus(){return n.isActiveElement(this.input)}select(e=null){this.input.select(),e&&(this.input.setSelectionRange(e.start,e.end),e.end===this.input.value.length&&(this.input.scrollLeft=this.input.scrollWidth))}isSelectionAtEnd(){return this.input.selectionEnd===this.input.value.length&&this.input.selectionStart===this.input.selectionEnd}enable(){this.input.removeAttribute("disabled")}disable(){this.blur(),this.input.disabled=!0,this._hideMessage()}set paddingRight(e){this.input.style.width=`calc(100% - ${e}px)`,this.mirror&&(this.mirror.style.paddingRight=e+"px")}updateScrollDimensions(){if("number"!=typeof this.cachedContentHeight||"number"!=typeof this.cachedHeight||!this.scrollableElement)return;const e=this.cachedContentHeight,t=this.cachedHeight,i=this.input.scrollTop;this.scrollableElement.setScrollDimensions({scrollHeight:e,height:t}),this.scrollableElement.setScrollPosition({scrollTop:i})}showMessage(e,t){if("open"===this.state&&(0,h.equals)(this.message,e))return;this.message=e,this.element.classList.remove("idle"),this.element.classList.remove("info"),this.element.classList.remove("warning"),this.element.classList.remove("error"),this.element.classList.add(this.classForType(e.type));const i=this.stylesForType(this.message.type);this.element.style.border=`1px solid ${n.asCssValueWithDefault(i.border,"transparent")}`,this.message.content&&(this.hasFocus()||t)&&this._showMessage()}hideMessage(){this.message=null,this.element.classList.remove("info"),this.element.classList.remove("warning"),this.element.classList.remove("error"),this.element.classList.add("idle"),this._hideMessage(),this.applyStyles()}validate(){let e=null;return this.validation&&(e=this.validation(this.value),e?(this.inputElement.setAttribute("aria-invalid","true"),this.showMessage(e)):this.inputElement.hasAttribute("aria-invalid")&&(this.inputElement.removeAttribute("aria-invalid"),this.hideMessage())),null==e?void 0:e.type}stylesForType(e){const t=this.options.inputBoxStyles;switch(e){case 1:return{border:t.inputValidationInfoBorder,background:t.inputValidationInfoBackground,foreground:t.inputValidationInfoForeground};case 2:return{border:t.inputValidationWarningBorder,background:t.inputValidationWarningBackground,foreground:t.inputValidationWarningForeground};default:return{border:t.inputValidationErrorBorder,background:t.inputValidationErrorBackground,foreground:t.inputValidationErrorForeground}}}classForType(e){switch(e){case 1:return"info";case 2:return"warning";default:return"error"}}_showMessage(){if(!this.contextViewProvider||!this.message)return;let e;const t=()=>e.style.width=n.getTotalWidth(this.element)+"px";let i;this.contextViewProvider.showContextView({getAnchor:()=>this.element,anchorAlignment:1,render:i=>{var o,s;if(!this.message)return null;e=n.append(i,D(".monaco-inputbox-container")),t();const a={inline:!0,className:"monaco-inputbox-message"},l=this.message.formatContent?(0,r.renderFormattedText)(this.message.content,a):(0,r.renderText)(this.message.content,a);l.classList.add(this.classForType(this.message.type));const c=this.stylesForType(this.message.type);return l.style.backgroundColor=null!==(o=c.background)&&void 0!==o?o:"",l.style.color=null!==(s=c.foreground)&&void 0!==s?s:"",l.style.border=c.border?`1px solid ${c.border}`:"",n.append(e,l),null},onHide:()=>{this.state="closed"},layout:t}),i=3===this.message.type?k.localize("vs/base/browser/ui/inputbox/inputBox","alertErrorMessage","Error: {0}",this.message.content):2===this.message.type?k.localize("vs/base/browser/ui/inputbox/inputBox","alertWarningMessage","Warning: {0}",this.message.content):k.localize("vs/base/browser/ui/inputbox/inputBox","alertInfoMessage","Info: {0}",this.message.content),a.alert(i),this.state="open"}_hideMessage(){this.contextViewProvider&&("open"===this.state&&this.contextViewProvider.hideContextView(),this.state="idle")}onValueChange(){this._onDidChange.fire(this.value),this.validate(),this.updateMirror(),this.input.classList.toggle("empty",!this.value),"open"===this.state&&this.contextViewProvider&&this.contextViewProvider.layout()}updateMirror(){if(!this.mirror)return;const e=this.value,t=10===e.charCodeAt(e.length-1)?" ":"";(e+t).replace(/\u000c/g,"")?this.mirror.textContent=e+t:this.mirror.innerText=" ",this.layout()}applyStyles(){var e,t,i;const o=this.options.inputBoxStyles,r=null!==(e=o.inputBackground)&&void 0!==e?e:"",s=null!==(t=o.inputForeground)&&void 0!==t?t:"",a=null!==(i=o.inputBorder)&&void 0!==i?i:"";this.element.style.backgroundColor=r,this.element.style.color=s,this.input.style.backgroundColor="inherit",this.input.style.color=s,this.element.style.border=`1px solid ${n.asCssValueWithDefault(a,"transparent")}`}layout(){if(!this.mirror)return;const e=this.cachedContentHeight;this.cachedContentHeight=n.getTotalHeight(this.mirror),e!==this.cachedContentHeight&&(this.cachedHeight=Math.min(this.cachedContentHeight,this.maxHeight),this.input.style.height=this.cachedHeight+"px",this._onDidHeightChange.fire(this.cachedContentHeight))}insertAtCursor(e){const t=this.inputElement,i=t.selectionStart,n=t.selectionEnd,o=t.value;null!==i&&null!==n&&(this.value=o.substr(0,i)+e+o.substr(n),t.setSelectionRange(i+1,i+1),this.layout())}dispose(){var e;this._hideMessage(),this.message=null,null===(e=this.actionbar)||void 0===e||e.dispose(),super.dispose()}}class T extends L{constructor(e,t,i){const o=k.localize("vs/base/browser/ui/inputbox/inputBox",{key:"history.inputbox.hint.suffix.noparens",comment:['Text is the suffix of an input field placeholder coming after the action the input field performs, this will be used when the input field ends in a closing parenthesis ")", for example "Filter (e.g. text, !exclude)". The character inserted into the final string is ⇅ to represent the up and down arrow keys.']}," or {0} for history","⇅"),r=k.localize("vs/base/browser/ui/inputbox/inputBox",{key:"history.inputbox.hint.suffix.inparens",comment:['Text is the suffix of an input field placeholder coming after the action the input field performs, this will be used when the input field does NOT end in a closing parenthesis (eg. "Find"). The character inserted into the final string is ⇅ to represent the up and down arrow keys.']}," ({0} for history)","⇅");super(e,t,i),this._onDidFocus=this._register(new d.Emitter),this.onDidFocus=this._onDidFocus.event,this._onDidBlur=this._register(new d.Emitter),this.onDidBlur=this._onDidBlur.event,this.history=new u.HistoryNavigator(i.history,100);const s=()=>{if(i.showHistoryHint&&i.showHistoryHint()&&!this.placeholder.endsWith(o)&&!this.placeholder.endsWith(r)&&this.history.getHistory().length){const e=this.placeholder.endsWith(")")?o:r,t=this.placeholder+e;i.showPlaceholderOnFocus&&!n.isActiveElement(this.input)?this.placeholder=t:this.setPlaceHolder(t)}};this.observer=new MutationObserver(((e,t)=>{e.forEach((e=>{e.target.textContent||s()}))})),this.observer.observe(this.input,{attributeFilter:["class"]}),this.onfocus(this.input,(()=>s())),this.onblur(this.input,(()=>{const e=e=>{if(this.placeholder.endsWith(e)){const t=this.placeholder.slice(0,this.placeholder.length-e.length);return i.showPlaceholderOnFocus?this.placeholder=t:this.setPlaceHolder(t),!0}return!1};e(r)||e(o)}))}dispose(){super.dispose(),this.observer&&(this.observer.disconnect(),this.observer=void 0)}addToHistory(e){this.value&&(e||this.value!==this.getCurrentValue())&&this.history.add(this.value)}isAtLastInHistory(){return this.history.isLast()}isNowhereInHistory(){return this.history.isNowhere()}showNextValue(){this.history.has(this.value)||this.addToHistory();let e=this.getNextValue();e&&(e=e===this.value?this.getNextValue():e),this.value=null!=e?e:"",a.status(this.value?this.value:k.localize("vs/base/browser/ui/inputbox/inputBox","clearedInput","Cleared Input"))}showPreviousValue(){this.history.has(this.value)||this.addToHistory();let e=this.getPreviousValue();e&&(e=e===this.value?this.getPreviousValue():e),e&&(this.value=e,a.status(this.value))}setPlaceHolder(e){super.setPlaceHolder(e),this.setTooltip(e)}onBlur(){super.onBlur(),this._onDidBlur.fire()}onFocus(){super.onFocus(),this._onDidFocus.fire()}getCurrentValue(){let e=this.history.current();return e||(e=this.history.last(),this.history.next()),e}getPreviousValue(){return this.history.previous()||this.history.first()}getNextValue(){return this.history.next()}}},91120:function(e,t,i){"use strict";i.r(t),i.d(t,{KeybindingLabel:function(){return y},unthemedKeybindingLabelOptions:function(){return w}});var n=i(96747),o=i(20693),r=i(91057),s=i(93379),a=i.n(s),l=i(7795),c=i.n(l),d=i(90569),u=i.n(d),h=i(3565),g=i.n(h),p=i(19216),m=i.n(p),f=i(44589),b=i.n(f),v=i(7896),_={};_.styleTagTransform=b(),_.setAttributes=g(),_.insert=u().bind(null,"head"),_.domAPI=c(),_.insertStyleElement=m();a()(v.Z,_),v.Z&&v.Z.locals&&v.Z.locals;var A=i(83787);const C=n.$,w={keybindingLabelBackground:void 0,keybindingLabelForeground:void 0,keybindingLabelBorder:void 0,keybindingLabelBottomBorder:void 0,keybindingLabelShadow:void 0};class y{constructor(e,t,i){this.os=t,this.keyElements=new Set,this.options=i||Object.create(null);const o=this.options.keybindingLabelForeground;this.domNode=n.append(e,C(".monaco-keybinding")),o&&(this.domNode.style.color=o),this.didEverRender=!1,e.appendChild(this.domNode)}get element(){return this.domNode}set(e,t){this.didEverRender&&this.keybinding===e&&y.areSame(this.matches,t)||(this.keybinding=e,this.matches=t,this.render())}render(){var e;if(this.clear(),this.keybinding){const t=this.keybinding.getChords();t[0]&&this.renderChord(this.domNode,t[0],this.matches?this.matches.firstPart:null);for(let e=1;e<t.length;e++)n.append(this.domNode,C("span.monaco-keybinding-key-chord-separator",void 0," ")),this.renderChord(this.domNode,t[e],this.matches?this.matches.chordPart:null);const i=null!==(e=this.options.disableTitle)&&void 0!==e&&e?void 0:this.keybinding.getAriaLabel()||void 0;void 0!==i?this.domNode.title=i:this.domNode.removeAttribute("title")}else this.options&&this.options.renderUnboundKeybindings&&this.renderUnbound(this.domNode);this.didEverRender=!0}clear(){n.clearNode(this.domNode),this.keyElements.clear()}renderChord(e,t,i){const n=o.UILabelProvider.modifierLabels[this.os];t.ctrlKey&&this.renderKey(e,n.ctrlKey,Boolean(null==i?void 0:i.ctrlKey),n.separator),t.shiftKey&&this.renderKey(e,n.shiftKey,Boolean(null==i?void 0:i.shiftKey),n.separator),t.altKey&&this.renderKey(e,n.altKey,Boolean(null==i?void 0:i.altKey),n.separator),t.metaKey&&this.renderKey(e,n.metaKey,Boolean(null==i?void 0:i.metaKey),n.separator);const r=t.keyLabel;r&&this.renderKey(e,r,Boolean(null==i?void 0:i.keyCode),"")}renderKey(e,t,i,o){n.append(e,this.createKeyElement(t,i?".highlight":"")),o&&n.append(e,C("span.monaco-keybinding-key-separator",void 0,o))}renderUnbound(e){n.append(e,this.createKeyElement((0,A.localize)("vs/base/browser/ui/keybindingLabel/keybindingLabel","unbound","Unbound")))}createKeyElement(e,t=""){const i=C("span.monaco-keybinding-key"+t,void 0,e);return this.keyElements.add(i),this.options.keybindingLabelBackground&&(i.style.backgroundColor=this.options.keybindingLabelBackground),this.options.keybindingLabelBorder&&(i.style.borderColor=this.options.keybindingLabelBorder),this.options.keybindingLabelBottomBorder&&(i.style.borderBottomColor=this.options.keybindingLabelBottomBorder),this.options.keybindingLabelShadow&&(i.style.boxShadow=`inset 0 -1px 0 ${this.options.keybindingLabelShadow}`),i}static areSame(e,t){return e===t||!e&&!t||!!e&&!!t&&(0,r.equals)(e.firstPart,t.firstPart)&&(0,r.equals)(e.chordPart,t.chordPart)}}},40083:function(e,t,i){"use strict";i.r(t),i.d(t,{ListError:function(){return n}});class n extends Error{constructor(e,t){super(`ListError [${e}] ${t}`)}}},17659:function(e,t,i){"use strict";i.r(t),i.d(t,{PagedList:function(){return d}});var n=i(64998),o=i(11256),r=i(63801),s=i(68921),a=(i(82833),i(72406));class l{get templateId(){return this.renderer.templateId}constructor(e,t){this.renderer=e,this.modelProvider=t}renderTemplate(e){return{data:this.renderer.renderTemplate(e),disposable:s.Disposable.None}}renderElement(e,t,i,n){var r;if(null===(r=i.disposable)||void 0===r||r.dispose(),!i.data)return;const s=this.modelProvider();if(s.isResolved(e))return this.renderer.renderElement(s.get(e),e,i.data,n);const a=new o.CancellationTokenSource,l=s.resolve(e,a.token);i.disposable={dispose:()=>a.cancel()},this.renderer.renderPlaceholder(e,i.data),l.then((t=>this.renderer.renderElement(t,e,i.data,n)))}disposeTemplate(e){e.disposable&&(e.disposable.dispose(),e.disposable=void 0),e.data&&(this.renderer.disposeTemplate(e.data),e.data=void 0)}}class c{constructor(e,t){this.modelProvider=e,this.accessibilityProvider=t}getWidgetAriaLabel(){return this.accessibilityProvider.getWidgetAriaLabel()}getAriaLabel(e){const t=this.modelProvider();return t.isResolved(e)?this.accessibilityProvider.getAriaLabel(t.get(e)):null}}class d{constructor(e,t,i,n,o={}){const r=()=>this.model,s=n.map((e=>new l(e,r)));this.list=new a.List(e,t,i,s,function(e,t){return{...t,accessibilityProvider:t.accessibilityProvider&&new c(e,t.accessibilityProvider)}}(r,o))}updateOptions(e){this.list.updateOptions(e)}getHTMLElement(){return this.list.getHTMLElement()}get onDidFocus(){return this.list.onDidFocus}get widget(){return this.list}get onDidDispose(){return this.list.onDidDispose}get onMouseDblClick(){return r.Event.map(this.list.onMouseDblClick,(({element:e,index:t,browserEvent:i})=>({element:void 0===e?void 0:this._model.get(e),index:t,browserEvent:i})))}get onPointer(){return r.Event.map(this.list.onPointer,(({element:e,index:t,browserEvent:i})=>({element:void 0===e?void 0:this._model.get(e),index:t,browserEvent:i})))}get onDidChangeSelection(){return r.Event.map(this.list.onDidChangeSelection,(({elements:e,indexes:t,browserEvent:i})=>({elements:e.map((e=>this._model.get(e))),indexes:t,browserEvent:i})))}get model(){return this._model}set model(e){this._model=e,this.list.splice(0,this.list.length,(0,n.range)(e.length))}getFocus(){return this.list.getFocus()}getSelection(){return this.list.getSelection()}getSelectedElements(){return this.getSelection().map((e=>this.model.get(e)))}style(e){this.list.style(e)}dispose(){this.list.dispose()}}},75291:function(e,t,i){"use strict";i.r(t),i.d(t,{ElementsDragAndDropData:function(){return C},ExternalElementsDragAndDropData:function(){return w},ListView:function(){return x},NativeDragAndDropData:function(){return y}});var n=i(65174),o=i(96747),r=i(50465),s=i(4043),a=i(34309),l=i(64998),c=i(66129),d=i(63966),u=i(63801),h=i(68921),g=i(83682),p=i(6097),m=i(37218),f=i(1056),b=i(12718),v=function(e,t,i,n){var o,r=arguments.length,s=r<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,i):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)s=Reflect.decorate(e,t,i,n);else for(var a=e.length-1;a>=0;a--)(o=e[a])&&(s=(r<3?o(s):r>3?o(t,i,s):o(t,i))||s);return r>3&&s&&Object.defineProperty(t,i,s),s};const _={CurrentDragAndDropData:void 0},A={useShadows:!0,verticalScrollMode:1,setRowLineHeight:!0,setRowHeight:!0,supportDynamicHeights:!1,dnd:{getDragElements(e){return[e]},getDragURI(){return null},onDragStart(){},onDragOver(){return!1},drop(){},dispose(){}},horizontalScrolling:!1,transformOptimization:!0,alwaysConsumeMouseWheel:!0};class C{constructor(e){this.elements=e}update(){}getData(){return this.elements}}class w{constructor(e){this.elements=e}update(){}getData(){return this.elements}}class y{constructor(){this.types=[],this.files=[]}update(e){if(e.types&&this.types.splice(0,this.types.length,...e.types),e.files){this.files.splice(0,this.files.length);for(let t=0;t<e.files.length;t++){const i=e.files.item(t);i&&(i.size||i.type)&&this.files.push(i)}}}getData(){return{types:this.types,files:this.files}}}class S{constructor(e){(null==e?void 0:e.getSetSize)?this.getSetSize=e.getSetSize.bind(e):this.getSetSize=(e,t,i)=>i,(null==e?void 0:e.getPosInSet)?this.getPosInSet=e.getPosInSet.bind(e):this.getPosInSet=(e,t)=>t+1,(null==e?void 0:e.getRole)?this.getRole=e.getRole.bind(e):this.getRole=e=>"listitem",(null==e?void 0:e.isChecked)?this.isChecked=e.isChecked.bind(e):this.isChecked=e=>{}}}class x{get contentHeight(){return this.rangeMap.size}get onDidScroll(){return this.scrollableElement.onScroll}get scrollableElementDomNode(){return this.scrollableElement.getDomNode()}get horizontalScrolling(){return this._horizontalScrolling}set horizontalScrolling(e){if(e!==this._horizontalScrolling){if(e&&this.supportDynamicHeights)throw new Error("Horizontal scrolling and dynamic heights not supported simultaneously");if(this._horizontalScrolling=e,this.domNode.classList.toggle("horizontal-scrolling",this._horizontalScrolling),this._horizontalScrolling){for(const e of this.items)this.measureItemWidth(e);this.updateScrollWidth(),this.scrollableElement.setScrollDimensions({width:(0,o.getContentWidth)(this.domNode)}),this.rowsContainer.style.width=`${Math.max(this.scrollWidth||0,this.renderWidth)}px`}else this.scrollableElementWidthDelayer.cancel(),this.scrollableElement.setScrollDimensions({width:this.renderWidth,scrollWidth:this.renderWidth}),this.rowsContainer.style.width=""}}constructor(e,t,i,n=A){var r,l,d,g,b,v,_,C,w,y,E,k,D;if(this.virtualDelegate=t,this.domId="list_id_"+ ++x.InstanceCount,this.renderers=new Map,this.renderWidth=0,this._scrollHeight=0,this.scrollableElementUpdateDisposable=null,this.scrollableElementWidthDelayer=new c.Delayer(50),this.splicing=!1,this.dragOverAnimationStopDisposable=h.Disposable.None,this.dragOverMouseY=0,this.canDrop=!1,this.currentDragFeedbackDisposable=h.Disposable.None,this.onDragLeaveTimeout=h.Disposable.None,this.disposables=new h.DisposableStore,this._onDidChangeContentHeight=new u.Emitter,this._onDidChangeContentWidth=new u.Emitter,this.onDidChangeContentHeight=u.Event.latch(this._onDidChangeContentHeight.event,void 0,this.disposables),this._horizontalScrolling=!1,n.horizontalScrolling&&n.supportDynamicHeights)throw new Error("Horizontal scrolling and dynamic heights not supported simultaneously");this.items=[],this.itemId=0,this.rangeMap=new m.RangeMap(null!==(r=n.paddingTop)&&void 0!==r?r:0);for(const e of i)this.renderers.set(e.templateId,e);this.cache=this.disposables.add(new f.RowCache(this.renderers)),this.lastRenderTop=0,this.lastRenderHeight=0,this.domNode=document.createElement("div"),this.domNode.className="monaco-list",this.domNode.classList.add(this.domId),this.domNode.tabIndex=0,this.domNode.classList.toggle("mouse-support","boolean"!=typeof n.mouseSupport||n.mouseSupport),this._horizontalScrolling=null!==(l=n.horizontalScrolling)&&void 0!==l?l:A.horizontalScrolling,this.domNode.classList.toggle("horizontal-scrolling",this._horizontalScrolling),this.paddingBottom=void 0===n.paddingBottom?0:n.paddingBottom,this.accessibilityProvider=new S(n.accessibilityProvider),this.rowsContainer=document.createElement("div"),this.rowsContainer.className="monaco-list-rows";(null!==(d=n.transformOptimization)&&void 0!==d?d:A.transformOptimization)&&(this.rowsContainer.style.transform="translate3d(0px, 0px, 0px)",this.rowsContainer.style.overflow="hidden",this.rowsContainer.style.contain="strict"),this.disposables.add(s.Gesture.addTarget(this.rowsContainer)),this.scrollable=this.disposables.add(new p.Scrollable({forceIntegerValues:!0,smoothScrollDuration:null!==(g=n.smoothScrolling)&&void 0!==g&&g?125:0,scheduleAtNextAnimationFrame:e=>(0,o.scheduleAtNextAnimationFrame)((0,o.getWindow)(this.domNode),e)})),this.scrollableElement=this.disposables.add(new a.SmoothScrollableElement(this.rowsContainer,{alwaysConsumeMouseWheel:null!==(b=n.alwaysConsumeMouseWheel)&&void 0!==b?b:A.alwaysConsumeMouseWheel,horizontal:1,vertical:null!==(v=n.verticalScrollMode)&&void 0!==v?v:A.verticalScrollMode,useShadows:null!==(_=n.useShadows)&&void 0!==_?_:A.useShadows,mouseWheelScrollSensitivity:n.mouseWheelScrollSensitivity,fastScrollSensitivity:n.fastScrollSensitivity,scrollByPage:n.scrollByPage},this.scrollable)),this.domNode.appendChild(this.scrollableElement.getDomNode()),e.appendChild(this.domNode),this.scrollableElement.onScroll(this.onScroll,this,this.disposables),this.disposables.add((0,o.addDisposableListener)(this.rowsContainer,s.EventType.Change,(e=>this.onTouchChange(e)))),this.disposables.add((0,o.addDisposableListener)(this.scrollableElement.getDomNode(),"scroll",(e=>e.target.scrollTop=0))),this.disposables.add((0,o.addDisposableListener)(this.domNode,"dragover",(e=>this.onDragOver(this.toDragEvent(e))))),this.disposables.add((0,o.addDisposableListener)(this.domNode,"drop",(e=>this.onDrop(this.toDragEvent(e))))),this.disposables.add((0,o.addDisposableListener)(this.domNode,"dragleave",(e=>this.onDragLeave(this.toDragEvent(e))))),this.disposables.add((0,o.addDisposableListener)(this.domNode,"dragend",(e=>this.onDragEnd(e)))),this.setRowLineHeight=null!==(C=n.setRowLineHeight)&&void 0!==C?C:A.setRowLineHeight,this.setRowHeight=null!==(w=n.setRowHeight)&&void 0!==w?w:A.setRowHeight,this.supportDynamicHeights=null!==(y=n.supportDynamicHeights)&&void 0!==y?y:A.supportDynamicHeights,this.dnd=null!==(E=n.dnd)&&void 0!==E?E:this.disposables.add(A.dnd),this.layout(null===(k=n.initialSize)||void 0===k?void 0:k.height,null===(D=n.initialSize)||void 0===D?void 0:D.width)}updateOptions(e){let t;if(void 0!==e.paddingBottom&&(this.paddingBottom=e.paddingBottom,this.scrollableElement.setScrollDimensions({scrollHeight:this.scrollHeight})),void 0!==e.smoothScrolling&&this.scrollable.setSmoothScrollDuration(e.smoothScrolling?125:0),void 0!==e.horizontalScrolling&&(this.horizontalScrolling=e.horizontalScrolling),void 0!==e.scrollByPage&&(t={...null!=t?t:{},scrollByPage:e.scrollByPage}),void 0!==e.mouseWheelScrollSensitivity&&(t={...null!=t?t:{},mouseWheelScrollSensitivity:e.mouseWheelScrollSensitivity}),void 0!==e.fastScrollSensitivity&&(t={...null!=t?t:{},fastScrollSensitivity:e.fastScrollSensitivity}),t&&this.scrollableElement.updateOptions(t),void 0!==e.paddingTop&&e.paddingTop!==this.rangeMap.paddingTop){const t=this.getRenderRange(this.lastRenderTop,this.lastRenderHeight),i=e.paddingTop-this.rangeMap.paddingTop;this.rangeMap.paddingTop=e.paddingTop,this.render(t,Math.max(0,this.lastRenderTop+i),this.lastRenderHeight,void 0,void 0,!0),this.setScrollTop(this.lastRenderTop),this.eventuallyUpdateScrollDimensions(),this.supportDynamicHeights&&this._rerender(this.lastRenderTop,this.lastRenderHeight)}}splice(e,t,i=[]){if(this.splicing)throw new Error("Can't run recursive splices.");this.splicing=!0;try{return this._splice(e,t,i)}finally{this.splicing=!1,this._onDidChangeContentHeight.fire(this.contentHeight)}}_splice(e,t,i=[]){const n=this.getRenderRange(this.lastRenderTop,this.lastRenderHeight),o={start:e,end:e+t},r=g.Range.intersect(n,o),s=new Map;for(let e=r.end-1;e>=r.start;e--){const t=this.items[e];if(t.dragStartDisposable.dispose(),t.checkedDisposable.dispose(),t.row){let i=s.get(t.templateId);i||(i=[],s.set(t.templateId,i));const n=this.renderers.get(t.templateId);n&&n.disposeElement&&n.disposeElement(t.element,e,t.row.templateData,t.size),i.push(t.row)}t.row=null}const a={start:e+t,end:this.items.length},l=g.Range.intersect(a,n),c=g.Range.relativeComplement(a,n),d=i.map((e=>({id:String(this.itemId++),element:e,templateId:this.virtualDelegate.getTemplateId(e),size:this.virtualDelegate.getHeight(e),width:void 0,hasDynamicHeight:!!this.virtualDelegate.hasDynamicHeight&&this.virtualDelegate.hasDynamicHeight(e),lastDynamicHeightWidth:void 0,row:null,uri:void 0,dropTarget:!1,dragStartDisposable:h.Disposable.None,checkedDisposable:h.Disposable.None})));let u;0===e&&t>=this.items.length?(this.rangeMap=new m.RangeMap(this.rangeMap.paddingTop),this.rangeMap.splice(0,0,d),u=this.items,this.items=d):(this.rangeMap.splice(e,t,d),u=this.items.splice(e,t,...d));const p=i.length-t,f=this.getRenderRange(this.lastRenderTop,this.lastRenderHeight),b=(0,m.shift)(l,p),v=g.Range.intersect(f,b);for(let e=v.start;e<v.end;e++)this.updateItemInDOM(this.items[e],e);const _=g.Range.relativeComplement(b,f);for(const e of _)for(let t=e.start;t<e.end;t++)this.removeItemFromDOM(t);const A=c.map((e=>(0,m.shift)(e,p))),C=[{start:e,end:e+i.length},...A].map((e=>g.Range.intersect(f,e))),w=this.getNextToLastElement(C);for(const e of C)for(let t=e.start;t<e.end;t++){const e=this.items[t],i=s.get(e.templateId),n=null==i?void 0:i.pop();this.insertItemInDOM(t,w,n)}for(const e of s.values())for(const t of e)this.cache.release(t);return this.eventuallyUpdateScrollDimensions(),this.supportDynamicHeights&&this._rerender(this.scrollTop,this.renderHeight),u.map((e=>e.element))}eventuallyUpdateScrollDimensions(){this._scrollHeight=this.contentHeight,this.rowsContainer.style.height=`${this._scrollHeight}px`,this.scrollableElementUpdateDisposable||(this.scrollableElementUpdateDisposable=(0,o.scheduleAtNextAnimationFrame)((0,o.getWindow)(this.domNode),(()=>{this.scrollableElement.setScrollDimensions({scrollHeight:this.scrollHeight}),this.updateScrollWidth(),this.scrollableElementUpdateDisposable=null})))}eventuallyUpdateScrollWidth(){this.horizontalScrolling?this.scrollableElementWidthDelayer.trigger((()=>this.updateScrollWidth())):this.scrollableElementWidthDelayer.cancel()}updateScrollWidth(){if(!this.horizontalScrolling)return;let e=0;for(const t of this.items)void 0!==t.width&&(e=Math.max(e,t.width));this.scrollWidth=e,this.scrollableElement.setScrollDimensions({scrollWidth:0===e?0:e+10}),this._onDidChangeContentWidth.fire(this.scrollWidth)}rerender(){if(this.supportDynamicHeights){for(const e of this.items)e.lastDynamicHeightWidth=void 0;this._rerender(this.lastRenderTop,this.lastRenderHeight)}}get length(){return this.items.length}get renderHeight(){return this.scrollableElement.getScrollDimensions().height}get firstVisibleIndex(){return this.getRenderRange(this.lastRenderTop,this.lastRenderHeight).start}element(e){return this.items[e].element}indexOf(e){return this.items.findIndex((t=>t.element===e))}domElement(e){const t=this.items[e].row;return t&&t.domNode}elementHeight(e){return this.items[e].size}elementTop(e){return this.rangeMap.positionAt(e)}indexAt(e){return this.rangeMap.indexAt(e)}indexAfter(e){return this.rangeMap.indexAfter(e)}layout(e,t){const i={height:"number"==typeof e?e:(0,o.getContentHeight)(this.domNode)};this.scrollableElementUpdateDisposable&&(this.scrollableElementUpdateDisposable.dispose(),this.scrollableElementUpdateDisposable=null,i.scrollHeight=this.scrollHeight),this.scrollableElement.setScrollDimensions(i),void 0!==t&&(this.renderWidth=t,this.supportDynamicHeights&&this._rerender(this.scrollTop,this.renderHeight)),this.horizontalScrolling&&this.scrollableElement.setScrollDimensions({width:"number"==typeof t?t:(0,o.getContentWidth)(this.domNode)})}render(e,t,i,n,o,r=!1){const s=this.getRenderRange(t,i),a=g.Range.relativeComplement(s,e),l=g.Range.relativeComplement(e,s),c=this.getNextToLastElement(a);if(r){const t=g.Range.intersect(e,s);for(let e=t.start;e<t.end;e++)this.updateItemInDOM(this.items[e],e)}this.cache.transact((()=>{for(const e of l)for(let t=e.start;t<e.end;t++)this.removeItemFromDOM(t);for(const e of a)for(let t=e.start;t<e.end;t++)this.insertItemInDOM(t,c)})),void 0!==n&&(this.rowsContainer.style.left=`-${n}px`),this.rowsContainer.style.top=`-${t}px`,this.horizontalScrolling&&void 0!==o&&(this.rowsContainer.style.width=`${Math.max(o,this.renderWidth)}px`),this.lastRenderTop=t,this.lastRenderHeight=i}insertItemInDOM(e,t,i){const n=this.items[e];let r=!1;if(!n.row)if(i)n.row=i;else{const e=this.cache.alloc(n.templateId);n.row=e.row,r=e.isReusingConnectedDomNode}const s=this.accessibilityProvider.getRole(n.element)||"listitem";n.row.domNode.setAttribute("role",s);const a=this.accessibilityProvider.isChecked(n.element);if("boolean"==typeof a)n.row.domNode.setAttribute("aria-checked",String(!!a));else if(a){const e=e=>n.row.domNode.setAttribute("aria-checked",String(!!e));e(a.value),n.checkedDisposable=a.onDidChange(e)}!r&&n.row.domNode.parentElement||(t?this.rowsContainer.insertBefore(n.row.domNode,t):this.rowsContainer.appendChild(n.row.domNode)),this.updateItemInDOM(n,e);const l=this.renderers.get(n.templateId);if(!l)throw new Error(`No renderer found for template id ${n.templateId}`);null==l||l.renderElement(n.element,e,n.row.templateData,n.size);const c=this.dnd.getDragURI(n.element);n.dragStartDisposable.dispose(),n.row.domNode.draggable=!!c,c&&(n.dragStartDisposable=(0,o.addDisposableListener)(n.row.domNode,"dragstart",(e=>this.onDragStart(n.element,c,e)))),this.horizontalScrolling&&(this.measureItemWidth(n),this.eventuallyUpdateScrollWidth())}measureItemWidth(e){if(!e.row||!e.row.domNode)return;e.row.domNode.style.width="fit-content",e.width=(0,o.getContentWidth)(e.row.domNode);const t=(0,o.getWindow)(e.row.domNode).getComputedStyle(e.row.domNode);t.paddingLeft&&(e.width+=parseFloat(t.paddingLeft)),t.paddingRight&&(e.width+=parseFloat(t.paddingRight)),e.row.domNode.style.width=""}updateItemInDOM(e,t){e.row.domNode.style.top=`${this.elementTop(t)}px`,this.setRowHeight&&(e.row.domNode.style.height=`${e.size}px`),this.setRowLineHeight&&(e.row.domNode.style.lineHeight=`${e.size}px`),e.row.domNode.setAttribute("data-index",`${t}`),e.row.domNode.setAttribute("data-last-element",t===this.length-1?"true":"false"),e.row.domNode.setAttribute("data-parity",t%2==0?"even":"odd"),e.row.domNode.setAttribute("aria-setsize",String(this.accessibilityProvider.getSetSize(e.element,t,this.length))),e.row.domNode.setAttribute("aria-posinset",String(this.accessibilityProvider.getPosInSet(e.element,t))),e.row.domNode.setAttribute("id",this.getElementDomId(t)),e.row.domNode.classList.toggle("drop-target",e.dropTarget)}removeItemFromDOM(e){const t=this.items[e];if(t.dragStartDisposable.dispose(),t.checkedDisposable.dispose(),t.row){const i=this.renderers.get(t.templateId);i&&i.disposeElement&&i.disposeElement(t.element,e,t.row.templateData,t.size),this.cache.release(t.row),t.row=null}this.horizontalScrolling&&this.eventuallyUpdateScrollWidth()}getScrollTop(){return this.scrollableElement.getScrollPosition().scrollTop}setScrollTop(e,t){this.scrollableElementUpdateDisposable&&(this.scrollableElementUpdateDisposable.dispose(),this.scrollableElementUpdateDisposable=null,this.scrollableElement.setScrollDimensions({scrollHeight:this.scrollHeight})),this.scrollableElement.setScrollPosition({scrollTop:e,reuseAnimation:t})}get scrollTop(){return this.getScrollTop()}set scrollTop(e){this.setScrollTop(e)}get scrollHeight(){return this._scrollHeight+(this.horizontalScrolling?10:0)+this.paddingBottom}get onMouseClick(){return u.Event.map(this.disposables.add(new r.DomEmitter(this.domNode,"click")).event,(e=>this.toMouseEvent(e)),this.disposables)}get onMouseDblClick(){return u.Event.map(this.disposables.add(new r.DomEmitter(this.domNode,"dblclick")).event,(e=>this.toMouseEvent(e)),this.disposables)}get onMouseMiddleClick(){return u.Event.filter(u.Event.map(this.disposables.add(new r.DomEmitter(this.domNode,"auxclick")).event,(e=>this.toMouseEvent(e)),this.disposables),(e=>1===e.browserEvent.button),this.disposables)}get onMouseDown(){return u.Event.map(this.disposables.add(new r.DomEmitter(this.domNode,"mousedown")).event,(e=>this.toMouseEvent(e)),this.disposables)}get onMouseOver(){return u.Event.map(this.disposables.add(new r.DomEmitter(this.domNode,"mouseover")).event,(e=>this.toMouseEvent(e)),this.disposables)}get onMouseOut(){return u.Event.map(this.disposables.add(new r.DomEmitter(this.domNode,"mouseout")).event,(e=>this.toMouseEvent(e)),this.disposables)}get onContextMenu(){return u.Event.any(u.Event.map(this.disposables.add(new r.DomEmitter(this.domNode,"contextmenu")).event,(e=>this.toMouseEvent(e)),this.disposables),u.Event.map(this.disposables.add(new r.DomEmitter(this.domNode,s.EventType.Contextmenu)).event,(e=>this.toGestureEvent(e)),this.disposables))}get onTouchStart(){return u.Event.map(this.disposables.add(new r.DomEmitter(this.domNode,"touchstart")).event,(e=>this.toTouchEvent(e)),this.disposables)}get onTap(){return u.Event.map(this.disposables.add(new r.DomEmitter(this.rowsContainer,s.EventType.Tap)).event,(e=>this.toGestureEvent(e)),this.disposables)}toMouseEvent(e){const t=this.getItemIndexFromEventTarget(e.target||null),i=void 0===t?void 0:this.items[t];return{browserEvent:e,index:t,element:i&&i.element}}toTouchEvent(e){const t=this.getItemIndexFromEventTarget(e.target||null),i=void 0===t?void 0:this.items[t];return{browserEvent:e,index:t,element:i&&i.element}}toGestureEvent(e){const t=this.getItemIndexFromEventTarget(e.initialTarget||null),i=void 0===t?void 0:this.items[t];return{browserEvent:e,index:t,element:i&&i.element}}toDragEvent(e){const t=this.getItemIndexFromEventTarget(e.target||null),i=void 0===t?void 0:this.items[t];return{browserEvent:e,index:t,element:i&&i.element}}onScroll(e){try{const t=this.getRenderRange(this.lastRenderTop,this.lastRenderHeight);this.render(t,e.scrollTop,e.height,e.scrollLeft,e.scrollWidth),this.supportDynamicHeights&&this._rerender(e.scrollTop,e.height,e.inSmoothScrolling)}catch(t){throw console.error("Got bad scroll event:",e),t}}onTouchChange(e){e.preventDefault(),e.stopPropagation(),this.scrollTop-=e.translationY}onDragStart(e,t,i){var r,s;if(!i.dataTransfer)return;const a=this.dnd.getDragElements(e);if(i.dataTransfer.effectAllowed="copyMove",i.dataTransfer.setData(n.DataTransfers.TEXT,t),i.dataTransfer.setDragImage){let e;this.dnd.getDragLabel&&(e=this.dnd.getDragLabel(a,i)),void 0===e&&(e=String(a.length));const t=(0,o.$)(".monaco-drag-image");t.textContent=e;const n=(e=>{for(;e&&!e.classList.contains("monaco-workbench");)e=e.parentElement;return e||this.domNode.ownerDocument})(this.domNode);n.appendChild(t),i.dataTransfer.setDragImage(t,-10,-10),setTimeout((()=>n.removeChild(t)),0)}this.domNode.classList.add("dragging"),this.currentDragData=new C(a),_.CurrentDragAndDropData=new w(a),null===(s=(r=this.dnd).onDragStart)||void 0===s||s.call(r,this.currentDragData,i)}onDragOver(e){var t;if(e.browserEvent.preventDefault(),this.onDragLeaveTimeout.dispose(),_.CurrentDragAndDropData&&"vscode-ui"===_.CurrentDragAndDropData.getData())return!1;if(this.setupDragAndDropScrollTopAnimation(e.browserEvent),!e.browserEvent.dataTransfer)return!1;if(!this.currentDragData)if(_.CurrentDragAndDropData)this.currentDragData=_.CurrentDragAndDropData;else{if(!e.browserEvent.dataTransfer.types)return!1;this.currentDragData=new y}const i=this.dnd.onDragOver(this.currentDragData,e.element,e.index,e.browserEvent);if(this.canDrop="boolean"==typeof i?i:i.accept,!this.canDrop)return this.currentDragFeedback=void 0,this.currentDragFeedbackDisposable.dispose(),!1;let n;if(e.browserEvent.dataTransfer.dropEffect="boolean"!=typeof i&&0===i.effect?"copy":"move",n="boolean"!=typeof i&&i.feedback?i.feedback:void 0===e.index?[-1]:[e.index],n=(0,l.distinct)(n).filter((e=>e>=-1&&e<this.length)).sort(((e,t)=>e-t)),n=-1===n[0]?[-1]:n,o=this.currentDragFeedback,r=n,Array.isArray(o)&&Array.isArray(r)?(0,l.equals)(o,r):o===r)return!0;var o,r;if(this.currentDragFeedback=n,this.currentDragFeedbackDisposable.dispose(),-1===n[0])this.domNode.classList.add("drop-target"),this.rowsContainer.classList.add("drop-target"),this.currentDragFeedbackDisposable=(0,h.toDisposable)((()=>{this.domNode.classList.remove("drop-target"),this.rowsContainer.classList.remove("drop-target")}));else{for(const e of n){const i=this.items[e];i.dropTarget=!0,null===(t=i.row)||void 0===t||t.domNode.classList.add("drop-target")}this.currentDragFeedbackDisposable=(0,h.toDisposable)((()=>{var e;for(const t of n){const i=this.items[t];i.dropTarget=!1,null===(e=i.row)||void 0===e||e.domNode.classList.remove("drop-target")}}))}return!0}onDragLeave(e){var t,i;this.onDragLeaveTimeout.dispose(),this.onDragLeaveTimeout=(0,c.disposableTimeout)((()=>this.clearDragOverFeedback()),100,this.disposables),this.currentDragData&&(null===(i=(t=this.dnd).onDragLeave)||void 0===i||i.call(t,this.currentDragData,e.element,e.index,e.browserEvent))}onDrop(e){if(!this.canDrop)return;const t=this.currentDragData;this.teardownDragAndDropScrollTopAnimation(),this.clearDragOverFeedback(),this.domNode.classList.remove("dragging"),this.currentDragData=void 0,_.CurrentDragAndDropData=void 0,t&&e.browserEvent.dataTransfer&&(e.browserEvent.preventDefault(),t.update(e.browserEvent.dataTransfer),this.dnd.drop(t,e.element,e.index,e.browserEvent))}onDragEnd(e){var t,i;this.canDrop=!1,this.teardownDragAndDropScrollTopAnimation(),this.clearDragOverFeedback(),this.domNode.classList.remove("dragging"),this.currentDragData=void 0,_.CurrentDragAndDropData=void 0,null===(i=(t=this.dnd).onDragEnd)||void 0===i||i.call(t,e)}clearDragOverFeedback(){this.currentDragFeedback=void 0,this.currentDragFeedbackDisposable.dispose(),this.currentDragFeedbackDisposable=h.Disposable.None}setupDragAndDropScrollTopAnimation(e){if(!this.dragOverAnimationDisposable){const e=(0,o.getTopLeftOffset)(this.domNode).top;this.dragOverAnimationDisposable=(0,o.animate)((0,o.getWindow)(this.domNode),this.animateDragAndDropScrollTop.bind(this,e))}this.dragOverAnimationStopDisposable.dispose(),this.dragOverAnimationStopDisposable=(0,c.disposableTimeout)((()=>{this.dragOverAnimationDisposable&&(this.dragOverAnimationDisposable.dispose(),this.dragOverAnimationDisposable=void 0)}),1e3,this.disposables),this.dragOverMouseY=e.pageY}animateDragAndDropScrollTop(e){if(void 0===this.dragOverMouseY)return;const t=this.dragOverMouseY-e,i=this.renderHeight-35;t<35?this.scrollTop+=Math.max(-14,Math.floor(.3*(t-35))):t>i&&(this.scrollTop+=Math.min(14,Math.floor(.3*(t-i))))}teardownDragAndDropScrollTopAnimation(){this.dragOverAnimationStopDisposable.dispose(),this.dragOverAnimationDisposable&&(this.dragOverAnimationDisposable.dispose(),this.dragOverAnimationDisposable=void 0)}getItemIndexFromEventTarget(e){const t=this.scrollableElement.getDomNode();let i=e;for(;i instanceof HTMLElement&&i!==this.rowsContainer&&t.contains(i);){const e=i.getAttribute("data-index");if(e){const t=Number(e);if(!isNaN(t))return t}i=i.parentElement}}getRenderRange(e,t){return{start:this.rangeMap.indexAt(e),end:this.rangeMap.indexAfter(e+t-1)}}_rerender(e,t,i){const n=this.getRenderRange(e,t);let o,r;e===this.elementTop(n.start)?(o=n.start,r=0):n.end-n.start>1&&(o=n.start+1,r=this.elementTop(o)-e);let s=0;for(;;){const a=this.getRenderRange(e,t);let l=!1;for(let e=a.start;e<a.end;e++){const t=this.probeDynamicHeight(e);0!==t&&this.rangeMap.splice(e,1,[this.items[e]]),s+=t,l=l||0!==t}if(!l){0!==s&&this.eventuallyUpdateScrollDimensions();const t=g.Range.relativeComplement(n,a);for(const e of t)for(let t=e.start;t<e.end;t++)this.items[t].row&&this.removeItemFromDOM(t);const l=g.Range.relativeComplement(a,n);for(const e of l)for(let t=e.start;t<e.end;t++){const e=t+1,i=e<this.items.length?this.items[e].row:null,n=i?i.domNode:null;this.insertItemInDOM(t,n)}for(let e=a.start;e<a.end;e++)this.items[e].row&&this.updateItemInDOM(this.items[e],e);if("number"==typeof o){const t=this.scrollable.getFutureScrollPosition().scrollTop-e,n=this.elementTop(o)-r+t;this.setScrollTop(n,i)}return void this._onDidChangeContentHeight.fire(this.contentHeight)}}}probeDynamicHeight(e){var t,i,n;const o=this.items[e];if(this.virtualDelegate.getDynamicHeight){const e=this.virtualDelegate.getDynamicHeight(o.element);if(null!==e){const t=o.size;return o.size=e,o.lastDynamicHeightWidth=this.renderWidth,e-t}}if(!o.hasDynamicHeight||o.lastDynamicHeightWidth===this.renderWidth)return 0;if(this.virtualDelegate.hasDynamicHeight&&!this.virtualDelegate.hasDynamicHeight(o.element))return 0;const r=o.size;if(o.row)return o.row.domNode.style.height="",o.size=o.row.domNode.offsetHeight,o.lastDynamicHeightWidth=this.renderWidth,o.size-r;const{row:s}=this.cache.alloc(o.templateId);s.domNode.style.height="",this.rowsContainer.appendChild(s.domNode);const a=this.renderers.get(o.templateId);if(!a)throw new b.BugIndicatingError("Missing renderer for templateId: "+o.templateId);return a.renderElement(o.element,e,s.templateData,void 0),o.size=s.domNode.offsetHeight,null===(t=a.disposeElement)||void 0===t||t.call(a,o.element,e,s.templateData,void 0),null===(n=(i=this.virtualDelegate).setDynamicHeight)||void 0===n||n.call(i,o.element,o.size),o.lastDynamicHeightWidth=this.renderWidth,this.rowsContainer.removeChild(s.domNode),this.cache.release(s),o.size-r}getNextToLastElement(e){const t=e[e.length-1];if(!t)return null;const i=this.items[t.end];return i&&i.row?i.row.domNode:null}getElementDomId(e){return`${this.domId}_${e}`}dispose(){var e,t;for(const t of this.items)if(t.dragStartDisposable.dispose(),t.checkedDisposable.dispose(),t.row){const i=this.renderers.get(t.row.templateId);i&&(null===(e=i.disposeElement)||void 0===e||e.call(i,t.element,-1,t.row.templateData,void 0),i.disposeTemplate(t.row.templateData))}this.items=[],this.domNode&&this.domNode.parentNode&&this.domNode.parentNode.removeChild(this.domNode),null===(t=this.dragOverAnimationDisposable)||void 0===t||t.dispose(),this.disposables.dispose()}}x.InstanceCount=0,v([d.memoize],x.prototype,"onMouseClick",null),v([d.memoize],x.prototype,"onMouseDblClick",null),v([d.memoize],x.prototype,"onMouseMiddleClick",null),v([d.memoize],x.prototype,"onMouseDown",null),v([d.memoize],x.prototype,"onMouseOver",null),v([d.memoize],x.prototype,"onMouseOut",null),v([d.memoize],x.prototype,"onContextMenu",null),v([d.memoize],x.prototype,"onTouchStart",null),v([d.memoize],x.prototype,"onTap",null)},72406:function(e,t,i){"use strict";i.r(t),i.d(t,{DefaultKeyboardNavigationDelegate:function(){return F},DefaultStyleController:function(){return Q},List:function(){return Z},MouseController:function(){return U},TypeNavigationMode:function(){return n},isActionItem:function(){return N},isButton:function(){return B},isInputElement:function(){return I},isMonacoCustomToggle:function(){return M},isMonacoEditor:function(){return T},isSelectionRangeChangeEvent:function(){return H},isSelectionSingleChangeEvent:function(){return W},isStickyScrollElement:function(){return R},unthemedListStyles:function(){return K}});var n,o,r=i(96747),s=i(50465),a=i(8769),l=i(4043),c=i(61950),d=i(25218),u=i(64998),h=i(66129),g=i(17160),p=i(63966),m=i(63801),f=i(27017),b=i(68921),v=i(53719),_=i(66719),A=i(18912),C=(i(82833),i(40083)),w=i(75291),y=i(5642),S=function(e,t,i,n){var o,r=arguments.length,s=r<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,i):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)s=Reflect.decorate(e,t,i,n);else for(var a=e.length-1;a>=0;a--)(o=e[a])&&(s=(r<3?o(s):r>3?o(t,i,s):o(t,i))||s);return r>3&&s&&Object.defineProperty(t,i,s),s};class x{constructor(e){this.trait=e,this.renderedElements=[]}get templateId(){return`template:${this.trait.name}`}renderTemplate(e){return e}renderElement(e,t,i){const n=this.renderedElements.findIndex((e=>e.templateData===i));if(n>=0){const e=this.renderedElements[n];this.trait.unrender(i),e.index=t}else{const e={index:t,templateData:i};this.renderedElements.push(e)}this.trait.renderIndex(t,i)}splice(e,t,i){const n=[];for(const o of this.renderedElements)o.index<e?n.push(o):o.index>=e+t&&n.push({index:o.index+i-t,templateData:o.templateData});this.renderedElements=n}renderIndexes(e){for(const{index:t,templateData:i}of this.renderedElements)e.indexOf(t)>-1&&this.trait.renderIndex(t,i)}disposeTemplate(e){const t=this.renderedElements.findIndex((t=>t.templateData===e));t<0||this.renderedElements.splice(t,1)}}class E{get name(){return this._trait}get renderer(){return new x(this)}constructor(e){this._trait=e,this.length=0,this.indexes=[],this.sortedIndexes=[],this._onChange=new m.Emitter,this.onChange=this._onChange.event}splice(e,t,i){var n;t=Math.max(0,Math.min(t,this.length-e));const o=i.length-t,r=e+t,s=[];let a=0;for(;a<this.sortedIndexes.length&&this.sortedIndexes[a]<e;)s.push(this.sortedIndexes[a++]);for(let t=0;t<i.length;t++)i[t]&&s.push(t+e);for(;a<this.sortedIndexes.length&&this.sortedIndexes[a]>=r;)s.push(this.sortedIndexes[a++]+o);const l=this.length+o;if(this.sortedIndexes.length>0&&0===s.length&&l>0){const t=null!==(n=this.sortedIndexes.find((t=>t>=e)))&&void 0!==n?n:l-1;s.push(Math.min(t,l-1))}this.renderer.splice(e,t,i.length),this._set(s,s),this.length=l}renderIndex(e,t){t.classList.toggle(this._trait,this.contains(e))}unrender(e){e.classList.remove(this._trait)}set(e,t){return this._set(e,[...e].sort(q),t)}_set(e,t,i){const n=this.indexes,o=this.sortedIndexes;this.indexes=e,this.sortedIndexes=t;const r=G(o,e);return this.renderer.renderIndexes(r),this._onChange.fire({indexes:e,browserEvent:i}),n}get(){return this.indexes}contains(e){return(0,u.binarySearch)(this.sortedIndexes,e,q)>=0}dispose(){(0,b.dispose)(this._onChange)}}S([p.memoize],E.prototype,"renderer",null);class k extends E{constructor(e){super("selected"),this.setAriaSelected=e}renderIndex(e,t){super.renderIndex(e,t),this.setAriaSelected&&(this.contains(e)?t.setAttribute("aria-selected","true"):t.setAttribute("aria-selected","false"))}}class D{constructor(e,t,i){this.trait=e,this.view=t,this.identityProvider=i}splice(e,t,i){if(!this.identityProvider)return this.trait.splice(e,t,new Array(i.length).fill(!1));const n=this.trait.get().map((e=>this.identityProvider.getId(this.view.element(e)).toString()));if(0===n.length)return this.trait.splice(e,t,new Array(i.length).fill(!1));const o=new Set(n),r=i.map((e=>o.has(this.identityProvider.getId(e).toString())));this.trait.splice(e,t,r)}}function I(e){return"INPUT"===e.tagName||"TEXTAREA"===e.tagName}function L(e,t){return!!e.classList.contains(t)||!e.classList.contains("monaco-list")&&(!!e.parentElement&&L(e.parentElement,t))}function T(e){return L(e,"monaco-editor")}function M(e){return L(e,"monaco-custom-toggle")}function N(e){return L(e,"action-item")}function R(e){return L(e,"monaco-tree-sticky-row")}function B(e){return!!("A"===e.tagName&&e.classList.contains("monaco-button")||"DIV"===e.tagName&&e.classList.contains("monaco-button-dropdown"))||!e.classList.contains("monaco-list")&&(!!e.parentElement&&B(e.parentElement))}class O{get onKeyDown(){return m.Event.chain(this.disposables.add(new s.DomEmitter(this.view.domNode,"keydown")).event,(e=>e.filter((e=>!I(e.target))).map((e=>new a.StandardKeyboardEvent(e)))))}constructor(e,t,i){this.list=e,this.view=t,this.disposables=new b.DisposableStore,this.multipleSelectionDisposables=new b.DisposableStore,this.multipleSelectionSupport=i.multipleSelectionSupport,this.disposables.add(this.onKeyDown((e=>{switch(e.keyCode){case 3:return this.onEnter(e);case 16:return this.onUpArrow(e);case 18:return this.onDownArrow(e);case 11:return this.onPageUpArrow(e);case 12:return this.onPageDownArrow(e);case 9:return this.onEscape(e);case 31:this.multipleSelectionSupport&&(_.isMacintosh?e.metaKey:e.ctrlKey)&&this.onCtrlA(e)}})))}updateOptions(e){void 0!==e.multipleSelectionSupport&&(this.multipleSelectionSupport=e.multipleSelectionSupport)}onEnter(e){e.preventDefault(),e.stopPropagation(),this.list.setSelection(this.list.getFocus(),e.browserEvent)}onUpArrow(e){e.preventDefault(),e.stopPropagation(),this.list.focusPrevious(1,!1,e.browserEvent);const t=this.list.getFocus()[0];this.list.setAnchor(t),this.list.reveal(t),this.view.domNode.focus()}onDownArrow(e){e.preventDefault(),e.stopPropagation(),this.list.focusNext(1,!1,e.browserEvent);const t=this.list.getFocus()[0];this.list.setAnchor(t),this.list.reveal(t),this.view.domNode.focus()}onPageUpArrow(e){e.preventDefault(),e.stopPropagation(),this.list.focusPreviousPage(e.browserEvent);const t=this.list.getFocus()[0];this.list.setAnchor(t),this.list.reveal(t),this.view.domNode.focus()}onPageDownArrow(e){e.preventDefault(),e.stopPropagation(),this.list.focusNextPage(e.browserEvent);const t=this.list.getFocus()[0];this.list.setAnchor(t),this.list.reveal(t),this.view.domNode.focus()}onCtrlA(e){e.preventDefault(),e.stopPropagation(),this.list.setSelection((0,u.range)(this.list.length),e.browserEvent),this.list.setAnchor(void 0),this.view.domNode.focus()}onEscape(e){this.list.getSelection().length&&(e.preventDefault(),e.stopPropagation(),this.list.setSelection([],e.browserEvent),this.list.setAnchor(void 0),this.view.domNode.focus())}dispose(){this.disposables.dispose(),this.multipleSelectionDisposables.dispose()}}S([p.memoize],O.prototype,"onKeyDown",null),function(e){e[e.Automatic=0]="Automatic",e[e.Trigger=1]="Trigger"}(n||(n={})),function(e){e[e.Idle=0]="Idle",e[e.Typing=1]="Typing"}(o||(o={}));const F=new class{mightProducePrintableCharacter(e){return!(e.ctrlKey||e.metaKey||e.altKey)&&(e.keyCode>=31&&e.keyCode<=56||e.keyCode>=21&&e.keyCode<=30||e.keyCode>=98&&e.keyCode<=107||e.keyCode>=85&&e.keyCode<=95)}};class P{constructor(e,t,i,r,s){this.list=e,this.view=t,this.keyboardNavigationLabelProvider=i,this.keyboardNavigationEventFilter=r,this.delegate=s,this.enabled=!1,this.state=o.Idle,this.mode=n.Automatic,this.triggered=!1,this.previouslyFocused=-1,this.enabledDisposables=new b.DisposableStore,this.disposables=new b.DisposableStore,this.updateOptions(e.options)}updateOptions(e){var t,i;null===(t=e.typeNavigationEnabled)||void 0===t||t?this.enable():this.disable(),this.mode=null!==(i=e.typeNavigationMode)&&void 0!==i?i:n.Automatic}enable(){if(this.enabled)return;let e=!1;const t=m.Event.chain(this.enabledDisposables.add(new s.DomEmitter(this.view.domNode,"keydown")).event,(t=>t.filter((e=>!I(e.target))).filter((()=>this.mode===n.Automatic||this.triggered)).map((e=>new a.StandardKeyboardEvent(e))).filter((t=>e||this.keyboardNavigationEventFilter(t))).filter((e=>this.delegate.mightProducePrintableCharacter(e))).forEach((e=>r.EventHelper.stop(e,!0))).map((e=>e.browserEvent.key)))),i=m.Event.debounce(t,(()=>null),800,void 0,void 0,void 0,this.enabledDisposables);m.Event.reduce(m.Event.any(t,i),((e,t)=>null===t?null:(e||"")+t),void 0,this.enabledDisposables)(this.onInput,this,this.enabledDisposables),i(this.onClear,this,this.enabledDisposables),t((()=>e=!0),void 0,this.enabledDisposables),i((()=>e=!1),void 0,this.enabledDisposables),this.enabled=!0,this.triggered=!1}disable(){this.enabled&&(this.enabledDisposables.clear(),this.enabled=!1,this.triggered=!1)}onClear(){var e;const t=this.list.getFocus();if(t.length>0&&t[0]===this.previouslyFocused){const i=null===(e=this.list.options.accessibilityProvider)||void 0===e?void 0:e.getAriaLabel(this.list.element(t[0]));i&&(0,c.alert)(i)}this.previouslyFocused=-1}onInput(e){if(!e)return this.state=o.Idle,void(this.triggered=!1);const t=this.list.getFocus(),i=t.length>0?t[0]:0,n=this.state===o.Idle?1:0;this.state=o.Typing;for(let t=0;t<this.list.length;t++){const o=(i+t+n)%this.list.length,r=this.keyboardNavigationLabelProvider.getKeyboardNavigationLabel(this.view.element(o)),s=r&&r.toString();if(this.list.options.typeNavigationEnabled){if(void 0!==s){if((0,f.matchesPrefix)(e,s))return this.previouslyFocused=i,this.list.setFocus([o]),void this.list.reveal(o);const t=(0,f.matchesFuzzy2)(e,s);if(t){if(t[0].end-t[0].start>1&&1===t.length)return this.previouslyFocused=i,this.list.setFocus([o]),void this.list.reveal(o)}}}else if(void 0===s||(0,f.matchesPrefix)(e,s))return this.previouslyFocused=i,this.list.setFocus([o]),void this.list.reveal(o)}}dispose(){this.disable(),this.enabledDisposables.dispose(),this.disposables.dispose()}}class z{constructor(e,t){this.list=e,this.view=t,this.disposables=new b.DisposableStore;const i=m.Event.chain(this.disposables.add(new s.DomEmitter(t.domNode,"keydown")).event,(e=>e.filter((e=>!I(e.target))).map((e=>new a.StandardKeyboardEvent(e)))));m.Event.chain(i,(e=>e.filter((e=>!(2!==e.keyCode||e.ctrlKey||e.metaKey||e.shiftKey||e.altKey)))))(this.onTab,this,this.disposables)}onTab(e){if(e.target!==this.view.domNode)return;const t=this.list.getFocus();if(0===t.length)return;const i=this.view.domElement(t[0]);if(!i)return;const n=i.querySelector("[tabIndex]");if(!(n&&n instanceof HTMLElement&&-1!==n.tabIndex))return;const o=(0,r.getWindow)(n).getComputedStyle(n);"hidden"!==o.visibility&&"none"!==o.display&&(e.preventDefault(),e.stopPropagation(),n.focus())}dispose(){this.disposables.dispose()}}function W(e){return _.isMacintosh?e.browserEvent.metaKey:e.browserEvent.ctrlKey}function H(e){return e.browserEvent.shiftKey}const V={isSelectionSingleChangeEvent:W,isSelectionRangeChangeEvent:H};class U{constructor(e){this.list=e,this.disposables=new b.DisposableStore,this._onPointer=new m.Emitter,this.onPointer=this._onPointer.event,!1!==e.options.multipleSelectionSupport&&(this.multipleSelectionController=this.list.options.multipleSelectionController||V),this.mouseSupport=void 0===e.options.mouseSupport||!!e.options.mouseSupport,this.mouseSupport&&(e.onMouseDown(this.onMouseDown,this,this.disposables),e.onContextMenu(this.onContextMenu,this,this.disposables),e.onMouseDblClick(this.onDoubleClick,this,this.disposables),e.onTouchStart(this.onMouseDown,this,this.disposables),this.disposables.add(l.Gesture.addTarget(e.getHTMLElement()))),m.Event.any(e.onMouseClick,e.onMouseMiddleClick,e.onTap)(this.onViewPointer,this,this.disposables)}updateOptions(e){void 0!==e.multipleSelectionSupport&&(this.multipleSelectionController=void 0,e.multipleSelectionSupport&&(this.multipleSelectionController=this.list.options.multipleSelectionController||V))}isSelectionSingleChangeEvent(e){return!!this.multipleSelectionController&&this.multipleSelectionController.isSelectionSingleChangeEvent(e)}isSelectionRangeChangeEvent(e){return!!this.multipleSelectionController&&this.multipleSelectionController.isSelectionRangeChangeEvent(e)}isSelectionChangeEvent(e){return this.isSelectionSingleChangeEvent(e)||this.isSelectionRangeChangeEvent(e)}onMouseDown(e){T(e.browserEvent.target)||(0,r.getActiveElement)()!==e.browserEvent.target&&this.list.domFocus()}onContextMenu(e){if(I(e.browserEvent.target)||T(e.browserEvent.target))return;const t=void 0===e.index?[]:[e.index];this.list.setFocus(t,e.browserEvent)}onViewPointer(e){if(!this.mouseSupport)return;if(I(e.browserEvent.target)||T(e.browserEvent.target))return;if(e.browserEvent.isHandledByList)return;e.browserEvent.isHandledByList=!0;const t=e.index;return void 0===t?(this.list.setFocus([],e.browserEvent),this.list.setSelection([],e.browserEvent),void this.list.setAnchor(void 0)):this.isSelectionChangeEvent(e)?this.changeSelection(e):(this.list.setFocus([t],e.browserEvent),this.list.setAnchor(t),i=e.browserEvent,(0,r.isMouseEvent)(i)&&2===i.button||this.list.setSelection([t],e.browserEvent),void this._onPointer.fire(e));var i}onDoubleClick(e){if(I(e.browserEvent.target)||T(e.browserEvent.target))return;if(this.isSelectionChangeEvent(e))return;if(e.browserEvent.isHandledByList)return;e.browserEvent.isHandledByList=!0;const t=this.list.getFocus();this.list.setSelection(t,e.browserEvent)}changeSelection(e){const t=e.index;let i=this.list.getAnchor();if(this.isSelectionRangeChangeEvent(e)){if(void 0===i){const e=this.list.getFocus()[0];i=null!=e?e:t,this.list.setAnchor(i)}const n=Math.min(i,t),o=Math.max(i,t),r=(0,u.range)(n,o+1),s=this.list.getSelection(),a=function(e,t){const i=e.indexOf(t);if(-1===i)return[];const n=[];let o=i-1;for(;o>=0&&e[o]===t-(i-o);)n.push(e[o--]);n.reverse(),o=i;for(;o<e.length&&e[o]===t+(o-i);)n.push(e[o++]);return n}(G(s,[i]),i);if(0===a.length)return;const l=G(r,function(e,t){const i=[];let n=0,o=0;for(;n<e.length||o<t.length;)if(n>=e.length)i.push(t[o++]);else if(o>=t.length)i.push(e[n++]);else{if(e[n]===t[o]){n++,o++;continue}e[n]<t[o]?i.push(e[n++]):o++}return i}(s,a));this.list.setSelection(l,e.browserEvent),this.list.setFocus([t],e.browserEvent)}else if(this.isSelectionSingleChangeEvent(e)){const i=this.list.getSelection(),n=i.filter((e=>e!==t));this.list.setFocus([t]),this.list.setAnchor(t),i.length===n.length?this.list.setSelection([...n,t],e.browserEvent):this.list.setSelection(n,e.browserEvent)}}dispose(){this.disposables.dispose()}}class Q{constructor(e,t){this.styleElement=e,this.selectorSuffix=t}style(e){var t,i;const n=this.selectorSuffix&&`.${this.selectorSuffix}`,o=[];e.listBackground&&o.push(`.monaco-list${n} .monaco-list-rows { background: ${e.listBackground}; }`),e.listFocusBackground&&(o.push(`.monaco-list${n}:focus .monaco-list-row.focused { background-color: ${e.listFocusBackground}; }`),o.push(`.monaco-list${n}:focus .monaco-list-row.focused:hover { background-color: ${e.listFocusBackground}; }`)),e.listFocusForeground&&o.push(`.monaco-list${n}:focus .monaco-list-row.focused { color: ${e.listFocusForeground}; }`),e.listActiveSelectionBackground&&(o.push(`.monaco-list${n}:focus .monaco-list-row.selected { background-color: ${e.listActiveSelectionBackground}; }`),o.push(`.monaco-list${n}:focus .monaco-list-row.selected:hover { background-color: ${e.listActiveSelectionBackground}; }`)),e.listActiveSelectionForeground&&o.push(`.monaco-list${n}:focus .monaco-list-row.selected { color: ${e.listActiveSelectionForeground}; }`),e.listActiveSelectionIconForeground&&o.push(`.monaco-list${n}:focus .monaco-list-row.selected .codicon { color: ${e.listActiveSelectionIconForeground}; }`),e.listFocusAndSelectionBackground&&o.push(`\n\t\t\t\t.monaco-drag-image,\n\t\t\t\t.monaco-list${n}:focus .monaco-list-row.selected.focused { background-color: ${e.listFocusAndSelectionBackground}; }\n\t\t\t`),e.listFocusAndSelectionForeground&&o.push(`\n\t\t\t\t.monaco-drag-image,\n\t\t\t\t.monaco-list${n}:focus .monaco-list-row.selected.focused { color: ${e.listFocusAndSelectionForeground}; }\n\t\t\t`),e.listInactiveFocusForeground&&(o.push(`.monaco-list${n} .monaco-list-row.focused { color:  ${e.listInactiveFocusForeground}; }`),o.push(`.monaco-list${n} .monaco-list-row.focused:hover { color:  ${e.listInactiveFocusForeground}; }`)),e.listInactiveSelectionIconForeground&&o.push(`.monaco-list${n} .monaco-list-row.focused .codicon { color:  ${e.listInactiveSelectionIconForeground}; }`),e.listInactiveFocusBackground&&(o.push(`.monaco-list${n} .monaco-list-row.focused { background-color:  ${e.listInactiveFocusBackground}; }`),o.push(`.monaco-list${n} .monaco-list-row.focused:hover { background-color:  ${e.listInactiveFocusBackground}; }`)),e.listInactiveSelectionBackground&&(o.push(`.monaco-list${n} .monaco-list-row.selected { background-color:  ${e.listInactiveSelectionBackground}; }`),o.push(`.monaco-list${n} .monaco-list-row.selected:hover { background-color:  ${e.listInactiveSelectionBackground}; }`)),e.listInactiveSelectionForeground&&o.push(`.monaco-list${n} .monaco-list-row.selected { color: ${e.listInactiveSelectionForeground}; }`),e.listHoverBackground&&o.push(`.monaco-list${n}:not(.drop-target):not(.dragging) .monaco-list-row:hover:not(.selected):not(.focused) { background-color: ${e.listHoverBackground}; }`),e.listHoverForeground&&o.push(`.monaco-list${n}:not(.drop-target):not(.dragging) .monaco-list-row:hover:not(.selected):not(.focused) { color:  ${e.listHoverForeground}; }`);const s=(0,r.asCssValueWithDefault)(e.listFocusAndSelectionOutline,(0,r.asCssValueWithDefault)(e.listSelectionOutline,null!==(t=e.listFocusOutline)&&void 0!==t?t:""));s&&o.push(`.monaco-list${n}:focus .monaco-list-row.focused.selected { outline: 1px solid ${s}; outline-offset: -1px;}`),e.listFocusOutline&&o.push(`\n\t\t\t\t.monaco-drag-image,\n\t\t\t\t.monaco-list${n}:focus .monaco-list-row.focused { outline: 1px solid ${e.listFocusOutline}; outline-offset: -1px; }\n\t\t\t\t.monaco-workbench.context-menu-visible .monaco-list${n}.last-focused .monaco-list-row.focused { outline: 1px solid ${e.listFocusOutline}; outline-offset: -1px; }\n\t\t\t`);const a=(0,r.asCssValueWithDefault)(e.listSelectionOutline,null!==(i=e.listInactiveFocusOutline)&&void 0!==i?i:"");a&&o.push(`.monaco-list${n} .monaco-list-row.focused.selected { outline: 1px dotted ${a}; outline-offset: -1px; }`),e.listSelectionOutline&&o.push(`.monaco-list${n} .monaco-list-row.selected { outline: 1px dotted ${e.listSelectionOutline}; outline-offset: -1px; }`),e.listInactiveFocusOutline&&o.push(`.monaco-list${n} .monaco-list-row.focused { outline: 1px dotted ${e.listInactiveFocusOutline}; outline-offset: -1px; }`),e.listHoverOutline&&o.push(`.monaco-list${n} .monaco-list-row:hover { outline: 1px dashed ${e.listHoverOutline}; outline-offset: -1px; }`),e.listDropBackground&&o.push(`\n\t\t\t\t.monaco-list${n}.drop-target,\n\t\t\t\t.monaco-list${n} .monaco-list-rows.drop-target,\n\t\t\t\t.monaco-list${n} .monaco-list-row.drop-target { background-color: ${e.listDropBackground} !important; color: inherit !important; }\n\t\t\t`),e.tableColumnsBorder&&o.push(`\n\t\t\t\t.monaco-table > .monaco-split-view2,\n\t\t\t\t.monaco-table > .monaco-split-view2 .monaco-sash.vertical::before,\n\t\t\t\t.monaco-workbench:not(.reduce-motion) .monaco-table:hover > .monaco-split-view2,\n\t\t\t\t.monaco-workbench:not(.reduce-motion) .monaco-table:hover > .monaco-split-view2 .monaco-sash.vertical::before {\n\t\t\t\t\tborder-color: ${e.tableColumnsBorder};\n\t\t\t\t}\n\n\t\t\t\t.monaco-workbench:not(.reduce-motion) .monaco-table > .monaco-split-view2,\n\t\t\t\t.monaco-workbench:not(.reduce-motion) .monaco-table > .monaco-split-view2 .monaco-sash.vertical::before {\n\t\t\t\t\tborder-color: transparent;\n\t\t\t\t}\n\t\t\t`),e.tableOddRowsBackgroundColor&&o.push(`\n\t\t\t\t.monaco-table .monaco-list-row[data-parity=odd]:not(.focused):not(.selected):not(:hover) .monaco-table-tr,\n\t\t\t\t.monaco-table .monaco-list:not(:focus) .monaco-list-row[data-parity=odd].focused:not(.selected):not(:hover) .monaco-table-tr,\n\t\t\t\t.monaco-table .monaco-list:not(.focused) .monaco-list-row[data-parity=odd].focused:not(.selected):not(:hover) .monaco-table-tr {\n\t\t\t\t\tbackground-color: ${e.tableOddRowsBackgroundColor};\n\t\t\t\t}\n\t\t\t`),this.styleElement.textContent=o.join("\n")}}const K={listFocusBackground:"#7FB0D0",listActiveSelectionBackground:"#0E639C",listActiveSelectionForeground:"#FFFFFF",listActiveSelectionIconForeground:"#FFFFFF",listFocusAndSelectionOutline:"#90C2F9",listFocusAndSelectionBackground:"#094771",listFocusAndSelectionForeground:"#FFFFFF",listInactiveSelectionBackground:"#3F3F46",listInactiveSelectionIconForeground:"#FFFFFF",listHoverBackground:"#2A2D2E",listDropBackground:"#383B3D",treeIndentGuidesStroke:"#a9a9a9",treeInactiveIndentGuidesStroke:g.Color.fromHex("#a9a9a9").transparent(.4).toString(),tableColumnsBorder:g.Color.fromHex("#cccccc").transparent(.2).toString(),tableOddRowsBackgroundColor:g.Color.fromHex("#cccccc").transparent(.04).toString(),listBackground:void 0,listFocusForeground:void 0,listInactiveSelectionForeground:void 0,listInactiveFocusForeground:void 0,listInactiveFocusBackground:void 0,listHoverForeground:void 0,listFocusOutline:void 0,listInactiveFocusOutline:void 0,listSelectionOutline:void 0,listHoverOutline:void 0},j={keyboardSupport:!0,mouseSupport:!0,multipleSelectionSupport:!0,dnd:{getDragURI(){return null},onDragStart(){},onDragOver(){return!1},drop(){},dispose(){}}};function G(e,t){const i=[];let n=0,o=0;for(;n<e.length||o<t.length;)if(n>=e.length)i.push(t[o++]);else if(o>=t.length)i.push(e[n++]);else{if(e[n]===t[o]){i.push(e[n]),n++,o++;continue}e[n]<t[o]?i.push(e[n++]):i.push(t[o++])}return i}const q=(e,t)=>e-t;class Y{constructor(e,t){this._templateId=e,this.renderers=t}get templateId(){return this._templateId}renderTemplate(e){return this.renderers.map((t=>t.renderTemplate(e)))}renderElement(e,t,i,n){let o=0;for(const r of this.renderers)r.renderElement(e,t,i[o++],n)}disposeElement(e,t,i,n){var o;let r=0;for(const s of this.renderers)null===(o=s.disposeElement)||void 0===o||o.call(s,e,t,i[r],n),r+=1}disposeTemplate(e){let t=0;for(const i of this.renderers)i.disposeTemplate(e[t++])}}class ${constructor(e){this.accessibilityProvider=e,this.templateId="a18n"}renderTemplate(e){return e}renderElement(e,t,i){const n=this.accessibilityProvider.getAriaLabel(e);n?i.setAttribute("aria-label",n):i.removeAttribute("aria-label");const o=this.accessibilityProvider.getAriaLevel&&this.accessibilityProvider.getAriaLevel(e);"number"==typeof o?i.setAttribute("aria-level",`${o}`):i.removeAttribute("aria-level")}disposeTemplate(e){}}class J{constructor(e,t){this.list=e,this.dnd=t}getDragElements(e){const t=this.list.getSelectedElements();return t.indexOf(e)>-1?t:[e]}getDragURI(e){return this.dnd.getDragURI(e)}getDragLabel(e,t){if(this.dnd.getDragLabel)return this.dnd.getDragLabel(e,t)}onDragStart(e,t){var i,n;null===(n=(i=this.dnd).onDragStart)||void 0===n||n.call(i,e,t)}onDragOver(e,t,i,n){return this.dnd.onDragOver(e,t,i,n)}onDragLeave(e,t,i,n){var o,r;null===(r=(o=this.dnd).onDragLeave)||void 0===r||r.call(o,e,t,i,n)}onDragEnd(e){var t,i;null===(i=(t=this.dnd).onDragEnd)||void 0===i||i.call(t,e)}drop(e,t,i,n){this.dnd.drop(e,t,i,n)}dispose(){this.dnd.dispose()}}class Z{get onDidChangeFocus(){return m.Event.map(this.eventBufferer.wrapEvent(this.focus.onChange),(e=>this.toListEvent(e)),this.disposables)}get onDidChangeSelection(){return m.Event.map(this.eventBufferer.wrapEvent(this.selection.onChange),(e=>this.toListEvent(e)),this.disposables)}get domId(){return this.view.domId}get onDidScroll(){return this.view.onDidScroll}get onMouseClick(){return this.view.onMouseClick}get onMouseDblClick(){return this.view.onMouseDblClick}get onMouseMiddleClick(){return this.view.onMouseMiddleClick}get onPointer(){return this.mouseController.onPointer}get onMouseDown(){return this.view.onMouseDown}get onMouseOver(){return this.view.onMouseOver}get onMouseOut(){return this.view.onMouseOut}get onTouchStart(){return this.view.onTouchStart}get onTap(){return this.view.onTap}get onContextMenu(){let e=!1;const t=m.Event.chain(this.disposables.add(new s.DomEmitter(this.view.domNode,"keydown")).event,(t=>t.map((e=>new a.StandardKeyboardEvent(e))).filter((t=>e=58===t.keyCode||t.shiftKey&&68===t.keyCode)).map((e=>r.EventHelper.stop(e,!0))).filter((()=>!1)))),i=m.Event.chain(this.disposables.add(new s.DomEmitter(this.view.domNode,"keyup")).event,(t=>t.forEach((()=>e=!1)).map((e=>new a.StandardKeyboardEvent(e))).filter((e=>58===e.keyCode||e.shiftKey&&68===e.keyCode)).map((e=>r.EventHelper.stop(e,!0))).map((({browserEvent:e})=>{const t=this.getFocus(),i=t.length?t[0]:void 0;return{index:i,element:void 0!==i?this.view.element(i):void 0,anchor:void 0!==i?this.view.domElement(i):this.view.domNode,browserEvent:e}})))),n=m.Event.chain(this.view.onContextMenu,(t=>t.filter((t=>!e)).map((({element:e,index:t,browserEvent:i})=>({element:e,index:t,anchor:new y.StandardMouseEvent((0,r.getWindow)(this.view.domNode),i),browserEvent:i})))));return m.Event.any(t,i,n)}get onKeyDown(){return this.disposables.add(new s.DomEmitter(this.view.domNode,"keydown")).event}get onDidFocus(){return m.Event.signal(this.disposables.add(new s.DomEmitter(this.view.domNode,"focus",!0)).event)}constructor(e,t,i,n,o=j){var s,a,l,c;this.user=e,this._options=o,this.focus=new E("focused"),this.anchor=new E("anchor"),this.eventBufferer=new m.EventBufferer,this._ariaLabel="",this.disposables=new b.DisposableStore,this._onDidDispose=new m.Emitter,this.onDidDispose=this._onDidDispose.event;const u=this._options.accessibilityProvider&&this._options.accessibilityProvider.getWidgetRole?null===(s=this._options.accessibilityProvider)||void 0===s?void 0:s.getWidgetRole():"list";this.selection=new k("listbox"!==u);const h=[this.focus.renderer,this.selection.renderer];this.accessibilityProvider=o.accessibilityProvider,this.accessibilityProvider&&(h.push(new $(this.accessibilityProvider)),null===(l=(a=this.accessibilityProvider).onDidChangeActiveDescendant)||void 0===l||l.call(a,this.onDidChangeActiveDescendant,this,this.disposables)),n=n.map((e=>new Y(e.templateId,[...h,e])));const g={...o,dnd:o.dnd&&new J(this,o.dnd)};if(this.view=this.createListView(t,i,n,g),this.view.domNode.setAttribute("role",u),o.styleController)this.styleController=o.styleController(this.view.domId);else{const e=(0,r.createStyleSheet)(this.view.domNode);this.styleController=new Q(e,this.view.domId)}if(this.spliceable=new d.CombinedSpliceable([new D(this.focus,this.view,o.identityProvider),new D(this.selection,this.view,o.identityProvider),new D(this.anchor,this.view,o.identityProvider),this.view]),this.disposables.add(this.focus),this.disposables.add(this.selection),this.disposables.add(this.anchor),this.disposables.add(this.view),this.disposables.add(this._onDidDispose),this.disposables.add(new z(this,this.view)),("boolean"!=typeof o.keyboardSupport||o.keyboardSupport)&&(this.keyboardController=new O(this,this.view,o),this.disposables.add(this.keyboardController)),o.keyboardNavigationLabelProvider){const e=o.keyboardNavigationDelegate||F;this.typeNavigationController=new P(this,this.view,o.keyboardNavigationLabelProvider,null!==(c=o.keyboardNavigationEventFilter)&&void 0!==c?c:()=>!0,e),this.disposables.add(this.typeNavigationController)}this.mouseController=this.createMouseController(o),this.disposables.add(this.mouseController),this.onDidChangeFocus(this._onFocusChange,this,this.disposables),this.onDidChangeSelection(this._onSelectionChange,this,this.disposables),this.accessibilityProvider&&(this.ariaLabel=this.accessibilityProvider.getWidgetAriaLabel()),!1!==this._options.multipleSelectionSupport&&this.view.domNode.setAttribute("aria-multiselectable","true")}createListView(e,t,i,n){return new w.ListView(e,t,i,n)}createMouseController(e){return new U(this)}updateOptions(e={}){var t,i;this._options={...this._options,...e},null===(t=this.typeNavigationController)||void 0===t||t.updateOptions(this._options),void 0!==this._options.multipleSelectionController&&(this._options.multipleSelectionSupport?this.view.domNode.setAttribute("aria-multiselectable","true"):this.view.domNode.removeAttribute("aria-multiselectable")),this.mouseController.updateOptions(e),null===(i=this.keyboardController)||void 0===i||i.updateOptions(e),this.view.updateOptions(e)}get options(){return this._options}splice(e,t,i=[]){if(e<0||e>this.view.length)throw new C.ListError(this.user,`Invalid start index: ${e}`);if(t<0)throw new C.ListError(this.user,`Invalid delete count: ${t}`);0===t&&0===i.length||this.eventBufferer.bufferEvents((()=>this.spliceable.splice(e,t,i)))}rerender(){this.view.rerender()}element(e){return this.view.element(e)}indexOf(e){return this.view.indexOf(e)}get length(){return this.view.length}get contentHeight(){return this.view.contentHeight}get onDidChangeContentHeight(){return this.view.onDidChangeContentHeight}get scrollTop(){return this.view.getScrollTop()}set scrollTop(e){this.view.setScrollTop(e)}get scrollHeight(){return this.view.scrollHeight}get renderHeight(){return this.view.renderHeight}get firstVisibleIndex(){return this.view.firstVisibleIndex}get ariaLabel(){return this._ariaLabel}set ariaLabel(e){this._ariaLabel=e,this.view.domNode.setAttribute("aria-label",e)}domFocus(){this.view.domNode.focus({preventScroll:!0})}layout(e,t){this.view.layout(e,t)}setSelection(e,t){for(const t of e)if(t<0||t>=this.length)throw new C.ListError(this.user,`Invalid index ${t}`);this.selection.set(e,t)}getSelection(){return this.selection.get()}getSelectedElements(){return this.getSelection().map((e=>this.view.element(e)))}setAnchor(e){if(void 0!==e){if(e<0||e>=this.length)throw new C.ListError(this.user,`Invalid index ${e}`);this.anchor.set([e])}else this.anchor.set([])}getAnchor(){return(0,u.firstOrDefault)(this.anchor.get(),void 0)}getAnchorElement(){const e=this.getAnchor();return void 0===e?void 0:this.element(e)}setFocus(e,t){for(const t of e)if(t<0||t>=this.length)throw new C.ListError(this.user,`Invalid index ${t}`);this.focus.set(e,t)}focusNext(e=1,t=!1,i,n){if(0===this.length)return;const o=this.focus.get(),r=this.findNextIndex(o.length>0?o[0]+e:0,t,n);r>-1&&this.setFocus([r],i)}focusPrevious(e=1,t=!1,i,n){if(0===this.length)return;const o=this.focus.get(),r=this.findPreviousIndex(o.length>0?o[0]-e:0,t,n);r>-1&&this.setFocus([r],i)}async focusNextPage(e,t){let i=this.view.indexAt(this.view.getScrollTop()+this.view.renderHeight);i=0===i?0:i-1;const n=this.getFocus()[0];if(n!==i&&(void 0===n||i>n)){const o=this.findPreviousIndex(i,!1,t);o>-1&&n!==o?this.setFocus([o],e):this.setFocus([i],e)}else{const o=this.view.getScrollTop();let r=o+this.view.renderHeight;i>n&&(r-=this.view.elementHeight(i)),this.view.setScrollTop(r),this.view.getScrollTop()!==o&&(this.setFocus([]),await(0,h.timeout)(0),await this.focusNextPage(e,t))}}async focusPreviousPage(e,t){let i;const n=this.view.getScrollTop();i=0===n?this.view.indexAt(n):this.view.indexAfter(n-1);const o=this.getFocus()[0];if(o!==i&&(void 0===o||o>=i)){const n=this.findNextIndex(i,!1,t);n>-1&&o!==n?this.setFocus([n],e):this.setFocus([i],e)}else{const i=n;this.view.setScrollTop(n-this.view.renderHeight),this.view.getScrollTop()!==i&&(this.setFocus([]),await(0,h.timeout)(0),await this.focusPreviousPage(e,t))}}focusLast(e,t){if(0===this.length)return;const i=this.findPreviousIndex(this.length-1,!1,t);i>-1&&this.setFocus([i],e)}focusFirst(e,t){this.focusNth(0,e,t)}focusNth(e,t,i){if(0===this.length)return;const n=this.findNextIndex(e,!1,i);n>-1&&this.setFocus([n],t)}findNextIndex(e,t=!1,i){for(let n=0;n<this.length;n++){if(e>=this.length&&!t)return-1;if(e%=this.length,!i||i(this.element(e)))return e;e++}return-1}findPreviousIndex(e,t=!1,i){for(let n=0;n<this.length;n++){if(e<0&&!t)return-1;if(e=(this.length+e%this.length)%this.length,!i||i(this.element(e)))return e;e--}return-1}getFocus(){return this.focus.get()}getFocusedElements(){return this.getFocus().map((e=>this.view.element(e)))}reveal(e,t,i=0){if(e<0||e>=this.length)throw new C.ListError(this.user,`Invalid index ${e}`);const n=this.view.getScrollTop(),o=this.view.elementTop(e),r=this.view.elementHeight(e);if((0,A.isNumber)(t)){const e=r-this.view.renderHeight+i;this.view.setScrollTop(e*(0,v.clamp)(t,0,1)+o-i)}else{const e=o+r,t=n+this.view.renderHeight;o<n+i&&e>=t||(o<n+i||e>=t&&r>=this.view.renderHeight?this.view.setScrollTop(o-i):e>=t&&this.view.setScrollTop(e-this.view.renderHeight))}}getRelativeTop(e,t=0){if(e<0||e>=this.length)throw new C.ListError(this.user,`Invalid index ${e}`);const i=this.view.getScrollTop(),n=this.view.elementTop(e),o=this.view.elementHeight(e);if(n<i+t||n+o>i+this.view.renderHeight)return null;const r=o-this.view.renderHeight+t;return Math.abs((i+t-n)/r)}getHTMLElement(){return this.view.domNode}getScrollableElement(){return this.view.scrollableElementDomNode}getElementID(e){return this.view.getElementDomId(e)}getElementTop(e){return this.view.elementTop(e)}style(e){this.styleController.style(e)}toListEvent({indexes:e,browserEvent:t}){return{indexes:e,elements:e.map((e=>this.view.element(e))),browserEvent:t}}_onFocusChange(){const e=this.focus.get();this.view.domNode.classList.toggle("element-focused",e.length>0),this.onDidChangeActiveDescendant()}onDidChangeActiveDescendant(){var e;const t=this.focus.get();if(t.length>0){let i;(null===(e=this.accessibilityProvider)||void 0===e?void 0:e.getActiveDescendantId)&&(i=this.accessibilityProvider.getActiveDescendantId(this.view.element(t[0]))),this.view.domNode.setAttribute("aria-activedescendant",i||this.view.getElementDomId(t[0]))}else this.view.domNode.removeAttribute("aria-activedescendant")}_onSelectionChange(){const e=this.selection.get();this.view.domNode.classList.toggle("selection-none",0===e.length),this.view.domNode.classList.toggle("selection-single",1===e.length),this.view.domNode.classList.toggle("selection-multiple",e.length>1)}dispose(){this._onDidDispose.fire(),this.disposables.dispose(),this._onDidDispose.dispose()}}S([p.memoize],Z.prototype,"onDidChangeFocus",null),S([p.memoize],Z.prototype,"onDidChangeSelection",null),S([p.memoize],Z.prototype,"onContextMenu",null),S([p.memoize],Z.prototype,"onKeyDown",null),S([p.memoize],Z.prototype,"onDidFocus",null)},37218:function(e,t,i){"use strict";i.r(t),i.d(t,{RangeMap:function(){return a},consolidate:function(){return s},groupIntersect:function(){return o},shift:function(){return r}});var n=i(83682);function o(e,t){const i=[];for(const o of t){if(e.start>=o.range.end)continue;if(e.end<o.range.start)break;const t=n.Range.intersect(e,o.range);n.Range.isEmpty(t)||i.push({range:t,size:o.size})}return i}function r({start:e,end:t},i){return{start:e+i,end:t+i}}function s(e){const t=[];let i=null;for(const n of e){const e=n.range.start,o=n.range.end,r=n.size;i&&r===i.size?i.range.end=o:(i={range:{start:e,end:o},size:r},t.push(i))}return t}class a{get paddingTop(){return this._paddingTop}set paddingTop(e){this._size=this._size+e-this._paddingTop,this._paddingTop=e}constructor(e){this.groups=[],this._size=0,this._paddingTop=0,this._paddingTop=null!=e?e:0,this._size=this._paddingTop}splice(e,t,i=[]){const n=i.length-t,a=o({start:0,end:e},this.groups),l=o({start:e+t,end:Number.POSITIVE_INFINITY},this.groups).map((e=>({range:r(e.range,n),size:e.size}))),c=i.map(((t,i)=>({range:{start:e+i,end:e+i+1},size:t.size})));this.groups=function(...e){return s(e.reduce(((e,t)=>e.concat(t)),[]))}(a,c,l),this._size=this._paddingTop+this.groups.reduce(((e,t)=>e+t.size*(t.range.end-t.range.start)),0)}get count(){const e=this.groups.length;return e?this.groups[e-1].range.end:0}get size(){return this._size}indexAt(e){if(e<0)return-1;if(e<this._paddingTop)return 0;let t=0,i=this._paddingTop;for(const n of this.groups){const o=n.range.end-n.range.start,r=i+o*n.size;if(e<r)return t+Math.floor((e-i)/n.size);t+=o,i=r}return t}indexAfter(e){return Math.min(this.indexAt(e)+1,this.count)}positionAt(e){if(e<0)return-1;let t=0,i=0;for(const n of this.groups){const o=n.range.end-n.range.start,r=i+o;if(e<r)return this._paddingTop+t+(e-i)*n.size;t+=o*n.size,i=r}return-1}}},1056:function(e,t,i){"use strict";i.r(t),i.d(t,{RowCache:function(){return o}});var n=i(96747);class o{constructor(e){this.renderers=e,this.cache=new Map,this.transactionNodesPendingRemoval=new Set,this.inTransaction=!1}alloc(e){let t=this.getTemplateCache(e).pop(),i=!1;if(t)i=this.transactionNodesPendingRemoval.has(t.domNode),i&&this.transactionNodesPendingRemoval.delete(t.domNode);else{const i=(0,n.$)(".monaco-list-row");t={domNode:i,templateId:e,templateData:this.getRenderer(e).renderTemplate(i)}}return{row:t,isReusingConnectedDomNode:i}}release(e){e&&this.releaseRow(e)}transact(e){if(this.inTransaction)throw new Error("Already in transaction");this.inTransaction=!0;try{e()}finally{for(const e of this.transactionNodesPendingRemoval)this.doRemoveNode(e);this.transactionNodesPendingRemoval.clear(),this.inTransaction=!1}}releaseRow(e){const{domNode:t,templateId:i}=e;t&&(this.inTransaction?this.transactionNodesPendingRemoval.add(t):this.doRemoveNode(t));this.getTemplateCache(i).push(e)}doRemoveNode(e){e.classList.remove("scrolling"),function(e){var t;try{null===(t=e.parentElement)||void 0===t||t.removeChild(e)}catch(e){}}(e)}getTemplateCache(e){let t=this.cache.get(e);return t||(t=[],this.cache.set(e,t)),t}dispose(){this.cache.forEach(((e,t)=>{for(const i of e){this.getRenderer(t).disposeTemplate(i.templateData),i.templateData=null}})),this.cache.clear(),this.transactionNodesPendingRemoval.clear()}getRenderer(e){const t=this.renderers.get(e);if(!t)throw new Error(`No renderer found for ${e}`);return t}}},25218:function(e,t,i){"use strict";i.r(t),i.d(t,{CombinedSpliceable:function(){return n}});class n{constructor(e){this.spliceables=e}splice(e,t,i){this.spliceables.forEach((n=>n.splice(e,t,i)))}}},96959:function(e,t,i){"use strict";i.r(t),i.d(t,{Direction:function(){return w},MENU_ESCAPED_MNEMONIC_REGEX:function(){return C},MENU_MNEMONIC_REGEX:function(){return A},Menu:function(){return y},cleanMnemonic:function(){return k},formatRule:function(){return D}});var n=i(76736),o=i(4043),r=i(96747),s=i(8769),a=i(5642),l=i(31532),c=i(61009),d=i(96205),u=i(34309),h=i(60969),g=i(66129),p=i(56087),m=i(27269),f=i(69373),b=i(68921),v=i(66719),_=i(91482);const A=/\(&([^\s&])\)|(^|[^&])&([^\s&])/,C=/(&amp;)?(&amp;)([^\s&])/g;var w;!function(e){e[e.Right=0]="Right",e[e.Left=1]="Left"}(w||(w={}));class y extends l.ActionBar{constructor(e,t,i,n){e.classList.add("monaco-menu-container"),e.setAttribute("role","presentation");const a=document.createElement("div");a.classList.add("monaco-menu"),a.setAttribute("role","presentation"),super(a,{orientation:1,actionViewItemProvider:e=>this.doGetActionViewItem(e,i,l),context:i.context,actionRunner:i.actionRunner,ariaLabel:i.ariaLabel,ariaRole:"menu",focusOnlyEnabledItems:!0,triggerKeys:{keys:[3,...v.isMacintosh||v.isLinux?[10]:[]],keyDown:!0}}),this.menuStyles=n,this.menuElement=a,this.actionsList.tabIndex=0,this.initializeOrUpdateStyleSheet(e,n),this._register(o.Gesture.addTarget(a)),this._register((0,r.addDisposableListener)(a,r.EventType.KEY_DOWN,(e=>{new s.StandardKeyboardEvent(e).equals(2)&&e.preventDefault()}))),i.enableMnemonics&&this._register((0,r.addDisposableListener)(a,r.EventType.KEY_DOWN,(e=>{const t=e.key.toLocaleLowerCase();if(this.mnemonics.has(t)){r.EventHelper.stop(e,!0);const i=this.mnemonics.get(t);if(1===i.length&&(i[0]instanceof x&&i[0].container&&this.focusItemByElement(i[0].container),i[0].onClick(e)),i.length>1){const e=i.shift();e&&e.container&&(this.focusItemByElement(e.container),i.push(e)),this.mnemonics.set(t,i)}}}))),v.isLinux&&this._register((0,r.addDisposableListener)(a,r.EventType.KEY_DOWN,(e=>{const t=new s.StandardKeyboardEvent(e);t.equals(14)||t.equals(11)?(this.focusedItem=this.viewItems.length-1,this.focusNext(),r.EventHelper.stop(e,!0)):(t.equals(13)||t.equals(12))&&(this.focusedItem=0,this.focusPrevious(),r.EventHelper.stop(e,!0))}))),this._register((0,r.addDisposableListener)(this.domNode,r.EventType.MOUSE_OUT,(e=>{const t=e.relatedTarget;(0,r.isAncestor)(t,this.domNode)||(this.focusedItem=void 0,this.updateFocus(),e.stopPropagation())}))),this._register((0,r.addDisposableListener)(this.actionsList,r.EventType.MOUSE_OVER,(e=>{let t=e.target;if(t&&(0,r.isAncestor)(t,this.actionsList)&&t!==this.actionsList){for(;t.parentElement!==this.actionsList&&null!==t.parentElement;)t=t.parentElement;if(t.classList.contains("action-item")){const e=this.focusedItem;this.setFocusedItem(t),e!==this.focusedItem&&this.updateFocus()}}}))),this._register(o.Gesture.addTarget(this.actionsList)),this._register((0,r.addDisposableListener)(this.actionsList,o.EventType.Tap,(e=>{let t=e.initialTarget;if(t&&(0,r.isAncestor)(t,this.actionsList)&&t!==this.actionsList){for(;t.parentElement!==this.actionsList&&null!==t.parentElement;)t=t.parentElement;if(t.classList.contains("action-item")){const e=this.focusedItem;this.setFocusedItem(t),e!==this.focusedItem&&this.updateFocus()}}})));const l={parent:this};this.mnemonics=new Map,this.scrollableElement=this._register(new u.DomScrollableElement(a,{alwaysConsumeMouseWheel:!0,horizontal:2,vertical:3,verticalScrollbarSize:7,handleMouseWheel:!0,useShadows:!0}));const c=this.scrollableElement.getDomNode();c.style.position="",this.styleScrollElement(c,n),this._register((0,r.addDisposableListener)(a,o.EventType.Change,(e=>{r.EventHelper.stop(e,!0);const t=this.scrollableElement.getScrollPosition().scrollTop;this.scrollableElement.setScrollPosition({scrollTop:t-e.translationY})}))),this._register((0,r.addDisposableListener)(c,r.EventType.MOUSE_UP,(e=>{e.preventDefault()})));const d=(0,r.getWindow)(e);a.style.maxHeight=`${Math.max(10,d.innerHeight-e.getBoundingClientRect().top-35)}px`,t=t.filter((e=>{var t;return!(null===(t=i.submenuIds)||void 0===t?void 0:t.has(e.id))||(console.warn(`Found submenu cycle: ${e.id}`),!1)})),this.push(t,{icon:!0,label:!0,isMenu:!0}),e.appendChild(this.scrollableElement.getDomNode()),this.scrollableElement.scanDomNode(),this.viewItems.filter((e=>!(e instanceof E))).forEach(((e,t,i)=>{e.updatePositionInSet(t+1,i.length)}))}initializeOrUpdateStyleSheet(e,t){this.styleSheet||((0,r.isInShadowDOM)(e)?this.styleSheet=(0,r.createStyleSheet)(e):(y.globalStyleSheet||(y.globalStyleSheet=(0,r.createStyleSheet)()),this.styleSheet=y.globalStyleSheet)),this.styleSheet.textContent=function(e,t){let i=`\n.monaco-menu {\n\tfont-size: 13px;\n\tborder-radius: 5px;\n\tmin-width: 160px;\n}\n\n${D(p.Codicon.menuSelection)}\n${D(p.Codicon.menuSubmenu)}\n\n.monaco-menu .monaco-action-bar {\n\ttext-align: right;\n\toverflow: hidden;\n\twhite-space: nowrap;\n}\n\n.monaco-menu .monaco-action-bar .actions-container {\n\tdisplay: flex;\n\tmargin: 0 auto;\n\tpadding: 0;\n\twidth: 100%;\n\tjustify-content: flex-end;\n}\n\n.monaco-menu .monaco-action-bar.vertical .actions-container {\n\tdisplay: inline-block;\n}\n\n.monaco-menu .monaco-action-bar.reverse .actions-container {\n\tflex-direction: row-reverse;\n}\n\n.monaco-menu .monaco-action-bar .action-item {\n\tcursor: pointer;\n\tdisplay: inline-block;\n\ttransition: transform 50ms ease;\n\tposition: relative;  /* DO NOT REMOVE - this is the key to preventing the ghosting icon bug in Chrome 42 */\n}\n\n.monaco-menu .monaco-action-bar .action-item.disabled {\n\tcursor: default;\n}\n\n.monaco-menu .monaco-action-bar.animated .action-item.active {\n\ttransform: scale(1.272019649, 1.272019649); /* 1.272019649 = √φ */\n}\n\n.monaco-menu .monaco-action-bar .action-item .icon,\n.monaco-menu .monaco-action-bar .action-item .codicon {\n\tdisplay: inline-block;\n}\n\n.monaco-menu .monaco-action-bar .action-item .codicon {\n\tdisplay: flex;\n\talign-items: center;\n}\n\n.monaco-menu .monaco-action-bar .action-label {\n\tfont-size: 11px;\n\tmargin-right: 4px;\n}\n\n.monaco-menu .monaco-action-bar .action-item.disabled .action-label,\n.monaco-menu .monaco-action-bar .action-item.disabled .action-label:hover {\n\tcolor: var(--vscode-disabledForeground);\n}\n\n/* Vertical actions */\n\n.monaco-menu .monaco-action-bar.vertical {\n\ttext-align: left;\n}\n\n.monaco-menu .monaco-action-bar.vertical .action-item {\n\tdisplay: block;\n}\n\n.monaco-menu .monaco-action-bar.vertical .action-label.separator {\n\tdisplay: block;\n\tborder-bottom: 1px solid var(--vscode-menu-separatorBackground);\n\tpadding-top: 1px;\n\tpadding: 30px;\n}\n\n.monaco-menu .secondary-actions .monaco-action-bar .action-label {\n\tmargin-left: 6px;\n}\n\n/* Action Items */\n.monaco-menu .monaco-action-bar .action-item.select-container {\n\toverflow: hidden; /* somehow the dropdown overflows its container, we prevent it here to not push */\n\tflex: 1;\n\tmax-width: 170px;\n\tmin-width: 60px;\n\tdisplay: flex;\n\talign-items: center;\n\tjustify-content: center;\n\tmargin-right: 10px;\n}\n\n.monaco-menu .monaco-action-bar.vertical {\n\tmargin-left: 0;\n\toverflow: visible;\n}\n\n.monaco-menu .monaco-action-bar.vertical .actions-container {\n\tdisplay: block;\n}\n\n.monaco-menu .monaco-action-bar.vertical .action-item {\n\tpadding: 0;\n\ttransform: none;\n\tdisplay: flex;\n}\n\n.monaco-menu .monaco-action-bar.vertical .action-item.active {\n\ttransform: none;\n}\n\n.monaco-menu .monaco-action-bar.vertical .action-menu-item {\n\tflex: 1 1 auto;\n\tdisplay: flex;\n\theight: 2em;\n\talign-items: center;\n\tposition: relative;\n\tmargin: 0 4px;\n\tborder-radius: 4px;\n}\n\n.monaco-menu .monaco-action-bar.vertical .action-menu-item:hover .keybinding,\n.monaco-menu .monaco-action-bar.vertical .action-menu-item:focus .keybinding {\n\topacity: unset;\n}\n\n.monaco-menu .monaco-action-bar.vertical .action-label {\n\tflex: 1 1 auto;\n\ttext-decoration: none;\n\tpadding: 0 1em;\n\tbackground: none;\n\tfont-size: 12px;\n\tline-height: 1;\n}\n\n.monaco-menu .monaco-action-bar.vertical .keybinding,\n.monaco-menu .monaco-action-bar.vertical .submenu-indicator {\n\tdisplay: inline-block;\n\tflex: 2 1 auto;\n\tpadding: 0 1em;\n\ttext-align: right;\n\tfont-size: 12px;\n\tline-height: 1;\n}\n\n.monaco-menu .monaco-action-bar.vertical .submenu-indicator {\n\theight: 100%;\n}\n\n.monaco-menu .monaco-action-bar.vertical .submenu-indicator.codicon {\n\tfont-size: 16px !important;\n\tdisplay: flex;\n\talign-items: center;\n}\n\n.monaco-menu .monaco-action-bar.vertical .submenu-indicator.codicon::before {\n\tmargin-left: auto;\n\tmargin-right: -20px;\n}\n\n.monaco-menu .monaco-action-bar.vertical .action-item.disabled .keybinding,\n.monaco-menu .monaco-action-bar.vertical .action-item.disabled .submenu-indicator {\n\topacity: 0.4;\n}\n\n.monaco-menu .monaco-action-bar.vertical .action-label:not(.separator) {\n\tdisplay: inline-block;\n\tbox-sizing: border-box;\n\tmargin: 0;\n}\n\n.monaco-menu .monaco-action-bar.vertical .action-item {\n\tposition: static;\n\toverflow: visible;\n}\n\n.monaco-menu .monaco-action-bar.vertical .action-item .monaco-submenu {\n\tposition: absolute;\n}\n\n.monaco-menu .monaco-action-bar.vertical .action-label.separator {\n\twidth: 100%;\n\theight: 0px !important;\n\topacity: 1;\n}\n\n.monaco-menu .monaco-action-bar.vertical .action-label.separator.text {\n\tpadding: 0.7em 1em 0.1em 1em;\n\tfont-weight: bold;\n\topacity: 1;\n}\n\n.monaco-menu .monaco-action-bar.vertical .action-label:hover {\n\tcolor: inherit;\n}\n\n.monaco-menu .monaco-action-bar.vertical .menu-item-check {\n\tposition: absolute;\n\tvisibility: hidden;\n\twidth: 1em;\n\theight: 100%;\n}\n\n.monaco-menu .monaco-action-bar.vertical .action-menu-item.checked .menu-item-check {\n\tvisibility: visible;\n\tdisplay: flex;\n\talign-items: center;\n\tjustify-content: center;\n}\n\n/* Context Menu */\n\n.context-view.monaco-menu-container {\n\toutline: 0;\n\tborder: none;\n\tanimation: fadeIn 0.083s linear;\n\t-webkit-app-region: no-drag;\n}\n\n.context-view.monaco-menu-container :focus,\n.context-view.monaco-menu-container .monaco-action-bar.vertical:focus,\n.context-view.monaco-menu-container .monaco-action-bar.vertical :focus {\n\toutline: 0;\n}\n\n.hc-black .context-view.monaco-menu-container,\n.hc-light .context-view.monaco-menu-container,\n:host-context(.hc-black) .context-view.monaco-menu-container,\n:host-context(.hc-light) .context-view.monaco-menu-container {\n\tbox-shadow: none;\n}\n\n.hc-black .monaco-menu .monaco-action-bar.vertical .action-item.focused,\n.hc-light .monaco-menu .monaco-action-bar.vertical .action-item.focused,\n:host-context(.hc-black) .monaco-menu .monaco-action-bar.vertical .action-item.focused,\n:host-context(.hc-light) .monaco-menu .monaco-action-bar.vertical .action-item.focused {\n\tbackground: none;\n}\n\n/* Vertical Action Bar Styles */\n\n.monaco-menu .monaco-action-bar.vertical {\n\tpadding: 4px 0;\n}\n\n.monaco-menu .monaco-action-bar.vertical .action-menu-item {\n\theight: 2em;\n}\n\n.monaco-menu .monaco-action-bar.vertical .action-label:not(.separator),\n.monaco-menu .monaco-action-bar.vertical .keybinding {\n\tfont-size: inherit;\n\tpadding: 0 2em;\n}\n\n.monaco-menu .monaco-action-bar.vertical .menu-item-check {\n\tfont-size: inherit;\n\twidth: 2em;\n}\n\n.monaco-menu .monaco-action-bar.vertical .action-label.separator {\n\tfont-size: inherit;\n\tmargin: 5px 0 !important;\n\tpadding: 0;\n\tborder-radius: 0;\n}\n\n.linux .monaco-menu .monaco-action-bar.vertical .action-label.separator,\n:host-context(.linux) .monaco-menu .monaco-action-bar.vertical .action-label.separator {\n\tmargin-left: 0;\n\tmargin-right: 0;\n}\n\n.monaco-menu .monaco-action-bar.vertical .submenu-indicator {\n\tfont-size: 60%;\n\tpadding: 0 1.8em;\n}\n\n.linux .monaco-menu .monaco-action-bar.vertical .submenu-indicator,\n:host-context(.linux) .monaco-menu .monaco-action-bar.vertical .submenu-indicator {\n\theight: 100%;\n\tmask-size: 10px 10px;\n\t-webkit-mask-size: 10px 10px;\n}\n\n.monaco-menu .action-item {\n\tcursor: default;\n}`;if(t){i+="\n\t\t\t/* Arrows */\n\t\t\t.monaco-scrollable-element > .scrollbar > .scra {\n\t\t\t\tcursor: pointer;\n\t\t\t\tfont-size: 11px !important;\n\t\t\t}\n\n\t\t\t.monaco-scrollable-element > .visible {\n\t\t\t\topacity: 1;\n\n\t\t\t\t/* Background rule added for IE9 - to allow clicks on dom node */\n\t\t\t\tbackground:rgba(0,0,0,0);\n\n\t\t\t\ttransition: opacity 100ms linear;\n\t\t\t}\n\t\t\t.monaco-scrollable-element > .invisible {\n\t\t\t\topacity: 0;\n\t\t\t\tpointer-events: none;\n\t\t\t}\n\t\t\t.monaco-scrollable-element > .invisible.fade {\n\t\t\t\ttransition: opacity 800ms linear;\n\t\t\t}\n\n\t\t\t/* Scrollable Content Inset Shadow */\n\t\t\t.monaco-scrollable-element > .shadow {\n\t\t\t\tposition: absolute;\n\t\t\t\tdisplay: none;\n\t\t\t}\n\t\t\t.monaco-scrollable-element > .shadow.top {\n\t\t\t\tdisplay: block;\n\t\t\t\ttop: 0;\n\t\t\t\tleft: 3px;\n\t\t\t\theight: 3px;\n\t\t\t\twidth: 100%;\n\t\t\t}\n\t\t\t.monaco-scrollable-element > .shadow.left {\n\t\t\t\tdisplay: block;\n\t\t\t\ttop: 3px;\n\t\t\t\tleft: 0;\n\t\t\t\theight: 100%;\n\t\t\t\twidth: 3px;\n\t\t\t}\n\t\t\t.monaco-scrollable-element > .shadow.top-left-corner {\n\t\t\t\tdisplay: block;\n\t\t\t\ttop: 0;\n\t\t\t\tleft: 0;\n\t\t\t\theight: 3px;\n\t\t\t\twidth: 3px;\n\t\t\t}\n\t\t";const t=e.scrollbarShadow;t&&(i+=`\n\t\t\t\t.monaco-scrollable-element > .shadow.top {\n\t\t\t\t\tbox-shadow: ${t} 0 6px 6px -6px inset;\n\t\t\t\t}\n\n\t\t\t\t.monaco-scrollable-element > .shadow.left {\n\t\t\t\t\tbox-shadow: ${t} 6px 0 6px -6px inset;\n\t\t\t\t}\n\n\t\t\t\t.monaco-scrollable-element > .shadow.top.left {\n\t\t\t\t\tbox-shadow: ${t} 6px 6px 6px -6px inset;\n\t\t\t\t}\n\t\t\t`);const n=e.scrollbarSliderBackground;n&&(i+=`\n\t\t\t\t.monaco-scrollable-element > .scrollbar > .slider {\n\t\t\t\t\tbackground: ${n};\n\t\t\t\t}\n\t\t\t`);const o=e.scrollbarSliderHoverBackground;o&&(i+=`\n\t\t\t\t.monaco-scrollable-element > .scrollbar > .slider:hover {\n\t\t\t\t\tbackground: ${o};\n\t\t\t\t}\n\t\t\t`);const r=e.scrollbarSliderActiveBackground;r&&(i+=`\n\t\t\t\t.monaco-scrollable-element > .scrollbar > .slider.active {\n\t\t\t\t\tbackground: ${r};\n\t\t\t\t}\n\t\t\t`)}return i}(t,(0,r.isInShadowDOM)(e))}styleScrollElement(e,t){var i,n;const o=null!==(i=t.foregroundColor)&&void 0!==i?i:"",r=null!==(n=t.backgroundColor)&&void 0!==n?n:"",s=t.borderColor?`1px solid ${t.borderColor}`:"",a=t.shadowColor?`0 2px 8px ${t.shadowColor}`:"";e.style.outline=s,e.style.borderRadius="5px",e.style.color=o,e.style.backgroundColor=r,e.style.boxShadow=a}getContainer(){return this.scrollableElement.getDomNode()}get onScroll(){return this.scrollableElement.onScroll}focusItemByElement(e){const t=this.focusedItem;this.setFocusedItem(e),t!==this.focusedItem&&this.updateFocus()}setFocusedItem(e){for(let t=0;t<this.actionsList.children.length;t++){if(e===this.actionsList.children[t]){this.focusedItem=t;break}}}updateFocus(e){super.updateFocus(e,!0,!0),void 0!==this.focusedItem&&this.scrollableElement.setScrollPosition({scrollTop:Math.round(this.menuElement.scrollTop)})}doGetActionViewItem(e,t,i){if(e instanceof h.Separator)return new E(t.context,e,{icon:!0},this.menuStyles);if(e instanceof h.SubmenuAction){const n=new x(e,e.actions,i,{...t,submenuIds:new Set([...t.submenuIds||[],e.id])},this.menuStyles);if(t.enableMnemonics){const e=n.getMnemonic();if(e&&n.isEnabled()){let t=[];this.mnemonics.has(e)&&(t=this.mnemonics.get(e)),t.push(n),this.mnemonics.set(e,t)}}return n}{const i={enableMnemonics:t.enableMnemonics,useEventAsContext:t.useEventAsContext};if(t.getKeyBinding){const n=t.getKeyBinding(e);if(n){const e=n.getLabel();e&&(i.keybinding=e)}}const n=new S(t.context,e,i,this.menuStyles);if(t.enableMnemonics){const e=n.getMnemonic();if(e&&n.isEnabled()){let t=[];this.mnemonics.has(e)&&(t=this.mnemonics.get(e)),t.push(n),this.mnemonics.set(e,t)}}return n}}}class S extends c.BaseActionViewItem{constructor(e,t,i,o){if(i.isMenu=!0,super(t,t,i),this.menuStyle=o,this.options=i,this.options.icon=void 0!==i.icon&&i.icon,this.options.label=void 0===i.label||i.label,this.cssClass="",this.options.label&&i.enableMnemonics){const e=this.action.label;if(e){const t=A.exec(e);t&&(this.mnemonic=(t[1]?t[1]:t[3]).toLocaleLowerCase())}}this.runOnceToEnableMouseUp=new g.RunOnceScheduler((()=>{this.element&&(this._register((0,r.addDisposableListener)(this.element,r.EventType.MOUSE_UP,(e=>{if(r.EventHelper.stop(e,!0),n.isFirefox){if(new a.StandardMouseEvent((0,r.getWindow)(this.element),e).rightButton)return;this.onClick(e)}else setTimeout((()=>{this.onClick(e)}),0)}))),this._register((0,r.addDisposableListener)(this.element,r.EventType.CONTEXT_MENU,(e=>{r.EventHelper.stop(e,!0)}))))}),100),this._register(this.runOnceToEnableMouseUp)}render(e){super.render(e),this.element&&(this.container=e,this.item=(0,r.append)(this.element,(0,r.$)("a.action-menu-item")),this._action.id===h.Separator.ID?this.item.setAttribute("role","presentation"):(this.item.setAttribute("role","menuitem"),this.mnemonic&&this.item.setAttribute("aria-keyshortcuts",`${this.mnemonic}`)),this.check=(0,r.append)(this.item,(0,r.$)("span.menu-item-check"+m.ThemeIcon.asCSSSelector(p.Codicon.menuSelection))),this.check.setAttribute("role","none"),this.label=(0,r.append)(this.item,(0,r.$)("span.action-label")),this.options.label&&this.options.keybinding&&((0,r.append)(this.item,(0,r.$)("span.keybinding")).textContent=this.options.keybinding),this.runOnceToEnableMouseUp.schedule(),this.updateClass(),this.updateLabel(),this.updateTooltip(),this.updateEnabled(),this.updateChecked(),this.applyStyle())}blur(){super.blur(),this.applyStyle()}focus(){var e;super.focus(),null===(e=this.item)||void 0===e||e.focus(),this.applyStyle()}updatePositionInSet(e,t){this.item&&(this.item.setAttribute("aria-posinset",`${e}`),this.item.setAttribute("aria-setsize",`${t}`))}updateLabel(){var e;if(this.label&&this.options.label){(0,r.clearNode)(this.label);let t=(0,f.stripIcons)(this.action.label);if(t){const i=k(t);this.options.enableMnemonics||(t=i),this.label.setAttribute("aria-label",i.replace(/&&/g,"&"));const n=A.exec(t);if(n){t=_.escape(t),C.lastIndex=0;let i=C.exec(t);for(;i&&i[1];)i=C.exec(t);const o=e=>e.replace(/&amp;&amp;/g,"&amp;");i?this.label.append(_.ltrim(o(t.substr(0,i.index))," "),(0,r.$)("u",{"aria-hidden":"true"},i[3]),_.rtrim(o(t.substr(i.index+i[0].length))," ")):this.label.innerText=o(t).trim(),null===(e=this.item)||void 0===e||e.setAttribute("aria-keyshortcuts",(n[1]?n[1]:n[3]).toLocaleLowerCase())}else this.label.innerText=t.replace(/&&/g,"&").trim()}}}updateTooltip(){}updateClass(){this.cssClass&&this.item&&this.item.classList.remove(...this.cssClass.split(" ")),this.options.icon&&this.label?(this.cssClass=this.action.class||"",this.label.classList.add("icon"),this.cssClass&&this.label.classList.add(...this.cssClass.split(" ")),this.updateEnabled()):this.label&&this.label.classList.remove("icon")}updateEnabled(){this.action.enabled?(this.element&&(this.element.classList.remove("disabled"),this.element.removeAttribute("aria-disabled")),this.item&&(this.item.classList.remove("disabled"),this.item.removeAttribute("aria-disabled"),this.item.tabIndex=0)):(this.element&&(this.element.classList.add("disabled"),this.element.setAttribute("aria-disabled","true")),this.item&&(this.item.classList.add("disabled"),this.item.setAttribute("aria-disabled","true")))}updateChecked(){if(!this.item)return;const e=this.action.checked;this.item.classList.toggle("checked",!!e),void 0!==e?(this.item.setAttribute("role","menuitemcheckbox"),this.item.setAttribute("aria-checked",e?"true":"false")):(this.item.setAttribute("role","menuitem"),this.item.setAttribute("aria-checked",""))}getMnemonic(){return this.mnemonic}applyStyle(){const e=this.element&&this.element.classList.contains("focused"),t=e&&this.menuStyle.selectionForegroundColor?this.menuStyle.selectionForegroundColor:this.menuStyle.foregroundColor,i=e&&this.menuStyle.selectionBackgroundColor?this.menuStyle.selectionBackgroundColor:void 0,n=e&&this.menuStyle.selectionBorderColor?`1px solid ${this.menuStyle.selectionBorderColor}`:"",o=e&&this.menuStyle.selectionBorderColor?"-1px":"";this.item&&(this.item.style.color=null!=t?t:"",this.item.style.backgroundColor=null!=i?i:"",this.item.style.outline=n,this.item.style.outlineOffset=o),this.check&&(this.check.style.color=null!=t?t:"")}}class x extends S{constructor(e,t,i,n,o){super(e,e,n,o),this.submenuActions=t,this.parentData=i,this.submenuOptions=n,this.mysubmenu=null,this.submenuDisposables=this._register(new b.DisposableStore),this.mouseOver=!1,this.expandDirection=n&&void 0!==n.expandDirection?n.expandDirection:w.Right,this.showScheduler=new g.RunOnceScheduler((()=>{this.mouseOver&&(this.cleanupExistingSubmenu(!1),this.createSubmenu(!1))}),250),this.hideScheduler=new g.RunOnceScheduler((()=>{this.element&&!(0,r.isAncestor)((0,r.getActiveElement)(),this.element)&&this.parentData.submenu===this.mysubmenu&&(this.parentData.parent.focus(!1),this.cleanupExistingSubmenu(!0))}),750)}render(e){super.render(e),this.element&&(this.item&&(this.item.classList.add("monaco-submenu-item"),this.item.tabIndex=0,this.item.setAttribute("aria-haspopup","true"),this.updateAriaExpanded("false"),this.submenuIndicator=(0,r.append)(this.item,(0,r.$)("span.submenu-indicator"+m.ThemeIcon.asCSSSelector(p.Codicon.menuSubmenu))),this.submenuIndicator.setAttribute("aria-hidden","true")),this._register((0,r.addDisposableListener)(this.element,r.EventType.KEY_UP,(e=>{const t=new s.StandardKeyboardEvent(e);(t.equals(17)||t.equals(3))&&(r.EventHelper.stop(e,!0),this.createSubmenu(!0))}))),this._register((0,r.addDisposableListener)(this.element,r.EventType.KEY_DOWN,(e=>{const t=new s.StandardKeyboardEvent(e);(0,r.getActiveElement)()===this.item&&(t.equals(17)||t.equals(3))&&r.EventHelper.stop(e,!0)}))),this._register((0,r.addDisposableListener)(this.element,r.EventType.MOUSE_OVER,(e=>{this.mouseOver||(this.mouseOver=!0,this.showScheduler.schedule())}))),this._register((0,r.addDisposableListener)(this.element,r.EventType.MOUSE_LEAVE,(e=>{this.mouseOver=!1}))),this._register((0,r.addDisposableListener)(this.element,r.EventType.FOCUS_OUT,(e=>{this.element&&!(0,r.isAncestor)((0,r.getActiveElement)(),this.element)&&this.hideScheduler.schedule()}))),this._register(this.parentData.parent.onScroll((()=>{this.parentData.submenu===this.mysubmenu&&(this.parentData.parent.focus(!1),this.cleanupExistingSubmenu(!0))}))))}updateEnabled(){}onClick(e){r.EventHelper.stop(e,!0),this.cleanupExistingSubmenu(!1),this.createSubmenu(!0)}cleanupExistingSubmenu(e){if(this.parentData.submenu&&(e||this.parentData.submenu!==this.mysubmenu)){try{this.parentData.submenu.dispose()}catch(e){}this.parentData.submenu=void 0,this.updateAriaExpanded("false"),this.submenuContainer&&(this.submenuDisposables.clear(),this.submenuContainer=void 0)}}calculateSubmenuMenuLayout(e,t,i,n){const o={top:0,left:0};return o.left=(0,d.layout)(e.width,t.width,{position:n===w.Right?0:1,offset:i.left,size:i.width}),o.left>=i.left&&o.left<i.left+i.width&&(i.left+10+t.width<=e.width&&(o.left=i.left+10),i.top+=10,i.height=0),o.top=(0,d.layout)(e.height,t.height,{position:0,offset:i.top,size:0}),o.top+t.height===i.top&&o.top+i.height+t.height<=e.height&&(o.top+=i.height),o}createSubmenu(e=!0){if(this.element)if(this.parentData.submenu)this.parentData.submenu.focus(!1);else{this.updateAriaExpanded("true"),this.submenuContainer=(0,r.append)(this.element,(0,r.$)("div.monaco-submenu")),this.submenuContainer.classList.add("menubar-menu-items-holder","context-view");const t=(0,r.getWindow)(this.parentData.parent.domNode).getComputedStyle(this.parentData.parent.domNode),i=parseFloat(t.paddingTop||"0")||0;this.submenuContainer.style.zIndex="1",this.submenuContainer.style.position="fixed",this.submenuContainer.style.top="0",this.submenuContainer.style.left="0",this.parentData.submenu=new y(this.submenuContainer,this.submenuActions.length?this.submenuActions:[new h.EmptySubmenuAction],this.submenuOptions,this.menuStyle);const n=this.element.getBoundingClientRect(),o={top:n.top-i,left:n.left,height:n.height+2*i,width:n.width},a=this.submenuContainer.getBoundingClientRect(),l=(0,r.getWindow)(this.element),{top:c,left:d}=this.calculateSubmenuMenuLayout(new r.Dimension(l.innerWidth,l.innerHeight),r.Dimension.lift(a),o,this.expandDirection);this.submenuContainer.style.left=d-a.left+"px",this.submenuContainer.style.top=c-a.top+"px",this.submenuDisposables.add((0,r.addDisposableListener)(this.submenuContainer,r.EventType.KEY_UP,(e=>{new s.StandardKeyboardEvent(e).equals(15)&&(r.EventHelper.stop(e,!0),this.parentData.parent.focus(),this.cleanupExistingSubmenu(!0))}))),this.submenuDisposables.add((0,r.addDisposableListener)(this.submenuContainer,r.EventType.KEY_DOWN,(e=>{new s.StandardKeyboardEvent(e).equals(15)&&r.EventHelper.stop(e,!0)}))),this.submenuDisposables.add(this.parentData.submenu.onDidCancel((()=>{this.parentData.parent.focus(),this.cleanupExistingSubmenu(!0)}))),this.parentData.submenu.focus(e),this.mysubmenu=this.parentData.submenu}}updateAriaExpanded(e){var t;this.item&&(null===(t=this.item)||void 0===t||t.setAttribute("aria-expanded",e))}applyStyle(){super.applyStyle();const e=this.element&&this.element.classList.contains("focused")&&this.menuStyle.selectionForegroundColor?this.menuStyle.selectionForegroundColor:this.menuStyle.foregroundColor;this.submenuIndicator&&(this.submenuIndicator.style.color=null!=e?e:"")}dispose(){super.dispose(),this.hideScheduler.dispose(),this.mysubmenu&&(this.mysubmenu.dispose(),this.mysubmenu=null),this.submenuContainer&&(this.submenuContainer=void 0)}}class E extends c.ActionViewItem{constructor(e,t,i,n){super(e,t,i),this.menuStyles=n}render(e){super.render(e),this.label&&(this.label.style.borderBottomColor=this.menuStyles.separatorColor?`${this.menuStyles.separatorColor}`:"")}}function k(e){const t=A,i=t.exec(e);if(!i)return e;const n=!i[1];return e.replace(t,n?"$2$3":"").trim()}function D(e){const t=(0,p.getCodiconFontCharacters)()[e.id];return`.codicon-${e.id}:before { content: '\\${t.toString(16)}'; }`}},16011:function(e,t,i){"use strict";i.r(t),i.d(t,{MOUSE_CURSOR_TEXT_CSS_CLASS_NAME:function(){return b}});var n=i(93379),o=i.n(n),r=i(7795),s=i.n(r),a=i(90569),l=i.n(a),c=i(3565),d=i.n(c),u=i(19216),h=i.n(u),g=i(44589),p=i.n(g),m=i(58322),f={};f.styleTagTransform=p(),f.setAttributes=d(),f.insert=l().bind(null,"head"),f.domAPI=s(),f.insertStyleElement=h();o()(m.Z,f),m.Z&&m.Z.locals&&m.Z.locals;const b="monaco-mouse-cursor-text"},81449:function(e,t,i){"use strict";i.r(t),i.d(t,{ProgressBar:function(){return x}});var n=i(96747),o=i(66129),r=i(68921),s=i(93379),a=i.n(s),l=i(7795),c=i.n(l),d=i(90569),u=i.n(d),h=i(3565),g=i.n(h),p=i(19216),m=i.n(p),f=i(44589),b=i.n(f),v=i(41227),_={};_.styleTagTransform=b(),_.setAttributes=g(),_.insert=u().bind(null,"head"),_.domAPI=c(),_.insertStyleElement=m();a()(v.Z,_),v.Z&&v.Z.locals&&v.Z.locals;const A="done",C="active",w="infinite",y="infinite-long-running",S="discrete";class x extends r.Disposable{constructor(e,t){super(),this.workedVal=0,this.showDelayedScheduler=this._register(new o.RunOnceScheduler((()=>(0,n.show)(this.element)),0)),this.longRunningScheduler=this._register(new o.RunOnceScheduler((()=>this.infiniteLongRunning()),x.LONG_RUNNING_INFINITE_THRESHOLD)),this.create(e,t)}create(e,t){this.element=document.createElement("div"),this.element.classList.add("monaco-progress-container"),this.element.setAttribute("role","progressbar"),this.element.setAttribute("aria-valuemin","0"),e.appendChild(this.element),this.bit=document.createElement("div"),this.bit.classList.add("progress-bit"),this.bit.style.backgroundColor=(null==t?void 0:t.progressBarBackground)||"#0E70C0",this.element.appendChild(this.bit)}off(){this.bit.style.width="inherit",this.bit.style.opacity="1",this.element.classList.remove(C,w,y,S),this.workedVal=0,this.totalWork=void 0,this.longRunningScheduler.cancel()}stop(){return this.doDone(!1)}doDone(e){return this.element.classList.add(A),this.element.classList.contains(w)?(this.bit.style.opacity="0",e?setTimeout((()=>this.off()),200):this.off()):(this.bit.style.width="inherit",e?setTimeout((()=>this.off()),200):this.off()),this}infinite(){return this.bit.style.width="2%",this.bit.style.opacity="1",this.element.classList.remove(S,A,y),this.element.classList.add(C,w),this.longRunningScheduler.schedule(),this}infiniteLongRunning(){this.element.classList.add(y)}getContainer(){return this.element}}x.LONG_RUNNING_INFINITE_THRESHOLD=1e4},59625:function(e,t,i){"use strict";i.r(t),i.d(t,{OrthogonalEdge:function(){return E},Sash:function(){return N}});var n=i(96747),o=i(50465),r=i(4043),s=i(66129),a=i(63966),l=i(63801),c=i(68921),d=i(66719),u=i(93379),h=i.n(u),g=i(7795),p=i.n(g),m=i(90569),f=i.n(m),b=i(3565),v=i.n(b),_=i(19216),A=i.n(_),C=i(44589),w=i.n(C),y=i(67054),S={};S.styleTagTransform=w(),S.setAttributes=v(),S.insert=f().bind(null,"head"),S.domAPI=p(),S.insertStyleElement=A();h()(y.Z,S),y.Z&&y.Z.locals&&y.Z.locals;var x=function(e,t,i,n){var o,r=arguments.length,s=r<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,i):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)s=Reflect.decorate(e,t,i,n);else for(var a=e.length-1;a>=0;a--)(o=e[a])&&(s=(r<3?o(s):r>3?o(t,i,s):o(t,i))||s);return r>3&&s&&Object.defineProperty(t,i,s),s};var E;!function(e){e.North="north",e.South="south",e.East="east",e.West="west"}(E||(E={}));const k=new l.Emitter;const D=new l.Emitter;class I{constructor(e){this.el=e,this.disposables=new c.DisposableStore}get onPointerMove(){return this.disposables.add(new o.DomEmitter((0,n.getWindow)(this.el),"mousemove")).event}get onPointerUp(){return this.disposables.add(new o.DomEmitter((0,n.getWindow)(this.el),"mouseup")).event}dispose(){this.disposables.dispose()}}x([a.memoize],I.prototype,"onPointerMove",null),x([a.memoize],I.prototype,"onPointerUp",null);class L{get onPointerMove(){return this.disposables.add(new o.DomEmitter(this.el,r.EventType.Change)).event}get onPointerUp(){return this.disposables.add(new o.DomEmitter(this.el,r.EventType.End)).event}constructor(e){this.el=e,this.disposables=new c.DisposableStore}dispose(){this.disposables.dispose()}}x([a.memoize],L.prototype,"onPointerMove",null),x([a.memoize],L.prototype,"onPointerUp",null);class T{get onPointerMove(){return this.factory.onPointerMove}get onPointerUp(){return this.factory.onPointerUp}constructor(e){this.factory=e}dispose(){}}x([a.memoize],T.prototype,"onPointerMove",null),x([a.memoize],T.prototype,"onPointerUp",null);const M="pointer-events-disabled";class N extends c.Disposable{get state(){return this._state}get orthogonalStartSash(){return this._orthogonalStartSash}get orthogonalEndSash(){return this._orthogonalEndSash}set state(e){this._state!==e&&(this.el.classList.toggle("disabled",0===e),this.el.classList.toggle("minimum",1===e),this.el.classList.toggle("maximum",2===e),this._state=e,this.onDidEnablementChange.fire(e))}set orthogonalStartSash(e){if(this._orthogonalStartSash!==e){if(this.orthogonalStartDragHandleDisposables.clear(),this.orthogonalStartSashDisposables.clear(),e){const t=t=>{this.orthogonalStartDragHandleDisposables.clear(),0!==t&&(this._orthogonalStartDragHandle=(0,n.append)(this.el,(0,n.$)(".orthogonal-drag-handle.start")),this.orthogonalStartDragHandleDisposables.add((0,c.toDisposable)((()=>this._orthogonalStartDragHandle.remove()))),this.orthogonalStartDragHandleDisposables.add(new o.DomEmitter(this._orthogonalStartDragHandle,"mouseenter")).event((()=>N.onMouseEnter(e)),void 0,this.orthogonalStartDragHandleDisposables),this.orthogonalStartDragHandleDisposables.add(new o.DomEmitter(this._orthogonalStartDragHandle,"mouseleave")).event((()=>N.onMouseLeave(e)),void 0,this.orthogonalStartDragHandleDisposables))};this.orthogonalStartSashDisposables.add(e.onDidEnablementChange.event(t,this)),t(e.state)}this._orthogonalStartSash=e}}set orthogonalEndSash(e){if(this._orthogonalEndSash!==e){if(this.orthogonalEndDragHandleDisposables.clear(),this.orthogonalEndSashDisposables.clear(),e){const t=t=>{this.orthogonalEndDragHandleDisposables.clear(),0!==t&&(this._orthogonalEndDragHandle=(0,n.append)(this.el,(0,n.$)(".orthogonal-drag-handle.end")),this.orthogonalEndDragHandleDisposables.add((0,c.toDisposable)((()=>this._orthogonalEndDragHandle.remove()))),this.orthogonalEndDragHandleDisposables.add(new o.DomEmitter(this._orthogonalEndDragHandle,"mouseenter")).event((()=>N.onMouseEnter(e)),void 0,this.orthogonalEndDragHandleDisposables),this.orthogonalEndDragHandleDisposables.add(new o.DomEmitter(this._orthogonalEndDragHandle,"mouseleave")).event((()=>N.onMouseLeave(e)),void 0,this.orthogonalEndDragHandleDisposables))};this.orthogonalEndSashDisposables.add(e.onDidEnablementChange.event(t,this)),t(e.state)}this._orthogonalEndSash=e}}constructor(e,t,i){super(),this.hoverDelay=300,this.hoverDelayer=this._register(new s.Delayer(this.hoverDelay)),this._state=3,this.onDidEnablementChange=this._register(new l.Emitter),this._onDidStart=this._register(new l.Emitter),this._onDidChange=this._register(new l.Emitter),this._onDidReset=this._register(new l.Emitter),this._onDidEnd=this._register(new l.Emitter),this.orthogonalStartSashDisposables=this._register(new c.DisposableStore),this.orthogonalStartDragHandleDisposables=this._register(new c.DisposableStore),this.orthogonalEndSashDisposables=this._register(new c.DisposableStore),this.orthogonalEndDragHandleDisposables=this._register(new c.DisposableStore),this.onDidStart=this._onDidStart.event,this.onDidChange=this._onDidChange.event,this.onDidReset=this._onDidReset.event,this.onDidEnd=this._onDidEnd.event,this.linkedSash=void 0,this.el=(0,n.append)(e,(0,n.$)(".monaco-sash")),i.orthogonalEdge&&this.el.classList.add(`orthogonal-edge-${i.orthogonalEdge}`),d.isMacintosh&&this.el.classList.add("mac");const a=this._register(new o.DomEmitter(this.el,"mousedown")).event;this._register(a((t=>this.onPointerStart(t,new I(e))),this));const u=this._register(new o.DomEmitter(this.el,"dblclick")).event;this._register(u(this.onPointerDoublePress,this));const h=this._register(new o.DomEmitter(this.el,"mouseenter")).event;this._register(h((()=>N.onMouseEnter(this))));const g=this._register(new o.DomEmitter(this.el,"mouseleave")).event;this._register(g((()=>N.onMouseLeave(this)))),this._register(r.Gesture.addTarget(this.el));const p=this._register(new o.DomEmitter(this.el,r.EventType.Start)).event;this._register(p((e=>this.onPointerStart(e,new L(this.el))),this));const m=this._register(new o.DomEmitter(this.el,r.EventType.Tap)).event;let f;this._register(m((e=>{if(f)return clearTimeout(f),f=void 0,void this.onPointerDoublePress(e);clearTimeout(f),f=setTimeout((()=>f=void 0),250)}),this)),"number"==typeof i.size?(this.size=i.size,0===i.orientation?this.el.style.width=`${this.size}px`:this.el.style.height=`${this.size}px`):(this.size=4,this._register(k.event((e=>{this.size=e,this.layout()})))),this._register(D.event((e=>this.hoverDelay=e))),this.layoutProvider=t,this.orthogonalStartSash=i.orthogonalStartSash,this.orthogonalEndSash=i.orthogonalEndSash,this.orientation=i.orientation||0,1===this.orientation?(this.el.classList.add("horizontal"),this.el.classList.remove("vertical")):(this.el.classList.remove("horizontal"),this.el.classList.add("vertical")),this.el.classList.toggle("debug",false),this.layout()}onPointerStart(e,t){n.EventHelper.stop(e);let i=!1;if(!e.__orthogonalSashEvent){const n=this.getOrthogonalSash(e);n&&(i=!0,e.__orthogonalSashEvent=!0,n.onPointerStart(e,new T(t)))}if(this.linkedSash&&!e.__linkedSashEvent&&(e.__linkedSashEvent=!0,this.linkedSash.onPointerStart(e,new T(t))),!this.state)return;const o=this.el.ownerDocument.getElementsByTagName("iframe");for(const e of o)e.classList.add(M);const r=e.pageX,s=e.pageY,a=e.altKey,l={startX:r,currentX:r,startY:s,currentY:s,altKey:a};this.el.classList.add("active"),this._onDidStart.fire(l);const u=(0,n.createStyleSheet)(this.el),h=()=>{let e="";e=i?"all-scroll":1===this.orientation?1===this.state?"s-resize":2===this.state?"n-resize":d.isMacintosh?"row-resize":"ns-resize":1===this.state?"e-resize":2===this.state?"w-resize":d.isMacintosh?"col-resize":"ew-resize",u.textContent=`* { cursor: ${e} !important; }`},g=new c.DisposableStore;h(),i||this.onDidEnablementChange.event(h,null,g);t.onPointerMove((e=>{n.EventHelper.stop(e,!1);const t={startX:r,currentX:e.pageX,startY:s,currentY:e.pageY,altKey:a};this._onDidChange.fire(t)}),null,g),t.onPointerUp((e=>{n.EventHelper.stop(e,!1),this.el.removeChild(u),this.el.classList.remove("active"),this._onDidEnd.fire(),g.dispose();for(const e of o)e.classList.remove(M)}),null,g),g.add(t)}onPointerDoublePress(e){const t=this.getOrthogonalSash(e);t&&t._onDidReset.fire(),this.linkedSash&&this.linkedSash._onDidReset.fire(),this._onDidReset.fire()}static onMouseEnter(e,t=!1){e.el.classList.contains("active")?(e.hoverDelayer.cancel(),e.el.classList.add("hover")):e.hoverDelayer.trigger((()=>e.el.classList.add("hover")),e.hoverDelay).then(void 0,(()=>{})),!t&&e.linkedSash&&N.onMouseEnter(e.linkedSash,!0)}static onMouseLeave(e,t=!1){e.hoverDelayer.cancel(),e.el.classList.remove("hover"),!t&&e.linkedSash&&N.onMouseLeave(e.linkedSash,!0)}clearSashHoverState(){N.onMouseLeave(this)}layout(){if(0===this.orientation){const e=this.layoutProvider;this.el.style.left=e.getVerticalSashLeft(this)-this.size/2+"px",e.getVerticalSashTop&&(this.el.style.top=e.getVerticalSashTop(this)+"px"),e.getVerticalSashHeight&&(this.el.style.height=e.getVerticalSashHeight(this)+"px")}else{const e=this.layoutProvider;this.el.style.top=e.getHorizontalSashTop(this)-this.size/2+"px",e.getHorizontalSashLeft&&(this.el.style.left=e.getHorizontalSashLeft(this)+"px"),e.getHorizontalSashWidth&&(this.el.style.width=e.getHorizontalSashWidth(this)+"px")}}getOrthogonalSash(e){var t;const i=null!==(t=e.initialTarget)&&void 0!==t?t:e.target;if(i&&i instanceof HTMLElement)return i.classList.contains("orthogonal-drag-handle")?i.classList.contains("start")?this.orthogonalStartSash:this.orthogonalEndSash:void 0}dispose(){super.dispose(),this.el.remove()}}},92117:function(e,t,i){"use strict";i.r(t),i.d(t,{AbstractScrollbar:function(){return d}});var n=i(96747),o=i(85297),r=i(95689),s=i(24990),a=i(23487),l=i(47257),c=i(66719);class d extends l.Widget{constructor(e){super(),this._lazyRender=e.lazyRender,this._host=e.host,this._scrollable=e.scrollable,this._scrollByPage=e.scrollByPage,this._scrollbarState=e.scrollbarState,this._visibilityController=this._register(new a.ScrollbarVisibilityController(e.visibility,"visible scrollbar "+e.extraScrollbarClassName,"invisible scrollbar "+e.extraScrollbarClassName)),this._visibilityController.setIsNeeded(this._scrollbarState.isNeeded()),this._pointerMoveMonitor=this._register(new r.GlobalPointerMoveMonitor),this._shouldRender=!0,this.domNode=(0,o.createFastDomNode)(document.createElement("div")),this.domNode.setAttribute("role","presentation"),this.domNode.setAttribute("aria-hidden","true"),this._visibilityController.setDomNode(this.domNode),this.domNode.setPosition("absolute"),this._register(n.addDisposableListener(this.domNode.domNode,n.EventType.POINTER_DOWN,(e=>this._domNodePointerDown(e))))}_createArrow(e){const t=this._register(new s.ScrollbarArrow(e));this.domNode.domNode.appendChild(t.bgDomNode),this.domNode.domNode.appendChild(t.domNode)}_createSlider(e,t,i,r){this.slider=(0,o.createFastDomNode)(document.createElement("div")),this.slider.setClassName("slider"),this.slider.setPosition("absolute"),this.slider.setTop(e),this.slider.setLeft(t),"number"==typeof i&&this.slider.setWidth(i),"number"==typeof r&&this.slider.setHeight(r),this.slider.setLayerHinting(!0),this.slider.setContain("strict"),this.domNode.domNode.appendChild(this.slider.domNode),this._register(n.addDisposableListener(this.slider.domNode,n.EventType.POINTER_DOWN,(e=>{0===e.button&&(e.preventDefault(),this._sliderPointerDown(e))}))),this.onclick(this.slider.domNode,(e=>{e.leftButton&&e.stopPropagation()}))}_onElementSize(e){return this._scrollbarState.setVisibleSize(e)&&(this._visibilityController.setIsNeeded(this._scrollbarState.isNeeded()),this._shouldRender=!0,this._lazyRender||this.render()),this._shouldRender}_onElementScrollSize(e){return this._scrollbarState.setScrollSize(e)&&(this._visibilityController.setIsNeeded(this._scrollbarState.isNeeded()),this._shouldRender=!0,this._lazyRender||this.render()),this._shouldRender}_onElementScrollPosition(e){return this._scrollbarState.setScrollPosition(e)&&(this._visibilityController.setIsNeeded(this._scrollbarState.isNeeded()),this._shouldRender=!0,this._lazyRender||this.render()),this._shouldRender}beginReveal(){this._visibilityController.setShouldBeVisible(!0)}beginHide(){this._visibilityController.setShouldBeVisible(!1)}render(){this._shouldRender&&(this._shouldRender=!1,this._renderDomNode(this._scrollbarState.getRectangleLargeSize(),this._scrollbarState.getRectangleSmallSize()),this._updateSlider(this._scrollbarState.getSliderSize(),this._scrollbarState.getArrowSize()+this._scrollbarState.getSliderPosition()))}_domNodePointerDown(e){e.target===this.domNode.domNode&&this._onPointerDown(e)}delegatePointerDown(e){const t=this.domNode.domNode.getClientRects()[0].top,i=t+this._scrollbarState.getSliderPosition(),n=t+this._scrollbarState.getSliderPosition()+this._scrollbarState.getSliderSize(),o=this._sliderPointerPosition(e);i<=o&&o<=n?0===e.button&&(e.preventDefault(),this._sliderPointerDown(e)):this._onPointerDown(e)}_onPointerDown(e){let t,i;if(e.target===this.domNode.domNode&&"number"==typeof e.offsetX&&"number"==typeof e.offsetY)t=e.offsetX,i=e.offsetY;else{const o=n.getDomNodePagePosition(this.domNode.domNode);t=e.pageX-o.left,i=e.pageY-o.top}const o=this._pointerDownRelativePosition(t,i);this._setDesiredScrollPositionNow(this._scrollByPage?this._scrollbarState.getDesiredScrollPositionFromOffsetPaged(o):this._scrollbarState.getDesiredScrollPositionFromOffset(o)),0===e.button&&(e.preventDefault(),this._sliderPointerDown(e))}_sliderPointerDown(e){if(!(e.target&&e.target instanceof Element))return;const t=this._sliderPointerPosition(e),i=this._sliderOrthogonalPointerPosition(e),n=this._scrollbarState.clone();this.slider.toggleClassName("active",!0),this._pointerMoveMonitor.startMonitoring(e.target,e.pointerId,e.buttons,(e=>{const o=this._sliderOrthogonalPointerPosition(e),r=Math.abs(o-i);if(c.isWindows&&r>140)return void this._setDesiredScrollPositionNow(n.getScrollPosition());const s=this._sliderPointerPosition(e)-t;this._setDesiredScrollPositionNow(n.getDesiredScrollPositionFromDelta(s))}),(()=>{this.slider.toggleClassName("active",!1),this._host.onDragEnd()})),this._host.onDragStart()}_setDesiredScrollPositionNow(e){const t={};this.writeScrollPosition(t,e),this._scrollable.setScrollPositionNow(t)}updateScrollbarSize(e){this._updateScrollbarSize(e),this._scrollbarState.setScrollbarSize(e),this._shouldRender=!0,this._lazyRender||this.render()}isNeeded(){return this._scrollbarState.isNeeded()}}},48321:function(e,t,i){"use strict";i.r(t),i.d(t,{HorizontalScrollbar:function(){return l}});var n=i(5642),o=i(92117),r=i(24990),s=i(76344),a=i(56087);class l extends o.AbstractScrollbar{constructor(e,t,i){const o=e.getScrollDimensions(),l=e.getCurrentScrollPosition();if(super({lazyRender:t.lazyRender,host:i,scrollbarState:new s.ScrollbarState(t.horizontalHasArrows?t.arrowSize:0,2===t.horizontal?0:t.horizontalScrollbarSize,2===t.vertical?0:t.verticalScrollbarSize,o.width,o.scrollWidth,l.scrollLeft),visibility:t.horizontal,extraScrollbarClassName:"horizontal",scrollable:e,scrollByPage:t.scrollByPage}),t.horizontalHasArrows){const e=(t.arrowSize-r.ARROW_IMG_SIZE)/2,i=(t.horizontalScrollbarSize-r.ARROW_IMG_SIZE)/2;this._createArrow({className:"scra",icon:a.Codicon.scrollbarButtonLeft,top:i,left:e,bottom:void 0,right:void 0,bgWidth:t.arrowSize,bgHeight:t.horizontalScrollbarSize,onActivate:()=>this._host.onMouseWheel(new n.StandardWheelEvent(null,1,0))}),this._createArrow({className:"scra",icon:a.Codicon.scrollbarButtonRight,top:i,left:void 0,bottom:void 0,right:e,bgWidth:t.arrowSize,bgHeight:t.horizontalScrollbarSize,onActivate:()=>this._host.onMouseWheel(new n.StandardWheelEvent(null,-1,0))})}this._createSlider(Math.floor((t.horizontalScrollbarSize-t.horizontalSliderSize)/2),0,void 0,t.horizontalSliderSize)}_updateSlider(e,t){this.slider.setWidth(e),this.slider.setLeft(t)}_renderDomNode(e,t){this.domNode.setWidth(e),this.domNode.setHeight(t),this.domNode.setLeft(0),this.domNode.setBottom(0)}onDidScroll(e){return this._shouldRender=this._onElementScrollSize(e.scrollWidth)||this._shouldRender,this._shouldRender=this._onElementScrollPosition(e.scrollLeft)||this._shouldRender,this._shouldRender=this._onElementSize(e.width)||this._shouldRender,this._shouldRender}_pointerDownRelativePosition(e,t){return e}_sliderPointerPosition(e){return e.pageX}_sliderOrthogonalPointerPosition(e){return e.pageY}_updateScrollbarSize(e){this.slider.setHeight(e)}writeScrollPosition(e,t){e.scrollLeft=t}updateOptions(e){this.updateScrollbarSize(2===e.horizontal?0:e.horizontalScrollbarSize),this._scrollbarState.setOppositeScrollbarSize(2===e.vertical?0:e.verticalScrollbarSize),this._visibilityController.setVisibility(e.horizontal),this._scrollByPage=e.scrollByPage}}},34309:function(e,t,i){"use strict";i.r(t),i.d(t,{AbstractScrollableElement:function(){return T},DomScrollableElement:function(){return R},MouseWheelClassifier:function(){return L},ScrollableElement:function(){return M},SmoothScrollableElement:function(){return N}});var n=i(76736),o=i(96747),r=i(85297),s=i(5642),a=i(48321),l=i(22876),c=i(47257),d=i(66129),u=i(63801),h=i(68921),g=i(66719),p=i(6097),m=i(93379),f=i.n(m),b=i(7795),v=i.n(b),_=i(90569),A=i.n(_),C=i(3565),w=i.n(C),y=i(19216),S=i.n(y),x=i(44589),E=i.n(x),k=i(64836),D={};D.styleTagTransform=E(),D.setAttributes=w(),D.insert=A().bind(null,"head"),D.domAPI=v(),D.insertStyleElement=S();f()(k.Z,D),k.Z&&k.Z.locals&&k.Z.locals;class I{constructor(e,t,i){this.timestamp=e,this.deltaX=t,this.deltaY=i,this.score=0}}class L{constructor(){this._capacity=5,this._memory=[],this._front=-1,this._rear=-1}isPhysicalMouseWheel(){if(-1===this._front&&-1===this._rear)return!1;let e=1,t=0,i=1,n=this._rear;for(;;){const o=n===this._front?e:Math.pow(2,-i);if(e-=o,t+=this._memory[n].score*o,n===this._front)break;n=(this._capacity+n-1)%this._capacity,i++}return t<=.5}acceptStandardWheelEvent(e){const t=o.getWindow(e.browserEvent).devicePixelRatio/(0,n.getZoomFactor)();g.isWindows||g.isLinux?this.accept(Date.now(),e.deltaX/t,e.deltaY/t):this.accept(Date.now(),e.deltaX,e.deltaY)}accept(e,t,i){const n=new I(e,t,i);n.score=this._computeScore(n),-1===this._front&&-1===this._rear?(this._memory[0]=n,this._front=0,this._rear=0):(this._rear=(this._rear+1)%this._capacity,this._rear===this._front&&(this._front=(this._front+1)%this._capacity),this._memory[this._rear]=n)}_computeScore(e){if(Math.abs(e.deltaX)>0&&Math.abs(e.deltaY)>0)return 1;let t=.5;-1===this._front&&-1===this._rear||this._memory[this._rear];return this._isAlmostInt(e.deltaX)&&this._isAlmostInt(e.deltaY)||(t+=.25),Math.min(Math.max(t,0),1)}_isAlmostInt(e){return Math.abs(Math.round(e)-e)<.01}}L.INSTANCE=new L;class T extends c.Widget{get options(){return this._options}constructor(e,t,i){super(),this._onScroll=this._register(new u.Emitter),this.onScroll=this._onScroll.event,this._onWillScroll=this._register(new u.Emitter),e.style.overflow="hidden",this._options=function(e){const t={lazyRender:void 0!==e.lazyRender&&e.lazyRender,className:void 0!==e.className?e.className:"",useShadows:void 0===e.useShadows||e.useShadows,handleMouseWheel:void 0===e.handleMouseWheel||e.handleMouseWheel,flipAxes:void 0!==e.flipAxes&&e.flipAxes,consumeMouseWheelIfScrollbarIsNeeded:void 0!==e.consumeMouseWheelIfScrollbarIsNeeded&&e.consumeMouseWheelIfScrollbarIsNeeded,alwaysConsumeMouseWheel:void 0!==e.alwaysConsumeMouseWheel&&e.alwaysConsumeMouseWheel,scrollYToX:void 0!==e.scrollYToX&&e.scrollYToX,mouseWheelScrollSensitivity:void 0!==e.mouseWheelScrollSensitivity?e.mouseWheelScrollSensitivity:1,fastScrollSensitivity:void 0!==e.fastScrollSensitivity?e.fastScrollSensitivity:5,scrollPredominantAxis:void 0===e.scrollPredominantAxis||e.scrollPredominantAxis,mouseWheelSmoothScroll:void 0===e.mouseWheelSmoothScroll||e.mouseWheelSmoothScroll,arrowSize:void 0!==e.arrowSize?e.arrowSize:11,listenOnDomNode:void 0!==e.listenOnDomNode?e.listenOnDomNode:null,horizontal:void 0!==e.horizontal?e.horizontal:1,horizontalScrollbarSize:void 0!==e.horizontalScrollbarSize?e.horizontalScrollbarSize:10,horizontalSliderSize:void 0!==e.horizontalSliderSize?e.horizontalSliderSize:0,horizontalHasArrows:void 0!==e.horizontalHasArrows&&e.horizontalHasArrows,vertical:void 0!==e.vertical?e.vertical:1,verticalScrollbarSize:void 0!==e.verticalScrollbarSize?e.verticalScrollbarSize:10,verticalHasArrows:void 0!==e.verticalHasArrows&&e.verticalHasArrows,verticalSliderSize:void 0!==e.verticalSliderSize?e.verticalSliderSize:0,scrollByPage:void 0!==e.scrollByPage&&e.scrollByPage};t.horizontalSliderSize=void 0!==e.horizontalSliderSize?e.horizontalSliderSize:t.horizontalScrollbarSize,t.verticalSliderSize=void 0!==e.verticalSliderSize?e.verticalSliderSize:t.verticalScrollbarSize,g.isMacintosh&&(t.className+=" mac");return t}(t),this._scrollable=i,this._register(this._scrollable.onScroll((e=>{this._onWillScroll.fire(e),this._onDidScroll(e),this._onScroll.fire(e)})));const n={onMouseWheel:e=>this._onMouseWheel(e),onDragStart:()=>this._onDragStart(),onDragEnd:()=>this._onDragEnd()};this._verticalScrollbar=this._register(new l.VerticalScrollbar(this._scrollable,this._options,n)),this._horizontalScrollbar=this._register(new a.HorizontalScrollbar(this._scrollable,this._options,n)),this._domNode=document.createElement("div"),this._domNode.className="monaco-scrollable-element "+this._options.className,this._domNode.setAttribute("role","presentation"),this._domNode.style.position="relative",this._domNode.style.overflow="hidden",this._domNode.appendChild(e),this._domNode.appendChild(this._horizontalScrollbar.domNode.domNode),this._domNode.appendChild(this._verticalScrollbar.domNode.domNode),this._options.useShadows?(this._leftShadowDomNode=(0,r.createFastDomNode)(document.createElement("div")),this._leftShadowDomNode.setClassName("shadow"),this._domNode.appendChild(this._leftShadowDomNode.domNode),this._topShadowDomNode=(0,r.createFastDomNode)(document.createElement("div")),this._topShadowDomNode.setClassName("shadow"),this._domNode.appendChild(this._topShadowDomNode.domNode),this._topLeftShadowDomNode=(0,r.createFastDomNode)(document.createElement("div")),this._topLeftShadowDomNode.setClassName("shadow"),this._domNode.appendChild(this._topLeftShadowDomNode.domNode)):(this._leftShadowDomNode=null,this._topShadowDomNode=null,this._topLeftShadowDomNode=null),this._listenOnDomNode=this._options.listenOnDomNode||this._domNode,this._mouseWheelToDispose=[],this._setListeningToMouseWheel(this._options.handleMouseWheel),this.onmouseover(this._listenOnDomNode,(e=>this._onMouseOver(e))),this.onmouseleave(this._listenOnDomNode,(e=>this._onMouseLeave(e))),this._hideTimeout=this._register(new d.TimeoutTimer),this._isDragging=!1,this._mouseIsOver=!1,this._shouldRender=!0,this._revealOnScroll=!0}dispose(){this._mouseWheelToDispose=(0,h.dispose)(this._mouseWheelToDispose),super.dispose()}getDomNode(){return this._domNode}getOverviewRulerLayoutInfo(){return{parent:this._domNode,insertBefore:this._verticalScrollbar.domNode.domNode}}delegateVerticalScrollbarPointerDown(e){this._verticalScrollbar.delegatePointerDown(e)}getScrollDimensions(){return this._scrollable.getScrollDimensions()}setScrollDimensions(e){this._scrollable.setScrollDimensions(e,!1)}updateClassName(e){this._options.className=e,g.isMacintosh&&(this._options.className+=" mac"),this._domNode.className="monaco-scrollable-element "+this._options.className}updateOptions(e){void 0!==e.handleMouseWheel&&(this._options.handleMouseWheel=e.handleMouseWheel,this._setListeningToMouseWheel(this._options.handleMouseWheel)),void 0!==e.mouseWheelScrollSensitivity&&(this._options.mouseWheelScrollSensitivity=e.mouseWheelScrollSensitivity),void 0!==e.fastScrollSensitivity&&(this._options.fastScrollSensitivity=e.fastScrollSensitivity),void 0!==e.scrollPredominantAxis&&(this._options.scrollPredominantAxis=e.scrollPredominantAxis),void 0!==e.horizontal&&(this._options.horizontal=e.horizontal),void 0!==e.vertical&&(this._options.vertical=e.vertical),void 0!==e.horizontalScrollbarSize&&(this._options.horizontalScrollbarSize=e.horizontalScrollbarSize),void 0!==e.verticalScrollbarSize&&(this._options.verticalScrollbarSize=e.verticalScrollbarSize),void 0!==e.scrollByPage&&(this._options.scrollByPage=e.scrollByPage),this._horizontalScrollbar.updateOptions(this._options),this._verticalScrollbar.updateOptions(this._options),this._options.lazyRender||this._render()}delegateScrollFromMouseWheelEvent(e){this._onMouseWheel(new s.StandardWheelEvent(e))}_setListeningToMouseWheel(e){if(this._mouseWheelToDispose.length>0!==e&&(this._mouseWheelToDispose=(0,h.dispose)(this._mouseWheelToDispose),e)){const e=e=>{this._onMouseWheel(new s.StandardWheelEvent(e))};this._mouseWheelToDispose.push(o.addDisposableListener(this._listenOnDomNode,o.EventType.MOUSE_WHEEL,e,{passive:!1}))}}_onMouseWheel(e){var t;if(null===(t=e.browserEvent)||void 0===t?void 0:t.defaultPrevented)return;const i=L.INSTANCE;i.acceptStandardWheelEvent(e);let n=!1;if(e.deltaY||e.deltaX){let t=e.deltaY*this._options.mouseWheelScrollSensitivity,o=e.deltaX*this._options.mouseWheelScrollSensitivity;this._options.scrollPredominantAxis&&(this._options.scrollYToX&&o+t===0?o=t=0:Math.abs(t)>=Math.abs(o)?o=0:t=0),this._options.flipAxes&&([t,o]=[o,t]);const r=!g.isMacintosh&&e.browserEvent&&e.browserEvent.shiftKey;!this._options.scrollYToX&&!r||o||(o=t,t=0),e.browserEvent&&e.browserEvent.altKey&&(o*=this._options.fastScrollSensitivity,t*=this._options.fastScrollSensitivity);const s=this._scrollable.getFutureScrollPosition();let a={};if(t){const e=50*t,i=s.scrollTop-(e<0?Math.floor(e):Math.ceil(e));this._verticalScrollbar.writeScrollPosition(a,i)}if(o){const e=50*o,t=s.scrollLeft-(e<0?Math.floor(e):Math.ceil(e));this._horizontalScrollbar.writeScrollPosition(a,t)}if(a=this._scrollable.validateScrollPosition(a),s.scrollLeft!==a.scrollLeft||s.scrollTop!==a.scrollTop){this._options.mouseWheelSmoothScroll&&i.isPhysicalMouseWheel()?this._scrollable.setScrollPositionSmooth(a):this._scrollable.setScrollPositionNow(a),n=!0}}let o=n;!o&&this._options.alwaysConsumeMouseWheel&&(o=!0),!o&&this._options.consumeMouseWheelIfScrollbarIsNeeded&&(this._verticalScrollbar.isNeeded()||this._horizontalScrollbar.isNeeded())&&(o=!0),o&&(e.preventDefault(),e.stopPropagation())}_onDidScroll(e){this._shouldRender=this._horizontalScrollbar.onDidScroll(e)||this._shouldRender,this._shouldRender=this._verticalScrollbar.onDidScroll(e)||this._shouldRender,this._options.useShadows&&(this._shouldRender=!0),this._revealOnScroll&&this._reveal(),this._options.lazyRender||this._render()}renderNow(){if(!this._options.lazyRender)throw new Error("Please use `lazyRender` together with `renderNow`!");this._render()}_render(){if(this._shouldRender&&(this._shouldRender=!1,this._horizontalScrollbar.render(),this._verticalScrollbar.render(),this._options.useShadows)){const e=this._scrollable.getCurrentScrollPosition(),t=e.scrollTop>0,i=e.scrollLeft>0,n=i?" left":"",o=t?" top":"",r=i||t?" top-left-corner":"";this._leftShadowDomNode.setClassName(`shadow${n}`),this._topShadowDomNode.setClassName(`shadow${o}`),this._topLeftShadowDomNode.setClassName(`shadow${r}${o}${n}`)}}_onDragStart(){this._isDragging=!0,this._reveal()}_onDragEnd(){this._isDragging=!1,this._hide()}_onMouseLeave(e){this._mouseIsOver=!1,this._hide()}_onMouseOver(e){this._mouseIsOver=!0,this._reveal()}_reveal(){this._verticalScrollbar.beginReveal(),this._horizontalScrollbar.beginReveal(),this._scheduleHide()}_hide(){this._mouseIsOver||this._isDragging||(this._verticalScrollbar.beginHide(),this._horizontalScrollbar.beginHide())}_scheduleHide(){this._mouseIsOver||this._isDragging||this._hideTimeout.cancelAndSet((()=>this._hide()),500)}}class M extends T{constructor(e,t){(t=t||{}).mouseWheelSmoothScroll=!1;const i=new p.Scrollable({forceIntegerValues:!0,smoothScrollDuration:0,scheduleAtNextAnimationFrame:t=>o.scheduleAtNextAnimationFrame(o.getWindow(e),t)});super(e,t,i),this._register(i)}setScrollPosition(e){this._scrollable.setScrollPositionNow(e)}}class N extends T{constructor(e,t,i){super(e,t,i)}setScrollPosition(e){e.reuseAnimation?this._scrollable.setScrollPositionSmooth(e,e.reuseAnimation):this._scrollable.setScrollPositionNow(e)}getScrollPosition(){return this._scrollable.getCurrentScrollPosition()}}class R extends T{constructor(e,t){(t=t||{}).mouseWheelSmoothScroll=!1;const i=new p.Scrollable({forceIntegerValues:!1,smoothScrollDuration:0,scheduleAtNextAnimationFrame:t=>o.scheduleAtNextAnimationFrame(o.getWindow(e),t)});super(e,t,i),this._register(i),this._element=e,this._register(this.onScroll((e=>{e.scrollTopChanged&&(this._element.scrollTop=e.scrollTop),e.scrollLeftChanged&&(this._element.scrollLeft=e.scrollLeft)}))),this.scanDomNode()}setScrollPosition(e){this._scrollable.setScrollPositionNow(e)}getScrollPosition(){return this._scrollable.getCurrentScrollPosition()}scanDomNode(){this.setScrollDimensions({width:this._element.clientWidth,scrollWidth:this._element.scrollWidth,height:this._element.clientHeight,scrollHeight:this._element.scrollHeight}),this.setScrollPosition({scrollLeft:this._element.scrollLeft,scrollTop:this._element.scrollTop})}}},24990:function(e,t,i){"use strict";i.r(t),i.d(t,{ARROW_IMG_SIZE:function(){return l},ScrollbarArrow:function(){return c}});var n=i(95689),o=i(47257),r=i(66129),s=i(27269),a=i(96747);const l=11;class c extends o.Widget{constructor(e){super(),this._onActivate=e.onActivate,this.bgDomNode=document.createElement("div"),this.bgDomNode.className="arrow-background",this.bgDomNode.style.position="absolute",this.bgDomNode.style.width=e.bgWidth+"px",this.bgDomNode.style.height=e.bgHeight+"px",void 0!==e.top&&(this.bgDomNode.style.top="0px"),void 0!==e.left&&(this.bgDomNode.style.left="0px"),void 0!==e.bottom&&(this.bgDomNode.style.bottom="0px"),void 0!==e.right&&(this.bgDomNode.style.right="0px"),this.domNode=document.createElement("div"),this.domNode.className=e.className,this.domNode.classList.add(...s.ThemeIcon.asClassNameArray(e.icon)),this.domNode.style.position="absolute",this.domNode.style.width=l+"px",this.domNode.style.height=l+"px",void 0!==e.top&&(this.domNode.style.top=e.top+"px"),void 0!==e.left&&(this.domNode.style.left=e.left+"px"),void 0!==e.bottom&&(this.domNode.style.bottom=e.bottom+"px"),void 0!==e.right&&(this.domNode.style.right=e.right+"px"),this._pointerMoveMonitor=this._register(new n.GlobalPointerMoveMonitor),this._register(a.addStandardDisposableListener(this.bgDomNode,a.EventType.POINTER_DOWN,(e=>this._arrowPointerDown(e)))),this._register(a.addStandardDisposableListener(this.domNode,a.EventType.POINTER_DOWN,(e=>this._arrowPointerDown(e)))),this._pointerdownRepeatTimer=this._register(new a.WindowIntervalTimer),this._pointerdownScheduleRepeatTimer=this._register(new r.TimeoutTimer)}_arrowPointerDown(e){if(!(e.target&&e.target instanceof Element))return;this._onActivate(),this._pointerdownRepeatTimer.cancel(),this._pointerdownScheduleRepeatTimer.cancelAndSet((()=>{this._pointerdownRepeatTimer.cancelAndSet((()=>this._onActivate()),1e3/24,a.getWindow(e))}),200),this._pointerMoveMonitor.startMonitoring(e.target,e.pointerId,e.buttons,(e=>{}),(()=>{this._pointerdownRepeatTimer.cancel(),this._pointerdownScheduleRepeatTimer.cancel()})),e.preventDefault()}}},76344:function(e,t,i){"use strict";i.r(t),i.d(t,{ScrollbarState:function(){return n}});class n{constructor(e,t,i,n,o,r){this._scrollbarSize=Math.round(t),this._oppositeScrollbarSize=Math.round(i),this._arrowSize=Math.round(e),this._visibleSize=n,this._scrollSize=o,this._scrollPosition=r,this._computedAvailableSize=0,this._computedIsNeeded=!1,this._computedSliderSize=0,this._computedSliderRatio=0,this._computedSliderPosition=0,this._refreshComputedValues()}clone(){return new n(this._arrowSize,this._scrollbarSize,this._oppositeScrollbarSize,this._visibleSize,this._scrollSize,this._scrollPosition)}setVisibleSize(e){const t=Math.round(e);return this._visibleSize!==t&&(this._visibleSize=t,this._refreshComputedValues(),!0)}setScrollSize(e){const t=Math.round(e);return this._scrollSize!==t&&(this._scrollSize=t,this._refreshComputedValues(),!0)}setScrollPosition(e){const t=Math.round(e);return this._scrollPosition!==t&&(this._scrollPosition=t,this._refreshComputedValues(),!0)}setScrollbarSize(e){this._scrollbarSize=Math.round(e)}setOppositeScrollbarSize(e){this._oppositeScrollbarSize=Math.round(e)}static _computeValues(e,t,i,n,o){const r=Math.max(0,i-e),s=Math.max(0,r-2*t),a=n>0&&n>i;if(!a)return{computedAvailableSize:Math.round(r),computedIsNeeded:a,computedSliderSize:Math.round(s),computedSliderRatio:0,computedSliderPosition:0};const l=Math.round(Math.max(20,Math.floor(i*s/n))),c=(s-l)/(n-i),d=o*c;return{computedAvailableSize:Math.round(r),computedIsNeeded:a,computedSliderSize:Math.round(l),computedSliderRatio:c,computedSliderPosition:Math.round(d)}}_refreshComputedValues(){const e=n._computeValues(this._oppositeScrollbarSize,this._arrowSize,this._visibleSize,this._scrollSize,this._scrollPosition);this._computedAvailableSize=e.computedAvailableSize,this._computedIsNeeded=e.computedIsNeeded,this._computedSliderSize=e.computedSliderSize,this._computedSliderRatio=e.computedSliderRatio,this._computedSliderPosition=e.computedSliderPosition}getArrowSize(){return this._arrowSize}getScrollPosition(){return this._scrollPosition}getRectangleLargeSize(){return this._computedAvailableSize}getRectangleSmallSize(){return this._scrollbarSize}isNeeded(){return this._computedIsNeeded}getSliderSize(){return this._computedSliderSize}getSliderPosition(){return this._computedSliderPosition}getDesiredScrollPositionFromOffset(e){if(!this._computedIsNeeded)return 0;const t=e-this._arrowSize-this._computedSliderSize/2;return Math.round(t/this._computedSliderRatio)}getDesiredScrollPositionFromOffsetPaged(e){if(!this._computedIsNeeded)return 0;const t=e-this._arrowSize;let i=this._scrollPosition;return t<this._computedSliderPosition?i-=this._visibleSize:i+=this._visibleSize,i}getDesiredScrollPositionFromDelta(e){if(!this._computedIsNeeded)return 0;const t=this._computedSliderPosition+e;return Math.round(t/this._computedSliderRatio)}}},23487:function(e,t,i){"use strict";i.r(t),i.d(t,{ScrollbarVisibilityController:function(){return r}});var n=i(66129),o=i(68921);class r extends o.Disposable{constructor(e,t,i){super(),this._visibility=e,this._visibleClassName=t,this._invisibleClassName=i,this._domNode=null,this._isVisible=!1,this._isNeeded=!1,this._rawShouldBeVisible=!1,this._shouldBeVisible=!1,this._revealTimer=this._register(new n.TimeoutTimer)}setVisibility(e){this._visibility!==e&&(this._visibility=e,this._updateShouldBeVisible())}setShouldBeVisible(e){this._rawShouldBeVisible=e,this._updateShouldBeVisible()}_applyVisibilitySetting(){return 2!==this._visibility&&(3===this._visibility||this._rawShouldBeVisible)}_updateShouldBeVisible(){const e=this._applyVisibilitySetting();this._shouldBeVisible!==e&&(this._shouldBeVisible=e,this.ensureVisibility())}setIsNeeded(e){this._isNeeded!==e&&(this._isNeeded=e,this.ensureVisibility())}setDomNode(e){this._domNode=e,this._domNode.setClassName(this._invisibleClassName),this.setShouldBeVisible(!1)}ensureVisibility(){this._isNeeded?this._shouldBeVisible?this._reveal():this._hide(!0):this._hide(!1)}_reveal(){this._isVisible||(this._isVisible=!0,this._revealTimer.setIfNotSet((()=>{var e;null===(e=this._domNode)||void 0===e||e.setClassName(this._visibleClassName)}),0))}_hide(e){var t;this._revealTimer.cancel(),this._isVisible&&(this._isVisible=!1,null===(t=this._domNode)||void 0===t||t.setClassName(this._invisibleClassName+(e?" fade":"")))}}},22876:function(e,t,i){"use strict";i.r(t),i.d(t,{VerticalScrollbar:function(){return l}});var n=i(5642),o=i(92117),r=i(24990),s=i(76344),a=i(56087);class l extends o.AbstractScrollbar{constructor(e,t,i){const o=e.getScrollDimensions(),l=e.getCurrentScrollPosition();if(super({lazyRender:t.lazyRender,host:i,scrollbarState:new s.ScrollbarState(t.verticalHasArrows?t.arrowSize:0,2===t.vertical?0:t.verticalScrollbarSize,0,o.height,o.scrollHeight,l.scrollTop),visibility:t.vertical,extraScrollbarClassName:"vertical",scrollable:e,scrollByPage:t.scrollByPage}),t.verticalHasArrows){const e=(t.arrowSize-r.ARROW_IMG_SIZE)/2,i=(t.verticalScrollbarSize-r.ARROW_IMG_SIZE)/2;this._createArrow({className:"scra",icon:a.Codicon.scrollbarButtonUp,top:e,left:i,bottom:void 0,right:void 0,bgWidth:t.verticalScrollbarSize,bgHeight:t.arrowSize,onActivate:()=>this._host.onMouseWheel(new n.StandardWheelEvent(null,0,1))}),this._createArrow({className:"scra",icon:a.Codicon.scrollbarButtonDown,top:void 0,left:i,bottom:e,right:void 0,bgWidth:t.verticalScrollbarSize,bgHeight:t.arrowSize,onActivate:()=>this._host.onMouseWheel(new n.StandardWheelEvent(null,0,-1))})}this._createSlider(0,Math.floor((t.verticalScrollbarSize-t.verticalSliderSize)/2),t.verticalSliderSize,void 0)}_updateSlider(e,t){this.slider.setHeight(e),this.slider.setTop(t)}_renderDomNode(e,t){this.domNode.setWidth(t),this.domNode.setHeight(e),this.domNode.setRight(0),this.domNode.setTop(0)}onDidScroll(e){return this._shouldRender=this._onElementScrollSize(e.scrollHeight)||this._shouldRender,this._shouldRender=this._onElementScrollPosition(e.scrollTop)||this._shouldRender,this._shouldRender=this._onElementSize(e.height)||this._shouldRender,this._shouldRender}_pointerDownRelativePosition(e,t){return t}_sliderPointerPosition(e){return e.pageY}_sliderOrthogonalPointerPosition(e){return e.pageX}_updateScrollbarSize(e){this.slider.setWidth(e)}writeScrollPosition(e,t){e.scrollTop=t}updateOptions(e){this.updateScrollbarSize(2===e.vertical?0:e.verticalScrollbarSize),this._scrollbarState.setOppositeScrollbarSize(0),this._visibilityController.setVisibility(e.vertical),this._scrollByPage=e.scrollByPage}}},66418:function(e,t,i){"use strict";i.r(t),i.d(t,{SelectBox:function(){return C}});var n=i(72094),o=i(96696),r=i(47257),s=i(66719),a=i(93379),l=i.n(a),c=i(7795),d=i.n(c),u=i(90569),h=i.n(u),g=i(3565),p=i.n(g),m=i(19216),f=i.n(m),b=i(44589),v=i.n(b),_=i(98657),A={};A.styleTagTransform=v(),A.setAttributes=p(),A.insert=h().bind(null,"head"),A.domAPI=d(),A.insertStyleElement=f();l()(_.Z,A),_.Z&&_.Z.locals&&_.Z.locals;class C extends r.Widget{constructor(e,t,i,r,a){super(),s.isMacintosh&&!(null==a?void 0:a.useCustomDrawn)?this.selectBoxDelegate=new o.SelectBoxNative(e,t,r,a):this.selectBoxDelegate=new n.SelectBoxList(e,t,i,r,a),this._register(this.selectBoxDelegate)}get onDidSelect(){return this.selectBoxDelegate.onDidSelect}setOptions(e,t){this.selectBoxDelegate.setOptions(e,t)}select(e){this.selectBoxDelegate.select(e)}focus(){this.selectBoxDelegate.focus()}blur(){this.selectBoxDelegate.blur()}setFocusable(e){this.selectBoxDelegate.setFocusable(e)}render(e){this.selectBoxDelegate.render(e)}}},72094:function(e,t,i){"use strict";i.r(t),i.d(t,{SelectBoxList:function(){return T}});var n=i(96747),o=i(50465),r=i(8769),s=i(32703),a=i(72406),l=i(64998),c=i(63801),d=i(98070),u=i(68921),h=i(66719),g=i(93379),p=i.n(g),m=i(7795),f=i.n(m),b=i(90569),v=i.n(b),_=i(3565),A=i.n(_),C=i(19216),w=i.n(C),y=i(44589),S=i.n(y),x=i(40053),E={};E.styleTagTransform=S(),E.setAttributes=A(),E.insert=v().bind(null,"head"),E.domAPI=f(),E.insertStyleElement=w();p()(x.Z,E),x.Z&&x.Z.locals&&x.Z.locals;var k=i(83787);const D=n.$,I="selectOption.entry.template";class L{get templateId(){return I}renderTemplate(e){const t=Object.create(null);return t.root=e,t.text=n.append(e,D(".option-text")),t.detail=n.append(e,D(".option-detail")),t.decoratorRight=n.append(e,D(".option-decorator-right")),t}renderElement(e,t,i){const n=i,o=e.text,r=e.detail,s=e.decoratorRight,a=e.isDisabled;n.text.textContent=o,n.detail.textContent=r||"",n.decoratorRight.innerText=s||"",a?n.root.classList.add("option-disabled"):n.root.classList.remove("option-disabled")}disposeTemplate(e){}}class T extends u.Disposable{constructor(e,t,i,n,o){super(),this.options=[],this._currentSelection=0,this._hasDetails=!1,this._skipLayout=!1,this._sticky=!1,this._isVisible=!1,this.styles=n,this.selectBoxOptions=o||Object.create(null),"number"!=typeof this.selectBoxOptions.minBottomMargin?this.selectBoxOptions.minBottomMargin=T.DEFAULT_DROPDOWN_MINIMUM_BOTTOM_MARGIN:this.selectBoxOptions.minBottomMargin<0&&(this.selectBoxOptions.minBottomMargin=0),this.selectElement=document.createElement("select"),this.selectElement.className="monaco-select-box monaco-select-box-dropdown-padding","string"==typeof this.selectBoxOptions.ariaLabel&&this.selectElement.setAttribute("aria-label",this.selectBoxOptions.ariaLabel),"string"==typeof this.selectBoxOptions.ariaDescription&&this.selectElement.setAttribute("aria-description",this.selectBoxOptions.ariaDescription),this._onDidSelect=new c.Emitter,this._register(this._onDidSelect),this.registerListeners(),this.constructSelectDropDown(i),this.selected=t||0,e&&this.setOptions(e,t),this.initStyleSheet()}getHeight(){return 22}getTemplateId(){return I}constructSelectDropDown(e){this.contextViewProvider=e,this.selectDropDownContainer=n.$(".monaco-select-box-dropdown-container"),this.selectDropDownContainer.classList.add("monaco-select-box-dropdown-padding"),this.selectionDetailsPane=n.append(this.selectDropDownContainer,D(".select-box-details-pane"));const t=n.append(this.selectDropDownContainer,D(".select-box-dropdown-container-width-control")),i=n.append(t,D(".width-control-div"));this.widthControlElement=document.createElement("span"),this.widthControlElement.className="option-text-width-control",n.append(i,this.widthControlElement),this._dropDownPosition=0,this.styleElement=n.createStyleSheet(this.selectDropDownContainer),this.selectDropDownContainer.setAttribute("draggable","true"),this._register(n.addDisposableListener(this.selectDropDownContainer,n.EventType.DRAG_START,(e=>{n.EventHelper.stop(e,!0)})))}registerListeners(){let e;this._register(n.addStandardDisposableListener(this.selectElement,"change",(e=>{this.selected=e.target.selectedIndex,this._onDidSelect.fire({index:e.target.selectedIndex,selected:e.target.value}),this.options[this.selected]&&this.options[this.selected].text&&(this.selectElement.title=this.options[this.selected].text)}))),this._register(n.addDisposableListener(this.selectElement,n.EventType.CLICK,(e=>{n.EventHelper.stop(e),this._isVisible?this.hideSelectDropDown(!0):this.showSelectDropDown()}))),this._register(n.addDisposableListener(this.selectElement,n.EventType.MOUSE_DOWN,(e=>{n.EventHelper.stop(e)}))),this._register(n.addDisposableListener(this.selectElement,"touchstart",(t=>{e=this._isVisible}))),this._register(n.addDisposableListener(this.selectElement,"touchend",(t=>{n.EventHelper.stop(t),e?this.hideSelectDropDown(!0):this.showSelectDropDown()}))),this._register(n.addDisposableListener(this.selectElement,n.EventType.KEY_DOWN,(e=>{const t=new r.StandardKeyboardEvent(e);let i=!1;h.isMacintosh?18!==t.keyCode&&16!==t.keyCode&&10!==t.keyCode&&3!==t.keyCode||(i=!0):(18===t.keyCode&&t.altKey||16===t.keyCode&&t.altKey||10===t.keyCode||3===t.keyCode)&&(i=!0),i&&(this.showSelectDropDown(),n.EventHelper.stop(e,!0))})))}get onDidSelect(){return this._onDidSelect.event}setOptions(e,t){l.equals(this.options,e)||(this.options=e,this.selectElement.options.length=0,this._hasDetails=!1,this._cachedMaxDetailsHeight=void 0,this.options.forEach(((e,t)=>{this.selectElement.add(this.createOption(e.text,t,e.isDisabled)),"string"==typeof e.description&&(this._hasDetails=!0)}))),void 0!==t&&(this.select(t),this._currentSelection=this.selected)}setOptionsList(){var e;null===(e=this.selectList)||void 0===e||e.splice(0,this.selectList.length,this.options)}select(e){e>=0&&e<this.options.length?this.selected=e:e>this.options.length-1?this.select(this.options.length-1):this.selected<0&&(this.selected=0),this.selectElement.selectedIndex=this.selected,this.options[this.selected]&&this.options[this.selected].text&&(this.selectElement.title=this.options[this.selected].text)}focus(){this.selectElement&&(this.selectElement.tabIndex=0,this.selectElement.focus())}blur(){this.selectElement&&(this.selectElement.tabIndex=-1,this.selectElement.blur())}setFocusable(e){this.selectElement.tabIndex=e?0:-1}render(e){this.container=e,e.classList.add("select-container"),e.appendChild(this.selectElement),this.styleSelectElement()}initStyleSheet(){const e=[];this.styles.listFocusBackground&&e.push(`.monaco-select-box-dropdown-container > .select-box-dropdown-list-container .monaco-list .monaco-list-row.focused { background-color: ${this.styles.listFocusBackground} !important; }`),this.styles.listFocusForeground&&e.push(`.monaco-select-box-dropdown-container > .select-box-dropdown-list-container .monaco-list .monaco-list-row.focused { color: ${this.styles.listFocusForeground} !important; }`),this.styles.decoratorRightForeground&&e.push(`.monaco-select-box-dropdown-container > .select-box-dropdown-list-container .monaco-list .monaco-list-row:not(.focused) .option-decorator-right { color: ${this.styles.decoratorRightForeground}; }`),this.styles.selectBackground&&this.styles.selectBorder&&this.styles.selectBorder!==this.styles.selectBackground?(e.push(`.monaco-select-box-dropdown-container { border: 1px solid ${this.styles.selectBorder} } `),e.push(`.monaco-select-box-dropdown-container > .select-box-details-pane.border-top { border-top: 1px solid ${this.styles.selectBorder} } `),e.push(`.monaco-select-box-dropdown-container > .select-box-details-pane.border-bottom { border-bottom: 1px solid ${this.styles.selectBorder} } `)):this.styles.selectListBorder&&(e.push(`.monaco-select-box-dropdown-container > .select-box-details-pane.border-top { border-top: 1px solid ${this.styles.selectListBorder} } `),e.push(`.monaco-select-box-dropdown-container > .select-box-details-pane.border-bottom { border-bottom: 1px solid ${this.styles.selectListBorder} } `)),this.styles.listHoverForeground&&e.push(`.monaco-select-box-dropdown-container > .select-box-dropdown-list-container .monaco-list .monaco-list-row:not(.option-disabled):not(.focused):hover { color: ${this.styles.listHoverForeground} !important; }`),this.styles.listHoverBackground&&e.push(`.monaco-select-box-dropdown-container > .select-box-dropdown-list-container .monaco-list .monaco-list-row:not(.option-disabled):not(.focused):hover { background-color: ${this.styles.listHoverBackground} !important; }`),this.styles.listFocusOutline&&e.push(`.monaco-select-box-dropdown-container > .select-box-dropdown-list-container .monaco-list .monaco-list-row.focused { outline: 1.6px dotted ${this.styles.listFocusOutline} !important; outline-offset: -1.6px !important; }`),this.styles.listHoverOutline&&e.push(`.monaco-select-box-dropdown-container > .select-box-dropdown-list-container .monaco-list .monaco-list-row:not(.option-disabled):not(.focused):hover { outline: 1.6px dashed ${this.styles.listHoverOutline} !important; outline-offset: -1.6px !important; }`),e.push(".monaco-select-box-dropdown-container > .select-box-dropdown-list-container .monaco-list .monaco-list-row.option-disabled.focused { background-color: transparent !important; color: inherit !important; outline: none !important; }"),e.push(".monaco-select-box-dropdown-container > .select-box-dropdown-list-container .monaco-list .monaco-list-row.option-disabled:hover { background-color: transparent !important; color: inherit !important; outline: none !important; }"),this.styleElement.textContent=e.join("\n")}styleSelectElement(){var e,t,i;const n=null!==(e=this.styles.selectBackground)&&void 0!==e?e:"",o=null!==(t=this.styles.selectForeground)&&void 0!==t?t:"",r=null!==(i=this.styles.selectBorder)&&void 0!==i?i:"";this.selectElement.style.backgroundColor=n,this.selectElement.style.color=o,this.selectElement.style.borderColor=r}styleList(){var e,t;const i=null!==(e=this.styles.selectBackground)&&void 0!==e?e:"",o=n.asCssValueWithDefault(this.styles.selectListBackground,i);this.selectDropDownListContainer.style.backgroundColor=o,this.selectionDetailsPane.style.backgroundColor=o;const r=null!==(t=this.styles.focusBorder)&&void 0!==t?t:"";this.selectDropDownContainer.style.outlineColor=r,this.selectDropDownContainer.style.outlineOffset="-1px",this.selectList.style(this.styles)}createOption(e,t,i){const n=document.createElement("option");return n.value=e,n.text=e,n.disabled=!!i,n}showSelectDropDown(){this.selectionDetailsPane.innerText="",this.contextViewProvider&&!this._isVisible&&(this.createSelectList(this.selectDropDownContainer),this.setOptionsList(),this.contextViewProvider.showContextView({getAnchor:()=>this.selectElement,render:e=>this.renderSelectDropDown(e,!0),layout:()=>{this.layoutSelectDropDown()},onHide:()=>{this.selectDropDownContainer.classList.remove("visible"),this.selectElement.classList.remove("synthetic-focus")},anchorPosition:this._dropDownPosition},this.selectBoxOptions.optionsAsChildren?this.container:void 0),this._isVisible=!0,this.hideSelectDropDown(!1),this.contextViewProvider.showContextView({getAnchor:()=>this.selectElement,render:e=>this.renderSelectDropDown(e),layout:()=>this.layoutSelectDropDown(),onHide:()=>{this.selectDropDownContainer.classList.remove("visible"),this.selectElement.classList.remove("synthetic-focus")},anchorPosition:this._dropDownPosition},this.selectBoxOptions.optionsAsChildren?this.container:void 0),this._currentSelection=this.selected,this._isVisible=!0,this.selectElement.setAttribute("aria-expanded","true"))}hideSelectDropDown(e){this.contextViewProvider&&this._isVisible&&(this._isVisible=!1,this.selectElement.setAttribute("aria-expanded","false"),e&&this.selectElement.focus(),this.contextViewProvider.hideContextView())}renderSelectDropDown(e,t){return e.appendChild(this.selectDropDownContainer),this.layoutSelectDropDown(t),{dispose:()=>{try{e.removeChild(this.selectDropDownContainer)}catch(e){}}}}measureMaxDetailsHeight(){let e=0;return this.options.forEach(((t,i)=>{this.updateDetail(i),this.selectionDetailsPane.offsetHeight>e&&(e=this.selectionDetailsPane.offsetHeight)})),e}layoutSelectDropDown(e){if(this._skipLayout)return!1;if(this.selectList){this.selectDropDownContainer.classList.add("visible");const t=n.getWindow(this.selectElement),i=n.getDomNodePagePosition(this.selectElement),o=n.getWindow(this.selectElement).getComputedStyle(this.selectElement),r=parseFloat(o.getPropertyValue("--dropdown-padding-top"))+parseFloat(o.getPropertyValue("--dropdown-padding-bottom")),s=t.innerHeight-i.top-i.height-(this.selectBoxOptions.minBottomMargin||0),a=i.top-T.DEFAULT_DROPDOWN_MINIMUM_TOP_MARGIN,l=this.selectElement.offsetWidth,c=this.setWidthControlElement(this.widthControlElement),d=Math.max(c,Math.round(l)).toString()+"px";this.selectDropDownContainer.style.width=d,this.selectList.getHTMLElement().style.height="",this.selectList.layout();let u=this.selectList.contentHeight;this._hasDetails&&void 0===this._cachedMaxDetailsHeight&&(this._cachedMaxDetailsHeight=this.measureMaxDetailsHeight());const h=this._hasDetails?this._cachedMaxDetailsHeight:0,g=u+r+h,p=Math.floor((s-r-h)/this.getHeight()),m=Math.floor((a-r-h)/this.getHeight());if(e)return!(i.top+i.height>t.innerHeight-22||i.top<T.DEFAULT_DROPDOWN_MINIMUM_TOP_MARGIN||p<1&&m<1)&&(p<T.DEFAULT_MINIMUM_VISIBLE_OPTIONS&&m>p&&this.options.length>p?(this._dropDownPosition=1,this.selectDropDownContainer.removeChild(this.selectDropDownListContainer),this.selectDropDownContainer.removeChild(this.selectionDetailsPane),this.selectDropDownContainer.appendChild(this.selectionDetailsPane),this.selectDropDownContainer.appendChild(this.selectDropDownListContainer),this.selectionDetailsPane.classList.remove("border-top"),this.selectionDetailsPane.classList.add("border-bottom")):(this._dropDownPosition=0,this.selectDropDownContainer.removeChild(this.selectDropDownListContainer),this.selectDropDownContainer.removeChild(this.selectionDetailsPane),this.selectDropDownContainer.appendChild(this.selectDropDownListContainer),this.selectDropDownContainer.appendChild(this.selectionDetailsPane),this.selectionDetailsPane.classList.remove("border-bottom"),this.selectionDetailsPane.classList.add("border-top")),!0);if(i.top+i.height>t.innerHeight-22||i.top<T.DEFAULT_DROPDOWN_MINIMUM_TOP_MARGIN||0===this._dropDownPosition&&p<1||1===this._dropDownPosition&&m<1)return this.hideSelectDropDown(!0),!1;if(0===this._dropDownPosition){if(this._isVisible&&p+m<1)return this.hideSelectDropDown(!0),!1;g>s&&(u=p*this.getHeight())}else g>a&&(u=m*this.getHeight());return this.selectList.layout(u),this.selectList.domFocus(),this.selectList.length>0&&(this.selectList.setFocus([this.selected||0]),this.selectList.reveal(this.selectList.getFocus()[0]||0)),this._hasDetails?(this.selectList.getHTMLElement().style.height=u+r+"px",this.selectDropDownContainer.style.height=""):this.selectDropDownContainer.style.height=u+r+"px",this.updateDetail(this.selected),this.selectDropDownContainer.style.width=d,this.selectDropDownListContainer.setAttribute("tabindex","0"),this.selectElement.classList.add("synthetic-focus"),this.selectDropDownContainer.classList.add("synthetic-focus"),!0}return!1}setWidthControlElement(e){let t=0;if(e){let i=0,o=0;this.options.forEach(((e,t)=>{const n=e.detail?e.detail.length:0,r=e.decoratorRight?e.decoratorRight.length:0,s=e.text.length+n+r;s>o&&(i=t,o=s)})),e.textContent=this.options[i].text+(this.options[i].decoratorRight?this.options[i].decoratorRight+" ":""),t=n.getTotalWidth(e)}return t}createSelectList(e){if(this.selectList)return;this.selectDropDownListContainer=n.append(e,D(".select-box-dropdown-list-container")),this.listRenderer=new L,this.selectList=new a.List("SelectBoxCustom",this.selectDropDownListContainer,this,[this.listRenderer],{useShadows:!1,verticalScrollMode:3,keyboardSupport:!1,mouseSupport:!1,accessibilityProvider:{getAriaLabel:e=>{let t=e.text;return e.detail&&(t+=`. ${e.detail}`),e.decoratorRight&&(t+=`. ${e.decoratorRight}`),e.description&&(t+=`. ${e.description}`),t},getWidgetAriaLabel:()=>(0,k.localize)("vs/base/browser/ui/selectBox/selectBoxCustom",{key:"selectBox",comment:["Behave like native select dropdown element."]},"Select Box"),getRole:()=>h.isMacintosh?"":"option",getWidgetRole:()=>"listbox"}}),this.selectBoxOptions.ariaLabel&&(this.selectList.ariaLabel=this.selectBoxOptions.ariaLabel);const t=this._register(new o.DomEmitter(this.selectDropDownListContainer,"keydown")),i=c.Event.chain(t.event,(e=>e.filter((()=>this.selectList.length>0)).map((e=>new r.StandardKeyboardEvent(e)))));this._register(c.Event.chain(i,(e=>e.filter((e=>3===e.keyCode))))(this.onEnter,this)),this._register(c.Event.chain(i,(e=>e.filter((e=>2===e.keyCode))))(this.onEnter,this)),this._register(c.Event.chain(i,(e=>e.filter((e=>9===e.keyCode))))(this.onEscape,this)),this._register(c.Event.chain(i,(e=>e.filter((e=>16===e.keyCode))))(this.onUpArrow,this)),this._register(c.Event.chain(i,(e=>e.filter((e=>18===e.keyCode))))(this.onDownArrow,this)),this._register(c.Event.chain(i,(e=>e.filter((e=>12===e.keyCode))))(this.onPageDown,this)),this._register(c.Event.chain(i,(e=>e.filter((e=>11===e.keyCode))))(this.onPageUp,this)),this._register(c.Event.chain(i,(e=>e.filter((e=>14===e.keyCode))))(this.onHome,this)),this._register(c.Event.chain(i,(e=>e.filter((e=>13===e.keyCode))))(this.onEnd,this)),this._register(c.Event.chain(i,(e=>e.filter((e=>e.keyCode>=21&&e.keyCode<=56||e.keyCode>=85&&e.keyCode<=113))))(this.onCharacter,this)),this._register(n.addDisposableListener(this.selectList.getHTMLElement(),n.EventType.POINTER_UP,(e=>this.onPointerUp(e)))),this._register(this.selectList.onMouseOver((e=>void 0!==e.index&&this.selectList.setFocus([e.index])))),this._register(this.selectList.onDidChangeFocus((e=>this.onListFocus(e)))),this._register(n.addDisposableListener(this.selectDropDownContainer,n.EventType.FOCUS_OUT,(e=>{this._isVisible&&!n.isAncestor(e.relatedTarget,this.selectDropDownContainer)&&this.onListBlur()}))),this.selectList.getHTMLElement().setAttribute("aria-label",this.selectBoxOptions.ariaLabel||""),this.selectList.getHTMLElement().setAttribute("aria-expanded","true"),this.styleList()}onPointerUp(e){if(!this.selectList.length)return;n.EventHelper.stop(e);const t=e.target;if(!t)return;if(t.classList.contains("slider"))return;const i=t.closest(".monaco-list-row");if(!i)return;const o=Number(i.getAttribute("data-index")),r=i.classList.contains("option-disabled");o>=0&&o<this.options.length&&!r&&(this.selected=o,this.select(this.selected),this.selectList.setFocus([this.selected]),this.selectList.reveal(this.selectList.getFocus()[0]),this.selected!==this._currentSelection&&(this._currentSelection=this.selected,this._onDidSelect.fire({index:this.selectElement.selectedIndex,selected:this.options[this.selected].text}),this.options[this.selected]&&this.options[this.selected].text&&(this.selectElement.title=this.options[this.selected].text)),this.hideSelectDropDown(!0))}onListBlur(){this._sticky||(this.selected!==this._currentSelection&&this.select(this._currentSelection),this.hideSelectDropDown(!1))}renderDescriptionMarkdown(e,t){const i=e=>{for(let t=0;t<e.childNodes.length;t++){const n=e.childNodes.item(t);"img"===(n.tagName&&n.tagName.toLowerCase())?e.removeChild(n):i(n)}},n=(0,s.renderMarkdown)({value:e,supportThemeIcons:!0},{actionHandler:t});return n.element.classList.add("select-box-description-markdown"),i(n.element),n.element}onListFocus(e){this._isVisible&&this._hasDetails&&this.updateDetail(e.indexes[0])}updateDetail(e){var t,i;this.selectionDetailsPane.innerText="";const n=this.options[e],o=null!==(t=null==n?void 0:n.description)&&void 0!==t?t:"",r=null!==(i=null==n?void 0:n.descriptionIsMarkdown)&&void 0!==i&&i;if(o){if(r){const e=n.descriptionMarkdownActionHandler;this.selectionDetailsPane.appendChild(this.renderDescriptionMarkdown(o,e))}else this.selectionDetailsPane.innerText=o;this.selectionDetailsPane.style.display="block"}else this.selectionDetailsPane.style.display="none";this._skipLayout=!0,this.contextViewProvider.layout(),this._skipLayout=!1}onEscape(e){n.EventHelper.stop(e),this.select(this._currentSelection),this.hideSelectDropDown(!0)}onEnter(e){n.EventHelper.stop(e),this.selected!==this._currentSelection&&(this._currentSelection=this.selected,this._onDidSelect.fire({index:this.selectElement.selectedIndex,selected:this.options[this.selected].text}),this.options[this.selected]&&this.options[this.selected].text&&(this.selectElement.title=this.options[this.selected].text)),this.hideSelectDropDown(!0)}onDownArrow(e){if(this.selected<this.options.length-1){n.EventHelper.stop(e,!0);const t=this.options[this.selected+1].isDisabled;if(t&&this.options.length>this.selected+2)this.selected+=2;else{if(t)return;this.selected++}this.select(this.selected),this.selectList.setFocus([this.selected]),this.selectList.reveal(this.selectList.getFocus()[0])}}onUpArrow(e){if(this.selected>0){n.EventHelper.stop(e,!0);this.options[this.selected-1].isDisabled&&this.selected>1?this.selected-=2:this.selected--,this.select(this.selected),this.selectList.setFocus([this.selected]),this.selectList.reveal(this.selectList.getFocus()[0])}}onPageUp(e){n.EventHelper.stop(e),this.selectList.focusPreviousPage(),setTimeout((()=>{this.selected=this.selectList.getFocus()[0],this.options[this.selected].isDisabled&&this.selected<this.options.length-1&&(this.selected++,this.selectList.setFocus([this.selected])),this.selectList.reveal(this.selected),this.select(this.selected)}),1)}onPageDown(e){n.EventHelper.stop(e),this.selectList.focusNextPage(),setTimeout((()=>{this.selected=this.selectList.getFocus()[0],this.options[this.selected].isDisabled&&this.selected>0&&(this.selected--,this.selectList.setFocus([this.selected])),this.selectList.reveal(this.selected),this.select(this.selected)}),1)}onHome(e){n.EventHelper.stop(e),this.options.length<2||(this.selected=0,this.options[this.selected].isDisabled&&this.selected>1&&this.selected++,this.selectList.setFocus([this.selected]),this.selectList.reveal(this.selected),this.select(this.selected))}onEnd(e){n.EventHelper.stop(e),this.options.length<2||(this.selected=this.options.length-1,this.options[this.selected].isDisabled&&this.selected>1&&this.selected--,this.selectList.setFocus([this.selected]),this.selectList.reveal(this.selected),this.select(this.selected))}onCharacter(e){const t=d.KeyCodeUtils.toString(e.keyCode);let i=-1;for(let o=0;o<this.options.length-1;o++)if(i=(o+this.selected+1)%this.options.length,this.options[i].text.charAt(0).toUpperCase()===t&&!this.options[i].isDisabled){this.select(i),this.selectList.setFocus([i]),this.selectList.reveal(this.selectList.getFocus()[0]),n.EventHelper.stop(e);break}}dispose(){this.hideSelectDropDown(!1),super.dispose()}}T.DEFAULT_DROPDOWN_MINIMUM_BOTTOM_MARGIN=32,T.DEFAULT_DROPDOWN_MINIMUM_TOP_MARGIN=2,T.DEFAULT_MINIMUM_VISIBLE_OPTIONS=3},96696:function(e,t,i){"use strict";i.r(t),i.d(t,{SelectBoxNative:function(){return c}});var n=i(96747),o=i(4043),r=i(64998),s=i(63801),a=i(68921),l=i(66719);class c extends a.Disposable{constructor(e,t,i,n){super(),this.selected=0,this.selectBoxOptions=n||Object.create(null),this.options=[],this.selectElement=document.createElement("select"),this.selectElement.className="monaco-select-box","string"==typeof this.selectBoxOptions.ariaLabel&&this.selectElement.setAttribute("aria-label",this.selectBoxOptions.ariaLabel),"string"==typeof this.selectBoxOptions.ariaDescription&&this.selectElement.setAttribute("aria-description",this.selectBoxOptions.ariaDescription),this._onDidSelect=this._register(new s.Emitter),this.styles=i,this.registerListeners(),this.setOptions(e,t)}registerListeners(){this._register(o.Gesture.addTarget(this.selectElement)),[o.EventType.Tap].forEach((e=>{this._register(n.addDisposableListener(this.selectElement,e,(e=>{this.selectElement.focus()})))})),this._register(n.addStandardDisposableListener(this.selectElement,"click",(e=>{n.EventHelper.stop(e,!0)}))),this._register(n.addStandardDisposableListener(this.selectElement,"change",(e=>{this.selectElement.title=e.target.value,this._onDidSelect.fire({index:e.target.selectedIndex,selected:e.target.value})}))),this._register(n.addStandardDisposableListener(this.selectElement,"keydown",(e=>{let t=!1;l.isMacintosh?18!==e.keyCode&&16!==e.keyCode&&10!==e.keyCode||(t=!0):(18===e.keyCode&&e.altKey||10===e.keyCode||3===e.keyCode)&&(t=!0),t&&e.stopPropagation()})))}get onDidSelect(){return this._onDidSelect.event}setOptions(e,t){this.options&&r.equals(this.options,e)||(this.options=e,this.selectElement.options.length=0,this.options.forEach(((e,t)=>{this.selectElement.add(this.createOption(e.text,t,e.isDisabled))}))),void 0!==t&&this.select(t)}select(e){0===this.options.length?this.selected=0:e>=0&&e<this.options.length?this.selected=e:e>this.options.length-1?this.select(this.options.length-1):this.selected<0&&(this.selected=0),this.selectElement.selectedIndex=this.selected,this.selected<this.options.length&&"string"==typeof this.options[this.selected].text?this.selectElement.title=this.options[this.selected].text:this.selectElement.title=""}focus(){this.selectElement&&(this.selectElement.tabIndex=0,this.selectElement.focus())}blur(){this.selectElement&&(this.selectElement.tabIndex=-1,this.selectElement.blur())}setFocusable(e){this.selectElement.tabIndex=e?0:-1}render(e){e.classList.add("select-container"),e.appendChild(this.selectElement),this.setOptions(this.options,this.selected),this.applyStyles()}applyStyles(){var e,t,i;this.selectElement&&(this.selectElement.style.backgroundColor=null!==(e=this.styles.selectBackground)&&void 0!==e?e:"",this.selectElement.style.color=null!==(t=this.styles.selectForeground)&&void 0!==t?t:"",this.selectElement.style.borderColor=null!==(i=this.styles.selectBorder)&&void 0!==i?i:"")}createOption(e,t,i){const n=document.createElement("option");return n.value=e,n.text=e,n.disabled=!!i,n}}},70626:function(e,t,i){"use strict";i.r(t),i.d(t,{Sizing:function(){return N},SplitView:function(){return R}});var n=i(96747),o=i(50465),r=i(59625),s=i(34309),a=i(64998),l=i(17160),c=i(63801),d=i(68921),u=i(53719),h=i(6097),g=i(18912),p=i(93379),m=i.n(p),f=i(7795),b=i.n(f),v=i(90569),_=i.n(v),A=i(3565),C=i.n(A),w=i(19216),y=i.n(w),S=i(44589),x=i.n(S),E=i(35201),k={};k.styleTagTransform=x(),k.setAttributes=C(),k.insert=_().bind(null,"head"),k.domAPI=b(),k.insertStyleElement=y();m()(E.Z,k),E.Z&&E.Z.locals&&E.Z.locals;const D={separatorBorder:l.Color.transparent};class I{set size(e){this._size=e}get size(){return this._size}get visible(){return void 0===this._cachedVisibleSize}setVisible(e,t){var i,n;if(e!==this.visible){e?(this.size=(0,u.clamp)(this._cachedVisibleSize,this.viewMinimumSize,this.viewMaximumSize),this._cachedVisibleSize=void 0):(this._cachedVisibleSize="number"==typeof t?t:this.size,this.size=0),this.container.classList.toggle("visible",e);try{null===(n=(i=this.view).setVisible)||void 0===n||n.call(i,e)}catch(e){console.error("Splitview: Failed to set visible view"),console.error(e)}}}get minimumSize(){return this.visible?this.view.minimumSize:0}get viewMinimumSize(){return this.view.minimumSize}get maximumSize(){return this.visible?this.view.maximumSize:0}get viewMaximumSize(){return this.view.maximumSize}get priority(){return this.view.priority}get proportionalLayout(){var e;return null===(e=this.view.proportionalLayout)||void 0===e||e}get snap(){return!!this.view.snap}set enabled(e){this.container.style.pointerEvents=e?"":"none"}constructor(e,t,i,n){this.container=e,this.view=t,this.disposable=n,this._cachedVisibleSize=void 0,"number"==typeof i?(this._size=i,this._cachedVisibleSize=void 0,e.classList.add("visible")):(this._size=0,this._cachedVisibleSize=i.cachedVisibleSize)}layout(e,t){this.layoutContainer(e);try{this.view.layout(this.size,e,t)}catch(e){console.error("Splitview: Failed to layout view"),console.error(e)}}dispose(){this.disposable.dispose()}}class L extends I{layoutContainer(e){this.container.style.top=`${e}px`,this.container.style.height=`${this.size}px`}}class T extends I{layoutContainer(e){this.container.style.left=`${e}px`,this.container.style.width=`${this.size}px`}}var M,N;!function(e){e[e.Idle=0]="Idle",e[e.Busy=1]="Busy"}(M||(M={})),function(e){e.Distribute={type:"distribute"},e.Split=function(e){return{type:"split",index:e}},e.Auto=function(e){return{type:"auto",index:e}},e.Invisible=function(e){return{type:"invisible",cachedVisibleSize:e}}}(N||(N={}));class R extends d.Disposable{get orthogonalStartSash(){return this._orthogonalStartSash}get orthogonalEndSash(){return this._orthogonalEndSash}get startSnappingEnabled(){return this._startSnappingEnabled}get endSnappingEnabled(){return this._endSnappingEnabled}set orthogonalStartSash(e){for(const t of this.sashItems)t.sash.orthogonalStartSash=e;this._orthogonalStartSash=e}set orthogonalEndSash(e){for(const t of this.sashItems)t.sash.orthogonalEndSash=e;this._orthogonalEndSash=e}set startSnappingEnabled(e){this._startSnappingEnabled!==e&&(this._startSnappingEnabled=e,this.updateSashEnablement())}set endSnappingEnabled(e){this._endSnappingEnabled!==e&&(this._endSnappingEnabled=e,this.updateSashEnablement())}constructor(e,t={}){var i,r,a,l,d;super(),this.size=0,this._contentSize=0,this.proportions=void 0,this.viewItems=[],this.sashItems=[],this.state=M.Idle,this._onDidSashChange=this._register(new c.Emitter),this._onDidSashReset=this._register(new c.Emitter),this._startSnappingEnabled=!0,this._endSnappingEnabled=!0,this.onDidSashChange=this._onDidSashChange.event,this.onDidSashReset=this._onDidSashReset.event,this.orientation=null!==(i=t.orientation)&&void 0!==i?i:0,this.inverseAltBehavior=null!==(r=t.inverseAltBehavior)&&void 0!==r&&r,this.proportionalLayout=null===(a=t.proportionalLayout)||void 0===a||a,this.getSashOrthogonalSize=t.getSashOrthogonalSize,this.el=document.createElement("div"),this.el.classList.add("monaco-split-view2"),this.el.classList.add(0===this.orientation?"vertical":"horizontal"),e.appendChild(this.el),this.sashContainer=(0,n.append)(this.el,(0,n.$)(".sash-container")),this.viewContainer=(0,n.$)(".split-view-container"),this.scrollable=this._register(new h.Scrollable({forceIntegerValues:!0,smoothScrollDuration:125,scheduleAtNextAnimationFrame:e=>(0,n.scheduleAtNextAnimationFrame)((0,n.getWindow)(this.el),e)})),this.scrollableElement=this._register(new s.SmoothScrollableElement(this.viewContainer,{vertical:0===this.orientation?null!==(l=t.scrollbarVisibility)&&void 0!==l?l:1:2,horizontal:1===this.orientation?null!==(d=t.scrollbarVisibility)&&void 0!==d?d:1:2},this.scrollable));const u=this._register(new o.DomEmitter(this.viewContainer,"scroll")).event;this._register(u((e=>{const t=this.scrollableElement.getScrollPosition(),i=Math.abs(this.viewContainer.scrollLeft-t.scrollLeft)<=1?void 0:this.viewContainer.scrollLeft,n=Math.abs(this.viewContainer.scrollTop-t.scrollTop)<=1?void 0:this.viewContainer.scrollTop;void 0===i&&void 0===n||this.scrollableElement.setScrollPosition({scrollLeft:i,scrollTop:n})}))),this.onDidScroll=this.scrollableElement.onScroll,this._register(this.onDidScroll((e=>{e.scrollTopChanged&&(this.viewContainer.scrollTop=e.scrollTop),e.scrollLeftChanged&&(this.viewContainer.scrollLeft=e.scrollLeft)}))),(0,n.append)(this.el,this.scrollableElement.getDomNode()),this.style(t.styles||D),t.descriptor&&(this.size=t.descriptor.size,t.descriptor.views.forEach(((e,t)=>{const i=g.isUndefined(e.visible)||e.visible?e.size:{type:"invisible",cachedVisibleSize:e.size},n=e.view;this.doAddView(n,i,t,!0)})),this._contentSize=this.viewItems.reduce(((e,t)=>e+t.size),0),this.saveProportions())}style(e){e.separatorBorder.isTransparent()?(this.el.classList.remove("separator-border"),this.el.style.removeProperty("--separator-border")):(this.el.classList.add("separator-border"),this.el.style.setProperty("--separator-border",e.separatorBorder.toString()))}addView(e,t,i=this.viewItems.length,n){this.doAddView(e,t,i,n)}layout(e,t){const i=Math.max(this.size,this._contentSize);if(this.size=e,this.layoutContext=t,this.proportions){let t=0;for(let i=0;i<this.viewItems.length;i++){const n=this.viewItems[i],o=this.proportions[i];"number"==typeof o?t+=o:e-=n.size}for(let i=0;i<this.viewItems.length;i++){const n=this.viewItems[i],o=this.proportions[i];"number"==typeof o&&t>0&&(n.size=(0,u.clamp)(Math.round(o*e/t),n.minimumSize,n.maximumSize))}}else{const t=(0,a.range)(this.viewItems.length),n=t.filter((e=>1===this.viewItems[e].priority)),o=t.filter((e=>2===this.viewItems[e].priority));this.resize(this.viewItems.length-1,e-i,void 0,n,o)}this.distributeEmptySpace(),this.layoutViews()}saveProportions(){this.proportionalLayout&&this._contentSize>0&&(this.proportions=this.viewItems.map((e=>e.proportionalLayout&&e.visible?e.size/this._contentSize:void 0)))}onSashStart({sash:e,start:t,alt:i}){for(const e of this.viewItems)e.enabled=!1;const o=this.sashItems.findIndex((t=>t.sash===e)),r=(0,d.combinedDisposable)((0,n.addDisposableListener)(this.el.ownerDocument.body,"keydown",(e=>s(this.sashDragState.current,e.altKey))),(0,n.addDisposableListener)(this.el.ownerDocument.body,"keyup",(()=>s(this.sashDragState.current,!1)))),s=(e,t)=>{const i=this.viewItems.map((e=>e.size));let n,s,l=Number.NEGATIVE_INFINITY,c=Number.POSITIVE_INFINITY;if(this.inverseAltBehavior&&(t=!t),t){if(o===this.sashItems.length-1){const e=this.viewItems[o];l=(e.minimumSize-e.size)/2,c=(e.maximumSize-e.size)/2}else{const e=this.viewItems[o+1];l=(e.size-e.maximumSize)/2,c=(e.size-e.minimumSize)/2}}if(!t){const e=(0,a.range)(o,-1),t=(0,a.range)(o+1,this.viewItems.length),r=e.reduce(((e,t)=>e+(this.viewItems[t].minimumSize-i[t])),0),l=e.reduce(((e,t)=>e+(this.viewItems[t].viewMaximumSize-i[t])),0),c=0===t.length?Number.POSITIVE_INFINITY:t.reduce(((e,t)=>e+(i[t]-this.viewItems[t].minimumSize)),0),d=0===t.length?Number.NEGATIVE_INFINITY:t.reduce(((e,t)=>e+(i[t]-this.viewItems[t].viewMaximumSize)),0),u=Math.max(r,d),h=Math.min(c,l),g=this.findFirstSnapIndex(e),p=this.findFirstSnapIndex(t);if("number"==typeof g){const e=this.viewItems[g],t=Math.floor(e.viewMinimumSize/2);n={index:g,limitDelta:e.visible?u-t:u+t,size:e.size}}if("number"==typeof p){const e=this.viewItems[p],t=Math.floor(e.viewMinimumSize/2);s={index:p,limitDelta:e.visible?h+t:h-t,size:e.size}}}this.sashDragState={start:e,current:e,index:o,sizes:i,minDelta:l,maxDelta:c,alt:t,snapBefore:n,snapAfter:s,disposable:r}};s(t,i)}onSashChange({current:e}){const{index:t,start:i,sizes:n,alt:o,minDelta:r,maxDelta:s,snapBefore:a,snapAfter:l}=this.sashDragState;this.sashDragState.current=e;const c=e-i,d=this.resize(t,c,n,void 0,void 0,r,s,a,l);if(o){const e=t===this.sashItems.length-1,i=this.viewItems.map((e=>e.size)),n=e?t:t+1,o=this.viewItems[n],r=o.size-o.maximumSize,s=o.size-o.minimumSize,a=e?t-1:t+1;this.resize(a,-d,i,void 0,void 0,r,s)}this.distributeEmptySpace(),this.layoutViews()}onSashEnd(e){this._onDidSashChange.fire(e),this.sashDragState.disposable.dispose(),this.saveProportions();for(const e of this.viewItems)e.enabled=!0}onViewChange(e,t){const i=this.viewItems.indexOf(e);i<0||i>=this.viewItems.length||(t="number"==typeof t?t:e.size,t=(0,u.clamp)(t,e.minimumSize,e.maximumSize),this.inverseAltBehavior&&i>0?(this.resize(i-1,Math.floor((e.size-t)/2)),this.distributeEmptySpace(),this.layoutViews()):(e.size=t,this.relayout([i],void 0)))}resizeView(e,t){if(!(e<0||e>=this.viewItems.length)){if(this.state!==M.Idle)throw new Error("Cant modify splitview");this.state=M.Busy;try{const i=(0,a.range)(this.viewItems.length).filter((t=>t!==e)),n=[...i.filter((e=>1===this.viewItems[e].priority)),e],o=i.filter((e=>2===this.viewItems[e].priority)),r=this.viewItems[e];t=Math.round(t),t=(0,u.clamp)(t,r.minimumSize,Math.min(r.maximumSize,this.size)),r.size=t,this.relayout(n,o)}finally{this.state=M.Idle}}}distributeViewSizes(){const e=[];let t=0;for(const i of this.viewItems)i.maximumSize-i.minimumSize>0&&(e.push(i),t+=i.size);const i=Math.floor(t/e.length);for(const t of e)t.size=(0,u.clamp)(i,t.minimumSize,t.maximumSize);const n=(0,a.range)(this.viewItems.length),o=n.filter((e=>1===this.viewItems[e].priority)),r=n.filter((e=>2===this.viewItems[e].priority));this.relayout(o,r)}getViewSize(e){return e<0||e>=this.viewItems.length?-1:this.viewItems[e].size}doAddView(e,t,i=this.viewItems.length,o){if(this.state!==M.Idle)throw new Error("Cant modify splitview");this.state=M.Busy;try{const s=(0,n.$)(".split-view-view");i===this.viewItems.length?this.viewContainer.appendChild(s):this.viewContainer.insertBefore(s,this.viewContainer.children.item(i));const l=e.onDidChange((e=>this.onViewChange(p,e))),u=(0,d.toDisposable)((()=>this.viewContainer.removeChild(s))),h=(0,d.combinedDisposable)(l,u);let g;"number"==typeof t?g=t:("auto"===t.type&&(t=this.areViewsDistributed()?{type:"distribute"}:{type:"split",index:t.index}),g="split"===t.type?this.getViewSize(t.index)/2:"invisible"===t.type?{cachedVisibleSize:t.cachedVisibleSize}:e.minimumSize);const p=0===this.orientation?new L(s,e,g,h):new T(s,e,g,h);if(this.viewItems.splice(i,0,p),this.viewItems.length>1){const e={orthogonalStartSash:this.orthogonalStartSash,orthogonalEndSash:this.orthogonalEndSash},t=0===this.orientation?new r.Sash(this.sashContainer,{getHorizontalSashTop:e=>this.getSashPosition(e),getHorizontalSashWidth:this.getSashOrthogonalSize},{...e,orientation:1}):new r.Sash(this.sashContainer,{getVerticalSashLeft:e=>this.getSashPosition(e),getVerticalSashHeight:this.getSashOrthogonalSize},{...e,orientation:0}),n=0===this.orientation?e=>({sash:t,start:e.startY,current:e.currentY,alt:e.altKey}):e=>({sash:t,start:e.startX,current:e.currentX,alt:e.altKey}),o=c.Event.map(t.onDidStart,n)(this.onSashStart,this),s=c.Event.map(t.onDidChange,n)(this.onSashChange,this),l=c.Event.map(t.onDidEnd,(()=>this.sashItems.findIndex((e=>e.sash===t)))),u=l(this.onSashEnd,this),h=t.onDidReset((()=>{const e=this.sashItems.findIndex((e=>e.sash===t)),i=(0,a.range)(e,-1),n=(0,a.range)(e+1,this.viewItems.length),o=this.findFirstSnapIndex(i),r=this.findFirstSnapIndex(n);("number"!=typeof o||this.viewItems[o].visible)&&("number"!=typeof r||this.viewItems[r].visible)&&this._onDidSashReset.fire(e)})),g=(0,d.combinedDisposable)(o,s,u,h,t),p={sash:t,disposable:g};this.sashItems.splice(i-1,0,p)}let m;s.appendChild(e.element),"number"!=typeof t&&"split"===t.type&&(m=[t.index]),o||this.relayout([i],m),o||"number"==typeof t||"distribute"!==t.type||this.distributeViewSizes()}finally{this.state=M.Idle}}relayout(e,t){const i=this.viewItems.reduce(((e,t)=>e+t.size),0);this.resize(this.viewItems.length-1,this.size-i,void 0,e,t),this.distributeEmptySpace(),this.layoutViews(),this.saveProportions()}resize(e,t,i=this.viewItems.map((e=>e.size)),n,o,r=Number.NEGATIVE_INFINITY,s=Number.POSITIVE_INFINITY,l,c){if(e<0||e>=this.viewItems.length)return 0;const d=(0,a.range)(e,-1),h=(0,a.range)(e+1,this.viewItems.length);if(o)for(const e of o)(0,a.pushToStart)(d,e),(0,a.pushToStart)(h,e);if(n)for(const e of n)(0,a.pushToEnd)(d,e),(0,a.pushToEnd)(h,e);const g=d.map((e=>this.viewItems[e])),p=d.map((e=>i[e])),m=h.map((e=>this.viewItems[e])),f=h.map((e=>i[e])),b=d.reduce(((e,t)=>e+(this.viewItems[t].minimumSize-i[t])),0),v=d.reduce(((e,t)=>e+(this.viewItems[t].maximumSize-i[t])),0),_=0===h.length?Number.POSITIVE_INFINITY:h.reduce(((e,t)=>e+(i[t]-this.viewItems[t].minimumSize)),0),A=0===h.length?Number.NEGATIVE_INFINITY:h.reduce(((e,t)=>e+(i[t]-this.viewItems[t].maximumSize)),0),C=Math.max(b,A,r),w=Math.min(_,v,s);let y=!1;if(l){const e=this.viewItems[l.index],i=t>=l.limitDelta;y=i!==e.visible,e.setVisible(i,l.size)}if(!y&&c){const e=this.viewItems[c.index],i=t<c.limitDelta;y=i!==e.visible,e.setVisible(i,c.size)}if(y)return this.resize(e,t,i,n,o,r,s);for(let e=0,i=t=(0,u.clamp)(t,C,w);e<g.length;e++){const t=g[e],n=(0,u.clamp)(p[e]+i,t.minimumSize,t.maximumSize);i-=n-p[e],t.size=n}for(let e=0,i=t;e<m.length;e++){const t=m[e],n=(0,u.clamp)(f[e]-i,t.minimumSize,t.maximumSize);i+=n-f[e],t.size=n}return t}distributeEmptySpace(e){const t=this.viewItems.reduce(((e,t)=>e+t.size),0);let i=this.size-t;const n=(0,a.range)(this.viewItems.length-1,-1),o=n.filter((e=>1===this.viewItems[e].priority)),r=n.filter((e=>2===this.viewItems[e].priority));for(const e of r)(0,a.pushToStart)(n,e);for(const e of o)(0,a.pushToEnd)(n,e);"number"==typeof e&&(0,a.pushToEnd)(n,e);for(let e=0;0!==i&&e<n.length;e++){const t=this.viewItems[n[e]],o=(0,u.clamp)(t.size+i,t.minimumSize,t.maximumSize);i-=o-t.size,t.size=o}}layoutViews(){this._contentSize=this.viewItems.reduce(((e,t)=>e+t.size),0);let e=0;for(const t of this.viewItems)t.layout(e,this.layoutContext),e+=t.size;this.sashItems.forEach((e=>e.sash.layout())),this.updateSashEnablement(),this.updateScrollableElement()}updateScrollableElement(){0===this.orientation?this.scrollableElement.setScrollDimensions({height:this.size,scrollHeight:this._contentSize}):this.scrollableElement.setScrollDimensions({width:this.size,scrollWidth:this._contentSize})}updateSashEnablement(){let e=!1;const t=this.viewItems.map((t=>e=t.size-t.minimumSize>0||e));e=!1;const i=this.viewItems.map((t=>e=t.maximumSize-t.size>0||e)),n=[...this.viewItems].reverse();e=!1;const o=n.map((t=>e=t.size-t.minimumSize>0||e)).reverse();e=!1;const r=n.map((t=>e=t.maximumSize-t.size>0||e)).reverse();let s=0;for(let e=0;e<this.sashItems.length;e++){const{sash:n}=this.sashItems[e];s+=this.viewItems[e].size;const l=!(t[e]&&r[e+1]),c=!(i[e]&&o[e+1]);if(l&&c){const i=(0,a.range)(e,-1),r=(0,a.range)(e+1,this.viewItems.length),l=this.findFirstSnapIndex(i),c=this.findFirstSnapIndex(r),d="number"==typeof l&&!this.viewItems[l].visible,u="number"==typeof c&&!this.viewItems[c].visible;d&&o[e]&&(s>0||this.startSnappingEnabled)?n.state=1:u&&t[e]&&(s<this._contentSize||this.endSnappingEnabled)?n.state=2:n.state=0}else n.state=l&&!c?1:!l&&c?2:3}}getSashPosition(e){let t=0;for(let i=0;i<this.sashItems.length;i++)if(t+=this.viewItems[i].size,this.sashItems[i].sash===e)return t;return 0}findFirstSnapIndex(e){for(const t of e){const e=this.viewItems[t];if(e.visible&&e.snap)return t}for(const t of e){const e=this.viewItems[t];if(e.visible&&e.maximumSize-e.minimumSize>0)return;if(!e.visible&&e.snap)return t}}areViewsDistributed(){let e,t;for(const i of this.viewItems)if(e=void 0===e?i.size:Math.min(e,i.size),t=void 0===t?i.size:Math.max(t,i.size),t-e>2)return!1;return!0}dispose(){var e;null===(e=this.sashDragState)||void 0===e||e.disposable.dispose(),(0,d.dispose)(this.viewItems),this.viewItems=[],this.sashItems.forEach((e=>e.disposable.dispose())),this.sashItems=[],super.dispose()}}},6507:function(e,t,i){"use strict";i.r(t),i.d(t,{Table:function(){return S}});var n=i(96747),o=i(72406),r=i(70626),s=i(63801),a=i(68921),l=i(93379),c=i.n(l),d=i(7795),u=i.n(d),h=i(90569),g=i.n(h),p=i(3565),m=i.n(p),f=i(19216),b=i.n(f),v=i(44589),_=i.n(v),A=i(78590),C={};C.styleTagTransform=_(),C.setAttributes=m(),C.insert=g().bind(null,"head"),C.domAPI=u(),C.insertStyleElement=b();c()(A.Z,C),A.Z&&A.Z.locals&&A.Z.locals;class w{constructor(e,t,i){this.columns=e,this.getColumnSize=i,this.templateId=w.TemplateId,this.renderedTemplates=new Set;const n=new Map(t.map((e=>[e.templateId,e])));this.renderers=[];for(const t of e){const e=n.get(t.templateId);if(!e)throw new Error(`Table cell renderer for template id ${t.templateId} not found.`);this.renderers.push(e)}}renderTemplate(e){const t=(0,n.append)(e,(0,n.$)(".monaco-table-tr")),i=[],o=[];for(let e=0;e<this.columns.length;e++){const r=this.renderers[e],s=(0,n.append)(t,(0,n.$)(".monaco-table-td",{"data-col-index":e}));s.style.width=`${this.getColumnSize(e)}px`,i.push(s),o.push(r.renderTemplate(s))}const r={container:e,cellContainers:i,cellTemplateData:o};return this.renderedTemplates.add(r),r}renderElement(e,t,i,n){for(let o=0;o<this.columns.length;o++){const r=this.columns[o].project(e);this.renderers[o].renderElement(r,t,i.cellTemplateData[o],n)}}disposeElement(e,t,i,n){for(let o=0;o<this.columns.length;o++){const r=this.renderers[o];if(r.disposeElement){const s=this.columns[o].project(e);r.disposeElement(s,t,i.cellTemplateData[o],n)}}}disposeTemplate(e){for(let t=0;t<this.columns.length;t++){this.renderers[t].disposeTemplate(e.cellTemplateData[t])}(0,n.clearNode)(e.container),this.renderedTemplates.delete(e)}layoutColumn(e,t){for(const{cellContainers:i}of this.renderedTemplates)i[e].style.width=`${t}px`}}w.TemplateId="row";class y{get minimumSize(){var e;return null!==(e=this.column.minimumWidth)&&void 0!==e?e:120}get maximumSize(){var e;return null!==(e=this.column.maximumWidth)&&void 0!==e?e:Number.POSITIVE_INFINITY}get onDidChange(){var e;return null!==(e=this.column.onDidChangeWidthConstraints)&&void 0!==e?e:s.Event.None}constructor(e,t){this.column=e,this.index=t,this._onDidLayout=new s.Emitter,this.onDidLayout=this._onDidLayout.event,this.element=(0,n.$)(".monaco-table-th",{"data-col-index":t,title:e.tooltip},e.label)}layout(e){this._onDidLayout.fire([this.index,e])}}class S{get onDidChangeFocus(){return this.list.onDidChangeFocus}get onDidChangeSelection(){return this.list.onDidChangeSelection}get onDidScroll(){return this.list.onDidScroll}get onMouseDblClick(){return this.list.onMouseDblClick}get onPointer(){return this.list.onPointer}get onDidFocus(){return this.list.onDidFocus}get scrollTop(){return this.list.scrollTop}set scrollTop(e){this.list.scrollTop=e}get scrollHeight(){return this.list.scrollHeight}get renderHeight(){return this.list.renderHeight}get onDidDispose(){return this.list.onDidDispose}constructor(e,t,i,l,c,d){this.virtualDelegate=i,this.domId="table_id_"+ ++S.InstanceCount,this.disposables=new a.DisposableStore,this.cachedWidth=0,this.cachedHeight=0,this.domNode=(0,n.append)(t,(0,n.$)(`.monaco-table.${this.domId}`));const u=l.map(((e,t)=>new y(e,t))),h={size:u.reduce(((e,t)=>e+t.column.weight),0),views:u.map((e=>({size:e.column.weight,view:e})))};this.splitview=this.disposables.add(new r.SplitView(this.domNode,{orientation:1,scrollbarVisibility:2,getSashOrthogonalSize:()=>this.cachedHeight,descriptor:h})),this.splitview.el.style.height=`${i.headerRowHeight}px`,this.splitview.el.style.lineHeight=`${i.headerRowHeight}px`;const g=new w(l,c,(e=>this.splitview.getViewSize(e)));var p;this.list=this.disposables.add(new o.List(e,this.domNode,(p=i,{getHeight(e){return p.getHeight(e)},getTemplateId(){return w.TemplateId}}),[g],d)),s.Event.any(...u.map((e=>e.onDidLayout)))((([e,t])=>g.layoutColumn(e,t)),null,this.disposables),this.splitview.onDidSashReset((e=>{const t=l.reduce(((e,t)=>e+t.weight),0),i=l[e].weight/t*this.cachedWidth;this.splitview.resizeView(e,i)}),null,this.disposables),this.styleElement=(0,n.createStyleSheet)(this.domNode),this.style(o.unthemedListStyles)}updateOptions(e){this.list.updateOptions(e)}splice(e,t,i=[]){this.list.splice(e,t,i)}getHTMLElement(){return this.domNode}style(e){const t=[];t.push(`.monaco-table.${this.domId} > .monaco-split-view2 .monaco-sash.vertical::before {\n\t\t\ttop: ${this.virtualDelegate.headerRowHeight+1}px;\n\t\t\theight: calc(100% - ${this.virtualDelegate.headerRowHeight}px);\n\t\t}`),this.styleElement.textContent=t.join("\n"),this.list.style(e)}getSelectedElements(){return this.list.getSelectedElements()}getSelection(){return this.list.getSelection()}getFocus(){return this.list.getFocus()}dispose(){this.disposables.dispose()}}S.InstanceCount=0},50797:function(e,t,i){"use strict";i.r(t),i.d(t,{Toggle:function(){return C},unthemedToggleStyles:function(){return A}});var n=i(47257),o=i(27269),r=i(63801),s=i(93379),a=i.n(s),l=i(7795),c=i.n(l),d=i(90569),u=i.n(d),h=i(3565),g=i.n(h),p=i(19216),m=i.n(p),f=i(44589),b=i.n(f),v=i(69811),_={};_.styleTagTransform=b(),_.setAttributes=g(),_.insert=u().bind(null,"head"),_.domAPI=c(),_.insertStyleElement=m();a()(v.Z,_),v.Z&&v.Z.locals&&v.Z.locals;const A={inputActiveOptionBorder:"#007ACC00",inputActiveOptionForeground:"#FFFFFF",inputActiveOptionBackground:"#0E639C50"};class C extends n.Widget{constructor(e){super(),this._onChange=this._register(new r.Emitter),this.onChange=this._onChange.event,this._onKeyDown=this._register(new r.Emitter),this.onKeyDown=this._onKeyDown.event,this._opts=e,this._checked=this._opts.isChecked;const t=["monaco-custom-toggle"];this._opts.icon&&(this._icon=this._opts.icon,t.push(...o.ThemeIcon.asClassNameArray(this._icon))),this._opts.actionClassName&&t.push(...this._opts.actionClassName.split(" ")),this._checked&&t.push("checked"),this.domNode=document.createElement("div"),this.domNode.title=this._opts.title,this.domNode.classList.add(...t),this._opts.notFocusable||(this.domNode.tabIndex=0),this.domNode.setAttribute("role","checkbox"),this.domNode.setAttribute("aria-checked",String(this._checked)),this.domNode.setAttribute("aria-label",this._opts.title),this.applyStyles(),this.onclick(this.domNode,(e=>{this.enabled&&(this.checked=!this._checked,this._onChange.fire(!1),e.preventDefault())})),this._register(this.ignoreGesture(this.domNode)),this.onkeydown(this.domNode,(e=>{if(10===e.keyCode||3===e.keyCode)return this.checked=!this._checked,this._onChange.fire(!0),e.preventDefault(),void e.stopPropagation();this._onKeyDown.fire(e)}))}get enabled(){return"true"!==this.domNode.getAttribute("aria-disabled")}focus(){this.domNode.focus()}get checked(){return this._checked}set checked(e){this._checked=e,this.domNode.setAttribute("aria-checked",String(this._checked)),this.domNode.classList.toggle("checked",this._checked),this.applyStyles()}width(){return 22}applyStyles(){this.domNode&&(this.domNode.style.borderColor=this._checked&&this._opts.inputActiveOptionBorder||"",this.domNode.style.color=this._checked&&this._opts.inputActiveOptionForeground||"inherit",this.domNode.style.backgroundColor=this._checked&&this._opts.inputActiveOptionBackground||"")}enable(){this.domNode.setAttribute("aria-disabled",String(!1))}disable(){this.domNode.setAttribute("aria-disabled",String(!0))}}},77323:function(e,t,i){"use strict";i.r(t),i.d(t,{ToggleMenuAction:function(){return E},ToolBar:function(){return x}});var n=i(31532),o=i(36720),r=i(60969),s=i(56087),a=i(27269),l=i(63801),c=i(68921),d=i(93379),u=i.n(d),h=i(7795),g=i.n(h),p=i(90569),m=i.n(p),f=i(3565),b=i.n(f),v=i(19216),_=i.n(v),A=i(44589),C=i.n(A),w=i(86228),y={};y.styleTagTransform=C(),y.setAttributes=b(),y.insert=m().bind(null,"head"),y.domAPI=g(),y.insertStyleElement=_();u()(w.Z,y),w.Z&&w.Z.locals&&w.Z.locals;var S=i(83787);class x extends c.Disposable{constructor(e,t,i={orientation:0}){super(),this.submenuActionViewItems=[],this.hasSecondaryActions=!1,this._onDidChangeDropdownVisibility=this._register(new l.EventMultiplexer),this.onDidChangeDropdownVisibility=this._onDidChangeDropdownVisibility.event,this.disposables=this._register(new c.DisposableStore),this.options=i,this.lookupKeybindings="function"==typeof this.options.getKeyBinding,this.toggleMenuAction=this._register(new E((()=>{var e;return null===(e=this.toggleMenuActionViewItem)||void 0===e?void 0:e.show()}),i.toggleMenuTitle)),this.element=document.createElement("div"),this.element.className="monaco-toolbar",e.appendChild(this.element),this.actionBar=this._register(new n.ActionBar(this.element,{orientation:i.orientation,ariaLabel:i.ariaLabel,actionRunner:i.actionRunner,allowContextMenu:i.allowContextMenu,highlightToggledItems:i.highlightToggledItems,actionViewItemProvider:(e,n)=>{var l;if(e.id===E.ID)return this.toggleMenuActionViewItem=new o.DropdownMenuActionViewItem(e,e.menuActions,t,{actionViewItemProvider:this.options.actionViewItemProvider,actionRunner:this.actionRunner,keybindingProvider:this.options.getKeyBinding,classNames:a.ThemeIcon.asClassNameArray(null!==(l=i.moreIcon)&&void 0!==l?l:s.Codicon.toolBarMore),anchorAlignmentProvider:this.options.anchorAlignmentProvider,menuAsChild:!!this.options.renderDropdownAsChildElement,skipTelemetry:this.options.skipTelemetry,isMenu:!0}),this.toggleMenuActionViewItem.setActionContext(this.actionBar.context),this.disposables.add(this._onDidChangeDropdownVisibility.add(this.toggleMenuActionViewItem.onDidChangeVisibility)),this.toggleMenuActionViewItem;if(i.actionViewItemProvider){const t=i.actionViewItemProvider(e,n);if(t)return t}if(e instanceof r.SubmenuAction){const i=new o.DropdownMenuActionViewItem(e,e.actions,t,{actionViewItemProvider:this.options.actionViewItemProvider,actionRunner:this.actionRunner,keybindingProvider:this.options.getKeyBinding,classNames:e.class,anchorAlignmentProvider:this.options.anchorAlignmentProvider,menuAsChild:!!this.options.renderDropdownAsChildElement,skipTelemetry:this.options.skipTelemetry});return i.setActionContext(this.actionBar.context),this.submenuActionViewItems.push(i),this.disposables.add(this._onDidChangeDropdownVisibility.add(i.onDidChangeVisibility)),i}}}))}set actionRunner(e){this.actionBar.actionRunner=e}get actionRunner(){return this.actionBar.actionRunner}getElement(){return this.element}getItemAction(e){return this.actionBar.getAction(e)}setActions(e,t){this.clear();const i=e?e.slice(0):[];this.hasSecondaryActions=!!(t&&t.length>0),this.hasSecondaryActions&&t&&(this.toggleMenuAction.menuActions=t.slice(0),i.push(this.toggleMenuAction)),i.forEach((e=>{this.actionBar.push(e,{icon:!0,label:!1,keybinding:this.getKeybindingLabel(e)})}))}getKeybindingLabel(e){var t,i,n;const o=this.lookupKeybindings?null===(i=(t=this.options).getKeyBinding)||void 0===i?void 0:i.call(t,e):void 0;return null!==(n=null==o?void 0:o.getLabel())&&void 0!==n?n:void 0}clear(){this.submenuActionViewItems=[],this.disposables.clear(),this.actionBar.clear()}dispose(){this.clear(),this.disposables.dispose(),super.dispose()}}class E extends r.Action{constructor(e,t){t=t||S.localize("vs/base/browser/ui/toolbar/toolbar","moreActions","More Actions..."),super(E.ID,t,void 0,!0),this._menuActions=[],this.toggleDropdownMenu=e}async run(){this.toggleDropdownMenu()}get menuActions(){return this._menuActions}set menuActions(e){this._menuActions=e}}E.ID="toolbar.toggle.more"},72665:function(e,t,i){"use strict";i.r(t),i.d(t,{AbstractTree:function(){return re},ComposedTreeDelegate:function(){return H},FuzzyToggle:function(){return j},ModeToggle:function(){return K},RenderIndentGuides:function(){return B},TreeFindMatchType:function(){return q},TreeFindMode:function(){return G},TreeRenderer:function(){return U}});var n=i(96747),o=(i(50465),i(8769)),r=(i(31532),i(73493),i(25802)),s=i(75291),a=i(72406),l=i(50797),c=i(49517),d=i(23877),u=(i(60969),i(64998)),h=i(66129),g=i(56087),p=i(27269),m=i(13833),f=i(63801),b=i(27017),v=i(68921),_=i(53719),A=i(18912),C=i(93379),w=i.n(C),y=i(7795),S=i.n(y),x=i(90569),E=i.n(x),k=i(3565),D=i.n(k),I=i(19216),L=i.n(I),T=i(44589),M=i.n(T),N=i(42650),R={};R.styleTagTransform=M(),R.setAttributes=D(),R.insert=E().bind(null,"head"),R.domAPI=S(),R.insertStyleElement=L();w()(N.Z,R),N.Z&&N.Z.locals&&N.Z.locals;var B,O=i(83787);class F extends s.ElementsDragAndDropData{constructor(e){super(e.elements.map((e=>e.element))),this.data=e}}function P(e){return e instanceof s.ElementsDragAndDropData?new F(e):e}class z{constructor(e,t){this.modelProvider=e,this.dnd=t,this.autoExpandDisposable=v.Disposable.None,this.disposables=new v.DisposableStore}getDragURI(e){return this.dnd.getDragURI(e.element)}getDragLabel(e,t){if(this.dnd.getDragLabel)return this.dnd.getDragLabel(e.map((e=>e.element)),t)}onDragStart(e,t){var i,n;null===(n=(i=this.dnd).onDragStart)||void 0===n||n.call(i,P(e),t)}onDragOver(e,t,i,n,o=!0){const r=this.dnd.onDragOver(P(e),t&&t.element,i,n),s=this.autoExpandNode!==t;if(s&&(this.autoExpandDisposable.dispose(),this.autoExpandNode=t),void 0===t)return r;if(s&&"boolean"!=typeof r&&r.autoExpand&&(this.autoExpandDisposable=(0,h.disposableTimeout)((()=>{const e=this.modelProvider(),i=e.getNodeLocation(t);e.isCollapsed(i)&&e.setCollapsed(i,!1),this.autoExpandNode=void 0}),500,this.disposables)),"boolean"==typeof r||!r.accept||void 0===r.bubble||r.feedback){if(!o){return{accept:"boolean"==typeof r?r:r.accept,effect:"boolean"==typeof r?void 0:r.effect,feedback:[i]}}return r}if(1===r.bubble){const i=this.modelProvider(),o=i.getNodeLocation(t),r=i.getParentNodeLocation(o),s=i.getNode(r),a=r&&i.getListIndex(r);return this.onDragOver(e,s,a,n,!1)}const a=this.modelProvider(),l=a.getNodeLocation(t),c=a.getListIndex(l),d=a.getListRenderCount(l);return{...r,feedback:(0,u.range)(c,c+d)}}drop(e,t,i,n){this.autoExpandDisposable.dispose(),this.autoExpandNode=void 0,this.dnd.drop(P(e),t&&t.element,i,n)}onDragEnd(e){var t,i;null===(i=(t=this.dnd).onDragEnd)||void 0===i||i.call(t,e)}dispose(){this.disposables.dispose(),this.dnd.dispose()}}function W(e,t){return t&&{...t,identityProvider:t.identityProvider&&{getId(e){return t.identityProvider.getId(e.element)}},dnd:t.dnd&&new z(e,t.dnd),multipleSelectionController:t.multipleSelectionController&&{isSelectionSingleChangeEvent(e){return t.multipleSelectionController.isSelectionSingleChangeEvent({...e,element:e.element})},isSelectionRangeChangeEvent(e){return t.multipleSelectionController.isSelectionRangeChangeEvent({...e,element:e.element})}},accessibilityProvider:t.accessibilityProvider&&{...t.accessibilityProvider,getSetSize(t){const i=e(),n=i.getNodeLocation(t),o=i.getParentNodeLocation(n);return i.getNode(o).visibleChildrenCount},getPosInSet(e){return e.visibleChildIndex+1},isChecked:t.accessibilityProvider&&t.accessibilityProvider.isChecked?e=>t.accessibilityProvider.isChecked(e.element):void 0,getRole:t.accessibilityProvider&&t.accessibilityProvider.getRole?e=>t.accessibilityProvider.getRole(e.element):()=>"treeitem",getAriaLabel(e){return t.accessibilityProvider.getAriaLabel(e.element)},getWidgetAriaLabel(){return t.accessibilityProvider.getWidgetAriaLabel()},getWidgetRole:t.accessibilityProvider&&t.accessibilityProvider.getWidgetRole?()=>t.accessibilityProvider.getWidgetRole():()=>"tree",getAriaLevel:t.accessibilityProvider&&t.accessibilityProvider.getAriaLevel?e=>t.accessibilityProvider.getAriaLevel(e.element):e=>e.depth,getActiveDescendantId:t.accessibilityProvider.getActiveDescendantId&&(e=>t.accessibilityProvider.getActiveDescendantId(e.element))},keyboardNavigationLabelProvider:t.keyboardNavigationLabelProvider&&{...t.keyboardNavigationLabelProvider,getKeyboardNavigationLabel(e){return t.keyboardNavigationLabelProvider.getKeyboardNavigationLabel(e.element)}}}}class H{constructor(e){this.delegate=e}getHeight(e){return this.delegate.getHeight(e.element)}getTemplateId(e){return this.delegate.getTemplateId(e.element)}hasDynamicHeight(e){return!!this.delegate.hasDynamicHeight&&this.delegate.hasDynamicHeight(e.element)}setDynamicHeight(e,t){var i,n;null===(n=(i=this.delegate).setDynamicHeight)||void 0===n||n.call(i,e.element,t)}}!function(e){e.None="none",e.OnHover="onHover",e.Always="always"}(B||(B={}));class V{get elements(){return this._elements}constructor(e,t=[]){this._elements=t,this.disposables=new v.DisposableStore,this.onDidChange=f.Event.forEach(e,(e=>this._elements=e),this.disposables)}dispose(){this.disposables.dispose()}}class U{constructor(e,t,i,n,o,r={}){var s;this.renderer=e,this.modelProvider=t,this.activeNodes=n,this.renderedIndentGuides=o,this.renderedElements=new Map,this.renderedNodes=new Map,this.indent=U.DefaultIndent,this.hideTwistiesOfChildlessElements=!1,this.shouldRenderIndentGuides=!1,this.activeIndentNodes=new Set,this.indentGuidesDisposable=v.Disposable.None,this.disposables=new v.DisposableStore,this.templateId=e.templateId,this.updateOptions(r),f.Event.map(i,(e=>e.node))(this.onDidChangeNodeTwistieState,this,this.disposables),null===(s=e.onDidChangeTwistieState)||void 0===s||s.call(e,this.onDidChangeTwistieState,this,this.disposables)}updateOptions(e={}){if(void 0!==e.indent){const t=(0,_.clamp)(e.indent,0,40);if(t!==this.indent){this.indent=t;for(const[e,t]of this.renderedNodes)this.renderTreeElement(e,t)}}if(void 0!==e.renderIndentGuides){const t=e.renderIndentGuides!==B.None;if(t!==this.shouldRenderIndentGuides){this.shouldRenderIndentGuides=t;for(const[e,t]of this.renderedNodes)this._renderIndentGuides(e,t);if(this.indentGuidesDisposable.dispose(),t){const e=new v.DisposableStore;this.activeNodes.onDidChange(this._onDidChangeActiveNodes,this,e),this.indentGuidesDisposable=e,this._onDidChangeActiveNodes(this.activeNodes.elements)}}}void 0!==e.hideTwistiesOfChildlessElements&&(this.hideTwistiesOfChildlessElements=e.hideTwistiesOfChildlessElements)}renderTemplate(e){const t=(0,n.append)(e,(0,n.$)(".monaco-tl-row")),i=(0,n.append)(t,(0,n.$)(".monaco-tl-indent")),o=(0,n.append)(t,(0,n.$)(".monaco-tl-twistie")),r=(0,n.append)(t,(0,n.$)(".monaco-tl-contents")),s=this.renderer.renderTemplate(r);return{container:e,indent:i,twistie:o,indentGuidesDisposable:v.Disposable.None,templateData:s}}renderElement(e,t,i,n){this.renderedNodes.set(e,i),this.renderedElements.set(e.element,e),this.renderTreeElement(e,i),this.renderer.renderElement(e,t,i.templateData,n)}disposeElement(e,t,i,n){var o,r;i.indentGuidesDisposable.dispose(),null===(r=(o=this.renderer).disposeElement)||void 0===r||r.call(o,e,t,i.templateData,n),"number"==typeof n&&(this.renderedNodes.delete(e),this.renderedElements.delete(e.element))}disposeTemplate(e){this.renderer.disposeTemplate(e.templateData)}onDidChangeTwistieState(e){const t=this.renderedElements.get(e);t&&this.onDidChangeNodeTwistieState(t)}onDidChangeNodeTwistieState(e){const t=this.renderedNodes.get(e);t&&(this._onDidChangeActiveNodes(this.activeNodes.elements),this.renderTreeElement(e,t))}renderTreeElement(e,t){const i=U.DefaultIndent+(e.depth-1)*this.indent;t.twistie.style.paddingLeft=`${i}px`,t.indent.style.width=i+this.indent-16+"px",e.collapsible?t.container.setAttribute("aria-expanded",String(!e.collapsed)):t.container.removeAttribute("aria-expanded"),t.twistie.classList.remove(...p.ThemeIcon.asClassNameArray(g.Codicon.treeItemExpanded));let n=!1;this.renderer.renderTwistie&&(n=this.renderer.renderTwistie(e.element,t.twistie)),e.collapsible&&(!this.hideTwistiesOfChildlessElements||e.visibleChildrenCount>0)?(n||t.twistie.classList.add(...p.ThemeIcon.asClassNameArray(g.Codicon.treeItemExpanded)),t.twistie.classList.add("collapsible"),t.twistie.classList.toggle("collapsed",e.collapsed)):t.twistie.classList.remove("collapsible","collapsed"),this._renderIndentGuides(e,t)}_renderIndentGuides(e,t){if((0,n.clearNode)(t.indent),t.indentGuidesDisposable.dispose(),!this.shouldRenderIndentGuides)return;const i=new v.DisposableStore,o=this.modelProvider();for(;;){const r=o.getNodeLocation(e),s=o.getParentNodeLocation(r);if(!s)break;const a=o.getNode(s),l=(0,n.$)(".indent-guide",{style:`width: ${this.indent}px`});this.activeIndentNodes.has(a)&&l.classList.add("active"),0===t.indent.childElementCount?t.indent.appendChild(l):t.indent.insertBefore(l,t.indent.firstElementChild),this.renderedIndentGuides.add(a,l),i.add((0,v.toDisposable)((()=>this.renderedIndentGuides.delete(a,l)))),e=a}t.indentGuidesDisposable=i}_onDidChangeActiveNodes(e){if(!this.shouldRenderIndentGuides)return;const t=new Set,i=this.modelProvider();e.forEach((e=>{const n=i.getNodeLocation(e);try{const o=i.getParentNodeLocation(n);e.collapsible&&e.children.length>0&&!e.collapsed?t.add(e):o&&t.add(i.getNode(o))}catch(e){}})),this.activeIndentNodes.forEach((e=>{t.has(e)||this.renderedIndentGuides.forEach(e,(e=>e.classList.remove("active")))})),t.forEach((e=>{this.activeIndentNodes.has(e)||this.renderedIndentGuides.forEach(e,(e=>e.classList.add("active")))})),this.activeIndentNodes=t}dispose(){this.renderedNodes.clear(),this.renderedElements.clear(),this.indentGuidesDisposable.dispose(),(0,v.dispose)(this.disposables)}}U.DefaultIndent=8;class Q{get totalCount(){return this._totalCount}get matchCount(){return this._matchCount}constructor(e,t,i){this.tree=e,this.keyboardNavigationLabelProvider=t,this._filter=i,this._totalCount=0,this._matchCount=0,this._pattern="",this._lowercasePattern="",this.disposables=new v.DisposableStore,e.onWillRefilter(this.reset,this,this.disposables)}filter(e,t){let i=1;if(this._filter){const n=this._filter.filter(e,t);if(i="boolean"==typeof n?n?1:0:(0,c.isFilterResult)(n)?(0,c.getVisibleState)(n.visibility):n,0===i)return!1}if(this._totalCount++,!this._pattern)return this._matchCount++,{data:b.FuzzyScore.Default,visibility:i};const n=this.keyboardNavigationLabelProvider.getKeyboardNavigationLabel(e),o=Array.isArray(n)?n:[n];for(const e of o){const t=e&&e.toString();if(void 0===t)return{data:b.FuzzyScore.Default,visibility:i};let n;if(this.tree.findMatchType===q.Contiguous){const e=t.toLowerCase().indexOf(this._lowercasePattern);if(e>-1){n=[Number.MAX_SAFE_INTEGER,0];for(let t=this._lowercasePattern.length;t>0;t--)n.push(e+t-1)}}else n=(0,b.fuzzyScore)(this._pattern,this._lowercasePattern,0,t,t.toLowerCase(),0,{firstMatchCanBeWeak:!0,boostFullMatch:!0});if(n)return this._matchCount++,1===o.length?{data:n,visibility:i}:{data:{label:t,score:n},visibility:i}}return this.tree.findMode===G.Filter?"number"==typeof this.tree.options.defaultFindVisibility?this.tree.options.defaultFindVisibility:this.tree.options.defaultFindVisibility?this.tree.options.defaultFindVisibility(e):2:{data:b.FuzzyScore.Default,visibility:i}}reset(){this._totalCount=0,this._matchCount=0}dispose(){(0,v.dispose)(this.disposables)}}class K extends l.Toggle{constructor(e){var t;super({icon:g.Codicon.listFilter,title:(0,O.localize)("vs/base/browser/ui/tree/abstractTree","filter","Filter"),isChecked:null!==(t=e.isChecked)&&void 0!==t&&t,inputActiveOptionBorder:e.inputActiveOptionBorder,inputActiveOptionForeground:e.inputActiveOptionForeground,inputActiveOptionBackground:e.inputActiveOptionBackground})}}class j extends l.Toggle{constructor(e){var t;super({icon:g.Codicon.searchFuzzy,title:(0,O.localize)("vs/base/browser/ui/tree/abstractTree","fuzzySearch","Fuzzy Match"),isChecked:null!==(t=e.isChecked)&&void 0!==t&&t,inputActiveOptionBorder:e.inputActiveOptionBorder,inputActiveOptionForeground:e.inputActiveOptionForeground,inputActiveOptionBackground:e.inputActiveOptionBackground})}}r.unthemedInboxStyles,l.unthemedToggleStyles;var G,q;!function(e){e[e.Highlight=0]="Highlight",e[e.Filter=1]="Filter"}(G||(G={})),function(e){e[e.Fuzzy=0]="Fuzzy",e[e.Contiguous=1]="Contiguous"}(q||(q={}));class Y{get pattern(){return this._pattern}get mode(){return this._mode}set mode(e){e!==this._mode&&(this._mode=e,this.widget&&(this.widget.mode=this._mode),this.tree.refilter(),this.render(),this._onDidChangeMode.fire(e))}get matchType(){return this._matchType}set matchType(e){e!==this._matchType&&(this._matchType=e,this.widget&&(this.widget.matchType=this._matchType),this.tree.refilter(),this.render(),this._onDidChangeMatchType.fire(e))}constructor(e,t,i,n,o,r={}){var s,a;this.tree=e,this.view=i,this.filter=n,this.contextViewProvider=o,this.options=r,this._pattern="",this.width=0,this._onDidChangeMode=new f.Emitter,this.onDidChangeMode=this._onDidChangeMode.event,this._onDidChangeMatchType=new f.Emitter,this.onDidChangeMatchType=this._onDidChangeMatchType.event,this._onDidChangePattern=new f.Emitter,this._onDidChangeOpenState=new f.Emitter,this.onDidChangeOpenState=this._onDidChangeOpenState.event,this.enabledDisposables=new v.DisposableStore,this.disposables=new v.DisposableStore,this._mode=null!==(s=e.options.defaultFindMode)&&void 0!==s?s:G.Highlight,this._matchType=null!==(a=e.options.defaultFindMatchType)&&void 0!==a?a:q.Fuzzy,t.onDidSplice(this.onDidSpliceModel,this,this.disposables)}updateOptions(e={}){void 0!==e.defaultFindMode&&(this.mode=e.defaultFindMode),void 0!==e.defaultFindMatchType&&(this.matchType=e.defaultFindMatchType)}onDidSpliceModel(){this.widget&&0!==this.pattern.length&&(this.tree.refilter(),this.render())}render(){var e,t,i,n;const o=this.filter.totalCount>0&&0===this.filter.matchCount;this.pattern&&o?null===(e=this.tree.options.showNotFoundMessage)||void 0===e||e?null===(t=this.widget)||void 0===t||t.showMessage({type:2,content:(0,O.localize)("vs/base/browser/ui/tree/abstractTree","not found","No elements found.")}):null===(i=this.widget)||void 0===i||i.showMessage({type:2}):null===(n=this.widget)||void 0===n||n.clearMessage()}shouldAllowFocus(e){return!this.widget||!this.pattern||this._mode===G.Filter||(this.filter.totalCount>0&&this.filter.matchCount<=1||!b.FuzzyScore.isDefault(e.filterData))}layout(e){var t;this.width=e,null===(t=this.widget)||void 0===t||t.layout(e)}dispose(){this._history=void 0,this._onDidChangePattern.dispose(),this.enabledDisposables.dispose(),this.disposables.dispose()}}function $(e,t){return e.position===t.position&&e.node.element===t.node.element&&e.startIndex===t.startIndex&&e.height===t.height&&e.endIndex===t.endIndex}class J extends v.Disposable{constructor(e=[]){super(),this.stickyNodes=e}get count(){return this.stickyNodes.length}equal(e){return(0,u.equals)(this.stickyNodes,e.stickyNodes,$)}addDisposable(e){this._register(e)}}class Z extends v.Disposable{get firstVisibleNode(){const e=this.view.firstVisibleIndex;if(!(e<0||e>=this.view.length))return this.view.element(e)}constructor(e,t,i,n,o,r={}){super(),this.tree=e,this.model=t,this.view=i,this.treeDelegate=o,this.maxWidgetViewRatio=.4;const s=this.validateStickySettings(r);this.stickyScrollMaxItemCount=s.stickyScrollMaxItemCount,this._widget=this._register(new X(i.getScrollableElement(),i,t,n,o)),this._register(i.onDidScroll((()=>this.update()))),this._register(i.onDidChangeContentHeight((()=>this.update()))),this._register(e.onDidChangeCollapseState((()=>this.update()))),this.update()}update(){const e=this.firstVisibleNode;if(!e||0===this.tree.scrollTop)return void this._widget.setState(void 0);const t=this.findStickyState(e);this._widget.setState(t)}findStickyState(e){const t=[],i=this.view.renderHeight*this.maxWidgetViewRatio;let n=e,o=0,r=this.getNextStickyNode(n,void 0,o);for(;r&&o+r.height<i&&(t.push(r),o+=r.height,!(t.length>=this.stickyScrollMaxItemCount))&&(n=this.getNextVisibleNode(n),n);)r=this.getNextStickyNode(n,r.node,o);return t.length?new J(t):void 0}getNextVisibleNode(e){const t=this.getNodeIndex(e);if(-1===t||t===this.view.length-1)return;return this.view.element(t+1)}getNextStickyNode(e,t,i){const n=this.getAncestorUnderPrevious(e,t);if(n){if(n===e){if(!this.nodeIsUncollapsedParent(e))return;if(this.nodeTopAlignsWithStickyNodesBottom(e,i))return}return this.createStickyScrollNode(n,i)}}nodeTopAlignsWithStickyNodesBottom(e,t){const i=this.getNodeIndex(e),n=this.view.getElementTop(i),o=t;return this.view.scrollTop===n-o}createStickyScrollNode(e,t){const i=this.treeDelegate.getHeight(e),{startIndex:n,endIndex:o}=this.getNodeRange(e);return{node:e,position:this.calculateStickyNodePosition(o,t),height:i,startIndex:n,endIndex:o}}getAncestorUnderPrevious(e,t=void 0){let i=e,n=this.getParentNode(i);for(;n;){if(n===t)return i;i=n,n=this.getParentNode(i)}if(void 0===t)return i}calculateStickyNodePosition(e,t){let i=this.view.getRelativeTop(e);if(null===i&&this.view.firstVisibleIndex===e&&e+1<this.view.length){const t=this.treeDelegate.getHeight(this.view.element(e)),n=this.view.getRelativeTop(e+1);i=n?n-t/this.view.renderHeight:null}if(null===i)return t;const n=this.view.element(e),o=this.treeDelegate.getHeight(n),r=i*this.view.renderHeight;return t>r&&t<=r+o?r:t}getParentNode(e){const t=this.model.getNodeLocation(e),i=this.model.getParentNodeLocation(t);return i?this.model.getNode(i):void 0}nodeIsUncollapsedParent(e){const t=this.model.getNodeLocation(e);return this.model.getListRenderCount(t)>1}getNodeIndex(e,t){void 0===t&&(t=this.model.getNodeLocation(e));return this.model.getListIndex(t)}getNodeRange(e){const t=this.model.getNodeLocation(e),i=this.model.getListIndex(t);if(i<0)throw new Error("Node not found in tree");return{startIndex:i,endIndex:i+this.model.getListRenderCount(t)-1}}nodePositionTopBelowWidget(e){const t=[];let i=this.getParentNode(e);for(;i;)t.push(i),i=this.getParentNode(i);let n=0;for(let e=0;e<t.length&&e<this.stickyScrollMaxItemCount;e++)n+=this.treeDelegate.getHeight(t[e]);return n}updateOptions(e={}){const t=this.validateStickySettings(e);this.stickyScrollMaxItemCount!==t.stickyScrollMaxItemCount&&(this.stickyScrollMaxItemCount=t.stickyScrollMaxItemCount,this.update())}validateStickySettings(e){let t=5;return"number"==typeof e.stickyScrollMaxItemCount&&(t=Math.max(e.stickyScrollMaxItemCount,1)),{stickyScrollMaxItemCount:t}}}class X{constructor(e,t,i,n,o){this.view=t,this.model=i,this.treeRenderers=n,this.treeDelegate=o,this._rootDomNode=document.createElement("div"),this._rootDomNode.classList.add("monaco-tree-sticky-container"),e.appendChild(this._rootDomNode)}setState(e){var t;const i=!!this._previousState&&this._previousState.count>0,o=!!e&&e.count>0;if(!i&&!o||i&&o&&this._previousState.equal(e))return;if(i!==o&&this.setVisible(o),null===(t=this._previousState)||void 0===t||t.dispose(),this._previousState=e,!o)return;for(let t=e.count-1;t>=0;t--){const i=e.stickyNodes[t],n=t?e.stickyNodes[t-1]:void 0,o=n?n.position+n.height:0,{element:r,disposable:s}=this.createElement(i,o);this._rootDomNode.appendChild(r),e.addDisposable(s)}const r=(0,n.$)(".monaco-tree-sticky-container-shadow");this._rootDomNode.appendChild(r),e.addDisposable((0,v.toDisposable)((()=>r.remove())));const s=e.stickyNodes[e.count-1];this._rootDomNode.style.height=`${s.position+s.height}px`}createElement(e,t){const i=this.model.getNodeLocation(e.node),n=this.model.getListIndex(i),o=document.createElement("div");o.style.top=`${e.position}px`,o.style.height=`${e.height}px`,o.style.lineHeight=`${e.height}px`,o.classList.add("monaco-tree-sticky-row"),o.classList.add("monaco-list-row"),o.setAttribute("data-index",`${n}`),o.setAttribute("data-parity",n%2==0?"even":"odd"),o.setAttribute("id",this.view.getElementID(n));const r=this.treeDelegate.getTemplateId(e.node),s=this.treeRenderers.find((e=>e.templateId===r));if(!s)throw new Error(`No renderer found for template id ${r}`);const a=new Proxy(e.node,{}),l=s.renderTemplate(o);s.renderElement(a,e.startIndex,l,e.height);const c=(0,v.toDisposable)((()=>{s.disposeElement(a,e.startIndex,l,e.height),s.disposeTemplate(l),o.remove()}));return{element:o,disposable:c}}setVisible(e){this._rootDomNode.style.display=e?"block":"none"}dispose(){var e;null===(e=this._previousState)||void 0===e||e.dispose(),this._rootDomNode.remove()}}function ee(e){let t=d.TreeMouseEventTarget.Unknown;return(0,n.hasParentWithClass)(e.browserEvent.target,"monaco-tl-twistie","monaco-tl-row")?t=d.TreeMouseEventTarget.Twistie:(0,n.hasParentWithClass)(e.browserEvent.target,"monaco-tl-contents","monaco-tl-row")?t=d.TreeMouseEventTarget.Element:(0,n.hasParentWithClass)(e.browserEvent.target,"monaco-tree-type-filter","monaco-list")&&(t=d.TreeMouseEventTarget.Filter),{browserEvent:e.browserEvent,element:e.element?e.element.element:null,target:t}}function te(e,t){t(e),e.children.forEach((e=>te(e,t)))}class ie{get nodeSet(){return this._nodeSet||(this._nodeSet=this.createNodeSet()),this._nodeSet}constructor(e,t){this.getFirstViewElementWithTrait=e,this.identityProvider=t,this.nodes=[],this._onDidChange=new f.Emitter,this.onDidChange=this._onDidChange.event}set(e,t){!(null==t?void 0:t.__forceEvent)&&(0,u.equals)(this.nodes,e)||this._set(e,!1,t)}_set(e,t,i){if(this.nodes=[...e],this.elements=void 0,this._nodeSet=void 0,!t){const e=this;this._onDidChange.fire({get elements(){return e.get()},browserEvent:i})}}get(){return this.elements||(this.elements=this.nodes.map((e=>e.element))),[...this.elements]}getNodes(){return this.nodes}has(e){return this.nodeSet.has(e)}onDidModelSplice({insertedNodes:e,deletedNodes:t}){if(!this.identityProvider){const e=this.createNodeSet(),i=t=>e.delete(t);return t.forEach((e=>te(e,i))),void this.set([...e.values()])}const i=new Set,n=e=>i.add(this.identityProvider.getId(e.element).toString());t.forEach((e=>te(e,n)));const o=new Map,r=e=>o.set(this.identityProvider.getId(e.element).toString(),e);e.forEach((e=>te(e,r)));const s=[];for(const e of this.nodes){const t=this.identityProvider.getId(e.element).toString();if(i.has(t)){const e=o.get(t);e&&e.visible&&s.push(e)}else s.push(e)}if(this.nodes.length>0&&0===s.length){const e=this.getFirstViewElementWithTrait();e&&s.push(e)}this._set(s,!0)}createNodeSet(){const e=new Set;for(const t of this.nodes)e.add(t);return e}}class ne extends a.MouseController{constructor(e,t,i){super(e),this.tree=t,this.stickyScrollProvider=i}onViewPointer(e){if((0,a.isButton)(e.browserEvent.target)||(0,a.isInputElement)(e.browserEvent.target)||(0,a.isMonacoEditor)(e.browserEvent.target))return;if(e.browserEvent.isHandledByList)return;const t=e.element;if(!t)return super.onViewPointer(e);if(this.isSelectionRangeChangeEvent(e)||this.isSelectionSingleChangeEvent(e))return super.onViewPointer(e);const i=e.browserEvent.target,n=i.classList.contains("monaco-tl-twistie")||i.classList.contains("monaco-icon-label")&&i.classList.contains("folder-icon")&&e.browserEvent.offsetX<16,o=(0,a.isStickyScrollElement)(e.browserEvent.target);let r=!1;if(r=!!o||("function"==typeof this.tree.expandOnlyOnTwistieClick?this.tree.expandOnlyOnTwistieClick(t.element):!!this.tree.expandOnlyOnTwistieClick),o)this.handleStickyScrollMouseEvent(e,t);else{if(r&&!n&&2!==e.browserEvent.detail)return super.onViewPointer(e);if(!this.tree.expandOnDoubleClick&&2===e.browserEvent.detail)return super.onViewPointer(e)}if(t.collapsible&&(!o||n)){const i=this.tree.getNodeLocation(t),o=e.browserEvent.altKey;if(this.tree.setFocus([i]),this.tree.toggleCollapsed(i,o),r&&n)return void(e.browserEvent.isHandledByList=!0)}o||super.onViewPointer(e)}handleStickyScrollMouseEvent(e,t){if((0,a.isMonacoCustomToggle)(e.browserEvent.target)||(0,a.isActionItem)(e.browserEvent.target))return;const i=this.stickyScrollProvider();if(!i)throw new Error("Sticky scroll controller not found");const n=this.list.indexOf(t),o=this.list.getElementTop(n),r=i.nodePositionTopBelowWidget(t);this.tree.scrollTop=o-r,this.list.setFocus([n]),this.list.setSelection([n])}onDoubleClick(e){!e.browserEvent.target.classList.contains("monaco-tl-twistie")&&this.tree.expandOnDoubleClick&&(e.browserEvent.isHandledByList||super.onDoubleClick(e))}}class oe extends a.List{constructor(e,t,i,n,o,r,s,a){super(e,t,i,n,a),this.focusTrait=o,this.selectionTrait=r,this.anchorTrait=s}createMouseController(e){return new ne(this,e.tree,e.stickyScrollProvider)}splice(e,t,i=[]){if(super.splice(e,t,i),0===i.length)return;const n=[],o=[];let r;i.forEach(((t,i)=>{this.focusTrait.has(t)&&n.push(e+i),this.selectionTrait.has(t)&&o.push(e+i),this.anchorTrait.has(t)&&(r=e+i)})),n.length>0&&super.setFocus((0,u.distinct)([...super.getFocus(),...n])),o.length>0&&super.setSelection((0,u.distinct)([...super.getSelection(),...o])),"number"==typeof r&&super.setAnchor(r)}setFocus(e,t,i=!1){super.setFocus(e,t),i||this.focusTrait.set(e.map((e=>this.element(e))),t)}setSelection(e,t,i=!1){super.setSelection(e,t),i||this.selectionTrait.set(e.map((e=>this.element(e))),t)}setAnchor(e,t=!1){super.setAnchor(e),t||(void 0===e?this.anchorTrait.set([]):this.anchorTrait.set([this.element(e)]))}}class re{get onDidScroll(){return this.view.onDidScroll}get onDidChangeFocus(){return this.eventBufferer.wrapEvent(this.focus.onDidChange)}get onDidChangeSelection(){return this.eventBufferer.wrapEvent(this.selection.onDidChange)}get onMouseDblClick(){return f.Event.filter(f.Event.map(this.view.onMouseDblClick,ee),(e=>e.target!==d.TreeMouseEventTarget.Filter))}get onPointer(){return f.Event.map(this.view.onPointer,ee)}get onDidFocus(){return this.view.onDidFocus}get onDidChangeModel(){return f.Event.signal(this.model.onDidSplice)}get onDidChangeCollapseState(){return this.model.onDidChangeCollapseState}get findMode(){var e,t;return null!==(t=null===(e=this.findController)||void 0===e?void 0:e.mode)&&void 0!==t?t:G.Highlight}set findMode(e){this.findController&&(this.findController.mode=e)}get findMatchType(){var e,t;return null!==(t=null===(e=this.findController)||void 0===e?void 0:e.matchType)&&void 0!==t?t:q.Fuzzy}set findMatchType(e){this.findController&&(this.findController.matchType=e)}get expandOnDoubleClick(){return void 0===this._options.expandOnDoubleClick||this._options.expandOnDoubleClick}get expandOnlyOnTwistieClick(){return void 0===this._options.expandOnlyOnTwistieClick||this._options.expandOnlyOnTwistieClick}get onDidDispose(){return this.view.onDidDispose}constructor(e,t,i,r,s={}){var l;this._user=e,this._options=s,this.eventBufferer=new f.EventBufferer,this.onDidChangeFindOpenState=f.Event.None,this.disposables=new v.DisposableStore,this._onWillRefilter=new f.Emitter,this.onWillRefilter=this._onWillRefilter.event,this._onDidUpdateOptions=new f.Emitter,this.treeDelegate=new H(i);const c=new f.Relay,d=new f.Relay,u=this.disposables.add(new V(d.event)),g=new m.SetMap;this.renderers=r.map((e=>new U(e,(()=>this.model),c.event,u,g,s)));for(const e of this.renderers)this.disposables.add(e);let p;s.keyboardNavigationLabelProvider&&(p=new Q(this,s.keyboardNavigationLabelProvider,s.filter),s={...s,filter:p},this.disposables.add(p)),this.focus=new ie((()=>this.view.getFocusedElements()[0]),s.identityProvider),this.selection=new ie((()=>this.view.getSelectedElements()[0]),s.identityProvider),this.anchor=new ie((()=>this.view.getAnchorElement()),s.identityProvider),this.view=new oe(e,t,this.treeDelegate,this.renderers,this.focus,this.selection,this.anchor,{...W((()=>this.model),s),tree:this,stickyScrollProvider:()=>this.stickyScrollController}),this.model=this.createModel(e,this.view,s),c.input=this.model.onDidChangeCollapseState;const b=f.Event.forEach(this.model.onDidSplice,(e=>{this.eventBufferer.bufferEvents((()=>{this.focus.onDidModelSplice(e),this.selection.onDidModelSplice(e)}))}),this.disposables);b((()=>null),null,this.disposables);const _=this.disposables.add(new f.Emitter),A=this.disposables.add(new h.Delayer(0));if(this.disposables.add(f.Event.any(b,this.focus.onDidChange,this.selection.onDidChange)((()=>{A.trigger((()=>{const e=new Set;for(const t of this.focus.getNodes())e.add(t);for(const t of this.selection.getNodes())e.add(t);_.fire([...e.values()])}))}))),d.input=_.event,!1!==s.keyboardSupport){const e=f.Event.chain(this.view.onKeyDown,(e=>e.filter((e=>!(0,a.isInputElement)(e.target))).map((e=>new o.StandardKeyboardEvent(e)))));f.Event.chain(e,(e=>e.filter((e=>15===e.keyCode))))(this.onLeftArrow,this,this.disposables),f.Event.chain(e,(e=>e.filter((e=>17===e.keyCode))))(this.onRightArrow,this,this.disposables),f.Event.chain(e,(e=>e.filter((e=>10===e.keyCode))))(this.onSpace,this,this.disposables)}if((null===(l=s.findWidgetEnabled)||void 0===l||l)&&s.keyboardNavigationLabelProvider&&s.contextViewProvider){const e=this.options.findWidgetStyles?{styles:this.options.findWidgetStyles}:void 0;this.findController=new Y(this,this.model,this.view,p,s.contextViewProvider,e),this.focusNavigationFilter=e=>this.findController.shouldAllowFocus(e),this.onDidChangeFindOpenState=this.findController.onDidChangeOpenState,this.disposables.add(this.findController),this.onDidChangeFindMode=this.findController.onDidChangeMode,this.onDidChangeFindMatchType=this.findController.onDidChangeMatchType}else this.onDidChangeFindMode=f.Event.None,this.onDidChangeFindMatchType=f.Event.None;s.enableStickyScroll&&(this.stickyScrollController=new Z(this,this.model,this.view,this.renderers,this.treeDelegate,s)),this.styleElement=(0,n.createStyleSheet)(this.view.getHTMLElement()),this.getHTMLElement().classList.toggle("always",this._options.renderIndentGuides===B.Always)}updateOptions(e={}){var t;this._options={...this._options,...e};for(const t of this.renderers)t.updateOptions(e);this.view.updateOptions(this._options),null===(t=this.findController)||void 0===t||t.updateOptions(e),this.updateStickyScroll(e),this._onDidUpdateOptions.fire(this._options),this.getHTMLElement().classList.toggle("always",this._options.renderIndentGuides===B.Always)}get options(){return this._options}updateStickyScroll(e){var t;!this.stickyScrollController&&this._options.enableStickyScroll?this.stickyScrollController=new Z(this,this.model,this.view,this.renderers,this.treeDelegate,this._options):this.stickyScrollController&&!this._options.enableStickyScroll&&(this.stickyScrollController.dispose(),this.stickyScrollController=void 0),null===(t=this.stickyScrollController)||void 0===t||t.updateOptions(e)}getHTMLElement(){return this.view.getHTMLElement()}get scrollTop(){return this.view.scrollTop}set scrollTop(e){this.view.scrollTop=e}get scrollHeight(){return this.view.scrollHeight}get renderHeight(){return this.view.renderHeight}domFocus(){this.view.domFocus()}layout(e,t){var i;this.view.layout(e,t),(0,A.isNumber)(t)&&(null===(i=this.findController)||void 0===i||i.layout(t))}style(e){const t=`.${this.view.domId}`,i=[];e.treeIndentGuidesStroke&&(i.push(`.monaco-list${t}:hover .monaco-tl-indent > .indent-guide, .monaco-list${t}.always .monaco-tl-indent > .indent-guide  { border-color: ${e.treeInactiveIndentGuidesStroke}; }`),i.push(`.monaco-list${t} .monaco-tl-indent > .indent-guide.active { border-color: ${e.treeIndentGuidesStroke}; }`)),e.listBackground&&(i.push(`.monaco-list${t} .monaco-scrollable-element .monaco-tree-sticky-container { background-color: ${e.listBackground}; }`),i.push(`.monaco-list${t} .monaco-scrollable-element .monaco-tree-sticky-container .monaco-tree-sticky-row { background-color: ${e.listBackground}; }`)),this.styleElement.textContent=i.join("\n"),this.view.style(e)}getParentElement(e){const t=this.model.getParentNodeLocation(e);return this.model.getNode(t).element}getFirstElementChild(e){return this.model.getFirstElementChild(e)}getNode(e){return this.model.getNode(e)}getNodeLocation(e){return this.model.getNodeLocation(e)}collapse(e,t=!1){return this.model.setCollapsed(e,!0,t)}expand(e,t=!1){return this.model.setCollapsed(e,!1,t)}toggleCollapsed(e,t=!1){return this.model.setCollapsed(e,void 0,t)}isCollapsible(e){return this.model.isCollapsible(e)}setCollapsible(e,t){return this.model.setCollapsible(e,t)}isCollapsed(e){return this.model.isCollapsed(e)}refilter(){this._onWillRefilter.fire(void 0),this.model.refilter()}setSelection(e,t){const i=e.map((e=>this.model.getNode(e)));this.selection.set(i,t);const n=e.map((e=>this.model.getListIndex(e))).filter((e=>e>-1));this.view.setSelection(n,t,!0)}getSelection(){return this.selection.get()}setFocus(e,t){const i=e.map((e=>this.model.getNode(e)));this.focus.set(i,t);const n=e.map((e=>this.model.getListIndex(e))).filter((e=>e>-1));this.view.setFocus(n,t,!0)}getFocus(){return this.focus.get()}reveal(e,t){this.model.expandTo(e);const i=this.model.getListIndex(e);if(-1!==i)if(this.stickyScrollController){const n=this.stickyScrollController.nodePositionTopBelowWidget(this.getNode(e));this.view.reveal(i,t,n)}else this.view.reveal(i,t)}onLeftArrow(e){e.preventDefault(),e.stopPropagation();const t=this.view.getFocusedElements();if(0===t.length)return;const i=t[0],n=this.model.getNodeLocation(i);if(!this.model.setCollapsed(n,!0)){const e=this.model.getParentNodeLocation(n);if(!e)return;const t=this.model.getListIndex(e);this.view.reveal(t),this.view.setFocus([t])}}onRightArrow(e){e.preventDefault(),e.stopPropagation();const t=this.view.getFocusedElements();if(0===t.length)return;const i=t[0],n=this.model.getNodeLocation(i);if(!this.model.setCollapsed(n,!1)){if(!i.children.some((e=>e.visible)))return;const[e]=this.view.getFocus(),t=e+1;this.view.reveal(t),this.view.setFocus([t])}}onSpace(e){e.preventDefault(),e.stopPropagation();const t=this.view.getFocusedElements();if(0===t.length)return;const i=t[0],n=this.model.getNodeLocation(i),o=e.browserEvent.altKey;this.model.setCollapsed(n,void 0,o)}dispose(){var e;(0,v.dispose)(this.disposables),null===(e=this.stickyScrollController)||void 0===e||e.dispose(),this.view.dispose()}}},74904:function(e,t,i){"use strict";i.r(t),i.d(t,{AsyncDataTree:function(){return k},CompressibleAsyncDataTree:function(){return L}});var n=i(75291),o=i(72665),r=i(49517),s=i(22481),a=i(23877),l=i(66129),c=i(56087),d=i(27269),u=i(12718),h=i(63801),g=i(24417),p=i(68921),m=i(18912);function f(e){return{...e,children:[],refreshPromise:void 0,stale:!0,slow:!1,forceExpanded:!1}}function b(e,t){return!!t.parent&&(t.parent===e||b(e,t.parent))}class v{get element(){return this.node.element.element}get children(){return this.node.children.map((e=>new v(e)))}get depth(){return this.node.depth}get visibleChildrenCount(){return this.node.visibleChildrenCount}get visibleChildIndex(){return this.node.visibleChildIndex}get collapsible(){return this.node.collapsible}get collapsed(){return this.node.collapsed}get visible(){return this.node.visible}get filterData(){return this.node.filterData}constructor(e){this.node=e}}class _{constructor(e,t,i){this.renderer=e,this.nodeMapper=t,this.onDidChangeTwistieState=i,this.renderedNodes=new Map,this.templateId=e.templateId}renderTemplate(e){return{templateData:this.renderer.renderTemplate(e)}}renderElement(e,t,i,n){this.renderer.renderElement(this.nodeMapper.map(e),t,i.templateData,n)}renderTwistie(e,t){return e.slow?(t.classList.add(...d.ThemeIcon.asClassNameArray(c.Codicon.treeItemLoading)),!0):(t.classList.remove(...d.ThemeIcon.asClassNameArray(c.Codicon.treeItemLoading)),!1)}disposeElement(e,t,i,n){var o,r;null===(r=(o=this.renderer).disposeElement)||void 0===r||r.call(o,this.nodeMapper.map(e),t,i.templateData,n)}disposeTemplate(e){this.renderer.disposeTemplate(e.templateData)}dispose(){this.renderedNodes.clear()}}function A(e){return{browserEvent:e.browserEvent,elements:e.elements.map((e=>e.element))}}function C(e){return{browserEvent:e.browserEvent,element:e.element&&e.element.element,target:e.target}}class w extends n.ElementsDragAndDropData{constructor(e){super(e.elements.map((e=>e.element))),this.data=e}}function y(e){return e instanceof n.ElementsDragAndDropData?new w(e):e}class S{constructor(e){this.dnd=e}getDragURI(e){return this.dnd.getDragURI(e.element)}getDragLabel(e,t){if(this.dnd.getDragLabel)return this.dnd.getDragLabel(e.map((e=>e.element)),t)}onDragStart(e,t){var i,n;null===(n=(i=this.dnd).onDragStart)||void 0===n||n.call(i,y(e),t)}onDragOver(e,t,i,n,o=!0){return this.dnd.onDragOver(y(e),t&&t.element,i,n)}drop(e,t,i,n){this.dnd.drop(y(e),t&&t.element,i,n)}onDragEnd(e){var t,i;null===(i=(t=this.dnd).onDragEnd)||void 0===i||i.call(t,e)}dispose(){this.dnd.dispose()}}function x(e){return e&&{...e,collapseByDefault:!0,identityProvider:e.identityProvider&&{getId(t){return e.identityProvider.getId(t.element)}},dnd:e.dnd&&new S(e.dnd),multipleSelectionController:e.multipleSelectionController&&{isSelectionSingleChangeEvent(t){return e.multipleSelectionController.isSelectionSingleChangeEvent({...t,element:t.element})},isSelectionRangeChangeEvent(t){return e.multipleSelectionController.isSelectionRangeChangeEvent({...t,element:t.element})}},accessibilityProvider:e.accessibilityProvider&&{...e.accessibilityProvider,getPosInSet:void 0,getSetSize:void 0,getRole:e.accessibilityProvider.getRole?t=>e.accessibilityProvider.getRole(t.element):()=>"treeitem",isChecked:e.accessibilityProvider.isChecked?t=>{var i;return!!(null===(i=e.accessibilityProvider)||void 0===i?void 0:i.isChecked(t.element))}:void 0,getAriaLabel(t){return e.accessibilityProvider.getAriaLabel(t.element)},getWidgetAriaLabel(){return e.accessibilityProvider.getWidgetAriaLabel()},getWidgetRole:e.accessibilityProvider.getWidgetRole?()=>e.accessibilityProvider.getWidgetRole():()=>"tree",getAriaLevel:e.accessibilityProvider.getAriaLevel&&(t=>e.accessibilityProvider.getAriaLevel(t.element)),getActiveDescendantId:e.accessibilityProvider.getActiveDescendantId&&(t=>e.accessibilityProvider.getActiveDescendantId(t.element))},filter:e.filter&&{filter(t,i){return e.filter.filter(t.element,i)}},keyboardNavigationLabelProvider:e.keyboardNavigationLabelProvider&&{...e.keyboardNavigationLabelProvider,getKeyboardNavigationLabel(t){return e.keyboardNavigationLabelProvider.getKeyboardNavigationLabel(t.element)}},sorter:void 0,expandOnlyOnTwistieClick:void 0===e.expandOnlyOnTwistieClick?void 0:"function"!=typeof e.expandOnlyOnTwistieClick?e.expandOnlyOnTwistieClick:t=>e.expandOnlyOnTwistieClick(t.element),defaultFindVisibility:t=>t.hasChildren&&t.stale?1:"number"==typeof e.defaultFindVisibility?e.defaultFindVisibility:void 0===e.defaultFindVisibility?2:e.defaultFindVisibility(t.element)}}function E(e,t){t(e),e.children.forEach((e=>E(e,t)))}class k{get onDidScroll(){return this.tree.onDidScroll}get onDidChangeFocus(){return h.Event.map(this.tree.onDidChangeFocus,A)}get onDidChangeSelection(){return h.Event.map(this.tree.onDidChangeSelection,A)}get onMouseDblClick(){return h.Event.map(this.tree.onMouseDblClick,C)}get onPointer(){return h.Event.map(this.tree.onPointer,C)}get onDidFocus(){return this.tree.onDidFocus}get onDidChangeModel(){return this.tree.onDidChangeModel}get onDidChangeCollapseState(){return this.tree.onDidChangeCollapseState}get onDidChangeFindOpenState(){return this.tree.onDidChangeFindOpenState}get onDidDispose(){return this.tree.onDidDispose}constructor(e,t,i,n,o,r={}){this.user=e,this.dataSource=o,this.nodes=new Map,this.subTreeRefreshPromises=new Map,this.refreshPromises=new Map,this._onDidRender=new h.Emitter,this._onDidChangeNodeSlowState=new h.Emitter,this.nodeMapper=new a.WeakMapper((e=>new v(e))),this.disposables=new p.DisposableStore,this.identityProvider=r.identityProvider,this.autoExpandSingleChildren=void 0!==r.autoExpandSingleChildren&&r.autoExpandSingleChildren,this.sorter=r.sorter,this.getDefaultCollapseState=e=>r.collapseByDefault?r.collapseByDefault(e)?a.ObjectTreeElementCollapseState.PreserveOrCollapsed:a.ObjectTreeElementCollapseState.PreserveOrExpanded:void 0,this.tree=this.createTree(e,t,i,n,r),this.onDidChangeFindMode=this.tree.onDidChangeFindMode,this.root=f({element:void 0,parent:null,hasChildren:!0,defaultCollapseState:void 0}),this.identityProvider&&(this.root={...this.root,id:null}),this.nodes.set(null,this.root),this.tree.onDidChangeCollapseState(this._onDidChangeCollapseState,this,this.disposables)}createTree(e,t,i,n,r){const a=new o.ComposedTreeDelegate(i),l=n.map((e=>new _(e,this.nodeMapper,this._onDidChangeNodeSlowState.event))),c=x(r)||{};return new s.ObjectTree(e,t,a,l,c)}updateOptions(e={}){this.tree.updateOptions(e)}getHTMLElement(){return this.tree.getHTMLElement()}get scrollTop(){return this.tree.scrollTop}set scrollTop(e){this.tree.scrollTop=e}get scrollHeight(){return this.tree.scrollHeight}get renderHeight(){return this.tree.renderHeight}domFocus(){this.tree.domFocus()}layout(e,t){this.tree.layout(e,t)}style(e){this.tree.style(e)}getInput(){return this.root.element}async setInput(e,t){this.refreshPromises.forEach((e=>e.cancel())),this.refreshPromises.clear(),this.root.element=e;const i=t&&{viewState:t,focus:[],selection:[]};await this._updateChildren(e,!0,!1,i),i&&(this.tree.setFocus(i.focus),this.tree.setSelection(i.selection)),t&&"number"==typeof t.scrollTop&&(this.scrollTop=t.scrollTop)}async _updateChildren(e=this.root.element,t=!0,i=!1,n,o){if(void 0===this.root.element)throw new a.TreeError(this.user,"Tree input not set");this.root.refreshPromise&&(await this.root.refreshPromise,await h.Event.toPromise(this._onDidRender.event));const r=this.getDataNode(e);if(await this.refreshAndRenderNode(r,t,n,o),i)try{this.tree.rerender(r)}catch(e){}}rerender(e){if(void 0===e||e===this.root.element)return void this.tree.rerender();const t=this.getDataNode(e);this.tree.rerender(t)}getNode(e=this.root.element){const t=this.getDataNode(e),i=this.tree.getNode(t===this.root?null:t);return this.nodeMapper.map(i)}collapse(e,t=!1){const i=this.getDataNode(e);return this.tree.collapse(i===this.root?null:i,t)}async expand(e,t=!1){if(void 0===this.root.element)throw new a.TreeError(this.user,"Tree input not set");this.root.refreshPromise&&(await this.root.refreshPromise,await h.Event.toPromise(this._onDidRender.event));const i=this.getDataNode(e);if(this.tree.hasElement(i)&&!this.tree.isCollapsible(i))return!1;if(i.refreshPromise&&(await this.root.refreshPromise,await h.Event.toPromise(this._onDidRender.event)),i!==this.root&&!i.refreshPromise&&!this.tree.isCollapsed(i))return!1;const n=this.tree.expand(i===this.root?null:i,t);return i.refreshPromise&&(await this.root.refreshPromise,await h.Event.toPromise(this._onDidRender.event)),n}setSelection(e,t){const i=e.map((e=>this.getDataNode(e)));this.tree.setSelection(i,t)}getSelection(){return this.tree.getSelection().map((e=>e.element))}setFocus(e,t){const i=e.map((e=>this.getDataNode(e)));this.tree.setFocus(i,t)}getFocus(){return this.tree.getFocus().map((e=>e.element))}reveal(e,t){this.tree.reveal(this.getDataNode(e),t)}getParentElement(e){const t=this.tree.getParentElement(this.getDataNode(e));return t&&t.element}getFirstElementChild(e=this.root.element){const t=this.getDataNode(e),i=this.tree.getFirstElementChild(t===this.root?null:t);return i&&i.element}getDataNode(e){const t=this.nodes.get(e===this.root.element?null:e);if(!t)throw new a.TreeError(this.user,`Data tree node not found: ${e}`);return t}async refreshAndRenderNode(e,t,i,n){await this.refreshNode(e,t,i),this.render(e,i,n)}async refreshNode(e,t,i){let n;if(this.subTreeRefreshPromises.forEach(((o,r)=>{!n&&function(e,t){return e===t||b(e,t)||b(t,e)}(r,e)&&(n=o.then((()=>this.refreshNode(e,t,i))))})),n)return n;if(e!==this.root){if(this.tree.getNode(e).collapsed)return e.hasChildren=!!this.dataSource.hasChildren(e.element),void(e.stale=!0)}return this.doRefreshSubTree(e,t,i)}async doRefreshSubTree(e,t,i){let n;e.refreshPromise=new Promise((e=>n=e)),this.subTreeRefreshPromises.set(e,e.refreshPromise),e.refreshPromise.finally((()=>{e.refreshPromise=void 0,this.subTreeRefreshPromises.delete(e)}));try{const n=await this.doRefreshNode(e,t,i);e.stale=!1,await l.Promises.settled(n.map((e=>this.doRefreshSubTree(e,t,i))))}finally{n()}}async doRefreshNode(e,t,i){let n;if(e.hasChildren=!!this.dataSource.hasChildren(e.element),e.hasChildren){const t=this.doGetChildren(e);if((0,m.isIterable)(t))n=Promise.resolve(t);else{const i=(0,l.timeout)(800);i.then((()=>{e.slow=!0,this._onDidChangeNodeSlowState.fire(e)}),(e=>null)),n=t.finally((()=>i.cancel()))}}else n=Promise.resolve(g.Iterable.empty());try{const o=await n;return this.setChildren(e,o,t,i)}catch(t){if(e!==this.root&&this.tree.hasElement(e)&&this.tree.collapse(e),(0,u.isCancellationError)(t))return[];throw t}finally{e.slow&&(e.slow=!1,this._onDidChangeNodeSlowState.fire(e))}}doGetChildren(e){let t=this.refreshPromises.get(e);if(t)return t;const i=this.dataSource.getChildren(e.element);return(0,m.isIterable)(i)?this.processChildren(i):(t=(0,l.createCancelablePromise)((async()=>this.processChildren(await i))),this.refreshPromises.set(e,t),t.finally((()=>{this.refreshPromises.delete(e)})))}_onDidChangeCollapseState({node:e,deep:t}){null!==e.element&&!e.collapsed&&e.element.stale&&(t?this.collapse(e.element.element):this.refreshAndRenderNode(e.element,!1).catch(u.onUnexpectedError))}setChildren(e,t,i,n){const o=[...t];if(0===e.children.length&&0===o.length)return[];const r=new Map,s=new Map;for(const t of e.children)r.set(t.element,t),this.identityProvider&&s.set(t.id,{node:t,collapsed:this.tree.hasElement(t)&&this.tree.isCollapsed(t)});const l=[],c=o.map((t=>{const o=!!this.dataSource.hasChildren(t);if(!this.identityProvider){const i=f({element:t,parent:e,hasChildren:o,defaultCollapseState:this.getDefaultCollapseState(t)});return o&&i.defaultCollapseState===a.ObjectTreeElementCollapseState.PreserveOrExpanded&&l.push(i),i}const c=this.identityProvider.getId(t).toString(),d=s.get(c);if(d){const e=d.node;return r.delete(e.element),this.nodes.delete(e.element),this.nodes.set(t,e),e.element=t,e.hasChildren=o,i?d.collapsed?(e.children.forEach((e=>E(e,(e=>this.nodes.delete(e.element))))),e.children.splice(0,e.children.length),e.stale=!0):l.push(e):o&&!d.collapsed&&l.push(e),e}const u=f({element:t,parent:e,id:c,hasChildren:o,defaultCollapseState:this.getDefaultCollapseState(t)});return n&&n.viewState.focus&&n.viewState.focus.indexOf(c)>-1&&n.focus.push(u),n&&n.viewState.selection&&n.viewState.selection.indexOf(c)>-1&&n.selection.push(u),(n&&n.viewState.expanded&&n.viewState.expanded.indexOf(c)>-1||o&&u.defaultCollapseState===a.ObjectTreeElementCollapseState.PreserveOrExpanded)&&l.push(u),u}));for(const e of r.values())E(e,(e=>this.nodes.delete(e.element)));for(const e of c)this.nodes.set(e.element,e);return e.children.splice(0,e.children.length,...c),e!==this.root&&this.autoExpandSingleChildren&&1===c.length&&0===l.length&&(c[0].forceExpanded=!0,l.push(c[0])),l}render(e,t,i){const n=e.children.map((e=>this.asTreeElement(e,t))),o=i&&{...i,diffIdentityProvider:i.diffIdentityProvider&&{getId(e){return i.diffIdentityProvider.getId(e.element)}}};this.tree.setChildren(e===this.root?null:e,n,o),e!==this.root&&this.tree.setCollapsible(e,e.hasChildren),this._onDidRender.fire()}asTreeElement(e,t){if(e.stale)return{element:e,collapsible:e.hasChildren,collapsed:!0};let i;return t&&t.viewState.expanded&&e.id&&t.viewState.expanded.indexOf(e.id)>-1?i=!1:e.forceExpanded?(i=!1,e.forceExpanded=!1):i=e.defaultCollapseState,{element:e,children:e.hasChildren?g.Iterable.map(e.children,(e=>this.asTreeElement(e,t))):[],collapsible:e.hasChildren,collapsed:i}}processChildren(e){return this.sorter&&(e=[...e].sort(this.sorter.compare.bind(this.sorter))),e}dispose(){this.disposables.dispose(),this.tree.dispose()}}class D{get element(){return{elements:this.node.element.elements.map((e=>e.element)),incompressible:this.node.element.incompressible}}get children(){return this.node.children.map((e=>new D(e)))}get depth(){return this.node.depth}get visibleChildrenCount(){return this.node.visibleChildrenCount}get visibleChildIndex(){return this.node.visibleChildIndex}get collapsible(){return this.node.collapsible}get collapsed(){return this.node.collapsed}get visible(){return this.node.visible}get filterData(){return this.node.filterData}constructor(e){this.node=e}}class I{constructor(e,t,i,n){this.renderer=e,this.nodeMapper=t,this.compressibleNodeMapperProvider=i,this.onDidChangeTwistieState=n,this.renderedNodes=new Map,this.disposables=[],this.templateId=e.templateId}renderTemplate(e){return{templateData:this.renderer.renderTemplate(e)}}renderElement(e,t,i,n){this.renderer.renderElement(this.nodeMapper.map(e),t,i.templateData,n)}renderCompressedElements(e,t,i,n){this.renderer.renderCompressedElements(this.compressibleNodeMapperProvider().map(e),t,i.templateData,n)}renderTwistie(e,t){return e.slow?(t.classList.add(...d.ThemeIcon.asClassNameArray(c.Codicon.treeItemLoading)),!0):(t.classList.remove(...d.ThemeIcon.asClassNameArray(c.Codicon.treeItemLoading)),!1)}disposeElement(e,t,i,n){var o,r;null===(r=(o=this.renderer).disposeElement)||void 0===r||r.call(o,this.nodeMapper.map(e),t,i.templateData,n)}disposeCompressedElements(e,t,i,n){var o,r;null===(r=(o=this.renderer).disposeCompressedElements)||void 0===r||r.call(o,this.compressibleNodeMapperProvider().map(e),t,i.templateData,n)}disposeTemplate(e){this.renderer.disposeTemplate(e.templateData)}dispose(){this.renderedNodes.clear(),this.disposables=(0,p.dispose)(this.disposables)}}class L extends k{constructor(e,t,i,n,o,r,s={}){super(e,t,i,o,r,s),this.compressionDelegate=n,this.compressibleNodeMapper=new a.WeakMapper((e=>new D(e))),this.filter=s.filter}createTree(e,t,i,n,r){const a=new o.ComposedTreeDelegate(i),l=n.map((e=>new I(e,this.nodeMapper,(()=>this.compressibleNodeMapper),this._onDidChangeNodeSlowState.event))),c=function(e){const t=e&&x(e);return t&&{...t,keyboardNavigationLabelProvider:t.keyboardNavigationLabelProvider&&{...t.keyboardNavigationLabelProvider,getCompressedNodeKeyboardNavigationLabel(t){return e.keyboardNavigationLabelProvider.getCompressedNodeKeyboardNavigationLabel(t.map((e=>e.element)))}}}}(r)||{};return new s.CompressibleObjectTree(e,t,a,l,c)}asTreeElement(e,t){return{incompressible:this.compressionDelegate.isIncompressible(e.element),...super.asTreeElement(e,t)}}updateOptions(e={}){this.tree.updateOptions(e)}render(e,t){if(!this.identityProvider)return super.render(e,t);const i=e=>this.identityProvider.getId(e).toString(),n=e=>{const t=new Set;for(const n of e){const e=this.tree.getCompressedTreeNode(n===this.root?null:n);if(e.element)for(const n of e.element.elements)t.add(i(n.element))}return t},o=n(this.tree.getSelection()),r=n(this.tree.getFocus());super.render(e,t);const s=this.getSelection();let a=!1;const l=this.getFocus();let c=!1;const d=e=>{const t=e.element;if(t)for(let e=0;e<t.elements.length;e++){const n=i(t.elements[e].element),d=t.elements[t.elements.length-1].element;o.has(n)&&-1===s.indexOf(d)&&(s.push(d),a=!0),r.has(n)&&-1===l.indexOf(d)&&(l.push(d),c=!0)}e.children.forEach(d)};d(this.tree.getCompressedTreeNode(e===this.root?null:e)),a&&this.setSelection(s),c&&this.setFocus(l)}processChildren(e){return this.filter&&(e=g.Iterable.filter(e,(e=>{const t=this.filter.filter(e,1),i="boolean"==typeof(n=t)?n?1:0:(0,r.isFilterResult)(n)?(0,r.getVisibleState)(n.visibility):(0,r.getVisibleState)(n);var n;if(2===i)throw new Error("Recursive tree visibility not supported in async data compressed trees");return 1===i}))),super.processChildren(e)}}},41605:function(e,t,i){"use strict";i.r(t),i.d(t,{CompressedObjectTreeModel:function(){return g},CompressibleObjectTreeModel:function(){return f},DefaultElementMapper:function(){return p},compress:function(){return c},decompress:function(){return u}});var n=i(63735),o=i(23877),r=i(64998),s=i(63801),a=i(24417);function l(e){return{element:{elements:[e.element],incompressible:e.incompressible||!1},children:a.Iterable.map(a.Iterable.from(e.children),l),collapsible:e.collapsible,collapsed:e.collapsed}}function c(e){const t=[e.element],i=e.incompressible||!1;let n,o;for(;[o,n]=a.Iterable.consume(a.Iterable.from(e.children),2),1===o.length&&!o[0].incompressible;)e=o[0],t.push(e.element);return{element:{elements:t,incompressible:i},children:a.Iterable.map(a.Iterable.concat(o,n),c),collapsible:e.collapsible,collapsed:e.collapsed}}function d(e,t=0){let i;return i=t<e.element.elements.length-1?[d(e,t+1)]:a.Iterable.map(a.Iterable.from(e.children),(e=>d(e,0))),0===t&&e.element.incompressible?{element:e.element.elements[t],children:i,incompressible:!0,collapsible:e.collapsible,collapsed:e.collapsed}:{element:e.element.elements[t],children:i,collapsible:e.collapsible,collapsed:e.collapsed}}function u(e){return d(e,0)}function h(e,t,i){return e.element===t?{...e,children:i}:{...e,children:a.Iterable.map(a.Iterable.from(e.children),(e=>h(e,t,i)))}}class g{get onDidSplice(){return this.model.onDidSplice}get onDidChangeCollapseState(){return this.model.onDidChangeCollapseState}get onDidChangeRenderNodeCount(){return this.model.onDidChangeRenderNodeCount}constructor(e,t,i={}){this.user=e,this.rootRef=null,this.nodes=new Map,this.model=new n.ObjectTreeModel(e,t,i),this.enabled=void 0===i.compressionEnabled||i.compressionEnabled,this.identityProvider=i.identityProvider}setChildren(e,t=a.Iterable.empty(),i){const n=i.diffIdentityProvider&&(s=i.diffIdentityProvider,{getId(e){return e.elements.map((e=>s.getId(e).toString())).join("\0")}});var s;if(null===e){const e=a.Iterable.map(t,this.enabled?c:l);return void this._setChildren(null,e,{diffIdentityProvider:n,diffDepth:1/0})}const d=this.nodes.get(e);if(!d)throw new o.TreeError(this.user,"Unknown compressed tree node");const g=this.model.getNode(d),p=this.model.getParentNodeLocation(d),m=this.model.getNode(p),f=h(u(g),e,t),b=(this.enabled?c:l)(f),v=i.diffIdentityProvider?(e,t)=>i.diffIdentityProvider.getId(e)===i.diffIdentityProvider.getId(t):void 0;if((0,r.equals)(b.element.elements,g.element.elements,v))return void this._setChildren(d,b.children||a.Iterable.empty(),{diffIdentityProvider:n,diffDepth:1});const _=m.children.map((e=>e===g?b:e));this._setChildren(m.element,_,{diffIdentityProvider:n,diffDepth:g.depth-m.depth})}setCompressionEnabled(e){if(e===this.enabled)return;this.enabled=e;const t=this.model.getNode().children,i=a.Iterable.map(t,u),n=a.Iterable.map(i,e?c:l);this._setChildren(null,n,{diffIdentityProvider:this.identityProvider,diffDepth:1/0})}_setChildren(e,t,i){const n=new Set;this.model.setChildren(e,t,{...i,onDidCreateNode:e=>{for(const t of e.element.elements)n.add(t),this.nodes.set(t,e.element)},onDidDeleteNode:e=>{for(const t of e.element.elements)n.has(t)||this.nodes.delete(t)}})}has(e){return this.nodes.has(e)}getListIndex(e){const t=this.getCompressedNode(e);return this.model.getListIndex(t)}getListRenderCount(e){const t=this.getCompressedNode(e);return this.model.getListRenderCount(t)}getNode(e){if(void 0===e)return this.model.getNode();const t=this.getCompressedNode(e);return this.model.getNode(t)}getNodeLocation(e){const t=this.model.getNodeLocation(e);return null===t?null:t.elements[t.elements.length-1]}getParentNodeLocation(e){const t=this.getCompressedNode(e),i=this.model.getParentNodeLocation(t);return null===i?null:i.elements[i.elements.length-1]}getFirstElementChild(e){const t=this.getCompressedNode(e);return this.model.getFirstElementChild(t)}isCollapsible(e){const t=this.getCompressedNode(e);return this.model.isCollapsible(t)}setCollapsible(e,t){const i=this.getCompressedNode(e);return this.model.setCollapsible(i,t)}isCollapsed(e){const t=this.getCompressedNode(e);return this.model.isCollapsed(t)}setCollapsed(e,t,i){const n=this.getCompressedNode(e);return this.model.setCollapsed(n,t,i)}expandTo(e){const t=this.getCompressedNode(e);this.model.expandTo(t)}rerender(e){const t=this.getCompressedNode(e);this.model.rerender(t)}refilter(){this.model.refilter()}getCompressedNode(e){if(null===e)return null;const t=this.nodes.get(e);if(!t)throw new o.TreeError(this.user,`Tree element not found: ${e}`);return t}}const p=e=>e[e.length-1];class m{get element(){return null===this.node.element?null:this.unwrapper(this.node.element)}get children(){return this.node.children.map((e=>new m(this.unwrapper,e)))}get depth(){return this.node.depth}get visibleChildrenCount(){return this.node.visibleChildrenCount}get visibleChildIndex(){return this.node.visibleChildIndex}get collapsible(){return this.node.collapsible}get collapsed(){return this.node.collapsed}get visible(){return this.node.visible}get filterData(){return this.node.filterData}constructor(e,t){this.unwrapper=e,this.node=t}}class f{get onDidSplice(){return s.Event.map(this.model.onDidSplice,(({insertedNodes:e,deletedNodes:t})=>({insertedNodes:e.map((e=>this.nodeMapper.map(e))),deletedNodes:t.map((e=>this.nodeMapper.map(e)))})))}get onDidChangeCollapseState(){return s.Event.map(this.model.onDidChangeCollapseState,(({node:e,deep:t})=>({node:this.nodeMapper.map(e),deep:t})))}get onDidChangeRenderNodeCount(){return s.Event.map(this.model.onDidChangeRenderNodeCount,(e=>this.nodeMapper.map(e)))}constructor(e,t,i={}){this.rootRef=null,this.elementMapper=i.elementMapper||p;const n=e=>this.elementMapper(e.elements);this.nodeMapper=new o.WeakMapper((e=>new m(n,e))),this.model=new g(e,function(e,t){return{splice(i,n,o){t.splice(i,n,o.map((t=>e.map(t))))},updateElementHeight(e,i){t.updateElementHeight(e,i)}}}(this.nodeMapper,t),function(e,t){return{...t,identityProvider:t.identityProvider&&{getId(i){return t.identityProvider.getId(e(i))}},sorter:t.sorter&&{compare(e,i){return t.sorter.compare(e.elements[0],i.elements[0])}},filter:t.filter&&{filter(i,n){return t.filter.filter(e(i),n)}}}}(n,i))}setChildren(e,t=a.Iterable.empty(),i={}){this.model.setChildren(e,t,i)}setCompressionEnabled(e){this.model.setCompressionEnabled(e)}has(e){return this.model.has(e)}getListIndex(e){return this.model.getListIndex(e)}getListRenderCount(e){return this.model.getListRenderCount(e)}getNode(e){return this.nodeMapper.map(this.model.getNode(e))}getNodeLocation(e){return e.element}getParentNodeLocation(e){return this.model.getParentNodeLocation(e)}getFirstElementChild(e){const t=this.model.getFirstElementChild(e);return null==t?t:this.elementMapper(t.elements)}isCollapsible(e){return this.model.isCollapsible(e)}setCollapsible(e,t){return this.model.setCollapsible(e,t)}isCollapsed(e){return this.model.isCollapsed(e)}setCollapsed(e,t,i){return this.model.setCollapsed(e,t,i)}expandTo(e){return this.model.expandTo(e)}rerender(e){return this.model.rerender(e)}refilter(){return this.model.refilter()}getCompressedTreeNode(e=null){return this.model.getNode(e)}}},35313:function(e,t,i){"use strict";i.r(t),i.d(t,{DataTree:function(){return r}});var n=i(72665),o=i(63735);class r extends n.AbstractTree{constructor(e,t,i,n,o,r={}){super(e,t,i,n,r),this.user=e,this.dataSource=o,this.identityProvider=r.identityProvider}createModel(e,t,i){return new o.ObjectTreeModel(e,t,i)}}},49517:function(e,t,i){"use strict";i.r(t),i.d(t,{IndexTreeModel:function(){return g},getVisibleState:function(){return u},isFilterResult:function(){return d}});var n=i(23877),o=i(64998),r=i(66129),s=i(68945),a=i(11914),l=i(63801),c=i(24417);function d(e){return"object"==typeof e&&"visibility"in e&&"data"in e}function u(e){switch(e){case!0:return 1;case!1:return 0;default:return e}}function h(e){return"boolean"==typeof e.collapsible}class g{constructor(e,t,i,n={}){this.user=e,this.list=t,this.rootRef=[],this.eventBufferer=new l.EventBufferer,this._onDidChangeCollapseState=new l.Emitter,this.onDidChangeCollapseState=this.eventBufferer.wrapEvent(this._onDidChangeCollapseState.event),this._onDidChangeRenderNodeCount=new l.Emitter,this.onDidChangeRenderNodeCount=this.eventBufferer.wrapEvent(this._onDidChangeRenderNodeCount.event),this._onDidSplice=new l.Emitter,this.onDidSplice=this._onDidSplice.event,this.refilterDelayer=new r.Delayer(s.MicrotaskDelay),this.collapseByDefault=void 0!==n.collapseByDefault&&n.collapseByDefault,this.filter=n.filter,this.autoExpandSingleChildren=void 0!==n.autoExpandSingleChildren&&n.autoExpandSingleChildren,this.root={parent:void 0,element:i,children:[],depth:0,visibleChildrenCount:0,visibleChildIndex:-1,collapsible:!1,collapsed:!1,renderNodeCount:0,visibility:1,visible:!0,filterData:void 0}}splice(e,t,i=c.Iterable.empty(),o={}){if(0===e.length)throw new n.TreeError(this.user,"Invalid tree location");o.diffIdentityProvider?this.spliceSmart(o.diffIdentityProvider,e,t,i,o):this.spliceSimple(e,t,i,o)}spliceSmart(e,t,i,n,o,r){var s;void 0===n&&(n=c.Iterable.empty()),void 0===r&&(r=null!==(s=o.diffDepth)&&void 0!==s?s:0);const{parentNode:l}=this.getParentNodeWithListIndex(t);if(!l.lastDiffIds)return this.spliceSimple(t,i,n,o);const d=[...n],u=t[t.length-1],h=new a.LcsDiff({getElements:()=>l.lastDiffIds},{getElements:()=>[...l.children.slice(0,u),...d,...l.children.slice(u+i)].map((t=>e.getId(t.element).toString()))}).ComputeDiff(!1);if(h.quitEarly)return l.lastDiffIds=void 0,this.spliceSimple(t,i,d,o);const g=t.slice(0,-1),p=(t,i,n)=>{if(r>0)for(let s=0;s<n;s++)t--,i--,this.spliceSmart(e,[...g,t,0],Number.MAX_SAFE_INTEGER,d[i].children,o,r-1)};let m=Math.min(l.children.length,u+i),f=d.length;for(const e of h.changes.sort(((e,t)=>t.originalStart-e.originalStart)))p(m,f,m-(e.originalStart+e.originalLength)),m=e.originalStart,f=e.modifiedStart-u,this.spliceSimple([...g,m],e.originalLength,c.Iterable.slice(d,f,f+e.modifiedLength),o);p(m,f,m)}spliceSimple(e,t,i=c.Iterable.empty(),{onDidCreateNode:n,onDidDeleteNode:r,diffIdentityProvider:s}){const{parentNode:a,listIndex:l,revealed:d,visible:u}=this.getParentNodeWithListIndex(e),h=[],g=c.Iterable.map(i,(e=>this.createTreeNode(e,a,a.visible?1:0,d,h,n))),p=e[e.length-1],m=a.children.length>0;let f=0;for(let e=p;e>=0&&e<a.children.length;e--){const t=a.children[e];if(t.visible){f=t.visibleChildIndex;break}}const b=[];let v=0,_=0;for(const e of g)b.push(e),_+=e.renderNodeCount,e.visible&&(e.visibleChildIndex=f+v++);const A=(0,o.splice)(a.children,p,t,b);s?a.lastDiffIds?(0,o.splice)(a.lastDiffIds,p,t,b.map((e=>s.getId(e.element).toString()))):a.lastDiffIds=a.children.map((e=>s.getId(e.element).toString())):a.lastDiffIds=void 0;let C=0;for(const e of A)e.visible&&C++;if(0!==C)for(let e=p+b.length;e<a.children.length;e++){const t=a.children[e];t.visible&&(t.visibleChildIndex-=C)}if(a.visibleChildrenCount+=v-C,d&&u){const e=A.reduce(((e,t)=>e+(t.visible?t.renderNodeCount:0)),0);this._updateAncestorsRenderNodeCount(a,_-e),this.list.splice(l,e,h)}if(A.length>0&&r){const e=t=>{r(t),t.children.forEach(e)};A.forEach(e)}this._onDidSplice.fire({insertedNodes:b,deletedNodes:A});const w=a.children.length>0;m!==w&&this.setCollapsible(e.slice(0,-1),w);let y=a;for(;y;){if(2===y.visibility){this.refilterDelayer.trigger((()=>this.refilter()));break}y=y.parent}}rerender(e){if(0===e.length)throw new n.TreeError(this.user,"Invalid tree location");const{node:t,listIndex:i,revealed:o}=this.getTreeNodeWithListIndex(e);t.visible&&o&&this.list.splice(i,1,[t])}has(e){return this.hasTreeNode(e)}getListIndex(e){const{listIndex:t,visible:i,revealed:n}=this.getTreeNodeWithListIndex(e);return i&&n?t:-1}getListRenderCount(e){return this.getTreeNode(e).renderNodeCount}isCollapsible(e){return this.getTreeNode(e).collapsible}setCollapsible(e,t){const i=this.getTreeNode(e);void 0===t&&(t=!i.collapsible);const n={collapsible:t};return this.eventBufferer.bufferEvents((()=>this._setCollapseState(e,n)))}isCollapsed(e){return this.getTreeNode(e).collapsed}setCollapsed(e,t,i){const n=this.getTreeNode(e);void 0===t&&(t=!n.collapsed);const o={collapsed:t,recursive:i||!1};return this.eventBufferer.bufferEvents((()=>this._setCollapseState(e,o)))}_setCollapseState(e,t){const{node:i,listIndex:n,revealed:o}=this.getTreeNodeWithListIndex(e),r=this._setListNodeCollapseState(i,n,o,t);if(i!==this.root&&this.autoExpandSingleChildren&&r&&!h(t)&&i.collapsible&&!i.collapsed&&!t.recursive){let n=-1;for(let e=0;e<i.children.length;e++){if(i.children[e].visible){if(n>-1){n=-1;break}n=e}}n>-1&&this._setCollapseState([...e,n],t)}return r}_setListNodeCollapseState(e,t,i,n){const o=this._setNodeCollapseState(e,n,!1);if(!i||!e.visible||!o)return o;const r=e.renderNodeCount,s=this.updateNodeAfterCollapseChange(e),a=r-(-1===t?0:1);return this.list.splice(t+1,a,s.slice(1)),o}_setNodeCollapseState(e,t,i){let n;if(e===this.root?n=!1:(h(t)?(n=e.collapsible!==t.collapsible,e.collapsible=t.collapsible):e.collapsible?(n=e.collapsed!==t.collapsed,e.collapsed=t.collapsed):n=!1,n&&this._onDidChangeCollapseState.fire({node:e,deep:i})),!h(t)&&t.recursive)for(const i of e.children)n=this._setNodeCollapseState(i,t,!0)||n;return n}expandTo(e){this.eventBufferer.bufferEvents((()=>{let t=this.getTreeNode(e);for(;t.parent;)t=t.parent,e=e.slice(0,e.length-1),t.collapsed&&this._setCollapseState(e,{collapsed:!1,recursive:!1})}))}refilter(){const e=this.root.renderNodeCount,t=this.updateNodeAfterFilterChange(this.root);this.list.splice(0,e,t),this.refilterDelayer.cancel()}createTreeNode(e,t,i,n,o,r){const s={parent:t,element:e.element,children:[],depth:t.depth+1,visibleChildrenCount:0,visibleChildIndex:-1,collapsible:"boolean"==typeof e.collapsible?e.collapsible:void 0!==e.collapsed,collapsed:void 0===e.collapsed?this.collapseByDefault:e.collapsed,renderNodeCount:1,visibility:1,visible:!0,filterData:void 0},a=this._filterNode(s,i);s.visibility=a,n&&o.push(s);const l=e.children||c.Iterable.empty(),d=n&&0!==a&&!s.collapsed;let u=0,h=1;for(const e of l){const t=this.createTreeNode(e,s,a,d,o,r);s.children.push(t),h+=t.renderNodeCount,t.visible&&(t.visibleChildIndex=u++)}return s.collapsible=s.collapsible||s.children.length>0,s.visibleChildrenCount=u,s.visible=2===a?u>0:1===a,s.visible?s.collapsed||(s.renderNodeCount=h):(s.renderNodeCount=0,n&&o.pop()),null==r||r(s),s}updateNodeAfterCollapseChange(e){const t=e.renderNodeCount,i=[];return this._updateNodeAfterCollapseChange(e,i),this._updateAncestorsRenderNodeCount(e.parent,i.length-t),i}_updateNodeAfterCollapseChange(e,t){if(!1===e.visible)return 0;if(t.push(e),e.renderNodeCount=1,!e.collapsed)for(const i of e.children)e.renderNodeCount+=this._updateNodeAfterCollapseChange(i,t);return this._onDidChangeRenderNodeCount.fire(e),e.renderNodeCount}updateNodeAfterFilterChange(e){const t=e.renderNodeCount,i=[];return this._updateNodeAfterFilterChange(e,e.visible?1:0,i),this._updateAncestorsRenderNodeCount(e.parent,i.length-t),i}_updateNodeAfterFilterChange(e,t,i,n=!0){let o;if(e!==this.root){if(o=this._filterNode(e,t),0===o)return e.visible=!1,e.renderNodeCount=0,!1;n&&i.push(e)}const r=i.length;e.renderNodeCount=e===this.root?0:1;let s=!1;if(e.collapsed&&0===o)e.visibleChildrenCount=0;else{let t=0;for(const r of e.children)s=this._updateNodeAfterFilterChange(r,o,i,n&&!e.collapsed)||s,r.visible&&(r.visibleChildIndex=t++);e.visibleChildrenCount=t}return e!==this.root&&(e.visible=2===o?s:1===o,e.visibility=o),e.visible?e.collapsed||(e.renderNodeCount+=i.length-r):(e.renderNodeCount=0,n&&i.pop()),this._onDidChangeRenderNodeCount.fire(e),e.visible}_updateAncestorsRenderNodeCount(e,t){if(0!==t)for(;e;)e.renderNodeCount+=t,this._onDidChangeRenderNodeCount.fire(e),e=e.parent}_filterNode(e,t){const i=this.filter?this.filter.filter(e.element,t):1;return"boolean"==typeof i?(e.filterData=void 0,i?1:0):d(i)?(e.filterData=i.data,u(i.visibility)):(e.filterData=void 0,u(i))}hasTreeNode(e,t=this.root){if(!e||0===e.length)return!0;const[i,...n]=e;return!(i<0||i>t.children.length)&&this.hasTreeNode(n,t.children[i])}getTreeNode(e,t=this.root){if(!e||0===e.length)return t;const[i,...o]=e;if(i<0||i>t.children.length)throw new n.TreeError(this.user,"Invalid tree location");return this.getTreeNode(o,t.children[i])}getTreeNodeWithListIndex(e){if(0===e.length)return{node:this.root,listIndex:-1,revealed:!0,visible:!1};const{parentNode:t,listIndex:i,revealed:o,visible:r}=this.getParentNodeWithListIndex(e),s=e[e.length-1];if(s<0||s>t.children.length)throw new n.TreeError(this.user,"Invalid tree location");const a=t.children[s];return{node:a,listIndex:i,revealed:o,visible:r&&a.visible}}getParentNodeWithListIndex(e,t=this.root,i=0,o=!0,r=!0){const[s,...a]=e;if(s<0||s>t.children.length)throw new n.TreeError(this.user,"Invalid tree location");for(let e=0;e<s;e++)i+=t.children[e].renderNodeCount;return o=o&&!t.collapsed,r=r&&t.visible,0===a.length?{parentNode:t,listIndex:i,revealed:o,visible:r}:this.getParentNodeWithListIndex(a,t.children[s],i+1,o,r)}getNode(e=[]){return this.getTreeNode(e)}getNodeLocation(e){const t=[];let i=e;for(;i.parent;)t.push(i.parent.children.indexOf(i)),i=i.parent;return t.reverse()}getParentNodeLocation(e){return 0===e.length?void 0:1===e.length?[]:(0,o.tail2)(e)[0]}getFirstElementChild(e){const t=this.getTreeNode(e);if(0!==t.children.length)return t.children[0].element}}},22481:function(e,t,i){"use strict";i.r(t),i.d(t,{CompressibleObjectTree:function(){return u},ObjectTree:function(){return c}});var n=i(72665),o=i(41605),r=i(63735),s=i(63966),a=i(24417),l=function(e,t,i,n){var o,r=arguments.length,s=r<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,i):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)s=Reflect.decorate(e,t,i,n);else for(var a=e.length-1;a>=0;a--)(o=e[a])&&(s=(r<3?o(s):r>3?o(t,i,s):o(t,i))||s);return r>3&&s&&Object.defineProperty(t,i,s),s};class c extends n.AbstractTree{get onDidChangeCollapseState(){return this.model.onDidChangeCollapseState}constructor(e,t,i,n,o={}){super(e,t,i,n,o),this.user=e}setChildren(e,t=a.Iterable.empty(),i){this.model.setChildren(e,t,i)}rerender(e){void 0!==e?this.model.rerender(e):this.view.rerender()}hasElement(e){return this.model.has(e)}createModel(e,t,i){return new r.ObjectTreeModel(e,t,i)}}class d{get compressedTreeNodeProvider(){return this._compressedTreeNodeProvider()}constructor(e,t){this._compressedTreeNodeProvider=e,this.renderer=t,this.templateId=t.templateId,t.onDidChangeTwistieState&&(this.onDidChangeTwistieState=t.onDidChangeTwistieState)}renderTemplate(e){return{compressedTreeNode:void 0,data:this.renderer.renderTemplate(e)}}renderElement(e,t,i,n){const o=this.compressedTreeNodeProvider.getCompressedTreeNode(e.element);1===o.element.elements.length?(i.compressedTreeNode=void 0,this.renderer.renderElement(e,t,i.data,n)):(i.compressedTreeNode=o,this.renderer.renderCompressedElements(o,t,i.data,n))}disposeElement(e,t,i,n){var o,r,s,a;i.compressedTreeNode?null===(r=(o=this.renderer).disposeCompressedElements)||void 0===r||r.call(o,i.compressedTreeNode,t,i.data,n):null===(a=(s=this.renderer).disposeElement)||void 0===a||a.call(s,e,t,i.data,n)}disposeTemplate(e){this.renderer.disposeTemplate(e.data)}renderTwistie(e,t){return!!this.renderer.renderTwistie&&this.renderer.renderTwistie(e,t)}}l([s.memoize],d.prototype,"compressedTreeNodeProvider",null);class u extends c{constructor(e,t,i,n,o={}){const r=()=>this;super(e,t,i,n.map((e=>new d(r,e))),function(e,t){return t&&{...t,keyboardNavigationLabelProvider:t.keyboardNavigationLabelProvider&&{getKeyboardNavigationLabel(i){let n;try{n=e().getCompressedTreeNode(i)}catch(e){return t.keyboardNavigationLabelProvider.getKeyboardNavigationLabel(i)}return 1===n.element.elements.length?t.keyboardNavigationLabelProvider.getKeyboardNavigationLabel(i):t.keyboardNavigationLabelProvider.getCompressedNodeKeyboardNavigationLabel(n.element.elements)}}}}(r,o))}setChildren(e,t=a.Iterable.empty(),i){this.model.setChildren(e,t,i)}createModel(e,t,i){return new o.CompressibleObjectTreeModel(e,t,i)}updateOptions(e={}){super.updateOptions(e),void 0!==e.compressionEnabled&&this.model.setCompressionEnabled(e.compressionEnabled)}getCompressedTreeNode(e=null){return this.model.getCompressedTreeNode(e)}}},63735:function(e,t,i){"use strict";i.r(t),i.d(t,{ObjectTreeModel:function(){return s}});var n=i(49517),o=i(23877),r=i(24417);class s{constructor(e,t,i={}){this.user=e,this.rootRef=null,this.nodes=new Map,this.nodesByIdentity=new Map,this.model=new n.IndexTreeModel(e,t,null,i),this.onDidSplice=this.model.onDidSplice,this.onDidChangeCollapseState=this.model.onDidChangeCollapseState,this.onDidChangeRenderNodeCount=this.model.onDidChangeRenderNodeCount,i.sorter&&(this.sorter={compare(e,t){return i.sorter.compare(e.element,t.element)}}),this.identityProvider=i.identityProvider}setChildren(e,t=r.Iterable.empty(),i={}){const n=this.getElementLocation(e);this._setChildren(n,this.preserveCollapseState(t),i)}_setChildren(e,t=r.Iterable.empty(),i){const n=new Set,o=new Set;this.model.splice([...e,0],Number.MAX_VALUE,t,{...i,onDidCreateNode:e=>{var t;if(null===e.element)return;const r=e;if(n.add(r.element),this.nodes.set(r.element,r),this.identityProvider){const e=this.identityProvider.getId(r.element).toString();o.add(e),this.nodesByIdentity.set(e,r)}null===(t=i.onDidCreateNode)||void 0===t||t.call(i,r)},onDidDeleteNode:e=>{var t;if(null===e.element)return;const r=e;if(n.has(r.element)||this.nodes.delete(r.element),this.identityProvider){const e=this.identityProvider.getId(r.element).toString();o.has(e)||this.nodesByIdentity.delete(e)}null===(t=i.onDidDeleteNode)||void 0===t||t.call(i,r)}})}preserveCollapseState(e=r.Iterable.empty()){return this.sorter&&(e=[...e].sort(this.sorter.compare.bind(this.sorter))),r.Iterable.map(e,(e=>{let t=this.nodes.get(e.element);if(!t&&this.identityProvider){const i=this.identityProvider.getId(e.element).toString();t=this.nodesByIdentity.get(i)}if(!t){let t;return t=void 0===e.collapsed?void 0:e.collapsed===o.ObjectTreeElementCollapseState.Collapsed||e.collapsed===o.ObjectTreeElementCollapseState.PreserveOrCollapsed||e.collapsed!==o.ObjectTreeElementCollapseState.Expanded&&e.collapsed!==o.ObjectTreeElementCollapseState.PreserveOrExpanded&&Boolean(e.collapsed),{...e,children:this.preserveCollapseState(e.children),collapsed:t}}const i="boolean"==typeof e.collapsible?e.collapsible:t.collapsible;let n;return n=void 0===e.collapsed||e.collapsed===o.ObjectTreeElementCollapseState.PreserveOrCollapsed||e.collapsed===o.ObjectTreeElementCollapseState.PreserveOrExpanded?t.collapsed:e.collapsed===o.ObjectTreeElementCollapseState.Collapsed||e.collapsed!==o.ObjectTreeElementCollapseState.Expanded&&Boolean(e.collapsed),{...e,collapsible:i,collapsed:n,children:this.preserveCollapseState(e.children)}}))}rerender(e){const t=this.getElementLocation(e);this.model.rerender(t)}getFirstElementChild(e=null){const t=this.getElementLocation(e);return this.model.getFirstElementChild(t)}has(e){return this.nodes.has(e)}getListIndex(e){const t=this.getElementLocation(e);return this.model.getListIndex(t)}getListRenderCount(e){const t=this.getElementLocation(e);return this.model.getListRenderCount(t)}isCollapsible(e){const t=this.getElementLocation(e);return this.model.isCollapsible(t)}setCollapsible(e,t){const i=this.getElementLocation(e);return this.model.setCollapsible(i,t)}isCollapsed(e){const t=this.getElementLocation(e);return this.model.isCollapsed(t)}setCollapsed(e,t,i){const n=this.getElementLocation(e);return this.model.setCollapsed(n,t,i)}expandTo(e){const t=this.getElementLocation(e);this.model.expandTo(t)}refilter(){this.model.refilter()}getNode(e=null){if(null===e)return this.model.getNode(this.model.rootRef);const t=this.nodes.get(e);if(!t)throw new o.TreeError(this.user,`Tree element not found: ${e}`);return t}getNodeLocation(e){return e.element}getParentNodeLocation(e){if(null===e)throw new o.TreeError(this.user,"Invalid getParentNodeLocation call");const t=this.nodes.get(e);if(!t)throw new o.TreeError(this.user,`Tree element not found: ${e}`);const i=this.model.getNodeLocation(t),n=this.model.getParentNodeLocation(i);return this.model.getNode(n).element}getElementLocation(e){if(null===e)return[];const t=this.nodes.get(e);if(!t)throw new o.TreeError(this.user,`Tree element not found: ${e}`);return this.model.getNodeLocation(t)}}},23877:function(e,t,i){"use strict";var n,o;i.r(t),i.d(t,{ObjectTreeElementCollapseState:function(){return n},TreeError:function(){return r},TreeMouseEventTarget:function(){return o},WeakMapper:function(){return s}}),function(e){e[e.Expanded=0]="Expanded",e[e.Collapsed=1]="Collapsed",e[e.PreserveOrExpanded=2]="PreserveOrExpanded",e[e.PreserveOrCollapsed=3]="PreserveOrCollapsed"}(n||(n={})),function(e){e[e.Unknown=0]="Unknown",e[e.Twistie=1]="Twistie",e[e.Element=2]="Element",e[e.Filter=3]="Filter"}(o||(o={}));class r extends Error{constructor(e,t){super(`TreeError [${e}] ${t}`)}}class s{constructor(e){this.fn=e,this._map=new WeakMap}map(e){let t=this._map.get(e);return t||(t=this.fn(e),this._map.set(e,t)),t}}},47257:function(e,t,i){"use strict";i.r(t),i.d(t,{Widget:function(){return l}});var n=i(96747),o=i(8769),r=i(5642),s=i(4043),a=i(68921);class l extends a.Disposable{onclick(e,t){this._register(n.addDisposableListener(e,n.EventType.CLICK,(i=>t(new r.StandardMouseEvent(n.getWindow(e),i)))))}onmousedown(e,t){this._register(n.addDisposableListener(e,n.EventType.MOUSE_DOWN,(i=>t(new r.StandardMouseEvent(n.getWindow(e),i)))))}onmouseover(e,t){this._register(n.addDisposableListener(e,n.EventType.MOUSE_OVER,(i=>t(new r.StandardMouseEvent(n.getWindow(e),i)))))}onmouseleave(e,t){this._register(n.addDisposableListener(e,n.EventType.MOUSE_LEAVE,(i=>t(new r.StandardMouseEvent(n.getWindow(e),i)))))}onkeydown(e,t){this._register(n.addDisposableListener(e,n.EventType.KEY_DOWN,(e=>t(new o.StandardKeyboardEvent(e)))))}onkeyup(e,t){this._register(n.addDisposableListener(e,n.EventType.KEY_UP,(e=>t(new o.StandardKeyboardEvent(e)))))}oninput(e,t){this._register(n.addDisposableListener(e,n.EventType.INPUT,t))}onblur(e,t){this._register(n.addDisposableListener(e,n.EventType.BLUR,t))}onfocus(e,t){this._register(n.addDisposableListener(e,n.EventType.FOCUS,t))}ignoreGesture(e){return s.Gesture.ignoreTarget(e)}}},99817:function(e,t,i){"use strict";function n(e,t){const i=e;"number"!=typeof i.vscodeWindowId&&Object.defineProperty(i,"vscodeWindowId",{get:()=>t})}i.r(t),i.d(t,{$window:function(){return r},ensureCodeWindow:function(){return n},mainWindow:function(){return o}});const o=window,r=o},60969:function(e,t,i){"use strict";i.r(t),i.d(t,{Action:function(){return s},ActionRunner:function(){return a},EmptySubmenuAction:function(){return d},Separator:function(){return l},SubmenuAction:function(){return c},toAction:function(){return u}});var n=i(63801),o=i(68921),r=i(83787);class s extends o.Disposable{constructor(e,t="",i="",o=!0,r){super(),this._onDidChange=this._register(new n.Emitter),this.onDidChange=this._onDidChange.event,this._enabled=!0,this._id=e,this._label=t,this._cssClass=i,this._enabled=o,this._actionCallback=r}get id(){return this._id}get label(){return this._label}set label(e){this._setLabel(e)}_setLabel(e){this._label!==e&&(this._label=e,this._onDidChange.fire({label:e}))}get tooltip(){return this._tooltip||""}set tooltip(e){this._setTooltip(e)}_setTooltip(e){this._tooltip!==e&&(this._tooltip=e,this._onDidChange.fire({tooltip:e}))}get class(){return this._cssClass}set class(e){this._setClass(e)}_setClass(e){this._cssClass!==e&&(this._cssClass=e,this._onDidChange.fire({class:e}))}get enabled(){return this._enabled}set enabled(e){this._setEnabled(e)}_setEnabled(e){this._enabled!==e&&(this._enabled=e,this._onDidChange.fire({enabled:e}))}get checked(){return this._checked}set checked(e){this._setChecked(e)}_setChecked(e){this._checked!==e&&(this._checked=e,this._onDidChange.fire({checked:e}))}async run(e,t){this._actionCallback&&await this._actionCallback(e)}}class a extends o.Disposable{constructor(){super(...arguments),this._onWillRun=this._register(new n.Emitter),this.onWillRun=this._onWillRun.event,this._onDidRun=this._register(new n.Emitter),this.onDidRun=this._onDidRun.event}async run(e,t){if(!e.enabled)return;let i;this._onWillRun.fire({action:e});try{await this.runAction(e,t)}catch(e){i=e}this._onDidRun.fire({action:e,error:i})}async runAction(e,t){await e.run(t)}}class l{constructor(){this.id=l.ID,this.label="",this.tooltip="",this.class="separator",this.enabled=!1,this.checked=!1}static join(...e){let t=[];for(const i of e)i.length&&(t=t.length?[...t,new l,...i]:i);return t}async run(){}}l.ID="vs.actions.separator";class c{get actions(){return this._actions}constructor(e,t,i,n){this.tooltip="",this.enabled=!0,this.checked=void 0,this.id=e,this.label=t,this.class=n,this._actions=i}async run(){}}class d extends s{constructor(){super(d.ID,r.localize("vs/base/common/actions","submenu.empty","(empty)"),void 0,!1)}}function u(e){var t,i;return{id:e.id,label:e.label,class:e.class,enabled:null===(t=e.enabled)||void 0===t||t,checked:null!==(i=e.checked)&&void 0!==i&&i,run:async(...t)=>e.run(...t),tooltip:e.label}}d.ID="vs.actions.empty"},64998:function(e,t,i){"use strict";function n(e,t=0){return e[e.length-(1+t)]}function o(e){if(0===e.length)throw new Error("Invalid tail call");return[e.slice(0,e.length-1),e[e.length-1]]}function r(e,t,i=((e,t)=>e===t)){if(e===t)return!0;if(!e||!t)return!1;if(e.length!==t.length)return!1;for(let n=0,o=e.length;n<o;n++)if(!i(e[n],t[n]))return!1;return!0}function s(e,t){const i=e.length-1;t<i&&(e[t]=e[i]),e.pop()}function a(e,t,i){return l(e.length,(n=>i(e[n],t)))}function l(e,t){let i=0,n=e-1;for(;i<=n;){const e=(i+n)/2|0,o=t(e);if(o<0)i=e+1;else{if(!(o>0))return e;n=e-1}}return-(i+1)}function c(e,t,i){if((e|=0)>=t.length)throw new TypeError("invalid index");const n=t[Math.floor(t.length*Math.random())],o=[],r=[],s=[];for(const e of t){const t=i(e,n);t<0?o.push(e):t>0?r.push(e):s.push(e)}return e<o.length?c(e,o,i):e<o.length+s.length?s[0]:c(e-(o.length+s.length),r,i)}function d(e,t){const i=[];let n;for(const o of e.slice(0).sort(t))n&&0===t(n[0],o)?n.push(o):(n=[o],i.push(n));return i}function*u(e,t){let i,n;for(const o of e)void 0!==n&&t(n,o)?i.push(o):(i&&(yield i),i=[o]),n=o;i&&(yield i)}function h(e,t){for(let i=0;i<=e.length;i++)t(0===i?void 0:e[i-1],i===e.length?void 0:e[i])}function g(e,t){for(let i=0;i<e.length;i++)t(0===i?void 0:e[i-1],e[i],i+1===e.length?void 0:e[i+1])}function p(e){return e.filter((e=>!!e))}function m(e){let t=0;for(let i=0;i<e.length;i++)e[i]&&(e[t]=e[i],t+=1);e.length=t}function f(e){return!Array.isArray(e)||0===e.length}function b(e){return Array.isArray(e)&&e.length>0}function v(e,t=(e=>e)){const i=new Set;return e.filter((e=>{const n=t(e);return!i.has(n)&&(i.add(n),!0)}))}function _(e,t){return e.length>0?e[0]:t}function A(e,t){let i="number"==typeof t?e:0;"number"==typeof t?i=e:(i=0,t=e);const n=[];if(i<=t)for(let e=i;e<t;e++)n.push(e);else for(let e=i;e>t;e--)n.push(e);return n}function C(e,t,i){const n=e.slice(0,t),o=e.slice(t);return n.concat(i,o)}function w(e,t){const i=e.indexOf(t);i>-1&&(e.splice(i,1),e.unshift(t))}function y(e,t){const i=e.indexOf(t);i>-1&&(e.splice(i,1),e.push(t))}function S(e,t){for(const i of t)e.push(i)}function x(e){return Array.isArray(e)?e:[e]}function E(e,t,i){const n=D(e,t),o=e.length,r=i.length;e.length=o+r;for(let t=o-1;t>=n;t--)e[t+r]=e[t];for(let t=0;t<r;t++)e[t+n]=i[t]}function k(e,t,i,n){const o=D(e,t);let r=e.splice(o,i);return void 0===r&&(r=[]),E(e,o,n),r}function D(e,t){return t<0?Math.max(t+e.length,0):Math.min(t,e.length)}var I;function L(e,t){return(i,n)=>t(e(i),e(n))}function T(...e){return(t,i)=>{for(const n of e){const e=n(t,i);if(!I.isNeitherLessOrGreaterThan(e))return e}return I.neitherLessOrGreaterThan}}i.r(t),i.d(t,{ArrayQueue:function(){return B},CallbackIterable:function(){return O},CompareResult:function(){return I},arrayInsert:function(){return C},asArray:function(){return x},binarySearch:function(){return a},binarySearch2:function(){return l},booleanComparator:function(){return N},coalesce:function(){return p},coalesceInPlace:function(){return m},compareBy:function(){return L},distinct:function(){return v},equals:function(){return r},firstOrDefault:function(){return _},forEachAdjacent:function(){return h},forEachWithNeighbors:function(){return g},groupAdjacentBy:function(){return u},groupBy:function(){return d},insertInto:function(){return E},isFalsyOrEmpty:function(){return f},isNonEmptyArray:function(){return b},numberComparator:function(){return M},pushMany:function(){return S},pushToEnd:function(){return y},pushToStart:function(){return w},quickSelect:function(){return c},range:function(){return A},removeFastWithoutKeepingOrder:function(){return s},reverseOrder:function(){return R},splice:function(){return k},tail:function(){return n},tail2:function(){return o},tieBreakComparators:function(){return T}}),function(e){e.isLessThan=function(e){return e<0},e.isLessThanOrEqual=function(e){return e<=0},e.isGreaterThan=function(e){return e>0},e.isNeitherLessOrGreaterThan=function(e){return 0===e},e.greaterThan=1,e.lessThan=-1,e.neitherLessOrGreaterThan=0}(I||(I={}));const M=(e,t)=>e-t,N=(e,t)=>M(e?1:0,t?1:0);function R(e){return(t,i)=>-e(t,i)}class B{constructor(e){this.items=e,this.firstIdx=0,this.lastIdx=this.items.length-1}get length(){return this.lastIdx-this.firstIdx+1}takeWhile(e){let t=this.firstIdx;for(;t<this.items.length&&e(this.items[t]);)t++;const i=t===this.firstIdx?null:this.items.slice(this.firstIdx,t);return this.firstIdx=t,i}takeFromEndWhile(e){let t=this.lastIdx;for(;t>=0&&e(this.items[t]);)t--;const i=t===this.lastIdx?null:this.items.slice(t+1,this.lastIdx+1);return this.lastIdx=t,i}peek(){if(0!==this.length)return this.items[this.firstIdx]}dequeue(){const e=this.items[this.firstIdx];return this.firstIdx++,e}takeCount(e){const t=this.items.slice(this.firstIdx,this.firstIdx+e);return this.firstIdx+=e,t}}class O{constructor(e){this.iterate=e}toArray(){const e=[];return this.iterate((t=>(e.push(t),!0))),e}filter(e){return new O((t=>this.iterate((i=>!e(i)||t(i)))))}map(e){return new O((t=>this.iterate((i=>t(e(i))))))}findLast(e){let t;return this.iterate((i=>(e(i)&&(t=i),!0))),t}findLastMaxBy(e){let t,i=!0;return this.iterate((n=>((i||I.isGreaterThan(e(n,t)))&&(i=!1,t=n),!0))),t}}O.empty=new O((e=>{}))},6977:function(e,t,i){"use strict";function n(e,t,i){const n=o(e,t);if(-1!==n)return e[n]}function o(e,t,i=e.length-1){for(let n=i;n>=0;n--){if(t(e[n]))return n}return-1}function r(e,t){const i=s(e,t);return-1===i?void 0:e[i]}function s(e,t,i=0,n=e.length){let o=i,r=n;for(;o<r;){const i=Math.floor((o+r)/2);t(e[i])?o=i+1:r=i}return o-1}function a(e,t){const i=l(e,t);return i===e.length?void 0:e[i]}function l(e,t,i=0,n=e.length){let o=i,r=n;for(;o<r;){const i=Math.floor((o+r)/2);t(e[i])?r=i:o=i+1}return o}i.r(t),i.d(t,{MonotonousArray:function(){return c},findFirstIdxMonotonousOrArrLen:function(){return l},findFirstMaxBy:function(){return d},findFirstMinBy:function(){return h},findFirstMonotonous:function(){return a},findLast:function(){return n},findLastIdx:function(){return o},findLastIdxMonotonous:function(){return s},findLastMaxBy:function(){return u},findLastMonotonous:function(){return r},findMaxIdxBy:function(){return g},mapFindFirst:function(){return p}});class c{constructor(e){this._array=e,this._findLastMonotonousLastIdx=0}findLastMonotonous(e){if(c.assertInvariants){if(this._prevFindLastPredicate)for(const t of this._array)if(this._prevFindLastPredicate(t)&&!e(t))throw new Error("MonotonousArray: current predicate must be weaker than (or equal to) the previous predicate.");this._prevFindLastPredicate=e}const t=s(this._array,e,this._findLastMonotonousLastIdx);return this._findLastMonotonousLastIdx=t+1,-1===t?void 0:this._array[t]}}function d(e,t){if(0===e.length)return;let i=e[0];for(let n=1;n<e.length;n++){const o=e[n];t(o,i)>0&&(i=o)}return i}function u(e,t){if(0===e.length)return;let i=e[0];for(let n=1;n<e.length;n++){const o=e[n];t(o,i)>=0&&(i=o)}return i}function h(e,t){return d(e,((e,i)=>-t(e,i)))}function g(e,t){if(0===e.length)return-1;let i=0;for(let n=1;n<e.length;n++){t(e[n],e[i])>0&&(i=n)}return i}function p(e,t){for(const i of e){const e=t(i);if(void 0!==e)return e}}c.assertInvariants=!1},86995:function(e,t,i){"use strict";i.r(t),i.d(t,{assertFn:function(){return s},assertNever:function(){return r},checkAdjacentItems:function(){return a},ok:function(){return o}});var n=i(12718);function o(e,t){if(!e)throw new Error(t?`Assertion failed (${t})`:"Assertion Failed")}function r(e,t="Unreachable"){throw new Error(t)}function s(e){e()||(e(),(0,n.onUnexpectedError)(new n.BugIndicatingError("Assertion Failed")))}function a(e,t){let i=0;for(;i<e.length-1;){if(!t(e[i],e[i+1]))return!1;i++}return!0}},66129:function(e,t,i){"use strict";i.r(t),i.d(t,{AbstractIdleValue:function(){return y},AsyncIterableObject:function(){return k},CancelableAsyncIterableObject:function(){return D},DeferredPromise:function(){return x},Delayer:function(){return g},GlobalIdleValue:function(){return S},IntervalTimer:function(){return _},Promises:function(){return E},RunOnceScheduler:function(){return A},ThrottledDelayer:function(){return p},Throttler:function(){return h},TimeoutTimer:function(){return v},_runWhenIdle:function(){return w},createCancelableAsyncIterable:function(){return I},createCancelablePromise:function(){return d},disposableTimeout:function(){return f},first:function(){return b},isThenable:function(){return c},raceCancellation:function(){return u},runWhenGlobalIdle:function(){return C},timeout:function(){return m}});var n=i(11256),o=i(12718),r=i(63801),s=i(68921),a=i(66719),l=i(68945);function c(e){return!!e&&"function"==typeof e.then}function d(e){const t=new n.CancellationTokenSource,i=e(t.token),r=new Promise(((e,n)=>{const r=t.token.onCancellationRequested((()=>{r.dispose(),t.dispose(),n(new o.CancellationError)}));Promise.resolve(i).then((i=>{r.dispose(),t.dispose(),e(i)}),(e=>{r.dispose(),t.dispose(),n(e)}))}));return new class{cancel(){t.cancel()}then(e,t){return r.then(e,t)}catch(e){return this.then(void 0,e)}finally(e){return r.finally(e)}}}function u(e,t,i){return new Promise(((n,o)=>{const r=t.onCancellationRequested((()=>{r.dispose(),n(i)}));e.then(n,o).finally((()=>r.dispose()))}))}class h{constructor(){this.isDisposed=!1,this.activePromise=null,this.queuedPromise=null,this.queuedPromiseFactory=null}queue(e){if(this.isDisposed)return Promise.reject(new Error("Throttler is disposed"));if(this.activePromise){if(this.queuedPromiseFactory=e,!this.queuedPromise){const e=()=>{if(this.queuedPromise=null,this.isDisposed)return;const e=this.queue(this.queuedPromiseFactory);return this.queuedPromiseFactory=null,e};this.queuedPromise=new Promise((t=>{this.activePromise.then(e,e).then(t)}))}return new Promise(((e,t)=>{this.queuedPromise.then(e,t)}))}return this.activePromise=e(),new Promise(((e,t)=>{this.activePromise.then((t=>{this.activePromise=null,e(t)}),(e=>{this.activePromise=null,t(e)}))}))}dispose(){this.isDisposed=!0}}class g{constructor(e){this.defaultDelay=e,this.deferred=null,this.completionPromise=null,this.doResolve=null,this.doReject=null,this.task=null}trigger(e,t=this.defaultDelay){this.task=e,this.cancelTimeout(),this.completionPromise||(this.completionPromise=new Promise(((e,t)=>{this.doResolve=e,this.doReject=t})).then((()=>{if(this.completionPromise=null,this.doResolve=null,this.task){const e=this.task;return this.task=null,e()}})));const i=()=>{var e;this.deferred=null,null===(e=this.doResolve)||void 0===e||e.call(this,null)};return this.deferred=t===l.MicrotaskDelay?(e=>{let t=!0;return queueMicrotask((()=>{t&&(t=!1,e())})),{isTriggered:()=>t,dispose:()=>{t=!1}}})(i):((e,t)=>{let i=!0;const n=setTimeout((()=>{i=!1,t()}),e);return{isTriggered:()=>i,dispose:()=>{clearTimeout(n),i=!1}}})(t,i),this.completionPromise}isTriggered(){var e;return!!(null===(e=this.deferred)||void 0===e?void 0:e.isTriggered())}cancel(){var e;this.cancelTimeout(),this.completionPromise&&(null===(e=this.doReject)||void 0===e||e.call(this,new o.CancellationError),this.completionPromise=null)}cancelTimeout(){var e;null===(e=this.deferred)||void 0===e||e.dispose(),this.deferred=null}dispose(){this.cancel()}}class p{constructor(e){this.delayer=new g(e),this.throttler=new h}trigger(e,t){return this.delayer.trigger((()=>this.throttler.queue(e)),t)}cancel(){this.delayer.cancel()}dispose(){this.delayer.dispose(),this.throttler.dispose()}}function m(e,t){return t?new Promise(((i,n)=>{const r=setTimeout((()=>{s.dispose(),i()}),e),s=t.onCancellationRequested((()=>{clearTimeout(r),s.dispose(),n(new o.CancellationError)}))})):d((t=>m(e,t)))}function f(e,t=0,i){const n=setTimeout((()=>{e(),i&&o.dispose()}),t),o=(0,s.toDisposable)((()=>{clearTimeout(n),null==i||i.deleteAndLeak(o)}));return null==i||i.add(o),o}function b(e,t=(e=>!!e),i=null){let n=0;const o=e.length,r=()=>{if(n>=o)return Promise.resolve(i);const s=e[n++];return Promise.resolve(s()).then((e=>t(e)?Promise.resolve(e):r()))};return r()}class v{constructor(e,t){this._token=-1,"function"==typeof e&&"number"==typeof t&&this.setIfNotSet(e,t)}dispose(){this.cancel()}cancel(){-1!==this._token&&(clearTimeout(this._token),this._token=-1)}cancelAndSet(e,t){this.cancel(),this._token=setTimeout((()=>{this._token=-1,e()}),t)}setIfNotSet(e,t){-1===this._token&&(this._token=setTimeout((()=>{this._token=-1,e()}),t))}}class _{constructor(){this.disposable=void 0}cancel(){var e;null===(e=this.disposable)||void 0===e||e.dispose(),this.disposable=void 0}cancelAndSet(e,t,i=globalThis){this.cancel();const n=i.setInterval((()=>{e()}),t);this.disposable=(0,s.toDisposable)((()=>{i.clearInterval(n),this.disposable=void 0}))}dispose(){this.cancel()}}class A{constructor(e,t){this.timeoutToken=-1,this.runner=e,this.timeout=t,this.timeoutHandler=this.onTimeout.bind(this)}dispose(){this.cancel(),this.runner=null}cancel(){this.isScheduled()&&(clearTimeout(this.timeoutToken),this.timeoutToken=-1)}schedule(e=this.timeout){this.cancel(),this.timeoutToken=setTimeout(this.timeoutHandler,e)}get delay(){return this.timeout}set delay(e){this.timeout=e}isScheduled(){return-1!==this.timeoutToken}onTimeout(){this.timeoutToken=-1,this.runner&&this.doRun()}doRun(){var e;null===(e=this.runner)||void 0===e||e.call(this)}}let C,w;w="function"!=typeof globalThis.requestIdleCallback||"function"!=typeof globalThis.cancelIdleCallback?(e,t)=>{(0,a.setTimeout0)((()=>{if(i)return;const e=Date.now()+15,n={didTimeout:!0,timeRemaining(){return Math.max(0,e-Date.now())}};t(Object.freeze(n))}));let i=!1;return{dispose(){i||(i=!0)}}}:(e,t,i)=>{const n=e.requestIdleCallback(t,"number"==typeof i?{timeout:i}:void 0);let o=!1;return{dispose(){o||(o=!0,e.cancelIdleCallback(n))}}},C=e=>w(globalThis,e);class y{constructor(e,t){this._didRun=!1,this._executor=()=>{try{this._value=t()}catch(e){this._error=e}finally{this._didRun=!0}},this._handle=w(e,(()=>this._executor()))}dispose(){this._handle.dispose()}get value(){if(this._didRun||(this._handle.dispose(),this._executor()),this._error)throw this._error;return this._value}get isInitialized(){return this._didRun}}class S extends y{constructor(e){super(globalThis,e)}}class x{get isRejected(){var e;return 1===(null===(e=this.outcome)||void 0===e?void 0:e.outcome)}get isSettled(){return!!this.outcome}constructor(){this.p=new Promise(((e,t)=>{this.completeCallback=e,this.errorCallback=t}))}complete(e){return new Promise((t=>{this.completeCallback(e),this.outcome={outcome:0,value:e},t()}))}error(e){return new Promise((t=>{this.errorCallback(e),this.outcome={outcome:1,value:e},t()}))}cancel(){return this.error(new o.CancellationError)}}var E;!function(e){e.settled=async function(e){let t;const i=await Promise.all(e.map((e=>e.then((e=>e),(e=>{t||(t=e)})))));if(void 0!==t)throw t;return i},e.withAsyncBody=function(e){return new Promise((async(t,i)=>{try{await e(t,i)}catch(e){i(e)}}))}}(E||(E={}));class k{static fromArray(e){return new k((t=>{t.emitMany(e)}))}static fromPromise(e){return new k((async t=>{t.emitMany(await e)}))}static fromPromises(e){return new k((async t=>{await Promise.all(e.map((async e=>t.emitOne(await e))))}))}static merge(e){return new k((async t=>{await Promise.all(e.map((async e=>{for await(const i of e)t.emitOne(i)})))}))}constructor(e){this._state=0,this._results=[],this._error=null,this._onStateChanged=new r.Emitter,queueMicrotask((async()=>{const t={emitOne:e=>this.emitOne(e),emitMany:e=>this.emitMany(e),reject:e=>this.reject(e)};try{await Promise.resolve(e(t)),this.resolve()}catch(e){this.reject(e)}finally{t.emitOne=void 0,t.emitMany=void 0,t.reject=void 0}}))}[Symbol.asyncIterator](){let e=0;return{next:async()=>{for(;;){if(2===this._state)throw this._error;if(e<this._results.length)return{done:!1,value:this._results[e++]};if(1===this._state)return{done:!0,value:void 0};await r.Event.toPromise(this._onStateChanged.event)}}}}static map(e,t){return new k((async i=>{for await(const n of e)i.emitOne(t(n))}))}map(e){return k.map(this,e)}static filter(e,t){return new k((async i=>{for await(const n of e)t(n)&&i.emitOne(n)}))}filter(e){return k.filter(this,e)}static coalesce(e){return k.filter(e,(e=>!!e))}coalesce(){return k.coalesce(this)}static async toPromise(e){const t=[];for await(const i of e)t.push(i);return t}toPromise(){return k.toPromise(this)}emitOne(e){0===this._state&&(this._results.push(e),this._onStateChanged.fire())}emitMany(e){0===this._state&&(this._results=this._results.concat(e),this._onStateChanged.fire())}resolve(){0===this._state&&(this._state=1,this._onStateChanged.fire())}reject(e){0===this._state&&(this._state=2,this._error=e,this._onStateChanged.fire())}}k.EMPTY=k.fromArray([]);class D extends k{constructor(e,t){super(t),this._source=e}cancel(){this._source.cancel()}}function I(e){const t=new n.CancellationTokenSource,i=e(t.token);return new D(t,(async e=>{const n=t.token.onCancellationRequested((()=>{n.dispose(),t.dispose(),e.reject(new o.CancellationError)}));try{for await(const n of i){if(t.token.isCancellationRequested)return;e.emitOne(n)}n.dispose(),t.dispose()}catch(i){n.dispose(),t.dispose(),e.reject(i)}}))}},44913:function(e,t,i){"use strict";i.r(t),i.d(t,{VSBuffer:function(){return s},readUInt16LE:function(){return a},readUInt32BE:function(){return c},readUInt8:function(){return u},writeUInt16LE:function(){return l},writeUInt32BE:function(){return d},writeUInt8:function(){return h}});var n=i(5560);const o="undefined"!=typeof Buffer;new n.Lazy((()=>new Uint8Array(256)));let r;class s{static wrap(e){return o&&!Buffer.isBuffer(e)&&(e=Buffer.from(e.buffer,e.byteOffset,e.byteLength)),new s(e)}constructor(e){this.buffer=e,this.byteLength=this.buffer.byteLength}toString(){return o?this.buffer.toString():(r||(r=new TextDecoder),r.decode(this.buffer))}}function a(e,t){return e[t+0]<<0>>>0|e[t+1]<<8>>>0}function l(e,t,i){e[i+0]=255&t,t>>>=8,e[i+1]=255&t}function c(e,t){return e[t]*2**24+65536*e[t+1]+256*e[t+2]+e[t+3]}function d(e,t,i){e[i+3]=t,t>>>=8,e[i+2]=t,t>>>=8,e[i+1]=t,t>>>=8,e[i]=t}function u(e,t){return e[t]}function h(e,t,i){e[i]=t}},12359:function(e,t,i){"use strict";i.r(t),i.d(t,{CachedFunction:function(){return o},LRUCachedFunction:function(){return n}});class n{constructor(e){this.fn=e,this.lastCache=void 0,this.lastArgKey=void 0}get(e){const t=JSON.stringify(e);return this.lastArgKey!==t&&(this.lastArgKey=t,this.lastCache=this.fn(e)),this.lastCache}}class o{get cachedValues(){return this._map}constructor(e){this.fn=e,this._map=new Map}get(e){if(this._map.has(e))return this._map.get(e);const t=this.fn(e);return this._map.set(e,t),t}}},11256:function(e,t,i){"use strict";i.r(t),i.d(t,{CancellationToken:function(){return r},CancellationTokenSource:function(){return a}});var n=i(63801);const o=Object.freeze((function(e,t){const i=setTimeout(e.bind(t),0);return{dispose(){clearTimeout(i)}}}));var r;!function(e){e.isCancellationToken=function(t){return t===e.None||t===e.Cancelled||(t instanceof s||!(!t||"object"!=typeof t)&&("boolean"==typeof t.isCancellationRequested&&"function"==typeof t.onCancellationRequested))},e.None=Object.freeze({isCancellationRequested:!1,onCancellationRequested:n.Event.None}),e.Cancelled=Object.freeze({isCancellationRequested:!0,onCancellationRequested:o})}(r||(r={}));class s{constructor(){this._isCancelled=!1,this._emitter=null}cancel(){this._isCancelled||(this._isCancelled=!0,this._emitter&&(this._emitter.fire(void 0),this.dispose()))}get isCancellationRequested(){return this._isCancelled}get onCancellationRequested(){return this._isCancelled?o:(this._emitter||(this._emitter=new n.Emitter),this._emitter.event)}dispose(){this._emitter&&(this._emitter.dispose(),this._emitter=null)}}class a{constructor(e){this._token=void 0,this._parentListener=void 0,this._parentListener=e&&e.onCancellationRequested(this.cancel,this)}get token(){return this._token||(this._token=new s),this._token}cancel(){this._token?this._token instanceof s&&this._token.cancel():this._token=r.Cancelled}dispose(e=!1){var t;e&&this.cancel(),null===(t=this._parentListener)||void 0===t||t.dispose(),this._token?this._token instanceof s&&this._token.dispose():this._token=r.None}}},56087:function(e,t,i){"use strict";i.r(t),i.d(t,{Codicon:function(){return a},getCodiconFontCharacters:function(){return s}});var n=i(18912);const o=Object.create(null);function r(e,t){if((0,n.isString)(t)){const i=o[t];if(void 0===i)throw new Error(`${e} references an unknown codicon: ${t}`);t=i}return o[e]=t,{id:e}}function s(){return o}const a={add:r("add",6e4),plus:r("plus",6e4),gistNew:r("gist-new",6e4),repoCreate:r("repo-create",6e4),lightbulb:r("lightbulb",60001),lightBulb:r("light-bulb",60001),repo:r("repo",60002),repoDelete:r("repo-delete",60002),gistFork:r("gist-fork",60003),repoForked:r("repo-forked",60003),gitPullRequest:r("git-pull-request",60004),gitPullRequestAbandoned:r("git-pull-request-abandoned",60004),recordKeys:r("record-keys",60005),keyboard:r("keyboard",60005),tag:r("tag",60006),tagAdd:r("tag-add",60006),tagRemove:r("tag-remove",60006),gitPullRequestLabel:r("git-pull-request-label",60006),person:r("person",60007),personFollow:r("person-follow",60007),personOutline:r("person-outline",60007),personFilled:r("person-filled",60007),gitBranch:r("git-branch",60008),gitBranchCreate:r("git-branch-create",60008),gitBranchDelete:r("git-branch-delete",60008),sourceControl:r("source-control",60008),mirror:r("mirror",60009),mirrorPublic:r("mirror-public",60009),star:r("star",60010),starAdd:r("star-add",60010),starDelete:r("star-delete",60010),starEmpty:r("star-empty",60010),comment:r("comment",60011),commentAdd:r("comment-add",60011),alert:r("alert",60012),warning:r("warning",60012),search:r("search",60013),searchSave:r("search-save",60013),logOut:r("log-out",60014),signOut:r("sign-out",60014),logIn:r("log-in",60015),signIn:r("sign-in",60015),eye:r("eye",60016),eyeUnwatch:r("eye-unwatch",60016),eyeWatch:r("eye-watch",60016),circleFilled:r("circle-filled",60017),primitiveDot:r("primitive-dot",60017),closeDirty:r("close-dirty",60017),debugBreakpoint:r("debug-breakpoint",60017),debugBreakpointDisabled:r("debug-breakpoint-disabled",60017),debugHint:r("debug-hint",60017),primitiveSquare:r("primitive-square",60018),edit:r("edit",60019),pencil:r("pencil",60019),info:r("info",60020),issueOpened:r("issue-opened",60020),gistPrivate:r("gist-private",60021),gitForkPrivate:r("git-fork-private",60021),lock:r("lock",60021),mirrorPrivate:r("mirror-private",60021),close:r("close",60022),removeClose:r("remove-close",60022),x:r("x",60022),repoSync:r("repo-sync",60023),sync:r("sync",60023),clone:r("clone",60024),desktopDownload:r("desktop-download",60024),beaker:r("beaker",60025),microscope:r("microscope",60025),vm:r("vm",60026),deviceDesktop:r("device-desktop",60026),file:r("file",60027),fileText:r("file-text",60027),more:r("more",60028),ellipsis:r("ellipsis",60028),kebabHorizontal:r("kebab-horizontal",60028),mailReply:r("mail-reply",60029),reply:r("reply",60029),organization:r("organization",60030),organizationFilled:r("organization-filled",60030),organizationOutline:r("organization-outline",60030),newFile:r("new-file",60031),fileAdd:r("file-add",60031),newFolder:r("new-folder",60032),fileDirectoryCreate:r("file-directory-create",60032),trash:r("trash",60033),trashcan:r("trashcan",60033),history:r("history",60034),clock:r("clock",60034),folder:r("folder",60035),fileDirectory:r("file-directory",60035),symbolFolder:r("symbol-folder",60035),logoGithub:r("logo-github",60036),markGithub:r("mark-github",60036),github:r("github",60036),terminal:r("terminal",60037),console:r("console",60037),repl:r("repl",60037),zap:r("zap",60038),symbolEvent:r("symbol-event",60038),error:r("error",60039),stop:r("stop",60039),variable:r("variable",60040),symbolVariable:r("symbol-variable",60040),array:r("array",60042),symbolArray:r("symbol-array",60042),symbolModule:r("symbol-module",60043),symbolPackage:r("symbol-package",60043),symbolNamespace:r("symbol-namespace",60043),symbolObject:r("symbol-object",60043),symbolMethod:r("symbol-method",60044),symbolFunction:r("symbol-function",60044),symbolConstructor:r("symbol-constructor",60044),symbolBoolean:r("symbol-boolean",60047),symbolNull:r("symbol-null",60047),symbolNumeric:r("symbol-numeric",60048),symbolNumber:r("symbol-number",60048),symbolStructure:r("symbol-structure",60049),symbolStruct:r("symbol-struct",60049),symbolParameter:r("symbol-parameter",60050),symbolTypeParameter:r("symbol-type-parameter",60050),symbolKey:r("symbol-key",60051),symbolText:r("symbol-text",60051),symbolReference:r("symbol-reference",60052),goToFile:r("go-to-file",60052),symbolEnum:r("symbol-enum",60053),symbolValue:r("symbol-value",60053),symbolRuler:r("symbol-ruler",60054),symbolUnit:r("symbol-unit",60054),activateBreakpoints:r("activate-breakpoints",60055),archive:r("archive",60056),arrowBoth:r("arrow-both",60057),arrowDown:r("arrow-down",60058),arrowLeft:r("arrow-left",60059),arrowRight:r("arrow-right",60060),arrowSmallDown:r("arrow-small-down",60061),arrowSmallLeft:r("arrow-small-left",60062),arrowSmallRight:r("arrow-small-right",60063),arrowSmallUp:r("arrow-small-up",60064),arrowUp:r("arrow-up",60065),bell:r("bell",60066),bold:r("bold",60067),book:r("book",60068),bookmark:r("bookmark",60069),debugBreakpointConditionalUnverified:r("debug-breakpoint-conditional-unverified",60070),debugBreakpointConditional:r("debug-breakpoint-conditional",60071),debugBreakpointConditionalDisabled:r("debug-breakpoint-conditional-disabled",60071),debugBreakpointDataUnverified:r("debug-breakpoint-data-unverified",60072),debugBreakpointData:r("debug-breakpoint-data",60073),debugBreakpointDataDisabled:r("debug-breakpoint-data-disabled",60073),debugBreakpointLogUnverified:r("debug-breakpoint-log-unverified",60074),debugBreakpointLog:r("debug-breakpoint-log",60075),debugBreakpointLogDisabled:r("debug-breakpoint-log-disabled",60075),briefcase:r("briefcase",60076),broadcast:r("broadcast",60077),browser:r("browser",60078),bug:r("bug",60079),calendar:r("calendar",60080),caseSensitive:r("case-sensitive",60081),check:r("check",60082),checklist:r("checklist",60083),chevronDown:r("chevron-down",60084),dropDownButton:r("drop-down-button",60084),chevronLeft:r("chevron-left",60085),chevronRight:r("chevron-right",60086),chevronUp:r("chevron-up",60087),chromeClose:r("chrome-close",60088),chromeMaximize:r("chrome-maximize",60089),chromeMinimize:r("chrome-minimize",60090),chromeRestore:r("chrome-restore",60091),circle:r("circle",60092),circleOutline:r("circle-outline",60092),debugBreakpointUnverified:r("debug-breakpoint-unverified",60092),circleSlash:r("circle-slash",60093),circuitBoard:r("circuit-board",60094),clearAll:r("clear-all",60095),clippy:r("clippy",60096),closeAll:r("close-all",60097),cloudDownload:r("cloud-download",60098),cloudUpload:r("cloud-upload",60099),code:r("code",60100),collapseAll:r("collapse-all",60101),colorMode:r("color-mode",60102),commentDiscussion:r("comment-discussion",60103),compareChanges:r("compare-changes",60157),creditCard:r("credit-card",60105),dash:r("dash",60108),dashboard:r("dashboard",60109),database:r("database",60110),debugContinue:r("debug-continue",60111),debugDisconnect:r("debug-disconnect",60112),debugPause:r("debug-pause",60113),debugRestart:r("debug-restart",60114),debugStart:r("debug-start",60115),debugStepInto:r("debug-step-into",60116),debugStepOut:r("debug-step-out",60117),debugStepOver:r("debug-step-over",60118),debugStop:r("debug-stop",60119),debug:r("debug",60120),deviceCameraVideo:r("device-camera-video",60121),deviceCamera:r("device-camera",60122),deviceMobile:r("device-mobile",60123),diffAdded:r("diff-added",60124),diffIgnored:r("diff-ignored",60125),diffModified:r("diff-modified",60126),diffRemoved:r("diff-removed",60127),diffRenamed:r("diff-renamed",60128),diff:r("diff",60129),discard:r("discard",60130),editorLayout:r("editor-layout",60131),emptyWindow:r("empty-window",60132),exclude:r("exclude",60133),extensions:r("extensions",60134),eyeClosed:r("eye-closed",60135),fileBinary:r("file-binary",60136),fileCode:r("file-code",60137),fileMedia:r("file-media",60138),filePdf:r("file-pdf",60139),fileSubmodule:r("file-submodule",60140),fileSymlinkDirectory:r("file-symlink-directory",60141),fileSymlinkFile:r("file-symlink-file",60142),fileZip:r("file-zip",60143),files:r("files",60144),filter:r("filter",60145),flame:r("flame",60146),foldDown:r("fold-down",60147),foldUp:r("fold-up",60148),fold:r("fold",60149),folderActive:r("folder-active",60150),folderOpened:r("folder-opened",60151),gear:r("gear",60152),gift:r("gift",60153),gistSecret:r("gist-secret",60154),gist:r("gist",60155),gitCommit:r("git-commit",60156),gitCompare:r("git-compare",60157),gitMerge:r("git-merge",60158),githubAction:r("github-action",60159),githubAlt:r("github-alt",60160),globe:r("globe",60161),grabber:r("grabber",60162),graph:r("graph",60163),gripper:r("gripper",60164),heart:r("heart",60165),home:r("home",60166),horizontalRule:r("horizontal-rule",60167),hubot:r("hubot",60168),inbox:r("inbox",60169),issueClosed:r("issue-closed",60324),issueReopened:r("issue-reopened",60171),issues:r("issues",60172),italic:r("italic",60173),jersey:r("jersey",60174),json:r("json",60175),bracket:r("bracket",60175),kebabVertical:r("kebab-vertical",60176),key:r("key",60177),law:r("law",60178),lightbulbAutofix:r("lightbulb-autofix",60179),linkExternal:r("link-external",60180),link:r("link",60181),listOrdered:r("list-ordered",60182),listUnordered:r("list-unordered",60183),liveShare:r("live-share",60184),loading:r("loading",60185),location:r("location",60186),mailRead:r("mail-read",60187),mail:r("mail",60188),markdown:r("markdown",60189),megaphone:r("megaphone",60190),mention:r("mention",60191),milestone:r("milestone",60192),gitPullRequestMilestone:r("git-pull-request-milestone",60192),mortarBoard:r("mortar-board",60193),move:r("move",60194),multipleWindows:r("multiple-windows",60195),mute:r("mute",60196),noNewline:r("no-newline",60197),note:r("note",60198),octoface:r("octoface",60199),openPreview:r("open-preview",60200),package:r("package",60201),paintcan:r("paintcan",60202),pin:r("pin",60203),play:r("play",60204),run:r("run",60204),plug:r("plug",60205),preserveCase:r("preserve-case",60206),preview:r("preview",60207),project:r("project",60208),pulse:r("pulse",60209),question:r("question",60210),quote:r("quote",60211),radioTower:r("radio-tower",60212),reactions:r("reactions",60213),references:r("references",60214),refresh:r("refresh",60215),regex:r("regex",60216),remoteExplorer:r("remote-explorer",60217),remote:r("remote",60218),remove:r("remove",60219),replaceAll:r("replace-all",60220),replace:r("replace",60221),repoClone:r("repo-clone",60222),repoForcePush:r("repo-force-push",60223),repoPull:r("repo-pull",60224),repoPush:r("repo-push",60225),report:r("report",60226),requestChanges:r("request-changes",60227),rocket:r("rocket",60228),rootFolderOpened:r("root-folder-opened",60229),rootFolder:r("root-folder",60230),rss:r("rss",60231),ruby:r("ruby",60232),saveAll:r("save-all",60233),saveAs:r("save-as",60234),save:r("save",60235),screenFull:r("screen-full",60236),screenNormal:r("screen-normal",60237),searchStop:r("search-stop",60238),server:r("server",60240),settingsGear:r("settings-gear",60241),settings:r("settings",60242),shield:r("shield",60243),smiley:r("smiley",60244),sortPrecedence:r("sort-precedence",60245),splitHorizontal:r("split-horizontal",60246),splitVertical:r("split-vertical",60247),squirrel:r("squirrel",60248),starFull:r("star-full",60249),starHalf:r("star-half",60250),symbolClass:r("symbol-class",60251),symbolColor:r("symbol-color",60252),symbolCustomColor:r("symbol-customcolor",60252),symbolConstant:r("symbol-constant",60253),symbolEnumMember:r("symbol-enum-member",60254),symbolField:r("symbol-field",60255),symbolFile:r("symbol-file",60256),symbolInterface:r("symbol-interface",60257),symbolKeyword:r("symbol-keyword",60258),symbolMisc:r("symbol-misc",60259),symbolOperator:r("symbol-operator",60260),symbolProperty:r("symbol-property",60261),wrench:r("wrench",60261),wrenchSubaction:r("wrench-subaction",60261),symbolSnippet:r("symbol-snippet",60262),tasklist:r("tasklist",60263),telescope:r("telescope",60264),textSize:r("text-size",60265),threeBars:r("three-bars",60266),thumbsdown:r("thumbsdown",60267),thumbsup:r("thumbsup",60268),tools:r("tools",60269),triangleDown:r("triangle-down",60270),triangleLeft:r("triangle-left",60271),triangleRight:r("triangle-right",60272),triangleUp:r("triangle-up",60273),twitter:r("twitter",60274),unfold:r("unfold",60275),unlock:r("unlock",60276),unmute:r("unmute",60277),unverified:r("unverified",60278),verified:r("verified",60279),versions:r("versions",60280),vmActive:r("vm-active",60281),vmOutline:r("vm-outline",60282),vmRunning:r("vm-running",60283),watch:r("watch",60284),whitespace:r("whitespace",60285),wholeWord:r("whole-word",60286),window:r("window",60287),wordWrap:r("word-wrap",60288),zoomIn:r("zoom-in",60289),zoomOut:r("zoom-out",60290),listFilter:r("list-filter",60291),listFlat:r("list-flat",60292),listSelection:r("list-selection",60293),selection:r("selection",60293),listTree:r("list-tree",60294),debugBreakpointFunctionUnverified:r("debug-breakpoint-function-unverified",60295),debugBreakpointFunction:r("debug-breakpoint-function",60296),debugBreakpointFunctionDisabled:r("debug-breakpoint-function-disabled",60296),debugStackframeActive:r("debug-stackframe-active",60297),circleSmallFilled:r("circle-small-filled",60298),debugStackframeDot:r("debug-stackframe-dot",60298),debugStackframe:r("debug-stackframe",60299),debugStackframeFocused:r("debug-stackframe-focused",60299),debugBreakpointUnsupported:r("debug-breakpoint-unsupported",60300),symbolString:r("symbol-string",60301),debugReverseContinue:r("debug-reverse-continue",60302),debugStepBack:r("debug-step-back",60303),debugRestartFrame:r("debug-restart-frame",60304),callIncoming:r("call-incoming",60306),callOutgoing:r("call-outgoing",60307),menu:r("menu",60308),expandAll:r("expand-all",60309),feedback:r("feedback",60310),gitPullRequestReviewer:r("git-pull-request-reviewer",60310),groupByRefType:r("group-by-ref-type",60311),ungroupByRefType:r("ungroup-by-ref-type",60312),account:r("account",60313),gitPullRequestAssignee:r("git-pull-request-assignee",60313),bellDot:r("bell-dot",60314),debugConsole:r("debug-console",60315),library:r("library",60316),output:r("output",60317),runAll:r("run-all",60318),syncIgnored:r("sync-ignored",60319),pinned:r("pinned",60320),githubInverted:r("github-inverted",60321),debugAlt:r("debug-alt",60305),serverProcess:r("server-process",60322),serverEnvironment:r("server-environment",60323),pass:r("pass",60324),stopCircle:r("stop-circle",60325),playCircle:r("play-circle",60326),record:r("record",60327),debugAltSmall:r("debug-alt-small",60328),vmConnect:r("vm-connect",60329),cloud:r("cloud",60330),merge:r("merge",60331),exportIcon:r("export",60332),graphLeft:r("graph-left",60333),magnet:r("magnet",60334),notebook:r("notebook",60335),redo:r("redo",60336),checkAll:r("check-all",60337),pinnedDirty:r("pinned-dirty",60338),passFilled:r("pass-filled",60339),circleLargeFilled:r("circle-large-filled",60340),circleLarge:r("circle-large",60341),circleLargeOutline:r("circle-large-outline",60341),combine:r("combine",60342),gather:r("gather",60342),table:r("table",60343),variableGroup:r("variable-group",60344),typeHierarchy:r("type-hierarchy",60345),typeHierarchySub:r("type-hierarchy-sub",60346),typeHierarchySuper:r("type-hierarchy-super",60347),gitPullRequestCreate:r("git-pull-request-create",60348),runAbove:r("run-above",60349),runBelow:r("run-below",60350),notebookTemplate:r("notebook-template",60351),debugRerun:r("debug-rerun",60352),workspaceTrusted:r("workspace-trusted",60353),workspaceUntrusted:r("workspace-untrusted",60354),workspaceUnspecified:r("workspace-unspecified",60355),terminalCmd:r("terminal-cmd",60356),terminalDebian:r("terminal-debian",60357),terminalLinux:r("terminal-linux",60358),terminalPowershell:r("terminal-powershell",60359),terminalTmux:r("terminal-tmux",60360),terminalUbuntu:r("terminal-ubuntu",60361),terminalBash:r("terminal-bash",60362),arrowSwap:r("arrow-swap",60363),copy:r("copy",60364),personAdd:r("person-add",60365),filterFilled:r("filter-filled",60366),wand:r("wand",60367),debugLineByLine:r("debug-line-by-line",60368),inspect:r("inspect",60369),layers:r("layers",60370),layersDot:r("layers-dot",60371),layersActive:r("layers-active",60372),compass:r("compass",60373),compassDot:r("compass-dot",60374),compassActive:r("compass-active",60375),azure:r("azure",60376),issueDraft:r("issue-draft",60377),gitPullRequestClosed:r("git-pull-request-closed",60378),gitPullRequestDraft:r("git-pull-request-draft",60379),debugAll:r("debug-all",60380),debugCoverage:r("debug-coverage",60381),runErrors:r("run-errors",60382),folderLibrary:r("folder-library",60383),debugContinueSmall:r("debug-continue-small",60384),beakerStop:r("beaker-stop",60385),graphLine:r("graph-line",60386),graphScatter:r("graph-scatter",60387),pieChart:r("pie-chart",60388),bracketDot:r("bracket-dot",60389),bracketError:r("bracket-error",60390),lockSmall:r("lock-small",60391),azureDevops:r("azure-devops",60392),verifiedFilled:r("verified-filled",60393),newLine:r("newline",60394),layout:r("layout",60395),layoutActivitybarLeft:r("layout-activitybar-left",60396),layoutActivitybarRight:r("layout-activitybar-right",60397),layoutPanelLeft:r("layout-panel-left",60398),layoutPanelCenter:r("layout-panel-center",60399),layoutPanelJustify:r("layout-panel-justify",60400),layoutPanelRight:r("layout-panel-right",60401),layoutPanel:r("layout-panel",60402),layoutSidebarLeft:r("layout-sidebar-left",60403),layoutSidebarRight:r("layout-sidebar-right",60404),layoutStatusbar:r("layout-statusbar",60405),layoutMenubar:r("layout-menubar",60406),layoutCentered:r("layout-centered",60407),layoutSidebarRightOff:r("layout-sidebar-right-off",60416),layoutPanelOff:r("layout-panel-off",60417),layoutSidebarLeftOff:r("layout-sidebar-left-off",60418),target:r("target",60408),indent:r("indent",60409),recordSmall:r("record-small",60410),errorSmall:r("error-small",60411),arrowCircleDown:r("arrow-circle-down",60412),arrowCircleLeft:r("arrow-circle-left",60413),arrowCircleRight:r("arrow-circle-right",60414),arrowCircleUp:r("arrow-circle-up",60415),heartFilled:r("heart-filled",60420),map:r("map",60421),mapFilled:r("map-filled",60422),circleSmall:r("circle-small",60423),bellSlash:r("bell-slash",60424),bellSlashDot:r("bell-slash-dot",60425),commentUnresolved:r("comment-unresolved",60426),gitPullRequestGoToChanges:r("git-pull-request-go-to-changes",60427),gitPullRequestNewChanges:r("git-pull-request-new-changes",60428),searchFuzzy:r("search-fuzzy",60429),commentDraft:r("comment-draft",60430),send:r("send",60431),sparkle:r("sparkle",60432),insert:r("insert",60433),mic:r("mic",60434),thumbsDownFilled:r("thumbsdown-filled",60435),thumbsUpFilled:r("thumbsup-filled",60436),coffee:r("coffee",60437),snake:r("snake",60438),game:r("game",60439),vr:r("vr",60440),chip:r("chip",60441),piano:r("piano",60442),music:r("music",60443),micFilled:r("mic-filled",60444),gitFetch:r("git-fetch",60445),copilot:r("copilot",60446),lightbulbSparkle:r("lightbulb-sparkle",60447),lightbulbSparkleAutofix:r("lightbulb-sparkle-autofix",60447),robot:r("robot",60448),sparkleFilled:r("sparkle-filled",60449),diffSingle:r("diff-single",60450),diffMultiple:r("diff-multiple",60451),dialogError:r("dialog-error","error"),dialogWarning:r("dialog-warning","warning"),dialogInfo:r("dialog-info","info"),dialogClose:r("dialog-close","close"),treeItemExpanded:r("tree-item-expanded","chevron-down"),treeFilterOnTypeOn:r("tree-filter-on-type-on","list-filter"),treeFilterOnTypeOff:r("tree-filter-on-type-off","list-selection"),treeFilterClear:r("tree-filter-clear","close"),treeItemLoading:r("tree-item-loading","loading"),menuSelection:r("menu-selection","check"),menuSubmenu:r("menu-submenu","chevron-right"),menuBarMore:r("menubar-more","more"),scrollbarButtonLeft:r("scrollbar-button-left","triangle-left"),scrollbarButtonRight:r("scrollbar-button-right","triangle-right"),scrollbarButtonUp:r("scrollbar-button-up","triangle-up"),scrollbarButtonDown:r("scrollbar-button-down","triangle-down"),toolBarMore:r("toolbar-more","more"),quickInputBack:r("quick-input-back","arrow-left")}},64280:function(e,t,i){"use strict";function n(e,t){const i=[],n=[];for(const n of e)t.has(n)||i.push(n);for(const i of t)e.has(i)||n.push(i);return{removed:i,added:n}}function o(e,t){const i=new Set;for(const n of t)e.has(n)&&i.add(n);return i}i.r(t),i.d(t,{diffSets:function(){return n},intersection:function(){return o}})},17160:function(e,t,i){"use strict";function n(e,t){const i=Math.pow(10,t);return Math.round(e*i)/i}i.r(t),i.d(t,{Color:function(){return a},HSLA:function(){return r},HSVA:function(){return s},RGBA:function(){return o}});class o{constructor(e,t,i,o=1){this._rgbaBrand=void 0,this.r=0|Math.min(255,Math.max(0,e)),this.g=0|Math.min(255,Math.max(0,t)),this.b=0|Math.min(255,Math.max(0,i)),this.a=n(Math.max(Math.min(1,o),0),3)}static equals(e,t){return e.r===t.r&&e.g===t.g&&e.b===t.b&&e.a===t.a}}class r{constructor(e,t,i,o){this._hslaBrand=void 0,this.h=0|Math.max(Math.min(360,e),0),this.s=n(Math.max(Math.min(1,t),0),3),this.l=n(Math.max(Math.min(1,i),0),3),this.a=n(Math.max(Math.min(1,o),0),3)}static equals(e,t){return e.h===t.h&&e.s===t.s&&e.l===t.l&&e.a===t.a}static fromRGBA(e){const t=e.r/255,i=e.g/255,n=e.b/255,o=e.a,s=Math.max(t,i,n),a=Math.min(t,i,n);let l=0,c=0;const d=(a+s)/2,u=s-a;if(u>0){switch(c=Math.min(d<=.5?u/(2*d):u/(2-2*d),1),s){case t:l=(i-n)/u+(i<n?6:0);break;case i:l=(n-t)/u+2;break;case n:l=(t-i)/u+4}l*=60,l=Math.round(l)}return new r(l,c,d,o)}static _hue2rgb(e,t,i){return i<0&&(i+=1),i>1&&(i-=1),i<1/6?e+6*(t-e)*i:i<.5?t:i<2/3?e+(t-e)*(2/3-i)*6:e}static toRGBA(e){const t=e.h/360,{s:i,l:n,a:s}=e;let a,l,c;if(0===i)a=l=c=n;else{const e=n<.5?n*(1+i):n+i-n*i,o=2*n-e;a=r._hue2rgb(o,e,t+1/3),l=r._hue2rgb(o,e,t),c=r._hue2rgb(o,e,t-1/3)}return new o(Math.round(255*a),Math.round(255*l),Math.round(255*c),s)}}class s{constructor(e,t,i,o){this._hsvaBrand=void 0,this.h=0|Math.max(Math.min(360,e),0),this.s=n(Math.max(Math.min(1,t),0),3),this.v=n(Math.max(Math.min(1,i),0),3),this.a=n(Math.max(Math.min(1,o),0),3)}static equals(e,t){return e.h===t.h&&e.s===t.s&&e.v===t.v&&e.a===t.a}static fromRGBA(e){const t=e.r/255,i=e.g/255,n=e.b/255,o=Math.max(t,i,n),r=o-Math.min(t,i,n),a=0===o?0:r/o;let l;return l=0===r?0:o===t?((i-n)/r%6+6)%6:o===i?(n-t)/r+2:(t-i)/r+4,new s(Math.round(60*l),a,o,e.a)}static toRGBA(e){const{h:t,s:i,v:n,a:r}=e,s=n*i,a=s*(1-Math.abs(t/60%2-1)),l=n-s;let[c,d,u]=[0,0,0];return t<60?(c=s,d=a):t<120?(c=a,d=s):t<180?(d=s,u=a):t<240?(d=a,u=s):t<300?(c=a,u=s):t<=360&&(c=s,u=a),c=Math.round(255*(c+l)),d=Math.round(255*(d+l)),u=Math.round(255*(u+l)),new o(c,d,u,r)}}class a{static fromHex(e){return a.Format.CSS.parseHex(e)||a.red}static equals(e,t){return!e&&!t||!(!e||!t)&&e.equals(t)}get hsla(){return this._hsla?this._hsla:r.fromRGBA(this.rgba)}get hsva(){return this._hsva?this._hsva:s.fromRGBA(this.rgba)}constructor(e){if(!e)throw new Error("Color needs a value");if(e instanceof o)this.rgba=e;else if(e instanceof r)this._hsla=e,this.rgba=r.toRGBA(e);else{if(!(e instanceof s))throw new Error("Invalid color ctor argument");this._hsva=e,this.rgba=s.toRGBA(e)}}equals(e){return!!e&&o.equals(this.rgba,e.rgba)&&r.equals(this.hsla,e.hsla)&&s.equals(this.hsva,e.hsva)}getRelativeLuminance(){return n(.2126*a._relativeLuminanceForComponent(this.rgba.r)+.7152*a._relativeLuminanceForComponent(this.rgba.g)+.0722*a._relativeLuminanceForComponent(this.rgba.b),4)}static _relativeLuminanceForComponent(e){const t=e/255;return t<=.03928?t/12.92:Math.pow((t+.055)/1.055,2.4)}isLighter(){return(299*this.rgba.r+587*this.rgba.g+114*this.rgba.b)/1e3>=128}isLighterThan(e){return this.getRelativeLuminance()>e.getRelativeLuminance()}isDarkerThan(e){return this.getRelativeLuminance()<e.getRelativeLuminance()}lighten(e){return new a(new r(this.hsla.h,this.hsla.s,this.hsla.l+this.hsla.l*e,this.hsla.a))}darken(e){return new a(new r(this.hsla.h,this.hsla.s,this.hsla.l-this.hsla.l*e,this.hsla.a))}transparent(e){const{r:t,g:i,b:n,a:r}=this.rgba;return new a(new o(t,i,n,r*e))}isTransparent(){return 0===this.rgba.a}isOpaque(){return 1===this.rgba.a}opposite(){return new a(new o(255-this.rgba.r,255-this.rgba.g,255-this.rgba.b,this.rgba.a))}makeOpaque(e){if(this.isOpaque()||1!==e.rgba.a)return this;const{r:t,g:i,b:n,a:r}=this.rgba;return new a(new o(e.rgba.r-r*(e.rgba.r-t),e.rgba.g-r*(e.rgba.g-i),e.rgba.b-r*(e.rgba.b-n),1))}toString(){return this._toString||(this._toString=a.Format.CSS.format(this)),this._toString}static getLighterColor(e,t,i){if(e.isLighterThan(t))return e;i=i||.5;const n=e.getRelativeLuminance(),o=t.getRelativeLuminance();return i=i*(o-n)/o,e.lighten(i)}static getDarkerColor(e,t,i){if(e.isDarkerThan(t))return e;i=i||.5;const n=e.getRelativeLuminance();return i=i*(n-t.getRelativeLuminance())/n,e.darken(i)}}a.white=new a(new o(255,255,255,1)),a.black=new a(new o(0,0,0,1)),a.red=new a(new o(255,0,0,1)),a.blue=new a(new o(0,0,255,1)),a.green=new a(new o(0,255,0,1)),a.cyan=new a(new o(0,255,255,1)),a.lightgrey=new a(new o(211,211,211,1)),a.transparent=new a(new o(0,0,0,0)),function(e){let t;!function(t){let i;!function(t){function i(e){const t=e.toString(16);return 2!==t.length?"0"+t:t}function n(e){switch(e){case 48:return 0;case 49:return 1;case 50:return 2;case 51:return 3;case 52:return 4;case 53:return 5;case 54:return 6;case 55:return 7;case 56:return 8;case 57:return 9;case 97:case 65:return 10;case 98:case 66:return 11;case 99:case 67:return 12;case 100:case 68:return 13;case 101:case 69:return 14;case 102:case 70:return 15}return 0}t.formatRGB=function(t){return 1===t.rgba.a?`rgb(${t.rgba.r}, ${t.rgba.g}, ${t.rgba.b})`:e.Format.CSS.formatRGBA(t)},t.formatRGBA=function(e){return`rgba(${e.rgba.r}, ${e.rgba.g}, ${e.rgba.b}, ${+e.rgba.a.toFixed(2)})`},t.formatHSL=function(t){return 1===t.hsla.a?`hsl(${t.hsla.h}, ${(100*t.hsla.s).toFixed(2)}%, ${(100*t.hsla.l).toFixed(2)}%)`:e.Format.CSS.formatHSLA(t)},t.formatHSLA=function(e){return`hsla(${e.hsla.h}, ${(100*e.hsla.s).toFixed(2)}%, ${(100*e.hsla.l).toFixed(2)}%, ${e.hsla.a.toFixed(2)})`},t.formatHex=function(e){return`#${i(e.rgba.r)}${i(e.rgba.g)}${i(e.rgba.b)}`},t.formatHexA=function(t,n=!1){return n&&1===t.rgba.a?e.Format.CSS.formatHex(t):`#${i(t.rgba.r)}${i(t.rgba.g)}${i(t.rgba.b)}${i(Math.round(255*t.rgba.a))}`},t.format=function(t){return t.isOpaque()?e.Format.CSS.formatHex(t):e.Format.CSS.formatRGBA(t)},t.parseHex=function(t){const i=t.length;if(0===i)return null;if(35!==t.charCodeAt(0))return null;if(7===i){const i=16*n(t.charCodeAt(1))+n(t.charCodeAt(2)),r=16*n(t.charCodeAt(3))+n(t.charCodeAt(4)),s=16*n(t.charCodeAt(5))+n(t.charCodeAt(6));return new e(new o(i,r,s,1))}if(9===i){const i=16*n(t.charCodeAt(1))+n(t.charCodeAt(2)),r=16*n(t.charCodeAt(3))+n(t.charCodeAt(4)),s=16*n(t.charCodeAt(5))+n(t.charCodeAt(6)),a=16*n(t.charCodeAt(7))+n(t.charCodeAt(8));return new e(new o(i,r,s,a/255))}if(4===i){const i=n(t.charCodeAt(1)),r=n(t.charCodeAt(2)),s=n(t.charCodeAt(3));return new e(new o(16*i+i,16*r+r,16*s+s))}if(5===i){const i=n(t.charCodeAt(1)),r=n(t.charCodeAt(2)),s=n(t.charCodeAt(3)),a=n(t.charCodeAt(4));return new e(new o(16*i+i,16*r+r,16*s+s,(16*a+a)/255))}return null}}(i=t.CSS||(t.CSS={}))}(t=e.Format||(e.Format={}))}(a||(a={}))},99981:function(e,t,i){"use strict";i.r(t),i.d(t,{compareAnything:function(){return s},compareByPrefix:function(){return a},compareFileNames:function(){return r}});var n=i(5560);const o=new n.Lazy((()=>{const e=new Intl.Collator(void 0,{numeric:!0,sensitivity:"base"});return{collator:e,collatorIsNumeric:e.resolvedOptions().numeric}}));new n.Lazy((()=>({collator:new Intl.Collator(void 0,{numeric:!0})}))),new n.Lazy((()=>({collator:new Intl.Collator(void 0,{numeric:!0,sensitivity:"accent"})})));function r(e,t,i=!1){const n=e||"",r=t||"",s=o.value.collator.compare(n,r);return o.value.collatorIsNumeric&&0===s&&n!==r?n<r?-1:1:s}function s(e,t,i){const n=e.toLowerCase(),o=t.toLowerCase(),s=a(e,t,i);if(s)return s;const l=n.endsWith(i);if(l!==o.endsWith(i))return l?-1:1;const c=r(n,o);return 0!==c?c:n.localeCompare(o)}function a(e,t,i){const n=e.toLowerCase(),o=t.toLowerCase(),r=n.startsWith(i),s=o.startsWith(i);if(r!==s)return r?-1:1;if(r&&s){if(n.length<o.length)return-1;if(n.length>o.length)return 1}return 0}},63966:function(e,t,i){"use strict";function n(e,t,i){let n=null,o=null;if("function"==typeof i.value?(n="value",o=i.value,0!==o.length&&console.warn("Memoize should only be used in functions with zero parameters")):"function"==typeof i.get&&(n="get",o=i.get),!o)throw new Error("not supported");const r=`$memoize$${t}`;i[n]=function(...e){return this.hasOwnProperty(r)||Object.defineProperty(this,r,{configurable:!1,enumerable:!1,writable:!1,value:o.apply(this,e)}),this[r]}}i.r(t),i.d(t,{memoize:function(){return n}})},11914:function(e,t,i){"use strict";i.r(t),i.d(t,{LcsDiff:function(){return d},StringDiffSequence:function(){return r},stringDiff:function(){return s}});var n=i(97917),o=i(23829);class r{constructor(e){this.source=e}getElements(){const e=this.source,t=new Int32Array(e.length);for(let i=0,n=e.length;i<n;i++)t[i]=e.charCodeAt(i);return t}}function s(e,t,i){return new d(new r(e),new r(t)).ComputeDiff(i).changes}class a{static Assert(e,t){if(!e)throw new Error(t)}}class l{static Copy(e,t,i,n,o){for(let r=0;r<o;r++)i[n+r]=e[t+r]}static Copy2(e,t,i,n,o){for(let r=0;r<o;r++)i[n+r]=e[t+r]}}class c{constructor(){this.m_changes=[],this.m_originalStart=1073741824,this.m_modifiedStart=1073741824,this.m_originalCount=0,this.m_modifiedCount=0}MarkNextChange(){(this.m_originalCount>0||this.m_modifiedCount>0)&&this.m_changes.push(new n.DiffChange(this.m_originalStart,this.m_originalCount,this.m_modifiedStart,this.m_modifiedCount)),this.m_originalCount=0,this.m_modifiedCount=0,this.m_originalStart=1073741824,this.m_modifiedStart=1073741824}AddOriginalElement(e,t){this.m_originalStart=Math.min(this.m_originalStart,e),this.m_modifiedStart=Math.min(this.m_modifiedStart,t),this.m_originalCount++}AddModifiedElement(e,t){this.m_originalStart=Math.min(this.m_originalStart,e),this.m_modifiedStart=Math.min(this.m_modifiedStart,t),this.m_modifiedCount++}getChanges(){return(this.m_originalCount>0||this.m_modifiedCount>0)&&this.MarkNextChange(),this.m_changes}getReverseChanges(){return(this.m_originalCount>0||this.m_modifiedCount>0)&&this.MarkNextChange(),this.m_changes.reverse(),this.m_changes}}class d{constructor(e,t,i=null){this.ContinueProcessingPredicate=i,this._originalSequence=e,this._modifiedSequence=t;const[n,o,r]=d._getElements(e),[s,a,l]=d._getElements(t);this._hasStrings=r&&l,this._originalStringElements=n,this._originalElementsOrHash=o,this._modifiedStringElements=s,this._modifiedElementsOrHash=a,this.m_forwardHistory=[],this.m_reverseHistory=[]}static _isStringArray(e){return e.length>0&&"string"==typeof e[0]}static _getElements(e){const t=e.getElements();if(d._isStringArray(t)){const e=new Int32Array(t.length);for(let i=0,n=t.length;i<n;i++)e[i]=(0,o.stringHash)(t[i],0);return[t,e,!0]}return t instanceof Int32Array?[[],t,!1]:[[],new Int32Array(t),!1]}ElementsAreEqual(e,t){return this._originalElementsOrHash[e]===this._modifiedElementsOrHash[t]&&(!this._hasStrings||this._originalStringElements[e]===this._modifiedStringElements[t])}ElementsAreStrictEqual(e,t){if(!this.ElementsAreEqual(e,t))return!1;return d._getStrictElement(this._originalSequence,e)===d._getStrictElement(this._modifiedSequence,t)}static _getStrictElement(e,t){return"function"==typeof e.getStrictElement?e.getStrictElement(t):null}OriginalElementsAreEqual(e,t){return this._originalElementsOrHash[e]===this._originalElementsOrHash[t]&&(!this._hasStrings||this._originalStringElements[e]===this._originalStringElements[t])}ModifiedElementsAreEqual(e,t){return this._modifiedElementsOrHash[e]===this._modifiedElementsOrHash[t]&&(!this._hasStrings||this._modifiedStringElements[e]===this._modifiedStringElements[t])}ComputeDiff(e){return this._ComputeDiff(0,this._originalElementsOrHash.length-1,0,this._modifiedElementsOrHash.length-1,e)}_ComputeDiff(e,t,i,n,o){const r=[!1];let s=this.ComputeDiffRecursive(e,t,i,n,r);return o&&(s=this.PrettifyChanges(s)),{quitEarly:r[0],changes:s}}ComputeDiffRecursive(e,t,i,o,r){for(r[0]=!1;e<=t&&i<=o&&this.ElementsAreEqual(e,i);)e++,i++;for(;t>=e&&o>=i&&this.ElementsAreEqual(t,o);)t--,o--;if(e>t||i>o){let r;return i<=o?(a.Assert(e===t+1,"originalStart should only be one more than originalEnd"),r=[new n.DiffChange(e,0,i,o-i+1)]):e<=t?(a.Assert(i===o+1,"modifiedStart should only be one more than modifiedEnd"),r=[new n.DiffChange(e,t-e+1,i,0)]):(a.Assert(e===t+1,"originalStart should only be one more than originalEnd"),a.Assert(i===o+1,"modifiedStart should only be one more than modifiedEnd"),r=[]),r}const s=[0],l=[0],c=this.ComputeRecursionPoint(e,t,i,o,s,l,r),d=s[0],u=l[0];if(null!==c)return c;if(!r[0]){const s=this.ComputeDiffRecursive(e,d,i,u,r);let a=[];return a=r[0]?[new n.DiffChange(d+1,t-(d+1)+1,u+1,o-(u+1)+1)]:this.ComputeDiffRecursive(d+1,t,u+1,o,r),this.ConcatenateChanges(s,a)}return[new n.DiffChange(e,t-e+1,i,o-i+1)]}WALKTRACE(e,t,i,o,r,s,a,l,d,u,h,g,p,m,f,b,v,_){let A=null,C=null,w=new c,y=t,S=i,x=p[0]-b[0]-o,E=-1073741824,k=this.m_forwardHistory.length-1;do{const t=x+e;t===y||t<S&&d[t-1]<d[t+1]?(m=(h=d[t+1])-x-o,h<E&&w.MarkNextChange(),E=h,w.AddModifiedElement(h+1,m),x=t+1-e):(m=(h=d[t-1]+1)-x-o,h<E&&w.MarkNextChange(),E=h-1,w.AddOriginalElement(h,m+1),x=t-1-e),k>=0&&(e=(d=this.m_forwardHistory[k])[0],y=1,S=d.length-1)}while(--k>=-1);if(A=w.getReverseChanges(),_[0]){let e=p[0]+1,t=b[0]+1;if(null!==A&&A.length>0){const i=A[A.length-1];e=Math.max(e,i.getOriginalEnd()),t=Math.max(t,i.getModifiedEnd())}C=[new n.DiffChange(e,g-e+1,t,f-t+1)]}else{w=new c,y=s,S=a,x=p[0]-b[0]-l,E=1073741824,k=v?this.m_reverseHistory.length-1:this.m_reverseHistory.length-2;do{const e=x+r;e===y||e<S&&u[e-1]>=u[e+1]?(m=(h=u[e+1]-1)-x-l,h>E&&w.MarkNextChange(),E=h+1,w.AddOriginalElement(h+1,m+1),x=e+1-r):(m=(h=u[e-1])-x-l,h>E&&w.MarkNextChange(),E=h,w.AddModifiedElement(h+1,m+1),x=e-1-r),k>=0&&(r=(u=this.m_reverseHistory[k])[0],y=1,S=u.length-1)}while(--k>=-1);C=w.getChanges()}return this.ConcatenateChanges(A,C)}ComputeRecursionPoint(e,t,i,o,r,s,a){let c=0,d=0,u=0,h=0,g=0,p=0;e--,i--,r[0]=0,s[0]=0,this.m_forwardHistory=[],this.m_reverseHistory=[];const m=t-e+(o-i),f=m+1,b=new Int32Array(f),v=new Int32Array(f),_=o-i,A=t-e,C=e-i,w=t-o,y=(A-_)%2==0;b[_]=e,v[A]=t,a[0]=!1;for(let S=1;S<=m/2+1;S++){let m=0,x=0;u=this.ClipDiagonalBound(_-S,S,_,f),h=this.ClipDiagonalBound(_+S,S,_,f);for(let e=u;e<=h;e+=2){c=e===u||e<h&&b[e-1]<b[e+1]?b[e+1]:b[e-1]+1,d=c-(e-_)-C;const i=c;for(;c<t&&d<o&&this.ElementsAreEqual(c+1,d+1);)c++,d++;if(b[e]=c,c+d>m+x&&(m=c,x=d),!y&&Math.abs(e-A)<=S-1&&c>=v[e])return r[0]=c,s[0]=d,i<=v[e]&&S<=1448?this.WALKTRACE(_,u,h,C,A,g,p,w,b,v,c,t,r,d,o,s,y,a):null}const E=(m-e+(x-i)-S)/2;if(null!==this.ContinueProcessingPredicate&&!this.ContinueProcessingPredicate(m,E))return a[0]=!0,r[0]=m,s[0]=x,E>0&&S<=1448?this.WALKTRACE(_,u,h,C,A,g,p,w,b,v,c,t,r,d,o,s,y,a):(e++,i++,[new n.DiffChange(e,t-e+1,i,o-i+1)]);g=this.ClipDiagonalBound(A-S,S,A,f),p=this.ClipDiagonalBound(A+S,S,A,f);for(let n=g;n<=p;n+=2){c=n===g||n<p&&v[n-1]>=v[n+1]?v[n+1]-1:v[n-1],d=c-(n-A)-w;const l=c;for(;c>e&&d>i&&this.ElementsAreEqual(c,d);)c--,d--;if(v[n]=c,y&&Math.abs(n-_)<=S&&c<=b[n])return r[0]=c,s[0]=d,l>=b[n]&&S<=1448?this.WALKTRACE(_,u,h,C,A,g,p,w,b,v,c,t,r,d,o,s,y,a):null}if(S<=1447){let e=new Int32Array(h-u+2);e[0]=_-u+1,l.Copy2(b,u,e,1,h-u+1),this.m_forwardHistory.push(e),e=new Int32Array(p-g+2),e[0]=A-g+1,l.Copy2(v,g,e,1,p-g+1),this.m_reverseHistory.push(e)}}return this.WALKTRACE(_,u,h,C,A,g,p,w,b,v,c,t,r,d,o,s,y,a)}PrettifyChanges(e){for(let t=0;t<e.length;t++){const i=e[t],n=t<e.length-1?e[t+1].originalStart:this._originalElementsOrHash.length,o=t<e.length-1?e[t+1].modifiedStart:this._modifiedElementsOrHash.length,r=i.originalLength>0,s=i.modifiedLength>0;for(;i.originalStart+i.originalLength<n&&i.modifiedStart+i.modifiedLength<o&&(!r||this.OriginalElementsAreEqual(i.originalStart,i.originalStart+i.originalLength))&&(!s||this.ModifiedElementsAreEqual(i.modifiedStart,i.modifiedStart+i.modifiedLength));){const e=this.ElementsAreStrictEqual(i.originalStart,i.modifiedStart);if(this.ElementsAreStrictEqual(i.originalStart+i.originalLength,i.modifiedStart+i.modifiedLength)&&!e)break;i.originalStart++,i.modifiedStart++}const a=[null];t<e.length-1&&this.ChangesOverlap(e[t],e[t+1],a)&&(e[t]=a[0],e.splice(t+1,1),t--)}for(let t=e.length-1;t>=0;t--){const i=e[t];let n=0,o=0;if(t>0){const i=e[t-1];n=i.originalStart+i.originalLength,o=i.modifiedStart+i.modifiedLength}const r=i.originalLength>0,s=i.modifiedLength>0;let a=0,l=this._boundaryScore(i.originalStart,i.originalLength,i.modifiedStart,i.modifiedLength);for(let e=1;;e++){const t=i.originalStart-e,c=i.modifiedStart-e;if(t<n||c<o)break;if(r&&!this.OriginalElementsAreEqual(t,t+i.originalLength))break;if(s&&!this.ModifiedElementsAreEqual(c,c+i.modifiedLength))break;const d=(t===n&&c===o?5:0)+this._boundaryScore(t,i.originalLength,c,i.modifiedLength);d>l&&(l=d,a=e)}i.originalStart-=a,i.modifiedStart-=a;const c=[null];t>0&&this.ChangesOverlap(e[t-1],e[t],c)&&(e[t-1]=c[0],e.splice(t,1),t++)}if(this._hasStrings)for(let t=1,i=e.length;t<i;t++){const i=e[t-1],n=e[t],o=n.originalStart-i.originalStart-i.originalLength,r=i.originalStart,s=n.originalStart+n.originalLength,a=s-r,l=i.modifiedStart,c=n.modifiedStart+n.modifiedLength,d=c-l;if(o<5&&a<20&&d<20){const e=this._findBetterContiguousSequence(r,a,l,d,o);if(e){const[t,r]=e;t===i.originalStart+i.originalLength&&r===i.modifiedStart+i.modifiedLength||(i.originalLength=t-i.originalStart,i.modifiedLength=r-i.modifiedStart,n.originalStart=t+o,n.modifiedStart=r+o,n.originalLength=s-n.originalStart,n.modifiedLength=c-n.modifiedStart)}}}return e}_findBetterContiguousSequence(e,t,i,n,o){if(t<o||n<o)return null;const r=e+t-o+1,s=i+n-o+1;let a=0,l=0,c=0;for(let t=e;t<r;t++)for(let e=i;e<s;e++){const i=this._contiguousSequenceScore(t,e,o);i>0&&i>a&&(a=i,l=t,c=e)}return a>0?[l,c]:null}_contiguousSequenceScore(e,t,i){let n=0;for(let o=0;o<i;o++){if(!this.ElementsAreEqual(e+o,t+o))return 0;n+=this._originalStringElements[e+o].length}return n}_OriginalIsBoundary(e){return e<=0||e>=this._originalElementsOrHash.length-1||this._hasStrings&&/^\s*$/.test(this._originalStringElements[e])}_OriginalRegionIsBoundary(e,t){if(this._OriginalIsBoundary(e)||this._OriginalIsBoundary(e-1))return!0;if(t>0){const i=e+t;if(this._OriginalIsBoundary(i-1)||this._OriginalIsBoundary(i))return!0}return!1}_ModifiedIsBoundary(e){return e<=0||e>=this._modifiedElementsOrHash.length-1||this._hasStrings&&/^\s*$/.test(this._modifiedStringElements[e])}_ModifiedRegionIsBoundary(e,t){if(this._ModifiedIsBoundary(e)||this._ModifiedIsBoundary(e-1))return!0;if(t>0){const i=e+t;if(this._ModifiedIsBoundary(i-1)||this._ModifiedIsBoundary(i))return!0}return!1}_boundaryScore(e,t,i,n){return(this._OriginalRegionIsBoundary(e,t)?1:0)+(this._ModifiedRegionIsBoundary(i,n)?1:0)}ConcatenateChanges(e,t){const i=[];if(0===e.length||0===t.length)return t.length>0?t:e;if(this.ChangesOverlap(e[e.length-1],t[0],i)){const n=new Array(e.length+t.length-1);return l.Copy(e,0,n,0,e.length-1),n[e.length-1]=i[0],l.Copy(t,1,n,e.length,t.length-1),n}{const i=new Array(e.length+t.length);return l.Copy(e,0,i,0,e.length),l.Copy(t,0,i,e.length,t.length),i}}ChangesOverlap(e,t,i){if(a.Assert(e.originalStart<=t.originalStart,"Left change is not less than or equal to right change"),a.Assert(e.modifiedStart<=t.modifiedStart,"Left change is not less than or equal to right change"),e.originalStart+e.originalLength>=t.originalStart||e.modifiedStart+e.modifiedLength>=t.modifiedStart){const o=e.originalStart;let r=e.originalLength;const s=e.modifiedStart;let a=e.modifiedLength;return e.originalStart+e.originalLength>=t.originalStart&&(r=t.originalStart+t.originalLength-e.originalStart),e.modifiedStart+e.modifiedLength>=t.modifiedStart&&(a=t.modifiedStart+t.modifiedLength-e.modifiedStart),i[0]=new n.DiffChange(o,r,s,a),!0}return i[0]=null,!1}ClipDiagonalBound(e,t,i,n){if(e>=0&&e<n)return e;const o=t%2==0;if(e<0){return o===(i%2==0)?0:1}return o===((n-i-1)%2==0)?n-1:n-2}}},97917:function(e,t,i){"use strict";i.r(t),i.d(t,{DiffChange:function(){return n}});class n{constructor(e,t,i,n){this.originalStart=e,this.originalLength=t,this.modifiedStart=i,this.modifiedLength=n}getOriginalEnd(){return this.originalStart+this.originalLength}getModifiedEnd(){return this.modifiedStart+this.modifiedLength}}},12718:function(e,t,i){"use strict";i.r(t),i.d(t,{BugIndicatingError:function(){return f},CancellationError:function(){return d},ErrorHandler:function(){return n},ErrorNoTelemetry:function(){return m},NotSupportedError:function(){return p},canceled:function(){return u},errorHandler:function(){return o},illegalArgument:function(){return h},illegalState:function(){return g},isCancellationError:function(){return c},onUnexpectedError:function(){return r},onUnexpectedExternalError:function(){return s},transformErrorForSerialization:function(){return a}});class n{constructor(){this.listeners=[],this.unexpectedErrorHandler=function(e){setTimeout((()=>{if(e.stack){if(m.isErrorNoTelemetry(e))throw new m(e.message+"\n\n"+e.stack);throw new Error(e.message+"\n\n"+e.stack)}throw e}),0)}}emit(e){this.listeners.forEach((t=>{t(e)}))}onUnexpectedError(e){this.unexpectedErrorHandler(e),this.emit(e)}onUnexpectedExternalError(e){this.unexpectedErrorHandler(e)}}const o=new n;function r(e){c(e)||o.onUnexpectedError(e)}function s(e){c(e)||o.onUnexpectedExternalError(e)}function a(e){if(e instanceof Error){const{name:t,message:i}=e;return{$isError:!0,name:t,message:i,stack:e.stacktrace||e.stack,noTelemetry:m.isErrorNoTelemetry(e)}}return e}const l="Canceled";function c(e){return e instanceof d||e instanceof Error&&e.name===l&&e.message===l}class d extends Error{constructor(){super(l),this.name=this.message}}function u(){const e=new Error(l);return e.name=e.message,e}function h(e){return e?new Error(`Illegal argument: ${e}`):new Error("Illegal argument")}function g(e){return e?new Error(`Illegal state: ${e}`):new Error("Illegal state")}class p extends Error{constructor(e){super("NotSupported"),e&&(this.message=e)}}class m extends Error{constructor(e){super(e),this.name="CodeExpectedError"}static fromError(e){if(e instanceof m)return e;const t=new m;return t.message=e.message,t.stack=e.stack,t}static isErrorNoTelemetry(e){return"CodeExpectedError"===e.name}}class f extends Error{constructor(e){super(e||"An unexpected bug occurred."),Object.setPrototypeOf(this,f.prototype)}}},63801:function(e,t,i){"use strict";i.r(t),i.d(t,{DebounceEmitter:function(){return b},Emitter:function(){return g},Event:function(){return l},EventBufferer:function(){return A},EventMultiplexer:function(){return _},EventProfiling:function(){return c},MicrotaskEmitter:function(){return v},PauseableEmitter:function(){return f},Relay:function(){return C},createEventDeliveryQueue:function(){return p}});var n=i(12718),o=i(40548),r=i(68921),s=i(22446),a=i(702);var l;!function(e){function t(e){false}function i(e){return(t,i=null,n)=>{let o,r=!1;return o=e((e=>{if(!r)return o?o.dispose():r=!0,t.call(i,e)}),null,n),r&&o.dispose(),o}}function n(e,t,i){return s(((i,n=null,o)=>e((e=>i.call(n,t(e))),null,o)),i)}function o(e,t,i){return s(((i,n=null,o)=>e((e=>t(e)&&i.call(n,e)),null,o)),i)}function s(e,i){let n;const o={onWillAddFirstListener(){n=e(r.fire,r)},onDidRemoveLastListener(){null==n||n.dispose()}};i||t();const r=new g(o);return null==i||i.add(r),r.event}function a(e,i,n=100,o=!1,r=!1,s,a){let l,c,d,u,h=0;const p={leakWarningThreshold:s,onWillAddFirstListener(){l=e((e=>{h++,c=i(c,e),o&&!d&&(m.fire(c),c=void 0),u=()=>{const e=c;c=void 0,d=void 0,(!o||h>1)&&m.fire(e),h=0},"number"==typeof n?(clearTimeout(d),d=setTimeout(u,n)):void 0===d&&(d=0,queueMicrotask(u))}))},onWillRemoveListener(){r&&h>0&&(null==u||u())},onDidRemoveLastListener(){u=void 0,l.dispose()}};a||t();const m=new g(p);return null==a||a.add(m),m.event}e.None=()=>r.Disposable.None,e.defer=function(e,t){return a(e,(()=>{}),0,void 0,!0,void 0,t)},e.once=i,e.map=n,e.forEach=function(e,t,i){return s(((i,n=null,o)=>e((e=>{t(e),i.call(n,e)}),null,o)),i)},e.filter=o,e.signal=function(e){return e},e.any=function(...e){return(t,i=null,n)=>function(e,t){t instanceof Array?t.push(e):t&&t.add(e);return e}((0,r.combinedDisposable)(...e.map((e=>e((e=>t.call(i,e)))))),n)},e.reduce=function(e,t,i,o){let r=i;return n(e,(e=>(r=t(r,e),r)),o)},e.debounce=a,e.accumulate=function(t,i=0,n){return e.debounce(t,((e,t)=>e?(e.push(t),e):[t]),i,void 0,!0,void 0,n)},e.latch=function(e,t=((e,t)=>e===t),i){let n,r=!0;return o(e,(e=>{const i=r||!t(e,n);return r=!1,n=e,i}),i)},e.split=function(t,i,n){return[e.filter(t,i,n),e.filter(t,(e=>!i(e)),n)]},e.buffer=function(e,t=!1,i=[],n){let o=i.slice(),r=e((e=>{o?o.push(e):a.fire(e)}));n&&n.add(r);const s=()=>{null==o||o.forEach((e=>a.fire(e))),o=null},a=new g({onWillAddFirstListener(){r||(r=e((e=>a.fire(e))),n&&n.add(r))},onDidAddFirstListener(){o&&(t?setTimeout(s):s())},onDidRemoveLastListener(){r&&r.dispose(),r=null}});return n&&n.add(a),a.event},e.chain=function(e,t){return(i,n,o)=>{const r=t(new c);return e((function(e){const t=r.evaluate(e);t!==l&&i.call(n,t)}),void 0,o)}};const l=Symbol("HaltChainable");class c{constructor(){this.steps=[]}map(e){return this.steps.push(e),this}forEach(e){return this.steps.push((t=>(e(t),t))),this}filter(e){return this.steps.push((t=>e(t)?t:l)),this}reduce(e,t){let i=t;return this.steps.push((t=>(i=e(i,t),i))),this}latch(e=((e,t)=>e===t)){let t,i=!0;return this.steps.push((n=>{const o=i||!e(n,t);return i=!1,t=n,o?n:l})),this}evaluate(e){for(const t of this.steps)if((e=t(e))===l)break;return e}}e.fromNodeEventEmitter=function(e,t,i=(e=>e)){const n=(...e)=>o.fire(i(...e)),o=new g({onWillAddFirstListener:()=>e.on(t,n),onDidRemoveLastListener:()=>e.removeListener(t,n)});return o.event},e.fromDOMEventEmitter=function(e,t,i=(e=>e)){const n=(...e)=>o.fire(i(...e)),o=new g({onWillAddFirstListener:()=>e.addEventListener(t,n),onDidRemoveLastListener:()=>e.removeEventListener(t,n)});return o.event},e.toPromise=function(e){return new Promise((t=>i(e)(t)))},e.fromPromise=function(e){const t=new g;return e.then((e=>{t.fire(e)}),(()=>{t.fire(void 0)})).finally((()=>{t.dispose()})),t.event},e.runAndSubscribe=function(e,t,i){return t(i),e((e=>t(e)))},e.runAndSubscribeWithStore=function(e,t){let i=null;function n(e){null==i||i.dispose(),i=new r.DisposableStore,t(e,i)}n(void 0);const o=e((e=>n(e)));return(0,r.toDisposable)((()=>{o.dispose(),null==i||i.dispose()}))};class d{constructor(e,i){this._observable=e,this._counter=0,this._hasChanged=!1;const n={onWillAddFirstListener:()=>{e.addObserver(this)},onDidRemoveLastListener:()=>{e.removeObserver(this)}};i||t(),this.emitter=new g(n),i&&i.add(this.emitter)}beginUpdate(e){this._counter++}handlePossibleChange(e){}handleChange(e,t){this._hasChanged=!0}endUpdate(e){this._counter--,0===this._counter&&(this._observable.reportChanges(),this._hasChanged&&(this._hasChanged=!1,this.emitter.fire(this._observable.get())))}}e.fromObservable=function(e,t){return new d(e,t).emitter.event},e.fromObservableLight=function(e){return(t,i,n)=>{let o=0,s=!1;const a={beginUpdate(){o++},endUpdate(){o--,0===o&&(e.reportChanges(),s&&(s=!1,t.call(i)))},handlePossibleChange(){},handleChange(){s=!0}};e.addObserver(a),e.reportChanges();const l={dispose(){e.removeObserver(a)}};return n instanceof r.DisposableStore?n.add(l):Array.isArray(n)&&n.push(l),l}}}(l||(l={}));class c{constructor(e){this.listenerCount=0,this.invocationCount=0,this.elapsedOverall=0,this.durations=[],this.name=`${e}_${c._idPool++}`,c.all.add(this)}start(e){this._stopWatch=new a.StopWatch,this.listenerCount=e}stop(){if(this._stopWatch){const e=this._stopWatch.elapsed();this.durations.push(e),this.elapsedOverall+=e,this.invocationCount+=1,this._stopWatch=void 0}}}c.all=new Set,c._idPool=0;class d{constructor(e,t=Math.random().toString(18).slice(2,5)){this.threshold=e,this.name=t,this._warnCountdown=0}dispose(){var e;null===(e=this._stacks)||void 0===e||e.clear()}check(e,t){const i=this.threshold;if(i<=0||t<i)return;this._stacks||(this._stacks=new Map);const n=this._stacks.get(e.value)||0;if(this._stacks.set(e.value,n+1),this._warnCountdown-=1,this._warnCountdown<=0){let e;this._warnCountdown=.5*i;let n=0;for(const[t,i]of this._stacks)(!e||n<i)&&(e=t,n=i);console.warn(`[${this.name}] potential listener LEAK detected, having ${t} listeners already. MOST frequent listener (${n}):`),console.warn(e)}return()=>{const t=this._stacks.get(e.value)||0;this._stacks.set(e.value,t-1)}}}class u{static create(){var e;return new u(null!==(e=(new Error).stack)&&void 0!==e?e:"")}constructor(e){this.value=e}print(){console.warn(this.value.split("\n").slice(2).join("\n"))}}class h{constructor(e){this.value=e}}class g{constructor(e){var t,i,n,o,r;this._size=0,this._options=e,this._leakageMon=(null===(t=this._options)||void 0===t?void 0:t.leakWarningThreshold)?new d(null!==(n=null===(i=this._options)||void 0===i?void 0:i.leakWarningThreshold)&&void 0!==n?n:-1):void 0,this._perfMon=(null===(o=this._options)||void 0===o?void 0:o._profName)?new c(this._options._profName):void 0,this._deliveryQueue=null===(r=this._options)||void 0===r?void 0:r.deliveryQueue}dispose(){var e,t,i,n;this._disposed||(this._disposed=!0,(null===(e=this._deliveryQueue)||void 0===e?void 0:e.current)===this&&this._deliveryQueue.reset(),this._listeners&&(this._listeners=void 0,this._size=0),null===(i=null===(t=this._options)||void 0===t?void 0:t.onDidRemoveLastListener)||void 0===i||i.call(t),null===(n=this._leakageMon)||void 0===n||n.dispose())}get event(){var e;return null!==(e=this._event)&&void 0!==e||(this._event=(e,t,i)=>{var n,o,s,a,l;if(this._leakageMon&&this._size>3*this._leakageMon.threshold)return console.warn(`[${this._leakageMon.name}] REFUSES to accept new listeners because it exceeded its threshold by far`),r.Disposable.None;if(this._disposed)return r.Disposable.None;t&&(e=e.bind(t));const c=new h(e);let d;this._leakageMon&&this._size>=Math.ceil(.2*this._leakageMon.threshold)&&(c.stack=u.create(),d=this._leakageMon.check(c.stack,this._size+1)),this._listeners?this._listeners instanceof h?(null!==(l=this._deliveryQueue)&&void 0!==l||(this._deliveryQueue=new m),this._listeners=[this._listeners,c]):this._listeners.push(c):(null===(o=null===(n=this._options)||void 0===n?void 0:n.onWillAddFirstListener)||void 0===o||o.call(n,this),this._listeners=c,null===(a=null===(s=this._options)||void 0===s?void 0:s.onDidAddFirstListener)||void 0===a||a.call(s,this)),this._size++;const g=(0,r.toDisposable)((()=>{null==d||d(),this._removeListener(c)}));return i instanceof r.DisposableStore?i.add(g):Array.isArray(i)&&i.push(g),g}),this._event}_removeListener(e){var t,i,n,o;if(null===(i=null===(t=this._options)||void 0===t?void 0:t.onWillRemoveListener)||void 0===i||i.call(t,this),!this._listeners)return;if(1===this._size)return this._listeners=void 0,null===(o=null===(n=this._options)||void 0===n?void 0:n.onDidRemoveLastListener)||void 0===o||o.call(n,this),void(this._size=0);const r=this._listeners,s=r.indexOf(e);if(-1===s)throw console.log("disposed?",this._disposed),console.log("size?",this._size),console.log("arr?",JSON.stringify(this._listeners)),new Error("Attempted to dispose unknown listener");this._size--,r[s]=void 0;const a=this._deliveryQueue.current===this;if(2*this._size<=r.length){let e=0;for(let t=0;t<r.length;t++)r[t]?r[e++]=r[t]:a&&(this._deliveryQueue.end--,e<this._deliveryQueue.i&&this._deliveryQueue.i--);r.length=e}}_deliver(e,t){var i;if(!e)return;const o=(null===(i=this._options)||void 0===i?void 0:i.onListenerError)||n.onUnexpectedError;if(o)try{e.value(t)}catch(e){o(e)}else e.value(t)}_deliverQueue(e){const t=e.current._listeners;for(;e.i<e.end;)this._deliver(t[e.i++],e.value);e.reset()}fire(e){var t,i,n,o;if((null===(t=this._deliveryQueue)||void 0===t?void 0:t.current)&&(this._deliverQueue(this._deliveryQueue),null===(i=this._perfMon)||void 0===i||i.stop()),null===(n=this._perfMon)||void 0===n||n.start(this._size),this._listeners)if(this._listeners instanceof h)this._deliver(this._listeners,e);else{const t=this._deliveryQueue;t.enqueue(this,e,this._listeners.length),this._deliverQueue(t)}else;null===(o=this._perfMon)||void 0===o||o.stop()}hasListeners(){return this._size>0}}const p=()=>new m;class m{constructor(){this.i=-1,this.end=0}enqueue(e,t,i){this.i=0,this.end=i,this.current=e,this.value=t}reset(){this.i=this.end,this.current=void 0,this.value=void 0}}class f extends g{constructor(e){super(e),this._isPaused=0,this._eventQueue=new s.LinkedList,this._mergeFn=null==e?void 0:e.merge}pause(){this._isPaused++}resume(){if(0!==this._isPaused&&0==--this._isPaused)if(this._mergeFn){if(this._eventQueue.size>0){const e=Array.from(this._eventQueue);this._eventQueue.clear(),super.fire(this._mergeFn(e))}}else for(;!this._isPaused&&0!==this._eventQueue.size;)super.fire(this._eventQueue.shift())}fire(e){this._size&&(0!==this._isPaused?this._eventQueue.push(e):super.fire(e))}}class b extends f{constructor(e){var t;super(e),this._delay=null!==(t=e.delay)&&void 0!==t?t:100}fire(e){this._handle||(this.pause(),this._handle=setTimeout((()=>{this._handle=void 0,this.resume()}),this._delay)),super.fire(e)}}class v extends g{constructor(e){super(e),this._queuedEvents=[],this._mergeFn=null==e?void 0:e.merge}fire(e){this.hasListeners()&&(this._queuedEvents.push(e),1===this._queuedEvents.length&&queueMicrotask((()=>{this._mergeFn?super.fire(this._mergeFn(this._queuedEvents)):this._queuedEvents.forEach((e=>super.fire(e))),this._queuedEvents=[]})))}}class _{constructor(){this.hasListeners=!1,this.events=[],this.emitter=new g({onWillAddFirstListener:()=>this.onFirstListenerAdd(),onDidRemoveLastListener:()=>this.onLastListenerRemove()})}get event(){return this.emitter.event}add(e){const t={event:e,listener:null};this.events.push(t),this.hasListeners&&this.hook(t);return(0,r.toDisposable)((0,o.createSingleCallFunction)((()=>{this.hasListeners&&this.unhook(t);const e=this.events.indexOf(t);this.events.splice(e,1)})))}onFirstListenerAdd(){this.hasListeners=!0,this.events.forEach((e=>this.hook(e)))}onLastListenerRemove(){this.hasListeners=!1,this.events.forEach((e=>this.unhook(e)))}hook(e){e.listener=e.event((e=>this.emitter.fire(e)))}unhook(e){e.listener&&e.listener.dispose(),e.listener=null}dispose(){this.emitter.dispose()}}class A{constructor(){this.buffers=[]}wrapEvent(e){return(t,i,n)=>e((e=>{const n=this.buffers[this.buffers.length-1];n?n.push((()=>t.call(i,e))):t.call(i,e)}),void 0,n)}bufferEvents(e){const t=[];this.buffers.push(t);const i=e();return this.buffers.pop(),t.forEach((e=>e())),i}}class C{constructor(){this.listening=!1,this.inputEvent=l.None,this.inputEventListener=r.Disposable.None,this.emitter=new g({onDidAddFirstListener:()=>{this.listening=!0,this.inputEventListener=this.inputEvent(this.emitter.fire,this.emitter)},onDidRemoveLastListener:()=>{this.listening=!1,this.inputEventListener.dispose()}}),this.event=this.emitter.event}set input(e){this.inputEvent=e,this.listening&&(this.inputEventListener.dispose(),this.inputEventListener=e(this.emitter.fire,this.emitter))}dispose(){this.inputEventListener.dispose(),this.emitter.dispose()}}},98508:function(e,t,i){"use strict";i.r(t),i.d(t,{getRoot:function(){return c},hasDriveLetter:function(){return h},isEqualOrParent:function(){return d},isPathSeparator:function(){return s},isWindowsDriveLetter:function(){return u},toPosixPath:function(){return l},toSlashes:function(){return a}});var n=i(23674),o=i(66719),r=i(91482);function s(e){return 47===e||92===e}function a(e){return e.replace(/[\\/]/g,n.posix.sep)}function l(e){return-1===e.indexOf("/")&&(e=a(e)),/^[a-zA-Z]:(\/|$)/.test(e)&&(e="/"+e),e}function c(e,t=n.posix.sep){if(!e)return"";const i=e.length,o=e.charCodeAt(0);if(s(o)){if(s(e.charCodeAt(1))&&!s(e.charCodeAt(2))){let n=3;const o=n;for(;n<i&&!s(e.charCodeAt(n));n++);if(o!==n&&!s(e.charCodeAt(n+1)))for(n+=1;n<i;n++)if(s(e.charCodeAt(n)))return e.slice(0,n+1).replace(/[\\/]/g,t)}return t}if(u(o)&&58===e.charCodeAt(1))return s(e.charCodeAt(2))?e.slice(0,2)+t:e.slice(0,2);let r=e.indexOf("://");if(-1!==r)for(r+=3;r<i;r++)if(s(e.charCodeAt(r)))return e.slice(0,r+1);return""}function d(e,t,i,o=n.sep){if(e===t)return!0;if(!e||!t)return!1;if(t.length>e.length)return!1;if(i){if(!(0,r.startsWithIgnoreCase)(e,t))return!1;if(t.length===e.length)return!0;let i=t.length;return t.charAt(t.length-1)===o&&i--,e.charAt(i)===o}return t.charAt(t.length-1)!==o&&(t+=o),0===e.indexOf(t)}function u(e){return e>=65&&e<=90||e>=97&&e<=122}function h(e,t=o.isWindows){return!!t&&(u(e.charCodeAt(0))&&58===e.charCodeAt(1))}},27017:function(e,t,i){"use strict";i.r(t),i.d(t,{FuzzyScore:function(){return J},FuzzyScoreOptions:function(){return Z},anyScore:function(){return B},createMatches:function(){return O},fuzzyScore:function(){return X},fuzzyScoreGracefulAggressive:function(){return te},isPatternInWord:function(){return $},isUpper:function(){return p},matchesCamelCase:function(){return E},matchesContiguousSubString:function(){return d},matchesFuzzy:function(){return N},matchesFuzzy2:function(){return R},matchesPrefix:function(){return l},matchesStrictPrefix:function(){return a},matchesSubString:function(){return u},matchesWords:function(){return k},or:function(){return s}});var n=i(13833),o=i(73264),r=i(91482);function s(...e){return function(t,i){for(let n=0,o=e.length;n<o;n++){const o=e[n](t,i);if(o)return o}return null}}const a=c.bind(void 0,!1),l=c.bind(void 0,!0);function c(e,t,i){if(!i||i.length<t.length)return null;let n;return n=e?r.startsWithIgnoreCase(i,t):0===i.indexOf(t),n?t.length>0?[{start:0,end:t.length}]:[]:null}function d(e,t){const i=t.toLowerCase().indexOf(e.toLowerCase());return-1===i?null:[{start:i,end:i+e.length}]}function u(e,t){return h(e.toLowerCase(),t.toLowerCase(),0,0)}function h(e,t,i,n){if(i===e.length)return[];if(n===t.length)return null;if(e[i]===t[n]){let o=null;return(o=h(e,t,i+1,n+1))?y({start:n,end:n+1},o):null}return h(e,t,i,n+1)}function g(e){return 97<=e&&e<=122}function p(e){return 65<=e&&e<=90}function m(e){return 48<=e&&e<=57}function f(e){return 32===e||9===e||10===e||13===e}const b=new Set;function v(e){return f(e)||b.has(e)}function _(e,t){return e===t||v(e)&&v(t)}"()[]{}<>`'\"-/;:,.?!".split("").forEach((e=>b.add(e.charCodeAt(0))));const A=new Map;function C(e){if(A.has(e))return A.get(e);let t;const i=(0,o.getKoreanAltChars)(e);return i&&(t=i),A.set(e,t),t}function w(e){return g(e)||p(e)||m(e)}function y(e,t){return 0===t.length?t=[e]:e.end===t[0].start?t[0].start=e.start:t.unshift(e),t}function S(e,t){for(let i=t;i<e.length;i++){const t=e.charCodeAt(i);if(p(t)||m(t)||i>0&&!w(e.charCodeAt(i-1)))return i}return e.length}function x(e,t,i,n){if(i===e.length)return[];if(n===t.length)return null;if(e[i]!==t[n].toLowerCase())return null;{let o=null,r=n+1;for(o=x(e,t,i+1,n+1);!o&&(r=S(t,r))<t.length;)o=x(e,t,i+1,r),r++;return null===o?null:y({start:n,end:n+1},o)}}function E(e,t){if(!t)return null;if(0===(t=t.trim()).length)return null;if(!function(e){let t=0,i=0,n=0,o=0;for(let r=0;r<e.length;r++)n=e.charCodeAt(r),p(n)&&t++,g(n)&&i++,f(n)&&o++;return 0!==t&&0!==i||0!==o?t<=5:e.length<=30}(e))return null;if(t.length>60)return null;const i=function(e){let t=0,i=0,n=0,o=0,r=0;for(let s=0;s<e.length;s++)r=e.charCodeAt(s),p(r)&&t++,g(r)&&i++,w(r)&&n++,m(r)&&o++;return{upperPercent:t/e.length,lowerPercent:i/e.length,alphaPercent:n/e.length,numericPercent:o/e.length}}(t);if(!function(e){const{upperPercent:t,lowerPercent:i,alphaPercent:n,numericPercent:o}=e;return i>.2&&t<.8&&n>.6&&o<.2}(i)){if(!function(e){const{upperPercent:t,lowerPercent:i}=e;return 0===i&&t>.6}(i))return null;t=t.toLowerCase()}let n=null,o=0;for(e=e.toLowerCase();o<t.length&&null===(n=x(e,t,0,o));)o=S(t,o+1);return n}function k(e,t,i=!1){if(!t||0===t.length)return null;let n=null,o=0;for(e=e.toLowerCase(),t=t.toLowerCase();o<t.length&&(n=D(e,t,0,o,i),null===n);)o=I(t,o+1);return n}function D(e,t,i,n,o){let r=0;if(i===e.length)return[];if(n===t.length)return null;if(!_(e.charCodeAt(i),t.charCodeAt(n))){const o=C(e.charCodeAt(i));if(!o)return null;for(let e=0;e<o.length;e++)if(!_(o[e],t.charCodeAt(n+e)))return null;r+=o.length-1}let s=null,a=n+r+1;if(s=D(e,t,i+1,a,o),!o)for(;!s&&(a=I(t,a))<t.length;)s=D(e,t,i+1,a,o),a++;if(!s)return null;if(e.charCodeAt(i)!==t.charCodeAt(n)){const o=C(e.charCodeAt(i));if(!o)return s;for(let e=0;e<o.length;e++)if(o[e]!==t.charCodeAt(n+e))return s}return y({start:n,end:n+r+1},s)}function I(e,t){for(let i=t;i<e.length;i++)if(v(e.charCodeAt(i))||i>0&&v(e.charCodeAt(i-1)))return i;return e.length}const L=s(l,E,d),T=s(l,E,u),M=new n.LRUCache(1e4);function N(e,t,i=!1){if("string"!=typeof e||"string"!=typeof t)return null;let n=M.get(e);n||(n=new RegExp(r.convertSimple2RegExpPattern(e),"i"),M.set(e,n));const o=n.exec(t);return o?[{start:o.index,end:o.index+o[0].length}]:i?T(e,t):L(e,t)}function R(e,t){const i=X(e,e.toLowerCase(),0,t,t.toLowerCase(),0,{firstMatchCanBeWeak:!0,boostFullMatch:!0});return i?O(i):null}function B(e,t,i,n,o,r){const s=Math.min(13,e.length);for(;i<s;i++){const s=X(e,t,i,n,o,r,{firstMatchCanBeWeak:!0,boostFullMatch:!0});if(s)return s}return[0,r]}function O(e){if(void 0===e)return[];const t=[],i=e[1];for(let n=e.length-1;n>1;n--){const o=e[n]+i,r=t[t.length-1];r&&r.end===o?r.end=o+1:t.push({start:o,end:o+1})}return t}const F=128;function P(){const e=[],t=[];for(let e=0;e<=F;e++)t[e]=0;for(let i=0;i<=F;i++)e.push(t.slice(0));return e}function z(e){const t=[];for(let i=0;i<=e;i++)t[i]=0;return t}const W=z(2*F),H=z(2*F),V=P(),U=P(),Q=P(),K=!1;function j(e,t,i,n,o){function r(e,t,i=" "){for(;e.length<t;)e=i+e;return e}let s=` |   |${n.split("").map((e=>r(e,3))).join("|")}\n`;for(let n=0;n<=i;n++)s+=0===n?" |":`${t[n-1]}|`,s+=e[n].slice(0,o+1).map((e=>r(e.toString(),3))).join("|")+"\n";return s}function G(e,t){if(t<0||t>=e.length)return!1;const i=e.codePointAt(t);switch(i){case 95:case 45:case 46:case 32:case 47:case 92:case 39:case 34:case 58:case 36:case 60:case 62:case 40:case 41:case 91:case 93:case 123:case 125:return!0;case void 0:return!1;default:return!!r.isEmojiImprecise(i)}}function q(e,t){if(t<0||t>=e.length)return!1;switch(e.charCodeAt(t)){case 32:case 9:return!0;default:return!1}}function Y(e,t,i){return t[e]!==i[e]}function $(e,t,i,n,o,r,s=!1){for(;t<i&&o<r;)e[t]===n[o]&&(s&&(W[t]=o),t+=1),o+=1;return t===i}var J;!function(e){e.Default=[-100,0],e.isDefault=function(e){return!e||2===e.length&&-100===e[0]&&0===e[1]}}(J||(J={}));class Z{constructor(e,t){this.firstMatchCanBeWeak=e,this.boostFullMatch=t}}function X(e,t,i,n,o,r,s=Z.default){const a=e.length>F?F:e.length,l=n.length>F?F:n.length;if(i>=a||r>=l||a-i>l-r)return;if(!$(t,i,a,o,r,l,!0))return;!function(e,t,i,n,o,r){let s=e-1,a=t-1;for(;s>=i&&a>=n;)o[s]===r[a]&&(H[s]=a,s--),a--}(a,l,i,r,t,o);let c=1,d=1,u=i,h=r;const g=[!1];for(c=1,u=i;u<a;c++,u++){const s=W[u],p=H[u],m=u+1<a?H[u+1]:l;for(d=s-r+1,h=s;h<m;d++,h++){let a=Number.MIN_SAFE_INTEGER,m=!1;h<=p&&(a=ee(e,t,u,i,n,o,h,l,r,0===V[c-1][d-1],g));let f=0;a!==Number.MAX_SAFE_INTEGER&&(m=!0,f=a+U[c-1][d-1]);const b=h>s,v=b?U[c][d-1]+(V[c][d-1]>0?-5:0):0,_=h>s+1&&V[c][d-1]>0,A=_?U[c][d-2]+(V[c][d-2]>0?-5:0):0;if(_&&(!b||A>=v)&&(!m||A>=f))U[c][d]=A,Q[c][d]=3,V[c][d]=0;else if(b&&(!m||v>=f))U[c][d]=v,Q[c][d]=2,V[c][d]=0;else{if(!m)throw new Error("not possible");U[c][d]=f,Q[c][d]=1,V[c][d]=V[c-1][d-1]+1}}}if(K&&function(e,t,i,n){e=e.substr(t),i=i.substr(n),console.log(j(U,e,e.length,i,i.length)),console.log(j(Q,e,e.length,i,i.length)),console.log(j(V,e,e.length,i,i.length))}(e,i,n,r),!g[0]&&!s.firstMatchCanBeWeak)return;c--,d--;const p=[U[c][d],r];let m=0,f=0;for(;c>=1;){let e=d;do{const t=Q[c][e];if(3===t)e-=2;else{if(2!==t)break;e-=1}}while(e>=1);m>1&&t[i+c-1]===o[r+d-1]&&!Y(e+r-1,n,o)&&m+1>V[c][e]&&(e=d),e===d?m++:m=1,f||(f=e),c--,d=e-1,p.push(d)}l===a&&s.boostFullMatch&&(p[0]+=2);const b=f-a;return p[0]-=b,p}function ee(e,t,i,n,o,r,s,a,l,c,d){if(t[i]!==r[s])return Number.MIN_SAFE_INTEGER;let u=1,h=!1;return s===i-n?u=e[i]===o[s]?7:5:!Y(s,o,r)||0!==s&&Y(s-1,o,r)?!G(r,s)||0!==s&&G(r,s-1)?(G(r,s-1)||q(r,s-1))&&(u=5,h=!0):u=5:(u=e[i]===o[s]?7:5,h=!0),u>1&&i===n&&(d[0]=!0),h||(h=Y(s,o,r)||G(r,s-1)||q(r,s-1)),i===n?s>l&&(u-=h?3:5):u+=c?h?2:0:h?0:1,s+1===a&&(u-=h?3:5),u}function te(e,t,i,n,o,r,s){return function(e,t,i,n,o,r,s,a){let l=X(e,t,i,n,o,r,a);if(l&&!s)return l;if(e.length>=3){const t=Math.min(7,e.length-1);for(let s=i+1;s<t;s++){const t=ie(e,s);if(t){const e=X(t,t.toLowerCase(),i,n,o,r,a);e&&(e[0]-=3,(!l||e[0]>l[0])&&(l=e))}}}return l}(e,t,i,n,o,r,!0,s)}function ie(e,t){if(t+1>=e.length)return;const i=e[t],n=e[t+1];return i!==n?e.slice(0,t)+n+i+e.slice(t+2):void 0}Z.default={boostFullMatch:!0,firstMatchCanBeWeak:!1}},40548:function(e,t,i){"use strict";function n(e,t){const i=this;let n,o=!1;return function(){if(o)return n;if(o=!0,t)try{n=e.apply(i,arguments)}finally{t()}else n=e.apply(i,arguments);return n}}i.r(t),i.d(t,{createSingleCallFunction:function(){return n}})},30997:function(e,t,i){"use strict";i.r(t),i.d(t,{GLOBSTAR:function(){return c},GLOB_SPLIT:function(){return d},isRelativePattern:function(){return M},match:function(){return L},parse:function(){return T},splitGlobAware:function(){return m}});var n=i(66129),o=i(98508),r=i(13833),s=i(23674),a=i(66719),l=i(91482);const c="**",d="/",u="[/\\\\]",h="[^/\\\\]",g=/\//g;function p(e,t){switch(e){case 0:return"";case 1:return`${h}*?`;default:return`(?:${u}|${h}+${u}${t?`|${u}${h}+`:""})*?`}}function m(e,t){if(!e)return[];const i=[];let n=!1,o=!1,r="";for(const s of e){switch(s){case t:if(!n&&!o){i.push(r),r="";continue}break;case"{":n=!0;break;case"}":n=!1;break;case"[":o=!0;break;case"]":o=!1}r+=s}return r&&i.push(r),i}function f(e){if(!e)return"";let t="";const i=m(e,d);if(i.every((e=>e===c)))t=".*";else{let e=!1;i.forEach(((n,o)=>{if(n===c){if(e)return;t+=p(2,o===i.length-1)}else{let e=!1,r="",s=!1,a="";for(const i of n)if("}"!==i&&e)r+=i;else if(!s||"]"===i&&a)switch(i){case"{":e=!0;continue;case"[":s=!0;continue;case"}":{const i=`(?:${m(r,",").map((e=>f(e))).join("|")})`;t+=i,e=!1,r="";break}case"]":t+="["+a+"]",s=!1,a="";break;case"?":t+=h;continue;case"*":t+=p(1);continue;default:t+=(0,l.escapeRegExpCharacters)(i)}else{let e;e="-"===i?i:"^"!==i&&"!"!==i||a?i===d?"":(0,l.escapeRegExpCharacters)(i):"^",a+=e}o<i.length-1&&(i[o+1]!==c||o+2<i.length)&&(t+=u)}e=n===c}))}return t}const b=/^\*\*\/\*\.[\w\.-]+$/,v=/^\*\*\/([\w\.-]+)\/?$/,_=/^{\*\*\/\*?[\w\.-]+\/?(,\*\*\/\*?[\w\.-]+\/?)*}$/,A=/^{\*\*\/\*?[\w\.-]+(\/(\*\*)?)?(,\*\*\/\*?[\w\.-]+(\/(\*\*)?)?)*}$/,C=/^\*\*((\/[\w\.-]+)+)\/?$/,w=/^([\w\.-]+(\/[\w\.-]+)*)\/?$/,y=new r.LRUCache(1e4),S=function(){return!1},x=function(){return null};function E(e,t){if(!e)return x;let i;i="string"!=typeof e?e.pattern:e,i=i.trim();const n=`${i}_${!!t.trimForExclusions}`;let o,r=y.get(n);return r||(r=b.test(i)?function(e,t){return function(i,n){return"string"==typeof i&&i.endsWith(e)?t:null}}(i.substr(4),i):(o=v.exec(D(i,t)))?function(e,t){const i=`/${e}`,n=`\\${e}`,o=function(o,r){return"string"!=typeof o?null:r?r===e?t:null:o===e||o.endsWith(i)||o.endsWith(n)?t:null},r=[e];return o.basenames=r,o.patterns=[t],o.allBasenames=r,o}(o[1],i):(t.trimForExclusions?A:_).test(i)?function(e,t){const i=N(e.slice(1,-1).split(",").map((e=>E(e,t))).filter((e=>e!==x)),e),n=i.length;if(!n)return x;if(1===n)return i[0];const o=function(t,n){for(let o=0,r=i.length;o<r;o++)if(i[o](t,n))return e;return null},r=i.find((e=>!!e.allBasenames));r&&(o.allBasenames=r.allBasenames);const s=i.reduce(((e,t)=>t.allPaths?e.concat(t.allPaths):e),[]);s.length&&(o.allPaths=s);return o}(i,t):(o=C.exec(D(i,t)))?I(o[1].substr(1),i,!0):(o=w.exec(D(i,t)))?I(o[1],i,!1):function(e){try{const t=new RegExp(`^${f(e)}$`);return function(i){return t.lastIndex=0,"string"==typeof i&&t.test(i)?e:null}}catch(e){return x}}(i),y.set(n,r)),k(r,e)}function k(e,t){if("string"==typeof t)return e;const i=function(i,n){return(0,o.isEqualOrParent)(i,t.base,!a.isLinux)?e((0,l.ltrim)(i.substr(t.base.length),s.sep),n):null};return i.allBasenames=e.allBasenames,i.allPaths=e.allPaths,i.basenames=e.basenames,i.patterns=e.patterns,i}function D(e,t){return t.trimForExclusions&&e.endsWith("/**")?e.substr(0,e.length-2):e}function I(e,t,i){const n=s.sep===s.posix.sep,o=n?e:e.replace(g,s.sep),r=s.sep+o,a=s.posix.sep+e;let l;return l=i?function(i,s){return"string"!=typeof i||i!==o&&!i.endsWith(r)&&(n||i!==e&&!i.endsWith(a))?null:t}:function(i,r){return"string"!=typeof i||i!==o&&(n||i!==e)?null:t},l.allPaths=[(i?"*/":"./")+e],l}function L(e,t,i){return!(!e||"string"!=typeof t)&&T(e)(t,void 0,i)}function T(e,t={}){if(!e)return S;if("string"==typeof e||M(e)){const i=E(e,t);if(i===x)return S;const n=function(e,t){return!!i(e,t)};return i.allBasenames&&(n.allBasenames=i.allBasenames),i.allPaths&&(n.allPaths=i.allPaths),n}return function(e,t){const i=N(Object.getOwnPropertyNames(e).map((i=>function(e,t,i){if(!1===t)return x;const o=E(e,i);if(o===x)return x;if("boolean"==typeof t)return o;if(t){const i=t.when;if("string"==typeof i){const t=(t,r,s,a)=>{if(!a||!o(t,r))return null;const l=a(i.replace("$(basename)",(()=>s)));return(0,n.isThenable)(l)?l.then((t=>t?e:null)):l?e:null};return t.requiresSiblings=!0,t}}return o}(i,e[i],t))).filter((e=>e!==x))),o=i.length;if(!o)return x;if(!i.some((e=>!!e.requiresSiblings))){if(1===o)return i[0];const e=function(e,t){let o;for(let r=0,s=i.length;r<s;r++){const s=i[r](e,t);if("string"==typeof s)return s;(0,n.isThenable)(s)&&(o||(o=[]),o.push(s))}return o?(async()=>{for(const e of o){const t=await e;if("string"==typeof t)return t}return null})():null},t=i.find((e=>!!e.allBasenames));t&&(e.allBasenames=t.allBasenames);const r=i.reduce(((e,t)=>t.allPaths?e.concat(t.allPaths):e),[]);return r.length&&(e.allPaths=r),e}const r=function(e,t,o){let r,a;for(let l=0,c=i.length;l<c;l++){const c=i[l];c.requiresSiblings&&o&&(t||(t=(0,s.basename)(e)),r||(r=t.substr(0,t.length-(0,s.extname)(e).length)));const d=c(e,t,r,o);if("string"==typeof d)return d;(0,n.isThenable)(d)&&(a||(a=[]),a.push(d))}return a?(async()=>{for(const e of a){const t=await e;if("string"==typeof t)return t}return null})():null},a=i.find((e=>!!e.allBasenames));a&&(r.allBasenames=a.allBasenames);const l=i.reduce(((e,t)=>t.allPaths?e.concat(t.allPaths):e),[]);l.length&&(r.allPaths=l);return r}(e,t)}function M(e){const t=e;return!!t&&("string"==typeof t.base&&"string"==typeof t.pattern)}function N(e,t){const i=e.filter((e=>!!e.basenames));if(i.length<2)return e;const n=i.reduce(((e,t)=>{const i=t.basenames;return i?e.concat(i):e}),[]);let o;if(t){o=[];for(let e=0,i=n.length;e<i;e++)o.push(t)}else o=i.reduce(((e,t)=>{const i=t.patterns;return i?e.concat(i):e}),[]);const r=function(e,t){if("string"!=typeof e)return null;if(!t){let i;for(i=e.length;i>0;i--){const t=e.charCodeAt(i-1);if(47===t||92===t)break}t=e.substr(i)}const i=n.indexOf(t);return-1!==i?o[i]:null};r.basenames=n,r.patterns=o,r.allBasenames=n;const s=e.filter((e=>!e.basenames));return s.push(r),s}},23829:function(e,t,i){"use strict";i.r(t),i.d(t,{StringSHA1:function(){return u},doHash:function(){return r},hash:function(){return o},numberHash:function(){return s},stringHash:function(){return a},toHexString:function(){return d}});var n=i(91482);function o(e){return r(e,0)}function r(e,t){switch(typeof e){case"object":return null===e?s(349,t):Array.isArray(e)?(i=e,n=s(104579,n=t),i.reduce(((e,t)=>r(t,e)),n)):function(e,t){return t=s(181387,t),Object.keys(e).sort().reduce(((t,i)=>(t=a(i,t),r(e[i],t))),t)}(e,t);case"string":return a(e,t);case"boolean":return function(e,t){return s(e?433:863,t)}(e,t);case"number":return s(e,t);case"undefined":return s(937,t);default:return s(617,t)}var i,n}function s(e,t){return(t<<5)-t+e|0}function a(e,t){t=s(149417,t);for(let i=0,n=e.length;i<n;i++)t=s(e.charCodeAt(i),t);return t}function l(e,t,i=32){const n=i-t;return(e<<t|(~((1<<n)-1)&e)>>>n)>>>0}function c(e,t=0,i=e.byteLength,n=0){for(let o=0;o<i;o++)e[t+o]=n}function d(e,t=32){return e instanceof ArrayBuffer?Array.from(new Uint8Array(e)).map((e=>e.toString(16).padStart(2,"0"))).join(""):function(e,t,i="0"){for(;e.length<t;)e=i+e;return e}((e>>>0).toString(16),t/4)}class u{constructor(){this._h0=1732584193,this._h1=4023233417,this._h2=2562383102,this._h3=271733878,this._h4=3285377520,this._buff=new Uint8Array(67),this._buffDV=new DataView(this._buff.buffer),this._buffLen=0,this._totalLen=0,this._leftoverHighSurrogate=0,this._finished=!1}update(e){const t=e.length;if(0===t)return;const i=this._buff;let o,r,s=this._buffLen,a=this._leftoverHighSurrogate;for(0!==a?(o=a,r=-1,a=0):(o=e.charCodeAt(0),r=0);;){let l=o;if(n.isHighSurrogate(o)){if(!(r+1<t)){a=o;break}{const t=e.charCodeAt(r+1);n.isLowSurrogate(t)?(r++,l=n.computeCodePoint(o,t)):l=65533}}else n.isLowSurrogate(o)&&(l=65533);if(s=this._push(i,s,l),r++,!(r<t))break;o=e.charCodeAt(r)}this._buffLen=s,this._leftoverHighSurrogate=a}_push(e,t,i){return i<128?e[t++]=i:i<2048?(e[t++]=192|(1984&i)>>>6,e[t++]=128|(63&i)>>>0):i<65536?(e[t++]=224|(61440&i)>>>12,e[t++]=128|(4032&i)>>>6,e[t++]=128|(63&i)>>>0):(e[t++]=240|(1835008&i)>>>18,e[t++]=128|(258048&i)>>>12,e[t++]=128|(4032&i)>>>6,e[t++]=128|(63&i)>>>0),t>=64&&(this._step(),t-=64,this._totalLen+=64,e[0]=e[64],e[1]=e[65],e[2]=e[66]),t}digest(){return this._finished||(this._finished=!0,this._leftoverHighSurrogate&&(this._leftoverHighSurrogate=0,this._buffLen=this._push(this._buff,this._buffLen,65533)),this._totalLen+=this._buffLen,this._wrapUp()),d(this._h0)+d(this._h1)+d(this._h2)+d(this._h3)+d(this._h4)}_wrapUp(){this._buff[this._buffLen++]=128,c(this._buff,this._buffLen),this._buffLen>56&&(this._step(),c(this._buff));const e=8*this._totalLen;this._buffDV.setUint32(56,Math.floor(e/4294967296),!1),this._buffDV.setUint32(60,e%4294967296,!1),this._step()}_step(){const e=u._bigBlock32,t=this._buffDV;for(let i=0;i<64;i+=4)e.setUint32(i,t.getUint32(i,!1),!1);for(let t=64;t<320;t+=4)e.setUint32(t,l(e.getUint32(t-12,!1)^e.getUint32(t-32,!1)^e.getUint32(t-56,!1)^e.getUint32(t-64,!1),1),!1);let i,n,o,r=this._h0,s=this._h1,a=this._h2,c=this._h3,d=this._h4;for(let t=0;t<80;t++)t<20?(i=s&a|~s&c,n=1518500249):t<40?(i=s^a^c,n=1859775393):t<60?(i=s&a|s&c|a&c,n=2400959708):(i=s^a^c,n=3395469782),o=l(r,5)+i+d+n+e.getUint32(4*t,!1)&4294967295,d=c,c=a,a=l(s,30),s=r,r=o;this._h0=this._h0+r&4294967295,this._h1=this._h1+s&4294967295,this._h2=this._h2+a&4294967295,this._h3=this._h3+c&4294967295,this._h4=this._h4+d&4294967295}}u._bigBlock32=new DataView(new ArrayBuffer(320))},68538:function(e,t,i){"use strict";i.r(t),i.d(t,{HistoryNavigator:function(){return o}});var n=i(27582);class o{constructor(e=[],t=10){this._initialize(e),this._limit=t,this._onChange()}getHistory(){return this._elements}add(e){this._history.delete(e),this._history.add(e),this._onChange()}next(){return this._navigator.next()}previous(){return 0!==this._currentPosition()?this._navigator.previous():null}current(){return this._navigator.current()}first(){return this._navigator.first()}last(){return this._navigator.last()}isLast(){return this._currentPosition()>=this._elements.length-1}isNowhere(){return null===this._navigator.current()}has(e){return this._history.has(e)}_onChange(){this._reduceToLimit();const e=this._elements;this._navigator=new n.ArrayNavigator(e,0,e.length,e.length)}_reduceToLimit(){const e=this._elements;e.length>this._limit&&this._initialize(e.slice(e.length-this._limit))}_currentPosition(){const e=this._navigator.current();return e?this._elements.indexOf(e):-1}_initialize(e){this._history=new Set;for(const t of e)this._history.add(t)}get _elements(){const e=[];return this._history.forEach((t=>e.push(t))),e}}},27752:function(e,t,i){"use strict";i.r(t),i.d(t,{isHotReloadEnabled:function(){return o},registerHotReloadHandler:function(){return r}});var n=i(63953);function o(){return n.env&&!!n.env.VSCODE_DEV}function r(e){if(o()){const t=function(){s||(s=new Set);const e=globalThis;e.$hotReload_applyNewExports||(e.$hotReload_applyNewExports=e=>{for(const t of s){const i=t(e);if(i)return i}});return s}();return t.add(e),{dispose(){t.delete(e)}}}return{dispose(){}}}let s;o()&&r((({oldExports:e,newSrc:t})=>{if(-1!==t.indexOf("/* hot-reload:patch-prototype-methods */"))return t=>{var i,n;for(const o in t){const r=t[o];if(console.log(`[hot-reload] Patching prototype methods of '${o}'`,{exportedItem:r}),"function"==typeof r&&r.prototype){const s=e[o];if(s){for(const e of Object.getOwnPropertyNames(r.prototype)){const t=Object.getOwnPropertyDescriptor(r.prototype,e),a=Object.getOwnPropertyDescriptor(s.prototype,e);(null===(i=null==t?void 0:t.value)||void 0===i?void 0:i.toString())!==(null===(n=null==a?void 0:a.value)||void 0===n?void 0:n.toString())&&console.log(`[hot-reload] Patching prototype method '${o}.${e}'`),Object.defineProperty(s.prototype,e,t)}t[o]=s}}}return!0}}))},25674:function(e,t,i){"use strict";i.r(t),i.d(t,{MarkdownString:function(){return l},escapeDoubleQuotes:function(){return g},escapeMarkdownSyntaxTokens:function(){return h},isEmptyMarkdownString:function(){return c},isMarkdownString:function(){return d},markdownStringEqual:function(){return u},parseHrefAndDimensions:function(){return m},removeMarkdownEscapes:function(){return p}});var n=i(12718),o=i(69373),r=i(50552),s=i(91482),a=i(19300);class l{constructor(e="",t=!1){var i,o,r;if(this.value=e,"string"!=typeof this.value)throw(0,n.illegalArgument)("value");"boolean"==typeof t?(this.isTrusted=t,this.supportThemeIcons=!1,this.supportHtml=!1):(this.isTrusted=null!==(i=t.isTrusted)&&void 0!==i?i:void 0,this.supportThemeIcons=null!==(o=t.supportThemeIcons)&&void 0!==o&&o,this.supportHtml=null!==(r=t.supportHtml)&&void 0!==r&&r)}appendText(e,t=0){return this.value+=h(this.supportThemeIcons?(0,o.escapeIcons)(e):e).replace(/([ \t]+)/g,((e,t)=>"&nbsp;".repeat(t.length))).replace(/\>/gm,"\\>").replace(/\n/g,1===t?"\\\n":"\n\n"),this}appendMarkdown(e){return this.value+=e,this}appendCodeblock(e,t){return this.value+="\n```",this.value+=e,this.value+="\n",this.value+=t,this.value+="\n```\n",this}appendLink(e,t,i){return this.value+="[",this.value+=this._escape(t,"]"),this.value+="](",this.value+=this._escape(String(e),")"),i&&(this.value+=` "${this._escape(this._escape(i,'"'),")")}"`),this.value+=")",this}_escape(e,t){const i=new RegExp((0,s.escapeRegExpCharacters)(t),"g");return e.replace(i,((t,i)=>"\\"!==e.charAt(i-1)?`\\${t}`:t))}}function c(e){return d(e)?!e.value:!Array.isArray(e)||e.every(c)}function d(e){return e instanceof l||!(!e||"object"!=typeof e)&&!("string"!=typeof e.value||"boolean"!=typeof e.isTrusted&&"object"!=typeof e.isTrusted&&void 0!==e.isTrusted||"boolean"!=typeof e.supportThemeIcons&&void 0!==e.supportThemeIcons)}function u(e,t){return e===t||!(!e||!t)&&(e.value===t.value&&e.isTrusted===t.isTrusted&&e.supportThemeIcons===t.supportThemeIcons&&e.supportHtml===t.supportHtml&&(e.baseUri===t.baseUri||!!e.baseUri&&!!t.baseUri&&(0,r.isEqual)(a.URI.from(e.baseUri),a.URI.from(t.baseUri))))}function h(e){return e.replace(/[\\`*_{}[\]()#+\-!~]/g,"\\$&")}function g(e){return e.replace(/"/g,"&quot;")}function p(e){return e?e.replace(/\\([\\`*_{}[\]()#+\-.!~])/g,"$1"):e}function m(e){const t=[],i=e.split("|").map((e=>e.trim()));e=i[0];const n=i[1];if(n){const e=/height=(\d+)/.exec(n),i=/width=(\d+)/.exec(n),o=e?e[1]:"",r=i?i[1]:"",s=isFinite(parseInt(r)),a=isFinite(parseInt(o));s&&t.push(`width="${r}"`),a&&t.push(`height="${o}"`)}return{href:e,dimensions:t}}},69373:function(e,t,i){"use strict";i.r(t),i.d(t,{escapeIcons:function(){return c},getCodiconAriaLabel:function(){return p},markdownEscapeEscapedIcons:function(){return u},matchesFuzzyIconAware:function(){return b},parseLabelWithIcons:function(){return f},stripIcons:function(){return g}});var n=i(27017),o=i(91482),r=i(27269);const s="$(",a=new RegExp(`\\$\\(${r.ThemeIcon.iconNameExpression}(?:${r.ThemeIcon.iconModifierExpression})?\\)`,"g"),l=new RegExp(`(\\\\)?${a.source}`,"g");function c(e){return e.replace(l,((e,t)=>t?e:`\\${e}`))}const d=new RegExp(`\\\\${a.source}`,"g");function u(e){return e.replace(d,(e=>`\\${e}`))}const h=new RegExp(`(\\s)?(\\\\)?${a.source}(\\s)?`,"g");function g(e){return-1===e.indexOf(s)?e:e.replace(h,((e,t,i,n)=>i?e:t||n||""))}function p(e){return e?e.replace(/\$\((.*?)\)/g,((e,t)=>` ${t} `)).trim():""}const m=new RegExp(`\\$\\(${r.ThemeIcon.iconNameCharacter}+\\)`,"g");function f(e){m.lastIndex=0;let t="";const i=[];let n=0;for(;;){const o=m.lastIndex,r=m.exec(e),s=e.substring(o,null==r?void 0:r.index);if(s.length>0){t+=s;for(let e=0;e<s.length;e++)i.push(n)}if(!r)break;n+=r[0].length}return{text:t,iconOffsets:i}}function b(e,t,i=!1){const{text:r,iconOffsets:s}=t;if(!s||0===s.length)return(0,n.matchesFuzzy)(e,r,i);const a=(0,o.ltrim)(r," "),l=r.length-a.length,c=(0,n.matchesFuzzy)(e,a,i);if(c)for(const e of c){const t=s[e.start+l]+l;e.start+=t,e.end+=t}return c}},60538:function(e,t,i){"use strict";i.r(t),i.d(t,{IdGenerator:function(){return n},defaultGenerator:function(){return o}});class n{constructor(e){this._prefix=e,this._lastId=0}nextId(){return this._prefix+ ++this._lastId}}const o=new n("id#")},45564:function(e,t,i){"use strict";i.r(t),i.d(t,{IME:function(){return r},IMEImpl:function(){return o}});var n=i(63801);class o{constructor(){this._onDidChange=new n.Emitter,this.onDidChange=this._onDidChange.event,this._enabled=!0}get enabled(){return this._enabled}enable(){this._enabled=!0,this._onDidChange.fire()}disable(){this._enabled=!1,this._onDidChange.fire()}}const r=new o},24417:function(e,t,i){"use strict";var n;i.r(t),i.d(t,{Iterable:function(){return n}}),function(e){function t(e){return e&&"object"==typeof e&&"function"==typeof e[Symbol.iterator]}e.is=t;const i=Object.freeze([]);function*n(e){yield e}e.empty=function(){return i},e.single=n,e.wrap=function(e){return t(e)?e:n(e)},e.from=function(e){return e||i},e.reverse=function*(e){for(let t=e.length-1;t>=0;t--)yield e[t]},e.isEmpty=function(e){return!e||!0===e[Symbol.iterator]().next().done},e.first=function(e){return e[Symbol.iterator]().next().value},e.some=function(e,t){for(const i of e)if(t(i))return!0;return!1},e.find=function(e,t){for(const i of e)if(t(i))return i},e.filter=function*(e,t){for(const i of e)t(i)&&(yield i)},e.map=function*(e,t){let i=0;for(const n of e)yield t(n,i++)},e.concat=function*(...e){for(const t of e)yield*t},e.reduce=function(e,t,i){let n=i;for(const i of e)n=t(n,i);return n},e.slice=function*(e,t,i=e.length){for(t<0&&(t+=e.length),i<0?i+=e.length:i>e.length&&(i=e.length);t<i;t++)yield e[t]},e.consume=function(t,i=Number.POSITIVE_INFINITY){const n=[];if(0===i)return[n,t];const o=t[Symbol.iterator]();for(let t=0;t<i;t++){const t=o.next();if(t.done)return[n,e.empty()];n.push(t.value)}return[n,{[Symbol.iterator](){return o}}]}}(n||(n={}))},98070:function(e,t,i){"use strict";i.r(t),i.d(t,{EVENT_KEY_CODE_MAP:function(){return a},IMMUTABLE_CODE_TO_KEY_CODE:function(){return h},IMMUTABLE_KEY_CODE_TO_CODE:function(){return g},KeyChord:function(){return m},KeyCodeUtils:function(){return p},NATIVE_WINDOWS_KEY_CODE_TO_KEY_CODE:function(){return l}});class n{constructor(){this._keyCodeToStr=[],this._strToKeyCode=Object.create(null)}define(e,t){this._keyCodeToStr[e]=t,this._strToKeyCode[t.toLowerCase()]=e}keyCodeToStr(e){return this._keyCodeToStr[e]}strToKeyCode(e){return this._strToKeyCode[e.toLowerCase()]||0}}const o=new n,r=new n,s=new n,a=new Array(230),l={},c=[],d=Object.create(null),u=Object.create(null),h=[],g=[];for(let e=0;e<=193;e++)h[e]=-1;for(let e=0;e<=132;e++)g[e]=-1;var p;function m(e,t){return(e|(65535&t)<<16>>>0)>>>0}!function(){const e="",t=[[1,0,"None",0,"unknown",0,"VK_UNKNOWN",e,e],[1,1,"Hyper",0,e,0,e,e,e],[1,2,"Super",0,e,0,e,e,e],[1,3,"Fn",0,e,0,e,e,e],[1,4,"FnLock",0,e,0,e,e,e],[1,5,"Suspend",0,e,0,e,e,e],[1,6,"Resume",0,e,0,e,e,e],[1,7,"Turbo",0,e,0,e,e,e],[1,8,"Sleep",0,e,0,"VK_SLEEP",e,e],[1,9,"WakeUp",0,e,0,e,e,e],[0,10,"KeyA",31,"A",65,"VK_A",e,e],[0,11,"KeyB",32,"B",66,"VK_B",e,e],[0,12,"KeyC",33,"C",67,"VK_C",e,e],[0,13,"KeyD",34,"D",68,"VK_D",e,e],[0,14,"KeyE",35,"E",69,"VK_E",e,e],[0,15,"KeyF",36,"F",70,"VK_F",e,e],[0,16,"KeyG",37,"G",71,"VK_G",e,e],[0,17,"KeyH",38,"H",72,"VK_H",e,e],[0,18,"KeyI",39,"I",73,"VK_I",e,e],[0,19,"KeyJ",40,"J",74,"VK_J",e,e],[0,20,"KeyK",41,"K",75,"VK_K",e,e],[0,21,"KeyL",42,"L",76,"VK_L",e,e],[0,22,"KeyM",43,"M",77,"VK_M",e,e],[0,23,"KeyN",44,"N",78,"VK_N",e,e],[0,24,"KeyO",45,"O",79,"VK_O",e,e],[0,25,"KeyP",46,"P",80,"VK_P",e,e],[0,26,"KeyQ",47,"Q",81,"VK_Q",e,e],[0,27,"KeyR",48,"R",82,"VK_R",e,e],[0,28,"KeyS",49,"S",83,"VK_S",e,e],[0,29,"KeyT",50,"T",84,"VK_T",e,e],[0,30,"KeyU",51,"U",85,"VK_U",e,e],[0,31,"KeyV",52,"V",86,"VK_V",e,e],[0,32,"KeyW",53,"W",87,"VK_W",e,e],[0,33,"KeyX",54,"X",88,"VK_X",e,e],[0,34,"KeyY",55,"Y",89,"VK_Y",e,e],[0,35,"KeyZ",56,"Z",90,"VK_Z",e,e],[0,36,"Digit1",22,"1",49,"VK_1",e,e],[0,37,"Digit2",23,"2",50,"VK_2",e,e],[0,38,"Digit3",24,"3",51,"VK_3",e,e],[0,39,"Digit4",25,"4",52,"VK_4",e,e],[0,40,"Digit5",26,"5",53,"VK_5",e,e],[0,41,"Digit6",27,"6",54,"VK_6",e,e],[0,42,"Digit7",28,"7",55,"VK_7",e,e],[0,43,"Digit8",29,"8",56,"VK_8",e,e],[0,44,"Digit9",30,"9",57,"VK_9",e,e],[0,45,"Digit0",21,"0",48,"VK_0",e,e],[1,46,"Enter",3,"Enter",13,"VK_RETURN",e,e],[1,47,"Escape",9,"Escape",27,"VK_ESCAPE",e,e],[1,48,"Backspace",1,"Backspace",8,"VK_BACK",e,e],[1,49,"Tab",2,"Tab",9,"VK_TAB",e,e],[1,50,"Space",10,"Space",32,"VK_SPACE",e,e],[0,51,"Minus",88,"-",189,"VK_OEM_MINUS","-","OEM_MINUS"],[0,52,"Equal",86,"=",187,"VK_OEM_PLUS","=","OEM_PLUS"],[0,53,"BracketLeft",92,"[",219,"VK_OEM_4","[","OEM_4"],[0,54,"BracketRight",94,"]",221,"VK_OEM_6","]","OEM_6"],[0,55,"Backslash",93,"\\",220,"VK_OEM_5","\\","OEM_5"],[0,56,"IntlHash",0,e,0,e,e,e],[0,57,"Semicolon",85,";",186,"VK_OEM_1",";","OEM_1"],[0,58,"Quote",95,"'",222,"VK_OEM_7","'","OEM_7"],[0,59,"Backquote",91,"`",192,"VK_OEM_3","`","OEM_3"],[0,60,"Comma",87,",",188,"VK_OEM_COMMA",",","OEM_COMMA"],[0,61,"Period",89,".",190,"VK_OEM_PERIOD",".","OEM_PERIOD"],[0,62,"Slash",90,"/",191,"VK_OEM_2","/","OEM_2"],[1,63,"CapsLock",8,"CapsLock",20,"VK_CAPITAL",e,e],[1,64,"F1",59,"F1",112,"VK_F1",e,e],[1,65,"F2",60,"F2",113,"VK_F2",e,e],[1,66,"F3",61,"F3",114,"VK_F3",e,e],[1,67,"F4",62,"F4",115,"VK_F4",e,e],[1,68,"F5",63,"F5",116,"VK_F5",e,e],[1,69,"F6",64,"F6",117,"VK_F6",e,e],[1,70,"F7",65,"F7",118,"VK_F7",e,e],[1,71,"F8",66,"F8",119,"VK_F8",e,e],[1,72,"F9",67,"F9",120,"VK_F9",e,e],[1,73,"F10",68,"F10",121,"VK_F10",e,e],[1,74,"F11",69,"F11",122,"VK_F11",e,e],[1,75,"F12",70,"F12",123,"VK_F12",e,e],[1,76,"PrintScreen",0,e,0,e,e,e],[1,77,"ScrollLock",84,"ScrollLock",145,"VK_SCROLL",e,e],[1,78,"Pause",7,"PauseBreak",19,"VK_PAUSE",e,e],[1,79,"Insert",19,"Insert",45,"VK_INSERT",e,e],[1,80,"Home",14,"Home",36,"VK_HOME",e,e],[1,81,"PageUp",11,"PageUp",33,"VK_PRIOR",e,e],[1,82,"Delete",20,"Delete",46,"VK_DELETE",e,e],[1,83,"End",13,"End",35,"VK_END",e,e],[1,84,"PageDown",12,"PageDown",34,"VK_NEXT",e,e],[1,85,"ArrowRight",17,"RightArrow",39,"VK_RIGHT","Right",e],[1,86,"ArrowLeft",15,"LeftArrow",37,"VK_LEFT","Left",e],[1,87,"ArrowDown",18,"DownArrow",40,"VK_DOWN","Down",e],[1,88,"ArrowUp",16,"UpArrow",38,"VK_UP","Up",e],[1,89,"NumLock",83,"NumLock",144,"VK_NUMLOCK",e,e],[1,90,"NumpadDivide",113,"NumPad_Divide",111,"VK_DIVIDE",e,e],[1,91,"NumpadMultiply",108,"NumPad_Multiply",106,"VK_MULTIPLY",e,e],[1,92,"NumpadSubtract",111,"NumPad_Subtract",109,"VK_SUBTRACT",e,e],[1,93,"NumpadAdd",109,"NumPad_Add",107,"VK_ADD",e,e],[1,94,"NumpadEnter",3,e,0,e,e,e],[1,95,"Numpad1",99,"NumPad1",97,"VK_NUMPAD1",e,e],[1,96,"Numpad2",100,"NumPad2",98,"VK_NUMPAD2",e,e],[1,97,"Numpad3",101,"NumPad3",99,"VK_NUMPAD3",e,e],[1,98,"Numpad4",102,"NumPad4",100,"VK_NUMPAD4",e,e],[1,99,"Numpad5",103,"NumPad5",101,"VK_NUMPAD5",e,e],[1,100,"Numpad6",104,"NumPad6",102,"VK_NUMPAD6",e,e],[1,101,"Numpad7",105,"NumPad7",103,"VK_NUMPAD7",e,e],[1,102,"Numpad8",106,"NumPad8",104,"VK_NUMPAD8",e,e],[1,103,"Numpad9",107,"NumPad9",105,"VK_NUMPAD9",e,e],[1,104,"Numpad0",98,"NumPad0",96,"VK_NUMPAD0",e,e],[1,105,"NumpadDecimal",112,"NumPad_Decimal",110,"VK_DECIMAL",e,e],[0,106,"IntlBackslash",97,"OEM_102",226,"VK_OEM_102",e,e],[1,107,"ContextMenu",58,"ContextMenu",93,e,e,e],[1,108,"Power",0,e,0,e,e,e],[1,109,"NumpadEqual",0,e,0,e,e,e],[1,110,"F13",71,"F13",124,"VK_F13",e,e],[1,111,"F14",72,"F14",125,"VK_F14",e,e],[1,112,"F15",73,"F15",126,"VK_F15",e,e],[1,113,"F16",74,"F16",127,"VK_F16",e,e],[1,114,"F17",75,"F17",128,"VK_F17",e,e],[1,115,"F18",76,"F18",129,"VK_F18",e,e],[1,116,"F19",77,"F19",130,"VK_F19",e,e],[1,117,"F20",78,"F20",131,"VK_F20",e,e],[1,118,"F21",79,"F21",132,"VK_F21",e,e],[1,119,"F22",80,"F22",133,"VK_F22",e,e],[1,120,"F23",81,"F23",134,"VK_F23",e,e],[1,121,"F24",82,"F24",135,"VK_F24",e,e],[1,122,"Open",0,e,0,e,e,e],[1,123,"Help",0,e,0,e,e,e],[1,124,"Select",0,e,0,e,e,e],[1,125,"Again",0,e,0,e,e,e],[1,126,"Undo",0,e,0,e,e,e],[1,127,"Cut",0,e,0,e,e,e],[1,128,"Copy",0,e,0,e,e,e],[1,129,"Paste",0,e,0,e,e,e],[1,130,"Find",0,e,0,e,e,e],[1,131,"AudioVolumeMute",117,"AudioVolumeMute",173,"VK_VOLUME_MUTE",e,e],[1,132,"AudioVolumeUp",118,"AudioVolumeUp",175,"VK_VOLUME_UP",e,e],[1,133,"AudioVolumeDown",119,"AudioVolumeDown",174,"VK_VOLUME_DOWN",e,e],[1,134,"NumpadComma",110,"NumPad_Separator",108,"VK_SEPARATOR",e,e],[0,135,"IntlRo",115,"ABNT_C1",193,"VK_ABNT_C1",e,e],[1,136,"KanaMode",0,e,0,e,e,e],[0,137,"IntlYen",0,e,0,e,e,e],[1,138,"Convert",0,e,0,e,e,e],[1,139,"NonConvert",0,e,0,e,e,e],[1,140,"Lang1",0,e,0,e,e,e],[1,141,"Lang2",0,e,0,e,e,e],[1,142,"Lang3",0,e,0,e,e,e],[1,143,"Lang4",0,e,0,e,e,e],[1,144,"Lang5",0,e,0,e,e,e],[1,145,"Abort",0,e,0,e,e,e],[1,146,"Props",0,e,0,e,e,e],[1,147,"NumpadParenLeft",0,e,0,e,e,e],[1,148,"NumpadParenRight",0,e,0,e,e,e],[1,149,"NumpadBackspace",0,e,0,e,e,e],[1,150,"NumpadMemoryStore",0,e,0,e,e,e],[1,151,"NumpadMemoryRecall",0,e,0,e,e,e],[1,152,"NumpadMemoryClear",0,e,0,e,e,e],[1,153,"NumpadMemoryAdd",0,e,0,e,e,e],[1,154,"NumpadMemorySubtract",0,e,0,e,e,e],[1,155,"NumpadClear",131,"Clear",12,"VK_CLEAR",e,e],[1,156,"NumpadClearEntry",0,e,0,e,e,e],[1,0,e,5,"Ctrl",17,"VK_CONTROL",e,e],[1,0,e,4,"Shift",16,"VK_SHIFT",e,e],[1,0,e,6,"Alt",18,"VK_MENU",e,e],[1,0,e,57,"Meta",91,"VK_COMMAND",e,e],[1,157,"ControlLeft",5,e,0,"VK_LCONTROL",e,e],[1,158,"ShiftLeft",4,e,0,"VK_LSHIFT",e,e],[1,159,"AltLeft",6,e,0,"VK_LMENU",e,e],[1,160,"MetaLeft",57,e,0,"VK_LWIN",e,e],[1,161,"ControlRight",5,e,0,"VK_RCONTROL",e,e],[1,162,"ShiftRight",4,e,0,"VK_RSHIFT",e,e],[1,163,"AltRight",6,e,0,"VK_RMENU",e,e],[1,164,"MetaRight",57,e,0,"VK_RWIN",e,e],[1,165,"BrightnessUp",0,e,0,e,e,e],[1,166,"BrightnessDown",0,e,0,e,e,e],[1,167,"MediaPlay",0,e,0,e,e,e],[1,168,"MediaRecord",0,e,0,e,e,e],[1,169,"MediaFastForward",0,e,0,e,e,e],[1,170,"MediaRewind",0,e,0,e,e,e],[1,171,"MediaTrackNext",124,"MediaTrackNext",176,"VK_MEDIA_NEXT_TRACK",e,e],[1,172,"MediaTrackPrevious",125,"MediaTrackPrevious",177,"VK_MEDIA_PREV_TRACK",e,e],[1,173,"MediaStop",126,"MediaStop",178,"VK_MEDIA_STOP",e,e],[1,174,"Eject",0,e,0,e,e,e],[1,175,"MediaPlayPause",127,"MediaPlayPause",179,"VK_MEDIA_PLAY_PAUSE",e,e],[1,176,"MediaSelect",128,"LaunchMediaPlayer",181,"VK_MEDIA_LAUNCH_MEDIA_SELECT",e,e],[1,177,"LaunchMail",129,"LaunchMail",180,"VK_MEDIA_LAUNCH_MAIL",e,e],[1,178,"LaunchApp2",130,"LaunchApp2",183,"VK_MEDIA_LAUNCH_APP2",e,e],[1,179,"LaunchApp1",0,e,0,"VK_MEDIA_LAUNCH_APP1",e,e],[1,180,"SelectTask",0,e,0,e,e,e],[1,181,"LaunchScreenSaver",0,e,0,e,e,e],[1,182,"BrowserSearch",120,"BrowserSearch",170,"VK_BROWSER_SEARCH",e,e],[1,183,"BrowserHome",121,"BrowserHome",172,"VK_BROWSER_HOME",e,e],[1,184,"BrowserBack",122,"BrowserBack",166,"VK_BROWSER_BACK",e,e],[1,185,"BrowserForward",123,"BrowserForward",167,"VK_BROWSER_FORWARD",e,e],[1,186,"BrowserStop",0,e,0,"VK_BROWSER_STOP",e,e],[1,187,"BrowserRefresh",0,e,0,"VK_BROWSER_REFRESH",e,e],[1,188,"BrowserFavorites",0,e,0,"VK_BROWSER_FAVORITES",e,e],[1,189,"ZoomToggle",0,e,0,e,e,e],[1,190,"MailReply",0,e,0,e,e,e],[1,191,"MailForward",0,e,0,e,e,e],[1,192,"MailSend",0,e,0,e,e,e],[1,0,e,114,"KeyInComposition",229,e,e,e],[1,0,e,116,"ABNT_C2",194,"VK_ABNT_C2",e,e],[1,0,e,96,"OEM_8",223,"VK_OEM_8",e,e],[1,0,e,0,e,0,"VK_KANA",e,e],[1,0,e,0,e,0,"VK_HANGUL",e,e],[1,0,e,0,e,0,"VK_JUNJA",e,e],[1,0,e,0,e,0,"VK_FINAL",e,e],[1,0,e,0,e,0,"VK_HANJA",e,e],[1,0,e,0,e,0,"VK_KANJI",e,e],[1,0,e,0,e,0,"VK_CONVERT",e,e],[1,0,e,0,e,0,"VK_NONCONVERT",e,e],[1,0,e,0,e,0,"VK_ACCEPT",e,e],[1,0,e,0,e,0,"VK_MODECHANGE",e,e],[1,0,e,0,e,0,"VK_SELECT",e,e],[1,0,e,0,e,0,"VK_PRINT",e,e],[1,0,e,0,e,0,"VK_EXECUTE",e,e],[1,0,e,0,e,0,"VK_SNAPSHOT",e,e],[1,0,e,0,e,0,"VK_HELP",e,e],[1,0,e,0,e,0,"VK_APPS",e,e],[1,0,e,0,e,0,"VK_PROCESSKEY",e,e],[1,0,e,0,e,0,"VK_PACKET",e,e],[1,0,e,0,e,0,"VK_DBE_SBCSCHAR",e,e],[1,0,e,0,e,0,"VK_DBE_DBCSCHAR",e,e],[1,0,e,0,e,0,"VK_ATTN",e,e],[1,0,e,0,e,0,"VK_CRSEL",e,e],[1,0,e,0,e,0,"VK_EXSEL",e,e],[1,0,e,0,e,0,"VK_EREOF",e,e],[1,0,e,0,e,0,"VK_PLAY",e,e],[1,0,e,0,e,0,"VK_ZOOM",e,e],[1,0,e,0,e,0,"VK_NONAME",e,e],[1,0,e,0,e,0,"VK_PA1",e,e],[1,0,e,0,e,0,"VK_OEM_CLEAR",e,e]],i=[],n=[];for(const e of t){const[t,p,m,f,b,v,_,A,C]=e;if(n[p]||(n[p]=!0,c[p]=m,d[m]=p,u[m.toLowerCase()]=p,t&&(h[p]=f,0!==f&&3!==f&&5!==f&&4!==f&&6!==f&&57!==f&&(g[f]=p))),!i[f]){if(i[f]=!0,!b)throw new Error(`String representation missing for key code ${f} around scan code ${m}`);o.define(f,b),r.define(f,A||b),s.define(f,C||A||b)}v&&(a[v]=f),_&&(l[_]=f)}g[3]=46}(),function(e){e.toString=function(e){return o.keyCodeToStr(e)},e.fromString=function(e){return o.strToKeyCode(e)},e.toUserSettingsUS=function(e){return r.keyCodeToStr(e)},e.toUserSettingsGeneral=function(e){return s.keyCodeToStr(e)},e.fromUserSettings=function(e){return r.strToKeyCode(e)||s.strToKeyCode(e)},e.toElectronAccelerator=function(e){if(e>=98&&e<=113)return null;switch(e){case 16:return"Up";case 18:return"Down";case 15:return"Left";case 17:return"Right"}return o.keyCodeToStr(e)}}(p||(p={}))},20693:function(e,t,i){"use strict";i.r(t),i.d(t,{AriaLabelProvider:function(){return s},ElectronAcceleratorLabelProvider:function(){return a},ModifierLabelProvider:function(){return o},UILabelProvider:function(){return r},UserSettingsLabelProvider:function(){return l}});var n=i(83787);class o{constructor(e,t,i=t){this.modifierLabels=[null],this.modifierLabels[2]=e,this.modifierLabels[1]=t,this.modifierLabels[3]=i}toLabel(e,t,i){if(0===t.length)return null;const n=[];for(let o=0,r=t.length;o<r;o++){const r=t[o],s=i(r);if(null===s)return null;n[o]=c(r,s,this.modifierLabels[e])}return n.join(" ")}}const r=new o({ctrlKey:"⌃",shiftKey:"⇧",altKey:"⌥",metaKey:"⌘",separator:""},{ctrlKey:n.localize("vs/base/common/keybindingLabels",{key:"ctrlKey",comment:["This is the short form for the Control key on the keyboard"]},"Ctrl"),shiftKey:n.localize("vs/base/common/keybindingLabels",{key:"shiftKey",comment:["This is the short form for the Shift key on the keyboard"]},"Shift"),altKey:n.localize("vs/base/common/keybindingLabels",{key:"altKey",comment:["This is the short form for the Alt key on the keyboard"]},"Alt"),metaKey:n.localize("vs/base/common/keybindingLabels",{key:"windowsKey",comment:["This is the short form for the Windows key on the keyboard"]},"Windows"),separator:"+"},{ctrlKey:n.localize("vs/base/common/keybindingLabels",{key:"ctrlKey",comment:["This is the short form for the Control key on the keyboard"]},"Ctrl"),shiftKey:n.localize("vs/base/common/keybindingLabels",{key:"shiftKey",comment:["This is the short form for the Shift key on the keyboard"]},"Shift"),altKey:n.localize("vs/base/common/keybindingLabels",{key:"altKey",comment:["This is the short form for the Alt key on the keyboard"]},"Alt"),metaKey:n.localize("vs/base/common/keybindingLabels",{key:"superKey",comment:["This is the short form for the Super key on the keyboard"]},"Super"),separator:"+"}),s=new o({ctrlKey:n.localize("vs/base/common/keybindingLabels",{key:"ctrlKey.long",comment:["This is the long form for the Control key on the keyboard"]},"Control"),shiftKey:n.localize("vs/base/common/keybindingLabels",{key:"shiftKey.long",comment:["This is the long form for the Shift key on the keyboard"]},"Shift"),altKey:n.localize("vs/base/common/keybindingLabels",{key:"optKey.long",comment:["This is the long form for the Alt/Option key on the keyboard"]},"Option"),metaKey:n.localize("vs/base/common/keybindingLabels",{key:"cmdKey.long",comment:["This is the long form for the Command key on the keyboard"]},"Command"),separator:"+"},{ctrlKey:n.localize("vs/base/common/keybindingLabels",{key:"ctrlKey.long",comment:["This is the long form for the Control key on the keyboard"]},"Control"),shiftKey:n.localize("vs/base/common/keybindingLabels",{key:"shiftKey.long",comment:["This is the long form for the Shift key on the keyboard"]},"Shift"),altKey:n.localize("vs/base/common/keybindingLabels",{key:"altKey.long",comment:["This is the long form for the Alt key on the keyboard"]},"Alt"),metaKey:n.localize("vs/base/common/keybindingLabels",{key:"windowsKey.long",comment:["This is the long form for the Windows key on the keyboard"]},"Windows"),separator:"+"},{ctrlKey:n.localize("vs/base/common/keybindingLabels",{key:"ctrlKey.long",comment:["This is the long form for the Control key on the keyboard"]},"Control"),shiftKey:n.localize("vs/base/common/keybindingLabels",{key:"shiftKey.long",comment:["This is the long form for the Shift key on the keyboard"]},"Shift"),altKey:n.localize("vs/base/common/keybindingLabels",{key:"altKey.long",comment:["This is the long form for the Alt key on the keyboard"]},"Alt"),metaKey:n.localize("vs/base/common/keybindingLabels",{key:"superKey.long",comment:["This is the long form for the Super key on the keyboard"]},"Super"),separator:"+"}),a=new o({ctrlKey:"Ctrl",shiftKey:"Shift",altKey:"Alt",metaKey:"Cmd",separator:"+"},{ctrlKey:"Ctrl",shiftKey:"Shift",altKey:"Alt",metaKey:"Super",separator:"+"}),l=new o({ctrlKey:"ctrl",shiftKey:"shift",altKey:"alt",metaKey:"cmd",separator:"+"},{ctrlKey:"ctrl",shiftKey:"shift",altKey:"alt",metaKey:"win",separator:"+"},{ctrlKey:"ctrl",shiftKey:"shift",altKey:"alt",metaKey:"meta",separator:"+"});function c(e,t,i){if(null===t)return"";const n=[];return e.ctrlKey&&n.push(i.ctrlKey),e.shiftKey&&n.push(i.shiftKey),e.altKey&&n.push(i.altKey),e.metaKey&&n.push(i.metaKey),""!==t&&n.push(t),n.join(i.separator)}},37345:function(e,t,i){"use strict";i.r(t),i.d(t,{KeyCodeChord:function(){return s},Keybinding:function(){return l},ResolvedChord:function(){return c},ResolvedKeybinding:function(){return d},ScanCodeChord:function(){return a},createSimpleKeybinding:function(){return r},decodeKeybinding:function(){return o}});var n=i(12718);function o(e,t){if("number"==typeof e){if(0===e)return null;const i=(65535&e)>>>0,n=(4294901760&e)>>>16;return new l(0!==n?[r(i,t),r(n,t)]:[r(i,t)])}{const i=[];for(let n=0;n<e.length;n++)i.push(r(e[n],t));return new l(i)}}function r(e,t){const i=!!(2048&e),n=!!(256&e);return new s(2===t?n:i,!!(1024&e),!!(512&e),2===t?i:n,255&e)}class s{constructor(e,t,i,n,o){this.ctrlKey=e,this.shiftKey=t,this.altKey=i,this.metaKey=n,this.keyCode=o}equals(e){return e instanceof s&&this.ctrlKey===e.ctrlKey&&this.shiftKey===e.shiftKey&&this.altKey===e.altKey&&this.metaKey===e.metaKey&&this.keyCode===e.keyCode}isModifierKey(){return 0===this.keyCode||5===this.keyCode||57===this.keyCode||6===this.keyCode||4===this.keyCode}isDuplicateModifierCase(){return this.ctrlKey&&5===this.keyCode||this.shiftKey&&4===this.keyCode||this.altKey&&6===this.keyCode||this.metaKey&&57===this.keyCode}}class a{constructor(e,t,i,n,o){this.ctrlKey=e,this.shiftKey=t,this.altKey=i,this.metaKey=n,this.scanCode=o}isDuplicateModifierCase(){return this.ctrlKey&&(157===this.scanCode||161===this.scanCode)||this.shiftKey&&(158===this.scanCode||162===this.scanCode)||this.altKey&&(159===this.scanCode||163===this.scanCode)||this.metaKey&&(160===this.scanCode||164===this.scanCode)}}class l{constructor(e){if(0===e.length)throw(0,n.illegalArgument)("chords");this.chords=e}}class c{constructor(e,t,i,n,o,r){this.ctrlKey=e,this.shiftKey=t,this.altKey=i,this.metaKey=n,this.keyLabel=o,this.keyAriaLabel=r}}class d{}},5560:function(e,t,i){"use strict";i.r(t),i.d(t,{Lazy:function(){return n}});class n{constructor(e){this.executor=e,this._didRun=!1}get value(){if(!this._didRun)try{this._value=this.executor()}catch(e){this._error=e}finally{this._didRun=!0}if(this._error)throw this._error;return this._value}get rawValue(){return this._value}}},68921:function(e,t,i){"use strict";i.r(t),i.d(t,{Disposable:function(){return f},DisposableMap:function(){return A},DisposableStore:function(){return m},ImmortalReference:function(){return _},MutableDisposable:function(){return b},RefCountedDisposable:function(){return v},combinedDisposable:function(){return g},dispose:function(){return h},isDisposable:function(){return u},markAsDisposed:function(){return l},markAsSingleton:function(){return d},setDisposableTracker:function(){return s},toDisposable:function(){return p},trackDisposable:function(){return a}});var n=i(40548),o=i(24417);let r=null;function s(e){r=e}function a(e){return null==r||r.trackDisposable(e),e}function l(e){null==r||r.markAsDisposed(e)}function c(e,t){null==r||r.setParent(e,t)}function d(e){return null==r||r.markAsSingleton(e),e}function u(e){return"function"==typeof e.dispose&&0===e.dispose.length}function h(e){if(o.Iterable.is(e)){const t=[];for(const i of e)if(i)try{i.dispose()}catch(e){t.push(e)}if(1===t.length)throw t[0];if(t.length>1)throw new AggregateError(t,"Encountered errors while disposing of store");return Array.isArray(e)?[]:e}if(e)return e.dispose(),e}function g(...e){const t=p((()=>h(e)));return function(e,t){if(r)for(const i of e)r.setParent(i,t)}(e,t),t}function p(e){const t=a({dispose:(0,n.createSingleCallFunction)((()=>{l(t),e()}))});return t}class m{constructor(){this._toDispose=new Set,this._isDisposed=!1,a(this)}dispose(){this._isDisposed||(l(this),this._isDisposed=!0,this.clear())}get isDisposed(){return this._isDisposed}clear(){if(0!==this._toDispose.size)try{h(this._toDispose)}finally{this._toDispose.clear()}}add(e){if(!e)return e;if(e===this)throw new Error("Cannot register a disposable on itself!");return c(e,this),this._isDisposed?m.DISABLE_DISPOSED_WARNING||console.warn(new Error("Trying to add a disposable to a DisposableStore that has already been disposed of. The added object will be leaked!").stack):this._toDispose.add(e),e}deleteAndLeak(e){e&&this._toDispose.has(e)&&(this._toDispose.delete(e),c(e,null))}}m.DISABLE_DISPOSED_WARNING=!1;class f{constructor(){this._store=new m,a(this),c(this._store,this)}dispose(){l(this),this._store.dispose()}_register(e){if(e===this)throw new Error("Cannot register a disposable on itself!");return this._store.add(e)}}f.None=Object.freeze({dispose(){}});class b{constructor(){this._isDisposed=!1,a(this)}get value(){return this._isDisposed?void 0:this._value}set value(e){var t;this._isDisposed||e===this._value||(null===(t=this._value)||void 0===t||t.dispose(),e&&c(e,this),this._value=e)}clear(){this.value=void 0}dispose(){var e;this._isDisposed=!0,l(this),null===(e=this._value)||void 0===e||e.dispose(),this._value=void 0}}class v{constructor(e){this._disposable=e,this._counter=1}acquire(){return this._counter++,this}release(){return 0==--this._counter&&this._disposable.dispose(),this}}class _{constructor(e){this.object=e}dispose(){}}class A{constructor(){this._store=new Map,this._isDisposed=!1,a(this)}dispose(){l(this),this._isDisposed=!0,this.clearAndDisposeAll()}clearAndDisposeAll(){if(this._store.size)try{h(this._store.values())}finally{this._store.clear()}}get(e){return this._store.get(e)}set(e,t,i=!1){var n;this._isDisposed&&console.warn(new Error("Trying to add a disposable to a DisposableMap that has already been disposed of. The added object will be leaked!").stack),i||null===(n=this._store.get(e))||void 0===n||n.dispose(),this._store.set(e,t)}deleteAndDispose(e){var t;null===(t=this._store.get(e))||void 0===t||t.dispose(),this._store.delete(e)}[Symbol.iterator](){return this._store[Symbol.iterator]()}}},22446:function(e,t,i){"use strict";i.r(t),i.d(t,{LinkedList:function(){return o}});class n{constructor(e){this.element=e,this.next=n.Undefined,this.prev=n.Undefined}}n.Undefined=new n(void 0);class o{constructor(){this._first=n.Undefined,this._last=n.Undefined,this._size=0}get size(){return this._size}isEmpty(){return this._first===n.Undefined}clear(){let e=this._first;for(;e!==n.Undefined;){const t=e.next;e.prev=n.Undefined,e.next=n.Undefined,e=t}this._first=n.Undefined,this._last=n.Undefined,this._size=0}unshift(e){return this._insert(e,!1)}push(e){return this._insert(e,!0)}_insert(e,t){const i=new n(e);if(this._first===n.Undefined)this._first=i,this._last=i;else if(t){const e=this._last;this._last=i,i.prev=e,e.next=i}else{const e=this._first;this._first=i,i.next=e,e.prev=i}this._size+=1;let o=!1;return()=>{o||(o=!0,this._remove(i))}}shift(){if(this._first!==n.Undefined){const e=this._first.element;return this._remove(this._first),e}}pop(){if(this._last!==n.Undefined){const e=this._last.element;return this._remove(this._last),e}}_remove(e){if(e.prev!==n.Undefined&&e.next!==n.Undefined){const t=e.prev;t.next=e.next,e.next.prev=t}else e.prev===n.Undefined&&e.next===n.Undefined?(this._first=n.Undefined,this._last=n.Undefined):e.next===n.Undefined?(this._last=this._last.prev,this._last.next=n.Undefined):e.prev===n.Undefined&&(this._first=this._first.next,this._first.prev=n.Undefined);this._size-=1}*[Symbol.iterator](){let e=this._first;for(;e!==n.Undefined;)yield e.element,e=e.next}}},91154:function(e,t,i){"use strict";i.r(t),i.d(t,{LinkedText:function(){return r},parseLinkedText:function(){return a}});var n=i(63966),o=function(e,t,i,n){var o,r=arguments.length,s=r<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,i):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)s=Reflect.decorate(e,t,i,n);else for(var a=e.length-1;a>=0;a--)(o=e[a])&&(s=(r<3?o(s):r>3?o(t,i,s):o(t,i))||s);return r>3&&s&&Object.defineProperty(t,i,s),s};class r{constructor(e){this.nodes=e}toString(){return this.nodes.map((e=>"string"==typeof e?e:e.label)).join("")}}o([n.memoize],r.prototype,"toString",null);const s=/\[([^\]]+)\]\(((?:https?:\/\/|command:|file:)[^\)\s]+)(?: (["'])(.+?)(\3))?\)/gi;function a(e){const t=[];let i,n=0;for(;i=s.exec(e);){i.index-n>0&&t.push(e.substring(n,i.index));const[,o,r,,s]=i;s?t.push({label:o,href:r,title:s}):t.push({label:o,href:r}),n=i.index+i[0].length}return n<e.length&&t.push(e.substring(n)),new r(t)}},13833:function(e,t,i){"use strict";var n,o;i.r(t),i.d(t,{BidirectionalMap:function(){return c},LRUCache:function(){return l},LinkedMap:function(){return a},ResourceMap:function(){return s},SetMap:function(){return d}});class r{constructor(e,t){this.uri=e,this.value=t}}class s{constructor(e,t){if(this[n]="ResourceMap",e instanceof s)this.map=new Map(e.map),this.toKey=null!=t?t:s.defaultToKey;else if(function(e){return Array.isArray(e)}(e)){this.map=new Map,this.toKey=null!=t?t:s.defaultToKey;for(const[t,i]of e)this.set(t,i)}else this.map=new Map,this.toKey=null!=e?e:s.defaultToKey}set(e,t){return this.map.set(this.toKey(e),new r(e,t)),this}get(e){var t;return null===(t=this.map.get(this.toKey(e)))||void 0===t?void 0:t.value}has(e){return this.map.has(this.toKey(e))}get size(){return this.map.size}clear(){this.map.clear()}delete(e){return this.map.delete(this.toKey(e))}forEach(e,t){void 0!==t&&(e=e.bind(t));for(const[t,i]of this.map)e(i.value,i.uri,this)}*values(){for(const e of this.map.values())yield e.value}*keys(){for(const e of this.map.values())yield e.uri}*entries(){for(const e of this.map.values())yield[e.uri,e.value]}*[(n=Symbol.toStringTag,Symbol.iterator)](){for(const[,e]of this.map)yield[e.uri,e.value]}}s.defaultToKey=e=>e.toString();class a{constructor(){this[o]="LinkedMap",this._map=new Map,this._head=void 0,this._tail=void 0,this._size=0,this._state=0}clear(){this._map.clear(),this._head=void 0,this._tail=void 0,this._size=0,this._state++}isEmpty(){return!this._head&&!this._tail}get size(){return this._size}get first(){var e;return null===(e=this._head)||void 0===e?void 0:e.value}get last(){var e;return null===(e=this._tail)||void 0===e?void 0:e.value}has(e){return this._map.has(e)}get(e,t=0){const i=this._map.get(e);if(i)return 0!==t&&this.touch(i,t),i.value}set(e,t,i=0){let n=this._map.get(e);if(n)n.value=t,0!==i&&this.touch(n,i);else{switch(n={key:e,value:t,next:void 0,previous:void 0},i){case 0:case 2:default:this.addItemLast(n);break;case 1:this.addItemFirst(n)}this._map.set(e,n),this._size++}return this}delete(e){return!!this.remove(e)}remove(e){const t=this._map.get(e);if(t)return this._map.delete(e),this.removeItem(t),this._size--,t.value}shift(){if(!this._head&&!this._tail)return;if(!this._head||!this._tail)throw new Error("Invalid list");const e=this._head;return this._map.delete(e.key),this.removeItem(e),this._size--,e.value}forEach(e,t){const i=this._state;let n=this._head;for(;n;){if(t?e.bind(t)(n.value,n.key,this):e(n.value,n.key,this),this._state!==i)throw new Error("LinkedMap got modified during iteration.");n=n.next}}keys(){const e=this,t=this._state;let i=this._head;const n={[Symbol.iterator](){return n},next(){if(e._state!==t)throw new Error("LinkedMap got modified during iteration.");if(i){const e={value:i.key,done:!1};return i=i.next,e}return{value:void 0,done:!0}}};return n}values(){const e=this,t=this._state;let i=this._head;const n={[Symbol.iterator](){return n},next(){if(e._state!==t)throw new Error("LinkedMap got modified during iteration.");if(i){const e={value:i.value,done:!1};return i=i.next,e}return{value:void 0,done:!0}}};return n}entries(){const e=this,t=this._state;let i=this._head;const n={[Symbol.iterator](){return n},next(){if(e._state!==t)throw new Error("LinkedMap got modified during iteration.");if(i){const e={value:[i.key,i.value],done:!1};return i=i.next,e}return{value:void 0,done:!0}}};return n}[(o=Symbol.toStringTag,Symbol.iterator)](){return this.entries()}trimOld(e){if(e>=this.size)return;if(0===e)return void this.clear();let t=this._head,i=this.size;for(;t&&i>e;)this._map.delete(t.key),t=t.next,i--;this._head=t,this._size=i,t&&(t.previous=void 0),this._state++}addItemFirst(e){if(this._head||this._tail){if(!this._head)throw new Error("Invalid list");e.next=this._head,this._head.previous=e}else this._tail=e;this._head=e,this._state++}addItemLast(e){if(this._head||this._tail){if(!this._tail)throw new Error("Invalid list");e.previous=this._tail,this._tail.next=e}else this._head=e;this._tail=e,this._state++}removeItem(e){if(e===this._head&&e===this._tail)this._head=void 0,this._tail=void 0;else if(e===this._head){if(!e.next)throw new Error("Invalid list");e.next.previous=void 0,this._head=e.next}else if(e===this._tail){if(!e.previous)throw new Error("Invalid list");e.previous.next=void 0,this._tail=e.previous}else{const t=e.next,i=e.previous;if(!t||!i)throw new Error("Invalid list");t.previous=i,i.next=t}e.next=void 0,e.previous=void 0,this._state++}touch(e,t){if(!this._head||!this._tail)throw new Error("Invalid list");if(1===t||2===t)if(1===t){if(e===this._head)return;const t=e.next,i=e.previous;e===this._tail?(i.next=void 0,this._tail=i):(t.previous=i,i.next=t),e.previous=void 0,e.next=this._head,this._head.previous=e,this._head=e,this._state++}else if(2===t){if(e===this._tail)return;const t=e.next,i=e.previous;e===this._head?(t.previous=void 0,this._head=t):(t.previous=i,i.next=t),e.next=void 0,e.previous=this._tail,this._tail.next=e,this._tail=e,this._state++}}toJSON(){const e=[];return this.forEach(((t,i)=>{e.push([i,t])})),e}fromJSON(e){this.clear();for(const[t,i]of e)this.set(t,i)}}class l extends a{constructor(e,t=1){super(),this._limit=e,this._ratio=Math.min(Math.max(0,t),1)}get limit(){return this._limit}set limit(e){this._limit=e,this.checkTrim()}get(e,t=2){return super.get(e,t)}peek(e){return super.get(e,0)}set(e,t){return super.set(e,t,2),this.checkTrim(),this}checkTrim(){this.size>this._limit&&this.trimOld(Math.round(this._limit*this._ratio))}}class c{constructor(e){if(this._m1=new Map,this._m2=new Map,e)for(const[t,i]of e)this.set(t,i)}clear(){this._m1.clear(),this._m2.clear()}set(e,t){this._m1.set(e,t),this._m2.set(t,e)}get(e){return this._m1.get(e)}getKey(e){return this._m2.get(e)}delete(e){const t=this._m1.get(e);return void 0!==t&&(this._m1.delete(e),this._m2.delete(t),!0)}keys(){return this._m1.keys()}values(){return this._m1.values()}}class d{constructor(){this.map=new Map}add(e,t){let i=this.map.get(e);i||(i=new Set,this.map.set(e,i)),i.add(t)}delete(e,t){const i=this.map.get(e);i&&(i.delete(t),0===i.size&&this.map.delete(e))}forEach(e,t){const i=this.map.get(e);i&&i.forEach(t)}get(e){const t=this.map.get(e);return t||new Set}}},55202:function(e,t,i){"use strict";i.r(t),i.d(t,{Lexer:function(){return o},Parser:function(){return r},Renderer:function(){return s},Slugger:function(){return a},TextRenderer:function(){return l},Tokenizer:function(){return c},getDefaults:function(){return d},lexer:function(){return u},marked:function(){return h},options:function(){return g},parse:function(){return p},parseInline:function(){return m},parser:function(){return f},setOptions:function(){return b},use:function(){return v},walkTokens:function(){return _}});let n={};!function(){function e(e,t){t(n)}e.amd=!0,function(t,i){e.amd?e(0,i):"object"==typeof exports?i(exports):i((t="undefined"!=typeof globalThis?globalThis:t||self).marked={})}(this,(function(e){function t(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}function i(e,t){(null==t||t>e.length)&&(t=e.length);for(var i=0,n=new Array(t);i<t;i++)n[i]=e[i];return n}function n(e,t){var n="undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(n)return(n=n.call(e)).next.bind(n);if(Array.isArray(e)||(n=function(e,t){if(e){if("string"==typeof e)return i(e,t);var n=Object.prototype.toString.call(e).slice(8,-1);return"Object"===n&&e.constructor&&(n=e.constructor.name),"Map"===n||"Set"===n?Array.from(e):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?i(e,t):void 0}}(e))||t&&e&&"number"==typeof e.length){n&&(e=n);var o=0;return function(){return o>=e.length?{done:!0}:{done:!1,value:e[o++]}}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}function o(){return{async:!1,baseUrl:null,breaks:!1,extensions:null,gfm:!0,headerIds:!0,headerPrefix:"",highlight:null,langPrefix:"language-",mangle:!0,pedantic:!1,renderer:null,sanitize:!1,sanitizer:null,silent:!1,smartLists:!1,smartypants:!1,tokenizer:null,walkTokens:null,xhtml:!1}}e.defaults={async:!1,baseUrl:null,breaks:!1,extensions:null,gfm:!0,headerIds:!0,headerPrefix:"",highlight:null,langPrefix:"language-",mangle:!0,pedantic:!1,renderer:null,sanitize:!1,sanitizer:null,silent:!1,smartLists:!1,smartypants:!1,tokenizer:null,walkTokens:null,xhtml:!1};var r=/[&<>"']/,s=/[&<>"']/g,a=/[<>"']|&(?!#?\w+;)/,l=/[<>"']|&(?!#?\w+;)/g,c={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#39;"},d=function(e){return c[e]};function u(e,t){if(t){if(r.test(e))return e.replace(s,d)}else if(a.test(e))return e.replace(l,d);return e}var h=/&(#(?:\d+)|(?:#x[0-9A-Fa-f]+)|(?:\w+));?/gi;function g(e){return e.replace(h,(function(e,t){return"colon"===(t=t.toLowerCase())?":":"#"===t.charAt(0)?"x"===t.charAt(1)?String.fromCharCode(parseInt(t.substring(2),16)):String.fromCharCode(+t.substring(1)):""}))}var p=/(^|[^\[])\^/g;function m(e,t){e="string"==typeof e?e:e.source,t=t||"";var i={replace:function(t,n){return n=(n=n.source||n).replace(p,"$1"),e=e.replace(t,n),i},getRegex:function(){return new RegExp(e,t)}};return i}var f=/[^\w:]/g,b=/^$|^[a-z][a-z0-9+.-]*:|^[?#]/i;function v(e,t,i){if(e){var n;try{n=decodeURIComponent(g(i)).replace(f,"").toLowerCase()}catch(e){return null}if(0===n.indexOf("javascript:")||0===n.indexOf("vbscript:")||0===n.indexOf("data:"))return null}t&&!b.test(i)&&(i=function(e,t){_[" "+e]||(A.test(e)?_[" "+e]=e+"/":_[" "+e]=E(e,"/",!0));e=_[" "+e];var i=-1===e.indexOf(":");return"//"===t.substring(0,2)?i?t:e.replace(C,"$1")+t:"/"===t.charAt(0)?i?t:e.replace(w,"$1")+t:e+t}(t,i));try{i=encodeURI(i).replace(/%25/g,"%")}catch(e){return null}return i}var _={},A=/^[^:]+:\/*[^/]*$/,C=/^([^:]+:)[\s\S]*$/,w=/^([^:]+:\/*[^/]*)[\s\S]*$/;var y={exec:function(){}};function S(e){for(var t,i,n=1;n<arguments.length;n++)for(i in t=arguments[n])Object.prototype.hasOwnProperty.call(t,i)&&(e[i]=t[i]);return e}function x(e,t){var i=e.replace(/\|/g,(function(e,t,i){for(var n=!1,o=t;--o>=0&&"\\"===i[o];)n=!n;return n?"|":" |"})).split(/ \|/),n=0;if(i[0].trim()||i.shift(),i.length>0&&!i[i.length-1].trim()&&i.pop(),i.length>t)i.splice(t);else for(;i.length<t;)i.push("");for(;n<i.length;n++)i[n]=i[n].trim().replace(/\\\|/g,"|");return i}function E(e,t,i){var n=e.length;if(0===n)return"";for(var o=0;o<n;){var r=e.charAt(n-o-1);if(r!==t||i){if(r===t||!i)break;o++}else o++}return e.slice(0,n-o)}function k(e){e&&e.sanitize&&!e.silent&&console.warn("marked(): sanitize and sanitizer parameters are deprecated since version 0.7.0, should not be used and will be removed in the future. Read more here: https://marked.js.org/#/USING_ADVANCED.md#options")}function D(e,t){if(t<1)return"";for(var i="";t>1;)1&t&&(i+=e),t>>=1,e+=e;return i+e}function I(e,t,i,n){var o=t.href,r=t.title?u(t.title):null,s=e[1].replace(/\\([\[\]])/g,"$1");if("!"!==e[0].charAt(0)){n.state.inLink=!0;var a={type:"link",raw:i,href:o,title:r,text:s,tokens:n.inlineTokens(s)};return n.state.inLink=!1,a}return{type:"image",raw:i,href:o,title:r,text:u(s)}}var L=function(){function t(t){this.options=t||e.defaults}var i=t.prototype;return i.space=function(e){var t=this.rules.block.newline.exec(e);if(t&&t[0].length>0)return{type:"space",raw:t[0]}},i.code=function(e){var t=this.rules.block.code.exec(e);if(t){var i=t[0].replace(/^ {1,4}/gm,"");return{type:"code",raw:t[0],codeBlockStyle:"indented",text:this.options.pedantic?i:E(i,"\n")}}},i.fences=function(e){var t=this.rules.block.fences.exec(e);if(t){var i=t[0],n=function(e,t){var i=e.match(/^(\s+)(?:```)/);if(null===i)return t;var n=i[1];return t.split("\n").map((function(e){var t=e.match(/^\s+/);return null===t?e:t[0].length>=n.length?e.slice(n.length):e})).join("\n")}(i,t[3]||"");return{type:"code",raw:i,lang:t[2]?t[2].trim():t[2],text:n}}},i.heading=function(e){var t=this.rules.block.heading.exec(e);if(t){var i=t[2].trim();if(/#$/.test(i)){var n=E(i,"#");this.options.pedantic?i=n.trim():n&&!/ $/.test(n)||(i=n.trim())}return{type:"heading",raw:t[0],depth:t[1].length,text:i,tokens:this.lexer.inline(i)}}},i.hr=function(e){var t=this.rules.block.hr.exec(e);if(t)return{type:"hr",raw:t[0]}},i.blockquote=function(e){var t=this.rules.block.blockquote.exec(e);if(t){var i=t[0].replace(/^ *>[ \t]?/gm,"");return{type:"blockquote",raw:t[0],tokens:this.lexer.blockTokens(i,[]),text:i}}},i.list=function(e){var t=this.rules.block.list.exec(e);if(t){var i,o,r,s,a,l,c,d,u,h,g,p,m=t[1].trim(),f=m.length>1,b={type:"list",raw:"",ordered:f,start:f?+m.slice(0,-1):"",loose:!1,items:[]};m=f?"\\d{1,9}\\"+m.slice(-1):"\\"+m,this.options.pedantic&&(m=f?m:"[*+-]");for(var v=new RegExp("^( {0,3}"+m+")((?:[\t ][^\\n]*)?(?:\\n|$))");e&&(p=!1,t=v.exec(e))&&!this.rules.block.hr.test(e);){if(i=t[0],e=e.substring(i.length),d=t[2].split("\n",1)[0],u=e.split("\n",1)[0],this.options.pedantic?(s=2,g=d.trimLeft()):(s=(s=t[2].search(/[^ ]/))>4?1:s,g=d.slice(s),s+=t[1].length),l=!1,!d&&/^ *$/.test(u)&&(i+=u+"\n",e=e.substring(u.length+1),p=!0),!p)for(var _=new RegExp("^ {0,"+Math.min(3,s-1)+"}(?:[*+-]|\\d{1,9}[.)])((?: [^\\n]*)?(?:\\n|$))"),A=new RegExp("^ {0,"+Math.min(3,s-1)+"}((?:- *){3,}|(?:_ *){3,}|(?:\\* *){3,})(?:\\n+|$)"),C=new RegExp("^ {0,"+Math.min(3,s-1)+"}(?:```|~~~)"),w=new RegExp("^ {0,"+Math.min(3,s-1)+"}#");e&&(d=h=e.split("\n",1)[0],this.options.pedantic&&(d=d.replace(/^ {1,4}(?=( {4})*[^ ])/g,"  ")),!C.test(d))&&!w.test(d)&&!_.test(d)&&!A.test(e);){if(d.search(/[^ ]/)>=s||!d.trim())g+="\n"+d.slice(s);else{if(l)break;g+="\n"+d}l||d.trim()||(l=!0),i+=h+"\n",e=e.substring(h.length+1)}b.loose||(c?b.loose=!0:/\n *\n *$/.test(i)&&(c=!0)),this.options.gfm&&(o=/^\[[ xX]\] /.exec(g))&&(r="[ ] "!==o[0],g=g.replace(/^\[[ xX]\] +/,"")),b.items.push({type:"list_item",raw:i,task:!!o,checked:r,loose:!1,text:g}),b.raw+=i}b.items[b.items.length-1].raw=i.trimRight(),b.items[b.items.length-1].text=g.trimRight(),b.raw=b.raw.trimRight();var y=b.items.length;for(a=0;a<y;a++){this.lexer.state.top=!1,b.items[a].tokens=this.lexer.blockTokens(b.items[a].text,[]);var S=b.items[a].tokens.filter((function(e){return"space"===e.type})),x=S.every((function(e){for(var t,i=0,o=n(e.raw.split(""));!(t=o()).done;){if("\n"===t.value&&(i+=1),i>1)return!0}return!1}));!b.loose&&S.length&&x&&(b.loose=!0,b.items[a].loose=!0)}return b}},i.html=function(e){var t=this.rules.block.html.exec(e);if(t){var i={type:"html",raw:t[0],pre:!this.options.sanitizer&&("pre"===t[1]||"script"===t[1]||"style"===t[1]),text:t[0]};if(this.options.sanitize){var n=this.options.sanitizer?this.options.sanitizer(t[0]):u(t[0]);i.type="paragraph",i.text=n,i.tokens=this.lexer.inline(n)}return i}},i.def=function(e){var t=this.rules.block.def.exec(e);if(t)return t[3]&&(t[3]=t[3].substring(1,t[3].length-1)),{type:"def",tag:t[1].toLowerCase().replace(/\s+/g," "),raw:t[0],href:t[2],title:t[3]}},i.table=function(e){var t=this.rules.block.table.exec(e);if(t){var i={type:"table",header:x(t[1]).map((function(e){return{text:e}})),align:t[2].replace(/^ *|\| *$/g,"").split(/ *\| */),rows:t[3]&&t[3].trim()?t[3].replace(/\n[ \t]*$/,"").split("\n"):[]};if(i.header.length===i.align.length){i.raw=t[0];var n,o,r,s,a=i.align.length;for(n=0;n<a;n++)/^ *-+: *$/.test(i.align[n])?i.align[n]="right":/^ *:-+: *$/.test(i.align[n])?i.align[n]="center":/^ *:-+ *$/.test(i.align[n])?i.align[n]="left":i.align[n]=null;for(a=i.rows.length,n=0;n<a;n++)i.rows[n]=x(i.rows[n],i.header.length).map((function(e){return{text:e}}));for(a=i.header.length,o=0;o<a;o++)i.header[o].tokens=this.lexer.inline(i.header[o].text);for(a=i.rows.length,o=0;o<a;o++)for(s=i.rows[o],r=0;r<s.length;r++)s[r].tokens=this.lexer.inline(s[r].text);return i}}},i.lheading=function(e){var t=this.rules.block.lheading.exec(e);if(t)return{type:"heading",raw:t[0],depth:"="===t[2].charAt(0)?1:2,text:t[1],tokens:this.lexer.inline(t[1])}},i.paragraph=function(e){var t=this.rules.block.paragraph.exec(e);if(t){var i="\n"===t[1].charAt(t[1].length-1)?t[1].slice(0,-1):t[1];return{type:"paragraph",raw:t[0],text:i,tokens:this.lexer.inline(i)}}},i.text=function(e){var t=this.rules.block.text.exec(e);if(t)return{type:"text",raw:t[0],text:t[0],tokens:this.lexer.inline(t[0])}},i.escape=function(e){var t=this.rules.inline.escape.exec(e);if(t)return{type:"escape",raw:t[0],text:u(t[1])}},i.tag=function(e){var t=this.rules.inline.tag.exec(e);if(t)return!this.lexer.state.inLink&&/^<a /i.test(t[0])?this.lexer.state.inLink=!0:this.lexer.state.inLink&&/^<\/a>/i.test(t[0])&&(this.lexer.state.inLink=!1),!this.lexer.state.inRawBlock&&/^<(pre|code|kbd|script)(\s|>)/i.test(t[0])?this.lexer.state.inRawBlock=!0:this.lexer.state.inRawBlock&&/^<\/(pre|code|kbd|script)(\s|>)/i.test(t[0])&&(this.lexer.state.inRawBlock=!1),{type:this.options.sanitize?"text":"html",raw:t[0],inLink:this.lexer.state.inLink,inRawBlock:this.lexer.state.inRawBlock,text:this.options.sanitize?this.options.sanitizer?this.options.sanitizer(t[0]):u(t[0]):t[0]}},i.link=function(e){var t=this.rules.inline.link.exec(e);if(t){var i=t[2].trim();if(!this.options.pedantic&&/^</.test(i)){if(!/>$/.test(i))return;var n=E(i.slice(0,-1),"\\");if((i.length-n.length)%2==0)return}else{var o=function(e,t){if(-1===e.indexOf(t[1]))return-1;for(var i=e.length,n=0,o=0;o<i;o++)if("\\"===e[o])o++;else if(e[o]===t[0])n++;else if(e[o]===t[1]&&--n<0)return o;return-1}(t[2],"()");if(o>-1){var r=(0===t[0].indexOf("!")?5:4)+t[1].length+o;t[2]=t[2].substring(0,o),t[0]=t[0].substring(0,r).trim(),t[3]=""}}var s=t[2],a="";if(this.options.pedantic){var l=/^([^'"]*[^\s])\s+(['"])(.*)\2/.exec(s);l&&(s=l[1],a=l[3])}else a=t[3]?t[3].slice(1,-1):"";return s=s.trim(),/^</.test(s)&&(s=this.options.pedantic&&!/>$/.test(i)?s.slice(1):s.slice(1,-1)),I(t,{href:s?s.replace(this.rules.inline._escapes,"$1"):s,title:a?a.replace(this.rules.inline._escapes,"$1"):a},t[0],this.lexer)}},i.reflink=function(e,t){var i;if((i=this.rules.inline.reflink.exec(e))||(i=this.rules.inline.nolink.exec(e))){var n=(i[2]||i[1]).replace(/\s+/g," ");if(!(n=t[n.toLowerCase()])||!n.href){var o=i[0].charAt(0);return{type:"text",raw:o,text:o}}return I(i,n,i[0],this.lexer)}},i.emStrong=function(e,t,i){void 0===i&&(i="");var n=this.rules.inline.emStrong.lDelim.exec(e);if(n&&(!n[3]||!i.match(/(?:[0-9A-Za-z\xAA\xB2\xB3\xB5\xB9\xBA\xBC-\xBE\xC0-\xD6\xD8-\xF6\xF8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0370-\u0374\u0376\u0377\u037A-\u037D\u037F\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u048A-\u052F\u0531-\u0556\u0559\u0560-\u0588\u05D0-\u05EA\u05EF-\u05F2\u0620-\u064A\u0660-\u0669\u066E\u066F\u0671-\u06D3\u06D5\u06E5\u06E6\u06EE-\u06FC\u06FF\u0710\u0712-\u072F\u074D-\u07A5\u07B1\u07C0-\u07EA\u07F4\u07F5\u07FA\u0800-\u0815\u081A\u0824\u0828\u0840-\u0858\u0860-\u086A\u0870-\u0887\u0889-\u088E\u08A0-\u08C9\u0904-\u0939\u093D\u0950\u0958-\u0961\u0966-\u096F\u0971-\u0980\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BD\u09CE\u09DC\u09DD\u09DF-\u09E1\u09E6-\u09F1\u09F4-\u09F9\u09FC\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A59-\u0A5C\u0A5E\u0A66-\u0A6F\u0A72-\u0A74\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABD\u0AD0\u0AE0\u0AE1\u0AE6-\u0AEF\u0AF9\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3D\u0B5C\u0B5D\u0B5F-\u0B61\u0B66-\u0B6F\u0B71-\u0B77\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BD0\u0BE6-\u0BF2\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D\u0C58-\u0C5A\u0C5D\u0C60\u0C61\u0C66-\u0C6F\u0C78-\u0C7E\u0C80\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBD\u0CDD\u0CDE\u0CE0\u0CE1\u0CE6-\u0CEF\u0CF1\u0CF2\u0D04-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D\u0D4E\u0D54-\u0D56\u0D58-\u0D61\u0D66-\u0D78\u0D7A-\u0D7F\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0DE6-\u0DEF\u0E01-\u0E30\u0E32\u0E33\u0E40-\u0E46\u0E50-\u0E59\u0E81\u0E82\u0E84\u0E86-\u0E8A\u0E8C-\u0EA3\u0EA5\u0EA7-\u0EB0\u0EB2\u0EB3\u0EBD\u0EC0-\u0EC4\u0EC6\u0ED0-\u0ED9\u0EDC-\u0EDF\u0F00\u0F20-\u0F33\u0F40-\u0F47\u0F49-\u0F6C\u0F88-\u0F8C\u1000-\u102A\u103F-\u1049\u1050-\u1055\u105A-\u105D\u1061\u1065\u1066\u106E-\u1070\u1075-\u1081\u108E\u1090-\u1099\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u1369-\u137C\u1380-\u138F\u13A0-\u13F5\u13F8-\u13FD\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u16EE-\u16F8\u1700-\u1711\u171F-\u1731\u1740-\u1751\u1760-\u176C\u176E-\u1770\u1780-\u17B3\u17D7\u17DC\u17E0-\u17E9\u17F0-\u17F9\u1810-\u1819\u1820-\u1878\u1880-\u1884\u1887-\u18A8\u18AA\u18B0-\u18F5\u1900-\u191E\u1946-\u196D\u1970-\u1974\u1980-\u19AB\u19B0-\u19C9\u19D0-\u19DA\u1A00-\u1A16\u1A20-\u1A54\u1A80-\u1A89\u1A90-\u1A99\u1AA7\u1B05-\u1B33\u1B45-\u1B4C\u1B50-\u1B59\u1B83-\u1BA0\u1BAE-\u1BE5\u1C00-\u1C23\u1C40-\u1C49\u1C4D-\u1C7D\u1C80-\u1C88\u1C90-\u1CBA\u1CBD-\u1CBF\u1CE9-\u1CEC\u1CEE-\u1CF3\u1CF5\u1CF6\u1CFA\u1D00-\u1DBF\u1E00-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u2070\u2071\u2074-\u2079\u207F-\u2089\u2090-\u209C\u2102\u2107\u210A-\u2113\u2115\u2119-\u211D\u2124\u2126\u2128\u212A-\u212D\u212F-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2150-\u2189\u2460-\u249B\u24EA-\u24FF\u2776-\u2793\u2C00-\u2CE4\u2CEB-\u2CEE\u2CF2\u2CF3\u2CFD\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D80-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u2E2F\u3005-\u3007\u3021-\u3029\u3031-\u3035\u3038-\u303C\u3041-\u3096\u309D-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312F\u3131-\u318E\u3192-\u3195\u31A0-\u31BF\u31F0-\u31FF\u3220-\u3229\u3248-\u324F\u3251-\u325F\u3280-\u3289\u32B1-\u32BF\u3400-\u4DBF\u4E00-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA62B\uA640-\uA66E\uA67F-\uA69D\uA6A0-\uA6EF\uA717-\uA71F\uA722-\uA788\uA78B-\uA7CA\uA7D0\uA7D1\uA7D3\uA7D5-\uA7D9\uA7F2-\uA801\uA803-\uA805\uA807-\uA80A\uA80C-\uA822\uA830-\uA835\uA840-\uA873\uA882-\uA8B3\uA8D0-\uA8D9\uA8F2-\uA8F7\uA8FB\uA8FD\uA8FE\uA900-\uA925\uA930-\uA946\uA960-\uA97C\uA984-\uA9B2\uA9CF-\uA9D9\uA9E0-\uA9E4\uA9E6-\uA9FE\uAA00-\uAA28\uAA40-\uAA42\uAA44-\uAA4B\uAA50-\uAA59\uAA60-\uAA76\uAA7A\uAA7E-\uAAAF\uAAB1\uAAB5\uAAB6\uAAB9-\uAABD\uAAC0\uAAC2\uAADB-\uAADD\uAAE0-\uAAEA\uAAF2-\uAAF4\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB5A\uAB5C-\uAB69\uAB70-\uABE2\uABF0-\uABF9\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D\uFB1F-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE70-\uFE74\uFE76-\uFEFC\uFF10-\uFF19\uFF21-\uFF3A\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC]|\uD800[\uDC00-\uDC0B\uDC0D-\uDC26\uDC28-\uDC3A\uDC3C\uDC3D\uDC3F-\uDC4D\uDC50-\uDC5D\uDC80-\uDCFA\uDD07-\uDD33\uDD40-\uDD78\uDD8A\uDD8B\uDE80-\uDE9C\uDEA0-\uDED0\uDEE1-\uDEFB\uDF00-\uDF23\uDF2D-\uDF4A\uDF50-\uDF75\uDF80-\uDF9D\uDFA0-\uDFC3\uDFC8-\uDFCF\uDFD1-\uDFD5]|\uD801[\uDC00-\uDC9D\uDCA0-\uDCA9\uDCB0-\uDCD3\uDCD8-\uDCFB\uDD00-\uDD27\uDD30-\uDD63\uDD70-\uDD7A\uDD7C-\uDD8A\uDD8C-\uDD92\uDD94\uDD95\uDD97-\uDDA1\uDDA3-\uDDB1\uDDB3-\uDDB9\uDDBB\uDDBC\uDE00-\uDF36\uDF40-\uDF55\uDF60-\uDF67\uDF80-\uDF85\uDF87-\uDFB0\uDFB2-\uDFBA]|\uD802[\uDC00-\uDC05\uDC08\uDC0A-\uDC35\uDC37\uDC38\uDC3C\uDC3F-\uDC55\uDC58-\uDC76\uDC79-\uDC9E\uDCA7-\uDCAF\uDCE0-\uDCF2\uDCF4\uDCF5\uDCFB-\uDD1B\uDD20-\uDD39\uDD80-\uDDB7\uDDBC-\uDDCF\uDDD2-\uDE00\uDE10-\uDE13\uDE15-\uDE17\uDE19-\uDE35\uDE40-\uDE48\uDE60-\uDE7E\uDE80-\uDE9F\uDEC0-\uDEC7\uDEC9-\uDEE4\uDEEB-\uDEEF\uDF00-\uDF35\uDF40-\uDF55\uDF58-\uDF72\uDF78-\uDF91\uDFA9-\uDFAF]|\uD803[\uDC00-\uDC48\uDC80-\uDCB2\uDCC0-\uDCF2\uDCFA-\uDD23\uDD30-\uDD39\uDE60-\uDE7E\uDE80-\uDEA9\uDEB0\uDEB1\uDF00-\uDF27\uDF30-\uDF45\uDF51-\uDF54\uDF70-\uDF81\uDFB0-\uDFCB\uDFE0-\uDFF6]|\uD804[\uDC03-\uDC37\uDC52-\uDC6F\uDC71\uDC72\uDC75\uDC83-\uDCAF\uDCD0-\uDCE8\uDCF0-\uDCF9\uDD03-\uDD26\uDD36-\uDD3F\uDD44\uDD47\uDD50-\uDD72\uDD76\uDD83-\uDDB2\uDDC1-\uDDC4\uDDD0-\uDDDA\uDDDC\uDDE1-\uDDF4\uDE00-\uDE11\uDE13-\uDE2B\uDE80-\uDE86\uDE88\uDE8A-\uDE8D\uDE8F-\uDE9D\uDE9F-\uDEA8\uDEB0-\uDEDE\uDEF0-\uDEF9\uDF05-\uDF0C\uDF0F\uDF10\uDF13-\uDF28\uDF2A-\uDF30\uDF32\uDF33\uDF35-\uDF39\uDF3D\uDF50\uDF5D-\uDF61]|\uD805[\uDC00-\uDC34\uDC47-\uDC4A\uDC50-\uDC59\uDC5F-\uDC61\uDC80-\uDCAF\uDCC4\uDCC5\uDCC7\uDCD0-\uDCD9\uDD80-\uDDAE\uDDD8-\uDDDB\uDE00-\uDE2F\uDE44\uDE50-\uDE59\uDE80-\uDEAA\uDEB8\uDEC0-\uDEC9\uDF00-\uDF1A\uDF30-\uDF3B\uDF40-\uDF46]|\uD806[\uDC00-\uDC2B\uDCA0-\uDCF2\uDCFF-\uDD06\uDD09\uDD0C-\uDD13\uDD15\uDD16\uDD18-\uDD2F\uDD3F\uDD41\uDD50-\uDD59\uDDA0-\uDDA7\uDDAA-\uDDD0\uDDE1\uDDE3\uDE00\uDE0B-\uDE32\uDE3A\uDE50\uDE5C-\uDE89\uDE9D\uDEB0-\uDEF8]|\uD807[\uDC00-\uDC08\uDC0A-\uDC2E\uDC40\uDC50-\uDC6C\uDC72-\uDC8F\uDD00-\uDD06\uDD08\uDD09\uDD0B-\uDD30\uDD46\uDD50-\uDD59\uDD60-\uDD65\uDD67\uDD68\uDD6A-\uDD89\uDD98\uDDA0-\uDDA9\uDEE0-\uDEF2\uDFB0\uDFC0-\uDFD4]|\uD808[\uDC00-\uDF99]|\uD809[\uDC00-\uDC6E\uDC80-\uDD43]|\uD80B[\uDF90-\uDFF0]|[\uD80C\uD81C-\uD820\uD822\uD840-\uD868\uD86A-\uD86C\uD86F-\uD872\uD874-\uD879\uD880-\uD883][\uDC00-\uDFFF]|\uD80D[\uDC00-\uDC2E]|\uD811[\uDC00-\uDE46]|\uD81A[\uDC00-\uDE38\uDE40-\uDE5E\uDE60-\uDE69\uDE70-\uDEBE\uDEC0-\uDEC9\uDED0-\uDEED\uDF00-\uDF2F\uDF40-\uDF43\uDF50-\uDF59\uDF5B-\uDF61\uDF63-\uDF77\uDF7D-\uDF8F]|\uD81B[\uDE40-\uDE96\uDF00-\uDF4A\uDF50\uDF93-\uDF9F\uDFE0\uDFE1\uDFE3]|\uD821[\uDC00-\uDFF7]|\uD823[\uDC00-\uDCD5\uDD00-\uDD08]|\uD82B[\uDFF0-\uDFF3\uDFF5-\uDFFB\uDFFD\uDFFE]|\uD82C[\uDC00-\uDD22\uDD50-\uDD52\uDD64-\uDD67\uDD70-\uDEFB]|\uD82F[\uDC00-\uDC6A\uDC70-\uDC7C\uDC80-\uDC88\uDC90-\uDC99]|\uD834[\uDEE0-\uDEF3\uDF60-\uDF78]|\uD835[\uDC00-\uDC54\uDC56-\uDC9C\uDC9E\uDC9F\uDCA2\uDCA5\uDCA6\uDCA9-\uDCAC\uDCAE-\uDCB9\uDCBB\uDCBD-\uDCC3\uDCC5-\uDD05\uDD07-\uDD0A\uDD0D-\uDD14\uDD16-\uDD1C\uDD1E-\uDD39\uDD3B-\uDD3E\uDD40-\uDD44\uDD46\uDD4A-\uDD50\uDD52-\uDEA5\uDEA8-\uDEC0\uDEC2-\uDEDA\uDEDC-\uDEFA\uDEFC-\uDF14\uDF16-\uDF34\uDF36-\uDF4E\uDF50-\uDF6E\uDF70-\uDF88\uDF8A-\uDFA8\uDFAA-\uDFC2\uDFC4-\uDFCB\uDFCE-\uDFFF]|\uD837[\uDF00-\uDF1E]|\uD838[\uDD00-\uDD2C\uDD37-\uDD3D\uDD40-\uDD49\uDD4E\uDE90-\uDEAD\uDEC0-\uDEEB\uDEF0-\uDEF9]|\uD839[\uDFE0-\uDFE6\uDFE8-\uDFEB\uDFED\uDFEE\uDFF0-\uDFFE]|\uD83A[\uDC00-\uDCC4\uDCC7-\uDCCF\uDD00-\uDD43\uDD4B\uDD50-\uDD59]|\uD83B[\uDC71-\uDCAB\uDCAD-\uDCAF\uDCB1-\uDCB4\uDD01-\uDD2D\uDD2F-\uDD3D\uDE00-\uDE03\uDE05-\uDE1F\uDE21\uDE22\uDE24\uDE27\uDE29-\uDE32\uDE34-\uDE37\uDE39\uDE3B\uDE42\uDE47\uDE49\uDE4B\uDE4D-\uDE4F\uDE51\uDE52\uDE54\uDE57\uDE59\uDE5B\uDE5D\uDE5F\uDE61\uDE62\uDE64\uDE67-\uDE6A\uDE6C-\uDE72\uDE74-\uDE77\uDE79-\uDE7C\uDE7E\uDE80-\uDE89\uDE8B-\uDE9B\uDEA1-\uDEA3\uDEA5-\uDEA9\uDEAB-\uDEBB]|\uD83C[\uDD00-\uDD0C]|\uD83E[\uDFF0-\uDFF9]|\uD869[\uDC00-\uDEDF\uDF00-\uDFFF]|\uD86D[\uDC00-\uDF38\uDF40-\uDFFF]|\uD86E[\uDC00-\uDC1D\uDC20-\uDFFF]|\uD873[\uDC00-\uDEA1\uDEB0-\uDFFF]|\uD87A[\uDC00-\uDFE0]|\uD87E[\uDC00-\uDE1D]|\uD884[\uDC00-\uDF4A])/))){var o=n[1]||n[2]||"";if(!o||o&&(""===i||this.rules.inline.punctuation.exec(i))){var r,s,a=n[0].length-1,l=a,c=0,d="*"===n[0][0]?this.rules.inline.emStrong.rDelimAst:this.rules.inline.emStrong.rDelimUnd;for(d.lastIndex=0,t=t.slice(-1*e.length+a);null!=(n=d.exec(t));)if(r=n[1]||n[2]||n[3]||n[4]||n[5]||n[6])if(s=r.length,n[3]||n[4])l+=s;else if(!((n[5]||n[6])&&a%3)||(a+s)%3){if(!((l-=s)>0)){if(s=Math.min(s,s+l+c),Math.min(a,s)%2){var u=e.slice(1,a+n.index+s);return{type:"em",raw:e.slice(0,a+n.index+s+1),text:u,tokens:this.lexer.inlineTokens(u)}}var h=e.slice(2,a+n.index+s-1);return{type:"strong",raw:e.slice(0,a+n.index+s+1),text:h,tokens:this.lexer.inlineTokens(h)}}}else c+=s}}},i.codespan=function(e){var t=this.rules.inline.code.exec(e);if(t){var i=t[2].replace(/\n/g," "),n=/[^ ]/.test(i),o=/^ /.test(i)&&/ $/.test(i);return n&&o&&(i=i.substring(1,i.length-1)),i=u(i,!0),{type:"codespan",raw:t[0],text:i}}},i.br=function(e){var t=this.rules.inline.br.exec(e);if(t)return{type:"br",raw:t[0]}},i.del=function(e){var t=this.rules.inline.del.exec(e);if(t)return{type:"del",raw:t[0],text:t[2],tokens:this.lexer.inlineTokens(t[2])}},i.autolink=function(e,t){var i,n,o=this.rules.inline.autolink.exec(e);if(o)return n="@"===o[2]?"mailto:"+(i=u(this.options.mangle?t(o[1]):o[1])):i=u(o[1]),{type:"link",raw:o[0],text:i,href:n,tokens:[{type:"text",raw:i,text:i}]}},i.url=function(e,t){var i;if(i=this.rules.inline.url.exec(e)){var n,o;if("@"===i[2])o="mailto:"+(n=u(this.options.mangle?t(i[0]):i[0]));else{var r;do{r=i[0],i[0]=this.rules.inline._backpedal.exec(i[0])[0]}while(r!==i[0]);n=u(i[0]),o="www."===i[1]?"http://"+n:n}return{type:"link",raw:i[0],text:n,href:o,tokens:[{type:"text",raw:n,text:n}]}}},i.inlineText=function(e,t){var i,n=this.rules.inline.text.exec(e);if(n)return i=this.lexer.state.inRawBlock?this.options.sanitize?this.options.sanitizer?this.options.sanitizer(n[0]):u(n[0]):n[0]:u(this.options.smartypants?t(n[0]):n[0]),{type:"text",raw:n[0],text:i}},t}(),T={newline:/^(?: *(?:\n|$))+/,code:/^( {4}[^\n]+(?:\n(?: *(?:\n|$))*)?)+/,fences:/^ {0,3}(`{3,}(?=[^`\n]*\n)|~{3,})([^\n]*)\n(?:|([\s\S]*?)\n)(?: {0,3}\1[~`]* *(?=\n|$)|$)/,hr:/^ {0,3}((?:-[\t ]*){3,}|(?:_[ \t]*){3,}|(?:\*[ \t]*){3,})(?:\n+|$)/,heading:/^ {0,3}(#{1,6})(?=\s|$)(.*)(?:\n+|$)/,blockquote:/^( {0,3}> ?(paragraph|[^\n]*)(?:\n|$))+/,list:/^( {0,3}bull)([ \t][^\n]+?)?(?:\n|$)/,html:"^ {0,3}(?:<(script|pre|style|textarea)[\\s>][\\s\\S]*?(?:</\\1>[^\\n]*\\n+|$)|comment[^\\n]*(\\n+|$)|<\\?[\\s\\S]*?(?:\\?>\\n*|$)|<![A-Z][\\s\\S]*?(?:>\\n*|$)|<!\\[CDATA\\[[\\s\\S]*?(?:\\]\\]>\\n*|$)|</?(tag)(?: +|\\n|/?>)[\\s\\S]*?(?:(?:\\n *)+\\n|$)|<(?!script|pre|style|textarea)([a-z][\\w-]*)(?:attribute)*? */?>(?=[ \\t]*(?:\\n|$))[\\s\\S]*?(?:(?:\\n *)+\\n|$)|</(?!script|pre|style|textarea)[a-z][\\w-]*\\s*>(?=[ \\t]*(?:\\n|$))[\\s\\S]*?(?:(?:\\n *)+\\n|$))",def:/^ {0,3}\[(label)\]: *(?:\n *)?<?([^\s>]+)>?(?:(?: +(?:\n *)?| *\n *)(title))? *(?:\n+|$)/,table:y,lheading:/^([^\n]+)\n {0,3}(=+|-+) *(?:\n+|$)/,_paragraph:/^([^\n]+(?:\n(?!hr|heading|lheading|blockquote|fences|list|html|table| +\n)[^\n]+)*)/,text:/^[^\n]+/,_label:/(?!\s*\])(?:\\.|[^\[\]\\])+/,_title:/(?:"(?:\\"?|[^"\\])*"|'[^'\n]*(?:\n[^'\n]+)*\n?'|\([^()]*\))/};T.def=m(T.def).replace("label",T._label).replace("title",T._title).getRegex(),T.bullet=/(?:[*+-]|\d{1,9}[.)])/,T.listItemStart=m(/^( *)(bull) */).replace("bull",T.bullet).getRegex(),T.list=m(T.list).replace(/bull/g,T.bullet).replace("hr","\\n+(?=\\1?(?:(?:- *){3,}|(?:_ *){3,}|(?:\\* *){3,})(?:\\n+|$))").replace("def","\\n+(?="+T.def.source+")").getRegex(),T._tag="address|article|aside|base|basefont|blockquote|body|caption|center|col|colgroup|dd|details|dialog|dir|div|dl|dt|fieldset|figcaption|figure|footer|form|frame|frameset|h[1-6]|head|header|hr|html|iframe|legend|li|link|main|menu|menuitem|meta|nav|noframes|ol|optgroup|option|p|param|section|source|summary|table|tbody|td|tfoot|th|thead|title|tr|track|ul",T._comment=/<!--(?!-?>)[\s\S]*?(?:-->|$)/,T.html=m(T.html,"i").replace("comment",T._comment).replace("tag",T._tag).replace("attribute",/ +[a-zA-Z:_][\w.:-]*(?: *= *"[^"\n]*"| *= *'[^'\n]*'| *= *[^\s"'=<>`]+)?/).getRegex(),T.paragraph=m(T._paragraph).replace("hr",T.hr).replace("heading"," {0,3}#{1,6} ").replace("|lheading","").replace("|table","").replace("blockquote"," {0,3}>").replace("fences"," {0,3}(?:`{3,}(?=[^`\\n]*\\n)|~{3,})[^\\n]*\\n").replace("list"," {0,3}(?:[*+-]|1[.)]) ").replace("html","</?(?:tag)(?: +|\\n|/?>)|<(?:script|pre|style|textarea|!--)").replace("tag",T._tag).getRegex(),T.blockquote=m(T.blockquote).replace("paragraph",T.paragraph).getRegex(),T.normal=S({},T),T.gfm=S({},T.normal,{table:"^ *([^\\n ].*\\|.*)\\n {0,3}(?:\\| *)?(:?-+:? *(?:\\| *:?-+:? *)*)(?:\\| *)?(?:\\n((?:(?! *\\n|hr|heading|blockquote|code|fences|list|html).*(?:\\n|$))*)\\n*|$)"}),T.gfm.table=m(T.gfm.table).replace("hr",T.hr).replace("heading"," {0,3}#{1,6} ").replace("blockquote"," {0,3}>").replace("code"," {4}[^\\n]").replace("fences"," {0,3}(?:`{3,}(?=[^`\\n]*\\n)|~{3,})[^\\n]*\\n").replace("list"," {0,3}(?:[*+-]|1[.)]) ").replace("html","</?(?:tag)(?: +|\\n|/?>)|<(?:script|pre|style|textarea|!--)").replace("tag",T._tag).getRegex(),T.gfm.paragraph=m(T._paragraph).replace("hr",T.hr).replace("heading"," {0,3}#{1,6} ").replace("|lheading","").replace("table",T.gfm.table).replace("blockquote"," {0,3}>").replace("fences"," {0,3}(?:`{3,}(?=[^`\\n]*\\n)|~{3,})[^\\n]*\\n").replace("list"," {0,3}(?:[*+-]|1[.)]) ").replace("html","</?(?:tag)(?: +|\\n|/?>)|<(?:script|pre|style|textarea|!--)").replace("tag",T._tag).getRegex(),T.pedantic=S({},T.normal,{html:m("^ *(?:comment *(?:\\n|\\s*$)|<(tag)[\\s\\S]+?</\\1> *(?:\\n{2,}|\\s*$)|<tag(?:\"[^\"]*\"|'[^']*'|\\s[^'\"/>\\s]*)*?/?> *(?:\\n{2,}|\\s*$))").replace("comment",T._comment).replace(/tag/g,"(?!(?:a|em|strong|small|s|cite|q|dfn|abbr|data|time|code|var|samp|kbd|sub|sup|i|b|u|mark|ruby|rt|rp|bdi|bdo|span|br|wbr|ins|del|img)\\b)\\w+(?!:|[^\\w\\s@]*@)\\b").getRegex(),def:/^ *\[([^\]]+)\]: *<?([^\s>]+)>?(?: +(["(][^\n]+[")]))? *(?:\n+|$)/,heading:/^(#{1,6})(.*)(?:\n+|$)/,fences:y,paragraph:m(T.normal._paragraph).replace("hr",T.hr).replace("heading"," *#{1,6} *[^\n]").replace("lheading",T.lheading).replace("blockquote"," {0,3}>").replace("|fences","").replace("|list","").replace("|html","").getRegex()});var M={escape:/^\\([!"#$%&'()*+,\-./:;<=>?@\[\]\\^_`{|}~])/,autolink:/^<(scheme:[^\s\x00-\x1f<>]*|email)>/,url:y,tag:"^comment|^</[a-zA-Z][\\w:-]*\\s*>|^<[a-zA-Z][\\w-]*(?:attribute)*?\\s*/?>|^<\\?[\\s\\S]*?\\?>|^<![a-zA-Z]+\\s[\\s\\S]*?>|^<!\\[CDATA\\[[\\s\\S]*?\\]\\]>",link:/^!?\[(label)\]\(\s*(href)(?:\s+(title))?\s*\)/,reflink:/^!?\[(label)\]\[(ref)\]/,nolink:/^!?\[(ref)\](?:\[\])?/,reflinkSearch:"reflink|nolink(?!\\()",emStrong:{lDelim:/^(?:\*+(?:([punct_])|[^\s*]))|^_+(?:([punct*])|([^\s_]))/,rDelimAst:/^[^_*]*?\_\_[^_*]*?\*[^_*]*?(?=\_\_)|[^*]+(?=[^*])|[punct_](\*+)(?=[\s]|$)|[^punct*_\s](\*+)(?=[punct_\s]|$)|[punct_\s](\*+)(?=[^punct*_\s])|[\s](\*+)(?=[punct_])|[punct_](\*+)(?=[punct_])|[^punct*_\s](\*+)(?=[^punct*_\s])/,rDelimUnd:/^[^_*]*?\*\*[^_*]*?\_[^_*]*?(?=\*\*)|[^_]+(?=[^_])|[punct*](\_+)(?=[\s]|$)|[^punct*_\s](\_+)(?=[punct*\s]|$)|[punct*\s](\_+)(?=[^punct*_\s])|[\s](\_+)(?=[punct*])|[punct*](\_+)(?=[punct*])/},code:/^(`+)([^`]|[^`][\s\S]*?[^`])\1(?!`)/,br:/^( {2,}|\\)\n(?!\s*$)/,del:y,text:/^(`+|[^`])(?:(?= {2,}\n)|[\s\S]*?(?:(?=[\\<!\[`*_]|\b_|$)|[^ ](?= {2,}\n)))/,punctuation:/^([\spunctuation])/};function N(e){return e.replace(/---/g,"—").replace(/--/g,"–").replace(/(^|[-\u2014/(\[{"\s])'/g,"$1‘").replace(/'/g,"’").replace(/(^|[-\u2014/(\[{\u2018\s])"/g,"$1“").replace(/"/g,"”").replace(/\.{3}/g,"…")}function R(e){var t,i,n="",o=e.length;for(t=0;t<o;t++)i=e.charCodeAt(t),Math.random()>.5&&(i="x"+i.toString(16)),n+="&#"+i+";";return n}M._punctuation="!\"#$%&'()+\\-.,/:;<=>?@\\[\\]`^{|}~",M.punctuation=m(M.punctuation).replace(/punctuation/g,M._punctuation).getRegex(),M.blockSkip=/\[[^\]]*?\]\([^\)]*?\)|`[^`]*?`|<[^>]*?>/g,M.escapedEmSt=/\\\*|\\_/g,M._comment=m(T._comment).replace("(?:--\x3e|$)","--\x3e").getRegex(),M.emStrong.lDelim=m(M.emStrong.lDelim).replace(/punct/g,M._punctuation).getRegex(),M.emStrong.rDelimAst=m(M.emStrong.rDelimAst,"g").replace(/punct/g,M._punctuation).getRegex(),M.emStrong.rDelimUnd=m(M.emStrong.rDelimUnd,"g").replace(/punct/g,M._punctuation).getRegex(),M._escapes=/\\([!"#$%&'()*+,\-./:;<=>?@\[\]\\^_`{|}~])/g,M._scheme=/[a-zA-Z][a-zA-Z0-9+.-]{1,31}/,M._email=/[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+(@)[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)+(?![-_])/,M.autolink=m(M.autolink).replace("scheme",M._scheme).replace("email",M._email).getRegex(),M._attribute=/\s+[a-zA-Z:_][\w.:-]*(?:\s*=\s*"[^"]*"|\s*=\s*'[^']*'|\s*=\s*[^\s"'=<>`]+)?/,M.tag=m(M.tag).replace("comment",M._comment).replace("attribute",M._attribute).getRegex(),M._label=/(?:\[(?:\\.|[^\[\]\\])*\]|\\.|`[^`]*`|[^\[\]\\`])*?/,M._href=/<(?:\\.|[^\n<>\\])+>|[^\s\x00-\x1f]*/,M._title=/"(?:\\"?|[^"\\])*"|'(?:\\'?|[^'\\])*'|\((?:\\\)?|[^)\\])*\)/,M.link=m(M.link).replace("label",M._label).replace("href",M._href).replace("title",M._title).getRegex(),M.reflink=m(M.reflink).replace("label",M._label).replace("ref",T._label).getRegex(),M.nolink=m(M.nolink).replace("ref",T._label).getRegex(),M.reflinkSearch=m(M.reflinkSearch,"g").replace("reflink",M.reflink).replace("nolink",M.nolink).getRegex(),M.normal=S({},M),M.pedantic=S({},M.normal,{strong:{start:/^__|\*\*/,middle:/^__(?=\S)([\s\S]*?\S)__(?!_)|^\*\*(?=\S)([\s\S]*?\S)\*\*(?!\*)/,endAst:/\*\*(?!\*)/g,endUnd:/__(?!_)/g},em:{start:/^_|\*/,middle:/^()\*(?=\S)([\s\S]*?\S)\*(?!\*)|^_(?=\S)([\s\S]*?\S)_(?!_)/,endAst:/\*(?!\*)/g,endUnd:/_(?!_)/g},link:m(/^!?\[(label)\]\((.*?)\)/).replace("label",M._label).getRegex(),reflink:m(/^!?\[(label)\]\s*\[([^\]]*)\]/).replace("label",M._label).getRegex()}),M.gfm=S({},M.normal,{escape:m(M.escape).replace("])","~|])").getRegex(),_extended_email:/[A-Za-z0-9._+-]+(@)[a-zA-Z0-9-_]+(?:\.[a-zA-Z0-9-_]*[a-zA-Z0-9])+(?![-_])/,url:/^((?:ftp|https?):\/\/|www\.)(?:[a-zA-Z0-9\-]+\.?)+[^\s<]*|^email/,_backpedal:/(?:[^?!.,:;*_~()&]+|\([^)]*\)|&(?![a-zA-Z0-9]+;$)|[?!.,:;*_~)]+(?!$))+/,del:/^(~~?)(?=[^\s~])([\s\S]*?[^\s~])\1(?=[^~]|$)/,text:/^([`~]+|[^`~])(?:(?= {2,}\n)|(?=[a-zA-Z0-9.!#$%&'*+\/=?_`{\|}~-]+@)|[\s\S]*?(?:(?=[\\<!\[`*~_]|\b_|https?:\/\/|ftp:\/\/|www\.|$)|[^ ](?= {2,}\n)|[^a-zA-Z0-9.!#$%&'*+\/=?_`{\|}~-](?=[a-zA-Z0-9.!#$%&'*+\/=?_`{\|}~-]+@)))/}),M.gfm.url=m(M.gfm.url,"i").replace("email",M.gfm._extended_email).getRegex(),M.breaks=S({},M.gfm,{br:m(M.br).replace("{2,}","*").getRegex(),text:m(M.gfm.text).replace("\\b_","\\b_| {2,}\\n").replace(/\{2,\}/g,"*").getRegex()});var B=function(){function i(t){this.tokens=[],this.tokens.links=Object.create(null),this.options=t||e.defaults,this.options.tokenizer=this.options.tokenizer||new L,this.tokenizer=this.options.tokenizer,this.tokenizer.options=this.options,this.tokenizer.lexer=this,this.inlineQueue=[],this.state={inLink:!1,inRawBlock:!1,top:!0};var i={block:T.normal,inline:M.normal};this.options.pedantic?(i.block=T.pedantic,i.inline=M.pedantic):this.options.gfm&&(i.block=T.gfm,this.options.breaks?i.inline=M.breaks:i.inline=M.gfm),this.tokenizer.rules=i}i.lex=function(e,t){return new i(t).lex(e)},i.lexInline=function(e,t){return new i(t).inlineTokens(e)};var n,o,r,s=i.prototype;return s.lex=function(e){var t;for(e=e.replace(/\r\n|\r/g,"\n"),this.blockTokens(e,this.tokens);t=this.inlineQueue.shift();)this.inlineTokens(t.src,t.tokens);return this.tokens},s.blockTokens=function(e,t){var i,n,o,r,s=this;for(void 0===t&&(t=[]),e=this.options.pedantic?e.replace(/\t/g,"    ").replace(/^ +$/gm,""):e.replace(/^( *)(\t+)/gm,(function(e,t,i){return t+"    ".repeat(i.length)}));e;)if(!(this.options.extensions&&this.options.extensions.block&&this.options.extensions.block.some((function(n){return!!(i=n.call({lexer:s},e,t))&&(e=e.substring(i.raw.length),t.push(i),!0)}))))if(i=this.tokenizer.space(e))e=e.substring(i.raw.length),1===i.raw.length&&t.length>0?t[t.length-1].raw+="\n":t.push(i);else if(i=this.tokenizer.code(e))e=e.substring(i.raw.length),!(n=t[t.length-1])||"paragraph"!==n.type&&"text"!==n.type?t.push(i):(n.raw+="\n"+i.raw,n.text+="\n"+i.text,this.inlineQueue[this.inlineQueue.length-1].src=n.text);else if(i=this.tokenizer.fences(e))e=e.substring(i.raw.length),t.push(i);else if(i=this.tokenizer.heading(e))e=e.substring(i.raw.length),t.push(i);else if(i=this.tokenizer.hr(e))e=e.substring(i.raw.length),t.push(i);else if(i=this.tokenizer.blockquote(e))e=e.substring(i.raw.length),t.push(i);else if(i=this.tokenizer.list(e))e=e.substring(i.raw.length),t.push(i);else if(i=this.tokenizer.html(e))e=e.substring(i.raw.length),t.push(i);else if(i=this.tokenizer.def(e))e=e.substring(i.raw.length),!(n=t[t.length-1])||"paragraph"!==n.type&&"text"!==n.type?this.tokens.links[i.tag]||(this.tokens.links[i.tag]={href:i.href,title:i.title}):(n.raw+="\n"+i.raw,n.text+="\n"+i.raw,this.inlineQueue[this.inlineQueue.length-1].src=n.text);else if(i=this.tokenizer.table(e))e=e.substring(i.raw.length),t.push(i);else if(i=this.tokenizer.lheading(e))e=e.substring(i.raw.length),t.push(i);else if(o=e,this.options.extensions&&this.options.extensions.startBlock&&function(){var t=1/0,i=e.slice(1),n=void 0;s.options.extensions.startBlock.forEach((function(e){"number"==typeof(n=e.call({lexer:this},i))&&n>=0&&(t=Math.min(t,n))})),t<1/0&&t>=0&&(o=e.substring(0,t+1))}(),this.state.top&&(i=this.tokenizer.paragraph(o)))n=t[t.length-1],r&&"paragraph"===n.type?(n.raw+="\n"+i.raw,n.text+="\n"+i.text,this.inlineQueue.pop(),this.inlineQueue[this.inlineQueue.length-1].src=n.text):t.push(i),r=o.length!==e.length,e=e.substring(i.raw.length);else if(i=this.tokenizer.text(e))e=e.substring(i.raw.length),(n=t[t.length-1])&&"text"===n.type?(n.raw+="\n"+i.raw,n.text+="\n"+i.text,this.inlineQueue.pop(),this.inlineQueue[this.inlineQueue.length-1].src=n.text):t.push(i);else if(e){var a="Infinite loop on byte: "+e.charCodeAt(0);if(this.options.silent){console.error(a);break}throw new Error(a)}return this.state.top=!0,t},s.inline=function(e,t){return void 0===t&&(t=[]),this.inlineQueue.push({src:e,tokens:t}),t},s.inlineTokens=function(e,t){var i,n,o,r=this;void 0===t&&(t=[]);var s,a,l,c=e;if(this.tokens.links){var d=Object.keys(this.tokens.links);if(d.length>0)for(;null!=(s=this.tokenizer.rules.inline.reflinkSearch.exec(c));)d.includes(s[0].slice(s[0].lastIndexOf("[")+1,-1))&&(c=c.slice(0,s.index)+"["+D("a",s[0].length-2)+"]"+c.slice(this.tokenizer.rules.inline.reflinkSearch.lastIndex))}for(;null!=(s=this.tokenizer.rules.inline.blockSkip.exec(c));)c=c.slice(0,s.index)+"["+D("a",s[0].length-2)+"]"+c.slice(this.tokenizer.rules.inline.blockSkip.lastIndex);for(;null!=(s=this.tokenizer.rules.inline.escapedEmSt.exec(c));)c=c.slice(0,s.index)+"++"+c.slice(this.tokenizer.rules.inline.escapedEmSt.lastIndex);for(;e;)if(a||(l=""),a=!1,!(this.options.extensions&&this.options.extensions.inline&&this.options.extensions.inline.some((function(n){return!!(i=n.call({lexer:r},e,t))&&(e=e.substring(i.raw.length),t.push(i),!0)}))))if(i=this.tokenizer.escape(e))e=e.substring(i.raw.length),t.push(i);else if(i=this.tokenizer.tag(e))e=e.substring(i.raw.length),(n=t[t.length-1])&&"text"===i.type&&"text"===n.type?(n.raw+=i.raw,n.text+=i.text):t.push(i);else if(i=this.tokenizer.link(e))e=e.substring(i.raw.length),t.push(i);else if(i=this.tokenizer.reflink(e,this.tokens.links))e=e.substring(i.raw.length),(n=t[t.length-1])&&"text"===i.type&&"text"===n.type?(n.raw+=i.raw,n.text+=i.text):t.push(i);else if(i=this.tokenizer.emStrong(e,c,l))e=e.substring(i.raw.length),t.push(i);else if(i=this.tokenizer.codespan(e))e=e.substring(i.raw.length),t.push(i);else if(i=this.tokenizer.br(e))e=e.substring(i.raw.length),t.push(i);else if(i=this.tokenizer.del(e))e=e.substring(i.raw.length),t.push(i);else if(i=this.tokenizer.autolink(e,R))e=e.substring(i.raw.length),t.push(i);else if(this.state.inLink||!(i=this.tokenizer.url(e,R))){if(o=e,this.options.extensions&&this.options.extensions.startInline&&function(){var t=1/0,i=e.slice(1),n=void 0;r.options.extensions.startInline.forEach((function(e){"number"==typeof(n=e.call({lexer:this},i))&&n>=0&&(t=Math.min(t,n))})),t<1/0&&t>=0&&(o=e.substring(0,t+1))}(),i=this.tokenizer.inlineText(o,N))e=e.substring(i.raw.length),"_"!==i.raw.slice(-1)&&(l=i.raw.slice(-1)),a=!0,(n=t[t.length-1])&&"text"===n.type?(n.raw+=i.raw,n.text+=i.text):t.push(i);else if(e){var u="Infinite loop on byte: "+e.charCodeAt(0);if(this.options.silent){console.error(u);break}throw new Error(u)}}else e=e.substring(i.raw.length),t.push(i);return t},n=i,r=[{key:"rules",get:function(){return{block:T,inline:M}}}],(o=null)&&t(n.prototype,o),r&&t(n,r),Object.defineProperty(n,"prototype",{writable:!1}),i}(),O=function(){function t(t){this.options=t||e.defaults}var i=t.prototype;return i.code=function(e,t,i){var n=(t||"").match(/\S*/)[0];if(this.options.highlight){var o=this.options.highlight(e,n);null!=o&&o!==e&&(i=!0,e=o)}return e=e.replace(/\n$/,"")+"\n",n?'<pre><code class="'+this.options.langPrefix+u(n,!0)+'">'+(i?e:u(e,!0))+"</code></pre>\n":"<pre><code>"+(i?e:u(e,!0))+"</code></pre>\n"},i.blockquote=function(e){return"<blockquote>\n"+e+"</blockquote>\n"},i.html=function(e){return e},i.heading=function(e,t,i,n){return this.options.headerIds?"<h"+t+' id="'+(this.options.headerPrefix+n.slug(i))+'">'+e+"</h"+t+">\n":"<h"+t+">"+e+"</h"+t+">\n"},i.hr=function(){return this.options.xhtml?"<hr/>\n":"<hr>\n"},i.list=function(e,t,i){var n=t?"ol":"ul";return"<"+n+(t&&1!==i?' start="'+i+'"':"")+">\n"+e+"</"+n+">\n"},i.listitem=function(e){return"<li>"+e+"</li>\n"},i.checkbox=function(e){return"<input "+(e?'checked="" ':"")+'disabled="" type="checkbox"'+(this.options.xhtml?" /":"")+"> "},i.paragraph=function(e){return"<p>"+e+"</p>\n"},i.table=function(e,t){return t&&(t="<tbody>"+t+"</tbody>"),"<table>\n<thead>\n"+e+"</thead>\n"+t+"</table>\n"},i.tablerow=function(e){return"<tr>\n"+e+"</tr>\n"},i.tablecell=function(e,t){var i=t.header?"th":"td";return(t.align?"<"+i+' align="'+t.align+'">':"<"+i+">")+e+"</"+i+">\n"},i.strong=function(e){return"<strong>"+e+"</strong>"},i.em=function(e){return"<em>"+e+"</em>"},i.codespan=function(e){return"<code>"+e+"</code>"},i.br=function(){return this.options.xhtml?"<br/>":"<br>"},i.del=function(e){return"<del>"+e+"</del>"},i.link=function(e,t,i){if(null===(e=v(this.options.sanitize,this.options.baseUrl,e)))return i;var n='<a href="'+u(e)+'"';return t&&(n+=' title="'+t+'"'),n+=">"+i+"</a>"},i.image=function(e,t,i){if(null===(e=v(this.options.sanitize,this.options.baseUrl,e)))return i;var n='<img src="'+e+'" alt="'+i+'"';return t&&(n+=' title="'+t+'"'),n+=this.options.xhtml?"/>":">"},i.text=function(e){return e},t}(),F=function(){function e(){}var t=e.prototype;return t.strong=function(e){return e},t.em=function(e){return e},t.codespan=function(e){return e},t.del=function(e){return e},t.html=function(e){return e},t.text=function(e){return e},t.link=function(e,t,i){return""+i},t.image=function(e,t,i){return""+i},t.br=function(){return""},e}(),P=function(){function e(){this.seen={}}var t=e.prototype;return t.serialize=function(e){return e.toLowerCase().trim().replace(/<[!\/a-z].*?>/gi,"").replace(/[\u2000-\u206F\u2E00-\u2E7F\\'!"#$%&()*+,./:;<=>?@[\]^`{|}~]/g,"").replace(/\s/g,"-")},t.getNextSafeSlug=function(e,t){var i=e,n=0;if(this.seen.hasOwnProperty(i)){n=this.seen[e];do{i=e+"-"+ ++n}while(this.seen.hasOwnProperty(i))}return t||(this.seen[e]=n,this.seen[i]=0),i},t.slug=function(e,t){void 0===t&&(t={});var i=this.serialize(e);return this.getNextSafeSlug(i,t.dryrun)},e}(),z=function(){function t(t){this.options=t||e.defaults,this.options.renderer=this.options.renderer||new O,this.renderer=this.options.renderer,this.renderer.options=this.options,this.textRenderer=new F,this.slugger=new P}t.parse=function(e,i){return new t(i).parse(e)},t.parseInline=function(e,i){return new t(i).parseInline(e)};var i=t.prototype;return i.parse=function(e,t){void 0===t&&(t=!0);var i,n,o,r,s,a,l,c,d,u,h,p,m,f,b,v,_,A,C,w="",y=e.length;for(i=0;i<y;i++)if(u=e[i],!(this.options.extensions&&this.options.extensions.renderers&&this.options.extensions.renderers[u.type])||!1===(C=this.options.extensions.renderers[u.type].call({parser:this},u))&&["space","hr","heading","code","table","blockquote","list","html","paragraph","text"].includes(u.type))switch(u.type){case"space":continue;case"hr":w+=this.renderer.hr();continue;case"heading":w+=this.renderer.heading(this.parseInline(u.tokens),u.depth,g(this.parseInline(u.tokens,this.textRenderer)),this.slugger);continue;case"code":w+=this.renderer.code(u.text,u.lang,u.escaped);continue;case"table":for(c="",l="",r=u.header.length,n=0;n<r;n++)l+=this.renderer.tablecell(this.parseInline(u.header[n].tokens),{header:!0,align:u.align[n]});for(c+=this.renderer.tablerow(l),d="",r=u.rows.length,n=0;n<r;n++){for(l="",s=(a=u.rows[n]).length,o=0;o<s;o++)l+=this.renderer.tablecell(this.parseInline(a[o].tokens),{header:!1,align:u.align[o]});d+=this.renderer.tablerow(l)}w+=this.renderer.table(c,d);continue;case"blockquote":d=this.parse(u.tokens),w+=this.renderer.blockquote(d);continue;case"list":for(h=u.ordered,p=u.start,m=u.loose,r=u.items.length,d="",n=0;n<r;n++)v=(b=u.items[n]).checked,_=b.task,f="",b.task&&(A=this.renderer.checkbox(v),m?b.tokens.length>0&&"paragraph"===b.tokens[0].type?(b.tokens[0].text=A+" "+b.tokens[0].text,b.tokens[0].tokens&&b.tokens[0].tokens.length>0&&"text"===b.tokens[0].tokens[0].type&&(b.tokens[0].tokens[0].text=A+" "+b.tokens[0].tokens[0].text)):b.tokens.unshift({type:"text",text:A}):f+=A),f+=this.parse(b.tokens,m),d+=this.renderer.listitem(f,_,v);w+=this.renderer.list(d,h,p);continue;case"html":w+=this.renderer.html(u.text);continue;case"paragraph":w+=this.renderer.paragraph(this.parseInline(u.tokens));continue;case"text":for(d=u.tokens?this.parseInline(u.tokens):u.text;i+1<y&&"text"===e[i+1].type;)d+="\n"+((u=e[++i]).tokens?this.parseInline(u.tokens):u.text);w+=t?this.renderer.paragraph(d):d;continue;default:var S='Token with "'+u.type+'" type was not found.';if(this.options.silent)return void console.error(S);throw new Error(S)}else w+=C||"";return w},i.parseInline=function(e,t){t=t||this.renderer;var i,n,o,r="",s=e.length;for(i=0;i<s;i++)if(n=e[i],!(this.options.extensions&&this.options.extensions.renderers&&this.options.extensions.renderers[n.type])||!1===(o=this.options.extensions.renderers[n.type].call({parser:this},n))&&["escape","html","link","image","strong","em","codespan","br","del","text"].includes(n.type))switch(n.type){case"escape":case"text":r+=t.text(n.text);break;case"html":r+=t.html(n.text);break;case"link":r+=t.link(n.href,n.title,this.parseInline(n.tokens,t));break;case"image":r+=t.image(n.href,n.title,n.text);break;case"strong":r+=t.strong(this.parseInline(n.tokens,t));break;case"em":r+=t.em(this.parseInline(n.tokens,t));break;case"codespan":r+=t.codespan(n.text);break;case"br":r+=t.br();break;case"del":r+=t.del(this.parseInline(n.tokens,t));break;default:var a='Token with "'+n.type+'" type was not found.';if(this.options.silent)return void console.error(a);throw new Error(a)}else r+=o||"";return r},t}();function W(e,t,i){if(null==e)throw new Error("marked(): input parameter is undefined or null");if("string"!=typeof e)throw new Error("marked(): input parameter is of type "+Object.prototype.toString.call(e)+", string expected");if("function"==typeof t&&(i=t,t=null),k(t=S({},W.defaults,t||{})),i){var n,o=t.highlight;try{n=B.lex(e,t)}catch(e){return i(e)}var r=function(e){var r;if(!e)try{t.walkTokens&&W.walkTokens(n,t.walkTokens),r=z.parse(n,t)}catch(t){e=t}return t.highlight=o,e?i(e):i(null,r)};if(!o||o.length<3)return r();if(delete t.highlight,!n.length)return r();var s=0;return W.walkTokens(n,(function(e){"code"===e.type&&(s++,setTimeout((function(){o(e.text,e.lang,(function(t,i){if(t)return r(t);null!=i&&i!==e.text&&(e.text=i,e.escaped=!0),0===--s&&r()}))}),0))})),void(0===s&&r())}function a(e){if(e.message+="\nPlease report this to https://github.com/markedjs/marked.",t.silent)return"<p>An error occurred:</p><pre>"+u(e.message+"",!0)+"</pre>";throw e}try{var l=B.lex(e,t);if(t.walkTokens){if(t.async)return Promise.all(W.walkTokens(l,t.walkTokens)).then((function(){return z.parse(l,t)})).catch(a);W.walkTokens(l,t.walkTokens)}return z.parse(l,t)}catch(e){a(e)}}W.options=W.setOptions=function(t){var i;return S(W.defaults,t),i=W.defaults,e.defaults=i,W},W.getDefaults=o,W.defaults=e.defaults,W.use=function(){for(var e=arguments.length,t=new Array(e),i=0;i<e;i++)t[i]=arguments[i];var n,o=S.apply(void 0,[{}].concat(t)),r=W.defaults.extensions||{renderers:{},childTokens:{}};t.forEach((function(e){if(e.extensions&&(n=!0,e.extensions.forEach((function(e){if(!e.name)throw new Error("extension name required");if(e.renderer){var t=r.renderers?r.renderers[e.name]:null;r.renderers[e.name]=t?function(){for(var i=arguments.length,n=new Array(i),o=0;o<i;o++)n[o]=arguments[o];var r=e.renderer.apply(this,n);return!1===r&&(r=t.apply(this,n)),r}:e.renderer}if(e.tokenizer){if(!e.level||"block"!==e.level&&"inline"!==e.level)throw new Error("extension level must be 'block' or 'inline'");r[e.level]?r[e.level].unshift(e.tokenizer):r[e.level]=[e.tokenizer],e.start&&("block"===e.level?r.startBlock?r.startBlock.push(e.start):r.startBlock=[e.start]:"inline"===e.level&&(r.startInline?r.startInline.push(e.start):r.startInline=[e.start]))}e.childTokens&&(r.childTokens[e.name]=e.childTokens)}))),e.renderer&&function(){var t=W.defaults.renderer||new O,i=function(i){var n=t[i];t[i]=function(){for(var o=arguments.length,r=new Array(o),s=0;s<o;s++)r[s]=arguments[s];var a=e.renderer[i].apply(t,r);return!1===a&&(a=n.apply(t,r)),a}};for(var n in e.renderer)i(n);o.renderer=t}(),e.tokenizer&&function(){var t=W.defaults.tokenizer||new L,i=function(i){var n=t[i];t[i]=function(){for(var o=arguments.length,r=new Array(o),s=0;s<o;s++)r[s]=arguments[s];var a=e.tokenizer[i].apply(t,r);return!1===a&&(a=n.apply(t,r)),a}};for(var n in e.tokenizer)i(n);o.tokenizer=t}(),e.walkTokens){var t=W.defaults.walkTokens;o.walkTokens=function(i){var n=[];return n.push(e.walkTokens.call(this,i)),t&&(n=n.concat(t.call(this,i))),n}}n&&(o.extensions=r),W.setOptions(o)}))},W.walkTokens=function(e,t){for(var i,o=[],r=function(){var e=i.value;switch(o=o.concat(t.call(W,e)),e.type){case"table":for(var r,s=n(e.header);!(r=s()).done;){var a=r.value;o=o.concat(W.walkTokens(a.tokens,t))}for(var l,c=n(e.rows);!(l=c()).done;)for(var d,u=n(l.value);!(d=u()).done;){var h=d.value;o=o.concat(W.walkTokens(h.tokens,t))}break;case"list":o=o.concat(W.walkTokens(e.items,t));break;default:W.defaults.extensions&&W.defaults.extensions.childTokens&&W.defaults.extensions.childTokens[e.type]?W.defaults.extensions.childTokens[e.type].forEach((function(i){o=o.concat(W.walkTokens(e[i],t))})):e.tokens&&(o=o.concat(W.walkTokens(e.tokens,t)))}},s=n(e);!(i=s()).done;)r();return o},W.parseInline=function(e,t){if(null==e)throw new Error("marked.parseInline(): input parameter is undefined or null");if("string"!=typeof e)throw new Error("marked.parseInline(): input parameter is of type "+Object.prototype.toString.call(e)+", string expected");k(t=S({},W.defaults,t||{}));try{var i=B.lexInline(e,t);return t.walkTokens&&W.walkTokens(i,t.walkTokens),z.parseInline(i,t)}catch(e){if(e.message+="\nPlease report this to https://github.com/markedjs/marked.",t.silent)return"<p>An error occurred:</p><pre>"+u(e.message+"",!0)+"</pre>";throw e}},W.Parser=z,W.parser=z.parse,W.Renderer=O,W.TextRenderer=F,W.Lexer=B,W.lexer=B.lex,W.Tokenizer=L,W.Slugger=P,W.parse=W;var H=W.options,V=W.setOptions,U=W.use,Q=W.walkTokens,K=W.parseInline,j=W,G=z.parse,q=B.lex;e.Lexer=B,e.Parser=z,e.Renderer=O,e.Slugger=P,e.TextRenderer=F,e.Tokenizer=L,e.getDefaults=o,e.lexer=q,e.marked=W,e.options=H,e.parse=j,e.parseInline=K,e.parser=G,e.setOptions=V,e.use=U,e.walkTokens=Q,Object.defineProperty(e,"__esModule",{value:!0})}))}();var o=n.Lexer||exports.Lexer,r=n.Parser||exports.Parser,s=n.Renderer||exports.Renderer,a=n.Slugger||exports.Slugger,l=n.TextRenderer||exports.TextRenderer,c=n.Tokenizer||exports.Tokenizer,d=n.getDefaults||exports.getDefaults,u=n.lexer||exports.lexer,h=n.marked||exports.marked,g=n.options||exports.options,p=n.parse||exports.parse,m=n.parseInline||exports.parseInline,f=n.parser||exports.parser,b=n.setOptions||exports.setOptions,v=n.use||exports.use,_=n.walkTokens||exports.walkTokens},61098:function(e,t,i){"use strict";i.r(t),i.d(t,{parse:function(){return s},revive:function(){return l},stringify:function(){return r}});var n=i(44913),o=i(19300);function r(e){return JSON.stringify(e,a)}function s(e){let t=JSON.parse(e);return t=l(t),t}function a(e,t){return t instanceof RegExp?{$mid:2,source:t.source,flags:t.flags}:t}function l(e,t=0){if(!e||t>200)return e;if("object"==typeof e){switch(e.$mid){case 1:return o.URI.revive(e);case 2:return new RegExp(e.source,e.flags);case 17:return new Date(e.source)}if(e instanceof n.VSBuffer||e instanceof Uint8Array)return e;if(Array.isArray(e))for(let i=0;i<e.length;++i)e[i]=l(e[i],t+1);else for(const i in e)Object.hasOwnProperty.call(e,i)&&(e[i]=l(e[i],t+1))}return e}},5121:function(e,t,i){"use strict";i.r(t),i.d(t,{Mimes:function(){return n}});const n=Object.freeze({text:"text/plain",binary:"application/octet-stream",unknown:"application/unknown",markdown:"text/markdown",latex:"text/latex",uriList:"text/uri-list"})},73264:function(e,t,i){"use strict";function n(e){const t=function(e){if(o=0,s(e,a,4352),o>0)return r.subarray(0,o);if(s(e,l,4449),o>0)return r.subarray(0,o);if(s(e,c,4520),o>0)return r.subarray(0,o);if(s(e,d,12593),o)return r.subarray(0,o);if(e>=44032&&e<=55203){const t=e-44032,i=t%588,n=Math.floor(t/588),u=Math.floor(i/28),h=i%28-1;if(n<a.length?s(n,a,0):4352+n-12593<d.length&&s(4352+n,d,12593),u<l.length?s(u,l,0):4449+u-12593<d.length&&s(4449+u-12593,d,12593),h>=0&&(h<c.length?s(h,c,0):4520+h-12593<d.length&&s(4520+h-12593,d,12593)),o>0)return r.subarray(0,o)}return}(e);if(t&&t.length>0)return new Uint32Array(t)}i.r(t),i.d(t,{getKoreanAltChars:function(){return n}});let o=0;const r=new Uint32Array(10);function s(e,t,i){e>=i&&e<i+t.length&&function(e){if(0===e)return;r[o++]=255&e,e>>8&&(r[o++]=e>>8&255);e>>16&&(r[o++]=e>>16&255)}(t[e-i])}const a=new Uint8Array([114,82,115,101,69,102,97,113,81,116,84,100,119,87,99,122,120,118,103]),l=new Uint16Array([107,111,105,79,106,112,117,80,104,27496,28520,27752,121,110,27246,28782,27758,98,109,27757,108]),c=new Uint16Array([114,82,29810,115,30579,26483,101,102,29286,24934,29030,29798,30822,30310,26470,97,113,29809,116,84,100,119,99,122,120,118,103]),d=new Uint16Array([114,82,29810,115,30579,26483,101,69,102,29286,24934,29030,29798,30822,30310,26470,97,113,81,29809,116,84,100,119,87,99,122,120,118,103,107,111,105,79,106,112,117,80,104,27496,28520,27752,121,110,27246,28782,27758,98,109,27757,108])},27582:function(e,t,i){"use strict";i.r(t),i.d(t,{ArrayNavigator:function(){return n}});class n{constructor(e,t=0,i=e.length,n=t-1){this.items=e,this.start=t,this.end=i,this.index=n}current(){return this.index===this.start-1||this.index===this.end?null:this.items[this.index]}next(){return this.index=Math.min(this.index+1,this.end),this.current()}previous(){return this.index=Math.max(this.index-1,this.start-1),this.current()}first(){return this.index=this.start,this.current()}last(){return this.index=this.end-1,this.current()}}},27952:function(e,t,i){"use strict";i.r(t),i.d(t,{COI:function(){return m},FileAccess:function(){return p},RemoteAuthorities:function(){return u},Schemas:function(){return n},VSCODE_AUTHORITY:function(){return h},connectionTokenQueryName:function(){return d},matchesScheme:function(){return l},matchesSomeScheme:function(){return c}});var n,o=i(12718),r=i(66719),s=i(91482),a=i(19300);function l(e,t){return a.URI.isUri(e)?(0,s.equalsIgnoreCase)(e.scheme,t):(0,s.startsWithIgnoreCase)(e,t+":")}function c(e,...t){return t.some((t=>l(e,t)))}!function(e){e.inMemory="inmemory",e.vscode="vscode",e.internal="private",e.walkThrough="walkThrough",e.walkThroughSnippet="walkThroughSnippet",e.http="http",e.https="https",e.file="file",e.mailto="mailto",e.untitled="untitled",e.data="data",e.command="command",e.vscodeRemote="vscode-remote",e.vscodeRemoteResource="vscode-remote-resource",e.vscodeManagedRemoteResource="vscode-managed-remote-resource",e.vscodeUserData="vscode-userdata",e.vscodeCustomEditor="vscode-custom-editor",e.vscodeNotebookCell="vscode-notebook-cell",e.vscodeNotebookCellMetadata="vscode-notebook-cell-metadata",e.vscodeNotebookCellOutput="vscode-notebook-cell-output",e.vscodeInteractiveInput="vscode-interactive-input",e.vscodeSettings="vscode-settings",e.vscodeWorkspaceTrust="vscode-workspace-trust",e.vscodeTerminal="vscode-terminal",e.vscodeChatSesssion="vscode-chat-editor",e.webviewPanel="webview-panel",e.vscodeWebview="vscode-webview",e.extension="extension",e.vscodeFileResource="vscode-file",e.tmp="tmp",e.vsls="vsls",e.vscodeSourceControl="vscode-scm"}(n||(n={}));const d="tkn";const u=new class{constructor(){this._hosts=Object.create(null),this._ports=Object.create(null),this._connectionTokens=Object.create(null),this._preferredWebSchema="http",this._delegate=null,this._remoteResourcesPath=`/${n.vscodeRemoteResource}`}setPreferredWebSchema(e){this._preferredWebSchema=e}rewrite(e){if(this._delegate)try{return this._delegate(e)}catch(t){return o.onUnexpectedError(t),e}const t=e.authority;let i=this._hosts[t];i&&-1!==i.indexOf(":")&&-1===i.indexOf("[")&&(i=`[${i}]`);const s=this._ports[t],l=this._connectionTokens[t];let c=`path=${encodeURIComponent(e.path)}`;return"string"==typeof l&&(c+=`&${d}=${encodeURIComponent(l)}`),a.URI.from({scheme:r.isWeb?this._preferredWebSchema:n.vscodeRemoteResource,authority:`${i}:${s}`,path:this._remoteResourcesPath,query:c})}},h="vscode-app";class g{uriToBrowserUri(e){return e.scheme===n.vscodeRemote?u.rewrite(e):e.scheme!==n.file||!r.isNative&&r.webWorkerOrigin!==`${n.vscodeFileResource}://${g.FALLBACK_AUTHORITY}`?e:e.with({scheme:n.vscodeFileResource,authority:e.authority||g.FALLBACK_AUTHORITY,query:null,fragment:null})}}g.FALLBACK_AUTHORITY=h;const p=new g;var m;!function(e){const t=new Map([["1",{"Cross-Origin-Opener-Policy":"same-origin"}],["2",{"Cross-Origin-Embedder-Policy":"require-corp"}],["3",{"Cross-Origin-Opener-Policy":"same-origin","Cross-Origin-Embedder-Policy":"require-corp"}]]);e.CoopAndCoep=Object.freeze(t.get("3"));const i="vscode-coi";e.getHeadersFromQuery=function(e){let n;"string"==typeof e?n=new URL(e).searchParams:e instanceof URL?n=e.searchParams:a.URI.isUri(e)&&(n=new URL(e.toString(!0)).searchParams);const o=null==n?void 0:n.get(i);if(o)return t.get(o)},e.addSearchParam=function(e,t,n){if(!globalThis.crossOriginIsolated)return;const o=t&&n?"3":n?"2":"1";e instanceof URLSearchParams?e.set(i,o):e[i]=o}}(m||(m={}))},53719:function(e,t,i){"use strict";function n(e,t,i){return Math.min(Math.max(e,t),i)}i.r(t),i.d(t,{MovingAverage:function(){return o},SlidingWindowAverage:function(){return r},clamp:function(){return n}});class o{constructor(){this._n=1,this._val=0}update(e){return this._val=this._val+(e-this._val)/this._n,this._n+=1,this._val}get value(){return this._val}}class r{constructor(e){this._n=0,this._val=0,this._values=[],this._index=0,this._sum=0,this._values=new Array(e),this._values.fill(0,0,e)}update(e){const t=this._values[this._index];return this._values[this._index]=e,this._index=(this._index+1)%this._values.length,this._sum-=t,this._sum+=e,this._n<this._values.length&&(this._n+=1),this._val=this._sum/this._n,this._val}get value(){return this._val}}},91057:function(e,t,i){"use strict";i.r(t),i.d(t,{cloneAndChange:function(){return a},createProxyObject:function(){return g},deepClone:function(){return o},deepFreeze:function(){return r},equals:function(){return d},getAllMethodNames:function(){return h},getAllPropertyNames:function(){return u},mixin:function(){return c}});var n=i(18912);function o(e){if(!e||"object"!=typeof e)return e;if(e instanceof RegExp)return e;const t=Array.isArray(e)?[]:{};return Object.entries(e).forEach((([e,i])=>{t[e]=i&&"object"==typeof i?o(i):i})),t}function r(e){if(!e||"object"!=typeof e)return e;const t=[e];for(;t.length>0;){const e=t.shift();Object.freeze(e);for(const i in e)if(s.call(e,i)){const o=e[i];"object"!=typeof o||Object.isFrozen(o)||(0,n.isTypedArray)(o)||t.push(o)}}return e}const s=Object.prototype.hasOwnProperty;function a(e,t){return l(e,t,new Set)}function l(e,t,i){if((0,n.isUndefinedOrNull)(e))return e;const o=t(e);if(void 0!==o)return o;if(Array.isArray(e)){const n=[];for(const o of e)n.push(l(o,t,i));return n}if((0,n.isObject)(e)){if(i.has(e))throw new Error("Cannot clone recursive data-structure");i.add(e);const n={};for(const o in e)s.call(e,o)&&(n[o]=l(e[o],t,i));return i.delete(e),n}return e}function c(e,t,i=!0){return(0,n.isObject)(e)?((0,n.isObject)(t)&&Object.keys(t).forEach((o=>{o in e?i&&((0,n.isObject)(e[o])&&(0,n.isObject)(t[o])?c(e[o],t[o],i):e[o]=t[o]):e[o]=t[o]})),e):t}function d(e,t){if(e===t)return!0;if(null==e||null==t)return!1;if(typeof e!=typeof t)return!1;if("object"!=typeof e)return!1;if(Array.isArray(e)!==Array.isArray(t))return!1;let i,n;if(Array.isArray(e)){if(e.length!==t.length)return!1;for(i=0;i<e.length;i++)if(!d(e[i],t[i]))return!1}else{const o=[];for(n in e)o.push(n);o.sort();const r=[];for(n in t)r.push(n);if(r.sort(),!d(o,r))return!1;for(i=0;i<o.length;i++)if(!d(e[o[i]],t[o[i]]))return!1}return!0}function u(e){let t=[];for(;Object.prototype!==e;)t=t.concat(Object.getOwnPropertyNames(e)),e=Object.getPrototypeOf(e);return t}function h(e){const t=[];for(const i of u(e))"function"==typeof e[i]&&t.push(i);return t}function g(e,t){const i=e=>function(){const i=Array.prototype.slice.call(arguments,0);return t(e,i)},n={};for(const t of e)n[t]=i(t);return n}},69750:function(e,t,i){"use strict";i.r(t),i.d(t,{autorun:function(){return r.autorun},autorunHandleChanges:function(){return r.autorunHandleChanges},autorunOpts:function(){return r.autorunOpts},autorunWithStore:function(){return r.autorunWithStore},constObservable:function(){return s.constObservable},derived:function(){return o.derived},derivedHandleChanges:function(){return o.derivedHandleChanges},derivedObservableWithCache:function(){return s.derivedObservableWithCache},derivedOpts:function(){return o.derivedOpts},derivedWithStore:function(){return o.derivedWithStore},disposableObservableValue:function(){return n.disposableObservableValue},observableFromEvent:function(){return s.observableFromEvent},observableSignal:function(){return s.observableSignal},observableSignalFromEvent:function(){return s.observableSignalFromEvent},observableValue:function(){return n.observableValue},recomputeInitiallyAndOnChange:function(){return s.recomputeInitiallyAndOnChange},subtransaction:function(){return n.subtransaction},transaction:function(){return n.transaction},waitForState:function(){return s.waitForState}});var n=i(11123),o=i(92665),r=i(17410),s=i(4687);i(51761)},17410:function(e,t,i){"use strict";i.r(t),i.d(t,{AutorunObserver:function(){return u},autorun:function(){return a},autorunHandleChanges:function(){return c},autorunOpts:function(){return l},autorunWithStore:function(){return d}});var n=i(86995),o=i(68921),r=i(11123),s=i(51761);function a(e){return new u(void 0,e,void 0,void 0)}function l(e,t){return new u(e.debugName,t,void 0,void 0)}function c(e,t){return new u(e.debugName,t,e.createEmptyChangeSummary,e.handleChange)}function d(e){const t=new o.DisposableStore,i=l({debugName:()=>(0,r.getFunctionName)(e)||"(anonymous)"},(i=>{t.clear(),e(i,t)}));return(0,o.toDisposable)((()=>{i.dispose(),t.dispose()}))}class u{get debugName(){if("string"==typeof this._debugName)return this._debugName;if("function"==typeof this._debugName){const e=this._debugName();if(void 0!==e)return e}const e=(0,r.getFunctionName)(this._runFn);return void 0!==e?e:"(anonymous)"}constructor(e,t,i,n){var r,a;this._debugName=e,this._runFn=t,this.createChangeSummary=i,this._handleChange=n,this.state=2,this.updateCount=0,this.disposed=!1,this.dependencies=new Set,this.dependenciesToBeRemoved=new Set,this.changeSummary=null===(r=this.createChangeSummary)||void 0===r?void 0:r.call(this),null===(a=(0,s.getLogger)())||void 0===a||a.handleAutorunCreated(this),this._runIfNeeded(),(0,o.trackDisposable)(this)}dispose(){this.disposed=!0;for(const e of this.dependencies)e.removeObserver(this);this.dependencies.clear(),(0,o.markAsDisposed)(this)}_runIfNeeded(){var e,t,i;if(3===this.state)return;const n=this.dependenciesToBeRemoved;this.dependenciesToBeRemoved=this.dependencies,this.dependencies=n,this.state=3;const o=this.disposed;try{if(!o){null===(e=(0,s.getLogger)())||void 0===e||e.handleAutorunTriggered(this);const i=this.changeSummary;this.changeSummary=null===(t=this.createChangeSummary)||void 0===t?void 0:t.call(this),this._runFn(this,i)}}finally{o||null===(i=(0,s.getLogger)())||void 0===i||i.handleAutorunFinished(this);for(const e of this.dependenciesToBeRemoved)e.removeObserver(this);this.dependenciesToBeRemoved.clear()}}toString(){return`Autorun<${this.debugName}>`}beginUpdate(){3===this.state&&(this.state=1),this.updateCount++}endUpdate(){if(1===this.updateCount)do{if(1===this.state){this.state=3;for(const e of this.dependencies)if(e.reportChanges(),2===this.state)break}this._runIfNeeded()}while(3!==this.state);this.updateCount--,(0,n.assertFn)((()=>this.updateCount>=0))}handlePossibleChange(e){3===this.state&&this.dependencies.has(e)&&!this.dependenciesToBeRemoved.has(e)&&(this.state=1)}handleChange(e,t){if(this.dependencies.has(e)&&!this.dependenciesToBeRemoved.has(e)){(!this._handleChange||this._handleChange({changedObservable:e,change:t,didChange:t=>t===e},this.changeSummary))&&(this.state=2)}}readObservable(e){if(this.disposed)return e.get();e.addObserver(this);const t=e.get();return this.dependencies.add(e),this.dependenciesToBeRemoved.delete(e),t}}!function(e){e.Observer=u}(a||(a={}))},11123:function(e,t,i){"use strict";i.r(t),i.d(t,{BaseObservable:function(){return d},ConvenientObservable:function(){return c},DisposableObservableValue:function(){return x},ObservableValue:function(){return y},TransactionImpl:function(){return m},_setDerivedOpts:function(){return l},_setRecomputeInitiallyAndOnChange:function(){return a},asyncTransaction:function(){return g},disposableObservableValue:function(){return S},getDebugName:function(){return v},getFunctionName:function(){return C},globalTransaction:function(){return h},observableValue:function(){return w},subtransaction:function(){return p},transaction:function(){return u}});var n=i(51761);let o,r,s;function a(e){o=e}function l(e){r=e}class c{get TChange(){return null}reportChanges(){this.get()}read(e){return e?e.readObservable(this):this.get()}map(e,t){const i=void 0===t?void 0:e,n=void 0===t?e:t;return r({owner:i,debugName:()=>{const e=C(n);if(void 0!==e)return e;const t=/^\s*\(?\s*([a-zA-Z_$][a-zA-Z_$0-9]*)\s*\)?\s*=>\s*\1(?:\??)\.([a-zA-Z_$][a-zA-Z_$0-9]*)\s*$/.exec(n.toString());return t?`${this.debugName}.${t[2]}`:i?void 0:`${this.debugName} (mapped)`}},(e=>n(this.read(e),e)))}recomputeInitiallyAndOnChange(e,t){return e.add(o(this,t)),this}}class d extends c{constructor(){super(...arguments),this.observers=new Set}addObserver(e){const t=this.observers.size;this.observers.add(e),0===t&&this.onFirstObserverAdded()}removeObserver(e){this.observers.delete(e)&&0===this.observers.size&&this.onLastObserverRemoved()}onFirstObserverAdded(){}onLastObserverRemoved(){}}function u(e,t){const i=new m(e,t);try{e(i)}finally{i.finish()}}function h(e){if(s)e(s);else{const t=new m(e,void 0);s=t;try{e(t)}finally{t.finish(),s=void 0}}}async function g(e,t){const i=new m(e,t);try{await e(i)}finally{i.finish()}}function p(e,t,i){e?t(e):u(t,i)}class m{constructor(e,t){var i;this._fn=e,this._getDebugName=t,this.updatingObservers=[],null===(i=(0,n.getLogger)())||void 0===i||i.handleBeginTransaction(this)}getDebugName(){return this._getDebugName?this._getDebugName():C(this._fn)}updateObserver(e,t){this.updatingObservers.push({observer:e,observable:t}),e.beginUpdate(t)}finish(){var e;const t=this.updatingObservers;for(let e=0;e<t.length;e++){const{observer:i,observable:n}=t[e];i.endUpdate(n)}this.updatingObservers=null,null===(e=(0,n.getLogger)())||void 0===e||e.handleEndTransaction()}}const f=new Map,b=new WeakMap;function v(e,t,i,n,o){var r;const s=b.get(e);if(s)return s;const a=function(e,t,i,n,o){const r=b.get(e);if(r)return r;const s=n?function(e){var t;const i=A.get(e);if(i)return i;const n=function(e){const t=e.constructor;if(t)return t.name;return"Object"}(e);let o=null!==(t=_.get(n))&&void 0!==t?t:0;o++,_.set(n,o);const r=1===o?n:`${n}#${o}`;return A.set(e,r),r}(n)+".":"";let a;if(void 0!==t){if("function"!=typeof t)return s+t;if(a=t(),void 0!==a)return s+a}if(void 0!==i&&(a=C(i),void 0!==a))return s+a;if(void 0!==n)for(const e in n)if(n[e]===o)return s+e;return}(e,t,i,n,o);if(a){let t=null!==(r=f.get(a))&&void 0!==r?r:0;t++,f.set(a,t);const i=1===t?a:`${a}#${t}`;return b.set(e,i),i}}const _=new Map,A=new WeakMap;function C(e){const t=e.toString(),i=/\/\*\*\s*@description\s*([^*]*)\*\//.exec(t),n=i?i[1]:void 0;return null==n?void 0:n.trim()}function w(e,t){return"string"==typeof e?new y(void 0,e,t):new y(e,void 0,t)}class y extends d{get debugName(){var e;return null!==(e=v(this,this._debugName,void 0,this._owner,this))&&void 0!==e?e:"ObservableValue"}constructor(e,t,i){super(),this._owner=e,this._debugName=t,this._value=i}get(){return this._value}set(e,t,i){var o;if(this._value===e)return;let r;t||(t=r=new m((()=>{}),(()=>`Setting ${this.debugName}`)));try{const r=this._value;this._setValue(e),null===(o=(0,n.getLogger)())||void 0===o||o.handleObservableChanged(this,{oldValue:r,newValue:e,change:i,didChange:!0,hadValue:!0});for(const e of this.observers)t.updateObserver(e,this),e.handleChange(this,i)}finally{r&&r.finish()}}toString(){return`${this.debugName}: ${this._value}`}_setValue(e){this._value=e}}function S(e,t){return"string"==typeof e?new x(void 0,e,t):new x(e,void 0,t)}class x extends y{_setValue(e){this._value!==e&&(this._value&&this._value.dispose(),this._value=e)}dispose(){var e;null===(e=this._value)||void 0===e||e.dispose()}}},92665:function(e,t,i){"use strict";i.r(t),i.d(t,{Derived:function(){return g},derived:function(){return l},derivedDisposable:function(){return h},derivedHandleChanges:function(){return d},derivedOpts:function(){return c},derivedWithStore:function(){return u}});var n=i(12718),o=i(68921),r=i(11123),s=i(51761);const a=(e,t)=>e===t;function l(e,t){return void 0!==t?new g(e,void 0,t,void 0,void 0,void 0,a):new g(void 0,void 0,e,void 0,void 0,void 0,a)}function c(e,t){var i;return new g(e.owner,e.debugName,t,void 0,void 0,void 0,null!==(i=e.equalityComparer)&&void 0!==i?i:a)}function d(e,t){var i;return new g(e.owner,e.debugName,t,e.createEmptyChangeSummary,e.handleChange,void 0,null!==(i=e.equalityComparer)&&void 0!==i?i:a)}function u(e,t){let i,n;void 0===t?(i=e,n=void 0):(n=e,i=t);const s=new o.DisposableStore;return new g(n,(()=>{var e;return null!==(e=(0,r.getFunctionName)(i))&&void 0!==e?e:"(anonymous)"}),(e=>(s.clear(),i(e,s))),void 0,void 0,(()=>s.dispose()),a)}function h(e,t){let i,n;void 0===t?(i=e,n=void 0):(n=e,i=t);const s=new o.DisposableStore;return new g(n,(()=>{var e;return null!==(e=(0,r.getFunctionName)(i))&&void 0!==e?e:"(anonymous)"}),(e=>{s.clear();const t=i(e);return t&&s.add(t),t}),void 0,void 0,(()=>s.dispose()),a)}(0,r._setDerivedOpts)(c);class g extends r.BaseObservable{get debugName(){var e;return null!==(e=(0,r.getDebugName)(this,this._debugName,this._computeFn,this._owner,this))&&void 0!==e?e:"(anonymous)"}constructor(e,t,i,n,o,r=void 0,a){var l,c;super(),this._owner=e,this._debugName=t,this._computeFn=i,this.createChangeSummary=n,this._handleChange=o,this._handleLastObserverRemoved=r,this._equalityComparator=a,this.state=0,this.value=void 0,this.updateCount=0,this.dependencies=new Set,this.dependenciesToBeRemoved=new Set,this.changeSummary=void 0,this.changeSummary=null===(l=this.createChangeSummary)||void 0===l?void 0:l.call(this),null===(c=(0,s.getLogger)())||void 0===c||c.handleDerivedCreated(this)}onLastObserverRemoved(){var e;this.state=0,this.value=void 0;for(const e of this.dependencies)e.removeObserver(this);this.dependencies.clear(),null===(e=this._handleLastObserverRemoved)||void 0===e||e.call(this)}get(){var e;if(0===this.observers.size){const t=this._computeFn(this,null===(e=this.createChangeSummary)||void 0===e?void 0:e.call(this));return this.onLastObserverRemoved(),t}do{if(1===this.state)for(const e of this.dependencies)if(e.reportChanges(),2===this.state)break;1===this.state&&(this.state=3),this._recomputeIfNeeded()}while(3!==this.state);return this.value}_recomputeIfNeeded(){var e,t;if(3===this.state)return;const i=this.dependenciesToBeRemoved;this.dependenciesToBeRemoved=this.dependencies,this.dependencies=i;const n=0!==this.state,o=this.value;this.state=3;const r=this.changeSummary;this.changeSummary=null===(e=this.createChangeSummary)||void 0===e?void 0:e.call(this);try{this.value=this._computeFn(this,r)}finally{for(const e of this.dependenciesToBeRemoved)e.removeObserver(this);this.dependenciesToBeRemoved.clear()}const a=n&&!this._equalityComparator(o,this.value);if(null===(t=(0,s.getLogger)())||void 0===t||t.handleDerivedRecomputed(this,{oldValue:o,newValue:this.value,change:void 0,didChange:a,hadValue:n}),a)for(const e of this.observers)e.handleChange(this,void 0)}toString(){return`LazyDerived<${this.debugName}>`}beginUpdate(e){this.updateCount++;const t=1===this.updateCount;if(3===this.state&&(this.state=1,!t))for(const e of this.observers)e.handlePossibleChange(this);if(t)for(const e of this.observers)e.beginUpdate(this)}endUpdate(e){if(this.updateCount--,0===this.updateCount){const e=[...this.observers];for(const t of e)t.endUpdate(this)}if(this.updateCount<0)throw new n.BugIndicatingError}handlePossibleChange(e){if(3===this.state&&this.dependencies.has(e)&&!this.dependenciesToBeRemoved.has(e)){this.state=1;for(const e of this.observers)e.handlePossibleChange(this)}}handleChange(e,t){if(this.dependencies.has(e)&&!this.dependenciesToBeRemoved.has(e)){const i=!this._handleChange||this._handleChange({changedObservable:e,change:t,didChange:t=>t===e},this.changeSummary),n=3===this.state;if(i&&(1===this.state||n)&&(this.state=2,n))for(const e of this.observers)e.handlePossibleChange(this)}}readObservable(e){e.addObserver(this);const t=e.get();return this.dependencies.add(e),this.dependenciesToBeRemoved.delete(e),t}addObserver(e){const t=!this.observers.has(e)&&this.updateCount>0;super.addObserver(e),t&&e.beginUpdate(this)}removeObserver(e){const t=this.observers.has(e)&&this.updateCount>0;super.removeObserver(e),t&&e.endUpdate(this)}}},51761:function(e,t,i){"use strict";let n;function o(e){n=e}function r(){return n}i.r(t),i.d(t,{ConsoleObservableLogger:function(){return s},getLogger:function(){return r},setLogger:function(){return o}});class s{constructor(){this.indentation=0,this.changedObservablesSets=new WeakMap}textToConsoleArgs(e){return function(e){const t=new Array,i=[];let n="";function o(e){if("length"in e)for(const t of e)t&&o(t);else"text"in e?(n+=`%c${e.text}`,t.push(e.style),e.data&&i.push(...e.data)):"data"in e&&i.push(...e.data)}o(e);const r=[n,...t];return r.push(...i),r}([a(u("|  ",this.indentation)),e])}formatInfo(e){return e.hadValue?e.didChange?[a(" "),c(d(e.oldValue,70),{color:"red",strikeThrough:!0}),a(" "),c(d(e.newValue,60),{color:"green"})]:[a(" (unchanged)")]:[a(" "),c(d(e.newValue,60),{color:"green"}),a(" (initial)")]}handleObservableChanged(e,t){console.log(...this.textToConsoleArgs([l("observable value changed"),c(e.debugName,{color:"BlueViolet"}),...this.formatInfo(t)]))}formatChanges(e){if(0!==e.size)return c(" (changed deps: "+[...e].map((e=>e.debugName)).join(", ")+")",{color:"gray"})}handleDerivedCreated(e){const t=e.handleChange;this.changedObservablesSets.set(e,new Set),e.handleChange=(i,n)=>(this.changedObservablesSets.get(e).add(i),t.apply(e,[i,n]))}handleDerivedRecomputed(e,t){const i=this.changedObservablesSets.get(e);console.log(...this.textToConsoleArgs([l("derived recomputed"),c(e.debugName,{color:"BlueViolet"}),...this.formatInfo(t),this.formatChanges(i),{data:[{fn:e._computeFn}]}])),i.clear()}handleFromEventObservableTriggered(e,t){console.log(...this.textToConsoleArgs([l("observable from event triggered"),c(e.debugName,{color:"BlueViolet"}),...this.formatInfo(t),{data:[{fn:e._getValue}]}]))}handleAutorunCreated(e){const t=e.handleChange;this.changedObservablesSets.set(e,new Set),e.handleChange=(i,n)=>(this.changedObservablesSets.get(e).add(i),t.apply(e,[i,n]))}handleAutorunTriggered(e){const t=this.changedObservablesSets.get(e);console.log(...this.textToConsoleArgs([l("autorun"),c(e.debugName,{color:"BlueViolet"}),this.formatChanges(t),{data:[{fn:e._runFn}]}])),t.clear(),this.indentation++}handleAutorunFinished(e){this.indentation--}handleBeginTransaction(e){let t=e.getDebugName();void 0===t&&(t=""),console.log(...this.textToConsoleArgs([l("transaction"),c(t,{color:"BlueViolet"}),{data:[{fn:e._fn}]}])),this.indentation++}handleEndTransaction(){this.indentation--}}function a(e){return c(e,{color:"black"})}function l(e){return c(function(e,t){for(;e.length<t;)e+=" ";return e}(`${e}: `,10),{color:"black",bold:!0})}function c(e,t={color:"black"}){const i={color:t.color};return t.strikeThrough&&(i["text-decoration"]="line-through"),t.bold&&(i["font-weight"]="bold"),{text:e,style:(n=i,Object.entries(n).reduce(((e,[t,i])=>`${e}${t}:${i};`),""))};var n}function d(e,t){switch(typeof e){case"number":default:return""+e;case"string":return e.length+2<=t?`"${e}"`:`"${e.substr(0,t-7)}"+...`;case"boolean":return e?"true":"false";case"undefined":return"undefined";case"object":return null===e?"null":Array.isArray(e)?function(e,t){let i="[ ",n=!0;for(const o of e){if(n||(i+=", "),i.length-5>t){i+="...";break}n=!1,i+=`${d(o,t-i.length)}`}return i+=" ]",i}(e,t):function(e,t){let i="{ ",n=!0;for(const[o,r]of Object.entries(e)){if(n||(i+=", "),i.length-5>t){i+="...";break}n=!1,i+=`${o}: ${d(r,t-i.length)}`}return i+=" }",i}(e,t);case"symbol":return e.toString();case"function":return`[[Function${e.name?" "+e.name:""}]]`}}function u(e,t){let i="";for(let n=1;n<=t;n++)i+=e;return i}},4687:function(e,t,i){"use strict";i.r(t),i.d(t,{FromEventObservable:function(){return h},constObservable:function(){return l},derivedObservableWithCache:function(){return _},observableFromEvent:function(){return u},observableSignal:function(){return m},observableSignalFromEvent:function(){return g},recomputeInitiallyAndOnChange:function(){return b},waitForState:function(){return d}});var n=i(68921),o=i(17410),r=i(11123),s=i(92665),a=i(51761);function l(e){return new c(e)}class c extends r.ConvenientObservable{constructor(e){super(),this.value=e}get debugName(){return this.toString()}get(){return this.value}addObserver(e){}removeObserver(e){}toString(){return`Const: ${this.value}`}}function d(e,t){return new Promise((i=>{let n=!1,r=!1;const s=e.map((e=>({isFinished:t(e),state:e}))),a=(0,o.autorun)((e=>{const{isFinished:t,state:o}=s.read(e);t&&(n?a.dispose():r=!0,i(o))}));n=!0,r&&a.dispose()}))}function u(e,t){return new h(e,t)}class h extends r.BaseObservable{constructor(e,t){super(),this.event=e,this._getValue=t,this.hasValue=!1,this.handleEvent=e=>{var t;const i=this._getValue(e),n=this.value,o=!this.hasValue||n!==i;let s=!1;o&&(this.value=i,this.hasValue&&(s=!0,(0,r.subtransaction)(h.globalTransaction,(e=>{var t;null===(t=(0,a.getLogger)())||void 0===t||t.handleFromEventObservableTriggered(this,{oldValue:n,newValue:i,change:void 0,didChange:o,hadValue:this.hasValue});for(const t of this.observers)e.updateObserver(t,this),t.handleChange(this,void 0)}),(()=>{const e=this.getDebugName();return"Event fired"+(e?`: ${e}`:"")}))),this.hasValue=!0),s||null===(t=(0,a.getLogger)())||void 0===t||t.handleFromEventObservableTriggered(this,{oldValue:n,newValue:i,change:void 0,didChange:o,hadValue:this.hasValue})}}getDebugName(){return(0,r.getFunctionName)(this._getValue)}get debugName(){const e=this.getDebugName();return"From Event"+(e?`: ${e}`:"")}onFirstObserverAdded(){this.subscription=this.event(this.handleEvent)}onLastObserverRemoved(){this.subscription.dispose(),this.subscription=void 0,this.hasValue=!1,this.value=void 0}get(){return this.subscription?(this.hasValue||this.handleEvent(void 0),this.value):this._getValue(void 0)}}function g(e,t){return new p(e,t)}!function(e){e.Observer=h,e.batchEventsGlobally=function(e,t){let i=!1;void 0===h.globalTransaction&&(h.globalTransaction=e,i=!0);try{t()}finally{i&&(h.globalTransaction=void 0)}}}(u||(u={}));class p extends r.BaseObservable{constructor(e,t){super(),this.debugName=e,this.event=t,this.handleEvent=()=>{(0,r.transaction)((e=>{for(const t of this.observers)e.updateObserver(t,this),t.handleChange(this,void 0)}),(()=>this.debugName))}}onFirstObserverAdded(){this.subscription=this.event(this.handleEvent)}onLastObserverRemoved(){this.subscription.dispose(),this.subscription=void 0}get(){}}function m(e){return"string"==typeof e?new f(e):new f(void 0,e)}class f extends r.BaseObservable{get debugName(){var e;return null!==(e=(0,r.getDebugName)(this,this._debugName,void 0,this._owner,this))&&void 0!==e?e:"Observable Signal"}constructor(e,t){super(),this._debugName=e,this._owner=t}trigger(e,t){if(e)for(const i of this.observers)e.updateObserver(i,this),i.handleChange(this,t);else(0,r.transaction)((e=>{this.trigger(e,t)}),(()=>`Trigger signal ${this.debugName}`))}get(){}}function b(e,t){const i=new v(!0,t);return e.addObserver(i),t?t(e.get()):e.reportChanges(),(0,n.toDisposable)((()=>{e.removeObserver(i)}))}(0,r._setRecomputeInitiallyAndOnChange)(b);class v{constructor(e,t){this._forceRecompute=e,this._handleValue=t,this._counter=0}beginUpdate(e){this._counter++}endUpdate(e){this._counter--,0===this._counter&&this._forceRecompute&&(this._handleValue?this._handleValue(e.get()):e.reportChanges())}handlePossibleChange(e){}handleChange(e,t){}}function _(e){let t;return(0,s.derived)((i=>(t=e(i,t),t)))}},23674:function(e,t,i){"use strict";i.r(t),i.d(t,{basename:function(){return y},dirname:function(){return w},extname:function(){return S},normalize:function(){return _},posix:function(){return v},relative:function(){return C},resolve:function(){return A},sep:function(){return x},win32:function(){return f}});var n=i(63953);const o=46,r=47,s=92,a=58;class l extends Error{constructor(e,t,i){let n;"string"==typeof t&&0===t.indexOf("not ")?(n="must not be",t=t.replace(/^not /,"")):n="must be";const o=-1!==e.indexOf(".")?"property":"argument";let r=`The "${e}" ${o} ${n} of type ${t}`;r+=". Received type "+typeof i,super(r),this.code="ERR_INVALID_ARG_TYPE"}}function c(e,t){if("string"!=typeof e)throw new l(t,"string",e)}const d="win32"===n.platform;function u(e){return e===r||e===s}function h(e){return e===r}function g(e){return e>=65&&e<=90||e>=97&&e<=122}function p(e,t,i,n){let s="",a=0,l=-1,c=0,d=0;for(let u=0;u<=e.length;++u){if(u<e.length)d=e.charCodeAt(u);else{if(n(d))break;d=r}if(n(d)){if(l===u-1||1===c);else if(2===c){if(s.length<2||2!==a||s.charCodeAt(s.length-1)!==o||s.charCodeAt(s.length-2)!==o){if(s.length>2){const e=s.lastIndexOf(i);-1===e?(s="",a=0):(s=s.slice(0,e),a=s.length-1-s.lastIndexOf(i)),l=u,c=0;continue}if(0!==s.length){s="",a=0,l=u,c=0;continue}}t&&(s+=s.length>0?`${i}..`:"..",a=2)}else s.length>0?s+=`${i}${e.slice(l+1,u)}`:s=e.slice(l+1,u),a=u-l-1;l=u,c=0}else d===o&&-1!==c?++c:c=-1}return s}function m(e,t){!function(e,t){if(null===e||"object"!=typeof e)throw new l(t,"Object",e)}(t,"pathObject");const i=t.dir||t.root,n=t.base||`${t.name||""}${t.ext||""}`;return i?i===t.root?`${i}${n}`:`${i}${e}${n}`:n}const f={resolve(...e){let t="",i="",o=!1;for(let r=e.length-1;r>=-1;r--){let l;if(r>=0){if(l=e[r],c(l,"path"),0===l.length)continue}else 0===t.length?l=n.cwd():(l=n.env[`=${t}`]||n.cwd(),(void 0===l||l.slice(0,2).toLowerCase()!==t.toLowerCase()&&l.charCodeAt(2)===s)&&(l=`${t}\\`));const d=l.length;let h=0,p="",m=!1;const f=l.charCodeAt(0);if(1===d)u(f)&&(h=1,m=!0);else if(u(f))if(m=!0,u(l.charCodeAt(1))){let e=2,t=e;for(;e<d&&!u(l.charCodeAt(e));)e++;if(e<d&&e!==t){const i=l.slice(t,e);for(t=e;e<d&&u(l.charCodeAt(e));)e++;if(e<d&&e!==t){for(t=e;e<d&&!u(l.charCodeAt(e));)e++;e!==d&&e===t||(p=`\\\\${i}\\${l.slice(t,e)}`,h=e)}}}else h=1;else g(f)&&l.charCodeAt(1)===a&&(p=l.slice(0,2),h=2,d>2&&u(l.charCodeAt(2))&&(m=!0,h=3));if(p.length>0)if(t.length>0){if(p.toLowerCase()!==t.toLowerCase())continue}else t=p;if(o){if(t.length>0)break}else if(i=`${l.slice(h)}\\${i}`,o=m,m&&t.length>0)break}return i=p(i,!o,"\\",u),o?`${t}\\${i}`:`${t}${i}`||"."},normalize(e){c(e,"path");const t=e.length;if(0===t)return".";let i,n=0,o=!1;const r=e.charCodeAt(0);if(1===t)return h(r)?"\\":e;if(u(r))if(o=!0,u(e.charCodeAt(1))){let o=2,r=o;for(;o<t&&!u(e.charCodeAt(o));)o++;if(o<t&&o!==r){const s=e.slice(r,o);for(r=o;o<t&&u(e.charCodeAt(o));)o++;if(o<t&&o!==r){for(r=o;o<t&&!u(e.charCodeAt(o));)o++;if(o===t)return`\\\\${s}\\${e.slice(r)}\\`;o!==r&&(i=`\\\\${s}\\${e.slice(r,o)}`,n=o)}}}else n=1;else g(r)&&e.charCodeAt(1)===a&&(i=e.slice(0,2),n=2,t>2&&u(e.charCodeAt(2))&&(o=!0,n=3));let s=n<t?p(e.slice(n),!o,"\\",u):"";return 0!==s.length||o||(s="."),s.length>0&&u(e.charCodeAt(t-1))&&(s+="\\"),void 0===i?o?`\\${s}`:s:o?`${i}\\${s}`:`${i}${s}`},isAbsolute(e){c(e,"path");const t=e.length;if(0===t)return!1;const i=e.charCodeAt(0);return u(i)||t>2&&g(i)&&e.charCodeAt(1)===a&&u(e.charCodeAt(2))},join(...e){if(0===e.length)return".";let t,i;for(let n=0;n<e.length;++n){const o=e[n];c(o,"path"),o.length>0&&(void 0===t?t=i=o:t+=`\\${o}`)}if(void 0===t)return".";let n=!0,o=0;if("string"==typeof i&&u(i.charCodeAt(0))){++o;const e=i.length;e>1&&u(i.charCodeAt(1))&&(++o,e>2&&(u(i.charCodeAt(2))?++o:n=!1))}if(n){for(;o<t.length&&u(t.charCodeAt(o));)o++;o>=2&&(t=`\\${t.slice(o)}`)}return f.normalize(t)},relative(e,t){if(c(e,"from"),c(t,"to"),e===t)return"";const i=f.resolve(e),n=f.resolve(t);if(i===n)return"";if((e=i.toLowerCase())===(t=n.toLowerCase()))return"";let o=0;for(;o<e.length&&e.charCodeAt(o)===s;)o++;let r=e.length;for(;r-1>o&&e.charCodeAt(r-1)===s;)r--;const a=r-o;let l=0;for(;l<t.length&&t.charCodeAt(l)===s;)l++;let d=t.length;for(;d-1>l&&t.charCodeAt(d-1)===s;)d--;const u=d-l,h=a<u?a:u;let g=-1,p=0;for(;p<h;p++){const i=e.charCodeAt(o+p);if(i!==t.charCodeAt(l+p))break;i===s&&(g=p)}if(p!==h){if(-1===g)return n}else{if(u>h){if(t.charCodeAt(l+p)===s)return n.slice(l+p+1);if(2===p)return n.slice(l+p)}a>h&&(e.charCodeAt(o+p)===s?g=p:2===p&&(g=3)),-1===g&&(g=0)}let m="";for(p=o+g+1;p<=r;++p)p!==r&&e.charCodeAt(p)!==s||(m+=0===m.length?"..":"\\..");return l+=g,m.length>0?`${m}${n.slice(l,d)}`:(n.charCodeAt(l)===s&&++l,n.slice(l,d))},toNamespacedPath(e){if("string"!=typeof e||0===e.length)return e;const t=f.resolve(e);if(t.length<=2)return e;if(t.charCodeAt(0)===s){if(t.charCodeAt(1)===s){const e=t.charCodeAt(2);if(63!==e&&e!==o)return`\\\\?\\UNC\\${t.slice(2)}`}}else if(g(t.charCodeAt(0))&&t.charCodeAt(1)===a&&t.charCodeAt(2)===s)return`\\\\?\\${t}`;return e},dirname(e){c(e,"path");const t=e.length;if(0===t)return".";let i=-1,n=0;const o=e.charCodeAt(0);if(1===t)return u(o)?e:".";if(u(o)){if(i=n=1,u(e.charCodeAt(1))){let o=2,r=o;for(;o<t&&!u(e.charCodeAt(o));)o++;if(o<t&&o!==r){for(r=o;o<t&&u(e.charCodeAt(o));)o++;if(o<t&&o!==r){for(r=o;o<t&&!u(e.charCodeAt(o));)o++;if(o===t)return e;o!==r&&(i=n=o+1)}}}}else g(o)&&e.charCodeAt(1)===a&&(i=t>2&&u(e.charCodeAt(2))?3:2,n=i);let r=-1,s=!0;for(let i=t-1;i>=n;--i)if(u(e.charCodeAt(i))){if(!s){r=i;break}}else s=!1;if(-1===r){if(-1===i)return".";r=i}return e.slice(0,r)},basename(e,t){void 0!==t&&c(t,"ext"),c(e,"path");let i,n=0,o=-1,r=!0;if(e.length>=2&&g(e.charCodeAt(0))&&e.charCodeAt(1)===a&&(n=2),void 0!==t&&t.length>0&&t.length<=e.length){if(t===e)return"";let s=t.length-1,a=-1;for(i=e.length-1;i>=n;--i){const l=e.charCodeAt(i);if(u(l)){if(!r){n=i+1;break}}else-1===a&&(r=!1,a=i+1),s>=0&&(l===t.charCodeAt(s)?-1==--s&&(o=i):(s=-1,o=a))}return n===o?o=a:-1===o&&(o=e.length),e.slice(n,o)}for(i=e.length-1;i>=n;--i)if(u(e.charCodeAt(i))){if(!r){n=i+1;break}}else-1===o&&(r=!1,o=i+1);return-1===o?"":e.slice(n,o)},extname(e){c(e,"path");let t=0,i=-1,n=0,r=-1,s=!0,l=0;e.length>=2&&e.charCodeAt(1)===a&&g(e.charCodeAt(0))&&(t=n=2);for(let a=e.length-1;a>=t;--a){const t=e.charCodeAt(a);if(u(t)){if(!s){n=a+1;break}}else-1===r&&(s=!1,r=a+1),t===o?-1===i?i=a:1!==l&&(l=1):-1!==i&&(l=-1)}return-1===i||-1===r||0===l||1===l&&i===r-1&&i===n+1?"":e.slice(i,r)},format:m.bind(null,"\\"),parse(e){c(e,"path");const t={root:"",dir:"",base:"",ext:"",name:""};if(0===e.length)return t;const i=e.length;let n=0,r=e.charCodeAt(0);if(1===i)return u(r)?(t.root=t.dir=e,t):(t.base=t.name=e,t);if(u(r)){if(n=1,u(e.charCodeAt(1))){let t=2,o=t;for(;t<i&&!u(e.charCodeAt(t));)t++;if(t<i&&t!==o){for(o=t;t<i&&u(e.charCodeAt(t));)t++;if(t<i&&t!==o){for(o=t;t<i&&!u(e.charCodeAt(t));)t++;t===i?n=t:t!==o&&(n=t+1)}}}}else if(g(r)&&e.charCodeAt(1)===a){if(i<=2)return t.root=t.dir=e,t;if(n=2,u(e.charCodeAt(2))){if(3===i)return t.root=t.dir=e,t;n=3}}n>0&&(t.root=e.slice(0,n));let s=-1,l=n,d=-1,h=!0,p=e.length-1,m=0;for(;p>=n;--p)if(r=e.charCodeAt(p),u(r)){if(!h){l=p+1;break}}else-1===d&&(h=!1,d=p+1),r===o?-1===s?s=p:1!==m&&(m=1):-1!==s&&(m=-1);return-1!==d&&(-1===s||0===m||1===m&&s===d-1&&s===l+1?t.base=t.name=e.slice(l,d):(t.name=e.slice(l,s),t.base=e.slice(l,d),t.ext=e.slice(s,d))),t.dir=l>0&&l!==n?e.slice(0,l-1):t.root,t},sep:"\\",delimiter:";",win32:null,posix:null},b=(()=>{if(d){const e=/\\/g;return()=>{const t=n.cwd().replace(e,"/");return t.slice(t.indexOf("/"))}}return()=>n.cwd()})(),v={resolve(...e){let t="",i=!1;for(let n=e.length-1;n>=-1&&!i;n--){const o=n>=0?e[n]:b();c(o,"path"),0!==o.length&&(t=`${o}/${t}`,i=o.charCodeAt(0)===r)}return t=p(t,!i,"/",h),i?`/${t}`:t.length>0?t:"."},normalize(e){if(c(e,"path"),0===e.length)return".";const t=e.charCodeAt(0)===r,i=e.charCodeAt(e.length-1)===r;return 0===(e=p(e,!t,"/",h)).length?t?"/":i?"./":".":(i&&(e+="/"),t?`/${e}`:e)},isAbsolute(e){return c(e,"path"),e.length>0&&e.charCodeAt(0)===r},join(...e){if(0===e.length)return".";let t;for(let i=0;i<e.length;++i){const n=e[i];c(n,"path"),n.length>0&&(void 0===t?t=n:t+=`/${n}`)}return void 0===t?".":v.normalize(t)},relative(e,t){if(c(e,"from"),c(t,"to"),e===t)return"";if((e=v.resolve(e))===(t=v.resolve(t)))return"";const i=e.length,n=i-1,o=t.length-1,s=n<o?n:o;let a=-1,l=0;for(;l<s;l++){const i=e.charCodeAt(1+l);if(i!==t.charCodeAt(1+l))break;i===r&&(a=l)}if(l===s)if(o>s){if(t.charCodeAt(1+l)===r)return t.slice(1+l+1);if(0===l)return t.slice(1+l)}else n>s&&(e.charCodeAt(1+l)===r?a=l:0===l&&(a=0));let d="";for(l=1+a+1;l<=i;++l)l!==i&&e.charCodeAt(l)!==r||(d+=0===d.length?"..":"/..");return`${d}${t.slice(1+a)}`},toNamespacedPath(e){return e},dirname(e){if(c(e,"path"),0===e.length)return".";const t=e.charCodeAt(0)===r;let i=-1,n=!0;for(let t=e.length-1;t>=1;--t)if(e.charCodeAt(t)===r){if(!n){i=t;break}}else n=!1;return-1===i?t?"/":".":t&&1===i?"//":e.slice(0,i)},basename(e,t){void 0!==t&&c(t,"ext"),c(e,"path");let i,n=0,o=-1,s=!0;if(void 0!==t&&t.length>0&&t.length<=e.length){if(t===e)return"";let a=t.length-1,l=-1;for(i=e.length-1;i>=0;--i){const c=e.charCodeAt(i);if(c===r){if(!s){n=i+1;break}}else-1===l&&(s=!1,l=i+1),a>=0&&(c===t.charCodeAt(a)?-1==--a&&(o=i):(a=-1,o=l))}return n===o?o=l:-1===o&&(o=e.length),e.slice(n,o)}for(i=e.length-1;i>=0;--i)if(e.charCodeAt(i)===r){if(!s){n=i+1;break}}else-1===o&&(s=!1,o=i+1);return-1===o?"":e.slice(n,o)},extname(e){c(e,"path");let t=-1,i=0,n=-1,s=!0,a=0;for(let l=e.length-1;l>=0;--l){const c=e.charCodeAt(l);if(c!==r)-1===n&&(s=!1,n=l+1),c===o?-1===t?t=l:1!==a&&(a=1):-1!==t&&(a=-1);else if(!s){i=l+1;break}}return-1===t||-1===n||0===a||1===a&&t===n-1&&t===i+1?"":e.slice(t,n)},format:m.bind(null,"/"),parse(e){c(e,"path");const t={root:"",dir:"",base:"",ext:"",name:""};if(0===e.length)return t;const i=e.charCodeAt(0)===r;let n;i?(t.root="/",n=1):n=0;let s=-1,a=0,l=-1,d=!0,u=e.length-1,h=0;for(;u>=n;--u){const t=e.charCodeAt(u);if(t!==r)-1===l&&(d=!1,l=u+1),t===o?-1===s?s=u:1!==h&&(h=1):-1!==s&&(h=-1);else if(!d){a=u+1;break}}if(-1!==l){const n=0===a&&i?1:a;-1===s||0===h||1===h&&s===l-1&&s===a+1?t.base=t.name=e.slice(n,l):(t.name=e.slice(n,s),t.base=e.slice(n,l),t.ext=e.slice(s,l))}return a>0?t.dir=e.slice(0,a-1):i&&(t.dir="/"),t},sep:"/",delimiter:":",win32:null,posix:null};v.win32=f.win32=f,v.posix=f.posix=v;const _=d?f.normalize:v.normalize,A=d?f.resolve:v.resolve,C=d?f.relative:v.relative,w=d?f.dirname:v.dirname,y=d?f.basename:v.basename,S=d?f.extname:v.extname,x=d?f.sep:v.sep},66719:function(e,t,i){"use strict";i.r(t),i.d(t,{LANGUAGE_DEFAULT:function(){return r},OS:function(){return z},isAndroid:function(){return G},isChrome:function(){return U},isEdge:function(){return j},isFirefox:function(){return Q},isIOS:function(){return N},isLinux:function(){return D},isLittleEndian:function(){return V},isMacintosh:function(){return k},isMobile:function(){return R},isNative:function(){return I},isSafari:function(){return K},isWeb:function(){return L},isWebWorker:function(){return T},isWindows:function(){return E},language:function(){return O},setTimeout0:function(){return P},setTimeout0IsFaster:function(){return F},userAgent:function(){return B},webWorkerOrigin:function(){return M}});var n,o=i(83787);const r="en";let s,a,l=!1,c=!1,d=!1,u=!1,h=!1,g=!1,p=!1,m=!1,f=!1,b=!1,v=r,_=null,A=null;const C=globalThis;let w;void 0!==C.vscode&&void 0!==C.vscode.process?w=C.vscode.process:"undefined"!=typeof process&&(w=process);const y="string"==typeof(null===(n=null==w?void 0:w.versions)||void 0===n?void 0:n.electron),S=y&&"renderer"===(null==w?void 0:w.type);if("object"!=typeof navigator||S)if("object"==typeof w){l="win32"===w.platform,c="darwin"===w.platform,d="linux"===w.platform,u=d&&!!w.env.SNAP&&!!w.env.SNAP_REVISION,p=y,f=!!w.env.CI||!!w.env.BUILD_ARTIFACTSTAGINGDIRECTORY,s=r,v=r;const e=w.env.VSCODE_NLS_CONFIG;if(e)try{const t=JSON.parse(e),i=t.availableLanguages["*"];s=t.locale,_=t.osLocale,v=i||r,A=t._translationsConfigFile}catch(e){}h=!0}else console.error("Unable to resolve platform.");else{a=navigator.userAgent,l=a.indexOf("Windows")>=0,c=a.indexOf("Macintosh")>=0,m=(a.indexOf("Macintosh")>=0||a.indexOf("iPad")>=0||a.indexOf("iPhone")>=0)&&!!navigator.maxTouchPoints&&navigator.maxTouchPoints>0,d=a.indexOf("Linux")>=0,b=(null==a?void 0:a.indexOf("Mobi"))>=0,g=!0;s=o.getConfiguredDefaultLocale(o.localize("vs/base/common/platform",{key:"ensureLoaderPluginIsLoaded",comment:["{Locked}"]},"_"))||r,v=s,_=navigator.language}let x=0;c?x=1:l?x=3:d&&(x=2);const E=l,k=c,D=d,I=h,L=g,T=g&&"function"==typeof C.importScripts,M=T?C.origin:void 0,N=m,R=b,B=a,O=v,F="function"==typeof C.postMessage&&!C.importScripts,P=(()=>{if(F){const e=[];C.addEventListener("message",(t=>{if(t.data&&t.data.vscodeScheduleAsyncWork)for(let i=0,n=e.length;i<n;i++){const n=e[i];if(n.id===t.data.vscodeScheduleAsyncWork)return e.splice(i,1),void n.callback()}}));let t=0;return i=>{const n=++t;e.push({id:n,callback:i}),C.postMessage({vscodeScheduleAsyncWork:n},"*")}}return e=>setTimeout(e)})(),z=c||m?2:l?1:3;let W=!0,H=!1;function V(){if(!H){H=!0;const e=new Uint8Array(2);e[0]=1,e[1]=2;const t=new Uint16Array(e.buffer);W=513===t[0]}return W}const U=!!(B&&B.indexOf("Chrome")>=0),Q=!!(B&&B.indexOf("Firefox")>=0),K=!!(!U&&B&&B.indexOf("Safari")>=0),j=!!(B&&B.indexOf("Edg/")>=0),G=!!(B&&B.indexOf("Android")>=0)},63953:function(e,t,i){"use strict";i.r(t),i.d(t,{cwd:function(){return s},env:function(){return a},platform:function(){return l}});var n=i(66719);let o;const r=globalThis.vscode;if(void 0!==r&&void 0!==r.process){const e=r.process;o={get platform(){return e.platform},get arch(){return e.arch},get env(){return e.env},cwd(){return e.cwd()}}}else o="undefined"!=typeof process?{get platform(){return process.platform},get arch(){return process.arch},get env(){return process.env},cwd(){return process.env.VSCODE_CWD||process.cwd()}}:{get platform(){return n.isWindows?"win32":n.isMacintosh?"darwin":"linux"},get arch(){},get env(){return{}},cwd(){return"/"}};const s=o.cwd,a=o.env,l=o.platform},83682:function(e,t,i){"use strict";var n;i.r(t),i.d(t,{Range:function(){return n}}),function(e){function t(e,t){if(e.start>=t.end||t.start>=e.end)return{start:0,end:0};const i=Math.max(e.start,t.start),n=Math.min(e.end,t.end);return n-i<=0?{start:0,end:0}:{start:i,end:n}}function i(e){return e.end-e.start<=0}e.intersect=t,e.isEmpty=i,e.intersects=function(e,n){return!i(t(e,n))},e.relativeComplement=function(e,t){const n=[],o={start:e.start,end:Math.min(t.start,e.end)},r={start:Math.max(t.end,e.start),end:e.end};return i(o)||n.push(o),i(r)||n.push(r),n}}(n||(n={}))},50552:function(e,t,i){"use strict";i.r(t),i.d(t,{DataUri:function(){return L},ExtUri:function(){return d},addTrailingPathSeparator:function(){return I},basename:function(){return v},basenameOrAuthority:function(){return b},dirname:function(){return A},extUri:function(){return u},extUriBiasedIgnorePathCase:function(){return h},extUriIgnorePathCase:function(){return g},extname:function(){return _},getComparisonKey:function(){return f},hasTrailingPathSeparator:function(){return k},isAbsolutePath:function(){return x},isEqual:function(){return p},isEqualAuthority:function(){return E},isEqualOrParent:function(){return m},joinPath:function(){return C},normalizePath:function(){return w},originalFSPath:function(){return c},relativePath:function(){return y},removeTrailingPathSeparator:function(){return D},resolvePath:function(){return S}});var n=i(98508),o=i(27952),r=i(23674),s=i(66719),a=i(91482),l=i(19300);function c(e){return(0,l.uriToFsPath)(e,!0)}class d{constructor(e){this._ignorePathCasing=e}compare(e,t,i=!1){return e===t?0:(0,a.compare)(this.getComparisonKey(e,i),this.getComparisonKey(t,i))}isEqual(e,t,i=!1){return e===t||!(!e||!t)&&this.getComparisonKey(e,i)===this.getComparisonKey(t,i)}getComparisonKey(e,t=!1){return e.with({path:this._ignorePathCasing(e)?e.path.toLowerCase():void 0,fragment:t?null:void 0}).toString()}isEqualOrParent(e,t,i=!1){if(e.scheme===t.scheme){if(e.scheme===o.Schemas.file)return n.isEqualOrParent(c(e),c(t),this._ignorePathCasing(e))&&e.query===t.query&&(i||e.fragment===t.fragment);if(E(e.authority,t.authority))return n.isEqualOrParent(e.path,t.path,this._ignorePathCasing(e),"/")&&e.query===t.query&&(i||e.fragment===t.fragment)}return!1}joinPath(e,...t){return l.URI.joinPath(e,...t)}basenameOrAuthority(e){return v(e)||e.authority}basename(e){return r.posix.basename(e.path)}extname(e){return r.posix.extname(e.path)}dirname(e){if(0===e.path.length)return e;let t;return e.scheme===o.Schemas.file?t=l.URI.file(r.dirname(c(e))).path:(t=r.posix.dirname(e.path),e.authority&&t.length&&47!==t.charCodeAt(0)&&(console.error(`dirname("${e.toString})) resulted in a relative path`),t="/")),e.with({path:t})}normalizePath(e){if(!e.path.length)return e;let t;return t=e.scheme===o.Schemas.file?l.URI.file(r.normalize(c(e))).path:r.posix.normalize(e.path),e.with({path:t})}relativePath(e,t){if(e.scheme!==t.scheme||!E(e.authority,t.authority))return;if(e.scheme===o.Schemas.file){const i=r.relative(c(e),c(t));return s.isWindows?n.toSlashes(i):i}let i=e.path||"/";const a=t.path||"/";if(this._ignorePathCasing(e)){let e=0;for(const t=Math.min(i.length,a.length);e<t&&(i.charCodeAt(e)===a.charCodeAt(e)||i.charAt(e).toLowerCase()===a.charAt(e).toLowerCase());e++);i=a.substr(0,e)+i.substr(e)}return r.posix.relative(i,a)}resolvePath(e,t){if(e.scheme===o.Schemas.file){const i=l.URI.file(r.resolve(c(e),t));return e.with({authority:i.authority,path:i.path})}return t=n.toPosixPath(t),e.with({path:r.posix.resolve(e.path,t)})}isAbsolutePath(e){return!!e.path&&"/"===e.path[0]}isEqualAuthority(e,t){return e===t||void 0!==e&&void 0!==t&&(0,a.equalsIgnoreCase)(e,t)}hasTrailingPathSeparator(e,t=r.sep){if(e.scheme===o.Schemas.file){const i=c(e);return i.length>n.getRoot(i).length&&i[i.length-1]===t}{const t=e.path;return t.length>1&&47===t.charCodeAt(t.length-1)&&!/^[a-zA-Z]:(\/$|\\$)/.test(e.fsPath)}}removeTrailingPathSeparator(e,t=r.sep){return k(e,t)?e.with({path:e.path.substr(0,e.path.length-1)}):e}addTrailingPathSeparator(e,t=r.sep){let i=!1;if(e.scheme===o.Schemas.file){const o=c(e);i=void 0!==o&&o.length===n.getRoot(o).length&&o[o.length-1]===t}else{t="/";const n=e.path;i=1===n.length&&47===n.charCodeAt(n.length-1)}return i||k(e,t)?e:e.with({path:e.path+"/"})}}const u=new d((()=>!1)),h=new d((e=>e.scheme!==o.Schemas.file||!s.isLinux)),g=new d((e=>!0)),p=u.isEqual.bind(u),m=u.isEqualOrParent.bind(u),f=u.getComparisonKey.bind(u),b=u.basenameOrAuthority.bind(u),v=u.basename.bind(u),_=u.extname.bind(u),A=u.dirname.bind(u),C=u.joinPath.bind(u),w=u.normalizePath.bind(u),y=u.relativePath.bind(u),S=u.resolvePath.bind(u),x=u.isAbsolutePath.bind(u),E=u.isEqualAuthority.bind(u),k=u.hasTrailingPathSeparator.bind(u),D=u.removeTrailingPathSeparator.bind(u),I=u.addTrailingPathSeparator.bind(u);var L;!function(e){e.META_DATA_LABEL="label",e.META_DATA_DESCRIPTION="description",e.META_DATA_SIZE="size",e.META_DATA_MIME="mime",e.parseMetaData=function(t){const i=new Map;t.path.substring(t.path.indexOf(";")+1,t.path.lastIndexOf(";")).split(";").forEach((e=>{const[t,n]=e.split(":");t&&n&&i.set(t,n)}));const n=t.path.substring(0,t.path.indexOf(";"));return n&&i.set(e.META_DATA_MIME,n),i}}(L||(L={}))},6097:function(e,t,i){"use strict";i.r(t),i.d(t,{ScrollState:function(){return r},Scrollable:function(){return s},SmoothScrollingOperation:function(){return c},SmoothScrollingUpdate:function(){return a}});var n=i(63801),o=i(68921);class r{constructor(e,t,i,n,o,r,s){this._forceIntegerValues=e,this._scrollStateBrand=void 0,this._forceIntegerValues&&(t|=0,i|=0,n|=0,o|=0,r|=0,s|=0),this.rawScrollLeft=n,this.rawScrollTop=s,t<0&&(t=0),n+t>i&&(n=i-t),n<0&&(n=0),o<0&&(o=0),s+o>r&&(s=r-o),s<0&&(s=0),this.width=t,this.scrollWidth=i,this.scrollLeft=n,this.height=o,this.scrollHeight=r,this.scrollTop=s}equals(e){return this.rawScrollLeft===e.rawScrollLeft&&this.rawScrollTop===e.rawScrollTop&&this.width===e.width&&this.scrollWidth===e.scrollWidth&&this.scrollLeft===e.scrollLeft&&this.height===e.height&&this.scrollHeight===e.scrollHeight&&this.scrollTop===e.scrollTop}withScrollDimensions(e,t){return new r(this._forceIntegerValues,void 0!==e.width?e.width:this.width,void 0!==e.scrollWidth?e.scrollWidth:this.scrollWidth,t?this.rawScrollLeft:this.scrollLeft,void 0!==e.height?e.height:this.height,void 0!==e.scrollHeight?e.scrollHeight:this.scrollHeight,t?this.rawScrollTop:this.scrollTop)}withScrollPosition(e){return new r(this._forceIntegerValues,this.width,this.scrollWidth,void 0!==e.scrollLeft?e.scrollLeft:this.rawScrollLeft,this.height,this.scrollHeight,void 0!==e.scrollTop?e.scrollTop:this.rawScrollTop)}createScrollEvent(e,t){const i=this.width!==e.width,n=this.scrollWidth!==e.scrollWidth,o=this.scrollLeft!==e.scrollLeft,r=this.height!==e.height,s=this.scrollHeight!==e.scrollHeight,a=this.scrollTop!==e.scrollTop;return{inSmoothScrolling:t,oldWidth:e.width,oldScrollWidth:e.scrollWidth,oldScrollLeft:e.scrollLeft,width:this.width,scrollWidth:this.scrollWidth,scrollLeft:this.scrollLeft,oldHeight:e.height,oldScrollHeight:e.scrollHeight,oldScrollTop:e.scrollTop,height:this.height,scrollHeight:this.scrollHeight,scrollTop:this.scrollTop,widthChanged:i,scrollWidthChanged:n,scrollLeftChanged:o,heightChanged:r,scrollHeightChanged:s,scrollTopChanged:a}}}class s extends o.Disposable{constructor(e){super(),this._scrollableBrand=void 0,this._onScroll=this._register(new n.Emitter),this.onScroll=this._onScroll.event,this._smoothScrollDuration=e.smoothScrollDuration,this._scheduleAtNextAnimationFrame=e.scheduleAtNextAnimationFrame,this._state=new r(e.forceIntegerValues,0,0,0,0,0,0),this._smoothScrolling=null}dispose(){this._smoothScrolling&&(this._smoothScrolling.dispose(),this._smoothScrolling=null),super.dispose()}setSmoothScrollDuration(e){this._smoothScrollDuration=e}validateScrollPosition(e){return this._state.withScrollPosition(e)}getScrollDimensions(){return this._state}setScrollDimensions(e,t){var i;const n=this._state.withScrollDimensions(e,t);this._setState(n,Boolean(this._smoothScrolling)),null===(i=this._smoothScrolling)||void 0===i||i.acceptScrollDimensions(this._state)}getFutureScrollPosition(){return this._smoothScrolling?this._smoothScrolling.to:this._state}getCurrentScrollPosition(){return this._state}setScrollPositionNow(e){const t=this._state.withScrollPosition(e);this._smoothScrolling&&(this._smoothScrolling.dispose(),this._smoothScrolling=null),this._setState(t,!1)}setScrollPositionSmooth(e,t){if(0===this._smoothScrollDuration)return this.setScrollPositionNow(e);if(this._smoothScrolling){e={scrollLeft:void 0===e.scrollLeft?this._smoothScrolling.to.scrollLeft:e.scrollLeft,scrollTop:void 0===e.scrollTop?this._smoothScrolling.to.scrollTop:e.scrollTop};const i=this._state.withScrollPosition(e);if(this._smoothScrolling.to.scrollLeft===i.scrollLeft&&this._smoothScrolling.to.scrollTop===i.scrollTop)return;let n;n=t?new c(this._smoothScrolling.from,i,this._smoothScrolling.startTime,this._smoothScrolling.duration):this._smoothScrolling.combine(this._state,i,this._smoothScrollDuration),this._smoothScrolling.dispose(),this._smoothScrolling=n}else{const t=this._state.withScrollPosition(e);this._smoothScrolling=c.start(this._state,t,this._smoothScrollDuration)}this._smoothScrolling.animationFrameDisposable=this._scheduleAtNextAnimationFrame((()=>{this._smoothScrolling&&(this._smoothScrolling.animationFrameDisposable=null,this._performSmoothScrolling())}))}hasPendingScrollAnimation(){return Boolean(this._smoothScrolling)}_performSmoothScrolling(){if(!this._smoothScrolling)return;const e=this._smoothScrolling.tick(),t=this._state.withScrollPosition(e);return this._setState(t,!0),this._smoothScrolling?e.isDone?(this._smoothScrolling.dispose(),void(this._smoothScrolling=null)):void(this._smoothScrolling.animationFrameDisposable=this._scheduleAtNextAnimationFrame((()=>{this._smoothScrolling&&(this._smoothScrolling.animationFrameDisposable=null,this._performSmoothScrolling())}))):void 0}_setState(e,t){const i=this._state;i.equals(e)||(this._state=e,this._onScroll.fire(this._state.createScrollEvent(i,t)))}}class a{constructor(e,t,i){this.scrollLeft=e,this.scrollTop=t,this.isDone=i}}function l(e,t){const i=t-e;return function(t){return e+i*(1-function(e){return Math.pow(e,3)}(1-t))}}class c{constructor(e,t,i,n){this.from=e,this.to=t,this.duration=n,this.startTime=i,this.animationFrameDisposable=null,this._initAnimations()}_initAnimations(){this.scrollLeft=this._initAnimation(this.from.scrollLeft,this.to.scrollLeft,this.to.width),this.scrollTop=this._initAnimation(this.from.scrollTop,this.to.scrollTop,this.to.height)}_initAnimation(e,t,i){if(Math.abs(e-t)>2.5*i){let s,a;return e<t?(s=e+.75*i,a=t-.75*i):(s=e-.75*i,a=t+.75*i),n=l(e,s),o=l(a,t),r=.33,function(e){return e<r?n(e/r):o((e-r)/(1-r))}}var n,o,r;return l(e,t)}dispose(){null!==this.animationFrameDisposable&&(this.animationFrameDisposable.dispose(),this.animationFrameDisposable=null)}acceptScrollDimensions(e){this.to=e.withScrollPosition(this.to),this._initAnimations()}tick(){return this._tick(Date.now())}_tick(e){const t=(e-this.startTime)/this.duration;if(t<1){const e=this.scrollLeft(t),i=this.scrollTop(t);return new a(e,i,!1)}return new a(this.to.scrollLeft,this.to.scrollTop,!0)}combine(e,t,i){return c.start(e,t,i)}static start(e,t,i){i+=10;const n=Date.now()-10;return new c(e,t,n,i)}}},15051:function(e,t,i){"use strict";i.r(t);var n,o=i(91482);!function(e){e[e.Ignore=0]="Ignore",e[e.Info=1]="Info",e[e.Warning=2]="Warning",e[e.Error=3]="Error"}(n||(n={})),function(e){const t="error",i="warning",n="info";e.fromValue=function(r){return r?o.equalsIgnoreCase(t,r)?e.Error:o.equalsIgnoreCase(i,r)||o.equalsIgnoreCase("warn",r)?e.Warning:o.equalsIgnoreCase(n,r)?e.Info:e.Ignore:e.Ignore},e.toString=function(o){switch(o){case e.Error:return t;case e.Warning:return i;case e.Info:return n;default:return"ignore"}}}(n||(n={})),t.default=n},702:function(e,t,i){"use strict";i.r(t),i.d(t,{StopWatch:function(){return o}});const n=globalThis.performance&&"function"==typeof globalThis.performance.now;class o{static create(e){return new o(e)}constructor(e){this._now=n&&!1===e?Date.now:globalThis.performance.now.bind(globalThis.performance),this._startTime=this._now(),this._stopTime=-1}stop(){this._stopTime=this._now()}elapsed(){return-1!==this._stopTime?this._stopTime-this._startTime:this._now()-this._startTime}}},91482:function(e,t,i){"use strict";i.r(t),i.d(t,{AmbiguousCharacters:function(){return re},CodePointIterator:function(){return F},GraphemeIterator:function(){return P},InvisibleCharacters:function(){return se},UNUSUAL_LINE_TERMINATORS:function(){return j},UTF8_BOM_CHARACTER:function(){return $},commonPrefixLength:function(){return T},commonSuffixLength:function(){return M},compare:function(){return w},compareIgnoreCase:function(){return S},compareSubstring:function(){return y},compareSubstringIgnoreCase:function(){return x},computeCodePoint:function(){return B},containsRTL:function(){return U},containsUnusualLineTerminators:function(){return G},containsUppercaseCharacter:function(){return Z},convertSimple2RegExpPattern:function(){return p},createRegExp:function(){return f},equalsIgnoreCase:function(){return I},escape:function(){return c},escapeRegExpCharacters:function(){return d},firstNonWhitespaceIndex:function(){return _},format:function(){return l},getCharContainingOffset:function(){return H},getLeadingWhitespace:function(){return A},getLeftDeleteOffset:function(){return ie},getNextCodePoint:function(){return O},isAsciiDigit:function(){return E},isBasicASCII:function(){return K},isEmojiImprecise:function(){return Y},isFalsyOrWhitespace:function(){return s},isFullWidthCharacter:function(){return q},isHighSurrogate:function(){return N},isLowSurrogate:function(){return R},isLowerAsciiLetter:function(){return k},isUpperAsciiLetter:function(){return D},lastNonWhitespaceIndex:function(){return C},ltrim:function(){return h},nextCharLength:function(){return z},noBreakWhitespace:function(){return oe},prevCharLength:function(){return W},regExpLeadsToEndlessLoop:function(){return b},rtrim:function(){return g},singleLetterHash:function(){return X},splitLines:function(){return v},startsWithIgnoreCase:function(){return L},startsWithUTF8BOM:function(){return J},stripWildcards:function(){return m},trim:function(){return u}});var n,o=i(12359),r=i(5560);function s(e){return!e||"string"!=typeof e||0===e.trim().length}const a=/{(\d+)}/g;function l(e,...t){return 0===t.length?e:e.replace(a,(function(e,i){const n=parseInt(i,10);return isNaN(n)||n<0||n>=t.length?e:t[n]}))}function c(e){return e.replace(/[<>&]/g,(function(e){switch(e){case"<":return"&lt;";case">":return"&gt;";case"&":return"&amp;";default:return e}}))}function d(e){return e.replace(/[\\\{\}\*\+\?\|\^\$\.\[\]\(\)]/g,"\\$&")}function u(e,t=" "){return g(h(e,t),t)}function h(e,t){if(!e||!t)return e;const i=t.length;if(0===i||0===e.length)return e;let n=0;for(;e.indexOf(t,n)===n;)n+=i;return e.substring(n)}function g(e,t){if(!e||!t)return e;const i=t.length,n=e.length;if(0===i||0===n)return e;let o=n,r=-1;for(;r=e.lastIndexOf(t,o-1),-1!==r&&r+i===o;){if(0===r)return"";o=r}return e.substring(0,o)}function p(e){return e.replace(/[\-\\\{\}\+\?\|\^\$\.\,\[\]\(\)\#\s]/g,"\\$&").replace(/[\*]/g,".*")}function m(e){return e.replace(/\*/g,"")}function f(e,t,i={}){if(!e)throw new Error("Cannot create regex from empty string");t||(e=d(e)),i.wholeWord&&(/\B/.test(e.charAt(0))||(e="\\b"+e),/\B/.test(e.charAt(e.length-1))||(e+="\\b"));let n="";return i.global&&(n+="g"),i.matchCase||(n+="i"),i.multiline&&(n+="m"),i.unicode&&(n+="u"),new RegExp(e,n)}function b(e){if("^"===e.source||"^$"===e.source||"$"===e.source||"^\\s*$"===e.source)return!1;return!(!e.exec("")||0!==e.lastIndex)}function v(e){return e.split(/\r\n|\r|\n/)}function _(e){for(let t=0,i=e.length;t<i;t++){const i=e.charCodeAt(t);if(32!==i&&9!==i)return t}return-1}function A(e,t=0,i=e.length){for(let n=t;n<i;n++){const i=e.charCodeAt(n);if(32!==i&&9!==i)return e.substring(t,n)}return e.substring(t,i)}function C(e,t=e.length-1){for(let i=t;i>=0;i--){const t=e.charCodeAt(i);if(32!==t&&9!==t)return i}return-1}function w(e,t){return e<t?-1:e>t?1:0}function y(e,t,i=0,n=e.length,o=0,r=t.length){for(;i<n&&o<r;i++,o++){const n=e.charCodeAt(i),r=t.charCodeAt(o);if(n<r)return-1;if(n>r)return 1}const s=n-i,a=r-o;return s<a?-1:s>a?1:0}function S(e,t){return x(e,t,0,e.length,0,t.length)}function x(e,t,i=0,n=e.length,o=0,r=t.length){for(;i<n&&o<r;i++,o++){let s=e.charCodeAt(i),a=t.charCodeAt(o);if(s===a)continue;if(s>=128||a>=128)return y(e.toLowerCase(),t.toLowerCase(),i,n,o,r);k(s)&&(s-=32),k(a)&&(a-=32);const l=s-a;if(0!==l)return l}const s=n-i,a=r-o;return s<a?-1:s>a?1:0}function E(e){return e>=48&&e<=57}function k(e){return e>=97&&e<=122}function D(e){return e>=65&&e<=90}function I(e,t){return e.length===t.length&&0===x(e,t)}function L(e,t){const i=t.length;return!(t.length>e.length)&&0===x(e,t,0,i)}function T(e,t){const i=Math.min(e.length,t.length);let n;for(n=0;n<i;n++)if(e.charCodeAt(n)!==t.charCodeAt(n))return n;return i}function M(e,t){const i=Math.min(e.length,t.length);let n;const o=e.length-1,r=t.length-1;for(n=0;n<i;n++)if(e.charCodeAt(o-n)!==t.charCodeAt(r-n))return n;return i}function N(e){return 55296<=e&&e<=56319}function R(e){return 56320<=e&&e<=57343}function B(e,t){return t-56320+(e-55296<<10)+65536}function O(e,t,i){const n=e.charCodeAt(i);if(N(n)&&i+1<t){const t=e.charCodeAt(i+1);if(R(t))return B(n,t)}return n}class F{get offset(){return this._offset}constructor(e,t=0){this._str=e,this._len=e.length,this._offset=t}setOffset(e){this._offset=e}prevCodePoint(){const e=function(e,t){const i=e.charCodeAt(t-1);if(R(i)&&t>1){const n=e.charCodeAt(t-2);if(N(n))return B(n,i)}return i}(this._str,this._offset);return this._offset-=e>=65536?2:1,e}nextCodePoint(){const e=O(this._str,this._len,this._offset);return this._offset+=e>=65536?2:1,e}eol(){return this._offset>=this._len}}class P{get offset(){return this._iterator.offset}constructor(e,t=0){this._iterator=new F(e,t)}nextGraphemeLength(){const e=te.getInstance(),t=this._iterator,i=t.offset;let n=e.getGraphemeBreakType(t.nextCodePoint());for(;!t.eol();){const i=t.offset,o=e.getGraphemeBreakType(t.nextCodePoint());if(ee(n,o)){t.setOffset(i);break}n=o}return t.offset-i}prevGraphemeLength(){const e=te.getInstance(),t=this._iterator,i=t.offset;let n=e.getGraphemeBreakType(t.prevCodePoint());for(;t.offset>0;){const i=t.offset,o=e.getGraphemeBreakType(t.prevCodePoint());if(ee(o,n)){t.setOffset(i);break}n=o}return i-t.offset}eol(){return this._iterator.eol()}}function z(e,t){return new P(e,t).nextGraphemeLength()}function W(e,t){return new P(e,t).prevGraphemeLength()}function H(e,t){t>0&&R(e.charCodeAt(t))&&t--;const i=t+z(e,t);return[i-W(e,i),i]}let V;function U(e){return V||(V=/(?:[\u05BE\u05C0\u05C3\u05C6\u05D0-\u05F4\u0608\u060B\u060D\u061B-\u064A\u066D-\u066F\u0671-\u06D5\u06E5\u06E6\u06EE\u06EF\u06FA-\u0710\u0712-\u072F\u074D-\u07A5\u07B1-\u07EA\u07F4\u07F5\u07FA\u07FE-\u0815\u081A\u0824\u0828\u0830-\u0858\u085E-\u088E\u08A0-\u08C9\u200F\uFB1D\uFB1F-\uFB28\uFB2A-\uFD3D\uFD50-\uFDC7\uFDF0-\uFDFC\uFE70-\uFEFC]|\uD802[\uDC00-\uDD1B\uDD20-\uDE00\uDE10-\uDE35\uDE40-\uDEE4\uDEEB-\uDF35\uDF40-\uDFFF]|\uD803[\uDC00-\uDD23\uDE80-\uDEA9\uDEAD-\uDF45\uDF51-\uDF81\uDF86-\uDFF6]|\uD83A[\uDC00-\uDCCF\uDD00-\uDD43\uDD4B-\uDFFF]|\uD83B[\uDC00-\uDEBB])/),V.test(e)}const Q=/^[\t\n\r\x20-\x7E]*$/;function K(e){return Q.test(e)}const j=/[\u2028\u2029]/;function G(e){return j.test(e)}function q(e){return e>=11904&&e<=55215||e>=63744&&e<=64255||e>=65281&&e<=65374}function Y(e){return e>=127462&&e<=127487||8986===e||8987===e||9200===e||9203===e||e>=9728&&e<=10175||11088===e||11093===e||e>=127744&&e<=128591||e>=128640&&e<=128764||e>=128992&&e<=129008||e>=129280&&e<=129535||e>=129648&&e<=129782}const $=String.fromCharCode(65279);function J(e){return!!(e&&e.length>0&&65279===e.charCodeAt(0))}function Z(e,t=!1){return!!e&&(t&&(e=e.replace(/\\./g,"")),e.toLowerCase()!==e)}function X(e){return(e%=52)<26?String.fromCharCode(97+e):String.fromCharCode(65+e-26)}function ee(e,t){return 0===e?5!==t&&7!==t:(2!==e||3!==t)&&(4===e||2===e||3===e||(4===t||2===t||3===t||(8!==e||8!==t&&9!==t&&11!==t&&12!==t)&&((11!==e&&9!==e||9!==t&&10!==t)&&((12!==e&&10!==e||10!==t)&&(5!==t&&13!==t&&(7!==t&&(1!==e&&((13!==e||14!==t)&&(6!==e||6!==t)))))))))}class te{static getInstance(){return te._INSTANCE||(te._INSTANCE=new te),te._INSTANCE}constructor(){this._data=JSON.parse("[0,0,0,51229,51255,12,44061,44087,12,127462,127487,6,7083,7085,5,47645,47671,12,54813,54839,12,128678,128678,14,3270,3270,5,9919,9923,14,45853,45879,12,49437,49463,12,53021,53047,12,71216,71218,7,128398,128399,14,129360,129374,14,2519,2519,5,4448,4519,9,9742,9742,14,12336,12336,14,44957,44983,12,46749,46775,12,48541,48567,12,50333,50359,12,52125,52151,12,53917,53943,12,69888,69890,5,73018,73018,5,127990,127990,14,128558,128559,14,128759,128760,14,129653,129655,14,2027,2035,5,2891,2892,7,3761,3761,5,6683,6683,5,8293,8293,4,9825,9826,14,9999,9999,14,43452,43453,5,44509,44535,12,45405,45431,12,46301,46327,12,47197,47223,12,48093,48119,12,48989,49015,12,49885,49911,12,50781,50807,12,51677,51703,12,52573,52599,12,53469,53495,12,54365,54391,12,65279,65279,4,70471,70472,7,72145,72147,7,119173,119179,5,127799,127818,14,128240,128244,14,128512,128512,14,128652,128652,14,128721,128722,14,129292,129292,14,129445,129450,14,129734,129743,14,1476,1477,5,2366,2368,7,2750,2752,7,3076,3076,5,3415,3415,5,4141,4144,5,6109,6109,5,6964,6964,5,7394,7400,5,9197,9198,14,9770,9770,14,9877,9877,14,9968,9969,14,10084,10084,14,43052,43052,5,43713,43713,5,44285,44311,12,44733,44759,12,45181,45207,12,45629,45655,12,46077,46103,12,46525,46551,12,46973,46999,12,47421,47447,12,47869,47895,12,48317,48343,12,48765,48791,12,49213,49239,12,49661,49687,12,50109,50135,12,50557,50583,12,51005,51031,12,51453,51479,12,51901,51927,12,52349,52375,12,52797,52823,12,53245,53271,12,53693,53719,12,54141,54167,12,54589,54615,12,55037,55063,12,69506,69509,5,70191,70193,5,70841,70841,7,71463,71467,5,72330,72342,5,94031,94031,5,123628,123631,5,127763,127765,14,127941,127941,14,128043,128062,14,128302,128317,14,128465,128467,14,128539,128539,14,128640,128640,14,128662,128662,14,128703,128703,14,128745,128745,14,129004,129007,14,129329,129330,14,129402,129402,14,129483,129483,14,129686,129704,14,130048,131069,14,173,173,4,1757,1757,1,2200,2207,5,2434,2435,7,2631,2632,5,2817,2817,5,3008,3008,5,3201,3201,5,3387,3388,5,3542,3542,5,3902,3903,7,4190,4192,5,6002,6003,5,6439,6440,5,6765,6770,7,7019,7027,5,7154,7155,7,8205,8205,13,8505,8505,14,9654,9654,14,9757,9757,14,9792,9792,14,9852,9853,14,9890,9894,14,9937,9937,14,9981,9981,14,10035,10036,14,11035,11036,14,42654,42655,5,43346,43347,7,43587,43587,5,44006,44007,7,44173,44199,12,44397,44423,12,44621,44647,12,44845,44871,12,45069,45095,12,45293,45319,12,45517,45543,12,45741,45767,12,45965,45991,12,46189,46215,12,46413,46439,12,46637,46663,12,46861,46887,12,47085,47111,12,47309,47335,12,47533,47559,12,47757,47783,12,47981,48007,12,48205,48231,12,48429,48455,12,48653,48679,12,48877,48903,12,49101,49127,12,49325,49351,12,49549,49575,12,49773,49799,12,49997,50023,12,50221,50247,12,50445,50471,12,50669,50695,12,50893,50919,12,51117,51143,12,51341,51367,12,51565,51591,12,51789,51815,12,52013,52039,12,52237,52263,12,52461,52487,12,52685,52711,12,52909,52935,12,53133,53159,12,53357,53383,12,53581,53607,12,53805,53831,12,54029,54055,12,54253,54279,12,54477,54503,12,54701,54727,12,54925,54951,12,55149,55175,12,68101,68102,5,69762,69762,7,70067,70069,7,70371,70378,5,70720,70721,7,71087,71087,5,71341,71341,5,71995,71996,5,72249,72249,7,72850,72871,5,73109,73109,5,118576,118598,5,121505,121519,5,127245,127247,14,127568,127569,14,127777,127777,14,127872,127891,14,127956,127967,14,128015,128016,14,128110,128172,14,128259,128259,14,128367,128368,14,128424,128424,14,128488,128488,14,128530,128532,14,128550,128551,14,128566,128566,14,128647,128647,14,128656,128656,14,128667,128673,14,128691,128693,14,128715,128715,14,128728,128732,14,128752,128752,14,128765,128767,14,129096,129103,14,129311,129311,14,129344,129349,14,129394,129394,14,129413,129425,14,129466,129471,14,129511,129535,14,129664,129666,14,129719,129722,14,129760,129767,14,917536,917631,5,13,13,2,1160,1161,5,1564,1564,4,1807,1807,1,2085,2087,5,2307,2307,7,2382,2383,7,2497,2500,5,2563,2563,7,2677,2677,5,2763,2764,7,2879,2879,5,2914,2915,5,3021,3021,5,3142,3144,5,3263,3263,5,3285,3286,5,3398,3400,7,3530,3530,5,3633,3633,5,3864,3865,5,3974,3975,5,4155,4156,7,4229,4230,5,5909,5909,7,6078,6085,7,6277,6278,5,6451,6456,7,6744,6750,5,6846,6846,5,6972,6972,5,7074,7077,5,7146,7148,7,7222,7223,5,7416,7417,5,8234,8238,4,8417,8417,5,9000,9000,14,9203,9203,14,9730,9731,14,9748,9749,14,9762,9763,14,9776,9783,14,9800,9811,14,9831,9831,14,9872,9873,14,9882,9882,14,9900,9903,14,9929,9933,14,9941,9960,14,9974,9974,14,9989,9989,14,10006,10006,14,10062,10062,14,10160,10160,14,11647,11647,5,12953,12953,14,43019,43019,5,43232,43249,5,43443,43443,5,43567,43568,7,43696,43696,5,43765,43765,7,44013,44013,5,44117,44143,12,44229,44255,12,44341,44367,12,44453,44479,12,44565,44591,12,44677,44703,12,44789,44815,12,44901,44927,12,45013,45039,12,45125,45151,12,45237,45263,12,45349,45375,12,45461,45487,12,45573,45599,12,45685,45711,12,45797,45823,12,45909,45935,12,46021,46047,12,46133,46159,12,46245,46271,12,46357,46383,12,46469,46495,12,46581,46607,12,46693,46719,12,46805,46831,12,46917,46943,12,47029,47055,12,47141,47167,12,47253,47279,12,47365,47391,12,47477,47503,12,47589,47615,12,47701,47727,12,47813,47839,12,47925,47951,12,48037,48063,12,48149,48175,12,48261,48287,12,48373,48399,12,48485,48511,12,48597,48623,12,48709,48735,12,48821,48847,12,48933,48959,12,49045,49071,12,49157,49183,12,49269,49295,12,49381,49407,12,49493,49519,12,49605,49631,12,49717,49743,12,49829,49855,12,49941,49967,12,50053,50079,12,50165,50191,12,50277,50303,12,50389,50415,12,50501,50527,12,50613,50639,12,50725,50751,12,50837,50863,12,50949,50975,12,51061,51087,12,51173,51199,12,51285,51311,12,51397,51423,12,51509,51535,12,51621,51647,12,51733,51759,12,51845,51871,12,51957,51983,12,52069,52095,12,52181,52207,12,52293,52319,12,52405,52431,12,52517,52543,12,52629,52655,12,52741,52767,12,52853,52879,12,52965,52991,12,53077,53103,12,53189,53215,12,53301,53327,12,53413,53439,12,53525,53551,12,53637,53663,12,53749,53775,12,53861,53887,12,53973,53999,12,54085,54111,12,54197,54223,12,54309,54335,12,54421,54447,12,54533,54559,12,54645,54671,12,54757,54783,12,54869,54895,12,54981,55007,12,55093,55119,12,55243,55291,10,66045,66045,5,68325,68326,5,69688,69702,5,69817,69818,5,69957,69958,7,70089,70092,5,70198,70199,5,70462,70462,5,70502,70508,5,70750,70750,5,70846,70846,7,71100,71101,5,71230,71230,7,71351,71351,5,71737,71738,5,72000,72000,7,72160,72160,5,72273,72278,5,72752,72758,5,72882,72883,5,73031,73031,5,73461,73462,7,94192,94193,7,119149,119149,7,121403,121452,5,122915,122916,5,126980,126980,14,127358,127359,14,127535,127535,14,127759,127759,14,127771,127771,14,127792,127793,14,127825,127867,14,127897,127899,14,127945,127945,14,127985,127986,14,128000,128007,14,128021,128021,14,128066,128100,14,128184,128235,14,128249,128252,14,128266,128276,14,128335,128335,14,128379,128390,14,128407,128419,14,128444,128444,14,128481,128481,14,128499,128499,14,128526,128526,14,128536,128536,14,128543,128543,14,128556,128556,14,128564,128564,14,128577,128580,14,128643,128645,14,128649,128649,14,128654,128654,14,128660,128660,14,128664,128664,14,128675,128675,14,128686,128689,14,128695,128696,14,128705,128709,14,128717,128719,14,128725,128725,14,128736,128741,14,128747,128748,14,128755,128755,14,128762,128762,14,128981,128991,14,129009,129023,14,129160,129167,14,129296,129304,14,129320,129327,14,129340,129342,14,129356,129356,14,129388,129392,14,129399,129400,14,129404,129407,14,129432,129442,14,129454,129455,14,129473,129474,14,129485,129487,14,129648,129651,14,129659,129660,14,129671,129679,14,129709,129711,14,129728,129730,14,129751,129753,14,129776,129782,14,917505,917505,4,917760,917999,5,10,10,3,127,159,4,768,879,5,1471,1471,5,1536,1541,1,1648,1648,5,1767,1768,5,1840,1866,5,2070,2073,5,2137,2139,5,2274,2274,1,2363,2363,7,2377,2380,7,2402,2403,5,2494,2494,5,2507,2508,7,2558,2558,5,2622,2624,7,2641,2641,5,2691,2691,7,2759,2760,5,2786,2787,5,2876,2876,5,2881,2884,5,2901,2902,5,3006,3006,5,3014,3016,7,3072,3072,5,3134,3136,5,3157,3158,5,3260,3260,5,3266,3266,5,3274,3275,7,3328,3329,5,3391,3392,7,3405,3405,5,3457,3457,5,3536,3537,7,3551,3551,5,3636,3642,5,3764,3772,5,3895,3895,5,3967,3967,7,3993,4028,5,4146,4151,5,4182,4183,7,4226,4226,5,4253,4253,5,4957,4959,5,5940,5940,7,6070,6070,7,6087,6088,7,6158,6158,4,6432,6434,5,6448,6449,7,6679,6680,5,6742,6742,5,6754,6754,5,6783,6783,5,6912,6915,5,6966,6970,5,6978,6978,5,7042,7042,7,7080,7081,5,7143,7143,7,7150,7150,7,7212,7219,5,7380,7392,5,7412,7412,5,8203,8203,4,8232,8232,4,8265,8265,14,8400,8412,5,8421,8432,5,8617,8618,14,9167,9167,14,9200,9200,14,9410,9410,14,9723,9726,14,9733,9733,14,9745,9745,14,9752,9752,14,9760,9760,14,9766,9766,14,9774,9774,14,9786,9786,14,9794,9794,14,9823,9823,14,9828,9828,14,9833,9850,14,9855,9855,14,9875,9875,14,9880,9880,14,9885,9887,14,9896,9897,14,9906,9916,14,9926,9927,14,9935,9935,14,9939,9939,14,9962,9962,14,9972,9972,14,9978,9978,14,9986,9986,14,9997,9997,14,10002,10002,14,10017,10017,14,10055,10055,14,10071,10071,14,10133,10135,14,10548,10549,14,11093,11093,14,12330,12333,5,12441,12442,5,42608,42610,5,43010,43010,5,43045,43046,5,43188,43203,7,43302,43309,5,43392,43394,5,43446,43449,5,43493,43493,5,43571,43572,7,43597,43597,7,43703,43704,5,43756,43757,5,44003,44004,7,44009,44010,7,44033,44059,12,44089,44115,12,44145,44171,12,44201,44227,12,44257,44283,12,44313,44339,12,44369,44395,12,44425,44451,12,44481,44507,12,44537,44563,12,44593,44619,12,44649,44675,12,44705,44731,12,44761,44787,12,44817,44843,12,44873,44899,12,44929,44955,12,44985,45011,12,45041,45067,12,45097,45123,12,45153,45179,12,45209,45235,12,45265,45291,12,45321,45347,12,45377,45403,12,45433,45459,12,45489,45515,12,45545,45571,12,45601,45627,12,45657,45683,12,45713,45739,12,45769,45795,12,45825,45851,12,45881,45907,12,45937,45963,12,45993,46019,12,46049,46075,12,46105,46131,12,46161,46187,12,46217,46243,12,46273,46299,12,46329,46355,12,46385,46411,12,46441,46467,12,46497,46523,12,46553,46579,12,46609,46635,12,46665,46691,12,46721,46747,12,46777,46803,12,46833,46859,12,46889,46915,12,46945,46971,12,47001,47027,12,47057,47083,12,47113,47139,12,47169,47195,12,47225,47251,12,47281,47307,12,47337,47363,12,47393,47419,12,47449,47475,12,47505,47531,12,47561,47587,12,47617,47643,12,47673,47699,12,47729,47755,12,47785,47811,12,47841,47867,12,47897,47923,12,47953,47979,12,48009,48035,12,48065,48091,12,48121,48147,12,48177,48203,12,48233,48259,12,48289,48315,12,48345,48371,12,48401,48427,12,48457,48483,12,48513,48539,12,48569,48595,12,48625,48651,12,48681,48707,12,48737,48763,12,48793,48819,12,48849,48875,12,48905,48931,12,48961,48987,12,49017,49043,12,49073,49099,12,49129,49155,12,49185,49211,12,49241,49267,12,49297,49323,12,49353,49379,12,49409,49435,12,49465,49491,12,49521,49547,12,49577,49603,12,49633,49659,12,49689,49715,12,49745,49771,12,49801,49827,12,49857,49883,12,49913,49939,12,49969,49995,12,50025,50051,12,50081,50107,12,50137,50163,12,50193,50219,12,50249,50275,12,50305,50331,12,50361,50387,12,50417,50443,12,50473,50499,12,50529,50555,12,50585,50611,12,50641,50667,12,50697,50723,12,50753,50779,12,50809,50835,12,50865,50891,12,50921,50947,12,50977,51003,12,51033,51059,12,51089,51115,12,51145,51171,12,51201,51227,12,51257,51283,12,51313,51339,12,51369,51395,12,51425,51451,12,51481,51507,12,51537,51563,12,51593,51619,12,51649,51675,12,51705,51731,12,51761,51787,12,51817,51843,12,51873,51899,12,51929,51955,12,51985,52011,12,52041,52067,12,52097,52123,12,52153,52179,12,52209,52235,12,52265,52291,12,52321,52347,12,52377,52403,12,52433,52459,12,52489,52515,12,52545,52571,12,52601,52627,12,52657,52683,12,52713,52739,12,52769,52795,12,52825,52851,12,52881,52907,12,52937,52963,12,52993,53019,12,53049,53075,12,53105,53131,12,53161,53187,12,53217,53243,12,53273,53299,12,53329,53355,12,53385,53411,12,53441,53467,12,53497,53523,12,53553,53579,12,53609,53635,12,53665,53691,12,53721,53747,12,53777,53803,12,53833,53859,12,53889,53915,12,53945,53971,12,54001,54027,12,54057,54083,12,54113,54139,12,54169,54195,12,54225,54251,12,54281,54307,12,54337,54363,12,54393,54419,12,54449,54475,12,54505,54531,12,54561,54587,12,54617,54643,12,54673,54699,12,54729,54755,12,54785,54811,12,54841,54867,12,54897,54923,12,54953,54979,12,55009,55035,12,55065,55091,12,55121,55147,12,55177,55203,12,65024,65039,5,65520,65528,4,66422,66426,5,68152,68154,5,69291,69292,5,69633,69633,5,69747,69748,5,69811,69814,5,69826,69826,5,69932,69932,7,70016,70017,5,70079,70080,7,70095,70095,5,70196,70196,5,70367,70367,5,70402,70403,7,70464,70464,5,70487,70487,5,70709,70711,7,70725,70725,7,70833,70834,7,70843,70844,7,70849,70849,7,71090,71093,5,71103,71104,5,71227,71228,7,71339,71339,5,71344,71349,5,71458,71461,5,71727,71735,5,71985,71989,7,71998,71998,5,72002,72002,7,72154,72155,5,72193,72202,5,72251,72254,5,72281,72283,5,72344,72345,5,72766,72766,7,72874,72880,5,72885,72886,5,73023,73029,5,73104,73105,5,73111,73111,5,92912,92916,5,94095,94098,5,113824,113827,4,119142,119142,7,119155,119162,4,119362,119364,5,121476,121476,5,122888,122904,5,123184,123190,5,125252,125258,5,127183,127183,14,127340,127343,14,127377,127386,14,127491,127503,14,127548,127551,14,127744,127756,14,127761,127761,14,127769,127769,14,127773,127774,14,127780,127788,14,127796,127797,14,127820,127823,14,127869,127869,14,127894,127895,14,127902,127903,14,127943,127943,14,127947,127950,14,127972,127972,14,127988,127988,14,127992,127994,14,128009,128011,14,128019,128019,14,128023,128041,14,128064,128064,14,128102,128107,14,128174,128181,14,128238,128238,14,128246,128247,14,128254,128254,14,128264,128264,14,128278,128299,14,128329,128330,14,128348,128359,14,128371,128377,14,128392,128393,14,128401,128404,14,128421,128421,14,128433,128434,14,128450,128452,14,128476,128478,14,128483,128483,14,128495,128495,14,128506,128506,14,128519,128520,14,128528,128528,14,128534,128534,14,128538,128538,14,128540,128542,14,128544,128549,14,128552,128555,14,128557,128557,14,128560,128563,14,128565,128565,14,128567,128576,14,128581,128591,14,128641,128642,14,128646,128646,14,128648,128648,14,128650,128651,14,128653,128653,14,128655,128655,14,128657,128659,14,128661,128661,14,128663,128663,14,128665,128666,14,128674,128674,14,128676,128677,14,128679,128685,14,128690,128690,14,128694,128694,14,128697,128702,14,128704,128704,14,128710,128714,14,128716,128716,14,128720,128720,14,128723,128724,14,128726,128727,14,128733,128735,14,128742,128744,14,128746,128746,14,128749,128751,14,128753,128754,14,128756,128758,14,128761,128761,14,128763,128764,14,128884,128895,14,128992,129003,14,129008,129008,14,129036,129039,14,129114,129119,14,129198,129279,14,129293,129295,14,129305,129310,14,129312,129319,14,129328,129328,14,129331,129338,14,129343,129343,14,129351,129355,14,129357,129359,14,129375,129387,14,129393,129393,14,129395,129398,14,129401,129401,14,129403,129403,14,129408,129412,14,129426,129431,14,129443,129444,14,129451,129453,14,129456,129465,14,129472,129472,14,129475,129482,14,129484,129484,14,129488,129510,14,129536,129647,14,129652,129652,14,129656,129658,14,129661,129663,14,129667,129670,14,129680,129685,14,129705,129708,14,129712,129718,14,129723,129727,14,129731,129733,14,129744,129750,14,129754,129759,14,129768,129775,14,129783,129791,14,917504,917504,4,917506,917535,4,917632,917759,4,918000,921599,4,0,9,4,11,12,4,14,31,4,169,169,14,174,174,14,1155,1159,5,1425,1469,5,1473,1474,5,1479,1479,5,1552,1562,5,1611,1631,5,1750,1756,5,1759,1764,5,1770,1773,5,1809,1809,5,1958,1968,5,2045,2045,5,2075,2083,5,2089,2093,5,2192,2193,1,2250,2273,5,2275,2306,5,2362,2362,5,2364,2364,5,2369,2376,5,2381,2381,5,2385,2391,5,2433,2433,5,2492,2492,5,2495,2496,7,2503,2504,7,2509,2509,5,2530,2531,5,2561,2562,5,2620,2620,5,2625,2626,5,2635,2637,5,2672,2673,5,2689,2690,5,2748,2748,5,2753,2757,5,2761,2761,7,2765,2765,5,2810,2815,5,2818,2819,7,2878,2878,5,2880,2880,7,2887,2888,7,2893,2893,5,2903,2903,5,2946,2946,5,3007,3007,7,3009,3010,7,3018,3020,7,3031,3031,5,3073,3075,7,3132,3132,5,3137,3140,7,3146,3149,5,3170,3171,5,3202,3203,7,3262,3262,7,3264,3265,7,3267,3268,7,3271,3272,7,3276,3277,5,3298,3299,5,3330,3331,7,3390,3390,5,3393,3396,5,3402,3404,7,3406,3406,1,3426,3427,5,3458,3459,7,3535,3535,5,3538,3540,5,3544,3550,7,3570,3571,7,3635,3635,7,3655,3662,5,3763,3763,7,3784,3789,5,3893,3893,5,3897,3897,5,3953,3966,5,3968,3972,5,3981,3991,5,4038,4038,5,4145,4145,7,4153,4154,5,4157,4158,5,4184,4185,5,4209,4212,5,4228,4228,7,4237,4237,5,4352,4447,8,4520,4607,10,5906,5908,5,5938,5939,5,5970,5971,5,6068,6069,5,6071,6077,5,6086,6086,5,6089,6099,5,6155,6157,5,6159,6159,5,6313,6313,5,6435,6438,7,6441,6443,7,6450,6450,5,6457,6459,5,6681,6682,7,6741,6741,7,6743,6743,7,6752,6752,5,6757,6764,5,6771,6780,5,6832,6845,5,6847,6862,5,6916,6916,7,6965,6965,5,6971,6971,7,6973,6977,7,6979,6980,7,7040,7041,5,7073,7073,7,7078,7079,7,7082,7082,7,7142,7142,5,7144,7145,5,7149,7149,5,7151,7153,5,7204,7211,7,7220,7221,7,7376,7378,5,7393,7393,7,7405,7405,5,7415,7415,7,7616,7679,5,8204,8204,5,8206,8207,4,8233,8233,4,8252,8252,14,8288,8292,4,8294,8303,4,8413,8416,5,8418,8420,5,8482,8482,14,8596,8601,14,8986,8987,14,9096,9096,14,9193,9196,14,9199,9199,14,9201,9202,14,9208,9210,14,9642,9643,14,9664,9664,14,9728,9729,14,9732,9732,14,9735,9741,14,9743,9744,14,9746,9746,14,9750,9751,14,9753,9756,14,9758,9759,14,9761,9761,14,9764,9765,14,9767,9769,14,9771,9773,14,9775,9775,14,9784,9785,14,9787,9791,14,9793,9793,14,9795,9799,14,9812,9822,14,9824,9824,14,9827,9827,14,9829,9830,14,9832,9832,14,9851,9851,14,9854,9854,14,9856,9861,14,9874,9874,14,9876,9876,14,9878,9879,14,9881,9881,14,9883,9884,14,9888,9889,14,9895,9895,14,9898,9899,14,9904,9905,14,9917,9918,14,9924,9925,14,9928,9928,14,9934,9934,14,9936,9936,14,9938,9938,14,9940,9940,14,9961,9961,14,9963,9967,14,9970,9971,14,9973,9973,14,9975,9977,14,9979,9980,14,9982,9985,14,9987,9988,14,9992,9996,14,9998,9998,14,10000,10001,14,10004,10004,14,10013,10013,14,10024,10024,14,10052,10052,14,10060,10060,14,10067,10069,14,10083,10083,14,10085,10087,14,10145,10145,14,10175,10175,14,11013,11015,14,11088,11088,14,11503,11505,5,11744,11775,5,12334,12335,5,12349,12349,14,12951,12951,14,42607,42607,5,42612,42621,5,42736,42737,5,43014,43014,5,43043,43044,7,43047,43047,7,43136,43137,7,43204,43205,5,43263,43263,5,43335,43345,5,43360,43388,8,43395,43395,7,43444,43445,7,43450,43451,7,43454,43456,7,43561,43566,5,43569,43570,5,43573,43574,5,43596,43596,5,43644,43644,5,43698,43700,5,43710,43711,5,43755,43755,7,43758,43759,7,43766,43766,5,44005,44005,5,44008,44008,5,44012,44012,7,44032,44032,11,44060,44060,11,44088,44088,11,44116,44116,11,44144,44144,11,44172,44172,11,44200,44200,11,44228,44228,11,44256,44256,11,44284,44284,11,44312,44312,11,44340,44340,11,44368,44368,11,44396,44396,11,44424,44424,11,44452,44452,11,44480,44480,11,44508,44508,11,44536,44536,11,44564,44564,11,44592,44592,11,44620,44620,11,44648,44648,11,44676,44676,11,44704,44704,11,44732,44732,11,44760,44760,11,44788,44788,11,44816,44816,11,44844,44844,11,44872,44872,11,44900,44900,11,44928,44928,11,44956,44956,11,44984,44984,11,45012,45012,11,45040,45040,11,45068,45068,11,45096,45096,11,45124,45124,11,45152,45152,11,45180,45180,11,45208,45208,11,45236,45236,11,45264,45264,11,45292,45292,11,45320,45320,11,45348,45348,11,45376,45376,11,45404,45404,11,45432,45432,11,45460,45460,11,45488,45488,11,45516,45516,11,45544,45544,11,45572,45572,11,45600,45600,11,45628,45628,11,45656,45656,11,45684,45684,11,45712,45712,11,45740,45740,11,45768,45768,11,45796,45796,11,45824,45824,11,45852,45852,11,45880,45880,11,45908,45908,11,45936,45936,11,45964,45964,11,45992,45992,11,46020,46020,11,46048,46048,11,46076,46076,11,46104,46104,11,46132,46132,11,46160,46160,11,46188,46188,11,46216,46216,11,46244,46244,11,46272,46272,11,46300,46300,11,46328,46328,11,46356,46356,11,46384,46384,11,46412,46412,11,46440,46440,11,46468,46468,11,46496,46496,11,46524,46524,11,46552,46552,11,46580,46580,11,46608,46608,11,46636,46636,11,46664,46664,11,46692,46692,11,46720,46720,11,46748,46748,11,46776,46776,11,46804,46804,11,46832,46832,11,46860,46860,11,46888,46888,11,46916,46916,11,46944,46944,11,46972,46972,11,47000,47000,11,47028,47028,11,47056,47056,11,47084,47084,11,47112,47112,11,47140,47140,11,47168,47168,11,47196,47196,11,47224,47224,11,47252,47252,11,47280,47280,11,47308,47308,11,47336,47336,11,47364,47364,11,47392,47392,11,47420,47420,11,47448,47448,11,47476,47476,11,47504,47504,11,47532,47532,11,47560,47560,11,47588,47588,11,47616,47616,11,47644,47644,11,47672,47672,11,47700,47700,11,47728,47728,11,47756,47756,11,47784,47784,11,47812,47812,11,47840,47840,11,47868,47868,11,47896,47896,11,47924,47924,11,47952,47952,11,47980,47980,11,48008,48008,11,48036,48036,11,48064,48064,11,48092,48092,11,48120,48120,11,48148,48148,11,48176,48176,11,48204,48204,11,48232,48232,11,48260,48260,11,48288,48288,11,48316,48316,11,48344,48344,11,48372,48372,11,48400,48400,11,48428,48428,11,48456,48456,11,48484,48484,11,48512,48512,11,48540,48540,11,48568,48568,11,48596,48596,11,48624,48624,11,48652,48652,11,48680,48680,11,48708,48708,11,48736,48736,11,48764,48764,11,48792,48792,11,48820,48820,11,48848,48848,11,48876,48876,11,48904,48904,11,48932,48932,11,48960,48960,11,48988,48988,11,49016,49016,11,49044,49044,11,49072,49072,11,49100,49100,11,49128,49128,11,49156,49156,11,49184,49184,11,49212,49212,11,49240,49240,11,49268,49268,11,49296,49296,11,49324,49324,11,49352,49352,11,49380,49380,11,49408,49408,11,49436,49436,11,49464,49464,11,49492,49492,11,49520,49520,11,49548,49548,11,49576,49576,11,49604,49604,11,49632,49632,11,49660,49660,11,49688,49688,11,49716,49716,11,49744,49744,11,49772,49772,11,49800,49800,11,49828,49828,11,49856,49856,11,49884,49884,11,49912,49912,11,49940,49940,11,49968,49968,11,49996,49996,11,50024,50024,11,50052,50052,11,50080,50080,11,50108,50108,11,50136,50136,11,50164,50164,11,50192,50192,11,50220,50220,11,50248,50248,11,50276,50276,11,50304,50304,11,50332,50332,11,50360,50360,11,50388,50388,11,50416,50416,11,50444,50444,11,50472,50472,11,50500,50500,11,50528,50528,11,50556,50556,11,50584,50584,11,50612,50612,11,50640,50640,11,50668,50668,11,50696,50696,11,50724,50724,11,50752,50752,11,50780,50780,11,50808,50808,11,50836,50836,11,50864,50864,11,50892,50892,11,50920,50920,11,50948,50948,11,50976,50976,11,51004,51004,11,51032,51032,11,51060,51060,11,51088,51088,11,51116,51116,11,51144,51144,11,51172,51172,11,51200,51200,11,51228,51228,11,51256,51256,11,51284,51284,11,51312,51312,11,51340,51340,11,51368,51368,11,51396,51396,11,51424,51424,11,51452,51452,11,51480,51480,11,51508,51508,11,51536,51536,11,51564,51564,11,51592,51592,11,51620,51620,11,51648,51648,11,51676,51676,11,51704,51704,11,51732,51732,11,51760,51760,11,51788,51788,11,51816,51816,11,51844,51844,11,51872,51872,11,51900,51900,11,51928,51928,11,51956,51956,11,51984,51984,11,52012,52012,11,52040,52040,11,52068,52068,11,52096,52096,11,52124,52124,11,52152,52152,11,52180,52180,11,52208,52208,11,52236,52236,11,52264,52264,11,52292,52292,11,52320,52320,11,52348,52348,11,52376,52376,11,52404,52404,11,52432,52432,11,52460,52460,11,52488,52488,11,52516,52516,11,52544,52544,11,52572,52572,11,52600,52600,11,52628,52628,11,52656,52656,11,52684,52684,11,52712,52712,11,52740,52740,11,52768,52768,11,52796,52796,11,52824,52824,11,52852,52852,11,52880,52880,11,52908,52908,11,52936,52936,11,52964,52964,11,52992,52992,11,53020,53020,11,53048,53048,11,53076,53076,11,53104,53104,11,53132,53132,11,53160,53160,11,53188,53188,11,53216,53216,11,53244,53244,11,53272,53272,11,53300,53300,11,53328,53328,11,53356,53356,11,53384,53384,11,53412,53412,11,53440,53440,11,53468,53468,11,53496,53496,11,53524,53524,11,53552,53552,11,53580,53580,11,53608,53608,11,53636,53636,11,53664,53664,11,53692,53692,11,53720,53720,11,53748,53748,11,53776,53776,11,53804,53804,11,53832,53832,11,53860,53860,11,53888,53888,11,53916,53916,11,53944,53944,11,53972,53972,11,54000,54000,11,54028,54028,11,54056,54056,11,54084,54084,11,54112,54112,11,54140,54140,11,54168,54168,11,54196,54196,11,54224,54224,11,54252,54252,11,54280,54280,11,54308,54308,11,54336,54336,11,54364,54364,11,54392,54392,11,54420,54420,11,54448,54448,11,54476,54476,11,54504,54504,11,54532,54532,11,54560,54560,11,54588,54588,11,54616,54616,11,54644,54644,11,54672,54672,11,54700,54700,11,54728,54728,11,54756,54756,11,54784,54784,11,54812,54812,11,54840,54840,11,54868,54868,11,54896,54896,11,54924,54924,11,54952,54952,11,54980,54980,11,55008,55008,11,55036,55036,11,55064,55064,11,55092,55092,11,55120,55120,11,55148,55148,11,55176,55176,11,55216,55238,9,64286,64286,5,65056,65071,5,65438,65439,5,65529,65531,4,66272,66272,5,68097,68099,5,68108,68111,5,68159,68159,5,68900,68903,5,69446,69456,5,69632,69632,7,69634,69634,7,69744,69744,5,69759,69761,5,69808,69810,7,69815,69816,7,69821,69821,1,69837,69837,1,69927,69931,5,69933,69940,5,70003,70003,5,70018,70018,7,70070,70078,5,70082,70083,1,70094,70094,7,70188,70190,7,70194,70195,7,70197,70197,7,70206,70206,5,70368,70370,7,70400,70401,5,70459,70460,5,70463,70463,7,70465,70468,7,70475,70477,7,70498,70499,7,70512,70516,5,70712,70719,5,70722,70724,5,70726,70726,5,70832,70832,5,70835,70840,5,70842,70842,5,70845,70845,5,70847,70848,5,70850,70851,5,71088,71089,7,71096,71099,7,71102,71102,7,71132,71133,5,71219,71226,5,71229,71229,5,71231,71232,5,71340,71340,7,71342,71343,7,71350,71350,7,71453,71455,5,71462,71462,7,71724,71726,7,71736,71736,7,71984,71984,5,71991,71992,7,71997,71997,7,71999,71999,1,72001,72001,1,72003,72003,5,72148,72151,5,72156,72159,7,72164,72164,7,72243,72248,5,72250,72250,1,72263,72263,5,72279,72280,7,72324,72329,1,72343,72343,7,72751,72751,7,72760,72765,5,72767,72767,5,72873,72873,7,72881,72881,7,72884,72884,7,73009,73014,5,73020,73021,5,73030,73030,1,73098,73102,7,73107,73108,7,73110,73110,7,73459,73460,5,78896,78904,4,92976,92982,5,94033,94087,7,94180,94180,5,113821,113822,5,118528,118573,5,119141,119141,5,119143,119145,5,119150,119154,5,119163,119170,5,119210,119213,5,121344,121398,5,121461,121461,5,121499,121503,5,122880,122886,5,122907,122913,5,122918,122922,5,123566,123566,5,125136,125142,5,126976,126979,14,126981,127182,14,127184,127231,14,127279,127279,14,127344,127345,14,127374,127374,14,127405,127461,14,127489,127490,14,127514,127514,14,127538,127546,14,127561,127567,14,127570,127743,14,127757,127758,14,127760,127760,14,127762,127762,14,127766,127768,14,127770,127770,14,127772,127772,14,127775,127776,14,127778,127779,14,127789,127791,14,127794,127795,14,127798,127798,14,127819,127819,14,127824,127824,14,127868,127868,14,127870,127871,14,127892,127893,14,127896,127896,14,127900,127901,14,127904,127940,14,127942,127942,14,127944,127944,14,127946,127946,14,127951,127955,14,127968,127971,14,127973,127984,14,127987,127987,14,127989,127989,14,127991,127991,14,127995,127999,5,128008,128008,14,128012,128014,14,128017,128018,14,128020,128020,14,128022,128022,14,128042,128042,14,128063,128063,14,128065,128065,14,128101,128101,14,128108,128109,14,128173,128173,14,128182,128183,14,128236,128237,14,128239,128239,14,128245,128245,14,128248,128248,14,128253,128253,14,128255,128258,14,128260,128263,14,128265,128265,14,128277,128277,14,128300,128301,14,128326,128328,14,128331,128334,14,128336,128347,14,128360,128366,14,128369,128370,14,128378,128378,14,128391,128391,14,128394,128397,14,128400,128400,14,128405,128406,14,128420,128420,14,128422,128423,14,128425,128432,14,128435,128443,14,128445,128449,14,128453,128464,14,128468,128475,14,128479,128480,14,128482,128482,14,128484,128487,14,128489,128494,14,128496,128498,14,128500,128505,14,128507,128511,14,128513,128518,14,128521,128525,14,128527,128527,14,128529,128529,14,128533,128533,14,128535,128535,14,128537,128537,14]")}getGraphemeBreakType(e){if(e<32)return 10===e?3:13===e?2:4;if(e<127)return 0;const t=this._data,i=t.length/3;let n=1;for(;n<=i;)if(e<t[3*n])n*=2;else{if(!(e>t[3*n+1]))return t[3*n+2];n=2*n+1}return 0}}function ie(e,t){if(0===e)return 0;const i=function(e,t){const i=new F(t,e);let n=i.prevCodePoint();for(;ne(n)||65039===n||8419===n;){if(0===i.offset)return;n=i.prevCodePoint()}if(!Y(n))return;let o=i.offset;if(o>0){8205===i.prevCodePoint()&&(o=i.offset)}return o}(e,t);if(void 0!==i)return i;const n=new F(t,e);return n.prevCodePoint(),n.offset}function ne(e){return 127995<=e&&e<=127999}te._INSTANCE=null;const oe=" ";class re{static getInstance(e){return n.cache.get(Array.from(e))}static getLocales(){return n._locales.value}constructor(e){this.confusableDictionary=e}isAmbiguous(e){return this.confusableDictionary.has(e)}getPrimaryConfusable(e){return this.confusableDictionary.get(e)}getConfusableCodePoints(){return new Set(this.confusableDictionary.keys())}}n=re,re.ambiguousCharacterData=new r.Lazy((()=>JSON.parse('{"_common":[8232,32,8233,32,5760,32,8192,32,8193,32,8194,32,8195,32,8196,32,8197,32,8198,32,8200,32,8201,32,8202,32,8287,32,8199,32,8239,32,2042,95,65101,95,65102,95,65103,95,8208,45,8209,45,8210,45,65112,45,1748,45,8259,45,727,45,8722,45,10134,45,11450,45,1549,44,1643,44,8218,44,184,44,42233,44,894,59,2307,58,2691,58,1417,58,1795,58,1796,58,5868,58,65072,58,6147,58,6153,58,8282,58,1475,58,760,58,42889,58,8758,58,720,58,42237,58,451,33,11601,33,660,63,577,63,2429,63,5038,63,42731,63,119149,46,8228,46,1793,46,1794,46,42510,46,68176,46,1632,46,1776,46,42232,46,1373,96,65287,96,8219,96,8242,96,1370,96,1523,96,8175,96,65344,96,900,96,8189,96,8125,96,8127,96,8190,96,697,96,884,96,712,96,714,96,715,96,756,96,699,96,701,96,700,96,702,96,42892,96,1497,96,2036,96,2037,96,5194,96,5836,96,94033,96,94034,96,65339,91,10088,40,10098,40,12308,40,64830,40,65341,93,10089,41,10099,41,12309,41,64831,41,10100,123,119060,123,10101,125,65342,94,8270,42,1645,42,8727,42,66335,42,5941,47,8257,47,8725,47,8260,47,9585,47,10187,47,10744,47,119354,47,12755,47,12339,47,11462,47,20031,47,12035,47,65340,92,65128,92,8726,92,10189,92,10741,92,10745,92,119311,92,119355,92,12756,92,20022,92,12034,92,42872,38,708,94,710,94,5869,43,10133,43,66203,43,8249,60,10094,60,706,60,119350,60,5176,60,5810,60,5120,61,11840,61,12448,61,42239,61,8250,62,10095,62,707,62,119351,62,5171,62,94015,62,8275,126,732,126,8128,126,8764,126,65372,124,65293,45,120784,50,120794,50,120804,50,120814,50,120824,50,130034,50,42842,50,423,50,1000,50,42564,50,5311,50,42735,50,119302,51,120785,51,120795,51,120805,51,120815,51,120825,51,130035,51,42923,51,540,51,439,51,42858,51,11468,51,1248,51,94011,51,71882,51,120786,52,120796,52,120806,52,120816,52,120826,52,130036,52,5070,52,71855,52,120787,53,120797,53,120807,53,120817,53,120827,53,130037,53,444,53,71867,53,120788,54,120798,54,120808,54,120818,54,120828,54,130038,54,11474,54,5102,54,71893,54,119314,55,120789,55,120799,55,120809,55,120819,55,120829,55,130039,55,66770,55,71878,55,2819,56,2538,56,2666,56,125131,56,120790,56,120800,56,120810,56,120820,56,120830,56,130040,56,547,56,546,56,66330,56,2663,57,2920,57,2541,57,3437,57,120791,57,120801,57,120811,57,120821,57,120831,57,130041,57,42862,57,11466,57,71884,57,71852,57,71894,57,9082,97,65345,97,119834,97,119886,97,119938,97,119990,97,120042,97,120094,97,120146,97,120198,97,120250,97,120302,97,120354,97,120406,97,120458,97,593,97,945,97,120514,97,120572,97,120630,97,120688,97,120746,97,65313,65,119808,65,119860,65,119912,65,119964,65,120016,65,120068,65,120120,65,120172,65,120224,65,120276,65,120328,65,120380,65,120432,65,913,65,120488,65,120546,65,120604,65,120662,65,120720,65,5034,65,5573,65,42222,65,94016,65,66208,65,119835,98,119887,98,119939,98,119991,98,120043,98,120095,98,120147,98,120199,98,120251,98,120303,98,120355,98,120407,98,120459,98,388,98,5071,98,5234,98,5551,98,65314,66,8492,66,119809,66,119861,66,119913,66,120017,66,120069,66,120121,66,120173,66,120225,66,120277,66,120329,66,120381,66,120433,66,42932,66,914,66,120489,66,120547,66,120605,66,120663,66,120721,66,5108,66,5623,66,42192,66,66178,66,66209,66,66305,66,65347,99,8573,99,119836,99,119888,99,119940,99,119992,99,120044,99,120096,99,120148,99,120200,99,120252,99,120304,99,120356,99,120408,99,120460,99,7428,99,1010,99,11429,99,43951,99,66621,99,128844,67,71922,67,71913,67,65315,67,8557,67,8450,67,8493,67,119810,67,119862,67,119914,67,119966,67,120018,67,120174,67,120226,67,120278,67,120330,67,120382,67,120434,67,1017,67,11428,67,5087,67,42202,67,66210,67,66306,67,66581,67,66844,67,8574,100,8518,100,119837,100,119889,100,119941,100,119993,100,120045,100,120097,100,120149,100,120201,100,120253,100,120305,100,120357,100,120409,100,120461,100,1281,100,5095,100,5231,100,42194,100,8558,68,8517,68,119811,68,119863,68,119915,68,119967,68,120019,68,120071,68,120123,68,120175,68,120227,68,120279,68,120331,68,120383,68,120435,68,5024,68,5598,68,5610,68,42195,68,8494,101,65349,101,8495,101,8519,101,119838,101,119890,101,119942,101,120046,101,120098,101,120150,101,120202,101,120254,101,120306,101,120358,101,120410,101,120462,101,43826,101,1213,101,8959,69,65317,69,8496,69,119812,69,119864,69,119916,69,120020,69,120072,69,120124,69,120176,69,120228,69,120280,69,120332,69,120384,69,120436,69,917,69,120492,69,120550,69,120608,69,120666,69,120724,69,11577,69,5036,69,42224,69,71846,69,71854,69,66182,69,119839,102,119891,102,119943,102,119995,102,120047,102,120099,102,120151,102,120203,102,120255,102,120307,102,120359,102,120411,102,120463,102,43829,102,42905,102,383,102,7837,102,1412,102,119315,70,8497,70,119813,70,119865,70,119917,70,120021,70,120073,70,120125,70,120177,70,120229,70,120281,70,120333,70,120385,70,120437,70,42904,70,988,70,120778,70,5556,70,42205,70,71874,70,71842,70,66183,70,66213,70,66853,70,65351,103,8458,103,119840,103,119892,103,119944,103,120048,103,120100,103,120152,103,120204,103,120256,103,120308,103,120360,103,120412,103,120464,103,609,103,7555,103,397,103,1409,103,119814,71,119866,71,119918,71,119970,71,120022,71,120074,71,120126,71,120178,71,120230,71,120282,71,120334,71,120386,71,120438,71,1292,71,5056,71,5107,71,42198,71,65352,104,8462,104,119841,104,119945,104,119997,104,120049,104,120101,104,120153,104,120205,104,120257,104,120309,104,120361,104,120413,104,120465,104,1211,104,1392,104,5058,104,65320,72,8459,72,8460,72,8461,72,119815,72,119867,72,119919,72,120023,72,120179,72,120231,72,120283,72,120335,72,120387,72,120439,72,919,72,120494,72,120552,72,120610,72,120668,72,120726,72,11406,72,5051,72,5500,72,42215,72,66255,72,731,105,9075,105,65353,105,8560,105,8505,105,8520,105,119842,105,119894,105,119946,105,119998,105,120050,105,120102,105,120154,105,120206,105,120258,105,120310,105,120362,105,120414,105,120466,105,120484,105,618,105,617,105,953,105,8126,105,890,105,120522,105,120580,105,120638,105,120696,105,120754,105,1110,105,42567,105,1231,105,43893,105,5029,105,71875,105,65354,106,8521,106,119843,106,119895,106,119947,106,119999,106,120051,106,120103,106,120155,106,120207,106,120259,106,120311,106,120363,106,120415,106,120467,106,1011,106,1112,106,65322,74,119817,74,119869,74,119921,74,119973,74,120025,74,120077,74,120129,74,120181,74,120233,74,120285,74,120337,74,120389,74,120441,74,42930,74,895,74,1032,74,5035,74,5261,74,42201,74,119844,107,119896,107,119948,107,120000,107,120052,107,120104,107,120156,107,120208,107,120260,107,120312,107,120364,107,120416,107,120468,107,8490,75,65323,75,119818,75,119870,75,119922,75,119974,75,120026,75,120078,75,120130,75,120182,75,120234,75,120286,75,120338,75,120390,75,120442,75,922,75,120497,75,120555,75,120613,75,120671,75,120729,75,11412,75,5094,75,5845,75,42199,75,66840,75,1472,108,8739,73,9213,73,65512,73,1633,108,1777,73,66336,108,125127,108,120783,73,120793,73,120803,73,120813,73,120823,73,130033,73,65321,73,8544,73,8464,73,8465,73,119816,73,119868,73,119920,73,120024,73,120128,73,120180,73,120232,73,120284,73,120336,73,120388,73,120440,73,65356,108,8572,73,8467,108,119845,108,119897,108,119949,108,120001,108,120053,108,120105,73,120157,73,120209,73,120261,73,120313,73,120365,73,120417,73,120469,73,448,73,120496,73,120554,73,120612,73,120670,73,120728,73,11410,73,1030,73,1216,73,1493,108,1503,108,1575,108,126464,108,126592,108,65166,108,65165,108,1994,108,11599,73,5825,73,42226,73,93992,73,66186,124,66313,124,119338,76,8556,76,8466,76,119819,76,119871,76,119923,76,120027,76,120079,76,120131,76,120183,76,120235,76,120287,76,120339,76,120391,76,120443,76,11472,76,5086,76,5290,76,42209,76,93974,76,71843,76,71858,76,66587,76,66854,76,65325,77,8559,77,8499,77,119820,77,119872,77,119924,77,120028,77,120080,77,120132,77,120184,77,120236,77,120288,77,120340,77,120392,77,120444,77,924,77,120499,77,120557,77,120615,77,120673,77,120731,77,1018,77,11416,77,5047,77,5616,77,5846,77,42207,77,66224,77,66321,77,119847,110,119899,110,119951,110,120003,110,120055,110,120107,110,120159,110,120211,110,120263,110,120315,110,120367,110,120419,110,120471,110,1400,110,1404,110,65326,78,8469,78,119821,78,119873,78,119925,78,119977,78,120029,78,120081,78,120185,78,120237,78,120289,78,120341,78,120393,78,120445,78,925,78,120500,78,120558,78,120616,78,120674,78,120732,78,11418,78,42208,78,66835,78,3074,111,3202,111,3330,111,3458,111,2406,111,2662,111,2790,111,3046,111,3174,111,3302,111,3430,111,3664,111,3792,111,4160,111,1637,111,1781,111,65359,111,8500,111,119848,111,119900,111,119952,111,120056,111,120108,111,120160,111,120212,111,120264,111,120316,111,120368,111,120420,111,120472,111,7439,111,7441,111,43837,111,959,111,120528,111,120586,111,120644,111,120702,111,120760,111,963,111,120532,111,120590,111,120648,111,120706,111,120764,111,11423,111,4351,111,1413,111,1505,111,1607,111,126500,111,126564,111,126596,111,65259,111,65260,111,65258,111,65257,111,1726,111,64428,111,64429,111,64427,111,64426,111,1729,111,64424,111,64425,111,64423,111,64422,111,1749,111,3360,111,4125,111,66794,111,71880,111,71895,111,66604,111,1984,79,2534,79,2918,79,12295,79,70864,79,71904,79,120782,79,120792,79,120802,79,120812,79,120822,79,130032,79,65327,79,119822,79,119874,79,119926,79,119978,79,120030,79,120082,79,120134,79,120186,79,120238,79,120290,79,120342,79,120394,79,120446,79,927,79,120502,79,120560,79,120618,79,120676,79,120734,79,11422,79,1365,79,11604,79,4816,79,2848,79,66754,79,42227,79,71861,79,66194,79,66219,79,66564,79,66838,79,9076,112,65360,112,119849,112,119901,112,119953,112,120005,112,120057,112,120109,112,120161,112,120213,112,120265,112,120317,112,120369,112,120421,112,120473,112,961,112,120530,112,120544,112,120588,112,120602,112,120646,112,120660,112,120704,112,120718,112,120762,112,120776,112,11427,112,65328,80,8473,80,119823,80,119875,80,119927,80,119979,80,120031,80,120083,80,120187,80,120239,80,120291,80,120343,80,120395,80,120447,80,929,80,120504,80,120562,80,120620,80,120678,80,120736,80,11426,80,5090,80,5229,80,42193,80,66197,80,119850,113,119902,113,119954,113,120006,113,120058,113,120110,113,120162,113,120214,113,120266,113,120318,113,120370,113,120422,113,120474,113,1307,113,1379,113,1382,113,8474,81,119824,81,119876,81,119928,81,119980,81,120032,81,120084,81,120188,81,120240,81,120292,81,120344,81,120396,81,120448,81,11605,81,119851,114,119903,114,119955,114,120007,114,120059,114,120111,114,120163,114,120215,114,120267,114,120319,114,120371,114,120423,114,120475,114,43847,114,43848,114,7462,114,11397,114,43905,114,119318,82,8475,82,8476,82,8477,82,119825,82,119877,82,119929,82,120033,82,120189,82,120241,82,120293,82,120345,82,120397,82,120449,82,422,82,5025,82,5074,82,66740,82,5511,82,42211,82,94005,82,65363,115,119852,115,119904,115,119956,115,120008,115,120060,115,120112,115,120164,115,120216,115,120268,115,120320,115,120372,115,120424,115,120476,115,42801,115,445,115,1109,115,43946,115,71873,115,66632,115,65331,83,119826,83,119878,83,119930,83,119982,83,120034,83,120086,83,120138,83,120190,83,120242,83,120294,83,120346,83,120398,83,120450,83,1029,83,1359,83,5077,83,5082,83,42210,83,94010,83,66198,83,66592,83,119853,116,119905,116,119957,116,120009,116,120061,116,120113,116,120165,116,120217,116,120269,116,120321,116,120373,116,120425,116,120477,116,8868,84,10201,84,128872,84,65332,84,119827,84,119879,84,119931,84,119983,84,120035,84,120087,84,120139,84,120191,84,120243,84,120295,84,120347,84,120399,84,120451,84,932,84,120507,84,120565,84,120623,84,120681,84,120739,84,11430,84,5026,84,42196,84,93962,84,71868,84,66199,84,66225,84,66325,84,119854,117,119906,117,119958,117,120010,117,120062,117,120114,117,120166,117,120218,117,120270,117,120322,117,120374,117,120426,117,120478,117,42911,117,7452,117,43854,117,43858,117,651,117,965,117,120534,117,120592,117,120650,117,120708,117,120766,117,1405,117,66806,117,71896,117,8746,85,8899,85,119828,85,119880,85,119932,85,119984,85,120036,85,120088,85,120140,85,120192,85,120244,85,120296,85,120348,85,120400,85,120452,85,1357,85,4608,85,66766,85,5196,85,42228,85,94018,85,71864,85,8744,118,8897,118,65366,118,8564,118,119855,118,119907,118,119959,118,120011,118,120063,118,120115,118,120167,118,120219,118,120271,118,120323,118,120375,118,120427,118,120479,118,7456,118,957,118,120526,118,120584,118,120642,118,120700,118,120758,118,1141,118,1496,118,71430,118,43945,118,71872,118,119309,86,1639,86,1783,86,8548,86,119829,86,119881,86,119933,86,119985,86,120037,86,120089,86,120141,86,120193,86,120245,86,120297,86,120349,86,120401,86,120453,86,1140,86,11576,86,5081,86,5167,86,42719,86,42214,86,93960,86,71840,86,66845,86,623,119,119856,119,119908,119,119960,119,120012,119,120064,119,120116,119,120168,119,120220,119,120272,119,120324,119,120376,119,120428,119,120480,119,7457,119,1121,119,1309,119,1377,119,71434,119,71438,119,71439,119,43907,119,71919,87,71910,87,119830,87,119882,87,119934,87,119986,87,120038,87,120090,87,120142,87,120194,87,120246,87,120298,87,120350,87,120402,87,120454,87,1308,87,5043,87,5076,87,42218,87,5742,120,10539,120,10540,120,10799,120,65368,120,8569,120,119857,120,119909,120,119961,120,120013,120,120065,120,120117,120,120169,120,120221,120,120273,120,120325,120,120377,120,120429,120,120481,120,5441,120,5501,120,5741,88,9587,88,66338,88,71916,88,65336,88,8553,88,119831,88,119883,88,119935,88,119987,88,120039,88,120091,88,120143,88,120195,88,120247,88,120299,88,120351,88,120403,88,120455,88,42931,88,935,88,120510,88,120568,88,120626,88,120684,88,120742,88,11436,88,11613,88,5815,88,42219,88,66192,88,66228,88,66327,88,66855,88,611,121,7564,121,65369,121,119858,121,119910,121,119962,121,120014,121,120066,121,120118,121,120170,121,120222,121,120274,121,120326,121,120378,121,120430,121,120482,121,655,121,7935,121,43866,121,947,121,8509,121,120516,121,120574,121,120632,121,120690,121,120748,121,1199,121,4327,121,71900,121,65337,89,119832,89,119884,89,119936,89,119988,89,120040,89,120092,89,120144,89,120196,89,120248,89,120300,89,120352,89,120404,89,120456,89,933,89,978,89,120508,89,120566,89,120624,89,120682,89,120740,89,11432,89,1198,89,5033,89,5053,89,42220,89,94019,89,71844,89,66226,89,119859,122,119911,122,119963,122,120015,122,120067,122,120119,122,120171,122,120223,122,120275,122,120327,122,120379,122,120431,122,120483,122,7458,122,43923,122,71876,122,66293,90,71909,90,65338,90,8484,90,8488,90,119833,90,119885,90,119937,90,119989,90,120041,90,120197,90,120249,90,120301,90,120353,90,120405,90,120457,90,918,90,120493,90,120551,90,120609,90,120667,90,120725,90,5059,90,42204,90,71849,90,65282,34,65284,36,65285,37,65286,38,65290,42,65291,43,65294,46,65295,47,65296,48,65297,49,65298,50,65299,51,65300,52,65301,53,65302,54,65303,55,65304,56,65305,57,65308,60,65309,61,65310,62,65312,64,65316,68,65318,70,65319,71,65324,76,65329,81,65330,82,65333,85,65334,86,65335,87,65343,95,65346,98,65348,100,65350,102,65355,107,65357,109,65358,110,65361,113,65362,114,65364,116,65365,117,65367,119,65370,122,65371,123,65373,125,119846,109],"_default":[160,32,8211,45,65374,126,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"cs":[65374,126,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"de":[65374,126,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"es":[8211,45,65374,126,65306,58,65281,33,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"fr":[65374,126,65306,58,65281,33,8216,96,8245,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"it":[160,32,8211,45,65374,126,65306,58,65281,33,8216,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"ja":[8211,45,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65292,44,65307,59],"ko":[8211,45,65374,126,65306,58,65281,33,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"pl":[65374,126,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"pt-BR":[65374,126,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"qps-ploc":[160,32,8211,45,65374,126,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"ru":[65374,126,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,12494,47,305,105,921,73,1009,112,215,120,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"tr":[160,32,8211,45,65374,126,65306,58,65281,33,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65288,40,65289,41,65292,44,65307,59,65311,63],"zh-hans":[65374,126,65306,58,65281,33,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41],"zh-hant":[8211,45,65374,126,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65283,35,65307,59]}'))),re.cache=new o.LRUCachedFunction((e=>{function t(e){const t=new Map;for(let i=0;i<e.length;i+=2)t.set(e[i],e[i+1]);return t}function i(e,t){if(!e)return t;const i=new Map;for(const[n,o]of e)t.has(n)&&i.set(n,o);return i}const o=n.ambiguousCharacterData.value;let r,s=e.filter((e=>!e.startsWith("_")&&e in o));0===s.length&&(s=["_default"]);for(const e of s){r=i(r,t(o[e]))}const a=function(e,t){const i=new Map(e);for(const[e,n]of t)i.set(e,n);return i}(t(o._common),r);return new n(a)})),re._locales=new r.Lazy((()=>Object.keys(n.ambiguousCharacterData.value).filter((e=>!e.startsWith("_")))));class se{static getRawData(){return JSON.parse("[9,10,11,12,13,32,127,160,173,847,1564,4447,4448,6068,6069,6155,6156,6157,6158,7355,7356,8192,8193,8194,8195,8196,8197,8198,8199,8200,8201,8202,8203,8204,8205,8206,8207,8234,8235,8236,8237,8238,8239,8287,8288,8289,8290,8291,8292,8293,8294,8295,8296,8297,8298,8299,8300,8301,8302,8303,10240,12288,12644,65024,65025,65026,65027,65028,65029,65030,65031,65032,65033,65034,65035,65036,65037,65038,65039,65279,65440,65520,65521,65522,65523,65524,65525,65526,65527,65528,65532,78844,119155,119156,119157,119158,119159,119160,119161,119162,917504,917505,917506,917507,917508,917509,917510,917511,917512,917513,917514,917515,917516,917517,917518,917519,917520,917521,917522,917523,917524,917525,917526,917527,917528,917529,917530,917531,917532,917533,917534,917535,917536,917537,917538,917539,917540,917541,917542,917543,917544,917545,917546,917547,917548,917549,917550,917551,917552,917553,917554,917555,917556,917557,917558,917559,917560,917561,917562,917563,917564,917565,917566,917567,917568,917569,917570,917571,917572,917573,917574,917575,917576,917577,917578,917579,917580,917581,917582,917583,917584,917585,917586,917587,917588,917589,917590,917591,917592,917593,917594,917595,917596,917597,917598,917599,917600,917601,917602,917603,917604,917605,917606,917607,917608,917609,917610,917611,917612,917613,917614,917615,917616,917617,917618,917619,917620,917621,917622,917623,917624,917625,917626,917627,917628,917629,917630,917631,917760,917761,917762,917763,917764,917765,917766,917767,917768,917769,917770,917771,917772,917773,917774,917775,917776,917777,917778,917779,917780,917781,917782,917783,917784,917785,917786,917787,917788,917789,917790,917791,917792,917793,917794,917795,917796,917797,917798,917799,917800,917801,917802,917803,917804,917805,917806,917807,917808,917809,917810,917811,917812,917813,917814,917815,917816,917817,917818,917819,917820,917821,917822,917823,917824,917825,917826,917827,917828,917829,917830,917831,917832,917833,917834,917835,917836,917837,917838,917839,917840,917841,917842,917843,917844,917845,917846,917847,917848,917849,917850,917851,917852,917853,917854,917855,917856,917857,917858,917859,917860,917861,917862,917863,917864,917865,917866,917867,917868,917869,917870,917871,917872,917873,917874,917875,917876,917877,917878,917879,917880,917881,917882,917883,917884,917885,917886,917887,917888,917889,917890,917891,917892,917893,917894,917895,917896,917897,917898,917899,917900,917901,917902,917903,917904,917905,917906,917907,917908,917909,917910,917911,917912,917913,917914,917915,917916,917917,917918,917919,917920,917921,917922,917923,917924,917925,917926,917927,917928,917929,917930,917931,917932,917933,917934,917935,917936,917937,917938,917939,917940,917941,917942,917943,917944,917945,917946,917947,917948,917949,917950,917951,917952,917953,917954,917955,917956,917957,917958,917959,917960,917961,917962,917963,917964,917965,917966,917967,917968,917969,917970,917971,917972,917973,917974,917975,917976,917977,917978,917979,917980,917981,917982,917983,917984,917985,917986,917987,917988,917989,917990,917991,917992,917993,917994,917995,917996,917997,917998,917999]")}static getData(){return this._data||(this._data=new Set(se.getRawData())),this._data}static isInvisibleCharacter(e){return se.getData().has(e)}static get codePoints(){return se.getData()}}se._data=void 0},68945:function(e,t,i){"use strict";i.r(t),i.d(t,{MicrotaskDelay:function(){return n}});const n=Symbol("MicrotaskDelay")},96628:function(e,t,i){"use strict";i.r(t),i.d(t,{ConfigKeysIterator:function(){return r},PathIterator:function(){return s},StringIterator:function(){return o},TernarySearchTree:function(){return c},UriIterator:function(){return a}});var n=i(91482);class o{constructor(){this._value="",this._pos=0}reset(e){return this._value=e,this._pos=0,this}next(){return this._pos+=1,this}hasNext(){return this._pos<this._value.length-1}cmp(e){return e.charCodeAt(0)-this._value.charCodeAt(this._pos)}value(){return this._value[this._pos]}}class r{constructor(e=!0){this._caseSensitive=e}reset(e){return this._value=e,this._from=0,this._to=0,this.next()}hasNext(){return this._to<this._value.length}next(){this._from=this._to;let e=!0;for(;this._to<this._value.length;this._to++){if(46===this._value.charCodeAt(this._to)){if(!e)break;this._from++}else e=!1}return this}cmp(e){return this._caseSensitive?(0,n.compareSubstring)(e,this._value,0,e.length,this._from,this._to):(0,n.compareSubstringIgnoreCase)(e,this._value,0,e.length,this._from,this._to)}value(){return this._value.substring(this._from,this._to)}}class s{constructor(e=!0,t=!0){this._splitOnBackslash=e,this._caseSensitive=t}reset(e){this._from=0,this._to=0,this._value=e,this._valueLen=e.length;for(let t=e.length-1;t>=0;t--,this._valueLen--){const e=this._value.charCodeAt(t);if(!(47===e||this._splitOnBackslash&&92===e))break}return this.next()}hasNext(){return this._to<this._valueLen}next(){this._from=this._to;let e=!0;for(;this._to<this._valueLen;this._to++){const t=this._value.charCodeAt(this._to);if(47===t||this._splitOnBackslash&&92===t){if(!e)break;this._from++}else e=!1}return this}cmp(e){return this._caseSensitive?(0,n.compareSubstring)(e,this._value,0,e.length,this._from,this._to):(0,n.compareSubstringIgnoreCase)(e,this._value,0,e.length,this._from,this._to)}value(){return this._value.substring(this._from,this._to)}}class a{constructor(e,t){this._ignorePathCasing=e,this._ignoreQueryAndFragment=t,this._states=[],this._stateIdx=0}reset(e){return this._value=e,this._states=[],this._value.scheme&&this._states.push(1),this._value.authority&&this._states.push(2),this._value.path&&(this._pathIterator=new s(!1,!this._ignorePathCasing(e)),this._pathIterator.reset(e.path),this._pathIterator.value()&&this._states.push(3)),this._ignoreQueryAndFragment(e)||(this._value.query&&this._states.push(4),this._value.fragment&&this._states.push(5)),this._stateIdx=0,this}next(){return 3===this._states[this._stateIdx]&&this._pathIterator.hasNext()?this._pathIterator.next():this._stateIdx+=1,this}hasNext(){return 3===this._states[this._stateIdx]&&this._pathIterator.hasNext()||this._stateIdx<this._states.length-1}cmp(e){if(1===this._states[this._stateIdx])return(0,n.compareIgnoreCase)(e,this._value.scheme);if(2===this._states[this._stateIdx])return(0,n.compareIgnoreCase)(e,this._value.authority);if(3===this._states[this._stateIdx])return this._pathIterator.cmp(e);if(4===this._states[this._stateIdx])return(0,n.compare)(e,this._value.query);if(5===this._states[this._stateIdx])return(0,n.compare)(e,this._value.fragment);throw new Error}value(){if(1===this._states[this._stateIdx])return this._value.scheme;if(2===this._states[this._stateIdx])return this._value.authority;if(3===this._states[this._stateIdx])return this._pathIterator.value();if(4===this._states[this._stateIdx])return this._value.query;if(5===this._states[this._stateIdx])return this._value.fragment;throw new Error}}class l{constructor(){this.height=1}rotateLeft(){const e=this.right;return this.right=e.left,e.left=this,this.updateHeight(),e.updateHeight(),e}rotateRight(){const e=this.left;return this.left=e.right,e.right=this,this.updateHeight(),e.updateHeight(),e}updateHeight(){this.height=1+Math.max(this.heightLeft,this.heightRight)}balanceFactor(){return this.heightRight-this.heightLeft}get heightLeft(){var e,t;return null!==(t=null===(e=this.left)||void 0===e?void 0:e.height)&&void 0!==t?t:0}get heightRight(){var e,t;return null!==(t=null===(e=this.right)||void 0===e?void 0:e.height)&&void 0!==t?t:0}}class c{static forUris(e=(()=>!1),t=(()=>!1)){return new c(new a(e,t))}static forStrings(){return new c(new o)}static forConfigKeys(){return new c(new r)}constructor(e){this._iter=e}clear(){this._root=void 0}set(e,t){const i=this._iter.reset(e);let n;this._root||(this._root=new l,this._root.segment=i.value());const o=[];for(n=this._root;;){const e=i.cmp(n.segment);if(e>0)n.left||(n.left=new l,n.left.segment=i.value()),o.push([-1,n]),n=n.left;else if(e<0)n.right||(n.right=new l,n.right.segment=i.value()),o.push([1,n]),n=n.right;else{if(!i.hasNext())break;i.next(),n.mid||(n.mid=new l,n.mid.segment=i.value()),o.push([0,n]),n=n.mid}}const r=n.value;n.value=t,n.key=e;for(let e=o.length-1;e>=0;e--){const t=o[e][1];t.updateHeight();const i=t.balanceFactor();if(i<-1||i>1){const i=o[e][0],n=o[e+1][0];if(1===i&&1===n)o[e][1]=t.rotateLeft();else if(-1===i&&-1===n)o[e][1]=t.rotateRight();else if(1===i&&-1===n)t.right=o[e+1][1]=o[e+1][1].rotateRight(),o[e][1]=t.rotateLeft();else{if(-1!==i||1!==n)throw new Error;t.left=o[e+1][1]=o[e+1][1].rotateLeft(),o[e][1]=t.rotateRight()}if(e>0)switch(o[e-1][0]){case-1:o[e-1][1].left=o[e][1];break;case 1:o[e-1][1].right=o[e][1];break;case 0:o[e-1][1].mid=o[e][1]}else this._root=o[0][1]}}return r}get(e){var t;return null===(t=this._getNode(e))||void 0===t?void 0:t.value}_getNode(e){const t=this._iter.reset(e);let i=this._root;for(;i;){const e=t.cmp(i.segment);if(e>0)i=i.left;else if(e<0)i=i.right;else{if(!t.hasNext())break;t.next(),i=i.mid}}return i}has(e){const t=this._getNode(e);return!(void 0===(null==t?void 0:t.value)&&void 0===(null==t?void 0:t.mid))}delete(e){return this._delete(e,!1)}deleteSuperstr(e){return this._delete(e,!0)}_delete(e,t){var i;const n=this._iter.reset(e),o=[];let r=this._root;for(;r;){const e=n.cmp(r.segment);if(e>0)o.push([-1,r]),r=r.left;else if(e<0)o.push([1,r]),r=r.right;else{if(!n.hasNext())break;n.next(),o.push([0,r]),r=r.mid}}if(r){if(t?(r.left=void 0,r.mid=void 0,r.right=void 0,r.height=1):(r.key=void 0,r.value=void 0),!r.mid&&!r.value)if(r.left&&r.right){const e=this._min(r.right);if(e.key){const{key:t,value:i,segment:n}=e;this._delete(e.key,!1),r.key=t,r.value=i,r.segment=n}}else{const e=null!==(i=r.left)&&void 0!==i?i:r.right;if(o.length>0){const[t,i]=o[o.length-1];switch(t){case-1:i.left=e;break;case 0:i.mid=e;break;case 1:i.right=e}}else this._root=e}for(let e=o.length-1;e>=0;e--){const t=o[e][1];t.updateHeight();const i=t.balanceFactor();if(i>1?(t.right.balanceFactor()>=0||(t.right=t.right.rotateRight()),o[e][1]=t.rotateLeft()):i<-1&&(t.left.balanceFactor()<=0||(t.left=t.left.rotateLeft()),o[e][1]=t.rotateRight()),e>0)switch(o[e-1][0]){case-1:o[e-1][1].left=o[e][1];break;case 1:o[e-1][1].right=o[e][1];break;case 0:o[e-1][1].mid=o[e][1]}else this._root=o[0][1]}}}_min(e){for(;e.left;)e=e.left;return e}findSubstr(e){const t=this._iter.reset(e);let i,n=this._root;for(;n;){const e=t.cmp(n.segment);if(e>0)n=n.left;else if(e<0)n=n.right;else{if(!t.hasNext())break;t.next(),i=n.value||i,n=n.mid}}return n&&n.value||i}findSuperstr(e){return this._findSuperstrOrElement(e,!1)}_findSuperstrOrElement(e,t){const i=this._iter.reset(e);let n=this._root;for(;n;){const e=i.cmp(n.segment);if(e>0)n=n.left;else if(e<0)n=n.right;else{if(!i.hasNext())return n.mid?this._entries(n.mid):t?n.value:void 0;i.next(),n=n.mid}}}forEach(e){for(const[t,i]of this)e(i,t)}*[Symbol.iterator](){yield*this._entries(this._root)}_entries(e){const t=[];return this._dfsEntries(e,t),t[Symbol.iterator]()}_dfsEntries(e,t){e&&(e.left&&this._dfsEntries(e.left,t),e.value&&t.push([e.key,e.value]),e.mid&&this._dfsEntries(e.mid,t),e.right&&this._dfsEntries(e.right,t))}}},27269:function(e,t,i){"use strict";i.r(t),i.d(t,{ThemeColor:function(){return n},ThemeIcon:function(){return o}});var n,o,r=i(56087);!function(e){e.isThemeColor=function(e){return e&&"object"==typeof e&&"string"==typeof e.id}}(n||(n={})),function(e){e.iconNameSegment="[A-Za-z0-9]+",e.iconNameExpression="[A-Za-z0-9-]+",e.iconModifierExpression="~[A-Za-z]+",e.iconNameCharacter="[A-Za-z0-9~-]";const t=new RegExp(`^(${e.iconNameExpression})(${e.iconModifierExpression})?$`);function i(e){const n=t.exec(e.id);if(!n)return i(r.Codicon.error);const[,o,s]=n,a=["codicon","codicon-"+o];return s&&a.push("codicon-modifier-"+s.substring(1)),a}e.asClassNameArray=i,e.asClassName=function(e){return i(e).join(" ")},e.asCSSSelector=function(e){return"."+i(e).join(".")},e.isThemeIcon=function(e){return e&&"object"==typeof e&&"string"==typeof e.id&&(void 0===e.color||n.isThemeColor(e.color))};const o=new RegExp(`^\\$\\((${e.iconNameExpression}(?:${e.iconModifierExpression})?)\\)$`);e.fromString=function(e){const t=o.exec(e);if(!t)return;const[,i]=t;return{id:i}},e.fromId=function(e){return{id:e}},e.modify=function(e,t){let i=e.id;const n=i.lastIndexOf("~");return-1!==n&&(i=i.substring(0,n)),t&&(i=`${i}~${t}`),{id:i}},e.getModifier=function(e){const t=e.id.lastIndexOf("~");if(-1!==t)return e.id.substring(t+1)},e.isEqual=function(e,t){var i,n;return e.id===t.id&&(null===(i=e.color)||void 0===i?void 0:i.id)===(null===(n=t.color)||void 0===n?void 0:n.id)}}(o||(o={}))},18912:function(e,t,i){"use strict";function n(e){return"string"==typeof e}function o(e){return!("object"!=typeof e||null===e||Array.isArray(e)||e instanceof RegExp||e instanceof Date)}function r(e){const t=Object.getPrototypeOf(Uint8Array);return"object"==typeof e&&e instanceof t}function s(e){return"number"==typeof e&&!isNaN(e)}function a(e){return!!e&&"function"==typeof e[Symbol.iterator]}function l(e){return!0===e||!1===e}function c(e){return void 0===e}function d(e){return!u(e)}function u(e){return c(e)||null===e}function h(e,t){if(!e)throw new Error(t?`Unexpected type, expected '${t}'`:"Unexpected type")}function g(e){if(u(e))throw new Error("Assertion Failed: argument is undefined or null");return e}function p(e){return"function"==typeof e}function m(e,t){const i=Math.min(e.length,t.length);for(let n=0;n<i;n++)f(e[n],t[n])}function f(e,t){if(n(t)){if(typeof e!==t)throw new Error(`argument does not match constraint: typeof ${t}`)}else if(p(t)){try{if(e instanceof t)return}catch(e){}if(!u(e)&&e.constructor===t)return;if(1===t.length&&!0===t.call(void 0,e))return;throw new Error("argument does not match one of these constraints: arg instanceof constraint, arg.constructor === constraint, nor constraint(arg) === true")}}i.r(t),i.d(t,{assertIsDefined:function(){return g},assertType:function(){return h},isBoolean:function(){return l},isDefined:function(){return d},isFunction:function(){return p},isIterable:function(){return a},isNumber:function(){return s},isObject:function(){return o},isString:function(){return n},isTypedArray:function(){return r},isUndefined:function(){return c},isUndefinedOrNull:function(){return u},validateConstraint:function(){return f},validateConstraints:function(){return m}})},90662:function(e,t,i){"use strict";function n(e){return e<0?0:e>255?255:0|e}function o(e){return e<0?0:e>4294967295?4294967295:0|e}i.r(t),i.d(t,{toUint32:function(){return o},toUint8:function(){return n}})},19300:function(e,t,i){"use strict";i.r(t),i.d(t,{URI:function(){return u},uriToFsPath:function(){return b}});var n=i(23674),o=i(66719);const r=/^\w[\w\d+.-]*$/,s=/^\//,a=/^\/\//;const l="",c="/",d=/^(([^:/?#]+?):)?(\/\/([^/?#]*))?([^?#]*)(\?([^#]*))?(#(.*))?/;class u{static isUri(e){return e instanceof u||!!e&&("string"==typeof e.authority&&"string"==typeof e.fragment&&"string"==typeof e.path&&"string"==typeof e.query&&"string"==typeof e.scheme&&"string"==typeof e.fsPath&&"function"==typeof e.with&&"function"==typeof e.toString)}constructor(e,t,i,n,o,d=!1){"object"==typeof e?(this.scheme=e.scheme||l,this.authority=e.authority||l,this.path=e.path||l,this.query=e.query||l,this.fragment=e.fragment||l):(this.scheme=function(e,t){return e||t?e:"file"}(e,d),this.authority=t||l,this.path=function(e,t){switch(e){case"https":case"http":case"file":t?t[0]!==c&&(t=c+t):t=c}return t}(this.scheme,i||l),this.query=n||l,this.fragment=o||l,function(e,t){if(!e.scheme&&t)throw new Error(`[UriError]: Scheme is missing: {scheme: "", authority: "${e.authority}", path: "${e.path}", query: "${e.query}", fragment: "${e.fragment}"}`);if(e.scheme&&!r.test(e.scheme))throw new Error("[UriError]: Scheme contains illegal characters.");if(e.path)if(e.authority){if(!s.test(e.path))throw new Error('[UriError]: If a URI contains an authority component, then the path component must either be empty or begin with a slash ("/") character')}else if(a.test(e.path))throw new Error('[UriError]: If a URI does not contain an authority component, then the path cannot begin with two slash characters ("//")')}(this,d))}get fsPath(){return b(this,!1)}with(e){if(!e)return this;let{scheme:t,authority:i,path:n,query:o,fragment:r}=e;return void 0===t?t=this.scheme:null===t&&(t=l),void 0===i?i=this.authority:null===i&&(i=l),void 0===n?n=this.path:null===n&&(n=l),void 0===o?o=this.query:null===o&&(o=l),void 0===r?r=this.fragment:null===r&&(r=l),t===this.scheme&&i===this.authority&&n===this.path&&o===this.query&&r===this.fragment?this:new g(t,i,n,o,r)}static parse(e,t=!1){const i=d.exec(e);return i?new g(i[2]||l,C(i[4]||l),C(i[5]||l),C(i[7]||l),C(i[9]||l),t):new g(l,l,l,l,l)}static file(e){let t=l;if(o.isWindows&&(e=e.replace(/\\/g,c)),e[0]===c&&e[1]===c){const i=e.indexOf(c,2);-1===i?(t=e.substring(2),e=c):(t=e.substring(2,i),e=e.substring(i)||c)}return new g("file",t,e,l,l)}static from(e,t){return new g(e.scheme,e.authority,e.path,e.query,e.fragment,t)}static joinPath(e,...t){if(!e.path)throw new Error("[UriError]: cannot call joinPath on URI without path");let i;return i=o.isWindows&&"file"===e.scheme?u.file(n.win32.join(b(e,!0),...t)).path:n.posix.join(e.path,...t),e.with({path:i})}toString(e=!1){return v(this,e)}toJSON(){return this}static revive(e){var t,i;if(e){if(e instanceof u)return e;{const n=new g(e);return n._formatted=null!==(t=e.external)&&void 0!==t?t:null,n._fsPath=e._sep===h&&null!==(i=e.fsPath)&&void 0!==i?i:null,n}}return e}}const h=o.isWindows?1:void 0;class g extends u{constructor(){super(...arguments),this._formatted=null,this._fsPath=null}get fsPath(){return this._fsPath||(this._fsPath=b(this,!1)),this._fsPath}toString(e=!1){return e?v(this,!0):(this._formatted||(this._formatted=v(this,!1)),this._formatted)}toJSON(){const e={$mid:1};return this._fsPath&&(e.fsPath=this._fsPath,e._sep=h),this._formatted&&(e.external=this._formatted),this.path&&(e.path=this.path),this.scheme&&(e.scheme=this.scheme),this.authority&&(e.authority=this.authority),this.query&&(e.query=this.query),this.fragment&&(e.fragment=this.fragment),e}}const p={58:"%3A",47:"%2F",63:"%3F",35:"%23",91:"%5B",93:"%5D",64:"%40",33:"%21",36:"%24",38:"%26",39:"%27",40:"%28",41:"%29",42:"%2A",43:"%2B",44:"%2C",59:"%3B",61:"%3D",32:"%20"};function m(e,t,i){let n,o=-1;for(let r=0;r<e.length;r++){const s=e.charCodeAt(r);if(s>=97&&s<=122||s>=65&&s<=90||s>=48&&s<=57||45===s||46===s||95===s||126===s||t&&47===s||i&&91===s||i&&93===s||i&&58===s)-1!==o&&(n+=encodeURIComponent(e.substring(o,r)),o=-1),void 0!==n&&(n+=e.charAt(r));else{void 0===n&&(n=e.substr(0,r));const t=p[s];void 0!==t?(-1!==o&&(n+=encodeURIComponent(e.substring(o,r)),o=-1),n+=t):-1===o&&(o=r)}}return-1!==o&&(n+=encodeURIComponent(e.substring(o))),void 0!==n?n:e}function f(e){let t;for(let i=0;i<e.length;i++){const n=e.charCodeAt(i);35===n||63===n?(void 0===t&&(t=e.substr(0,i)),t+=p[n]):void 0!==t&&(t+=e[i])}return void 0!==t?t:e}function b(e,t){let i;return i=e.authority&&e.path.length>1&&"file"===e.scheme?`//${e.authority}${e.path}`:47===e.path.charCodeAt(0)&&(e.path.charCodeAt(1)>=65&&e.path.charCodeAt(1)<=90||e.path.charCodeAt(1)>=97&&e.path.charCodeAt(1)<=122)&&58===e.path.charCodeAt(2)?t?e.path.substr(1):e.path[1].toLowerCase()+e.path.substr(2):e.path,o.isWindows&&(i=i.replace(/\//g,"\\")),i}function v(e,t){const i=t?f:m;let n="",{scheme:o,authority:r,path:s,query:a,fragment:l}=e;if(o&&(n+=o,n+=":"),(r||"file"===o)&&(n+=c,n+=c),r){let e=r.indexOf("@");if(-1!==e){const t=r.substr(0,e);r=r.substr(e+1),e=t.lastIndexOf(":"),-1===e?n+=i(t,!1,!1):(n+=i(t.substr(0,e),!1,!1),n+=":",n+=i(t.substr(e+1),!1,!0)),n+="@"}r=r.toLowerCase(),e=r.lastIndexOf(":"),-1===e?n+=i(r,!1,!0):(n+=i(r.substr(0,e),!1,!0),n+=r.substr(e))}if(s){if(s.length>=3&&47===s.charCodeAt(0)&&58===s.charCodeAt(2)){const e=s.charCodeAt(1);e>=65&&e<=90&&(s=`/${String.fromCharCode(e+32)}:${s.substr(3)}`)}else if(s.length>=2&&58===s.charCodeAt(1)){const e=s.charCodeAt(0);e>=65&&e<=90&&(s=`${String.fromCharCode(e+32)}:${s.substr(2)}`)}n+=i(s,!0,!1)}return a&&(n+="?",n+=i(a,!1,!1)),l&&(n+="#",n+=t?l:m(l,!1,!1)),n}function _(e){try{return decodeURIComponent(e)}catch(t){return e.length>3?e.substr(0,3)+_(e.substr(3)):e}}const A=/(%[0-9A-Za-z][0-9A-Za-z])+/g;function C(e){return e.match(A)?e.replace(A,(e=>_(e))):e}},50302:function(e,t,i){"use strict";i.r(t),i.d(t,{SimpleWorkerClient:function(){return v},SimpleWorkerServer:function(){return w},create:function(){return y},logOnceWebWorkerWarning:function(){return u}});var n=i(12718),o=i(63801),r=i(68921),s=i(91057),a=i(66719),l=i(91482);const c="$initialize";let d=!1;function u(e){a.isWeb&&(d||(d=!0,console.warn("Could not create web worker(s). Falling back to loading web worker code in main thread, which might cause UI freezes. Please see https://github.com/microsoft/monaco-editor#faq")),console.warn(e.message))}class h{constructor(e,t,i,n){this.vsWorker=e,this.req=t,this.method=i,this.args=n,this.type=0}}class g{constructor(e,t,i,n){this.vsWorker=e,this.seq=t,this.res=i,this.err=n,this.type=1}}class p{constructor(e,t,i,n){this.vsWorker=e,this.req=t,this.eventName=i,this.arg=n,this.type=2}}class m{constructor(e,t,i){this.vsWorker=e,this.req=t,this.event=i,this.type=3}}class f{constructor(e,t){this.vsWorker=e,this.req=t,this.type=4}}class b{constructor(e){this._workerId=-1,this._handler=e,this._lastSentReq=0,this._pendingReplies=Object.create(null),this._pendingEmitters=new Map,this._pendingEvents=new Map}setWorkerId(e){this._workerId=e}sendMessage(e,t){const i=String(++this._lastSentReq);return new Promise(((n,o)=>{this._pendingReplies[i]={resolve:n,reject:o},this._send(new h(this._workerId,i,e,t))}))}listen(e,t){let i=null;const n=new o.Emitter({onWillAddFirstListener:()=>{i=String(++this._lastSentReq),this._pendingEmitters.set(i,n),this._send(new p(this._workerId,i,e,t))},onDidRemoveLastListener:()=>{this._pendingEmitters.delete(i),this._send(new f(this._workerId,i)),i=null}});return n.event}handleMessage(e){e&&e.vsWorker&&(-1!==this._workerId&&e.vsWorker!==this._workerId||this._handleMessage(e))}_handleMessage(e){switch(e.type){case 1:return this._handleReplyMessage(e);case 0:return this._handleRequestMessage(e);case 2:return this._handleSubscribeEventMessage(e);case 3:return this._handleEventMessage(e);case 4:return this._handleUnsubscribeEventMessage(e)}}_handleReplyMessage(e){if(!this._pendingReplies[e.seq])return void console.warn("Got reply to unknown seq");const t=this._pendingReplies[e.seq];if(delete this._pendingReplies[e.seq],e.err){let i=e.err;return e.err.$isError&&(i=new Error,i.name=e.err.name,i.message=e.err.message,i.stack=e.err.stack),void t.reject(i)}t.resolve(e.res)}_handleRequestMessage(e){const t=e.req;this._handler.handleMessage(e.method,e.args).then((e=>{this._send(new g(this._workerId,t,e,void 0))}),(e=>{e.detail instanceof Error&&(e.detail=(0,n.transformErrorForSerialization)(e.detail)),this._send(new g(this._workerId,t,void 0,(0,n.transformErrorForSerialization)(e)))}))}_handleSubscribeEventMessage(e){const t=e.req,i=this._handler.handleEvent(e.eventName,e.arg)((e=>{this._send(new m(this._workerId,t,e))}));this._pendingEvents.set(t,i)}_handleEventMessage(e){this._pendingEmitters.has(e.req)?this._pendingEmitters.get(e.req).fire(e.event):console.warn("Got event for unknown req")}_handleUnsubscribeEventMessage(e){this._pendingEvents.has(e.req)?(this._pendingEvents.get(e.req).dispose(),this._pendingEvents.delete(e.req)):console.warn("Got unsubscribe for unknown req")}_send(e){const t=[];if(0===e.type)for(let i=0;i<e.args.length;i++)e.args[i]instanceof ArrayBuffer&&t.push(e.args[i]);else 1===e.type&&e.res instanceof ArrayBuffer&&t.push(e.res);this._handler.sendMessage(e,t)}}class v extends r.Disposable{constructor(e,t,i){super();let n=null;this._worker=this._register(e.create("vs/base/common/worker/simpleWorker",(e=>{this._protocol.handleMessage(e)}),(e=>{null==n||n(e)}))),this._protocol=new b({sendMessage:(e,t)=>{this._worker.postMessage(e,t)},handleMessage:(e,t)=>{if("function"!=typeof i[e])return Promise.reject(new Error("Missing method "+e+" on main thread host."));try{return Promise.resolve(i[e].apply(i,t))}catch(e){return Promise.reject(e)}},handleEvent:(e,t)=>{if(A(e)){const n=i[e].call(i,t);if("function"!=typeof n)throw new Error(`Missing dynamic event ${e} on main thread host.`);return n}if(_(e)){const t=i[e];if("function"!=typeof t)throw new Error(`Missing event ${e} on main thread host.`);return t}throw new Error(`Malformed event name ${e}`)}}),this._protocol.setWorkerId(this._worker.getId());let o=null;const r=globalThis.require;void 0!==r&&"function"==typeof r.getConfig?o=r.getConfig():void 0!==globalThis.requirejs&&(o=globalThis.requirejs.s.contexts._.config);const a=(0,s.getAllMethodNames)(i);this._onModuleLoaded=this._protocol.sendMessage(c,[this._worker.getId(),JSON.parse(JSON.stringify(o)),t,a]);const l=(e,t)=>this._request(e,t),d=(e,t)=>this._protocol.listen(e,t);this._lazyProxy=new Promise(((e,i)=>{n=i,this._onModuleLoaded.then((t=>{e(C(t,l,d))}),(e=>{i(e),this._onError("Worker failed to load "+t,e)}))}))}getProxyObject(){return this._lazyProxy}_request(e,t){return new Promise(((i,n)=>{this._onModuleLoaded.then((()=>{this._protocol.sendMessage(e,t).then(i,n)}),n)}))}_onError(e,t){console.error(e),console.info(t)}}function _(e){return"o"===e[0]&&"n"===e[1]&&l.isUpperAsciiLetter(e.charCodeAt(2))}function A(e){return/^onDynamic/.test(e)&&l.isUpperAsciiLetter(e.charCodeAt(9))}function C(e,t,i){const n=e=>function(){const i=Array.prototype.slice.call(arguments,0);return t(e,i)},o=e=>function(t){return i(e,t)},r={};for(const t of e)A(t)?r[t]=o(t):_(t)?r[t]=i(t,void 0):r[t]=n(t);return r}class w{constructor(e,t){this._requestHandlerFactory=t,this._requestHandler=null,this._protocol=new b({sendMessage:(t,i)=>{e(t,i)},handleMessage:(e,t)=>this._handleMessage(e,t),handleEvent:(e,t)=>this._handleEvent(e,t)})}onmessage(e){this._protocol.handleMessage(e)}_handleMessage(e,t){if(e===c)return this.initialize(t[0],t[1],t[2],t[3]);if(!this._requestHandler||"function"!=typeof this._requestHandler[e])return Promise.reject(new Error("Missing requestHandler or method: "+e));try{return Promise.resolve(this._requestHandler[e].apply(this._requestHandler,t))}catch(e){return Promise.reject(e)}}_handleEvent(e,t){if(!this._requestHandler)throw new Error("Missing requestHandler");if(A(e)){const i=this._requestHandler[e].call(this._requestHandler,t);if("function"!=typeof i)throw new Error(`Missing dynamic event ${e} on request handler.`);return i}if(_(e)){const t=this._requestHandler[e];if("function"!=typeof t)throw new Error(`Missing event ${e} on request handler.`);return t}throw new Error(`Malformed event name ${e}`)}initialize(e,t,i,n){this._protocol.setWorkerId(e);const o=C(n,((e,t)=>this._protocol.sendMessage(e,t)),((e,t)=>this._protocol.listen(e,t)));return this._requestHandlerFactory?(this._requestHandler=this._requestHandlerFactory(o),Promise.resolve((0,s.getAllMethodNames)(this._requestHandler))):(t&&(void 0!==t.baseUrl&&delete t.baseUrl,void 0!==t.paths&&void 0!==t.paths.vs&&delete t.paths.vs,void 0!==typeof t.trustedTypesPolicy&&delete t.trustedTypesPolicy,t.catchError=!0,globalThis.require.config(t)),new Promise(((e,t)=>{(0,globalThis.require)([i],(i=>{this._requestHandler=i.create(o),this._requestHandler?e((0,s.getAllMethodNames)(this._requestHandler)):t(new Error("No RequestHandler!"))}),t)})))}}function y(e){return new w(e,null)}},14778:function(e,t,i){"use strict";i.r(t),i.d(t,{InMemoryStorageDatabase:function(){return u},Storage:function(){return d},StorageHint:function(){return n},StorageState:function(){return o}});var n,o,r=i(66129),s=i(63801),a=i(68921),l=i(61098),c=i(18912);!function(e){e[e.STORAGE_DOES_NOT_EXIST=0]="STORAGE_DOES_NOT_EXIST",e[e.STORAGE_IN_MEMORY=1]="STORAGE_IN_MEMORY"}(n||(n={})),function(e){e[e.None=0]="None",e[e.Initialized=1]="Initialized",e[e.Closed=2]="Closed"}(o||(o={}));class d extends a.Disposable{constructor(e,t=Object.create(null)){super(),this.database=e,this.options=t,this._onDidChangeStorage=this._register(new s.PauseableEmitter),this.onDidChangeStorage=this._onDidChangeStorage.event,this.state=o.None,this.cache=new Map,this.flushDelayer=this._register(new r.ThrottledDelayer(d.DEFAULT_FLUSH_DELAY)),this.pendingDeletes=new Set,this.pendingInserts=new Map,this.whenFlushedCallbacks=[],this.registerListeners()}registerListeners(){this._register(this.database.onDidChangeItemsExternal((e=>this.onDidChangeItemsExternal(e))))}onDidChangeItemsExternal(e){var t,i;this._onDidChangeStorage.pause();try{null===(t=e.changed)||void 0===t||t.forEach(((e,t)=>this.acceptExternal(t,e))),null===(i=e.deleted)||void 0===i||i.forEach((e=>this.acceptExternal(e,void 0)))}finally{this._onDidChangeStorage.resume()}}acceptExternal(e,t){if(this.state===o.Closed)return;let i=!1;if((0,c.isUndefinedOrNull)(t))i=this.cache.delete(e);else{this.cache.get(e)!==t&&(this.cache.set(e,t),i=!0)}i&&this._onDidChangeStorage.fire({key:e,external:!0})}get(e,t){const i=this.cache.get(e);return(0,c.isUndefinedOrNull)(i)?t:i}getBoolean(e,t){const i=this.get(e);return(0,c.isUndefinedOrNull)(i)?t:"true"===i}getNumber(e,t){const i=this.get(e);return(0,c.isUndefinedOrNull)(i)?t:parseInt(i,10)}async set(e,t,i=!1){if(this.state===o.Closed)return;if((0,c.isUndefinedOrNull)(t))return this.delete(e,i);const n=(0,c.isObject)(t)||Array.isArray(t)?(0,l.stringify)(t):String(t);return this.cache.get(e)!==n?(this.cache.set(e,n),this.pendingInserts.set(e,n),this.pendingDeletes.delete(e),this._onDidChangeStorage.fire({key:e,external:i}),this.doFlush()):void 0}async delete(e,t=!1){if(this.state===o.Closed)return;return this.cache.delete(e)?(this.pendingDeletes.has(e)||this.pendingDeletes.add(e),this.pendingInserts.delete(e),this._onDidChangeStorage.fire({key:e,external:t}),this.doFlush()):void 0}get hasPending(){return this.pendingInserts.size>0||this.pendingDeletes.size>0}async flushPending(){if(!this.hasPending)return;const e={insert:this.pendingInserts,delete:this.pendingDeletes};return this.pendingDeletes=new Set,this.pendingInserts=new Map,this.database.updateItems(e).finally((()=>{var e;if(!this.hasPending)for(;this.whenFlushedCallbacks.length;)null===(e=this.whenFlushedCallbacks.pop())||void 0===e||e()}))}async doFlush(e){return this.options.hint===n.STORAGE_IN_MEMORY?this.flushPending():this.flushDelayer.trigger((()=>this.flushPending()),e)}}d.DEFAULT_FLUSH_DELAY=100;class u{constructor(){this.onDidChangeItemsExternal=s.Event.None,this.items=new Map}async updateItems(e){var t,i;null===(t=e.insert)||void 0===t||t.forEach(((e,t)=>this.items.set(t,e))),null===(i=e.delete)||void 0===i||i.forEach((e=>this.items.delete(e)))}}},97365:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return n},language:function(){return o}});
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.45.0(5e5af013f8d295555a7210df0d5f2cea0bf5dd56)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
var n={comments:{lineComment:"*"},brackets:[["[","]"],["(",")"]]},o={defaultToken:"invalid",ignoreCase:!0,tokenPostfix:".abap",keywords:["abap-source","abbreviated","abstract","accept","accepting","according","activation","actual","add","add-corresponding","adjacent","after","alias","aliases","align","all","allocate","alpha","analysis","analyzer","and","append","appendage","appending","application","archive","area","arithmetic","as","ascending","aspect","assert","assign","assigned","assigning","association","asynchronous","at","attributes","authority","authority-check","avg","back","background","backup","backward","badi","base","before","begin","between","big","binary","bintohex","bit","black","blank","blanks","blob","block","blocks","blue","bound","boundaries","bounds","boxed","break-point","buffer","by","bypassing","byte","byte-order","call","calling","case","cast","casting","catch","center","centered","chain","chain-input","chain-request","change","changing","channels","character","char-to-hex","check","checkbox","ci_","circular","class","class-coding","class-data","class-events","class-methods","class-pool","cleanup","clear","client","clob","clock","close","coalesce","code","coding","col_background","col_group","col_heading","col_key","col_negative","col_normal","col_positive","col_total","collect","color","column","columns","comment","comments","commit","common","communication","comparing","component","components","compression","compute","concat","concat_with_space","concatenate","cond","condense","condition","connect","connection","constants","context","contexts","continue","control","controls","conv","conversion","convert","copies","copy","corresponding","country","cover","cpi","create","creating","critical","currency","currency_conversion","current","cursor","cursor-selection","customer","customer-function","dangerous","data","database","datainfo","dataset","date","dats_add_days","dats_add_months","dats_days_between","dats_is_valid","daylight","dd/mm/yy","dd/mm/yyyy","ddmmyy","deallocate","decimal_shift","decimals","declarations","deep","default","deferred","define","defining","definition","delete","deleting","demand","department","descending","describe","destination","detail","dialog","directory","disconnect","display","display-mode","distinct","divide","divide-corresponding","division","do","dummy","duplicate","duplicates","duration","during","dynamic","dynpro","edit","editor-call","else","elseif","empty","enabled","enabling","encoding","end","endat","endcase","endcatch","endchain","endclass","enddo","endenhancement","end-enhancement-section","endexec","endform","endfunction","endian","endif","ending","endinterface","end-lines","endloop","endmethod","endmodule","end-of-definition","end-of-editing","end-of-file","end-of-page","end-of-selection","endon","endprovide","endselect","end-test-injection","end-test-seam","endtry","endwhile","endwith","engineering","enhancement","enhancement-point","enhancements","enhancement-section","entries","entry","enum","environment","equiv","errormessage","errors","escaping","event","events","exact","except","exception","exceptions","exception-table","exclude","excluding","exec","execute","exists","exit","exit-command","expand","expanding","expiration","explicit","exponent","export","exporting","extend","extended","extension","extract","fail","fetch","field","field-groups","fields","field-symbol","field-symbols","file","filter","filters","filter-table","final","find","first","first-line","fixed-point","fkeq","fkge","flush","font","for","form","format","forward","found","frame","frames","free","friends","from","function","functionality","function-pool","further","gaps","generate","get","giving","gkeq","gkge","global","grant","green","group","groups","handle","handler","harmless","hashed","having","hdb","header","headers","heading","head-lines","help-id","help-request","hextobin","hide","high","hint","hold","hotspot","icon","id","identification","identifier","ids","if","ignore","ignoring","immediately","implementation","implementations","implemented","implicit","import","importing","in","inactive","incl","include","includes","including","increment","index","index-line","infotypes","inheriting","init","initial","initialization","inner","inout","input","insert","instance","instances","instr","intensified","interface","interface-pool","interfaces","internal","intervals","into","inverse","inverted-date","is","iso","job","join","keep","keeping","kernel","key","keys","keywords","kind","language","last","late","layout","leading","leave","left","left-justified","leftplus","leftspace","legacy","length","let","level","levels","like","line","lines","line-count","linefeed","line-selection","line-size","list","listbox","list-processing","little","llang","load","load-of-program","lob","local","locale","locator","logfile","logical","log-point","long","loop","low","lower","lpad","lpi","ltrim","mail","main","major-id","mapping","margin","mark","mask","match","matchcode","max","maximum","medium","members","memory","mesh","message","message-id","messages","messaging","method","methods","min","minimum","minor-id","mm/dd/yy","mm/dd/yyyy","mmddyy","mode","modif","modifier","modify","module","move","move-corresponding","multiply","multiply-corresponding","name","nametab","native","nested","nesting","new","new-line","new-page","new-section","next","no","no-display","no-extension","no-gap","no-gaps","no-grouping","no-heading","no-scrolling","no-sign","no-title","no-topofpage","no-zero","node","nodes","non-unicode","non-unique","not","null","number","object","objects","obligatory","occurrence","occurrences","occurs","of","off","offset","ole","on","only","open","option","optional","options","or","order","other","others","out","outer","output","output-length","overflow","overlay","pack","package","pad","padding","page","pages","parameter","parameters","parameter-table","part","partially","pattern","percentage","perform","performing","person","pf1","pf10","pf11","pf12","pf13","pf14","pf15","pf2","pf3","pf4","pf5","pf6","pf7","pf8","pf9","pf-status","pink","places","pool","pos_high","pos_low","position","pragmas","precompiled","preferred","preserving","primary","print","print-control","priority","private","procedure","process","program","property","protected","provide","public","push","pushbutton","put","queue-only","quickinfo","radiobutton","raise","raising","range","ranges","read","reader","read-only","receive","received","receiver","receiving","red","redefinition","reduce","reduced","ref","reference","refresh","regex","reject","remote","renaming","replace","replacement","replacing","report","request","requested","reserve","reset","resolution","respecting","responsible","result","results","resumable","resume","retry","return","returncode","returning","returns","right","right-justified","rightplus","rightspace","risk","rmc_communication_failure","rmc_invalid_status","rmc_system_failure","role","rollback","rows","rpad","rtrim","run","sap","sap-spool","saving","scale_preserving","scale_preserving_scientific","scan","scientific","scientific_with_leading_zero","scroll","scroll-boundary","scrolling","search","secondary","seconds","section","select","selection","selections","selection-screen","selection-set","selection-sets","selection-table","select-options","send","separate","separated","set","shared","shift","short","shortdump-id","sign_as_postfix","single","size","skip","skipping","smart","some","sort","sortable","sorted","source","specified","split","spool","spots","sql","sqlscript","stable","stamp","standard","starting","start-of-editing","start-of-selection","state","statement","statements","static","statics","statusinfo","step-loop","stop","structure","structures","style","subkey","submatches","submit","subroutine","subscreen","subtract","subtract-corresponding","suffix","sum","summary","summing","supplied","supply","suppress","switch","switchstates","symbol","syncpoints","syntax","syntax-check","syntax-trace","system-call","system-exceptions","system-exit","tab","tabbed","table","tables","tableview","tabstrip","target","task","tasks","test","testing","test-injection","test-seam","text","textpool","then","throw","time","times","timestamp","timezone","tims_is_valid","title","titlebar","title-lines","to","tokenization","tokens","top-lines","top-of-page","trace-file","trace-table","trailing","transaction","transfer","transformation","translate","transporting","trmac","truncate","truncation","try","tstmp_add_seconds","tstmp_current_utctimestamp","tstmp_is_valid","tstmp_seconds_between","type","type-pool","type-pools","types","uline","unassign","under","unicode","union","unique","unit_conversion","unix","unpack","until","unwind","up","update","upper","user","user-command","using","utf-8","valid","value","value-request","values","vary","varying","verification-message","version","via","view","visible","wait","warning","when","whenever","where","while","width","window","windows","with","with-heading","without","with-title","word","work","write","writer","xml","xsd","yellow","yes","yymmdd","zero","zone","abap_system_timezone","abap_user_timezone","access","action","adabas","adjust_numbers","allow_precision_loss","allowed","amdp","applicationuser","as_geo_json","as400","associations","balance","behavior","breakup","bulk","cds","cds_client","check_before_save","child","clients","corr","corr_spearman","cross","cycles","datn_add_days","datn_add_months","datn_days_between","dats_from_datn","dats_tims_to_tstmp","dats_to_datn","db2","db6","ddl","dense_rank","depth","deterministic","discarding","entities","entity","error","failed","finalize","first_value","fltp_to_dec","following","fractional","full","graph","grouping","hierarchy","hierarchy_ancestors","hierarchy_ancestors_aggregate","hierarchy_descendants","hierarchy_descendants_aggregate","hierarchy_siblings","incremental","indicators","lag","last_value","lead","leaves","like_regexpr","link","locale_sap","lock","locks","many","mapped","matched","measures","median","mssqlnt","multiple","nodetype","ntile","nulls","occurrences_regexpr","one","operations","oracle","orphans","over","parent","parents","partition","pcre","period","pfcg_mapping","preceding","privileged","product","projection","rank","redirected","replace_regexpr","reported","response","responses","root","row","row_number","sap_system_date","save","schema","session","sets","shortdump","siblings","spantree","start","stddev","string_agg","subtotal","sybase","tims_from_timn","tims_to_timn","to_blob","to_clob","total","trace-entry","tstmp_to_dats","tstmp_to_dst","tstmp_to_tims","tstmpl_from_utcl","tstmpl_to_utcl","unbounded","utcl_add_seconds","utcl_current","utcl_seconds_between","uuid","var","verbatim"],builtinFunctions:["abs","acos","asin","atan","bit-set","boolc","boolx","ceil","char_off","charlen","cmax","cmin","concat_lines_of","contains","contains_any_not_of","contains_any_of","cos","cosh","count","count_any_not_of","count_any_of","dbmaxlen","distance","escape","exp","find_any_not_of","find_any_of","find_end","floor","frac","from_mixed","ipow","line_exists","line_index","log","log10","matches","nmax","nmin","numofchar","repeat","rescale","reverse","round","segment","shift_left","shift_right","sign","sin","sinh","sqrt","strlen","substring","substring_after","substring_before","substring_from","substring_to","tan","tanh","to_lower","to_mixed","to_upper","trunc","utclong_add","utclong_current","utclong_diff","xsdbool","xstrlen"],typeKeywords:["b","c","d","decfloat16","decfloat34","f","i","int8","n","p","s","string","t","utclong","x","xstring","any","clike","csequence","decfloat","numeric","simple","xsequence","accp","char","clnt","cuky","curr","datn","dats","d16d","d16n","d16r","d34d","d34n","d34r","dec","df16_dec","df16_raw","df34_dec","df34_raw","fltp","geom_ewkb","int1","int2","int4","lang","lchr","lraw","numc","quan","raw","rawstring","sstring","timn","tims","unit","utcl","df16_scl","df34_scl","prec","varc","abap_bool","abap_false","abap_true","abap_undefined","me","screen","space","super","sy","syst","table_line","*sys*"],builtinMethods:["class_constructor","constructor"],derivedTypes:["%CID","%CID_REF","%CONTROL","%DATA","%ELEMENT","%FAIL","%KEY","%MSG","%PARAM","%PID","%PID_ASSOC","%PID_PARENT","%_HINTS"],cdsLanguage:["@AbapAnnotation","@AbapCatalog","@AccessControl","@API","@ClientDependent","@ClientHandling","@CompatibilityContract","@DataAging","@EndUserText","@Environment","@LanguageDependency","@MappingRole","@Metadata","@MetadataExtension","@ObjectModel","@Scope","@Semantics","$EXTENSION","$SELF"],selectors:["->","->*","=>","~","~*"],operators:[" +"," -","/","*","**","div","mod","=","#","@","+=","-=","*=","/=","**=","&&=","?=","&","&&","bit-and","bit-not","bit-or","bit-xor","m","o","z","<"," >","<=",">=","<>","><","=<","=>","bt","byte-ca","byte-cn","byte-co","byte-cs","byte-na","byte-ns","ca","cn","co","cp","cs","eq","ge","gt","le","lt","na","nb","ne","np","ns","*/","*:","--","/*","//"],symbols:/[=><!~?&+\-*\/\^%#@]+/,tokenizer:{root:[[/[a-z_\/$%@]([\w\/$%]|-(?!>))*/,{cases:{"@typeKeywords":"type","@keywords":"keyword","@cdsLanguage":"annotation","@derivedTypes":"type","@builtinFunctions":"type","@builtinMethods":"type","@operators":"key","@default":"identifier"}}],[/<[\w]+>/,"identifier"],[/##[\w|_]+/,"comment"],{include:"@whitespace"},[/[:,.]/,"delimiter"],[/[{}()\[\]]/,"@brackets"],[/@symbols/,{cases:{"@selectors":"tag","@operators":"key","@default":""}}],[/'/,{token:"string",bracket:"@open",next:"@stringquote"}],[/`/,{token:"string",bracket:"@open",next:"@stringping"}],[/\|/,{token:"string",bracket:"@open",next:"@stringtemplate"}],[/\d+/,"number"]],stringtemplate:[[/[^\\\|]+/,"string"],[/\\\|/,"string"],[/\|/,{token:"string",bracket:"@close",next:"@pop"}]],stringping:[[/[^\\`]+/,"string"],[/`/,{token:"string",bracket:"@close",next:"@pop"}]],stringquote:[[/[^\\']+/,"string"],[/'/,{token:"string",bracket:"@close",next:"@pop"}]],whitespace:[[/[ \t\r\n]+/,""],[/^\*.*$/,"comment"],[/\".*$/,"comment"]]}}},81294:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return n},language:function(){return r}});
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.45.0(5e5af013f8d295555a7210df0d5f2cea0bf5dd56)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
var n={wordPattern:/(-?\d*\.\d\w*)|([^\`\~\!\#\%\^\&\*\(\)\-\=\+\[\{\]\}\\\|\;\:\'\"\,\.\<\>\/\?\s]+)/g,comments:{lineComment:"//",blockComment:["/*","*/"]},brackets:[["{","}"],["[","]"],["(",")"]],autoClosingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"'},{open:"'",close:"'"}],surroundingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"'},{open:"'",close:"'"},{open:"<",close:">"}],folding:{markers:{start:new RegExp("^\\s*//\\s*(?:(?:#?region\\b)|(?:<editor-fold\\b))"),end:new RegExp("^\\s*//\\s*(?:(?:#?endregion\\b)|(?:</editor-fold>))")}}},o=[];["abstract","activate","and","any","array","as","asc","assert","autonomous","begin","bigdecimal","blob","boolean","break","bulk","by","case","cast","catch","char","class","collect","commit","const","continue","convertcurrency","decimal","default","delete","desc","do","double","else","end","enum","exception","exit","export","extends","false","final","finally","float","for","from","future","get","global","goto","group","having","hint","if","implements","import","in","inner","insert","instanceof","int","interface","into","join","last_90_days","last_month","last_n_days","last_week","like","limit","list","long","loop","map","merge","native","new","next_90_days","next_month","next_n_days","next_week","not","null","nulls","number","object","of","on","or","outer","override","package","parallel","pragma","private","protected","public","retrieve","return","returning","rollback","savepoint","search","select","set","short","sort","stat","static","strictfp","super","switch","synchronized","system","testmethod","then","this","this_month","this_week","throw","throws","today","tolabel","tomorrow","transaction","transient","trigger","true","try","type","undelete","update","upsert","using","virtual","void","volatile","webservice","when","where","while","yesterday"].forEach((e=>{o.push(e),o.push(e.toUpperCase()),o.push((e=>e.charAt(0).toUpperCase()+e.substr(1))(e))}));var r={defaultToken:"",tokenPostfix:".apex",keywords:o,operators:["=",">","<","!","~","?",":","==","<=",">=","!=","&&","||","++","--","+","-","*","/","&","|","^","%","<<",">>",">>>","+=","-=","*=","/=","&=","|=","^=","%=","<<=",">>=",">>>="],symbols:/[=><!~?:&|+\-*\/\^%]+/,escapes:/\\(?:[abfnrtv\\"']|x[0-9A-Fa-f]{1,4}|u[0-9A-Fa-f]{4}|U[0-9A-Fa-f]{8})/,digits:/\d+(_+\d+)*/,octaldigits:/[0-7]+(_+[0-7]+)*/,binarydigits:/[0-1]+(_+[0-1]+)*/,hexdigits:/[[0-9a-fA-F]+(_+[0-9a-fA-F]+)*/,tokenizer:{root:[[/[a-z_$][\w$]*/,{cases:{"@keywords":{token:"keyword.$0"},"@default":"identifier"}}],[/[A-Z][\w\$]*/,{cases:{"@keywords":{token:"keyword.$0"},"@default":"type.identifier"}}],{include:"@whitespace"},[/[{}()\[\]]/,"@brackets"],[/[<>](?!@symbols)/,"@brackets"],[/@symbols/,{cases:{"@operators":"delimiter","@default":""}}],[/@\s*[a-zA-Z_\$][\w\$]*/,"annotation"],[/(@digits)[eE]([\-+]?(@digits))?[fFdD]?/,"number.float"],[/(@digits)\.(@digits)([eE][\-+]?(@digits))?[fFdD]?/,"number.float"],[/(@digits)[fFdD]/,"number.float"],[/(@digits)[lL]?/,"number"],[/[;,.]/,"delimiter"],[/"([^"\\]|\\.)*$/,"string.invalid"],[/'([^'\\]|\\.)*$/,"string.invalid"],[/"/,"string",'@string."'],[/'/,"string","@string.'"],[/'[^\\']'/,"string"],[/(')(@escapes)(')/,["string","string.escape","string"]],[/'/,"string.invalid"]],whitespace:[[/[ \t\r\n]+/,""],[/\/\*\*(?!\/)/,"comment.doc","@apexdoc"],[/\/\*/,"comment","@comment"],[/\/\/.*$/,"comment"]],comment:[[/[^\/*]+/,"comment"],[/\*\//,"comment","@pop"],[/[\/*]/,"comment"]],apexdoc:[[/[^\/*]+/,"comment.doc"],[/\*\//,"comment.doc","@pop"],[/[\/*]/,"comment.doc"]],string:[[/[^\\"']+/,"string"],[/@escapes/,"string.escape"],[/\\./,"string.escape.invalid"],[/["']/,{cases:{"$#==$S2":{token:"string",next:"@pop"},"@default":"string"}}]]}}},64343:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return n},language:function(){return o}});
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.45.0(5e5af013f8d295555a7210df0d5f2cea0bf5dd56)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
var n={comments:{lineComment:"#"}},o={defaultToken:"keyword",ignoreCase:!0,tokenPostfix:".azcli",str:/[^#\s]/,tokenizer:{root:[{include:"@comment"},[/\s-+@str*\s*/,{cases:{"@eos":{token:"key.identifier",next:"@popall"},"@default":{token:"key.identifier",next:"@type"}}}],[/^-+@str*\s*/,{cases:{"@eos":{token:"key.identifier",next:"@popall"},"@default":{token:"key.identifier",next:"@type"}}}]],type:[{include:"@comment"},[/-+@str*\s*/,{cases:{"@eos":{token:"key.identifier",next:"@popall"},"@default":"key.identifier"}}],[/@str+\s*/,{cases:{"@eos":{token:"string",next:"@popall"},"@default":"string"}}]],comment:[[/#.*$/,{cases:{"@eos":{token:"comment",next:"@popall"}}}]]}}},42479:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return n},language:function(){return o}});
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.45.0(5e5af013f8d295555a7210df0d5f2cea0bf5dd56)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
var n={comments:{lineComment:"REM"},brackets:[["{","}"],["[","]"],["(",")"]],autoClosingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"'}],surroundingPairs:[{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"'}],folding:{markers:{start:new RegExp("^\\s*(::\\s*|REM\\s+)#region"),end:new RegExp("^\\s*(::\\s*|REM\\s+)#endregion")}}},o={defaultToken:"",ignoreCase:!0,tokenPostfix:".bat",brackets:[{token:"delimiter.bracket",open:"{",close:"}"},{token:"delimiter.parenthesis",open:"(",close:")"},{token:"delimiter.square",open:"[",close:"]"}],keywords:/call|defined|echo|errorlevel|exist|for|goto|if|pause|set|shift|start|title|not|pushd|popd/,symbols:/[=><!~?&|+\-*\/\^;\.,]+/,escapes:/\\(?:[abfnrtv\\"']|x[0-9A-Fa-f]{1,4}|u[0-9A-Fa-f]{4}|U[0-9A-Fa-f]{8})/,tokenizer:{root:[[/^(\s*)(rem(?:\s.*|))$/,["","comment"]],[/(\@?)(@keywords)(?!\w)/,[{token:"keyword"},{token:"keyword.$2"}]],[/[ \t\r\n]+/,""],[/setlocal(?!\w)/,"keyword.tag-setlocal"],[/endlocal(?!\w)/,"keyword.tag-setlocal"],[/[a-zA-Z_]\w*/,""],[/:\w*/,"metatag"],[/%[^%]+%/,"variable"],[/%%[\w]+(?!\w)/,"variable"],[/[{}()\[\]]/,"@brackets"],[/@symbols/,"delimiter"],[/\d*\.\d+([eE][\-+]?\d+)?/,"number.float"],[/0[xX][0-9a-fA-F_]*[0-9a-fA-F]/,"number.hex"],[/\d+/,"number"],[/[;,.]/,"delimiter"],[/"/,"string",'@string."'],[/'/,"string","@string.'"]],string:[[/[^\\"'%]+/,{cases:{"@eos":{token:"string",next:"@popall"},"@default":"string"}}],[/@escapes/,"string.escape"],[/\\./,"string.escape.invalid"],[/%[\w ]+%/,"variable"],[/%%[\w]+(?!\w)/,"variable"],[/["']/,{cases:{"$#==$S2":{token:"string",next:"@pop"},"@default":"string"}}],[/$/,"string","@popall"]]}}},80767:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return o},language:function(){return r}});
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.45.0(5e5af013f8d295555a7210df0d5f2cea0bf5dd56)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
var n=`\\b${"[_a-zA-Z][_a-zA-Z0-9]*"}\\b`,o={comments:{lineComment:"//",blockComment:["/*","*/"]},brackets:[["{","}"],["[","]"],["(",")"]],surroundingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:"'",close:"'"},{open:"'''",close:"'''"}],autoClosingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:"'",close:"'",notIn:["string","comment"]},{open:"'''",close:"'''",notIn:["string","comment"]}],autoCloseBefore:":.,=}])' \n\t",indentationRules:{increaseIndentPattern:new RegExp("^((?!\\/\\/).)*(\\{[^}\"'`]*|\\([^)\"'`]*|\\[[^\\]\"'`]*)$"),decreaseIndentPattern:new RegExp("^((?!.*?\\/\\*).*\\*/)?\\s*[\\}\\]].*$")}},r={defaultToken:"",tokenPostfix:".bicep",brackets:[{open:"{",close:"}",token:"delimiter.curly"},{open:"[",close:"]",token:"delimiter.square"},{open:"(",close:")",token:"delimiter.parenthesis"}],symbols:/[=><!~?:&|+\-*/^%]+/,keywords:["targetScope","resource","module","param","var","output","for","in","if","existing"],namedLiterals:["true","false","null"],escapes:"\\\\(u{[0-9A-Fa-f]+}|n|r|t|\\\\|'|\\${)",tokenizer:{root:[{include:"@expression"},{include:"@whitespace"}],stringVerbatim:[{regex:"(|'|'')[^']",action:{token:"string"}},{regex:"'''",action:{token:"string.quote",next:"@pop"}}],stringLiteral:[{regex:"\\${",action:{token:"delimiter.bracket",next:"@bracketCounting"}},{regex:"[^\\\\'$]+",action:{token:"string"}},{regex:"@escapes",action:{token:"string.escape"}},{regex:"\\\\.",action:{token:"string.escape.invalid"}},{regex:"'",action:{token:"string",next:"@pop"}}],bracketCounting:[{regex:"{",action:{token:"delimiter.bracket",next:"@bracketCounting"}},{regex:"}",action:{token:"delimiter.bracket",next:"@pop"}},{include:"expression"}],comment:[{regex:"[^\\*]+",action:{token:"comment"}},{regex:"\\*\\/",action:{token:"comment",next:"@pop"}},{regex:"[\\/*]",action:{token:"comment"}}],whitespace:[{regex:"[ \\t\\r\\n]"},{regex:"\\/\\*",action:{token:"comment",next:"@comment"}},{regex:"\\/\\/.*$",action:{token:"comment"}}],expression:[{regex:"'''",action:{token:"string.quote",next:"@stringVerbatim"}},{regex:"'",action:{token:"string.quote",next:"@stringLiteral"}},{regex:"[0-9]+",action:{token:"number"}},{regex:n,action:{cases:{"@keywords":{token:"keyword"},"@namedLiterals":{token:"keyword"},"@default":{token:"identifier"}}}}]}}},39395:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return n},language:function(){return o}});
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.45.0(5e5af013f8d295555a7210df0d5f2cea0bf5dd56)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
var n={comments:{lineComment:"//",blockComment:["(*","*)"]},brackets:[["{","}"],["[","]"],["(",")"],["<",">"]],autoClosingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:"<",close:">"},{open:"'",close:"'"},{open:'"',close:'"'},{open:"(*",close:"*)"}],surroundingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:"<",close:">"},{open:"'",close:"'"},{open:'"',close:'"'},{open:"(*",close:"*)"}]},o={defaultToken:"",tokenPostfix:".cameligo",ignoreCase:!0,brackets:[{open:"{",close:"}",token:"delimiter.curly"},{open:"[",close:"]",token:"delimiter.square"},{open:"(",close:")",token:"delimiter.parenthesis"},{open:"<",close:">",token:"delimiter.angle"}],keywords:["abs","assert","block","Bytes","case","Crypto","Current","else","failwith","false","for","fun","if","in","let","let%entry","let%init","List","list","Map","map","match","match%nat","mod","not","operation","Operation","of","record","Set","set","sender","skip","source","String","then","to","true","type","with"],typeKeywords:["int","unit","string","tz","nat","bool"],operators:["=",">","<","<=",">=","<>",":",":=","and","mod","or","+","-","*","/","@","&","^","%","->","<-","&&","||"],symbols:/[=><:@\^&|+\-*\/\^%]+/,tokenizer:{root:[[/[a-zA-Z_][\w]*/,{cases:{"@keywords":{token:"keyword.$0"},"@default":"identifier"}}],{include:"@whitespace"},[/[{}()\[\]]/,"@brackets"],[/[<>](?!@symbols)/,"@brackets"],[/@symbols/,{cases:{"@operators":"delimiter","@default":""}}],[/\d*\.\d+([eE][\-+]?\d+)?/,"number.float"],[/\$[0-9a-fA-F]{1,16}/,"number.hex"],[/\d+/,"number"],[/[;,.]/,"delimiter"],[/'([^'\\]|\\.)*$/,"string.invalid"],[/'/,"string","@string"],[/'[^\\']'/,"string"],[/'/,"string.invalid"],[/\#\d+/,"string"]],comment:[[/[^\(\*]+/,"comment"],[/\*\)/,"comment","@pop"],[/\(\*/,"comment"]],string:[[/[^\\']+/,"string"],[/\\./,"string.escape.invalid"],[/'/,{token:"string.quote",bracket:"@close",next:"@pop"}]],whitespace:[[/[ \t\r\n]+/,"white"],[/\(\*/,"comment","@comment"],[/\/\/.*$/,"comment"]]}}},36525:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return n},language:function(){return o}});
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.45.0(5e5af013f8d295555a7210df0d5f2cea0bf5dd56)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
var n={comments:{lineComment:";;"},brackets:[["[","]"],["(",")"],["{","}"]],autoClosingPairs:[{open:"[",close:"]"},{open:'"',close:'"'},{open:"(",close:")"},{open:"{",close:"}"}],surroundingPairs:[{open:"[",close:"]"},{open:'"',close:'"'},{open:"(",close:")"},{open:"{",close:"}"}]},o={defaultToken:"",ignoreCase:!0,tokenPostfix:".clj",brackets:[{open:"[",close:"]",token:"delimiter.square"},{open:"(",close:")",token:"delimiter.parenthesis"},{open:"{",close:"}",token:"delimiter.curly"}],constants:["true","false","nil"],numbers:/^(?:[+\-]?\d+(?:(?:N|(?:[eE][+\-]?\d+))|(?:\.?\d*(?:M|(?:[eE][+\-]?\d+))?)|\/\d+|[xX][0-9a-fA-F]+|r[0-9a-zA-Z]+)?(?=[\\\[\]\s"#'(),;@^`{}~]|$))/,characters:/^(?:\\(?:backspace|formfeed|newline|return|space|tab|o[0-7]{3}|u[0-9A-Fa-f]{4}|x[0-9A-Fa-f]{4}|.)?(?=[\\\[\]\s"(),;@^`{}~]|$))/,escapes:/^\\(?:["'\\bfnrt]|x[0-9A-Fa-f]{1,4}|u[0-9A-Fa-f]{4}|U[0-9A-Fa-f]{8})/,qualifiedSymbols:/^(?:(?:[^\\\/\[\]\d\s"#'(),;@^`{}~][^\\\[\]\s"(),;@^`{}~]*(?:\.[^\\\/\[\]\d\s"#'(),;@^`{}~][^\\\[\]\s"(),;@^`{}~]*)*\/)?(?:\/|[^\\\/\[\]\d\s"#'(),;@^`{}~][^\\\[\]\s"(),;@^`{}~]*)*(?=[\\\[\]\s"(),;@^`{}~]|$))/,specialForms:[".","catch","def","do","if","monitor-enter","monitor-exit","new","quote","recur","set!","throw","try","var"],coreSymbols:["*","*'","*1","*2","*3","*agent*","*allow-unresolved-vars*","*assert*","*clojure-version*","*command-line-args*","*compile-files*","*compile-path*","*compiler-options*","*data-readers*","*default-data-reader-fn*","*e","*err*","*file*","*flush-on-newline*","*fn-loader*","*in*","*math-context*","*ns*","*out*","*print-dup*","*print-length*","*print-level*","*print-meta*","*print-namespace-maps*","*print-readably*","*read-eval*","*reader-resolver*","*source-path*","*suppress-read*","*unchecked-math*","*use-context-classloader*","*verbose-defrecords*","*warn-on-reflection*","+","+'","-","-'","->","->>","->ArrayChunk","->Eduction","->Vec","->VecNode","->VecSeq","-cache-protocol-fn","-reset-methods","..","/","<","<=","=","==",">",">=","EMPTY-NODE","Inst","StackTraceElement->vec","Throwable->map","accessor","aclone","add-classpath","add-watch","agent","agent-error","agent-errors","aget","alength","alias","all-ns","alter","alter-meta!","alter-var-root","amap","ancestors","and","any?","apply","areduce","array-map","as->","aset","aset-boolean","aset-byte","aset-char","aset-double","aset-float","aset-int","aset-long","aset-short","assert","assoc","assoc!","assoc-in","associative?","atom","await","await-for","await1","bases","bean","bigdec","bigint","biginteger","binding","bit-and","bit-and-not","bit-clear","bit-flip","bit-not","bit-or","bit-set","bit-shift-left","bit-shift-right","bit-test","bit-xor","boolean","boolean-array","boolean?","booleans","bound-fn","bound-fn*","bound?","bounded-count","butlast","byte","byte-array","bytes","bytes?","case","cast","cat","char","char-array","char-escape-string","char-name-string","char?","chars","chunk","chunk-append","chunk-buffer","chunk-cons","chunk-first","chunk-next","chunk-rest","chunked-seq?","class","class?","clear-agent-errors","clojure-version","coll?","comment","commute","comp","comparator","compare","compare-and-set!","compile","complement","completing","concat","cond","cond->","cond->>","condp","conj","conj!","cons","constantly","construct-proxy","contains?","count","counted?","create-ns","create-struct","cycle","dec","dec'","decimal?","declare","dedupe","default-data-readers","definline","definterface","defmacro","defmethod","defmulti","defn","defn-","defonce","defprotocol","defrecord","defstruct","deftype","delay","delay?","deliver","denominator","deref","derive","descendants","destructure","disj","disj!","dissoc","dissoc!","distinct","distinct?","doall","dorun","doseq","dosync","dotimes","doto","double","double-array","double?","doubles","drop","drop-last","drop-while","eduction","empty","empty?","ensure","ensure-reduced","enumeration-seq","error-handler","error-mode","eval","even?","every-pred","every?","ex-data","ex-info","extend","extend-protocol","extend-type","extenders","extends?","false?","ffirst","file-seq","filter","filterv","find","find-keyword","find-ns","find-protocol-impl","find-protocol-method","find-var","first","flatten","float","float-array","float?","floats","flush","fn","fn?","fnext","fnil","for","force","format","frequencies","future","future-call","future-cancel","future-cancelled?","future-done?","future?","gen-class","gen-interface","gensym","get","get-in","get-method","get-proxy-class","get-thread-bindings","get-validator","group-by","halt-when","hash","hash-combine","hash-map","hash-ordered-coll","hash-set","hash-unordered-coll","ident?","identical?","identity","if-let","if-not","if-some","ifn?","import","in-ns","inc","inc'","indexed?","init-proxy","inst-ms","inst-ms*","inst?","instance?","int","int-array","int?","integer?","interleave","intern","interpose","into","into-array","ints","io!","isa?","iterate","iterator-seq","juxt","keep","keep-indexed","key","keys","keyword","keyword?","last","lazy-cat","lazy-seq","let","letfn","line-seq","list","list*","list?","load","load-file","load-reader","load-string","loaded-libs","locking","long","long-array","longs","loop","macroexpand","macroexpand-1","make-array","make-hierarchy","map","map-entry?","map-indexed","map?","mapcat","mapv","max","max-key","memfn","memoize","merge","merge-with","meta","method-sig","methods","min","min-key","mix-collection-hash","mod","munge","name","namespace","namespace-munge","nat-int?","neg-int?","neg?","newline","next","nfirst","nil?","nnext","not","not-any?","not-empty","not-every?","not=","ns","ns-aliases","ns-imports","ns-interns","ns-map","ns-name","ns-publics","ns-refers","ns-resolve","ns-unalias","ns-unmap","nth","nthnext","nthrest","num","number?","numerator","object-array","odd?","or","parents","partial","partition","partition-all","partition-by","pcalls","peek","persistent!","pmap","pop","pop!","pop-thread-bindings","pos-int?","pos?","pr","pr-str","prefer-method","prefers","primitives-classnames","print","print-ctor","print-dup","print-method","print-simple","print-str","printf","println","println-str","prn","prn-str","promise","proxy","proxy-call-with-super","proxy-mappings","proxy-name","proxy-super","push-thread-bindings","pvalues","qualified-ident?","qualified-keyword?","qualified-symbol?","quot","rand","rand-int","rand-nth","random-sample","range","ratio?","rational?","rationalize","re-find","re-groups","re-matcher","re-matches","re-pattern","re-seq","read","read-line","read-string","reader-conditional","reader-conditional?","realized?","record?","reduce","reduce-kv","reduced","reduced?","reductions","ref","ref-history-count","ref-max-history","ref-min-history","ref-set","refer","refer-clojure","reify","release-pending-sends","rem","remove","remove-all-methods","remove-method","remove-ns","remove-watch","repeat","repeatedly","replace","replicate","require","reset!","reset-meta!","reset-vals!","resolve","rest","restart-agent","resultset-seq","reverse","reversible?","rseq","rsubseq","run!","satisfies?","second","select-keys","send","send-off","send-via","seq","seq?","seqable?","seque","sequence","sequential?","set","set-agent-send-executor!","set-agent-send-off-executor!","set-error-handler!","set-error-mode!","set-validator!","set?","short","short-array","shorts","shuffle","shutdown-agents","simple-ident?","simple-keyword?","simple-symbol?","slurp","some","some->","some->>","some-fn","some?","sort","sort-by","sorted-map","sorted-map-by","sorted-set","sorted-set-by","sorted?","special-symbol?","spit","split-at","split-with","str","string?","struct","struct-map","subs","subseq","subvec","supers","swap!","swap-vals!","symbol","symbol?","sync","tagged-literal","tagged-literal?","take","take-last","take-nth","take-while","test","the-ns","thread-bound?","time","to-array","to-array-2d","trampoline","transduce","transient","tree-seq","true?","type","unchecked-add","unchecked-add-int","unchecked-byte","unchecked-char","unchecked-dec","unchecked-dec-int","unchecked-divide-int","unchecked-double","unchecked-float","unchecked-inc","unchecked-inc-int","unchecked-int","unchecked-long","unchecked-multiply","unchecked-multiply-int","unchecked-negate","unchecked-negate-int","unchecked-remainder-int","unchecked-short","unchecked-subtract","unchecked-subtract-int","underive","unquote","unquote-splicing","unreduced","unsigned-bit-shift-right","update","update-in","update-proxy","uri?","use","uuid?","val","vals","var-get","var-set","var?","vary-meta","vec","vector","vector-of","vector?","volatile!","volatile?","vreset!","vswap!","when","when-first","when-let","when-not","when-some","while","with-bindings","with-bindings*","with-in-str","with-loading-context","with-local-vars","with-meta","with-open","with-out-str","with-precision","with-redefs","with-redefs-fn","xml-seq","zero?","zipmap"],tokenizer:{root:[{include:"@whitespace"},[/@numbers/,"number"],[/@characters/,"string"],{include:"@string"},[/[()\[\]{}]/,"@brackets"],[/\/#"(?:\.|(?:")|[^"\n])*"\/g/,"regexp"],[/[#'@^`~]/,"meta"],[/@qualifiedSymbols/,{cases:{"^:.+$":"constant","@specialForms":"keyword","@coreSymbols":"keyword","@constants":"constant","@default":"identifier"}}]],whitespace:[[/[\s,]+/,"white"],[/;.*$/,"comment"],[/\(comment\b/,"comment","@comment"]],comment:[[/\(/,"comment","@push"],[/\)/,"comment","@pop"],[/[^()]/,"comment"]],string:[[/"/,"string","@multiLineString"]],multiLineString:[[/"/,"string","@popall"],[/@escapes/,"string.escape"],[/./,"string"]]}}},78444:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return n},language:function(){return o}});
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.45.0(5e5af013f8d295555a7210df0d5f2cea0bf5dd56)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
var n={wordPattern:/(-?\d*\.\d\w*)|([^\`\~\!\@\#%\^\&\*\(\)\=\$\-\+\[\{\]\}\\\|\;\:\'\"\,\.\<\>\/\?\s]+)/g,comments:{blockComment:["###","###"],lineComment:"#"},brackets:[["{","}"],["[","]"],["(",")"]],autoClosingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"'},{open:"'",close:"'"}],surroundingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"'},{open:"'",close:"'"}],folding:{markers:{start:new RegExp("^\\s*#region\\b"),end:new RegExp("^\\s*#endregion\\b")}}},o={defaultToken:"",ignoreCase:!0,tokenPostfix:".coffee",brackets:[{open:"{",close:"}",token:"delimiter.curly"},{open:"[",close:"]",token:"delimiter.square"},{open:"(",close:")",token:"delimiter.parenthesis"}],regEx:/\/(?!\/\/)(?:[^\/\\]|\\.)*\/[igm]*/,keywords:["and","or","is","isnt","not","on","yes","@","no","off","true","false","null","this","new","delete","typeof","in","instanceof","return","throw","break","continue","debugger","if","else","switch","for","while","do","try","catch","finally","class","extends","super","undefined","then","unless","until","loop","of","by","when"],symbols:/[=><!~?&%|+\-*\/\^\.,\:]+/,escapes:/\\(?:[abfnrtv\\"'$]|x[0-9A-Fa-f]{1,4}|u[0-9A-Fa-f]{4}|U[0-9A-Fa-f]{8})/,tokenizer:{root:[[/\@[a-zA-Z_]\w*/,"variable.predefined"],[/[a-zA-Z_]\w*/,{cases:{this:"variable.predefined","@keywords":{token:"keyword.$0"},"@default":""}}],[/[ \t\r\n]+/,""],[/###/,"comment","@comment"],[/#.*$/,"comment"],["///",{token:"regexp",next:"@hereregexp"}],[/^(\s*)(@regEx)/,["","regexp"]],[/(\()(\s*)(@regEx)/,["@brackets","","regexp"]],[/(\,)(\s*)(@regEx)/,["delimiter","","regexp"]],[/(\=)(\s*)(@regEx)/,["delimiter","","regexp"]],[/(\:)(\s*)(@regEx)/,["delimiter","","regexp"]],[/(\[)(\s*)(@regEx)/,["@brackets","","regexp"]],[/(\!)(\s*)(@regEx)/,["delimiter","","regexp"]],[/(\&)(\s*)(@regEx)/,["delimiter","","regexp"]],[/(\|)(\s*)(@regEx)/,["delimiter","","regexp"]],[/(\?)(\s*)(@regEx)/,["delimiter","","regexp"]],[/(\{)(\s*)(@regEx)/,["@brackets","","regexp"]],[/(\;)(\s*)(@regEx)/,["","","regexp"]],[/}/,{cases:{"$S2==interpolatedstring":{token:"string",next:"@pop"},"@default":"@brackets"}}],[/[{}()\[\]]/,"@brackets"],[/@symbols/,"delimiter"],[/\d+[eE]([\-+]?\d+)?/,"number.float"],[/\d+\.\d+([eE][\-+]?\d+)?/,"number.float"],[/0[xX][0-9a-fA-F]+/,"number.hex"],[/0[0-7]+(?!\d)/,"number.octal"],[/\d+/,"number"],[/[,.]/,"delimiter"],[/"""/,"string",'@herestring."""'],[/'''/,"string","@herestring.'''"],[/"/,{cases:{"@eos":"string","@default":{token:"string",next:'@string."'}}}],[/'/,{cases:{"@eos":"string","@default":{token:"string",next:"@string.'"}}}]],string:[[/[^"'\#\\]+/,"string"],[/@escapes/,"string.escape"],[/\./,"string.escape.invalid"],[/\./,"string.escape.invalid"],[/#{/,{cases:{'$S2=="':{token:"string",next:"root.interpolatedstring"},"@default":"string"}}],[/["']/,{cases:{"$#==$S2":{token:"string",next:"@pop"},"@default":"string"}}],[/#/,"string"]],herestring:[[/("""|''')/,{cases:{"$1==$S2":{token:"string",next:"@pop"},"@default":"string"}}],[/[^#\\'"]+/,"string"],[/['"]+/,"string"],[/@escapes/,"string.escape"],[/\./,"string.escape.invalid"],[/#{/,{token:"string.quote",next:"root.interpolatedstring"}],[/#/,"string"]],comment:[[/[^#]+/,"comment"],[/###/,"comment","@pop"],[/#/,"comment"]],hereregexp:[[/[^\\\/#]+/,"regexp"],[/\\./,"regexp"],[/#.*$/,"comment"],["///[igm]*",{token:"regexp",next:"@pop"}],[/\//,"regexp"]]}}},63584:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return n},language:function(){return o}});
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.45.0(5e5af013f8d295555a7210df0d5f2cea0bf5dd56)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
var n={comments:{lineComment:"//",blockComment:["/*","*/"]},brackets:[["{","}"],["[","]"],["(",")"]],autoClosingPairs:[{open:"[",close:"]"},{open:"{",close:"}"},{open:"(",close:")"},{open:"'",close:"'",notIn:["string","comment"]},{open:'"',close:'"',notIn:["string"]}],surroundingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:'"',close:'"'},{open:"'",close:"'"}],folding:{markers:{start:new RegExp("^\\s*#pragma\\s+region\\b"),end:new RegExp("^\\s*#pragma\\s+endregion\\b")}}},o={defaultToken:"",tokenPostfix:".cpp",brackets:[{token:"delimiter.curly",open:"{",close:"}"},{token:"delimiter.parenthesis",open:"(",close:")"},{token:"delimiter.square",open:"[",close:"]"},{token:"delimiter.angle",open:"<",close:">"}],keywords:["abstract","amp","array","auto","bool","break","case","catch","char","class","const","constexpr","const_cast","continue","cpu","decltype","default","delegate","delete","do","double","dynamic_cast","each","else","enum","event","explicit","export","extern","false","final","finally","float","for","friend","gcnew","generic","goto","if","in","initonly","inline","int","interface","interior_ptr","internal","literal","long","mutable","namespace","new","noexcept","nullptr","__nullptr","operator","override","partial","pascal","pin_ptr","private","property","protected","public","ref","register","reinterpret_cast","restrict","return","safe_cast","sealed","short","signed","sizeof","static","static_assert","static_cast","struct","switch","template","this","thread_local","throw","tile_static","true","try","typedef","typeid","typename","union","unsigned","using","virtual","void","volatile","wchar_t","where","while","_asm","_based","_cdecl","_declspec","_fastcall","_if_exists","_if_not_exists","_inline","_multiple_inheritance","_pascal","_single_inheritance","_stdcall","_virtual_inheritance","_w64","__abstract","__alignof","__asm","__assume","__based","__box","__builtin_alignof","__cdecl","__clrcall","__declspec","__delegate","__event","__except","__fastcall","__finally","__forceinline","__gc","__hook","__identifier","__if_exists","__if_not_exists","__inline","__int128","__int16","__int32","__int64","__int8","__interface","__leave","__m128","__m128d","__m128i","__m256","__m256d","__m256i","__m512","__m512d","__m512i","__m64","__multiple_inheritance","__newslot","__nogc","__noop","__nounwind","__novtordisp","__pascal","__pin","__pragma","__property","__ptr32","__ptr64","__raise","__restrict","__resume","__sealed","__single_inheritance","__stdcall","__super","__thiscall","__try","__try_cast","__typeof","__unaligned","__unhook","__uuidof","__value","__virtual_inheritance","__w64","__wchar_t"],operators:["=",">","<","!","~","?",":","==","<=",">=","!=","&&","||","++","--","+","-","*","/","&","|","^","%","<<",">>",">>>","+=","-=","*=","/=","&=","|=","^=","%=","<<=",">>=",">>>="],symbols:/[=><!~?:&|+\-*\/\^%]+/,escapes:/\\(?:[0abfnrtv\\"']|x[0-9A-Fa-f]{1,4}|u[0-9A-Fa-f]{4}|U[0-9A-Fa-f]{8})/,integersuffix:/([uU](ll|LL|l|L)|(ll|LL|l|L)?[uU]?)/,floatsuffix:/[fFlL]?/,encoding:/u|u8|U|L/,tokenizer:{root:[[/@encoding?R\"(?:([^ ()\\\t]*))\(/,{token:"string.raw.begin",next:"@raw.$1"}],[/[a-zA-Z_]\w*/,{cases:{"@keywords":{token:"keyword.$0"},"@default":"identifier"}}],[/^\s*#\s*include/,{token:"keyword.directive.include",next:"@include"}],[/^\s*#\s*\w+/,"keyword.directive"],{include:"@whitespace"},[/\[\s*\[/,{token:"annotation",next:"@annotation"}],[/[{}()\[\]]/,"@brackets"],[/[<>](?!@symbols)/,"@brackets"],[/@symbols/,{cases:{"@operators":"delimiter","@default":""}}],[/\d*\d+[eE]([\-+]?\d+)?(@floatsuffix)/,"number.float"],[/\d*\.\d+([eE][\-+]?\d+)?(@floatsuffix)/,"number.float"],[/0[xX][0-9a-fA-F']*[0-9a-fA-F](@integersuffix)/,"number.hex"],[/0[0-7']*[0-7](@integersuffix)/,"number.octal"],[/0[bB][0-1']*[0-1](@integersuffix)/,"number.binary"],[/\d[\d']*\d(@integersuffix)/,"number"],[/\d(@integersuffix)/,"number"],[/[;,.]/,"delimiter"],[/"([^"\\]|\\.)*$/,"string.invalid"],[/"/,"string","@string"],[/'[^\\']'/,"string"],[/(')(@escapes)(')/,["string","string.escape","string"]],[/'/,"string.invalid"]],whitespace:[[/[ \t\r\n]+/,""],[/\/\*\*(?!\/)/,"comment.doc","@doccomment"],[/\/\*/,"comment","@comment"],[/\/\/.*\\$/,"comment","@linecomment"],[/\/\/.*$/,"comment"]],comment:[[/[^\/*]+/,"comment"],[/\*\//,"comment","@pop"],[/[\/*]/,"comment"]],linecomment:[[/.*[^\\]$/,"comment","@pop"],[/[^]+/,"comment"]],doccomment:[[/[^\/*]+/,"comment.doc"],[/\*\//,"comment.doc","@pop"],[/[\/*]/,"comment.doc"]],string:[[/[^\\"]+/,"string"],[/@escapes/,"string.escape"],[/\\./,"string.escape.invalid"],[/"/,"string","@pop"]],raw:[[/(.*)(\))(?:([^ ()\\\t"]*))(\")/,{cases:{"$3==$S2":["string.raw","string.raw.end","string.raw.end",{token:"string.raw.end",next:"@pop"}],"@default":["string.raw","string.raw","string.raw","string.raw"]}}],[/.*/,"string.raw"]],annotation:[{include:"@whitespace"},[/using|alignas/,"keyword"],[/[a-zA-Z0-9_]+/,"annotation"],[/[,:]/,"delimiter"],[/[()]/,"@brackets"],[/\]\s*\]/,{token:"annotation",next:"@pop"}]],include:[[/(\s*)(<)([^<>]*)(>)/,["","keyword.directive.include.begin","string.include.identifier",{token:"keyword.directive.include.end",next:"@pop"}]],[/(\s*)(")([^"]*)(")/,["","keyword.directive.include.begin","string.include.identifier",{token:"keyword.directive.include.end",next:"@pop"}]]]}}},12910:function(e,t,i){"use strict";i.r(t),i.d(t,{conf:function(){return n},language:function(){return o}});
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.45.0(5e5af013f8d295555a7210df0d5f2cea0bf5dd56)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
var n={wordPattern:/(-?\d*\.\d\w*)|([^\`\~\!\#\$\%\^\&\*\(\)\-\=\+\[\{\]\}\\\|\;\:\'\"\,\.\<\>\/\?\s]+)/g,comments:{lineComment:"//",blockComment:["/*","*/"]},brackets:[["{","}"],["[","]"],["(",")"]],autoClosingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:"'",close:"'",notIn:["string","comment"]},{open:'"',close:'"',notIn:["string","comment"]}],surroundingPairs:[{open:"{",close:"}"},{open:"[",close:"]"},{open:"(",close:")"},{open:"<",close:">"},{open:"'",close:"'"},{open:'"',close:'"'}],folding:{markers:{start:new RegExp("^\\s*#region\\b"),end:new RegExp("^\\s*#endregion\\b")}}},o={defaultToken:"",tokenPostfix:".cs",brackets:[{open:"{",close:"}",token:"delimiter.curly"},{open:"[",close:"]",token:"delimiter.square"},{open:"(",close:")",token:"delimiter.parenthesis"},{open:"<",close:">",token:"delimiter.angle"}],keywords:["extern","alias","using","bool","decimal","sbyte","byte","short","ushort","int","uint","long","ulong","char","float","double","object","dynamic","string","assembly","is","as","ref","out","this","base","new","typeof","void","checked","unchecked","default","delegate","var","const","if","else","switch","case","while","do","for","foreach","in","break","continue","goto","return","throw","try","catch","finally","lock","yield","from","let","where","join","on","equals","into","orderby","ascending","descending","select","group","by","namespace","partial","class","field","event","method","param","public","protected","internal","private","abstract","sealed","static","struct","readonly","volatile","virtual","override","params","get","set","add","remove","operator","true","false","implicit","explicit","interface","enum","null","async","await","fixed","sizeof","stackalloc","unsafe","nameof","when"],namespaceFollows:["namespace","using"],parenFollows:["if","for","while","switch","foreach","using","catch","when"],operators:["=","??","||","&&","|","^","&","==","!=","<=",">=","<<","+","-","*","/","%","!","~","++","--","+=","-=","*=","/=","%=","&=","|=","^=","<<=",">>=",">>","=>"],symbols:/[=><!~?:&|+\-*\/\^%]+/,escapes:/\\(?:[abfnrtv\\"']|x[0-9A-Fa-f]{1,4}|u[0-9A-Fa-f]{4}|U[0-9A-Fa-f]{8})/,tokenizer:{root:[[/\@?[a-zA-Z_]\w*/,{cases:{"@namespaceFollows":{token:"keyword.$0",next:"@namespace"},"@keywords":{token:"keyword.$0",next:"@qualified"},"@default":{token:"identifier",next:"@qualified"}}}],{include:"@whitespace"},[/}/,{cases:{"$S2==interpolatedstring":{token:"string.quote",next:"@pop"},"$S2==litinterpstring":{token:"string.quote",next:"@pop"},"@default":"@brackets"}}],[/[{}()\[\]]/,"@brackets"],[/[<>](?!@symbols)/,"@brackets"],[/@symbols/,{cases:{"@operators":"delimiter","@default":""}}],[/[0-9_]*\.[0-9_]+([eE][\-+]?\d+)?[fFdD]?/,"number.float"],[/0[xX][0-9a-fA-F_]+/,"number.hex"],[/0[bB][01_]+/,"number.hex"],[/[0-9_]+/,"number"],[/[;,.]/,"delimiter"],[/"([^"\\]|\\.)*$/,"string.invalid"],[/"/,{token:"string.quote",next:"@string"}],[/\$\@"/,{token:"string.quote",next:"@litinterpstring"}],[/\@"/,{token:"string.quote",next:"@litstring"}],[/\$"/,{token:"string.quote",next:"@interpolatedstring"}],[/'[^\\']'/,"string"],[/(')(@escapes)(')/,["string","string.escape","string"]],[/'/,"string.invalid"]],qualified:[[/[a-zA-Z_][\w]*/,{cases:{"@keywords":{token:"keyword.$0"},"@default":"identifier"}}],[/\./,"delimiter"],["","","@pop"]],namespace:[{include:"@whitespace"},[/[A-Z]\w*/,"namespace"],[/[\.=]/,"delimiter"],["","","@pop"]],comment:[[/[^\/*]+/,"comment"],["\\*/","comment","@pop"],[/[\/*]/,"comment"]],string:[[/[^\\"]+/,"string"],[/@escapes/,"string.escape"],[/\\./,"string.escape.invalid"],[/"/,{token:"string.quote",next:"@pop"}]],litstring:[[/[^"]+/,"string"],[/""/,"string.escape"],[/"/,{token:"string.quote",next:"@pop"}]],litinterpstring:[[/[^"{]+/,"string"],[/""/,"string.escape"],[/{{/,"string.escape"],[/}}/,"string.escape"],[/{/,{token:"string.quote",next:"root.litinterpstring"}],[/"/,{token:"string.quote",next:"@pop"}]],interpolatedstring:[[/[^\\"{]+/,"string"],[/@escapes/,"string.escape"],[/\\./,"string.escape.invalid"],[/{{/,"string.escape"],[/}}/,"string.escape"],[/{/,{token:"string.quote",next:"root.interpolatedstring"}],[/"/,{token:"string.quote",next:"@pop"}]],whitespace:[[/^