/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.optimizerplugin;

import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.WarningLevel;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.primefaces.extensions.optimizerplugin.Aggregation;
import org.primefaces.extensions.optimizerplugin.ClosureCompilerOptimizer;
import org.primefaces.extensions.optimizerplugin.ResourcesScanner;
import org.primefaces.extensions.optimizerplugin.ResourcesSet;
import org.primefaces.extensions.optimizerplugin.ResourcesSetAdapter;
import org.primefaces.extensions.optimizerplugin.YuiCompressorOptimizer;

public class ResourcesOptimizerMojo
extends AbstractMojo {
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/*.css", "**/*.js"};
    private static final String[] DEFAULT_EXCLUDES = new String[0];
    private File inputDir;
    private String compilationLevel;
    private String warningLevel;
    private String encoding;
    private boolean failOnWarning = false;
    private String suffix;
    private String[] includes;
    private String[] excludes;
    private Aggregation aggregation;
    private List<ResourcesSet> resourcesSets;
    private long originalFilesSize = 0L;
    private long optimizedFilesSize = 0L;
    boolean resFound = false;

    public void execute() throws MojoExecutionException, MojoFailureException {
        block17: {
            this.getLog().info((CharSequence)"Optimization of resources is started ...");
            try {
                if (this.resourcesSets == null || this.resourcesSets.isEmpty()) {
                    String[] incls = this.includes != null && this.includes.length > 0 ? this.includes : DEFAULT_INCLUDES;
                    String[] excls = this.excludes != null && this.excludes.length > 0 ? this.excludes : DEFAULT_EXCLUDES;
                    Aggregation aggr = this.checkAggregation(this.aggregation) ? null : this.aggregation;
                    ResourcesScanner scanner = new ResourcesScanner();
                    scanner.scan(this.inputDir, incls, excls);
                    if (aggr != null && aggr.getOutputFile() == null) {
                        File[] files = this.inputDir.listFiles();
                        if (files != null) {
                            for (File file : files) {
                                Set<File> subDirJsFiles;
                                if (!file.isDirectory()) continue;
                                ResourcesScanner subDirScanner = new ResourcesScanner();
                                subDirScanner.scan(file, DEFAULT_INCLUDES, DEFAULT_EXCLUDES);
                                Set<File> subDirCssFiles = this.filterSubDirFiles(scanner.getCssFiles(), subDirScanner.getCssFiles());
                                if (!subDirCssFiles.isEmpty()) {
                                    this.processCssFiles(file, subDirCssFiles, this.getSubDirAggregation(file, aggr, "css"), null);
                                }
                                if ((subDirJsFiles = this.filterSubDirFiles(scanner.getJsFiles(), subDirScanner.getJsFiles())).isEmpty()) continue;
                                this.processJsFiles(file, subDirJsFiles, this.getCompilationLevel(this.compilationLevel), this.getWarningLevel(this.warningLevel), this.getSubDirAggregation(file, aggr, "js"), null);
                            }
                        }
                    } else {
                        if (!scanner.getCssFiles().isEmpty()) {
                            this.processCssFiles(this.inputDir, scanner.getCssFiles(), aggr, this.suffix);
                        }
                        if (!scanner.getJsFiles().isEmpty()) {
                            this.processJsFiles(this.inputDir, scanner.getJsFiles(), this.getCompilationLevel(this.compilationLevel), this.getWarningLevel(this.warningLevel), aggr, this.suffix);
                        }
                    }
                    break block17;
                }
                for (ResourcesSet rs : this.resourcesSets) {
                    File dir;
                    File file = dir = rs.getInputDir() != null ? rs.getInputDir() : this.inputDir;
                    String[] incls = rs.getIncludes() != null && rs.getIncludes().length > 0 ? rs.getIncludes() : (this.includes != null && this.includes.length > 0 ? this.includes : DEFAULT_INCLUDES);
                    String[] excls = rs.getExcludes() != null && rs.getExcludes().length > 0 ? rs.getExcludes() : (this.excludes != null && this.excludes.length > 0 ? this.excludes : DEFAULT_EXCLUDES);
                    Object aggr = this.checkAggregation(rs.getAggregation()) ? (this.checkAggregation(this.aggregation) ? null : this.aggregation) : rs.getAggregation();
                    ResourcesScanner scanner = new ResourcesScanner();
                    scanner.scan(dir, incls, excls);
                    if (aggr != null && ((Aggregation)aggr).getOutputFile() == null) {
                        File[] files = dir.listFiles();
                        if (files == null) continue;
                        for (File file2 : files) {
                            Set<File> subDirJsFiles;
                            if (!file2.isDirectory()) continue;
                            ResourcesScanner subDirScanner = new ResourcesScanner();
                            subDirScanner.scan(file2, DEFAULT_INCLUDES, DEFAULT_EXCLUDES);
                            Set<File> subDirCssFiles = this.filterSubDirFiles(scanner.getCssFiles(), subDirScanner.getCssFiles());
                            if (!subDirCssFiles.isEmpty()) {
                                this.processCssFiles(file2, subDirCssFiles, this.getSubDirAggregation(file2, (Aggregation)aggr, "css"), null);
                            }
                            if ((subDirJsFiles = this.filterSubDirFiles(scanner.getJsFiles(), subDirScanner.getJsFiles())).isEmpty()) continue;
                            CompilationLevel compLevel = rs.getCompilationLevel() != null ? this.getCompilationLevel(rs.getCompilationLevel()) : this.getCompilationLevel(this.compilationLevel);
                            WarningLevel warnLevel = rs.getWarningLevel() != null ? this.getWarningLevel(rs.getWarningLevel()) : this.getWarningLevel(this.warningLevel);
                            this.processJsFiles(file2, subDirJsFiles, compLevel, warnLevel, this.getSubDirAggregation(file2, (Aggregation)aggr, "js"), null);
                        }
                        continue;
                    }
                    if (!scanner.getCssFiles().isEmpty()) {
                        this.processCssFiles(dir, scanner.getCssFiles(), (Aggregation)aggr, this.suffix);
                    }
                    if (scanner.getJsFiles().isEmpty()) continue;
                    CompilationLevel compLevel = rs.getCompilationLevel() != null ? this.getCompilationLevel(rs.getCompilationLevel()) : this.getCompilationLevel(this.compilationLevel);
                    WarningLevel warnLevel = rs.getWarningLevel() != null ? this.getWarningLevel(rs.getWarningLevel()) : this.getWarningLevel(this.warningLevel);
                    this.processJsFiles(dir, scanner.getJsFiles(), compLevel, warnLevel, (Aggregation)aggr, this.suffix);
                }
            }
            catch (MojoExecutionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error while executing the mojo " + ((Object)((Object)this)).getClass(), e);
            }
        }
        if (!this.resFound) {
            this.getLog().info((CharSequence)"No resources found for optimization.");
            return;
        }
        this.getLog().info((CharSequence)"Optimization of resources has been finished successfully.");
        this.outputStatistic();
    }

    private void processCssFiles(File inputDir, Set<File> cssFiles, Aggregation aggr, String suffix) throws MojoExecutionException {
        this.resFound = true;
        ResourcesSetAdapter rsa = new ResourcesSetAdapter(inputDir, cssFiles, null, null, aggr, this.encoding, this.failOnWarning, suffix);
        YuiCompressorOptimizer yuiOptimizer = new YuiCompressorOptimizer();
        yuiOptimizer.optimize(rsa, this.getLog());
        this.originalFilesSize += yuiOptimizer.getTotalOriginalSize();
        this.optimizedFilesSize += yuiOptimizer.getTotalOptimizedSize();
    }

    private void processJsFiles(File inputDir, Set<File> jsFiles, CompilationLevel compilationLevel, WarningLevel warningLevel, Aggregation aggr, String suffix) throws MojoExecutionException {
        this.resFound = true;
        ResourcesSetAdapter rsa = new ResourcesSetAdapter(inputDir, jsFiles, compilationLevel, warningLevel, aggr, this.encoding, this.failOnWarning, suffix);
        ClosureCompilerOptimizer closureOptimizer = new ClosureCompilerOptimizer();
        closureOptimizer.optimize(rsa, this.getLog());
        this.originalFilesSize += closureOptimizer.getTotalOriginalSize();
        this.optimizedFilesSize += closureOptimizer.getTotalOptimizedSize();
    }

    private boolean checkAggregation(Aggregation aggregation) throws MojoExecutionException {
        if (aggregation == null) {
            return true;
        }
        if (aggregation.isSubDirMode() && aggregation.getOutputFile() != null) {
            String errMsg = "At least one aggregation tag is ambiguous because both 'subDirMode' and 'outputFile' were set";
            if (this.failOnWarning) {
                throw new MojoExecutionException("At least one aggregation tag is ambiguous because both 'subDirMode' and 'outputFile' were set");
            }
            this.getLog().warn((CharSequence)"At least one aggregation tag is ambiguous because both 'subDirMode' and 'outputFile' were set");
            this.getLog().warn((CharSequence)"Using 'outputFile' as aggregation");
            aggregation.setSubDirMode(false);
            return false;
        }
        if (!aggregation.isSubDirMode() && aggregation.getOutputFile() == null) {
            String errMsg = "An aggregation tag is available, but no valid aggregation was configured. Check 'subDirMode' and 'outputFile'";
            if (this.failOnWarning) {
                throw new MojoExecutionException("An aggregation tag is available, but no valid aggregation was configured. Check 'subDirMode' and 'outputFile'");
            }
            this.getLog().warn((CharSequence)"An aggregation tag is available, but no valid aggregation was configured. Check 'subDirMode' and 'outputFile'");
            return true;
        }
        return false;
    }

    private Aggregation getSubDirAggregation(File dir, Aggregation aggr, String fileExtension) {
        Aggregation subDirAggr = new Aggregation();
        subDirAggr.setPrependedFile(aggr.getPrependedFile());
        subDirAggr.setRemoveIncluded(aggr.isRemoveIncluded());
        subDirAggr.setWithoutCompress(aggr.isWithoutCompress());
        subDirAggr.setSubDirMode(true);
        File outputFile = new File(dir, dir.getName() + "." + fileExtension);
        subDirAggr.setOutputFile(outputFile);
        return subDirAggr;
    }

    private CompilationLevel getCompilationLevel(String compilationLevel) throws MojoExecutionException {
        try {
            return CompilationLevel.valueOf((String)compilationLevel);
        }
        catch (Exception e) {
            String errMsg = "Compilation level '" + compilationLevel + "' is wrong. Valid constants are: 'WHITESPACE_ONLY', 'SIMPLE_OPTIMIZATIONS', 'ADVANCED_OPTIMIZATIONS'";
            if (this.failOnWarning) {
                throw new MojoExecutionException(errMsg);
            }
            this.getLog().warn((CharSequence)errMsg);
            this.getLog().warn((CharSequence)"Using 'SIMPLE_OPTIMIZATIONS' as compilation level");
            return CompilationLevel.SIMPLE_OPTIMIZATIONS;
        }
    }

    private WarningLevel getWarningLevel(String warningLevel) throws MojoExecutionException {
        try {
            return WarningLevel.valueOf((String)warningLevel);
        }
        catch (Exception e) {
            String errMsg = "Warning level '" + warningLevel + "' is wrong. Valid constants are: 'QUIET', 'DEFAULT', 'VERBOSE'";
            if (this.failOnWarning) {
                throw new MojoExecutionException(errMsg);
            }
            this.getLog().warn((CharSequence)errMsg);
            this.getLog().warn((CharSequence)"Using 'QUIET' as warning level");
            return WarningLevel.QUIET;
        }
    }

    private Set<File> filterSubDirFiles(Set<File> resSetFiles, Set<File> subDirFiles) {
        LinkedHashSet<File> filteredFiles = new LinkedHashSet<File>();
        if (subDirFiles == null || subDirFiles.isEmpty() || resSetFiles == null || resSetFiles.isEmpty()) {
            return filteredFiles;
        }
        for (File subDirFile : subDirFiles) {
            if (!resSetFiles.contains(subDirFile)) continue;
            filteredFiles.add(subDirFile);
        }
        return filteredFiles;
    }

    private void outputStatistic() {
        long oneMB = 0x100000L;
        String originalSizeTotal = this.originalFilesSize <= 1024L ? this.originalFilesSize + " Bytes" : (this.originalFilesSize <= oneMB ? this.round((double)this.originalFilesSize / 1024.0, 3) + " KB" : this.round((double)this.originalFilesSize / (double)oneMB, 3) + " MB");
        String optimizedSizeTotal = this.optimizedFilesSize <= 1024L ? this.optimizedFilesSize + " Bytes" : (this.optimizedFilesSize <= oneMB ? this.round((double)this.optimizedFilesSize / 1024.0, 3) + " KB" : this.round((double)this.optimizedFilesSize / (double)oneMB, 3) + " MB");
        if (this.originalFilesSize > 0L) {
            this.getLog().info((CharSequence)"=== Statistic ===========================================");
            this.getLog().info((CharSequence)("Size of original resources = " + originalSizeTotal));
            this.getLog().info((CharSequence)("Size of optimized resources = " + optimizedSizeTotal));
            this.getLog().info((CharSequence)("Optimized resources have " + this.round((double)this.optimizedFilesSize * 100.0 / (double)this.originalFilesSize, 2) + "% of original size"));
            this.getLog().info((CharSequence)"=========================================================");
        }
    }

    private double round(double value, int places) {
        double roundedValue = 0.0;
        double factor = Math.pow(10.0, places);
        double temp = (double)Math.round(value * factor * factor) / factor;
        roundedValue = (double)Math.round(temp) / factor;
        return roundedValue;
    }
}

