/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.optimizerplugin;

import com.google.common.io.Files;
import com.yahoo.platform.yui.compressor.CssCompressor;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.primefaces.extensions.optimizerplugin.AbstractOptimizer;
import org.primefaces.extensions.optimizerplugin.ResourcesSetAdapter;

public class YuiCompressorOptimizer
extends AbstractOptimizer {
    private static final String OPTIMIZED_FILE_EXTENSION = ".optcss";

    @Override
    public void optimize(ResourcesSetAdapter rsa, Log log) throws MojoExecutionException {
        InputStreamReader in = null;
        OutputStreamWriter out = null;
        try {
            if (rsa.getAggregation() == null) {
                for (File file : rsa.getFiles()) {
                    log.info((CharSequence)("Optimize CSS file " + file.getName() + " ..."));
                    this.addToOriginalSize(file);
                    in = new InputStreamReader((InputStream)new FileInputStream(file), rsa.getEncoding());
                    String path = file.getCanonicalPath();
                    if (StringUtils.isNotBlank((String)rsa.getSuffix())) {
                        File outputFile = this.getFileWithSuffix(path, rsa.getSuffix());
                        out = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), rsa.getEncoding());
                        CssCompressor compressor = new CssCompressor((Reader)in);
                        compressor.compress((Writer)out, 500);
                        this.closeStreams(in, out);
                        this.addToOptimizedSize(outputFile);
                        continue;
                    }
                    String pathOptimized = FileUtils.removeExtension((String)path) + OPTIMIZED_FILE_EXTENSION;
                    File outputFile = new File(pathOptimized);
                    Files.touch((File)outputFile);
                    out = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), rsa.getEncoding());
                    CssCompressor compressor = new CssCompressor((Reader)in);
                    compressor.compress((Writer)out, 500);
                    this.closeStreams(in, out);
                    FileUtils.rename((File)outputFile, (File)file);
                    this.addToOptimizedSize(file);
                }
            } else if (rsa.getAggregation().getOutputFile() != null) {
                File outputFile;
                Charset cset = Charset.forName(rsa.getEncoding());
                if (!rsa.getAggregation().isWithoutCompress()) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, rsa.getEncoding());
                    for (File file : rsa.getFiles()) {
                        log.info((CharSequence)("Optimize CSS file " + file.getName() + " ..."));
                        this.addToOriginalSize(file);
                        in = new InputStreamReader((InputStream)new FileInputStream(file), rsa.getEncoding());
                        CssCompressor compressor = new CssCompressor((Reader)in);
                        compressor.compress((Writer)osw, 500);
                        IOUtil.close((Reader)in);
                    }
                    IOUtil.close((Writer)osw);
                    int filesCount = rsa.getFiles().size();
                    if (rsa.getAggregation().getPrependedFile() != null) {
                        ++filesCount;
                    }
                    if (filesCount > 1) {
                        log.info((CharSequence)"Aggregation is running ...");
                    }
                    outputFile = this.getOutputFile(rsa);
                    long sizeBefore = outputFile.length();
                    if (rsa.getAggregation().getPrependedFile() != null) {
                        this.prependFile(rsa.getAggregation().getPrependedFile(), outputFile, cset, rsa.getEncoding());
                    }
                    Files.append((CharSequence)baos.toString(rsa.getEncoding()), (File)outputFile, (Charset)cset);
                    this.addToOptimizedSize(outputFile.length() - sizeBefore);
                    if (filesCount > 1) {
                        log.info((CharSequence)(filesCount + " files were successfully aggregated."));
                    }
                } else {
                    outputFile = this.aggregateFiles(rsa, cset, log);
                }
                this.deleteFilesIfNecessary(rsa, log);
                this.renameOutputFileIfNecessary(rsa, outputFile);
            } else {
                log.error((CharSequence)"Wrong plugin's internal state.");
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Resources optimization failure: " + e.getLocalizedMessage(), e);
        }
        finally {
            this.closeStreams(in, out);
        }
    }

    protected void closeStreams(Reader in, Writer out) {
        IOUtil.close((Reader)in);
        IOUtil.close((Writer)out);
    }
}

