/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.optimizerplugin.optimizer;

import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.primefaces.extensions.optimizerplugin.util.ResourcesSetAdapter;

public abstract class AbstractOptimizer {
    protected static final String OUTPUT_FILE_SUFFIX = ".source";
    private long sizeTotalOriginal = 0L;
    private long sizeTotalOptimized = 0L;

    public abstract void optimize(ResourcesSetAdapter var1, Log var2) throws MojoExecutionException;

    public long getTotalOriginalSize() {
        return this.sizeTotalOriginal;
    }

    public long getTotalOptimizedSize() {
        return this.sizeTotalOptimized;
    }

    protected File getFileWithSuffix(String path, String suffix) throws IOException {
        String extension = FileUtils.extension((String)path);
        if (StringUtils.isNotEmpty((String)extension)) {
            extension = "." + extension;
        }
        String pathSuffix = FileUtils.removeExtension((String)path) + suffix + extension;
        File outputFile = new File(pathSuffix);
        Files.touch((File)outputFile);
        return outputFile;
    }

    protected File aggregateFiles(ResourcesSetAdapter rsa, Charset cset, boolean delimeters) throws IOException {
        File outputFile = this.getOutputFile(rsa);
        if (rsa.getAggregation().getPrependedFile() != null) {
            this.prependFile(rsa.getAggregation().getPrependedFile(), outputFile, cset, rsa);
        }
        for (File file : rsa.getFiles()) {
            Reader in = this.getReader(rsa, file);
            StringWriter writer = new StringWriter();
            IOUtil.copy((Reader)in, (Writer)writer);
            if (delimeters && outputFile.length() > 0L) {
                Files.asCharSink((File)outputFile, (Charset)cset, (FileWriteMode[])new FileWriteMode[]{FileWriteMode.APPEND}).write((CharSequence)";");
            }
            Files.asCharSink((File)outputFile, (Charset)cset, (FileWriteMode[])new FileWriteMode[]{FileWriteMode.APPEND}).write((CharSequence)writer.toString());
            IOUtil.close((Reader)in);
        }
        return outputFile;
    }

    protected void deleteFilesIfNecessary(ResourcesSetAdapter rsa, Log log) {
        if (rsa.getAggregation().isRemoveIncluded() && rsa.getFiles().size() > 0) {
            for (File file : rsa.getFiles()) {
                if (!file.exists() || file.delete()) continue;
                log.warn((CharSequence)("File " + file.getName() + " could not be deleted after aggregation."));
            }
        }
    }

    protected void deleteDirectoryIfNecessary(ResourcesSetAdapter rsa, Log log) {
        if (rsa.getAggregation().isRemoveEmptyDirectories() && rsa.getFiles().size() > 0) {
            for (File file : rsa.getFiles()) {
                File directory;
                File file2 = directory = file.isDirectory() ? file : file.getParentFile();
                while (directory != null && directory.isDirectory() && directory.listFiles().length == 0) {
                    if (!directory.delete()) {
                        log.warn((CharSequence)("File " + file.getName() + " could not be deleted after aggregation."));
                    }
                    directory = directory.getParentFile();
                }
            }
        }
    }

    protected void renameOutputFileIfNecessary(ResourcesSetAdapter rsa, File outputFile) throws IOException {
        if (outputFile != null && outputFile.exists()) {
            FileUtils.rename((File)outputFile, (File)rsa.getAggregation().getOutputFile());
        }
    }

    protected void prependFile(File prependedFile, File outputFile, Charset cset, ResourcesSetAdapter rsa) throws IOException {
        Reader in = this.getReader(rsa, prependedFile);
        StringWriter writer = new StringWriter();
        IOUtil.copy((Reader)in, (Writer)writer);
        writer.write(System.getProperty("line.separator"));
        Files.asCharSink((File)outputFile, (Charset)cset, (FileWriteMode[])new FileWriteMode[]{FileWriteMode.APPEND}).write((CharSequence)writer.toString());
        IOUtil.close((Reader)in);
    }

    protected File getOutputFile(ResourcesSetAdapter rsa) throws IOException {
        File outputFile = rsa.getAggregation().getOutputFile();
        String extension = FileUtils.extension((String)outputFile.getName());
        if (StringUtils.isNotEmpty((String)extension)) {
            extension = "." + extension;
        }
        String pathSuffix = FileUtils.removeExtension((String)outputFile.getCanonicalPath()) + OUTPUT_FILE_SUFFIX + extension;
        File aggrFile = new File(pathSuffix);
        Files.createParentDirs((File)aggrFile);
        Files.touch((File)aggrFile);
        return aggrFile;
    }

    protected Reader getReader(ResourcesSetAdapter rsAdapter, File file) throws FileNotFoundException, UnsupportedEncodingException {
        return new InputStreamReader((InputStream)new FileInputStream(file), rsAdapter.getEncoding());
    }

    protected long addToOriginalSize(File file) {
        long lenght = file.length();
        this.sizeTotalOriginal += lenght;
        return lenght;
    }

    protected void addToOptimizedSize(File file) {
        this.sizeTotalOptimized += file.length();
    }

    protected void addToOptimizedSize(long size) {
        this.sizeTotalOptimized += size;
    }
}

