/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.optimizerplugin.optimizer;

import com.google.common.collect.ImmutableList;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.SourceMap;
import com.google.javascript.jscomp.WarningLevel;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.primefaces.extensions.optimizerplugin.optimizer.AbstractOptimizer;
import org.primefaces.extensions.optimizerplugin.util.ResourcesSetAdapter;
import org.primefaces.extensions.optimizerplugin.util.ResourcesSetJsAdapter;

public class ClosureCompilerOptimizer
extends AbstractOptimizer {
    private static final List<SourceFile> EXTERNS_EMPTY = new ArrayList<SourceFile>();
    private static final String OPTIMIZED_FILE_EXTENSION = ".optjs";
    private static final String SOURCE_MAP_FILE_EXTENSION = ".map";

    @Override
    public void optimize(ResourcesSetAdapter rsAdapter, Log log) throws MojoExecutionException {
        ResourcesSetJsAdapter rsa = (ResourcesSetJsAdapter)rsAdapter;
        CompilationLevel compLevel = rsa.getCompilationLevel();
        CompilerOptions options = new CompilerOptions();
        compLevel.setOptionsForCompilationLevel(options);
        WarningLevel warnLevel = rsa.getWarningLevel();
        warnLevel.setOptionsForWarningLevel(options);
        CompilerOptions.LanguageMode langIn = rsa.getLanguageIn();
        options.setLanguageIn(langIn);
        CompilerOptions.LanguageMode langOut = rsa.getLanguageOut();
        options.setLanguageOut(langOut);
        Compiler.setLoggingLevel((Level)Level.WARNING);
        try {
            Charset cset = Charset.forName(rsa.getEncoding());
            if (rsa.getAggregation() == null) {
                for (File file : rsa.getFiles()) {
                    File sourceFile;
                    log.info((CharSequence)("Optimize JS file " + file.getName() + " ..."));
                    this.addToOriginalSize(file);
                    String path = file.getCanonicalPath();
                    String outputFilePath = null;
                    String outputSourceMapDir = null;
                    File sourceMapFile = null;
                    if (rsa.getSourceMap() != null) {
                        outputFilePath = file.getCanonicalPath();
                        outputSourceMapDir = rsa.getSourceMap().getOutputDir();
                        sourceMapFile = this.setupSourceMapFile(options, rsa.getSourceMap(), outputFilePath);
                        sourceFile = this.getFileWithSuffix(path, ".source");
                        if (StringUtils.isNotBlank((String)rsa.getSuffix())) {
                            FileUtils.rename((File)file, (File)sourceFile);
                        } else {
                            FileUtils.copyFile((File)file, (File)sourceFile);
                        }
                    } else {
                        sourceFile = file;
                    }
                    ArrayList<SourceFile> interns = new ArrayList<SourceFile>();
                    interns.add(SourceFile.fromPath((Path)sourceFile.toPath(), (Charset)cset));
                    Compiler compiler = this.compile(log, interns, options, rsa.isFailOnWarning());
                    if (StringUtils.isNotBlank((String)rsa.getSuffix())) {
                        File outputFile = this.getFileWithSuffix(path, rsa.getSuffix());
                        Files.asCharSink((File)outputFile, (Charset)cset, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)compiler.toSource());
                        if (sourceMapFile != null) {
                            this.writeSourceMappingURL(outputFile, sourceMapFile, rsa.getSourceMap().getSourceMapRoot(), cset, log);
                        }
                        this.addToOptimizedSize(outputFile);
                    } else {
                        String pathOptimized = FileUtils.removeExtension((String)path) + OPTIMIZED_FILE_EXTENSION;
                        File outputFile = new File(pathOptimized);
                        Files.touch((File)outputFile);
                        Files.asCharSink((File)outputFile, (Charset)cset, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)compiler.toSource());
                        FileUtils.rename((File)outputFile, (File)file);
                        if (sourceMapFile != null) {
                            this.writeSourceMappingURL(file, sourceMapFile, rsa.getSourceMap().getSourceMapRoot(), cset, log);
                        }
                        this.addToOptimizedSize(file);
                    }
                    if (outputFilePath == null || sourceMapFile == null) continue;
                    Files.touch((File)sourceMapFile);
                    this.writeSourceMap(sourceMapFile, outputFilePath, compiler.getSourceMap(), outputSourceMapDir, log);
                    this.moveToSourceMapDir(sourceFile, outputSourceMapDir, log);
                }
            } else if (rsa.getAggregation().getOutputFile() != null) {
                File outputFile = rsa.getAggregation().getOutputFile();
                File aggrOutputFile = this.aggregateFiles(rsa, cset, true);
                long sizeBefore = this.addToOriginalSize(aggrOutputFile);
                if (!rsa.getAggregation().isWithoutCompress()) {
                    for (File file : rsa.getFiles()) {
                        log.info((CharSequence)("Optimize JS file " + file.getName() + " ..."));
                    }
                    String outputFilePath = null;
                    File sourceMapFile = null;
                    if (rsa.getSourceMap() != null) {
                        outputFilePath = outputFile.getCanonicalPath();
                        sourceMapFile = this.setupSourceMapFile(options, rsa.getSourceMap(), outputFilePath);
                    }
                    ArrayList<SourceFile> interns = new ArrayList<SourceFile>();
                    interns.add(SourceFile.fromPath((Path)aggrOutputFile.toPath(), (Charset)cset));
                    Compiler compiler = this.compile(log, interns, options, rsa.isFailOnWarning());
                    this.deleteFilesIfNecessary(rsa, log);
                    this.deleteDirectoryIfNecessary(rsa, log);
                    Files.touch((File)outputFile);
                    Files.asCharSink((File)outputFile, (Charset)cset, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)compiler.toSource());
                    if (outputFilePath != null && sourceMapFile != null) {
                        this.writeSourceMappingURL(outputFile, sourceMapFile, rsa.getSourceMap().getSourceMapRoot(), cset, log);
                        String outputSourceMapDir = rsa.getSourceMap().getOutputDir();
                        Files.touch((File)sourceMapFile);
                        this.writeSourceMap(sourceMapFile, outputFilePath, compiler.getSourceMap(), outputSourceMapDir, log);
                        this.moveToSourceMapDir(aggrOutputFile, outputSourceMapDir, log);
                    } else if (aggrOutputFile.exists() && !aggrOutputFile.delete()) {
                        log.warn((CharSequence)("Temporary file " + aggrOutputFile.getName() + " could not be deleted."));
                    }
                    this.addToOptimizedSize(sizeBefore - outputFile.length());
                } else {
                    this.deleteFilesIfNecessary(rsa, log);
                    this.deleteDirectoryIfNecessary(rsa, log);
                    this.renameOutputFileIfNecessary(rsa, aggrOutputFile);
                    this.addToOptimizedSize(sizeBefore);
                }
            } else {
                log.error((CharSequence)"Wrong plugin's internal state.");
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Resources optimization failure: " + e.getLocalizedMessage(), e);
        }
    }

    protected Compiler compile(Log log, List<SourceFile> interns, CompilerOptions options, boolean failOnWarning) throws MojoExecutionException {
        Compiler compiler = new Compiler();
        Result result = compiler.compile(EXTERNS_EMPTY, interns, options);
        this.evalResult(result, log, failOnWarning);
        return compiler;
    }

    protected void evalResult(Result result, Log log, boolean failOnWarning) throws MojoExecutionException {
        if (result.warnings != null) {
            for (JSError warning : result.warnings) {
                log.warn((CharSequence)warning.toString());
            }
        }
        if (result.warnings != null && result.warnings.size() > 0 && failOnWarning) {
            throw new MojoExecutionException("Resources optimization failure. Please fix warnings and try again.");
        }
        if (result.errors != null) {
            for (JSError error : result.errors) {
                log.error((CharSequence)error.toString());
            }
        }
        if (result.errors != null && result.errors.size() > 0) {
            throw new MojoExecutionException("Resources optimization failure. Please fix errors and try again.");
        }
        if (!result.success) {
            throw new MojoExecutionException("Resources optimization failure. Please fix errors and try again.");
        }
    }

    private File setupSourceMapFile(CompilerOptions options, org.primefaces.extensions.optimizerplugin.model.SourceMap sourceMap, String outputFilePath) throws IOException {
        options.setSourceMapDetailLevel(SourceMap.DetailLevel.valueOf((String)sourceMap.getDetailLevel()));
        options.setSourceMapFormat(SourceMap.Format.valueOf((String)sourceMap.getFormat()));
        File sourceMapFile = new File(outputFilePath + SOURCE_MAP_FILE_EXTENSION);
        options.setSourceMapOutputPath(sourceMapFile.getCanonicalPath());
        String prefix = outputFilePath.substring(0, outputFilePath.lastIndexOf(File.separator) + 1);
        if (File.separatorChar == '\\') {
            prefix = prefix.replace('\\', '/');
        }
        ImmutableList sourceMapLocationMappings = ImmutableList.of((Object)new SourceMap.PrefixLocationMapping(prefix, ""));
        options.setSourceMapLocationMappings((List)sourceMapLocationMappings);
        return sourceMapFile;
    }

    private void writeSourceMap(File sourceMapFile, String sourceFileName, SourceMap sourceMap, String outputDir, Log log) {
        try {
            FileWriter out = new FileWriter(sourceMapFile);
            sourceMap.appendTo((Appendable)out, sourceFileName);
            out.flush();
            IOUtil.close((Writer)out);
        }
        catch (Exception e) {
            log.error((CharSequence)("Failed to write an JavaScript Source Map file for " + sourceFileName), (Throwable)e);
        }
        this.moveToSourceMapDir(sourceMapFile, outputDir, log);
    }

    private void moveToSourceMapDir(File file, String outputDir, Log log) {
        try {
            String name = file.getName();
            String target = outputDir + name;
            File targetFile = new File(target);
            if (!file.equals(targetFile)) {
                Files.createParentDirs((File)targetFile);
                Files.move((File)file, (File)targetFile);
            }
        }
        catch (Exception e) {
            log.error((CharSequence)("File " + file + " could not be moved to " + outputDir), (Throwable)e);
        }
    }

    private void writeSourceMappingURL(File minifiedFile, File sourceMapFile, String sourceMapRoot, Charset cset, Log log) {
        try {
            String smRoot = sourceMapRoot != null ? sourceMapRoot : "";
            Files.asCharSink((File)minifiedFile, (Charset)cset, (FileWriteMode[])new FileWriteMode[]{FileWriteMode.APPEND}).write((CharSequence)System.getProperty("line.separator"));
            Files.asCharSink((File)minifiedFile, (Charset)cset, (FileWriteMode[])new FileWriteMode[]{FileWriteMode.APPEND}).write((CharSequence)("//# sourceMappingURL=" + smRoot + sourceMapFile.getName()));
        }
        catch (IOException e) {
            log.error((CharSequence)("//# sourceMappingURL for the minified file " + minifiedFile + " could not be written"), (Throwable)e);
        }
    }
}

