/*
 * Decompiled with CFR 0.152.
 */
package org.probato.api;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.DisplayNameGeneration;
import org.junit.jupiter.api.DynamicNode;
import org.junit.jupiter.api.TestFactory;
import org.junit.jupiter.api.extension.ExtendWith;
import org.probato.Probato;
import org.probato.api.Dataset;
import org.probato.junit.SuiteFactoryDisplayNameGenerator;
import org.probato.junit.TestanoForJUnit5;
import org.probato.node.TestNodeService;

@DisplayNameGeneration(value=SuiteFactoryDisplayNameGenerator.class)
@ExtendWith(value={TestanoForJUnit5.class})
public interface TestSuite {
    @TestFactory
    @DisplayName(value="Test cases")
    default public Stream<DynamicNode> buildTestCase() {
        return Probato.getTestsCase(this.getClass()).map(this::buildScriptTestNode);
    }

    default public DynamicNode buildScriptTestNode(Class<?> scriptClazz) {
        return Probato.loadScript(scriptClazz).map(item -> TestNodeService.createScriptTestNode(item, this.buildDatasetTestNode(scriptClazz))).orElse(TestNodeService.createScriptTestNode(scriptClazz, this.buildDatasetTestNode(scriptClazz)));
    }

    default public List<DynamicNode> buildDatasetTestNode(Class<?> scriptClazz) {
        return Probato.loadDataset(scriptClazz).map(dataset -> this.buildDatasetTestNode(scriptClazz, (Dataset)dataset)).orElse(this.buildTestNode(scriptClazz, 0));
    }

    default public List<DynamicNode> buildDatasetTestNode(Class<?> scriptClazz, Dataset dataset) {
        ArrayList<DynamicNode> list = new ArrayList<DynamicNode>();
        IntStream.range(0, Probato.getCsvCounterLines((Dataset)dataset)).forEach(numberLine -> list.add(TestNodeService.createDatasetTestNode(++numberLine, this.buildTestNode(scriptClazz, numberLine))));
        if (list.isEmpty()) {
            list.addAll(this.buildTestNode(scriptClazz, 0));
        }
        return list;
    }

    default public List<DynamicNode> buildTestNode(Class<?> scriptClazz, Integer datasetLine) {
        ArrayList<DynamicNode> list = new ArrayList<DynamicNode>();
        Probato.loadBrowsers(this.getClass()).map(browser -> TestNodeService.createBrowserTestNode(this.getClass(), scriptClazz, browser, datasetLine)).forEach(list::add);
        return list;
    }
}

