/*
 * Decompiled with CFR 0.152.
 */
package org.probato.junit;

import java.lang.reflect.Method;
import java.text.MessageFormat;
import org.junit.jupiter.api.DisplayNameGenerator;
import org.probato.loader.AnnotationLoader;

public final class SuiteFactoryDisplayNameGenerator
implements DisplayNameGenerator {
    private static final String SUITE_TEXT = "{0} - {1}";

    public String generateDisplayNameForClass(Class<?> suiteClazz) {
        return AnnotationLoader.getSuite(suiteClazz).map(suite -> this.buildText(SUITE_TEXT, suite.code(), suite.name())).orElse(suiteClazz.getSimpleName());
    }

    public String generateDisplayNameForNestedClass(Class<?> nestedClass) {
        return nestedClass.getSimpleName();
    }

    public String generateDisplayNameForMethod(Class<?> testClass, Method testMethod) {
        return testMethod.getName() + DisplayNameGenerator.parameterTypesAsString((Method)testMethod);
    }

    private String buildText(String pattern, Object ... params) {
        return MessageFormat.format(pattern, params);
    }
}

