/*
 * Decompiled with CFR 0.152.
 */
package org.probato.junit;

import java.lang.reflect.AnnotatedElement;
import java.util.Optional;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.probato.Probato;

public final class TestanoForJUnit5
implements BeforeAllCallback,
BeforeEachCallback,
AfterEachCallback,
AfterAllCallback,
ExecutionCondition {
    public void beforeAll(ExtensionContext context) throws Exception {
        context.getTestClass().ifPresent(Probato::init);
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        Probato.setup();
    }

    public void afterEach(ExtensionContext context) throws Exception {
        Probato.finish();
    }

    public void afterAll(ExtensionContext context) throws Exception {
        context.getTestClass().ifPresent(clazz -> Probato.destroy());
    }

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        ConditionEvaluationResult result = null;
        Optional element = context.getElement();
        result = element.isPresent() && this.isDisabled((AnnotatedElement)element.get()) ? this.getDisabled((AnnotatedElement)element.get()).map(Disabled::value).map(ConditionEvaluationResult::disabled).orElse(ConditionEvaluationResult.disabled((String)"")) : ConditionEvaluationResult.enabled((String)"");
        return result;
    }

    private boolean isDisabled(AnnotatedElement element) {
        return element.isAnnotationPresent(Disabled.class);
    }

    private Optional<Disabled> getDisabled(AnnotatedElement element) {
        return Optional.ofNullable(element.getAnnotation(Disabled.class));
    }
}

