/*
 * Decompiled with CFR 0.152.
 */
package org.probato.browser;

import java.util.Comparator;
import java.util.ServiceLoader;
import org.probato.exception.IntegrityException;
import org.probato.model.Browser;
import org.probato.model.type.BrowserType;

public interface BrowserService {
    public static final String BROWSER_IMPLEMENTATION_NOT_FOUND = "Browser implementation not found: {0}";

    public Object driver();

    public String getBrowserDescription();

    public String getBrowserVersion();

    public void run();

    public void destroy();

    public boolean accepted(BrowserType var1);

    public void browser(Browser var1);

    public static BrowserService getInstance(Browser browser) {
        return ServiceLoader.load(BrowserService.class).stream().map(ServiceLoader.Provider::get).filter(service -> service.accepted(browser.getType())).sorted(Comparator.comparing(service -> service.getClass().getPackageName().equals(BrowserService.class.getClass().getPackageName()), Comparator.reverseOrder())).map(service -> {
            service.browser(browser);
            return service;
        }).findFirst().orElseThrow(() -> new IntegrityException(BROWSER_IMPLEMENTATION_NOT_FOUND, new Object[]{browser.getType()}));
    }
}

