/*
 * Decompiled with CFR 0.152.
 */
package org.probato.dataset;

import com.opencsv.CSVReader;
import com.opencsv.bean.CsvToBean;
import com.opencsv.bean.CsvToBeanBuilder;
import com.opencsv.bean.HeaderColumnNameMappingStrategy;
import com.opencsv.bean.MappingStrategy;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.probato.api.Dataset;
import org.probato.dataset.DatasetService;
import org.probato.exception.IntegrityException;
import org.probato.model.Content;
import org.probato.model.Datamodel;

public class CsvDatasetService
implements DatasetService {
    private static final String MSG_LOAD_ERROR = "Load file ''{0}'' error: {1}";
    private static final String MSG_MUST_DEFAULT_CONSTRUCTOR = "Class must have default constructor: ''{0}''";

    @Override
    public int counterLines(Dataset dataset) {
        return this.getDatamodels(dataset).size();
    }

    @Override
    public List<Datamodel> getDatamodels(Dataset dataset) {
        return this.getDatamodels(dataset, Datamodel.class);
    }

    @Override
    public <T> List<T> getDatamodels(Dataset dataset, Class<T> clazz) {
        ArrayList models = new ArrayList();
        for (String path : dataset.value()) {
            try (FileReader reader = this.readFile(path);){
                models.addAll(this.getObjectMapperBuilder(reader, clazz).parse());
            }
            catch (Exception ex) {
                throw new IntegrityException(MSG_LOAD_ERROR, path, ex.getMessage());
            }
        }
        return models;
    }

    @Override
    public <T> T getDatamodel(Dataset dataset, Class<T> clazz, int index) {
        if (index >= 0) {
            return this.getDatamodels(dataset, clazz).get(index);
        }
        return this.newInstance(clazz);
    }

    @Override
    public Content getContent(Dataset dataset, int index) {
        if (index >= 0) {
            String[] headers = this.getContent(dataset).get(0);
            String[] data = this.getContent(dataset).get(index);
            return new Content(headers, data);
        }
        return this.newInstance(Content.class);
    }

    public List<String[]> getContent(Dataset dataset) {
        ArrayList<String[]> models = new ArrayList<String[]>();
        for (String path : dataset.value()) {
            try (FileReader reader = this.readFile(path);){
                models.addAll(new CSVReader((Reader)reader).readAll());
            }
            catch (Exception ex) {
                throw new IntegrityException(MSG_LOAD_ERROR, dataset.value(), ex.getMessage());
            }
        }
        return models;
    }

    private FileReader readFile(String path) throws FileNotFoundException, URISyntaxException {
        return new FileReader(this.getPath(path).toString());
    }

    private Path getPath(String path) throws URISyntaxException {
        return Paths.get(this.getURI(path));
    }

    private URI getURI(String path) throws URISyntaxException {
        return this.getURL(path).toURI();
    }

    private URL getURL(String url) {
        return Optional.ofNullable(ClassLoader.getSystemResource(url)).orElseThrow(() -> new IntegrityException("File not found", new Object[0]));
    }

    private <T> CsvToBean<T> getObjectMapperBuilder(FileReader reader, Class<T> clazz) {
        return new CsvToBeanBuilder((Reader)reader).withType(clazz).withMappingStrategy(this.getObjectMapperStrategy(clazz)).build();
    }

    private <T> MappingStrategy<T> getObjectMapperStrategy(Class<T> clazz) {
        HeaderColumnNameMappingStrategy strategy = new HeaderColumnNameMappingStrategy();
        strategy.setType(clazz);
        return strategy;
    }

    private <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IntegrityException(MSG_MUST_DEFAULT_CONSTRUCTOR, clazz.getName());
        }
    }
}

