/*
 * Decompiled with CFR 0.152.
 */
package org.probato.dataset;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.ServiceLoader;
import org.probato.api.Dataset;
import org.probato.exception.IntegrityException;
import org.probato.model.Content;
import org.probato.model.Datamodel;

public interface DatasetService {
    public static final String DATASET_SERVICE_IMPLEMENTATION_NOT_FOUND = "Dataset service implementation not found";
    public static final String MSG_MUST_DEFAULT_CONSTRUCTOR = "Class must have default constructor: ''{0}''";

    public int counterLines(Dataset var1);

    public List<Datamodel> getDatamodels(Dataset var1);

    public <T> List<T> getDatamodels(Dataset var1, Class<T> var2);

    public <T> T getDatamodel(Dataset var1, Class<T> var2, int var3);

    public Content getContent(Dataset var1, int var2);

    public static DatasetService getInstance() {
        return ServiceLoader.load(DatasetService.class).stream().map(ServiceLoader.Provider::get).sorted(Comparator.comparing(serviceClazz -> serviceClazz.getClass().getPackageName().equals(DatasetService.class.getClass().getPackageName()), Comparator.reverseOrder())).findFirst().orElse(DatasetService.newDefaultInstance());
    }

    public static DatasetService newDefaultInstance() {
        return new DatasetService(){

            @Override
            public <T> List<T> getDatamodels(Dataset dataset, Class<T> clazz) {
                return new ArrayList();
            }

            @Override
            public List<Datamodel> getDatamodels(Dataset dataset) {
                return new ArrayList<Datamodel>();
            }

            @Override
            public <T> T getDatamodel(Dataset dataset, Class<T> clazz, int index) {
                return this.newInstance(clazz);
            }

            @Override
            public Content getContent(Dataset dataset, int index) {
                return this.newInstance(Content.class);
            }

            @Override
            public int counterLines(Dataset dataset) {
                return 0;
            }

            private <T> T newInstance(Class<T> clazz) {
                try {
                    return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    throw new IntegrityException(DatasetService.MSG_MUST_DEFAULT_CONSTRUCTOR, clazz.getName());
                }
            }
        };
    }
}

