/*
 * Decompiled with CFR 0.152.
 */
package org.probato.engine.browser;

import java.time.ZonedDateTime;
import java.util.List;
import org.opentest4j.AssertionFailedError;
import org.probato.api.Postcondition;
import org.probato.api.Precondition;
import org.probato.api.Procedure;
import org.probato.browser.BrowserService;
import org.probato.datasource.DatasourceService;
import org.probato.engine.ScriptExecutor;
import org.probato.engine.execution.ExecutionContextHolder;
import org.probato.engine.execution.ExecutionService;
import org.probato.engine.execution.ProcedureExecutionService;
import org.probato.engine.execution.builder.Execution;
import org.probato.engine.execution.builder.Script;
import org.probato.engine.execution.builder.Suite;
import org.probato.exception.ImpeditiveException;
import org.probato.loader.AnnotationLoader;
import org.probato.model.Browser;
import org.probato.model.type.Evaluation;

public class BrowserScriptExecutionService
extends ScriptExecutor {
    private static final String IMPEDITIVE_MSG = "An error occurred while running preconditions: {0}";
    private List<DatasourceService> datasourcesService;
    private ProcedureExecutionService procedureExecutionService;
    private final Class<?> suiteClazz;
    private final Class<?> scriptClazz;
    private final Browser browser;
    private final Integer datasetLine;
    private BrowserService browserService;
    private ExecutionService executionService;
    private List<Object> preconditions;
    private List<Object> procedures;
    private List<Object> postconditions;
    private Suite.SuiteBuilder suiteBuilder;
    private Script.ScriptBuilder scriptBuilder;
    private Execution.ExecutionBuilder executionBuilder;

    public BrowserScriptExecutionService(Class<?> suiteClazz, Class<?> scriptClazz, Browser browser, Integer datasetLine) {
        this.suiteClazz = suiteClazz;
        this.scriptClazz = scriptClazz;
        this.browser = browser;
        this.datasetLine = datasetLine;
        this.datasourcesService = DatasourceService.getInstance();
        this.procedureExecutionService = new ProcedureExecutionService();
        this.browserService = BrowserService.getInstance(browser);
        this.executionService = ExecutionService.getInstance(scriptClazz);
    }

    @Override
    protected void init() {
        ExecutionContextHolder.clean();
        this.initProcedures();
        this.suiteBuilder = this.initSuiteBuilder();
        this.scriptBuilder = this.initScriptBuilder();
        this.executionBuilder = this.initExecutionBuilder();
    }

    @Override
    protected void execute() {
        try {
            this.browserService.run();
            this.executionBuilder.browser(this.browser, this.browserService.getBrowserDescription(), this.browserService.getBrowserVersion());
            this.executionBuilder.video(this.executionService.startRecording(this.browser.getDimension()));
            this.collectUseCaseData();
            this.loadSQL();
            this.executeUseCase();
            this.executionBuilder.evaluation(Evaluation.SUCCESS);
        }
        catch (Throwable ex) {
            this.executionBuilder.evaluation(this.getEvaluation(ex)).motive(ex).image(this.executionService.captureScreen(this.browser.getDimension()));
        }
        finally {
            this.executionService.endRecording();
        }
    }

    @Override
    protected void finish() {
        this.executionBuilder.end(ZonedDateTime.now());
        this.browserService.destroy();
        Suite suite = this.suiteBuilder.build();
        Script script = this.scriptBuilder.build();
        Execution execution = this.executionBuilder.build();
        this.executionService.save(suite, script, execution);
        if (Evaluation.FAILURE.equals((Object)execution.getEvaluation())) {
            throw new AssertionFailedError(execution.getMotive());
        }
        if (Evaluation.ERROR.equals((Object)execution.getEvaluation())) {
            throw new RuntimeException(execution.getMotive());
        }
        if (Evaluation.IMPEDITIVE.equals((Object)execution.getEvaluation())) {
            throw new AssertionFailedError(execution.getMotive());
        }
    }

    private Evaluation getEvaluation(Throwable ex) {
        Evaluation evaluation = null;
        evaluation = ex instanceof ImpeditiveException ? Evaluation.IMPEDITIVE : (ex instanceof Error ? Evaluation.FAILURE : (ex instanceof RuntimeException ? Evaluation.FAILURE : Evaluation.ERROR));
        return evaluation;
    }

    private Suite.SuiteBuilder initSuiteBuilder() {
        return Suite.builder().clazz(this.suiteClazz);
    }

    private Script.ScriptBuilder initScriptBuilder() {
        return Script.builder().clazz(this.suiteClazz, this.scriptClazz);
    }

    private Execution.ExecutionBuilder initExecutionBuilder() {
        return Execution.builder().project().env().id(this.executionService.getExecutionId()).suite(this.suiteClazz).script(this.scriptClazz).dataset(this.scriptClazz, this.datasetLine).sql(this.suiteClazz).sql(this.scriptClazz).start(ZonedDateTime.now());
    }

    private void initProcedures() {
        this.preconditions = AnnotationLoader.getProceduresScript(this.scriptClazz, Precondition.class);
        this.procedures = AnnotationLoader.getProceduresScript(this.scriptClazz, Procedure.class);
        this.postconditions = AnnotationLoader.getProceduresScript(this.scriptClazz, Postcondition.class);
    }

    private void collectUseCaseData() throws Throwable {
        ExecutionContextHolder.onCollectionMode();
        this.collectStepsPreconditions();
        this.collectStepsProcedures();
        this.collectStepsPostconditions();
        ExecutionContextHolder.offCollectionMode();
    }

    private void collectStepsPreconditions() throws Throwable {
        this.executeSteps(this.preconditions);
        this.scriptBuilder.preconditions(ExecutionContextHolder.getActions());
        this.executionBuilder.stepsPreconditions(ExecutionContextHolder.getSteps());
    }

    private void collectStepsProcedures() throws Throwable {
        this.executeSteps(this.procedures);
        this.scriptBuilder.procedures(ExecutionContextHolder.getActions());
        this.executionBuilder.stepsProcedures(ExecutionContextHolder.getSteps());
    }

    private void collectStepsPostconditions() throws Throwable {
        this.executeSteps(this.postconditions);
        this.scriptBuilder.postconditions(ExecutionContextHolder.getActions());
        this.executionBuilder.stepsPostconditions(ExecutionContextHolder.getSteps());
    }

    private void loadSQL() {
        this.datasourcesService.stream().forEach(service -> {
            service.run(this.suiteClazz);
            service.run(this.scriptClazz);
        });
    }

    private void executeUseCase() throws Throwable {
        ExecutionContextHolder.offCollectionMode();
        this.executePreconditions();
        this.executeProcedures();
        this.executePostconditions();
    }

    private void executePreconditions() throws Throwable {
        try {
            this.procedureExecutionService.execute(this.browserService.driver(), this.scriptClazz, this.datasetLine, this.preconditions);
        }
        catch (Exception ex) {
            throw new ImpeditiveException(IMPEDITIVE_MSG, ex.getMessage());
        }
        finally {
            this.executionBuilder.preconditions(ExecutionContextHolder.getActions());
        }
    }

    private void executeProcedures() throws Throwable {
        try {
            this.procedureExecutionService.execute(this.browserService.driver(), this.scriptClazz, this.datasetLine, this.procedures);
        }
        finally {
            this.executionBuilder.procedures(ExecutionContextHolder.getActions());
        }
    }

    private void executePostconditions() throws Throwable {
        try {
            this.procedureExecutionService.execute(this.browserService.driver(), this.scriptClazz, this.datasetLine, this.postconditions);
        }
        finally {
            this.executionBuilder.postconditions(ExecutionContextHolder.getActions());
        }
    }

    private void executeSteps(List<Object> procedures) throws Throwable {
        this.procedureExecutionService.execute(this.browserService.driver(), this.scriptClazz, this.datasetLine, procedures);
    }
}

