/*
 * Decompiled with CFR 0.152.
 */
package org.probato.engine.execution;

import java.util.ArrayList;
import java.util.List;
import org.probato.engine.execution.builder.Step;

public class ExecutionContextHolder {
    private static Long increment;
    private static String version;
    private static Integer indexAction;
    private static Integer indexStep;
    private static Object content;
    private static ThreadLocal<Boolean> collectionMode;
    private static ThreadLocal<Throwable> throwable;
    private static ThreadLocal<List<Step>> actions;
    private static ThreadLocal<List<Step>> steps;

    private ExecutionContextHolder() {
    }

    public static void setContent(Object content) {
        ExecutionContextHolder.content = content;
    }

    public static Object getContent() {
        return content;
    }

    public static void setIncrement(Long increment) {
        ExecutionContextHolder.increment = increment;
    }

    public static void setVersion(String version) {
        ExecutionContextHolder.version = version;
    }

    public static Long getIncrement() {
        return increment;
    }

    public static String getVersion() {
        return version;
    }

    public static boolean isCollectionMode() {
        return collectionMode.get();
    }

    public static void onCollectionMode() {
        collectionMode.set(Boolean.TRUE);
    }

    public static void offCollectionMode() {
        collectionMode.set(Boolean.FALSE);
    }

    public static void setThrowable(Throwable throwable) {
        ExecutionContextHolder.throwable.set(throwable);
    }

    public static Throwable getThrowable() {
        return throwable.get();
    }

    public static void addAction(String action) {
        Integer n = indexAction;
        indexAction = indexAction + 1;
        actions.get().add(Step.builder().sequence(n).text(action).build());
    }

    public static void addStep(String step) {
        Integer n = indexStep;
        indexStep = indexStep + 1;
        steps.get().add(Step.builder().sequence(n).text(step).build());
    }

    public static List<Step> getActions() {
        return actions.get();
    }

    public static List<Step> getSteps() {
        return steps.get();
    }

    public static void cleanActions() {
        indexAction = 0;
        actions.remove();
        actions.set(new ArrayList());
    }

    public static void cleanSteps() {
        indexStep = 0;
        steps.remove();
        steps.set(new ArrayList());
    }

    public static void clean() {
        content = null;
        collectionMode.remove();
        collectionMode.set(Boolean.FALSE);
        throwable.remove();
        ExecutionContextHolder.cleanActions();
        ExecutionContextHolder.cleanSteps();
    }

    static {
        indexAction = 0;
        indexStep = 0;
        collectionMode = new ThreadLocal();
        throwable = new ThreadLocal();
        actions = new ThreadLocal();
        steps = new ThreadLocal();
    }
}

