/*
 * Decompiled with CFR 0.152.
 */
package org.probato.engine.execution;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Optional;
import java.util.UUID;
import org.probato.engine.execution.ExecutionService;
import org.probato.engine.execution.builder.Execution;
import org.probato.engine.execution.builder.Script;
import org.probato.engine.execution.builder.Suite;
import org.probato.exception.ExecutionException;
import org.probato.loader.Configuration;
import org.probato.model.Dimension;
import org.probato.record.RecordService;
import org.probato.util.ConverterUtil;
import org.probato.util.FileUtil;

class ExecutionServiceImpl
implements ExecutionService {
    private static final String DIRECTORY = "{0}/{1}/{2}";
    private static final String SUITE_FILE_JSON = "000-{0}.json";
    private static final String SCRIPT_FILE_JSON = "001-{0}.json";
    private static final String FILE_JSON = "{0}.json";
    private static final String FILE_MP4 = "{0}.mp4";
    private static final String FILE_JPG = "{0}.jpg";
    private static final String ERROR_DEFAULT_MSG = "An error occurred while executing: {0}";
    private final UUID executionId = UUID.randomUUID();
    private final Configuration configuration;
    private final Optional<RecordService> recordService;

    protected ExecutionServiceImpl(Class<?> clazz) {
        this.configuration = Configuration.getInstance(clazz);
        this.recordService = RecordService.getInstance();
    }

    @Override
    public void save(Suite suite, Script script, Execution execution) {
        try {
            String directory = this.buildPath(DIRECTORY, this.configuration.getExecution().getDirectory().getTemp(), suite.getProjectId(), suite.getProjectVersion(), execution.getId());
            this.saveSuite(suite, directory);
            this.saveScript(script, directory);
            this.saveExecution(execution, directory);
        }
        catch (IOException ex) {
            throw new Error(ex.getMessage());
        }
    }

    @Override
    public UUID captureScreen(Dimension dimension) {
        UUID ret = null;
        try {
            if (this.recordService.isPresent() && this.isEnabled()) {
                RecordService service = this.recordService.get();
                UUID projectId = this.configuration.getExecution().getTarget().getProjectId();
                String projectVersion = this.configuration.getExecution().getTarget().getVersion();
                String tempDir = this.configuration.getExecution().getDirectory().getTemp();
                String directory = this.buildPath(DIRECTORY, tempDir, projectId, projectVersion);
                String name = this.buildPath(FILE_JPG, this.executionId);
                FileUtil.createTempDir(directory);
                service.screenshot(directory.concat("/").concat(name), dimension);
                ret = this.executionId;
            }
        }
        catch (Exception ex) {
            throw new ExecutionException(ERROR_DEFAULT_MSG, ex.getMessage());
        }
        return ret;
    }

    @Override
    public UUID startRecording(Dimension dimension) {
        UUID ret = null;
        try {
            if (this.recordService.isPresent() && this.isEnabled()) {
                RecordService service = this.recordService.get();
                UUID projectId = this.configuration.getExecution().getTarget().getProjectId();
                String projectVersion = this.configuration.getExecution().getTarget().getVersion();
                String tempDir = this.configuration.getExecution().getDirectory().getTemp();
                String directory = this.buildPath(DIRECTORY, tempDir, projectId, projectVersion);
                String name = this.buildPath(FILE_MP4, this.executionId);
                FileUtil.createTempDir(directory);
                service.start(directory.concat("/").concat(name), dimension);
                ret = this.executionId;
            }
        }
        catch (Exception ex) {
            throw new ExecutionException(ERROR_DEFAULT_MSG, ex.getMessage());
        }
        return ret;
    }

    @Override
    public void endRecording() {
        try {
            this.recordService.ifPresent(RecordService::stop);
        }
        catch (Exception ex) {
            throw new ExecutionException(ERROR_DEFAULT_MSG, ex.getMessage());
        }
    }

    @Override
    public UUID getExecutionId() {
        return this.executionId;
    }

    private boolean isEnabled() {
        return this.configuration.getExecution().getVideo().isEnabled();
    }

    private void saveSuite(Suite suite, String directory) throws IOException {
        String name = this.buildPath(SUITE_FILE_JSON, suite.getCode());
        String json = ConverterUtil.toJson(suite);
        FileUtil.save(directory, name, json);
    }

    private void saveScript(Script script, String directory) throws IOException {
        String name = this.buildPath(SCRIPT_FILE_JSON, script.getCode());
        String json = ConverterUtil.toJson(script);
        FileUtil.save(directory, name, json);
    }

    private void saveExecution(Execution execution, String directory) throws IOException {
        String name = this.buildPath(FILE_JSON, execution.getId());
        String json = ConverterUtil.toJson(execution);
        FileUtil.save(directory, name, json);
    }

    private String buildPath(String pattern, Object ... params) {
        return MessageFormat.format(pattern, params);
    }
}

