/*
 * Decompiled with CFR 0.152.
 */
package org.probato.engine.execution;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.InvocationHandlerAdapter;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.probato.api.Dataset;
import org.probato.dataset.DatasetService;
import org.probato.engine.execution.ExecutionContextHolder;
import org.probato.engine.execution.InicializerExecutionService;
import org.probato.engine.execution.proxy.PageProxy;
import org.probato.loader.AnnotationLoader;
import org.probato.model.PageObject;

public class ProcedureExecutionService {
    private InicializerExecutionService inicializerExecutionService = new InicializerExecutionService();

    public void execute(Object driver, Class<?> scriptClazz, Integer datasetLine, List<Object> procedures) throws Throwable {
        ExecutionContextHolder.cleanActions();
        ExecutionContextHolder.cleanSteps();
        for (Object procedure : procedures) {
            if (procedure instanceof Method) {
                this.invokeMethod(driver, scriptClazz, datasetLine, procedure);
                continue;
            }
            this.invokeProcedure(driver, scriptClazz, datasetLine, procedure);
        }
    }

    private void invokeMethod(Object driver, Class<?> scriptClazz, Integer datasetLine, Object item) throws Throwable {
        Method method = (Method)item;
        Object object = this.inicializerExecutionService.newInstance(method.getDeclaringClass(), new Object[0]);
        this.initializePagesObject(driver, method.getDeclaringClass(), object);
        this.executeMethod(scriptClazz, datasetLine, object, method);
    }

    private void invokeProcedure(Object driver, Class<?> scriptClazz, Integer datasetLine, Object item) throws Throwable {
        Field field = (Field)item;
        Class<?> type = field.getType();
        Method method = AnnotationLoader.getRunMethod(type);
        Object objectScript = this.inicializerExecutionService.newInstance(field.getDeclaringClass(), new Object[0]);
        Object objectProcedure = this.inicializerExecutionService.newInstance(type, new Object[0]);
        field.setAccessible(Boolean.TRUE);
        field.set(objectScript, objectProcedure);
        this.initializePagesObject(driver, type, objectProcedure);
        this.executeMethod(scriptClazz, datasetLine, objectProcedure, method);
    }

    private void initializePagesObject(Object driver, Class<?> clazz, Object object) throws Exception {
        for (Field page : AnnotationLoader.getPages(clazz)) {
            Object pageObject = this.intancePageObjectProxy(page.getType());
            ((PageObject)pageObject).setDriver(driver);
            page.setAccessible(Boolean.TRUE);
            page.set(object, pageObject);
        }
    }

    private <T> T intancePageObjectProxy(Class<T> clazz) throws InstantiationException, IllegalAccessException {
        return new ByteBuddy().subclass(clazz).method((ElementMatcher)ElementMatchers.any()).intercept((Implementation)InvocationHandlerAdapter.of((InvocationHandler)new PageProxy(clazz.newInstance()))).make().load(clazz.getClassLoader()).getLoaded().newInstance();
    }

    private void executeMethod(Class<?> scriptClazz, Integer datasetLine, Object object, Method method) throws Throwable {
        if (method.getGenericParameterTypes().length == 0) {
            method.setAccessible(Boolean.TRUE);
            method.invoke(object, new Object[0]);
        } else {
            ArrayList models = new ArrayList();
            for (Class<?> clazz : method.getParameterTypes()) {
                AnnotationLoader.getDataset(scriptClazz).ifPresent(dataset -> models.add(DatasetService.getInstance().getDatamodel((Dataset)dataset, clazz, datasetLine - 1)));
            }
            try {
                method.setAccessible(Boolean.TRUE);
                method.invoke(object, models.toArray());
            }
            catch (Exception ex) {
                throw ex.getCause();
            }
        }
    }
}

