/*
 * Decompiled with CFR 0.152.
 */
package org.probato.engine.execution.proxy;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.probato.api.Action;
import org.probato.api.Param;
import org.probato.engine.execution.ExecutionContextHolder;
import org.probato.loader.AnnotationLoader;
import org.probato.loader.Configuration;

public class PageProxy
implements InvocationHandler {
    private Object target;

    public PageProxy(Object target) {
        this.target = target;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] args) throws Throwable {
        String actionValue = null;
        String stepValue = null;
        Object result = null;
        try {
            if (!ExecutionContextHolder.isCollectionMode()) {
                Configuration configuration = Configuration.getInstance();
                TimeUnit.MILLISECONDS.sleep(configuration.getExecution().getDelay().getActionInterval().intValue());
                result = method.invoke(this.target, args);
            }
        }
        catch (Throwable ex) {
            if (Objects.nonNull(ex.getCause())) {
                ExecutionContextHolder.setThrowable(ex.getCause());
                throw ex.getCause();
            }
            ExecutionContextHolder.setThrowable(ex);
            throw ex;
        }
        finally {
            if (method.isAnnotationPresent(Action.class)) {
                HashMap<String, String> params = new HashMap<String, String>();
                Annotation[][] paramAnottations = method.getParameterAnnotations();
                for (int i = 0; i < paramAnottations.length; ++i) {
                    for (Annotation annotation : paramAnottations[i]) {
                        if (!(annotation instanceof Param)) continue;
                        String key = ((Param)annotation).value();
                        Object valueArg = args[i];
                        if (Objects.isNull(valueArg)) {
                            valueArg = "[null]";
                        }
                        params.put(key, valueArg.toString());
                    }
                }
                actionValue = stepValue = AnnotationLoader.getActionValue(method);
                for (Map.Entry item : params.entrySet()) {
                    stepValue = PageProxy.replaceParam(actionValue, (String)item.getKey(), (String)item.getValue());
                }
            }
        }
        this.addStepAction(method, actionValue, stepValue);
        return result;
    }

    private void addStepAction(Method method, String actionValue, String stepValue) {
        if (method.isAnnotationPresent(Action.class)) {
            ExecutionContextHolder.addAction(actionValue);
            ExecutionContextHolder.addStep(stepValue);
        }
    }

    private static String replaceParam(String content, String key, String value) {
        return PageProxy.replace(content, "\\{\\{%s\\}\\}", key, value);
    }

    private static String replace(String content, String pattern, String key, String value) {
        Pattern p = Pattern.compile(String.format(pattern, key));
        Matcher m = p.matcher(content);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, value);
        }
        m.appendTail(sb);
        return sb.toString();
    }
}

