/*
 * Decompiled with CFR 0.152.
 */
package org.probato.integration.manager;

import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Objects;
import org.probato.exception.IntegrationException;
import org.probato.integration.manager.AbstractApiService;
import org.probato.integration.manager.dto.HealthCheckResponse;
import org.probato.model.type.ExecutionPhase;

public class HealthCheckApiService
extends AbstractApiService {
    private static final String HEALTHCHECK_ENDPOINT = "{0}/health";
    private static final String HEALTHCHECK_UP_RESPONSE = "UP";
    private static final String HEALTHCHECK_NO_UP_MSG = "Web application is currently unavailable";

    @Override
    public ExecutionPhase getExecutionPhase() {
        return ExecutionPhase.BEFORE_EACH;
    }

    @Override
    public void execute() throws Exception {
        HttpRequest request = HttpRequest.newBuilder().GET().uri(URI.create(this.buildUrl(HEALTHCHECK_ENDPOINT, this.getBaseUrl()))).build();
        HttpResponse<String> response = this.send(request);
        HealthCheckResponse data = this.converterResponse(response, HealthCheckResponse.class);
        if (!HealthCheckApiService.isUP(data)) {
            throw new IntegrationException(HEALTHCHECK_NO_UP_MSG, new Object[0]);
        }
    }

    private static boolean isUP(HealthCheckResponse data) {
        return Objects.nonNull(data) && HEALTHCHECK_UP_RESPONSE.equals(data.getStatus());
    }
}

