/*
 * Decompiled with CFR 0.152.
 */
package org.probato.integration.manager;

import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.probato.integration.manager.AbstractApiService;
import org.probato.integration.manager.dto.NextIncrementExecutionResponse;
import org.probato.loader.Configuration;
import org.probato.model.type.ExecutionPhase;

public class LoadIncrementExecutionApiService
extends AbstractApiService {
    private static final String GET_INCREMENT_ENDPOINT = "{0}/query/executions/next-increment";

    @Override
    public ExecutionPhase getExecutionPhase() {
        return ExecutionPhase.BEFORE_ALL;
    }

    @Override
    public void execute() throws Exception {
        if (Objects.nonNull(this.getIncrement())) {
            return;
        }
        HttpRequest request = HttpRequest.newBuilder().GET().uri(URI.create(this.buildUrl(GET_INCREMENT_ENDPOINT, this.getBaseUrl()))).header("X-Project-Token", this.getProjectToken()).build();
        HttpResponse<String> response = this.send(request);
        NextIncrementExecutionResponse data = this.converterResponse(response, NextIncrementExecutionResponse.class);
        this.setIncrement(data.getNextIncrement());
        this.setProjectId(data.getProjectId());
    }

    private void setIncrement(Long nextIncrement) {
        Optional.ofNullable(Configuration.getInstance().getExecution()).ifPresent(execution -> execution.setIncrement(nextIncrement));
    }

    private void setProjectId(UUID projectId) {
        Optional.ofNullable(Configuration.getInstance().getExecution()).ifPresent(execution -> execution.getTarget().setProjectId(projectId));
    }
}

