/*
 * Decompiled with CFR 0.152.
 */
package org.probato.integration.manager;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.net.http.HttpRequest;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.probato.integration.manager.AbstractApiService;
import org.probato.integration.manager.dto.RecordFileExecutionRequest;
import org.probato.model.type.ExecutionPhase;
import org.probato.util.ConverterUtil;
import org.probato.util.FileUtil;

public class SubmitExecutionDataApiService
extends AbstractApiService {
    private static final String SUBMIT_SUITE_ENDPOINT = "{0}/core/suites";
    private static final String SUBMIT_SCRIPT_ENDPOINT = "{0}/core/scripts";
    private static final String SUBMIT_EXECUTION_ENDPOINT = "{0}/core/executions";
    private static final String SUBMIT_FILE_EXECUTION_ENDPOINT = "{0}/core/executions/file";
    private static final String DIRECTORY = "{0}/{1}/{2}";
    private static final String CONTENT_TYPE = "Content-Type";

    @Override
    public ExecutionPhase getExecutionPhase() {
        return ExecutionPhase.AFTER_EACH;
    }

    @Override
    public void execute() throws Exception {
        List<File> files = this.getExecutionFiles();
        for (File file : files) {
            String ext;
            switch (ext = FileUtil.getFileExtension(file.getName())) {
                case "json": {
                    String url;
                    String name = file.getName();
                    if (name.startsWith("000-")) {
                        url = this.buildUrl(SUBMIT_SUITE_ENDPOINT, this.getBaseUrl());
                        this.submitPutContent(url, file);
                        break;
                    }
                    if (name.startsWith("001-")) {
                        url = this.buildUrl(SUBMIT_SCRIPT_ENDPOINT, this.getBaseUrl());
                        this.submitPutContent(url, file);
                        break;
                    }
                    url = this.buildUrl(SUBMIT_EXECUTION_ENDPOINT, this.getBaseUrl());
                    this.submitPostContent(url, file);
                    break;
                }
                case "mp4": 
                case "jpg": {
                    String url = this.buildUrl(SUBMIT_FILE_EXECUTION_ENDPOINT, this.getBaseUrl());
                    this.submitFilePostContent(url, file);
                    break;
                }
            }
        }
    }

    private void submitPostContent(String url, File file) throws IOException, InterruptedException {
        String content = FileUtil.getContent(file);
        HttpRequest request = HttpRequest.newBuilder().POST(HttpRequest.BodyPublishers.ofString(content)).uri(URI.create(this.buildUrl(url, new Object[0]))).setHeader("X-Project-Token", this.getProjectToken()).setHeader(CONTENT_TYPE, "application/json").build();
        this.send(request);
    }

    private void submitPutContent(String url, File file) throws IOException, InterruptedException {
        String content = FileUtil.getContent(file);
        HttpRequest request = HttpRequest.newBuilder().PUT(HttpRequest.BodyPublishers.ofString(content)).uri(URI.create(this.buildUrl(url, new Object[0]))).setHeader("X-Project-Token", this.getProjectToken()).setHeader(CONTENT_TYPE, "application/json").build();
        this.send(request);
    }

    private void submitFilePostContent(String url, File file) throws IOException, InterruptedException {
        RecordFileExecutionRequest command = RecordFileExecutionRequest.builder().projectId(this.getProjectId()).projectVersion(this.getProjectVersion()).increment(this.getIncrement()).build();
        LinkedHashMap<Object, Object> data = new LinkedHashMap<Object, Object>();
        data.put("file", file.toPath());
        data.put("command", this.converterRequest(command));
        String boundary = new BigInteger(256, new Random()).toString();
        HttpRequest request = HttpRequest.newBuilder().POST(SubmitExecutionDataApiService.ofMimeMultipartData(data, boundary)).uri(URI.create(this.buildUrl(url, new Object[0]))).setHeader("X-Project-Token", this.getProjectToken()).setHeader(CONTENT_TYPE, "multipart/form-data; boundary=" + boundary).build();
        this.send(request);
    }

    private List<File> getExecutionFiles() {
        String path = this.buildUrl(DIRECTORY, this.getTempDir(), this.getProjectId(), this.getProjectVersion());
        return FileUtil.loadFiles(path);
    }

    private String converterRequest(Object object) {
        return ConverterUtil.toJson(object);
    }

    private static HttpRequest.BodyPublisher ofMimeMultipartData(Map<Object, Object> data, String boundary) throws IOException {
        ArrayList<byte[]> byteArrays = new ArrayList<byte[]>();
        byte[] separator = ("--" + boundary + "\r\nContent-Disposition: form-data; name=").getBytes(StandardCharsets.UTF_8);
        for (Map.Entry<Object, Object> entry : data.entrySet()) {
            byteArrays.add(separator);
            if (entry.getValue() instanceof Path) {
                Path path = (Path)entry.getValue();
                String mimeType = Files.probeContentType(path);
                byteArrays.add(("\"" + String.valueOf(entry.getKey()) + "\"; filename=\"" + String.valueOf(path.getFileName()) + "\"\r\nContent-Type: " + mimeType + "\r\n\r\n").getBytes(StandardCharsets.UTF_8));
                byteArrays.add(Files.readAllBytes(path));
                byteArrays.add("\r\n".getBytes(StandardCharsets.UTF_8));
                continue;
            }
            byteArrays.add(("\"" + String.valueOf(entry.getKey()) + "\"; filename=\"" + String.valueOf(entry.getKey()) + "\"\r\nContent-Type: application/json\r\n\r\n").getBytes(StandardCharsets.UTF_8));
            byteArrays.add(entry.getValue().toString().getBytes());
            byteArrays.add("\r\n".getBytes(StandardCharsets.UTF_8));
        }
        byteArrays.add(("--" + boundary + "--").getBytes(StandardCharsets.UTF_8));
        return HttpRequest.BodyPublishers.ofByteArrays(byteArrays);
    }
}

