/*
 * Decompiled with CFR 0.152.
 */
package org.probato.record;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.probato.model.Dimension;
import org.probato.model.type.DimensionMode;
import org.probato.model.type.Screen;

abstract class AbstractScreen {
    private static final String TESTANO_TEXT_SCREEN = "TESTANO.COM";
    private static final Integer TEXT_SIZE = 16;
    private static final Integer WIDTH_TEXT_POSITION = 135;
    private static final Integer HEIGHT_TEXT_POSITION = 15;
    private static final Integer WIDTH_MIN_LENGTH = 400;
    private static final Integer HEIGHT_MIN_LENGTH = 300;
    protected Screen screen;
    protected Rectangle screenBounds;
    protected Integer width;
    protected Integer height;

    protected AbstractScreen(Screen screen, Dimension dimension) {
        this.screen = screen;
        this.setScreenBounds();
        this.setSize(dimension);
    }

    protected final BufferedImage addText(BufferedImage image) {
        Graphics2D graphics = image.createGraphics();
        Color textColor = Color.GRAY;
        graphics.setColor(textColor);
        graphics.setFont(new Font(null, 1, TEXT_SIZE));
        graphics.drawString(TESTANO_TEXT_SCREEN, this.width - WIDTH_TEXT_POSITION, this.height - HEIGHT_TEXT_POSITION);
        return image;
    }

    protected Rectangle getRectangle() {
        return new Rectangle(this.screenBounds.x, this.screenBounds.y, this.width, this.height);
    }

    private void setSize(Dimension dimension) {
        int heightTemp;
        int widthTemp;
        if (DimensionMode.CUSTOM.equals((Object)dimension.getMode())) {
            widthTemp = dimension.getWidth();
            heightTemp = dimension.getHeight();
        } else {
            widthTemp = this.screenBounds.width;
            heightTemp = this.screenBounds.height;
        }
        this.width = this.getWidth(widthTemp);
        this.height = this.getHeight(heightTemp);
    }

    private int getWidth(int width) {
        return width > this.screenBounds.width ? this.screenBounds.width : this.getMinWidth(width);
    }

    private int getHeight(int height) {
        return height > this.screenBounds.height ? this.screenBounds.height : this.getMinHeight(height);
    }

    private int getMinWidth(int width) {
        return width < WIDTH_MIN_LENGTH ? WIDTH_MIN_LENGTH : width;
    }

    private int getMinHeight(int height) {
        return height < HEIGHT_MIN_LENGTH ? HEIGHT_MIN_LENGTH : height;
    }

    private void setScreenBounds() {
        this.screenBounds = AbstractScreen.getScreen(this.screen);
    }

    protected static Rectangle getScreen(Screen screen) {
        Rectangle result = null;
        GraphicsDevice principalGe = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        List screens = Stream.of(ge.getScreenDevices()).filter(item -> !item.equals(principalGe)).collect(Collectors.toList());
        try {
            if (Screen.PRINCIPAL.equals((Object)screen)) {
                result = principalGe.getDefaultConfiguration().getBounds();
            } else if (!screens.isEmpty()) {
                result = ((GraphicsDevice)screens.get(0)).getDefaultConfiguration().getBounds();
            }
        }
        catch (IndexOutOfBoundsException ex) {
            result = principalGe.getDefaultConfiguration().getBounds();
        }
        return result;
    }
}

