/*
 * Decompiled with CFR 0.152.
 */
package org.probato.record;

import java.util.Optional;
import org.probato.exception.ExecutionException;
import org.probato.loader.Configuration;
import org.probato.model.Dimension;
import org.probato.model.Video;
import org.probato.model.type.Screen;
import org.probato.record.RecordService;
import org.probato.record.ScreenRecorder;
import org.probato.record.Screenshot;

public class RecordServiceImpl
implements RecordService {
    private static final String ERROR_DEFAULT_MSG = "An error occurred while trying to record screen the execution: {0}";
    private ScreenRecorder recorder;

    @Override
    public void start(String outputFile, Dimension dimension) {
        try {
            Configuration configuration = Configuration.getInstance();
            Screen screen = configuration.getExecution().getScreen();
            Video video = configuration.getExecution().getVideo();
            if (video.isEnabled()) {
                this.recorder = new ScreenRecorder(outputFile, screen, video, dimension);
                this.recorder.startCapture();
            }
        }
        catch (Exception ex) {
            Thread.currentThread().interrupt();
            throw new ExecutionException(ERROR_DEFAULT_MSG, ex.getMessage());
        }
    }

    @Override
    public void stop() {
        Configuration configuration = Configuration.getInstance();
        Video video = configuration.getExecution().getVideo();
        if (video.isEnabled()) {
            Optional.ofNullable(this.recorder).ifPresent(ScreenRecorder::stopCapture);
        }
    }

    @Override
    public void screenshot(String outputFile, Dimension dimension) {
        try {
            Configuration configuration = Configuration.getInstance();
            Screen screen = configuration.getExecution().getScreen();
            new Screenshot(outputFile, screen, dimension).print();
        }
        catch (Exception ex) {
            throw new ExecutionException(ERROR_DEFAULT_MSG, ex.getMessage());
        }
    }
}

