/*
 * Decompiled with CFR 0.152.
 */
package org.probato.record;

import com.xuggle.mediatool.IMediaWriter;
import com.xuggle.mediatool.ToolFactory;
import com.xuggle.xuggler.ICodec;
import java.awt.AWTException;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.probato.exception.ExecutionException;
import org.probato.model.Dimension;
import org.probato.model.Video;
import org.probato.model.type.Quality;
import org.probato.model.type.Screen;
import org.probato.record.AbstractScreen;

public final class ScreenRecorder
extends AbstractScreen
implements Runnable {
    private static final String ERROR_DEFAULT_MSG = "An error occurred while trying to record screen the execution: {0}";
    private double frameRate;
    private Robot robot;
    private IMediaWriter writer;
    private ScheduledExecutorService pool;
    private long startTime;

    public ScreenRecorder(String outputFile, Screen screen, Video video, Dimension dimension) throws AWTException {
        super(screen, dimension);
        this.frameRate = video.getFrameRate();
        this.robot = new Robot();
        this.writer = ToolFactory.makeWriter((String)outputFile);
        this.screenBounds = ScreenRecorder.getScreen(screen);
        this.setVideoStream(video);
    }

    public void startCapture() {
        try {
            this.startTime = System.nanoTime();
            this.pool.scheduleAtFixedRate(this, 0L, (long)(1000.0 / this.frameRate), TimeUnit.MILLISECONDS);
        }
        catch (Exception ex) {
            Thread.currentThread().interrupt();
            throw new ExecutionException(ERROR_DEFAULT_MSG, ex.getMessage());
        }
    }

    public void stopCapture() {
        try {
            TimeUnit.SECONDS.sleep(1L);
            this.pool.shutdown();
            this.pool.awaitTermination(1L, TimeUnit.SECONDS);
            this.writer.close();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new ExecutionException(ERROR_DEFAULT_MSG, ex.getMessage());
        }
    }

    @Override
    public void run() {
        Rectangle rectangle = this.getRectangle();
        BufferedImage screen = this.robot.createScreenCapture(rectangle);
        BufferedImage bgrScreen = this.convertToType(screen, 5);
        this.writer.encodeVideo(0, bgrScreen, System.nanoTime() - this.startTime, TimeUnit.NANOSECONDS);
    }

    private BufferedImage convertToType(BufferedImage sourceImage, int targetType) {
        BufferedImage image = new BufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), targetType);
        image.getGraphics().drawImage(sourceImage, 0, 0, null);
        return this.addText(image);
    }

    private void setVideoStream(Video video) {
        int heightTemp;
        Quality quality = video.getQuality();
        int widthTemp = this.width / quality.getDivisor();
        if (this.isOdd(widthTemp)) {
            ++widthTemp;
        }
        if (this.isOdd(heightTemp = this.height / quality.getDivisor())) {
            ++heightTemp;
        }
        this.writer.addVideoStream(0, 0, ICodec.ID.CODEC_ID_H264, widthTemp, heightTemp);
        this.pool = Executors.newScheduledThreadPool(1);
    }

    private boolean isOdd(int side) {
        return side % 2 != 0;
    }
}

