/*
 * Decompiled with CFR 0.152.
 */
package org.probato.record;

import java.awt.AWTException;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.probato.exception.ExecutionException;
import org.probato.model.Dimension;
import org.probato.model.type.Screen;
import org.probato.record.AbstractScreen;

public final class Screenshot
extends AbstractScreen {
    private static final String ERROR_DEFAULT_MSG = "An error occurred while trying to screenshot the execution: {0}";
    public static final String FORMAT_JPG = "JPG";
    private Robot robot;
    private String outputFile;

    public Screenshot(String outputFile, Screen screen, Dimension dimension) throws AWTException {
        super(screen, dimension);
        this.outputFile = outputFile;
        this.robot = new Robot();
    }

    public void print() {
        try {
            Rectangle rectangle = this.getRectangle();
            BufferedImage screen = this.robot.createScreenCapture(rectangle);
            BufferedImage bgrScreen = this.addText(screen);
            File file = new File(this.outputFile);
            ImageIO.write((RenderedImage)bgrScreen, FORMAT_JPG, file);
        }
        catch (IOException ex) {
            throw new ExecutionException(ERROR_DEFAULT_MSG, ex.getMessage());
        }
    }
}

