/*
 * Decompiled with CFR 0.152.
 */
package org.probato.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public class ConverterUtil {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().registerTypeAdapter(ZonedDateTime.class, (Object)new JsonSerializer<ZonedDateTime>(){

        public JsonElement serialize(ZonedDateTime value, Type type, JsonSerializationContext context) {
            return new JsonPrimitive(value.format(DateTimeFormatter.ISO_ZONED_DATE_TIME));
        }
    }).create();

    private ConverterUtil() {
    }

    public static String toJson(Object object) {
        return GSON.toJson(object);
    }

    public static <T> T toObject(String json, Class<T> clazz) {
        return (T)GSON.fromJson(json, clazz);
    }
}

