/*
 * Decompiled with CFR 0.152.
 */
package org.probato.validator;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.probato.exception.IntegrityException;
import org.probato.model.type.ComponentValidatorType;

public abstract class ComponentValidator {
    private static final String COMPONENT_VALIDATOR_IMPLEMENTATION_NOT_FOUND = "Component validator implementation not found";
    private ComponentValidator next;

    public abstract ComponentValidatorType getStrategy();

    public abstract boolean accepted(ComponentValidatorType var1);

    public abstract void execute(Class<?> var1);

    protected void chain(Class<?> suiteClazz) {
        if (Objects.nonNull(this.next)) {
            this.next.execute(suiteClazz);
        }
    }

    public static List<ComponentValidator> getInstance(ComponentValidatorType type) {
        return ServiceLoader.load(ComponentValidator.class).stream().map(ServiceLoader.Provider::get).sorted(Comparator.comparing(serviceClazz -> serviceClazz.getClass().getPackageName().equals(ComponentValidator.class.getClass().getPackageName()), Comparator.reverseOrder())).filter(component -> component.accepted(type)).collect(Collectors.toList());
    }

    public static ComponentValidator link(List<ComponentValidator> validators) {
        ComponentValidator first;
        if (validators.isEmpty()) {
            throw new IntegrityException(COMPONENT_VALIDATOR_IMPLEMENTATION_NOT_FOUND, new Object[0]);
        }
        ComponentValidator head = first = validators.remove(0);
        Iterator<ComponentValidator> iterator = validators.iterator();
        while (iterator.hasNext()) {
            ComponentValidator item;
            head.next = item = iterator.next();
            head = item;
        }
        return first;
    }
}

