/*
 * Decompiled with CFR 0.152.
 */
package org.probato.validator;

import java.util.Objects;
import org.probato.exception.IntegrityException;
import org.probato.loader.Configuration;
import org.probato.model.Delay;
import org.probato.model.Directory;
import org.probato.model.Execution;
import org.probato.model.type.ComponentValidatorType;
import org.probato.util.StringUtil;
import org.probato.validator.ComponentValidator;

public class ConfigurationComponentValidator
extends ComponentValidator {
    private static final String PROPERTIE_NOT_FOUND_MSG = "Property ''{0}'' should be declared in ''configuration.yml'' file";

    @Override
    public ComponentValidatorType getStrategy() {
        return ComponentValidatorType.CONFIGURATION;
    }

    @Override
    public boolean accepted(ComponentValidatorType type) {
        return this.getStrategy().equals((Object)type);
    }

    @Override
    public void execute(Class<?> suiteClazz) {
        Configuration configuration = Configuration.getInstance(suiteClazz);
        this.validateExecution(configuration);
        this.chain(suiteClazz);
    }

    private void validateExecution(Configuration configuration) {
        Execution execution = configuration.getExecution();
        if (Objects.isNull(execution)) {
            throw new IntegrityException(PROPERTIE_NOT_FOUND_MSG, "execution");
        }
        if (Objects.isNull((Object)execution.getScreen())) {
            throw new IntegrityException(PROPERTIE_NOT_FOUND_MSG, "execution.screen");
        }
        this.validateDelay(execution);
        this.validateDirectory(execution);
    }

    private void validateDelay(Execution execution) {
        Delay delay = execution.getDelay();
        if (Objects.isNull(delay) || Objects.isNull(delay.getActionInterval())) {
            throw new IntegrityException(PROPERTIE_NOT_FOUND_MSG, "execution.delay.actionInterval");
        }
        if (Objects.isNull(delay.getWaitingTimeout())) {
            throw new IntegrityException(PROPERTIE_NOT_FOUND_MSG, "execution.delay.waitingTimeout");
        }
    }

    private void validateDirectory(Execution execution) {
        Directory directory = execution.getDirectory();
        if (Objects.isNull(directory) || StringUtil.isBlank(directory.getTemp())) {
            throw new IntegrityException(PROPERTIE_NOT_FOUND_MSG, "execution.directory.temp");
        }
    }
}

