/*
 * Decompiled with CFR 0.152.
 */
package org.probato.validator;

import java.lang.reflect.Field;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.probato.exception.IntegrityException;
import org.probato.loader.AnnotationLoader;
import org.probato.model.type.ComponentValidatorType;
import org.probato.util.FileUtil;
import org.probato.util.StringUtil;
import org.probato.validator.ComponentValidator;

public class DatabaseSqlComponentValidator
extends ComponentValidator {
    private static final String SQL_LIST_ANNOTATION_REQUIRED = "List of sql must have at least 1 item in the '@SQL' annotation: ''{0}''";
    private static final String SQL_VALUE_ANNOTATION_REQUIRED = "List of sql must not have null or empty value in the '@SQL' annotation: ''{0}''";
    private static final String SQL_FILE_NOT_FOUNT = "SQL file ''{0}'' not found: ''{1}''";
    private static final String SQL_LOAD_FILE = "Problem when trying to load SQL file: ''{0}''";
    private static final String SQL_VALIDATE_COMMAND = "Invalid SQL command in file ''{0}'': \n''{1}''";

    @Override
    public ComponentValidatorType getStrategy() {
        return ComponentValidatorType.DATASOURCE;
    }

    @Override
    public boolean accepted(ComponentValidatorType type) {
        return this.getStrategy().equals((Object)type);
    }

    @Override
    public void execute(Class<?> suiteClazz) {
        boolean ignored = AnnotationLoader.isIgnore(suiteClazz);
        if (ignored) {
            return;
        }
        this.validateSQL(suiteClazz);
        AnnotationLoader.getTestCaseField(suiteClazz).stream().map(Field::getType).forEach(this::validateScript);
        this.chain(suiteClazz);
    }

    private void validateScript(Class<?> scriptClazz) {
        boolean ignored = AnnotationLoader.isIgnore(scriptClazz);
        if (ignored) {
            return;
        }
        this.validateSQL(scriptClazz);
        AnnotationLoader.getPreconditions(scriptClazz).stream().forEach(this::validateProcedure);
        AnnotationLoader.getProcedures(scriptClazz).stream().forEach(this::validateProcedure);
        AnnotationLoader.getPostconditions(scriptClazz).stream().forEach(this::validateProcedure);
    }

    private void validateProcedure(Class<?> procedureClazz) {
        boolean ignored = AnnotationLoader.isIgnore(procedureClazz);
        if (ignored) {
            return;
        }
        this.validateSQL(procedureClazz);
    }

    private void validateSQL(Class<?> clazz) {
        AnnotationLoader.getSqlPaths(clazz).entrySet().forEach(datasource -> {
            String datasourceName = (String)datasource.getKey();
            List sqlList = (List)datasource.getValue();
            this.validateSqlList(clazz, sqlList);
            sqlList.stream().forEach(item -> {
                this.validateSqlItem(clazz, (String)item);
                this.validateFile(clazz, (String)item);
                this.validateSqlCommands(clazz, datasourceName, (String)item);
            });
        });
    }

    private void validateSqlList(Class<?> clazz, List<String> sqlList) {
        if (CollectionUtils.isEmpty(sqlList)) {
            throw new IntegrityException(SQL_LIST_ANNOTATION_REQUIRED, this.getName(clazz));
        }
    }

    private void validateSqlItem(Class<?> clazz, String item) {
        if (StringUtil.isBlank(item)) {
            throw new IntegrityException(SQL_VALUE_ANNOTATION_REQUIRED, this.getName(clazz));
        }
    }

    private void validateFile(Class<?> clazz, String item) {
        if (!FileUtil.exists(item)) {
            throw new IntegrityException(SQL_FILE_NOT_FOUNT, item, this.getName(clazz));
        }
    }

    private void validateSqlCommands(Class<?> clazz, String datasourceName, String item) {
    }

    private String getName(Class<?> clazz) {
        return clazz.getName();
    }
}

