/*
 * Decompiled with CFR 0.152.
 */
package org.probato.validator;

import java.lang.reflect.Field;
import java.util.stream.Stream;
import org.probato.exception.IntegrityException;
import org.probato.loader.AnnotationLoader;
import org.probato.model.type.ComponentValidatorType;
import org.probato.util.FileUtil;
import org.probato.util.StringUtil;
import org.probato.validator.ComponentValidator;

public class DatasetComponentValidator
extends ComponentValidator {
    private static final String DATASET_ANNOTATION_REQUIRED = "List of dataset files must have at least 1 item in the '@Dataset' annotation: ''{0}''";
    private static final String DATASET_PATH_REQUIRED = "Dataset path must be required in the '@Dataset' annotation: ''{0}''";
    private static final String DATASET_FILE_NOT_FOUNT = "Dataset file ''{0}'' not found: ''{1}''";

    @Override
    public ComponentValidatorType getStrategy() {
        return ComponentValidatorType.DATASET;
    }

    @Override
    public boolean accepted(ComponentValidatorType type) {
        return this.getStrategy().equals((Object)type);
    }

    @Override
    public void execute(Class<?> suiteClazz) {
        boolean ignored = AnnotationLoader.isIgnore(suiteClazz);
        if (ignored) {
            return;
        }
        AnnotationLoader.getTestCaseField(suiteClazz).stream().map(Field::getType).forEach(this::validateScript);
        this.chain(suiteClazz);
    }

    private void validateScript(Class<?> scriptClazz) {
        boolean ignored = AnnotationLoader.isIgnore(scriptClazz);
        if (ignored) {
            return;
        }
        AnnotationLoader.getDataset(scriptClazz).ifPresent(dataset -> {
            String[] value = dataset.value();
            this.validateValue(scriptClazz, dataset.value());
            Stream.of(value).forEach(path -> {
                this.validatePath(scriptClazz, (String)path);
                this.validateFile(scriptClazz, (String)path);
            });
        });
    }

    private void validateValue(Class<?> clazz, String[] value) {
        if (value.length == 0) {
            throw new IntegrityException(DATASET_ANNOTATION_REQUIRED, this.getName(clazz));
        }
    }

    private void validatePath(Class<?> clazz, String value) {
        if (StringUtil.isBlank(value)) {
            throw new IntegrityException(DATASET_PATH_REQUIRED, this.getName(clazz));
        }
    }

    private void validateFile(Class<?> clazz, String path) {
        if (!FileUtil.exists(path)) {
            throw new IntegrityException(DATASET_FILE_NOT_FOUNT, path, this.getName(clazz));
        }
    }

    private String getName(Class<?> scritpClazz) {
        return scritpClazz.getName();
    }
}

