/*
 * Decompiled with CFR 0.152.
 */
package org.probato.validator;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.probato.model.type.ComponentValidatorType;
import org.probato.validator.ComponentValidator;

public class ValidationService {
    private ComponentValidator validator;

    private ValidationService() {
        List<ComponentValidator> validators = Stream.of(ComponentValidator.getInstance(ComponentValidatorType.CONFIGURATION), ComponentValidator.getInstance(ComponentValidatorType.SUITE), ComponentValidator.getInstance(ComponentValidatorType.SCRIPT), ComponentValidator.getInstance(ComponentValidatorType.PROCEDURE), ComponentValidator.getInstance(ComponentValidatorType.PAGE_OBJECT), ComponentValidator.getInstance(ComponentValidatorType.DATASET), ComponentValidator.getInstance(ComponentValidatorType.DATASOURCE), ComponentValidator.getInstance(ComponentValidatorType.BROWSER)).flatMap(Collection::stream).collect(Collectors.toList());
        this.validator = ComponentValidator.link(validators);
    }

    public void execute(Class<?> suiteClazz) {
        this.validator.execute(suiteClazz);
    }

    public static ValidationService getInstance() {
        return new ValidationService();
    }
}

