/*
 * Decompiled with CFR 0.152.
 */
package processing.video;

import java.awt.Dimension;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.concurrent.TimeUnit;
import org.gstreamer.Buffer;
import org.gstreamer.Bus;
import org.gstreamer.Element;
import org.gstreamer.Format;
import org.gstreamer.GstObject;
import org.gstreamer.SeekType;
import org.gstreamer.elements.BufferDataAppSink;
import org.gstreamer.elements.PlayBin2;
import org.gstreamer.elements.RGBDataAppSink;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.video.Video;

public class Movie
extends PImage
implements PConstants {
    public static String[] supportedProtocols = new String[]{"http"};
    public float frameRate;
    public String filename;
    public PlayBin2 playbin;
    protected boolean playing = false;
    protected boolean paused = false;
    protected boolean repeat = false;
    protected float rate;
    protected int bufWidth;
    protected int bufHeight;
    protected float volume;
    protected Method movieEventMethod;
    protected Object eventHandler;
    protected boolean available;
    protected boolean sinkReady;
    protected boolean newFrame;
    protected RGBDataAppSink rgbSink = null;
    protected int[] copyPixels = null;
    protected boolean firstFrame = true;
    protected boolean seeking = false;
    protected boolean useBufferSink = false;
    protected boolean outdatedPixels = true;
    protected Object bufferSink;
    protected Method sinkCopyMethod;
    protected Method sinkSetMethod;
    protected Method sinkDisposeMethod;
    protected Method sinkGetMethod;
    protected String copyMask;
    protected Buffer natBuffer = null;
    protected BufferDataAppSink natSink = null;

    public Movie(PApplet pApplet, String string) {
        super(0, 0, 1);
        this.initGStreamer(pApplet, string);
    }

    public void dispose() {
        if (this.playbin != null) {
            try {
                if (this.playbin.isPlaying()) {
                    this.playbin.stop();
                    this.playbin.getState();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.pixels = null;
            this.copyPixels = null;
            if (this.rgbSink != null) {
                this.rgbSink.removeListener();
                this.rgbSink.dispose();
                this.rgbSink = null;
            }
            this.natBuffer = null;
            if (this.natSink != null) {
                this.natSink.removeListener();
                this.natSink.dispose();
                this.natSink = null;
            }
            this.playbin.dispose();
            this.playbin = null;
            this.parent.g.removeCache((PImage)this);
            this.parent.unregisterMethod("dispose", (Object)this);
            this.parent.unregisterMethod("post", (Object)this);
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        finally {
            super.finalize();
        }
    }

    public void frameRate(float f) {
        long l;
        long l2;
        float f2;
        if (this.seeking) {
            return;
        }
        float f3 = f2 = 0.0f < f && 0.0f < this.frameRate ? f / this.frameRate : 1.0f;
        if (this.playing) {
            this.playbin.pause();
            this.playbin.getState();
        }
        long l3 = this.playbin.queryPosition(TimeUnit.NANOSECONDS);
        if (this.rate > 0.0f) {
            l2 = l3;
            l = -1L;
        } else {
            l2 = 0L;
            l = l3;
        }
        boolean bl = this.playbin.seek((double)(this.rate * f2), Format.TIME, 1, SeekType.SET, l2, SeekType.SET, l);
        this.playbin.getState();
        if (!bl) {
            PGraphics.showWarning((String)"Seek operation failed.");
        }
        if (this.playing) {
            this.playbin.play();
        }
        this.frameRate = f;
        this.seeking = true;
        this.playbin.getState();
        this.seeking = false;
    }

    public void speed(float f) {
        if ((double)PApplet.abs((float)(this.rate - f)) > 0.1) {
            this.rate = f;
            this.frameRate(this.frameRate);
        }
    }

    public float duration() {
        float f = this.playbin.queryDuration().toSeconds();
        float f2 = this.playbin.queryDuration().getNanoSeconds();
        return f + Video.nanoSecToSecFrac(f2);
    }

    public float time() {
        float f = this.playbin.queryPosition().toSeconds();
        float f2 = this.playbin.queryPosition().getNanoSeconds();
        return f + Video.nanoSecToSecFrac(f2);
    }

    public void jump(float f) {
        float f2;
        int n;
        long l;
        boolean bl;
        if (this.seeking) {
            return;
        }
        if (!this.sinkReady) {
            this.initSink();
        }
        if (!(bl = this.playbin.seek((double)this.rate, Format.TIME, 1, SeekType.SET, l = Video.secToNanoLong(f = (float)(n = (int)(f * (f2 = this.getSourceFrameRate()))) / f2), SeekType.NONE, -1L))) {
            PGraphics.showWarning((String)"Seek operation failed.");
        }
        this.seeking = true;
        this.playbin.getState();
        this.seeking = false;
    }

    public boolean available() {
        return this.available;
    }

    public void play() {
        if (this.seeking) {
            return;
        }
        if (!this.sinkReady) {
            this.initSink();
        }
        this.playing = true;
        this.paused = false;
        this.playbin.play();
        this.playbin.getState();
    }

    public void loop() {
        if (this.seeking) {
            return;
        }
        this.repeat = true;
        this.play();
    }

    public void noLoop() {
        if (this.seeking) {
            return;
        }
        if (!this.sinkReady) {
            this.initSink();
        }
        this.repeat = false;
    }

    public void pause() {
        if (this.seeking) {
            return;
        }
        if (!this.sinkReady) {
            this.initSink();
        }
        this.playing = false;
        this.paused = true;
        this.playbin.pause();
        this.playbin.getState();
    }

    public void stop() {
        if (this.seeking) {
            return;
        }
        if (!this.sinkReady) {
            this.initSink();
        }
        if (this.playing) {
            this.jump(0.0f);
            this.playing = false;
        }
        this.paused = false;
        this.playbin.stop();
        this.playbin.getState();
    }

    public synchronized void read() {
        if (this.frameRate < 0.0f) {
            this.frameRate = this.getSourceFrameRate();
        }
        if (this.volume < 0.0f) {
            this.volume = (float)this.playbin.getVolume();
        }
        if (this.useBufferSink) {
            Object object;
            this.outdatedPixels = true;
            if (this.natBuffer == null) {
                return;
            }
            if (this.firstFrame) {
                super.init(this.bufWidth, this.bufHeight, 2);
                this.firstFrame = false;
            }
            if (this.bufferSink == null) {
                object = this.parent.g.getCache((PImage)this);
                if (object == null) {
                    return;
                }
                this.setBufferSink(object);
                this.getSinkMethods();
            }
            object = this.natBuffer.getByteBuffer();
            try {
                this.sinkCopyMethod.invoke(this.bufferSink, this.natBuffer, object, this.bufWidth, this.bufHeight);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.natBuffer = null;
        } else {
            if (this.copyPixels == null) {
                return;
            }
            if (this.firstFrame) {
                super.init(this.bufWidth, this.bufHeight, 1);
                this.firstFrame = false;
            }
            int[] nArray = this.pixels;
            this.pixels = this.copyPixels;
            this.updatePixels();
            this.copyPixels = nArray;
        }
        this.available = false;
        this.newFrame = true;
    }

    public void volume(float f) {
        if (this.playing && PApplet.abs((float)(this.volume - f)) > 0.001f) {
            this.playbin.setVolume((double)f);
            this.volume = f;
        }
    }

    public synchronized void loadPixels() {
        super.loadPixels();
        if (this.useBufferSink) {
            if (this.natBuffer != null) {
                IntBuffer intBuffer = this.natBuffer.getByteBuffer().asIntBuffer();
                intBuffer.rewind();
                intBuffer.get(this.pixels);
                Video.convertToARGB(this.pixels, this.width, this.height);
            } else if (this.sinkGetMethod != null) {
                try {
                    this.sinkGetMethod.invoke(this.bufferSink, new Object[]{this.pixels});
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.outdatedPixels = false;
        }
    }

    public int get(int n, int n2) {
        if (this.outdatedPixels) {
            this.loadPixels();
        }
        return super.get(n, n2);
    }

    protected void getImpl(int n, int n2, int n3, int n4, PImage pImage, int n5, int n6) {
        if (this.outdatedPixels) {
            this.loadPixels();
        }
        super.getImpl(n, n2, n3, n4, pImage, n5, n6);
    }

    protected void initGStreamer(PApplet pApplet, String string) {
        block16: {
            this.parent = pApplet;
            this.playbin = null;
            Video.init();
            try {
                File file;
                try {
                    file = new File(pApplet.dataPath(string));
                    if (file.exists()) {
                        this.playbin = new PlayBin2("Movie Player");
                        this.playbin.setInputFile(file);
                    }
                }
                catch (Exception exception) {}
                if (this.playbin == null) {
                    try {
                        file = new File(string);
                        if (file.exists()) {
                            this.playbin = new PlayBin2("Movie Player");
                            this.playbin.setInputFile(file);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if (this.playbin != null) break block16;
                int n = 0;
                while (n < supportedProtocols.length) {
                    if (string.startsWith(String.valueOf(supportedProtocols[n]) + "://")) {
                        try {
                            this.playbin = new PlayBin2("Movie Player");
                            this.playbin.setURI(URI.create(string));
                            break;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    ++n;
                }
            }
            catch (SecurityException securityException) {}
        }
        if (this.playbin == null) {
            pApplet.die("Could not load movie file " + string, null);
        }
        try {
            this.filename = string;
            pApplet.registerMethod("dispose", (Object)this);
            pApplet.registerMethod("post", (Object)this);
            this.setEventHandlerObject(pApplet);
            this.rate = 1.0f;
            this.frameRate = -1.0f;
            this.volume = -1.0f;
            this.sinkReady = false;
            this.bufHeight = 0;
            this.bufWidth = 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void setEventHandlerObject(Object object) {
        this.eventHandler = object;
        try {
            this.movieEventMethod = this.eventHandler.getClass().getMethod("movieEvent", Movie.class);
            return;
        }
        catch (Exception exception) {
            try {
                this.movieEventMethod = this.eventHandler.getClass().getMethod("movieEvent", Object.class);
            }
            catch (Exception exception2) {}
            return;
        }
    }

    protected void initSink() {
        if (this.bufferSink != null || Video.useGLBufferSink && this.parent.g.isGL()) {
            this.useBufferSink = true;
            if (this.bufferSink != null) {
                this.getSinkMethods();
            }
            if (this.copyMask == null || this.copyMask.equals("")) {
                this.initCopyMask();
            }
            this.natSink = new BufferDataAppSink("nat", this.copyMask, new BufferDataAppSink.Listener(){

                public void bufferFrame(int n, int n2, Buffer buffer) {
                    Movie.this.invokeEvent(n, n2, buffer);
                }
            });
            this.natSink.setAutoDisposeBuffer(false);
            this.playbin.setVideoSink((Element)this.natSink);
            this.natSink.dispose();
        } else {
            this.rgbSink = new RGBDataAppSink("rgb", new RGBDataAppSink.Listener(){

                public void rgbFrame(int n, int n2, IntBuffer intBuffer) {
                    Movie.this.invokeEvent(n, n2, intBuffer);
                }
            });
            this.rgbSink.setPassDirectBuffer(Video.passDirectBuffer);
            this.playbin.setVideoSink((Element)this.rgbSink);
            this.rgbSink.dispose();
        }
        Bus bus = this.playbin.getBus();
        bus.connect(new Bus.EOS(){

            public void endOfStream(GstObject gstObject) {
                Movie.this.eosEvent();
            }
        });
        this.sinkReady = true;
        this.newFrame = false;
    }

    protected synchronized void invokeEvent(int n, int n2, IntBuffer intBuffer) {
        this.available = true;
        this.bufWidth = n;
        this.bufHeight = n2;
        if (this.copyPixels == null) {
            this.copyPixels = new int[n * n2];
        }
        intBuffer.rewind();
        try {
            intBuffer.get(this.copyPixels);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            bufferUnderflowException.printStackTrace();
            this.copyPixels = null;
            return;
        }
        if (this.playing) {
            this.fireMovieEvent();
        }
    }

    protected synchronized void invokeEvent(int n, int n2, Buffer buffer) {
        this.available = true;
        this.bufWidth = n;
        this.bufHeight = n2;
        if (this.natBuffer != null) {
            this.natBuffer.dispose();
        }
        this.natBuffer = buffer;
        if (this.playing) {
            this.fireMovieEvent();
        }
    }

    private void fireMovieEvent() {
        if (this.movieEventMethod != null) {
            try {
                this.movieEventMethod.invoke(this.eventHandler, new Object[]{this});
            }
            catch (Exception exception) {
                System.err.println("error, disabling movieEvent() for " + this.filename);
                exception.printStackTrace();
                this.movieEventMethod = null;
            }
        }
    }

    protected void eosEvent() {
        if (this.repeat) {
            if (0.0f < this.rate) {
                this.jump(0.0f);
            } else {
                this.jump(this.duration());
            }
            this.frameRate(this.frameRate);
        } else {
            this.playing = false;
        }
    }

    protected int getSourceHeight() {
        Dimension dimension = this.playbin.getVideoSize();
        if (dimension != null) {
            return dimension.height;
        }
        return 0;
    }

    protected float getSourceFrameRate() {
        return (float)this.playbin.getVideoSinkFrameRate();
    }

    protected int getSourceWidth() {
        Dimension dimension = this.playbin.getVideoSize();
        if (dimension != null) {
            return dimension.width;
        }
        return 0;
    }

    public void setBufferSink(Object object) {
        this.bufferSink = object;
        this.initCopyMask();
    }

    public void setBufferSink(Object object, String string) {
        this.bufferSink = object;
        this.copyMask = string;
    }

    public boolean hasBufferSink() {
        return this.bufferSink != null;
    }

    public synchronized void disposeBuffer(Object object) {
        ((Buffer)object).dispose();
    }

    protected void getSinkMethods() {
        try {
            this.sinkCopyMethod = this.bufferSink.getClass().getMethod("copyBufferFromSource", Object.class, ByteBuffer.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Exception exception) {
            throw new RuntimeException("Movie: provided sink object doesn't have a copyBufferFromSource method.");
        }
        try {
            this.sinkSetMethod = this.bufferSink.getClass().getMethod("setBufferSource", Object.class);
            this.sinkSetMethod.invoke(this.bufferSink, new Object[]{this});
        }
        catch (Exception exception) {
            throw new RuntimeException("Movie: provided sink object doesn't have a setBufferSource method.");
        }
        try {
            this.sinkDisposeMethod = this.bufferSink.getClass().getMethod("disposeSourceBuffer", new Class[0]);
        }
        catch (Exception exception) {
            throw new RuntimeException("Movie: provided sink object doesn't have a disposeSourceBuffer method.");
        }
        try {
            this.sinkGetMethod = this.bufferSink.getClass().getMethod("getBufferPixels", int[].class);
        }
        catch (Exception exception) {
            throw new RuntimeException("Movie: provided sink object doesn't have a getBufferPixels method.");
        }
    }

    protected void initCopyMask() {
        this.copyMask = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? "red_mask=(int)0xFF000000, green_mask=(int)0xFF0000, blue_mask=(int)0xFF00" : "red_mask=(int)0xFF, green_mask=(int)0xFF00, blue_mask=(int)0xFF0000";
    }

    public synchronized void post() {
        if (this.useBufferSink && this.sinkDisposeMethod != null) {
            try {
                this.sinkDisposeMethod.invoke(this.bufferSink, new Object[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

