/*
 * Decompiled with CFR 0.152.
 */
package processing.video;

import java.awt.Dimension;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.concurrent.TimeUnit;
import org.gstreamer.Buffer;
import org.gstreamer.Bus;
import org.gstreamer.Element;
import org.gstreamer.Format;
import org.gstreamer.GstObject;
import org.gstreamer.SeekType;
import org.gstreamer.elements.BufferDataAppSink;
import org.gstreamer.elements.PlayBin2;
import org.gstreamer.elements.RGBDataAppSink;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.video.Video;

public class Movie
extends PImage
implements PConstants {
    public static String[] supportedProtocols = new String[]{"http"};
    public float frameRate;
    public String filename;
    public PlayBin2 playbin;
    protected boolean playing = false;
    protected boolean paused = false;
    protected boolean repeat = false;
    protected float rate;
    protected int bufWidth;
    protected int bufHeight;
    protected float volume;
    protected Method movieEventMethod;
    protected Object eventHandler;
    protected boolean available;
    protected boolean sinkReady;
    protected boolean newFrame;
    protected RGBDataAppSink rgbSink = null;
    protected int[] copyPixels = null;
    protected boolean firstFrame = true;
    protected boolean seeking = false;
    protected boolean useBufferSink = false;
    protected boolean outdatedPixels = true;
    protected Object bufferSink;
    protected Method sinkCopyMethod;
    protected Method sinkSetMethod;
    protected Method sinkDisposeMethod;
    protected Method sinkGetMethod;
    protected String copyMask;
    protected Buffer natBuffer = null;
    protected BufferDataAppSink natSink = null;

    public Movie(PApplet parent, String filename) {
        super(0, 0, 1);
        this.initGStreamer(parent, filename);
    }

    public void dispose() {
        if (this.playbin != null) {
            try {
                if (this.playbin.isPlaying()) {
                    this.playbin.stop();
                    this.playbin.getState();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.pixels = null;
            this.copyPixels = null;
            if (this.rgbSink != null) {
                this.rgbSink.removeListener();
                this.rgbSink.dispose();
                this.rgbSink = null;
            }
            this.natBuffer = null;
            if (this.natSink != null) {
                this.natSink.removeListener();
                this.natSink.dispose();
                this.natSink = null;
            }
            this.playbin.dispose();
            this.playbin = null;
            this.parent.g.removeCache((PImage)this);
            this.parent.unregisterMethod("dispose", (Object)this);
            this.parent.unregisterMethod("post", (Object)this);
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        finally {
            super.finalize();
        }
    }

    public void frameRate(float ifps) {
        long stop;
        long start;
        float f;
        if (this.seeking) {
            return;
        }
        float f2 = f = 0.0f < ifps && 0.0f < this.frameRate ? ifps / this.frameRate : 1.0f;
        if (this.playing) {
            this.playbin.pause();
            this.playbin.getState();
        }
        long t = this.playbin.queryPosition(TimeUnit.NANOSECONDS);
        if (this.rate > 0.0f) {
            start = t;
            stop = -1L;
        } else {
            start = 0L;
            stop = t;
        }
        boolean res = this.playbin.seek((double)(this.rate * f), Format.TIME, 1, SeekType.SET, start, SeekType.SET, stop);
        this.playbin.getState();
        if (!res) {
            PGraphics.showWarning((String)"Seek operation failed.");
        }
        if (this.playing) {
            this.playbin.play();
        }
        this.frameRate = ifps;
        this.seeking = true;
        this.playbin.getState();
        this.seeking = false;
    }

    public void speed(float irate) {
        if ((double)PApplet.abs((float)(this.rate - irate)) > 0.1) {
            this.rate = irate;
            this.frameRate(this.frameRate);
        }
    }

    public float duration() {
        float sec = this.playbin.queryDuration().toSeconds();
        float nanosec = this.playbin.queryDuration().getNanoSeconds();
        return sec + Video.nanoSecToSecFrac(nanosec);
    }

    public float time() {
        float sec = this.playbin.queryPosition().toSeconds();
        float nanosec = this.playbin.queryPosition().getNanoSeconds();
        return sec + Video.nanoSecToSecFrac(nanosec);
    }

    public void jump(float where) {
        float fps;
        int frame;
        long pos;
        boolean res;
        if (this.seeking) {
            return;
        }
        if (!this.sinkReady) {
            this.initSink();
        }
        if (!(res = this.playbin.seek((double)this.rate, Format.TIME, 1, SeekType.SET, pos = Video.secToNanoLong(where = (float)(frame = (int)(where * (fps = this.getSourceFrameRate()))) / fps), SeekType.NONE, -1L))) {
            PGraphics.showWarning((String)"Seek operation failed.");
        }
        this.seeking = true;
        this.playbin.getState();
        this.seeking = false;
    }

    public boolean available() {
        return this.available;
    }

    public void play() {
        if (this.seeking) {
            return;
        }
        if (!this.sinkReady) {
            this.initSink();
        }
        this.playing = true;
        this.paused = false;
        this.playbin.play();
        this.playbin.getState();
    }

    public void loop() {
        if (this.seeking) {
            return;
        }
        this.repeat = true;
        this.play();
    }

    public void noLoop() {
        if (this.seeking) {
            return;
        }
        if (!this.sinkReady) {
            this.initSink();
        }
        this.repeat = false;
    }

    public void pause() {
        if (this.seeking) {
            return;
        }
        if (!this.sinkReady) {
            this.initSink();
        }
        this.playing = false;
        this.paused = true;
        this.playbin.pause();
        this.playbin.getState();
    }

    public void stop() {
        if (this.seeking) {
            return;
        }
        if (!this.sinkReady) {
            this.initSink();
        }
        if (this.playing) {
            this.jump(0.0f);
            this.playing = false;
        }
        this.paused = false;
        this.playbin.stop();
        this.playbin.getState();
    }

    public synchronized void read() {
        if (this.frameRate < 0.0f) {
            this.frameRate = this.getSourceFrameRate();
        }
        if (this.volume < 0.0f) {
            this.volume = (float)this.playbin.getVolume();
        }
        if (this.useBufferSink) {
            this.outdatedPixels = true;
            if (this.natBuffer == null) {
                return;
            }
            if (this.firstFrame) {
                super.init(this.bufWidth, this.bufHeight, 2, 1);
                this.firstFrame = false;
            }
            if (this.bufferSink == null) {
                Object cache = this.parent.g.getCache((PImage)this);
                if (cache == null) {
                    return;
                }
                this.setBufferSink(cache);
                this.getSinkMethods();
            }
            ByteBuffer byteBuffer = this.natBuffer.getByteBuffer();
            try {
                this.sinkCopyMethod.invoke(this.bufferSink, this.natBuffer, byteBuffer, this.bufWidth, this.bufHeight);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.natBuffer = null;
        } else {
            if (this.copyPixels == null) {
                return;
            }
            if (this.firstFrame) {
                super.init(this.bufWidth, this.bufHeight, 1, 1);
                this.firstFrame = false;
            }
            int[] temp = this.pixels;
            this.pixels = this.copyPixels;
            this.updatePixels();
            this.copyPixels = temp;
        }
        this.available = false;
        this.newFrame = true;
    }

    public void volume(float v) {
        if (this.playing && PApplet.abs((float)(this.volume - v)) > 0.001f) {
            this.playbin.setVolume((double)v);
            this.volume = v;
        }
    }

    public synchronized void loadPixels() {
        super.loadPixels();
        if (this.useBufferSink) {
            if (this.natBuffer != null) {
                IntBuffer buf = this.natBuffer.getByteBuffer().asIntBuffer();
                buf.rewind();
                buf.get(this.pixels);
                Video.convertToARGB(this.pixels, this.width, this.height);
            } else if (this.sinkGetMethod != null) {
                try {
                    this.sinkGetMethod.invoke(this.bufferSink, new Object[]{this.pixels});
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.outdatedPixels = false;
        }
    }

    public int get(int x, int y) {
        if (this.outdatedPixels) {
            this.loadPixels();
        }
        return super.get(x, y);
    }

    protected void getImpl(int sourceX, int sourceY, int sourceWidth, int sourceHeight, PImage target, int targetX, int targetY) {
        if (this.outdatedPixels) {
            this.loadPixels();
        }
        super.getImpl(sourceX, sourceY, sourceWidth, sourceHeight, target, targetX, targetY);
    }

    protected void initGStreamer(PApplet parent, String filename) {
        block15: {
            this.parent = parent;
            this.playbin = null;
            Video.init();
            try {
                File file;
                try {
                    file = new File(parent.dataPath(filename));
                    if (file.exists()) {
                        this.playbin = new PlayBin2("Movie Player");
                        this.playbin.setInputFile(file);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.playbin == null) {
                    try {
                        file = new File(filename);
                        if (file.exists()) {
                            this.playbin = new PlayBin2("Movie Player");
                            this.playbin.setInputFile(file);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (this.playbin != null) break block15;
                for (int i = 0; i < supportedProtocols.length; ++i) {
                    if (!filename.startsWith(supportedProtocols[i] + "://")) continue;
                    try {
                        this.playbin = new PlayBin2("Movie Player");
                        this.playbin.setURI(URI.create(filename));
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (SecurityException i) {
                // empty catch block
            }
        }
        if (this.playbin == null) {
            parent.die("Could not load movie file " + filename, null);
        }
        try {
            this.filename = filename;
            parent.registerMethod("dispose", (Object)this);
            parent.registerMethod("post", (Object)this);
            this.setEventHandlerObject(parent);
            this.rate = 1.0f;
            this.frameRate = -1.0f;
            this.volume = -1.0f;
            this.sinkReady = false;
            this.bufHeight = 0;
            this.bufWidth = 0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void setEventHandlerObject(Object obj) {
        this.eventHandler = obj;
        try {
            this.movieEventMethod = this.eventHandler.getClass().getMethod("movieEvent", Movie.class);
            return;
        }
        catch (Exception exception) {
            try {
                this.movieEventMethod = this.eventHandler.getClass().getMethod("movieEvent", Object.class);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return;
        }
    }

    protected void initSink() {
        if (this.bufferSink != null || Video.useGLBufferSink && this.parent.g.isGL()) {
            this.useBufferSink = true;
            if (this.bufferSink != null) {
                this.getSinkMethods();
            }
            if (this.copyMask == null || this.copyMask.equals("")) {
                this.initCopyMask();
            }
            this.natSink = new BufferDataAppSink("nat", this.copyMask, new BufferDataAppSink.Listener(){

                public void bufferFrame(int w, int h, Buffer buffer) {
                    Movie.this.invokeEvent(w, h, buffer);
                }
            });
            this.natSink.setAutoDisposeBuffer(false);
            this.playbin.setVideoSink((Element)this.natSink);
            this.natSink.dispose();
        } else {
            this.rgbSink = new RGBDataAppSink("rgb", new RGBDataAppSink.Listener(){

                public void rgbFrame(int w, int h, IntBuffer buffer) {
                    Movie.this.invokeEvent(w, h, buffer);
                }
            });
            this.rgbSink.setPassDirectBuffer(Video.passDirectBuffer);
            this.playbin.setVideoSink((Element)this.rgbSink);
            this.rgbSink.dispose();
        }
        Bus bus = this.playbin.getBus();
        bus.connect(new Bus.EOS(){

            public void endOfStream(GstObject element) {
                Movie.this.eosEvent();
            }
        });
        this.sinkReady = true;
        this.newFrame = false;
    }

    protected synchronized void invokeEvent(int w, int h, IntBuffer buffer) {
        this.available = true;
        this.bufWidth = w;
        this.bufHeight = h;
        if (this.copyPixels == null) {
            this.copyPixels = new int[w * h];
        }
        buffer.rewind();
        try {
            buffer.get(this.copyPixels);
        }
        catch (BufferUnderflowException e) {
            e.printStackTrace();
            this.copyPixels = null;
            return;
        }
        if (this.playing) {
            this.fireMovieEvent();
        }
    }

    protected synchronized void invokeEvent(int w, int h, Buffer buffer) {
        this.available = true;
        this.bufWidth = w;
        this.bufHeight = h;
        if (this.natBuffer != null) {
            this.natBuffer.dispose();
        }
        this.natBuffer = buffer;
        if (this.playing) {
            this.fireMovieEvent();
        }
    }

    private void fireMovieEvent() {
        if (this.movieEventMethod != null) {
            try {
                this.movieEventMethod.invoke(this.eventHandler, new Object[]{this});
            }
            catch (Exception e) {
                System.err.println("error, disabling movieEvent() for " + this.filename);
                e.printStackTrace();
                this.movieEventMethod = null;
            }
        }
    }

    protected void eosEvent() {
        if (this.repeat) {
            if (0.0f < this.rate) {
                this.jump(0.0f);
            } else {
                this.jump(this.duration());
            }
            this.frameRate(this.frameRate);
        } else {
            this.playing = false;
        }
    }

    protected int getSourceHeight() {
        Dimension dim = this.playbin.getVideoSize();
        if (dim != null) {
            return dim.height;
        }
        return 0;
    }

    protected float getSourceFrameRate() {
        return (float)this.playbin.getVideoSinkFrameRate();
    }

    protected int getSourceWidth() {
        Dimension dim = this.playbin.getVideoSize();
        if (dim != null) {
            return dim.width;
        }
        return 0;
    }

    public void setBufferSink(Object sink) {
        this.bufferSink = sink;
        this.initCopyMask();
    }

    public void setBufferSink(Object sink, String mask) {
        this.bufferSink = sink;
        this.copyMask = mask;
    }

    public boolean hasBufferSink() {
        return this.bufferSink != null;
    }

    public synchronized void disposeBuffer(Object buf) {
        ((Buffer)buf).dispose();
    }

    protected void getSinkMethods() {
        try {
            this.sinkCopyMethod = this.bufferSink.getClass().getMethod("copyBufferFromSource", Object.class, ByteBuffer.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Exception e) {
            throw new RuntimeException("Movie: provided sink object doesn't have a copyBufferFromSource method.");
        }
        try {
            this.sinkSetMethod = this.bufferSink.getClass().getMethod("setBufferSource", Object.class);
            this.sinkSetMethod.invoke(this.bufferSink, new Object[]{this});
        }
        catch (Exception e) {
            throw new RuntimeException("Movie: provided sink object doesn't have a setBufferSource method.");
        }
        try {
            this.sinkDisposeMethod = this.bufferSink.getClass().getMethod("disposeSourceBuffer", new Class[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Movie: provided sink object doesn't have a disposeSourceBuffer method.");
        }
        try {
            this.sinkGetMethod = this.bufferSink.getClass().getMethod("getBufferPixels", int[].class);
        }
        catch (Exception e) {
            throw new RuntimeException("Movie: provided sink object doesn't have a getBufferPixels method.");
        }
    }

    protected void initCopyMask() {
        this.copyMask = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? "red_mask=(int)0xFF000000, green_mask=(int)0xFF0000, blue_mask=(int)0xFF00" : "red_mask=(int)0xFF, green_mask=(int)0xFF00, blue_mask=(int)0xFF0000";
    }

    public synchronized void post() {
        if (this.useBufferSink && this.sinkDisposeMethod != null) {
            try {
                this.sinkDisposeMethod.invoke(this.bufferSink, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

