/*
 * Decompiled with CFR 0.152.
 */
package processing.video;

import java.io.File;
import java.lang.reflect.Method;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.ArrayList;
import org.gstreamer.Buffer;
import org.gstreamer.Caps;
import org.gstreamer.Element;
import org.gstreamer.ElementFactory;
import org.gstreamer.Fraction;
import org.gstreamer.Pad;
import org.gstreamer.Pipeline;
import org.gstreamer.Structure;
import org.gstreamer.ValueList;
import org.gstreamer.elements.BufferDataAppSink;
import org.gstreamer.elements.RGBDataAppSink;
import org.gstreamer.interfaces.Property;
import org.gstreamer.interfaces.PropertyProbe;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.video.Video;

public class Capture
extends PImage
implements PConstants {
    protected static String sourceElementName;
    protected static String devicePropertyName;
    protected static String indexPropertyName;
    protected static boolean useResMacHack;
    public float frameRate;
    public Pipeline pipeline;
    protected boolean capturing = false;
    protected String frameRateString;
    protected int bufWidth;
    protected int bufHeight;
    protected String sourceName;
    protected Element sourceElement;
    protected Method captureEventMethod;
    protected Object eventHandler;
    protected boolean available;
    protected boolean pipelineReady;
    protected boolean newFrame;
    protected RGBDataAppSink rgbSink = null;
    protected int[] copyPixels = null;
    protected boolean firstFrame = true;
    protected int reqWidth;
    protected int reqHeight;
    protected boolean useBufferSink = false;
    protected boolean outdatedPixels = true;
    protected Object bufferSink;
    protected Method sinkCopyMethod;
    protected Method sinkSetMethod;
    protected Method sinkDisposeMethod;
    protected Method sinkGetMethod;
    protected String copyMask;
    protected Buffer natBuffer = null;
    protected BufferDataAppSink natSink = null;

    public Capture(PApplet parent) {
        Object idValue;
        String idName;
        String[] configs = Capture.list();
        if (configs.length == 0) {
            throw new RuntimeException("There are no cameras available for capture");
        }
        String name = this.getName(configs[0]);
        int[] size = this.getSize(configs[0]);
        String fps = this.getFrameRate(configs[0]);
        if (devicePropertyName.equals("")) {
            idName = indexPropertyName;
            idValue = new Integer(PApplet.parseInt((String)name));
        } else {
            idName = devicePropertyName;
            idValue = name;
        }
        this.initGStreamer(parent, size[0], size[1], sourceElementName, idName, idValue, fps);
    }

    public Capture(PApplet parent, String requestConfig) {
        Object idValue;
        String idName;
        String name = this.getName(requestConfig);
        int[] size = this.getSize(requestConfig);
        String fps = this.getFrameRate(requestConfig);
        if (devicePropertyName.equals("")) {
            idName = indexPropertyName;
            idValue = new Integer(PApplet.parseInt((String)name));
        } else {
            idName = devicePropertyName;
            idValue = name;
        }
        this.initGStreamer(parent, size[0], size[1], sourceElementName, idName, idValue, fps);
    }

    public Capture(PApplet parent, int requestWidth, int requestHeight) {
        super(requestWidth, requestHeight, 1);
        this.initGStreamer(parent, requestWidth, requestHeight, sourceElementName, null, null, "");
    }

    public Capture(PApplet parent, int requestWidth, int requestHeight, int frameRate) {
        super(requestWidth, requestHeight, 1);
        this.initGStreamer(parent, requestWidth, requestHeight, sourceElementName, null, null, frameRate + "/1");
    }

    public Capture(PApplet parent, int requestWidth, int requestHeight, String cameraName) {
        super(requestWidth, requestHeight, 1);
        Object idValue;
        String idName;
        if (-1 < cameraName.indexOf("name=")) {
            cameraName = this.getName(cameraName);
        }
        if (devicePropertyName.equals("")) {
            idName = indexPropertyName;
            idValue = new Integer(PApplet.parseInt((String)cameraName));
        } else {
            idName = devicePropertyName;
            idValue = cameraName;
        }
        this.initGStreamer(parent, requestWidth, requestHeight, sourceElementName, idName, idValue, "");
    }

    public Capture(PApplet parent, int requestWidth, int requestHeight, String cameraName, int frameRate) {
        super(requestWidth, requestHeight, 1);
        Object idValue;
        String idName;
        if (-1 < cameraName.indexOf("name=")) {
            cameraName = this.getName(cameraName);
        }
        if (devicePropertyName.equals("")) {
            idName = indexPropertyName;
            idValue = new Integer(PApplet.parseInt((String)cameraName));
        } else {
            idName = devicePropertyName;
            idValue = cameraName;
        }
        this.initGStreamer(parent, requestWidth, requestHeight, sourceElementName, idName, idValue, frameRate + "/1");
    }

    public void dispose() {
        if (this.pipeline != null) {
            try {
                if (this.pipeline.isPlaying()) {
                    this.pipeline.stop();
                    this.pipeline.getState();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.pixels = null;
            this.copyPixels = null;
            if (this.rgbSink != null) {
                this.rgbSink.removeListener();
                this.rgbSink.dispose();
                this.rgbSink = null;
            }
            this.natBuffer = null;
            if (this.natSink != null) {
                this.natSink.removeListener();
                this.natSink.dispose();
                this.natSink = null;
            }
            this.pipeline.dispose();
            this.pipeline = null;
            this.parent.g.removeCache((PImage)this);
            this.parent.unregisterMethod("dispose", (Object)this);
            this.parent.unregisterMethod("post", (Object)this);
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        finally {
            super.finalize();
        }
    }

    public boolean available() {
        return this.available;
    }

    public void start() {
        boolean init = false;
        if (!this.pipelineReady) {
            this.initPipeline();
            init = true;
        }
        this.capturing = true;
        this.pipeline.play();
        if (init) {
            this.checkResIsValid();
        }
    }

    public void stop() {
        if (!this.pipelineReady) {
            this.initPipeline();
        }
        this.capturing = false;
        this.pipeline.stop();
        this.pipeline.getState();
    }

    public synchronized void read() {
        if (this.frameRate < 0.0f) {
            this.frameRate = this.getSourceFrameRate();
        }
        if (this.useBufferSink) {
            this.outdatedPixels = true;
            if (this.natBuffer == null) {
                return;
            }
            if (this.firstFrame) {
                super.init(this.bufWidth, this.bufHeight, 2, 1);
                this.firstFrame = false;
            }
            if (this.bufferSink == null) {
                Object cache = this.parent.g.getCache((PImage)this);
                if (cache == null) {
                    return;
                }
                this.setBufferSink(cache);
                this.getSinkMethods();
            }
            ByteBuffer byteBuffer = this.natBuffer.getByteBuffer();
            try {
                this.sinkCopyMethod.invoke(this.bufferSink, this.natBuffer, byteBuffer, this.bufWidth, this.bufHeight);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.natBuffer = null;
        } else {
            if (this.copyPixels == null) {
                return;
            }
            if (this.firstFrame) {
                super.init(this.bufWidth, this.bufHeight, 1, 1);
                this.firstFrame = false;
            }
            int[] temp = this.pixels;
            this.pixels = this.copyPixels;
            this.updatePixels();
            this.copyPixels = temp;
        }
        this.available = false;
        this.newFrame = true;
    }

    public synchronized void loadPixels() {
        super.loadPixels();
        if (this.useBufferSink) {
            if (this.natBuffer != null) {
                IntBuffer buf = this.natBuffer.getByteBuffer().asIntBuffer();
                buf.rewind();
                buf.get(this.pixels);
                Video.convertToARGB(this.pixels, this.width, this.height);
            } else if (this.sinkGetMethod != null) {
                try {
                    this.sinkGetMethod.invoke(this.bufferSink, new Object[]{this.pixels});
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.outdatedPixels = false;
        }
    }

    public int get(int x, int y) {
        if (this.outdatedPixels) {
            this.loadPixels();
        }
        return super.get(x, y);
    }

    protected void getImpl(int sourceX, int sourceY, int sourceWidth, int sourceHeight, PImage target, int targetX, int targetY) {
        if (this.outdatedPixels) {
            this.loadPixels();
        }
        super.getImpl(sourceX, sourceY, sourceWidth, sourceHeight, target, targetX, targetY);
    }

    public static String[] list() {
        if (devicePropertyName.equals("")) {
            return Capture.list(sourceElementName, indexPropertyName);
        }
        return Capture.list(sourceElementName, devicePropertyName);
    }

    protected static String[] list(String sourceName, String propertyName) {
        Video.init();
        ArrayList<String> devices = Capture.listDevices(sourceName, propertyName);
        ArrayList<String> configList = new ArrayList<String>();
        for (String device : devices) {
            ArrayList<String> resolutions = Capture.listResolutions(sourceName, propertyName, device);
            if (0 < resolutions.size()) {
                for (String res : resolutions) {
                    configList.add("name=" + device + "," + res);
                }
                continue;
            }
            configList.add("name=" + device);
        }
        String[] configs = new String[configList.size()];
        for (int i = 0; i < configs.length; ++i) {
            configs[i] = (String)configList.get(i);
        }
        return configs;
    }

    protected static ArrayList<String> listDevices(String sourceName, String propertyName) {
        ArrayList<String> devices = new ArrayList<String>();
        try {
            Object[] values;
            Property property;
            Element videoSource = ElementFactory.make((String)sourceName, (String)"Source");
            PropertyProbe probe = PropertyProbe.wrap((Element)videoSource);
            if (probe != null && (property = probe.getProperty(propertyName)) != null && (values = probe.getValues(property)) != null) {
                for (int i = 0; i < values.length; ++i) {
                    if (values[i] instanceof String) {
                        devices.add((String)values[i]);
                        continue;
                    }
                    if (!(values[i] instanceof Integer)) continue;
                    devices.add(((Integer)values[i]).toString());
                }
            }
        }
        catch (IllegalArgumentException e) {
            if (PApplet.platform == 3) {
                devices = new ArrayList();
                String dir = "/dev";
                File libPath = new File(dir);
                String[] files = libPath.list();
                if (files != null) {
                    for (int i = 0; i < files.length; ++i) {
                        if (-1 >= files[i].indexOf("video")) continue;
                        devices.add("/dev/" + files[i]);
                    }
                }
            }
            PGraphics.showWarning((String)"The capture plugin does not support device query!");
            devices = new ArrayList();
        }
        return devices;
    }

    protected static ArrayList<String> listResolutions(String sourceName, String propertyName, Object propertyValue) {
        Pipeline testPipeline = new Pipeline("test");
        Element source = ElementFactory.make((String)sourceName, (String)"source");
        source.set(propertyName, propertyValue);
        BufferDataAppSink sink = new BufferDataAppSink("sink", "", new BufferDataAppSink.Listener(){

            public void bufferFrame(int w, int h, Buffer buffer) {
            }
        });
        testPipeline.addMany(new Element[]{source, sink});
        Element.linkMany((Element[])new Element[]{source, sink});
        testPipeline.play();
        testPipeline.getState();
        testPipeline.pause();
        testPipeline.getState();
        ArrayList<String> resolutions = new ArrayList<String>();
        Capture.addResFromSource(resolutions, source);
        testPipeline.stop();
        testPipeline.getState();
        if (sink != null) {
            sink.removeListener();
            sink.dispose();
        }
        testPipeline.dispose();
        return resolutions;
    }

    protected static void addResFromSource(ArrayList<String> res, Element src) {
        if (PApplet.platform == 2 && useResMacHack) {
            Capture.addResFromSourceMacHack(res, src);
        } else {
            Capture.addResFromSourceImpl(res, src);
        }
    }

    protected static void addResFromSourceImpl(ArrayList<String> res, Element src) {
        for (Pad pad : src.getPads()) {
            Caps caps = pad.getCaps();
            int n = caps.size();
            for (int i = 0; i < n; ++i) {
                Structure str = caps.getStructure(i);
                if (!str.hasIntField("width") || !str.hasIntField("height")) continue;
                int w = (Integer)str.getValue("width");
                int h = (Integer)str.getValue("height");
                if (PApplet.platform == 1) {
                    Capture.addResFromString(res, str.toString(), w, h);
                    continue;
                }
                Capture.addResFromStructure(res, str, w, h);
            }
        }
    }

    protected static void addResFromSourceMacHack(ArrayList<String> res, Element src) {
        block2: for (Pad pad : src.getPads()) {
            Caps caps = pad.getNegotiatedCaps();
            int n = caps.size();
            if (0 >= n) continue;
            Structure str = caps.getStructure(0);
            if (!str.hasIntField("width") || !str.hasIntField("height")) {
                return;
            }
            int w = (Integer)str.getValue("width");
            int h = (Integer)str.getValue("height");
            while (80 <= w) {
                int num = 30;
                int den = 1;
                try {
                    Fraction fr = str.getFraction("framerate");
                    num = fr.numerator;
                    den = fr.denominator;
                }
                catch (Exception e) {
                    // empty catch block
                }
                res.add(Capture.makeResolutionString(w, h, num, den));
                if (num == 30 && den == 1) {
                    res.add(Capture.makeResolutionString(w, h, 15, 1));
                    res.add(Capture.makeResolutionString(w, h, 1, 1));
                }
                if (w % 2 != 0 || h % 2 != 0) continue block2;
                w /= 2;
                h /= 2;
            }
        }
    }

    protected static void addResFromString(ArrayList<String> res, String str, int w, int h) {
        int n0 = str.indexOf("framerate=(fraction)");
        if (-1 < n0) {
            String temp = str.substring(n0 + 20, str.length());
            int n1 = temp.indexOf("[");
            int n2 = temp.indexOf("]");
            if (-1 < n1 && -1 < n2) {
                temp = temp.substring(n1 + 1, n2);
                String[] fractions = temp.split(",");
                for (int k = 0; k < fractions.length; ++k) {
                    String fpsStr = fractions[k].trim();
                    res.add(Capture.makeResolutionString(w, h, fpsStr));
                }
            } else {
                int n3 = temp.indexOf(",");
                int n4 = temp.indexOf(";");
                if (-1 < n3 || -1 < n4) {
                    int n5 = -1;
                    n5 = n3 == -1 ? n4 : (n4 == -1 ? n3 : PApplet.min((int)n3, (int)n4));
                    temp = temp.substring(0, n5);
                    String fpsStr = temp.trim();
                    res.add(Capture.makeResolutionString(w, h, fpsStr));
                }
            }
        }
    }

    protected static void addResFromStructure(ArrayList<String> res, Structure str, int w, int h) {
        boolean singleFrac = false;
        try {
            Fraction fr = str.getFraction("framerate");
            res.add(Capture.makeResolutionString(w, h, fr.numerator, fr.denominator));
            singleFrac = true;
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!singleFrac) {
            ValueList flist = null;
            try {
                flist = str.getValueList("framerate");
            }
            catch (Exception e) {
                // empty catch block
            }
            if (flist != null) {
                for (int k = 0; k < flist.getSize(); ++k) {
                    Fraction fr = flist.getFraction(k);
                    res.add(Capture.makeResolutionString(w, h, fr.numerator, fr.denominator));
                }
            }
        }
    }

    protected static String makeResolutionString(int width, int height, int fpsNumerator, int fpsDenominator) {
        String res = "size=" + width + "x" + height + ",fps=" + fpsNumerator;
        if (fpsDenominator != 1) {
            res = res + "/" + fpsDenominator;
        }
        return res;
    }

    protected static String makeResolutionString(int width, int height, String fpsStr) {
        String res = "size=" + width + "x" + height;
        String[] parts = fpsStr.split("/");
        if (parts.length == 2) {
            int fpsNumerator = PApplet.parseInt((String)parts[0]);
            int fpsDenominator = PApplet.parseInt((String)parts[1]);
            res = res + ",fps=" + fpsNumerator;
            if (fpsDenominator != 1) {
                res = res + "/" + fpsDenominator;
            }
        }
        return res;
    }

    protected void checkResIsValid() {
        ArrayList<String> resolutions = new ArrayList<String>();
        Capture.addResFromSource(resolutions, this.sourceElement);
        boolean valid = resolutions.size() == 0;
        for (String res : resolutions) {
            if (!this.validRes(res)) continue;
            valid = true;
            break;
        }
        if (!valid) {
            String fpsStr = "";
            if (!this.frameRateString.equals("")) {
                fpsStr = ", " + this.frameRateString + "fps";
            }
            throw new RuntimeException("The requested resolution of " + this.reqWidth + "x" + this.reqHeight + fpsStr + " is not supported by the selected capture " + "device.\n");
        }
    }

    protected void checkValidDevices(String src) {
        ArrayList<String> devices = devicePropertyName.equals("") ? Capture.listDevices(src, indexPropertyName) : Capture.listDevices(src, devicePropertyName);
        if (devices.size() == 0) {
            throw new RuntimeException("There are no capture devices connected to this computer.\n");
        }
    }

    protected boolean validRes(String res) {
        int[] size = this.getSize(res);
        String fps = this.getFrameRate(res);
        return (this.reqWidth == 0 || this.reqHeight == 0 || size[0] == this.reqWidth && size[1] == this.reqHeight) && (this.frameRateString.equals("") || this.frameRateString.equals(fps));
    }

    protected void initGStreamer(PApplet parent, int rw, int rh, String src, String idName, Object idValue, String fps) {
        this.parent = parent;
        Video.init();
        this.checkValidDevices(src);
        parent.registerMethod("dispose", (Object)this);
        parent.registerMethod("post", (Object)this);
        this.setEventHandlerObject(parent);
        this.pipeline = new Pipeline("Video Capture");
        this.frameRateString = fps;
        if (this.frameRateString.equals("")) {
            this.frameRate = -1.0f;
        } else {
            String[] parts = this.frameRateString.split("/");
            if (parts.length == 2) {
                int fpsDenominator = PApplet.parseInt((String)parts[0]);
                int fpsNumerator = PApplet.parseInt((String)parts[1]);
                this.frameRate = (float)fpsDenominator / (float)fpsNumerator;
            } else if (parts.length == 1) {
                this.frameRateString = this.frameRateString + "/1";
                this.frameRate = PApplet.parseFloat((String)parts[0]);
            } else {
                this.frameRateString = "";
                this.frameRate = -1.0f;
            }
        }
        this.reqWidth = rw;
        this.reqHeight = rh;
        this.sourceName = src;
        this.sourceElement = ElementFactory.make((String)src, (String)"Source");
        if (idName != null && !idName.equals("")) {
            this.sourceElement.set(idName, idValue);
        }
        this.bufHeight = 0;
        this.bufWidth = 0;
        this.pipelineReady = false;
    }

    protected void initPipeline() {
        String whStr = "";
        if (0 < this.reqWidth && 0 < this.reqHeight) {
            whStr = "width=" + this.reqWidth + ", height=" + this.reqHeight;
        } else {
            PGraphics.showWarning((String)"Resolution information not available, attempting to open the capture device at 320x240");
            whStr = "width=320, height=240";
        }
        String fpsStr = "";
        if (!this.frameRateString.equals("")) {
            fpsStr = ", framerate=" + this.frameRateString;
        }
        if (this.bufferSink != null || Video.useGLBufferSink && this.parent.g.isGL()) {
            this.useBufferSink = true;
            if (this.bufferSink != null) {
                this.getSinkMethods();
            }
            if (this.copyMask == null || this.copyMask.equals("")) {
                this.initCopyMask();
            }
            String caps = whStr + fpsStr + ", " + this.copyMask;
            this.natSink = new BufferDataAppSink("nat", caps, new BufferDataAppSink.Listener(){

                public void bufferFrame(int w, int h, Buffer buffer) {
                    Capture.this.invokeEvent(w, h, buffer);
                }
            });
            this.natSink.setAutoDisposeBuffer(false);
            this.pipeline.addMany(new Element[]{this.sourceElement, this.natSink});
            Element.linkMany((Element[])new Element[]{this.sourceElement, this.natSink});
        } else {
            Element conv = ElementFactory.make((String)"ffmpegcolorspace", (String)"ColorConverter");
            Element videofilter = ElementFactory.make((String)"capsfilter", (String)"ColorFilter");
            videofilter.setCaps(new Caps("video/x-raw-rgb, width=" + this.reqWidth + ", height=" + this.reqHeight + ", bpp=32, depth=24" + fpsStr));
            this.rgbSink = new RGBDataAppSink("rgb", new RGBDataAppSink.Listener(){

                public void rgbFrame(int w, int h, IntBuffer buffer) {
                    Capture.this.invokeEvent(w, h, buffer);
                }
            });
            this.rgbSink.setPassDirectBuffer(Video.passDirectBuffer);
            this.pipeline.addMany(new Element[]{this.sourceElement, conv, videofilter, this.rgbSink});
            Element.linkMany((Element[])new Element[]{this.sourceElement, conv, videofilter, this.rgbSink});
        }
        this.pipelineReady = true;
        this.newFrame = false;
    }

    protected void setEventHandlerObject(Object obj) {
        this.eventHandler = obj;
        try {
            this.captureEventMethod = obj.getClass().getMethod("captureEvent", Capture.class);
            return;
        }
        catch (Exception e) {
            try {
                this.captureEventMethod = obj.getClass().getMethod("captureEvent", Object.class);
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    protected synchronized void invokeEvent(int w, int h, IntBuffer buffer) {
        this.available = true;
        this.bufWidth = w;
        this.bufHeight = h;
        if (this.copyPixels == null) {
            this.copyPixels = new int[w * h];
        }
        buffer.rewind();
        try {
            buffer.get(this.copyPixels);
        }
        catch (BufferUnderflowException e) {
            e.printStackTrace();
            this.copyPixels = null;
            return;
        }
        this.fireCaptureEvent();
    }

    protected synchronized void invokeEvent(int w, int h, Buffer buffer) {
        this.available = true;
        this.bufWidth = w;
        this.bufHeight = h;
        if (this.natBuffer != null) {
            this.natBuffer.dispose();
        }
        this.natBuffer = buffer;
        this.fireCaptureEvent();
    }

    private void fireCaptureEvent() {
        if (this.captureEventMethod != null) {
            try {
                this.captureEventMethod.invoke(this.eventHandler, new Object[]{this});
            }
            catch (Exception e) {
                System.err.println("error, disabling captureEvent()");
                e.printStackTrace();
                this.captureEventMethod = null;
            }
        }
    }

    protected float getSourceFrameRate() {
        for (Element sink : this.pipeline.getSinks()) {
            for (Pad pad : sink.getPads()) {
                Fraction frameRate = org.gstreamer.Video.getVideoFrameRate((Pad)pad);
                if (frameRate == null) continue;
                return (float)frameRate.toDouble();
            }
        }
        return 0.0f;
    }

    protected String getName(String config) {
        String[] parts;
        String name = "";
        for (String part : parts = PApplet.split((String)config, (char)',')) {
            String[] values;
            if (-1 >= part.indexOf("name") || 0 >= (values = PApplet.split((String)part, (char)'=')).length) continue;
            name = values[1];
        }
        return name;
    }

    protected int[] getSize(String config) {
        String[] parts;
        int[] wh = new int[]{0, 0};
        for (String part : parts = PApplet.split((String)config, (char)',')) {
            String[] whstr;
            String[] values;
            if (-1 >= part.indexOf("size") || 0 >= (values = PApplet.split((String)part, (char)'=')).length || (whstr = PApplet.split((String)values[1], (char)'x')).length != 2) continue;
            wh[0] = PApplet.parseInt((String)whstr[0]);
            wh[1] = PApplet.parseInt((String)whstr[1]);
        }
        return wh;
    }

    protected String getFrameRate(String config) {
        String[] parts;
        String fps = "";
        for (String part : parts = PApplet.split((String)config, (char)',')) {
            String[] values;
            if (-1 >= part.indexOf("fps") || 0 >= (values = PApplet.split((String)part, (char)'=')).length || (fps = values[1]).indexOf("/") != -1) continue;
            fps = fps + "/1";
        }
        return fps;
    }

    public void setBufferSink(Object sink) {
        this.bufferSink = sink;
        this.initCopyMask();
    }

    public void setBufferSink(Object sink, String mask) {
        this.bufferSink = sink;
        this.copyMask = mask;
    }

    public boolean hasBufferSink() {
        return this.bufferSink != null;
    }

    public synchronized void disposeBuffer(Object buf) {
        ((Buffer)buf).dispose();
    }

    protected void getSinkMethods() {
        try {
            this.sinkCopyMethod = this.bufferSink.getClass().getMethod("copyBufferFromSource", Object.class, ByteBuffer.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Exception e) {
            throw new RuntimeException("Capture: provided sink object doesn't have a copyBufferFromSource method.");
        }
        try {
            this.sinkSetMethod = this.bufferSink.getClass().getMethod("setBufferSource", Object.class);
            this.sinkSetMethod.invoke(this.bufferSink, new Object[]{this});
        }
        catch (Exception e) {
            throw new RuntimeException("Capture: provided sink object doesn't have a setBufferSource method.");
        }
        try {
            this.sinkDisposeMethod = this.bufferSink.getClass().getMethod("disposeSourceBuffer", new Class[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Capture: provided sink object doesn't have a disposeSourceBuffer method.");
        }
        try {
            this.sinkGetMethod = this.bufferSink.getClass().getMethod("getBufferPixels", int[].class);
        }
        catch (Exception e) {
            throw new RuntimeException("Capture: provided sink object doesn't have a getBufferPixels method.");
        }
    }

    protected void initCopyMask() {
        this.copyMask = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? "red_mask=(int)0xFF000000, green_mask=(int)0xFF0000, blue_mask=(int)0xFF00" : "red_mask=(int)0xFF, green_mask=(int)0xFF00, blue_mask=(int)0xFF0000";
    }

    public synchronized void post() {
        if (this.useBufferSink && this.sinkDisposeMethod != null) {
            try {
                this.sinkDisposeMethod.invoke(this.bufferSink, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static {
        if (PApplet.platform == 2) {
            sourceElementName = "qtkitvideosrc";
            devicePropertyName = "device-name";
            indexPropertyName = "device-index";
        } else if (PApplet.platform == 1) {
            sourceElementName = "ksvideosrc";
            devicePropertyName = "device-name";
            indexPropertyName = "device-index";
        } else if (PApplet.platform == 3) {
            sourceElementName = "v4l2src";
            devicePropertyName = "device";
            indexPropertyName = "device-fd";
        }
        useResMacHack = true;
    }
}

