/*
 * Decompiled with CFR 0.152.
 */
package processing.video;

import java.io.File;
import java.nio.ByteOrder;
import java.util.List;
import org.gstreamer.Gst;
import org.gstreamer.Plugin;
import org.gstreamer.Registry;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.video.LibraryLoader;
import processing.video.LibraryPath;

public class Video
implements PConstants {
    protected static String gstreamerLibPath = "";
    protected static String gstreamerPluginPath = "";
    protected static boolean passDirectBuffer = true;
    protected static boolean useGLBufferSink = true;
    protected static boolean defaultGLibContext = false;
    protected static long INSTANCES_COUNT = 0L;
    protected static int bitsJVM = PApplet.parseInt((String)System.getProperty("sun.arch.data.model"));

    protected static void init() {
        if (INSTANCES_COUNT == 0L) {
            Video.initImpl();
        }
        ++INSTANCES_COUNT;
    }

    protected static void restart() {
        Video.removePlugins();
        Gst.deinit();
        Video.initImpl();
    }

    protected static void initImpl() {
        LibraryLoader loader;
        String libPath = System.getProperty("gstreamer.library.path");
        if (libPath != null) {
            gstreamerLibPath = libPath;
            String pluginPath = System.getProperty("gstreamer.plugin.path");
            if (pluginPath != null) {
                gstreamerPluginPath = pluginPath;
            }
        } else if (PApplet.platform == 3) {
            Video.buildLinuxPaths();
        } else if (PApplet.platform == 1) {
            Video.buildWindowsPaths();
        } else if (PApplet.platform == 2) {
            Video.buildMacOSXPaths();
        }
        if (!gstreamerLibPath.equals("")) {
            System.setProperty("jna.library.path", gstreamerLibPath);
        }
        if (PApplet.platform == 1 && (loader = LibraryLoader.getInstance()) == null) {
            System.err.println("Cannot load local version of GStreamer libraries.");
        }
        String[] args = new String[]{""};
        Gst.setUseDefaultContext((boolean)defaultGLibContext);
        Gst.init((String)"Processing core video", (String[])args);
        Video.addPlugins();
    }

    protected static void addPlugins() {
        Registry reg;
        boolean res;
        if (!gstreamerPluginPath.equals("") && !(res = (reg = Registry.getDefault()).scanPath(gstreamerPluginPath))) {
            System.err.println("Cannot load GStreamer plugins from " + gstreamerPluginPath);
        }
    }

    protected static void removePlugins() {
        Registry reg = Registry.getDefault();
        List list = reg.getPluginList();
        for (Plugin plg : list) {
            reg.removePlugin(plg);
        }
    }

    protected static void buildLinuxPaths() {
        gstreamerLibPath = "";
        gstreamerPluginPath = "";
    }

    protected static void buildWindowsPaths() {
        LibraryPath libPath = new LibraryPath();
        String path = libPath.get();
        gstreamerLibPath = Video.buildGStreamerLibPath(path, "\\windows" + bitsJVM);
        gstreamerPluginPath = gstreamerLibPath + "\\plugins";
    }

    protected static void buildMacOSXPaths() {
        LibraryPath libPath = new LibraryPath();
        String path = libPath.get();
        gstreamerLibPath = Video.buildGStreamerLibPath(path, "/macosx" + bitsJVM);
        gstreamerPluginPath = gstreamerLibPath + "/plugins";
    }

    protected static String buildGStreamerLibPath(String base, String os) {
        File path = new File(base + os);
        if (path.exists()) {
            return base + os;
        }
        return base;
    }

    protected static float nanoSecToSecFrac(float nanosec) {
        for (int i = 0; i < 3; ++i) {
            nanosec = (float)((double)nanosec / 1000.0);
        }
        return nanosec;
    }

    protected static long secToNanoLong(float sec) {
        Float f = new Float((double)sec * 1.0E9);
        return f.longValue();
    }

    protected static void convertToARGB(int[] pixels, int width, int height) {
        int t = 0;
        int p = 0;
        if (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int pixel = pixels[p++];
                    pixels[t++] = pixel >>> 8 | pixel << 24 & 0xFF000000;
                }
            }
        } else {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int pixel = pixels[p++];
                    pixels[t++] = (pixel & 0xFF) << 16 | (pixel & 0xFF0000) >> 16 | pixel & 0xFF00FF00;
                }
            }
        }
    }
}

