/*
 * This code is made available under the terms of the Eclipse Public License v1.0
 * in the github project https://github.com/project-husky/husky there you also
 * find a list of the contributors and the license information.
 *
 * This project has been developed further and modified by the joined working group Husky
 * on the basis of the eHealth Connector opensource project from June 28, 2021,
 * whereas medshare GmbH is the initial and main contributor/author of the eHealth Connector.
 */
package org.projecthusky.cda.elga.generated.artdecor.base.enums;

import java.util.Objects;
import javax.annotation.processing.Generated;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

/**
 * Enumeration of ELGA_SpecimenType values
 * <p>
 * EN: No designation found.<br>
 * DE: No designation found.<br>
 * FR: No designation found.<br>
 * IT: No designation found.<br>
 * <p>
 * Identifier: 1.2.40.0.34.10.46<br>
 * Effective date: 2013-01-10 00:00<br>
 * Version: null<br>
 * Status: DEPRECATED
 */
@Generated(value = "org.projecthusky.codegenerator.ch.valuesets.UpdateValueSets", date = "2022-02-21")
public enum ElgaSpecimenType implements ValueSetEnumInterface {

    /**
     * EN: Abcess.<br>
     */
    ABCESS_L2("ABS",
              "2.16.840.1.113883.5.129",
              "Abcess",
              "Abcess",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Amniotic fluid.<br>
     */
    AMNIOTIC_FLUID_L2("AMN",
                      "2.16.840.1.113883.5.129",
                      "Amniotic fluid",
                      "Amniotic fluid",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Aspirate.<br>
     */
    ASPIRATE_L1("ASP",
                "2.16.840.1.113883.5.129",
                "Aspirate",
                "Aspirate",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Basophils.<br>
     */
    BASOPHILS_L2("BPH",
                 "2.16.840.1.113883.5.129",
                 "Basophils",
                 "Basophils",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Bile fluid.<br>
     */
    BILE_FLUID_L2("BIFL",
                  "2.16.840.1.113883.5.129",
                  "Bile fluid",
                  "Bile fluid",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Blood arterial.<br>
     */
    BLOOD_ARTERIAL_L2("BLDA",
                      "2.16.840.1.113883.5.129",
                      "Blood arterial",
                      "Blood arterial",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Blood bag.<br>
     */
    BLOOD_BAG_L2("BBL",
                 "2.16.840.1.113883.5.129",
                 "Blood bag",
                 "Blood bag",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Blood capillary.<br>
     */
    BLOOD_CAPILLARY_L2("BLDC",
                       "2.16.840.1.113883.5.129",
                       "Blood capillary",
                       "Blood capillary",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: Blood - cord.<br>
     */
    BLOOD_CORD_L2("BLDCO",
                  "2.16.840.1.113883.5.129",
                  "Blood - cord",
                  "Blood - cord",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Blood product unit.<br>
     */
    BLOOD_PRODUCT_UNIT_L2("BPU",
                          "2.16.840.1.113883.5.129",
                          "Blood product unit",
                          "Blood product unit",
                          "TOTRANSLATE",
                          "TOTRANSLATE",
                          "TOTRANSLATE"),
    /**
     * EN: Blood venous.<br>
     */
    BLOOD_VENOUS_L2("BLDV",
                    "2.16.840.1.113883.5.129",
                    "Blood venous",
                    "Blood venous",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Body fluid, unsp.<br>
     */
    BODY_FLUID_UNSP_L2("FLU",
                       "2.16.840.1.113883.5.129",
                       "Body fluid, unsp",
                       "Body fluid, unsp",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: Bone.<br>
     */
    BONE_L1("BON",
            "2.16.840.1.113883.5.129",
            "Bone",
            "Bone",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Breast milk.<br>
     */
    BREAST_MILK_L2("MILK",
                   "2.16.840.1.113883.5.129",
                   "Breast milk",
                   "Breast milk",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Breath (use EXG) Exhaled gas (=breath).<br>
     */
    BREATH_USE_EXG_EXHALED_GAS_BREATH_L2("BRTH",
                                         "2.16.840.1.113883.5.129",
                                         "Breath (use EXG) Exhaled gas (=breath)",
                                         "Breath (use EXG) Exhaled gas (=breath)",
                                         "TOTRANSLATE",
                                         "TOTRANSLATE",
                                         "TOTRANSLATE"),
    /**
     * EN: Bronchial.<br>
     */
    BRONCHIAL_L1("BRO",
                 "2.16.840.1.113883.5.129",
                 "Bronchial",
                 "Bronchial",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Burn.<br>
     */
    BURN_L2("BRN",
            "2.16.840.1.113883.5.129",
            "Burn",
            "Burn",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Calculus (=Stone) Stone (use CALC).<br>
     */
    CALCULUS_STONE_STONE_USE_CALC_L2("CALC",
                                     "2.16.840.1.113883.5.129",
                                     "Calculus (=Stone) Stone (use CALC)",
                                     "Calculus (=Stone) Stone (use CALC)",
                                     "TOTRANSLATE",
                                     "TOTRANSLATE",
                                     "TOTRANSLATE"),
    /**
     * EN: Cannula.<br>
     */
    CANNULA_L2("CNL",
               "2.16.840.1.113883.5.129",
               "Cannula",
               "Cannula",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Cardiac muscle.<br>
     */
    CARDIAC_MUSCLE_L2("CDM",
                      "2.16.840.1.113883.5.129",
                      "Cardiac muscle",
                      "Cardiac muscle",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Catheter tip.<br>
     */
    CATHETER_TIP_L2("CTP",
                    "2.16.840.1.113883.5.129",
                    "Catheter tip",
                    "Catheter tip",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Cerebral spinal fluid.<br>
     */
    CEREBRAL_SPINAL_FLUID_L1("CSF",
                             "2.16.840.1.113883.5.129",
                             "Cerebral spinal fluid",
                             "Cerebral spinal fluid",
                             "TOTRANSLATE",
                             "TOTRANSLATE",
                             "TOTRANSLATE"),
    /**
     * EN: Cervical mucus.<br>
     */
    CERVICAL_MUCUS_L2("CVM",
                      "2.16.840.1.113883.5.129",
                      "Cervical mucus",
                      "Cervical mucus",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Cervix.<br>
     */
    CERVIX_L2("CVX",
              "2.16.840.1.113883.5.129",
              "Cervix",
              "Cervix",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Colostrum.<br>
     */
    COLOSTRUM_L2("COL",
                 "2.16.840.1.113883.5.129",
                 "Colostrum",
                 "Colostrum",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Conjunctiva.<br>
     */
    CONJUNCTIVA_L2("CNJT",
                   "2.16.840.1.113883.5.129",
                   "Conjunctiva",
                   "Conjunctiva",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Cornea.<br>
     */
    CORNEA_L2("CRN",
              "2.16.840.1.113883.5.129",
              "Cornea",
              "Cornea",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Curettage.<br>
     */
    CURETTAGE_L2("CUR",
                 "2.16.840.1.113883.5.129",
                 "Curettage",
                 "Curettage",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Cyst.<br>
     */
    CYST_L2("CYST",
            "2.16.840.1.113883.5.129",
            "Cyst",
            "Cyst",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Dialysis fluid.<br>
     */
    DIALYSIS_FLUID_L2("DIAF",
                      "2.16.840.1.113883.5.129",
                      "Dialysis fluid",
                      "Dialysis fluid",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Dose med or substance.<br>
     */
    DOSE_MED_OR_SUBSTANCE_L1("DOSE",
                             "2.16.840.1.113883.5.129",
                             "Dose med or substance",
                             "Dose med or substance",
                             "TOTRANSLATE",
                             "TOTRANSLATE",
                             "TOTRANSLATE"),
    /**
     * EN: Drain.<br>
     */
    DRAIN_L2("DRN",
             "2.16.840.1.113883.5.129",
             "Drain",
             "Drain",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Duodenal fluid.<br>
     */
    DUODENAL_FLUID_L1("DUFL",
                      "2.16.840.1.113883.5.129",
                      "Duodenal fluid",
                      "Duodenal fluid",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Ear.<br>
     */
    EAR_L2("EAR",
           "2.16.840.1.113883.5.129",
           "Ear",
           "Ear",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Ear wax (cerumen).<br>
     */
    EAR_WAX_CERUMEN_L1("EARW",
                       "2.16.840.1.113883.5.129",
                       "Ear wax (cerumen)",
                       "Ear wax (cerumen)",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: Electrode.<br>
     */
    ELECTRODE_L2("ELT",
                 "2.16.840.1.113883.5.129",
                 "Electrode",
                 "Electrode",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Endocardium.<br>
     */
    ENDOCARDIUM_L2("ENDC",
                   "2.16.840.1.113883.5.129",
                   "Endocardium",
                   "Endocardium",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Endometrium.<br>
     */
    ENDOMETRIUM_L1("ENDM",
                   "2.16.840.1.113883.5.129",
                   "Endometrium",
                   "Endometrium",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Eosinophils.<br>
     */
    EOSINOPHILS_L2("EOS",
                   "2.16.840.1.113883.5.129",
                   "Eosinophils",
                   "Eosinophils",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Erythrocytes.<br>
     */
    ERYTHROCYTES_L1("RBC",
                    "2.16.840.1.113883.5.129",
                    "Erythrocytes",
                    "Erythrocytes",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Eye.<br>
     */
    EYE_L2("EYE",
           "2.16.840.1.113883.5.129",
           "Eye",
           "Eye",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Fibroblasts.<br>
     */
    FIBROBLASTS_L2("FIB",
                   "2.16.840.1.113883.5.129",
                   "Fibroblasts",
                   "Fibroblasts",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Filter.<br>
     */
    FILTER_L1("FLT",
              "2.16.840.1.113883.5.129",
              "Filter",
              "Filter",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Fistula.<br>
     */
    FISTULA_L2("FIST",
               "2.16.840.1.113883.5.129",
               "Fistula",
               "Fistula",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Food sample.<br>
     */
    FOOD_SAMPLE_L2("FOOD",
                   "2.16.840.1.113883.5.129",
                   "Food sample",
                   "Food sample",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Gastric fluid/contents.<br>
     */
    GASTRIC_FLUID_CONTENTS_L2("GAST",
                              "2.16.840.1.113883.5.129",
                              "Gastric fluid/contents",
                              "Gastric fluid/contents",
                              "TOTRANSLATE",
                              "TOTRANSLATE",
                              "TOTRANSLATE"),
    /**
     * EN: Gas.<br>
     */
    GAS_L2("GAS",
           "2.16.840.1.113883.5.129",
           "Gas",
           "Gas",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Genital cervix.<br>
     */
    GENITAL_CERVIX_L2("GENC",
                      "2.16.840.1.113883.5.129",
                      "Genital cervix",
                      "Genital cervix",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Genital fluid.<br>
     */
    GENITAL_FLUID_L2("GENF",
                     "2.16.840.1.113883.5.129",
                     "Genital fluid",
                     "Genital fluid",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: Genital.<br>
     */
    GENITAL_L2("GEN",
               "2.16.840.1.113883.5.129",
               "Genital",
               "Genital",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Genital lochia.<br>
     */
    GENITAL_LOCHIA_L2("GENL",
                      "2.16.840.1.113883.5.129",
                      "Genital lochia",
                      "Genital lochia",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Genital vaginal.<br>
     */
    GENITAL_VAGINAL_L1("GENV",
                       "2.16.840.1.113883.5.129",
                       "Genital vaginal",
                       "Genital vaginal",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: Hair.<br>
     */
    HAIR_L2("HAR",
            "2.16.840.1.113883.5.129",
            "Hair",
            "Hair",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Inhaled Gas.<br>
     */
    INHALED_GAS_L2("IHG",
                   "2.16.840.1.113883.5.129",
                   "Inhaled Gas",
                   "Inhaled Gas",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Intubation tube.<br>
     */
    INTUBATION_TUBE_L2("IT",
                       "2.16.840.1.113883.5.129",
                       "Intubation tube",
                       "Intubation tube",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: Isolate.<br>
     */
    ISOLATE_L2("ISLT",
               "2.16.840.1.113883.5.129",
               "Isolate",
               "Isolate",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Lamella.<br>
     */
    LAMELLA_L2("LAM",
               "2.16.840.1.113883.5.129",
               "Lamella",
               "Lamella",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Leukocytes.<br>
     */
    LEUKOCYTES_L2("WBC",
                  "2.16.840.1.113883.5.129",
                  "Leukocytes",
                  "Leukocytes",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Line arterial.<br>
     */
    LINE_ARTERIAL_L2("LNA",
                     "2.16.840.1.113883.5.129",
                     "Line arterial",
                     "Line arterial",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: Line.<br>
     */
    LINE_L2("LN",
            "2.16.840.1.113883.5.129",
            "Line",
            "Line",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Line venous.<br>
     */
    LINE_VENOUS_L1("LNV",
                   "2.16.840.1.113883.5.129",
                   "Line venous",
                   "Line venous",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Liquid NOS.<br>
     */
    LIQUID_NOS_L2("LIQ",
                  "2.16.840.1.113883.5.129",
                  "Liquid NOS",
                  "Liquid NOS",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Lymphocytes.<br>
     */
    LYMPHOCYTES_L2("LYM",
                   "2.16.840.1.113883.5.129",
                   "Lymphocytes",
                   "Lymphocytes",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Macrophages.<br>
     */
    MACROPHAGES_L2("MAC",
                   "2.16.840.1.113883.5.129",
                   "Macrophages",
                   "Macrophages",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Marrow (bone).<br>
     */
    MARROW_BONE_L2("MAR",
                   "2.16.840.1.113883.5.129",
                   "Marrow (bone)",
                   "Marrow (bone)",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Meconium.<br>
     */
    MECONIUM_L2("MEC",
                "2.16.840.1.113883.5.129",
                "Meconium",
                "Meconium",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Menstrual blood.<br>
     */
    MENSTRUAL_BLOOD_L2("MBLD",
                       "2.16.840.1.113883.5.129",
                       "Menstrual blood",
                       "Menstrual blood",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: Milk.<br>
     */
    MILK_L2("MLK",
            "2.16.840.1.113883.5.129",
            "Milk",
            "Milk",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Nail.<br>
     */
    NAIL_L2("NAIL",
            "2.16.840.1.113883.5.129",
            "Nail",
            "Nail",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Nose (nasal passage).<br>
     */
    NOSE_NASAL_PASSAGE_L2("NOS",
                          "2.16.840.1.113883.5.129",
                          "Nose (nasal passage)",
                          "Nose (nasal passage)",
                          "TOTRANSLATE",
                          "TOTRANSLATE",
                          "TOTRANSLATE"),
    /**
     * EN: Pancreatic fluid.<br>
     */
    PANCREATIC_FLUID_L2("PAFL",
                        "2.16.840.1.113883.5.129",
                        "Pancreatic fluid",
                        "Pancreatic fluid",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: Patient.<br>
     */
    PATIENT_L1("PAT",
               "2.16.840.1.113883.5.129",
               "Patient",
               "Patient",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Peritoneal fluid /ascites.<br>
     */
    PERITONEAL_FLUID_ASCITES_L1("PRT",
                                "2.16.840.1.113883.5.129",
                                "Peritoneal fluid /ascites",
                                "Peritoneal fluid /ascites",
                                "TOTRANSLATE",
                                "TOTRANSLATE",
                                "TOTRANSLATE"),
    /**
     * EN: Placenta.<br>
     */
    PLACENTA_L2("PLC",
                "2.16.840.1.113883.5.129",
                "Placenta",
                "Placenta",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Plasma bag.<br>
     */
    PLASMA_BAG_L2("PLB",
                  "2.16.840.1.113883.5.129",
                  "Plasma bag",
                  "Plasma bag",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Plasma.<br>
     */
    PLASMA_L2("PLAS",
              "2.16.840.1.113883.5.129",
              "Plasma",
              "Plasma",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Platelet poor plasma.<br>
     */
    PLATELET_POOR_PLASMA_L1("PPP",
                            "2.16.840.1.113883.5.129",
                            "Platelet poor plasma",
                            "Platelet poor plasma",
                            "TOTRANSLATE",
                            "TOTRANSLATE",
                            "TOTRANSLATE"),
    /**
     * EN: Platelet rich plasma.<br>
     */
    PLATELET_RICH_PLASMA_L2("PRP",
                            "2.16.840.1.113883.5.129",
                            "Platelet rich plasma",
                            "Platelet rich plasma",
                            "TOTRANSLATE",
                            "TOTRANSLATE",
                            "TOTRANSLATE"),
    /**
     * EN: Pleural fluid (thoracentesis fld).<br>
     */
    PLEURAL_FLUID_THORACENTESIS_FLD_L2("PLR",
                                       "2.16.840.1.113883.5.129",
                                       "Pleural fluid (thoracentesis fld)",
                                       "Pleural fluid (thoracentesis fld)",
                                       "TOTRANSLATE",
                                       "TOTRANSLATE",
                                       "TOTRANSLATE"),
    /**
     * EN: Polymorphonuclear neutrophils.<br>
     */
    POLYMORPHONUCLEAR_NEUTROPHILS_L2("PMN",
                                     "2.16.840.1.113883.5.129",
                                     "Polymorphonuclear neutrophils",
                                     "Polymorphonuclear neutrophils",
                                     "TOTRANSLATE",
                                     "TOTRANSLATE",
                                     "TOTRANSLATE"),
    /**
     * EN: Pus.<br>
     */
    PUS_L2("PUS",
           "2.16.840.1.113883.5.129",
           "Pus",
           "Pus",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Saliva.<br>
     */
    SALIVA_L2("SAL",
              "2.16.840.1.113883.5.129",
              "Saliva",
              "Saliva",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Seminal fluid.<br>
     */
    SEMINAL_FLUID_L1("SMN",
                     "2.16.840.1.113883.5.129",
                     "Seminal fluid",
                     "Seminal fluid",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: Seminal plasma.<br>
     */
    SEMINAL_PLASMA_L2("SMPLS",
                      "2.16.840.1.113883.5.129",
                      "Seminal plasma",
                      "Seminal plasma",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Serum.<br>
     */
    SERUM_L2("SER",
             "2.16.840.1.113883.5.129",
             "Serum",
             "Serum",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Skeletal muscle.<br>
     */
    SKELETAL_MUSCLE_L1("SKM",
                       "2.16.840.1.113883.5.129",
                       "Skeletal muscle",
                       "Skeletal muscle",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: Skin.<br>
     */
    SKIN_L2("SKN",
            "2.16.840.1.113883.5.129",
            "Skin",
            "Skin",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Spermatozoa.<br>
     */
    SPERMATOZOA_L2("SPRM",
                   "2.16.840.1.113883.5.129",
                   "Spermatozoa",
                   "Spermatozoa",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Sputum - coughed.<br>
     */
    SPUTUM_COUGHED_L2("SPTC",
                      "2.16.840.1.113883.5.129",
                      "Sputum - coughed",
                      "Sputum - coughed",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Sputum.<br>
     */
    SPUTUM_L2("SPT",
              "2.16.840.1.113883.5.129",
              "Sputum",
              "Sputum",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Sputum - tracheal aspirate.<br>
     */
    SPUTUM_TRACHEAL_ASPIRATE_L2("SPTT",
                                "2.16.840.1.113883.5.129",
                                "Sputum - tracheal aspirate",
                                "Sputum - tracheal aspirate",
                                "TOTRANSLATE",
                                "TOTRANSLATE",
                                "TOTRANSLATE"),
    /**
     * EN: Stool = Fecal.<br>
     */
    STOOL_FECAL_L2("STL",
                   "2.16.840.1.113883.5.129",
                   "Stool = Fecal",
                   "Stool = Fecal",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Sweat.<br>
     */
    SWEAT_L2("SWT",
             "2.16.840.1.113883.5.129",
             "Sweat",
             "Sweat",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Synovial fluid (Joint fluid).<br>
     */
    SYNOVIAL_FLUID_JOINT_FLUID_L2("SNV",
                                  "2.16.840.1.113883.5.129",
                                  "Synovial fluid (Joint fluid)",
                                  "Synovial fluid (Joint fluid)",
                                  "TOTRANSLATE",
                                  "TOTRANSLATE",
                                  "TOTRANSLATE"),
    /**
     * EN: Tears.<br>
     */
    TEARS_L2("TEAR",
             "2.16.840.1.113883.5.129",
             "Tears",
             "Tears",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Throat.<br>
     */
    THROAT_L2("THRT",
              "2.16.840.1.113883.5.129",
              "Throat",
              "Throat",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Thrombocyte (platelet).<br>
     */
    THROMBOCYTE_PLATELET_L2("THRB",
                            "2.16.840.1.113883.5.129",
                            "Thrombocyte (platelet)",
                            "Thrombocyte (platelet)",
                            "TOTRANSLATE",
                            "TOTRANSLATE",
                            "TOTRANSLATE"),
    /**
     * EN: Tissue gall bladder.<br>
     */
    TISSUE_GALL_BLADDER_L2("TISG",
                           "2.16.840.1.113883.5.129",
                           "Tissue gall bladder",
                           "Tissue gall bladder",
                           "TOTRANSLATE",
                           "TOTRANSLATE",
                           "TOTRANSLATE"),
    /**
     * EN: Tissue large intestine.<br>
     */
    TISSUE_LARGE_INTESTINE_L2("TLGI",
                              "2.16.840.1.113883.5.129",
                              "Tissue large intestine",
                              "Tissue large intestine",
                              "TOTRANSLATE",
                              "TOTRANSLATE",
                              "TOTRANSLATE"),
    /**
     * EN: Tissue lung.<br>
     */
    TISSUE_LUNG_L2("TLNG",
                   "2.16.840.1.113883.5.129",
                   "Tissue lung",
                   "Tissue lung",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Tissue placenta.<br>
     */
    TISSUE_PLACENTA_L2("TISPL",
                       "2.16.840.1.113883.5.129",
                       "Tissue placenta",
                       "Tissue placenta",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: Tissue small intestine Tissue ulcer.<br>
     */
    TISSUE_SMALL_INTESTINE_TISSUE_ULCER_L2("TSMI",
                                           "2.16.840.1.113883.5.129",
                                           "Tissue small intestine Tissue ulcer",
                                           "Tissue small intestine Tissue ulcer",
                                           "TOTRANSLATE",
                                           "TOTRANSLATE",
                                           "TOTRANSLATE"),
    /**
     * EN: Tissue ulcer.<br>
     */
    TISSUE_ULCER_L2("TISU",
                    "2.16.840.1.113883.5.129",
                    "Tissue ulcer",
                    "Tissue ulcer",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Tissue, unspecified.<br>
     */
    TISSUE_UNSPECIFIED_L2("TISS",
                          "2.16.840.1.113883.5.129",
                          "Tissue, unspecified",
                          "Tissue, unspecified",
                          "TOTRANSLATE",
                          "TOTRANSLATE",
                          "TOTRANSLATE"),
    /**
     * EN: Tube, unspecified.<br>
     */
    TUBE_UNSPECIFIED_L2("TUB",
                        "2.16.840.1.113883.5.129",
                        "Tube, unspecified",
                        "Tube, unspecified",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: Ulcer.<br>
     */
    ULCER_L2("ULC",
             "2.16.840.1.113883.5.129",
             "Ulcer",
             "Ulcer",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Umbilical blood.<br>
     */
    UMBILICAL_BLOOD_L2("UMB",
                       "2.16.840.1.113883.5.129",
                       "Umbilical blood",
                       "Umbilical blood",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: Unknown medicine.<br>
     */
    UNKNOWN_MEDICINE_L2("UMED",
                        "2.16.840.1.113883.5.129",
                        "Unknown medicine",
                        "Unknown medicine",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: Unknown substance.<br>
     */
    UNKNOWN_SUBSTANCE_L2("USUB",
                         "2.16.840.1.113883.5.129",
                         "Unknown substance",
                         "Unknown substance",
                         "TOTRANSLATE",
                         "TOTRANSLATE",
                         "TOTRANSLATE"),
    /**
     * EN: Urethra.<br>
     */
    URETHRA_L2("URTH",
               "2.16.840.1.113883.5.129",
               "Urethra",
               "Urethra",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Urine catheter.<br>
     */
    URINE_CATHETER_L2("URT",
                      "2.16.840.1.113883.5.129",
                      "Urine catheter",
                      "Urine catheter",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Urine clean catch.<br>
     */
    URINE_CLEAN_CATCH_L2("URC",
                         "2.16.840.1.113883.5.129",
                         "Urine clean catch",
                         "Urine clean catch",
                         "TOTRANSLATE",
                         "TOTRANSLATE",
                         "TOTRANSLATE"),
    /**
     * EN: Urine.<br>
     */
    URINE_L2("UR",
             "2.16.840.1.113883.5.129",
             "Urine",
             "Urine",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Urine sediment.<br>
     */
    URINE_SEDIMENT_L2("URNS",
                      "2.16.840.1.113883.5.129",
                      "Urine sediment",
                      "Urine sediment",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Vomitus.<br>
     */
    VOMITUS_L2("VOM",
               "2.16.840.1.113883.5.129",
               "Vomitus",
               "Vomitus",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Water.<br>
     */
    WATER_L2("WAT",
             "2.16.840.1.113883.5.129",
             "Water",
             "Water",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Whole blood.<br>
     */
    WHOLE_BLOOD_L1("BLD",
                   "2.16.840.1.113883.5.129",
                   "Whole blood",
                   "Whole blood",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Whole body.<br>
     */
    WHOLE_BODY_L2("BDY",
                  "2.16.840.1.113883.5.129",
                  "Whole body",
                  "Whole body",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Wick.<br>
     */
    WICK_L2("WICK",
            "2.16.840.1.113883.5.129",
            "Wick",
            "Wick",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Wound abscess.<br>
     */
    WOUND_ABSCESS_L2("WNDA",
                     "2.16.840.1.113883.5.129",
                     "Wound abscess",
                     "Wound abscess",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: Wound drainage.<br>
     */
    WOUND_DRAINAGE_L2("WNDD",
                      "2.16.840.1.113883.5.129",
                      "Wound drainage",
                      "Wound drainage",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Wound exudate.<br>
     */
    WOUND_EXUDATE_L2("WNDE",
                     "2.16.840.1.113883.5.129",
                     "Wound exudate",
                     "Wound exudate",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: Wound.<br>
     */
    WOUND_L2("WND",
             "2.16.840.1.113883.5.129",
             "Wound",
             "Wound",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE");

    /**
     * EN: Code for Abcess.<br>
     */
    public static final String ABCESS_L2_CODE = "ABS";

    /**
     * EN: Code for Amniotic fluid.<br>
     */
    public static final String AMNIOTIC_FLUID_L2_CODE = "AMN";

    /**
     * EN: Code for Aspirate.<br>
     */
    public static final String ASPIRATE_L1_CODE = "ASP";

    /**
     * EN: Code for Basophils.<br>
     */
    public static final String BASOPHILS_L2_CODE = "BPH";

    /**
     * EN: Code for Bile fluid.<br>
     */
    public static final String BILE_FLUID_L2_CODE = "BIFL";

    /**
     * EN: Code for Blood arterial.<br>
     */
    public static final String BLOOD_ARTERIAL_L2_CODE = "BLDA";

    /**
     * EN: Code for Blood bag.<br>
     */
    public static final String BLOOD_BAG_L2_CODE = "BBL";

    /**
     * EN: Code for Blood capillary.<br>
     */
    public static final String BLOOD_CAPILLARY_L2_CODE = "BLDC";

    /**
     * EN: Code for Blood - cord.<br>
     */
    public static final String BLOOD_CORD_L2_CODE = "BLDCO";

    /**
     * EN: Code for Blood product unit.<br>
     */
    public static final String BLOOD_PRODUCT_UNIT_L2_CODE = "BPU";

    /**
     * EN: Code for Blood venous.<br>
     */
    public static final String BLOOD_VENOUS_L2_CODE = "BLDV";

    /**
     * EN: Code for Body fluid, unsp.<br>
     */
    public static final String BODY_FLUID_UNSP_L2_CODE = "FLU";

    /**
     * EN: Code for Bone.<br>
     */
    public static final String BONE_L1_CODE = "BON";

    /**
     * EN: Code for Breast milk.<br>
     */
    public static final String BREAST_MILK_L2_CODE = "MILK";

    /**
     * EN: Code for Breath (use EXG) Exhaled gas (=breath).<br>
     */
    public static final String BREATH_USE_EXG_EXHALED_GAS_BREATH_L2_CODE = "BRTH";

    /**
     * EN: Code for Bronchial.<br>
     */
    public static final String BRONCHIAL_L1_CODE = "BRO";

    /**
     * EN: Code for Burn.<br>
     */
    public static final String BURN_L2_CODE = "BRN";

    /**
     * EN: Code for Calculus (=Stone) Stone (use CALC).<br>
     */
    public static final String CALCULUS_STONE_STONE_USE_CALC_L2_CODE = "CALC";

    /**
     * EN: Code for Cannula.<br>
     */
    public static final String CANNULA_L2_CODE = "CNL";

    /**
     * EN: Code for Cardiac muscle.<br>
     */
    public static final String CARDIAC_MUSCLE_L2_CODE = "CDM";

    /**
     * EN: Code for Catheter tip.<br>
     */
    public static final String CATHETER_TIP_L2_CODE = "CTP";

    /**
     * EN: Code for Cerebral spinal fluid.<br>
     */
    public static final String CEREBRAL_SPINAL_FLUID_L1_CODE = "CSF";

    /**
     * EN: Code for Cervical mucus.<br>
     */
    public static final String CERVICAL_MUCUS_L2_CODE = "CVM";

    /**
     * EN: Code for Cervix.<br>
     */
    public static final String CERVIX_L2_CODE = "CVX";

    /**
     * EN: Code for Colostrum.<br>
     */
    public static final String COLOSTRUM_L2_CODE = "COL";

    /**
     * EN: Code for Conjunctiva.<br>
     */
    public static final String CONJUNCTIVA_L2_CODE = "CNJT";

    /**
     * EN: Code for Cornea.<br>
     */
    public static final String CORNEA_L2_CODE = "CRN";

    /**
     * EN: Code for Curettage.<br>
     */
    public static final String CURETTAGE_L2_CODE = "CUR";

    /**
     * EN: Code for Cyst.<br>
     */
    public static final String CYST_L2_CODE = "CYST";

    /**
     * EN: Code for Dialysis fluid.<br>
     */
    public static final String DIALYSIS_FLUID_L2_CODE = "DIAF";

    /**
     * EN: Code for Dose med or substance.<br>
     */
    public static final String DOSE_MED_OR_SUBSTANCE_L1_CODE = "DOSE";

    /**
     * EN: Code for Drain.<br>
     */
    public static final String DRAIN_L2_CODE = "DRN";

    /**
     * EN: Code for Duodenal fluid.<br>
     */
    public static final String DUODENAL_FLUID_L1_CODE = "DUFL";

    /**
     * EN: Code for Ear.<br>
     */
    public static final String EAR_L2_CODE = "EAR";

    /**
     * EN: Code for Ear wax (cerumen).<br>
     */
    public static final String EAR_WAX_CERUMEN_L1_CODE = "EARW";

    /**
     * EN: Code for Electrode.<br>
     */
    public static final String ELECTRODE_L2_CODE = "ELT";

    /**
     * EN: Code for Endocardium.<br>
     */
    public static final String ENDOCARDIUM_L2_CODE = "ENDC";

    /**
     * EN: Code for Endometrium.<br>
     */
    public static final String ENDOMETRIUM_L1_CODE = "ENDM";

    /**
     * EN: Code for Eosinophils.<br>
     */
    public static final String EOSINOPHILS_L2_CODE = "EOS";

    /**
     * EN: Code for Erythrocytes.<br>
     */
    public static final String ERYTHROCYTES_L1_CODE = "RBC";

    /**
     * EN: Code for Eye.<br>
     */
    public static final String EYE_L2_CODE = "EYE";

    /**
     * EN: Code for Fibroblasts.<br>
     */
    public static final String FIBROBLASTS_L2_CODE = "FIB";

    /**
     * EN: Code for Filter.<br>
     */
    public static final String FILTER_L1_CODE = "FLT";

    /**
     * EN: Code for Fistula.<br>
     */
    public static final String FISTULA_L2_CODE = "FIST";

    /**
     * EN: Code for Food sample.<br>
     */
    public static final String FOOD_SAMPLE_L2_CODE = "FOOD";

    /**
     * EN: Code for Gastric fluid/contents.<br>
     */
    public static final String GASTRIC_FLUID_CONTENTS_L2_CODE = "GAST";

    /**
     * EN: Code for Gas.<br>
     */
    public static final String GAS_L2_CODE = "GAS";

    /**
     * EN: Code for Genital cervix.<br>
     */
    public static final String GENITAL_CERVIX_L2_CODE = "GENC";

    /**
     * EN: Code for Genital fluid.<br>
     */
    public static final String GENITAL_FLUID_L2_CODE = "GENF";

    /**
     * EN: Code for Genital.<br>
     */
    public static final String GENITAL_L2_CODE = "GEN";

    /**
     * EN: Code for Genital lochia.<br>
     */
    public static final String GENITAL_LOCHIA_L2_CODE = "GENL";

    /**
     * EN: Code for Genital vaginal.<br>
     */
    public static final String GENITAL_VAGINAL_L1_CODE = "GENV";

    /**
     * EN: Code for Hair.<br>
     */
    public static final String HAIR_L2_CODE = "HAR";

    /**
     * EN: Code for Inhaled Gas.<br>
     */
    public static final String INHALED_GAS_L2_CODE = "IHG";

    /**
     * EN: Code for Intubation tube.<br>
     */
    public static final String INTUBATION_TUBE_L2_CODE = "IT";

    /**
     * EN: Code for Isolate.<br>
     */
    public static final String ISOLATE_L2_CODE = "ISLT";

    /**
     * EN: Code for Lamella.<br>
     */
    public static final String LAMELLA_L2_CODE = "LAM";

    /**
     * EN: Code for Leukocytes.<br>
     */
    public static final String LEUKOCYTES_L2_CODE = "WBC";

    /**
     * EN: Code for Line arterial.<br>
     */
    public static final String LINE_ARTERIAL_L2_CODE = "LNA";

    /**
     * EN: Code for Line.<br>
     */
    public static final String LINE_L2_CODE = "LN";

    /**
     * EN: Code for Line venous.<br>
     */
    public static final String LINE_VENOUS_L1_CODE = "LNV";

    /**
     * EN: Code for Liquid NOS.<br>
     */
    public static final String LIQUID_NOS_L2_CODE = "LIQ";

    /**
     * EN: Code for Lymphocytes.<br>
     */
    public static final String LYMPHOCYTES_L2_CODE = "LYM";

    /**
     * EN: Code for Macrophages.<br>
     */
    public static final String MACROPHAGES_L2_CODE = "MAC";

    /**
     * EN: Code for Marrow (bone).<br>
     */
    public static final String MARROW_BONE_L2_CODE = "MAR";

    /**
     * EN: Code for Meconium.<br>
     */
    public static final String MECONIUM_L2_CODE = "MEC";

    /**
     * EN: Code for Menstrual blood.<br>
     */
    public static final String MENSTRUAL_BLOOD_L2_CODE = "MBLD";

    /**
     * EN: Code for Milk.<br>
     */
    public static final String MILK_L2_CODE = "MLK";

    /**
     * EN: Code for Nail.<br>
     */
    public static final String NAIL_L2_CODE = "NAIL";

    /**
     * EN: Code for Nose (nasal passage).<br>
     */
    public static final String NOSE_NASAL_PASSAGE_L2_CODE = "NOS";

    /**
     * EN: Code for Pancreatic fluid.<br>
     */
    public static final String PANCREATIC_FLUID_L2_CODE = "PAFL";

    /**
     * EN: Code for Patient.<br>
     */
    public static final String PATIENT_L1_CODE = "PAT";

    /**
     * EN: Code for Peritoneal fluid /ascites.<br>
     */
    public static final String PERITONEAL_FLUID_ASCITES_L1_CODE = "PRT";

    /**
     * EN: Code for Placenta.<br>
     */
    public static final String PLACENTA_L2_CODE = "PLC";

    /**
     * EN: Code for Plasma bag.<br>
     */
    public static final String PLASMA_BAG_L2_CODE = "PLB";

    /**
     * EN: Code for Plasma.<br>
     */
    public static final String PLASMA_L2_CODE = "PLAS";

    /**
     * EN: Code for Platelet poor plasma.<br>
     */
    public static final String PLATELET_POOR_PLASMA_L1_CODE = "PPP";

    /**
     * EN: Code for Platelet rich plasma.<br>
     */
    public static final String PLATELET_RICH_PLASMA_L2_CODE = "PRP";

    /**
     * EN: Code for Pleural fluid (thoracentesis fld).<br>
     */
    public static final String PLEURAL_FLUID_THORACENTESIS_FLD_L2_CODE = "PLR";

    /**
     * EN: Code for Polymorphonuclear neutrophils.<br>
     */
    public static final String POLYMORPHONUCLEAR_NEUTROPHILS_L2_CODE = "PMN";

    /**
     * EN: Code for Pus.<br>
     */
    public static final String PUS_L2_CODE = "PUS";

    /**
     * EN: Code for Saliva.<br>
     */
    public static final String SALIVA_L2_CODE = "SAL";

    /**
     * EN: Code for Seminal fluid.<br>
     */
    public static final String SEMINAL_FLUID_L1_CODE = "SMN";

    /**
     * EN: Code for Seminal plasma.<br>
     */
    public static final String SEMINAL_PLASMA_L2_CODE = "SMPLS";

    /**
     * EN: Code for Serum.<br>
     */
    public static final String SERUM_L2_CODE = "SER";

    /**
     * EN: Code for Skeletal muscle.<br>
     */
    public static final String SKELETAL_MUSCLE_L1_CODE = "SKM";

    /**
     * EN: Code for Skin.<br>
     */
    public static final String SKIN_L2_CODE = "SKN";

    /**
     * EN: Code for Spermatozoa.<br>
     */
    public static final String SPERMATOZOA_L2_CODE = "SPRM";

    /**
     * EN: Code for Sputum - coughed.<br>
     */
    public static final String SPUTUM_COUGHED_L2_CODE = "SPTC";

    /**
     * EN: Code for Sputum.<br>
     */
    public static final String SPUTUM_L2_CODE = "SPT";

    /**
     * EN: Code for Sputum - tracheal aspirate.<br>
     */
    public static final String SPUTUM_TRACHEAL_ASPIRATE_L2_CODE = "SPTT";

    /**
     * EN: Code for Stool = Fecal.<br>
     */
    public static final String STOOL_FECAL_L2_CODE = "STL";

    /**
     * EN: Code for Sweat.<br>
     */
    public static final String SWEAT_L2_CODE = "SWT";

    /**
     * EN: Code for Synovial fluid (Joint fluid).<br>
     */
    public static final String SYNOVIAL_FLUID_JOINT_FLUID_L2_CODE = "SNV";

    /**
     * EN: Code for Tears.<br>
     */
    public static final String TEARS_L2_CODE = "TEAR";

    /**
     * EN: Code for Throat.<br>
     */
    public static final String THROAT_L2_CODE = "THRT";

    /**
     * EN: Code for Thrombocyte (platelet).<br>
     */
    public static final String THROMBOCYTE_PLATELET_L2_CODE = "THRB";

    /**
     * EN: Code for Tissue gall bladder.<br>
     */
    public static final String TISSUE_GALL_BLADDER_L2_CODE = "TISG";

    /**
     * EN: Code for Tissue large intestine.<br>
     */
    public static final String TISSUE_LARGE_INTESTINE_L2_CODE = "TLGI";

    /**
     * EN: Code for Tissue lung.<br>
     */
    public static final String TISSUE_LUNG_L2_CODE = "TLNG";

    /**
     * EN: Code for Tissue placenta.<br>
     */
    public static final String TISSUE_PLACENTA_L2_CODE = "TISPL";

    /**
     * EN: Code for Tissue small intestine Tissue ulcer.<br>
     */
    public static final String TISSUE_SMALL_INTESTINE_TISSUE_ULCER_L2_CODE = "TSMI";

    /**
     * EN: Code for Tissue ulcer.<br>
     */
    public static final String TISSUE_ULCER_L2_CODE = "TISU";

    /**
     * EN: Code for Tissue, unspecified.<br>
     */
    public static final String TISSUE_UNSPECIFIED_L2_CODE = "TISS";

    /**
     * EN: Code for Tube, unspecified.<br>
     */
    public static final String TUBE_UNSPECIFIED_L2_CODE = "TUB";

    /**
     * EN: Code for Ulcer.<br>
     */
    public static final String ULCER_L2_CODE = "ULC";

    /**
     * EN: Code for Umbilical blood.<br>
     */
    public static final String UMBILICAL_BLOOD_L2_CODE = "UMB";

    /**
     * EN: Code for Unknown medicine.<br>
     */
    public static final String UNKNOWN_MEDICINE_L2_CODE = "UMED";

    /**
     * EN: Code for Unknown substance.<br>
     */
    public static final String UNKNOWN_SUBSTANCE_L2_CODE = "USUB";

    /**
     * EN: Code for Urethra.<br>
     */
    public static final String URETHRA_L2_CODE = "URTH";

    /**
     * EN: Code for Urine catheter.<br>
     */
    public static final String URINE_CATHETER_L2_CODE = "URT";

    /**
     * EN: Code for Urine clean catch.<br>
     */
    public static final String URINE_CLEAN_CATCH_L2_CODE = "URC";

    /**
     * EN: Code for Urine.<br>
     */
    public static final String URINE_L2_CODE = "UR";

    /**
     * EN: Code for Urine sediment.<br>
     */
    public static final String URINE_SEDIMENT_L2_CODE = "URNS";

    /**
     * EN: Code for Vomitus.<br>
     */
    public static final String VOMITUS_L2_CODE = "VOM";

    /**
     * EN: Code for Water.<br>
     */
    public static final String WATER_L2_CODE = "WAT";

    /**
     * EN: Code for Whole blood.<br>
     */
    public static final String WHOLE_BLOOD_L1_CODE = "BLD";

    /**
     * EN: Code for Whole body.<br>
     */
    public static final String WHOLE_BODY_L2_CODE = "BDY";

    /**
     * EN: Code for Wick.<br>
     */
    public static final String WICK_L2_CODE = "WICK";

    /**
     * EN: Code for Wound abscess.<br>
     */
    public static final String WOUND_ABSCESS_L2_CODE = "WNDA";

    /**
     * EN: Code for Wound drainage.<br>
     */
    public static final String WOUND_DRAINAGE_L2_CODE = "WNDD";

    /**
     * EN: Code for Wound exudate.<br>
     */
    public static final String WOUND_EXUDATE_L2_CODE = "WNDE";

    /**
     * EN: Code for Wound.<br>
     */
    public static final String WOUND_L2_CODE = "WND";

    /**
     * Identifier of the value set.
     */
    public static final String VALUE_SET_ID = "1.2.40.0.34.10.46";

    /**
     * Name of the value set.
     */
    public static final String VALUE_SET_NAME = "ELGA_SpecimenType";

    /**
     * Identifier of the code system (all values share the same).
     */
    public static final String CODE_SYSTEM_ID = "2.16.840.1.113883.5.129";

    /**
     * Gets the Enum with a given code.
     *
     * @param code The code value.
     * @return the enum value found or {@code null}.
     */
    @Nullable
    public static ElgaSpecimenType getEnum(@Nullable final String code) {
        for (final ElgaSpecimenType x : values()) {
            if (x.getCodeValue().equals(code)) {
                return x;
            }
        }
        return null;
    }

    /**
     * Checks if a given enum is part of this value set.
     *
     * @param enumName The name of the enum.
     * @return {@code true} if the name is found in this value set, {@code false} otherwise.
     */
    public static boolean isEnumOfValueSet(@Nullable final String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(ElgaSpecimenType.class,
                         enumName);
            return true;
        } catch (final IllegalArgumentException ex) {
            return false;
        }
    }

    /**
     * Checks if a given code value is in this value set.
     *
     * @param codeValue The code value.
     * @return {@code true} if the value is found in this value set, {@code false} otherwise.
     */
    public static boolean isInValueSet(@Nullable final String codeValue) {
        for (final ElgaSpecimenType x : values()) {
            if (x.getCodeValue().equals(codeValue)) {
                return true;
            }
        }
        return false;
    }

    /**
     * Machine interpretable and (inside this class) unique code.
     */
    @NonNull
    private final String code;

    /**
     * Identifier of the referencing code system.
     */
    @NonNull
    private final String codeSystem;

    /**
     * The display names per language. It's always stored in the given order: default display name (0), in English (1),
     * in German (2), in French (3) and in Italian (4).
     */
    @NonNull
    private final String[] displayNames;

    /**
     * Instantiates this enum with a given code and display names.
     *
     * @param code          The code value.
     * @param codeSystem    The code system (OID).
     * @param displayName   The default display name.
     * @param displayNameEn The display name in English.
     * @param displayNameDe The display name in German.
     * @param displayNameFr The display name in French.
     * @param displayNameIt The display name in Italian.
     */
    ElgaSpecimenType(@NonNull final String code, @NonNull final String codeSystem, @NonNull final String displayName, @NonNull final String displayNameEn, @NonNull final String displayNameDe, @NonNull final String displayNameFr, @NonNull final String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    /**
     * Gets the code system identifier.
     *
     * @return the code system identifier.
     */
    @Override
    @NonNull
    public String getCodeSystemId() {
        return this.codeSystem;
    }

    /**
     * Gets the code system name.
     *
     * @return the code system name.
     */
    @Override
    @NonNull
    public String getCodeSystemName() {
        final var codeSystem = CodeSystems.getEnum(this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    /**
     * Gets the code value as a string.
     *
     * @return the code value.
     */
    @Override
    @NonNull
    public String getCodeValue() {
        return this.code;
    }

    /**
     * Gets the display name defined by the language param.
     *
     * @param languageCode The language code to get the display name for, {@code null} to get the default display name.
     * @return the display name in the desired language.
     */
    @Override
    @NonNull
    public String getDisplayName(@Nullable final LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch(languageCode) {
            case ENGLISH ->
                this.displayNames[1];
            case GERMAN ->
                this.displayNames[2];
            case FRENCH ->
                this.displayNames[3];
            case ITALIAN ->
                this.displayNames[4];
            default ->
                "TOTRANSLATE";
        };
    }

    /**
     * Gets the value set identifier.
     *
     * @return the value set identifier.
     */
    @Override
    @NonNull
    public String getValueSetId() {
        return VALUE_SET_ID;
    }

    /**
     * Gets the value set name.
     *
     * @return the value set name.
     */
    @Override
    @NonNull
    public String getValueSetName() {
        return VALUE_SET_NAME;
    }
}
