/*
 * This code is made available under the terms of the Eclipse Public License v1.0
 * in the github project https://github.com/project-husky/husky there you also
 * find a list of the contributors and the license information.
 *
 * This project has been developed further and modified by the joined working group Husky
 * on the basis of the eHealth Connector opensource project from June 28, 2021,
 * whereas medshare GmbH is the initial and main contributor/author of the eHealth Connector.
 */
package org.projecthusky.cda.elga.generated.artdecor.ems.enums;

import java.util.Objects;
import javax.annotation.processing.Generated;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

/**
 * Enumeration of epims_EMSMaterial values
 * <p>
 * EN: No designation found.<br>
 * DE: No designation found.<br>
 * FR: No designation found.<br>
 * IT: No designation found.<br>
 * <p>
 * Identifier: 1.2.40.0.34.6.0.10.17<br>
 * Effective date: 2020-02-20 14:43<br>
 * Version: 2020<br>
 * Status: DRAFT
 */
@Generated(value = "org.projecthusky.codegenerator.ch.valuesets.UpdateValueSets", date = "2022-02-01")
public enum EpimsEmsmaterial implements ValueSetEnumInterface {

    /**
     * EN: Abstrich.<br>
     */
    ABSTRICH("ABSTRICH",
             "1.2.40.0.34.5.58",
             "Abstrich",
             "Abstrich",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Abszess.<br>
     */
    ABSZESS("ABSZESS",
            "1.2.40.0.34.5.58",
            "Abszess",
            "Abszess",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: anderes.<br>
     */
    ANDERES("OTHER",
            "1.2.40.0.34.5.58",
            "anderes",
            "anderes",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: andere Abstriche.<br>
     */
    ANDERE_ABSTRICHE("OTHERSWAB",
                     "1.2.40.0.34.5.58",
                     "andere Abstriche",
                     "andere Abstriche",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: andere erregerhaltige Körperflüssigkeiten.<br>
     */
    ANDERE_ERREGERHALTIGE_K_RPERFL_SSIGKEITEN("OTHERBODY",
                                              "1.2.40.0.34.5.58",
                                              "andere erregerhaltige Körperflüssigkeiten",
                                              "andere erregerhaltige Körperflüssigkeiten",
                                              "TOTRANSLATE",
                                              "TOTRANSLATE",
                                              "TOTRANSLATE"),
    /**
     * EN: andere nicht sterile Probe.<br>
     */
    ANDERE_NICHT_STERILE_PROBE("OTHERNOTSTERILE",
                               "1.2.40.0.34.5.58",
                               "andere nicht sterile Probe",
                               "andere nicht sterile Probe",
                               "TOTRANSLATE",
                               "TOTRANSLATE",
                               "TOTRANSLATE"),
    /**
     * EN: andere sterile Probe.<br>
     */
    ANDERE_STERILE_PROBE("OTHERSTERILE",
                         "1.2.40.0.34.5.58",
                         "andere sterile Probe",
                         "andere sterile Probe",
                         "TOTRANSLATE",
                         "TOTRANSLATE",
                         "TOTRANSLATE"),
    /**
     * EN: Ascites.<br>
     */
    ASCITES("ASCITES",
            "1.2.40.0.34.5.58",
            "Ascites",
            "Ascites",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Biopsiematerial.<br>
     */
    BIOPSIEMATERIAL("BIOPSIE",
                    "1.2.40.0.34.5.58",
                    "Biopsiematerial",
                    "Biopsiematerial",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Blut.<br>
     */
    BLUT("BLOOD",
         "1.2.40.0.34.5.58",
         "Blut",
         "Blut",
         "TOTRANSLATE",
         "TOTRANSLATE",
         "TOTRANSLATE"),
    /**
     * EN: Blutausstrich.<br>
     */
    BLUTAUSSTRICH("BLOODAUS",
                  "1.2.40.0.34.5.58",
                  "Blutausstrich",
                  "Blutausstrich",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Bronchiallavage.<br>
     */
    BRONCHIALLAVAGE("BRONCHLAV",
                    "1.2.40.0.34.5.58",
                    "Bronchiallavage",
                    "Bronchiallavage",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Bronchialsekret.<br>
     */
    BRONCHIALSEKRET("BRONCHSEKR",
                    "1.2.40.0.34.5.58",
                    "Bronchialsekret",
                    "Bronchialsekret",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Cervicalabstrich.<br>
     */
    CERVICALABSTRICH("CERVSWAB",
                     "1.2.40.0.34.5.58",
                     "Cervicalabstrich",
                     "Cervicalabstrich",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: EDTA-Blut.<br>
     */
    EDTA_BLUT("EDTA",
              "1.2.40.0.34.5.58",
              "EDTA-Blut",
              "EDTA-Blut",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: EDTA-Blut/Plas,a.<br>
     */
    EDTA_BLUT_PLAS_A("EDTAPLAS",
                     "1.2.40.0.34.5.58",
                     "EDTA-Blut/Plas,a",
                     "EDTA-Blut/Plas,a",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: Eiter.<br>
     */
    EITER("EITER",
          "1.2.40.0.34.5.58",
          "Eiter",
          "Eiter",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: Ejakulat.<br>
     */
    EJAKULAT("EJAKULAT",
             "1.2.40.0.34.5.58",
             "Ejakulat",
             "Ejakulat",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Erbrochenes.<br>
     */
    ERBROCHENES("ERBR",
                "1.2.40.0.34.5.58",
                "Erbrochenes",
                "Erbrochenes",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Exsudat Peritoneum.<br>
     */
    EXSUDAT_PERITONEUM("EXSUPERI",
                       "1.2.40.0.34.5.58",
                       "Exsudat Peritoneum",
                       "Exsudat Peritoneum",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: Exsudat Pleura.<br>
     */
    EXSUDAT_PLEURA("EXSUPLEURA",
                   "1.2.40.0.34.5.58",
                   "Exsudat Pleura",
                   "Exsudat Pleura",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Gallenflüssigkeit.<br>
     */
    GALLENFL_SSIGKEIT("GALLE",
                      "1.2.40.0.34.5.58",
                      "Gallenflüssigkeit",
                      "Gallenflüssigkeit",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Gelenkflüssigkeit.<br>
     */
    GELENKFL_SSIGKEIT("GELENK",
                      "1.2.40.0.34.5.58",
                      "Gelenkflüssigkeit",
                      "Gelenkflüssigkeit",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: getrockneter Bluttropfen.<br>
     */
    GETROCKNETER_BLUTTROPFEN("BLOODDRY",
                             "1.2.40.0.34.5.58",
                             "getrockneter Bluttropfen",
                             "getrockneter Bluttropfen",
                             "TOTRANSLATE",
                             "TOTRANSLATE",
                             "TOTRANSLATE"),
    /**
     * EN: Gewebe.<br>
     */
    GEWEBE("GEWEBE",
           "1.2.40.0.34.5.58",
           "Gewebe",
           "Gewebe",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Harn.<br>
     */
    HARN("URINE",
         "1.2.40.0.34.5.58",
         "Harn",
         "Harn",
         "TOTRANSLATE",
         "TOTRANSLATE",
         "TOTRANSLATE"),
    /**
     * EN: Haut.<br>
     */
    HAUT("HAUT",
         "1.2.40.0.34.5.58",
         "Haut",
         "Haut",
         "TOTRANSLATE",
         "TOTRANSLATE",
         "TOTRANSLATE"),
    /**
     * EN: Hirn.<br>
     */
    HIRN("HIRN",
         "1.2.40.0.34.5.58",
         "Hirn",
         "Hirn",
         "TOTRANSLATE",
         "TOTRANSLATE",
         "TOTRANSLATE"),
    /**
     * EN: Isolat.<br>
     */
    ISOLAT("ISOLAT",
           "1.2.40.0.34.5.58",
           "Isolat",
           "Isolat",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Knochenmark.<br>
     */
    KNOCHENMARK("KNOCHENMARK",
                "1.2.40.0.34.5.58",
                "Knochenmark",
                "Knochenmark",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Kruste.<br>
     */
    KRUSTE("KRUSTE",
           "1.2.40.0.34.5.58",
           "Kruste",
           "Kruste",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Lavage.<br>
     */
    LAVAGE("LAVAGE",
           "1.2.40.0.34.5.58",
           "Lavage",
           "Lavage",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Leberbiopsie.<br>
     */
    LEBERBIOPSIE("LEBER",
                 "1.2.40.0.34.5.58",
                 "Leberbiopsie",
                 "Leberbiopsie",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Leichenblut.<br>
     */
    LEICHENBLUT("BLOODPOST",
                "1.2.40.0.34.5.58",
                "Leichenblut",
                "Leichenblut",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Liquor.<br>
     */
    LIQUOR("CSF",
           "1.2.40.0.34.5.58",
           "Liquor",
           "Liquor",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Lunge.<br>
     */
    LUNGE("LUNGE",
          "1.2.40.0.34.5.58",
          "Lunge",
          "Lunge",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: Lymphknoten.<br>
     */
    LYMPHKNOTEN("LYMPH",
                "1.2.40.0.34.5.58",
                "Lymphknoten",
                "Lymphknoten",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Magensaft.<br>
     */
    MAGENSAFT("MAGENSAFT",
              "1.2.40.0.34.5.58",
              "Magensaft",
              "Magensaft",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Membran.<br>
     */
    MEMBRAN("MEMBRAN",
            "1.2.40.0.34.5.58",
            "Membran",
            "Membran",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Milz.<br>
     */
    MILZ("MILZ",
         "1.2.40.0.34.5.58",
         "Milz",
         "Milz",
         "TOTRANSLATE",
         "TOTRANSLATE",
         "TOTRANSLATE"),
    /**
     * EN: Nackenhautbiopsie.<br>
     */
    NACKENHAUTBIOPSIE("NACKENHAUT",
                      "1.2.40.0.34.5.58",
                      "Nackenhautbiopsie",
                      "Nackenhautbiopsie",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Nasenabstrich.<br>
     */
    NASENABSTRICH("NASALSWAB",
                  "1.2.40.0.34.5.58",
                  "Nasenabstrich",
                  "Nasenabstrich",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Neugeborenenabstrich.<br>
     */
    NEUGEBORENENABSTRICH("NEWBORNSWAB",
                         "1.2.40.0.34.5.58",
                         "Neugeborenenabstrich",
                         "Neugeborenenabstrich",
                         "TOTRANSLATE",
                         "TOTRANSLATE",
                         "TOTRANSLATE"),
    /**
     * EN: Operationsmaterial.<br>
     */
    OPERATIONSMATERIAL("OPMATERIAL",
                       "1.2.40.0.34.5.58",
                       "Operationsmaterial",
                       "Operationsmaterial",
                       "TOTRANSLATE",
                       "TOTRANSLATE",
                       "TOTRANSLATE"),
    /**
     * EN: Plasma.<br>
     */
    PLASMA("PLASMA",
           "1.2.40.0.34.5.58",
           "Plasma",
           "Plasma",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: post mortem-Material.<br>
     */
    POST_MORTEM_MATERIAL("POSTMORTEM",
                         "1.2.40.0.34.5.58",
                         "post mortem-Material",
                         "post mortem-Material",
                         "TOTRANSLATE",
                         "TOTRANSLATE",
                         "TOTRANSLATE"),
    /**
     * EN: Punktat.<br>
     */
    PUNKTAT("PUNKTAT",
            "1.2.40.0.34.5.58",
            "Punktat",
            "Punktat",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Rachenabstrich.<br>
     */
    RACHENABSTRICH("NASALTHROATSWAB",
                   "1.2.40.0.34.5.58",
                   "Rachenabstrich",
                   "Rachenabstrich",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Rachenspülflüssigkeit Serum.<br>
     */
    RACHENSP_LFL_SSIGKEIT_SERUM("THROATSWABFLUSS",
                                "1.2.40.0.34.5.58",
                                "Rachenspülflüssigkeit Serum",
                                "Rachenspülflüssigkeit Serum",
                                "TOTRANSLATE",
                                "TOTRANSLATE",
                                "TOTRANSLATE"),
    /**
     * EN: Rektalabstrich.<br>
     */
    REKTALABSTRICH("ANAL",
                   "1.2.40.0.34.5.58",
                   "Rektalabstrich",
                   "Rektalabstrich",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Respiratorische Sekrete.<br>
     */
    RESPIRATORISCHE_SEKRETE("RESPSEKR",
                            "1.2.40.0.34.5.58",
                            "Respiratorische Sekrete",
                            "Respiratorische Sekrete",
                            "TOTRANSLATE",
                            "TOTRANSLATE",
                            "TOTRANSLATE"),
    /**
     * EN: Sekrete.<br>
     */
    SEKRETE("SEKRETE",
            "1.2.40.0.34.5.58",
            "Sekrete",
            "Sekrete",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Serum.<br>
     */
    SERUM("SERUM",
          "1.2.40.0.34.5.58",
          "Serum",
          "Serum",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: sonstiges.<br>
     */
    SONSTIGES("SONST",
              "1.2.40.0.34.5.58",
              "sonstiges",
              "sonstiges",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Speichel.<br>
     */
    SPEICHEL("SPEICHEL",
             "1.2.40.0.34.5.58",
             "Speichel",
             "Speichel",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Spritzeninhalt.<br>
     */
    SPRITZENINHALT("SPRITZE",
                   "1.2.40.0.34.5.58",
                   "Spritzeninhalt",
                   "Spritzeninhalt",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Sputum.<br>
     */
    SPUTUM("SPUTUM",
           "1.2.40.0.34.5.58",
           "Sputum",
           "Sputum",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Stuhl.<br>
     */
    STUHL("STUHL",
          "1.2.40.0.34.5.58",
          "Stuhl",
          "Stuhl",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: Tonsillenabstrich.<br>
     */
    TONSILLENABSTRICH("TONS",
                      "1.2.40.0.34.5.58",
                      "Tonsillenabstrich",
                      "Tonsillenabstrich",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Umgebungsprobe.<br>
     */
    UMGEBUNGSPROBE("UMGEB",
                   "1.2.40.0.34.5.58",
                   "Umgebungsprobe",
                   "Umgebungsprobe",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Vollblut.<br>
     */
    VOLLBLUT("BLOODFULL",
             "1.2.40.0.34.5.58",
             "Vollblut",
             "Vollblut",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Wundsekret.<br>
     */
    WUNDSEKRET("WUND",
               "1.2.40.0.34.5.58",
               "Wundsekret",
               "Wundsekret",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE");

    /**
     * EN: Code for Abstrich.<br>
     */
    public static final String ABSTRICH_CODE = "ABSTRICH";

    /**
     * EN: Code for Abszess.<br>
     */
    public static final String ABSZESS_CODE = "ABSZESS";

    /**
     * EN: Code for anderes.<br>
     */
    public static final String ANDERES_CODE = "OTHER";

    /**
     * EN: Code for andere Abstriche.<br>
     */
    public static final String ANDERE_ABSTRICHE_CODE = "OTHERSWAB";

    /**
     * EN: Code for andere erregerhaltige Körperflüssigkeiten.<br>
     */
    public static final String ANDERE_ERREGERHALTIGE_K_RPERFL_SSIGKEITEN_CODE = "OTHERBODY";

    /**
     * EN: Code for andere nicht sterile Probe.<br>
     */
    public static final String ANDERE_NICHT_STERILE_PROBE_CODE = "OTHERNOTSTERILE";

    /**
     * EN: Code for andere sterile Probe.<br>
     */
    public static final String ANDERE_STERILE_PROBE_CODE = "OTHERSTERILE";

    /**
     * EN: Code for Ascites.<br>
     */
    public static final String ASCITES_CODE = "ASCITES";

    /**
     * EN: Code for Biopsiematerial.<br>
     */
    public static final String BIOPSIEMATERIAL_CODE = "BIOPSIE";

    /**
     * EN: Code for Blut.<br>
     */
    public static final String BLUT_CODE = "BLOOD";

    /**
     * EN: Code for Blutausstrich.<br>
     */
    public static final String BLUTAUSSTRICH_CODE = "BLOODAUS";

    /**
     * EN: Code for Bronchiallavage.<br>
     */
    public static final String BRONCHIALLAVAGE_CODE = "BRONCHLAV";

    /**
     * EN: Code for Bronchialsekret.<br>
     */
    public static final String BRONCHIALSEKRET_CODE = "BRONCHSEKR";

    /**
     * EN: Code for Cervicalabstrich.<br>
     */
    public static final String CERVICALABSTRICH_CODE = "CERVSWAB";

    /**
     * EN: Code for EDTA-Blut.<br>
     */
    public static final String EDTA_BLUT_CODE = "EDTA";

    /**
     * EN: Code for EDTA-Blut/Plas,a.<br>
     */
    public static final String EDTA_BLUT_PLAS_A_CODE = "EDTAPLAS";

    /**
     * EN: Code for Eiter.<br>
     */
    public static final String EITER_CODE = "EITER";

    /**
     * EN: Code for Ejakulat.<br>
     */
    public static final String EJAKULAT_CODE = "EJAKULAT";

    /**
     * EN: Code for Erbrochenes.<br>
     */
    public static final String ERBROCHENES_CODE = "ERBR";

    /**
     * EN: Code for Exsudat Peritoneum.<br>
     */
    public static final String EXSUDAT_PERITONEUM_CODE = "EXSUPERI";

    /**
     * EN: Code for Exsudat Pleura.<br>
     */
    public static final String EXSUDAT_PLEURA_CODE = "EXSUPLEURA";

    /**
     * EN: Code for Gallenflüssigkeit.<br>
     */
    public static final String GALLENFL_SSIGKEIT_CODE = "GALLE";

    /**
     * EN: Code for Gelenkflüssigkeit.<br>
     */
    public static final String GELENKFL_SSIGKEIT_CODE = "GELENK";

    /**
     * EN: Code for getrockneter Bluttropfen.<br>
     */
    public static final String GETROCKNETER_BLUTTROPFEN_CODE = "BLOODDRY";

    /**
     * EN: Code for Gewebe.<br>
     */
    public static final String GEWEBE_CODE = "GEWEBE";

    /**
     * EN: Code for Harn.<br>
     */
    public static final String HARN_CODE = "URINE";

    /**
     * EN: Code for Haut.<br>
     */
    public static final String HAUT_CODE = "HAUT";

    /**
     * EN: Code for Hirn.<br>
     */
    public static final String HIRN_CODE = "HIRN";

    /**
     * EN: Code for Isolat.<br>
     */
    public static final String ISOLAT_CODE = "ISOLAT";

    /**
     * EN: Code for Knochenmark.<br>
     */
    public static final String KNOCHENMARK_CODE = "KNOCHENMARK";

    /**
     * EN: Code for Kruste.<br>
     */
    public static final String KRUSTE_CODE = "KRUSTE";

    /**
     * EN: Code for Lavage.<br>
     */
    public static final String LAVAGE_CODE = "LAVAGE";

    /**
     * EN: Code for Leberbiopsie.<br>
     */
    public static final String LEBERBIOPSIE_CODE = "LEBER";

    /**
     * EN: Code for Leichenblut.<br>
     */
    public static final String LEICHENBLUT_CODE = "BLOODPOST";

    /**
     * EN: Code for Liquor.<br>
     */
    public static final String LIQUOR_CODE = "CSF";

    /**
     * EN: Code for Lunge.<br>
     */
    public static final String LUNGE_CODE = "LUNGE";

    /**
     * EN: Code for Lymphknoten.<br>
     */
    public static final String LYMPHKNOTEN_CODE = "LYMPH";

    /**
     * EN: Code for Magensaft.<br>
     */
    public static final String MAGENSAFT_CODE = "MAGENSAFT";

    /**
     * EN: Code for Membran.<br>
     */
    public static final String MEMBRAN_CODE = "MEMBRAN";

    /**
     * EN: Code for Milz.<br>
     */
    public static final String MILZ_CODE = "MILZ";

    /**
     * EN: Code for Nackenhautbiopsie.<br>
     */
    public static final String NACKENHAUTBIOPSIE_CODE = "NACKENHAUT";

    /**
     * EN: Code for Nasenabstrich.<br>
     */
    public static final String NASENABSTRICH_CODE = "NASALSWAB";

    /**
     * EN: Code for Neugeborenenabstrich.<br>
     */
    public static final String NEUGEBORENENABSTRICH_CODE = "NEWBORNSWAB";

    /**
     * EN: Code for Operationsmaterial.<br>
     */
    public static final String OPERATIONSMATERIAL_CODE = "OPMATERIAL";

    /**
     * EN: Code for Plasma.<br>
     */
    public static final String PLASMA_CODE = "PLASMA";

    /**
     * EN: Code for post mortem-Material.<br>
     */
    public static final String POST_MORTEM_MATERIAL_CODE = "POSTMORTEM";

    /**
     * EN: Code for Punktat.<br>
     */
    public static final String PUNKTAT_CODE = "PUNKTAT";

    /**
     * EN: Code for Rachenabstrich.<br>
     */
    public static final String RACHENABSTRICH_CODE = "NASALTHROATSWAB";

    /**
     * EN: Code for Rachenspülflüssigkeit Serum.<br>
     */
    public static final String RACHENSP_LFL_SSIGKEIT_SERUM_CODE = "THROATSWABFLUSS";

    /**
     * EN: Code for Rektalabstrich.<br>
     */
    public static final String REKTALABSTRICH_CODE = "ANAL";

    /**
     * EN: Code for Respiratorische Sekrete.<br>
     */
    public static final String RESPIRATORISCHE_SEKRETE_CODE = "RESPSEKR";

    /**
     * EN: Code for Sekrete.<br>
     */
    public static final String SEKRETE_CODE = "SEKRETE";

    /**
     * EN: Code for Serum.<br>
     */
    public static final String SERUM_CODE = "SERUM";

    /**
     * EN: Code for sonstiges.<br>
     */
    public static final String SONSTIGES_CODE = "SONST";

    /**
     * EN: Code for Speichel.<br>
     */
    public static final String SPEICHEL_CODE = "SPEICHEL";

    /**
     * EN: Code for Spritzeninhalt.<br>
     */
    public static final String SPRITZENINHALT_CODE = "SPRITZE";

    /**
     * EN: Code for Sputum.<br>
     */
    public static final String SPUTUM_CODE = "SPUTUM";

    /**
     * EN: Code for Stuhl.<br>
     */
    public static final String STUHL_CODE = "STUHL";

    /**
     * EN: Code for Tonsillenabstrich.<br>
     */
    public static final String TONSILLENABSTRICH_CODE = "TONS";

    /**
     * EN: Code for Umgebungsprobe.<br>
     */
    public static final String UMGEBUNGSPROBE_CODE = "UMGEB";

    /**
     * EN: Code for Vollblut.<br>
     */
    public static final String VOLLBLUT_CODE = "BLOODFULL";

    /**
     * EN: Code for Wundsekret.<br>
     */
    public static final String WUNDSEKRET_CODE = "WUND";

    /**
     * Identifier of the value set.
     */
    public static final String VALUE_SET_ID = "1.2.40.0.34.6.0.10.17";

    /**
     * Name of the value set.
     */
    public static final String VALUE_SET_NAME = "epims_EMSMaterial";

    /**
     * Identifier of the code system (all values share the same).
     */
    public static final String CODE_SYSTEM_ID = "1.2.40.0.34.5.58";

    /**
     * Gets the Enum with a given code.
     *
     * @param code The code value.
     * @return the enum value found or {@code null}.
     */
    @Nullable
    public static EpimsEmsmaterial getEnum(@Nullable final String code) {
        for (final EpimsEmsmaterial x : values()) {
            if (x.getCodeValue().equals(code)) {
                return x;
            }
        }
        return null;
    }

    /**
     * Checks if a given enum is part of this value set.
     *
     * @param enumName The name of the enum.
     * @return {@code true} if the name is found in this value set, {@code false} otherwise.
     */
    public static boolean isEnumOfValueSet(@Nullable final String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(EpimsEmsmaterial.class,
                         enumName);
            return true;
        } catch (final IllegalArgumentException ex) {
            return false;
        }
    }

    /**
     * Checks if a given code value is in this value set.
     *
     * @param codeValue The code value.
     * @return {@code true} if the value is found in this value set, {@code false} otherwise.
     */
    public static boolean isInValueSet(@Nullable final String codeValue) {
        for (final EpimsEmsmaterial x : values()) {
            if (x.getCodeValue().equals(codeValue)) {
                return true;
            }
        }
        return false;
    }

    /**
     * Machine interpretable and (inside this class) unique code.
     */
    @NonNull
    private final String code;

    /**
     * Identifier of the referencing code system.
     */
    @NonNull
    private final String codeSystem;

    /**
     * The display names per language. It's always stored in the given order: default display name (0), in English (1),
     * in German (2), in French (3) and in Italian (4).
     */
    @NonNull
    private final String[] displayNames;

    /**
     * Instantiates this enum with a given code and display names.
     *
     * @param code          The code value.
     * @param codeSystem    The code system (OID).
     * @param displayName   The default display name.
     * @param displayNameEn The display name in English.
     * @param displayNameDe The display name in German.
     * @param displayNameFr The display name in French.
     * @param displayNameIt The display name in Italian.
     */
    EpimsEmsmaterial(@NonNull final String code, @NonNull final String codeSystem, @NonNull final String displayName, @NonNull final String displayNameEn, @NonNull final String displayNameDe, @NonNull final String displayNameFr, @NonNull final String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    /**
     * Gets the code system identifier.
     *
     * @return the code system identifier.
     */
    @Override
    @NonNull
    public String getCodeSystemId() {
        return this.codeSystem;
    }

    /**
     * Gets the code system name.
     *
     * @return the code system name.
     */
    @Override
    @NonNull
    public String getCodeSystemName() {
        final var codeSystem = CodeSystems.getEnum(this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    /**
     * Gets the code value as a string.
     *
     * @return the code value.
     */
    @Override
    @NonNull
    public String getCodeValue() {
        return this.code;
    }

    /**
     * Gets the display name defined by the language param.
     *
     * @param languageCode The language code to get the display name for, {@code null} to get the default display name.
     * @return the display name in the desired language.
     */
    @Override
    @NonNull
    public String getDisplayName(@Nullable final LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch(languageCode) {
            case ENGLISH ->
                this.displayNames[1];
            case GERMAN ->
                this.displayNames[2];
            case FRENCH ->
                this.displayNames[3];
            case ITALIAN ->
                this.displayNames[4];
            default ->
                "TOTRANSLATE";
        };
    }

    /**
     * Gets the value set identifier.
     *
     * @return the value set identifier.
     */
    @Override
    @NonNull
    public String getValueSetId() {
        return VALUE_SET_ID;
    }

    /**
     * Gets the value set name.
     *
     * @return the value set name.
     */
    @Override
    @NonNull
    public String getValueSetName() {
        return VALUE_SET_NAME;
    }
}
