/*
 * This code is made available under the terms of the Eclipse Public License v1.0
 * in the github project https://github.com/project-husky/husky there you also
 * find a list of the contributors and the license information.
 *
 * This project has been developed further and modified by the joined working group Husky
 * on the basis of the eHealth Connector opensource project from June 28, 2021,
 * whereas medshare GmbH is the initial and main contributor/author of the eHealth Connector.
 */
package org.projecthusky.cda.elga.generated.artdecor.enums;

import java.util.Objects;

import javax.annotation.processing.Generated;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

/**
 * Enumeration of eImpf_HistorischeImpfstoffe_VS values
 * <p>
 * EN: No designation found.<br>
 * DE: No designation found.<br>
 * FR: No designation found.<br>
 * IT: No designation found.<br>
 * <p>
 * Identifier: 1.2.40.0.34.6.0.10.10<br>
 * Effective date: 2021-11-23 00:00<br>
 * Version: 202111(-beta)<br>
 * Status: DRAFT
 */
@Generated(value = "org.projecthusky.codegenerator.ch.valuesets.UpdateValueSets", date = "2022-02-18")
public enum EImpfHistorischeImpfstoffeVs implements ValueSetEnumInterface {

    /**
     * EN: Acel - P Lederle.<br>
     */
    ACEL_P_LEDERLE("AHI001",
                   "1.2.40.0.34.5.186",
                   "Acel - P Lederle",
                   "Acel - P Lederle",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Act-HIB+DPT.<br>
     */
    ACT_HIB_DPT("AHI002",
                "1.2.40.0.34.5.186",
                "Act-HIB+DPT",
                "Act-HIB+DPT",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Addigrip.<br>
     */
    ADDIGRIP("AHI003",
             "1.2.40.0.34.5.186",
             "Addigrip",
             "Addigrip",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Arepanrix.<br>
     */
    AREPANRIX("AHI004",
              "1.2.40.0.34.5.186",
              "Arepanrix",
              "Arepanrix",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Arilvax.<br>
     */
    ARILVAX("AHI005",
            "1.2.40.0.34.5.186",
            "Arilvax",
            "Arilvax",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Avaxim.<br>
     */
    AVAXIM("AHI130",
           "1.2.40.0.34.5.186",
           "Avaxim",
           "Avaxim",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Batrevac.<br>
     */
    BATREVAC("AHI006",
             "1.2.40.0.34.5.186",
             "Batrevac",
             "Batrevac",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: BCG Vaccine 'Mérieux'.<br>
     */
    BCG_VACCINE_M_RIEUX("AHI007",
                        "1.2.40.0.34.5.186",
                        "BCG Vaccine 'Mérieux'",
                        "BCG Vaccine 'Mérieux'",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: Begrivac.<br>
     */
    BEGRIVAC("AHI008",
             "1.2.40.0.34.5.186",
             "Begrivac",
             "Begrivac",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Celvapan.<br>
     */
    CELVAPAN("AHI009",
             "1.2.40.0.34.5.186",
             "Celvapan",
             "Celvapan",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Cholera - Impfstoff 'Berna'.<br>
     */
    CHOLERA_IMPFSTOFF_BERNA("AHI010",
                            "1.2.40.0.34.5.186",
                            "Cholera - Impfstoff 'Berna'",
                            "Cholera - Impfstoff 'Berna'",
                            "TOTRANSLATE",
                            "TOTRANSLATE",
                            "TOTRANSLATE"),
    /**
     * EN: Cholera - Vakzine 'Sero'.<br>
     */
    CHOLERA_VAKZINE_SERO("AHI011",
                         "1.2.40.0.34.5.186",
                         "Cholera - Vakzine 'Sero'",
                         "Cholera - Vakzine 'Sero'",
                         "TOTRANSLATE",
                         "TOTRANSLATE",
                         "TOTRANSLATE"),
    /**
     * EN: Daronrix.<br>
     */
    DARONRIX("AHI012",
             "1.2.40.0.34.5.186",
             "Daronrix",
             "Daronrix",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Diftetall.<br>
     */
    DIFTETALL("AHI013",
              "1.2.40.0.34.5.186",
              "Diftetall",
              "Diftetall",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Diphtherie Adsorbat Impfstoff 'Behring'.<br>
     */
    DIPHTHERIE_ADSORBAT_IMPFSTOFF_BEHRING("AHI014",
                                          "1.2.40.0.34.5.186",
                                          "Diphtherie Adsorbat Impfstoff 'Behring'",
                                          "Diphtherie Adsorbat Impfstoff 'Behring'",
                                          "TOTRANSLATE",
                                          "TOTRANSLATE",
                                          "TOTRANSLATE"),
    /**
     * EN: Ditanrix.<br>
     */
    DITANRIX("AHI015",
             "1.2.40.0.34.5.186",
             "Ditanrix",
             "Ditanrix",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: DiTePer Anatoxal Berna.<br>
     */
    DITEPER_ANATOXAL_BERNA("AHI018",
                           "1.2.40.0.34.5.186",
                           "DiTePer Anatoxal Berna",
                           "DiTePer Anatoxal Berna",
                           "TOTRANSLATE",
                           "TOTRANSLATE",
                           "TOTRANSLATE"),
    /**
     * EN: DiTe Anatoxal Berna.<br>
     */
    DITE_ANATOXAL_BERNA("AHI016",
                        "1.2.40.0.34.5.186",
                        "DiTe Anatoxal Berna",
                        "DiTe Anatoxal Berna",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: DiTe Anatoxal(dT) Berna.<br>
     */
    DITE_ANATOXAL_DT_BERNA("AHI017",
                           "1.2.40.0.34.5.186",
                           "DiTe Anatoxal(dT) Berna",
                           "DiTe Anatoxal(dT) Berna",
                           "TOTRANSLATE",
                           "TOTRANSLATE",
                           "TOTRANSLATE"),
    /**
     * EN: DPT Adsorbat 'Mérieux'.<br>
     */
    DPT_ADSORBAT_M_RIEUX("AHI020",
                         "1.2.40.0.34.5.186",
                         "DPT Adsorbat 'Mérieux'",
                         "DPT Adsorbat 'Mérieux'",
                         "TOTRANSLATE",
                         "TOTRANSLATE",
                         "TOTRANSLATE"),
    /**
     * EN: DTaP Vakzine SSI.<br>
     */
    DTAP_VAKZINE_SSI("AHI021",
                     "1.2.40.0.34.5.186",
                     "DTaP Vakzine SSI",
                     "DTaP Vakzine SSI",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: DT Adsorbat 'Mérieux'.<br>
     */
    DT_ADSORBAT_M_RIEUX("AHI019",
                        "1.2.40.0.34.5.186",
                        "DT Adsorbat 'Mérieux'",
                        "DT Adsorbat 'Mérieux'",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: D.T.Vax.<br>
     */
    D_T_VAX("AHI022",
            "1.2.40.0.34.5.186",
            "D.T.Vax",
            "D.T.Vax",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Epaxal.<br>
     */
    EPAXAL("AHI023",
           "1.2.40.0.34.5.186",
           "Epaxal",
           "Epaxal",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Ervevax.<br>
     */
    ERVEVAX("AHI024",
            "1.2.40.0.34.5.186",
            "Ervevax",
            "Ervevax",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Fluad.<br>
     */
    FLUAD("AHI131",
          "1.2.40.0.34.5.186",
          "Fluad",
          "Fluad",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: Fluarix.<br>
     */
    FLUARIX("AHI025",
            "1.2.40.0.34.5.186",
            "Fluarix",
            "Fluarix",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Fluenz.<br>
     */
    FLUENZ("AHI026",
           "1.2.40.0.34.5.186",
           "Fluenz",
           "Fluenz",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Fluvaccinol Subunit.<br>
     */
    FLUVACCINOL_SUBUNIT("AHI127",
                        "1.2.40.0.34.5.186",
                        "Fluvaccinol Subunit",
                        "Fluvaccinol Subunit",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: Fluvirin.<br>
     */
    FLUVIRIN("AHI027",
             "1.2.40.0.34.5.186",
             "Fluvirin",
             "Fluvirin",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Focetria.<br>
     */
    FOCETRIA("AHI028",
             "1.2.40.0.34.5.186",
             "Focetria",
             "Focetria",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Gen-HB-vax 10 ug.<br>
     */
    GEN_HB_VAX_10_UG("AHI029",
                     "1.2.40.0.34.5.186",
                     "Gen-HB-vax 10 ug",
                     "Gen-HB-vax 10 ug",
                     "TOTRANSLATE",
                     "TOTRANSLATE",
                     "TOTRANSLATE"),
    /**
     * EN: Havrix 360 E.I.U./ml.<br>
     */
    HAVRIX_360_E_I_U_ML("AHI030",
                        "1.2.40.0.34.5.186",
                        "Havrix 360 E.I.U./ml",
                        "Havrix 360 E.I.U./ml",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: Hepacare.<br>
     */
    HEPACARE("AHI031",
             "1.2.40.0.34.5.186",
             "Hepacare",
             "Hepacare",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Hepatyrix.<br>
     */
    HEPATYRIX("AHI032",
              "1.2.40.0.34.5.186",
              "Hepatyrix",
              "Hepatyrix",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Hevac B 'Pasteur'.<br>
     */
    HEVAC_B_PASTEUR("AHI033",
                    "1.2.40.0.34.5.186",
                    "Hevac B 'Pasteur'",
                    "Hevac B 'Pasteur'",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Hexavac.<br>
     */
    HEXAVAC("AHI034",
            "1.2.40.0.34.5.186",
            "Hexavac",
            "Hexavac",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Hiberix.<br>
     */
    HIBERIX("AHI036",
            "1.2.40.0.34.5.186",
            "Hiberix",
            "Hiberix",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: HIB-Titer.<br>
     */
    HIB_TITER("AHI035",
              "1.2.40.0.34.5.186",
              "HIB-Titer",
              "HIB-Titer",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Humenza.<br>
     */
    HUMENZA("AHI037",
            "1.2.40.0.34.5.186",
            "Humenza",
            "Humenza",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: IDflu.<br>
     */
    IDFLU("AHI038",
          "1.2.40.0.34.5.186",
          "IDflu",
          "IDflu",
          "TOTRANSLATE",
          "TOTRANSLATE",
          "TOTRANSLATE"),
    /**
     * EN: Immovax Polio.<br>
     */
    IMMOVAX_POLIO("AHI040",
                  "1.2.40.0.34.5.186",
                  "Immovax Polio",
                  "Immovax Polio",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Immugrip.<br>
     */
    IMMUGRIP("AHI039",
             "1.2.40.0.34.5.186",
             "Immugrip",
             "Immugrip",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Infanrix.<br>
     */
    INFANRIX("AHI041",
             "1.2.40.0.34.5.186",
             "Infanrix",
             "Infanrix",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Infanrix + HepB.<br>
     */
    INFANRIX_HEPB("AHI044",
                  "1.2.40.0.34.5.186",
                  "Infanrix + HepB",
                  "Infanrix + HepB",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Infanrix + HiB.<br>
     */
    INFANRIX_HIB("AHI045",
                 "1.2.40.0.34.5.186",
                 "Infanrix + HiB",
                 "Infanrix + HiB",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Infanrix Penta.<br>
     */
    INFANRIX_PENTA("AHI042",
                   "1.2.40.0.34.5.186",
                   "Infanrix Penta",
                   "Infanrix Penta",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Infanrix Tetra.<br>
     */
    INFANRIX_TETRA("AHI043",
                   "1.2.40.0.34.5.186",
                   "Infanrix Tetra",
                   "Infanrix Tetra",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Inflexal V.<br>
     */
    INFLEXAL_V("AHI046",
               "1.2.40.0.34.5.186",
               "Inflexal V",
               "Inflexal V",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Intanza.<br>
     */
    INTANZA("AHI047",
            "1.2.40.0.34.5.186",
            "Intanza",
            "Intanza",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Invivac.<br>
     */
    INVIVAC("AHI048",
            "1.2.40.0.34.5.186",
            "Invivac",
            "Invivac",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: IPV Mérieux.<br>
     */
    IPV_M_RIEUX("AHI049",
                "1.2.40.0.34.5.186",
                "IPV Mérieux",
                "IPV Mérieux",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Japan B Encephalitis Vaccine.<br>
     */
    JAPAN_B_ENCEPHALITIS_VACCINE("AHI051",
                                 "1.2.40.0.34.5.186",
                                 "Japan B Encephalitis Vaccine",
                                 "Japan B Encephalitis Vaccine",
                                 "TOTRANSLATE",
                                 "TOTRANSLATE",
                                 "TOTRANSLATE"),
    /**
     * EN: JE - Vax.<br>
     */
    JE_VAX("AHI050",
           "1.2.40.0.34.5.186",
           "JE - Vax",
           "JE - Vax",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Laevactin.<br>
     */
    LAEVACTIN("AHI052",
              "1.2.40.0.34.5.186",
              "Laevactin",
              "Laevactin",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Masern Vaccine 'Mérieux'.<br>
     */
    MASERN_VACCINE_M_RIEUX("AHI053",
                           "1.2.40.0.34.5.186",
                           "Masern Vaccine 'Mérieux'",
                           "Masern Vaccine 'Mérieux'",
                           "TOTRANSLATE",
                           "TOTRANSLATE",
                           "TOTRANSLATE"),
    /**
     * EN: Menactra.<br>
     */
    MENACTRA("AHI059",
             "1.2.40.0.34.5.186",
             "Menactra",
             "Menactra",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Mencevax ACWY.<br>
     */
    MENCEVAX_ACWY("AHI057",
                  "1.2.40.0.34.5.186",
                  "Mencevax ACWY",
                  "Mencevax ACWY",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Meningokokken-Impfstoff A+C Mérieux.<br>
     */
    MENINGOKOKKEN_IMPFSTOFF_A_C_M_RIEUX("AHI060",
                                        "1.2.40.0.34.5.186",
                                        "Meningokokken-Impfstoff A+C Mérieux",
                                        "Meningokokken-Impfstoff A+C Mérieux",
                                        "TOTRANSLATE",
                                        "TOTRANSLATE",
                                        "TOTRANSLATE"),
    /**
     * EN: Meningovax A+C.<br>
     */
    MENINGOVAX_A_C("AHI058",
                   "1.2.40.0.34.5.186",
                   "Meningovax A+C",
                   "Meningovax A+C",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Meninvact C.<br>
     */
    MENINVACT_C("AHI061",
                "1.2.40.0.34.5.186",
                "Meninvact C",
                "Meninvact C",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Menomune ACWY.<br>
     */
    MENOMUNE_ACWY("AHI054",
                  "1.2.40.0.34.5.186",
                  "Menomune ACWY",
                  "Menomune ACWY",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: MMR Triplovax.<br>
     */
    MMR_TRIPLOVAX("AHI056",
                  "1.2.40.0.34.5.186",
                  "MMR Triplovax",
                  "MMR Triplovax",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Mumps Vaccine 'Merieux'.<br>
     */
    MUMPS_VACCINE_MERIEUX("AHI055",
                          "1.2.40.0.34.5.186",
                          "Mumps Vaccine 'Merieux'",
                          "Mumps Vaccine 'Merieux'",
                          "TOTRANSLATE",
                          "TOTRANSLATE",
                          "TOTRANSLATE"),
    /**
     * EN: Mutagrip.<br>
     */
    MUTAGRIP("AHI062",
             "1.2.40.0.34.5.186",
             "Mutagrip",
             "Mutagrip",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Optaflu.<br>
     */
    OPTAFLU("AHI063",
            "1.2.40.0.34.5.186",
            "Optaflu",
            "Optaflu",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Orochol.<br>
     */
    OROCHOL("AHI064",
            "1.2.40.0.34.5.186",
            "Orochol",
            "Orochol",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: PAC-Mérieux.<br>
     */
    PAC_M_RIEUX("AHI065",
                "1.2.40.0.34.5.186",
                "PAC-Mérieux",
                "PAC-Mérieux",
                "TOTRANSLATE",
                "TOTRANSLATE",
                "TOTRANSLATE"),
    /**
     * EN: Pandemrix.<br>
     */
    PANDEMRIX("AHI066",
              "1.2.40.0.34.5.186",
              "Pandemrix",
              "Pandemrix",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Pariorix.<br>
     */
    PARIORIX("AHI067",
             "1.2.40.0.34.5.186",
             "Pariorix",
             "Pariorix",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Pediacel.<br>
     */
    PEDIACEL("AHI068",
             "1.2.40.0.34.5.186",
             "Pediacel",
             "Pediacel",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Pentavac.<br>
     */
    PENTAVAC("AHI070",
             "1.2.40.0.34.5.186",
             "Pentavac",
             "Pentavac",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Pent-Act-HiB.<br>
     */
    PENT_ACT_HIB("AHI069",
                 "1.2.40.0.34.5.186",
                 "Pent-Act-HiB",
                 "Pent-Act-HiB",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Pertoral.<br>
     */
    PERTORAL("AHI071",
             "1.2.40.0.34.5.186",
             "Pertoral",
             "Pertoral",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Pneumo 23 'Merieux'.<br>
     */
    PNEUMO_23_MERIEUX("AHI075",
                      "1.2.40.0.34.5.186",
                      "Pneumo 23 'Merieux'",
                      "Pneumo 23 'Merieux'",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: PNU-Imune.<br>
     */
    PNU_IMUNE("AHI076",
              "1.2.40.0.34.5.186",
              "PNU-Imune",
              "PNU-Imune",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Pocken Vaccine.<br>
     */
    POCKEN_VACCINE("AHI072",
                   "1.2.40.0.34.5.186",
                   "Pocken Vaccine",
                   "Pocken Vaccine",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Poliomyelitis Vaccine 'Berna'.<br>
     */
    POLIOMYELITIS_VACCINE_BERNA("AHI074",
                                "1.2.40.0.34.5.186",
                                "Poliomyelitis Vaccine 'Berna'",
                                "Poliomyelitis Vaccine 'Berna'",
                                "TOTRANSLATE",
                                "TOTRANSLATE",
                                "TOTRANSLATE"),
    /**
     * EN: Polio Sabin (oral) "SB" - Tropfen und Zuckersuspension.<br>
     */
    POLIO_SABIN_ORAL_SB_TROPFEN_UND_ZUCKERSUSPENSION("AHI073",
                                                     "1.2.40.0.34.5.186",
			"Polio Sabin (oral) \"SB\" - Tropfen und Zuckersuspension",
			"Polio Sabin (oral) \"SB\" - Tropfen und Zuckersuspension",
                                                     "TOTRANSLATE",
                                                     "TOTRANSLATE",
                                                     "TOTRANSLATE"),
    /**
     * EN: Preflucel.<br>
     */
    PREFLUCEL("AHI124",
              "1.2.40.0.34.5.186",
              "Preflucel",
              "Preflucel",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Prepandrix.<br>
     */
    PREPANDRIX("AHI132",
               "1.2.40.0.34.5.186",
               "Prepandrix",
               "Prepandrix",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Prevenar (7-valent).<br>
     */
    PREVENAR_7_VALENT("AHI080",
                      "1.2.40.0.34.5.186",
                      "Prevenar (7-valent)",
                      "Prevenar (7-valent)",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Primavax.<br>
     */
    PRIMAVAX("AHI081",
             "1.2.40.0.34.5.186",
             "Primavax",
             "Primavax",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Procomvax.<br>
     */
    PROCOMVAX("AHI082",
              "1.2.40.0.34.5.186",
              "Procomvax",
              "Procomvax",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: ProHIBiT.<br>
     */
    PROHIBIT("AHI084",
             "1.2.40.0.34.5.186",
             "ProHIBiT",
             "ProHIBiT",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Provarivax.<br>
     */
    PROVARIVAX("AHI083",
               "1.2.40.0.34.5.186",
               "Provarivax",
               "Provarivax",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Präpandemischer Impfstoff (H5N1) GSK.<br>
     */
    PR_PANDEMISCHER_IMPFSTOFF_H5N1_GSK("AHI077",
                                       "1.2.40.0.34.5.186",
                                       "Präpandemischer Impfstoff (H5N1) GSK",
                                       "Präpandemischer Impfstoff (H5N1) GSK",
                                       "TOTRANSLATE",
                                       "TOTRANSLATE",
                                       "TOTRANSLATE"),
    /**
     * EN: Präpandemischer Impfstoff (H5N1) Novartis.<br>
     */
    PR_PANDEMISCHER_IMPFSTOFF_H5N1_NOVARTIS("AHI078",
                                            "1.2.40.0.34.5.186",
                                            "Präpandemischer Impfstoff (H5N1) Novartis",
                                            "Präpandemischer Impfstoff (H5N1) Novartis",
                                            "TOTRANSLATE",
                                            "TOTRANSLATE",
                                            "TOTRANSLATE"),
    /**
     * EN: Prévigrip.<br>
     */
    PR_VIGRIP("AHI079",
              "1.2.40.0.34.5.186",
              "Prévigrip",
              "Prévigrip",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Pumarix.<br>
     */
    PUMARIX("AHI085",
            "1.2.40.0.34.5.186",
            "Pumarix",
            "Pumarix",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Quatrovirelon.<br>
     */
    QUATROVIRELON("AHI086",
                  "1.2.40.0.34.5.186",
                  "Quatrovirelon",
                  "Quatrovirelon",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Quintanrix.<br>
     */
    QUINTANRIX("AHI087",
               "1.2.40.0.34.5.186",
               "Quintanrix",
               "Quintanrix",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Quintovirelon.<br>
     */
    QUINTOVIRELON("AHI088",
                  "1.2.40.0.34.5.186",
                  "Quintovirelon",
                  "Quintovirelon",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Rabies Imovax.<br>
     */
    RABIES_IMOVAX("AHI089",
                  "1.2.40.0.34.5.186",
                  "Rabies Imovax",
                  "Rabies Imovax",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Rimevax.<br>
     */
    RIMEVAX("AHI091",
            "1.2.40.0.34.5.186",
            "Rimevax",
            "Rimevax",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Rimparix.<br>
     */
    RIMPARIX("AHI090",
             "1.2.40.0.34.5.186",
             "Rimparix",
             "Rimparix",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: RotaShield.<br>
     */
    ROTASHIELD("AHI094",
               "1.2.40.0.34.5.186",
               "RotaShield",
               "RotaShield",
               "TOTRANSLATE",
               "TOTRANSLATE",
               "TOTRANSLATE"),
    /**
     * EN: Rouvax.<br>
     */
    ROUVAX("AHI092",
           "1.2.40.0.34.5.186",
           "Rouvax",
           "Rouvax",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Rubeaten 'Berna'.<br>
     */
    RUBEATEN_BERNA("AHI096",
                   "1.2.40.0.34.5.186",
                   "Rubeaten 'Berna'",
                   "Rubeaten 'Berna'",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Rudivax.<br>
     */
    RUDIVAX("AHI093",
            "1.2.40.0.34.5.186",
            "Rudivax",
            "Rudivax",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Röteln-Impfstoff HDC Mérieux.<br>
     */
    R_TELN_IMPFSTOFF_HDC_M_RIEUX("AHI095",
                                 "1.2.40.0.34.5.186",
                                 "Röteln-Impfstoff HDC Mérieux",
                                 "Röteln-Impfstoff HDC Mérieux",
                                 "TOTRANSLATE",
                                 "TOTRANSLATE",
                                 "TOTRANSLATE"),
    /**
     * EN: Sandovac.<br>
     */
    SANDOVAC("AHI125",
             "1.2.40.0.34.5.186",
             "Sandovac",
             "Sandovac",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Silgard.<br>
     */
    SILGARD("AHI128",
            "1.2.40.0.34.5.186",
            "Silgard",
            "Silgard",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Spirolept.<br>
     */
    SPIROLEPT("AHI097",
              "1.2.40.0.34.5.186",
              "Spirolept",
              "Spirolept",
              "TOTRANSLATE",
              "TOTRANSLATE",
              "TOTRANSLATE"),
    /**
     * EN: Tanrix.<br>
     */
    TANRIX("AHI098",
           "1.2.40.0.34.5.186",
           "Tanrix",
           "Tanrix",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Td-Rix.<br>
     */
    TD_RIX("AHI102",
           "1.2.40.0.34.5.186",
           "Td-Rix",
           "Td-Rix",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Tetagrip.<br>
     */
    TETAGRIP("AHI103",
             "1.2.40.0.34.5.186",
             "Tetagrip",
             "Tetagrip",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Tetanol.<br>
     */
    TETANOL("AHI100",
            "1.2.40.0.34.5.186",
            "Tetanol",
            "Tetanol",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Tetanus-Adsorbat 'Merieux'.<br>
     */
    TETANUS_ADSORBAT_MERIEUX("AHI101",
                             "1.2.40.0.34.5.186",
                             "Tetanus-Adsorbat 'Merieux'",
                             "Tetanus-Adsorbat 'Merieux'",
                             "TOTRANSLATE",
                             "TOTRANSLATE",
                             "TOTRANSLATE"),
    /**
     * EN: Tetracoq.<br>
     */
    TETRACOQ("AHI104",
             "1.2.40.0.34.5.186",
             "Tetracoq",
             "Tetracoq",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Tetravac.<br>
     */
    TETRAVAC("AHI133",
             "1.2.40.0.34.5.186",
             "Tetravac",
             "Tetravac",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Te-Anatoxal 'Berna'.<br>
     */
    TE_ANATOXAL_BERNA("AHI099",
                      "1.2.40.0.34.5.186",
                      "Te-Anatoxal 'Berna'",
                      "Te-Anatoxal 'Berna'",
                      "TOTRANSLATE",
                      "TOTRANSLATE",
                      "TOTRANSLATE"),
    /**
     * EN: Ticovac.<br>
     */
    TICOVAC("AHI108",
            "1.2.40.0.34.5.186",
            "Ticovac",
            "Ticovac",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE"),
    /**
     * EN: Ticovac junior.<br>
     */
    TICOVAC_JUNIOR("AHI107",
                   "1.2.40.0.34.5.186",
                   "Ticovac junior",
                   "Ticovac junior",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Tollwut Vaccine HDC.<br>
     */
    TOLLWUT_VACCINE_HDC("AHI111",
                        "1.2.40.0.34.5.186",
                        "Tollwut Vaccine HDC",
                        "Tollwut Vaccine HDC",
                        "TOTRANSLATE",
                        "TOTRANSLATE",
                        "TOTRANSLATE"),
    /**
     * EN: Tollwut Vakzine 'Pasteur Merieux'.<br>
     */
    TOLLWUT_VAKZINE_PASTEUR_MERIEUX("AHI109",
                                    "1.2.40.0.34.5.186",
                                    "Tollwut Vakzine 'Pasteur Merieux'",
                                    "Tollwut Vakzine 'Pasteur Merieux'",
                                    "TOTRANSLATE",
                                    "TOTRANSLATE",
                                    "TOTRANSLATE"),
    /**
     * EN: Triacelluvax.<br>
     */
    TRIACELLUVAX("AHI105",
                 "1.2.40.0.34.5.186",
                 "Triacelluvax",
                 "Triacelluvax",
                 "TOTRANSLATE",
                 "TOTRANSLATE",
                 "TOTRANSLATE"),
    /**
     * EN: Triaxis Polio.<br>
     */
    TRIAXIS_POLIO("AHI106",
                  "1.2.40.0.34.5.186",
                  "Triaxis Polio",
                  "Triaxis Polio",
                  "TOTRANSLATE",
                  "TOTRANSLATE",
                  "TOTRANSLATE"),
    /**
     * EN: Tritanrix DTPw.<br>
     */
    TRITANRIX_DTPW("AHI110",
                   "1.2.40.0.34.5.186",
                   "Tritanrix DTPw",
                   "Tritanrix DTPw",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Tritanrix HepB.<br>
     */
    TRITANRIX_HEPB("AHI112",
                   "1.2.40.0.34.5.186",
                   "Tritanrix HepB",
                   "Tritanrix HepB",
                   "TOTRANSLATE",
                   "TOTRANSLATE",
                   "TOTRANSLATE"),
    /**
     * EN: Tyavax.<br>
     */
    TYAVAX("AHI113",
           "1.2.40.0.34.5.186",
           "Tyavax",
           "Tyavax",
           "TOTRANSLATE",
           "TOTRANSLATE",
           "TOTRANSLATE"),
    /**
     * EN: Typherix.<br>
     */
    TYPHERIX("AHI114",
             "1.2.40.0.34.5.186",
             "Typherix",
             "Typherix",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Typhoral.<br>
     */
    TYPHORAL("AHI115",
             "1.2.40.0.34.5.186",
             "Typhoral",
             "Typhoral",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Vaccine Boostrixtetra.<br>
     */
    VACCINE_BOOSTRIXTETRA("AHI120",
                          "1.2.40.0.34.5.186",
                          "Vaccine Boostrixtetra",
                          "Vaccine Boostrixtetra",
                          "TOTRANSLATE",
                          "TOTRANSLATE",
                          "TOTRANSLATE"),
    /**
     * EN: Vaccine Rabique Pasteur.<br>
     */
    VACCINE_RABIQUE_PASTEUR("AHI118",
                            "1.2.40.0.34.5.186",
                            "Vaccine Rabique Pasteur",
                            "Vaccine Rabique Pasteur",
                            "TOTRANSLATE",
                            "TOTRANSLATE",
                            "TOTRANSLATE"),
    /**
     * EN: Vaccine Tétamique Pasteur.<br>
     */
    VACCINE_T_TAMIQUE_PASTEUR("AHI119",
                              "1.2.40.0.34.5.186",
                              "Vaccine Tétamique Pasteur",
                              "Vaccine Tétamique Pasteur",
                              "TOTRANSLATE",
                              "TOTRANSLATE",
                              "TOTRANSLATE"),
    /**
     * EN: Vaccin GenHevac B Pasteur.<br>
     */
    VACCIN_GENHEVAC_B_PASTEUR("AHI117",
                              "1.2.40.0.34.5.186",
                              "Vaccin GenHevac B Pasteur",
                              "Vaccin GenHevac B Pasteur",
                              "TOTRANSLATE",
                              "TOTRANSLATE",
                              "TOTRANSLATE"),
    /**
     * EN: Vaccin Rabique inactivé Mérieux HDCV.<br>
     */
    VACCIN_RABIQUE_INACTIV_M_RIEUX_HDCV("AHI116",
                                        "1.2.40.0.34.5.186",
                                        "Vaccin Rabique inactivé Mérieux HDCV",
                                        "Vaccin Rabique inactivé Mérieux HDCV",
                                        "TOTRANSLATE",
                                        "TOTRANSLATE",
                                        "TOTRANSLATE"),
    /**
     * EN: Varicella Impfstoff SB.<br>
     */
    VARICELLA_IMPFSTOFF_SB("AHI121",
                           "1.2.40.0.34.5.186",
                           "Varicella Impfstoff SB",
                           "Varicella Impfstoff SB",
                           "TOTRANSLATE",
                           "TOTRANSLATE",
                           "TOTRANSLATE"),
    /**
     * EN: Vaxigrip.<br>
     */
    VAXIGRIP("AHI123",
             "1.2.40.0.34.5.186",
             "Vaxigrip",
             "Vaxigrip",
             "TOTRANSLATE",
             "TOTRANSLATE",
             "TOTRANSLATE"),
    /**
     * EN: Vaxigrip junior.<br>
     */
    VAXIGRIP_JUNIOR("AHI122",
                    "1.2.40.0.34.5.186",
                    "Vaxigrip junior",
                    "Vaxigrip junior",
                    "TOTRANSLATE",
                    "TOTRANSLATE",
                    "TOTRANSLATE"),
    /**
     * EN: Vepacel.<br>
     */
    VEPACEL("AHI126",
            "1.2.40.0.34.5.186",
            "Vepacel",
            "Vepacel",
            "TOTRANSLATE",
            "TOTRANSLATE",
            "TOTRANSLATE");

    /**
     * EN: Code for Acel - P Lederle.<br>
     */
    public static final String ACEL_P_LEDERLE_CODE = "AHI001";

    /**
     * EN: Code for Act-HIB+DPT.<br>
     */
    public static final String ACT_HIB_DPT_CODE = "AHI002";

    /**
     * EN: Code for Addigrip.<br>
     */
    public static final String ADDIGRIP_CODE = "AHI003";

    /**
     * EN: Code for Arepanrix.<br>
     */
    public static final String AREPANRIX_CODE = "AHI004";

    /**
     * EN: Code for Arilvax.<br>
     */
    public static final String ARILVAX_CODE = "AHI005";

    /**
     * EN: Code for Avaxim.<br>
     */
    public static final String AVAXIM_CODE = "AHI130";

    /**
     * EN: Code for Batrevac.<br>
     */
    public static final String BATREVAC_CODE = "AHI006";

    /**
     * EN: Code for BCG Vaccine 'Mérieux'.<br>
     */
    public static final String BCG_VACCINE_M_RIEUX_CODE = "AHI007";

    /**
     * EN: Code for Begrivac.<br>
     */
    public static final String BEGRIVAC_CODE = "AHI008";

    /**
     * EN: Code for Celvapan.<br>
     */
    public static final String CELVAPAN_CODE = "AHI009";

    /**
     * EN: Code for Cholera - Impfstoff 'Berna'.<br>
     */
    public static final String CHOLERA_IMPFSTOFF_BERNA_CODE = "AHI010";

    /**
     * EN: Code for Cholera - Vakzine 'Sero'.<br>
     */
    public static final String CHOLERA_VAKZINE_SERO_CODE = "AHI011";

    /**
     * EN: Code for Daronrix.<br>
     */
    public static final String DARONRIX_CODE = "AHI012";

    /**
     * EN: Code for Diftetall.<br>
     */
    public static final String DIFTETALL_CODE = "AHI013";

    /**
     * EN: Code for Diphtherie Adsorbat Impfstoff 'Behring'.<br>
     */
    public static final String DIPHTHERIE_ADSORBAT_IMPFSTOFF_BEHRING_CODE = "AHI014";

    /**
     * EN: Code for Ditanrix.<br>
     */
    public static final String DITANRIX_CODE = "AHI015";

    /**
     * EN: Code for DiTePer Anatoxal Berna.<br>
     */
    public static final String DITEPER_ANATOXAL_BERNA_CODE = "AHI018";

    /**
     * EN: Code for DiTe Anatoxal Berna.<br>
     */
    public static final String DITE_ANATOXAL_BERNA_CODE = "AHI016";

    /**
     * EN: Code for DiTe Anatoxal(dT) Berna.<br>
     */
    public static final String DITE_ANATOXAL_DT_BERNA_CODE = "AHI017";

    /**
     * EN: Code for DPT Adsorbat 'Mérieux'.<br>
     */
    public static final String DPT_ADSORBAT_M_RIEUX_CODE = "AHI020";

    /**
     * EN: Code for DTaP Vakzine SSI.<br>
     */
    public static final String DTAP_VAKZINE_SSI_CODE = "AHI021";

    /**
     * EN: Code for DT Adsorbat 'Mérieux'.<br>
     */
    public static final String DT_ADSORBAT_M_RIEUX_CODE = "AHI019";

    /**
     * EN: Code for D.T.Vax.<br>
     */
    public static final String D_T_VAX_CODE = "AHI022";

    /**
     * EN: Code for Epaxal.<br>
     */
    public static final String EPAXAL_CODE = "AHI023";

    /**
     * EN: Code for Ervevax.<br>
     */
    public static final String ERVEVAX_CODE = "AHI024";

    /**
     * EN: Code for Fluad.<br>
     */
    public static final String FLUAD_CODE = "AHI131";

    /**
     * EN: Code for Fluarix.<br>
     */
    public static final String FLUARIX_CODE = "AHI025";

    /**
     * EN: Code for Fluenz.<br>
     */
    public static final String FLUENZ_CODE = "AHI026";

    /**
     * EN: Code for Fluvaccinol Subunit.<br>
     */
    public static final String FLUVACCINOL_SUBUNIT_CODE = "AHI127";

    /**
     * EN: Code for Fluvirin.<br>
     */
    public static final String FLUVIRIN_CODE = "AHI027";

    /**
     * EN: Code for Focetria.<br>
     */
    public static final String FOCETRIA_CODE = "AHI028";

    /**
     * EN: Code for Gen-HB-vax 10 ug.<br>
     */
    public static final String GEN_HB_VAX_10_UG_CODE = "AHI029";

    /**
     * EN: Code for Havrix 360 E.I.U./ml.<br>
     */
    public static final String HAVRIX_360_E_I_U_ML_CODE = "AHI030";

    /**
     * EN: Code for Hepacare.<br>
     */
    public static final String HEPACARE_CODE = "AHI031";

    /**
     * EN: Code for Hepatyrix.<br>
     */
    public static final String HEPATYRIX_CODE = "AHI032";

    /**
     * EN: Code for Hevac B 'Pasteur'.<br>
     */
    public static final String HEVAC_B_PASTEUR_CODE = "AHI033";

    /**
     * EN: Code for Hexavac.<br>
     */
    public static final String HEXAVAC_CODE = "AHI034";

    /**
     * EN: Code for Hiberix.<br>
     */
    public static final String HIBERIX_CODE = "AHI036";

    /**
     * EN: Code for HIB-Titer.<br>
     */
    public static final String HIB_TITER_CODE = "AHI035";

    /**
     * EN: Code for Humenza.<br>
     */
    public static final String HUMENZA_CODE = "AHI037";

    /**
     * EN: Code for IDflu.<br>
     */
    public static final String IDFLU_CODE = "AHI038";

    /**
     * EN: Code for Immovax Polio.<br>
     */
    public static final String IMMOVAX_POLIO_CODE = "AHI040";

    /**
     * EN: Code for Immugrip.<br>
     */
    public static final String IMMUGRIP_CODE = "AHI039";

    /**
     * EN: Code for Infanrix.<br>
     */
    public static final String INFANRIX_CODE = "AHI041";

    /**
     * EN: Code for Infanrix + HepB.<br>
     */
    public static final String INFANRIX_HEPB_CODE = "AHI044";

    /**
     * EN: Code for Infanrix + HiB.<br>
     */
    public static final String INFANRIX_HIB_CODE = "AHI045";

    /**
     * EN: Code for Infanrix Penta.<br>
     */
    public static final String INFANRIX_PENTA_CODE = "AHI042";

    /**
     * EN: Code for Infanrix Tetra.<br>
     */
    public static final String INFANRIX_TETRA_CODE = "AHI043";

    /**
     * EN: Code for Inflexal V.<br>
     */
    public static final String INFLEXAL_V_CODE = "AHI046";

    /**
     * EN: Code for Intanza.<br>
     */
    public static final String INTANZA_CODE = "AHI047";

    /**
     * EN: Code for Invivac.<br>
     */
    public static final String INVIVAC_CODE = "AHI048";

    /**
     * EN: Code for IPV Mérieux.<br>
     */
    public static final String IPV_M_RIEUX_CODE = "AHI049";

    /**
     * EN: Code for Japan B Encephalitis Vaccine.<br>
     */
    public static final String JAPAN_B_ENCEPHALITIS_VACCINE_CODE = "AHI051";

    /**
     * EN: Code for JE - Vax.<br>
     */
    public static final String JE_VAX_CODE = "AHI050";

    /**
     * EN: Code for Laevactin.<br>
     */
    public static final String LAEVACTIN_CODE = "AHI052";

    /**
     * EN: Code for Masern Vaccine 'Mérieux'.<br>
     */
    public static final String MASERN_VACCINE_M_RIEUX_CODE = "AHI053";

    /**
     * EN: Code for Menactra.<br>
     */
    public static final String MENACTRA_CODE = "AHI059";

    /**
     * EN: Code for Mencevax ACWY.<br>
     */
    public static final String MENCEVAX_ACWY_CODE = "AHI057";

    /**
     * EN: Code for Meningokokken-Impfstoff A+C Mérieux.<br>
     */
    public static final String MENINGOKOKKEN_IMPFSTOFF_A_C_M_RIEUX_CODE = "AHI060";

    /**
     * EN: Code for Meningovax A+C.<br>
     */
    public static final String MENINGOVAX_A_C_CODE = "AHI058";

    /**
     * EN: Code for Meninvact C.<br>
     */
    public static final String MENINVACT_C_CODE = "AHI061";

    /**
     * EN: Code for Menomune ACWY.<br>
     */
    public static final String MENOMUNE_ACWY_CODE = "AHI054";

    /**
     * EN: Code for MMR Triplovax.<br>
     */
    public static final String MMR_TRIPLOVAX_CODE = "AHI056";

    /**
     * EN: Code for Mumps Vaccine 'Merieux'.<br>
     */
    public static final String MUMPS_VACCINE_MERIEUX_CODE = "AHI055";

    /**
     * EN: Code for Mutagrip.<br>
     */
    public static final String MUTAGRIP_CODE = "AHI062";

    /**
     * EN: Code for Optaflu.<br>
     */
    public static final String OPTAFLU_CODE = "AHI063";

    /**
     * EN: Code for Orochol.<br>
     */
    public static final String OROCHOL_CODE = "AHI064";

    /**
     * EN: Code for PAC-Mérieux.<br>
     */
    public static final String PAC_M_RIEUX_CODE = "AHI065";

    /**
     * EN: Code for Pandemrix.<br>
     */
    public static final String PANDEMRIX_CODE = "AHI066";

    /**
     * EN: Code for Pariorix.<br>
     */
    public static final String PARIORIX_CODE = "AHI067";

    /**
     * EN: Code for Pediacel.<br>
     */
    public static final String PEDIACEL_CODE = "AHI068";

    /**
     * EN: Code for Pentavac.<br>
     */
    public static final String PENTAVAC_CODE = "AHI070";

    /**
     * EN: Code for Pent-Act-HiB.<br>
     */
    public static final String PENT_ACT_HIB_CODE = "AHI069";

    /**
     * EN: Code for Pertoral.<br>
     */
    public static final String PERTORAL_CODE = "AHI071";

    /**
     * EN: Code for Pneumo 23 'Merieux'.<br>
     */
    public static final String PNEUMO_23_MERIEUX_CODE = "AHI075";

    /**
     * EN: Code for PNU-Imune.<br>
     */
    public static final String PNU_IMUNE_CODE = "AHI076";

    /**
     * EN: Code for Pocken Vaccine.<br>
     */
    public static final String POCKEN_VACCINE_CODE = "AHI072";

    /**
     * EN: Code for Poliomyelitis Vaccine 'Berna'.<br>
     */
    public static final String POLIOMYELITIS_VACCINE_BERNA_CODE = "AHI074";

    /**
     * EN: Code for Polio Sabin (oral) "SB" - Tropfen und Zuckersuspension.<br>
     */
    public static final String POLIO_SABIN_ORAL_SB_TROPFEN_UND_ZUCKERSUSPENSION_CODE = "AHI073";

    /**
     * EN: Code for Preflucel.<br>
     */
    public static final String PREFLUCEL_CODE = "AHI124";

    /**
     * EN: Code for Prepandrix.<br>
     */
    public static final String PREPANDRIX_CODE = "AHI132";

    /**
     * EN: Code for Prevenar (7-valent).<br>
     */
    public static final String PREVENAR_7_VALENT_CODE = "AHI080";

    /**
     * EN: Code for Primavax.<br>
     */
    public static final String PRIMAVAX_CODE = "AHI081";

    /**
     * EN: Code for Procomvax.<br>
     */
    public static final String PROCOMVAX_CODE = "AHI082";

    /**
     * EN: Code for ProHIBiT.<br>
     */
    public static final String PROHIBIT_CODE = "AHI084";

    /**
     * EN: Code for Provarivax.<br>
     */
    public static final String PROVARIVAX_CODE = "AHI083";

    /**
     * EN: Code for Präpandemischer Impfstoff (H5N1) GSK.<br>
     */
    public static final String PR_PANDEMISCHER_IMPFSTOFF_H5N1_GSK_CODE = "AHI077";

    /**
     * EN: Code for Präpandemischer Impfstoff (H5N1) Novartis.<br>
     */
    public static final String PR_PANDEMISCHER_IMPFSTOFF_H5N1_NOVARTIS_CODE = "AHI078";

    /**
     * EN: Code for Prévigrip.<br>
     */
    public static final String PR_VIGRIP_CODE = "AHI079";

    /**
     * EN: Code for Pumarix.<br>
     */
    public static final String PUMARIX_CODE = "AHI085";

    /**
     * EN: Code for Quatrovirelon.<br>
     */
    public static final String QUATROVIRELON_CODE = "AHI086";

    /**
     * EN: Code for Quintanrix.<br>
     */
    public static final String QUINTANRIX_CODE = "AHI087";

    /**
     * EN: Code for Quintovirelon.<br>
     */
    public static final String QUINTOVIRELON_CODE = "AHI088";

    /**
     * EN: Code for Rabies Imovax.<br>
     */
    public static final String RABIES_IMOVAX_CODE = "AHI089";

    /**
     * EN: Code for Rimevax.<br>
     */
    public static final String RIMEVAX_CODE = "AHI091";

    /**
     * EN: Code for Rimparix.<br>
     */
    public static final String RIMPARIX_CODE = "AHI090";

    /**
     * EN: Code for RotaShield.<br>
     */
    public static final String ROTASHIELD_CODE = "AHI094";

    /**
     * EN: Code for Rouvax.<br>
     */
    public static final String ROUVAX_CODE = "AHI092";

    /**
     * EN: Code for Rubeaten 'Berna'.<br>
     */
    public static final String RUBEATEN_BERNA_CODE = "AHI096";

    /**
     * EN: Code for Rudivax.<br>
     */
    public static final String RUDIVAX_CODE = "AHI093";

    /**
     * EN: Code for Röteln-Impfstoff HDC Mérieux.<br>
     */
    public static final String R_TELN_IMPFSTOFF_HDC_M_RIEUX_CODE = "AHI095";

    /**
     * EN: Code for Sandovac.<br>
     */
    public static final String SANDOVAC_CODE = "AHI125";

    /**
     * EN: Code for Silgard.<br>
     */
    public static final String SILGARD_CODE = "AHI128";

    /**
     * EN: Code for Spirolept.<br>
     */
    public static final String SPIROLEPT_CODE = "AHI097";

    /**
     * EN: Code for Tanrix.<br>
     */
    public static final String TANRIX_CODE = "AHI098";

    /**
     * EN: Code for Td-Rix.<br>
     */
    public static final String TD_RIX_CODE = "AHI102";

    /**
     * EN: Code for Tetagrip.<br>
     */
    public static final String TETAGRIP_CODE = "AHI103";

    /**
     * EN: Code for Tetanol.<br>
     */
    public static final String TETANOL_CODE = "AHI100";

    /**
     * EN: Code for Tetanus-Adsorbat 'Merieux'.<br>
     */
    public static final String TETANUS_ADSORBAT_MERIEUX_CODE = "AHI101";

    /**
     * EN: Code for Tetracoq.<br>
     */
    public static final String TETRACOQ_CODE = "AHI104";

    /**
     * EN: Code for Tetravac.<br>
     */
    public static final String TETRAVAC_CODE = "AHI133";

    /**
     * EN: Code for Te-Anatoxal 'Berna'.<br>
     */
    public static final String TE_ANATOXAL_BERNA_CODE = "AHI099";

    /**
     * EN: Code for Ticovac.<br>
     */
    public static final String TICOVAC_CODE = "AHI108";

    /**
     * EN: Code for Ticovac junior.<br>
     */
    public static final String TICOVAC_JUNIOR_CODE = "AHI107";

    /**
     * EN: Code for Tollwut Vaccine HDC.<br>
     */
    public static final String TOLLWUT_VACCINE_HDC_CODE = "AHI111";

    /**
     * EN: Code for Tollwut Vakzine 'Pasteur Merieux'.<br>
     */
    public static final String TOLLWUT_VAKZINE_PASTEUR_MERIEUX_CODE = "AHI109";

    /**
     * EN: Code for Triacelluvax.<br>
     */
    public static final String TRIACELLUVAX_CODE = "AHI105";

    /**
     * EN: Code for Triaxis Polio.<br>
     */
    public static final String TRIAXIS_POLIO_CODE = "AHI106";

    /**
     * EN: Code for Tritanrix DTPw.<br>
     */
    public static final String TRITANRIX_DTPW_CODE = "AHI110";

    /**
     * EN: Code for Tritanrix HepB.<br>
     */
    public static final String TRITANRIX_HEPB_CODE = "AHI112";

    /**
     * EN: Code for Tyavax.<br>
     */
    public static final String TYAVAX_CODE = "AHI113";

    /**
     * EN: Code for Typherix.<br>
     */
    public static final String TYPHERIX_CODE = "AHI114";

    /**
     * EN: Code for Typhoral.<br>
     */
    public static final String TYPHORAL_CODE = "AHI115";

    /**
     * EN: Code for Vaccine Boostrixtetra.<br>
     */
    public static final String VACCINE_BOOSTRIXTETRA_CODE = "AHI120";

    /**
     * EN: Code for Vaccine Rabique Pasteur.<br>
     */
    public static final String VACCINE_RABIQUE_PASTEUR_CODE = "AHI118";

    /**
     * EN: Code for Vaccine Tétamique Pasteur.<br>
     */
    public static final String VACCINE_T_TAMIQUE_PASTEUR_CODE = "AHI119";

    /**
     * EN: Code for Vaccin GenHevac B Pasteur.<br>
     */
    public static final String VACCIN_GENHEVAC_B_PASTEUR_CODE = "AHI117";

    /**
     * EN: Code for Vaccin Rabique inactivé Mérieux HDCV.<br>
     */
    public static final String VACCIN_RABIQUE_INACTIV_M_RIEUX_HDCV_CODE = "AHI116";

    /**
     * EN: Code for Varicella Impfstoff SB.<br>
     */
    public static final String VARICELLA_IMPFSTOFF_SB_CODE = "AHI121";

    /**
     * EN: Code for Vaxigrip.<br>
     */
    public static final String VAXIGRIP_CODE = "AHI123";

    /**
     * EN: Code for Vaxigrip junior.<br>
     */
    public static final String VAXIGRIP_JUNIOR_CODE = "AHI122";

    /**
     * EN: Code for Vepacel.<br>
     */
    public static final String VEPACEL_CODE = "AHI126";

    /**
     * Identifier of the value set.
     */
    public static final String VALUE_SET_ID = "1.2.40.0.34.6.0.10.10";

    /**
     * Name of the value set.
     */
    public static final String VALUE_SET_NAME = "eImpf_HistorischeImpfstoffe_VS";

    /**
     * Identifier of the code system (all values share the same).
     */
    public static final String CODE_SYSTEM_ID = "1.2.40.0.34.5.186";

    /**
     * Gets the Enum with a given code.
     *
     * @param code The code value.
     * @return the enum value found or {@code null}.
     */
    @Nullable
    public static EImpfHistorischeImpfstoffeVs getEnum(@Nullable final String code) {
        for (final EImpfHistorischeImpfstoffeVs x : values()) {
            if (x.getCodeValue().equals(code)) {
                return x;
            }
        }
        return null;
    }

    /**
     * Checks if a given enum is part of this value set.
     *
     * @param enumName The name of the enum.
     * @return {@code true} if the name is found in this value set, {@code false} otherwise.
     */
    public static boolean isEnumOfValueSet(@Nullable final String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(EImpfHistorischeImpfstoffeVs.class,
                         enumName);
            return true;
        } catch (final IllegalArgumentException ex) {
            return false;
        }
    }

    /**
     * Checks if a given code value is in this value set.
     *
     * @param codeValue The code value.
     * @return {@code true} if the value is found in this value set, {@code false} otherwise.
     */
    public static boolean isInValueSet(@Nullable final String codeValue) {
        for (final EImpfHistorischeImpfstoffeVs x : values()) {
            if (x.getCodeValue().equals(codeValue)) {
                return true;
            }
        }
        return false;
    }

    /**
     * Machine interpretable and (inside this class) unique code.
     */
    @NonNull
    private final String code;

    /**
     * Identifier of the referencing code system.
     */
    @NonNull
    private final String codeSystem;

    /**
     * The display names per language. It's always stored in the given order: default display name (0), in English (1),
     * in German (2), in French (3) and in Italian (4).
     */
    @NonNull
    private final String[] displayNames;

    /**
     * Instantiates this enum with a given code and display names.
     *
     * @param code          The code value.
     * @param codeSystem    The code system (OID).
     * @param displayName   The default display name.
     * @param displayNameEn The display name in English.
     * @param displayNameDe The display name in German.
     * @param displayNameFr The display name in French.
     * @param displayNameIt The display name in Italian.
     */
    EImpfHistorischeImpfstoffeVs(@NonNull final String code, @NonNull final String codeSystem, @NonNull final String displayName, @NonNull final String displayNameEn, @NonNull final String displayNameDe, @NonNull final String displayNameFr, @NonNull final String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    /**
     * Gets the code system identifier.
     *
     * @return the code system identifier.
     */
    @Override
    @NonNull
    public String getCodeSystemId() {
        return this.codeSystem;
    }

    /**
     * Gets the code system name.
     *
     * @return the code system name.
     */
    @Override
    @NonNull
    public String getCodeSystemName() {
        final var codeSystem = CodeSystems.getEnum(this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    /**
     * Gets the code value as a string.
     *
     * @return the code value.
     */
    @Override
    @NonNull
    public String getCodeValue() {
        return this.code;
    }

    /**
     * Gets the display name defined by the language param.
     *
     * @param languageCode The language code to get the display name for, {@code null} to get the default display name.
     * @return the display name in the desired language.
     */
    @Override
    @NonNull
    public String getDisplayName(@Nullable final LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch(languageCode) {
            case ENGLISH ->
                this.displayNames[1];
            case GERMAN ->
                this.displayNames[2];
            case FRENCH ->
                this.displayNames[3];
            case ITALIAN ->
                this.displayNames[4];
            default ->
                "TOTRANSLATE";
        };
    }

    /**
     * Gets the value set identifier.
     *
     * @return the value set identifier.
     */
    @Override
    @NonNull
    public String getValueSetId() {
        return VALUE_SET_ID;
    }

    /**
     * Gets the value set name.
     *
     * @return the value set name.
     */
    @Override
    @NonNull
    public String getValueSetName() {
        return VALUE_SET_NAME;
    }
}
