/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.generated.artdecor.ps;

import java.util.List;
import org.projecthusky.common.hl7cdar2.ANY;
import org.projecthusky.common.hl7cdar2.BL;
import org.projecthusky.common.hl7cdar2.CD;
import org.projecthusky.common.hl7cdar2.CE;
import org.projecthusky.common.hl7cdar2.CS;
import org.projecthusky.common.hl7cdar2.II;
import org.projecthusky.common.hl7cdar2.IVLTS;
import org.projecthusky.common.hl7cdar2.ObjectFactory;
import org.projecthusky.common.hl7cdar2.POCDMT000040Author;
import org.projecthusky.common.hl7cdar2.POCDMT000040EntryRelationship;
import org.projecthusky.common.hl7cdar2.POCDMT000040Informant12;
import org.projecthusky.common.hl7cdar2.POCDMT000040Observation;
import org.projecthusky.common.hl7cdar2.POCDMT000040Reference;
import org.projecthusky.common.hl7cdar2.XActMoodDocumentObservation;
import org.projecthusky.common.hl7cdar2.XActRelationshipEntryRelationship;

public class SchwangerschaftsEntry
extends POCDMT000040Observation {
    public SchwangerschaftsEntry() {
        super.getClassCode().add("OBS");
        super.setMoodCode(XActMoodDocumentObservation.EVN);
        super.getTemplateId().add(SchwangerschaftsEntry.createHl7TemplateIdFixedValue("1.2.40.0.34.11.13.3.10"));
        super.setCode((CD)SchwangerschaftsEntry.createHl7CodeFixedValue("Pregnancy Status", "LOINC", "2.16.840.1.113883.6.1", "11449-6"));
        super.setStatusCode(SchwangerschaftsEntry.createHl7StatusCodeFixedValue("completed", null, null, null));
    }

    public void addHl7Author(POCDMT000040Author value) {
        this.getAuthor().add(value);
    }

    public void addHl7Informant(POCDMT000040Informant12 value) {
        this.getInformant().add(value);
    }

    public void clearHl7Author() {
        this.getAuthor().clear();
    }

    public void clearHl7Informant() {
        this.getInformant().clear();
    }

    private static CE createHl7CodeFixedValue(String displayName, String codeSystemName, String codeSystem, String code) {
        ObjectFactory factory = new ObjectFactory();
        CE retVal = factory.createCE();
        retVal.setDisplayName(displayName);
        retVal.setCodeSystemName(codeSystemName);
        retVal.setCodeSystem(codeSystem);
        retVal.setCode(code);
        return retVal;
    }

    private static POCDMT000040EntryRelationship createHl7EntryRelationshipFixedValue(String typeCode, String inversionInd) {
        ObjectFactory factory = new ObjectFactory();
        POCDMT000040EntryRelationship retVal = factory.createPOCDMT000040EntryRelationship();
        retVal.setTypeCode(XActRelationshipEntryRelationship.fromValue((String)typeCode));
        if (inversionInd != null) {
            retVal.setInversionInd(Boolean.valueOf(Boolean.parseBoolean(inversionInd)));
        }
        return retVal;
    }

    private static CS createHl7StatusCodeFixedValue(String code, String codeSystem, String codeSystemName, String displayName) {
        ObjectFactory factory = new ObjectFactory();
        CS retVal = factory.createCS();
        retVal.setCode(code);
        retVal.setCodeSystem(codeSystem);
        retVal.setCodeSystemName(codeSystemName);
        retVal.setDisplayName(displayName);
        return retVal;
    }

    private static II createHl7TemplateIdFixedValue(String root) {
        ObjectFactory factory = new ObjectFactory();
        II retVal = factory.createII();
        retVal.setRoot(root);
        return retVal;
    }

    public CE getHl7Code() {
        return (CE)this.code;
    }

    public IVLTS getHl7EffectiveTime() {
        return this.effectiveTime;
    }

    public List<POCDMT000040EntryRelationship> getHl7EntryRelationship() {
        return this.entryRelationship;
    }

    public List<POCDMT000040Reference> getHl7Reference() {
        return this.reference;
    }

    public CS getHl7StatusCode() {
        return this.statusCode;
    }

    public List<II> getHl7TemplateId() {
        return this.templateId;
    }

    public List<ANY> getHl7Value() {
        return this.value;
    }

    public static POCDMT000040EntryRelationship getPredefinedEntryRelationshipCompNull() {
        return SchwangerschaftsEntry.createHl7EntryRelationshipFixedValue("COMP", null);
    }

    public void setHl7Code(CE value) {
        this.code = value;
    }

    public void setHl7EffectiveTime(IVLTS value) {
        this.effectiveTime = value;
    }

    public void setHl7EntryRelationship(POCDMT000040EntryRelationship value) {
        this.getEntryRelationship().clear();
        this.getEntryRelationship().add(value);
    }

    public void setHl7Reference(POCDMT000040Reference value) {
        this.getReference().clear();
        this.getReference().add(value);
    }

    public void setHl7StatusCode(CS value) {
        this.statusCode = value;
    }

    public void setHl7TemplateId(II value) {
        this.getTemplateId().clear();
        this.getTemplateId().add(value);
    }

    public void setHl7Value(BL value) {
        this.getValue().clear();
        this.getValue().add(value);
    }
}

