/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.cda.elga.generated.artdecor.ps.enums;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

public enum ElgaProblemarten implements ValueSetEnumInterface
{
    COMPLAINT("409586006", "2.16.840.1.113883.6.96", "Complaint", "Complaint", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    CONDITION("64572001", "2.16.840.1.113883.6.96", "Condition", "Condition", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    DIAGNOSIS("282291009", "2.16.840.1.113883.6.96", "Diagnosis", "Diagnosis", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    FINDING("404684003", "2.16.840.1.113883.6.96", "Finding", "Finding", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    FUNCTIONAL_LIMITATION("248536006", "2.16.840.1.113883.6.96", "Functional limitation", "Functional limitation", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    NO_CURRENT_PROBLEMS_OR_DISABILITY("160245001", "2.16.840.1.113883.6.96", "no current problems or disability", "no current problems or disability", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    PROBLEM("55607006", "2.16.840.1.113883.6.96", "Problem", "Problem", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    SYMPTOM("418799008", "2.16.840.1.113883.6.96", "Symptom", "Symptom", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE");

    public static final String COMPLAINT_CODE = "409586006";
    public static final String CONDITION_CODE = "64572001";
    public static final String DIAGNOSIS_CODE = "282291009";
    public static final String FINDING_CODE = "404684003";
    public static final String FUNCTIONAL_LIMITATION_CODE = "248536006";
    public static final String NO_CURRENT_PROBLEMS_OR_DISABILITY_CODE = "160245001";
    public static final String PROBLEM_CODE = "55607006";
    public static final String SYMPTOM_CODE = "418799008";
    public static final String VALUE_SET_ID = "1.2.40.0.34.10.35";
    public static final String VALUE_SET_NAME = "ELGA_Problemarten";
    public static final String CODE_SYSTEM_ID = "2.16.840.1.113883.6.96";
    private final @NonNull String code;
    private final @NonNull String codeSystem;
    private final @NonNull String[] displayNames;

    public static @Nullable ElgaProblemarten getEnum(@Nullable String code) {
        for (ElgaProblemarten x : ElgaProblemarten.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(@Nullable String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(ElgaProblemarten.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(@Nullable String codeValue) {
        for (ElgaProblemarten x : ElgaProblemarten.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private ElgaProblemarten(@NonNull String code, @NonNull String codeSystem, @NonNull String displayName, @NonNull String displayNameEn, @NonNull String displayNameDe, String displayNameFr, String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    public @NonNull String getCodeSystemId() {
        return this.codeSystem;
    }

    public @NonNull String getCodeSystemName() {
        CodeSystems codeSystem = CodeSystems.getEnum((String)this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    public @NonNull String getCodeValue() {
        return this.code;
    }

    public @NonNull String getDisplayName(@Nullable LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch (languageCode) {
            case LanguageCode.ENGLISH -> this.displayNames[1];
            case LanguageCode.GERMAN -> this.displayNames[2];
            case LanguageCode.FRENCH -> this.displayNames[3];
            case LanguageCode.ITALIAN -> this.displayNames[4];
            default -> "TOTRANSLATE";
        };
    }

    public @NonNull String getValueSetId() {
        return VALUE_SET_ID;
    }

    public @NonNull String getValueSetName() {
        return VALUE_SET_NAME;
    }
}

